# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MagicYaraResponseData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'rule': 'str',
        'name': 'str',
        'magic_yara_id': 'str',
        'magic_criteria_id': 'str',
        'cluster_size': 'int',
        'creation_date': 'str',
        'query_binaries_used': 'list[str]',
        'query_binaries_filtered': 'list[str]'
    }

    attribute_map = {
        'rule': 'rule',
        'name': 'name',
        'magic_yara_id': 'magic_yara_id',
        'magic_criteria_id': 'magic_criteria_id',
        'cluster_size': 'cluster_size',
        'creation_date': 'creation_date',
        'query_binaries_used': 'query_binaries_used',
        'query_binaries_filtered': 'query_binaries_filtered'
    }

    def __init__(self, rule=None, name=None, magic_yara_id=None, magic_criteria_id=None, cluster_size=None, creation_date=None, query_binaries_used=None, query_binaries_filtered=None):  # noqa: E501
        """MagicYaraResponseData - a model defined in Swagger"""  # noqa: E501

        self._rule = None
        self._name = None
        self._magic_yara_id = None
        self._magic_criteria_id = None
        self._cluster_size = None
        self._creation_date = None
        self._query_binaries_used = None
        self._query_binaries_filtered = None
        self.discriminator = None

        if rule is not None:
            self.rule = rule
        if name is not None:
            self.name = name
        if magic_yara_id is not None:
            self.magic_yara_id = magic_yara_id
        if magic_criteria_id is not None:
            self.magic_criteria_id = magic_criteria_id
        if cluster_size is not None:
            self.cluster_size = cluster_size
        if creation_date is not None:
            self.creation_date = creation_date
        if query_binaries_used is not None:
            self.query_binaries_used = query_binaries_used
        if query_binaries_filtered is not None:
            self.query_binaries_filtered = query_binaries_filtered

    @property
    def rule(self):
        """Gets the rule of this MagicYaraResponseData.  # noqa: E501

        The actual yara rule itself  # noqa: E501

        :return: The rule of this MagicYaraResponseData.  # noqa: E501
        :rtype: str
        """
        return self._rule

    @rule.setter
    def rule(self, rule):
        """Sets the rule of this MagicYaraResponseData.

        The actual yara rule itself  # noqa: E501

        :param rule: The rule of this MagicYaraResponseData.  # noqa: E501
        :type: str
        """

        self._rule = rule

    @property
    def name(self):
        """Gets the name of this MagicYaraResponseData.  # noqa: E501

        The name of the yara rule  # noqa: E501

        :return: The name of this MagicYaraResponseData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this MagicYaraResponseData.

        The name of the yara rule  # noqa: E501

        :param name: The name of this MagicYaraResponseData.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def magic_yara_id(self):
        """Gets the magic_yara_id of this MagicYaraResponseData.  # noqa: E501

        An md5 cryptographic hash representing the procedures used to create the rule  # noqa: E501

        :return: The magic_yara_id of this MagicYaraResponseData.  # noqa: E501
        :rtype: str
        """
        return self._magic_yara_id

    @magic_yara_id.setter
    def magic_yara_id(self, magic_yara_id):
        """Sets the magic_yara_id of this MagicYaraResponseData.

        An md5 cryptographic hash representing the procedures used to create the rule  # noqa: E501

        :param magic_yara_id: The magic_yara_id of this MagicYaraResponseData.  # noqa: E501
        :type: str
        """
        if magic_yara_id is not None and not re.search(r'[a-fA-F0-9]{32}', magic_yara_id):  # noqa: E501
            raise ValueError(r"Invalid value for `magic_yara_id`, must be a follow pattern or equal to `/[a-fA-F0-9]{32}/`")  # noqa: E501

        self._magic_yara_id = magic_yara_id

    @property
    def magic_criteria_id(self):
        """Gets the magic_criteria_id of this MagicYaraResponseData.  # noqa: E501

        An md5 cryptographic hash representing the criteria used to determine included procedures  # noqa: E501

        :return: The magic_criteria_id of this MagicYaraResponseData.  # noqa: E501
        :rtype: str
        """
        return self._magic_criteria_id

    @magic_criteria_id.setter
    def magic_criteria_id(self, magic_criteria_id):
        """Sets the magic_criteria_id of this MagicYaraResponseData.

        An md5 cryptographic hash representing the criteria used to determine included procedures  # noqa: E501

        :param magic_criteria_id: The magic_criteria_id of this MagicYaraResponseData.  # noqa: E501
        :type: str
        """
        if magic_criteria_id is not None and not re.search(r'[a-fA-F0-9]{32}', magic_criteria_id):  # noqa: E501
            raise ValueError(r"Invalid value for `magic_criteria_id`, must be a follow pattern or equal to `/[a-fA-F0-9]{32}/`")  # noqa: E501

        self._magic_criteria_id = magic_criteria_id

    @property
    def cluster_size(self):
        """Gets the cluster_size of this MagicYaraResponseData.  # noqa: E501

        The number of binaries used to generate the rule  # noqa: E501

        :return: The cluster_size of this MagicYaraResponseData.  # noqa: E501
        :rtype: int
        """
        return self._cluster_size

    @cluster_size.setter
    def cluster_size(self, cluster_size):
        """Sets the cluster_size of this MagicYaraResponseData.

        The number of binaries used to generate the rule  # noqa: E501

        :param cluster_size: The cluster_size of this MagicYaraResponseData.  # noqa: E501
        :type: int
        """

        self._cluster_size = cluster_size

    @property
    def creation_date(self):
        """Gets the creation_date of this MagicYaraResponseData.  # noqa: E501

        The date the rule was generated  # noqa: E501

        :return: The creation_date of this MagicYaraResponseData.  # noqa: E501
        :rtype: str
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this MagicYaraResponseData.

        The date the rule was generated  # noqa: E501

        :param creation_date: The creation_date of this MagicYaraResponseData.  # noqa: E501
        :type: str
        """

        self._creation_date = creation_date

    @property
    def query_binaries_used(self):
        """Gets the query_binaries_used of this MagicYaraResponseData.  # noqa: E501


        :return: The query_binaries_used of this MagicYaraResponseData.  # noqa: E501
        :rtype: list[str]
        """
        return self._query_binaries_used

    @query_binaries_used.setter
    def query_binaries_used(self, query_binaries_used):
        """Sets the query_binaries_used of this MagicYaraResponseData.


        :param query_binaries_used: The query_binaries_used of this MagicYaraResponseData.  # noqa: E501
        :type: list[str]
        """

        self._query_binaries_used = query_binaries_used

    @property
    def query_binaries_filtered(self):
        """Gets the query_binaries_filtered of this MagicYaraResponseData.  # noqa: E501


        :return: The query_binaries_filtered of this MagicYaraResponseData.  # noqa: E501
        :rtype: list[str]
        """
        return self._query_binaries_filtered

    @query_binaries_filtered.setter
    def query_binaries_filtered(self, query_binaries_filtered):
        """Sets the query_binaries_filtered of this MagicYaraResponseData.


        :param query_binaries_filtered: The query_binaries_filtered of this MagicYaraResponseData.  # noqa: E501
        :type: list[str]
        """

        self._query_binaries_filtered = query_binaries_filtered

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MagicYaraResponseData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MagicYaraResponseData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
