# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from typing import Any, Dict, Optional

from stytch.core.api_base import ApiBase
from stytch.core.http.client import AsyncClient, SyncClient
from stytch.models.oauth import AttachResponse, AuthenticateResponse


class OAuth:
    def __init__(
        self,
        api_base: ApiBase,
        sync_client: SyncClient,
        async_client: AsyncClient,
    ) -> None:
        self.api_base = api_base
        self.sync_client = sync_client
        self.async_client = async_client

    @property
    def sub_url(self) -> str:
        return "oauth"

    def authenticate(
        self,
        token: str,
        session_token: Optional[str] = None,
        session_jwt: Optional[str] = None,
        session_duration_minutes: Optional[int] = None,
        session_custom_claims: Optional[Dict[str, Any]] = None,
        code_verifier: Optional[str] = None,
    ) -> AuthenticateResponse:
        """[Stytch docs](https://stytch.com/docs/api/oauth-authenticate)

        Authenticate a user given a token. This endpoint verifies that the user completed the OAuth flow by verifying that the token is valid and hasn't expired. To initiate a Stytch session for the user while authenticating their OAuth token, include `session_duration_minutes`; a session with the identity provider, e.g. Google or Facebook, will always be initiated upon successful authentication.

        Parameters:

        - `token`: The token to authenticate.

        - `session_custom_claims`: Add a custom claims map to the session being authenticated. Claims are only created if a session is initialized by providing a value in `session duration minutes`. Claims will be included on the session object and in the JWT. To update a key in an existing session, supply a new value. To delete a key, supply a null value

          Custom claims made with reserved claims ("iss", "sub", "aud", "exp", "nbf", "iat", "jti") will be ignored. Total custom claims size cannot exceed four kilobytes

        - `session_duration_minutes`: (Stytch sessions only) Set the session lifetime to be this many minutes from now. This will start a new session if one doesn't already exist, returning both an opaque `session_token` and `session_jwt` for this session. Remember that `session_jwt` will have a fixed lifetime of five minutes regardless of the underlying session duration, and will need to be refreshed over time.

          This argument only sets the lifetime for Stytch sessions, not for IdP sessions. This value must be a minimum of 5 and a maximum of 129600 minutes (90 days).

          If a session_token or `session_jwt` is provided then a successful authentication will continue to extend the session this many minutes.

          If the `session_duration_minutes` parameter is not specified, a Stytch session will not be created.

        - `session_jwt`: (Stytch sessions only) Reuse an existing session instead of creating a new one. If you provide us with a `session_jwt`, then we'll update the session represented by this JWT with this OAuth factor. If this `session_jwt` belongs to a different user than the OAuth token, the `session_jwt` will be ignored. This endpoint will error if both session_token and `session_jwt` are provided.

        - `session_token`: (Stytch sessions only) Reuse an existing session instead of creating a new one. If you provide us with a `session_token`, then we'll update the session represented by this session token with this OAuth factor. If this `session_token` belongs to a different user than the OAuth token, the `session_token` will be ignored. This endpoint will error if both `session_token` and `session_jwt` are provided.

        - `code_verifier`: A base64url encoded one time secret used to validate that the request starts and ends on the same device. See the [PKCE OAuth guide](https://stytch.com/docs/oauth#guides_pkce) for usage instructions.
        """  # noqa

        payload: Dict[str, Any] = {
            "token": token,
        }

        if session_token is not None:
            payload["session_token"] = session_token
        if session_jwt is not None:
            payload["session_jwt"] = session_jwt
        if session_duration_minutes is not None:
            payload["session_duration_minutes"] = session_duration_minutes
        if session_custom_claims is not None:
            payload["session_custom_claims"] = session_custom_claims
        if code_verifier is not None:
            payload["code_verifier"] = code_verifier

        url = self.api_base.route_with_sub_url(self.sub_url, "authenticate")

        res = self.sync_client.post(url, json=payload)
        return AuthenticateResponse.from_json(res.response.status_code, res.json)

    async def authenticate_async(
        self,
        token: str,
        session_token: Optional[str] = None,
        session_jwt: Optional[str] = None,
        session_duration_minutes: Optional[int] = None,
        session_custom_claims: Optional[Dict[str, Any]] = None,
        code_verifier: Optional[str] = None,
    ) -> AuthenticateResponse:
        """[Stytch docs](https://stytch.com/docs/api/oauth-authenticate)

        Authenticate a user given a token. This endpoint verifies that the user completed the OAuth flow by verifying that the token is valid and hasn't expired. To initiate a Stytch session for the user while authenticating their OAuth token, include `session_duration_minutes`; a session with the identity provider, e.g. Google or Facebook, will always be initiated upon successful authentication.

        Parameters:

        - `token`: The token to authenticate.

        - `session_custom_claims`: Add a custom claims map to the session being authenticated. Claims are only created if a session is initialized by providing a value in `session duration minutes`. Claims will be included on the session object and in the JWT. To update a key in an existing session, supply a new value. To delete a key, supply a null value

          Custom claims made with reserved claims ("iss", "sub", "aud", "exp", "nbf", "iat", "jti") will be ignored. Total custom claims size cannot exceed four kilobytes

        - `session_duration_minutes`: (Stytch sessions only) Set the session lifetime to be this many minutes from now. This will start a new session if one doesn't already exist, returning both an opaque `session_token` and `session_jwt` for this session. Remember that `session_jwt` will have a fixed lifetime of five minutes regardless of the underlying session duration, and will need to be refreshed over time.

          This argument only sets the lifetime for Stytch sessions, not for IdP sessions. This value must be a minimum of 5 and a maximum of 129600 minutes (90 days).

          If a session_token or `session_jwt` is provided then a successful authentication will continue to extend the session this many minutes.

          If the `session_duration_minutes` parameter is not specified, a Stytch session will not be created.

        - `session_jwt`: (Stytch sessions only) Reuse an existing session instead of creating a new one. If you provide us with a `session_jwt`, then we'll update the session represented by this JWT with this OAuth factor. If this `session_jwt` belongs to a different user than the OAuth token, the `session_jwt` will be ignored. This endpoint will error if both session_token and `session_jwt` are provided.

        - `session_token`: (Stytch sessions only) Reuse an existing session instead of creating a new one. If you provide us with a `session_token`, then we'll update the session represented by this session token with this OAuth factor. If this `session_token` belongs to a different user than the OAuth token, the `session_token` will be ignored. This endpoint will error if both `session_token` and `session_jwt` are provided.

        - `code_verifier`: A base64url encoded one time secret used to validate that the request starts and ends on the same device. See the [PKCE OAuth guide](https://stytch.com/docs/oauth#guides_pkce) for usage instructions.
        """  # noqa

        payload: Dict[str, Any] = {
            "token": token,
        }

        if session_token is not None:
            payload["session_token"] = session_token
        if session_jwt is not None:
            payload["session_jwt"] = session_jwt
        if session_duration_minutes is not None:
            payload["session_duration_minutes"] = session_duration_minutes
        if session_custom_claims is not None:
            payload["session_custom_claims"] = session_custom_claims
        if code_verifier is not None:
            payload["code_verifier"] = code_verifier

        url = self.api_base.route_with_sub_url(self.sub_url, "authenticate")

        res = await self.async_client.post(url, json=payload)
        return AuthenticateResponse.from_json(res.response.status, res.json)

    def attach(
        self,
        provider: str,
        user_id: Optional[str] = None,
        session_token: Optional[str] = None,
        session_jwt: Optional[str] = None,
    ) -> AttachResponse:
        """[Stytch docs](https://stytch.com/docs/api/oauth-overview)"""  # noqa

        payload: Dict[str, Any] = {
            "provider": provider,
        }

        if user_id is not None:
            payload["user_id"] = user_id
        if session_token is not None:
            payload["session_token"] = session_token
        if session_jwt is not None:
            payload["session_jwt"] = session_jwt

        url = self.api_base.route_with_sub_url(self.sub_url, "attach")

        res = self.sync_client.post(url, json=payload)
        return AttachResponse.from_json(res.response.status_code, res.json)

    async def attach_async(
        self,
        provider: str,
        user_id: Optional[str] = None,
        session_token: Optional[str] = None,
        session_jwt: Optional[str] = None,
    ) -> AttachResponse:
        """[Stytch docs](https://stytch.com/docs/api/oauth-overview)"""  # noqa

        payload: Dict[str, Any] = {
            "provider": provider,
        }

        if user_id is not None:
            payload["user_id"] = user_id
        if session_token is not None:
            payload["session_token"] = session_token
        if session_jwt is not None:
            payload["session_jwt"] = session_jwt

        url = self.api_base.route_with_sub_url(self.sub_url, "attach")

        res = await self.async_client.post(url, json=payload)
        return AttachResponse.from_json(res.response.status, res.json)
