"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsSubscription = void 0;
const sns = require("@aws-cdk/aws-sns");
/**
 * Use an sms address as a subscription target.
 *
 * @stability stable
 */
class SmsSubscription {
    /**
     * @stability stable
     */
    constructor(phoneNumber, props = {}) {
        this.phoneNumber = phoneNumber;
        this.props = props;
    }
    /**
     * Returns a configuration used to subscribe to an SNS topic.
     *
     * @stability stable
     */
    bind(_topic) {
        return {
            subscriberId: this.phoneNumber,
            endpoint: this.phoneNumber,
            protocol: sns.SubscriptionProtocol.SMS,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.SmsSubscription = SmsSubscription;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic21zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic21zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3Qzs7Ozs7O0FBWXhDLE1BQWEsZUFBZTs7OztJQUMxQixZQUE2QixXQUFtQixFQUFtQixRQUE4QixFQUFFO1FBQXRFLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQTJCO0lBQ25HLENBQUM7Ozs7OztJQUVNLElBQUksQ0FBQyxNQUFrQjtRQUM1QixPQUFPO1lBQ0wsWUFBWSxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzlCLFFBQVEsRUFBRSxJQUFJLENBQUMsV0FBVztZQUMxQixRQUFRLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLEdBQUc7WUFDdEMsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWTtTQUN0QyxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBWkQsMENBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5pbXBvcnQgeyBTdWJzY3JpcHRpb25Qcm9wcyB9IGZyb20gJy4vc3Vic2NyaXB0aW9uJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU21zU3Vic2NyaXB0aW9uUHJvcHMgZXh0ZW5kcyBTdWJzY3JpcHRpb25Qcm9wcyB7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNtc1N1YnNjcmlwdGlvbiBpbXBsZW1lbnRzIHNucy5JVG9waWNTdWJzY3JpcHRpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHBob25lTnVtYmVyOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFNtc1N1YnNjcmlwdGlvblByb3BzID0ge30pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF90b3BpYzogc25zLklUb3BpYyk6IHNucy5Ub3BpY1N1YnNjcmlwdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHN1YnNjcmliZXJJZDogdGhpcy5waG9uZU51bWJlcixcbiAgICAgIGVuZHBvaW50OiB0aGlzLnBob25lTnVtYmVyLFxuICAgICAgcHJvdG9jb2w6IHNucy5TdWJzY3JpcHRpb25Qcm90b2NvbC5TTVMsXG4gICAgICBmaWx0ZXJQb2xpY3k6IHRoaXMucHJvcHMuZmlsdGVyUG9saWN5LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==