# -*- coding: utf-8 -*-
import copy
import numpy as np
import fractalshades.colors as fscolors
import fractalshades.utils as fsutils


##: A colormap circling through black, blue, white, orange, black
cmap_legacy = fscolors.Fractal_colormap(
    colors=[[0.00784314, 0.01960784, 0.14509804],
            [0.17647059, 0.10980392, 0.10588235],
            [0.48627451, 0.24313725, 0.07058824],
            [0.63921569, 0.39607843, 0.17647059],
            [0.81176471, 0.58039216, 0.33333333],
            [0.97647059, 0.85490196, 0.64313725],
            [0.96470588, 0.98823529, 0.90196078],
            [0.48627451, 0.7254902 , 0.90980392],
            [0.27843137, 0.51764706, 0.74901961],
            [0.12156863, 0.32941176, 0.57254902],
            [0.07058824, 0.25490196, 0.49411765],
            [0.00784314, 0.01960784, 0.14509804]],
    kinds=['Lab', 'Lch', 'Lch', 'Lch', 'Lab', 'Lab', 'Lab', 'Lch', 'Lch', 'Lch', 'Lab'],
    grad_npts=[32, 32, 32, 32,  32,  32,  32,  32,  32,  32,  32,  32],
    grad_funcs=['x', 'x', 'x', 'x', 'x', 'x', 'x', 'x', 'x', 'x', 'x'],
    extent='mirror'
) 

def Pchipinterpolate_rgb(rgb_arr, pos_arr, npts=256):
    """ Utility function used to build a cmap. It needs scipy but should
    not be necessary to the end-used """
    from scipy.interpolate import PchipInterpolator
    res = np.empty([npts, 3], dtype=np.float64)
    lin_scale = np.linspace(0., 1., num=npts, dtype=np.float64)
    for ic in range(3):
        channel_y = rgb_arr[:, ic]
        interp = PchipInterpolator(pos_arr, channel_y)
        res[:, ic] = interp(lin_scale)
    return res

def create_UF_cmap():
    """
    Utility function to create a cmap
    classic_colormap = create_UF_cmap()
    """
    pos_arr = np.array([0., 0.16, 0.42, 0.6425, 0.8575, 1.], dtype=np.float64)
    rgb_arr = np.array([
        [   0.,   7., 100.],
        [  32., 107., 203.],
        [ 237., 255., 255.],
        [ 255., 170.,   0.],
        [   0.,   2.,   0.],
        [   0.,   7., 100.]
    ]) / 255.
    res_rgb = Pchipinterpolate_rgb(rgb_arr, pos_arr)
    cmap = fscolors.Fractal_colormap(
        colors=res_rgb,
        kinds="Lch",
        grad_npts=3,
        grad_funcs='x',
        extent='mirror'
    )
    return cmap

cmap_classic = fscolors.Fractal_colormap(
    colors=[[0.00000000e+00, 2.74509804e-02, 3.92156863e-01],
     [1.10437384e-04, 3.73834922e-02, 4.04650357e-01],
     [4.38226764e-04, 4.73039863e-02, 4.17125524e-01],
     [9.78083979e-04, 5.72121456e-02, 4.29573705e-01],
     [1.72472487e-03, 6.71076526e-02, 4.41986240e-01],
     [2.67286527e-03, 7.69901900e-02, 4.54354469e-01],
     [3.81722103e-03, 8.68594405e-02, 4.66669733e-01],
     [5.15250798e-03, 9.67150866e-02, 4.78923371e-01],
     [6.67344196e-03, 1.06556811e-01, 4.91106726e-01],
     [8.37473881e-03, 1.16384297e-01, 5.03211136e-01],
     [1.02511144e-02, 1.26197226e-01, 5.15227942e-01],
     [1.22972845e-02, 1.35995282e-01, 5.27148486e-01],
     [1.45079650e-02, 1.45778147e-01, 5.38964106e-01],
     [1.68778717e-02, 1.55545503e-01, 5.50666144e-01],
     [1.94017206e-02, 1.65297034e-01, 5.62245939e-01],
     [2.20742273e-02, 1.75032422e-01, 5.73694833e-01],
     [2.48901077e-02, 1.84751350e-01, 5.85004166e-01],
     [2.78440778e-02, 1.94453500e-01, 5.96165278e-01],
     [3.09308533e-02, 2.04138555e-01, 6.07169509e-01],
     [3.41451500e-02, 2.13806197e-01, 6.18008200e-01],
     [3.74816839e-02, 2.23456110e-01, 6.28672691e-01],
     [4.09351707e-02, 2.33087977e-01, 6.39154323e-01],
     [4.45003263e-02, 2.42701478e-01, 6.49444436e-01],
     [4.81718665e-02, 2.52296298e-01, 6.59534371e-01],
     [5.19445072e-02, 2.61872119e-01, 6.69415467e-01],
     [5.58129642e-02, 2.71428624e-01, 6.79079066e-01],
     [5.97719533e-02, 2.80965495e-01, 6.88516507e-01],
     [6.38161904e-02, 2.90482415e-01, 6.97719131e-01],
     [6.79403913e-02, 2.99979067e-01, 7.06678279e-01],
     [7.21392719e-02, 3.09455133e-01, 7.15385291e-01],
     [7.64075480e-02, 3.18910296e-01, 7.23831507e-01],
     [8.07399355e-02, 3.28344239e-01, 7.32008267e-01],
     [8.51311501e-02, 3.37756644e-01, 7.39906913e-01],
     [8.95759078e-02, 3.47147194e-01, 7.47518784e-01],
     [9.40689243e-02, 3.56515572e-01, 7.54835221e-01],
     [9.86049155e-02, 3.65861460e-01, 7.61847564e-01],
     [1.03178597e-01, 3.75184541e-01, 7.68547154e-01],
     [1.07784685e-01, 3.84484498e-01, 7.74925331e-01],
     [1.12417896e-01, 3.93761012e-01, 7.80973436e-01],
     [1.17072944e-01, 4.03013768e-01, 7.86682808e-01],
     [1.21744546e-01, 4.12242448e-01, 7.92044788e-01],
     [1.26442213e-01, 4.21451959e-01, 7.97057643e-01],
     [1.31644451e-01, 4.30811773e-01, 8.01942937e-01],
     [1.37566242e-01, 4.40395326e-01, 8.06809033e-01],
     [1.44183896e-01, 4.50191275e-01, 8.11654219e-01],
     [1.51473724e-01, 4.60188274e-01, 8.16476784e-01],
     [1.59412036e-01, 4.70374980e-01, 8.21275017e-01],
     [1.67975141e-01, 4.80740047e-01, 8.26047207e-01],
     [1.77139351e-01, 4.91272131e-01, 8.30791641e-01],
     [1.86880974e-01, 5.01959888e-01, 8.35506611e-01],
     [1.97176323e-01, 5.12791973e-01, 8.40190402e-01],
     [2.08001706e-01, 5.23757041e-01, 8.44841306e-01],
     [2.19333434e-01, 5.34843749e-01, 8.49457610e-01],
     [2.31147817e-01, 5.46040752e-01, 8.54037602e-01],
     [2.43421166e-01, 5.57336705e-01, 8.58579573e-01],
     [2.56129790e-01, 5.68720263e-01, 8.63081810e-01],
     [2.69250000e-01, 5.80180083e-01, 8.67542602e-01],
     [2.82758106e-01, 5.91704820e-01, 8.71960239e-01],
     [2.96630418e-01, 6.03283129e-01, 8.76333008e-01],
     [3.10843247e-01, 6.14903666e-01, 8.80659199e-01],
     [3.25372903e-01, 6.26555086e-01, 8.84937100e-01],
     [3.40195695e-01, 6.38226045e-01, 8.89165000e-01],
     [3.55287934e-01, 6.49905198e-01, 8.93341187e-01],
     [3.70625931e-01, 6.61581201e-01, 8.97463951e-01],
     [3.86185996e-01, 6.73242710e-01, 9.01531580e-01],
     [4.01944438e-01, 6.84878379e-01, 9.05542364e-01],
     [4.17877568e-01, 6.96476865e-01, 9.09494590e-01],
     [4.33961696e-01, 7.08026823e-01, 9.13386547e-01],
     [4.50173133e-01, 7.19516908e-01, 9.17216524e-01],
     [4.66488189e-01, 7.30935776e-01, 9.20982811e-01],
     [4.82883173e-01, 7.42272083e-01, 9.24683695e-01],
     [4.99334396e-01, 7.53514484e-01, 9.28317465e-01],
     [5.15818169e-01, 7.64651634e-01, 9.31882411e-01],
     [5.32310801e-01, 7.75672189e-01, 9.35376820e-01],
     [5.48788603e-01, 7.86564805e-01, 9.38798982e-01],
     [5.65227885e-01, 7.97318137e-01, 9.42147185e-01],
     [5.81604957e-01, 8.07920840e-01, 9.45419719e-01],
     [5.97896129e-01, 8.18361570e-01, 9.48614871e-01],
     [6.14077712e-01, 8.28628983e-01, 9.51730931e-01],
     [6.30126016e-01, 8.38711735e-01, 9.54766187e-01],
     [6.46017351e-01, 8.48598479e-01, 9.57718928e-01],
     [6.61728027e-01, 8.58277873e-01, 9.60587443e-01],
     [6.77234354e-01, 8.67738572e-01, 9.63370021e-01],
     [6.92512643e-01, 8.76969230e-01, 9.66064950e-01],
     [7.07539204e-01, 8.85958505e-01, 9.68670518e-01],
     [7.22290347e-01, 8.94695050e-01, 9.71185016e-01],
     [7.36742383e-01, 9.03167523e-01, 9.73606731e-01],
     [7.50871621e-01, 9.11364577e-01, 9.75933952e-01],
     [7.64654371e-01, 9.19274869e-01, 9.78164968e-01],
     [7.78066945e-01, 9.26887055e-01, 9.80298068e-01],
     [7.91085652e-01, 9.34189789e-01, 9.82331541e-01],
     [8.03686802e-01, 9.41171728e-01, 9.84263674e-01],
     [8.15846706e-01, 9.47821526e-01, 9.86092758e-01],
     [8.27541674e-01, 9.54127840e-01, 9.87817080e-01],
     [8.38748016e-01, 9.60079324e-01, 9.89434930e-01],
     [8.49442042e-01, 9.65664635e-01, 9.90944596e-01],
     [8.59600062e-01, 9.70872428e-01, 9.92344366e-01],
     [8.69198387e-01, 9.75691358e-01, 9.93632531e-01],
     [8.78213328e-01, 9.80110081e-01, 9.94807377e-01],
     [8.86621193e-01, 9.84117253e-01, 9.95867195e-01],
     [8.94398294e-01, 9.87701528e-01, 9.96810273e-01],
     [9.01520940e-01, 9.90851563e-01, 9.97634899e-01],
     [9.07965442e-01, 9.93556012e-01, 9.98339363e-01],
     [9.13708110e-01, 9.95803532e-01, 9.98921953e-01],
     [9.18725254e-01, 9.97582779e-01, 9.99380957e-01],
     [9.22993185e-01, 9.98882406e-01, 9.99714665e-01],
     [9.26488212e-01, 9.99691071e-01, 9.99921366e-01],
     [9.29186646e-01, 9.99997428e-01, 9.99999347e-01],
     [9.31390967e-01, 9.99862137e-01, 9.99253124e-01],
     [9.33566587e-01, 9.99389882e-01, 9.96710858e-01],
     [9.35716976e-01, 9.98588684e-01, 9.92429575e-01],
     [9.37841616e-01, 9.97465705e-01, 9.86474975e-01],
     [9.39939988e-01, 9.96028108e-01, 9.78912758e-01],
     [9.42011573e-01, 9.94283054e-01, 9.69808626e-01],
     [9.44055854e-01, 9.92237706e-01, 9.59228278e-01],
     [9.46072311e-01, 9.89899227e-01, 9.47237417e-01],
     [9.48060428e-01, 9.87274778e-01, 9.33901742e-01],
     [9.50019684e-01, 9.84371523e-01, 9.19286955e-01],
     [9.51949561e-01, 9.81196622e-01, 9.03458756e-01],
     [9.53849542e-01, 9.77757239e-01, 8.86482847e-01],
     [9.55719108e-01, 9.74060536e-01, 8.68424927e-01],
     [9.57557740e-01, 9.70113676e-01, 8.49350698e-01],
     [9.59364920e-01, 9.65923819e-01, 8.29325861e-01],
     [9.61140129e-01, 9.61498130e-01, 8.08416116e-01],
     [9.62882850e-01, 9.56843770e-01, 7.86687164e-01],
     [9.64592563e-01, 9.51967901e-01, 7.64204706e-01],
     [9.66268750e-01, 9.46877686e-01, 7.41034443e-01],
     [9.67910894e-01, 9.41580287e-01, 7.17242075e-01],
     [9.69518474e-01, 9.36082866e-01, 6.92893304e-01],
     [9.71090974e-01, 9.30392586e-01, 6.68053830e-01],
     [9.72627874e-01, 9.24516609e-01, 6.42789353e-01],
     [9.74128656e-01, 9.18462098e-01, 6.17165576e-01],
     [9.75592802e-01, 9.12236214e-01, 5.91248198e-01],
     [9.77019794e-01, 9.05846120e-01, 5.65102920e-01],
     [9.78409112e-01, 8.99298978e-01, 5.38795444e-01],
     [9.79760238e-01, 8.92601951e-01, 5.12391470e-01],
     [9.81072655e-01, 8.85762201e-01, 4.85956698e-01],
     [9.82345843e-01, 8.78786890e-01, 4.59556830e-01],
     [9.83579285e-01, 8.71683180e-01, 4.33257566e-01],
     [9.84772461e-01, 8.64458234e-01, 4.07124607e-01],
     [9.85924854e-01, 8.57119214e-01, 3.81223655e-01],
     [9.87035944e-01, 8.49673283e-01, 3.55620409e-01],
     [9.88105214e-01, 8.42127602e-01, 3.30380570e-01],
     [9.89132146e-01, 8.34489335e-01, 3.05569840e-01],
     [9.90116220e-01, 8.26765643e-01, 2.81253919e-01],
     [9.91056918e-01, 8.18963688e-01, 2.57498508e-01],
     [9.91953722e-01, 8.11090634e-01, 2.34369308e-01],
     [9.92806113e-01, 8.03153642e-01, 2.11932020e-01],
     [9.93613573e-01, 7.95159874e-01, 1.90252343e-01],
     [9.94375584e-01, 7.87116493e-01, 1.69395980e-01],
     [9.95091627e-01, 7.79030662e-01, 1.49428631e-01],
     [9.95761184e-01, 7.70909542e-01, 1.30415997e-01],
     [9.96383736e-01, 7.62760296e-01, 1.12423778e-01],
     [9.96958765e-01, 7.54590086e-01, 9.55176752e-02],
     [9.97485753e-01, 7.46406074e-01, 7.97633899e-02],
     [9.97964180e-01, 7.38215424e-01, 6.52266225e-02],
     [9.98393529e-01, 7.30025296e-01, 5.19730738e-02],
     [9.98773282e-01, 7.21842854e-01, 4.00684447e-02],
     [9.99102919e-01, 7.13675259e-01, 2.95784359e-02],
     [9.99381923e-01, 7.05529675e-01, 2.05687483e-02],
     [9.99609774e-01, 6.97413263e-01, 1.31050827e-02],
     [9.99785955e-01, 6.89333185e-01, 7.25313979e-03],
     [9.99909947e-01, 6.81296605e-01, 3.07862044e-03],
     [9.99981232e-01, 6.73310683e-01, 6.47225458e-04],
     [9.99973697e-01, 6.65372012e-01, 0.00000000e+00],
     [9.98670259e-01, 6.56984091e-01, 0.00000000e+00],
     [9.95455321e-01, 6.47895389e-01, 0.00000000e+00],
     [9.90401699e-01, 6.38138096e-01, 0.00000000e+00],
     [9.83582215e-01, 6.27744402e-01, 0.00000000e+00],
     [9.75069687e-01, 6.16746500e-01, 0.00000000e+00],
     [9.64936933e-01, 6.05176579e-01, 0.00000000e+00],
     [9.53256774e-01, 5.93066831e-01, 0.00000000e+00],
     [9.40102027e-01, 5.80449446e-01, 0.00000000e+00],
     [9.25545513e-01, 5.67356615e-01, 0.00000000e+00],
     [9.09660051e-01, 5.53820529e-01, 0.00000000e+00],
     [8.92518458e-01, 5.39873379e-01, 0.00000000e+00],
     [8.74193556e-01, 5.25547356e-01, 0.00000000e+00],
     [8.54758162e-01, 5.10874650e-01, 0.00000000e+00],
     [8.34285096e-01, 4.95887452e-01, 0.00000000e+00],
     [8.12847176e-01, 4.80617953e-01, 0.00000000e+00],
     [7.90517223e-01, 4.65098344e-01, 0.00000000e+00],
     [7.67368055e-01, 4.49360816e-01, 0.00000000e+00],
     [7.43472491e-01, 4.33437559e-01, 0.00000000e+00],
     [7.18903350e-01, 4.17360764e-01, 0.00000000e+00],
     [6.93733452e-01, 4.01162623e-01, 0.00000000e+00],
     [6.68035615e-01, 3.84875326e-01, 0.00000000e+00],
     [6.41882659e-01, 3.68531063e-01, 0.00000000e+00],
     [6.15347402e-01, 3.52162026e-01, 0.00000000e+00],
     [5.88502665e-01, 3.35800405e-01, 0.00000000e+00],
     [5.61421265e-01, 3.19478392e-01, 0.00000000e+00],
     [5.34176022e-01, 3.03228177e-01, 0.00000000e+00],
     [5.06839756e-01, 2.87081950e-01, 0.00000000e+00],
     [4.79485284e-01, 2.71071903e-01, 0.00000000e+00],
     [4.52185427e-01, 2.55230227e-01, 0.00000000e+00],
     [4.25013004e-01, 2.39589112e-01, 0.00000000e+00],
     [3.98040832e-01, 2.24180749e-01, 0.00000000e+00],
     [3.71341733e-01, 2.09037330e-01, 0.00000000e+00],
     [3.44988524e-01, 1.94191044e-01, 0.00000000e+00],
     [3.19054025e-01, 1.79674082e-01, 0.00000000e+00],
     [2.93611055e-01, 1.65518636e-01, 0.00000000e+00],
     [2.68732434e-01, 1.51756896e-01, 0.00000000e+00],
     [2.44490979e-01, 1.38421054e-01, 0.00000000e+00],
     [2.20959510e-01, 1.25543299e-01, 0.00000000e+00],
     [1.98210847e-01, 1.13155823e-01, 0.00000000e+00],
     [1.76317808e-01, 1.01290816e-01, 0.00000000e+00],
     [1.55353213e-01, 8.99804696e-02, 0.00000000e+00],
     [1.35389881e-01, 7.92569745e-02, 0.00000000e+00],
     [1.16500630e-01, 6.91525213e-02, 0.00000000e+00],
     [9.87582805e-02, 5.96993009e-02, 0.00000000e+00],
     [8.22356507e-02, 5.09295041e-02, 0.00000000e+00],
     [6.70055599e-02, 4.28753217e-02, 0.00000000e+00],
     [5.31408274e-02, 3.55689446e-02, 0.00000000e+00],
     [4.07142721e-02, 2.90425636e-02, 0.00000000e+00],
     [2.97987132e-02, 2.33283694e-02, 0.00000000e+00],
     [2.04669698e-02, 1.84585530e-02, 0.00000000e+00],
     [1.27918610e-02, 1.44653050e-02, 0.00000000e+00],
     [6.84620587e-03, 1.13808164e-02, 0.00000000e+00],
     [2.70282357e-03, 9.23727801e-03, 0.00000000e+00],
     [4.34533158e-04, 8.06688056e-03, 0.00000000e+00],
     [0.00000000e+00, 7.84315297e-03, 5.39857630e-05],
     [0.00000000e+00, 7.84411505e-03, 8.39057327e-04],
     [0.00000000e+00, 7.84835664e-03, 2.53589902e-03],
     [0.00000000e+00, 7.85832973e-03, 5.11501856e-03],
     [0.00000000e+00, 7.87648628e-03, 8.54692366e-03],
     [0.00000000e+00, 7.90527827e-03, 1.28021221e-02],
     [0.00000000e+00, 7.94715768e-03, 1.78511215e-02],
     [0.00000000e+00, 8.00457647e-03, 2.36644296e-02],
     [0.00000000e+00, 8.07998662e-03, 3.02125542e-02],
     [0.00000000e+00, 8.17584011e-03, 3.74660029e-02],
     [0.00000000e+00, 8.29458892e-03, 4.53952835e-02],
     [0.00000000e+00, 8.43868501e-03, 5.39709038e-02],
     [0.00000000e+00, 8.61058036e-03, 6.31633713e-02],
     [0.00000000e+00, 8.81272694e-03, 7.29431939e-02],
     [0.00000000e+00, 9.04757673e-03, 8.32808793e-02],
     [0.00000000e+00, 9.31758171e-03, 9.41469352e-02],
     [0.00000000e+00, 9.62519385e-03, 1.05511869e-01],
     [0.00000000e+00, 9.97286511e-03, 1.17346189e-01],
     [0.00000000e+00, 1.03630475e-02, 1.29620403e-01],
     [0.00000000e+00, 1.07981929e-02, 1.42305018e-01],
     [0.00000000e+00, 1.12807535e-02, 1.55370542e-01],
     [0.00000000e+00, 1.18131810e-02, 1.68787483e-01],
     [0.00000000e+00, 1.23979275e-02, 1.82526348e-01],
     [0.00000000e+00, 1.30374451e-02, 1.96557646e-01],
     [0.00000000e+00, 1.37341856e-02, 2.10851884e-01],
     [0.00000000e+00, 1.44906010e-02, 2.25379569e-01],
     [0.00000000e+00, 1.53091433e-02, 2.40111210e-01],
     [0.00000000e+00, 1.61922645e-02, 2.55017314e-01],
     [0.00000000e+00, 1.71424165e-02, 2.70068388e-01],
     [0.00000000e+00, 1.81620514e-02, 2.85234942e-01],
     [0.00000000e+00, 1.92536210e-02, 3.00487481e-01],
     [0.00000000e+00, 2.04195775e-02, 3.15796515e-01],
     [0.00000000e+00, 2.16623727e-02, 3.31132550e-01],
     [0.00000000e+00, 2.29844586e-02, 3.46466095e-01],
     [0.00000000e+00, 2.43882872e-02, 3.61767657e-01],
     [0.00000000e+00, 2.58763105e-02, 3.77007743e-01],
     [0.00000000e+00, 2.74509804e-02, 3.92156863e-01]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='repeat'
)

cmap_atoll = fscolors.Fractal_colormap(
    colors=[[0.5372549 , 0.89411765, 0.80784314],
     [0.55294118, 0.89019608, 0.8       ],
     [0.56862745, 0.89019608, 0.8       ],
     [0.57647059, 0.89019608, 0.8       ],
     [0.59607843, 0.89411765, 0.80784314],
     [0.60784314, 0.89803922, 0.80784314],
     [0.62745098, 0.90196078, 0.80392157],
     [0.58431373, 0.91764706, 0.81960784],
     [0.17254902, 0.75686275, 0.72156863],
     [0.10588235, 0.68627451, 0.72156863],
     [0.11372549, 0.66666667, 0.70588235],
     [0.1254902 , 0.63137255, 0.69411765],
     [0.10196078, 0.57647059, 0.65882353],
     [0.10980392, 0.58039216, 0.6745098 ],
     [0.10980392, 0.57647059, 0.65882353],
     [0.11764706, 0.56470588, 0.65882353],
     [0.1254902 , 0.56078431, 0.66666667],
     [0.12156863, 0.57647059, 0.68235294],
     [0.13333333, 0.61176471, 0.70196078],
     [0.10980392, 0.50588235, 0.6       ],
     [0.10196078, 0.34901961, 0.48627451],
     [0.12156863, 0.3254902 , 0.47058824],
     [0.1254902 , 0.34117647, 0.48627451],
     [0.10980392, 0.34509804, 0.47843137],
     [0.10980392, 0.3372549 , 0.47058824],
     [0.11372549, 0.3254902 , 0.46666667],
     [0.10196078, 0.29803922, 0.44313725],
     [0.10196078, 0.30980392, 0.45098039],
     [0.11372549, 0.30588235, 0.44705882],
     [0.12156863, 0.30980392, 0.4627451 ],
     [0.12156863, 0.37254902, 0.51372549],
     [0.09411765, 0.5254902 , 0.62745098],
     [0.11764706, 0.58039216, 0.6745098 ],
     [0.11764706, 0.58039216, 0.65882353],
     [0.11764706, 0.57647059, 0.65490196],
     [0.12156863, 0.58039216, 0.65882353],
     [0.12941176, 0.58039216, 0.6627451 ],
     [0.10196078, 0.55686275, 0.63921569],
     [0.11764706, 0.50196078, 0.59607843],
     [0.09803922, 0.4745098 , 0.57254902],
     [0.10588235, 0.49411765, 0.58823529],
     [0.08627451, 0.4       , 0.52156863],
     [0.12156863, 0.48627451, 0.58823529],
     [0.11764706, 0.49019608, 0.59607843],
     [0.11372549, 0.45490196, 0.56078431],
     [0.10588235, 0.42352941, 0.54509804],
     [0.11764706, 0.53333333, 0.62745098],
     [0.10196078, 0.56470588, 0.65098039],
     [0.12156863, 0.55294118, 0.64705882],
     [0.11372549, 0.54509804, 0.63529412],
     [0.10980392, 0.53333333, 0.62352941],
     [0.09803922, 0.54117647, 0.62352941],
     [0.10980392, 0.55686275, 0.65098039],
     [0.1254902 , 0.56078431, 0.66666667],
     [0.11372549, 0.55294118, 0.64705882],
     [0.11764706, 0.54901961, 0.64705882],
     [0.10196078, 0.54901961, 0.64313725],
     [0.10588235, 0.55294118, 0.64705882],
     [0.11372549, 0.55294118, 0.64705882],
     [0.09411765, 0.54901961, 0.63921569],
     [0.10196078, 0.55686275, 0.64705882],
     [0.11372549, 0.56078431, 0.65490196],
     [0.09019608, 0.54509804, 0.63529412],
     [0.09019608, 0.54509804, 0.63529412],
     [0.09411765, 0.54509804, 0.64705882],
     [0.09411765, 0.54117647, 0.64313725],
     [0.10196078, 0.54901961, 0.65098039],
     [0.09803922, 0.54901961, 0.63137255],
     [0.10196078, 0.54901961, 0.64313725],
     [0.10980392, 0.55686275, 0.65098039],
     [0.10588235, 0.55294118, 0.65490196],
     [0.09803922, 0.54509804, 0.63921569],
     [0.10980392, 0.55686275, 0.65098039],
     [0.10196078, 0.54901961, 0.64313725],
     [0.13333333, 0.58431373, 0.68235294],
     [0.09411765, 0.56078431, 0.65490196],
     [0.10196078, 0.57254902, 0.66666667],
     [0.10196078, 0.58039216, 0.67058824],
     [0.09411765, 0.58431373, 0.6627451 ],
     [0.10588235, 0.57647059, 0.67058824],
     [0.10588235, 0.58431373, 0.6745098 ],
     [0.12156863, 0.59215686, 0.68627451],
     [0.11372549, 0.59215686, 0.68235294],
     [0.1254902 , 0.59607843, 0.69019608],
     [0.11764706, 0.59215686, 0.68627451],
     [0.10196078, 0.59215686, 0.67058824],
     [0.10980392, 0.60392157, 0.68235294],
     [0.11372549, 0.61176471, 0.68627451],
     [0.1254902 , 0.62352941, 0.69411765],
     [0.10980392, 0.61568627, 0.69019608],
     [0.11372549, 0.61176471, 0.6745098 ],
     [0.10980392, 0.61176471, 0.68627451],
     [0.14117647, 0.63137255, 0.70196078],
     [0.11372549, 0.64705882, 0.70196078],
     [0.1254902 , 0.68627451, 0.73333333],
     [0.37647059, 0.78039216, 0.7372549 ],
     [0.68627451, 0.79607843, 0.71764706],
     [0.6627451 , 0.69019608, 0.6       ],
     [0.59215686, 0.70980392, 0.64705882],
     [0.34117647, 0.81568627, 0.76470588],
     [0.18823529, 0.84705882, 0.83529412],
     [0.12941176, 0.78039216, 0.79607843],
     [0.14117647, 0.7372549 , 0.76862745],
     [0.14509804, 0.70196078, 0.74901961],
     [0.1372549 , 0.69803922, 0.74509804],
     [0.14509804, 0.69411765, 0.74509804],
     [0.12941176, 0.69019608, 0.74509804],
     [0.12941176, 0.69019608, 0.74509804],
     [0.12941176, 0.68627451, 0.74117647],
     [0.12941176, 0.68627451, 0.73333333],
     [0.14901961, 0.70588235, 0.75294118],
     [0.14901961, 0.69803922, 0.74509804],
     [0.1372549 , 0.70980392, 0.74901961],
     [0.14901961, 0.70980392, 0.74901961],
     [0.10980392, 0.66666667, 0.70588235],
     [0.13333333, 0.69019608, 0.72941176],
     [0.1372549 , 0.68627451, 0.73333333],
     [0.1254902 , 0.69019608, 0.72941176],
     [0.12156863, 0.6745098 , 0.71372549],
     [0.1254902 , 0.66666667, 0.70588235],
     [0.11764706, 0.65882353, 0.70196078],
     [0.10980392, 0.6745098 , 0.70980392],
     [0.14117647, 0.70588235, 0.73333333],
     [0.10980392, 0.66666667, 0.69019608],
     [0.1254902 , 0.61176471, 0.6627451 ],
     [0.12941176, 0.54901961, 0.62352941],
     [0.12156863, 0.54509804, 0.61176471],
     [0.10980392, 0.58823529, 0.64705882],
     [0.13333333, 0.64705882, 0.69411765],
     [0.1372549 , 0.69019608, 0.71764706],
     [0.14509804, 0.68235294, 0.69411765],
     [0.25098039, 0.85490196, 0.82745098],
     [0.35686275, 0.87058824, 0.82352941],
     [0.36862745, 0.74509804, 0.70588235],
     [0.50588235, 0.80784314, 0.75294118],
     [0.49411765, 0.76862745, 0.69803922],
     [0.4627451 , 0.76470588, 0.71764706],
     [0.42352941, 0.81960784, 0.76470588],
     [0.41568627, 0.88235294, 0.83137255],
     [0.36862745, 0.90196078, 0.8627451 ],
     [0.35294118, 0.91372549, 0.88235294],
     [0.3254902 , 0.90980392, 0.87843137],
     [0.29411765, 0.90980392, 0.8745098 ],
     [0.26666667, 0.87843137, 0.85490196],
     [0.2       , 0.8       , 0.79215686],
     [0.16862745, 0.70588235, 0.72941176],
     [0.17254902, 0.72156863, 0.75294118],
     [0.20392157, 0.76078431, 0.77254902],
     [0.26666667, 0.82352941, 0.82352941],
     [0.26666667, 0.82745098, 0.81568627],
     [0.30196078, 0.82745098, 0.83529412],
     [0.27058824, 0.78039216, 0.78431373],
     [0.20784314, 0.67058824, 0.69019608],
     [0.24313725, 0.63137255, 0.68627451],
     [0.21960784, 0.60392157, 0.66666667],
     [0.2627451 , 0.65882353, 0.69019608],
     [0.38823529, 0.75686275, 0.74901961],
     [0.51372549, 0.81176471, 0.76078431],
     [0.56862745, 0.82745098, 0.75686275],
     [0.57254902, 0.78039216, 0.70980392],
     [0.68627451, 0.81568627, 0.73333333],
     [0.78039216, 0.84705882, 0.74509804],
     [0.87058824, 0.86666667, 0.75294118],
     [0.89019608, 0.89019608, 0.78039216],
     [0.88235294, 0.89803922, 0.80392157],
     [0.93333333, 0.96078431, 0.88627451],
     [0.91764706, 0.94901961, 0.88627451],
     [0.92941176, 0.94509804, 0.87843137],
     [0.94117647, 0.95686275, 0.89019608],
     [0.93333333, 0.94901961, 0.8627451 ],
     [0.93333333, 0.94509804, 0.84705882],
     [0.9254902 , 0.9254902 , 0.83137255],
     [0.96078431, 0.94901961, 0.85098039],
     [0.95294118, 0.92941176, 0.83137255],
     [0.94117647, 0.90980392, 0.81568627],
     [0.99607843, 0.96862745, 0.9372549 ],
     [0.99607843, 0.96862745, 0.93333333],
     [0.94901961, 0.90588235, 0.78823529],
     [0.98039216, 0.97254902, 0.89411765],
     [0.98823529, 0.94509804, 0.86666667],
     [0.98431373, 0.98431373, 0.89803922],
     [0.98431373, 0.94901961, 0.8627451 ],
     [0.94117647, 0.89019608, 0.70980392],
     [0.95294118, 0.86666667, 0.67843137],
     [0.89019608, 0.80392157, 0.45882353],
     [0.80784314, 0.72156863, 0.35294118],
     [0.74509804, 0.67058824, 0.29411765],
     [0.73333333, 0.69411765, 0.34117647],
     [0.72156863, 0.74509804, 0.47058824],
     [0.6745098 , 0.75686275, 0.47843137],
     [0.63137255, 0.78039216, 0.52941176],
     [0.59607843, 0.78431373, 0.54117647],
     [0.56078431, 0.81176471, 0.56470588],
     [0.52156863, 0.8       , 0.58039216],
     [0.49019608, 0.81568627, 0.61960784],
     [0.46666667, 0.81568627, 0.63137255],
     [0.57254902, 0.62352941, 0.28235294],
     [0.25490196, 0.36862745, 0.25098039],
     [0.39607843, 0.78431373, 0.62352941],
     [0.16862745, 0.30980392, 0.11764706],
     [0.36470588, 0.61176471, 0.34117647],
     [0.37254902, 0.79607843, 0.58823529],
     [0.12156863, 0.25882353, 0.14901961],
     [0.4       , 0.55294118, 0.08627451],
     [0.38823529, 0.39215686, 0.11764706],
     [0.43921569, 0.50588235, 0.09019608],
     [0.25490196, 0.29803922, 0.14117647],
     [0.43137255, 0.4745098 , 0.06666667],
     [0.47058824, 0.48627451, 0.10196078],
     [0.19215686, 0.3372549 , 0.07843137],
     [0.45882353, 0.45098039, 0.15294118],
     [0.17647059, 0.25490196, 0.04705882],
     [0.48235294, 0.47843137, 0.08235294],
     [0.38431373, 0.39607843, 0.16078431],
     [0.50196078, 0.5254902 , 0.17647059],
     [0.34509804, 0.38039216, 0.10980392],
     [0.29411765, 0.29019608, 0.09411765],
     [0.21960784, 0.24705882, 0.07843137],
     [0.25490196, 0.2745098 , 0.11764706],
     [0.31372549, 0.29411765, 0.08627451],
     [0.10980392, 0.18431373, 0.0745098 ],
     [0.16470588, 0.21960784, 0.08235294],
     [0.21960784, 0.25490196, 0.11372549],
     [0.12156863, 0.16470588, 0.12156863],
     [0.41176471, 0.42352941, 0.19607843],
     [0.3254902 , 0.2745098 , 0.09803922],
     [0.34117647, 0.35686275, 0.07058824],
     [0.24313725, 0.31372549, 0.12941176],
     [0.16862745, 0.23529412, 0.1372549 ],
     [0.43137255, 0.4       , 0.15294118],
     [0.21960784, 0.28235294, 0.09803922],
     [0.21568627, 0.23921569, 0.08627451],
     [0.45098039, 0.41568627, 0.09411765],
     [0.2627451 , 0.32941176, 0.05098039],
     [0.29803922, 0.35294118, 0.07058824],
     [0.24705882, 0.25882353, 0.08235294],
     [0.35294118, 0.40392157, 0.09411765],
     [0.42352941, 0.51764706, 0.09411765],
     [0.31372549, 0.38431373, 0.08235294],
     [0.29019608, 0.34901961, 0.14117647],
     [0.28235294, 0.38823529, 0.08627451],
     [0.43137255, 0.4627451 , 0.11764706],
     [0.25490196, 0.30196078, 0.0627451 ],
     [0.54117647, 0.56862745, 0.12156863],
     [0.41568627, 0.44705882, 0.05490196],
     [0.1372549 , 0.16470588, 0.09019608],
     [0.39215686, 0.32941176, 0.12156863],
     [0.62745098, 0.55294118, 0.22745098],
     [0.26666667, 0.37647059, 0.03529412],
     [0.18431373, 0.27843137, 0.05882353],
     [0.42352941, 0.5372549 , 0.03921569],
     [0.54509804, 0.6       , 0.04313725],
     [0.20392157, 0.26666667, 0.0745098 ],
     [0.21568627, 0.32156863, 0.03137255],
     [0.40784314, 0.46666667, 0.05098039],
     [0.45490196, 0.4627451 , 0.09019608]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='mirror'
)



cmap_sunset = fscolors.Fractal_colormap(
    colors=[[0.98823529, 0.29411765, 0.10196078],
     [0.97254902, 0.27843137, 0.08627451],
     [0.98039216, 0.30588235, 0.10196078],
     [0.96862745, 0.31764706, 0.0745098 ],
     [0.99607843, 0.35686275, 0.14117647],
     [0.99607843, 0.34901961, 0.15686275],
     [0.99215686, 0.36078431, 0.1372549 ],
     [0.99215686, 0.37647059, 0.12156863],
     [0.99607843, 0.37647059, 0.14509804],
     [0.97254902, 0.36078431, 0.12156863],
     [1.        , 0.38039216, 0.13333333],
     [0.99215686, 0.38039216, 0.16078431],
     [0.98039216, 0.38431373, 0.12156863],
     [0.99607843, 0.40784314, 0.16862745],
     [0.98039216, 0.39215686, 0.16078431],
     [0.97647059, 0.38823529, 0.15686275],
     [0.99215686, 0.4       , 0.16862745],
     [0.98823529, 0.39215686, 0.17647059],
     [0.99215686, 0.40392157, 0.19215686],
     [0.99607843, 0.41960784, 0.21960784],
     [0.98431373, 0.4       , 0.2       ],
     [0.98431373, 0.4       , 0.21960784],
     [0.96078431, 0.3254902 , 0.23137255],
     [0.54509804, 0.26666667, 0.24313725],
     [0.56078431, 0.2745098 , 0.25098039],
     [0.52156863, 0.26666667, 0.24313725],
     [0.49411765, 0.25882353, 0.25882353],
     [0.4745098 , 0.27058824, 0.28627451],
     [0.45490196, 0.24313725, 0.23137255],
     [0.4745098 , 0.2745098 , 0.27058824],
     [0.5254902 , 0.28627451, 0.2745098 ],
     [0.55294118, 0.29803922, 0.2745098 ],
     [0.56862745, 0.29411765, 0.28627451],
     [0.58823529, 0.31372549, 0.29411765],
     [0.58823529, 0.30588235, 0.27843137],
     [0.55686275, 0.29019608, 0.27843137],
     [0.56862745, 0.31372549, 0.29411765],
     [0.52941176, 0.29019608, 0.27843137],
     [0.55686275, 0.31764706, 0.30588235],
     [0.51372549, 0.28235294, 0.29019608],
     [0.53333333, 0.29803922, 0.29803922],
     [0.5372549 , 0.30196078, 0.29803922],
     [0.54117647, 0.29803922, 0.30980392],
     [0.5372549 , 0.30588235, 0.32156863],
     [0.52941176, 0.30196078, 0.29803922],
     [0.5254902 , 0.32156863, 0.32941176],
     [0.49019608, 0.28627451, 0.29411765],
     [0.45490196, 0.27843137, 0.29019608],
     [0.49019608, 0.31372549, 0.33333333],
     [0.46666667, 0.29411765, 0.31372549],
     [0.43137255, 0.27058824, 0.29411765],
     [0.44313725, 0.30196078, 0.31764706],
     [0.45882353, 0.29803922, 0.32156863],
     [0.43137255, 0.29019608, 0.30588235],
     [0.45490196, 0.29803922, 0.32941176],
     [0.42352941, 0.27843137, 0.30588235],
     [0.42745098, 0.28235294, 0.30980392],
     [0.41960784, 0.2627451 , 0.29411765],
     [0.42745098, 0.27058824, 0.30196078],
     [0.44705882, 0.28627451, 0.31764706],
     [0.43529412, 0.2745098 , 0.29803922],
     [0.50196078, 0.30980392, 0.32156863],
     [0.51764706, 0.32156863, 0.3254902 ],
     [0.52156863, 0.29019608, 0.30588235],
     [0.50980392, 0.30980392, 0.31372549],
     [0.52156863, 0.31372549, 0.34117647],
     [0.53333333, 0.30196078, 0.31764706],
     [0.54901961, 0.31372549, 0.31372549],
     [0.54117647, 0.30980392, 0.30980392],
     [0.5372549 , 0.29019608, 0.30980392],
     [0.57254902, 0.31764706, 0.32156863],
     [0.54117647, 0.29803922, 0.31764706],
     [0.51764706, 0.2627451 , 0.27843137],
     [0.53333333, 0.29019608, 0.30980392],
     [0.69019608, 0.29803922, 0.30588235],
     [0.78039216, 0.28627451, 0.30196078],
     [0.67843137, 0.27058824, 0.2745098 ],
     [0.61960784, 0.28235294, 0.28627451],
     [0.60784314, 0.27058824, 0.2745098 ],
     [0.69019608, 0.24705882, 0.27058824],
     [0.83921569, 0.24313725, 0.2627451 ],
     [0.98431373, 0.24705882, 0.2745098 ],
     [0.99215686, 0.23921569, 0.25882353],
     [1.        , 0.24705882, 0.2745098 ],
     [0.99607843, 0.27058824, 0.2627451 ],
     [0.98039216, 0.21176471, 0.25098039],
     [1.        , 0.23921569, 0.2745098 ],
     [0.95686275, 0.20784314, 0.24705882],
     [0.98039216, 0.20784314, 0.23921569],
     [0.98431373, 0.20784314, 0.2627451 ],
     [0.97254902, 0.16078431, 0.23529412],
     [0.99215686, 0.18431373, 0.23529412],
     [0.98431373, 0.12941176, 0.20392157],
     [0.99607843, 0.20392157, 0.24313725],
     [0.98823529, 0.18431373, 0.20392157],
     [0.98823529, 0.19215686, 0.20392157],
     [0.98823529, 0.22745098, 0.20784314],
     [0.98823529, 0.24313725, 0.19607843],
     [0.99215686, 0.27058824, 0.20392157],
     [0.98431373, 0.30980392, 0.18431373],
     [0.98039216, 0.31764706, 0.17647059],
     [0.99607843, 0.31764706, 0.19215686],
     [0.98431373, 0.29411765, 0.16862745],
     [0.98823529, 0.26666667, 0.15294118],
     [0.99215686, 0.23137255, 0.17647059],
     [0.99607843, 0.23529412, 0.18823529],
     [0.99607843, 0.24313725, 0.16470588],
     [0.97647059, 0.16862745, 0.10196078],
     [0.99607843, 0.20392157, 0.1372549 ],
     [0.98039216, 0.23137255, 0.12941176],
     [0.99607843, 0.27843137, 0.1254902 ],
     [0.99607843, 0.31372549, 0.12941176],
     [0.99607843, 0.39215686, 0.14117647],
     [0.99607843, 0.45882353, 0.22352941],
     [0.99607843, 0.43529412, 0.21176471],
     [0.99607843, 0.38431373, 0.1254902 ],
     [0.97254902, 0.34901961, 0.09803922],
     [0.99607843, 0.35294118, 0.05490196],
     [0.99607843, 0.37254902, 0.09019608],
     [0.98431373, 0.26666667, 0.        ],
     [1.        , 0.28627451, 0.02745098],
     [0.99215686, 0.35294118, 0.04313725],
     [0.99607843, 0.44705882, 0.16862745],
     [1.        , 0.3372549 , 0.02352941],
     [0.99215686, 0.33333333, 0.02745098],
     [0.97647059, 0.36862745, 0.02352941],
     [0.99607843, 0.47843137, 0.03529412],
     [0.98823529, 0.43529412, 0.01960784],
     [0.99607843, 0.43137255, 0.00392157],
     [0.98431373, 0.52941176, 0.        ],
     [0.99215686, 0.50196078, 0.00784314],
     [0.99215686, 0.55294118, 0.00392157],
     [1.        , 0.56862745, 0.00784314],
     [0.98823529, 0.56470588, 0.        ],
     [0.99215686, 0.58823529, 0.        ],
     [0.99607843, 0.56470588, 0.00392157],
     [0.98823529, 0.99607843, 0.00784314],
     [0.99607843, 1.        , 0.00784314],
     [0.99607843, 1.        , 0.00392157],
     [0.99215686, 1.        , 0.00784314],
     [0.99607843, 0.98431373, 0.01176471],
     [0.99607843, 0.02745098, 0.01960784],
     [0.91372549, 0.        , 0.        ],
     [0.98431373, 0.75294118, 0.00784314],
     [0.99607843, 0.69411765, 0.        ],
     [0.80392157, 0.        , 0.00784314],
     [0.95686275, 0.40784314, 0.        ],
     [0.98431373, 0.68235294, 0.        ],
     [0.99607843, 0.63529412, 0.00392157],
     [0.99215686, 0.57647059, 0.00392157],
     [0.98431373, 0.50588235, 0.00784314],
     [0.71764706, 0.00392157, 0.01176471],
     [0.38823529, 0.        , 0.09019608],
     [0.30196078, 0.0627451 , 0.10980392],
     [0.2       , 0.03921569, 0.08235294],
     [0.26666667, 0.05490196, 0.10980392],
     [0.28235294, 0.0745098 , 0.14509804],
     [0.29019608, 0.12941176, 0.14901961],
     [0.61568627, 0.38431373, 0.40392157],
     [0.14117647, 0.01568627, 0.06666667],
     [0.09411765, 0.01568627, 0.03137255],
     [0.20784314, 0.05882353, 0.10980392],
     [0.30980392, 0.1372549 , 0.15294118],
     [0.55686275, 0.35686275, 0.38431373],
     [0.51372549, 0.27058824, 0.2745098 ],
     [0.4627451 , 0.2627451 , 0.28235294],
     [0.80392157, 0.5254902 , 0.53333333],
     [0.35294118, 0.18823529, 0.22352941],
     [0.65098039, 0.39607843, 0.39607843],
     [0.15294118, 0.05882353, 0.10588235],
     [0.23921569, 0.12156863, 0.14901961],
     [0.44705882, 0.25882353, 0.26666667],
     [0.34901961, 0.22745098, 0.27058824],
     [0.34117647, 0.2       , 0.21960784],
     [0.65098039, 0.39215686, 0.35294118],
     [0.54509804, 0.36470588, 0.39215686],
     [0.14901961, 0.05882353, 0.12156863],
     [0.49411765, 0.2627451 , 0.23921569],
     [0.25098039, 0.1372549 , 0.16862745],
     [0.30588235, 0.16078431, 0.20392157],
     [0.16078431, 0.0745098 , 0.12156863],
     [0.44705882, 0.27058824, 0.28627451],
     [0.02745098, 0.        , 0.04313725],
     [0.50980392, 0.34901961, 0.37647059],
     [0.21568627, 0.10588235, 0.15294118],
     [0.37647059, 0.24313725, 0.28235294],
     [0.09019608, 0.03137255, 0.07843137],
     [0.39215686, 0.26666667, 0.29019608],
     [0.29803922, 0.17254902, 0.20392157],
     [0.27843137, 0.16078431, 0.21960784],
     [0.5254902 , 0.32941176, 0.30980392],
     [0.23529412, 0.1372549 , 0.17254902],
     [0.42352941, 0.27058824, 0.29019608],
     [0.37254902, 0.21960784, 0.22352941],
     [0.37254902, 0.24313725, 0.26666667],
     [0.5254902 , 0.29019608, 0.29019608],
     [0.36470588, 0.22352941, 0.25490196],
     [0.88235294, 0.60784314, 0.56470588],
     [0.25882353, 0.1372549 , 0.16078431],
     [0.22745098, 0.1254902 , 0.16862745],
     [0.31372549, 0.14509804, 0.16862745],
     [0.89411765, 0.56470588, 0.51764706],
     [0.8627451 , 0.54117647, 0.48235294],
     [0.4745098 , 0.2627451 , 0.28627451],
     [0.99215686, 0.74117647, 0.56078431],
     [0.97647059, 0.68235294, 0.55294118],
     [0.69019608, 0.36862745, 0.30196078],
     [0.82745098, 0.50588235, 0.38823529],
     [0.98431373, 0.64705882, 0.55686275],
     [0.99607843, 0.74509804, 0.6       ],
     [0.94901961, 0.62352941, 0.43921569],
     [1.        , 0.71372549, 0.52941176],
     [0.56078431, 0.2745098 , 0.21568627],
     [0.83529412, 0.52941176, 0.47843137],
     [0.96862745, 0.66666667, 0.48627451],
     [0.58431373, 0.30588235, 0.29019608],
     [0.52156863, 0.28627451, 0.28235294],
     [0.95686275, 0.70588235, 0.61176471],
     [0.88627451, 0.60392157, 0.50588235],
     [0.99607843, 0.77647059, 0.6745098 ],
     [0.98823529, 0.71764706, 0.54117647],
     [0.44705882, 0.27843137, 0.31372549],
     [0.99607843, 0.79215686, 0.65882353],
     [0.75294118, 0.45882353, 0.38431373],
     [0.30588235, 0.18823529, 0.24705882],
     [0.30588235, 0.20392157, 0.31764706],
     [0.22745098, 0.16470588, 0.29803922],
     [0.19215686, 0.14117647, 0.25098039],
     [0.16862745, 0.1372549 , 0.21960784],
     [0.06666667, 0.05882353, 0.1254902 ],
     [0.08627451, 0.05098039, 0.11764706],
     [0.09411765, 0.05490196, 0.12156863],
     [0.4745098 , 0.34509804, 0.3372549 ],
     [0.16862745, 0.10196078, 0.2       ],
     [0.69019608, 0.49803922, 0.49411765],
     [0.35294118, 0.21568627, 0.25490196],
     [0.44705882, 0.29019608, 0.30196078],
     [0.40392157, 0.2627451 , 0.29019608],
     [0.40392157, 0.27058824, 0.29803922],
     [0.25098039, 0.18039216, 0.24705882],
     [0.69411765, 0.42745098, 0.40784314],
     [0.29803922, 0.1372549 , 0.20392157],
     [0.60784314, 0.35686275, 0.33333333],
     [0.9254902 , 0.60392157, 0.54117647],
     [0.23921569, 0.14509804, 0.19607843],
     [0.22352941, 0.11372549, 0.21176471],
     [0.74509804, 0.4627451 , 0.41568627],
     [0.83921569, 0.5372549 , 0.4627451 ],
     [0.93333333, 0.6       , 0.48235294],
     [0.83137255, 0.47843137, 0.37647059],
     [0.87843137, 0.54117647, 0.43921569],
     [0.99607843, 0.74117647, 0.55294118],
     [0.99215686, 0.70588235, 0.54509804],
     [0.74509804, 0.44313725, 0.38431373],
     [0.76470588, 0.45490196, 0.38823529],
     [0.98823529, 0.72156863, 0.51764706]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='mirror'
)

cmap_autumn = fscolors.Fractal_colormap(
    colors=[[0.65490196, 0.20392157, 0.04705882],
     [0.78823529, 0.26666667, 0.04313725],
     [0.94509804, 0.57647059, 0.27843137],
     [0.64313725, 0.21960784, 0.        ],
     [0.47058824, 0.18431373, 0.00392157],
     [0.61176471, 0.16078431, 0.02352941],
     [0.66666667, 0.16470588, 0.        ],
     [0.28627451, 0.09803922, 0.05490196],
     [0.70980392, 0.18431373, 0.        ],
     [0.9372549 , 0.37647059, 0.07843137],
     [0.77647059, 0.19607843, 0.        ],
     [0.64313725, 0.14117647, 0.        ],
     [0.95294118, 0.67843137, 0.25882353],
     [1.        , 0.85882353, 0.41568627],
     [0.99215686, 0.79215686, 0.30588235],
     [0.97647059, 0.95294118, 0.48627451],
     [0.99215686, 0.94509804, 0.50980392],
     [0.99607843, 0.95686275, 0.52156863],
     [0.99607843, 0.95686275, 0.52156863],
     [1.        , 0.96078431, 0.52156863],
     [1.        , 0.65882353, 0.21960784],
     [0.99607843, 0.59607843, 0.16862745],
     [0.98431373, 0.63921569, 0.10980392],
     [0.94509804, 0.52156863, 0.09019608],
     [0.99607843, 0.47843137, 0.        ],
     [1.        , 0.82352941, 0.24705882],
     [0.97647059, 0.63137255, 0.12156863],
     [0.99607843, 0.50980392, 0.0745098 ],
     [0.99607843, 0.95294118, 0.45490196],
     [0.96078431, 0.76862745, 0.24313725],
     [0.95686275, 0.6       , 0.10196078],
     [0.99607843, 0.96078431, 0.49411765],
     [0.97647059, 0.87058824, 0.35294118],
     [0.98823529, 0.69803922, 0.19607843],
     [0.98039216, 0.98823529, 0.50980392],
     [1.        , 0.99215686, 0.57254902],
     [0.99607843, 0.99215686, 0.57647059],
     [1.        , 0.99607843, 0.58039216],
     [0.90980392, 0.85490196, 0.40392157],
     [0.98431373, 0.99607843, 0.56862745],
     [0.99607843, 0.98823529, 0.58431373],
     [1.        , 0.98039216, 0.53333333],
     [0.98431373, 0.75294118, 0.29019608],
     [0.95294118, 0.62352941, 0.21176471],
     [0.95686275, 0.36862745, 0.03137255],
     [0.94509804, 0.43921569, 0.05098039],
     [0.98431373, 0.34901961, 0.        ],
     [0.97254902, 0.62352941, 0.14509804],
     [0.98431373, 0.58431373, 0.12156863],
     [0.97254902, 0.70196078, 0.16862745],
     [1.        , 0.95686275, 0.51372549],
     [0.96470588, 0.97647059, 0.56470588],
     [0.99215686, 1.        , 0.61568627],
     [1.        , 0.90980392, 0.44705882],
     [0.98823529, 0.91764706, 0.40392157],
     [1.        , 0.75686275, 0.24313725],
     [0.99215686, 0.92941176, 0.43137255],
     [0.99607843, 0.45490196, 0.03529412],
     [0.90196078, 0.49019608, 0.01176471],
     [0.99215686, 0.64705882, 0.10196078],
     [1.        , 0.67058824, 0.18039216],
     [0.98431373, 0.41176471, 0.00392157],
     [0.77647059, 0.22352941, 0.00392157],
     [0.68235294, 0.16862745, 0.01176471],
     [0.90588235, 0.30196078, 0.02352941],
     [0.95294118, 0.3254902 , 0.0627451 ],
     [0.63137255, 0.21960784, 0.01568627],
     [0.53333333, 0.09411765, 0.00784314],
     [0.76078431, 0.27843137, 0.07058824],
     [0.62745098, 0.10588235, 0.        ],
     [0.82352941, 0.22352941, 0.        ],
     [0.88235294, 0.26666667, 0.        ],
     [0.88235294, 0.23137255, 0.05098039],
     [0.82352941, 0.2       , 0.        ],
     [0.8745098 , 0.25098039, 0.01568627],
     [0.89019608, 0.2745098 , 0.01176471],
     [0.8745098 , 0.2745098 , 0.01568627],
     [0.78823529, 0.20392157, 0.        ],
     [0.89019608, 0.43137255, 0.0745098 ],
     [0.91764706, 0.28627451, 0.05098039],
     [0.85098039, 0.28235294, 0.02352941],
     [0.85098039, 0.30196078, 0.02352941],
     [0.81960784, 0.22745098, 0.00392157],
     [0.86666667, 0.28627451, 0.00392157],
     [0.89803922, 0.33333333, 0.03529412],
     [0.96862745, 0.45882353, 0.00784314],
     [1.        , 0.55294118, 0.04705882],
     [0.83529412, 0.32156863, 0.        ],
     [0.70196078, 0.21568627, 0.02745098],
     [0.71764706, 0.23921569, 0.00784314],
     [0.69803922, 0.21176471, 0.03137255],
     [0.81960784, 0.32156863, 0.02745098],
     [0.99607843, 0.54901961, 0.0745098 ],
     [0.80392157, 0.37254902, 0.01960784],
     [0.67843137, 0.30980392, 0.04705882],
     [0.71372549, 0.25490196, 0.03137255],
     [0.49803922, 0.2       , 0.01176471],
     [0.8       , 0.3372549 , 0.02745098],
     [0.8745098 , 0.34509804, 0.09019608],
     [0.61568627, 0.15294118, 0.        ],
     [0.5372549 , 0.1372549 , 0.        ],
     [0.59607843, 0.20784314, 0.02745098],
     [0.50196078, 0.16862745, 0.01568627],
     [0.43921569, 0.13333333, 0.03137255],
     [0.54901961, 0.24313725, 0.02352941],
     [0.54509804, 0.17647059, 0.00392157],
     [0.48235294, 0.14901961, 0.        ],
     [0.45882353, 0.16078431, 0.        ],
     [0.54901961, 0.19607843, 0.        ],
     [0.58823529, 0.20784314, 0.        ],
     [0.57254902, 0.23529412, 0.01176471],
     [0.81960784, 0.3254902 , 0.04705882],
     [0.62745098, 0.27843137, 0.02352941],
     [0.78431373, 0.41176471, 0.17254902],
     [0.9254902 , 0.48627451, 0.2       ],
     [0.85098039, 0.43529412, 0.25098039],
     [0.85490196, 0.46666667, 0.21960784],
     [0.99607843, 0.61960784, 0.22352941],
     [0.89019608, 0.48235294, 0.21960784],
     [1.        , 0.6745098 , 0.29411765],
     [0.8627451 , 0.46666667, 0.21960784],
     [0.85882353, 0.49019608, 0.23921569],
     [0.88235294, 0.44313725, 0.1372549 ],
     [0.92156863, 0.47843137, 0.17254902],
     [0.91372549, 0.49803922, 0.18431373],
     [0.93333333, 0.54117647, 0.20784314],
     [0.98039216, 0.69411765, 0.27058824],
     [0.99607843, 0.71764706, 0.32941176],
     [0.98823529, 0.70980392, 0.23921569],
     [0.99607843, 0.7254902 , 0.2627451 ],
     [0.99607843, 0.74901961, 0.2745098 ],
     [1.        , 0.78039216, 0.2627451 ],
     [0.89411765, 0.62352941, 0.24313725],
     [0.79215686, 0.4627451 , 0.18431373],
     [0.98039216, 0.64705882, 0.21960784],
     [0.94901961, 0.61568627, 0.21176471],
     [1.        , 0.78823529, 0.27843137],
     [0.99215686, 0.78823529, 0.21568627],
     [0.98431373, 0.73333333, 0.21960784],
     [1.        , 0.78039216, 0.25098039],
     [0.97647059, 0.79215686, 0.21568627],
     [1.        , 0.78823529, 0.2627451 ],
     [0.99607843, 0.75686275, 0.25098039],
     [0.99607843, 0.74901961, 0.22352941],
     [1.        , 0.78039216, 0.23921569],
     [0.93333333, 0.74117647, 0.17647059],
     [1.        , 0.78431373, 0.23529412],
     [0.88627451, 0.58039216, 0.21960784],
     [0.94117647, 0.65882353, 0.2627451 ],
     [0.96078431, 0.68235294, 0.29019608],
     [0.77647059, 0.57647059, 0.23529412],
     [0.75686275, 0.55686275, 0.32156863],
     [0.65490196, 0.49411765, 0.22745098],
     [0.49803922, 0.38039216, 0.24313725],
     [0.47843137, 0.36078431, 0.25882353],
     [0.54901961, 0.44705882, 0.32941176],
     [0.40784314, 0.30980392, 0.22745098],
     [0.38431373, 0.29803922, 0.21960784],
     [0.49803922, 0.41960784, 0.3254902 ],
     [0.45490196, 0.37254902, 0.2627451 ],
     [0.49411765, 0.40784314, 0.3254902 ],
     [0.3372549 , 0.2627451 , 0.19607843],
     [0.39607843, 0.32156863, 0.24705882],
     [0.4627451 , 0.36862745, 0.25882353],
     [0.4627451 , 0.36862745, 0.19607843],
     [0.38431373, 0.3372549 , 0.16862745],
     [0.44313725, 0.35294118, 0.18039216],
     [0.54117647, 0.45490196, 0.23921569],
     [0.48627451, 0.38039216, 0.20784314],
     [0.4627451 , 0.36862745, 0.21960784],
     [0.37254902, 0.30980392, 0.21960784],
     [0.41960784, 0.33333333, 0.21960784],
     [0.33333333, 0.31372549, 0.18823529],
     [0.22745098, 0.21960784, 0.14117647],
     [0.22745098, 0.20784314, 0.1372549 ],
     [0.23137255, 0.2       , 0.12156863],
     [0.36078431, 0.34901961, 0.17647059],
     [0.34117647, 0.3254902 , 0.18039216],
     [0.3254902 , 0.29019608, 0.16078431],
     [0.34117647, 0.31372549, 0.20784314],
     [0.21568627, 0.22745098, 0.1372549 ],
     [0.2745098 , 0.25098039, 0.19607843],
     [0.16078431, 0.14901961, 0.12156863],
     [0.08235294, 0.07058824, 0.04313725],
     [0.09019608, 0.07843137, 0.05098039],
     [0.20784314, 0.19215686, 0.14901961],
     [0.15294118, 0.14901961, 0.12156863],
     [0.21960784, 0.20784314, 0.17254902],
     [0.2627451 , 0.24705882, 0.18431373],
     [0.18823529, 0.18431373, 0.12156863],
     [0.14509804, 0.15686275, 0.10196078],
     [0.25098039, 0.23529412, 0.21176471],
     [0.20392157, 0.2       , 0.14901961],
     [0.14509804, 0.16078431, 0.10588235],
     [0.12156863, 0.14117647, 0.05882353],
     [0.23921569, 0.23137255, 0.12156863],
     [0.26666667, 0.23921569, 0.12941176],
     [0.12941176, 0.1372549 , 0.08235294],
     [0.11372549, 0.11764706, 0.10196078],
     [0.07058824, 0.07058824, 0.05490196],
     [0.2       , 0.2       , 0.15294118],
     [0.32941176, 0.27843137, 0.14509804],
     [0.31372549, 0.31372549, 0.22352941],
     [0.12941176, 0.1372549 , 0.11764706],
     [0.09019608, 0.10980392, 0.10588235],
     [0.07058824, 0.10588235, 0.09411765],
     [0.05882353, 0.08235294, 0.07843137],
     [0.01176471, 0.05490196, 0.03921569],
     [0.09411765, 0.1254902 , 0.06666667],
     [0.13333333, 0.20784314, 0.12156863],
     [0.10196078, 0.16470588, 0.12156863],
     [0.05882353, 0.11372549, 0.10980392],
     [0.01960784, 0.0745098 , 0.0745098 ],
     [0.        , 0.03137255, 0.03921569],
     [0.00392157, 0.03921569, 0.05882353],
     [0.00784314, 0.04705882, 0.05490196],
     [0.02352941, 0.05490196, 0.0627451 ],
     [0.00392157, 0.03137255, 0.03921569],
     [0.00784314, 0.03921569, 0.04705882],
     [0.01960784, 0.10196078, 0.09019608],
     [0.00392157, 0.05882353, 0.05882353],
     [0.00784314, 0.04705882, 0.04313725],
     [0.00392157, 0.03921569, 0.04705882],
     [0.        , 0.03529412, 0.04313725],
     [0.01176471, 0.05490196, 0.0627451 ],
     [0.        , 0.04313725, 0.04313725],
     [0.        , 0.01568627, 0.02352941],
     [0.        , 0.02745098, 0.03529412],
     [0.01568627, 0.05098039, 0.05490196],
     [0.02352941, 0.05490196, 0.0627451 ],
     [0.04705882, 0.08235294, 0.08235294],
     [0.09803922, 0.11764706, 0.10980392],
     [0.01960784, 0.03921569, 0.05098039],
     [0.        , 0.01960784, 0.03137255],
     [0.02352941, 0.07058824, 0.07058824],
     [0.02352941, 0.09019608, 0.09019608],
     [0.        , 0.03137255, 0.03921569],
     [0.01176471, 0.03137255, 0.04705882],
     [0.00392157, 0.03529412, 0.04313725],
     [0.00784314, 0.04705882, 0.05490196],
     [0.        , 0.03921569, 0.04705882],
     [0.00392157, 0.05490196, 0.07843137],
     [0.00392157, 0.03921569, 0.05882353],
     [0.01176471, 0.03137255, 0.04705882],
     [0.00392157, 0.03529412, 0.04705882],
     [0.02352941, 0.0627451 , 0.06666667],
     [0.01568627, 0.09019608, 0.0745098 ],
     [0.00784314, 0.04705882, 0.03921569],
     [0.        , 0.01176471, 0.02352941],
     [0.01568627, 0.        , 0.        ],
     [0.01960784, 0.0627451 , 0.07843137],
     [0.00392157, 0.08235294, 0.12941176],
     [0.        , 0.10980392, 0.17254902],
     [0.01960784, 0.10588235, 0.16078431],
     [0.03529412, 0.15294118, 0.18039216],
     [0.02352941, 0.13333333, 0.21568627]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='mirror'
)


cmap_valensole = fscolors.Fractal_colormap(
    colors=[[0.65098039, 0.4627451 , 0.72156863],
     [0.60784314, 0.45882353, 0.69803922],
     [0.58039216, 0.43921569, 0.68627451],
     [0.65490196, 0.4745098 , 0.70588235],
     [0.7372549 , 0.55686275, 0.6745098 ],
     [0.71764706, 0.52941176, 0.62352941],
     [0.7372549 , 0.56470588, 0.65490196],
     [0.78039216, 0.63921569, 0.65490196],
     [0.74509804, 0.57647059, 0.62352941],
     [0.70588235, 0.43137255, 0.59607843],
     [0.63137255, 0.38039216, 0.59215686],
     [0.52941176, 0.3254902 , 0.58431373],
     [0.38039216, 0.23921569, 0.51372549],
     [0.32941176, 0.21176471, 0.4745098 ],
     [0.56862745, 0.38039216, 0.62352941],
     [0.6       , 0.37254902, 0.58823529],
     [0.52941176, 0.34117647, 0.55294118],
     [0.48235294, 0.31764706, 0.56078431],
     [0.5372549 , 0.34117647, 0.57254902],
     [0.57647059, 0.36862745, 0.59607843],
     [0.6745098 , 0.47058824, 0.62745098],
     [0.72156863, 0.59607843, 0.64705882],
     [0.70196078, 0.65098039, 0.69411765],
     [0.69019608, 0.65490196, 0.71764706],
     [0.6745098 , 0.66666667, 0.72941176],
     [0.63921569, 0.67058824, 0.7372549 ],
     [0.72156863, 0.74117647, 0.79607843],
     [0.92941176, 0.94117647, 0.96862745],
     [0.9372549 , 0.94117647, 0.95294118],
     [0.9372549 , 0.94117647, 0.95686275],
     [0.61960784, 0.63921569, 0.71764706],
     [0.56078431, 0.57254902, 0.69803922],
     [0.62352941, 0.61568627, 0.7372549 ],
     [0.47843137, 0.43137255, 0.64705882],
     [0.50196078, 0.40784314, 0.6627451 ],
     [0.4627451 , 0.36078431, 0.58823529],
     [0.56470588, 0.43921569, 0.6745098 ],
     [0.50980392, 0.35294118, 0.59607843],
     [0.54901961, 0.39607843, 0.61960784],
     [0.49411765, 0.34117647, 0.55686275],
     [0.49411765, 0.3254902 , 0.53333333],
     [0.50588235, 0.31764706, 0.5254902 ],
     [0.5372549 , 0.32941176, 0.53333333],
     [0.55686275, 0.34901961, 0.55294118],
     [0.58823529, 0.37647059, 0.58039216],
     [0.59607843, 0.38431373, 0.58823529],
     [0.58431373, 0.36078431, 0.55294118],
     [0.55294118, 0.27843137, 0.49019608],
     [0.53333333, 0.23921569, 0.42745098],
     [0.5254902 , 0.20392157, 0.38431373],
     [0.52941176, 0.19607843, 0.34901961],
     [0.56470588, 0.22352941, 0.36078431],
     [0.61176471, 0.25490196, 0.38039216],
     [0.64313725, 0.27843137, 0.38823529],
     [0.6745098 , 0.28627451, 0.39215686],
     [0.71372549, 0.29411765, 0.36078431],
     [0.76470588, 0.34509804, 0.38039216],
     [0.76078431, 0.33333333, 0.36078431],
     [0.74509804, 0.30980392, 0.34117647],
     [0.77254902, 0.32156863, 0.3372549 ],
     [0.77647059, 0.3254902 , 0.31372549],
     [0.78823529, 0.32941176, 0.28627451],
     [0.80392157, 0.33333333, 0.27058824],
     [0.83529412, 0.35686275, 0.2745098 ],
     [0.8627451 , 0.38823529, 0.27058824],
     [0.84705882, 0.37254902, 0.25490196],
     [0.83921569, 0.35686275, 0.24313725],
     [0.85098039, 0.38431373, 0.25882353],
     [0.87058824, 0.42352941, 0.29019608],
     [0.90980392, 0.4627451 , 0.30980392],
     [0.95294118, 0.54117647, 0.32941176],
     [0.94901961, 0.51372549, 0.33333333],
     [0.9254902 , 0.49019608, 0.30980392],
     [0.9372549 , 0.50196078, 0.31764706],
     [0.95294118, 0.52941176, 0.33333333],
     [0.95686275, 0.54117647, 0.34901961],
     [0.97254902, 0.56078431, 0.34117647],
     [0.94901961, 0.51372549, 0.32156863],
     [0.95294118, 0.50588235, 0.30588235],
     [0.94509804, 0.49019608, 0.25882353],
     [0.94901961, 0.49019608, 0.24705882],
     [0.96470588, 0.51764706, 0.25490196],
     [0.96078431, 0.59607843, 0.20784314],
     [0.94901961, 0.62352941, 0.20392157],
     [0.95294118, 0.58039216, 0.25490196],
     [0.95686275, 0.57254902, 0.27058824],
     [0.96078431, 0.60392157, 0.30196078],
     [0.96078431, 0.68627451, 0.28627451],
     [0.94509804, 0.77647059, 0.12941176],
     [0.94117647, 0.83921569, 0.0627451 ],
     [0.95294118, 0.89019608, 0.04313725],
     [0.90588235, 0.89411765, 0.        ],
     [0.94117647, 0.92941176, 0.        ],
     [0.95686275, 0.9254902 , 0.01960784],
     [0.95294118, 0.80392157, 0.0627451 ],
     [0.94117647, 0.72941176, 0.10588235],
     [0.94117647, 0.83921569, 0.03921569],
     [0.94117647, 0.93333333, 0.02745098],
     [0.9372549 , 0.91764706, 0.05882353],
     [0.94901961, 0.92941176, 0.        ],
     [0.92156863, 0.90196078, 0.14901961],
     [0.98431373, 0.97647059, 0.58039216],
     [0.97254902, 0.95294118, 0.81176471],
     [0.96862745, 0.95686275, 0.83137255],
     [0.97647059, 0.95686275, 0.79607843],
     [0.98039216, 0.94901961, 0.84705882],
     [0.96470588, 0.81568627, 0.5254902 ],
     [0.96862745, 0.63921569, 0.49803922],
     [0.96862745, 0.64705882, 0.56862745],
     [0.98431373, 0.63921569, 0.62352941],
     [0.96862745, 0.65490196, 0.63529412],
     [0.92941176, 0.64313725, 0.61176471],
     [0.62745098, 0.31764706, 0.31764706],
     [0.01960784, 0.01176471, 0.        ],
     [0.02352941, 0.01176471, 0.        ],
     [0.08627451, 0.00784314, 0.01176471],
     [0.08235294, 0.01960784, 0.00784314],
     [0.31372549, 0.11372549, 0.25882353],
     [0.5254902 , 0.21568627, 0.50980392],
     [0.51764706, 0.21960784, 0.54117647],
     [0.38823529, 0.14117647, 0.47058824],
     [0.38823529, 0.15686275, 0.45490196],
     [0.29411765, 0.12156863, 0.38431373],
     [0.25882353, 0.12156863, 0.4       ],
     [0.2627451 , 0.11764706, 0.44705882],
     [0.19215686, 0.0745098 , 0.36862745],
     [0.19607843, 0.08627451, 0.35294118],
     [0.31764706, 0.16470588, 0.5254902 ],
     [0.25882353, 0.11372549, 0.47843137],
     [0.29411765, 0.13333333, 0.46666667],
     [0.26666667, 0.09803922, 0.4745098 ],
     [0.21960784, 0.0627451 , 0.3372549 ],
     [0.21176471, 0.09803922, 0.34509804],
     [0.27843137, 0.16078431, 0.42352941],
     [0.23137255, 0.10196078, 0.41960784],
     [0.2       , 0.06666667, 0.43529412],
     [0.24705882, 0.12156863, 0.42352941],
     [0.12156863, 0.02352941, 0.2       ],
     [0.09803922, 0.03921569, 0.19607843],
     [0.09411765, 0.03137255, 0.21176471],
     [0.24705882, 0.18431373, 0.5254902 ],
     [0.23921569, 0.14509804, 0.62745098],
     [0.17254902, 0.10980392, 0.50588235],
     [0.17647059, 0.09803922, 0.48627451],
     [0.18431373, 0.11764706, 0.50980392],
     [0.12941176, 0.06666667, 0.3372549 ],
     [0.05882353, 0.01960784, 0.29019608],
     [0.13333333, 0.10588235, 0.31764706],
     [0.2627451 , 0.21960784, 0.50588235],
     [0.16078431, 0.12156863, 0.36862745],
     [0.21960784, 0.18039216, 0.43137255],
     [0.16078431, 0.1372549 , 0.38431373],
     [0.15686275, 0.15686275, 0.36078431],
     [0.20784314, 0.16862745, 0.48235294],
     [0.09803922, 0.05490196, 0.38431373],
     [0.2627451 , 0.21960784, 0.61568627],
     [0.18039216, 0.10588235, 0.50588235],
     [0.21176471, 0.16862745, 0.61568627],
     [0.28627451, 0.20784314, 0.71764706],
     [0.29019608, 0.20784314, 0.69803922],
     [0.21176471, 0.16470588, 0.47058824],
     [0.17254902, 0.10588235, 0.44705882],
     [0.2745098 , 0.21176471, 0.50980392],
     [0.2       , 0.13333333, 0.43529412],
     [0.20784314, 0.15686275, 0.4745098 ],
     [0.29019608, 0.22352941, 0.63137255],
     [0.30980392, 0.20784314, 0.63529412],
     [0.29019608, 0.18823529, 0.67843137],
     [0.30196078, 0.19215686, 0.65882353],
     [0.18431373, 0.15686275, 0.52156863],
     [0.39215686, 0.35294118, 0.74509804],
     [0.15294118, 0.10588235, 0.36470588],
     [0.1254902 , 0.08235294, 0.34901961],
     [0.39607843, 0.37647059, 0.40784314],
     [0.29019608, 0.20392157, 0.75294118],
     [0.18431373, 0.16470588, 0.43529412],
     [0.21568627, 0.19215686, 0.6       ],
     [0.17254902, 0.17254902, 0.44313725],
     [0.05490196, 0.03921569, 0.29411765],
     [0.14117647, 0.12156863, 0.4627451 ],
     [0.12941176, 0.11764706, 0.38039216],
     [0.10980392, 0.10980392, 0.36470588],
     [0.22745098, 0.26666667, 0.28235294],
     [0.19215686, 0.22745098, 0.23529412],
     [0.12156863, 0.10980392, 0.29411765],
     [0.15686275, 0.15686275, 0.42352941],
     [0.17254902, 0.21176471, 0.21960784],
     [0.07058824, 0.0627451 , 0.31764706],
     [0.09803922, 0.14117647, 0.07843137],
     [0.0627451 , 0.07058824, 0.16470588],
     [0.05098039, 0.06666667, 0.18431373],
     [0.0745098 , 0.08235294, 0.24705882],
     [0.02745098, 0.06666667, 0.11372549],
     [0.04705882, 0.05490196, 0.21176471],
     [0.        , 0.00392157, 0.07058824],
     [0.14901961, 0.15294118, 0.41176471],
     [0.34509804, 0.29019608, 0.52941176],
     [0.31764706, 0.25882353, 0.51764706],
     [0.16078431, 0.17647059, 0.42745098],
     [0.30588235, 0.25490196, 0.7372549 ],
     [0.22352941, 0.21960784, 0.50588235],
     [0.28235294, 0.25098039, 0.4627451 ],
     [0.25882353, 0.2745098 , 0.50980392],
     [0.32941176, 0.34509804, 0.68235294],
     [0.28627451, 0.30980392, 0.39215686],
     [0.24705882, 0.28627451, 0.49803922],
     [0.18431373, 0.18431373, 0.50196078],
     [0.27843137, 0.2745098 , 0.68627451],
     [0.19607843, 0.14509804, 0.49803922],
     [0.2627451 , 0.26666667, 0.68627451],
     [0.15686275, 0.16470588, 0.38431373],
     [0.35294118, 0.3372549 , 0.76470588],
     [0.24705882, 0.30588235, 0.38431373],
     [0.15686275, 0.19215686, 0.43529412],
     [0.22745098, 0.21568627, 0.55294118],
     [0.21960784, 0.18823529, 0.59607843],
     [0.31372549, 0.24705882, 0.6745098 ],
     [0.21960784, 0.14901961, 0.60392157],
     [0.03137255, 0.01568627, 0.11372549],
     [0.00784314, 0.        , 0.38823529],
     [0.02745098, 0.03137255, 0.24705882],
     [0.05882353, 0.07843137, 0.25490196],
     [0.01568627, 0.0627451 , 0.15686275],
     [0.23529412, 0.24705882, 0.47058824],
     [0.25098039, 0.34901961, 0.45098039],
     [0.03529412, 0.15294118, 0.06666667],
     [0.15294118, 0.17647059, 0.27843137],
     [0.35686275, 0.25490196, 0.37647059],
     [0.14509804, 0.16078431, 0.24313725],
     [0.02745098, 0.0745098 , 0.05098039],
     [0.07843137, 0.10980392, 0.20784314],
     [0.00392157, 0.02352941, 0.04705882],
     [0.19607843, 0.14509804, 0.31372549],
     [0.01568627, 0.03137255, 0.01176471],
     [0.1372549 , 0.18039216, 0.09019608],
     [0.05098039, 0.07058824, 0.21176471],
     [0.0745098 , 0.0745098 , 0.12156863],
     [0.06666667, 0.08627451, 0.22745098],
     [0.01960784, 0.01568627, 0.11372549],
     [0.37647059, 0.3254902 , 0.81176471],
     [0.2627451 , 0.17254902, 0.56078431],
     [0.01960784, 0.00392157, 0.05490196],
     [0.10980392, 0.11372549, 0.09411765],
     [0.42352941, 0.35686275, 0.74901961],
     [0.21960784, 0.20392157, 0.55686275],
     [0.        , 0.00784314, 0.01568627],
     [0.        , 0.02352941, 0.00392157],
     [0.14509804, 0.14117647, 0.2745098 ],
     [0.03529412, 0.07058824, 0.0627451 ],
     [0.08235294, 0.10980392, 0.37254902],
     [0.30196078, 0.34509804, 0.4627451 ],
     [0.00392157, 0.00392157, 0.1372549 ],
     [0.20392157, 0.20784314, 0.65490196],
     [0.23529412, 0.1372549 , 0.52156863],
     [0.08627451, 0.0745098 , 0.31372549],
     [0.18431373, 0.11764706, 0.29803922]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='mirror'
)


cmap_stellar = fscolors.Fractal_colormap(
    colors=[[0.02745098, 0.55294118, 0.74117647],
     [0.00784314, 0.49803922, 0.72941176],
     [0.10980392, 0.58431373, 0.83921569],
     [0.01960784, 0.49411765, 0.7372549 ],
     [0.03137255, 0.57254902, 0.78431373],
     [0.00784314, 0.51764706, 0.73333333],
     [0.07058824, 0.58039216, 0.80784314],
     [0.03921569, 0.52156863, 0.77647059],
     [0.14117647, 0.57254902, 0.8745098 ],
     [0.02352941, 0.37254902, 0.72941176],
     [0.08235294, 0.43921569, 0.76078431],
     [0.01960784, 0.47843137, 0.72941176],
     [0.03921569, 0.52941176, 0.76470588],
     [0.02745098, 0.58431373, 0.82745098],
     [0.06666667, 0.70980392, 0.84313725],
     [0.04705882, 0.66666667, 0.85490196],
     [0.24313725, 0.78431373, 0.97254902],
     [0.38039216, 0.77254902, 0.95686275],
     [0.35294118, 0.56078431, 0.76862745],
     [0.5254902 , 0.58431373, 0.81960784],
     [0.5372549 , 0.49019608, 0.76078431],
     [0.63137255, 0.5372549 , 0.81568627],
     [0.64313725, 0.51372549, 0.81176471],
     [0.62745098, 0.49019608, 0.77254902],
     [0.89411765, 0.76470588, 0.88627451],
     [0.95686275, 0.85490196, 0.76862745],
     [0.98039216, 0.97647059, 0.80392157],
     [0.84705882, 0.85882353, 0.81568627],
     [0.69019608, 0.70588235, 0.78431373],
     [0.7254902 , 0.72941176, 0.85098039],
     [0.65882353, 0.63529412, 0.78431373],
     [0.56078431, 0.71372549, 0.80392157],
     [0.57647059, 0.65490196, 0.8       ],
     [0.69803922, 0.64705882, 0.81960784],
     [0.90196078, 0.63137255, 0.83921569],
     [0.74117647, 0.76470588, 0.84313725],
     [0.70588235, 0.8627451 , 0.90196078],
     [0.6745098 , 0.75294118, 0.83529412],
     [0.72941176, 0.76862745, 0.83921569],
     [0.84705882, 0.84313725, 0.81568627],
     [0.94117647, 0.89411765, 0.85490196],
     [0.87058824, 0.78823529, 0.83529412],
     [0.84705882, 0.74509804, 0.8       ],
     [0.92941176, 0.79215686, 0.83529412],
     [0.98039216, 0.81568627, 0.85098039],
     [0.97647059, 0.81176471, 0.82745098],
     [0.97254902, 0.83529412, 0.85098039],
     [0.9254902 , 0.80784314, 0.82352941],
     [0.96862745, 0.87843137, 0.84313725],
     [0.97647059, 0.89019608, 0.84705882],
     [0.92156863, 0.84313725, 0.83921569],
     [0.89019608, 0.76862745, 0.83921569],
     [0.84313725, 0.65882353, 0.80784314],
     [0.75686275, 0.60392157, 0.76862745],
     [0.54509804, 0.56078431, 0.74117647],
     [0.45882353, 0.65490196, 0.7372549 ],
     [0.56470588, 0.76078431, 0.82352941],
     [0.67058824, 0.8       , 0.8627451 ],
     [0.70196078, 0.79607843, 0.84313725],
     [0.76862745, 0.79215686, 0.83921569],
     [0.6627451 , 0.81176471, 0.83137255],
     [0.49019608, 0.82352941, 0.83137255],
     [0.4745098 , 0.92156863, 0.9372549 ],
     [0.2       , 0.81568627, 0.83529412],
     [0.01568627, 0.82745098, 0.83137255],
     [0.05882353, 0.78431373, 0.83921569],
     [0.07058824, 0.74509804, 0.83529412],
     [0.1372549 , 0.76078431, 0.84313725],
     [0.49411765, 0.78039216, 0.85098039],
     [0.79607843, 0.85490196, 0.88235294],
     [0.79607843, 0.84313725, 0.85882353],
     [0.6745098 , 0.78823529, 0.80784314],
     [0.75294118, 0.83137255, 0.84705882],
     [0.9254902 , 0.84313725, 0.83529412],
     [0.89019608, 0.88235294, 0.85882353],
     [0.56078431, 0.82745098, 0.83921569],
     [0.16078431, 0.79607843, 0.85098039],
     [0.34117647, 0.82745098, 0.91372549],
     [0.43529412, 0.82745098, 0.89411765],
     [0.49803922, 0.85098039, 0.87843137],
     [0.43529412, 0.85098039, 0.89019608],
     [0.20392157, 0.74901961, 0.80784314],
     [0.10588235, 0.79215686, 0.83921569],
     [0.04313725, 0.82745098, 0.8627451 ],
     [0.04705882, 0.77254902, 0.85882353],
     [0.0627451 , 0.6627451 , 0.80392157],
     [0.04313725, 0.56862745, 0.72156863],
     [0.04313725, 0.44705882, 0.67843137],
     [0.19607843, 0.46666667, 0.74117647],
     [0.00392157, 0.19607843, 0.49019608],
     [0.05490196, 0.29411765, 0.58039216],
     [0.31764706, 0.56862745, 0.85098039],
     [0.01960784, 0.25490196, 0.52941176],
     [0.02745098, 0.31372549, 0.56470588],
     [0.31372549, 0.74901961, 0.91372549],
     [0.11764706, 0.63529412, 0.77254902],
     [0.41568627, 0.89803922, 0.97647059],
     [0.00784314, 0.45098039, 0.70588235],
     [0.        , 0.43921569, 0.71764706],
     [0.01176471, 0.42352941, 0.70588235],
     [0.02352941, 0.43137255, 0.69803922],
     [0.01568627, 0.38431373, 0.62745098],
     [0.09803922, 0.43137255, 0.76470588],
     [0.02745098, 0.37254902, 0.75294118],
     [0.12941176, 0.54117647, 0.81568627],
     [0.11372549, 0.55294118, 0.73333333],
     [0.16078431, 0.59215686, 0.7372549 ],
     [0.14901961, 0.57254902, 0.73333333],
     [0.19215686, 0.60392157, 0.79607843],
     [0.11764706, 0.49803922, 0.71764706],
     [0.23137255, 0.58039216, 0.76078431],
     [0.34117647, 0.61960784, 0.83137255],
     [0.38823529, 0.49019608, 0.80784314],
     [0.43137255, 0.44705882, 0.79607843],
     [0.49019608, 0.46666667, 0.81176471],
     [0.43137255, 0.41960784, 0.72156863],
     [0.5372549 , 0.54117647, 0.82352941],
     [0.38431373, 0.41960784, 0.71764706],
     [0.34509804, 0.41568627, 0.72941176],
     [0.30980392, 0.39607843, 0.68235294],
     [0.48627451, 0.61568627, 0.84313725],
     [0.4       , 0.58039216, 0.78431373],
     [0.31764706, 0.57254902, 0.72156863],
     [0.23921569, 0.60392157, 0.76470588],
     [0.34901961, 0.72941176, 0.85882353],
     [0.29411765, 0.63529412, 0.79215686],
     [0.42352941, 0.83921569, 0.89411765],
     [0.39607843, 0.7254902 , 0.8627451 ],
     [0.30196078, 0.60392157, 0.75294118],
     [0.44313725, 0.76862745, 0.81960784],
     [0.43137255, 0.75686275, 0.81176471],
     [0.43137255, 0.78823529, 0.85490196],
     [0.31372549, 0.72156863, 0.78039216],
     [0.32156863, 0.71764706, 0.77647059],
     [0.41176471, 0.75686275, 0.82745098],
     [0.40784314, 0.73333333, 0.78823529],
     [0.43921569, 0.71764706, 0.74901961],
     [0.55686275, 0.75686275, 0.78823529],
     [0.63137255, 0.76078431, 0.82352941],
     [0.60392157, 0.70196078, 0.76078431],
     [0.61176471, 0.74509804, 0.78431373],
     [0.61960784, 0.80784314, 0.83137255],
     [0.58431373, 0.79607843, 0.80784314],
     [0.59215686, 0.83137255, 0.83921569],
     [0.54509804, 0.76078431, 0.76470588],
     [0.65882353, 0.85490196, 0.85490196],
     [0.52156863, 0.71372549, 0.71764706],
     [0.64313725, 0.82745098, 0.79215686],
     [0.83137255, 0.98823529, 0.90196078],
     [0.60784314, 0.75294118, 0.72941176],
     [0.6627451 , 0.76862745, 0.76862745],
     [0.72156863, 0.77647059, 0.75686275],
     [0.65490196, 0.69803922, 0.67843137],
     [0.49803922, 0.60392157, 0.65882353],
     [0.47843137, 0.55686275, 0.6627451 ],
     [0.64313725, 0.69019608, 0.78431373],
     [0.81176471, 0.83529412, 0.83921569],
     [0.89019608, 0.87843137, 0.85882353],
     [0.64705882, 0.62745098, 0.63921569],
     [0.72941176, 0.70980392, 0.76470588],
     [0.70980392, 0.69411765, 0.74901961],
     [0.70588235, 0.66666667, 0.72156863],
     [0.78431373, 0.70980392, 0.76862745],
     [0.81960784, 0.70588235, 0.76470588],
     [0.8627451 , 0.75294118, 0.74901961],
     [0.86666667, 0.75686275, 0.74509804],
     [0.85490196, 0.72941176, 0.7372549 ],
     [0.90980392, 0.77647059, 0.8       ],
     [0.86666667, 0.70980392, 0.76470588],
     [0.84705882, 0.6745098 , 0.74509804],
     [0.90588235, 0.74901961, 0.76862745],
     [0.77647059, 0.67058824, 0.73333333],
     [0.71764706, 0.65098039, 0.73333333],
     [0.70980392, 0.63921569, 0.69411765],
     [0.92941176, 0.82745098, 0.8745098 ],
     [0.76078431, 0.61568627, 0.69411765],
     [0.76862745, 0.61176471, 0.70588235],
     [0.76862745, 0.59607843, 0.69803922],
     [0.79607843, 0.61568627, 0.7254902 ],
     [0.79215686, 0.61568627, 0.72156863],
     [0.79215686, 0.63921569, 0.74117647],
     [0.74901961, 0.59607843, 0.68627451],
     [0.78039216, 0.63137255, 0.71764706],
     [0.76862745, 0.62352941, 0.71764706],
     [0.68627451, 0.54901961, 0.65490196],
     [0.63137255, 0.49803922, 0.62352941],
     [0.6       , 0.49411765, 0.61176471],
     [0.65882353, 0.54117647, 0.65098039],
     [0.6745098 , 0.50588235, 0.59215686],
     [0.87058824, 0.67058824, 0.75294118],
     [0.71764706, 0.3254902 , 0.47058824],
     [0.74509804, 0.35686275, 0.50196078],
     [0.76862745, 0.5372549 , 0.65490196],
     [0.68627451, 0.45490196, 0.62352941],
     [0.63529412, 0.43529412, 0.61960784],
     [0.55294118, 0.36862745, 0.54117647],
     [0.52941176, 0.32156863, 0.52156863],
     [0.6627451 , 0.40784314, 0.61960784],
     [0.67058824, 0.37647059, 0.5254902 ],
     [0.84313725, 0.62745098, 0.74117647],
     [0.6745098 , 0.51764706, 0.61176471],
     [0.77254902, 0.61176471, 0.70588235],
     [0.73333333, 0.55686275, 0.64705882],
     [0.71372549, 0.55294118, 0.68235294],
     [0.72156863, 0.48627451, 0.57254902],
     [0.61960784, 0.39607843, 0.45098039],
     [0.59607843, 0.32156863, 0.4745098 ],
     [0.57254902, 0.21960784, 0.42352941],
     [0.49803922, 0.15686275, 0.36862745],
     [0.36470588, 0.07058824, 0.3254902 ],
     [0.31372549, 0.12156863, 0.34901961],
     [0.36078431, 0.16470588, 0.44313725],
     [0.32156863, 0.07058824, 0.37254902],
     [0.6627451 , 0.44313725, 0.6745098 ],
     [0.42352941, 0.2       , 0.41568627],
     [0.29411765, 0.06666667, 0.28627451],
     [0.30196078, 0.12156863, 0.39215686],
     [0.12156863, 0.01960784, 0.30980392],
     [0.15686275, 0.08235294, 0.42352941],
     [0.12941176, 0.03529412, 0.35686275],
     [0.08235294, 0.        , 0.29019608],
     [0.1372549 , 0.05882353, 0.3372549 ],
     [0.41568627, 0.30196078, 0.54901961],
     [0.19607843, 0.03921569, 0.2745098 ],
     [0.19607843, 0.03529412, 0.33333333],
     [0.18039216, 0.02745098, 0.31372549],
     [0.32156863, 0.16862745, 0.41176471],
     [0.19607843, 0.03137255, 0.27843137],
     [0.18431373, 0.01176471, 0.32156863],
     [0.19215686, 0.01176471, 0.34117647],
     [0.21568627, 0.02352941, 0.34509804],
     [0.22352941, 0.04705882, 0.34901961],
     [0.13333333, 0.01568627, 0.29019608],
     [0.36470588, 0.19607843, 0.41568627],
     [0.14509804, 0.01176471, 0.24313725],
     [0.05490196, 0.02352941, 0.31764706],
     [0.05490196, 0.01568627, 0.29019608],
     [0.15294118, 0.01960784, 0.21176471],
     [0.30196078, 0.11372549, 0.28627451],
     [0.07058824, 0.03529412, 0.29019608],
     [0.17254902, 0.05882353, 0.33333333],
     [0.15686275, 0.01176471, 0.29019608],
     [0.21176471, 0.02745098, 0.3254902 ],
     [0.25098039, 0.01568627, 0.32941176],
     [0.24705882, 0.00784314, 0.3254902 ],
     [0.20392157, 0.00392157, 0.30588235],
     [0.50196078, 0.33333333, 0.62352941],
     [0.14901961, 0.02352941, 0.31764706],
     [0.1254902 , 0.01568627, 0.2745098 ],
     [0.17647059, 0.01960784, 0.30588235],
     [0.05882353, 0.03529412, 0.30588235],
     [0.07058824, 0.00392157, 0.30980392],
     [0.04313725, 0.02352941, 0.31372549],
     [0.12941176, 0.05098039, 0.38431373],
     [0.03137255, 0.01176471, 0.34117647],
     [0.00392157, 0.00392157, 0.31764706]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='mirror'
)

cmap_citrus = fscolors.Fractal_colormap(
    colors=[[0.96078431, 0.83137255, 0.77254902],
     [0.34901961, 0.01568627, 0.02745098],
     [0.27843137, 0.        , 0.02745098],
     [0.41176471, 0.00392157, 0.04705882],
     [0.44705882, 0.        , 0.05882353],
     [0.71372549, 0.14509804, 0.20392157],
     [0.79607843, 0.26666667, 0.21176471],
     [0.92941176, 0.54117647, 0.47843137],
     [0.90588235, 0.5372549 , 0.47058824],
     [0.89803922, 0.49411765, 0.43529412],
     [0.91372549, 0.51764706, 0.50196078],
     [0.79215686, 0.41176471, 0.40392157],
     [0.84705882, 0.45098039, 0.44705882],
     [0.86666667, 0.44705882, 0.41960784],
     [0.89803922, 0.54509804, 0.56862745],
     [0.98431373, 0.68627451, 0.72941176],
     [0.78039216, 0.30980392, 0.30588235],
     [0.90196078, 0.4745098 , 0.4745098 ],
     [0.76862745, 0.38823529, 0.43529412],
     [0.95294118, 0.74117647, 0.75294118],
     [0.80392157, 0.4       , 0.39607843],
     [0.84313725, 0.38823529, 0.36078431],
     [0.80392157, 0.26666667, 0.26666667],
     [0.90980392, 0.51764706, 0.52156863],
     [0.89019608, 0.58823529, 0.58431373],
     [0.81176471, 0.3372549 , 0.29803922],
     [0.71372549, 0.13333333, 0.10588235],
     [0.72156863, 0.18823529, 0.18431373],
     [0.81176471, 0.35294118, 0.35686275],
     [0.82352941, 0.40784314, 0.41960784],
     [0.84313725, 0.30980392, 0.28235294],
     [0.8745098 , 0.49411765, 0.48627451],
     [0.99607843, 0.69411765, 0.73333333],
     [0.70980392, 0.16470588, 0.14117647],
     [0.85490196, 0.27843137, 0.2627451 ],
     [0.89019608, 0.45882353, 0.43137255],
     [0.84313725, 0.30196078, 0.25490196],
     [0.81568627, 0.27843137, 0.22745098],
     [0.92941176, 0.40392157, 0.37254902],
     [0.76078431, 0.22352941, 0.21176471],
     [0.94509804, 0.41960784, 0.41568627],
     [0.75294118, 0.20392157, 0.2       ],
     [0.85490196, 0.36470588, 0.34901961],
     [0.79607843, 0.20784314, 0.18823529],
     [0.85098039, 0.27843137, 0.2745098 ],
     [0.83529412, 0.18431373, 0.2       ],
     [0.90196078, 0.34117647, 0.3254902 ],
     [0.81176471, 0.41960784, 0.41960784],
     [0.90980392, 0.56470588, 0.6       ],
     [0.87058824, 0.43529412, 0.48235294],
     [0.96862745, 0.76078431, 0.68627451],
     [0.94117647, 0.8745098 , 0.76862745],
     [0.99607843, 0.97647059, 0.89019608],
     [0.97647059, 0.9254902 , 0.85882353],
     [0.96862745, 0.90196078, 0.80784314],
     [0.96862745, 0.85882353, 0.74509804],
     [0.98039216, 0.89411765, 0.76078431],
     [0.97647059, 0.85490196, 0.62745098],
     [0.9254902 , 0.72941176, 0.23921569],
     [0.83137255, 0.6745098 , 0.4       ],
     [0.82352941, 0.74901961, 0.52941176],
     [0.82745098, 0.75294118, 0.56078431],
     [0.8627451 , 0.79215686, 0.65490196],
     [0.69803922, 0.63921569, 0.30196078],
     [0.9254902 , 0.9254902 , 0.56862745],
     [0.79215686, 0.80784314, 0.21176471],
     [0.78823529, 0.81568627, 0.20784314],
     [0.83529412, 0.8627451 , 0.4       ],
     [0.8745098 , 0.90980392, 0.41176471],
     [0.80392157, 0.82745098, 0.24705882],
     [0.78431373, 0.81176471, 0.20392157],
     [0.78431373, 0.81960784, 0.20784314],
     [0.79215686, 0.82745098, 0.23529412],
     [0.75686275, 0.79607843, 0.18039216],
     [0.77254902, 0.81568627, 0.19607843],
     [0.75686275, 0.80392157, 0.18431373],
     [0.72156863, 0.78039216, 0.18431373],
     [0.79607843, 0.85098039, 0.28627451],
     [0.76078431, 0.8       , 0.19607843],
     [0.81568627, 0.8627451 , 0.29411765],
     [0.77254902, 0.82352941, 0.20392157],
     [0.78431373, 0.83921569, 0.21960784],
     [0.77647059, 0.83529412, 0.20392157],
     [0.75294118, 0.81568627, 0.18039216],
     [0.76078431, 0.82352941, 0.19215686],
     [0.76470588, 0.82745098, 0.19607843],
     [0.78823529, 0.84705882, 0.2       ],
     [0.82745098, 0.89411765, 0.28235294],
     [0.77647059, 0.83137255, 0.21176471],
     [0.79607843, 0.8627451 , 0.23529412],
     [0.75686275, 0.82352941, 0.17254902],
     [0.82352941, 0.88235294, 0.30196078],
     [0.76470588, 0.82352941, 0.20392157],
     [0.81176471, 0.8627451 , 0.22352941],
     [0.75686275, 0.80784314, 0.16078431],
     [0.78039216, 0.82745098, 0.18039216],
     [0.79215686, 0.83921569, 0.25882353],
     [0.80784314, 0.84313725, 0.21176471],
     [0.81568627, 0.85490196, 0.24313725],
     [0.85490196, 0.89803922, 0.41176471],
     [0.88627451, 0.91764706, 0.45490196],
     [0.81568627, 0.83921569, 0.21960784],
     [0.92941176, 0.92156863, 0.7372549 ],
     [0.9254902 , 0.91764706, 0.74901961],
     [0.94509804, 0.92941176, 0.78039216],
     [0.94901961, 0.91764706, 0.76470588],
     [0.9254902 , 0.89803922, 0.69019608],
     [0.91764706, 0.89019608, 0.70196078],
     [0.92156863, 0.89803922, 0.71372549],
     [0.9254902 , 0.89803922, 0.70980392],
     [0.95686275, 0.90980392, 0.70196078],
     [0.93333333, 0.85882353, 0.60392157],
     [0.9372549 , 0.83921569, 0.49019608],
     [0.91764706, 0.81568627, 0.36470588],
     [0.89803922, 0.78823529, 0.25882353],
     [0.89411765, 0.79215686, 0.21568627],
     [0.91764706, 0.80784314, 0.23921569],
     [0.93333333, 0.82352941, 0.29411765],
     [0.9372549 , 0.81960784, 0.3372549 ],
     [0.92156863, 0.82745098, 0.34509804],
     [0.91372549, 0.81176471, 0.32941176],
     [0.92156863, 0.81176471, 0.30980392],
     [0.93333333, 0.84705882, 0.4       ],
     [0.91372549, 0.80784314, 0.27843137],
     [0.95686275, 0.85098039, 0.32941176],
     [0.9254902 , 0.83529412, 0.3254902 ],
     [0.9254902 , 0.83137255, 0.33333333],
     [0.91764706, 0.81960784, 0.27843137],
     [0.9254902 , 0.82745098, 0.27058824],
     [0.93333333, 0.83921569, 0.3372549 ],
     [0.96078431, 0.86666667, 0.39215686],
     [0.94509804, 0.8627451 , 0.41568627],
     [0.94509804, 0.85882353, 0.43529412],
     [0.94509804, 0.8627451 , 0.41960784],
     [0.92156863, 0.83137255, 0.34117647],
     [0.90980392, 0.82352941, 0.32941176],
     [0.92941176, 0.83921569, 0.35686275],
     [0.92941176, 0.8627451 , 0.38823529],
     [0.96078431, 0.90196078, 0.49019608],
     [0.98823529, 0.98823529, 0.83529412],
     [0.98431373, 0.99607843, 0.8745098 ],
     [0.98039216, 0.99607843, 0.85098039],
     [0.98039216, 0.99607843, 0.78823529],
     [0.98039216, 0.99607843, 0.83921569],
     [0.91764706, 0.9372549 , 0.65490196],
     [0.89803922, 0.85490196, 0.31764706],
     [0.66666667, 0.61176471, 0.19215686],
     [0.04313725, 0.0745098 , 0.05490196],
     [0.03921569, 0.05882353, 0.03529412],
     [0.03137255, 0.05882353, 0.03137255],
     [0.05098039, 0.0745098 , 0.02352941],
     [0.10588235, 0.12156863, 0.03137255],
     [0.11764706, 0.15294118, 0.03137255],
     [0.14901961, 0.17647059, 0.03529412],
     [0.18039216, 0.23921569, 0.05882353],
     [0.23137255, 0.31372549, 0.09019608],
     [0.19607843, 0.27058824, 0.05098039],
     [0.23137255, 0.3372549 , 0.08235294],
     [0.25098039, 0.36078431, 0.08627451],
     [0.24313725, 0.34901961, 0.08627451],
     [0.23921569, 0.35294118, 0.09019608],
     [0.20392157, 0.32156863, 0.05882353],
     [0.23529412, 0.35686275, 0.08627451],
     [0.25882353, 0.38823529, 0.09019608],
     [0.24705882, 0.39215686, 0.08235294],
     [0.27058824, 0.41568627, 0.10588235],
     [0.26666667, 0.41176471, 0.09803922],
     [0.26666667, 0.41176471, 0.09803922],
     [0.25490196, 0.40784314, 0.09019608],
     [0.25098039, 0.41960784, 0.09411765],
     [0.27058824, 0.41960784, 0.10196078],
     [0.29411765, 0.42745098, 0.11372549],
     [0.27058824, 0.40392157, 0.09019608],
     [0.28627451, 0.43529412, 0.09803922],
     [0.27843137, 0.42745098, 0.09803922],
     [0.27843137, 0.42352941, 0.10980392],
     [0.29411765, 0.40784314, 0.11372549],
     [0.24705882, 0.33333333, 0.06666667],
     [0.28235294, 0.31372549, 0.04705882],
     [0.42745098, 0.43921569, 0.15294118],
     [0.24705882, 0.26666667, 0.06666667],
     [0.27058824, 0.31764706, 0.09019608],
     [0.2       , 0.27058824, 0.02745098],
     [0.2745098 , 0.3254902 , 0.07843137],
     [0.3254902 , 0.34117647, 0.10980392],
     [0.30588235, 0.32941176, 0.09019608],
     [0.27058824, 0.30980392, 0.08235294],
     [0.23921569, 0.29019608, 0.07058824],
     [0.23137255, 0.28235294, 0.07058824],
     [0.21176471, 0.24313725, 0.05098039],
     [0.21960784, 0.24313725, 0.06666667],
     [0.18431373, 0.21176471, 0.06666667],
     [0.75294118, 0.79607843, 0.33333333],
     [0.90588235, 0.94509804, 0.63921569],
     [0.89411765, 0.91764706, 0.46666667],
     [0.81960784, 0.85098039, 0.24705882],
     [0.77647059, 0.81568627, 0.30196078],
     [0.80392157, 0.81960784, 0.20784314],
     [0.77254902, 0.81176471, 0.28235294],
     [0.85882353, 0.88627451, 0.49019608],
     [0.82745098, 0.85882353, 0.39607843],
     [0.81568627, 0.85098039, 0.28235294],
     [0.81960784, 0.84705882, 0.3372549 ],
     [0.82745098, 0.85882353, 0.39607843],
     [0.80392157, 0.83529412, 0.28235294],
     [0.78431373, 0.81960784, 0.20392157],
     [0.80392157, 0.83921569, 0.25490196],
     [0.78823529, 0.83921569, 0.23529412],
     [0.81176471, 0.85098039, 0.29411765],
     [0.76862745, 0.80392157, 0.23137255],
     [0.73333333, 0.78823529, 0.25882353],
     [0.8745098 , 0.90196078, 0.4627451 ],
     [0.9372549 , 0.95686275, 0.58431373],
     [0.77647059, 0.8       , 0.18039216],
     [0.78823529, 0.81960784, 0.23137255],
     [0.76078431, 0.79607843, 0.18823529],
     [0.78431373, 0.83529412, 0.25882353],
     [0.79607843, 0.82352941, 0.23137255],
     [0.78823529, 0.83529412, 0.30588235],
     [0.76470588, 0.80392157, 0.23529412],
     [0.81960784, 0.85098039, 0.4       ],
     [0.77254902, 0.80392157, 0.25882353],
     [0.80392157, 0.85098039, 0.31372549],
     [0.8627451 , 0.90196078, 0.41960784],
     [0.77254902, 0.81568627, 0.22352941],
     [0.83529412, 0.87843137, 0.37254902],
     [0.8       , 0.84313725, 0.36862745],
     [0.88235294, 0.92941176, 0.58431373],
     [0.84313725, 0.89803922, 0.48627451],
     [0.78431373, 0.82745098, 0.29019608],
     [0.81960784, 0.85490196, 0.30588235],
     [0.85490196, 0.89411765, 0.50196078],
     [0.82745098, 0.86666667, 0.3372549 ],
     [0.84705882, 0.88235294, 0.38039216],
     [0.82352941, 0.86666667, 0.40784314],
     [0.9254902 , 0.98039216, 0.61568627],
     [0.69411765, 0.78823529, 0.18823529],
     [0.64313725, 0.7254902 , 0.17647059],
     [0.61176471, 0.64313725, 0.13333333],
     [0.62352941, 0.56862745, 0.14509804],
     [0.60392157, 0.11372549, 0.03921569],
     [0.84313725, 0.28235294, 0.29803922],
     [0.6745098 , 0.02352941, 0.07058824],
     [0.66666667, 0.        , 0.05490196],
     [0.68627451, 0.01568627, 0.07058824],
     [0.69411765, 0.07058824, 0.10980392],
     [0.69019608, 0.00392157, 0.0745098 ],
     [0.71764706, 0.04705882, 0.10980392],
     [0.65490196, 0.00784314, 0.0627451 ],
     [0.81568627, 0.28627451, 0.30588235],
     [0.78039216, 0.23137255, 0.23921569],
     [0.69803922, 0.12941176, 0.12156863],
     [0.72156863, 0.12941176, 0.13333333],
     [0.71764706, 0.10980392, 0.11372549],
     [0.79215686, 0.24313725, 0.18823529],
     [0.74901961, 0.20392157, 0.16470588]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='repeat'
)

cmap_argon = fscolors.Fractal_colormap(
    colors=[
     [0.01568627, 0.        , 0.12156863],
     [0.14509804, 0.00392157, 0.31372549],
     [0.27843137, 0.00784314, 0.50196078],
     [0.40784314, 0.01176471, 0.69411765],
     [0.54901961, 0.05490196, 0.74901961],
     [0.69019608, 0.11764706, 0.74509804],
     [0.83137255, 0.17647059, 0.74117647],
     [0.93333333, 0.29019608, 0.76078431],
     [0.95294118, 0.50588235, 0.83137255],
     [0.97254902, 0.72156863, 0.90588235],
     [0.98039216, 0.82745098, 0.94117647]],
    kinds='Lch',
    grad_npts=32,
    grad_funcs='x',
    extent='mirror'
)

cmap_peacock = fscolors.Fractal_colormap(
    colors=[
 [0.02745098, 0.05882353, 0.01568627],
 [0.05098039, 0.05882353, 0.04705882],
 [0.08235294, 0.11372549, 0.03529412],
 [0.07058824, 0.10588235, 0.03529412],
 [0.01176471, 0.04313725, 0.        ],
 [0.00392157, 0.03137255, 0.        ],
 [0.01960784, 0.04705882, 0.01568627],
 [0.        , 0.04313725, 0.        ],
 [0.0627451 , 0.10980392, 0.03921569],
 [0.0745098 , 0.10980392, 0.04705882],
 [0.01960784, 0.04313725, 0.00392157],
 [0.00392157, 0.01960784, 0.01568627],
 [0.        , 0.        , 0.        ],
 [0.        , 0.        , 0.01568627],
 [0.        , 0.00392157, 0.01176471],
 [0.01960784, 0.06666667, 0.02352941],
 [0.05882353, 0.15686275, 0.05882353],
 [0.10588235, 0.23921569, 0.11372549],
 [0.01568627, 0.07843137, 0.01960784],
 [0.01568627, 0.        , 0.02352941],
 [0.01960784, 0.08235294, 0.01568627],
 [0.02352941, 0.1254902 , 0.00784314],
 [0.16470588, 0.31764706, 0.10196078],
 [0.40784314, 0.56862745, 0.30980392],
 [0.19215686, 0.35294118, 0.1254902 ],
 [0.27843137, 0.45098039, 0.24705882],
 [0.41568627, 0.58039216, 0.41176471],
 [0.25098039, 0.37647059, 0.14901961],
 [0.10980392, 0.19215686, 0.03137255],
 [0.00392157, 0.03921569, 0.01176471],
 [0.07843137, 0.15294118, 0.06666667],
 [0.13333333, 0.30196078, 0.08627451],
 [0.09019608, 0.23921569, 0.03137255],
 [0.05882353, 0.19607843, 0.05098039],
 [0.05490196, 0.14901961, 0.08235294],
 [0.04313725, 0.07058824, 0.03137255],
 [0.09411765, 0.27843137, 0.09411765],
 [0.24705882, 0.60784314, 0.27843137],
 [0.01568627, 0.2627451 , 0.01960784],
 [0.14509804, 0.36470588, 0.1372549 ],
 [0.18431373, 0.38039216, 0.14901961],
 [0.15294118, 0.31764706, 0.09803922],
 [0.05882353, 0.22745098, 0.05098039],
 [0.        , 0.04313725, 0.        ],
 [0.00784314, 0.07843137, 0.02352941],
 [0.10196078, 0.34901961, 0.16078431],
 [0.37647059, 0.72941176, 0.37647059],
 [0.48627451, 0.8       , 0.36862745],
 [0.05882353, 0.26666667, 0.01176471],
 [0.02352941, 0.17647059, 0.01960784],
 [0.41960784, 0.65882353, 0.41568627],
 [0.34117647, 0.70980392, 0.3372549 ],
 [0.14901961, 0.57647059, 0.20392157],
 [0.08627451, 0.4745098 , 0.24705882],
 [0.02352941, 0.30196078, 0.16862745],
 [0.27058824, 0.70980392, 0.4745098 ],
 [0.36862745, 0.93333333, 0.50588235],
 [0.54901961, 0.99215686, 0.4627451 ],
 [0.43137255, 0.69411765, 0.14117647],
 [0.16078431, 0.48627451, 0.03529412],
 [0.28235294, 0.57647059, 0.28627451],
 [0.03921569, 0.2       , 0.04705882],
 [0.09411765, 0.47843137, 0.25098039],
 [0.49411765, 0.90980392, 0.49411765],
 [0.75686275, 0.99607843, 0.43137255],
 [0.59607843, 0.97647059, 0.30196078],
 [0.37647059, 0.88627451, 0.35686275],
 [0.14509804, 0.5254902 , 0.27058824],
 [0.27058824, 0.66666667, 0.50588235],
 [0.49411765, 0.98039216, 0.75294118],
 [0.41568627, 0.95294118, 0.48627451],
 [0.36078431, 0.85098039, 0.27058824],
 [0.2627451 , 0.63921569, 0.14509804],
 [0.06666667, 0.3254902 , 0.05490196],
 [0.12156863, 0.32941176, 0.19215686],
 [0.18431373, 0.41960784, 0.19215686],
 [0.45490196, 0.56862745, 0.26666667],
 [0.23529412, 0.30980392, 0.        ],
 [0.09411765, 0.14901961, 0.0627451 ],
 [0.00392157, 0.07058824, 0.01960784],
 [0.2627451 , 0.41568627, 0.25490196],
 [0.45098039, 0.58823529, 0.28627451],
 [0.62352941, 0.68627451, 0.33333333],
 [0.12156863, 0.09411765, 0.04705882],
 [0.16078431, 0.12941176, 0.05098039],
 [0.63529412, 0.62352941, 0.34901961],
 [0.55294118, 0.54509804, 0.22745098],
 [0.2       , 0.18823529, 0.06666667],
 [0.15294118, 0.1372549 , 0.05098039],
 [0.73333333, 0.65882353, 0.37254902],
 [0.59215686, 0.50196078, 0.2745098 ],
 [0.16862745, 0.12156863, 0.07058824],
 [0.08235294, 0.08627451, 0.08235294],
 [0.19607843, 0.12941176, 0.0745098 ],
 [0.59215686, 0.54117647, 0.25882353],
 [0.52156863, 0.45098039, 0.2745098 ],
 [0.03137255, 0.03137255, 0.00784314],
 [0.4745098 , 0.31372549, 0.18431373],
 [0.65882353, 0.50588235, 0.25490196],
 [0.39607843, 0.27843137, 0.16862745],
 [0.09411765, 0.01176471, 0.02352941],
 [0.62745098, 0.4745098 , 0.35294118],
 [0.53333333, 0.39607843, 0.16470588],
 [0.12156863, 0.08235294, 0.03921569],
 [0.15294118, 0.14117647, 0.08235294],
 [0.51372549, 0.45490196, 0.26666667],
 [0.19215686, 0.16078431, 0.05882353],
 [0.03921569, 0.04313725, 0.00392157],
 [0.10196078, 0.15686275, 0.08235294],
 [0.30980392, 0.44313725, 0.29803922],
 [0.10980392, 0.25490196, 0.20784314],
 [0.05098039, 0.15686275, 0.32941176],
 [0.08235294, 0.38039216, 0.64313725],
 [0.16862745, 0.8       , 0.94117647],
 [0.02745098, 0.67843137, 0.69019608],
 [0.10588235, 0.43137255, 0.69411765],
 [0.07843137, 0.57254902, 0.85098039],
 [0.12156863, 0.91372549, 0.95686275],
 [0.14117647, 0.73333333, 0.87058824],
 [0.        , 0.2745098 , 0.61960784],
 [0.11764706, 0.72156863, 0.94117647],
 [0.06666667, 0.89411765, 0.96470588],
 [0.0745098 , 0.60784314, 0.83921569],
 [0.02352941, 0.3372549 , 0.76862745],
 [0.05490196, 0.83137255, 0.94901961],
 [0.11764706, 0.77254902, 0.91764706],
 [0.03529412, 0.35294118, 0.70196078],
 [0.09803922, 0.75294118, 0.96470588],
 [0.03921569, 0.6627451 , 0.87843137],
 [0.02352941, 0.25098039, 0.70588235],
 [0.1254902 , 0.48235294, 0.88235294],
 [0.07058824, 0.85490196, 0.96470588],
 [0.0745098 , 0.58039216, 0.89019608],
 [0.09803922, 0.24705882, 0.74901961],
 [0.0745098 , 0.68627451, 0.94117647],
 [0.12156863, 0.70980392, 0.97647059],
 [0.01960784, 0.28627451, 0.73333333],
 [0.2       , 0.62745098, 0.99215686],
 [0.07843137, 0.69019608, 0.9372549 ],
 [0.08235294, 0.40392157, 0.81960784],
 [0.10196078, 0.49019608, 0.85490196],
 [0.09411765, 0.8       , 0.97647059],
 [0.07058824, 0.54117647, 0.83921569],
 [0.03137255, 0.2       , 0.76470588],
 [0.12156863, 0.54509804, 0.96078431],
 [0.17254902, 0.64313725, 0.98431373],
 [0.0745098 , 0.24313725, 0.76862745],
 [0.09019608, 0.1372549 , 0.81568627],
 [0.14117647, 0.29019608, 0.94509804],
 [0.15294118, 0.34117647, 0.82745098],
 [0.07058824, 0.16862745, 0.4627451 ],
 [0.47843137, 0.45882353, 0.65098039],
 [0.04313725, 0.05490196, 0.18823529],
 [0.01176471, 0.02352941, 0.1254902 ],
 [0.21960784, 0.2627451 , 0.3372549 ],
 [0.43921569, 0.49803922, 0.57254902],
 [0.04313725, 0.0745098 , 0.18823529],
 [0.07058824, 0.08627451, 0.23137255],
 [0.40784314, 0.41960784, 0.56078431],
 [0.07058824, 0.08235294, 0.2       ],
 [0.05490196, 0.07058824, 0.16862745],
 [0.29803922, 0.30980392, 0.41568627],
 [0.25882353, 0.25098039, 0.37254902],
 [0.00784314, 0.01568627, 0.12941176],
 [0.23529412, 0.25490196, 0.36862745],
 [0.25882353, 0.27843137, 0.39215686],
 [0.00784314, 0.01960784, 0.14117647],
 [0.09803922, 0.11764706, 0.24313725],
 [0.25098039, 0.27058824, 0.4       ],
 [0.01568627, 0.01960784, 0.14117647],
 [0.09803922, 0.11372549, 0.25882353],
 [0.25490196, 0.2627451 , 0.42352941],
 [0.10588235, 0.12156863, 0.27058824],
 [0.14117647, 0.18823529, 0.30588235],
 [0.51372549, 0.56862745, 0.68627451],
 [0.00784314, 0.01568627, 0.14901961],
 [0.04705882, 0.05490196, 0.19607843],
 [0.32156863, 0.34117647, 0.49803922],
 [0.03529412, 0.04705882, 0.23529412],
 [0.03137255, 0.03137255, 0.23921569],
 [0.2       , 0.22352941, 0.44705882],
 [0.0627451 , 0.08627451, 0.35686275],
 [0.00784314, 0.01568627, 0.24313725],
 [0.19215686, 0.20392157, 0.38823529],
 [0.04313725, 0.0627451 , 0.28627451],
 [0.01176471, 0.01960784, 0.24705882],
 [0.14509804, 0.16862745, 0.35686275],
 [0.08627451, 0.10588235, 0.34509804],
 [0.02745098, 0.04313725, 0.34117647],
 [0.15686275, 0.18431373, 0.48627451],
 [0.07843137, 0.09019608, 0.42352941],
 [0.04313725, 0.05490196, 0.36078431],
 [0.14117647, 0.16470588, 0.40784314],
 [0.04705882, 0.0745098 , 0.31764706],
 [0.        , 0.03529412, 0.29803922],
 [0.09803922, 0.1372549 , 0.37254902],
 [0.07058824, 0.10196078, 0.39215686],
 [0.04313725, 0.0745098 , 0.34901961],
 [0.0627451 , 0.10588235, 0.32941176],
 [0.05882353, 0.08627451, 0.35294118],
 [0.09411765, 0.11372549, 0.37647059],
 [0.03921569, 0.0627451 , 0.29019608],
 [0.04313725, 0.05490196, 0.36470588],
 [0.10980392, 0.11764706, 0.49803922],
 [0.05098039, 0.08235294, 0.40392157],
 [0.04705882, 0.07843137, 0.39215686],
 [0.0745098 , 0.10196078, 0.40392157],
 [0.05490196, 0.0745098 , 0.37254902],
 [0.01960784, 0.05490196, 0.36470588],
 [0.02745098, 0.0745098 , 0.45098039],
 [0.01176471, 0.05098039, 0.41176471],
 [0.01960784, 0.05882353, 0.4       ],
 [0.02745098, 0.0627451 , 0.38431373],
 [0.03137255, 0.06666667, 0.36862745],
 [0.08627451, 0.11764706, 0.44313725],
 [0.01568627, 0.03921569, 0.37254902],
 [0.03921569, 0.05490196, 0.41176471],
 [0.04313725, 0.05490196, 0.42352941],
 [0.01568627, 0.03137255, 0.38823529],
 [0.00784314, 0.05490196, 0.39215686],
 [0.08235294, 0.12156863, 0.51764706],
 [0.22745098, 0.25098039, 0.70588235],
 [0.12156863, 0.14117647, 0.57254902],
 [0.00392157, 0.01176471, 0.37647059],
 [0.03921569, 0.0627451 , 0.40784314],
 [0.        , 0.02745098, 0.35686275],
 [0.01568627, 0.05882353, 0.46666667],
 [0.        , 0.0627451 , 0.49803922],
 [0.        , 0.09411765, 0.48627451],
 [0.01176471, 0.05098039, 0.45490196],
 [0.00392157, 0.02352941, 0.36470588],
 [0.05098039, 0.06666667, 0.36470588],
 [0.01960784, 0.04313725, 0.34509804],
 [0.        , 0.03529412, 0.32941176],
 [0.02352941, 0.03137255, 0.32156863],
 [0.04313725, 0.04705882, 0.30980392],
 [0.01960784, 0.02745098, 0.27058824],
 [0.01568627, 0.01568627, 0.25490196],
 [0.05098039, 0.04705882, 0.31372549],
 [0.01960784, 0.03137255, 0.30588235],
 [0.01568627, 0.02745098, 0.29803922],
 [0.02352941, 0.03529412, 0.29019608],
 [0.02352941, 0.04313725, 0.27058824],
 [0.00784314, 0.02745098, 0.24313725],
 [0.00392157, 0.01960784, 0.15294118],
 [0.        , 0.00392157, 0.11764706],
 [0.02352941, 0.04705882, 0.15294118],
 [0.02745098, 0.04313725, 0.13333333],
 [0.00784314, 0.01568627, 0.15294118],
 [0.        , 0.01176471, 0.16078431],
 [0.00784314, 0.01568627, 0.16470588],
 [0.05882353, 0.05490196, 0.18823529],
 [0.00392157, 0.00392157, 0.10196078],
 [0.00784314, 0.00392157, 0.07843137],
 [0.        , 0.        , 0.09019608],
 [0.00392157, 0.01176471, 0.09803922]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='mirror'
)

cmap_dawn = fscolors.Fractal_colormap(
    colors=[
 [0.0627451 , 0.09019608, 0.20392157],
 [0.79215688, 0.65490198, 0.98823529],
 [0.99215686, 0.90980393, 0.36862746]],
    kinds=['Lch', 'Lch', 'Lch'],
    grad_npts=[32, 32,  32],
    grad_funcs=['x', 'x', 'x'],
    extent='mirror'
)

cmap_lily = fscolors.Fractal_colormap(
    colors=[[1.        , 0.64313725, 0.34901961],
 [1.        , 0.70196078, 0.38431373],
 [0.9254902 , 0.44705882, 0.24313725],
 [0.98823529, 0.47058824, 0.2745098 ],
 [0.99607843, 0.59607843, 0.32941176],
 [0.95686275, 0.36078431, 0.18039216],
 [0.9372549 , 0.22352941, 0.11764706],
 [0.97647059, 0.45098039, 0.29411765],
 [1.        , 0.68627451, 0.52941176],
 [1.        , 0.6       , 0.54901961],
 [0.99215686, 0.26666667, 0.42352941],
 [0.96078431, 0.09019608, 0.40784314],
 [0.99607843, 0.16470588, 0.55294118],
 [0.99607843, 0.23529412, 0.62352941],
 [0.99215686, 0.16078431, 0.58039216],
 [0.99607843, 0.09019608, 0.5372549 ],
 [0.99215686, 0.0627451 , 0.50980392],
 [0.97647059, 0.09019608, 0.52941176],
 [0.96470588, 0.15294118, 0.57647059],
 [0.99607843, 0.30588235, 0.70196078],
 [1.        , 0.40784314, 0.78431373],
 [0.98431373, 0.45882353, 0.80392157],
 [0.96078431, 0.47843137, 0.78823529],
 [0.96862745, 0.48627451, 0.78431373],
 [0.94901961, 0.36078431, 0.68235294],
 [0.95686275, 0.27843137, 0.63921569],
 [0.96470588, 0.25882353, 0.63529412],
 [0.98431373, 0.2745098 , 0.6627451 ],
 [0.99607843, 0.29411765, 0.69411765],
 [1.        , 0.33333333, 0.7372549 ],
 [0.99215686, 0.34117647, 0.75686275],
 [0.95686275, 0.27843137, 0.71372549],
 [0.95294118, 0.29803922, 0.7254902 ],
 [0.98039216, 0.32156863, 0.7372549 ],
 [0.98823529, 0.32941176, 0.72156863],
 [0.92156863, 0.22352941, 0.58431373],
 [0.89019608, 0.24313725, 0.56470588],
 [0.63137255, 0.24705882, 0.39607843],
 [0.2745098 , 0.22745098, 0.12941176],
 [0.63137257, 0.24705882, 0.39607844],
 [0.92156863, 0.22352941, 0.58431375],
 [0.16470588, 0.27843137, 0.06666667],
 [0.16862745, 0.28235294, 0.0745098 ],
 [0.16078431, 0.28235294, 0.06666667],
 [0.16078431, 0.28627451, 0.06666667],
 [0.95686275, 0.27843139, 0.71372551],
 [0.99215686, 0.34117648, 0.75686276],
 [0.63137257, 0.24705882, 0.39607844],
 [0.15294118, 0.29019608, 0.06666667],
 [0.15294118, 0.29019608, 0.06666667],
 [0.15294118, 0.29019608, 0.06666667],
 [0.15294118, 0.28627451, 0.06666667],
 [0.53725493, 0.70980394, 0.54901963],
 [0.15294118, 0.27843137, 0.05490196],
 [0.15686275, 0.27058824, 0.05098039],
 [0.16078431, 0.25098039, 0.08627451],
 [0.20392157, 0.27843137, 0.15686275],
 [0.27058824, 0.35294118, 0.24705882],
 [0.48235294, 0.60392157, 0.48235294],
 [0.5372549 , 0.70980392, 0.54901961],
 [0.44313725, 0.67843137, 0.44313725],
 [0.37254902, 0.6627451 , 0.32941176],
 [0.35294118, 0.66666667, 0.29803922],
 [0.34509804, 0.65882353, 0.27843137],
 [0.34509804, 0.6627451 , 0.2627451 ],
 [0.34509804, 0.67058824, 0.25490196],
 [0.34509804, 0.6745098 , 0.25098039],
 [0.34117647, 0.6745098 , 0.25098039],
 [0.34117647, 0.68235294, 0.24313725],
 [0.33333333, 0.6745098 , 0.21568627],
 [0.32941176, 0.6745098 , 0.20392157],
 [0.32941176, 0.6745098 , 0.19215686],
 [0.3254902 , 0.67058824, 0.19215686],
 [0.3254902 , 0.66666667, 0.19607843],
 [0.3254902 , 0.66666667, 0.19607843],
 [0.3254902 , 0.67058824, 0.19215686],
 [0.46666667, 0.80000001, 0.37254903],
 [0.46666667, 0.80000001, 0.37254903],
 [0.30980392, 0.66666667, 0.16862745],
 [0.36470589, 0.71372551, 0.20392157],
 [0.31372549, 0.67058824, 0.17254902],
 [0.32156863, 0.67843137, 0.18823529],
 [0.34117647, 0.69411765, 0.21960784],
 [0.34117647, 0.69411765, 0.21960784],
 [0.3372549 , 0.69411765, 0.18823529],
 [0.33333333, 0.69411765, 0.16470588],
 [0.30196078, 0.66666667, 0.12941176],
 [0.2745098 , 0.63921569, 0.07843137],
 [0.2745098 , 0.63921569, 0.03921569],
 [0.29019608, 0.65882353, 0.02352941],
 [0.29019608, 0.65882353, 0.05098039],
 [0.36470588, 0.71372549, 0.20392157],
 [0.46666667, 0.8       , 0.37254902],
 [0.39607843, 0.74117647, 0.30196078],
 [0.32156863, 0.68235294, 0.19215686],
 [0.31372549, 0.69019608, 0.17647059],
 [0.29803922, 0.67843137, 0.15686275],
 [0.27843137, 0.66666667, 0.14117647],
 [0.27843137, 0.67058824, 0.14901961],
 [0.27058824, 0.66666667, 0.14117647],
 [0.26666667, 0.6627451 , 0.12156863],
 [0.2745098 , 0.67058824, 0.12156863],
 [0.27843137, 0.67058824, 0.12941176],
 [0.28235294, 0.66666667, 0.1372549 ],
 [0.30588235, 0.68235294, 0.15294118],
 [0.30980392, 0.68235294, 0.15686275],
 [0.30588235, 0.67843137, 0.14509804],
 [0.28627451, 0.65882353, 0.12156863],
 [0.27058824, 0.64313725, 0.10980392],
 [0.27843137, 0.65098039, 0.11764706],
 [0.30588235, 0.68235294, 0.15686275],
 [0.29411765, 0.67058824, 0.14509804],
 [0.27843137, 0.65490196, 0.11372549],
 [0.28627451, 0.66666667, 0.11764706],
 [0.27058824, 0.65490196, 0.10196078],
 [0.23137255, 0.61568627, 0.05882353],
 [0.24313725, 0.61960784, 0.05490196],
 [0.25882353, 0.63529412, 0.0745098 ],
 [0.28627451, 0.63921569, 0.10588235],
 [0.41568627, 0.74509804, 0.27843137],
 [0.51372549, 0.82352941, 0.42352941],
 [0.53333333, 0.83137255, 0.48627451],
 [0.54509804, 0.85098039, 0.4745098 ],
 [0.4745098 , 0.80392157, 0.34901961],
 [0.4       , 0.74117647, 0.20392157],
 [0.34117647, 0.69803922, 0.11764706],
 [0.31764706, 0.68235294, 0.09411765],
 [0.3254902 , 0.69019608, 0.10196078],
 [0.32156863, 0.68627451, 0.0745098 ],
 [0.29803922, 0.6745098 , 0.05882353],
 [0.2627451 , 0.64313725, 0.02352941],
 [0.21960784, 0.61960784, 0.        ],
 [0.21568627, 0.63137255, 0.        ],
 [0.20784314, 0.65098039, 0.        ],
 [0.20392157, 0.64705882, 0.00784314],
 [0.19215686, 0.64313725, 0.02745098],
 [0.21176471, 0.64705882, 0.0627451 ],
 [0.24705882, 0.6627451 , 0.10980392],
 [0.2745098 , 0.6627451 , 0.11764706],
 [0.3372549 , 0.68235294, 0.1372549 ],
 [0.4       , 0.7254902 , 0.14117647],
 [0.37647059, 0.70980392, 0.09019608],
 [0.33333333, 0.67843137, 0.0745098 ],
 [0.38823529, 0.74509804, 0.17647059],
 [0.38039216, 0.75686275, 0.20392157],
 [0.30980392, 0.70196078, 0.10588235],
 [0.25882353, 0.65490196, 0.01960784],
 [0.2627451 , 0.65882353, 0.01960784],
 [0.27058824, 0.66666667, 0.03137255],
 [0.24705882, 0.64313725, 0.01960784],
 [0.23137255, 0.63137255, 0.02352941],
 [0.25098039, 0.64313725, 0.05490196],
 [0.27058824, 0.6627451 , 0.0745098 ],
 [0.29019608, 0.68235294, 0.09411765],
 [0.29411765, 0.68235294, 0.08627451],
 [0.28235294, 0.6745098 , 0.0745098 ],
 [0.28235294, 0.6745098 , 0.07843137],
 [0.28235294, 0.6745098 , 0.08627451],
 [0.27843137, 0.66666667, 0.08235294],
 [0.4627451 , 0.7647059 , 0.40000001],
 [0.27843137, 0.67058824, 0.06666667],
 [0.28235294, 0.6745098 , 0.07843137],
 [0.27058824, 0.65882353, 0.0745098 ],
 [0.2745098 , 0.65882353, 0.09019608],
 [0.2745098 , 0.6627451 , 0.08627451],
 [0.27058824, 0.6627451 , 0.0745098 ],
 [0.22745098, 0.61568627, 0.02745098],
 [0.21176471, 0.60392157, 0.01176471],
 [0.24313725, 0.62745098, 0.03137255],
 [0.25882353, 0.63921569, 0.05490196],
 [0.2627451 , 0.63529412, 0.07843137],
 [0.28627451, 0.64313725, 0.11372549],
 [0.30588235, 0.65098039, 0.14117647],
 [0.34901961, 0.68627451, 0.19607843],
 [0.34901961, 0.68235294, 0.21568627],
 [0.34901961, 0.6745098 , 0.24313725],
 [0.38431373, 0.70980392, 0.29803922],
 [0.42352941, 0.74117647, 0.35294118],
 [0.44705882, 0.75294118, 0.38431373],
 [0.4627451 , 0.76470588, 0.4       ],
 [0.48235294, 0.77647059, 0.45098039],
 [0.45490196, 0.76470588, 0.41176471],
 [0.33333333, 0.65882353, 0.24313725],
 [0.29411765, 0.64313725, 0.16862745],
 [0.28235294, 0.64313725, 0.17254902],
 [0.30196078, 0.65882353, 0.18823529],
 [0.31764706, 0.6745098 , 0.20392157],
 [0.31372549, 0.6745098 , 0.20392157],
 [0.31764706, 0.67843137, 0.20784314],
 [0.31372549, 0.6627451 , 0.20784314],
 [0.25882353, 0.60784314, 0.16078431],
 [0.36470588, 0.70980392, 0.27058824],
 [0.45098039, 0.78823529, 0.35686275],
 [0.37254902, 0.70980392, 0.28627451],
 [0.34117647, 0.67843137, 0.25098039],
 [0.33333333, 0.67058824, 0.24705882],
 [0.29803922, 0.63137255, 0.21568627],
 [0.3254902 , 0.65882353, 0.24313725],
 [0.34509804, 0.67843137, 0.27058824],
 [0.35686275, 0.69019608, 0.29019608],
 [0.36470588, 0.69803922, 0.30196078],
 [0.34117647, 0.67843137, 0.26666667],
 [0.36078431, 0.69803922, 0.26666667],
 [0.32156863, 0.6627451 , 0.21568627],
 [0.25490196, 0.6       , 0.12941176],
 [0.21960784, 0.56470588, 0.07058824],
 [0.22745098, 0.58039216, 0.05882353],
 [0.24313725, 0.59607843, 0.0627451 ],
 [0.24705882, 0.61176471, 0.07058824],
 [0.24705882, 0.61568627, 0.06666667],
 [0.24705882, 0.60784314, 0.07058824],
 [0.2627451 , 0.59607843, 0.10588235],
 [0.26666667, 0.58039216, 0.1372549 ],
 [0.27058824, 0.60392157, 0.14901961],
 [0.21960784, 0.58039216, 0.09019608],
 [0.22745098, 0.58431373, 0.10980392],
 [0.33333333, 0.6627451 , 0.2627451 ],
 [0.34509804, 0.64705882, 0.31764706],
 [0.35294118, 0.64313725, 0.32941176],
 [0.34509804, 0.64705882, 0.31764706],
 [0.32156863, 0.63529412, 0.29019608],
 [0.29019608, 0.60392157, 0.24313725],
 [0.28235294, 0.6       , 0.22352941],
 [0.29411765, 0.58039216, 0.23921569],
 [0.25490196, 0.4745098 , 0.20784314],
 [0.13333333, 0.27058824, 0.08235294],
 [0.03921569, 0.15686275, 0.01960784],
 [0.03529412, 0.16862745, 0.04313725],
 [0.02352941, 0.18039216, 0.04705882],
 [0.02745098, 0.17647059, 0.04705882],
 [0.03137255, 0.17647059, 0.04705882],
 [0.02745098, 0.17254902, 0.04313725],
 [0.02745098, 0.16862745, 0.04313725],
 [0.02745098, 0.16470588, 0.03921569],
 [0.03137255, 0.16862745, 0.04313725],
 [0.34509805, 0.64705884, 0.31764707],
 [0.02745098, 0.16470588, 0.03921569],
 [0.03137255, 0.16862745, 0.04313725],
 [0.03921569, 0.17647059, 0.04705882],
 [0.03921569, 0.17254902, 0.04705882],
 [0.03921569, 0.17254902, 0.04705882],
 [0.03137255, 0.16862745, 0.04313725],
 [0.03137255, 0.16862745, 0.04313725],
 [0.03137255, 0.16862745, 0.04313725],
 [0.02352941, 0.16078431, 0.03529412],
 [0.02352941, 0.16078431, 0.03137255],
 [0.02352941, 0.16078431, 0.02745098],
 [0.13333334, 0.27058825, 0.08235294],
 [0.02745098, 0.16862745, 0.03529412],
 [0.03137255, 0.16862745, 0.04313725],
 [0.34509805, 0.64705884, 0.31764707]],
    kinds='Lch',
    grad_npts=3,
    grad_funcs='x',
    extent='mirror'
)

# To import a cmap one shall do:
# import fractalshades.colors as fscolors
# fscolors.cmap_register.keys()

cmap_register = {
    "classic": cmap_classic,
    "legacy": cmap_legacy,
    "atoll": cmap_atoll,
    "sunset": cmap_sunset,
    "autumn": cmap_autumn,
    "valensole": cmap_valensole,
    "stellar": cmap_stellar,
    "citrus": cmap_citrus,
    "argon": cmap_argon,
    "peacock": cmap_peacock,
    "dawn": cmap_dawn,
    "lily": cmap_lily
}
for k, v in cmap_register.items():
    v._template = k

cmap_register = fsutils.Protected_mapping(cmap_register)
