# anansi-sdk
These endpoints describe the REST API of the Anansi Data Lineage Tool. The Catalog endpoint is for saving data into Nodes. The Relationships endpoints is for connecting data between Nodes. The endpoints use JWT as the security mechanism.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.8
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [https://www.anansihub.com](https://www.anansihub.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import anansi_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import anansi_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import anansi_sdk
from anansi_sdk.rest import ApiException
from pprint import pprint

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
table_name = 'table_name_example' # str | Also can be called Node Name interchangeably.
unused_parameter = 'unused_parameter_example' # str | This is a unused parameter. It can be set to anything.
body = [{
  "value" : [ {
    "Email" : "test@test1.com"
  } ]
}] # list[object] |  (optional)

try:
    # Delete Catalog Entries
    api_response = api_instance.delete_api_catalog_table_name(table_name, unused_parameter, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_api_catalog_table_name: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
catalogname = 'catalogname_example' # str | Source Catalog Name
unused_parameter = 'unused_parameter_example' # str | Unused but required parameter.
body = [anansi_sdk.RelationshipUnusedParameterBody()] # list[RelationshipUnusedParameterBody] |  (optional)

try:
    # Delete Relationships
    api_response = api_instance.delete_api_relationship_unused_parameter_catalog_name(catalogname, unused_parameter, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_api_relationship_unused_parameter_catalog_name: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
catalogname = 'catalogname_example' # str | Source Catalog Name
limit = 56 # int | Number of Records returned
skip = 56 # int | Number of Records to be skipped
source_label = 'source_label_example' # str | Name of the Source Node. Used for Filter.  (optional)
dest_label = 'dest_label_example' # str | Name of the Destination Node. Used for Filter. (optional)
relation_name = 'relation_name_example' # str | Type of Relationship. Used for Filter. (optional)
order_prop = 'order_prop_example' # str | Order By Property. Used for Sorting. (optional)
order_type = 'order_type_example' # str | Ascending or Descending. Used for Sorting. (optional)

try:
    # GET Relationships
    api_response = api_instance.get_api_relationship(catalogname, limit, skip, source_label=source_label, dest_label=dest_label, relation_name=relation_name, order_prop=order_prop, order_type=order_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_api_relationship: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
limit = 56 # int | The number of rows to return.
skip = 56 # int | The number of rows to skip during a select. This mainly used for pagination.
table_name = 'table_name_example' # str | Also can be called Node Name interchangeably.
_property = '_property_example' # str | We can choose to return only 1 property (optional)
order_info_order_prop = 'order_info_order_prop_example' # str | Order by this property (optional)
order_info_order_type = 'order_info_order_type_example' # str | Ascending or Descending Order. Default is Ascending Order. (optional)
optional_filter = 'optional_filter_example' # str | Used for filtering data. (optional)
relation_info_name = 'relation_info_name_example' # str | Relationship Name (optional)
relation_info_node_name = 'relation_info_node_name_example' # str | Source Node (optional)
relation_info_unique_col_name = 'relation_info_unique_col_name_example' # str | Source Node Unique Column Name (optional)
relation_info_id = 'relation_info_id_example' # str | Source Node Identifier (optional)
relation_info_direction = 'Downstream' # str | Direction Identifier (optional) (default to Downstream)

try:
    # Get Catalog Data by Table Name
    api_response = api_instance.get_catalog_tablename(limit, skip, table_name, _property=_property, order_info_order_prop=order_info_order_prop, order_info_order_type=order_info_order_type, optional_filter=optional_filter, relation_info_name=relation_info_name, relation_info_node_name=relation_info_node_name, relation_info_unique_col_name=relation_info_unique_col_name, relation_info_id=relation_info_id, relation_info_direction=relation_info_direction)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_catalog_tablename: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
table_name = 'table_name_example' # str | Also can be called Node Name interchangeably.
unused_parameter = 'unused_parameter_example' # str | This is a unused parameter. It can be set to anything.
body = NULL # object |  (optional)

try:
    # Update Properties in the table
    api_response = api_instance.patch_api_catalog_table_name_x(table_name, unused_parameter, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->patch_api_catalog_table_name_x: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
catalogname = 'catalogname_example' # str | Source Catalog Name
unused_parameter = 'unused_parameter_example' # str | Unused but required parameter.
body = anansi_sdk.Relationship() # Relationship |  (optional)

try:
    # Update Relationship
    api_response = api_instance.patch_api_relationship(catalogname, unused_parameter, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->patch_api_relationship: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
table_name = 'table_name_example' # str | Also can be called Node Name interchangeably.
body = [{
  "value" : [ {
    "User Id" : "123",
    "Email" : "test@test1.com",
    "Encrypted Password" : "x",
    "Name" : "Someone",
    "Last Updated By" : "System Startup",
    "Last Updated DateTime" : "2023-06-15T09:26:40Z",
    "Created By" : "System Startup",
    "Created DateTime" : "2023-06-15T09:26:40Z"
  } ]
}] # list[object] |  (optional)

try:
    # Create New Entries in the Table
    api_instance.post_api_catalog_table_name(table_name, body=body)
except ApiException as e:
    print("Exception when calling DefaultApi->post_api_catalog_table_name: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
catalog_name = 'catalog_name_example' # str | Name of the Catalog
body = anansi_sdk.GraphRequest() # GraphRequest |  (optional)

try:
    # Generate Graph
    api_response = api_instance.post_api_graph_catalog_name(catalog_name, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->post_api_graph_catalog_name: %s\n" % e)

# Configure API key authorization: JWT
configuration = anansi_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = anansi_sdk.DefaultApi(anansi_sdk.ApiClient(configuration))
catalogname = 'catalogname_example' # str | Source Catalog Name
body = [anansi_sdk.Relationship()] # list[Relationship] |  (optional)

try:
    # Create Relationships
    api_instance.post_api_relationship(catalogname, body=body)
except ApiException as e:
    print("Exception when calling DefaultApi->post_api_relationship: %s\n" % e)

# Configure API key authorization: JWT
configuration = swagger_client.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = {
  "value" : {
    "searchStr" : "Treasury",
    "similarityThreshold" : 0.8,
    "fullTextIndexLimit" : 3,
    "maxResultReturned" : 3
  }
} # object |  (optional)

try:
    # Your POST endpoint
    api_response = api_instance.post_api_search(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->post_api_search: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:80*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**delete_api_catalog_table_name**](docs/DefaultApi.md#delete_api_catalog_table_name) | **DELETE** /api/catalog/{tableName}/{unusedParameter} | Delete Catalog Entries
*DefaultApi* | [**delete_api_relationship_unused_parameter_catalog_name**](docs/DefaultApi.md#delete_api_relationship_unused_parameter_catalog_name) | **DELETE** /api/relationship/{UnusedParameter} | Delete Relationships
*DefaultApi* | [**get_api_relationship**](docs/DefaultApi.md#get_api_relationship) | **GET** /api/relationship | GET Relationships
*DefaultApi* | [**get_catalog_tablename**](docs/DefaultApi.md#get_catalog_tablename) | **GET** /api/catalog/{tableName} | Get Catalog Data by Table Name
*DefaultApi* | [**patch_api_catalog_table_name_x**](docs/DefaultApi.md#patch_api_catalog_table_name_x) | **PATCH** /api/catalog/{tableName}/{unusedParameter} | Update Properties in the table
*DefaultApi* | [**patch_api_relationship**](docs/DefaultApi.md#patch_api_relationship) | **PATCH** /api/relationship/{UnusedParameter} | Update Relationship
*DefaultApi* | [**post_api_catalog_table_name**](docs/DefaultApi.md#post_api_catalog_table_name) | **POST** /api/catalog/{tableName} | Create New Entries in the Table
*DefaultApi* | [**post_api_graph_catalog_name**](docs/DefaultApi.md#post_api_graph_catalog_name) | **POST** /api/graph/{catalogName} | Generate Graph
*DefaultApi* | [**post_api_relationship**](docs/DefaultApi.md#post_api_relationship) | **POST** /api/relationship | Create Relationships
*DefaultApi* | [**post_api_search**](docs/DefaultApi.md#post_api_search) | **POST** /api/search | Your POST endpoint

## Documentation For Models

 - [ErrorResponse](docs/ErrorResponse.md)
 - [GraphRequest](docs/GraphRequest.md)
 - [GraphRequestItem](docs/GraphRequestItem.md)
 - [GraphRequestItemNodeIdInfo](docs/GraphRequestItemNodeIdInfo.md)
 - [GraphResponse](docs/GraphResponse.md)
 - [OneOfGraphResponseEdges](docs/OneOfGraphResponseEdges.md)
 - [OneOfGraphResponseNodes](docs/OneOfGraphResponseNodes.md)
 - [Relationship](docs/Relationship.md)
 - [RelationshipUnusedParameterBody](docs/RelationshipUnusedParameterBody.md)
 - [SuccessResponseOnCRUD](docs/SuccessResponseOnCRUD.md)

## Documentation For Authorization


## JWT

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

admin@suketa.in
