# coding: utf-8

"""
    Anansi REST API

    These endpoints describe the REST API of the Anansi Data Lineage Tool. The Catalog endpoint is for saving data into Nodes. The Relationships endpoints is for connecting data between Nodes. The endpoints use JWT as the security mechanism.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: admin@suketa.in
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from anansi_sdk.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_api_catalog_table_name(self, table_name, unused_parameter, catalog_name, **kwargs):  # noqa: E501
        """Delete Catalog Entries  # noqa: E501

        Delete multiple records. The \"x\" in the endpoint does not mean anything. It's just used as a placeholder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_catalog_table_name(table_name, unused_parameter, catalog_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param str unused_parameter: This is a unused parameter. It can be set to anything. (required)
        :param str catalog_name: Catalog Name (Optional, but recommended)
        :param list[object] body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_api_catalog_table_name_with_http_info(table_name, unused_parameter, catalog_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_api_catalog_table_name_with_http_info(table_name, unused_parameter, catalog_name, **kwargs)  # noqa: E501
            return data

    def delete_api_catalog_table_name_with_http_info(self, table_name, unused_parameter, catalog_name, **kwargs):  # noqa: E501
        """Delete Catalog Entries  # noqa: E501

        Delete multiple records. The \"x\" in the endpoint does not mean anything. It's just used as a placeholder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_catalog_table_name_with_http_info(table_name, unused_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param str unused_parameter: This is a unused parameter. It can be set to anything. (required)
        :param str catalog_name: Catalog Name (Optional, but recommended)
        :param list[object] body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_name', 'unused_parameter', 'catalog_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_api_catalog_table_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'table_name' is set
        if ('table_name' not in params or
                params['table_name'] is None):
            raise ValueError("Missing the required parameter `table_name` when calling `delete_api_catalog_table_name`")  # noqa: E501
        # verify the required parameter 'unused_parameter' is set
        if ('unused_parameter' not in params or
                params['unused_parameter'] is None):
            raise ValueError("Missing the required parameter `unused_parameter` when calling `delete_api_catalog_table_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'table_name' in params:
            path_params['tableName'] = params['table_name']  # noqa: E501
        if 'unused_parameter' in params:
            path_params['unusedParameter'] = params['unused_parameter']  # noqa: E501

        query_params = []

        header_params = {}
        
        if 'catalog_name' in params:
            path_params['Catalogname'] = params['catalog_name']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/catalog/{tableName}/{unusedParameter}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponseOnCRUD',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_api_relationship_unused_parameter_catalog_name(self, catalogname, unused_parameter, **kwargs):  # noqa: E501
        """Delete Relationships  # noqa: E501

        Multiple Relationships can be deleted at once.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_relationship_unused_parameter_catalog_name(catalogname, unused_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param str unused_parameter: Unused but required parameter. (required)
        :param list[RelationshipUnusedParameterBody] body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_api_relationship_unused_parameter_catalog_name_with_http_info(catalogname, unused_parameter, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_api_relationship_unused_parameter_catalog_name_with_http_info(catalogname, unused_parameter, **kwargs)  # noqa: E501
            return data

    def delete_api_relationship_unused_parameter_catalog_name_with_http_info(self, catalogname, unused_parameter, **kwargs):  # noqa: E501
        """Delete Relationships  # noqa: E501

        Multiple Relationships can be deleted at once.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_relationship_unused_parameter_catalog_name_with_http_info(catalogname, unused_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param str unused_parameter: Unused but required parameter. (required)
        :param list[RelationshipUnusedParameterBody] body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['catalogname', 'unused_parameter', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_api_relationship_unused_parameter_catalog_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'catalogname' is set
        if ('catalogname' not in params or
                params['catalogname'] is None):
            raise ValueError("Missing the required parameter `catalogname` when calling `delete_api_relationship_unused_parameter_catalog_name`")  # noqa: E501
        # verify the required parameter 'unused_parameter' is set
        if ('unused_parameter' not in params or
                params['unused_parameter'] is None):
            raise ValueError("Missing the required parameter `unused_parameter` when calling `delete_api_relationship_unused_parameter_catalog_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'unused_parameter' in params:
            path_params['UnusedParameter'] = params['unused_parameter']  # noqa: E501

        query_params = []

        header_params = {}
        if 'catalogname' in params:
            header_params['Catalogname'] = params['catalogname']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/relationship/{UnusedParameter}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponseOnCRUD',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_relationship(self, catalogname, limit, skip, **kwargs):  # noqa: E501
        """GET Relationships  # noqa: E501

        Gets Relationships  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_relationship(catalogname, limit, skip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param int limit: Number of Records returned (required)
        :param int skip: Number of Records to be skipped (required)
        :param str source_label: Name of the Source Node. Used for Filter. 
        :param str dest_label: Name of the Destination Node. Used for Filter.
        :param str relation_name: Type of Relationship. Used for Filter.
        :param str order_prop: Order By Property. Used for Sorting.
        :param str order_type: Ascending or Descending. Used for Sorting.
        :return: list[Relationship]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_relationship_with_http_info(catalogname, limit, skip, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_relationship_with_http_info(catalogname, limit, skip, **kwargs)  # noqa: E501
            return data

    def get_api_relationship_with_http_info(self, catalogname, limit, skip, **kwargs):  # noqa: E501
        """GET Relationships  # noqa: E501

        Gets Relationships  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_relationship_with_http_info(catalogname, limit, skip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param int limit: Number of Records returned (required)
        :param int skip: Number of Records to be skipped (required)
        :param str source_label: Name of the Source Node. Used for Filter. 
        :param str dest_label: Name of the Destination Node. Used for Filter.
        :param str relation_name: Type of Relationship. Used for Filter.
        :param str order_prop: Order By Property. Used for Sorting.
        :param str order_type: Ascending or Descending. Used for Sorting.
        :return: list[Relationship]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['catalogname', 'limit', 'skip', 'source_label', 'dest_label', 'relation_name', 'order_prop', 'order_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'catalogname' is set
        if ('catalogname' not in params or
                params['catalogname'] is None):
            raise ValueError("Missing the required parameter `catalogname` when calling `get_api_relationship`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `get_api_relationship`")  # noqa: E501
        # verify the required parameter 'skip' is set
        if ('skip' not in params or
                params['skip'] is None):
            raise ValueError("Missing the required parameter `skip` when calling `get_api_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'source_label' in params:
            query_params.append(('SourceLabel', params['source_label']))  # noqa: E501
        if 'dest_label' in params:
            query_params.append(('DestLabel', params['dest_label']))  # noqa: E501
        if 'relation_name' in params:
            query_params.append(('RelationName', params['relation_name']))  # noqa: E501
        if 'order_prop' in params:
            query_params.append(('orderProp', params['order_prop']))  # noqa: E501
        if 'order_type' in params:
            query_params.append(('orderType', params['order_type']))  # noqa: E501

        header_params = {}
        if 'catalogname' in params:
            header_params['Catalogname'] = params['catalogname']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/relationship', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Relationship]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_catalog_tablename(self, limit, skip, table_name, **kwargs):  # noqa: E501
        """Get Catalog Data by Table Name  # noqa: E501

        Retrieve the information from a particular node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalog_tablename(limit, skip, table_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of rows to return. (required)
        :param int skip: The number of rows to skip during a select. This mainly used for pagination. (required)
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param str _property: We can choose to return only 1 property
        :param str order_info_order_prop: Order by this property
        :param str order_info_order_type: Ascending or Descending Order. Default is Ascending Order.
        :param str optional_filter: Used for filtering data.
        :param str relation_info_name: Relationship Name
        :param str relation_info_node_name: Source Node
        :param str relation_info_unique_col_name: Source Node Unique Column Name
        :param str relation_info_id: Source Node Identifier
        :param str relation_info_direction: Direction Identifier
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_catalog_tablename_with_http_info(limit, skip, table_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_catalog_tablename_with_http_info(limit, skip, table_name, **kwargs)  # noqa: E501
            return data

    def get_catalog_tablename_with_http_info(self, limit, skip, table_name, **kwargs):  # noqa: E501
        """Get Catalog Data by Table Name  # noqa: E501

        Retrieve the information from a particular node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalog_tablename_with_http_info(limit, skip, table_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of rows to return. (required)
        :param int skip: The number of rows to skip during a select. This mainly used for pagination. (required)
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param str _property: We can choose to return only 1 property
        :param str order_info_order_prop: Order by this property
        :param str order_info_order_type: Ascending or Descending Order. Default is Ascending Order.
        :param str optional_filter: Used for filtering data.
        :param str relation_info_name: Relationship Name
        :param str relation_info_node_name: Source Node
        :param str relation_info_unique_col_name: Source Node Unique Column Name
        :param str relation_info_id: Source Node Identifier
        :param str relation_info_direction: Direction Identifier
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'skip', 'table_name', '_property', 'order_info_order_prop', 'order_info_order_type', 'optional_filter', 'relation_info_name', 'relation_info_node_name', 'relation_info_unique_col_name', 'relation_info_id', 'relation_info_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_catalog_tablename" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `get_catalog_tablename`")  # noqa: E501
        # verify the required parameter 'skip' is set
        if ('skip' not in params or
                params['skip'] is None):
            raise ValueError("Missing the required parameter `skip` when calling `get_catalog_tablename`")  # noqa: E501
        # verify the required parameter 'table_name' is set
        if ('table_name' not in params or
                params['table_name'] is None):
            raise ValueError("Missing the required parameter `table_name` when calling `get_catalog_tablename`")  # noqa: E501

        collection_formats = {}

        def handle_optional_filter(inp_opt_filter):
            if inp_opt_filter is not None:
                temp = inp_opt_filter.split(";")
                temp1 = [tuple(value.split(":")) for value in temp]
                return temp1
    
        path_params = {}
        if 'table_name' in params:
            path_params['tableName'] = params['table_name']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if '_property' in params:
            query_params.append(('property', params['_property']))  # noqa: E501
        if 'order_info_order_prop' in params:
            query_params.append(('orderInfo.orderProp', params['order_info_order_prop']))  # noqa: E501
        if 'order_info_order_type' in params:
            query_params.append(('orderInfo.orderType', params['order_info_order_type']))  # noqa: E501
        if 'optional_filter' in params:
            query_params.extend(handle_optional_filter(params['optional_filter']))  # noqa: E501
        if 'relation_info_name' in params:
            query_params.append(('relationInfo.name', params['relation_info_name']))  # noqa: E501
        if 'relation_info_node_name' in params:
            query_params.append(('relationInfo.nodeName', params['relation_info_node_name']))  # noqa: E501
        if 'relation_info_unique_col_name' in params:
            query_params.append(('relationInfo.uniqueColName', params['relation_info_unique_col_name']))  # noqa: E501
        if 'relation_info_id' in params:
            query_params.append(('relationInfo.id', params['relation_info_id']))  # noqa: E501
        if 'relation_info_direction' in params:
            query_params.append(('relationInfo.direction', params['relation_info_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/catalog/{tableName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_api_catalog_table_name_x(self, table_name, unused_parameter, **kwargs):  # noqa: E501
        """Update Properties in the table  # noqa: E501

        Unlike the other Apis, it can only update 1 row at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_api_catalog_table_name_x(table_name, unused_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param str unused_parameter: This is a unused parameter. It can be set to anything. (required)
        :param object body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_api_catalog_table_name_x_with_http_info(table_name, unused_parameter, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_api_catalog_table_name_x_with_http_info(table_name, unused_parameter, **kwargs)  # noqa: E501
            return data

    def patch_api_catalog_table_name_x_with_http_info(self, table_name, unused_parameter, **kwargs):  # noqa: E501
        """Update Properties in the table  # noqa: E501

        Unlike the other Apis, it can only update 1 row at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_api_catalog_table_name_x_with_http_info(table_name, unused_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param str unused_parameter: This is a unused parameter. It can be set to anything. (required)
        :param object body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_name', 'unused_parameter', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_api_catalog_table_name_x" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'table_name' is set
        if ('table_name' not in params or
                params['table_name'] is None):
            raise ValueError("Missing the required parameter `table_name` when calling `patch_api_catalog_table_name_x`")  # noqa: E501
        # verify the required parameter 'unused_parameter' is set
        if ('unused_parameter' not in params or
                params['unused_parameter'] is None):
            raise ValueError("Missing the required parameter `unused_parameter` when calling `patch_api_catalog_table_name_x`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'table_name' in params:
            path_params['tableName'] = params['table_name']  # noqa: E501
        if 'unused_parameter' in params:
            path_params['unusedParameter'] = params['unused_parameter']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/catalog/{tableName}/{unusedParameter}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponseOnCRUD',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_api_relationship(self, catalogname, unused_parameter, **kwargs):  # noqa: E501
        """Update Relationship  # noqa: E501

        Update Relationship data. Mainly to update Label and Description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_api_relationship(catalogname, unused_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param str unused_parameter: Unused but required parameter. (required)
        :param Relationship body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_api_relationship_with_http_info(catalogname, unused_parameter, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_api_relationship_with_http_info(catalogname, unused_parameter, **kwargs)  # noqa: E501
            return data

    def patch_api_relationship_with_http_info(self, catalogname, unused_parameter, **kwargs):  # noqa: E501
        """Update Relationship  # noqa: E501

        Update Relationship data. Mainly to update Label and Description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_api_relationship_with_http_info(catalogname, unused_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param str unused_parameter: Unused but required parameter. (required)
        :param Relationship body:
        :return: SuccessResponseOnCRUD
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['catalogname', 'unused_parameter', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_api_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'catalogname' is set
        if ('catalogname' not in params or
                params['catalogname'] is None):
            raise ValueError("Missing the required parameter `catalogname` when calling `patch_api_relationship`")  # noqa: E501
        # verify the required parameter 'unused_parameter' is set
        if ('unused_parameter' not in params or
                params['unused_parameter'] is None):
            raise ValueError("Missing the required parameter `unused_parameter` when calling `patch_api_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'unused_parameter' in params:
            path_params['UnusedParameter'] = params['unused_parameter']  # noqa: E501

        query_params = []

        header_params = {}
        if 'catalogname' in params:
            header_params['Catalogname'] = params['catalogname']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/relationship/{UnusedParameter}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponseOnCRUD',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_api_catalog_table_name(self, table_name, **kwargs):  # noqa: E501
        """Create New Entries in the Table  # noqa: E501

        Create Multiple rows in a Table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_catalog_table_name(table_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param list[object] body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_api_catalog_table_name_with_http_info(table_name, **kwargs)  # noqa: E501
        else:
            (data) = self.post_api_catalog_table_name_with_http_info(table_name, **kwargs)  # noqa: E501
            return data

    def post_api_catalog_table_name_with_http_info(self, table_name, **kwargs):  # noqa: E501
        """Create New Entries in the Table  # noqa: E501

        Create Multiple rows in a Table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_catalog_table_name_with_http_info(table_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str table_name: Also can be called Node Name interchangeably. (required)
        :param list[object] body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_api_catalog_table_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'table_name' is set
        if ('table_name' not in params or
                params['table_name'] is None):
            raise ValueError("Missing the required parameter `table_name` when calling `post_api_catalog_table_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'table_name' in params:
            path_params['tableName'] = params['table_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/catalog/{tableName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_api_graph_catalog_name(self, catalog_name, **kwargs):  # noqa: E501
        """Generate Graph  # noqa: E501

        Generate a Graph. There are 2 types of graphs possible. System View or Metadata View.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_graph_catalog_name(catalog_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalog_name: Name of the Catalog (required)
        :param GraphRequest body:
        :return: GraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_api_graph_catalog_name_with_http_info(catalog_name, **kwargs)  # noqa: E501
        else:
            (data) = self.post_api_graph_catalog_name_with_http_info(catalog_name, **kwargs)  # noqa: E501
            return data

    def post_api_graph_catalog_name_with_http_info(self, catalog_name, **kwargs):  # noqa: E501
        """Generate Graph  # noqa: E501

        Generate a Graph. There are 2 types of graphs possible. System View or Metadata View.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_graph_catalog_name_with_http_info(catalog_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalog_name: Name of the Catalog (required)
        :param GraphRequest body:
        :return: GraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['catalog_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_api_graph_catalog_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'catalog_name' is set
        if ('catalog_name' not in params or
                params['catalog_name'] is None):
            raise ValueError("Missing the required parameter `catalog_name` when calling `post_api_graph_catalog_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalog_name' in params:
            path_params['catalogName'] = params['catalog_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/graph/{catalogName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GraphResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_api_relationship(self, catalogname, **kwargs):  # noqa: E501
        """Create Relationships  # noqa: E501

        Create a Relationship between a Source Node and a Destination Node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_relationship(catalogname, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param list[Relationship] body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_api_relationship_with_http_info(catalogname, **kwargs)  # noqa: E501
        else:
            (data) = self.post_api_relationship_with_http_info(catalogname, **kwargs)  # noqa: E501
            return data

    def post_api_relationship_with_http_info(self, catalogname, **kwargs):  # noqa: E501
        """Create Relationships  # noqa: E501

        Create a Relationship between a Source Node and a Destination Node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_relationship_with_http_info(catalogname, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str catalogname: Source Catalog Name (required)
        :param list[Relationship] body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['catalogname', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_api_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'catalogname' is set
        if ('catalogname' not in params or
                params['catalogname'] is None):
            raise ValueError("Missing the required parameter `catalogname` when calling `post_api_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'catalogname' in params:
            header_params['Catalogname'] = params['catalogname']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/relationship', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_api_search(self, **kwargs):  # noqa: E501
        """Your POST endpoint  # noqa: E501

        Gets all the full text indexes with the prefix: \"fullText_\" and runs a search on the search term.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_search(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body:
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_api_search_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_api_search_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_api_search_with_http_info(self, **kwargs):  # noqa: E501
        """Your POST endpoint  # noqa: E501

        Gets all the full text indexes with the prefix: \"fullText_\" and runs a search on the search term.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_api_search_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body:
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_api_search" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/api/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
