# coding: utf-8

"""
    Anansi REST API

    These endpoints describe the REST API of the Anansi Data Lineage Tool. The Catalog endpoint is for saving data into Nodes. The Relationships endpoints is for connecting data between Nodes. The endpoints use JWT as the security mechanism.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: admin@suketa.in
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GraphRequestItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'case': 'str',
        'node_name': 'str',
        'node_unique_col_name': 'str',
        'node_id_info': 'GraphRequestItemNodeIdInfo'
    }

    attribute_map = {
        'case': 'Case',
        'node_name': 'nodeName',
        'node_unique_col_name': 'nodeUniqueColName',
        'node_id_info': 'nodeIdInfo'
    }

    def __init__(self, case='NodeGraphRequest', node_name=None, node_unique_col_name=None, node_id_info=None):  # noqa: E501
        """GraphRequestItem - a model defined in Swagger"""  # noqa: E501
        self._case = None
        self._node_name = None
        self._node_unique_col_name = None
        self._node_id_info = None
        self.discriminator = None
        self.case = case
        self.node_name = node_name
        self.node_unique_col_name = node_unique_col_name
        if node_id_info is not None:
            self.node_id_info = node_id_info

    @property
    def case(self):
        """Gets the case of this GraphRequestItem.  # noqa: E501


        :return: The case of this GraphRequestItem.  # noqa: E501
        :rtype: str
        """
        return self._case

    @case.setter
    def case(self, case):
        """Sets the case of this GraphRequestItem.


        :param case: The case of this GraphRequestItem.  # noqa: E501
        :type: str
        """
        if case is None:
            raise ValueError("Invalid value for `case`, must not be `None`")  # noqa: E501

        self._case = case

    @property
    def node_name(self):
        """Gets the node_name of this GraphRequestItem.  # noqa: E501


        :return: The node_name of this GraphRequestItem.  # noqa: E501
        :rtype: str
        """
        return self._node_name

    @node_name.setter
    def node_name(self, node_name):
        """Sets the node_name of this GraphRequestItem.


        :param node_name: The node_name of this GraphRequestItem.  # noqa: E501
        :type: str
        """
        if node_name is None:
            raise ValueError("Invalid value for `node_name`, must not be `None`")  # noqa: E501

        self._node_name = node_name

    @property
    def node_unique_col_name(self):
        """Gets the node_unique_col_name of this GraphRequestItem.  # noqa: E501


        :return: The node_unique_col_name of this GraphRequestItem.  # noqa: E501
        :rtype: str
        """
        return self._node_unique_col_name

    @node_unique_col_name.setter
    def node_unique_col_name(self, node_unique_col_name):
        """Sets the node_unique_col_name of this GraphRequestItem.


        :param node_unique_col_name: The node_unique_col_name of this GraphRequestItem.  # noqa: E501
        :type: str
        """
        if node_unique_col_name is None:
            raise ValueError("Invalid value for `node_unique_col_name`, must not be `None`")  # noqa: E501

        self._node_unique_col_name = node_unique_col_name

    @property
    def node_id_info(self):
        """Gets the node_id_info of this GraphRequestItem.  # noqa: E501


        :return: The node_id_info of this GraphRequestItem.  # noqa: E501
        :rtype: GraphRequestItemNodeIdInfo
        """
        return self._node_id_info

    @node_id_info.setter
    def node_id_info(self, node_id_info):
        """Sets the node_id_info of this GraphRequestItem.


        :param node_id_info: The node_id_info of this GraphRequestItem.  # noqa: E501
        :type: GraphRequestItemNodeIdInfo
        """

        self._node_id_info = node_id_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GraphRequestItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GraphRequestItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
