# coding: utf-8

"""
    Anansi REST API

    These endpoints describe the REST API of the Anansi Data Lineage Tool. The Catalog endpoint is for saving data into Nodes. The Relationships endpoints is for connecting data between Nodes. The endpoints use JWT as the security mechanism.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: admin@suketa.in
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GraphResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'title': 'str',
        'description': 'str',
        'graph_type': 'str',
        'nodes': 'OneOfGraphResponseNodes',
        'edges': 'OneOfGraphResponseEdges'
    }

    attribute_map = {
        'title': 'title',
        'description': 'description',
        'graph_type': 'graphType',
        'nodes': 'nodes',
        'edges': 'edges'
    }

    def __init__(self, title=None, description=None, graph_type=None, nodes=None, edges=None):  # noqa: E501
        """GraphResponse - a model defined in Swagger"""  # noqa: E501
        self._title = None
        self._description = None
        self._graph_type = None
        self._nodes = None
        self._edges = None
        self.discriminator = None
        if title is not None:
            self.title = title
        if description is not None:
            self.description = description
        self.graph_type = graph_type
        self.nodes = nodes
        self.edges = edges

    @property
    def title(self):
        """Gets the title of this GraphResponse.  # noqa: E501


        :return: The title of this GraphResponse.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this GraphResponse.


        :param title: The title of this GraphResponse.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def description(self):
        """Gets the description of this GraphResponse.  # noqa: E501


        :return: The description of this GraphResponse.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GraphResponse.


        :param description: The description of this GraphResponse.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def graph_type(self):
        """Gets the graph_type of this GraphResponse.  # noqa: E501


        :return: The graph_type of this GraphResponse.  # noqa: E501
        :rtype: str
        """
        return self._graph_type

    @graph_type.setter
    def graph_type(self, graph_type):
        """Sets the graph_type of this GraphResponse.


        :param graph_type: The graph_type of this GraphResponse.  # noqa: E501
        :type: str
        """
        if graph_type is None:
            raise ValueError("Invalid value for `graph_type`, must not be `None`")  # noqa: E501
        allowed_values = ["columnlineage", "SystemLineage"]  # noqa: E501
        if graph_type not in allowed_values:
            raise ValueError(
                "Invalid value for `graph_type` ({0}), must be one of {1}"  # noqa: E501
                .format(graph_type, allowed_values)
            )

        self._graph_type = graph_type

    @property
    def nodes(self):
        """Gets the nodes of this GraphResponse.  # noqa: E501


        :return: The nodes of this GraphResponse.  # noqa: E501
        :rtype: OneOfGraphResponseNodes
        """
        return self._nodes

    @nodes.setter
    def nodes(self, nodes):
        """Sets the nodes of this GraphResponse.


        :param nodes: The nodes of this GraphResponse.  # noqa: E501
        :type: OneOfGraphResponseNodes
        """
        if nodes is None:
            raise ValueError("Invalid value for `nodes`, must not be `None`")  # noqa: E501

        self._nodes = nodes

    @property
    def edges(self):
        """Gets the edges of this GraphResponse.  # noqa: E501


        :return: The edges of this GraphResponse.  # noqa: E501
        :rtype: OneOfGraphResponseEdges
        """
        return self._edges

    @edges.setter
    def edges(self, edges):
        """Sets the edges of this GraphResponse.


        :param edges: The edges of this GraphResponse.  # noqa: E501
        :type: OneOfGraphResponseEdges
        """
        if edges is None:
            raise ValueError("Invalid value for `edges`, must not be `None`")  # noqa: E501

        self._edges = edges

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GraphResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GraphResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
