# Sweetheart **0.1.1**
*do better with low-code and low-costs python programs*

## A supercharged heart for the non-expert hands

Since Ubuntu 20.04 can be installed as usual softwares within Windows 10, it provides an incredible way for any organization to develop, deploy, and administrate **powerful responsive web-apps including AI** on its own local network keeping high capabilities of integration with the already existing tools like databases, MS-Excel, and SAP.

Sweetheart provides a simple Python/Html centric approach leading you implementing best components and best coding practices. Due to the current top-rated place of the Python language regarding to data processing, calculations and AI, this makes sweetheart a fast and ideal toolkit to e-volute towards **Industry4.0** precepts and innovative ideas.

Sweetheart is shared under the [CeCILL-C FREE SOFTWARE LICENSE AGREEMENT](https://github.com/IncredibleProgress/sweetheart.py/blob/master/LICENSE).

## Get coding full power at the speedlight including AI

Sweetheart supports you getting coding full power from scratch:

- easy to learn, easy to use
- full documentation provided
- built-in responsive user interfaces
- quick and clean prototyping
- quick and clean deployment
- ready for maintenable great code quality
- ready for datacenters, big-data and AI
- ready for high performances, innovation and creativity

## Stick to good standards without thinking about it

Sweetheart is a thin-layer for going efficient and doesn't reinvent the wheel. It just intends to transform you step-wise in a good driver and maybe in a pilot! Due to provided components, configuration and documentation **you will learn quickly to make great python/html code** including up-to-date best practices and patterns. You won't learn Sweetheart itself, you will learn Python/Html real programming life like any other developer, but gradually and under control. Meaning that you don't need any kind of expertise to use the good things in the right way.

## The highest quality components which can be adopted by newbies

Sweetheart delivers a stock of ready-to-use features:

- backend language: [**Python**](https://www.python.org/)
- provided database server: [**MongoDB**](https://www.mongodb.com/)
- provided asynchronous webserver: [Uvicorn](https://www.uvicorn.org/)
- optionnal webserver for static contents: [CherryPy](https://cherrypy.org/)
- provided asgi framework: [Starlette](https://www.starlette.io/), [FastApi](https://fastapi.tiangolo.com/)
- provided fast documentation builder: [mdBook](https://rust-lang.github.io/mdBook/index.html)
- responsive user interfaces: [Html](https://www.w3schools.com/), [JupyterLab](https://jupyter.org/)
- provided web libs for going fast: [Bootstrap](https://getbootstrap.com/)
- provided web libs for high-level featuring: [Vue](https://vuejs.org/)
- optionnal frontend language: [Typescript](https://www.typescriptlang.org/), [WebAssembly](https://www.assemblyscript.org/)
- optionnal low-level language: [Rust](https://www.rust-lang.org/)

**And all other nice things you wish** using [apt](https://en.wikipedia.org/wiki/APT_(software)), [cargo](https://doc.rust-lang.org/cargo/), [pip](https://pip.pypa.io/en/stable/) and [npm](https://docs.npmjs.com/about-npm/): Sweetheart comes with the above mentioned package to support you saving time. Your are not forced to use these components, but these are what you should highly consider for starting any new project.

In a first approach just consider these provide to you **an incredible full-stacked sandbox**. In a second time you will take benefits of Sweetheart as a low-costs and convenient super-orchestrator.

## Keep permanently innovative capabilities

The following *sweetheart development chart* allows to evaluate coding and costs efforts for implementation of most important and innovative features at the date of today.

|                                              | Coding effort | Costs effort |
| :------------------------------------------- | :-----------: | :----------: |
| Build responsive webapp with default libs    | FAST          | FREE         |
| Build responsive datavisualizations          | MIDDLE        | FREE         |
| Run MongoDB/webserver on local network       | FAST          | FREE         |
| Improve code quality and reinforce security  | EXPERT        | CHEAP        |
| Run MongoDB/webserver as internet services   | MIDDLE        | MODERATE     |
| Implement AI capabilities                    | MIDDLE        | MODERATE     |
| Implement SAP gateway                        | MIDDLE        | MODERATE     |
| Erect and run a dedicated datacenter         | EXPERT        | HIGH         |

## Code examples

### your first webpage controller written in Python

``` python
from sweetheart.sweet import quickstart
from sweetheart.heart import Route, HTMLResponse

quickstart( Route("/", HTMLResponse("<h1>Welcome!</h1>")) )
```

### your first *sweet* Html webpage

``` html
%rebase("SWEET.HTML")

<div style="text-align:center;">
  <h1>Welcome!</h1>
  <p>get coding full power at the speedlight</p>
</div>
```

## Install and run Sweetheart

### first steps with Bash

``` bash
#1: set prerequisites
curl -sSL https://raw.githubusercontent.com/IncredibleProgress/sweetheart.py/master/get-sweetheart.py | python3 -
#2: get sweetheart components
sws sweet --init
#3: run sweetheart enabling JupyterLab 
sws start --jupyter-lab
```

Be quite, there are no heavy installation process which could badly interact with the operating system. Everything goes and runs safely within dedicated */home* directories. [Click-here]() for detailed informations.

### go one with many additionnal resources

``` bash
# get calculation, machine-learning and ms-excel components
sws install science
```

## Epilogue: a new life starts now

Even at this Beta step, Sweetheart allows you to make a lot by yourself. Enjoy discovering and learning how coding can help and support you, using amazing raw materials widely used by GAFAM and others!
