# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sweetheart']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'sweetheart',
    'version': '0.1.1a0',
    'description': 'less code, more power, AI included',
    'long_description': '# Sweetheart **0.1.1**\n*do better with low-code and low-costs python programs*\n\n## A supercharged heart for the non-expert hands\n\nSince Ubuntu 20.04 can be installed as usual softwares within Windows 10, it provides an incredible way for any organization to develop, deploy, and administrate **powerful responsive web-apps including AI** on its own local network keeping high capabilities of integration with the already existing tools like databases, MS-Excel, and SAP.\n\nSweetheart provides a simple Python/Html centric approach leading you implementing best components and best coding practices. Due to the current top-rated place of the Python language regarding to data processing, calculations and AI, this makes sweetheart a fast and ideal toolkit to e-volute towards **Industry4.0** precepts and innovative ideas.\n\nSweetheart is shared under the [CeCILL-C FREE SOFTWARE LICENSE AGREEMENT](https://github.com/IncredibleProgress/sweetheart.py/blob/master/LICENSE).\n\n## Get coding full power at the speedlight including AI\n\nSweetheart supports you getting coding full power from scratch:\n\n- easy to learn, easy to use\n- full documentation provided\n- built-in responsive user interfaces\n- quick and clean prototyping\n- quick and clean deployment\n- ready for maintenable great code quality\n- ready for datacenters, big-data and AI\n- ready for high performances, innovation and creativity\n\n## Stick to good standards without thinking about it\n\nSweetheart is a thin-layer for going efficient and doesn\'t reinvent the wheel. It just intends to transform you step-wise in a good driver and maybe in a pilot! Due to provided components, configuration and documentation **you will learn quickly to make great python/html code** including up-to-date best practices and patterns. You won\'t learn Sweetheart itself, you will learn Python/Html real programming life like any other developer, but gradually and under control. Meaning that you don\'t need any kind of expertise to use the good things in the right way.\n\n## The highest quality components which can be adopted by newbies\n\nSweetheart delivers a stock of ready-to-use features:\n\n- backend language: [**Python**](https://www.python.org/)\n- provided database server: [**MongoDB**](https://www.mongodb.com/)\n- provided asynchronous webserver: [Uvicorn](https://www.uvicorn.org/)\n- optionnal webserver for static contents: [CherryPy](https://cherrypy.org/)\n- provided asgi framework: [Starlette](https://www.starlette.io/), [FastApi](https://fastapi.tiangolo.com/)\n- provided fast documentation builder: [mdBook](https://rust-lang.github.io/mdBook/index.html)\n- responsive user interfaces: [Html](https://www.w3schools.com/), [JupyterLab](https://jupyter.org/)\n- provided web libs for going fast: [Bootstrap](https://getbootstrap.com/)\n- provided web libs for high-level featuring: [Vue](https://vuejs.org/)\n- optionnal frontend language: [Typescript](https://www.typescriptlang.org/), [WebAssembly](https://www.assemblyscript.org/)\n- optionnal low-level language: [Rust](https://www.rust-lang.org/)\n\n**And all other nice things you wish** using [apt](https://en.wikipedia.org/wiki/APT_(software)), [cargo](https://doc.rust-lang.org/cargo/), [pip](https://pip.pypa.io/en/stable/) and [npm](https://docs.npmjs.com/about-npm/): Sweetheart comes with the above mentioned package to support you saving time. Your are not forced to use these components, but these are what you should highly consider for starting any new project.\n\nIn a first approach just consider these provide to you **an incredible full-stacked sandbox**. In a second time you will take benefits of Sweetheart as a low-costs and convenient super-orchestrator.\n\n## Keep permanently innovative capabilities\n\nThe following *sweetheart development chart* allows to evaluate coding and costs efforts for implementation of most important and innovative features at the date of today.\n\n|                                              | Coding effort | Costs effort |\n| :------------------------------------------- | :-----------: | :----------: |\n| Build responsive webapp with default libs    | FAST          | FREE         |\n| Build responsive datavisualizations          | MIDDLE        | FREE         |\n| Run MongoDB/webserver on local network       | FAST          | FREE         |\n| Improve code quality and reinforce security  | EXPERT        | CHEAP        |\n| Run MongoDB/webserver as internet services   | MIDDLE        | MODERATE     |\n| Implement AI capabilities                    | MIDDLE        | MODERATE     |\n| Implement SAP gateway                        | MIDDLE        | MODERATE     |\n| Erect and run a dedicated datacenter         | EXPERT        | HIGH         |\n\n## Code examples\n\n### your first webpage controller written in Python\n\n``` python\nfrom sweetheart.sweet import quickstart\nfrom sweetheart.heart import Route, HTMLResponse\n\nquickstart( Route("/", HTMLResponse("<h1>Welcome!</h1>")) )\n```\n\n### your first *sweet* Html webpage\n\n``` html\n%rebase("SWEET.HTML")\n\n<div style="text-align:center;">\n  <h1>Welcome!</h1>\n  <p>get coding full power at the speedlight</p>\n</div>\n```\n\n## Install and run Sweetheart\n\n### first steps with Bash\n\n``` bash\n#1: set prerequisites\ncurl -sSL https://raw.githubusercontent.com/IncredibleProgress/sweetheart.py/master/get-sweetheart.py | python3 -\n#2: get sweetheart components\nsws sweet --init\n#3: run sweetheart enabling JupyterLab \nsws start --jupyter-lab\n```\n\nBe quite, there are no heavy installation process which could badly interact with the operating system. Everything goes and runs safely within dedicated */home* directories. [Click-here]() for detailed informations.\n\n### go one with many additionnal resources\n\n``` bash\n# get calculation, machine-learning and ms-excel components\nsws install science\n```\n\n## Epilogue: a new life starts now\n\nEven at this Beta step, Sweetheart allows you to make a lot by yourself. Enjoy discovering and learning how coding can help and support you, using amazing raw materials widely used by GAFAM and others!\n',
    'author': 'Nicolas Champion',
    'author_email': 'champion.nicolas@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/IncredibleProgress/sweetheart.py',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
