<a id="mypy-boto3-rekognition"></a>

# mypy-boto3-rekognition

[![PyPI - mypy-boto3-rekognition](https://img.shields.io/pypi/v/mypy-boto3-rekognition.svg?color=blue)](https://pypi.org/project/mypy-boto3-rekognition)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-rekognition.svg?color=blue)](https://pypi.org/project/mypy-boto3-rekognition)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-rekognition?color=blue)](https://pypistats.org/packages/mypy-boto3-rekognition)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Rekognition 1.18.2](https://boto3.amazonaws.com/v1/documentation/api/1.18.2/reference/services/rekognition.html#Rekognition)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-rekognition docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rekognition/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-rekognition](#mypy-boto3-rekognition)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Rekognition` service.

```bash
python -m pip install boto3-stubs[rekognition]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[rekognition]` in your environment:
  `python -m pip install 'boto3-stubs[rekognition]'`

Both type checking and auto-complete should work for `Rekognition` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[rekognition]` in your environment:
  `python -m pip install 'boto3-stubs[rekognition]'`

Both type checking and auto-complete should work for `Rekognition` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[rekognition]` in your environment:
  `python -m pip install 'boto3-stubs[rekognition]'`
- Run `mypy` as usual

Type checking should work for `Rekognition` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[rekognition]` in your environment:
  `python -m pip install 'boto3-stubs[rekognition]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Rekognition` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`RekognitionClient` provides annotations for `boto3.client("rekognition")`.

```python
import boto3

from mypy_boto3_rekognition import RekognitionClient

client: RekognitionClient = boto3.client("rekognition")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RekognitionClient = session.client("rekognition")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_rekognition.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_rekognition import RekognitionClient
from mypy_boto3_rekognition.paginator import (
    DescribeProjectVersionsPaginator,
    DescribeProjectsPaginator,
    ListCollectionsPaginator,
    ListFacesPaginator,
    ListStreamProcessorsPaginator,
)

client: RekognitionClient = boto3.client("rekognition")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_project_versions_paginator: DescribeProjectVersionsPaginator = client.get_paginator("describe_project_versions")
describe_projects_paginator: DescribeProjectsPaginator = client.get_paginator("describe_projects")
list_collections_paginator: ListCollectionsPaginator = client.get_paginator("list_collections")
list_faces_paginator: ListFacesPaginator = client.get_paginator("list_faces")
list_stream_processors_paginator: ListStreamProcessorsPaginator = client.get_paginator("list_stream_processors")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_rekognition.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_rekognition import RekognitionClient
from mypy_boto3_rekognition.waiter import (
    ProjectVersionRunningWaiter,
    ProjectVersionTrainingCompletedWaiter,
)

client: RekognitionClient = boto3.client("rekognition")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
project_version_running_waiter: ProjectVersionRunningWaiter = client.get_waiter("project_version_running")
project_version_training_completed_waiter: ProjectVersionTrainingCompletedWaiter = client.get_waiter("project_version_training_completed")
```

<a id="literals"></a>

### Literals

`mypy_boto3_rekognition.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_rekognition.literals import (
    AttributeType,
    BodyPartType,
    CelebrityRecognitionSortByType,
    ContentClassifierType,
    ContentModerationSortByType,
    DescribeProjectVersionsPaginatorName,
    DescribeProjectsPaginatorName,
    EmotionNameType,
    FaceAttributesType,
    FaceSearchSortByType,
    GenderTypeType,
    LabelDetectionSortByType,
    LandmarkTypeType,
    ListCollectionsPaginatorName,
    ListFacesPaginatorName,
    ListStreamProcessorsPaginatorName,
    OrientationCorrectionType,
    PersonTrackingSortByType,
    ProjectStatusType,
    ProjectVersionRunningWaiterName,
    ProjectVersionStatusType,
    ProjectVersionTrainingCompletedWaiterName,
    ProtectiveEquipmentTypeType,
    QualityFilterType,
    ReasonType,
    SegmentTypeType,
    StreamProcessorStatusType,
    TechnicalCueTypeType,
    TextTypesType,
    VideoJobStatusType,
)

def check_value(value: AttributeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_rekognition.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_rekognition.type_defs import (
    AgeRangeTypeDef,
    AssetTypeDef,
    AudioMetadataTypeDef,
    BeardTypeDef,
    BoundingBoxTypeDef,
    CelebrityDetailTypeDef,
    CelebrityRecognitionTypeDef,
    CelebrityTypeDef,
    CompareFacesMatchTypeDef,
    CompareFacesRequestRequestTypeDef,
    CompareFacesResponseTypeDef,
    ComparedFaceTypeDef,
    ComparedSourceImageFaceTypeDef,
    ContentModerationDetectionTypeDef,
    CoversBodyPartTypeDef,
    CreateCollectionRequestRequestTypeDef,
    CreateCollectionResponseTypeDef,
    CreateProjectRequestRequestTypeDef,
    CreateProjectResponseTypeDef,
    CreateProjectVersionRequestRequestTypeDef,
    CreateProjectVersionResponseTypeDef,
    CreateStreamProcessorRequestRequestTypeDef,
    CreateStreamProcessorResponseTypeDef,
    CustomLabelTypeDef,
    DeleteCollectionRequestRequestTypeDef,
    DeleteCollectionResponseTypeDef,
    DeleteFacesRequestRequestTypeDef,
    DeleteFacesResponseTypeDef,
    DeleteProjectRequestRequestTypeDef,
    DeleteProjectResponseTypeDef,
    DeleteProjectVersionRequestRequestTypeDef,
    DeleteProjectVersionResponseTypeDef,
    DeleteStreamProcessorRequestRequestTypeDef,
    DescribeCollectionRequestRequestTypeDef,
    DescribeCollectionResponseTypeDef,
    DescribeProjectVersionsRequestRequestTypeDef,
    DescribeProjectVersionsResponseTypeDef,
    DescribeProjectsRequestRequestTypeDef,
    DescribeProjectsResponseTypeDef,
    DescribeStreamProcessorRequestRequestTypeDef,
    DescribeStreamProcessorResponseTypeDef,
    DetectCustomLabelsRequestRequestTypeDef,
    DetectCustomLabelsResponseTypeDef,
    DetectFacesRequestRequestTypeDef,
    DetectFacesResponseTypeDef,
    DetectLabelsRequestRequestTypeDef,
    DetectLabelsResponseTypeDef,
    DetectModerationLabelsRequestRequestTypeDef,
    DetectModerationLabelsResponseTypeDef,
    DetectProtectiveEquipmentRequestRequestTypeDef,
    DetectProtectiveEquipmentResponseTypeDef,
    DetectTextFiltersTypeDef,
    DetectTextRequestRequestTypeDef,
    DetectTextResponseTypeDef,
    DetectionFilterTypeDef,
    EmotionTypeDef,
    EquipmentDetectionTypeDef,
    EvaluationResultTypeDef,
    EyeOpenTypeDef,
    EyeglassesTypeDef,
    FaceDetailTypeDef,
    FaceDetectionTypeDef,
    FaceMatchTypeDef,
    FaceRecordTypeDef,
    FaceSearchSettingsTypeDef,
    FaceTypeDef,
    GenderTypeDef,
    GeometryTypeDef,
    GetCelebrityInfoRequestRequestTypeDef,
    GetCelebrityInfoResponseTypeDef,
    GetCelebrityRecognitionRequestRequestTypeDef,
    GetCelebrityRecognitionResponseTypeDef,
    GetContentModerationRequestRequestTypeDef,
    GetContentModerationResponseTypeDef,
    GetFaceDetectionRequestRequestTypeDef,
    GetFaceDetectionResponseTypeDef,
    GetFaceSearchRequestRequestTypeDef,
    GetFaceSearchResponseTypeDef,
    GetLabelDetectionRequestRequestTypeDef,
    GetLabelDetectionResponseTypeDef,
    GetPersonTrackingRequestRequestTypeDef,
    GetPersonTrackingResponseTypeDef,
    GetSegmentDetectionRequestRequestTypeDef,
    GetSegmentDetectionResponseTypeDef,
    GetTextDetectionRequestRequestTypeDef,
    GetTextDetectionResponseTypeDef,
    GroundTruthManifestTypeDef,
    HumanLoopActivationOutputTypeDef,
    HumanLoopConfigTypeDef,
    HumanLoopDataAttributesTypeDef,
    ImageQualityTypeDef,
    ImageTypeDef,
    IndexFacesRequestRequestTypeDef,
    IndexFacesResponseTypeDef,
    InstanceTypeDef,
    KinesisDataStreamTypeDef,
    KinesisVideoStreamTypeDef,
    LabelDetectionTypeDef,
    LabelTypeDef,
    LandmarkTypeDef,
    ListCollectionsRequestRequestTypeDef,
    ListCollectionsResponseTypeDef,
    ListFacesRequestRequestTypeDef,
    ListFacesResponseTypeDef,
    ListStreamProcessorsRequestRequestTypeDef,
    ListStreamProcessorsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ModerationLabelTypeDef,
    MouthOpenTypeDef,
    MustacheTypeDef,
    NotificationChannelTypeDef,
    OutputConfigTypeDef,
    PaginatorConfigTypeDef,
    ParentTypeDef,
    PersonDetailTypeDef,
    PersonDetectionTypeDef,
    PersonMatchTypeDef,
    PointTypeDef,
    PoseTypeDef,
    ProjectDescriptionTypeDef,
    ProjectVersionDescriptionTypeDef,
    ProtectiveEquipmentBodyPartTypeDef,
    ProtectiveEquipmentPersonTypeDef,
    ProtectiveEquipmentSummarizationAttributesTypeDef,
    ProtectiveEquipmentSummaryTypeDef,
    RecognizeCelebritiesRequestRequestTypeDef,
    RecognizeCelebritiesResponseTypeDef,
    RegionOfInterestTypeDef,
    ResponseMetadataTypeDef,
    S3ObjectTypeDef,
    SearchFacesByImageRequestRequestTypeDef,
    SearchFacesByImageResponseTypeDef,
    SearchFacesRequestRequestTypeDef,
    SearchFacesResponseTypeDef,
    SegmentDetectionTypeDef,
    SegmentTypeInfoTypeDef,
    ShotSegmentTypeDef,
    SmileTypeDef,
    StartCelebrityRecognitionRequestRequestTypeDef,
    StartCelebrityRecognitionResponseTypeDef,
    StartContentModerationRequestRequestTypeDef,
    StartContentModerationResponseTypeDef,
    StartFaceDetectionRequestRequestTypeDef,
    StartFaceDetectionResponseTypeDef,
    StartFaceSearchRequestRequestTypeDef,
    StartFaceSearchResponseTypeDef,
    StartLabelDetectionRequestRequestTypeDef,
    StartLabelDetectionResponseTypeDef,
    StartPersonTrackingRequestRequestTypeDef,
    StartPersonTrackingResponseTypeDef,
    StartProjectVersionRequestRequestTypeDef,
    StartProjectVersionResponseTypeDef,
    StartSegmentDetectionFiltersTypeDef,
    StartSegmentDetectionRequestRequestTypeDef,
    StartSegmentDetectionResponseTypeDef,
    StartShotDetectionFilterTypeDef,
    StartStreamProcessorRequestRequestTypeDef,
    StartTechnicalCueDetectionFilterTypeDef,
    StartTextDetectionFiltersTypeDef,
    StartTextDetectionRequestRequestTypeDef,
    StartTextDetectionResponseTypeDef,
    StopProjectVersionRequestRequestTypeDef,
    StopProjectVersionResponseTypeDef,
    StopStreamProcessorRequestRequestTypeDef,
    StreamProcessorInputTypeDef,
    StreamProcessorOutputTypeDef,
    StreamProcessorSettingsTypeDef,
    StreamProcessorTypeDef,
    SummaryTypeDef,
    SunglassesTypeDef,
    TagResourceRequestRequestTypeDef,
    TechnicalCueSegmentTypeDef,
    TestingDataResultTypeDef,
    TestingDataTypeDef,
    TextDetectionResultTypeDef,
    TextDetectionTypeDef,
    TrainingDataResultTypeDef,
    TrainingDataTypeDef,
    UnindexedFaceTypeDef,
    UntagResourceRequestRequestTypeDef,
    ValidationDataTypeDef,
    VideoMetadataTypeDef,
    VideoTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AgeRangeTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-rekognition` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-rekognition docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rekognition/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
