# coding: utf-8

"""
    ARLAS Exploration API

    Explore the content of ARLAS collections  # noqa: E501

    OpenAPI spec version: 23.0.1
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Aggregation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'field': 'str',
        'interval': 'Interval',
        'format': 'str',
        'metrics': 'list[Metric]',
        'order': 'str',
        'on': 'str',
        'size': 'str',
        'include': 'str',
        'raw_geometries': 'list[RawGeometry]',
        'aggregated_geometries': 'list[str]',
        'fetch_hits': 'HitsFetcher'
    }

    attribute_map = {
        'type': 'type',
        'field': 'field',
        'interval': 'interval',
        'format': 'format',
        'metrics': 'metrics',
        'order': 'order',
        'on': 'on',
        'size': 'size',
        'include': 'include',
        'raw_geometries': 'raw_geometries',
        'aggregated_geometries': 'aggregated_geometries',
        'fetch_hits': 'fetch_hits'
    }

    def __init__(self, type=None, field=None, interval=None, format=None, metrics=None, order=None, on=None, size=None, include=None, raw_geometries=None, aggregated_geometries=None, fetch_hits=None):  # noqa: E501
        """Aggregation - a model defined in Swagger"""  # noqa: E501

        self._type = None
        self._field = None
        self._interval = None
        self._format = None
        self._metrics = None
        self._order = None
        self._on = None
        self._size = None
        self._include = None
        self._raw_geometries = None
        self._aggregated_geometries = None
        self._fetch_hits = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if field is not None:
            self.field = field
        if interval is not None:
            self.interval = interval
        if format is not None:
            self.format = format
        if metrics is not None:
            self.metrics = metrics
        if order is not None:
            self.order = order
        if on is not None:
            self.on = on
        if size is not None:
            self.size = size
        if include is not None:
            self.include = include
        if raw_geometries is not None:
            self.raw_geometries = raw_geometries
        if aggregated_geometries is not None:
            self.aggregated_geometries = aggregated_geometries
        if fetch_hits is not None:
            self.fetch_hits = fetch_hits

    @property
    def type(self):
        """Gets the type of this Aggregation.  # noqa: E501


        :return: The type of this Aggregation.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Aggregation.


        :param type: The type of this Aggregation.  # noqa: E501
        :type: str
        """
        allowed_values = ["datehistogram", "geohash", "geotile", "histogram", "term", "h3"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def field(self):
        """Gets the field of this Aggregation.  # noqa: E501


        :return: The field of this Aggregation.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this Aggregation.


        :param field: The field of this Aggregation.  # noqa: E501
        :type: str
        """

        self._field = field

    @property
    def interval(self):
        """Gets the interval of this Aggregation.  # noqa: E501


        :return: The interval of this Aggregation.  # noqa: E501
        :rtype: Interval
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this Aggregation.


        :param interval: The interval of this Aggregation.  # noqa: E501
        :type: Interval
        """

        self._interval = interval

    @property
    def format(self):
        """Gets the format of this Aggregation.  # noqa: E501


        :return: The format of this Aggregation.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this Aggregation.


        :param format: The format of this Aggregation.  # noqa: E501
        :type: str
        """

        self._format = format

    @property
    def metrics(self):
        """Gets the metrics of this Aggregation.  # noqa: E501


        :return: The metrics of this Aggregation.  # noqa: E501
        :rtype: list[Metric]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """Sets the metrics of this Aggregation.


        :param metrics: The metrics of this Aggregation.  # noqa: E501
        :type: list[Metric]
        """

        self._metrics = metrics

    @property
    def order(self):
        """Gets the order of this Aggregation.  # noqa: E501


        :return: The order of this Aggregation.  # noqa: E501
        :rtype: str
        """
        return self._order

    @order.setter
    def order(self, order):
        """Sets the order of this Aggregation.


        :param order: The order of this Aggregation.  # noqa: E501
        :type: str
        """
        allowed_values = ["asc", "desc"]  # noqa: E501
        if order not in allowed_values:
            raise ValueError(
                "Invalid value for `order` ({0}), must be one of {1}"  # noqa: E501
                .format(order, allowed_values)
            )

        self._order = order

    @property
    def on(self):
        """Gets the on of this Aggregation.  # noqa: E501


        :return: The on of this Aggregation.  # noqa: E501
        :rtype: str
        """
        return self._on

    @on.setter
    def on(self, on):
        """Sets the on of this Aggregation.


        :param on: The on of this Aggregation.  # noqa: E501
        :type: str
        """
        allowed_values = ["field", "count", "result"]  # noqa: E501
        if on not in allowed_values:
            raise ValueError(
                "Invalid value for `on` ({0}), must be one of {1}"  # noqa: E501
                .format(on, allowed_values)
            )

        self._on = on

    @property
    def size(self):
        """Gets the size of this Aggregation.  # noqa: E501


        :return: The size of this Aggregation.  # noqa: E501
        :rtype: str
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Aggregation.


        :param size: The size of this Aggregation.  # noqa: E501
        :type: str
        """

        self._size = size

    @property
    def include(self):
        """Gets the include of this Aggregation.  # noqa: E501


        :return: The include of this Aggregation.  # noqa: E501
        :rtype: str
        """
        return self._include

    @include.setter
    def include(self, include):
        """Sets the include of this Aggregation.


        :param include: The include of this Aggregation.  # noqa: E501
        :type: str
        """

        self._include = include

    @property
    def raw_geometries(self):
        """Gets the raw_geometries of this Aggregation.  # noqa: E501


        :return: The raw_geometries of this Aggregation.  # noqa: E501
        :rtype: list[RawGeometry]
        """
        return self._raw_geometries

    @raw_geometries.setter
    def raw_geometries(self, raw_geometries):
        """Sets the raw_geometries of this Aggregation.


        :param raw_geometries: The raw_geometries of this Aggregation.  # noqa: E501
        :type: list[RawGeometry]
        """

        self._raw_geometries = raw_geometries

    @property
    def aggregated_geometries(self):
        """Gets the aggregated_geometries of this Aggregation.  # noqa: E501


        :return: The aggregated_geometries of this Aggregation.  # noqa: E501
        :rtype: list[str]
        """
        return self._aggregated_geometries

    @aggregated_geometries.setter
    def aggregated_geometries(self, aggregated_geometries):
        """Sets the aggregated_geometries of this Aggregation.


        :param aggregated_geometries: The aggregated_geometries of this Aggregation.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["BBOX", "CENTROID", "CELL", "CELLCENTER", "GEOHASH", "GEOHASH_CENTER"]  # noqa: E501
        if not set(aggregated_geometries).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `aggregated_geometries` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(aggregated_geometries) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._aggregated_geometries = aggregated_geometries

    @property
    def fetch_hits(self):
        """Gets the fetch_hits of this Aggregation.  # noqa: E501


        :return: The fetch_hits of this Aggregation.  # noqa: E501
        :rtype: HitsFetcher
        """
        return self._fetch_hits

    @fetch_hits.setter
    def fetch_hits(self, fetch_hits):
        """Sets the fetch_hits of this Aggregation.


        :param fetch_hits: The fetch_hits of this Aggregation.  # noqa: E501
        :type: HitsFetcher
        """

        self._fetch_hits = fetch_hits

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Aggregation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Aggregation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
