# Generated by Django 4.1.2 on 2022-11-29 06:33

import _socket
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_lab.managers
import edc_metadata.metadata_helper.metadata_helper_mixin
import edc_model.models.fields.duration
import edc_model.models.fields.initials_field
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import edc_vitals.models.fields.blood_pressure
import edc_vitals.models.fields.height
import edc_vitals.models.fields.waist_circumference
import edc_vitals.models.fields.weight
import intecomm_subject.models.subject_visit
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("intecomm_lists", "0002_delete_reasonsfortesting_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("edc_action_item", "0031_auto_20220922_2236"),
        ("edc_dx_review", "0001_initial"),
        ("edc_appointment", "0033_alter_appointment_appt_reason_and_more"),
        ("edc_lab", "0024_alter_manifestitem_managers"),
        ("edc_rx", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="DrugRefillDm",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "rx_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "rx_modified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Was the patient’s prescription changed at this visit compared with their prescription at the previous visit?",
                    ),
                ),
                (
                    "modifications_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "modifications_reason_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "return_in_days",
                    models.IntegerField(
                        verbose_name="In how many days has the patient been asked to return to clinic for a drug refill?"
                    ),
                ),
                (
                    "modifications",
                    models.ManyToManyField(
                        blank=True,
                        to="edc_rx.rxmodifications",
                        verbose_name="Which changes occurred?",
                    ),
                ),
                (
                    "modifications_reason",
                    models.ManyToManyField(
                        blank=True,
                        to="edc_rx.rxmodificationreasons",
                        verbose_name="Why did the patient’s previous prescription change?",
                    ),
                ),
                (
                    "rx",
                    models.ManyToManyField(
                        to="intecomm_lists.dmtreatments",
                        verbose_name="Which medicine did the patient receive today?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Drug Refill: Diabetes",
                "verbose_name_plural": "Drug Refills: Diabetes",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DrugRefillHiv",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "rx_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "rx_modified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Was the patient’s prescription changed at this visit compared with their prescription at the previous visit?",
                    ),
                ),
                (
                    "modifications_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "modifications_reason_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "return_in_days",
                    models.IntegerField(
                        verbose_name="In how many days has the patient been asked to return to clinic for a drug refill?"
                    ),
                ),
                (
                    "clinic_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="How many days supplied by the clinic",
                    ),
                ),
                (
                    "club_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="How many days supplied by a club",
                    ),
                ),
                (
                    "purchased_days",
                    models.IntegerField(
                        help_text="This can be purchased by patient, through a medicines club that the patient belong to, through insurance or someone else has paid. ",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="How many days supplied by to be purchased",
                    ),
                ),
                (
                    "modifications",
                    models.ManyToManyField(
                        blank=True,
                        to="edc_rx.rxmodifications",
                        verbose_name="Which changes occurred?",
                    ),
                ),
                (
                    "modifications_reason",
                    models.ManyToManyField(
                        blank=True,
                        to="edc_rx.rxmodificationreasons",
                        verbose_name="Why did the patient’s previous prescription change?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Drug Refill: HIV",
                "verbose_name_plural": "Drug Refills: HIV",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DrugRefillHtn",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "rx_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "rx_modified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Was the patient’s prescription changed at this visit compared with their prescription at the previous visit?",
                    ),
                ),
                (
                    "modifications_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "modifications_reason_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "return_in_days",
                    models.IntegerField(
                        verbose_name="In how many days has the patient been asked to return to clinic for a drug refill?"
                    ),
                ),
                (
                    "modifications",
                    models.ManyToManyField(
                        blank=True,
                        to="edc_rx.rxmodifications",
                        verbose_name="Which changes occurred?",
                    ),
                ),
                (
                    "modifications_reason",
                    models.ManyToManyField(
                        blank=True,
                        to="edc_rx.rxmodificationreasons",
                        verbose_name="Why did the patient’s previous prescription change?",
                    ),
                ),
                (
                    "rx",
                    models.ManyToManyField(
                        to="intecomm_lists.htntreatments",
                        verbose_name="Which medicine did the patient receive today?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Drug Refill: Hypertension",
                "verbose_name_plural": "Drug Refills: Hypertension",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(editable=False, max_length=50, null=True, unique=True),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(editable=False, max_length=18, null=True, unique=True),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model.models.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Specimen type"
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "panel",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_lab.panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_lab.managers.RequisitionManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("visit_code", models.CharField(editable=False, max_length=25, null=True)),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                            ("N/A", "Not applicable (if missed)"),
                        ],
                        default="alive",
                        help_text="If YES, submit Death report",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        help_text="Will be validated on the Death report",
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "document_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag as incomplete",
                        max_length=25,
                        verbose_name="Document status",
                    ),
                ),
                (
                    "document_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this document",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit (study)"),
                            ("unscheduled", "Routine / Unscheduled visit (non-study)"),
                            ("missed", "Missed visit"),
                        ],
                        help_text="If 'missed', fill in the separate missed visit report",
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("patient_unwell_outpatient", "Patient unwell"),
                            ("drug_refill", "Drug refill only"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "unschedule_self_referral",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="If 'unschedule', is this a self-referral?",
                    ),
                ),
                (
                    "unschedule_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If 'unschedule', please provide further details, if any",
                    ),
                ),
                (
                    "clinic_services_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("patient", "Patient"),
                            (
                                "patient_and_outpatient",
                                "Patient, hospital notes and/or outpatient card",
                            ),
                            (
                                "patient_representive",
                                "Patient Representative (e.family member, friend)",
                            ),
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("N/A", "Not applicable"),
                            ("OTHER", "Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "appointment",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_appointment.appointment",
                    ),
                ),
                (
                    "clinic_services",
                    models.ManyToManyField(
                        related_name="visit_clinic_services",
                        to="intecomm_lists.clinicservices",
                        verbose_name="Why is the patient at the clinic today?",
                    ),
                ),
                (
                    "health_services",
                    models.ManyToManyField(
                        related_name="visit_health_services",
                        to="intecomm_lists.healthservices",
                        verbose_name="Which health service(s) is the patient here for today?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "ordering": (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            bases=(
                edc_metadata.metadata_helper.metadata_helper_mixin.MetadataHelperMixin,
                models.Model,
            ),
            managers=[
                ("on_site", intecomm_subject.models.subject_visit.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.VisitModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ArvRegimens",
            fields=[],
            options={
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("intecomm_lists.arvregimens",),
        ),
        migrations.CreateModel(
            name="ViralLoadResult",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "vl_value",
                    models.IntegerField(
                        help_text="in copies/mL",
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(9999999),
                        ],
                        verbose_name="VL Result",
                    ),
                ),
                (
                    "vl_quantifier",
                    models.CharField(
                        choices=[("=", "="), (">", ">"), ("<", "<")],
                        default="=",
                        max_length=10,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "vl_units",
                    models.CharField(
                        default="copies/mL",
                        editable=False,
                        max_length=25,
                        verbose_name="Units",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "viral_load"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Viral Load Result",
                "verbose_name_plural": "Viral Load Results",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="UrinePregnancy",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the urine pregnancy test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "assay_date",
                    models.DateField(blank=True, null=True, verbose_name="Urine βhCG date"),
                ),
                (
                    "bhcg_value",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=25,
                        verbose_name="Urine βhCG result",
                    ),
                ),
                (
                    "notified",
                    models.BooleanField(
                        default=False,
                        editable=False,
                        help_text="Auto-updated by Pregnancy Notification PRN form",
                    ),
                ),
                (
                    "notified_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Auto-updated by Pregnancy Notification PRN form",
                        null=True,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Urine Pregnancy",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="UrineDipstickTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the urine dipstick test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "ketones",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Ketones?",
                    ),
                ),
                (
                    "protein",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Protein?",
                    ),
                ),
                (
                    "glucose",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Glucose?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Urine Dipstick Test",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectVisitMissed",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        help_text="If deceased, complete the death report",
                        max_length=25,
                        verbose_name="Survival status",
                    ),
                ),
                (
                    "contact_attempted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Not including pre-appointment reminders",
                        max_length=25,
                        verbose_name="Were any attempts made to contact the participant since the expected appointment date?",
                    ),
                ),
                (
                    "contact_attempts_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Not including pre-appointment reminders. Multiple attempts on the same day count as a single attempt.",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Number of attempts made to contact participantsince the expected appointment date",
                    ),
                ),
                (
                    "contact_attempts_explained",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If contact not made and less than 3 attempts, please explain",
                    ),
                ),
                (
                    "contact_last_date",
                    models.DateField(
                        blank=True,
                        default=edc_utils.date.get_utcnow,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_not_future,
                            edc_protocol.validators.date_not_before_study_start,
                        ],
                        verbose_name="Date of last telephone contact/attempt",
                    ),
                ),
                (
                    "contact_made",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Was contact finally made with the participant?",
                    ),
                ),
                (
                    "missed_reasons_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ltfu",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="No",
                        help_text="If 'Yes', complete the Loss to Follow up form",
                        max_length=15,
                        verbose_name="Has the participant met the protocol criteria for lost to follow up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide further details, if any",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "missed_reasons",
                    models.ManyToManyField(
                        blank=True,
                        related_name="meta_missed_reasons",
                        to="intecomm_lists.subjectvisitmissedreasons",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Missed Visit Report",
                "verbose_name_plural": "Missed Visit Report",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddField(
            model_name="subjectrequisition",
            name="subject_visit",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="intecomm_subject.subjectvisit"
            ),
        ),
        migrations.CreateModel(
            name="OtherBaselineData",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "employment_status",
                    models.CharField(
                        choices=[
                            ("professional", "Professional / office work / business"),
                            ("manual_work", "Skilled / Unskilled manual work"),
                            ("housewife", "Housewife"),
                            ("unemployed", "Not working / seeking work"),
                            ("retired", "Retired"),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="What is the patient's employment status?",
                    ),
                ),
                (
                    "employment_status_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "education",
                    models.CharField(
                        choices=[
                            ("no_formal_education", "No Formal Education"),
                            ("primary", "Up to primary"),
                            ("secondary", "Up to secondary / high school"),
                            ("tertiary", "university educated"),
                        ],
                        max_length=25,
                        verbose_name="How much formal education does the patient have?",
                    ),
                ),
                (
                    "marital_status",
                    models.CharField(
                        choices=[
                            ("married", "Married or living with someone"),
                            ("single", "Single"),
                            ("divorced", "Divorced"),
                            ("widowed", "Widow / Spinster"),
                        ],
                        max_length=25,
                        verbose_name="Personal status?",
                    ),
                ),
                (
                    "smoking_status",
                    models.CharField(
                        choices=[
                            ("smoker", "Currently smoke"),
                            ("former_smoker", "Used to smoke but stopped"),
                            ("nonsmoker", "Never smoked"),
                        ],
                        max_length=15,
                        verbose_name="Which of these options describes you",
                    ),
                ),
                (
                    "smoker_quit_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "smoker_quit_estimated_date",
                    models.DateField(
                        editable=False, null=True, verbose_name="Estimated date smoker quit?"
                    ),
                ),
                (
                    "alcohol",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you drink alcohol?",
                    ),
                ),
                (
                    "alcohol_consumption",
                    models.CharField(
                        choices=[
                            ("ocassionally", "Ocassionally"),
                            ("1_2_per_week", "1-2 times a week"),
                            ("3_4_per_week", "3-4 times a week"),
                            ("daily", "Daily"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If yes, how often do you drink alcohol?",
                    ),
                ),
                (
                    "work_activity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Does your work involve moderate or vigorous-intensity activity thatcauses small to large increases in breathing or heart rate like carrying or lifting loads, digging or construction work",
                    ),
                ),
                (
                    "work_activity_days",
                    models.IntegerField(
                        blank=True,
                        help_text="Give number of days in a 7-day week",
                        null=True,
                        verbose_name="In a typical week, how many days do you do these moderate or vigorous-intensity activities as part of your work?",
                    ),
                ),
                (
                    "work_activity_exercise",
                    models.IntegerField(
                        blank=True,
                        help_text="Give number of days in a 7-day week",
                        null=True,
                        verbose_name="In addition to the moderate or vigorous-intensity activity above, how many days do you do exercise, do sports or fitness activities in a typical week?",
                    ),
                ),
                (
                    "work_activity_exercise_time",
                    models.IntegerField(
                        blank=True,
                        help_text="Give number of minutes",
                        null=True,
                        verbose_name="On an average day, how long do you spend combined on the moderate or vigorous-intensity activities and doing exercise, sports and fitness activities?",
                    ),
                ),
                (
                    "num_vegetables_eaten",
                    models.IntegerField(
                        verbose_name="On average, how many vegetables do you eat in a day?"
                    ),
                ),
                (
                    "use_salt_on_food",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you add salt to your food in addition to what has been added when cooking?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Other Baseline Data",
                "verbose_name_plural": "Other Baseline Data",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Medications",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "refill_hiv",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if subject has not been diagnosed and prescribed medication for HIV infection.",
                        max_length=25,
                        verbose_name="Is the patient filling / refilling HIV medications?",
                    ),
                ),
                (
                    "refill_dm",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if subject has not been diagnosed and prescribed medication for Diabetes.",
                        max_length=25,
                        verbose_name="Is the patient filling / refilling Diabetes medications?",
                    ),
                ),
                (
                    "refill_htn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if subject has not been diagnosed and prescribed medication for Hypertension.",
                        max_length=25,
                        verbose_name="Is the patient filling / refilling Hypertension medications?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Medications",
                "verbose_name_plural": "Medications",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="MalariaTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the malaria test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "diagnostic_type",
                    models.CharField(
                        choices=[
                            ("rapid_test", "Rapid test"),
                            ("microscopy", "Microscopy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Diagnostic test used",
                    ),
                ),
                (
                    "result",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Result",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Malaria Test",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Investigations",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "hiv_tested",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=15,
                        verbose_name="Was the patient tested for HIV infection?",
                    ),
                ),
                (
                    "hypertension_tested",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=15,
                        verbose_name="Was the patient tested for hypertension?",
                    ),
                ),
                (
                    "diabetes_tested",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=15,
                        verbose_name="Was the patient tested for diabetes?",
                    ),
                ),
                (
                    "test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "reason",
                    models.ManyToManyField(
                        blank=True,
                        to="edc_dx_review.reasonsfortesting",
                        verbose_name="Why was the patient tested?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Investigations",
                "verbose_name_plural": "Investigations",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Indicators",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField(blank=True, null=True)),
                ("height", edc_vitals.models.fields.height.HeightField(blank=True, null=True)),
                (
                    "waist",
                    edc_vitals.models.fields.waist_circumference.WaistCircumferenceField(
                        blank=True, null=True
                    ),
                ),
                (
                    "hip",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in centimeters",
                        max_digits=5,
                        null=True,
                        verbose_name="Hip circumference:",
                    ),
                ),
                (
                    "r1_taken",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was a blood pressure reading taken",
                    ),
                ),
                (
                    "r1_reason_not_taken",
                    models.TextField(
                        blank=True, max_length=250, null=True, verbose_name="reason not taken"
                    ),
                ),
                (
                    "sys_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "r2_taken",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_required", "Not required"),
                        ],
                        default="not_required",
                        max_length=15,
                        verbose_name="Was a second blood pressure reading taken",
                    ),
                ),
                (
                    "r2_reason_not_taken",
                    models.TextField(blank=True, max_length=250, null=True),
                ),
                (
                    "sys_blood_pressure_r2",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_r2",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Indicators",
                "verbose_name_plural": "Indicators",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HtnReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[
                            ("health_facility", "Health facility"),
                            ("community_clinic", "Community clinic"),
                            ("OTHER", "Other facility, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Care for this `condition` was delivered today at ...",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If other facility, please specify"
                    ),
                ),
                (
                    "test_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Date tested for Hypertension",
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been diagnosed with Hypertension?",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's hypertension be managed going forward?",
                    ),
                ),
                (
                    "care_start_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date clinical management started"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Hypertension Review",
                "verbose_name_plural": "Hypertension Review",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HtnMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=5,
                        verbose_name="Was a pill count performed",
                    ),
                ),
                (
                    "pill_count_not_performed_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If not performed, please explain ...",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Number of pills left in the bottle",
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "missed_pill_reason",
                    models.ManyToManyField(
                        blank=True,
                        to="intecomm_lists.nonadherencereasons",
                        verbose_name="Reasons for missing study pills",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Hypertension Medication Adherence",
                "verbose_name_plural": "Hypertension Medication Adherence",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HtnInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_is_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="How is the patient's hypertension managed?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Hypertension Initial Review",
                "verbose_name_plural": "Hypertension Initial Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HivReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[
                            ("health_facility", "Health facility"),
                            ("community_clinic", "Community clinic"),
                            ("OTHER", "Other facility, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Care for this `condition` was delivered today at ...",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If other facility, please specify"
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been infected with HIV?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if previously reported.",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HIV Review",
                "verbose_name_plural": "HIV Review",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HivMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=5,
                        verbose_name="Was a pill count performed",
                    ),
                ),
                (
                    "pill_count_not_performed_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If not performed, please explain ...",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Number of pills left in the bottle",
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "missed_pill_reason",
                    models.ManyToManyField(
                        blank=True,
                        to="intecomm_lists.nonadherencereasons",
                        verbose_name="Reasons for missing study pills",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HIV Medication Adherence",
                "verbose_name_plural": "HIV Medication Adherence",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HivInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_is_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "receives_care",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient receiving care for HIV?",
                    ),
                ),
                (
                    "clinic",
                    models.CharField(
                        choices=[
                            ("this_clinic", "Patient comes to this facility for their care"),
                            ("OTHER", "Patient goes to a different clinic"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Where does the patient receive care for HIV",
                    ),
                ),
                (
                    "clinic_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If not attending here, where does the patient attend?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `arv_initiation_ago`",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Estimated Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the ART start date estimated?",
                    ),
                ),
                (
                    "has_vl",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("PENDING", "Pending"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent viral load result available?",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(9999999),
                        ],
                        verbose_name="Most recent viral load",
                    ),
                ),
                (
                    "vl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[("=", "="), (">", ">"), ("<", "<")],
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent viral load",
                    ),
                ),
                (
                    "has_cd4",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent CD4 result available?",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Most recent CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent CD4",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HIV Initial Review",
                "verbose_name_plural": "HIV Initial Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalViralLoadResult",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "vl_value",
                    models.IntegerField(
                        help_text="in copies/mL",
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(9999999),
                        ],
                        verbose_name="VL Result",
                    ),
                ),
                (
                    "vl_quantifier",
                    models.CharField(
                        choices=[("=", "="), (">", ">"), ("<", "<")],
                        default="=",
                        max_length=10,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "vl_units",
                    models.CharField(
                        default="copies/mL",
                        editable=False,
                        max_length=25,
                        verbose_name="Units",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "viral_load"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Viral Load Result",
                "verbose_name_plural": "historical Viral Load Results",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalUrinePregnancy",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the urine pregnancy test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "assay_date",
                    models.DateField(blank=True, null=True, verbose_name="Urine βhCG date"),
                ),
                (
                    "bhcg_value",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=25,
                        verbose_name="Urine βhCG result",
                    ),
                ),
                (
                    "notified",
                    models.BooleanField(
                        default=False,
                        editable=False,
                        help_text="Auto-updated by Pregnancy Notification PRN form",
                    ),
                ),
                (
                    "notified_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Auto-updated by Pregnancy Notification PRN form",
                        null=True,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Urine Pregnancy",
                "verbose_name_plural": "historical Urine Pregnancys",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalUrineDipstickTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the urine dipstick test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "ketones",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Ketones?",
                    ),
                ),
                (
                    "protein",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Protein?",
                    ),
                ),
                (
                    "glucose",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Glucose?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Urine Dipstick Test",
                "verbose_name_plural": "historical Urine Dipstick Tests",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisitMissed",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        help_text="If deceased, complete the death report",
                        max_length=25,
                        verbose_name="Survival status",
                    ),
                ),
                (
                    "contact_attempted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Not including pre-appointment reminders",
                        max_length=25,
                        verbose_name="Were any attempts made to contact the participant since the expected appointment date?",
                    ),
                ),
                (
                    "contact_attempts_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Not including pre-appointment reminders. Multiple attempts on the same day count as a single attempt.",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Number of attempts made to contact participantsince the expected appointment date",
                    ),
                ),
                (
                    "contact_attempts_explained",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If contact not made and less than 3 attempts, please explain",
                    ),
                ),
                (
                    "contact_last_date",
                    models.DateField(
                        blank=True,
                        default=edc_utils.date.get_utcnow,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_not_future,
                            edc_protocol.validators.date_not_before_study_start,
                        ],
                        verbose_name="Date of last telephone contact/attempt",
                    ),
                ),
                (
                    "contact_made",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Was contact finally made with the participant?",
                    ),
                ),
                (
                    "missed_reasons_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ltfu",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="No",
                        help_text="If 'Yes', complete the Loss to Follow up form",
                        max_length=15,
                        verbose_name="Has the participant met the protocol criteria for lost to follow up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide further details, if any",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Missed Visit Report",
                "verbose_name_plural": "historical Missed Visit Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("visit_code", models.CharField(editable=False, max_length=25, null=True)),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                            ("N/A", "Not applicable (if missed)"),
                        ],
                        default="alive",
                        help_text="If YES, submit Death report",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        help_text="Will be validated on the Death report",
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "document_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag as incomplete",
                        max_length=25,
                        verbose_name="Document status",
                    ),
                ),
                (
                    "document_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this document",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit (study)"),
                            ("unscheduled", "Routine / Unscheduled visit (non-study)"),
                            ("missed", "Missed visit"),
                        ],
                        help_text="If 'missed', fill in the separate missed visit report",
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("patient_unwell_outpatient", "Patient unwell"),
                            ("drug_refill", "Drug refill only"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "unschedule_self_referral",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="If 'unschedule', is this a self-referral?",
                    ),
                ),
                (
                    "unschedule_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If 'unschedule', please provide further details, if any",
                    ),
                ),
                (
                    "clinic_services_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("patient", "Patient"),
                            (
                                "patient_and_outpatient",
                                "Patient, hospital notes and/or outpatient card",
                            ),
                            (
                                "patient_representive",
                                "Patient Representative (e.family member, friend)",
                            ),
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("N/A", "Not applicable"),
                            ("OTHER", "Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "appointment",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_appointment.appointment",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject visit",
                "verbose_name_plural": "historical subject visits",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(db_index=True, editable=False, max_length=50, null=True),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(db_index=True, editable=False, max_length=18, null=True),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model.models.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Specimen type"
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "panel",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_lab.panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject requisition",
                "verbose_name_plural": "historical subject requisitions",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalOtherBaselineData",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "employment_status",
                    models.CharField(
                        choices=[
                            ("professional", "Professional / office work / business"),
                            ("manual_work", "Skilled / Unskilled manual work"),
                            ("housewife", "Housewife"),
                            ("unemployed", "Not working / seeking work"),
                            ("retired", "Retired"),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="What is the patient's employment status?",
                    ),
                ),
                (
                    "employment_status_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "education",
                    models.CharField(
                        choices=[
                            ("no_formal_education", "No Formal Education"),
                            ("primary", "Up to primary"),
                            ("secondary", "Up to secondary / high school"),
                            ("tertiary", "university educated"),
                        ],
                        max_length=25,
                        verbose_name="How much formal education does the patient have?",
                    ),
                ),
                (
                    "marital_status",
                    models.CharField(
                        choices=[
                            ("married", "Married or living with someone"),
                            ("single", "Single"),
                            ("divorced", "Divorced"),
                            ("widowed", "Widow / Spinster"),
                        ],
                        max_length=25,
                        verbose_name="Personal status?",
                    ),
                ),
                (
                    "smoking_status",
                    models.CharField(
                        choices=[
                            ("smoker", "Currently smoke"),
                            ("former_smoker", "Used to smoke but stopped"),
                            ("nonsmoker", "Never smoked"),
                        ],
                        max_length=15,
                        verbose_name="Which of these options describes you",
                    ),
                ),
                (
                    "smoker_quit_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "smoker_quit_estimated_date",
                    models.DateField(
                        editable=False, null=True, verbose_name="Estimated date smoker quit?"
                    ),
                ),
                (
                    "alcohol",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you drink alcohol?",
                    ),
                ),
                (
                    "alcohol_consumption",
                    models.CharField(
                        choices=[
                            ("ocassionally", "Ocassionally"),
                            ("1_2_per_week", "1-2 times a week"),
                            ("3_4_per_week", "3-4 times a week"),
                            ("daily", "Daily"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If yes, how often do you drink alcohol?",
                    ),
                ),
                (
                    "work_activity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Does your work involve moderate or vigorous-intensity activity thatcauses small to large increases in breathing or heart rate like carrying or lifting loads, digging or construction work",
                    ),
                ),
                (
                    "work_activity_days",
                    models.IntegerField(
                        blank=True,
                        help_text="Give number of days in a 7-day week",
                        null=True,
                        verbose_name="In a typical week, how many days do you do these moderate or vigorous-intensity activities as part of your work?",
                    ),
                ),
                (
                    "work_activity_exercise",
                    models.IntegerField(
                        blank=True,
                        help_text="Give number of days in a 7-day week",
                        null=True,
                        verbose_name="In addition to the moderate or vigorous-intensity activity above, how many days do you do exercise, do sports or fitness activities in a typical week?",
                    ),
                ),
                (
                    "work_activity_exercise_time",
                    models.IntegerField(
                        blank=True,
                        help_text="Give number of minutes",
                        null=True,
                        verbose_name="On an average day, how long do you spend combined on the moderate or vigorous-intensity activities and doing exercise, sports and fitness activities?",
                    ),
                ),
                (
                    "num_vegetables_eaten",
                    models.IntegerField(
                        verbose_name="On average, how many vegetables do you eat in a day?"
                    ),
                ),
                (
                    "use_salt_on_food",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you add salt to your food in addition to what has been added when cooking?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Other Baseline Data",
                "verbose_name_plural": "historical Other Baseline Data",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMedications",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "refill_hiv",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if subject has not been diagnosed and prescribed medication for HIV infection.",
                        max_length=25,
                        verbose_name="Is the patient filling / refilling HIV medications?",
                    ),
                ),
                (
                    "refill_dm",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if subject has not been diagnosed and prescribed medication for Diabetes.",
                        max_length=25,
                        verbose_name="Is the patient filling / refilling Diabetes medications?",
                    ),
                ),
                (
                    "refill_htn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if subject has not been diagnosed and prescribed medication for Hypertension.",
                        max_length=25,
                        verbose_name="Is the patient filling / refilling Hypertension medications?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Medications",
                "verbose_name_plural": "historical Medications",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMalariaTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the malaria test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "diagnostic_type",
                    models.CharField(
                        choices=[
                            ("rapid_test", "Rapid test"),
                            ("microscopy", "Microscopy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Diagnostic test used",
                    ),
                ),
                (
                    "result",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Result",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Malaria Test",
                "verbose_name_plural": "historical Malaria Tests",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalInvestigations",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "hiv_tested",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=15,
                        verbose_name="Was the patient tested for HIV infection?",
                    ),
                ),
                (
                    "hypertension_tested",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=15,
                        verbose_name="Was the patient tested for hypertension?",
                    ),
                ),
                (
                    "diabetes_tested",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=15,
                        verbose_name="Was the patient tested for diabetes?",
                    ),
                ),
                (
                    "test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Investigations",
                "verbose_name_plural": "historical Investigations",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalIndicators",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField(blank=True, null=True)),
                ("height", edc_vitals.models.fields.height.HeightField(blank=True, null=True)),
                (
                    "waist",
                    edc_vitals.models.fields.waist_circumference.WaistCircumferenceField(
                        blank=True, null=True
                    ),
                ),
                (
                    "hip",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in centimeters",
                        max_digits=5,
                        null=True,
                        verbose_name="Hip circumference:",
                    ),
                ),
                (
                    "r1_taken",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was a blood pressure reading taken",
                    ),
                ),
                (
                    "r1_reason_not_taken",
                    models.TextField(
                        blank=True, max_length=250, null=True, verbose_name="reason not taken"
                    ),
                ),
                (
                    "sys_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "r2_taken",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_required", "Not required"),
                        ],
                        default="not_required",
                        max_length=15,
                        verbose_name="Was a second blood pressure reading taken",
                    ),
                ),
                (
                    "r2_reason_not_taken",
                    models.TextField(blank=True, max_length=250, null=True),
                ),
                (
                    "sys_blood_pressure_r2",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_r2",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Indicators",
                "verbose_name_plural": "historical Indicators",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHtnReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[
                            ("health_facility", "Health facility"),
                            ("community_clinic", "Community clinic"),
                            ("OTHER", "Other facility, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Care for this `condition` was delivered today at ...",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If other facility, please specify"
                    ),
                ),
                (
                    "test_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Date tested for Hypertension",
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been diagnosed with Hypertension?",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's hypertension be managed going forward?",
                    ),
                ),
                (
                    "care_start_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date clinical management started"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Hypertension Review",
                "verbose_name_plural": "historical Hypertension Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHtnMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=5,
                        verbose_name="Was a pill count performed",
                    ),
                ),
                (
                    "pill_count_not_performed_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If not performed, please explain ...",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Number of pills left in the bottle",
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Hypertension Medication Adherence",
                "verbose_name_plural": "historical Hypertension Medication Adherence",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHtnInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_is_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="How is the patient's hypertension managed?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Hypertension Initial Review",
                "verbose_name_plural": "historical Hypertension Initial Reviews",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHivReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[
                            ("health_facility", "Health facility"),
                            ("community_clinic", "Community clinic"),
                            ("OTHER", "Other facility, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Care for this `condition` was delivered today at ...",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If other facility, please specify"
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been infected with HIV?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if previously reported.",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HIV Review",
                "verbose_name_plural": "historical HIV Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHivMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=5,
                        verbose_name="Was a pill count performed",
                    ),
                ),
                (
                    "pill_count_not_performed_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If not performed, please explain ...",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Number of pills left in the bottle",
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HIV Medication Adherence",
                "verbose_name_plural": "historical HIV Medication Adherence",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHivInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_is_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "receives_care",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient receiving care for HIV?",
                    ),
                ),
                (
                    "clinic",
                    models.CharField(
                        choices=[
                            ("this_clinic", "Patient comes to this facility for their care"),
                            ("OTHER", "Patient goes to a different clinic"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Where does the patient receive care for HIV",
                    ),
                ),
                (
                    "clinic_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If not attending here, where does the patient attend?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `arv_initiation_ago`",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Estimated Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the ART start date estimated?",
                    ),
                ),
                (
                    "has_vl",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("PENDING", "Pending"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent viral load result available?",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(9999999),
                        ],
                        verbose_name="Most recent viral load",
                    ),
                ),
                (
                    "vl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[("=", "="), (">", ">"), ("<", "<")],
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent viral load",
                    ),
                ),
                (
                    "has_cd4",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent CD4 result available?",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Most recent CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent CD4",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HIV Initial Review",
                "verbose_name_plural": "historical HIV Initial Reviews",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHba1cResult",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "drawn_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Specimen collection date",
                    ),
                ),
                (
                    "result",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in %",
                        max_digits=4,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(20.0),
                        ],
                        verbose_name="Result",
                    ),
                ),
                (
                    "quantifier",
                    models.CharField(
                        default="=", max_length=10, verbose_name="HbA1c quantifier"
                    ),
                ),
                (
                    "units",
                    models.CharField(
                        default="%", editable=False, max_length=15, verbose_name="HbA1c units"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HbA1c Result",
                "verbose_name_plural": "historical HbA1c Results",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalGlucose",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Glucose level",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        verbose_name="Glucose quantifier",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Glucose units",
                    ),
                ),
                (
                    "glucose_date",
                    models.DateField(blank=True, null=True, verbose_name="FBG date measured"),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "glucose_fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "glucose_fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Glucose",
                "verbose_name_plural": "historical Glucose",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalFamilyHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "htn_in_household",
                    models.CharField(
                        choices=[
                            ("No", "No"),
                            ("yes_spouse", "Yes, my spouse"),
                            ("yes_parents", "Yes, one of my parents living with me"),
                            ("yes_relative", "Yes, another relative living with me"),
                        ],
                        max_length=25,
                        verbose_name="Do you know if anyone else in your household has high blood pressure?",
                    ),
                ),
                (
                    "dm_in_household",
                    models.CharField(
                        choices=[
                            ("No", "No"),
                            ("yes_spouse", "Yes, my spouse"),
                            ("yes_parents", "Yes, one of my parents living with me"),
                            ("yes_relative", "Yes, another relative living with me"),
                        ],
                        max_length=25,
                        verbose_name="Do you know if anyone else in your household has diabetes?",
                    ),
                ),
                (
                    "hiv_in_household",
                    models.CharField(
                        choices=[
                            ("No", "No"),
                            ("yes_spouse", "Yes, my spouse"),
                            ("yes_parents", "Yes, one of my parents living with me"),
                            ("yes_relative", "Yes, another relative living with me"),
                        ],
                        max_length=25,
                        verbose_name="Do you know if anyone else in your household has HIV?",
                    ),
                ),
                (
                    "high_bp_bs_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="High blood pressure and high blood sugar can cause many illnesses like heart attacks, stroke, kidney failure",
                    ),
                ),
                (
                    "overweight_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Being overweight protects from high blood pressure and high blood sugar",
                    ),
                ),
                (
                    "salty_foods_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Salty food protects from high blood sugar",
                    ),
                ),
                (
                    "excercise_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Regular exercise is important for people with high blood pressure or high blood sugar even if they are taking medicines for these conditions.",
                    ),
                ),
                (
                    "take_medicine_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Drugs for blood sugar and blood pressure can make you unwell",
                    ),
                ),
                (
                    "stop_htn_meds_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="It is best to stop taking blood pressure pills when you feel better and start pill taking again when you feel sick",
                    ),
                ),
                (
                    "traditional_htn_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Herbs and traditional medicine are better for managing blood pressure than pills and medicines",
                    ),
                ),
                (
                    "stop_dm_meds_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="It is best to stop taking blood sugar medicines when you feel better and start pill taking again when you feel sick",
                    ),
                ),
                (
                    "traditional_dm_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Herbs and traditional medicine are better for managing diabetes than pills and medicines",
                    ),
                ),
                (
                    "dm_cause_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Having drinks with sugar (e.g. tea/coffee) causes diabetes",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Family History and Knowledge",
                "verbose_name_plural": "historical Family History and Knowledge",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDrugRefillHtn",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "rx_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "rx_modified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Was the patient’s prescription changed at this visit compared with their prescription at the previous visit?",
                    ),
                ),
                (
                    "modifications_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "modifications_reason_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "return_in_days",
                    models.IntegerField(
                        verbose_name="In how many days has the patient been asked to return to clinic for a drug refill?"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Drug Refill: Hypertension",
                "verbose_name_plural": "historical Drug Refills: Hypertension",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDrugRefillHiv",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "rx_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "rx_modified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Was the patient’s prescription changed at this visit compared with their prescription at the previous visit?",
                    ),
                ),
                (
                    "modifications_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "modifications_reason_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "return_in_days",
                    models.IntegerField(
                        verbose_name="In how many days has the patient been asked to return to clinic for a drug refill?"
                    ),
                ),
                (
                    "clinic_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="How many days supplied by the clinic",
                    ),
                ),
                (
                    "club_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="How many days supplied by a club",
                    ),
                ),
                (
                    "purchased_days",
                    models.IntegerField(
                        help_text="This can be purchased by patient, through a medicines club that the patient belong to, through insurance or someone else has paid. ",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="How many days supplied by to be purchased",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "rx",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.arvregimens",
                        verbose_name="Which medicine did the patient receive today?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Drug Refill: HIV",
                "verbose_name_plural": "historical Drug Refills: HIV",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDrugRefillDm",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "rx_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "rx_modified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Was the patient’s prescription changed at this visit compared with their prescription at the previous visit?",
                    ),
                ),
                (
                    "modifications_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "modifications_reason_other",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "return_in_days",
                    models.IntegerField(
                        verbose_name="In how many days has the patient been asked to return to clinic for a drug refill?"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Drug Refill: Diabetes",
                "verbose_name_plural": "historical Drug Refills: Diabetes",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDmReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Glucose level",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        verbose_name="Glucose quantifier",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Glucose units",
                    ),
                ),
                (
                    "glucose_date",
                    models.DateField(blank=True, null=True, verbose_name="FBG date measured"),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "glucose_fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "glucose_fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[
                            ("health_facility", "Health facility"),
                            ("community_clinic", "Community clinic"),
                            ("OTHER", "Other facility, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Care for this `condition` was delivered today at ...",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If other facility, please specify"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Diabetes Review",
                "verbose_name_plural": "historical Diabetes Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDmMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=5,
                        verbose_name="Was a pill count performed",
                    ),
                ),
                (
                    "pill_count_not_performed_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If not performed, please explain ...",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Number of pills left in the bottle",
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Medication Adherence (Diabetes)",
                "verbose_name_plural": "historical Medication Adherence (Diabetes)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDmInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Glucose level",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        verbose_name="Glucose quantifier",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Glucose units",
                    ),
                ),
                (
                    "glucose_date",
                    models.DateField(blank=True, null=True, verbose_name="FBG date measured"),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "glucose_fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "glucose_fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_is_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("insulin", "Insulin injections"),
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How is the patient's diabetes managed?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "glucose_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient had their glucose measured in the last few months?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Diabetes Initial Review",
                "verbose_name_plural": "historical Diabetes Initial Reviews",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalConcomitantMedication",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Concomitant Medication",
                "verbose_name_plural": "historical Concomitant Medication",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalComplicationsFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "stroke",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Stroke",
                    ),
                ),
                (
                    "stroke_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "heart_attack",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Heart attack / heart failure",
                    ),
                ),
                (
                    "heart_attack_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "renal_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Renal (kidney) disease",
                    ),
                ),
                (
                    "renal_disease_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "vision",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Vision problems (e.g. blurred vision)",
                    ),
                ),
                (
                    "vision_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "numbness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Numbness / burning sensation",
                    ),
                ),
                (
                    "numbness_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "foot_ulcers",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Foot ulcers",
                    ),
                ),
                (
                    "foot_ulcers_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Are there any other major complications to report?",
                    ),
                ),
                (
                    "complications_other",
                    models.TextField(blank=True, help_text="Please include dates", null=True),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Complications: Followup",
                "verbose_name_plural": "historical Complications: Followup",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalComplicationsBaseline",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "stroke",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Stroke",
                    ),
                ),
                (
                    "stroke_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "stroke_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of stroke",
                    ),
                ),
                (
                    "heart_attack",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Heart attack / heart failure",
                    ),
                ),
                (
                    "heart_attack_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "heart_attack_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of heart attack / heart failure",
                    ),
                ),
                (
                    "renal_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Renal (kidney) disease",
                    ),
                ),
                (
                    "renal_disease_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "renal_disease_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of renal_disease",
                    ),
                ),
                (
                    "vision",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Vision problems (e.g. blurred vision)",
                    ),
                ),
                (
                    "vision_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "vision_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of vision problems",
                    ),
                ),
                (
                    "numbness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Numbness / burning sensation",
                    ),
                ),
                (
                    "numbness_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "numbness_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of numbness",
                    ),
                ),
                (
                    "foot_ulcers",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Foot ulcers",
                    ),
                ),
                (
                    "foot_ulcers_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "foot_ulcers_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of foot ulcers",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Are there any other major complications to report?",
                    ),
                ),
                (
                    "complications_other",
                    models.TextField(blank=True, help_text="Please include dates", null=True),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Complications: Baseline",
                "verbose_name_plural": "historical Complications: Baseline",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalClinicalReviewBaseline",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient have any private or work-place health insurance?",
                    ),
                ),
                (
                    "health_insurance_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on health insurance",
                    ),
                ),
                (
                    "patient_club",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient belong to a ‘club’ that supports medicines purchase?",
                    ),
                ),
                (
                    "patient_club_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on club membership",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Diabetes?",
                    ),
                ),
                (
                    "dm_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dm_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `dm_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Diabetes test?",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If YES, complete form `Diabetes Initial Review`",
                        max_length=15,
                        verbose_name="Have you ever been diagnosed with Diabetes",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "hiv_test_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        help_text="calculated by the EDC using `hiv_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True,
                        help_text="IF HIV(+), DATE PATIENT FIRST TESTED POSITIVE. ",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent HIV test?",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If YES, complete form `HIV Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever tested <U>positive</U> for HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Hypertension?",
                    ),
                ),
                (
                    "htn_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "htn_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `htn_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Hypertension test?",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If YES, complete form `Hypertension Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever been diagnosed with Hypertension",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If YES, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinical Review: Baseline",
                "verbose_name_plural": "historical Clinical Review: Baseline",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalClinicalReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient have any private or work-place health insurance?",
                    ),
                ),
                (
                    "health_insurance_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on health insurance",
                    ),
                ),
                (
                    "patient_club",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient belong to a ‘club’ that supports medicines purchase?",
                    ),
                ),
                (
                    "patient_club_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on club membership",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "hiv_reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient newly diagnosed with HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for hypertension?",
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "htn_reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient newly diagnosed with hypertension?",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for diabetes?",
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "dm_reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient newly diagnosed with diabetes?",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If Yes, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
                (
                    "reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinical Review",
                "verbose_name_plural": "historical Clinical Reviews",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalCd4Result",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "cd4_value",
                    models.IntegerField(
                        help_text="in cells/mm<sup>3</sup>",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="CD4 Result",
                    ),
                ),
                (
                    "cd4_units",
                    models.CharField(
                        default="cells/mm^3",
                        editable=False,
                        max_length=25,
                        verbose_name="Units",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical CD4 Result",
                "verbose_name_plural": "historical CD4 Results",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsRft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "creatinine_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Creatinine",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "creatinine_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "creatinine_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "creatinine_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "creatinine_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "creatinine_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "urea_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Urea (BUN)",
                    ),
                ),
                (
                    "urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "urea_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "urea_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "urea_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "urea_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "urea_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "uric_acid_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=10,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Uric Acid",
                    ),
                ),
                (
                    "uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)"), ("mg/dL", "mg/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "uric_acid_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "uric_acid_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "uric_acid_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "uric_acid_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "uric_acid_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "egfr_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "egfr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mL/min/1.73m2", "mL/min/1.73m2")],
                        default="mL/min/1.73m2",
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "egfr_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "egfr_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "egfr_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "egfr_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "egfr_drop_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=10,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="eGFR Drop",
                    ),
                ),
                (
                    "egfr_drop_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        default="%",
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "egfr_drop_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "egfr_drop_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "egfr_drop_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr_drop_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "egfr_drop_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "old_egfr_value",
                    models.DecimalField(
                        decimal_places=4,
                        editable=False,
                        help_text="incorrect ckd-epi calculation (w/ 1.150 as ethnicity factor)",
                        max_digits=8,
                        null=True,
                    ),
                ),
                (
                    "old_egfr_drop_value",
                    models.DecimalField(
                        decimal_places=4,
                        editable=False,
                        help_text="incorrect ckd-epi calculation (w/ 1.150 as ethnicity factor)",
                        max_digits=10,
                        null=True,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "chemistry_rft"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: RFT",
                "verbose_name_plural": "historical Blood Results: RFT",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsLipid",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "chol_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Total Cholesterol",
                    ),
                ),
                (
                    "chol_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "chol_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "chol_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "chol_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "chol_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "chol_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "hdl_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="HDL",
                    ),
                ),
                (
                    "hdl_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hdl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "hdl_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hdl_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hdl_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "hdl_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ldl_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="LDL",
                    ),
                ),
                (
                    "ldl_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ldl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ldl_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ldl_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ldl_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ldl_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "trig_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Triglycerides",
                    ),
                ),
                (
                    "trig_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "trig_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "trig_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "trig_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "trig_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "trig_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "chemistry_lipids"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: Lipids",
                "verbose_name_plural": "historical Blood Results: Lipids",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsLft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "albumin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum albumin",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "albumin_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "albumin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "albumin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "albumin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "albumin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alp_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALP",
                    ),
                ),
                (
                    "alp_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alp_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "alp_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alp_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alp_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alp_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALT",
                    ),
                ),
                (
                    "alt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alt_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "alt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ast_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="AST",
                    ),
                ),
                (
                    "ast_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ast_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ast_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ast_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ast_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ast_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "amylase_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum Amylase",
                    ),
                ),
                (
                    "amylase_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "amylase_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "amylase_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "amylase_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "amylase_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "amylase_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ggt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="GGT",
                    ),
                ),
                (
                    "ggt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ggt_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ggt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ggt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ggt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ggt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "chemistry_lft"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: LFT",
                "verbose_name_plural": "historical Blood Results: LFT",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsIns",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "ins_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Insulin",
                    ),
                ),
                (
                    "ins_units",
                    models.CharField(
                        blank=True,
                        choices=[("uIU/mL", "μIU/mL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ins_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ins_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ins_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ins_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ins_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "insulin"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: Insulin",
                "verbose_name_plural": "historical Blood Results: Insulin",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsHba1c",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "hba1c_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c value",
                    ),
                ),
                (
                    "hba1c_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "hba1c_units",
                    models.CharField(
                        blank=True, default="%", max_length=15, null=True, verbose_name="units"
                    ),
                ),
                (
                    "hba1c_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hba1c_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "hba1c"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: HbA1c",
                "verbose_name_plural": "historical Blood Results: HbA1c",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsGlu",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.99),
                        ],
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "glucose_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "glucose_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "glucose_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "glucose_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        choices=[("fasting", "Fasting"), ("non_fasting", "Non-fasting")],
                        max_length=25,
                        null=True,
                        verbose_name="Was this fasting or non-fasting?",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "blood_glucose"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: Glucose",
                "verbose_name_plural": "historical Blood Results: Glucose",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsFbc",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, db_index=True, max_length=50, null=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "haemoglobin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Haemoglobin",
                    ),
                ),
                (
                    "haemoglobin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "haemoglobin_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "haemoglobin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "haemoglobin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "haemoglobin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "haemoglobin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "hct_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Hematocrit",
                    ),
                ),
                (
                    "hct_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hct_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "hct_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hct_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hct_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "hct_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mch_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCH",
                    ),
                ),
                (
                    "mch_units",
                    models.CharField(
                        blank=True,
                        choices=[("pg/cell", "pg/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mch_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "mch_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mch_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mch_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mch_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mchc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCHC",
                    ),
                ),
                (
                    "mchc_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mchc_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "mchc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mchc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mchc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mchc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mcv_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCV",
                    ),
                ),
                (
                    "mcv_units",
                    models.CharField(
                        blank=True,
                        choices=[("fL/cell", "fL/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mcv_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "mcv_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mcv_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mcv_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mcv_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "platelets_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="Platelets",
                    ),
                ),
                (
                    "platelets_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm<sup>3</sup>")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "platelets_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "platelets_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "platelets_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "platelets_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "platelets_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "rbc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999999.0),
                        ],
                        verbose_name="Red blood cell count",
                    ),
                ),
                (
                    "rbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm^3")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "rbc_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "rbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "rbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "rbc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "rbc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "wbc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="WBC",
                    ),
                ),
                (
                    "wbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm<sup>3</sup>")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "wbc_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "wbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "wbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "wbc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "wbc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "fbc"},
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: FBC",
                "verbose_name_plural": "historical Blood Results: FBC",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Hba1cResult",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "drawn_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Specimen collection date",
                    ),
                ),
                (
                    "result",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in %",
                        max_digits=4,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(20.0),
                        ],
                        verbose_name="Result",
                    ),
                ),
                (
                    "quantifier",
                    models.CharField(
                        default="=", max_length=10, verbose_name="HbA1c quantifier"
                    ),
                ),
                (
                    "units",
                    models.CharField(
                        default="%", editable=False, max_length=15, verbose_name="HbA1c units"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HbA1c Result",
                "verbose_name_plural": "HbA1c Results",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Glucose",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Glucose level",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        verbose_name="Glucose quantifier",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Glucose units",
                    ),
                ),
                (
                    "glucose_date",
                    models.DateField(blank=True, null=True, verbose_name="FBG date measured"),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "glucose_fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "glucose_fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Glucose",
                "verbose_name_plural": "Glucose",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="FamilyHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "htn_in_household",
                    models.CharField(
                        choices=[
                            ("No", "No"),
                            ("yes_spouse", "Yes, my spouse"),
                            ("yes_parents", "Yes, one of my parents living with me"),
                            ("yes_relative", "Yes, another relative living with me"),
                        ],
                        max_length=25,
                        verbose_name="Do you know if anyone else in your household has high blood pressure?",
                    ),
                ),
                (
                    "dm_in_household",
                    models.CharField(
                        choices=[
                            ("No", "No"),
                            ("yes_spouse", "Yes, my spouse"),
                            ("yes_parents", "Yes, one of my parents living with me"),
                            ("yes_relative", "Yes, another relative living with me"),
                        ],
                        max_length=25,
                        verbose_name="Do you know if anyone else in your household has diabetes?",
                    ),
                ),
                (
                    "hiv_in_household",
                    models.CharField(
                        choices=[
                            ("No", "No"),
                            ("yes_spouse", "Yes, my spouse"),
                            ("yes_parents", "Yes, one of my parents living with me"),
                            ("yes_relative", "Yes, another relative living with me"),
                        ],
                        max_length=25,
                        verbose_name="Do you know if anyone else in your household has HIV?",
                    ),
                ),
                (
                    "high_bp_bs_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="High blood pressure and high blood sugar can cause many illnesses like heart attacks, stroke, kidney failure",
                    ),
                ),
                (
                    "overweight_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Being overweight protects from high blood pressure and high blood sugar",
                    ),
                ),
                (
                    "salty_foods_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Salty food protects from high blood sugar",
                    ),
                ),
                (
                    "excercise_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Regular exercise is important for people with high blood pressure or high blood sugar even if they are taking medicines for these conditions.",
                    ),
                ),
                (
                    "take_medicine_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Drugs for blood sugar and blood pressure can make you unwell",
                    ),
                ),
                (
                    "stop_htn_meds_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="It is best to stop taking blood pressure pills when you feel better and start pill taking again when you feel sick",
                    ),
                ),
                (
                    "traditional_htn_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Herbs and traditional medicine are better for managing blood pressure than pills and medicines",
                    ),
                ),
                (
                    "stop_dm_meds_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="It is best to stop taking blood sugar medicines when you feel better and start pill taking again when you feel sick",
                    ),
                ),
                (
                    "traditional_dm_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Herbs and traditional medicine are better for managing diabetes than pills and medicines",
                    ),
                ),
                (
                    "dm_cause_tf",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Having drinks with sugar (e.g. tea/coffee) causes diabetes",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Family History and Knowledge",
                "verbose_name_plural": "Family History and Knowledge",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DrugSupplyHtn",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "clinic_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="Clinic",
                    ),
                ),
                (
                    "club_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="Club",
                    ),
                ),
                (
                    "purchased_days",
                    models.IntegerField(
                        help_text="This can be purchased by patient, through a medicines club that the patient belong to, through insurance or someone else has paid. ",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="To purchase",
                    ),
                ),
                (
                    "drug",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_lists.htntreatments",
                    ),
                ),
                (
                    "drug_refill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.drugrefillhtn",
                    ),
                ),
            ],
            options={
                "verbose_name": "Drug Supply: Hypertension",
                "verbose_name_plural": "Drug Supply: Hypertension",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
        ),
        migrations.CreateModel(
            name="DrugSupplyHiv",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "clinic_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="Clinic",
                    ),
                ),
                (
                    "club_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="Club",
                    ),
                ),
                (
                    "purchased_days",
                    models.IntegerField(
                        help_text="This can be purchased by patient, through a medicines club that the patient belong to, through insurance or someone else has paid. ",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="To purchase",
                    ),
                ),
                (
                    "drug",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_lists.arvdrugs",
                    ),
                ),
                (
                    "drug_refill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.drugrefillhiv",
                    ),
                ),
            ],
            options={
                "verbose_name": "Drug Supply: HIV",
                "verbose_name_plural": "Drug Supply: HIV",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
        ),
        migrations.CreateModel(
            name="DrugSupplyDm",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "clinic_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="Clinic",
                    ),
                ),
                (
                    "club_days",
                    models.IntegerField(
                        help_text="days",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="Club",
                    ),
                ),
                (
                    "purchased_days",
                    models.IntegerField(
                        help_text="This can be purchased by patient, through a medicines club that the patient belong to, through insurance or someone else has paid. ",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="To purchase",
                    ),
                ),
                (
                    "drug",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_lists.dmtreatments",
                    ),
                ),
                (
                    "drug_refill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.drugrefilldm",
                    ),
                ),
            ],
            options={
                "verbose_name": "Drug Supply: Diabetes",
                "verbose_name_plural": "Drug Supply: Diabetes",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
        ),
        migrations.AddField(
            model_name="drugrefillhtn",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="intecomm_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="drugrefillhiv",
            name="rx",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                to="intecomm_subject.arvregimens",
                verbose_name="Which medicine did the patient receive today?",
            ),
        ),
        migrations.AddField(
            model_name="drugrefillhiv",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="drugrefillhiv",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="intecomm_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="drugrefilldm",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="intecomm_subject.subjectvisit"
            ),
        ),
        migrations.CreateModel(
            name="DmReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Glucose level",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        verbose_name="Glucose quantifier",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Glucose units",
                    ),
                ),
                (
                    "glucose_date",
                    models.DateField(blank=True, null=True, verbose_name="FBG date measured"),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "glucose_fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "glucose_fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[
                            ("health_facility", "Health facility"),
                            ("community_clinic", "Community clinic"),
                            ("OTHER", "Other facility, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Care for this `condition` was delivered today at ...",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If other facility, please specify"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Diabetes Review",
                "verbose_name_plural": "Diabetes Review",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DmMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=5,
                        verbose_name="Was a pill count performed",
                    ),
                ),
                (
                    "pill_count_not_performed_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If not performed, please explain ...",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Number of pills left in the bottle",
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "missed_pill_reason",
                    models.ManyToManyField(
                        blank=True,
                        to="intecomm_lists.nonadherencereasons",
                        verbose_name="Reasons for missing study pills",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Medication Adherence (Diabetes)",
                "verbose_name_plural": "Medication Adherence (Diabetes)",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DmInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="A `HIGH` reading may be entered as 9999.99",
                        max_digits=8,
                        null=True,
                        verbose_name="Glucose level",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        verbose_name="Glucose quantifier",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        choices=[
                            ("mg/dL", "mg/dL"),
                            ("mmol/L", "mmol/L (millimoles/L)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Glucose units",
                    ),
                ),
                (
                    "glucose_date",
                    models.DateField(blank=True, null=True, verbose_name="FBG date measured"),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "glucose_fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "glucose_fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_is_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("insulin", "Insulin injections"),
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How is the patient's diabetes managed?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "glucose_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient had their glucose measured in the last few months?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Diabetes Initial Review",
                "verbose_name_plural": "Diabetes Initial Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ConcomitantMedication",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Concomitant Medication",
                "verbose_name_plural": "Concomitant Medication",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ComplicationsFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "stroke",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Stroke",
                    ),
                ),
                (
                    "stroke_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "heart_attack",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Heart attack / heart failure",
                    ),
                ),
                (
                    "heart_attack_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "renal_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Renal (kidney) disease",
                    ),
                ),
                (
                    "renal_disease_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "vision",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Vision problems (e.g. blurred vision)",
                    ),
                ),
                (
                    "vision_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "numbness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Numbness / burning sensation",
                    ),
                ),
                (
                    "numbness_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "foot_ulcers",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Foot ulcers",
                    ),
                ),
                (
                    "foot_ulcers_date",
                    models.DateField(
                        blank=True,
                        help_text="If exact date not known, see SOP on how to estimate a date.",
                        null=True,
                        verbose_name="If yes, date",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Are there any other major complications to report?",
                    ),
                ),
                (
                    "complications_other",
                    models.TextField(blank=True, help_text="Please include dates", null=True),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Complications: Followup",
                "verbose_name_plural": "Complications: Followup",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ComplicationsBaseline",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "stroke",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Stroke",
                    ),
                ),
                (
                    "stroke_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "stroke_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of stroke",
                    ),
                ),
                (
                    "heart_attack",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Heart attack / heart failure",
                    ),
                ),
                (
                    "heart_attack_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "heart_attack_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of heart attack / heart failure",
                    ),
                ),
                (
                    "renal_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Renal (kidney) disease",
                    ),
                ),
                (
                    "renal_disease_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "renal_disease_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of renal_disease",
                    ),
                ),
                (
                    "vision",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Vision problems (e.g. blurred vision)",
                    ),
                ),
                (
                    "vision_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "vision_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of vision problems",
                    ),
                ),
                (
                    "numbness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Numbness / burning sensation",
                    ),
                ),
                (
                    "numbness_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "numbness_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of numbness",
                    ),
                ),
                (
                    "foot_ulcers",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Foot ulcers",
                    ),
                ),
                (
                    "foot_ulcers_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "foot_ulcers_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Estimated date of foot ulcers",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Are there any other major complications to report?",
                    ),
                ),
                (
                    "complications_other",
                    models.TextField(blank=True, help_text="Please include dates", null=True),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Complications: Baseline",
                "verbose_name_plural": "Complications: Baseline",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ClinicalReviewBaseline",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient have any private or work-place health insurance?",
                    ),
                ),
                (
                    "health_insurance_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on health insurance",
                    ),
                ),
                (
                    "patient_club",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient belong to a ‘club’ that supports medicines purchase?",
                    ),
                ),
                (
                    "patient_club_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on club membership",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Diabetes?",
                    ),
                ),
                (
                    "dm_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dm_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `dm_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Diabetes test?",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If YES, complete form `Diabetes Initial Review`",
                        max_length=15,
                        verbose_name="Have you ever been diagnosed with Diabetes",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "hiv_test_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        help_text="calculated by the EDC using `hiv_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True,
                        help_text="IF HIV(+), DATE PATIENT FIRST TESTED POSITIVE. ",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent HIV test?",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If YES, complete form `HIV Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever tested <U>positive</U> for HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Hypertension?",
                    ),
                ),
                (
                    "htn_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "htn_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `htn_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Hypertension test?",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If YES, complete form `Hypertension Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever been diagnosed with Hypertension",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If YES, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinical Review: Baseline",
                "verbose_name_plural": "Clinical Review: Baseline",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ClinicalReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient have any private or work-place health insurance?",
                    ),
                ),
                (
                    "health_insurance_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on health insurance",
                    ),
                ),
                (
                    "patient_club",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="unknown",
                        max_length=15,
                        verbose_name="Does the patient belong to a ‘club’ that supports medicines purchase?",
                    ),
                ),
                (
                    "patient_club_monthly_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="amount in local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="In the last month, how much has the patient spent on club membership",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "hiv_reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient newly diagnosed with HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for hypertension?",
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "htn_reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient newly diagnosed with hypertension?",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for diabetes?",
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "dm_reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient newly diagnosed with diabetes?",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If Yes, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
                (
                    "reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dm_reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="dm_reason",
                        to="edc_dx_review.reasonsfortesting",
                        verbose_name="Why was the patient tested for diabetes?",
                    ),
                ),
                (
                    "hiv_reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="hiv_test_reason",
                        to="edc_dx_review.reasonsfortesting",
                        verbose_name="Why was the patient tested for HIV infection?",
                    ),
                ),
                (
                    "htn_reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="htn_test_reason",
                        to="edc_dx_review.reasonsfortesting",
                        verbose_name="Why was the patient tested for hypertension?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinical Review",
                "verbose_name_plural": "Clinical Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Cd4Result",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "cd4_value",
                    models.IntegerField(
                        help_text="in cells/mm<sup>3</sup>",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="CD4 Result",
                    ),
                ),
                (
                    "cd4_units",
                    models.CharField(
                        default="cells/mm^3",
                        editable=False,
                        max_length=25,
                        verbose_name="Units",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "CD4 Result",
                "verbose_name_plural": "CD4 Results",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsRft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "creatinine_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Creatinine",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "creatinine_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "creatinine_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "creatinine_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "creatinine_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "creatinine_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "urea_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Urea (BUN)",
                    ),
                ),
                (
                    "urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "urea_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "urea_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "urea_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "urea_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "urea_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "uric_acid_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=10,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Uric Acid",
                    ),
                ),
                (
                    "uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)"), ("mg/dL", "mg/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "uric_acid_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "uric_acid_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "uric_acid_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "uric_acid_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "uric_acid_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "egfr_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "egfr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mL/min/1.73m2", "mL/min/1.73m2")],
                        default="mL/min/1.73m2",
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "egfr_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "egfr_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "egfr_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "egfr_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "egfr_drop_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=10,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="eGFR Drop",
                    ),
                ),
                (
                    "egfr_drop_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        default="%",
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "egfr_drop_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "egfr_drop_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "egfr_drop_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr_drop_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "egfr_drop_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "old_egfr_value",
                    models.DecimalField(
                        decimal_places=4,
                        editable=False,
                        help_text="incorrect ckd-epi calculation (w/ 1.150 as ethnicity factor)",
                        max_digits=8,
                        null=True,
                    ),
                ),
                (
                    "old_egfr_drop_value",
                    models.DecimalField(
                        decimal_places=4,
                        editable=False,
                        help_text="incorrect ckd-epi calculation (w/ 1.150 as ethnicity factor)",
                        max_digits=10,
                        null=True,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "chemistry_rft"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: RFT",
                "verbose_name_plural": "Blood Results: RFT",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsLipid",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "chol_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Total Cholesterol",
                    ),
                ),
                (
                    "chol_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "chol_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "chol_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "chol_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "chol_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "chol_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "hdl_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="HDL",
                    ),
                ),
                (
                    "hdl_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hdl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "hdl_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hdl_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hdl_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "hdl_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ldl_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="LDL",
                    ),
                ),
                (
                    "ldl_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ldl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ldl_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ldl_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ldl_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ldl_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "trig_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Triglycerides",
                    ),
                ),
                (
                    "trig_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "trig_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "trig_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "trig_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "trig_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "trig_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "chemistry_lipids"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: Lipids",
                "verbose_name_plural": "Blood Results: Lipids",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsLft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "albumin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum albumin",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "albumin_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "albumin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "albumin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "albumin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "albumin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alp_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALP",
                    ),
                ),
                (
                    "alp_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alp_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "alp_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alp_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alp_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alp_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALT",
                    ),
                ),
                (
                    "alt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alt_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "alt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ast_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="AST",
                    ),
                ),
                (
                    "ast_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ast_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ast_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ast_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ast_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ast_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "amylase_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum Amylase",
                    ),
                ),
                (
                    "amylase_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "amylase_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "amylase_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "amylase_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "amylase_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "amylase_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ggt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="GGT",
                    ),
                ),
                (
                    "ggt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ggt_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ggt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ggt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ggt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ggt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "chemistry_lft"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: LFT",
                "verbose_name_plural": "Blood Results: LFT",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsIns",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "ins_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Insulin",
                    ),
                ),
                (
                    "ins_units",
                    models.CharField(
                        blank=True,
                        choices=[("uIU/mL", "μIU/mL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ins_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "ins_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ins_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ins_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ins_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="As reported by patient",
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasting_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasting_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "insulin"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: Insulin",
                "verbose_name_plural": "Blood Results: Insulin",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsHba1c",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "hba1c_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c value",
                    ),
                ),
                (
                    "hba1c_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "hba1c_units",
                    models.CharField(
                        blank=True, default="%", max_length=15, null=True, verbose_name="units"
                    ),
                ),
                (
                    "hba1c_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hba1c_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "hba1c"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: HbA1c",
                "verbose_name_plural": "Blood Results: HbA1c",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsGlu",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "glucose_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.99),
                        ],
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "glucose_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "glucose_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "glucose_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "glucose_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        choices=[("fasting", "Fasting"), ("non_fasting", "Non-fasting")],
                        max_length=25,
                        null=True,
                        verbose_name="Was this fasting or non-fasting?",
                    ),
                ),
                (
                    "glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        limit_choices_to={"panel__name": "blood_glucose"},
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="intecomm_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: Glucose",
                "verbose_name_plural": "Blood Results: Glucose",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsFbc",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "action_identifier",
                    models.CharField(blank=True, max_length=50, null=True, unique=True),
                ),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result assay date and time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Abnormal results at present at baseline or continuing from baseline not included.",
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "missing_count",
                    models.IntegerField(
                        default=0, editable=False, help_text="A count of fields left blank"
                    ),
                ),
                (
                    "missing",
                    models.TextField(
                        editable=False,
                        help_text="calculated string of field names that have been left blank",
                        null=True,
                    ),
                ),
                (
                    "haemoglobin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Haemoglobin",
                    ),
                ),
                (
                    "haemoglobin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "haemoglobin_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "haemoglobin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "haemoglobin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "haemoglobin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "haemoglobin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "hct_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Hematocrit",
                    ),
                ),
                (
                    "hct_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hct_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "hct_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hct_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hct_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "hct_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mch_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCH",
                    ),
                ),
                (
                    "mch_units",
                    models.CharField(
                        blank=True,
                        choices=[("pg/cell", "pg/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mch_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "mch_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mch_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mch_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mch_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mchc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCHC",
                    ),
                ),
                (
                    "mchc_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mchc_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "mchc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mchc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mchc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mchc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mcv_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCV",
                    ),
                ),
                (
                    "mcv_units",
                    models.CharField(
                        blank=True,
                        choices=[("fL/cell", "fL/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mcv_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                        null=True,
                        verbose_name="Quantifier",
                    ),
                ),
                (
                    "mcv_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mcv_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mcv_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mcv_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "platelets_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="Platelets",
                    ),
                ),
                (
                    "platelets_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm<sup>3</sup>")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "platelets_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", "