# Generated by Django 4.1.2 on 2023-01-27 00:58

import _socket
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import edc_vitals.models.fields.blood_pressure
import edc_vitals.models.fields.heart_rate
import edc_vitals.models.fields.height
import edc_vitals.models.fields.respiratory_rate
import edc_vitals.models.fields.temperature
import edc_vitals.models.fields.waist_circumference
import edc_vitals.models.fields.weight
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        (
            "intecomm_subject",
            "0007_alter_historicalotherbaselinedata_alcohol_consumption_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalVitals",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "sys_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: systolic (average)",
                    ),
                ),
                (
                    "dia_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: diastolic (average)",
                    ),
                ),
                (
                    "severe_htn",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have severe hypertension?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField(blank=True, null=True)),
                (
                    "weight_is_estmated",
                    models.CharField(
                        choices=[
                            ("estimated", "Estimated"),
                            ("measured", "Measured"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Is weight estimated or measured?",
                    ),
                ),
                (
                    "bp_measured",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the patient's blood pressure measured today",
                    ),
                ),
                (
                    "bp_not_measured_reason",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If BP not measured, please explain",
                    ),
                ),
                ("heart_rate", edc_vitals.models.fields.heart_rate.HeartRateField()),
                (
                    "respiratory_rate",
                    edc_vitals.models.fields.respiratory_rate.RespiratoryRateField(
                        blank=True, null=True
                    ),
                ),
                ("temperature", edc_vitals.models.fields.temperature.TemperatureField()),
                ("height", edc_vitals.models.fields.height.HeightField(blank=True, null=True)),
                (
                    "waist",
                    edc_vitals.models.fields.waist_circumference.WaistCircumferenceField(
                        blank=True, null=True
                    ),
                ),
                (
                    "hip",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in centimeters",
                        max_digits=5,
                        null=True,
                        verbose_name="Hip circumference:",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Vitals",
                "verbose_name_plural": "historical Vitals",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Vitals",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "sys_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_one",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure_two",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "sys_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: systolic (average)",
                    ),
                ),
                (
                    "dia_blood_pressure_avg",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Blood pressure: diastolic (average)",
                    ),
                ),
                (
                    "severe_htn",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Based on the above readings. Severe HTN is any BP reading > 180/110mmHg",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have severe hypertension?",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField(blank=True, null=True)),
                (
                    "weight_is_estmated",
                    models.CharField(
                        choices=[
                            ("estimated", "Estimated"),
                            ("measured", "Measured"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Is weight estimated or measured?",
                    ),
                ),
                (
                    "bp_measured",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the patient's blood pressure measured today",
                    ),
                ),
                (
                    "bp_not_measured_reason",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If BP not measured, please explain",
                    ),
                ),
                ("heart_rate", edc_vitals.models.fields.heart_rate.HeartRateField()),
                (
                    "respiratory_rate",
                    edc_vitals.models.fields.respiratory_rate.RespiratoryRateField(
                        blank=True, null=True
                    ),
                ),
                ("temperature", edc_vitals.models.fields.temperature.TemperatureField()),
                ("height", edc_vitals.models.fields.height.HeightField(blank=True, null=True)),
                (
                    "waist",
                    edc_vitals.models.fields.waist_circumference.WaistCircumferenceField(
                        blank=True, null=True
                    ),
                ),
                (
                    "hip",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in centimeters",
                        max_digits=5,
                        null=True,
                        verbose_name="Hip circumference:",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Vitals",
                "verbose_name_plural": "Vitals",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.RemoveField(
            model_name="indicators",
            name="site",
        ),
        migrations.RemoveField(
            model_name="indicators",
            name="subject_visit",
        ),
        migrations.DeleteModel(
            name="HistoricalIndicators",
        ),
        migrations.DeleteModel(
            name="Indicators",
        ),
        migrations.AddIndex(
            model_name="vitals",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="intecomm_su_subject_204579_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="vitals",
            index=models.Index(
                fields=["subject_visit", "report_datetime"],
                name="intecomm_su_subject_2d0586_idx",
            ),
        ),
    ]
