'''
MAVLink protocol implementation (auto-generated by mavgen.py)

Generated from: all.xml,ardupilotmega.xml,common.xml,icarous.xml,minimal.xml,python_array_test.xml,standard.xml,test.xml,ualberta.xml,uAvionix.xml

Note: this file has been auto-generated. DO NOT EDIT
'''
from __future__ import print_function
from builtins import range
from builtins import object
import struct, array, time, json, os, sys, platform

from pymavlink.generator.mavcrc import x25crc
import hashlib

WIRE_PROTOCOL_VERSION = '1.0'
DIALECT = 'all'

PROTOCOL_MARKER_V1 = 0xFE
PROTOCOL_MARKER_V2 = 0xFD
HEADER_LEN_V1 = 6
HEADER_LEN_V2 = 10

MAVLINK_SIGNATURE_BLOCK_LEN = 13

MAVLINK_IFLAG_SIGNED = 0x01

native_supported = platform.system() != 'Windows' # Not yet supported on other dialects
native_force = 'MAVNATIVE_FORCE' in os.environ # Will force use of native code regardless of what client app wants
native_testing = 'MAVNATIVE_TESTING' in os.environ # Will force both native and legacy code to be used and their results compared

if native_supported and float(WIRE_PROTOCOL_VERSION) <= 1:
    try:
        import mavnative
    except ImportError:
        print('ERROR LOADING MAVNATIVE - falling back to python implementation')
        native_supported = False
else:
    # mavnative isn't supported for MAVLink2 yet
    native_supported = False

# allow MAV_IGNORE_CRC=1 to ignore CRC, allowing some
# corrupted msgs to be seen
MAVLINK_IGNORE_CRC = os.environ.get("MAV_IGNORE_CRC",0)

# some base types from mavlink_types.h
MAVLINK_TYPE_CHAR     = 0
MAVLINK_TYPE_UINT8_T  = 1
MAVLINK_TYPE_INT8_T   = 2
MAVLINK_TYPE_UINT16_T = 3
MAVLINK_TYPE_INT16_T  = 4
MAVLINK_TYPE_UINT32_T = 5
MAVLINK_TYPE_INT32_T  = 6
MAVLINK_TYPE_UINT64_T = 7
MAVLINK_TYPE_INT64_T  = 8
MAVLINK_TYPE_FLOAT    = 9
MAVLINK_TYPE_DOUBLE   = 10


# swiped from DFReader.py
def to_string(s):
    '''desperate attempt to convert a string regardless of what garbage we get'''
    try:
        return s.decode("utf-8")
    except Exception as e:
        pass
    try:
        s2 = s.encode('utf-8', 'ignore')
        x = u"%s" % s2
        return s2
    except Exception:
        pass
    # so it's a nasty one. Let's grab as many characters as we can
    r = ''
    try:
        for c in s:
            r2 = r + c
            r2 = r2.encode('ascii', 'ignore')
            x = u"%s" % r2
            r = r2
    except Exception:
        pass
    return r + '_XXX'


class MAVLink_header(object):
    '''MAVLink message header'''
    def __init__(self, msgId, incompat_flags=0, compat_flags=0, mlen=0, seq=0, srcSystem=0, srcComponent=0):
        self.mlen = mlen
        self.seq = seq
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.msgId = msgId
        self.incompat_flags = incompat_flags
        self.compat_flags = compat_flags

    def pack(self, force_mavlink1=False):
        if WIRE_PROTOCOL_VERSION == '2.0' and not force_mavlink1:
            return struct.pack('<BBBBBBBHB', 254, self.mlen,
                               self.incompat_flags, self.compat_flags,
                               self.seq, self.srcSystem, self.srcComponent,
                               self.msgId&0xFFFF, self.msgId>>16)
        return struct.pack('<BBBBBB', PROTOCOL_MARKER_V1, self.mlen, self.seq,
                           self.srcSystem, self.srcComponent, self.msgId)

class MAVLink_message(object):
    '''base MAVLink message class'''
    def __init__(self, msgId, name):
        self._header     = MAVLink_header(msgId)
        self._payload    = None
        self._msgbuf     = None
        self._crc        = None
        self._fieldnames = []
        self._type       = name
        self._signed     = False
        self._link_id    = None
        self._instances  = None
        self._instance_field = None

    def format_attr(self, field):
        '''override field getter'''
        raw_attr = getattr(self,field)
        if isinstance(raw_attr, bytes):
            raw_attr = to_string(raw_attr).rstrip("\00")
        return raw_attr

    def get_msgbuf(self):
        if isinstance(self._msgbuf, bytearray):
            return self._msgbuf
        return bytearray(self._msgbuf)

    def get_header(self):
        return self._header

    def get_payload(self):
        return self._payload

    def get_crc(self):
        return self._crc

    def get_fieldnames(self):
        return self._fieldnames

    def get_type(self):
        return self._type

    def get_msgId(self):
        return self._header.msgId

    def get_srcSystem(self):
        return self._header.srcSystem

    def get_srcComponent(self):
        return self._header.srcComponent

    def get_seq(self):
        return self._header.seq

    def get_signed(self):
        return self._signed

    def get_link_id(self):
        return self._link_id

    def __str__(self):
        ret = '%s {' % self._type
        for a in self._fieldnames:
            v = self.format_attr(a)
            ret += '%s : %s, ' % (a, v)
        ret = ret[0:-2] + '}'
        return ret

    def __ne__(self, other):
        return not self.__eq__(other)

    def __eq__(self, other):
        if other is None:
            return False

        if self.get_type() != other.get_type():
            return False

        # We do not compare CRC because native code doesn't provide it
        #if self.get_crc() != other.get_crc():
        #    return False

        if self.get_seq() != other.get_seq():
            return False

        if self.get_srcSystem() != other.get_srcSystem():
            return False

        if self.get_srcComponent() != other.get_srcComponent():
            return False

        for a in self._fieldnames:
            if self.format_attr(a) != other.format_attr(a):
                return False

        return True

    def to_dict(self):
        d = dict({})
        d['mavpackettype'] = self._type
        for a in self._fieldnames:
          d[a] = self.format_attr(a)
        return d

    def to_json(self):
        return json.dumps(self.to_dict())

    def sign_packet(self, mav):
        h = hashlib.new('sha256')
        self._msgbuf += struct.pack('<BQ', mav.signing.link_id, mav.signing.timestamp)[:7]
        h.update(mav.signing.secret_key)
        h.update(self._msgbuf)
        sig = h.digest()[:6]
        self._msgbuf += sig
        mav.signing.timestamp += 1

    def pack(self, mav, crc_extra, payload, force_mavlink1=False):
        plen = len(payload)
        if WIRE_PROTOCOL_VERSION != '1.0' and not force_mavlink1:
            # in MAVLink2 we can strip trailing zeros off payloads. This allows for simple
            # variable length arrays and smaller packets
            nullbyte = chr(0)
            # in Python2, type("fred') is str but also type("fred")==bytes
            if str(type(payload)) == "<class 'bytes'>":
                nullbyte = 0
            while plen > 1 and payload[plen-1] == nullbyte:
                plen -= 1
        self._payload = payload[:plen]
        incompat_flags = 0
        if mav.signing.sign_outgoing:
            incompat_flags |= MAVLINK_IFLAG_SIGNED
        self._header  = MAVLink_header(self._header.msgId,
                                       incompat_flags=incompat_flags, compat_flags=0,
                                       mlen=len(self._payload), seq=mav.seq,
                                       srcSystem=mav.srcSystem, srcComponent=mav.srcComponent)
        self._msgbuf = self._header.pack(force_mavlink1=force_mavlink1) + self._payload
        crc = x25crc(self._msgbuf[1:])
        if True: # using CRC extra
            crc.accumulate_str(struct.pack('B', crc_extra))
        self._crc = crc.crc
        self._msgbuf += struct.pack('<H', self._crc)
        if mav.signing.sign_outgoing and not force_mavlink1:
            self.sign_packet(mav)
        return self._msgbuf

    def __getitem__(self, key):
        '''support indexing, allowing for multi-instance sensors in one message'''
        if self._instances is None:
            raise IndexError()
        if not key in self._instances:
            raise IndexError()
        return self._instances[key]


# enums

class EnumEntry(object):
    def __init__(self, name, description):
        self.name = name
        self.description = description
        self.param = {}

enums = {}

# ACCELCAL_VEHICLE_POS
enums['ACCELCAL_VEHICLE_POS'] = {}
ACCELCAL_VEHICLE_POS_LEVEL = 1 # 
enums['ACCELCAL_VEHICLE_POS'][1] = EnumEntry('ACCELCAL_VEHICLE_POS_LEVEL', '''''')
ACCELCAL_VEHICLE_POS_LEFT = 2 # 
enums['ACCELCAL_VEHICLE_POS'][2] = EnumEntry('ACCELCAL_VEHICLE_POS_LEFT', '''''')
ACCELCAL_VEHICLE_POS_RIGHT = 3 # 
enums['ACCELCAL_VEHICLE_POS'][3] = EnumEntry('ACCELCAL_VEHICLE_POS_RIGHT', '''''')
ACCELCAL_VEHICLE_POS_NOSEDOWN = 4 # 
enums['ACCELCAL_VEHICLE_POS'][4] = EnumEntry('ACCELCAL_VEHICLE_POS_NOSEDOWN', '''''')
ACCELCAL_VEHICLE_POS_NOSEUP = 5 # 
enums['ACCELCAL_VEHICLE_POS'][5] = EnumEntry('ACCELCAL_VEHICLE_POS_NOSEUP', '''''')
ACCELCAL_VEHICLE_POS_BACK = 6 # 
enums['ACCELCAL_VEHICLE_POS'][6] = EnumEntry('ACCELCAL_VEHICLE_POS_BACK', '''''')
ACCELCAL_VEHICLE_POS_SUCCESS = 16777215 # 
enums['ACCELCAL_VEHICLE_POS'][16777215] = EnumEntry('ACCELCAL_VEHICLE_POS_SUCCESS', '''''')
ACCELCAL_VEHICLE_POS_FAILED = 16777216 # 
enums['ACCELCAL_VEHICLE_POS'][16777216] = EnumEntry('ACCELCAL_VEHICLE_POS_FAILED', '''''')
ACCELCAL_VEHICLE_POS_ENUM_END = 16777217 # 
enums['ACCELCAL_VEHICLE_POS'][16777217] = EnumEntry('ACCELCAL_VEHICLE_POS_ENUM_END', '''''')

# HEADING_TYPE
enums['HEADING_TYPE'] = {}
HEADING_TYPE_COURSE_OVER_GROUND = 0 # 
enums['HEADING_TYPE'][0] = EnumEntry('HEADING_TYPE_COURSE_OVER_GROUND', '''''')
HEADING_TYPE_HEADING = 1 # 
enums['HEADING_TYPE'][1] = EnumEntry('HEADING_TYPE_HEADING', '''''')
HEADING_TYPE_ENUM_END = 2 # 
enums['HEADING_TYPE'][2] = EnumEntry('HEADING_TYPE_ENUM_END', '''''')

# SPEED_TYPE
enums['SPEED_TYPE'] = {}
SPEED_TYPE_AIRSPEED = 0 # 
enums['SPEED_TYPE'][0] = EnumEntry('SPEED_TYPE_AIRSPEED', '''''')
SPEED_TYPE_GROUNDSPEED = 1 # 
enums['SPEED_TYPE'][1] = EnumEntry('SPEED_TYPE_GROUNDSPEED', '''''')
SPEED_TYPE_ENUM_END = 2 # 
enums['SPEED_TYPE'][2] = EnumEntry('SPEED_TYPE_ENUM_END', '''''')

# MAV_CMD
enums['MAV_CMD'] = {}
MAV_CMD_NAV_WAYPOINT = 16 # Navigate to waypoint.
enums['MAV_CMD'][16] = EnumEntry('MAV_CMD_NAV_WAYPOINT', '''Navigate to waypoint.''')
enums['MAV_CMD'][16].param[1] = '''Hold time. (ignored by fixed wing, time to stay at waypoint for rotary wing)'''
enums['MAV_CMD'][16].param[2] = '''Acceptance radius (if the sphere with this radius is hit, the waypoint counts as reached)'''
enums['MAV_CMD'][16].param[3] = '''0 to pass through the WP, if > 0 radius to pass by WP. Positive value for clockwise orbit, negative value for counter-clockwise orbit. Allows trajectory control.'''
enums['MAV_CMD'][16].param[4] = '''Desired yaw angle at waypoint (rotary wing). NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][16].param[5] = '''Latitude'''
enums['MAV_CMD'][16].param[6] = '''Longitude'''
enums['MAV_CMD'][16].param[7] = '''Altitude'''
MAV_CMD_NAV_LOITER_UNLIM = 17 # Loiter around this waypoint an unlimited amount of time
enums['MAV_CMD'][17] = EnumEntry('MAV_CMD_NAV_LOITER_UNLIM', '''Loiter around this waypoint an unlimited amount of time''')
enums['MAV_CMD'][17].param[1] = '''Empty'''
enums['MAV_CMD'][17].param[2] = '''Empty'''
enums['MAV_CMD'][17].param[3] = '''Loiter radius around waypoint for forward-only moving vehicles (not multicopters). If positive loiter clockwise, else counter-clockwise'''
enums['MAV_CMD'][17].param[4] = '''Desired yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][17].param[5] = '''Latitude'''
enums['MAV_CMD'][17].param[6] = '''Longitude'''
enums['MAV_CMD'][17].param[7] = '''Altitude'''
MAV_CMD_NAV_LOITER_TURNS = 18 # Loiter around this waypoint for X turns
enums['MAV_CMD'][18] = EnumEntry('MAV_CMD_NAV_LOITER_TURNS', '''Loiter around this waypoint for X turns''')
enums['MAV_CMD'][18].param[1] = '''Number of turns.'''
enums['MAV_CMD'][18].param[2] = '''Empty'''
enums['MAV_CMD'][18].param[3] = '''Radius around waypoint. If positive loiter clockwise, else counter-clockwise'''
enums['MAV_CMD'][18].param[4] = '''Forward moving aircraft this sets exit xtrack location: 0 for center of loiter wp, 1 for exit location. Else, this is desired yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][18].param[5] = '''Latitude'''
enums['MAV_CMD'][18].param[6] = '''Longitude'''
enums['MAV_CMD'][18].param[7] = '''Altitude'''
MAV_CMD_NAV_LOITER_TIME = 19 # Loiter around this waypoint for X seconds
enums['MAV_CMD'][19] = EnumEntry('MAV_CMD_NAV_LOITER_TIME', '''Loiter around this waypoint for X seconds''')
enums['MAV_CMD'][19].param[1] = '''Loiter time.'''
enums['MAV_CMD'][19].param[2] = '''Empty'''
enums['MAV_CMD'][19].param[3] = '''Radius around waypoint. If positive loiter clockwise, else counter-clockwise.'''
enums['MAV_CMD'][19].param[4] = '''Forward moving aircraft this sets exit xtrack location: 0 for center of loiter wp, 1 for exit location. Else, this is desired yaw angle.  NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][19].param[5] = '''Latitude'''
enums['MAV_CMD'][19].param[6] = '''Longitude'''
enums['MAV_CMD'][19].param[7] = '''Altitude'''
MAV_CMD_NAV_RETURN_TO_LAUNCH = 20 # Return to launch location
enums['MAV_CMD'][20] = EnumEntry('MAV_CMD_NAV_RETURN_TO_LAUNCH', '''Return to launch location''')
enums['MAV_CMD'][20].param[1] = '''Empty'''
enums['MAV_CMD'][20].param[2] = '''Empty'''
enums['MAV_CMD'][20].param[3] = '''Empty'''
enums['MAV_CMD'][20].param[4] = '''Empty'''
enums['MAV_CMD'][20].param[5] = '''Empty'''
enums['MAV_CMD'][20].param[6] = '''Empty'''
enums['MAV_CMD'][20].param[7] = '''Empty'''
MAV_CMD_NAV_LAND = 21 # Land at location.
enums['MAV_CMD'][21] = EnumEntry('MAV_CMD_NAV_LAND', '''Land at location.''')
enums['MAV_CMD'][21].param[1] = '''Minimum target altitude if landing is aborted (0 = undefined/use system default).'''
enums['MAV_CMD'][21].param[2] = '''Precision land mode.'''
enums['MAV_CMD'][21].param[3] = '''Empty.'''
enums['MAV_CMD'][21].param[4] = '''Desired yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][21].param[5] = '''Latitude.'''
enums['MAV_CMD'][21].param[6] = '''Longitude.'''
enums['MAV_CMD'][21].param[7] = '''Landing altitude (ground level in current frame).'''
MAV_CMD_NAV_TAKEOFF = 22 # Takeoff from ground / hand. Vehicles that support multiple takeoff
                        # modes (e.g. VTOL quadplane) should take off
                        # using the currently configured mode.
enums['MAV_CMD'][22] = EnumEntry('MAV_CMD_NAV_TAKEOFF', '''Takeoff from ground / hand. Vehicles that support multiple takeoff modes (e.g. VTOL quadplane) should take off using the currently configured mode.''')
enums['MAV_CMD'][22].param[1] = '''Minimum pitch (if airspeed sensor present), desired pitch without sensor'''
enums['MAV_CMD'][22].param[2] = '''Empty'''
enums['MAV_CMD'][22].param[3] = '''Empty'''
enums['MAV_CMD'][22].param[4] = '''Yaw angle (if magnetometer present), ignored without magnetometer. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][22].param[5] = '''Latitude'''
enums['MAV_CMD'][22].param[6] = '''Longitude'''
enums['MAV_CMD'][22].param[7] = '''Altitude'''
MAV_CMD_NAV_LAND_LOCAL = 23 # Land at local position (local frame only)
enums['MAV_CMD'][23] = EnumEntry('MAV_CMD_NAV_LAND_LOCAL', '''Land at local position (local frame only)''')
enums['MAV_CMD'][23].param[1] = '''Landing target number (if available)'''
enums['MAV_CMD'][23].param[2] = '''Maximum accepted offset from desired landing position - computed magnitude from spherical coordinates: d = sqrt(x^2 + y^2 + z^2), which gives the maximum accepted distance between the desired landing position and the position where the vehicle is about to land'''
enums['MAV_CMD'][23].param[3] = '''Landing descend rate'''
enums['MAV_CMD'][23].param[4] = '''Desired yaw angle'''
enums['MAV_CMD'][23].param[5] = '''Y-axis position'''
enums['MAV_CMD'][23].param[6] = '''X-axis position'''
enums['MAV_CMD'][23].param[7] = '''Z-axis / ground level position'''
MAV_CMD_NAV_TAKEOFF_LOCAL = 24 # Takeoff from local position (local frame only)
enums['MAV_CMD'][24] = EnumEntry('MAV_CMD_NAV_TAKEOFF_LOCAL', '''Takeoff from local position (local frame only)''')
enums['MAV_CMD'][24].param[1] = '''Minimum pitch (if airspeed sensor present), desired pitch without sensor'''
enums['MAV_CMD'][24].param[2] = '''Empty'''
enums['MAV_CMD'][24].param[3] = '''Takeoff ascend rate'''
enums['MAV_CMD'][24].param[4] = '''Yaw angle (if magnetometer or another yaw estimation source present), ignored without one of these'''
enums['MAV_CMD'][24].param[5] = '''Y-axis position'''
enums['MAV_CMD'][24].param[6] = '''X-axis position'''
enums['MAV_CMD'][24].param[7] = '''Z-axis position'''
MAV_CMD_NAV_FOLLOW = 25 # Vehicle following, i.e. this waypoint represents the position of a
                        # moving vehicle
enums['MAV_CMD'][25] = EnumEntry('MAV_CMD_NAV_FOLLOW', '''Vehicle following, i.e. this waypoint represents the position of a moving vehicle''')
enums['MAV_CMD'][25].param[1] = '''Following logic to use (e.g. loitering or sinusoidal following) - depends on specific autopilot implementation'''
enums['MAV_CMD'][25].param[2] = '''Ground speed of vehicle to be followed'''
enums['MAV_CMD'][25].param[3] = '''Radius around waypoint. If positive loiter clockwise, else counter-clockwise'''
enums['MAV_CMD'][25].param[4] = '''Desired yaw angle.'''
enums['MAV_CMD'][25].param[5] = '''Latitude'''
enums['MAV_CMD'][25].param[6] = '''Longitude'''
enums['MAV_CMD'][25].param[7] = '''Altitude'''
MAV_CMD_NAV_CONTINUE_AND_CHANGE_ALT = 30 # Continue on the current course and climb/descend to specified
                        # altitude.  When the altitude is reached
                        # continue to the next command (i.e., don't
                        # proceed to the next command until the
                        # desired altitude is reached.
enums['MAV_CMD'][30] = EnumEntry('MAV_CMD_NAV_CONTINUE_AND_CHANGE_ALT', '''Continue on the current course and climb/descend to specified altitude.  When the altitude is reached continue to the next command (i.e., don't proceed to the next command until the desired altitude is reached.''')
enums['MAV_CMD'][30].param[1] = '''Climb or Descend (0 = Neutral, command completes when within 5m of this command's altitude, 1 = Climbing, command completes when at or above this command's altitude, 2 = Descending, command completes when at or below this command's altitude.'''
enums['MAV_CMD'][30].param[2] = '''Empty'''
enums['MAV_CMD'][30].param[3] = '''Empty'''
enums['MAV_CMD'][30].param[4] = '''Empty'''
enums['MAV_CMD'][30].param[5] = '''Empty'''
enums['MAV_CMD'][30].param[6] = '''Empty'''
enums['MAV_CMD'][30].param[7] = '''Desired altitude'''
MAV_CMD_NAV_LOITER_TO_ALT = 31 # Begin loiter at the specified Latitude and Longitude.  If Lat=Lon=0,
                        # then loiter at the current position.  Don't
                        # consider the navigation command complete
                        # (don't leave loiter) until the altitude has
                        # been reached. Additionally, if the Heading
                        # Required parameter is non-zero the aircraft
                        # will not leave the loiter until heading
                        # toward the next waypoint.
enums['MAV_CMD'][31] = EnumEntry('MAV_CMD_NAV_LOITER_TO_ALT', '''Begin loiter at the specified Latitude and Longitude.  If Lat=Lon=0, then loiter at the current position.  Don't consider the navigation command complete (don't leave loiter) until the altitude has been reached. Additionally, if the Heading Required parameter is non-zero the aircraft will not leave the loiter until heading toward the next waypoint.''')
enums['MAV_CMD'][31].param[1] = '''Heading Required (0 = False)'''
enums['MAV_CMD'][31].param[2] = '''Radius. If positive loiter clockwise, negative counter-clockwise, 0 means no change to standard loiter.'''
enums['MAV_CMD'][31].param[3] = '''Empty'''
enums['MAV_CMD'][31].param[4] = '''Forward moving aircraft this sets exit xtrack location: 0 for center of loiter wp, 1 for exit location'''
enums['MAV_CMD'][31].param[5] = '''Latitude'''
enums['MAV_CMD'][31].param[6] = '''Longitude'''
enums['MAV_CMD'][31].param[7] = '''Altitude'''
MAV_CMD_DO_FOLLOW = 32 # Begin following a target
enums['MAV_CMD'][32] = EnumEntry('MAV_CMD_DO_FOLLOW', '''Begin following a target''')
enums['MAV_CMD'][32].param[1] = '''System ID (of the FOLLOW_TARGET beacon). Send 0 to disable follow-me and return to the default position hold mode.'''
enums['MAV_CMD'][32].param[2] = '''Reserved'''
enums['MAV_CMD'][32].param[3] = '''Reserved'''
enums['MAV_CMD'][32].param[4] = '''Altitude mode: 0: Keep current altitude, 1: keep altitude difference to target, 2: go to a fixed altitude above home.'''
enums['MAV_CMD'][32].param[5] = '''Altitude above home. (used if mode=2)'''
enums['MAV_CMD'][32].param[6] = '''Reserved'''
enums['MAV_CMD'][32].param[7] = '''Time to land in which the MAV should go to the default position hold mode after a message RX timeout.'''
MAV_CMD_DO_FOLLOW_REPOSITION = 33 # Reposition the MAV after a follow target command has been sent
enums['MAV_CMD'][33] = EnumEntry('MAV_CMD_DO_FOLLOW_REPOSITION', '''Reposition the MAV after a follow target command has been sent''')
enums['MAV_CMD'][33].param[1] = '''Camera q1 (where 0 is on the ray from the camera to the tracking device)'''
enums['MAV_CMD'][33].param[2] = '''Camera q2'''
enums['MAV_CMD'][33].param[3] = '''Camera q3'''
enums['MAV_CMD'][33].param[4] = '''Camera q4'''
enums['MAV_CMD'][33].param[5] = '''altitude offset from target'''
enums['MAV_CMD'][33].param[6] = '''X offset from target'''
enums['MAV_CMD'][33].param[7] = '''Y offset from target'''
MAV_CMD_NAV_ROI = 80 # Sets the region of interest (ROI) for a sensor set or the vehicle
                        # itself. This can then be used by the
                        # vehicle's control system to control the
                        # vehicle attitude and the attitude of various
                        # sensors such as cameras.
enums['MAV_CMD'][80] = EnumEntry('MAV_CMD_NAV_ROI', '''Sets the region of interest (ROI) for a sensor set or the vehicle itself. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.''')
enums['MAV_CMD'][80].param[1] = '''Region of interest mode.'''
enums['MAV_CMD'][80].param[2] = '''Waypoint index/ target ID. (see MAV_ROI enum)'''
enums['MAV_CMD'][80].param[3] = '''ROI index (allows a vehicle to manage multiple ROI's)'''
enums['MAV_CMD'][80].param[4] = '''Empty'''
enums['MAV_CMD'][80].param[5] = '''x the location of the fixed ROI (see MAV_FRAME)'''
enums['MAV_CMD'][80].param[6] = '''y'''
enums['MAV_CMD'][80].param[7] = '''z'''
MAV_CMD_NAV_PATHPLANNING = 81 # Control autonomous path planning on the MAV.
enums['MAV_CMD'][81] = EnumEntry('MAV_CMD_NAV_PATHPLANNING', '''Control autonomous path planning on the MAV.''')
enums['MAV_CMD'][81].param[1] = '''0: Disable local obstacle avoidance / local path planning (without resetting map), 1: Enable local path planning, 2: Enable and reset local path planning'''
enums['MAV_CMD'][81].param[2] = '''0: Disable full path planning (without resetting map), 1: Enable, 2: Enable and reset map/occupancy grid, 3: Enable and reset planned route, but not occupancy grid'''
enums['MAV_CMD'][81].param[3] = '''Empty'''
enums['MAV_CMD'][81].param[4] = '''Yaw angle at goal'''
enums['MAV_CMD'][81].param[5] = '''Latitude/X of goal'''
enums['MAV_CMD'][81].param[6] = '''Longitude/Y of goal'''
enums['MAV_CMD'][81].param[7] = '''Altitude/Z of goal'''
MAV_CMD_NAV_SPLINE_WAYPOINT = 82 # Navigate to waypoint using a spline path.
enums['MAV_CMD'][82] = EnumEntry('MAV_CMD_NAV_SPLINE_WAYPOINT', '''Navigate to waypoint using a spline path.''')
enums['MAV_CMD'][82].param[1] = '''Hold time. (ignored by fixed wing, time to stay at waypoint for rotary wing)'''
enums['MAV_CMD'][82].param[2] = '''Empty'''
enums['MAV_CMD'][82].param[3] = '''Empty'''
enums['MAV_CMD'][82].param[4] = '''Empty'''
enums['MAV_CMD'][82].param[5] = '''Latitude/X of goal'''
enums['MAV_CMD'][82].param[6] = '''Longitude/Y of goal'''
enums['MAV_CMD'][82].param[7] = '''Altitude/Z of goal'''
MAV_CMD_NAV_ALTITUDE_WAIT = 83 # Mission command to wait for an altitude or downwards vertical speed.
                        # This is meant for high altitude balloon
                        # launches, allowing the aircraft to be idle
                        # until either an altitude is reached or a
                        # negative vertical speed is reached
                        # (indicating early balloon burst). The wiggle
                        # time is how often to wiggle the control
                        # surfaces to prevent them seizing up.
enums['MAV_CMD'][83] = EnumEntry('MAV_CMD_NAV_ALTITUDE_WAIT', '''Mission command to wait for an altitude or downwards vertical speed. This is meant for high altitude balloon launches, allowing the aircraft to be idle until either an altitude is reached or a negative vertical speed is reached (indicating early balloon burst). The wiggle time is how often to wiggle the control surfaces to prevent them seizing up.''')
enums['MAV_CMD'][83].param[1] = '''Altitude.'''
enums['MAV_CMD'][83].param[2] = '''Descent speed.'''
enums['MAV_CMD'][83].param[3] = '''How long to wiggle the control surfaces to prevent them seizing up.'''
enums['MAV_CMD'][83].param[4] = '''Empty.'''
enums['MAV_CMD'][83].param[5] = '''Empty.'''
enums['MAV_CMD'][83].param[6] = '''Empty.'''
enums['MAV_CMD'][83].param[7] = '''Empty.'''
MAV_CMD_NAV_VTOL_TAKEOFF = 84 # Takeoff from ground using VTOL mode, and transition to forward flight
                        # with specified heading.
enums['MAV_CMD'][84] = EnumEntry('MAV_CMD_NAV_VTOL_TAKEOFF', '''Takeoff from ground using VTOL mode, and transition to forward flight with specified heading.''')
enums['MAV_CMD'][84].param[1] = '''Empty'''
enums['MAV_CMD'][84].param[2] = '''Front transition heading.'''
enums['MAV_CMD'][84].param[3] = '''Empty'''
enums['MAV_CMD'][84].param[4] = '''Yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][84].param[5] = '''Latitude'''
enums['MAV_CMD'][84].param[6] = '''Longitude'''
enums['MAV_CMD'][84].param[7] = '''Altitude'''
MAV_CMD_NAV_VTOL_LAND = 85 # Land using VTOL mode
enums['MAV_CMD'][85] = EnumEntry('MAV_CMD_NAV_VTOL_LAND', '''Land using VTOL mode''')
enums['MAV_CMD'][85].param[1] = '''Empty'''
enums['MAV_CMD'][85].param[2] = '''Empty'''
enums['MAV_CMD'][85].param[3] = '''Approach altitude (with the same reference as the Altitude field). NaN if unspecified.'''
enums['MAV_CMD'][85].param[4] = '''Yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.).'''
enums['MAV_CMD'][85].param[5] = '''Latitude'''
enums['MAV_CMD'][85].param[6] = '''Longitude'''
enums['MAV_CMD'][85].param[7] = '''Altitude (ground level)'''
MAV_CMD_NAV_GUIDED_ENABLE = 92 # hand control over to an external controller
enums['MAV_CMD'][92] = EnumEntry('MAV_CMD_NAV_GUIDED_ENABLE', '''hand control over to an external controller''')
enums['MAV_CMD'][92].param[1] = '''On / Off (> 0.5f on)'''
enums['MAV_CMD'][92].param[2] = '''Empty'''
enums['MAV_CMD'][92].param[3] = '''Empty'''
enums['MAV_CMD'][92].param[4] = '''Empty'''
enums['MAV_CMD'][92].param[5] = '''Empty'''
enums['MAV_CMD'][92].param[6] = '''Empty'''
enums['MAV_CMD'][92].param[7] = '''Empty'''
MAV_CMD_NAV_DELAY = 93 # Delay the next navigation command a number of seconds or until a
                        # specified time
enums['MAV_CMD'][93] = EnumEntry('MAV_CMD_NAV_DELAY', '''Delay the next navigation command a number of seconds or until a specified time''')
enums['MAV_CMD'][93].param[1] = '''Delay (-1 to enable time-of-day fields)'''
enums['MAV_CMD'][93].param[2] = '''hour (24h format, UTC, -1 to ignore)'''
enums['MAV_CMD'][93].param[3] = '''minute (24h format, UTC, -1 to ignore)'''
enums['MAV_CMD'][93].param[4] = '''second (24h format, UTC, -1 to ignore)'''
enums['MAV_CMD'][93].param[5] = '''Empty'''
enums['MAV_CMD'][93].param[6] = '''Empty'''
enums['MAV_CMD'][93].param[7] = '''Empty'''
MAV_CMD_NAV_PAYLOAD_PLACE = 94 # Descend and place payload. Vehicle moves to specified location,
                        # descends until it detects a hanging payload
                        # has reached the ground, and then releases
                        # the payload. If ground is not detected
                        # before the reaching the maximum descent
                        # value (param1), the command will complete
                        # without releasing the payload.
enums['MAV_CMD'][94] = EnumEntry('MAV_CMD_NAV_PAYLOAD_PLACE', '''Descend and place payload. Vehicle moves to specified location, descends until it detects a hanging payload has reached the ground, and then releases the payload. If ground is not detected before the reaching the maximum descent value (param1), the command will complete without releasing the payload.''')
enums['MAV_CMD'][94].param[1] = '''Maximum distance to descend.'''
enums['MAV_CMD'][94].param[2] = '''Empty'''
enums['MAV_CMD'][94].param[3] = '''Empty'''
enums['MAV_CMD'][94].param[4] = '''Empty'''
enums['MAV_CMD'][94].param[5] = '''Latitude'''
enums['MAV_CMD'][94].param[6] = '''Longitude'''
enums['MAV_CMD'][94].param[7] = '''Altitude'''
MAV_CMD_NAV_LAST = 95 # NOP - This command is only used to mark the upper limit of the
                        # NAV/ACTION commands in the enumeration
enums['MAV_CMD'][95] = EnumEntry('MAV_CMD_NAV_LAST', '''NOP - This command is only used to mark the upper limit of the NAV/ACTION commands in the enumeration''')
enums['MAV_CMD'][95].param[1] = '''Empty'''
enums['MAV_CMD'][95].param[2] = '''Empty'''
enums['MAV_CMD'][95].param[3] = '''Empty'''
enums['MAV_CMD'][95].param[4] = '''Empty'''
enums['MAV_CMD'][95].param[5] = '''Empty'''
enums['MAV_CMD'][95].param[6] = '''Empty'''
enums['MAV_CMD'][95].param[7] = '''Empty'''
MAV_CMD_CONDITION_DELAY = 112 # Delay mission state machine.
enums['MAV_CMD'][112] = EnumEntry('MAV_CMD_CONDITION_DELAY', '''Delay mission state machine.''')
enums['MAV_CMD'][112].param[1] = '''Delay'''
enums['MAV_CMD'][112].param[2] = '''Empty'''
enums['MAV_CMD'][112].param[3] = '''Empty'''
enums['MAV_CMD'][112].param[4] = '''Empty'''
enums['MAV_CMD'][112].param[5] = '''Empty'''
enums['MAV_CMD'][112].param[6] = '''Empty'''
enums['MAV_CMD'][112].param[7] = '''Empty'''
MAV_CMD_CONDITION_CHANGE_ALT = 113 # Ascend/descend to target altitude at specified rate. Delay mission
                        # state machine until desired altitude
                        # reached.
enums['MAV_CMD'][113] = EnumEntry('MAV_CMD_CONDITION_CHANGE_ALT', '''Ascend/descend to target altitude at specified rate. Delay mission state machine until desired altitude reached.''')
enums['MAV_CMD'][113].param[1] = '''Descent / Ascend rate.'''
enums['MAV_CMD'][113].param[2] = '''Empty'''
enums['MAV_CMD'][113].param[3] = '''Empty'''
enums['MAV_CMD'][113].param[4] = '''Empty'''
enums['MAV_CMD'][113].param[5] = '''Empty'''
enums['MAV_CMD'][113].param[6] = '''Empty'''
enums['MAV_CMD'][113].param[7] = '''Target Altitude'''
MAV_CMD_CONDITION_DISTANCE = 114 # Delay mission state machine until within desired distance of next NAV
                        # point.
enums['MAV_CMD'][114] = EnumEntry('MAV_CMD_CONDITION_DISTANCE', '''Delay mission state machine until within desired distance of next NAV point.''')
enums['MAV_CMD'][114].param[1] = '''Distance.'''
enums['MAV_CMD'][114].param[2] = '''Empty'''
enums['MAV_CMD'][114].param[3] = '''Empty'''
enums['MAV_CMD'][114].param[4] = '''Empty'''
enums['MAV_CMD'][114].param[5] = '''Empty'''
enums['MAV_CMD'][114].param[6] = '''Empty'''
enums['MAV_CMD'][114].param[7] = '''Empty'''
MAV_CMD_CONDITION_YAW = 115 # Reach a certain target angle.
enums['MAV_CMD'][115] = EnumEntry('MAV_CMD_CONDITION_YAW', '''Reach a certain target angle.''')
enums['MAV_CMD'][115].param[1] = '''target angle, 0 is north'''
enums['MAV_CMD'][115].param[2] = '''angular speed'''
enums['MAV_CMD'][115].param[3] = '''direction: -1: counter clockwise, 1: clockwise'''
enums['MAV_CMD'][115].param[4] = '''0: absolute angle, 1: relative offset'''
enums['MAV_CMD'][115].param[5] = '''Empty'''
enums['MAV_CMD'][115].param[6] = '''Empty'''
enums['MAV_CMD'][115].param[7] = '''Empty'''
MAV_CMD_CONDITION_LAST = 159 # NOP - This command is only used to mark the upper limit of the
                        # CONDITION commands in the enumeration
enums['MAV_CMD'][159] = EnumEntry('MAV_CMD_CONDITION_LAST', '''NOP - This command is only used to mark the upper limit of the CONDITION commands in the enumeration''')
enums['MAV_CMD'][159].param[1] = '''Empty'''
enums['MAV_CMD'][159].param[2] = '''Empty'''
enums['MAV_CMD'][159].param[3] = '''Empty'''
enums['MAV_CMD'][159].param[4] = '''Empty'''
enums['MAV_CMD'][159].param[5] = '''Empty'''
enums['MAV_CMD'][159].param[6] = '''Empty'''
enums['MAV_CMD'][159].param[7] = '''Empty'''
MAV_CMD_DO_SET_MODE = 176 # Set system mode.
enums['MAV_CMD'][176] = EnumEntry('MAV_CMD_DO_SET_MODE', '''Set system mode.''')
enums['MAV_CMD'][176].param[1] = '''Mode'''
enums['MAV_CMD'][176].param[2] = '''Custom mode - this is system specific, please refer to the individual autopilot specifications for details.'''
enums['MAV_CMD'][176].param[3] = '''Custom sub mode - this is system specific, please refer to the individual autopilot specifications for details.'''
enums['MAV_CMD'][176].param[4] = '''Empty'''
enums['MAV_CMD'][176].param[5] = '''Empty'''
enums['MAV_CMD'][176].param[6] = '''Empty'''
enums['MAV_CMD'][176].param[7] = '''Empty'''
MAV_CMD_DO_JUMP = 177 # Jump to the desired command in the mission list.  Repeat this action
                        # only the specified number of times
enums['MAV_CMD'][177] = EnumEntry('MAV_CMD_DO_JUMP', '''Jump to the desired command in the mission list.  Repeat this action only the specified number of times''')
enums['MAV_CMD'][177].param[1] = '''Sequence number'''
enums['MAV_CMD'][177].param[2] = '''Repeat count'''
enums['MAV_CMD'][177].param[3] = '''Empty'''
enums['MAV_CMD'][177].param[4] = '''Empty'''
enums['MAV_CMD'][177].param[5] = '''Empty'''
enums['MAV_CMD'][177].param[6] = '''Empty'''
enums['MAV_CMD'][177].param[7] = '''Empty'''
MAV_CMD_DO_CHANGE_SPEED = 178 # Change speed and/or throttle set points.
enums['MAV_CMD'][178] = EnumEntry('MAV_CMD_DO_CHANGE_SPEED', '''Change speed and/or throttle set points.''')
enums['MAV_CMD'][178].param[1] = '''Speed type (0=Airspeed, 1=Ground Speed, 2=Climb Speed, 3=Descent Speed)'''
enums['MAV_CMD'][178].param[2] = '''Speed (-1 indicates no change)'''
enums['MAV_CMD'][178].param[3] = '''Throttle (-1 indicates no change)'''
enums['MAV_CMD'][178].param[4] = '''0: absolute, 1: relative'''
enums['MAV_CMD'][178].param[5] = '''Empty'''
enums['MAV_CMD'][178].param[6] = '''Empty'''
enums['MAV_CMD'][178].param[7] = '''Empty'''
MAV_CMD_DO_SET_HOME = 179 # Changes the home location either to the current location or a
                        # specified location.
enums['MAV_CMD'][179] = EnumEntry('MAV_CMD_DO_SET_HOME', '''Changes the home location either to the current location or a specified location.''')
enums['MAV_CMD'][179].param[1] = '''Use current (1=use current location, 0=use specified location)'''
enums['MAV_CMD'][179].param[2] = '''Empty'''
enums['MAV_CMD'][179].param[3] = '''Empty'''
enums['MAV_CMD'][179].param[4] = '''Empty'''
enums['MAV_CMD'][179].param[5] = '''Latitude'''
enums['MAV_CMD'][179].param[6] = '''Longitude'''
enums['MAV_CMD'][179].param[7] = '''Altitude'''
MAV_CMD_DO_SET_PARAMETER = 180 # Set a system parameter.  Caution!  Use of this command requires
                        # knowledge of the numeric enumeration value
                        # of the parameter.
enums['MAV_CMD'][180] = EnumEntry('MAV_CMD_DO_SET_PARAMETER', '''Set a system parameter.  Caution!  Use of this command requires knowledge of the numeric enumeration value of the parameter.''')
enums['MAV_CMD'][180].param[1] = '''Parameter number'''
enums['MAV_CMD'][180].param[2] = '''Parameter value'''
enums['MAV_CMD'][180].param[3] = '''Empty'''
enums['MAV_CMD'][180].param[4] = '''Empty'''
enums['MAV_CMD'][180].param[5] = '''Empty'''
enums['MAV_CMD'][180].param[6] = '''Empty'''
enums['MAV_CMD'][180].param[7] = '''Empty'''
MAV_CMD_DO_SET_RELAY = 181 # Set a relay to a condition.
enums['MAV_CMD'][181] = EnumEntry('MAV_CMD_DO_SET_RELAY', '''Set a relay to a condition.''')
enums['MAV_CMD'][181].param[1] = '''Relay instance number.'''
enums['MAV_CMD'][181].param[2] = '''Setting. (1=on, 0=off, others possible depending on system hardware)'''
enums['MAV_CMD'][181].param[3] = '''Empty'''
enums['MAV_CMD'][181].param[4] = '''Empty'''
enums['MAV_CMD'][181].param[5] = '''Empty'''
enums['MAV_CMD'][181].param[6] = '''Empty'''
enums['MAV_CMD'][181].param[7] = '''Empty'''
MAV_CMD_DO_REPEAT_RELAY = 182 # Cycle a relay on and off for a desired number of cycles with a desired
                        # period.
enums['MAV_CMD'][182] = EnumEntry('MAV_CMD_DO_REPEAT_RELAY', '''Cycle a relay on and off for a desired number of cycles with a desired period.''')
enums['MAV_CMD'][182].param[1] = '''Relay instance number.'''
enums['MAV_CMD'][182].param[2] = '''Cycle count.'''
enums['MAV_CMD'][182].param[3] = '''Cycle time.'''
enums['MAV_CMD'][182].param[4] = '''Empty'''
enums['MAV_CMD'][182].param[5] = '''Empty'''
enums['MAV_CMD'][182].param[6] = '''Empty'''
enums['MAV_CMD'][182].param[7] = '''Empty'''
MAV_CMD_DO_SET_SERVO = 183 # Set a servo to a desired PWM value.
enums['MAV_CMD'][183] = EnumEntry('MAV_CMD_DO_SET_SERVO', '''Set a servo to a desired PWM value.''')
enums['MAV_CMD'][183].param[1] = '''Servo instance number.'''
enums['MAV_CMD'][183].param[2] = '''Pulse Width Modulation.'''
enums['MAV_CMD'][183].param[3] = '''Empty'''
enums['MAV_CMD'][183].param[4] = '''Empty'''
enums['MAV_CMD'][183].param[5] = '''Empty'''
enums['MAV_CMD'][183].param[6] = '''Empty'''
enums['MAV_CMD'][183].param[7] = '''Empty'''
MAV_CMD_DO_REPEAT_SERVO = 184 # Cycle a between its nominal setting and a desired PWM for a desired
                        # number of cycles with a desired period.
enums['MAV_CMD'][184] = EnumEntry('MAV_CMD_DO_REPEAT_SERVO', '''Cycle a between its nominal setting and a desired PWM for a desired number of cycles with a desired period.''')
enums['MAV_CMD'][184].param[1] = '''Servo instance number.'''
enums['MAV_CMD'][184].param[2] = '''Pulse Width Modulation.'''
enums['MAV_CMD'][184].param[3] = '''Cycle count.'''
enums['MAV_CMD'][184].param[4] = '''Cycle time.'''
enums['MAV_CMD'][184].param[5] = '''Empty'''
enums['MAV_CMD'][184].param[6] = '''Empty'''
enums['MAV_CMD'][184].param[7] = '''Empty'''
MAV_CMD_DO_FLIGHTTERMINATION = 185 # Terminate flight immediately
enums['MAV_CMD'][185] = EnumEntry('MAV_CMD_DO_FLIGHTTERMINATION', '''Terminate flight immediately''')
enums['MAV_CMD'][185].param[1] = '''Flight termination activated if > 0.5'''
enums['MAV_CMD'][185].param[2] = '''Empty'''
enums['MAV_CMD'][185].param[3] = '''Empty'''
enums['MAV_CMD'][185].param[4] = '''Empty'''
enums['MAV_CMD'][185].param[5] = '''Empty'''
enums['MAV_CMD'][185].param[6] = '''Empty'''
enums['MAV_CMD'][185].param[7] = '''Empty'''
MAV_CMD_DO_CHANGE_ALTITUDE = 186 # Change altitude set point.
enums['MAV_CMD'][186] = EnumEntry('MAV_CMD_DO_CHANGE_ALTITUDE', '''Change altitude set point.''')
enums['MAV_CMD'][186].param[1] = '''Altitude.'''
enums['MAV_CMD'][186].param[2] = '''Frame of new altitude.'''
enums['MAV_CMD'][186].param[3] = '''Empty'''
enums['MAV_CMD'][186].param[4] = '''Empty'''
enums['MAV_CMD'][186].param[5] = '''Empty'''
enums['MAV_CMD'][186].param[6] = '''Empty'''
enums['MAV_CMD'][186].param[7] = '''Empty'''
MAV_CMD_DO_LAND_START = 189 # Mission command to perform a landing. This is used as a marker in a
                        # mission to tell the autopilot where a
                        # sequence of mission items that represents a
                        # landing starts. It may also be sent via a
                        # COMMAND_LONG to trigger a landing, in which
                        # case the nearest (geographically) landing
                        # sequence in the mission will be used. The
                        # Latitude/Longitude is optional, and may be
                        # set to 0 if not needed. If specified then it
                        # will be used to help find the closest
                        # landing sequence.
enums['MAV_CMD'][189] = EnumEntry('MAV_CMD_DO_LAND_START', '''Mission command to perform a landing. This is used as a marker in a mission to tell the autopilot where a sequence of mission items that represents a landing starts. It may also be sent via a COMMAND_LONG to trigger a landing, in which case the nearest (geographically) landing sequence in the mission will be used. The Latitude/Longitude is optional, and may be set to 0 if not needed. If specified then it will be used to help find the closest landing sequence.''')
enums['MAV_CMD'][189].param[1] = '''Empty'''
enums['MAV_CMD'][189].param[2] = '''Empty'''
enums['MAV_CMD'][189].param[3] = '''Empty'''
enums['MAV_CMD'][189].param[4] = '''Empty'''
enums['MAV_CMD'][189].param[5] = '''Latitude'''
enums['MAV_CMD'][189].param[6] = '''Longitude'''
enums['MAV_CMD'][189].param[7] = '''Empty'''
MAV_CMD_DO_RALLY_LAND = 190 # Mission command to perform a landing from a rally point.
enums['MAV_CMD'][190] = EnumEntry('MAV_CMD_DO_RALLY_LAND', '''Mission command to perform a landing from a rally point.''')
enums['MAV_CMD'][190].param[1] = '''Break altitude'''
enums['MAV_CMD'][190].param[2] = '''Landing speed'''
enums['MAV_CMD'][190].param[3] = '''Empty'''
enums['MAV_CMD'][190].param[4] = '''Empty'''
enums['MAV_CMD'][190].param[5] = '''Empty'''
enums['MAV_CMD'][190].param[6] = '''Empty'''
enums['MAV_CMD'][190].param[7] = '''Empty'''
MAV_CMD_DO_GO_AROUND = 191 # Mission command to safely abort an autonomous landing.
enums['MAV_CMD'][191] = EnumEntry('MAV_CMD_DO_GO_AROUND', '''Mission command to safely abort an autonomous landing.''')
enums['MAV_CMD'][191].param[1] = '''Altitude'''
enums['MAV_CMD'][191].param[2] = '''Empty'''
enums['MAV_CMD'][191].param[3] = '''Empty'''
enums['MAV_CMD'][191].param[4] = '''Empty'''
enums['MAV_CMD'][191].param[5] = '''Empty'''
enums['MAV_CMD'][191].param[6] = '''Empty'''
enums['MAV_CMD'][191].param[7] = '''Empty'''
MAV_CMD_DO_REPOSITION = 192 # Reposition the vehicle to a specific WGS84 global position.
enums['MAV_CMD'][192] = EnumEntry('MAV_CMD_DO_REPOSITION', '''Reposition the vehicle to a specific WGS84 global position.''')
enums['MAV_CMD'][192].param[1] = '''Ground speed, less than 0 (-1) for default'''
enums['MAV_CMD'][192].param[2] = '''Bitmask of option flags.'''
enums['MAV_CMD'][192].param[3] = '''Reserved'''
enums['MAV_CMD'][192].param[4] = '''Yaw heading. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.). For planes indicates loiter direction (0: clockwise, 1: counter clockwise)'''
enums['MAV_CMD'][192].param[5] = '''Latitude'''
enums['MAV_CMD'][192].param[6] = '''Longitude'''
enums['MAV_CMD'][192].param[7] = '''Altitude'''
MAV_CMD_DO_PAUSE_CONTINUE = 193 # If in a GPS controlled position mode, hold the current position or
                        # continue.
enums['MAV_CMD'][193] = EnumEntry('MAV_CMD_DO_PAUSE_CONTINUE', '''If in a GPS controlled position mode, hold the current position or continue.''')
enums['MAV_CMD'][193].param[1] = '''0: Pause current mission or reposition command, hold current position. 1: Continue mission. A VTOL capable vehicle should enter hover mode (multicopter and VTOL planes). A plane should loiter with the default loiter radius.'''
enums['MAV_CMD'][193].param[2] = '''Reserved'''
enums['MAV_CMD'][193].param[3] = '''Reserved'''
enums['MAV_CMD'][193].param[4] = '''Reserved'''
enums['MAV_CMD'][193].param[5] = '''Reserved'''
enums['MAV_CMD'][193].param[6] = '''Reserved'''
enums['MAV_CMD'][193].param[7] = '''Reserved'''
MAV_CMD_DO_SET_REVERSE = 194 # Set moving direction to forward or reverse.
enums['MAV_CMD'][194] = EnumEntry('MAV_CMD_DO_SET_REVERSE', '''Set moving direction to forward or reverse.''')
enums['MAV_CMD'][194].param[1] = '''Direction (0=Forward, 1=Reverse)'''
enums['MAV_CMD'][194].param[2] = '''Empty'''
enums['MAV_CMD'][194].param[3] = '''Empty'''
enums['MAV_CMD'][194].param[4] = '''Empty'''
enums['MAV_CMD'][194].param[5] = '''Empty'''
enums['MAV_CMD'][194].param[6] = '''Empty'''
enums['MAV_CMD'][194].param[7] = '''Empty'''
MAV_CMD_DO_SET_ROI_LOCATION = 195 # Sets the region of interest (ROI) to a location. This can then be used
                        # by the vehicle's control system to control
                        # the vehicle attitude and the attitude of
                        # various sensors such as cameras.
enums['MAV_CMD'][195] = EnumEntry('MAV_CMD_DO_SET_ROI_LOCATION', '''Sets the region of interest (ROI) to a location. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.''')
enums['MAV_CMD'][195].param[1] = '''Empty'''
enums['MAV_CMD'][195].param[2] = '''Empty'''
enums['MAV_CMD'][195].param[3] = '''Empty'''
enums['MAV_CMD'][195].param[4] = '''Empty'''
enums['MAV_CMD'][195].param[5] = '''Latitude of ROI location'''
enums['MAV_CMD'][195].param[6] = '''Longitude of ROI location'''
enums['MAV_CMD'][195].param[7] = '''Altitude of ROI location'''
MAV_CMD_DO_SET_ROI_WPNEXT_OFFSET = 196 # Sets the region of interest (ROI) to be toward next waypoint, with
                        # optional pitch/roll/yaw offset. This can
                        # then be used by the vehicle's control system
                        # to control the vehicle attitude and the
                        # attitude of various sensors such as cameras.
enums['MAV_CMD'][196] = EnumEntry('MAV_CMD_DO_SET_ROI_WPNEXT_OFFSET', '''Sets the region of interest (ROI) to be toward next waypoint, with optional pitch/roll/yaw offset. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.''')
enums['MAV_CMD'][196].param[1] = '''Empty'''
enums['MAV_CMD'][196].param[2] = '''Empty'''
enums['MAV_CMD'][196].param[3] = '''Empty'''
enums['MAV_CMD'][196].param[4] = '''Empty'''
enums['MAV_CMD'][196].param[5] = '''Pitch offset from next waypoint, positive pitching up'''
enums['MAV_CMD'][196].param[6] = '''Roll offset from next waypoint, positive rolling to the right'''
enums['MAV_CMD'][196].param[7] = '''Yaw offset from next waypoint, positive yawing to the right'''
MAV_CMD_DO_SET_ROI_NONE = 197 # Cancels any previous ROI command returning the vehicle/sensors to
                        # default flight characteristics. This can
                        # then be used by the vehicle's control system
                        # to control the vehicle attitude and the
                        # attitude of various sensors such as cameras.
enums['MAV_CMD'][197] = EnumEntry('MAV_CMD_DO_SET_ROI_NONE', '''Cancels any previous ROI command returning the vehicle/sensors to default flight characteristics. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.''')
enums['MAV_CMD'][197].param[1] = '''Empty'''
enums['MAV_CMD'][197].param[2] = '''Empty'''
enums['MAV_CMD'][197].param[3] = '''Empty'''
enums['MAV_CMD'][197].param[4] = '''Empty'''
enums['MAV_CMD'][197].param[5] = '''Empty'''
enums['MAV_CMD'][197].param[6] = '''Empty'''
enums['MAV_CMD'][197].param[7] = '''Empty'''
MAV_CMD_DO_SET_ROI_SYSID = 198 # Mount tracks system with specified system ID. Determination of target
                        # vehicle position may be done with
                        # GLOBAL_POSITION_INT or any other means.
enums['MAV_CMD'][198] = EnumEntry('MAV_CMD_DO_SET_ROI_SYSID', '''Mount tracks system with specified system ID. Determination of target vehicle position may be done with GLOBAL_POSITION_INT or any other means.''')
enums['MAV_CMD'][198].param[1] = '''System ID'''
enums['MAV_CMD'][198].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][198].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][198].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][198].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][198].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][198].param[7] = '''Reserved (default:0)'''
MAV_CMD_DO_CONTROL_VIDEO = 200 # Control onboard camera system.
enums['MAV_CMD'][200] = EnumEntry('MAV_CMD_DO_CONTROL_VIDEO', '''Control onboard camera system.''')
enums['MAV_CMD'][200].param[1] = '''Camera ID (-1 for all)'''
enums['MAV_CMD'][200].param[2] = '''Transmission: 0: disabled, 1: enabled compressed, 2: enabled raw'''
enums['MAV_CMD'][200].param[3] = '''Transmission mode: 0: video stream, >0: single images every n seconds'''
enums['MAV_CMD'][200].param[4] = '''Recording: 0: disabled, 1: enabled compressed, 2: enabled raw'''
enums['MAV_CMD'][200].param[5] = '''Empty'''
enums['MAV_CMD'][200].param[6] = '''Empty'''
enums['MAV_CMD'][200].param[7] = '''Empty'''
MAV_CMD_DO_SET_ROI = 201 # Sets the region of interest (ROI) for a sensor set or the vehicle
                        # itself. This can then be used by the
                        # vehicle's control system to control the
                        # vehicle attitude and the attitude of various
                        # sensors such as cameras.
enums['MAV_CMD'][201] = EnumEntry('MAV_CMD_DO_SET_ROI', '''Sets the region of interest (ROI) for a sensor set or the vehicle itself. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.''')
enums['MAV_CMD'][201].param[1] = '''Region of interest mode.'''
enums['MAV_CMD'][201].param[2] = '''Waypoint index/ target ID (depends on param 1).'''
enums['MAV_CMD'][201].param[3] = '''Region of interest index. (allows a vehicle to manage multiple ROI's)'''
enums['MAV_CMD'][201].param[4] = '''Empty'''
enums['MAV_CMD'][201].param[5] = '''x the location of the fixed ROI (see MAV_FRAME)'''
enums['MAV_CMD'][201].param[6] = '''y'''
enums['MAV_CMD'][201].param[7] = '''z'''
MAV_CMD_DO_DIGICAM_CONFIGURE = 202 # Configure digital camera. This is a fallback message for systems that
                        # have not yet implemented PARAM_EXT_XXX
                        # messages and camera definition files (see ht
                        # tps://mavlink.io/en/services/camera_def.html
                        # ).
enums['MAV_CMD'][202] = EnumEntry('MAV_CMD_DO_DIGICAM_CONFIGURE', '''Configure digital camera. This is a fallback message for systems that have not yet implemented PARAM_EXT_XXX messages and camera definition files (see https://mavlink.io/en/services/camera_def.html ).''')
enums['MAV_CMD'][202].param[1] = '''Modes: P, TV, AV, M, Etc.'''
enums['MAV_CMD'][202].param[2] = '''Shutter speed: Divisor number for one second.'''
enums['MAV_CMD'][202].param[3] = '''Aperture: F stop number.'''
enums['MAV_CMD'][202].param[4] = '''ISO number e.g. 80, 100, 200, Etc.'''
enums['MAV_CMD'][202].param[5] = '''Exposure type enumerator.'''
enums['MAV_CMD'][202].param[6] = '''Command Identity.'''
enums['MAV_CMD'][202].param[7] = '''Main engine cut-off time before camera trigger. (0 means no cut-off)'''
MAV_CMD_DO_DIGICAM_CONTROL = 203 # Control digital camera. This is a fallback message for systems that
                        # have not yet implemented PARAM_EXT_XXX
                        # messages and camera definition files (see ht
                        # tps://mavlink.io/en/services/camera_def.html
                        # ).
enums['MAV_CMD'][203] = EnumEntry('MAV_CMD_DO_DIGICAM_CONTROL', '''Control digital camera. This is a fallback message for systems that have not yet implemented PARAM_EXT_XXX messages and camera definition files (see https://mavlink.io/en/services/camera_def.html ).''')
enums['MAV_CMD'][203].param[1] = '''Session control e.g. show/hide lens'''
enums['MAV_CMD'][203].param[2] = '''Zoom's absolute position'''
enums['MAV_CMD'][203].param[3] = '''Zooming step value to offset zoom from the current position'''
enums['MAV_CMD'][203].param[4] = '''Focus Locking, Unlocking or Re-locking'''
enums['MAV_CMD'][203].param[5] = '''Shooting Command'''
enums['MAV_CMD'][203].param[6] = '''Command Identity'''
enums['MAV_CMD'][203].param[7] = '''Test shot identifier. If set to 1, image will only be captured, but not counted towards internal frame count.'''
MAV_CMD_DO_MOUNT_CONFIGURE = 204 # Mission command to configure a camera or antenna mount
enums['MAV_CMD'][204] = EnumEntry('MAV_CMD_DO_MOUNT_CONFIGURE', '''Mission command to configure a camera or antenna mount''')
enums['MAV_CMD'][204].param[1] = '''Mount operation mode'''
enums['MAV_CMD'][204].param[2] = '''stabilize roll? (1 = yes, 0 = no)'''
enums['MAV_CMD'][204].param[3] = '''stabilize pitch? (1 = yes, 0 = no)'''
enums['MAV_CMD'][204].param[4] = '''stabilize yaw? (1 = yes, 0 = no)'''
enums['MAV_CMD'][204].param[5] = '''Empty'''
enums['MAV_CMD'][204].param[6] = '''Empty'''
enums['MAV_CMD'][204].param[7] = '''Empty'''
MAV_CMD_DO_MOUNT_CONTROL = 205 # Mission command to control a camera or antenna mount
enums['MAV_CMD'][205] = EnumEntry('MAV_CMD_DO_MOUNT_CONTROL', '''Mission command to control a camera or antenna mount''')
enums['MAV_CMD'][205].param[1] = '''pitch (WIP: DEPRECATED: or lat in degrees) depending on mount mode.'''
enums['MAV_CMD'][205].param[2] = '''roll (WIP: DEPRECATED: or lon in degrees) depending on mount mode.'''
enums['MAV_CMD'][205].param[3] = '''yaw (WIP: DEPRECATED: or alt in meters) depending on mount mode.'''
enums['MAV_CMD'][205].param[4] = '''WIP: alt in meters depending on mount mode.'''
enums['MAV_CMD'][205].param[5] = '''WIP: latitude in degrees * 1E7, set if appropriate mount mode.'''
enums['MAV_CMD'][205].param[6] = '''WIP: longitude in degrees * 1E7, set if appropriate mount mode.'''
enums['MAV_CMD'][205].param[7] = '''Mount mode.'''
MAV_CMD_DO_SET_CAM_TRIGG_DIST = 206 # Mission command to set camera trigger distance for this flight. The
                        # camera is triggered each time this distance
                        # is exceeded. This command can also be used
                        # to set the shutter integration time for the
                        # camera.
enums['MAV_CMD'][206] = EnumEntry('MAV_CMD_DO_SET_CAM_TRIGG_DIST', '''Mission command to set camera trigger distance for this flight. The camera is triggered each time this distance is exceeded. This command can also be used to set the shutter integration time for the camera.''')
enums['MAV_CMD'][206].param[1] = '''Camera trigger distance. 0 to stop triggering.'''
enums['MAV_CMD'][206].param[2] = '''Camera shutter integration time. -1 or 0 to ignore'''
enums['MAV_CMD'][206].param[3] = '''Trigger camera once immediately. (0 = no trigger, 1 = trigger)'''
enums['MAV_CMD'][206].param[4] = '''Empty'''
enums['MAV_CMD'][206].param[5] = '''Empty'''
enums['MAV_CMD'][206].param[6] = '''Empty'''
enums['MAV_CMD'][206].param[7] = '''Empty'''
MAV_CMD_DO_FENCE_ENABLE = 207 # Mission command to enable the geofence
enums['MAV_CMD'][207] = EnumEntry('MAV_CMD_DO_FENCE_ENABLE', '''Mission command to enable the geofence''')
enums['MAV_CMD'][207].param[1] = '''enable? (0=disable, 1=enable, 2=disable_floor_only)'''
enums['MAV_CMD'][207].param[2] = '''Empty'''
enums['MAV_CMD'][207].param[3] = '''Empty'''
enums['MAV_CMD'][207].param[4] = '''Empty'''
enums['MAV_CMD'][207].param[5] = '''Empty'''
enums['MAV_CMD'][207].param[6] = '''Empty'''
enums['MAV_CMD'][207].param[7] = '''Empty'''
MAV_CMD_DO_PARACHUTE = 208 # Mission item/command to release a parachute or enable/disable auto
                        # release.
enums['MAV_CMD'][208] = EnumEntry('MAV_CMD_DO_PARACHUTE', '''Mission item/command to release a parachute or enable/disable auto release.''')
enums['MAV_CMD'][208].param[1] = '''Action'''
enums['MAV_CMD'][208].param[2] = '''Empty'''
enums['MAV_CMD'][208].param[3] = '''Empty'''
enums['MAV_CMD'][208].param[4] = '''Empty'''
enums['MAV_CMD'][208].param[5] = '''Empty'''
enums['MAV_CMD'][208].param[6] = '''Empty'''
enums['MAV_CMD'][208].param[7] = '''Empty'''
MAV_CMD_DO_MOTOR_TEST = 209 # Mission command to perform motor test.
enums['MAV_CMD'][209] = EnumEntry('MAV_CMD_DO_MOTOR_TEST', '''Mission command to perform motor test.''')
enums['MAV_CMD'][209].param[1] = '''Motor instance number. (from 1 to max number of motors on the vehicle)'''
enums['MAV_CMD'][209].param[2] = '''Throttle type.'''
enums['MAV_CMD'][209].param[3] = '''Throttle.'''
enums['MAV_CMD'][209].param[4] = '''Timeout.'''
enums['MAV_CMD'][209].param[5] = '''Motor count. (number of motors to test to test in sequence, waiting for the timeout above between them; 0=1 motor, 1=1 motor, 2=2 motors...)'''
enums['MAV_CMD'][209].param[6] = '''Motor test order.'''
enums['MAV_CMD'][209].param[7] = '''Empty'''
MAV_CMD_DO_INVERTED_FLIGHT = 210 # Change to/from inverted flight.
enums['MAV_CMD'][210] = EnumEntry('MAV_CMD_DO_INVERTED_FLIGHT', '''Change to/from inverted flight.''')
enums['MAV_CMD'][210].param[1] = '''Inverted flight. (0=normal, 1=inverted)'''
enums['MAV_CMD'][210].param[2] = '''Empty'''
enums['MAV_CMD'][210].param[3] = '''Empty'''
enums['MAV_CMD'][210].param[4] = '''Empty'''
enums['MAV_CMD'][210].param[5] = '''Empty'''
enums['MAV_CMD'][210].param[6] = '''Empty'''
enums['MAV_CMD'][210].param[7] = '''Empty'''
MAV_CMD_DO_GRIPPER = 211 # Mission command to operate a gripper.
enums['MAV_CMD'][211] = EnumEntry('MAV_CMD_DO_GRIPPER', '''Mission command to operate a gripper.''')
enums['MAV_CMD'][211].param[1] = '''Gripper instance number.'''
enums['MAV_CMD'][211].param[2] = '''Gripper action to perform.'''
enums['MAV_CMD'][211].param[3] = '''Empty'''
enums['MAV_CMD'][211].param[4] = '''Empty'''
enums['MAV_CMD'][211].param[5] = '''Empty'''
enums['MAV_CMD'][211].param[6] = '''Empty'''
enums['MAV_CMD'][211].param[7] = '''Empty'''
MAV_CMD_DO_AUTOTUNE_ENABLE = 212 # Enable/disable autotune.
enums['MAV_CMD'][212] = EnumEntry('MAV_CMD_DO_AUTOTUNE_ENABLE', '''Enable/disable autotune.''')
enums['MAV_CMD'][212].param[1] = '''Enable (1: enable, 0:disable).'''
enums['MAV_CMD'][212].param[2] = '''Empty.'''
enums['MAV_CMD'][212].param[3] = '''Empty.'''
enums['MAV_CMD'][212].param[4] = '''Empty.'''
enums['MAV_CMD'][212].param[5] = '''Empty.'''
enums['MAV_CMD'][212].param[6] = '''Empty.'''
enums['MAV_CMD'][212].param[7] = '''Empty.'''
MAV_CMD_NAV_SET_YAW_SPEED = 213 # Sets a desired vehicle turn angle and speed change.
enums['MAV_CMD'][213] = EnumEntry('MAV_CMD_NAV_SET_YAW_SPEED', '''Sets a desired vehicle turn angle and speed change.''')
enums['MAV_CMD'][213].param[1] = '''Yaw angle to adjust steering by.'''
enums['MAV_CMD'][213].param[2] = '''Speed.'''
enums['MAV_CMD'][213].param[3] = '''Final angle. (0=absolute, 1=relative)'''
enums['MAV_CMD'][213].param[4] = '''Empty'''
enums['MAV_CMD'][213].param[5] = '''Empty'''
enums['MAV_CMD'][213].param[6] = '''Empty'''
enums['MAV_CMD'][213].param[7] = '''Empty'''
MAV_CMD_DO_SET_CAM_TRIGG_INTERVAL = 214 # Mission command to set camera trigger interval for this flight. If
                        # triggering is enabled, the camera is
                        # triggered each time this interval expires.
                        # This command can also be used to set the
                        # shutter integration time for the camera.
enums['MAV_CMD'][214] = EnumEntry('MAV_CMD_DO_SET_CAM_TRIGG_INTERVAL', '''Mission command to set camera trigger interval for this flight. If triggering is enabled, the camera is triggered each time this interval expires. This command can also be used to set the shutter integration time for the camera.''')
enums['MAV_CMD'][214].param[1] = '''Camera trigger cycle time. -1 or 0 to ignore.'''
enums['MAV_CMD'][214].param[2] = '''Camera shutter integration time. Should be less than trigger cycle time. -1 or 0 to ignore.'''
enums['MAV_CMD'][214].param[3] = '''Empty'''
enums['MAV_CMD'][214].param[4] = '''Empty'''
enums['MAV_CMD'][214].param[5] = '''Empty'''
enums['MAV_CMD'][214].param[6] = '''Empty'''
enums['MAV_CMD'][214].param[7] = '''Empty'''
MAV_CMD_DO_SET_RESUME_REPEAT_DIST = 215 # Set the distance to be repeated on mission resume
enums['MAV_CMD'][215] = EnumEntry('MAV_CMD_DO_SET_RESUME_REPEAT_DIST', '''Set the distance to be repeated on mission resume''')
enums['MAV_CMD'][215].param[1] = '''Distance.'''
enums['MAV_CMD'][215].param[2] = '''Empty.'''
enums['MAV_CMD'][215].param[3] = '''Empty.'''
enums['MAV_CMD'][215].param[4] = '''Empty.'''
enums['MAV_CMD'][215].param[5] = '''Empty.'''
enums['MAV_CMD'][215].param[6] = '''Empty.'''
enums['MAV_CMD'][215].param[7] = '''Empty.'''
MAV_CMD_DO_SPRAYER = 216 # Control attached liquid sprayer
enums['MAV_CMD'][216] = EnumEntry('MAV_CMD_DO_SPRAYER', '''Control attached liquid sprayer''')
enums['MAV_CMD'][216].param[1] = '''0: disable sprayer. 1: enable sprayer.'''
enums['MAV_CMD'][216].param[2] = '''Empty.'''
enums['MAV_CMD'][216].param[3] = '''Empty.'''
enums['MAV_CMD'][216].param[4] = '''Empty.'''
enums['MAV_CMD'][216].param[5] = '''Empty.'''
enums['MAV_CMD'][216].param[6] = '''Empty.'''
enums['MAV_CMD'][216].param[7] = '''Empty.'''
MAV_CMD_DO_SEND_SCRIPT_MESSAGE = 217 # Pass instructions onto scripting, a script should be checking for a
                        # new command
enums['MAV_CMD'][217] = EnumEntry('MAV_CMD_DO_SEND_SCRIPT_MESSAGE', '''Pass instructions onto scripting, a script should be checking for a new command''')
enums['MAV_CMD'][217].param[1] = '''uint16 ID value to be passed to scripting'''
enums['MAV_CMD'][217].param[2] = '''float value to be passed to scripting'''
enums['MAV_CMD'][217].param[3] = '''float value to be passed to scripting'''
enums['MAV_CMD'][217].param[4] = '''float value to be passed to scripting'''
enums['MAV_CMD'][217].param[5] = '''Empty.'''
enums['MAV_CMD'][217].param[6] = '''Empty.'''
enums['MAV_CMD'][217].param[7] = '''Empty.'''
MAV_CMD_DO_AUX_FUNCTION = 218 # Execute auxiliary function
enums['MAV_CMD'][218] = EnumEntry('MAV_CMD_DO_AUX_FUNCTION', '''Execute auxiliary function''')
enums['MAV_CMD'][218].param[1] = '''Auxiliary Function.'''
enums['MAV_CMD'][218].param[2] = '''Switch Level.'''
enums['MAV_CMD'][218].param[3] = '''Empty.'''
enums['MAV_CMD'][218].param[4] = '''Empty.'''
enums['MAV_CMD'][218].param[5] = '''Empty.'''
enums['MAV_CMD'][218].param[6] = '''Empty.'''
enums['MAV_CMD'][218].param[7] = '''Empty.'''
MAV_CMD_DO_MOUNT_CONTROL_QUAT = 220 # Mission command to control a camera or antenna mount, using a
                        # quaternion as reference.
enums['MAV_CMD'][220] = EnumEntry('MAV_CMD_DO_MOUNT_CONTROL_QUAT', '''Mission command to control a camera or antenna mount, using a quaternion as reference.''')
enums['MAV_CMD'][220].param[1] = '''quaternion param q1, w (1 in null-rotation)'''
enums['MAV_CMD'][220].param[2] = '''quaternion param q2, x (0 in null-rotation)'''
enums['MAV_CMD'][220].param[3] = '''quaternion param q3, y (0 in null-rotation)'''
enums['MAV_CMD'][220].param[4] = '''quaternion param q4, z (0 in null-rotation)'''
enums['MAV_CMD'][220].param[5] = '''Empty'''
enums['MAV_CMD'][220].param[6] = '''Empty'''
enums['MAV_CMD'][220].param[7] = '''Empty'''
MAV_CMD_DO_GUIDED_MASTER = 221 # set id of master controller
enums['MAV_CMD'][221] = EnumEntry('MAV_CMD_DO_GUIDED_MASTER', '''set id of master controller''')
enums['MAV_CMD'][221].param[1] = '''System ID'''
enums['MAV_CMD'][221].param[2] = '''Component ID'''
enums['MAV_CMD'][221].param[3] = '''Empty'''
enums['MAV_CMD'][221].param[4] = '''Empty'''
enums['MAV_CMD'][221].param[5] = '''Empty'''
enums['MAV_CMD'][221].param[6] = '''Empty'''
enums['MAV_CMD'][221].param[7] = '''Empty'''
MAV_CMD_DO_GUIDED_LIMITS = 222 # Set limits for external control
enums['MAV_CMD'][222] = EnumEntry('MAV_CMD_DO_GUIDED_LIMITS', '''Set limits for external control''')
enums['MAV_CMD'][222].param[1] = '''Timeout - maximum time that external controller will be allowed to control vehicle. 0 means no timeout.'''
enums['MAV_CMD'][222].param[2] = '''Altitude (MSL) min - if vehicle moves below this alt, the command will be aborted and the mission will continue. 0 means no lower altitude limit.'''
enums['MAV_CMD'][222].param[3] = '''Altitude (MSL) max - if vehicle moves above this alt, the command will be aborted and the mission will continue. 0 means no upper altitude limit.'''
enums['MAV_CMD'][222].param[4] = '''Horizontal move limit - if vehicle moves more than this distance from its location at the moment the command was executed, the command will be aborted and the mission will continue. 0 means no horizontal move limit.'''
enums['MAV_CMD'][222].param[5] = '''Empty'''
enums['MAV_CMD'][222].param[6] = '''Empty'''
enums['MAV_CMD'][222].param[7] = '''Empty'''
MAV_CMD_DO_ENGINE_CONTROL = 223 # Control vehicle engine. This is interpreted by the vehicles engine
                        # controller to change the target engine
                        # state. It is intended for vehicles with
                        # internal combustion engines
enums['MAV_CMD'][223] = EnumEntry('MAV_CMD_DO_ENGINE_CONTROL', '''Control vehicle engine. This is interpreted by the vehicles engine controller to change the target engine state. It is intended for vehicles with internal combustion engines''')
enums['MAV_CMD'][223].param[1] = '''0: Stop engine, 1:Start Engine'''
enums['MAV_CMD'][223].param[2] = '''0: Warm start, 1:Cold start. Controls use of choke where applicable'''
enums['MAV_CMD'][223].param[3] = '''Height delay. This is for commanding engine start only after the vehicle has gained the specified height. Used in VTOL vehicles during takeoff to start engine after the aircraft is off the ground. Zero for no delay.'''
enums['MAV_CMD'][223].param[4] = '''Empty'''
enums['MAV_CMD'][223].param[5] = '''Empty'''
enums['MAV_CMD'][223].param[6] = '''Empty'''
enums['MAV_CMD'][223].param[7] = '''Empty'''
MAV_CMD_DO_SET_MISSION_CURRENT = 224 # Set the mission item with sequence number seq as current item. This
                        # means that the MAV will continue to this
                        # mission item on the shortest path (not
                        # following the mission items in-between).
enums['MAV_CMD'][224] = EnumEntry('MAV_CMD_DO_SET_MISSION_CURRENT', '''Set the mission item with sequence number seq as current item. This means that the MAV will continue to this mission item on the shortest path (not following the mission items in-between).''')
enums['MAV_CMD'][224].param[1] = '''Mission sequence value to set'''
enums['MAV_CMD'][224].param[2] = '''Empty'''
enums['MAV_CMD'][224].param[3] = '''Empty'''
enums['MAV_CMD'][224].param[4] = '''Empty'''
enums['MAV_CMD'][224].param[5] = '''Empty'''
enums['MAV_CMD'][224].param[6] = '''Empty'''
enums['MAV_CMD'][224].param[7] = '''Empty'''
MAV_CMD_DO_LAST = 240 # NOP - This command is only used to mark the upper limit of the DO
                        # commands in the enumeration
enums['MAV_CMD'][240] = EnumEntry('MAV_CMD_DO_LAST', '''NOP - This command is only used to mark the upper limit of the DO commands in the enumeration''')
enums['MAV_CMD'][240].param[1] = '''Empty'''
enums['MAV_CMD'][240].param[2] = '''Empty'''
enums['MAV_CMD'][240].param[3] = '''Empty'''
enums['MAV_CMD'][240].param[4] = '''Empty'''
enums['MAV_CMD'][240].param[5] = '''Empty'''
enums['MAV_CMD'][240].param[6] = '''Empty'''
enums['MAV_CMD'][240].param[7] = '''Empty'''
MAV_CMD_PREFLIGHT_CALIBRATION = 241 # Trigger calibration. This command will be only accepted if in pre-
                        # flight mode. Except for Temperature
                        # Calibration, only one sensor should be set
                        # in a single message and all others should be
                        # zero.
enums['MAV_CMD'][241] = EnumEntry('MAV_CMD_PREFLIGHT_CALIBRATION', '''Trigger calibration. This command will be only accepted if in pre-flight mode. Except for Temperature Calibration, only one sensor should be set in a single message and all others should be zero.''')
enums['MAV_CMD'][241].param[1] = '''1: gyro calibration, 3: gyro temperature calibration'''
enums['MAV_CMD'][241].param[2] = '''1: magnetometer calibration'''
enums['MAV_CMD'][241].param[3] = '''1: ground pressure calibration'''
enums['MAV_CMD'][241].param[4] = '''1: radio RC calibration, 2: RC trim calibration'''
enums['MAV_CMD'][241].param[5] = '''1: accelerometer calibration, 2: board level calibration, 3: accelerometer temperature calibration, 4: simple accelerometer calibration'''
enums['MAV_CMD'][241].param[6] = '''1: APM: compass/motor interference calibration (PX4: airspeed calibration, deprecated), 2: airspeed calibration'''
enums['MAV_CMD'][241].param[7] = '''1: ESC calibration, 3: barometer temperature calibration'''
MAV_CMD_PREFLIGHT_SET_SENSOR_OFFSETS = 242 # Set sensor offsets. This command will be only accepted if in pre-
                        # flight mode.
enums['MAV_CMD'][242] = EnumEntry('MAV_CMD_PREFLIGHT_SET_SENSOR_OFFSETS', '''Set sensor offsets. This command will be only accepted if in pre-flight mode.''')
enums['MAV_CMD'][242].param[1] = '''Sensor to adjust the offsets for: 0: gyros, 1: accelerometer, 2: magnetometer, 3: barometer, 4: optical flow, 5: second magnetometer, 6: third magnetometer'''
enums['MAV_CMD'][242].param[2] = '''X axis offset (or generic dimension 1), in the sensor's raw units'''
enums['MAV_CMD'][242].param[3] = '''Y axis offset (or generic dimension 2), in the sensor's raw units'''
enums['MAV_CMD'][242].param[4] = '''Z axis offset (or generic dimension 3), in the sensor's raw units'''
enums['MAV_CMD'][242].param[5] = '''Generic dimension 4, in the sensor's raw units'''
enums['MAV_CMD'][242].param[6] = '''Generic dimension 5, in the sensor's raw units'''
enums['MAV_CMD'][242].param[7] = '''Generic dimension 6, in the sensor's raw units'''
MAV_CMD_PREFLIGHT_UAVCAN = 243 # Trigger UAVCAN configuration (actuator ID assignment and direction
                        # mapping). Note that this maps to the legacy
                        # UAVCAN v0 function UAVCAN_ENUMERATE, which
                        # is intended to be executed just once during
                        # initial vehicle configuration (it is not a
                        # normal pre-flight command and has been
                        # poorly named).
enums['MAV_CMD'][243] = EnumEntry('MAV_CMD_PREFLIGHT_UAVCAN', '''Trigger UAVCAN configuration (actuator ID assignment and direction mapping). Note that this maps to the legacy UAVCAN v0 function UAVCAN_ENUMERATE, which is intended to be executed just once during initial vehicle configuration (it is not a normal pre-flight command and has been poorly named).''')
enums['MAV_CMD'][243].param[1] = '''1: Trigger actuator ID assignment and direction mapping. 0: Cancel command.'''
enums['MAV_CMD'][243].param[2] = '''Reserved'''
enums['MAV_CMD'][243].param[3] = '''Reserved'''
enums['MAV_CMD'][243].param[4] = '''Reserved'''
enums['MAV_CMD'][243].param[5] = '''Reserved'''
enums['MAV_CMD'][243].param[6] = '''Reserved'''
enums['MAV_CMD'][243].param[7] = '''Reserved'''
MAV_CMD_PREFLIGHT_STORAGE = 245 # Request storage of different parameter values and logs. This command
                        # will be only accepted if in pre-flight mode.
enums['MAV_CMD'][245] = EnumEntry('MAV_CMD_PREFLIGHT_STORAGE', '''Request storage of different parameter values and logs. This command will be only accepted if in pre-flight mode.''')
enums['MAV_CMD'][245].param[1] = '''Parameter storage: 0: READ FROM FLASH/EEPROM, 1: WRITE CURRENT TO FLASH/EEPROM, 2: Reset to defaults'''
enums['MAV_CMD'][245].param[2] = '''Mission storage: 0: READ FROM FLASH/EEPROM, 1: WRITE CURRENT TO FLASH/EEPROM, 2: Reset to defaults'''
enums['MAV_CMD'][245].param[3] = '''Onboard logging: 0: Ignore, 1: Start default rate logging, -1: Stop logging, > 1: logging rate (e.g. set to 1000 for 1000 Hz logging)'''
enums['MAV_CMD'][245].param[4] = '''Reserved'''
enums['MAV_CMD'][245].param[5] = '''Empty'''
enums['MAV_CMD'][245].param[6] = '''Empty'''
enums['MAV_CMD'][245].param[7] = '''Empty'''
MAV_CMD_PREFLIGHT_REBOOT_SHUTDOWN = 246 # Request the reboot or shutdown of system components.
enums['MAV_CMD'][246] = EnumEntry('MAV_CMD_PREFLIGHT_REBOOT_SHUTDOWN', '''Request the reboot or shutdown of system components.''')
enums['MAV_CMD'][246].param[1] = '''0: Do nothing for autopilot, 1: Reboot autopilot, 2: Shutdown autopilot, 3: Reboot autopilot and keep it in the bootloader until upgraded.'''
enums['MAV_CMD'][246].param[2] = '''0: Do nothing for onboard computer, 1: Reboot onboard computer, 2: Shutdown onboard computer, 3: Reboot onboard computer and keep it in the bootloader until upgraded.'''
enums['MAV_CMD'][246].param[3] = '''WIP: 0: Do nothing for camera, 1: Reboot onboard camera, 2: Shutdown onboard camera, 3: Reboot onboard camera and keep it in the bootloader until upgraded'''
enums['MAV_CMD'][246].param[4] = '''WIP: 0: Do nothing for mount (e.g. gimbal), 1: Reboot mount, 2: Shutdown mount, 3: Reboot mount and keep it in the bootloader until upgraded'''
enums['MAV_CMD'][246].param[5] = '''Reserved (set to 0)'''
enums['MAV_CMD'][246].param[6] = '''Reserved (set to 0)'''
enums['MAV_CMD'][246].param[7] = '''WIP: ID (e.g. camera ID -1 for all IDs)'''
MAV_CMD_OVERRIDE_GOTO = 252 # Override current mission with command to pause mission, pause mission
                        # and move to position, continue/resume
                        # mission. When param 1 indicates that the
                        # mission is paused (MAV_GOTO_DO_HOLD), param
                        # 2 defines whether it holds in place or moves
                        # to another position.
enums['MAV_CMD'][252] = EnumEntry('MAV_CMD_OVERRIDE_GOTO', '''Override current mission with command to pause mission, pause mission and move to position, continue/resume mission. When param 1 indicates that the mission is paused (MAV_GOTO_DO_HOLD), param 2 defines whether it holds in place or moves to another position.''')
enums['MAV_CMD'][252].param[1] = '''MAV_GOTO_DO_HOLD: pause mission and either hold or move to specified position (depending on param2), MAV_GOTO_DO_CONTINUE: resume mission.'''
enums['MAV_CMD'][252].param[2] = '''MAV_GOTO_HOLD_AT_CURRENT_POSITION: hold at current position, MAV_GOTO_HOLD_AT_SPECIFIED_POSITION: hold at specified position.'''
enums['MAV_CMD'][252].param[3] = '''Coordinate frame of hold point.'''
enums['MAV_CMD'][252].param[4] = '''Desired yaw angle.'''
enums['MAV_CMD'][252].param[5] = '''Latitude/X position.'''
enums['MAV_CMD'][252].param[6] = '''Longitude/Y position.'''
enums['MAV_CMD'][252].param[7] = '''Altitude/Z position.'''
MAV_CMD_OBLIQUE_SURVEY = 260 # Mission command to set a Camera Auto Mount Pivoting Oblique Survey
                        # (Replaces CAM_TRIGG_DIST for this purpose).
                        # The camera is triggered each time this
                        # distance is exceeded, then the mount moves
                        # to the next position. Params 4~6 set-up the
                        # angle limits and number of positions for
                        # oblique survey, where mount-enabled vehicles
                        # automatically roll the camera between shots
                        # to emulate an oblique camera setup
                        # (providing an increased HFOV). This command
                        # can also be used to set the shutter
                        # integration time for the camera.
enums['MAV_CMD'][260] = EnumEntry('MAV_CMD_OBLIQUE_SURVEY', '''Mission command to set a Camera Auto Mount Pivoting Oblique Survey (Replaces CAM_TRIGG_DIST for this purpose). The camera is triggered each time this distance is exceeded, then the mount moves to the next position. Params 4~6 set-up the angle limits and number of positions for oblique survey, where mount-enabled vehicles automatically roll the camera between shots to emulate an oblique camera setup (providing an increased HFOV). This command can also be used to set the shutter integration time for the camera.''')
enums['MAV_CMD'][260].param[1] = '''Camera trigger distance. 0 to stop triggering.'''
enums['MAV_CMD'][260].param[2] = '''Camera shutter integration time. 0 to ignore'''
enums['MAV_CMD'][260].param[3] = '''The minimum interval in which the camera is capable of taking subsequent pictures repeatedly. 0 to ignore.'''
enums['MAV_CMD'][260].param[4] = '''Total number of roll positions at which the camera will capture photos (images captures spread evenly across the limits defined by param5).'''
enums['MAV_CMD'][260].param[5] = '''Angle limits that the camera can be rolled to left and right of center.'''
enums['MAV_CMD'][260].param[6] = '''Fixed pitch angle that the camera will hold in oblique mode if the mount is actuated in the pitch axis.'''
enums['MAV_CMD'][260].param[7] = '''Empty'''
MAV_CMD_MISSION_START = 300 # start running a mission
enums['MAV_CMD'][300] = EnumEntry('MAV_CMD_MISSION_START', '''start running a mission''')
enums['MAV_CMD'][300].param[1] = '''first_item: the first mission item to run'''
enums['MAV_CMD'][300].param[2] = '''last_item:  the last mission item to run (after this item is run, the mission ends)'''
enums['MAV_CMD'][300].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][300].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][300].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][300].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][300].param[7] = '''Reserved (default:0)'''
MAV_CMD_COMPONENT_ARM_DISARM = 400 # Arms / Disarms a component
enums['MAV_CMD'][400] = EnumEntry('MAV_CMD_COMPONENT_ARM_DISARM', '''Arms / Disarms a component''')
enums['MAV_CMD'][400].param[1] = '''0: disarm, 1: arm'''
enums['MAV_CMD'][400].param[2] = '''0: arm-disarm unless prevented by safety checks (i.e. when landed), 21196: force arming/disarming (e.g. allow arming to override preflight checks and disarming in flight)'''
enums['MAV_CMD'][400].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][400].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][400].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][400].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][400].param[7] = '''Reserved (default:0)'''
MAV_CMD_RUN_PREARM_CHECKS = 401 # Instructs system to run pre-arm checks.  This command should return
                        # MAV_RESULT_TEMPORARILY_REJECTED in the case
                        # the system is armed, otherwse
                        # MAV_RESULT_ACCEPTED.  Note that the return
                        # value from executing this command does not
                        # indicate whether the vehicle is armable or
                        # not, just whether the system has
                        # successfully run/is currently running the
                        # checks.  The result of the checks is
                        # reflected in the SYS_STATUS message.
enums['MAV_CMD'][401] = EnumEntry('MAV_CMD_RUN_PREARM_CHECKS', '''Instructs system to run pre-arm checks.  This command should return MAV_RESULT_TEMPORARILY_REJECTED in the case the system is armed, otherwse MAV_RESULT_ACCEPTED.  Note that the return value from executing this command does not indicate whether the vehicle is armable or not, just whether the system has successfully run/is currently running the checks.  The result of the checks is reflected in the SYS_STATUS message.''')
enums['MAV_CMD'][401].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD'][401].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][401].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][401].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][401].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][401].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][401].param[7] = '''Reserved (default:0)'''
MAV_CMD_GET_HOME_POSITION = 410 # Request the home position from the vehicle.
enums['MAV_CMD'][410] = EnumEntry('MAV_CMD_GET_HOME_POSITION', '''Request the home position from the vehicle.''')
enums['MAV_CMD'][410].param[1] = '''Reserved'''
enums['MAV_CMD'][410].param[2] = '''Reserved'''
enums['MAV_CMD'][410].param[3] = '''Reserved'''
enums['MAV_CMD'][410].param[4] = '''Reserved'''
enums['MAV_CMD'][410].param[5] = '''Reserved'''
enums['MAV_CMD'][410].param[6] = '''Reserved'''
enums['MAV_CMD'][410].param[7] = '''Reserved'''
MAV_CMD_START_RX_PAIR = 500 # Starts receiver pairing.
enums['MAV_CMD'][500] = EnumEntry('MAV_CMD_START_RX_PAIR', '''Starts receiver pairing.''')
enums['MAV_CMD'][500].param[1] = '''0:Spektrum.'''
enums['MAV_CMD'][500].param[2] = '''RC type.'''
enums['MAV_CMD'][500].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][500].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][500].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][500].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][500].param[7] = '''Reserved (default:0)'''
MAV_CMD_GET_MESSAGE_INTERVAL = 510 # Request the interval between messages for a particular MAVLink message
                        # ID. The receiver should ACK the command and
                        # then emit its response in a MESSAGE_INTERVAL
                        # message.
enums['MAV_CMD'][510] = EnumEntry('MAV_CMD_GET_MESSAGE_INTERVAL', '''Request the interval between messages for a particular MAVLink message ID. The receiver should ACK the command and then emit its response in a MESSAGE_INTERVAL message.''')
enums['MAV_CMD'][510].param[1] = '''The MAVLink message ID'''
enums['MAV_CMD'][510].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][510].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][510].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][510].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][510].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][510].param[7] = '''Reserved (default:0)'''
MAV_CMD_SET_MESSAGE_INTERVAL = 511 # Set the interval between messages for a particular MAVLink message ID.
                        # This interface replaces REQUEST_DATA_STREAM.
enums['MAV_CMD'][511] = EnumEntry('MAV_CMD_SET_MESSAGE_INTERVAL', '''Set the interval between messages for a particular MAVLink message ID. This interface replaces REQUEST_DATA_STREAM.''')
enums['MAV_CMD'][511].param[1] = '''The MAVLink message ID'''
enums['MAV_CMD'][511].param[2] = '''The interval between two messages. Set to -1 to disable and 0 to request default rate.'''
enums['MAV_CMD'][511].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][511].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][511].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][511].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][511].param[7] = '''Target address of message stream (if message has target address fields). 0: Flight-stack default (recommended), 1: address of requestor, 2: broadcast.'''
MAV_CMD_REQUEST_MESSAGE = 512 # Request the target system(s) emit a single instance of a specified
                        # message (i.e. a "one-shot" version of
                        # MAV_CMD_SET_MESSAGE_INTERVAL).
enums['MAV_CMD'][512] = EnumEntry('MAV_CMD_REQUEST_MESSAGE', '''Request the target system(s) emit a single instance of a specified message (i.e. a "one-shot" version of MAV_CMD_SET_MESSAGE_INTERVAL).''')
enums['MAV_CMD'][512].param[1] = '''The MAVLink message ID of the requested message.'''
enums['MAV_CMD'][512].param[2] = '''Use for index ID, if required. Otherwise, the use of this parameter (if any) must be defined in the requested message. By default assumed not used (0).'''
enums['MAV_CMD'][512].param[3] = '''The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0).'''
enums['MAV_CMD'][512].param[4] = '''The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0).'''
enums['MAV_CMD'][512].param[5] = '''The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0).'''
enums['MAV_CMD'][512].param[6] = '''The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0).'''
enums['MAV_CMD'][512].param[7] = '''Target address for requested message (if message has target address fields). 0: Flight-stack default, 1: address of requestor, 2: broadcast.'''
MAV_CMD_REQUEST_PROTOCOL_VERSION = 519 # Request MAVLink protocol version compatibility. All receivers should
                        # ACK the command and then emit their
                        # capabilities in an PROTOCOL_VERSION message
enums['MAV_CMD'][519] = EnumEntry('MAV_CMD_REQUEST_PROTOCOL_VERSION', '''Request MAVLink protocol version compatibility. All receivers should ACK the command and then emit their capabilities in an PROTOCOL_VERSION message''')
enums['MAV_CMD'][519].param[1] = '''1: Request supported protocol versions by all nodes on the network'''
enums['MAV_CMD'][519].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][519].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_AUTOPILOT_CAPABILITIES = 520 # Request autopilot capabilities. The receiver should ACK the command
                        # and then emit its capabilities in an
                        # AUTOPILOT_VERSION message
enums['MAV_CMD'][520] = EnumEntry('MAV_CMD_REQUEST_AUTOPILOT_CAPABILITIES', '''Request autopilot capabilities. The receiver should ACK the command and then emit its capabilities in an AUTOPILOT_VERSION message''')
enums['MAV_CMD'][520].param[1] = '''1: Request autopilot version'''
enums['MAV_CMD'][520].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][520].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][520].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][520].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][520].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][520].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_CAMERA_INFORMATION = 521 # Request camera information (CAMERA_INFORMATION).
enums['MAV_CMD'][521] = EnumEntry('MAV_CMD_REQUEST_CAMERA_INFORMATION', '''Request camera information (CAMERA_INFORMATION).''')
enums['MAV_CMD'][521].param[1] = '''0: No action 1: Request camera capabilities'''
enums['MAV_CMD'][521].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][521].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][521].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][521].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][521].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][521].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_CAMERA_SETTINGS = 522 # Request camera settings (CAMERA_SETTINGS).
enums['MAV_CMD'][522] = EnumEntry('MAV_CMD_REQUEST_CAMERA_SETTINGS', '''Request camera settings (CAMERA_SETTINGS).''')
enums['MAV_CMD'][522].param[1] = '''0: No Action 1: Request camera settings'''
enums['MAV_CMD'][522].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][522].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][522].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][522].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][522].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][522].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_STORAGE_INFORMATION = 525 # Request storage information (STORAGE_INFORMATION). Use the command's
                        # target_component to target a specific
                        # component's storage.
enums['MAV_CMD'][525] = EnumEntry('MAV_CMD_REQUEST_STORAGE_INFORMATION', '''Request storage information (STORAGE_INFORMATION). Use the command's target_component to target a specific component's storage.''')
enums['MAV_CMD'][525].param[1] = '''Storage ID (0 for all, 1 for first, 2 for second, etc.)'''
enums['MAV_CMD'][525].param[2] = '''0: No Action 1: Request storage information'''
enums['MAV_CMD'][525].param[3] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][525].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][525].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][525].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][525].param[7] = '''Reserved (default:0)'''
MAV_CMD_STORAGE_FORMAT = 526 # Format a storage medium. Once format is complete, a
                        # STORAGE_INFORMATION message is sent. Use the
                        # command's target_component to target a
                        # specific component's storage.
enums['MAV_CMD'][526] = EnumEntry('MAV_CMD_STORAGE_FORMAT', '''Format a storage medium. Once format is complete, a STORAGE_INFORMATION message is sent. Use the command's target_component to target a specific component's storage.''')
enums['MAV_CMD'][526].param[1] = '''Storage ID (1 for first, 2 for second, etc.)'''
enums['MAV_CMD'][526].param[2] = '''0: No action 1: Format storage'''
enums['MAV_CMD'][526].param[3] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][526].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][526].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][526].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][526].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_CAMERA_CAPTURE_STATUS = 527 # Request camera capture status (CAMERA_CAPTURE_STATUS)
enums['MAV_CMD'][527] = EnumEntry('MAV_CMD_REQUEST_CAMERA_CAPTURE_STATUS', '''Request camera capture status (CAMERA_CAPTURE_STATUS)''')
enums['MAV_CMD'][527].param[1] = '''0: No Action 1: Request camera capture status'''
enums['MAV_CMD'][527].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][527].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][527].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][527].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][527].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][527].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_FLIGHT_INFORMATION = 528 # Request flight information (FLIGHT_INFORMATION)
enums['MAV_CMD'][528] = EnumEntry('MAV_CMD_REQUEST_FLIGHT_INFORMATION', '''Request flight information (FLIGHT_INFORMATION)''')
enums['MAV_CMD'][528].param[1] = '''1: Request flight information'''
enums['MAV_CMD'][528].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][528].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][528].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][528].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][528].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][528].param[7] = '''Reserved (default:0)'''
MAV_CMD_RESET_CAMERA_SETTINGS = 529 # Reset all camera settings to Factory Default
enums['MAV_CMD'][529] = EnumEntry('MAV_CMD_RESET_CAMERA_SETTINGS', '''Reset all camera settings to Factory Default''')
enums['MAV_CMD'][529].param[1] = '''0: No Action 1: Reset all settings'''
enums['MAV_CMD'][529].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][529].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][529].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][529].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][529].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][529].param[7] = '''Reserved (default:0)'''
MAV_CMD_SET_CAMERA_MODE = 530 # Set camera running mode. Use NaN for reserved values. GCS will send a
                        # MAV_CMD_REQUEST_VIDEO_STREAM_STATUS command
                        # after a mode change if the camera supports
                        # video streaming.
enums['MAV_CMD'][530] = EnumEntry('MAV_CMD_SET_CAMERA_MODE', '''Set camera running mode. Use NaN for reserved values. GCS will send a MAV_CMD_REQUEST_VIDEO_STREAM_STATUS command after a mode change if the camera supports video streaming.''')
enums['MAV_CMD'][530].param[1] = '''Reserved (Set to 0)'''
enums['MAV_CMD'][530].param[2] = '''Camera mode'''
enums['MAV_CMD'][530].param[3] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][530].param[4] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][530].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][530].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][530].param[7] = '''Reserved (default:NaN)'''
MAV_CMD_JUMP_TAG = 600 # Tagged jump target. Can be jumped to with MAV_CMD_DO_JUMP_TAG.
enums['MAV_CMD'][600] = EnumEntry('MAV_CMD_JUMP_TAG', '''Tagged jump target. Can be jumped to with MAV_CMD_DO_JUMP_TAG.''')
enums['MAV_CMD'][600].param[1] = '''Tag.'''
enums['MAV_CMD'][600].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][600].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][600].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][600].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][600].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][600].param[7] = '''Reserved (default:0)'''
MAV_CMD_DO_JUMP_TAG = 601 # Jump to the matching tag in the mission list. Repeat this action for
                        # the specified number of times. A mission
                        # should contain a single matching tag for
                        # each jump. If this is not the case then a
                        # jump to a missing tag should complete the
                        # mission, and a jump where there are multiple
                        # matching tags should always select the one
                        # with the lowest mission sequence number.
enums['MAV_CMD'][601] = EnumEntry('MAV_CMD_DO_JUMP_TAG', '''Jump to the matching tag in the mission list. Repeat this action for the specified number of times. A mission should contain a single matching tag for each jump. If this is not the case then a jump to a missing tag should complete the mission, and a jump where there are multiple matching tags should always select the one with the lowest mission sequence number.''')
enums['MAV_CMD'][601].param[1] = '''Target tag to jump to.'''
enums['MAV_CMD'][601].param[2] = '''Repeat count.'''
enums['MAV_CMD'][601].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][601].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][601].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][601].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][601].param[7] = '''Reserved (default:0)'''
MAV_CMD_IMAGE_START_CAPTURE = 2000 # Start image capture sequence. Sends CAMERA_IMAGE_CAPTURED after each
                        # capture. Use NaN for reserved values.
enums['MAV_CMD'][2000] = EnumEntry('MAV_CMD_IMAGE_START_CAPTURE', '''Start image capture sequence. Sends CAMERA_IMAGE_CAPTURED after each capture. Use NaN for reserved values.''')
enums['MAV_CMD'][2000].param[1] = '''Reserved (Set to 0)'''
enums['MAV_CMD'][2000].param[2] = '''Desired elapsed time between two consecutive pictures (in seconds). Minimum values depend on hardware (typically greater than 2 seconds).'''
enums['MAV_CMD'][2000].param[3] = '''Total number of images to capture. 0 to capture forever/until MAV_CMD_IMAGE_STOP_CAPTURE.'''
enums['MAV_CMD'][2000].param[4] = '''Capture sequence number starting from 1. This is only valid for single-capture (param3 == 1), otherwise set to 0. Increment the capture ID for each capture command to prevent double captures when a command is re-transmitted.'''
enums['MAV_CMD'][2000].param[5] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2000].param[6] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2000].param[7] = '''Reserved (default:NaN)'''
MAV_CMD_IMAGE_STOP_CAPTURE = 2001 # Stop image capture sequence Use NaN for reserved values.
enums['MAV_CMD'][2001] = EnumEntry('MAV_CMD_IMAGE_STOP_CAPTURE', '''Stop image capture sequence Use NaN for reserved values.''')
enums['MAV_CMD'][2001].param[1] = '''Reserved (Set to 0)'''
enums['MAV_CMD'][2001].param[2] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2001].param[3] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2001].param[4] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2001].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][2001].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][2001].param[7] = '''Reserved (default:NaN)'''
MAV_CMD_DO_TRIGGER_CONTROL = 2003 # Enable or disable on-board camera triggering system.
enums['MAV_CMD'][2003] = EnumEntry('MAV_CMD_DO_TRIGGER_CONTROL', '''Enable or disable on-board camera triggering system.''')
enums['MAV_CMD'][2003].param[1] = '''Trigger enable/disable (0 for disable, 1 for start), -1 to ignore'''
enums['MAV_CMD'][2003].param[2] = '''1 to reset the trigger sequence, -1 or 0 to ignore'''
enums['MAV_CMD'][2003].param[3] = '''1 to pause triggering, but without switching the camera off or retracting it. -1 to ignore'''
enums['MAV_CMD'][2003].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][2003].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][2003].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][2003].param[7] = '''Reserved (default:0)'''
MAV_CMD_VIDEO_START_CAPTURE = 2500 # Starts video capture (recording).
enums['MAV_CMD'][2500] = EnumEntry('MAV_CMD_VIDEO_START_CAPTURE', '''Starts video capture (recording).''')
enums['MAV_CMD'][2500].param[1] = '''Video Stream ID (0 for all streams)'''
enums['MAV_CMD'][2500].param[2] = '''Frequency CAMERA_CAPTURE_STATUS messages should be sent while recording (0 for no messages, otherwise frequency)'''
enums['MAV_CMD'][2500].param[3] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2500].param[4] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2500].param[5] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2500].param[6] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2500].param[7] = '''Reserved (default:NaN)'''
MAV_CMD_VIDEO_STOP_CAPTURE = 2501 # Stop the current video capture (recording).
enums['MAV_CMD'][2501] = EnumEntry('MAV_CMD_VIDEO_STOP_CAPTURE', '''Stop the current video capture (recording).''')
enums['MAV_CMD'][2501].param[1] = '''Video Stream ID (0 for all streams)'''
enums['MAV_CMD'][2501].param[2] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2501].param[3] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2501].param[4] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2501].param[5] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2501].param[6] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2501].param[7] = '''Reserved (default:NaN)'''
MAV_CMD_VIDEO_START_STREAMING = 2502 # Start video streaming
enums['MAV_CMD'][2502] = EnumEntry('MAV_CMD_VIDEO_START_STREAMING', '''Start video streaming''')
enums['MAV_CMD'][2502].param[1] = '''Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)'''
enums['MAV_CMD'][2502].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][2502].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][2502].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][2502].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][2502].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][2502].param[7] = '''Reserved (default:0)'''
MAV_CMD_VIDEO_STOP_STREAMING = 2503 # Stop the given video stream
enums['MAV_CMD'][2503] = EnumEntry('MAV_CMD_VIDEO_STOP_STREAMING', '''Stop the given video stream''')
enums['MAV_CMD'][2503].param[1] = '''Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)'''
enums['MAV_CMD'][2503].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][2503].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][2503].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][2503].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][2503].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][2503].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_VIDEO_STREAM_INFORMATION = 2504 # Request video stream information (VIDEO_STREAM_INFORMATION)
enums['MAV_CMD'][2504] = EnumEntry('MAV_CMD_REQUEST_VIDEO_STREAM_INFORMATION', '''Request video stream information (VIDEO_STREAM_INFORMATION)''')
enums['MAV_CMD'][2504].param[1] = '''Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)'''
enums['MAV_CMD'][2504].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][2504].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][2504].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][2504].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][2504].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][2504].param[7] = '''Reserved (default:0)'''
MAV_CMD_REQUEST_VIDEO_STREAM_STATUS = 2505 # Request video stream status (VIDEO_STREAM_STATUS)
enums['MAV_CMD'][2505] = EnumEntry('MAV_CMD_REQUEST_VIDEO_STREAM_STATUS', '''Request video stream status (VIDEO_STREAM_STATUS)''')
enums['MAV_CMD'][2505].param[1] = '''Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)'''
enums['MAV_CMD'][2505].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][2505].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][2505].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][2505].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][2505].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][2505].param[7] = '''Reserved (default:0)'''
MAV_CMD_LOGGING_START = 2510 # Request to start streaming logging data over MAVLink (see also
                        # LOGGING_DATA message)
enums['MAV_CMD'][2510] = EnumEntry('MAV_CMD_LOGGING_START', '''Request to start streaming logging data over MAVLink (see also LOGGING_DATA message)''')
enums['MAV_CMD'][2510].param[1] = '''Format: 0: ULog'''
enums['MAV_CMD'][2510].param[2] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2510].param[3] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2510].param[4] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2510].param[5] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2510].param[6] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2510].param[7] = '''Reserved (set to 0)'''
MAV_CMD_LOGGING_STOP = 2511 # Request to stop streaming log data over MAVLink
enums['MAV_CMD'][2511] = EnumEntry('MAV_CMD_LOGGING_STOP', '''Request to stop streaming log data over MAVLink''')
enums['MAV_CMD'][2511].param[1] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2511].param[2] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2511].param[3] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2511].param[4] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2511].param[5] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2511].param[6] = '''Reserved (set to 0)'''
enums['MAV_CMD'][2511].param[7] = '''Reserved (set to 0)'''
MAV_CMD_AIRFRAME_CONFIGURATION = 2520 # 
enums['MAV_CMD'][2520] = EnumEntry('MAV_CMD_AIRFRAME_CONFIGURATION', '''''')
enums['MAV_CMD'][2520].param[1] = '''Landing gear ID (default: 0, -1 for all)'''
enums['MAV_CMD'][2520].param[2] = '''Landing gear position (Down: 0, Up: 1, NaN for no change)'''
enums['MAV_CMD'][2520].param[3] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2520].param[4] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2520].param[5] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2520].param[6] = '''Reserved (default:NaN)'''
enums['MAV_CMD'][2520].param[7] = '''Reserved (default:NaN)'''
MAV_CMD_CONTROL_HIGH_LATENCY = 2600 # Request to start/stop transmitting over the high latency telemetry
enums['MAV_CMD'][2600] = EnumEntry('MAV_CMD_CONTROL_HIGH_LATENCY', '''Request to start/stop transmitting over the high latency telemetry''')
enums['MAV_CMD'][2600].param[1] = '''Control transmission over high latency telemetry (0: stop, 1: start)'''
enums['MAV_CMD'][2600].param[2] = '''Empty'''
enums['MAV_CMD'][2600].param[3] = '''Empty'''
enums['MAV_CMD'][2600].param[4] = '''Empty'''
enums['MAV_CMD'][2600].param[5] = '''Empty'''
enums['MAV_CMD'][2600].param[6] = '''Empty'''
enums['MAV_CMD'][2600].param[7] = '''Empty'''
MAV_CMD_PANORAMA_CREATE = 2800 # Create a panorama at the current position
enums['MAV_CMD'][2800] = EnumEntry('MAV_CMD_PANORAMA_CREATE', '''Create a panorama at the current position''')
enums['MAV_CMD'][2800].param[1] = '''Viewing angle horizontal of the panorama (+- 0.5 the total angle)'''
enums['MAV_CMD'][2800].param[2] = '''Viewing angle vertical of panorama.'''
enums['MAV_CMD'][2800].param[3] = '''Speed of the horizontal rotation.'''
enums['MAV_CMD'][2800].param[4] = '''Speed of the vertical rotation.'''
enums['MAV_CMD'][2800].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][2800].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][2800].param[7] = '''Reserved (default:0)'''
MAV_CMD_DO_VTOL_TRANSITION = 3000 # Request VTOL transition
enums['MAV_CMD'][3000] = EnumEntry('MAV_CMD_DO_VTOL_TRANSITION', '''Request VTOL transition''')
enums['MAV_CMD'][3000].param[1] = '''The target VTOL state. Only MAV_VTOL_STATE_MC and MAV_VTOL_STATE_FW can be used.'''
enums['MAV_CMD'][3000].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][3000].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][3000].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][3000].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][3000].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][3000].param[7] = '''Reserved (default:0)'''
MAV_CMD_ARM_AUTHORIZATION_REQUEST = 3001 # Request authorization to arm the vehicle to a external entity, the arm
                        # authorizer is responsible to request all
                        # data that is needs from the vehicle before
                        # authorize or deny the request. If approved
                        # the progress of command_ack message should
                        # be set with period of time that this
                        # authorization is valid in seconds or in case
                        # it was denied it should be set with one of
                        # the reasons in ARM_AUTH_DENIED_REASON.
enums['MAV_CMD'][3001] = EnumEntry('MAV_CMD_ARM_AUTHORIZATION_REQUEST', '''Request authorization to arm the vehicle to a external entity, the arm authorizer is responsible to request all data that is needs from the vehicle before authorize or deny the request. If approved the progress of command_ack message should be set with period of time that this authorization is valid in seconds or in case it was denied it should be set with one of the reasons in ARM_AUTH_DENIED_REASON.
        ''')
enums['MAV_CMD'][3001].param[1] = '''Vehicle system id, this way ground station can request arm authorization on behalf of any vehicle'''
enums['MAV_CMD'][3001].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][3001].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][3001].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][3001].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][3001].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][3001].param[7] = '''Reserved (default:0)'''
MAV_CMD_SET_GUIDED_SUBMODE_STANDARD = 4000 # This command sets the submode to standard guided when vehicle is in
                        # guided mode. The vehicle holds position and
                        # altitude and the user can input the desired
                        # velocities along all three axes.
enums['MAV_CMD'][4000] = EnumEntry('MAV_CMD_SET_GUIDED_SUBMODE_STANDARD', '''This command sets the submode to standard guided when vehicle is in guided mode. The vehicle holds position and altitude and the user can input the desired velocities along all three axes.
                  ''')
enums['MAV_CMD'][4000].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD'][4000].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][4000].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][4000].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][4000].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][4000].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][4000].param[7] = '''Reserved (default:0)'''
MAV_CMD_SET_GUIDED_SUBMODE_CIRCLE = 4001 # This command sets submode circle when vehicle is in guided mode.
                        # Vehicle flies along a circle facing the
                        # center of the circle. The user can input the
                        # velocity along the circle and change the
                        # radius. If no input is given the vehicle
                        # will hold position.
enums['MAV_CMD'][4001] = EnumEntry('MAV_CMD_SET_GUIDED_SUBMODE_CIRCLE', '''This command sets submode circle when vehicle is in guided mode. Vehicle flies along a circle facing the center of the circle. The user can input the velocity along the circle and change the radius. If no input is given the vehicle will hold position.
                  ''')
enums['MAV_CMD'][4001].param[1] = '''Radius of desired circle in CIRCLE_MODE'''
enums['MAV_CMD'][4001].param[2] = '''User defined'''
enums['MAV_CMD'][4001].param[3] = '''User defined'''
enums['MAV_CMD'][4001].param[4] = '''User defined'''
enums['MAV_CMD'][4001].param[5] = '''Target latitude of center of circle in CIRCLE_MODE'''
enums['MAV_CMD'][4001].param[6] = '''Target longitude of center of circle in CIRCLE_MODE'''
enums['MAV_CMD'][4001].param[7] = '''Reserved (default:0)'''
MAV_CMD_NAV_FENCE_RETURN_POINT = 5000 # Fence return point (there can only be one such point in a geofence
                        # definition). If rally points are supported
                        # they should be used instead.
enums['MAV_CMD'][5000] = EnumEntry('MAV_CMD_NAV_FENCE_RETURN_POINT', '''Fence return point (there can only be one such point in a geofence definition). If rally points are supported they should be used instead.''')
enums['MAV_CMD'][5000].param[1] = '''Reserved'''
enums['MAV_CMD'][5000].param[2] = '''Reserved'''
enums['MAV_CMD'][5000].param[3] = '''Reserved'''
enums['MAV_CMD'][5000].param[4] = '''Reserved'''
enums['MAV_CMD'][5000].param[5] = '''Latitude'''
enums['MAV_CMD'][5000].param[6] = '''Longitude'''
enums['MAV_CMD'][5000].param[7] = '''Altitude'''
MAV_CMD_NAV_FENCE_POLYGON_VERTEX_INCLUSION = 5001 # Fence vertex for an inclusion polygon (the polygon must not be self-
                        # intersecting). The vehicle must stay within
                        # this area. Minimum of 3 vertices required.
enums['MAV_CMD'][5001] = EnumEntry('MAV_CMD_NAV_FENCE_POLYGON_VERTEX_INCLUSION', '''Fence vertex for an inclusion polygon (the polygon must not be self-intersecting). The vehicle must stay within this area. Minimum of 3 vertices required.
        ''')
enums['MAV_CMD'][5001].param[1] = '''Polygon vertex count'''
enums['MAV_CMD'][5001].param[2] = '''Vehicle must be inside ALL inclusion zones in a single group, vehicle must be inside at least one group, must be the same for all points in each polygon'''
enums['MAV_CMD'][5001].param[3] = '''Reserved'''
enums['MAV_CMD'][5001].param[4] = '''Reserved'''
enums['MAV_CMD'][5001].param[5] = '''Latitude'''
enums['MAV_CMD'][5001].param[6] = '''Longitude'''
enums['MAV_CMD'][5001].param[7] = '''Reserved'''
MAV_CMD_NAV_FENCE_POLYGON_VERTEX_EXCLUSION = 5002 # Fence vertex for an exclusion polygon (the polygon must not be self-
                        # intersecting). The vehicle must stay outside
                        # this area. Minimum of 3 vertices required.
enums['MAV_CMD'][5002] = EnumEntry('MAV_CMD_NAV_FENCE_POLYGON_VERTEX_EXCLUSION', '''Fence vertex for an exclusion polygon (the polygon must not be self-intersecting). The vehicle must stay outside this area. Minimum of 3 vertices required.
        ''')
enums['MAV_CMD'][5002].param[1] = '''Polygon vertex count'''
enums['MAV_CMD'][5002].param[2] = '''Reserved'''
enums['MAV_CMD'][5002].param[3] = '''Reserved'''
enums['MAV_CMD'][5002].param[4] = '''Reserved'''
enums['MAV_CMD'][5002].param[5] = '''Latitude'''
enums['MAV_CMD'][5002].param[6] = '''Longitude'''
enums['MAV_CMD'][5002].param[7] = '''Reserved'''
MAV_CMD_NAV_FENCE_CIRCLE_INCLUSION = 5003 # Circular fence area. The vehicle must stay inside this area.
enums['MAV_CMD'][5003] = EnumEntry('MAV_CMD_NAV_FENCE_CIRCLE_INCLUSION', '''Circular fence area. The vehicle must stay inside this area.
        ''')
enums['MAV_CMD'][5003].param[1] = '''Radius.'''
enums['MAV_CMD'][5003].param[2] = '''Vehicle must be inside ALL inclusion zones in a single group, vehicle must be inside at least one group'''
enums['MAV_CMD'][5003].param[3] = '''Reserved'''
enums['MAV_CMD'][5003].param[4] = '''Reserved'''
enums['MAV_CMD'][5003].param[5] = '''Latitude'''
enums['MAV_CMD'][5003].param[6] = '''Longitude'''
enums['MAV_CMD'][5003].param[7] = '''Reserved'''
MAV_CMD_NAV_FENCE_CIRCLE_EXCLUSION = 5004 # Circular fence area. The vehicle must stay outside this area.
enums['MAV_CMD'][5004] = EnumEntry('MAV_CMD_NAV_FENCE_CIRCLE_EXCLUSION', '''Circular fence area. The vehicle must stay outside this area.
        ''')
enums['MAV_CMD'][5004].param[1] = '''Radius.'''
enums['MAV_CMD'][5004].param[2] = '''Reserved'''
enums['MAV_CMD'][5004].param[3] = '''Reserved'''
enums['MAV_CMD'][5004].param[4] = '''Reserved'''
enums['MAV_CMD'][5004].param[5] = '''Latitude'''
enums['MAV_CMD'][5004].param[6] = '''Longitude'''
enums['MAV_CMD'][5004].param[7] = '''Reserved'''
MAV_CMD_NAV_RALLY_POINT = 5100 # Rally point. You can have multiple rally points defined.
enums['MAV_CMD'][5100] = EnumEntry('MAV_CMD_NAV_RALLY_POINT', '''Rally point. You can have multiple rally points defined.
        ''')
enums['MAV_CMD'][5100].param[1] = '''Reserved'''
enums['MAV_CMD'][5100].param[2] = '''Reserved'''
enums['MAV_CMD'][5100].param[3] = '''Reserved'''
enums['MAV_CMD'][5100].param[4] = '''Reserved'''
enums['MAV_CMD'][5100].param[5] = '''Latitude'''
enums['MAV_CMD'][5100].param[6] = '''Longitude'''
enums['MAV_CMD'][5100].param[7] = '''Altitude'''
MAV_CMD_UAVCAN_GET_NODE_INFO = 5200 # Commands the vehicle to respond with a sequence of messages
                        # UAVCAN_NODE_INFO, one message per every
                        # UAVCAN node that is online. Note that some
                        # of the response messages can be lost, which
                        # the receiver can detect easily by checking
                        # whether every received UAVCAN_NODE_STATUS
                        # has a matching message UAVCAN_NODE_INFO
                        # received earlier; if not, this command
                        # should be sent again in order to request re-
                        # transmission of the node information
                        # messages.
enums['MAV_CMD'][5200] = EnumEntry('MAV_CMD_UAVCAN_GET_NODE_INFO', '''Commands the vehicle to respond with a sequence of messages UAVCAN_NODE_INFO, one message per every UAVCAN node that is online. Note that some of the response messages can be lost, which the receiver can detect easily by checking whether every received UAVCAN_NODE_STATUS has a matching message UAVCAN_NODE_INFO received earlier; if not, this command should be sent again in order to request re-transmission of the node information messages.''')
enums['MAV_CMD'][5200].param[1] = '''Reserved (set to 0)'''
enums['MAV_CMD'][5200].param[2] = '''Reserved (set to 0)'''
enums['MAV_CMD'][5200].param[3] = '''Reserved (set to 0)'''
enums['MAV_CMD'][5200].param[4] = '''Reserved (set to 0)'''
enums['MAV_CMD'][5200].param[5] = '''Reserved (set to 0)'''
enums['MAV_CMD'][5200].param[6] = '''Reserved (set to 0)'''
enums['MAV_CMD'][5200].param[7] = '''Reserved (set to 0)'''
MAV_CMD_DO_ADSB_OUT_IDENT = 10001 # Trigger the start of an ADSB-out IDENT. This should only be used when
                        # requested to do so by an Air Traffic
                        # Controller in controlled airspace. This
                        # starts the IDENT which is then typically
                        # held for 18 seconds by the hardware per the
                        # Mode A, C, and S transponder spec.
enums['MAV_CMD'][10001] = EnumEntry('MAV_CMD_DO_ADSB_OUT_IDENT', '''Trigger the start of an ADSB-out IDENT. This should only be used when requested to do so by an Air Traffic Controller in controlled airspace. This starts the IDENT which is then typically held for 18 seconds by the hardware per the Mode A, C, and S transponder spec.''')
enums['MAV_CMD'][10001].param[1] = '''Reserved (set to 0)'''
enums['MAV_CMD'][10001].param[2] = '''Reserved (set to 0)'''
enums['MAV_CMD'][10001].param[3] = '''Reserved (set to 0)'''
enums['MAV_CMD'][10001].param[4] = '''Reserved (set to 0)'''
enums['MAV_CMD'][10001].param[5] = '''Reserved (set to 0)'''
enums['MAV_CMD'][10001].param[6] = '''Reserved (set to 0)'''
enums['MAV_CMD'][10001].param[7] = '''Reserved (set to 0)'''
MAV_CMD_PAYLOAD_PREPARE_DEPLOY = 30001 # Deploy payload on a Lat / Lon / Alt position. This includes the
                        # navigation to reach the required release
                        # position and velocity.
enums['MAV_CMD'][30001] = EnumEntry('MAV_CMD_PAYLOAD_PREPARE_DEPLOY', '''Deploy payload on a Lat / Lon / Alt position. This includes the navigation to reach the required release position and velocity.''')
enums['MAV_CMD'][30001].param[1] = '''Operation mode. 0: prepare single payload deploy (overwriting previous requests), but do not execute it. 1: execute payload deploy immediately (rejecting further deploy commands during execution, but allowing abort). 2: add payload deploy to existing deployment list.'''
enums['MAV_CMD'][30001].param[2] = '''Desired approach vector in compass heading. A negative value indicates the system can define the approach vector at will.'''
enums['MAV_CMD'][30001].param[3] = '''Desired ground speed at release time. This can be overridden by the airframe in case it needs to meet minimum airspeed. A negative value indicates the system can define the ground speed at will.'''
enums['MAV_CMD'][30001].param[4] = '''Minimum altitude clearance to the release position. A negative value indicates the system can define the clearance at will.'''
enums['MAV_CMD'][30001].param[5] = '''Latitude. Note, if used in MISSION_ITEM (deprecated) the units are degrees (unscaled)'''
enums['MAV_CMD'][30001].param[6] = '''Longitude. Note, if used in MISSION_ITEM (deprecated) the units are degrees (unscaled)'''
enums['MAV_CMD'][30001].param[7] = '''Altitude (MSL)'''
MAV_CMD_PAYLOAD_CONTROL_DEPLOY = 30002 # Control the payload deployment.
enums['MAV_CMD'][30002] = EnumEntry('MAV_CMD_PAYLOAD_CONTROL_DEPLOY', '''Control the payload deployment.''')
enums['MAV_CMD'][30002].param[1] = '''Operation mode. 0: Abort deployment, continue normal mission. 1: switch to payload deployment mode. 100: delete first payload deployment request. 101: delete all payload deployment requests.'''
enums['MAV_CMD'][30002].param[2] = '''Reserved'''
enums['MAV_CMD'][30002].param[3] = '''Reserved'''
enums['MAV_CMD'][30002].param[4] = '''Reserved'''
enums['MAV_CMD'][30002].param[5] = '''Reserved'''
enums['MAV_CMD'][30002].param[6] = '''Reserved'''
enums['MAV_CMD'][30002].param[7] = '''Reserved'''
MAV_CMD_WAYPOINT_USER_1 = 31000 # User defined waypoint item. Ground Station will show the Vehicle as
                        # flying through this item.
enums['MAV_CMD'][31000] = EnumEntry('MAV_CMD_WAYPOINT_USER_1', '''User defined waypoint item. Ground Station will show the Vehicle as flying through this item.''')
enums['MAV_CMD'][31000].param[1] = '''User defined'''
enums['MAV_CMD'][31000].param[2] = '''User defined'''
enums['MAV_CMD'][31000].param[3] = '''User defined'''
enums['MAV_CMD'][31000].param[4] = '''User defined'''
enums['MAV_CMD'][31000].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31000].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31000].param[7] = '''Altitude (MSL)'''
MAV_CMD_WAYPOINT_USER_2 = 31001 # User defined waypoint item. Ground Station will show the Vehicle as
                        # flying through this item.
enums['MAV_CMD'][31001] = EnumEntry('MAV_CMD_WAYPOINT_USER_2', '''User defined waypoint item. Ground Station will show the Vehicle as flying through this item.''')
enums['MAV_CMD'][31001].param[1] = '''User defined'''
enums['MAV_CMD'][31001].param[2] = '''User defined'''
enums['MAV_CMD'][31001].param[3] = '''User defined'''
enums['MAV_CMD'][31001].param[4] = '''User defined'''
enums['MAV_CMD'][31001].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31001].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31001].param[7] = '''Altitude (MSL)'''
MAV_CMD_WAYPOINT_USER_3 = 31002 # User defined waypoint item. Ground Station will show the Vehicle as
                        # flying through this item.
enums['MAV_CMD'][31002] = EnumEntry('MAV_CMD_WAYPOINT_USER_3', '''User defined waypoint item. Ground Station will show the Vehicle as flying through this item.''')
enums['MAV_CMD'][31002].param[1] = '''User defined'''
enums['MAV_CMD'][31002].param[2] = '''User defined'''
enums['MAV_CMD'][31002].param[3] = '''User defined'''
enums['MAV_CMD'][31002].param[4] = '''User defined'''
enums['MAV_CMD'][31002].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31002].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31002].param[7] = '''Altitude (MSL)'''
MAV_CMD_WAYPOINT_USER_4 = 31003 # User defined waypoint item. Ground Station will show the Vehicle as
                        # flying through this item.
enums['MAV_CMD'][31003] = EnumEntry('MAV_CMD_WAYPOINT_USER_4', '''User defined waypoint item. Ground Station will show the Vehicle as flying through this item.''')
enums['MAV_CMD'][31003].param[1] = '''User defined'''
enums['MAV_CMD'][31003].param[2] = '''User defined'''
enums['MAV_CMD'][31003].param[3] = '''User defined'''
enums['MAV_CMD'][31003].param[4] = '''User defined'''
enums['MAV_CMD'][31003].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31003].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31003].param[7] = '''Altitude (MSL)'''
MAV_CMD_WAYPOINT_USER_5 = 31004 # User defined waypoint item. Ground Station will show the Vehicle as
                        # flying through this item.
enums['MAV_CMD'][31004] = EnumEntry('MAV_CMD_WAYPOINT_USER_5', '''User defined waypoint item. Ground Station will show the Vehicle as flying through this item.''')
enums['MAV_CMD'][31004].param[1] = '''User defined'''
enums['MAV_CMD'][31004].param[2] = '''User defined'''
enums['MAV_CMD'][31004].param[3] = '''User defined'''
enums['MAV_CMD'][31004].param[4] = '''User defined'''
enums['MAV_CMD'][31004].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31004].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31004].param[7] = '''Altitude (MSL)'''
MAV_CMD_SPATIAL_USER_1 = 31005 # User defined spatial item. Ground Station will not show the Vehicle as
                        # flying through this item. Example: ROI item.
enums['MAV_CMD'][31005] = EnumEntry('MAV_CMD_SPATIAL_USER_1', '''User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.''')
enums['MAV_CMD'][31005].param[1] = '''User defined'''
enums['MAV_CMD'][31005].param[2] = '''User defined'''
enums['MAV_CMD'][31005].param[3] = '''User defined'''
enums['MAV_CMD'][31005].param[4] = '''User defined'''
enums['MAV_CMD'][31005].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31005].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31005].param[7] = '''Altitude (MSL)'''
MAV_CMD_SPATIAL_USER_2 = 31006 # User defined spatial item. Ground Station will not show the Vehicle as
                        # flying through this item. Example: ROI item.
enums['MAV_CMD'][31006] = EnumEntry('MAV_CMD_SPATIAL_USER_2', '''User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.''')
enums['MAV_CMD'][31006].param[1] = '''User defined'''
enums['MAV_CMD'][31006].param[2] = '''User defined'''
enums['MAV_CMD'][31006].param[3] = '''User defined'''
enums['MAV_CMD'][31006].param[4] = '''User defined'''
enums['MAV_CMD'][31006].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31006].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31006].param[7] = '''Altitude (MSL)'''
MAV_CMD_SPATIAL_USER_3 = 31007 # User defined spatial item. Ground Station will not show the Vehicle as
                        # flying through this item. Example: ROI item.
enums['MAV_CMD'][31007] = EnumEntry('MAV_CMD_SPATIAL_USER_3', '''User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.''')
enums['MAV_CMD'][31007].param[1] = '''User defined'''
enums['MAV_CMD'][31007].param[2] = '''User defined'''
enums['MAV_CMD'][31007].param[3] = '''User defined'''
enums['MAV_CMD'][31007].param[4] = '''User defined'''
enums['MAV_CMD'][31007].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31007].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31007].param[7] = '''Altitude (MSL)'''
MAV_CMD_SPATIAL_USER_4 = 31008 # User defined spatial item. Ground Station will not show the Vehicle as
                        # flying through this item. Example: ROI item.
enums['MAV_CMD'][31008] = EnumEntry('MAV_CMD_SPATIAL_USER_4', '''User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.''')
enums['MAV_CMD'][31008].param[1] = '''User defined'''
enums['MAV_CMD'][31008].param[2] = '''User defined'''
enums['MAV_CMD'][31008].param[3] = '''User defined'''
enums['MAV_CMD'][31008].param[4] = '''User defined'''
enums['MAV_CMD'][31008].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31008].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31008].param[7] = '''Altitude (MSL)'''
MAV_CMD_SPATIAL_USER_5 = 31009 # User defined spatial item. Ground Station will not show the Vehicle as
                        # flying through this item. Example: ROI item.
enums['MAV_CMD'][31009] = EnumEntry('MAV_CMD_SPATIAL_USER_5', '''User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.''')
enums['MAV_CMD'][31009].param[1] = '''User defined'''
enums['MAV_CMD'][31009].param[2] = '''User defined'''
enums['MAV_CMD'][31009].param[3] = '''User defined'''
enums['MAV_CMD'][31009].param[4] = '''User defined'''
enums['MAV_CMD'][31009].param[5] = '''Latitude unscaled'''
enums['MAV_CMD'][31009].param[6] = '''Longitude unscaled'''
enums['MAV_CMD'][31009].param[7] = '''Altitude (MSL)'''
MAV_CMD_USER_1 = 31010 # User defined command. Ground Station will not show the Vehicle as
                        # flying through this item. Example:
                        # MAV_CMD_DO_SET_PARAMETER item.
enums['MAV_CMD'][31010] = EnumEntry('MAV_CMD_USER_1', '''User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.''')
enums['MAV_CMD'][31010].param[1] = '''User defined'''
enums['MAV_CMD'][31010].param[2] = '''User defined'''
enums['MAV_CMD'][31010].param[3] = '''User defined'''
enums['MAV_CMD'][31010].param[4] = '''User defined'''
enums['MAV_CMD'][31010].param[5] = '''User defined'''
enums['MAV_CMD'][31010].param[6] = '''User defined'''
enums['MAV_CMD'][31010].param[7] = '''User defined'''
MAV_CMD_USER_2 = 31011 # User defined command. Ground Station will not show the Vehicle as
                        # flying through this item. Example:
                        # MAV_CMD_DO_SET_PARAMETER item.
enums['MAV_CMD'][31011] = EnumEntry('MAV_CMD_USER_2', '''User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.''')
enums['MAV_CMD'][31011].param[1] = '''User defined'''
enums['MAV_CMD'][31011].param[2] = '''User defined'''
enums['MAV_CMD'][31011].param[3] = '''User defined'''
enums['MAV_CMD'][31011].param[4] = '''User defined'''
enums['MAV_CMD'][31011].param[5] = '''User defined'''
enums['MAV_CMD'][31011].param[6] = '''User defined'''
enums['MAV_CMD'][31011].param[7] = '''User defined'''
MAV_CMD_USER_3 = 31012 # User defined command. Ground Station will not show the Vehicle as
                        # flying through this item. Example:
                        # MAV_CMD_DO_SET_PARAMETER item.
enums['MAV_CMD'][31012] = EnumEntry('MAV_CMD_USER_3', '''User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.''')
enums['MAV_CMD'][31012].param[1] = '''User defined'''
enums['MAV_CMD'][31012].param[2] = '''User defined'''
enums['MAV_CMD'][31012].param[3] = '''User defined'''
enums['MAV_CMD'][31012].param[4] = '''User defined'''
enums['MAV_CMD'][31012].param[5] = '''User defined'''
enums['MAV_CMD'][31012].param[6] = '''User defined'''
enums['MAV_CMD'][31012].param[7] = '''User defined'''
MAV_CMD_USER_4 = 31013 # User defined command. Ground Station will not show the Vehicle as
                        # flying through this item. Example:
                        # MAV_CMD_DO_SET_PARAMETER item.
enums['MAV_CMD'][31013] = EnumEntry('MAV_CMD_USER_4', '''User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.''')
enums['MAV_CMD'][31013].param[1] = '''User defined'''
enums['MAV_CMD'][31013].param[2] = '''User defined'''
enums['MAV_CMD'][31013].param[3] = '''User defined'''
enums['MAV_CMD'][31013].param[4] = '''User defined'''
enums['MAV_CMD'][31013].param[5] = '''User defined'''
enums['MAV_CMD'][31013].param[6] = '''User defined'''
enums['MAV_CMD'][31013].param[7] = '''User defined'''
MAV_CMD_USER_5 = 31014 # User defined command. Ground Station will not show the Vehicle as
                        # flying through this item. Example:
                        # MAV_CMD_DO_SET_PARAMETER item.
enums['MAV_CMD'][31014] = EnumEntry('MAV_CMD_USER_5', '''User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.''')
enums['MAV_CMD'][31014].param[1] = '''User defined'''
enums['MAV_CMD'][31014].param[2] = '''User defined'''
enums['MAV_CMD'][31014].param[3] = '''User defined'''
enums['MAV_CMD'][31014].param[4] = '''User defined'''
enums['MAV_CMD'][31014].param[5] = '''User defined'''
enums['MAV_CMD'][31014].param[6] = '''User defined'''
enums['MAV_CMD'][31014].param[7] = '''User defined'''
MAV_CMD_POWER_OFF_INITIATED = 42000 # A system wide power-off event has been initiated.
enums['MAV_CMD'][42000] = EnumEntry('MAV_CMD_POWER_OFF_INITIATED', '''A system wide power-off event has been initiated.''')
enums['MAV_CMD'][42000].param[1] = '''Empty.'''
enums['MAV_CMD'][42000].param[2] = '''Empty.'''
enums['MAV_CMD'][42000].param[3] = '''Empty.'''
enums['MAV_CMD'][42000].param[4] = '''Empty.'''
enums['MAV_CMD'][42000].param[5] = '''Empty.'''
enums['MAV_CMD'][42000].param[6] = '''Empty.'''
enums['MAV_CMD'][42000].param[7] = '''Empty.'''
MAV_CMD_SOLO_BTN_FLY_CLICK = 42001 # FLY button has been clicked.
enums['MAV_CMD'][42001] = EnumEntry('MAV_CMD_SOLO_BTN_FLY_CLICK', '''FLY button has been clicked.''')
enums['MAV_CMD'][42001].param[1] = '''Empty.'''
enums['MAV_CMD'][42001].param[2] = '''Empty.'''
enums['MAV_CMD'][42001].param[3] = '''Empty.'''
enums['MAV_CMD'][42001].param[4] = '''Empty.'''
enums['MAV_CMD'][42001].param[5] = '''Empty.'''
enums['MAV_CMD'][42001].param[6] = '''Empty.'''
enums['MAV_CMD'][42001].param[7] = '''Empty.'''
MAV_CMD_SOLO_BTN_FLY_HOLD = 42002 # FLY button has been held for 1.5 seconds.
enums['MAV_CMD'][42002] = EnumEntry('MAV_CMD_SOLO_BTN_FLY_HOLD', '''FLY button has been held for 1.5 seconds.''')
enums['MAV_CMD'][42002].param[1] = '''Takeoff altitude.'''
enums['MAV_CMD'][42002].param[2] = '''Empty.'''
enums['MAV_CMD'][42002].param[3] = '''Empty.'''
enums['MAV_CMD'][42002].param[4] = '''Empty.'''
enums['MAV_CMD'][42002].param[5] = '''Empty.'''
enums['MAV_CMD'][42002].param[6] = '''Empty.'''
enums['MAV_CMD'][42002].param[7] = '''Empty.'''
MAV_CMD_SOLO_BTN_PAUSE_CLICK = 42003 # PAUSE button has been clicked.
enums['MAV_CMD'][42003] = EnumEntry('MAV_CMD_SOLO_BTN_PAUSE_CLICK', '''PAUSE button has been clicked.''')
enums['MAV_CMD'][42003].param[1] = '''1 if Solo is in a shot mode, 0 otherwise.'''
enums['MAV_CMD'][42003].param[2] = '''Empty.'''
enums['MAV_CMD'][42003].param[3] = '''Empty.'''
enums['MAV_CMD'][42003].param[4] = '''Empty.'''
enums['MAV_CMD'][42003].param[5] = '''Empty.'''
enums['MAV_CMD'][42003].param[6] = '''Empty.'''
enums['MAV_CMD'][42003].param[7] = '''Empty.'''
MAV_CMD_FIXED_MAG_CAL = 42004 # Magnetometer calibration based on fixed position         in earth
                        # field given by inclination, declination and
                        # intensity.
enums['MAV_CMD'][42004] = EnumEntry('MAV_CMD_FIXED_MAG_CAL', '''Magnetometer calibration based on fixed position
        in earth field given by inclination, declination and intensity.''')
enums['MAV_CMD'][42004].param[1] = '''Magnetic declination.'''
enums['MAV_CMD'][42004].param[2] = '''Magnetic inclination.'''
enums['MAV_CMD'][42004].param[3] = '''Magnetic intensity.'''
enums['MAV_CMD'][42004].param[4] = '''Yaw.'''
enums['MAV_CMD'][42004].param[5] = '''Empty.'''
enums['MAV_CMD'][42004].param[6] = '''Empty.'''
enums['MAV_CMD'][42004].param[7] = '''Empty.'''
MAV_CMD_FIXED_MAG_CAL_FIELD = 42005 # Magnetometer calibration based on fixed expected field values.
enums['MAV_CMD'][42005] = EnumEntry('MAV_CMD_FIXED_MAG_CAL_FIELD', '''Magnetometer calibration based on fixed expected field values.''')
enums['MAV_CMD'][42005].param[1] = '''Field strength X.'''
enums['MAV_CMD'][42005].param[2] = '''Field strength Y.'''
enums['MAV_CMD'][42005].param[3] = '''Field strength Z.'''
enums['MAV_CMD'][42005].param[4] = '''Empty.'''
enums['MAV_CMD'][42005].param[5] = '''Empty.'''
enums['MAV_CMD'][42005].param[6] = '''Empty.'''
enums['MAV_CMD'][42005].param[7] = '''Empty.'''
MAV_CMD_FIXED_MAG_CAL_YAW = 42006 # Magnetometer calibration based on provided known yaw. This allows for
                        # fast calibration using WMM field tables in
                        # the vehicle, given only the known yaw of the
                        # vehicle. If Latitude and longitude are both
                        # zero then use the current vehicle location.
enums['MAV_CMD'][42006] = EnumEntry('MAV_CMD_FIXED_MAG_CAL_YAW', '''Magnetometer calibration based on provided known yaw. This allows for fast calibration using WMM field tables in the vehicle, given only the known yaw of the vehicle. If Latitude and longitude are both zero then use the current vehicle location.''')
enums['MAV_CMD'][42006].param[1] = '''Yaw of vehicle in earth frame.'''
enums['MAV_CMD'][42006].param[2] = '''CompassMask, 0 for all.'''
enums['MAV_CMD'][42006].param[3] = '''Latitude.'''
enums['MAV_CMD'][42006].param[4] = '''Longitude.'''
enums['MAV_CMD'][42006].param[5] = '''Empty.'''
enums['MAV_CMD'][42006].param[6] = '''Empty.'''
enums['MAV_CMD'][42006].param[7] = '''Empty.'''
MAV_CMD_SET_EKF_SOURCE_SET = 42007 # Set EKF sensor source set.
enums['MAV_CMD'][42007] = EnumEntry('MAV_CMD_SET_EKF_SOURCE_SET', '''Set EKF sensor source set.''')
enums['MAV_CMD'][42007].param[1] = '''Source Set Id.'''
enums['MAV_CMD'][42007].param[2] = '''Empty.'''
enums['MAV_CMD'][42007].param[3] = '''Empty.'''
enums['MAV_CMD'][42007].param[4] = '''Empty.'''
enums['MAV_CMD'][42007].param[5] = '''Empty.'''
enums['MAV_CMD'][42007].param[6] = '''Empty.'''
enums['MAV_CMD'][42007].param[7] = '''Empty.'''
MAV_CMD_DO_START_MAG_CAL = 42424 # Initiate a magnetometer calibration.
enums['MAV_CMD'][42424] = EnumEntry('MAV_CMD_DO_START_MAG_CAL', '''Initiate a magnetometer calibration.''')
enums['MAV_CMD'][42424].param[1] = '''Bitmask of magnetometers to calibrate. Use 0 to calibrate all sensors that can be started (sensors may not start if disabled, unhealthy, etc.). The command will NACK if calibration does not start for a sensor explicitly specified by the bitmask.'''
enums['MAV_CMD'][42424].param[2] = '''Automatically retry on failure (0=no retry, 1=retry).'''
enums['MAV_CMD'][42424].param[3] = '''Save without user input (0=require input, 1=autosave).'''
enums['MAV_CMD'][42424].param[4] = '''Delay.'''
enums['MAV_CMD'][42424].param[5] = '''Autoreboot (0=user reboot, 1=autoreboot).'''
enums['MAV_CMD'][42424].param[6] = '''Empty.'''
enums['MAV_CMD'][42424].param[7] = '''Empty.'''
MAV_CMD_DO_ACCEPT_MAG_CAL = 42425 # Accept a magnetometer calibration.
enums['MAV_CMD'][42425] = EnumEntry('MAV_CMD_DO_ACCEPT_MAG_CAL', '''Accept a magnetometer calibration.''')
enums['MAV_CMD'][42425].param[1] = '''Bitmask of magnetometers that calibration is accepted (0 means all).'''
enums['MAV_CMD'][42425].param[2] = '''Empty.'''
enums['MAV_CMD'][42425].param[3] = '''Empty.'''
enums['MAV_CMD'][42425].param[4] = '''Empty.'''
enums['MAV_CMD'][42425].param[5] = '''Empty.'''
enums['MAV_CMD'][42425].param[6] = '''Empty.'''
enums['MAV_CMD'][42425].param[7] = '''Empty.'''
MAV_CMD_DO_CANCEL_MAG_CAL = 42426 # Cancel a running magnetometer calibration.
enums['MAV_CMD'][42426] = EnumEntry('MAV_CMD_DO_CANCEL_MAG_CAL', '''Cancel a running magnetometer calibration.''')
enums['MAV_CMD'][42426].param[1] = '''Bitmask of magnetometers to cancel a running calibration (0 means all).'''
enums['MAV_CMD'][42426].param[2] = '''Empty.'''
enums['MAV_CMD'][42426].param[3] = '''Empty.'''
enums['MAV_CMD'][42426].param[4] = '''Empty.'''
enums['MAV_CMD'][42426].param[5] = '''Empty.'''
enums['MAV_CMD'][42426].param[6] = '''Empty.'''
enums['MAV_CMD'][42426].param[7] = '''Empty.'''
MAV_CMD_SET_FACTORY_TEST_MODE = 42427 # Command autopilot to get into factory test/diagnostic mode.
enums['MAV_CMD'][42427] = EnumEntry('MAV_CMD_SET_FACTORY_TEST_MODE', '''Command autopilot to get into factory test/diagnostic mode.''')
enums['MAV_CMD'][42427].param[1] = '''0: activate test mode, 1: exit test mode.'''
enums['MAV_CMD'][42427].param[2] = '''Empty.'''
enums['MAV_CMD'][42427].param[3] = '''Empty.'''
enums['MAV_CMD'][42427].param[4] = '''Empty.'''
enums['MAV_CMD'][42427].param[5] = '''Empty.'''
enums['MAV_CMD'][42427].param[6] = '''Empty.'''
enums['MAV_CMD'][42427].param[7] = '''Empty.'''
MAV_CMD_DO_SEND_BANNER = 42428 # Reply with the version banner.
enums['MAV_CMD'][42428] = EnumEntry('MAV_CMD_DO_SEND_BANNER', '''Reply with the version banner.''')
enums['MAV_CMD'][42428].param[1] = '''Empty.'''
enums['MAV_CMD'][42428].param[2] = '''Empty.'''
enums['MAV_CMD'][42428].param[3] = '''Empty.'''
enums['MAV_CMD'][42428].param[4] = '''Empty.'''
enums['MAV_CMD'][42428].param[5] = '''Empty.'''
enums['MAV_CMD'][42428].param[6] = '''Empty.'''
enums['MAV_CMD'][42428].param[7] = '''Empty.'''
MAV_CMD_ACCELCAL_VEHICLE_POS = 42429 # Used when doing accelerometer calibration. When sent to the GCS tells
                        # it what position to put the vehicle in. When
                        # sent to the vehicle says what position the
                        # vehicle is in.
enums['MAV_CMD'][42429] = EnumEntry('MAV_CMD_ACCELCAL_VEHICLE_POS', '''Used when doing accelerometer calibration. When sent to the GCS tells it what position to put the vehicle in. When sent to the vehicle says what position the vehicle is in.''')
enums['MAV_CMD'][42429].param[1] = '''Position.'''
enums['MAV_CMD'][42429].param[2] = '''Empty.'''
enums['MAV_CMD'][42429].param[3] = '''Empty.'''
enums['MAV_CMD'][42429].param[4] = '''Empty.'''
enums['MAV_CMD'][42429].param[5] = '''Empty.'''
enums['MAV_CMD'][42429].param[6] = '''Empty.'''
enums['MAV_CMD'][42429].param[7] = '''Empty.'''
MAV_CMD_GIMBAL_RESET = 42501 # Causes the gimbal to reset and boot as if it was just powered on.
enums['MAV_CMD'][42501] = EnumEntry('MAV_CMD_GIMBAL_RESET', '''Causes the gimbal to reset and boot as if it was just powered on.''')
enums['MAV_CMD'][42501].param[1] = '''Empty.'''
enums['MAV_CMD'][42501].param[2] = '''Empty.'''
enums['MAV_CMD'][42501].param[3] = '''Empty.'''
enums['MAV_CMD'][42501].param[4] = '''Empty.'''
enums['MAV_CMD'][42501].param[5] = '''Empty.'''
enums['MAV_CMD'][42501].param[6] = '''Empty.'''
enums['MAV_CMD'][42501].param[7] = '''Empty.'''
MAV_CMD_GIMBAL_AXIS_CALIBRATION_STATUS = 42502 # Reports progress and success or failure of gimbal axis calibration
                        # procedure.
enums['MAV_CMD'][42502] = EnumEntry('MAV_CMD_GIMBAL_AXIS_CALIBRATION_STATUS', '''Reports progress and success or failure of gimbal axis calibration procedure.''')
enums['MAV_CMD'][42502].param[1] = '''Gimbal axis we're reporting calibration progress for.'''
enums['MAV_CMD'][42502].param[2] = '''Current calibration progress for this axis.'''
enums['MAV_CMD'][42502].param[3] = '''Status of the calibration.'''
enums['MAV_CMD'][42502].param[4] = '''Empty.'''
enums['MAV_CMD'][42502].param[5] = '''Empty.'''
enums['MAV_CMD'][42502].param[6] = '''Empty.'''
enums['MAV_CMD'][42502].param[7] = '''Empty.'''
MAV_CMD_GIMBAL_REQUEST_AXIS_CALIBRATION = 42503 # Starts commutation calibration on the gimbal.
enums['MAV_CMD'][42503] = EnumEntry('MAV_CMD_GIMBAL_REQUEST_AXIS_CALIBRATION', '''Starts commutation calibration on the gimbal.''')
enums['MAV_CMD'][42503].param[1] = '''Empty.'''
enums['MAV_CMD'][42503].param[2] = '''Empty.'''
enums['MAV_CMD'][42503].param[3] = '''Empty.'''
enums['MAV_CMD'][42503].param[4] = '''Empty.'''
enums['MAV_CMD'][42503].param[5] = '''Empty.'''
enums['MAV_CMD'][42503].param[6] = '''Empty.'''
enums['MAV_CMD'][42503].param[7] = '''Empty.'''
MAV_CMD_GIMBAL_FULL_RESET = 42505 # Erases gimbal application and parameters.
enums['MAV_CMD'][42505] = EnumEntry('MAV_CMD_GIMBAL_FULL_RESET', '''Erases gimbal application and parameters.''')
enums['MAV_CMD'][42505].param[1] = '''Magic number.'''
enums['MAV_CMD'][42505].param[2] = '''Magic number.'''
enums['MAV_CMD'][42505].param[3] = '''Magic number.'''
enums['MAV_CMD'][42505].param[4] = '''Magic number.'''
enums['MAV_CMD'][42505].param[5] = '''Magic number.'''
enums['MAV_CMD'][42505].param[6] = '''Magic number.'''
enums['MAV_CMD'][42505].param[7] = '''Magic number.'''
MAV_CMD_DO_WINCH = 42600 # Command to operate winch.
enums['MAV_CMD'][42600] = EnumEntry('MAV_CMD_DO_WINCH', '''Command to operate winch.''')
enums['MAV_CMD'][42600].param[1] = '''Winch instance number.'''
enums['MAV_CMD'][42600].param[2] = '''Action to perform.'''
enums['MAV_CMD'][42600].param[3] = '''Length of cable to release (negative to wind).'''
enums['MAV_CMD'][42600].param[4] = '''Release rate (negative to wind).'''
enums['MAV_CMD'][42600].param[5] = '''Empty.'''
enums['MAV_CMD'][42600].param[6] = '''Empty.'''
enums['MAV_CMD'][42600].param[7] = '''Empty.'''
MAV_CMD_FLASH_BOOTLOADER = 42650 # Update the bootloader
enums['MAV_CMD'][42650] = EnumEntry('MAV_CMD_FLASH_BOOTLOADER', '''Update the bootloader''')
enums['MAV_CMD'][42650].param[1] = '''Empty'''
enums['MAV_CMD'][42650].param[2] = '''Empty'''
enums['MAV_CMD'][42650].param[3] = '''Empty'''
enums['MAV_CMD'][42650].param[4] = '''Empty'''
enums['MAV_CMD'][42650].param[5] = '''Magic number - set to 290876 to actually flash'''
enums['MAV_CMD'][42650].param[6] = '''Empty'''
enums['MAV_CMD'][42650].param[7] = '''Empty'''
MAV_CMD_BATTERY_RESET = 42651 # Reset battery capacity for batteries that accumulate consumed battery
                        # via integration.
enums['MAV_CMD'][42651] = EnumEntry('MAV_CMD_BATTERY_RESET', '''Reset battery capacity for batteries that accumulate consumed battery via integration.''')
enums['MAV_CMD'][42651].param[1] = '''Bitmask of batteries to reset. Least significant bit is for the first battery.'''
enums['MAV_CMD'][42651].param[2] = '''Battery percentage remaining to set.'''
enums['MAV_CMD'][42651].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][42651].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][42651].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][42651].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][42651].param[7] = '''Reserved (default:0)'''
MAV_CMD_DEBUG_TRAP = 42700 # Issue a trap signal to the autopilot process, presumably to enter the
                        # debugger.
enums['MAV_CMD'][42700] = EnumEntry('MAV_CMD_DEBUG_TRAP', '''Issue a trap signal to the autopilot process, presumably to enter the debugger.''')
enums['MAV_CMD'][42700].param[1] = '''Magic number - set to 32451 to actually trap.'''
enums['MAV_CMD'][42700].param[2] = '''Empty.'''
enums['MAV_CMD'][42700].param[3] = '''Empty.'''
enums['MAV_CMD'][42700].param[4] = '''Empty.'''
enums['MAV_CMD'][42700].param[5] = '''Empty.'''
enums['MAV_CMD'][42700].param[6] = '''Empty.'''
enums['MAV_CMD'][42700].param[7] = '''Empty.'''
MAV_CMD_SCRIPTING = 42701 # Control onboard scripting.
enums['MAV_CMD'][42701] = EnumEntry('MAV_CMD_SCRIPTING', '''Control onboard scripting.''')
enums['MAV_CMD'][42701].param[1] = '''Scripting command to execute'''
enums['MAV_CMD'][42701].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD'][42701].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][42701].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][42701].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][42701].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][42701].param[7] = '''Reserved (default:0)'''
MAV_CMD_NAV_SCRIPT_TIME = 42702 # Scripting command as NAV command with wait for completion.
enums['MAV_CMD'][42702] = EnumEntry('MAV_CMD_NAV_SCRIPT_TIME', '''Scripting command as NAV command with wait for completion.''')
enums['MAV_CMD'][42702].param[1] = '''integer command number (0 to 255)'''
enums['MAV_CMD'][42702].param[2] = '''timeout for operation in seconds. Zero means no timeout (0 to 255)'''
enums['MAV_CMD'][42702].param[3] = '''argument1.'''
enums['MAV_CMD'][42702].param[4] = '''argument2.'''
enums['MAV_CMD'][42702].param[5] = '''Empty'''
enums['MAV_CMD'][42702].param[6] = '''Empty'''
enums['MAV_CMD'][42702].param[7] = '''Empty'''
MAV_CMD_GUIDED_CHANGE_SPEED = 43000 # Change flight speed at a given rate. This slews the vehicle at a
                        # controllable rate between it's previous
                        # speed and the new one. (affects GUIDED only.
                        # Outside GUIDED, aircraft ignores these
                        # commands. Designed for onboard companion-
                        # computer command-and-control, not normally
                        # operator/GCS control.)
enums['MAV_CMD'][43000] = EnumEntry('MAV_CMD_GUIDED_CHANGE_SPEED', '''Change flight speed at a given rate. This slews the vehicle at a controllable rate between it's previous speed and the new one. (affects GUIDED only. Outside GUIDED, aircraft ignores these commands. Designed for onboard companion-computer command-and-control, not normally operator/GCS control.)''')
enums['MAV_CMD'][43000].param[1] = '''Airspeed or groundspeed.'''
enums['MAV_CMD'][43000].param[2] = '''Target Speed'''
enums['MAV_CMD'][43000].param[3] = '''Acceleration rate, 0 to take effect instantly'''
enums['MAV_CMD'][43000].param[4] = '''Empty'''
enums['MAV_CMD'][43000].param[5] = '''Empty'''
enums['MAV_CMD'][43000].param[6] = '''Empty'''
enums['MAV_CMD'][43000].param[7] = '''Empty'''
MAV_CMD_GUIDED_CHANGE_ALTITUDE = 43001 # Change target altitude at a given rate. This slews the vehicle at a
                        # controllable rate between it's previous
                        # altitude and the new one. (affects GUIDED
                        # only. Outside GUIDED, aircraft ignores these
                        # commands. Designed for onboard companion-
                        # computer command-and-control, not normally
                        # operator/GCS control.)
enums['MAV_CMD'][43001] = EnumEntry('MAV_CMD_GUIDED_CHANGE_ALTITUDE', '''Change target altitude at a given rate. This slews the vehicle at a controllable rate between it's previous altitude and the new one. (affects GUIDED only. Outside GUIDED, aircraft ignores these commands. Designed for onboard companion-computer command-and-control, not normally operator/GCS control.)''')
enums['MAV_CMD'][43001].param[1] = '''Empty'''
enums['MAV_CMD'][43001].param[2] = '''Empty'''
enums['MAV_CMD'][43001].param[3] = '''Rate of change, toward new altitude. 0 for maximum rate change. Positive numbers only, as negative numbers will not converge on the new target alt.'''
enums['MAV_CMD'][43001].param[4] = '''Empty'''
enums['MAV_CMD'][43001].param[5] = '''Empty'''
enums['MAV_CMD'][43001].param[6] = '''Empty'''
enums['MAV_CMD'][43001].param[7] = '''Target Altitude'''
MAV_CMD_GUIDED_CHANGE_HEADING = 43002 # Change to target heading at a given rate, overriding previous
                        # heading/s. This slews the vehicle at a
                        # controllable rate between it's previous
                        # heading and the new one. (affects GUIDED
                        # only. Exiting GUIDED returns aircraft to
                        # normal behaviour defined elsewhere. Designed
                        # for onboard companion-computer command-and-
                        # control, not normally operator/GCS control.)
enums['MAV_CMD'][43002] = EnumEntry('MAV_CMD_GUIDED_CHANGE_HEADING', '''Change to target heading at a given rate, overriding previous heading/s. This slews the vehicle at a controllable rate between it's previous heading and the new one. (affects GUIDED only. Exiting GUIDED returns aircraft to normal behaviour defined elsewhere. Designed for onboard companion-computer command-and-control, not normally operator/GCS control.)''')
enums['MAV_CMD'][43002].param[1] = '''course-over-ground or raw vehicle heading.'''
enums['MAV_CMD'][43002].param[2] = '''Target heading.'''
enums['MAV_CMD'][43002].param[3] = '''Maximum centripetal accelearation, ie rate of change,  toward new heading.'''
enums['MAV_CMD'][43002].param[4] = '''Empty'''
enums['MAV_CMD'][43002].param[5] = '''Empty'''
enums['MAV_CMD'][43002].param[6] = '''Empty'''
enums['MAV_CMD'][43002].param[7] = '''Empty'''
MAV_CMD_ENUM_END = 43003 # 
enums['MAV_CMD'][43003] = EnumEntry('MAV_CMD_ENUM_END', '''''')

# SCRIPTING_CMD
enums['SCRIPTING_CMD'] = {}
SCRIPTING_CMD_REPL_START = 0 # Start a REPL session.
enums['SCRIPTING_CMD'][0] = EnumEntry('SCRIPTING_CMD_REPL_START', '''Start a REPL session.''')
SCRIPTING_CMD_REPL_STOP = 1 # End a REPL session.
enums['SCRIPTING_CMD'][1] = EnumEntry('SCRIPTING_CMD_REPL_STOP', '''End a REPL session.''')
SCRIPTING_CMD_STOP = 2 # Stop execution of scripts.
enums['SCRIPTING_CMD'][2] = EnumEntry('SCRIPTING_CMD_STOP', '''Stop execution of scripts.''')
SCRIPTING_CMD_STOP_AND_RESTART = 3 # Stop execution of scripts and restart.
enums['SCRIPTING_CMD'][3] = EnumEntry('SCRIPTING_CMD_STOP_AND_RESTART', '''Stop execution of scripts and restart.''')
SCRIPTING_CMD_ENUM_END = 4 # 
enums['SCRIPTING_CMD'][4] = EnumEntry('SCRIPTING_CMD_ENUM_END', '''''')

# LIMITS_STATE
enums['LIMITS_STATE'] = {}
LIMITS_INIT = 0 # Pre-initialization.
enums['LIMITS_STATE'][0] = EnumEntry('LIMITS_INIT', '''Pre-initialization.''')
LIMITS_DISABLED = 1 # Disabled.
enums['LIMITS_STATE'][1] = EnumEntry('LIMITS_DISABLED', '''Disabled.''')
LIMITS_ENABLED = 2 # Checking limits.
enums['LIMITS_STATE'][2] = EnumEntry('LIMITS_ENABLED', '''Checking limits.''')
LIMITS_TRIGGERED = 3 # A limit has been breached.
enums['LIMITS_STATE'][3] = EnumEntry('LIMITS_TRIGGERED', '''A limit has been breached.''')
LIMITS_RECOVERING = 4 # Taking action e.g. Return/RTL.
enums['LIMITS_STATE'][4] = EnumEntry('LIMITS_RECOVERING', '''Taking action e.g. Return/RTL.''')
LIMITS_RECOVERED = 5 # We're no longer in breach of a limit.
enums['LIMITS_STATE'][5] = EnumEntry('LIMITS_RECOVERED', '''We're no longer in breach of a limit.''')
LIMITS_STATE_ENUM_END = 6 # 
enums['LIMITS_STATE'][6] = EnumEntry('LIMITS_STATE_ENUM_END', '''''')

# LIMIT_MODULE
enums['LIMIT_MODULE'] = {}
LIMIT_GPSLOCK = 1 # Pre-initialization.
enums['LIMIT_MODULE'][1] = EnumEntry('LIMIT_GPSLOCK', '''Pre-initialization.''')
LIMIT_GEOFENCE = 2 # Disabled.
enums['LIMIT_MODULE'][2] = EnumEntry('LIMIT_GEOFENCE', '''Disabled.''')
LIMIT_ALTITUDE = 4 # Checking limits.
enums['LIMIT_MODULE'][4] = EnumEntry('LIMIT_ALTITUDE', '''Checking limits.''')
LIMIT_MODULE_ENUM_END = 5 # 
enums['LIMIT_MODULE'][5] = EnumEntry('LIMIT_MODULE_ENUM_END', '''''')

# RALLY_FLAGS
enums['RALLY_FLAGS'] = {}
FAVORABLE_WIND = 1 # Flag set when requiring favorable winds for landing.
enums['RALLY_FLAGS'][1] = EnumEntry('FAVORABLE_WIND', '''Flag set when requiring favorable winds for landing.''')
LAND_IMMEDIATELY = 2 # Flag set when plane is to immediately descend to break altitude and
                        # land without GCS intervention. Flag not set
                        # when plane is to loiter at Rally point until
                        # commanded to land.
enums['RALLY_FLAGS'][2] = EnumEntry('LAND_IMMEDIATELY', '''Flag set when plane is to immediately descend to break altitude and land without GCS intervention. Flag not set when plane is to loiter at Rally point until commanded to land.''')
RALLY_FLAGS_ENUM_END = 3 # 
enums['RALLY_FLAGS'][3] = EnumEntry('RALLY_FLAGS_ENUM_END', '''''')

# CAMERA_STATUS_TYPES
enums['CAMERA_STATUS_TYPES'] = {}
CAMERA_STATUS_TYPE_HEARTBEAT = 0 # Camera heartbeat, announce camera component ID at 1Hz.
enums['CAMERA_STATUS_TYPES'][0] = EnumEntry('CAMERA_STATUS_TYPE_HEARTBEAT', '''Camera heartbeat, announce camera component ID at 1Hz.''')
CAMERA_STATUS_TYPE_TRIGGER = 1 # Camera image triggered.
enums['CAMERA_STATUS_TYPES'][1] = EnumEntry('CAMERA_STATUS_TYPE_TRIGGER', '''Camera image triggered.''')
CAMERA_STATUS_TYPE_DISCONNECT = 2 # Camera connection lost.
enums['CAMERA_STATUS_TYPES'][2] = EnumEntry('CAMERA_STATUS_TYPE_DISCONNECT', '''Camera connection lost.''')
CAMERA_STATUS_TYPE_ERROR = 3 # Camera unknown error.
enums['CAMERA_STATUS_TYPES'][3] = EnumEntry('CAMERA_STATUS_TYPE_ERROR', '''Camera unknown error.''')
CAMERA_STATUS_TYPE_LOWBATT = 4 # Camera battery low. Parameter p1 shows reported voltage.
enums['CAMERA_STATUS_TYPES'][4] = EnumEntry('CAMERA_STATUS_TYPE_LOWBATT', '''Camera battery low. Parameter p1 shows reported voltage.''')
CAMERA_STATUS_TYPE_LOWSTORE = 5 # Camera storage low. Parameter p1 shows reported shots remaining.
enums['CAMERA_STATUS_TYPES'][5] = EnumEntry('CAMERA_STATUS_TYPE_LOWSTORE', '''Camera storage low. Parameter p1 shows reported shots remaining.''')
CAMERA_STATUS_TYPE_LOWSTOREV = 6 # Camera storage low. Parameter p1 shows reported video minutes
                        # remaining.
enums['CAMERA_STATUS_TYPES'][6] = EnumEntry('CAMERA_STATUS_TYPE_LOWSTOREV', '''Camera storage low. Parameter p1 shows reported video minutes remaining.''')
CAMERA_STATUS_TYPES_ENUM_END = 7 # 
enums['CAMERA_STATUS_TYPES'][7] = EnumEntry('CAMERA_STATUS_TYPES_ENUM_END', '''''')

# CAMERA_FEEDBACK_FLAGS
enums['CAMERA_FEEDBACK_FLAGS'] = {}
CAMERA_FEEDBACK_PHOTO = 0 # Shooting photos, not video.
enums['CAMERA_FEEDBACK_FLAGS'][0] = EnumEntry('CAMERA_FEEDBACK_PHOTO', '''Shooting photos, not video.''')
CAMERA_FEEDBACK_VIDEO = 1 # Shooting video, not stills.
enums['CAMERA_FEEDBACK_FLAGS'][1] = EnumEntry('CAMERA_FEEDBACK_VIDEO', '''Shooting video, not stills.''')
CAMERA_FEEDBACK_BADEXPOSURE = 2 # Unable to achieve requested exposure (e.g. shutter speed too low).
enums['CAMERA_FEEDBACK_FLAGS'][2] = EnumEntry('CAMERA_FEEDBACK_BADEXPOSURE', '''Unable to achieve requested exposure (e.g. shutter speed too low).''')
CAMERA_FEEDBACK_CLOSEDLOOP = 3 # Closed loop feedback from camera, we know for sure it has successfully
                        # taken a picture.
enums['CAMERA_FEEDBACK_FLAGS'][3] = EnumEntry('CAMERA_FEEDBACK_CLOSEDLOOP', '''Closed loop feedback from camera, we know for sure it has successfully taken a picture.''')
CAMERA_FEEDBACK_OPENLOOP = 4 # Open loop camera, an image trigger has been requested but we can't
                        # know for sure it has successfully taken a
                        # picture.
enums['CAMERA_FEEDBACK_FLAGS'][4] = EnumEntry('CAMERA_FEEDBACK_OPENLOOP', '''Open loop camera, an image trigger has been requested but we can't know for sure it has successfully taken a picture.''')
CAMERA_FEEDBACK_FLAGS_ENUM_END = 5 # 
enums['CAMERA_FEEDBACK_FLAGS'][5] = EnumEntry('CAMERA_FEEDBACK_FLAGS_ENUM_END', '''''')

# MAV_MODE_GIMBAL
enums['MAV_MODE_GIMBAL'] = {}
MAV_MODE_GIMBAL_UNINITIALIZED = 0 # Gimbal is powered on but has not started initializing yet.
enums['MAV_MODE_GIMBAL'][0] = EnumEntry('MAV_MODE_GIMBAL_UNINITIALIZED', '''Gimbal is powered on but has not started initializing yet.''')
MAV_MODE_GIMBAL_CALIBRATING_PITCH = 1 # Gimbal is currently running calibration on the pitch axis.
enums['MAV_MODE_GIMBAL'][1] = EnumEntry('MAV_MODE_GIMBAL_CALIBRATING_PITCH', '''Gimbal is currently running calibration on the pitch axis.''')
MAV_MODE_GIMBAL_CALIBRATING_ROLL = 2 # Gimbal is currently running calibration on the roll axis.
enums['MAV_MODE_GIMBAL'][2] = EnumEntry('MAV_MODE_GIMBAL_CALIBRATING_ROLL', '''Gimbal is currently running calibration on the roll axis.''')
MAV_MODE_GIMBAL_CALIBRATING_YAW = 3 # Gimbal is currently running calibration on the yaw axis.
enums['MAV_MODE_GIMBAL'][3] = EnumEntry('MAV_MODE_GIMBAL_CALIBRATING_YAW', '''Gimbal is currently running calibration on the yaw axis.''')
MAV_MODE_GIMBAL_INITIALIZED = 4 # Gimbal has finished calibrating and initializing, but is relaxed
                        # pending reception of first rate command from
                        # copter.
enums['MAV_MODE_GIMBAL'][4] = EnumEntry('MAV_MODE_GIMBAL_INITIALIZED', '''Gimbal has finished calibrating and initializing, but is relaxed pending reception of first rate command from copter.''')
MAV_MODE_GIMBAL_ACTIVE = 5 # Gimbal is actively stabilizing.
enums['MAV_MODE_GIMBAL'][5] = EnumEntry('MAV_MODE_GIMBAL_ACTIVE', '''Gimbal is actively stabilizing.''')
MAV_MODE_GIMBAL_RATE_CMD_TIMEOUT = 6 # Gimbal is relaxed because it missed more than 10 expected rate command
                        # messages in a row. Gimbal will move back to
                        # active mode when it receives a new rate
                        # command.
enums['MAV_MODE_GIMBAL'][6] = EnumEntry('MAV_MODE_GIMBAL_RATE_CMD_TIMEOUT', '''Gimbal is relaxed because it missed more than 10 expected rate command messages in a row. Gimbal will move back to active mode when it receives a new rate command.''')
MAV_MODE_GIMBAL_ENUM_END = 7 # 
enums['MAV_MODE_GIMBAL'][7] = EnumEntry('MAV_MODE_GIMBAL_ENUM_END', '''''')

# GIMBAL_AXIS
enums['GIMBAL_AXIS'] = {}
GIMBAL_AXIS_YAW = 0 # Gimbal yaw axis.
enums['GIMBAL_AXIS'][0] = EnumEntry('GIMBAL_AXIS_YAW', '''Gimbal yaw axis.''')
GIMBAL_AXIS_PITCH = 1 # Gimbal pitch axis.
enums['GIMBAL_AXIS'][1] = EnumEntry('GIMBAL_AXIS_PITCH', '''Gimbal pitch axis.''')
GIMBAL_AXIS_ROLL = 2 # Gimbal roll axis.
enums['GIMBAL_AXIS'][2] = EnumEntry('GIMBAL_AXIS_ROLL', '''Gimbal roll axis.''')
GIMBAL_AXIS_ENUM_END = 3 # 
enums['GIMBAL_AXIS'][3] = EnumEntry('GIMBAL_AXIS_ENUM_END', '''''')

# GIMBAL_AXIS_CALIBRATION_STATUS
enums['GIMBAL_AXIS_CALIBRATION_STATUS'] = {}
GIMBAL_AXIS_CALIBRATION_STATUS_IN_PROGRESS = 0 # Axis calibration is in progress.
enums['GIMBAL_AXIS_CALIBRATION_STATUS'][0] = EnumEntry('GIMBAL_AXIS_CALIBRATION_STATUS_IN_PROGRESS', '''Axis calibration is in progress.''')
GIMBAL_AXIS_CALIBRATION_STATUS_SUCCEEDED = 1 # Axis calibration succeeded.
enums['GIMBAL_AXIS_CALIBRATION_STATUS'][1] = EnumEntry('GIMBAL_AXIS_CALIBRATION_STATUS_SUCCEEDED', '''Axis calibration succeeded.''')
GIMBAL_AXIS_CALIBRATION_STATUS_FAILED = 2 # Axis calibration failed.
enums['GIMBAL_AXIS_CALIBRATION_STATUS'][2] = EnumEntry('GIMBAL_AXIS_CALIBRATION_STATUS_FAILED', '''Axis calibration failed.''')
GIMBAL_AXIS_CALIBRATION_STATUS_ENUM_END = 3 # 
enums['GIMBAL_AXIS_CALIBRATION_STATUS'][3] = EnumEntry('GIMBAL_AXIS_CALIBRATION_STATUS_ENUM_END', '''''')

# GIMBAL_AXIS_CALIBRATION_REQUIRED
enums['GIMBAL_AXIS_CALIBRATION_REQUIRED'] = {}
GIMBAL_AXIS_CALIBRATION_REQUIRED_UNKNOWN = 0 # Whether or not this axis requires calibration is unknown at this time.
enums['GIMBAL_AXIS_CALIBRATION_REQUIRED'][0] = EnumEntry('GIMBAL_AXIS_CALIBRATION_REQUIRED_UNKNOWN', '''Whether or not this axis requires calibration is unknown at this time.''')
GIMBAL_AXIS_CALIBRATION_REQUIRED_TRUE = 1 # This axis requires calibration.
enums['GIMBAL_AXIS_CALIBRATION_REQUIRED'][1] = EnumEntry('GIMBAL_AXIS_CALIBRATION_REQUIRED_TRUE', '''This axis requires calibration.''')
GIMBAL_AXIS_CALIBRATION_REQUIRED_FALSE = 2 # This axis does not require calibration.
enums['GIMBAL_AXIS_CALIBRATION_REQUIRED'][2] = EnumEntry('GIMBAL_AXIS_CALIBRATION_REQUIRED_FALSE', '''This axis does not require calibration.''')
GIMBAL_AXIS_CALIBRATION_REQUIRED_ENUM_END = 3 # 
enums['GIMBAL_AXIS_CALIBRATION_REQUIRED'][3] = EnumEntry('GIMBAL_AXIS_CALIBRATION_REQUIRED_ENUM_END', '''''')

# GOPRO_HEARTBEAT_STATUS
enums['GOPRO_HEARTBEAT_STATUS'] = {}
GOPRO_HEARTBEAT_STATUS_DISCONNECTED = 0 # No GoPro connected.
enums['GOPRO_HEARTBEAT_STATUS'][0] = EnumEntry('GOPRO_HEARTBEAT_STATUS_DISCONNECTED', '''No GoPro connected.''')
GOPRO_HEARTBEAT_STATUS_INCOMPATIBLE = 1 # The detected GoPro is not HeroBus compatible.
enums['GOPRO_HEARTBEAT_STATUS'][1] = EnumEntry('GOPRO_HEARTBEAT_STATUS_INCOMPATIBLE', '''The detected GoPro is not HeroBus compatible.''')
GOPRO_HEARTBEAT_STATUS_CONNECTED = 2 # A HeroBus compatible GoPro is connected.
enums['GOPRO_HEARTBEAT_STATUS'][2] = EnumEntry('GOPRO_HEARTBEAT_STATUS_CONNECTED', '''A HeroBus compatible GoPro is connected.''')
GOPRO_HEARTBEAT_STATUS_ERROR = 3 # An unrecoverable error was encountered with the connected GoPro, it
                        # may require a power cycle.
enums['GOPRO_HEARTBEAT_STATUS'][3] = EnumEntry('GOPRO_HEARTBEAT_STATUS_ERROR', '''An unrecoverable error was encountered with the connected GoPro, it may require a power cycle.''')
GOPRO_HEARTBEAT_STATUS_ENUM_END = 4 # 
enums['GOPRO_HEARTBEAT_STATUS'][4] = EnumEntry('GOPRO_HEARTBEAT_STATUS_ENUM_END', '''''')

# GOPRO_HEARTBEAT_FLAGS
enums['GOPRO_HEARTBEAT_FLAGS'] = {}
GOPRO_FLAG_RECORDING = 1 # GoPro is currently recording.
enums['GOPRO_HEARTBEAT_FLAGS'][1] = EnumEntry('GOPRO_FLAG_RECORDING', '''GoPro is currently recording.''')
GOPRO_HEARTBEAT_FLAGS_ENUM_END = 2 # 
enums['GOPRO_HEARTBEAT_FLAGS'][2] = EnumEntry('GOPRO_HEARTBEAT_FLAGS_ENUM_END', '''''')

# GOPRO_REQUEST_STATUS
enums['GOPRO_REQUEST_STATUS'] = {}
GOPRO_REQUEST_SUCCESS = 0 # The write message with ID indicated succeeded.
enums['GOPRO_REQUEST_STATUS'][0] = EnumEntry('GOPRO_REQUEST_SUCCESS', '''The write message with ID indicated succeeded.''')
GOPRO_REQUEST_FAILED = 1 # The write message with ID indicated failed.
enums['GOPRO_REQUEST_STATUS'][1] = EnumEntry('GOPRO_REQUEST_FAILED', '''The write message with ID indicated failed.''')
GOPRO_REQUEST_STATUS_ENUM_END = 2 # 
enums['GOPRO_REQUEST_STATUS'][2] = EnumEntry('GOPRO_REQUEST_STATUS_ENUM_END', '''''')

# GOPRO_COMMAND
enums['GOPRO_COMMAND'] = {}
GOPRO_COMMAND_POWER = 0 # (Get/Set).
enums['GOPRO_COMMAND'][0] = EnumEntry('GOPRO_COMMAND_POWER', '''(Get/Set).''')
GOPRO_COMMAND_CAPTURE_MODE = 1 # (Get/Set).
enums['GOPRO_COMMAND'][1] = EnumEntry('GOPRO_COMMAND_CAPTURE_MODE', '''(Get/Set).''')
GOPRO_COMMAND_SHUTTER = 2 # (___/Set).
enums['GOPRO_COMMAND'][2] = EnumEntry('GOPRO_COMMAND_SHUTTER', '''(___/Set).''')
GOPRO_COMMAND_BATTERY = 3 # (Get/___).
enums['GOPRO_COMMAND'][3] = EnumEntry('GOPRO_COMMAND_BATTERY', '''(Get/___).''')
GOPRO_COMMAND_MODEL = 4 # (Get/___).
enums['GOPRO_COMMAND'][4] = EnumEntry('GOPRO_COMMAND_MODEL', '''(Get/___).''')
GOPRO_COMMAND_VIDEO_SETTINGS = 5 # (Get/Set).
enums['GOPRO_COMMAND'][5] = EnumEntry('GOPRO_COMMAND_VIDEO_SETTINGS', '''(Get/Set).''')
GOPRO_COMMAND_LOW_LIGHT = 6 # (Get/Set).
enums['GOPRO_COMMAND'][6] = EnumEntry('GOPRO_COMMAND_LOW_LIGHT', '''(Get/Set).''')
GOPRO_COMMAND_PHOTO_RESOLUTION = 7 # (Get/Set).
enums['GOPRO_COMMAND'][7] = EnumEntry('GOPRO_COMMAND_PHOTO_RESOLUTION', '''(Get/Set).''')
GOPRO_COMMAND_PHOTO_BURST_RATE = 8 # (Get/Set).
enums['GOPRO_COMMAND'][8] = EnumEntry('GOPRO_COMMAND_PHOTO_BURST_RATE', '''(Get/Set).''')
GOPRO_COMMAND_PROTUNE = 9 # (Get/Set).
enums['GOPRO_COMMAND'][9] = EnumEntry('GOPRO_COMMAND_PROTUNE', '''(Get/Set).''')
GOPRO_COMMAND_PROTUNE_WHITE_BALANCE = 10 # (Get/Set) Hero 3+ Only.
enums['GOPRO_COMMAND'][10] = EnumEntry('GOPRO_COMMAND_PROTUNE_WHITE_BALANCE', '''(Get/Set) Hero 3+ Only.''')
GOPRO_COMMAND_PROTUNE_COLOUR = 11 # (Get/Set) Hero 3+ Only.
enums['GOPRO_COMMAND'][11] = EnumEntry('GOPRO_COMMAND_PROTUNE_COLOUR', '''(Get/Set) Hero 3+ Only.''')
GOPRO_COMMAND_PROTUNE_GAIN = 12 # (Get/Set) Hero 3+ Only.
enums['GOPRO_COMMAND'][12] = EnumEntry('GOPRO_COMMAND_PROTUNE_GAIN', '''(Get/Set) Hero 3+ Only.''')
GOPRO_COMMAND_PROTUNE_SHARPNESS = 13 # (Get/Set) Hero 3+ Only.
enums['GOPRO_COMMAND'][13] = EnumEntry('GOPRO_COMMAND_PROTUNE_SHARPNESS', '''(Get/Set) Hero 3+ Only.''')
GOPRO_COMMAND_PROTUNE_EXPOSURE = 14 # (Get/Set) Hero 3+ Only.
enums['GOPRO_COMMAND'][14] = EnumEntry('GOPRO_COMMAND_PROTUNE_EXPOSURE', '''(Get/Set) Hero 3+ Only.''')
GOPRO_COMMAND_TIME = 15 # (Get/Set).
enums['GOPRO_COMMAND'][15] = EnumEntry('GOPRO_COMMAND_TIME', '''(Get/Set).''')
GOPRO_COMMAND_CHARGING = 16 # (Get/Set).
enums['GOPRO_COMMAND'][16] = EnumEntry('GOPRO_COMMAND_CHARGING', '''(Get/Set).''')
GOPRO_COMMAND_ENUM_END = 17 # 
enums['GOPRO_COMMAND'][17] = EnumEntry('GOPRO_COMMAND_ENUM_END', '''''')

# GOPRO_CAPTURE_MODE
enums['GOPRO_CAPTURE_MODE'] = {}
GOPRO_CAPTURE_MODE_VIDEO = 0 # Video mode.
enums['GOPRO_CAPTURE_MODE'][0] = EnumEntry('GOPRO_CAPTURE_MODE_VIDEO', '''Video mode.''')
GOPRO_CAPTURE_MODE_PHOTO = 1 # Photo mode.
enums['GOPRO_CAPTURE_MODE'][1] = EnumEntry('GOPRO_CAPTURE_MODE_PHOTO', '''Photo mode.''')
GOPRO_CAPTURE_MODE_BURST = 2 # Burst mode, Hero 3+ only.
enums['GOPRO_CAPTURE_MODE'][2] = EnumEntry('GOPRO_CAPTURE_MODE_BURST', '''Burst mode, Hero 3+ only.''')
GOPRO_CAPTURE_MODE_TIME_LAPSE = 3 # Time lapse mode, Hero 3+ only.
enums['GOPRO_CAPTURE_MODE'][3] = EnumEntry('GOPRO_CAPTURE_MODE_TIME_LAPSE', '''Time lapse mode, Hero 3+ only.''')
GOPRO_CAPTURE_MODE_MULTI_SHOT = 4 # Multi shot mode, Hero 4 only.
enums['GOPRO_CAPTURE_MODE'][4] = EnumEntry('GOPRO_CAPTURE_MODE_MULTI_SHOT', '''Multi shot mode, Hero 4 only.''')
GOPRO_CAPTURE_MODE_PLAYBACK = 5 # Playback mode, Hero 4 only, silver only except when LCD or HDMI is
                        # connected to black.
enums['GOPRO_CAPTURE_MODE'][5] = EnumEntry('GOPRO_CAPTURE_MODE_PLAYBACK', '''Playback mode, Hero 4 only, silver only except when LCD or HDMI is connected to black.''')
GOPRO_CAPTURE_MODE_SETUP = 6 # Playback mode, Hero 4 only.
enums['GOPRO_CAPTURE_MODE'][6] = EnumEntry('GOPRO_CAPTURE_MODE_SETUP', '''Playback mode, Hero 4 only.''')
GOPRO_CAPTURE_MODE_UNKNOWN = 255 # Mode not yet known.
enums['GOPRO_CAPTURE_MODE'][255] = EnumEntry('GOPRO_CAPTURE_MODE_UNKNOWN', '''Mode not yet known.''')
GOPRO_CAPTURE_MODE_ENUM_END = 256 # 
enums['GOPRO_CAPTURE_MODE'][256] = EnumEntry('GOPRO_CAPTURE_MODE_ENUM_END', '''''')

# GOPRO_RESOLUTION
enums['GOPRO_RESOLUTION'] = {}
GOPRO_RESOLUTION_480p = 0 # 848 x 480 (480p).
enums['GOPRO_RESOLUTION'][0] = EnumEntry('GOPRO_RESOLUTION_480p', '''848 x 480 (480p).''')
GOPRO_RESOLUTION_720p = 1 # 1280 x 720 (720p).
enums['GOPRO_RESOLUTION'][1] = EnumEntry('GOPRO_RESOLUTION_720p', '''1280 x 720 (720p).''')
GOPRO_RESOLUTION_960p = 2 # 1280 x 960 (960p).
enums['GOPRO_RESOLUTION'][2] = EnumEntry('GOPRO_RESOLUTION_960p', '''1280 x 960 (960p).''')
GOPRO_RESOLUTION_1080p = 3 # 1920 x 1080 (1080p).
enums['GOPRO_RESOLUTION'][3] = EnumEntry('GOPRO_RESOLUTION_1080p', '''1920 x 1080 (1080p).''')
GOPRO_RESOLUTION_1440p = 4 # 1920 x 1440 (1440p).
enums['GOPRO_RESOLUTION'][4] = EnumEntry('GOPRO_RESOLUTION_1440p', '''1920 x 1440 (1440p).''')
GOPRO_RESOLUTION_2_7k_17_9 = 5 # 2704 x 1440 (2.7k-17:9).
enums['GOPRO_RESOLUTION'][5] = EnumEntry('GOPRO_RESOLUTION_2_7k_17_9', '''2704 x 1440 (2.7k-17:9).''')
GOPRO_RESOLUTION_2_7k_16_9 = 6 # 2704 x 1524 (2.7k-16:9).
enums['GOPRO_RESOLUTION'][6] = EnumEntry('GOPRO_RESOLUTION_2_7k_16_9', '''2704 x 1524 (2.7k-16:9).''')
GOPRO_RESOLUTION_2_7k_4_3 = 7 # 2704 x 2028 (2.7k-4:3).
enums['GOPRO_RESOLUTION'][7] = EnumEntry('GOPRO_RESOLUTION_2_7k_4_3', '''2704 x 2028 (2.7k-4:3).''')
GOPRO_RESOLUTION_4k_16_9 = 8 # 3840 x 2160 (4k-16:9).
enums['GOPRO_RESOLUTION'][8] = EnumEntry('GOPRO_RESOLUTION_4k_16_9', '''3840 x 2160 (4k-16:9).''')
GOPRO_RESOLUTION_4k_17_9 = 9 # 4096 x 2160 (4k-17:9).
enums['GOPRO_RESOLUTION'][9] = EnumEntry('GOPRO_RESOLUTION_4k_17_9', '''4096 x 2160 (4k-17:9).''')
GOPRO_RESOLUTION_720p_SUPERVIEW = 10 # 1280 x 720 (720p-SuperView).
enums['GOPRO_RESOLUTION'][10] = EnumEntry('GOPRO_RESOLUTION_720p_SUPERVIEW', '''1280 x 720 (720p-SuperView).''')
GOPRO_RESOLUTION_1080p_SUPERVIEW = 11 # 1920 x 1080 (1080p-SuperView).
enums['GOPRO_RESOLUTION'][11] = EnumEntry('GOPRO_RESOLUTION_1080p_SUPERVIEW', '''1920 x 1080 (1080p-SuperView).''')
GOPRO_RESOLUTION_2_7k_SUPERVIEW = 12 # 2704 x 1520 (2.7k-SuperView).
enums['GOPRO_RESOLUTION'][12] = EnumEntry('GOPRO_RESOLUTION_2_7k_SUPERVIEW', '''2704 x 1520 (2.7k-SuperView).''')
GOPRO_RESOLUTION_4k_SUPERVIEW = 13 # 3840 x 2160 (4k-SuperView).
enums['GOPRO_RESOLUTION'][13] = EnumEntry('GOPRO_RESOLUTION_4k_SUPERVIEW', '''3840 x 2160 (4k-SuperView).''')
GOPRO_RESOLUTION_ENUM_END = 14 # 
enums['GOPRO_RESOLUTION'][14] = EnumEntry('GOPRO_RESOLUTION_ENUM_END', '''''')

# GOPRO_FRAME_RATE
enums['GOPRO_FRAME_RATE'] = {}
GOPRO_FRAME_RATE_12 = 0 # 12 FPS.
enums['GOPRO_FRAME_RATE'][0] = EnumEntry('GOPRO_FRAME_RATE_12', '''12 FPS.''')
GOPRO_FRAME_RATE_15 = 1 # 15 FPS.
enums['GOPRO_FRAME_RATE'][1] = EnumEntry('GOPRO_FRAME_RATE_15', '''15 FPS.''')
GOPRO_FRAME_RATE_24 = 2 # 24 FPS.
enums['GOPRO_FRAME_RATE'][2] = EnumEntry('GOPRO_FRAME_RATE_24', '''24 FPS.''')
GOPRO_FRAME_RATE_25 = 3 # 25 FPS.
enums['GOPRO_FRAME_RATE'][3] = EnumEntry('GOPRO_FRAME_RATE_25', '''25 FPS.''')
GOPRO_FRAME_RATE_30 = 4 # 30 FPS.
enums['GOPRO_FRAME_RATE'][4] = EnumEntry('GOPRO_FRAME_RATE_30', '''30 FPS.''')
GOPRO_FRAME_RATE_48 = 5 # 48 FPS.
enums['GOPRO_FRAME_RATE'][5] = EnumEntry('GOPRO_FRAME_RATE_48', '''48 FPS.''')
GOPRO_FRAME_RATE_50 = 6 # 50 FPS.
enums['GOPRO_FRAME_RATE'][6] = EnumEntry('GOPRO_FRAME_RATE_50', '''50 FPS.''')
GOPRO_FRAME_RATE_60 = 7 # 60 FPS.
enums['GOPRO_FRAME_RATE'][7] = EnumEntry('GOPRO_FRAME_RATE_60', '''60 FPS.''')
GOPRO_FRAME_RATE_80 = 8 # 80 FPS.
enums['GOPRO_FRAME_RATE'][8] = EnumEntry('GOPRO_FRAME_RATE_80', '''80 FPS.''')
GOPRO_FRAME_RATE_90 = 9 # 90 FPS.
enums['GOPRO_FRAME_RATE'][9] = EnumEntry('GOPRO_FRAME_RATE_90', '''90 FPS.''')
GOPRO_FRAME_RATE_100 = 10 # 100 FPS.
enums['GOPRO_FRAME_RATE'][10] = EnumEntry('GOPRO_FRAME_RATE_100', '''100 FPS.''')
GOPRO_FRAME_RATE_120 = 11 # 120 FPS.
enums['GOPRO_FRAME_RATE'][11] = EnumEntry('GOPRO_FRAME_RATE_120', '''120 FPS.''')
GOPRO_FRAME_RATE_240 = 12 # 240 FPS.
enums['GOPRO_FRAME_RATE'][12] = EnumEntry('GOPRO_FRAME_RATE_240', '''240 FPS.''')
GOPRO_FRAME_RATE_12_5 = 13 # 12.5 FPS.
enums['GOPRO_FRAME_RATE'][13] = EnumEntry('GOPRO_FRAME_RATE_12_5', '''12.5 FPS.''')
GOPRO_FRAME_RATE_ENUM_END = 14 # 
enums['GOPRO_FRAME_RATE'][14] = EnumEntry('GOPRO_FRAME_RATE_ENUM_END', '''''')

# GOPRO_FIELD_OF_VIEW
enums['GOPRO_FIELD_OF_VIEW'] = {}
GOPRO_FIELD_OF_VIEW_WIDE = 0 # 0x00: Wide.
enums['GOPRO_FIELD_OF_VIEW'][0] = EnumEntry('GOPRO_FIELD_OF_VIEW_WIDE', '''0x00: Wide.''')
GOPRO_FIELD_OF_VIEW_MEDIUM = 1 # 0x01: Medium.
enums['GOPRO_FIELD_OF_VIEW'][1] = EnumEntry('GOPRO_FIELD_OF_VIEW_MEDIUM', '''0x01: Medium.''')
GOPRO_FIELD_OF_VIEW_NARROW = 2 # 0x02: Narrow.
enums['GOPRO_FIELD_OF_VIEW'][2] = EnumEntry('GOPRO_FIELD_OF_VIEW_NARROW', '''0x02: Narrow.''')
GOPRO_FIELD_OF_VIEW_ENUM_END = 3 # 
enums['GOPRO_FIELD_OF_VIEW'][3] = EnumEntry('GOPRO_FIELD_OF_VIEW_ENUM_END', '''''')

# GOPRO_VIDEO_SETTINGS_FLAGS
enums['GOPRO_VIDEO_SETTINGS_FLAGS'] = {}
GOPRO_VIDEO_SETTINGS_TV_MODE = 1 # 0=NTSC, 1=PAL.
enums['GOPRO_VIDEO_SETTINGS_FLAGS'][1] = EnumEntry('GOPRO_VIDEO_SETTINGS_TV_MODE', '''0=NTSC, 1=PAL.''')
GOPRO_VIDEO_SETTINGS_FLAGS_ENUM_END = 2 # 
enums['GOPRO_VIDEO_SETTINGS_FLAGS'][2] = EnumEntry('GOPRO_VIDEO_SETTINGS_FLAGS_ENUM_END', '''''')

# GOPRO_PHOTO_RESOLUTION
enums['GOPRO_PHOTO_RESOLUTION'] = {}
GOPRO_PHOTO_RESOLUTION_5MP_MEDIUM = 0 # 5MP Medium.
enums['GOPRO_PHOTO_RESOLUTION'][0] = EnumEntry('GOPRO_PHOTO_RESOLUTION_5MP_MEDIUM', '''5MP Medium.''')
GOPRO_PHOTO_RESOLUTION_7MP_MEDIUM = 1 # 7MP Medium.
enums['GOPRO_PHOTO_RESOLUTION'][1] = EnumEntry('GOPRO_PHOTO_RESOLUTION_7MP_MEDIUM', '''7MP Medium.''')
GOPRO_PHOTO_RESOLUTION_7MP_WIDE = 2 # 7MP Wide.
enums['GOPRO_PHOTO_RESOLUTION'][2] = EnumEntry('GOPRO_PHOTO_RESOLUTION_7MP_WIDE', '''7MP Wide.''')
GOPRO_PHOTO_RESOLUTION_10MP_WIDE = 3 # 10MP Wide.
enums['GOPRO_PHOTO_RESOLUTION'][3] = EnumEntry('GOPRO_PHOTO_RESOLUTION_10MP_WIDE', '''10MP Wide.''')
GOPRO_PHOTO_RESOLUTION_12MP_WIDE = 4 # 12MP Wide.
enums['GOPRO_PHOTO_RESOLUTION'][4] = EnumEntry('GOPRO_PHOTO_RESOLUTION_12MP_WIDE', '''12MP Wide.''')
GOPRO_PHOTO_RESOLUTION_ENUM_END = 5 # 
enums['GOPRO_PHOTO_RESOLUTION'][5] = EnumEntry('GOPRO_PHOTO_RESOLUTION_ENUM_END', '''''')

# GOPRO_PROTUNE_WHITE_BALANCE
enums['GOPRO_PROTUNE_WHITE_BALANCE'] = {}
GOPRO_PROTUNE_WHITE_BALANCE_AUTO = 0 # Auto.
enums['GOPRO_PROTUNE_WHITE_BALANCE'][0] = EnumEntry('GOPRO_PROTUNE_WHITE_BALANCE_AUTO', '''Auto.''')
GOPRO_PROTUNE_WHITE_BALANCE_3000K = 1 # 3000K.
enums['GOPRO_PROTUNE_WHITE_BALANCE'][1] = EnumEntry('GOPRO_PROTUNE_WHITE_BALANCE_3000K', '''3000K.''')
GOPRO_PROTUNE_WHITE_BALANCE_5500K = 2 # 5500K.
enums['GOPRO_PROTUNE_WHITE_BALANCE'][2] = EnumEntry('GOPRO_PROTUNE_WHITE_BALANCE_5500K', '''5500K.''')
GOPRO_PROTUNE_WHITE_BALANCE_6500K = 3 # 6500K.
enums['GOPRO_PROTUNE_WHITE_BALANCE'][3] = EnumEntry('GOPRO_PROTUNE_WHITE_BALANCE_6500K', '''6500K.''')
GOPRO_PROTUNE_WHITE_BALANCE_RAW = 4 # Camera Raw.
enums['GOPRO_PROTUNE_WHITE_BALANCE'][4] = EnumEntry('GOPRO_PROTUNE_WHITE_BALANCE_RAW', '''Camera Raw.''')
GOPRO_PROTUNE_WHITE_BALANCE_ENUM_END = 5 # 
enums['GOPRO_PROTUNE_WHITE_BALANCE'][5] = EnumEntry('GOPRO_PROTUNE_WHITE_BALANCE_ENUM_END', '''''')

# GOPRO_PROTUNE_COLOUR
enums['GOPRO_PROTUNE_COLOUR'] = {}
GOPRO_PROTUNE_COLOUR_STANDARD = 0 # Auto.
enums['GOPRO_PROTUNE_COLOUR'][0] = EnumEntry('GOPRO_PROTUNE_COLOUR_STANDARD', '''Auto.''')
GOPRO_PROTUNE_COLOUR_NEUTRAL = 1 # Neutral.
enums['GOPRO_PROTUNE_COLOUR'][1] = EnumEntry('GOPRO_PROTUNE_COLOUR_NEUTRAL', '''Neutral.''')
GOPRO_PROTUNE_COLOUR_ENUM_END = 2 # 
enums['GOPRO_PROTUNE_COLOUR'][2] = EnumEntry('GOPRO_PROTUNE_COLOUR_ENUM_END', '''''')

# GOPRO_PROTUNE_GAIN
enums['GOPRO_PROTUNE_GAIN'] = {}
GOPRO_PROTUNE_GAIN_400 = 0 # ISO 400.
enums['GOPRO_PROTUNE_GAIN'][0] = EnumEntry('GOPRO_PROTUNE_GAIN_400', '''ISO 400.''')
GOPRO_PROTUNE_GAIN_800 = 1 # ISO 800 (Only Hero 4).
enums['GOPRO_PROTUNE_GAIN'][1] = EnumEntry('GOPRO_PROTUNE_GAIN_800', '''ISO 800 (Only Hero 4).''')
GOPRO_PROTUNE_GAIN_1600 = 2 # ISO 1600.
enums['GOPRO_PROTUNE_GAIN'][2] = EnumEntry('GOPRO_PROTUNE_GAIN_1600', '''ISO 1600.''')
GOPRO_PROTUNE_GAIN_3200 = 3 # ISO 3200 (Only Hero 4).
enums['GOPRO_PROTUNE_GAIN'][3] = EnumEntry('GOPRO_PROTUNE_GAIN_3200', '''ISO 3200 (Only Hero 4).''')
GOPRO_PROTUNE_GAIN_6400 = 4 # ISO 6400.
enums['GOPRO_PROTUNE_GAIN'][4] = EnumEntry('GOPRO_PROTUNE_GAIN_6400', '''ISO 6400.''')
GOPRO_PROTUNE_GAIN_ENUM_END = 5 # 
enums['GOPRO_PROTUNE_GAIN'][5] = EnumEntry('GOPRO_PROTUNE_GAIN_ENUM_END', '''''')

# GOPRO_PROTUNE_SHARPNESS
enums['GOPRO_PROTUNE_SHARPNESS'] = {}
GOPRO_PROTUNE_SHARPNESS_LOW = 0 # Low Sharpness.
enums['GOPRO_PROTUNE_SHARPNESS'][0] = EnumEntry('GOPRO_PROTUNE_SHARPNESS_LOW', '''Low Sharpness.''')
GOPRO_PROTUNE_SHARPNESS_MEDIUM = 1 # Medium Sharpness.
enums['GOPRO_PROTUNE_SHARPNESS'][1] = EnumEntry('GOPRO_PROTUNE_SHARPNESS_MEDIUM', '''Medium Sharpness.''')
GOPRO_PROTUNE_SHARPNESS_HIGH = 2 # High Sharpness.
enums['GOPRO_PROTUNE_SHARPNESS'][2] = EnumEntry('GOPRO_PROTUNE_SHARPNESS_HIGH', '''High Sharpness.''')
GOPRO_PROTUNE_SHARPNESS_ENUM_END = 3 # 
enums['GOPRO_PROTUNE_SHARPNESS'][3] = EnumEntry('GOPRO_PROTUNE_SHARPNESS_ENUM_END', '''''')

# GOPRO_PROTUNE_EXPOSURE
enums['GOPRO_PROTUNE_EXPOSURE'] = {}
GOPRO_PROTUNE_EXPOSURE_NEG_5_0 = 0 # -5.0 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][0] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_5_0', '''-5.0 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_NEG_4_5 = 1 # -4.5 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][1] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_4_5', '''-4.5 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_NEG_4_0 = 2 # -4.0 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][2] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_4_0', '''-4.0 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_NEG_3_5 = 3 # -3.5 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][3] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_3_5', '''-3.5 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_NEG_3_0 = 4 # -3.0 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][4] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_3_0', '''-3.0 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_NEG_2_5 = 5 # -2.5 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][5] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_2_5', '''-2.5 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_NEG_2_0 = 6 # -2.0 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][6] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_2_0', '''-2.0 EV.''')
GOPRO_PROTUNE_EXPOSURE_NEG_1_5 = 7 # -1.5 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][7] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_1_5', '''-1.5 EV.''')
GOPRO_PROTUNE_EXPOSURE_NEG_1_0 = 8 # -1.0 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][8] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_1_0', '''-1.0 EV.''')
GOPRO_PROTUNE_EXPOSURE_NEG_0_5 = 9 # -0.5 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][9] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_NEG_0_5', '''-0.5 EV.''')
GOPRO_PROTUNE_EXPOSURE_ZERO = 10 # 0.0 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][10] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_ZERO', '''0.0 EV.''')
GOPRO_PROTUNE_EXPOSURE_POS_0_5 = 11 # +0.5 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][11] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_0_5', '''+0.5 EV.''')
GOPRO_PROTUNE_EXPOSURE_POS_1_0 = 12 # +1.0 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][12] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_1_0', '''+1.0 EV.''')
GOPRO_PROTUNE_EXPOSURE_POS_1_5 = 13 # +1.5 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][13] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_1_5', '''+1.5 EV.''')
GOPRO_PROTUNE_EXPOSURE_POS_2_0 = 14 # +2.0 EV.
enums['GOPRO_PROTUNE_EXPOSURE'][14] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_2_0', '''+2.0 EV.''')
GOPRO_PROTUNE_EXPOSURE_POS_2_5 = 15 # +2.5 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][15] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_2_5', '''+2.5 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_POS_3_0 = 16 # +3.0 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][16] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_3_0', '''+3.0 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_POS_3_5 = 17 # +3.5 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][17] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_3_5', '''+3.5 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_POS_4_0 = 18 # +4.0 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][18] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_4_0', '''+4.0 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_POS_4_5 = 19 # +4.5 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][19] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_4_5', '''+4.5 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_POS_5_0 = 20 # +5.0 EV (Hero 3+ Only).
enums['GOPRO_PROTUNE_EXPOSURE'][20] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_POS_5_0', '''+5.0 EV (Hero 3+ Only).''')
GOPRO_PROTUNE_EXPOSURE_ENUM_END = 21 # 
enums['GOPRO_PROTUNE_EXPOSURE'][21] = EnumEntry('GOPRO_PROTUNE_EXPOSURE_ENUM_END', '''''')

# GOPRO_CHARGING
enums['GOPRO_CHARGING'] = {}
GOPRO_CHARGING_DISABLED = 0 # Charging disabled.
enums['GOPRO_CHARGING'][0] = EnumEntry('GOPRO_CHARGING_DISABLED', '''Charging disabled.''')
GOPRO_CHARGING_ENABLED = 1 # Charging enabled.
enums['GOPRO_CHARGING'][1] = EnumEntry('GOPRO_CHARGING_ENABLED', '''Charging enabled.''')
GOPRO_CHARGING_ENUM_END = 2 # 
enums['GOPRO_CHARGING'][2] = EnumEntry('GOPRO_CHARGING_ENUM_END', '''''')

# GOPRO_MODEL
enums['GOPRO_MODEL'] = {}
GOPRO_MODEL_UNKNOWN = 0 # Unknown gopro model.
enums['GOPRO_MODEL'][0] = EnumEntry('GOPRO_MODEL_UNKNOWN', '''Unknown gopro model.''')
GOPRO_MODEL_HERO_3_PLUS_SILVER = 1 # Hero 3+ Silver (HeroBus not supported by GoPro).
enums['GOPRO_MODEL'][1] = EnumEntry('GOPRO_MODEL_HERO_3_PLUS_SILVER', '''Hero 3+ Silver (HeroBus not supported by GoPro).''')
GOPRO_MODEL_HERO_3_PLUS_BLACK = 2 # Hero 3+ Black.
enums['GOPRO_MODEL'][2] = EnumEntry('GOPRO_MODEL_HERO_3_PLUS_BLACK', '''Hero 3+ Black.''')
GOPRO_MODEL_HERO_4_SILVER = 3 # Hero 4 Silver.
enums['GOPRO_MODEL'][3] = EnumEntry('GOPRO_MODEL_HERO_4_SILVER', '''Hero 4 Silver.''')
GOPRO_MODEL_HERO_4_BLACK = 4 # Hero 4 Black.
enums['GOPRO_MODEL'][4] = EnumEntry('GOPRO_MODEL_HERO_4_BLACK', '''Hero 4 Black.''')
GOPRO_MODEL_ENUM_END = 5 # 
enums['GOPRO_MODEL'][5] = EnumEntry('GOPRO_MODEL_ENUM_END', '''''')

# GOPRO_BURST_RATE
enums['GOPRO_BURST_RATE'] = {}
GOPRO_BURST_RATE_3_IN_1_SECOND = 0 # 3 Shots / 1 Second.
enums['GOPRO_BURST_RATE'][0] = EnumEntry('GOPRO_BURST_RATE_3_IN_1_SECOND', '''3 Shots / 1 Second.''')
GOPRO_BURST_RATE_5_IN_1_SECOND = 1 # 5 Shots / 1 Second.
enums['GOPRO_BURST_RATE'][1] = EnumEntry('GOPRO_BURST_RATE_5_IN_1_SECOND', '''5 Shots / 1 Second.''')
GOPRO_BURST_RATE_10_IN_1_SECOND = 2 # 10 Shots / 1 Second.
enums['GOPRO_BURST_RATE'][2] = EnumEntry('GOPRO_BURST_RATE_10_IN_1_SECOND', '''10 Shots / 1 Second.''')
GOPRO_BURST_RATE_10_IN_2_SECOND = 3 # 10 Shots / 2 Second.
enums['GOPRO_BURST_RATE'][3] = EnumEntry('GOPRO_BURST_RATE_10_IN_2_SECOND', '''10 Shots / 2 Second.''')
GOPRO_BURST_RATE_10_IN_3_SECOND = 4 # 10 Shots / 3 Second (Hero 4 Only).
enums['GOPRO_BURST_RATE'][4] = EnumEntry('GOPRO_BURST_RATE_10_IN_3_SECOND', '''10 Shots / 3 Second (Hero 4 Only).''')
GOPRO_BURST_RATE_30_IN_1_SECOND = 5 # 30 Shots / 1 Second.
enums['GOPRO_BURST_RATE'][5] = EnumEntry('GOPRO_BURST_RATE_30_IN_1_SECOND', '''30 Shots / 1 Second.''')
GOPRO_BURST_RATE_30_IN_2_SECOND = 6 # 30 Shots / 2 Second.
enums['GOPRO_BURST_RATE'][6] = EnumEntry('GOPRO_BURST_RATE_30_IN_2_SECOND', '''30 Shots / 2 Second.''')
GOPRO_BURST_RATE_30_IN_3_SECOND = 7 # 30 Shots / 3 Second.
enums['GOPRO_BURST_RATE'][7] = EnumEntry('GOPRO_BURST_RATE_30_IN_3_SECOND', '''30 Shots / 3 Second.''')
GOPRO_BURST_RATE_30_IN_6_SECOND = 8 # 30 Shots / 6 Second.
enums['GOPRO_BURST_RATE'][8] = EnumEntry('GOPRO_BURST_RATE_30_IN_6_SECOND', '''30 Shots / 6 Second.''')
GOPRO_BURST_RATE_ENUM_END = 9 # 
enums['GOPRO_BURST_RATE'][9] = EnumEntry('GOPRO_BURST_RATE_ENUM_END', '''''')

# MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'] = {}
MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_LOW = 0 # Switch Low.
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0] = EnumEntry('MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_LOW', '''Switch Low.''')
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][0].param[7] = '''Reserved (default:0)'''
MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_MIDDLE = 1 # Switch Middle.
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1] = EnumEntry('MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_MIDDLE', '''Switch Middle.''')
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][1].param[7] = '''Reserved (default:0)'''
MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_HIGH = 2 # Switch High.
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2] = EnumEntry('MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_HIGH', '''Switch High.''')
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][2].param[7] = '''Reserved (default:0)'''
MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_ENUM_END = 3 # 
enums['MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL'][3] = EnumEntry('MAV_CMD_DO_AUX_FUNCTION_SWITCH_LEVEL_ENUM_END', '''''')

# LED_CONTROL_PATTERN
enums['LED_CONTROL_PATTERN'] = {}
LED_CONTROL_PATTERN_OFF = 0 # LED patterns off (return control to regular vehicle control).
enums['LED_CONTROL_PATTERN'][0] = EnumEntry('LED_CONTROL_PATTERN_OFF', '''LED patterns off (return control to regular vehicle control).''')
LED_CONTROL_PATTERN_FIRMWAREUPDATE = 1 # LEDs show pattern during firmware update.
enums['LED_CONTROL_PATTERN'][1] = EnumEntry('LED_CONTROL_PATTERN_FIRMWAREUPDATE', '''LEDs show pattern during firmware update.''')
LED_CONTROL_PATTERN_CUSTOM = 255 # Custom Pattern using custom bytes fields.
enums['LED_CONTROL_PATTERN'][255] = EnumEntry('LED_CONTROL_PATTERN_CUSTOM', '''Custom Pattern using custom bytes fields.''')
LED_CONTROL_PATTERN_ENUM_END = 256 # 
enums['LED_CONTROL_PATTERN'][256] = EnumEntry('LED_CONTROL_PATTERN_ENUM_END', '''''')

# EKF_STATUS_FLAGS
enums['EKF_STATUS_FLAGS'] = {}
EKF_ATTITUDE = 1 # Set if EKF's attitude estimate is good.
enums['EKF_STATUS_FLAGS'][1] = EnumEntry('EKF_ATTITUDE', '''Set if EKF's attitude estimate is good.''')
EKF_VELOCITY_HORIZ = 2 # Set if EKF's horizontal velocity estimate is good.
enums['EKF_STATUS_FLAGS'][2] = EnumEntry('EKF_VELOCITY_HORIZ', '''Set if EKF's horizontal velocity estimate is good.''')
EKF_VELOCITY_VERT = 4 # Set if EKF's vertical velocity estimate is good.
enums['EKF_STATUS_FLAGS'][4] = EnumEntry('EKF_VELOCITY_VERT', '''Set if EKF's vertical velocity estimate is good.''')
EKF_POS_HORIZ_REL = 8 # Set if EKF's horizontal position (relative) estimate is good.
enums['EKF_STATUS_FLAGS'][8] = EnumEntry('EKF_POS_HORIZ_REL', '''Set if EKF's horizontal position (relative) estimate is good.''')
EKF_POS_HORIZ_ABS = 16 # Set if EKF's horizontal position (absolute) estimate is good.
enums['EKF_STATUS_FLAGS'][16] = EnumEntry('EKF_POS_HORIZ_ABS', '''Set if EKF's horizontal position (absolute) estimate is good.''')
EKF_POS_VERT_ABS = 32 # Set if EKF's vertical position (absolute) estimate is good.
enums['EKF_STATUS_FLAGS'][32] = EnumEntry('EKF_POS_VERT_ABS', '''Set if EKF's vertical position (absolute) estimate is good.''')
EKF_POS_VERT_AGL = 64 # Set if EKF's vertical position (above ground) estimate is good.
enums['EKF_STATUS_FLAGS'][64] = EnumEntry('EKF_POS_VERT_AGL', '''Set if EKF's vertical position (above ground) estimate is good.''')
EKF_CONST_POS_MODE = 128 # EKF is in constant position mode and does not know it's absolute or
                        # relative position.
enums['EKF_STATUS_FLAGS'][128] = EnumEntry('EKF_CONST_POS_MODE', '''EKF is in constant position mode and does not know it's absolute or relative position.''')
EKF_PRED_POS_HORIZ_REL = 256 # Set if EKF's predicted horizontal position (relative) estimate is
                        # good.
enums['EKF_STATUS_FLAGS'][256] = EnumEntry('EKF_PRED_POS_HORIZ_REL', '''Set if EKF's predicted horizontal position (relative) estimate is good.''')
EKF_PRED_POS_HORIZ_ABS = 512 # Set if EKF's predicted horizontal position (absolute) estimate is
                        # good.
enums['EKF_STATUS_FLAGS'][512] = EnumEntry('EKF_PRED_POS_HORIZ_ABS', '''Set if EKF's predicted horizontal position (absolute) estimate is good.''')
EKF_UNINITIALIZED = 1024 # Set if EKF has never been healthy.
enums['EKF_STATUS_FLAGS'][1024] = EnumEntry('EKF_UNINITIALIZED', '''Set if EKF has never been healthy.''')
EKF_STATUS_FLAGS_ENUM_END = 1025 # 
enums['EKF_STATUS_FLAGS'][1025] = EnumEntry('EKF_STATUS_FLAGS_ENUM_END', '''''')

# PID_TUNING_AXIS
enums['PID_TUNING_AXIS'] = {}
PID_TUNING_ROLL = 1 # 
enums['PID_TUNING_AXIS'][1] = EnumEntry('PID_TUNING_ROLL', '''''')
PID_TUNING_PITCH = 2 # 
enums['PID_TUNING_AXIS'][2] = EnumEntry('PID_TUNING_PITCH', '''''')
PID_TUNING_YAW = 3 # 
enums['PID_TUNING_AXIS'][3] = EnumEntry('PID_TUNING_YAW', '''''')
PID_TUNING_ACCZ = 4 # 
enums['PID_TUNING_AXIS'][4] = EnumEntry('PID_TUNING_ACCZ', '''''')
PID_TUNING_STEER = 5 # 
enums['PID_TUNING_AXIS'][5] = EnumEntry('PID_TUNING_STEER', '''''')
PID_TUNING_LANDING = 6 # 
enums['PID_TUNING_AXIS'][6] = EnumEntry('PID_TUNING_LANDING', '''''')
PID_TUNING_AXIS_ENUM_END = 7 # 
enums['PID_TUNING_AXIS'][7] = EnumEntry('PID_TUNING_AXIS_ENUM_END', '''''')

# MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS
enums['MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS'] = {}
MAV_REMOTE_LOG_DATA_BLOCK_STOP = 2147483645 # UAV to stop sending DataFlash blocks.
enums['MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS'][2147483645] = EnumEntry('MAV_REMOTE_LOG_DATA_BLOCK_STOP', '''UAV to stop sending DataFlash blocks.''')
MAV_REMOTE_LOG_DATA_BLOCK_START = 2147483646 # UAV to start sending DataFlash blocks.
enums['MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS'][2147483646] = EnumEntry('MAV_REMOTE_LOG_DATA_BLOCK_START', '''UAV to start sending DataFlash blocks.''')
MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS_ENUM_END = 2147483647 # 
enums['MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS'][2147483647] = EnumEntry('MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS_ENUM_END', '''''')

# MAV_REMOTE_LOG_DATA_BLOCK_STATUSES
enums['MAV_REMOTE_LOG_DATA_BLOCK_STATUSES'] = {}
MAV_REMOTE_LOG_DATA_BLOCK_NACK = 0 # This block has NOT been received.
enums['MAV_REMOTE_LOG_DATA_BLOCK_STATUSES'][0] = EnumEntry('MAV_REMOTE_LOG_DATA_BLOCK_NACK', '''This block has NOT been received.''')
MAV_REMOTE_LOG_DATA_BLOCK_ACK = 1 # This block has been received.
enums['MAV_REMOTE_LOG_DATA_BLOCK_STATUSES'][1] = EnumEntry('MAV_REMOTE_LOG_DATA_BLOCK_ACK', '''This block has been received.''')
MAV_REMOTE_LOG_DATA_BLOCK_STATUSES_ENUM_END = 2 # 
enums['MAV_REMOTE_LOG_DATA_BLOCK_STATUSES'][2] = EnumEntry('MAV_REMOTE_LOG_DATA_BLOCK_STATUSES_ENUM_END', '''''')

# DEVICE_OP_BUSTYPE
enums['DEVICE_OP_BUSTYPE'] = {}
DEVICE_OP_BUSTYPE_I2C = 0 # I2C Device operation.
enums['DEVICE_OP_BUSTYPE'][0] = EnumEntry('DEVICE_OP_BUSTYPE_I2C', '''I2C Device operation.''')
DEVICE_OP_BUSTYPE_SPI = 1 # SPI Device operation.
enums['DEVICE_OP_BUSTYPE'][1] = EnumEntry('DEVICE_OP_BUSTYPE_SPI', '''SPI Device operation.''')
DEVICE_OP_BUSTYPE_ENUM_END = 2 # 
enums['DEVICE_OP_BUSTYPE'][2] = EnumEntry('DEVICE_OP_BUSTYPE_ENUM_END', '''''')

# DEEPSTALL_STAGE
enums['DEEPSTALL_STAGE'] = {}
DEEPSTALL_STAGE_FLY_TO_LANDING = 0 # Flying to the landing point.
enums['DEEPSTALL_STAGE'][0] = EnumEntry('DEEPSTALL_STAGE_FLY_TO_LANDING', '''Flying to the landing point.''')
DEEPSTALL_STAGE_ESTIMATE_WIND = 1 # Building an estimate of the wind.
enums['DEEPSTALL_STAGE'][1] = EnumEntry('DEEPSTALL_STAGE_ESTIMATE_WIND', '''Building an estimate of the wind.''')
DEEPSTALL_STAGE_WAIT_FOR_BREAKOUT = 2 # Waiting to breakout of the loiter to fly the approach.
enums['DEEPSTALL_STAGE'][2] = EnumEntry('DEEPSTALL_STAGE_WAIT_FOR_BREAKOUT', '''Waiting to breakout of the loiter to fly the approach.''')
DEEPSTALL_STAGE_FLY_TO_ARC = 3 # Flying to the first arc point to turn around to the landing point.
enums['DEEPSTALL_STAGE'][3] = EnumEntry('DEEPSTALL_STAGE_FLY_TO_ARC', '''Flying to the first arc point to turn around to the landing point.''')
DEEPSTALL_STAGE_ARC = 4 # Turning around back to the deepstall landing point.
enums['DEEPSTALL_STAGE'][4] = EnumEntry('DEEPSTALL_STAGE_ARC', '''Turning around back to the deepstall landing point.''')
DEEPSTALL_STAGE_APPROACH = 5 # Approaching the landing point.
enums['DEEPSTALL_STAGE'][5] = EnumEntry('DEEPSTALL_STAGE_APPROACH', '''Approaching the landing point.''')
DEEPSTALL_STAGE_LAND = 6 # Stalling and steering towards the land point.
enums['DEEPSTALL_STAGE'][6] = EnumEntry('DEEPSTALL_STAGE_LAND', '''Stalling and steering towards the land point.''')
DEEPSTALL_STAGE_ENUM_END = 7 # 
enums['DEEPSTALL_STAGE'][7] = EnumEntry('DEEPSTALL_STAGE_ENUM_END', '''''')

# PLANE_MODE
enums['PLANE_MODE'] = {}
PLANE_MODE_MANUAL = 0 # 
enums['PLANE_MODE'][0] = EnumEntry('PLANE_MODE_MANUAL', '''''')
PLANE_MODE_CIRCLE = 1 # 
enums['PLANE_MODE'][1] = EnumEntry('PLANE_MODE_CIRCLE', '''''')
PLANE_MODE_STABILIZE = 2 # 
enums['PLANE_MODE'][2] = EnumEntry('PLANE_MODE_STABILIZE', '''''')
PLANE_MODE_TRAINING = 3 # 
enums['PLANE_MODE'][3] = EnumEntry('PLANE_MODE_TRAINING', '''''')
PLANE_MODE_ACRO = 4 # 
enums['PLANE_MODE'][4] = EnumEntry('PLANE_MODE_ACRO', '''''')
PLANE_MODE_FLY_BY_WIRE_A = 5 # 
enums['PLANE_MODE'][5] = EnumEntry('PLANE_MODE_FLY_BY_WIRE_A', '''''')
PLANE_MODE_FLY_BY_WIRE_B = 6 # 
enums['PLANE_MODE'][6] = EnumEntry('PLANE_MODE_FLY_BY_WIRE_B', '''''')
PLANE_MODE_CRUISE = 7 # 
enums['PLANE_MODE'][7] = EnumEntry('PLANE_MODE_CRUISE', '''''')
PLANE_MODE_AUTOTUNE = 8 # 
enums['PLANE_MODE'][8] = EnumEntry('PLANE_MODE_AUTOTUNE', '''''')
PLANE_MODE_AUTO = 10 # 
enums['PLANE_MODE'][10] = EnumEntry('PLANE_MODE_AUTO', '''''')
PLANE_MODE_RTL = 11 # 
enums['PLANE_MODE'][11] = EnumEntry('PLANE_MODE_RTL', '''''')
PLANE_MODE_LOITER = 12 # 
enums['PLANE_MODE'][12] = EnumEntry('PLANE_MODE_LOITER', '''''')
PLANE_MODE_TAKEOFF = 13 # 
enums['PLANE_MODE'][13] = EnumEntry('PLANE_MODE_TAKEOFF', '''''')
PLANE_MODE_AVOID_ADSB = 14 # 
enums['PLANE_MODE'][14] = EnumEntry('PLANE_MODE_AVOID_ADSB', '''''')
PLANE_MODE_GUIDED = 15 # 
enums['PLANE_MODE'][15] = EnumEntry('PLANE_MODE_GUIDED', '''''')
PLANE_MODE_INITIALIZING = 16 # 
enums['PLANE_MODE'][16] = EnumEntry('PLANE_MODE_INITIALIZING', '''''')
PLANE_MODE_QSTABILIZE = 17 # 
enums['PLANE_MODE'][17] = EnumEntry('PLANE_MODE_QSTABILIZE', '''''')
PLANE_MODE_QHOVER = 18 # 
enums['PLANE_MODE'][18] = EnumEntry('PLANE_MODE_QHOVER', '''''')
PLANE_MODE_QLOITER = 19 # 
enums['PLANE_MODE'][19] = EnumEntry('PLANE_MODE_QLOITER', '''''')
PLANE_MODE_QLAND = 20 # 
enums['PLANE_MODE'][20] = EnumEntry('PLANE_MODE_QLAND', '''''')
PLANE_MODE_QRTL = 21 # 
enums['PLANE_MODE'][21] = EnumEntry('PLANE_MODE_QRTL', '''''')
PLANE_MODE_QAUTOTUNE = 22 # 
enums['PLANE_MODE'][22] = EnumEntry('PLANE_MODE_QAUTOTUNE', '''''')
PLANE_MODE_QACRO = 23 # 
enums['PLANE_MODE'][23] = EnumEntry('PLANE_MODE_QACRO', '''''')
PLANE_MODE_THERMAL = 24 # 
enums['PLANE_MODE'][24] = EnumEntry('PLANE_MODE_THERMAL', '''''')
PLANE_MODE_ENUM_END = 25 # 
enums['PLANE_MODE'][25] = EnumEntry('PLANE_MODE_ENUM_END', '''''')

# COPTER_MODE
enums['COPTER_MODE'] = {}
COPTER_MODE_STABILIZE = 0 # 
enums['COPTER_MODE'][0] = EnumEntry('COPTER_MODE_STABILIZE', '''''')
COPTER_MODE_ACRO = 1 # 
enums['COPTER_MODE'][1] = EnumEntry('COPTER_MODE_ACRO', '''''')
COPTER_MODE_ALT_HOLD = 2 # 
enums['COPTER_MODE'][2] = EnumEntry('COPTER_MODE_ALT_HOLD', '''''')
COPTER_MODE_AUTO = 3 # 
enums['COPTER_MODE'][3] = EnumEntry('COPTER_MODE_AUTO', '''''')
COPTER_MODE_GUIDED = 4 # 
enums['COPTER_MODE'][4] = EnumEntry('COPTER_MODE_GUIDED', '''''')
COPTER_MODE_LOITER = 5 # 
enums['COPTER_MODE'][5] = EnumEntry('COPTER_MODE_LOITER', '''''')
COPTER_MODE_RTL = 6 # 
enums['COPTER_MODE'][6] = EnumEntry('COPTER_MODE_RTL', '''''')
COPTER_MODE_CIRCLE = 7 # 
enums['COPTER_MODE'][7] = EnumEntry('COPTER_MODE_CIRCLE', '''''')
COPTER_MODE_LAND = 9 # 
enums['COPTER_MODE'][9] = EnumEntry('COPTER_MODE_LAND', '''''')
COPTER_MODE_DRIFT = 11 # 
enums['COPTER_MODE'][11] = EnumEntry('COPTER_MODE_DRIFT', '''''')
COPTER_MODE_SPORT = 13 # 
enums['COPTER_MODE'][13] = EnumEntry('COPTER_MODE_SPORT', '''''')
COPTER_MODE_FLIP = 14 # 
enums['COPTER_MODE'][14] = EnumEntry('COPTER_MODE_FLIP', '''''')
COPTER_MODE_AUTOTUNE = 15 # 
enums['COPTER_MODE'][15] = EnumEntry('COPTER_MODE_AUTOTUNE', '''''')
COPTER_MODE_POSHOLD = 16 # 
enums['COPTER_MODE'][16] = EnumEntry('COPTER_MODE_POSHOLD', '''''')
COPTER_MODE_BRAKE = 17 # 
enums['COPTER_MODE'][17] = EnumEntry('COPTER_MODE_BRAKE', '''''')
COPTER_MODE_THROW = 18 # 
enums['COPTER_MODE'][18] = EnumEntry('COPTER_MODE_THROW', '''''')
COPTER_MODE_AVOID_ADSB = 19 # 
enums['COPTER_MODE'][19] = EnumEntry('COPTER_MODE_AVOID_ADSB', '''''')
COPTER_MODE_GUIDED_NOGPS = 20 # 
enums['COPTER_MODE'][20] = EnumEntry('COPTER_MODE_GUIDED_NOGPS', '''''')
COPTER_MODE_SMART_RTL = 21 # 
enums['COPTER_MODE'][21] = EnumEntry('COPTER_MODE_SMART_RTL', '''''')
COPTER_MODE_FLOWHOLD = 22 # 
enums['COPTER_MODE'][22] = EnumEntry('COPTER_MODE_FLOWHOLD', '''''')
COPTER_MODE_FOLLOW = 23 # 
enums['COPTER_MODE'][23] = EnumEntry('COPTER_MODE_FOLLOW', '''''')
COPTER_MODE_ZIGZAG = 24 # 
enums['COPTER_MODE'][24] = EnumEntry('COPTER_MODE_ZIGZAG', '''''')
COPTER_MODE_SYSTEMID = 25 # 
enums['COPTER_MODE'][25] = EnumEntry('COPTER_MODE_SYSTEMID', '''''')
COPTER_MODE_AUTOROTATE = 26 # 
enums['COPTER_MODE'][26] = EnumEntry('COPTER_MODE_AUTOROTATE', '''''')
COPTER_MODE_AUTO_RTL = 27 # 
enums['COPTER_MODE'][27] = EnumEntry('COPTER_MODE_AUTO_RTL', '''''')
COPTER_MODE_ENUM_END = 28 # 
enums['COPTER_MODE'][28] = EnumEntry('COPTER_MODE_ENUM_END', '''''')

# SUB_MODE
enums['SUB_MODE'] = {}
SUB_MODE_STABILIZE = 0 # 
enums['SUB_MODE'][0] = EnumEntry('SUB_MODE_STABILIZE', '''''')
SUB_MODE_ACRO = 1 # 
enums['SUB_MODE'][1] = EnumEntry('SUB_MODE_ACRO', '''''')
SUB_MODE_ALT_HOLD = 2 # 
enums['SUB_MODE'][2] = EnumEntry('SUB_MODE_ALT_HOLD', '''''')
SUB_MODE_AUTO = 3 # 
enums['SUB_MODE'][3] = EnumEntry('SUB_MODE_AUTO', '''''')
SUB_MODE_GUIDED = 4 # 
enums['SUB_MODE'][4] = EnumEntry('SUB_MODE_GUIDED', '''''')
SUB_MODE_CIRCLE = 7 # 
enums['SUB_MODE'][7] = EnumEntry('SUB_MODE_CIRCLE', '''''')
SUB_MODE_SURFACE = 9 # 
enums['SUB_MODE'][9] = EnumEntry('SUB_MODE_SURFACE', '''''')
SUB_MODE_POSHOLD = 16 # 
enums['SUB_MODE'][16] = EnumEntry('SUB_MODE_POSHOLD', '''''')
SUB_MODE_MANUAL = 19 # 
enums['SUB_MODE'][19] = EnumEntry('SUB_MODE_MANUAL', '''''')
SUB_MODE_ENUM_END = 20 # 
enums['SUB_MODE'][20] = EnumEntry('SUB_MODE_ENUM_END', '''''')

# ROVER_MODE
enums['ROVER_MODE'] = {}
ROVER_MODE_MANUAL = 0 # 
enums['ROVER_MODE'][0] = EnumEntry('ROVER_MODE_MANUAL', '''''')
ROVER_MODE_ACRO = 1 # 
enums['ROVER_MODE'][1] = EnumEntry('ROVER_MODE_ACRO', '''''')
ROVER_MODE_STEERING = 3 # 
enums['ROVER_MODE'][3] = EnumEntry('ROVER_MODE_STEERING', '''''')
ROVER_MODE_HOLD = 4 # 
enums['ROVER_MODE'][4] = EnumEntry('ROVER_MODE_HOLD', '''''')
ROVER_MODE_LOITER = 5 # 
enums['ROVER_MODE'][5] = EnumEntry('ROVER_MODE_LOITER', '''''')
ROVER_MODE_FOLLOW = 6 # 
enums['ROVER_MODE'][6] = EnumEntry('ROVER_MODE_FOLLOW', '''''')
ROVER_MODE_SIMPLE = 7 # 
enums['ROVER_MODE'][7] = EnumEntry('ROVER_MODE_SIMPLE', '''''')
ROVER_MODE_AUTO = 10 # 
enums['ROVER_MODE'][10] = EnumEntry('ROVER_MODE_AUTO', '''''')
ROVER_MODE_RTL = 11 # 
enums['ROVER_MODE'][11] = EnumEntry('ROVER_MODE_RTL', '''''')
ROVER_MODE_SMART_RTL = 12 # 
enums['ROVER_MODE'][12] = EnumEntry('ROVER_MODE_SMART_RTL', '''''')
ROVER_MODE_GUIDED = 15 # 
enums['ROVER_MODE'][15] = EnumEntry('ROVER_MODE_GUIDED', '''''')
ROVER_MODE_INITIALIZING = 16 # 
enums['ROVER_MODE'][16] = EnumEntry('ROVER_MODE_INITIALIZING', '''''')
ROVER_MODE_ENUM_END = 17 # 
enums['ROVER_MODE'][17] = EnumEntry('ROVER_MODE_ENUM_END', '''''')

# TRACKER_MODE
enums['TRACKER_MODE'] = {}
TRACKER_MODE_MANUAL = 0 # 
enums['TRACKER_MODE'][0] = EnumEntry('TRACKER_MODE_MANUAL', '''''')
TRACKER_MODE_STOP = 1 # 
enums['TRACKER_MODE'][1] = EnumEntry('TRACKER_MODE_STOP', '''''')
TRACKER_MODE_SCAN = 2 # 
enums['TRACKER_MODE'][2] = EnumEntry('TRACKER_MODE_SCAN', '''''')
TRACKER_MODE_SERVO_TEST = 3 # 
enums['TRACKER_MODE'][3] = EnumEntry('TRACKER_MODE_SERVO_TEST', '''''')
TRACKER_MODE_AUTO = 10 # 
enums['TRACKER_MODE'][10] = EnumEntry('TRACKER_MODE_AUTO', '''''')
TRACKER_MODE_INITIALIZING = 16 # 
enums['TRACKER_MODE'][16] = EnumEntry('TRACKER_MODE_INITIALIZING', '''''')
TRACKER_MODE_ENUM_END = 17 # 
enums['TRACKER_MODE'][17] = EnumEntry('TRACKER_MODE_ENUM_END', '''''')

# OSD_PARAM_CONFIG_TYPE
enums['OSD_PARAM_CONFIG_TYPE'] = {}
OSD_PARAM_NONE = 0 # 
enums['OSD_PARAM_CONFIG_TYPE'][0] = EnumEntry('OSD_PARAM_NONE', '''''')
OSD_PARAM_SERIAL_PROTOCOL = 1 # 
enums['OSD_PARAM_CONFIG_TYPE'][1] = EnumEntry('OSD_PARAM_SERIAL_PROTOCOL', '''''')
OSD_PARAM_SERVO_FUNCTION = 2 # 
enums['OSD_PARAM_CONFIG_TYPE'][2] = EnumEntry('OSD_PARAM_SERVO_FUNCTION', '''''')
OSD_PARAM_AUX_FUNCTION = 3 # 
enums['OSD_PARAM_CONFIG_TYPE'][3] = EnumEntry('OSD_PARAM_AUX_FUNCTION', '''''')
OSD_PARAM_FLIGHT_MODE = 4 # 
enums['OSD_PARAM_CONFIG_TYPE'][4] = EnumEntry('OSD_PARAM_FLIGHT_MODE', '''''')
OSD_PARAM_FAILSAFE_ACTION = 5 # 
enums['OSD_PARAM_CONFIG_TYPE'][5] = EnumEntry('OSD_PARAM_FAILSAFE_ACTION', '''''')
OSD_PARAM_FAILSAFE_ACTION_1 = 6 # 
enums['OSD_PARAM_CONFIG_TYPE'][6] = EnumEntry('OSD_PARAM_FAILSAFE_ACTION_1', '''''')
OSD_PARAM_FAILSAFE_ACTION_2 = 7 # 
enums['OSD_PARAM_CONFIG_TYPE'][7] = EnumEntry('OSD_PARAM_FAILSAFE_ACTION_2', '''''')
OSD_PARAM_NUM_TYPES = 8 # 
enums['OSD_PARAM_CONFIG_TYPE'][8] = EnumEntry('OSD_PARAM_NUM_TYPES', '''''')
OSD_PARAM_CONFIG_TYPE_ENUM_END = 9 # 
enums['OSD_PARAM_CONFIG_TYPE'][9] = EnumEntry('OSD_PARAM_CONFIG_TYPE_ENUM_END', '''''')

# OSD_PARAM_CONFIG_ERROR
enums['OSD_PARAM_CONFIG_ERROR'] = {}
OSD_PARAM_SUCCESS = 0 # 
enums['OSD_PARAM_CONFIG_ERROR'][0] = EnumEntry('OSD_PARAM_SUCCESS', '''''')
OSD_PARAM_INVALID_SCREEN = 1 # 
enums['OSD_PARAM_CONFIG_ERROR'][1] = EnumEntry('OSD_PARAM_INVALID_SCREEN', '''''')
OSD_PARAM_INVALID_PARAMETER_INDEX = 2 # 
enums['OSD_PARAM_CONFIG_ERROR'][2] = EnumEntry('OSD_PARAM_INVALID_PARAMETER_INDEX', '''''')
OSD_PARAM_INVALID_PARAMETER = 3 # 
enums['OSD_PARAM_CONFIG_ERROR'][3] = EnumEntry('OSD_PARAM_INVALID_PARAMETER', '''''')
OSD_PARAM_CONFIG_ERROR_ENUM_END = 4 # 
enums['OSD_PARAM_CONFIG_ERROR'][4] = EnumEntry('OSD_PARAM_CONFIG_ERROR_ENUM_END', '''''')

# FIRMWARE_VERSION_TYPE
enums['FIRMWARE_VERSION_TYPE'] = {}
FIRMWARE_VERSION_TYPE_DEV = 0 # development release
enums['FIRMWARE_VERSION_TYPE'][0] = EnumEntry('FIRMWARE_VERSION_TYPE_DEV', '''development release''')
FIRMWARE_VERSION_TYPE_ALPHA = 64 # alpha release
enums['FIRMWARE_VERSION_TYPE'][64] = EnumEntry('FIRMWARE_VERSION_TYPE_ALPHA', '''alpha release''')
FIRMWARE_VERSION_TYPE_BETA = 128 # beta release
enums['FIRMWARE_VERSION_TYPE'][128] = EnumEntry('FIRMWARE_VERSION_TYPE_BETA', '''beta release''')
FIRMWARE_VERSION_TYPE_RC = 192 # release candidate
enums['FIRMWARE_VERSION_TYPE'][192] = EnumEntry('FIRMWARE_VERSION_TYPE_RC', '''release candidate''')
FIRMWARE_VERSION_TYPE_OFFICIAL = 255 # official stable release
enums['FIRMWARE_VERSION_TYPE'][255] = EnumEntry('FIRMWARE_VERSION_TYPE_OFFICIAL', '''official stable release''')
FIRMWARE_VERSION_TYPE_ENUM_END = 256 # 
enums['FIRMWARE_VERSION_TYPE'][256] = EnumEntry('FIRMWARE_VERSION_TYPE_ENUM_END', '''''')

# HL_FAILURE_FLAG
enums['HL_FAILURE_FLAG'] = {}
HL_FAILURE_FLAG_GPS = 1 # GPS failure.
enums['HL_FAILURE_FLAG'][1] = EnumEntry('HL_FAILURE_FLAG_GPS', '''GPS failure.''')
HL_FAILURE_FLAG_DIFFERENTIAL_PRESSURE = 2 # Differential pressure sensor failure.
enums['HL_FAILURE_FLAG'][2] = EnumEntry('HL_FAILURE_FLAG_DIFFERENTIAL_PRESSURE', '''Differential pressure sensor failure.''')
HL_FAILURE_FLAG_ABSOLUTE_PRESSURE = 4 # Absolute pressure sensor failure.
enums['HL_FAILURE_FLAG'][4] = EnumEntry('HL_FAILURE_FLAG_ABSOLUTE_PRESSURE', '''Absolute pressure sensor failure.''')
HL_FAILURE_FLAG_3D_ACCEL = 8 # Accelerometer sensor failure.
enums['HL_FAILURE_FLAG'][8] = EnumEntry('HL_FAILURE_FLAG_3D_ACCEL', '''Accelerometer sensor failure.''')
HL_FAILURE_FLAG_3D_GYRO = 16 # Gyroscope sensor failure.
enums['HL_FAILURE_FLAG'][16] = EnumEntry('HL_FAILURE_FLAG_3D_GYRO', '''Gyroscope sensor failure.''')
HL_FAILURE_FLAG_3D_MAG = 32 # Magnetometer sensor failure.
enums['HL_FAILURE_FLAG'][32] = EnumEntry('HL_FAILURE_FLAG_3D_MAG', '''Magnetometer sensor failure.''')
HL_FAILURE_FLAG_TERRAIN = 64 # Terrain subsystem failure.
enums['HL_FAILURE_FLAG'][64] = EnumEntry('HL_FAILURE_FLAG_TERRAIN', '''Terrain subsystem failure.''')
HL_FAILURE_FLAG_BATTERY = 128 # Battery failure/critical low battery.
enums['HL_FAILURE_FLAG'][128] = EnumEntry('HL_FAILURE_FLAG_BATTERY', '''Battery failure/critical low battery.''')
HL_FAILURE_FLAG_RC_RECEIVER = 256 # RC receiver failure/no rc connection.
enums['HL_FAILURE_FLAG'][256] = EnumEntry('HL_FAILURE_FLAG_RC_RECEIVER', '''RC receiver failure/no rc connection.''')
HL_FAILURE_FLAG_OFFBOARD_LINK = 512 # Offboard link failure.
enums['HL_FAILURE_FLAG'][512] = EnumEntry('HL_FAILURE_FLAG_OFFBOARD_LINK', '''Offboard link failure.''')
HL_FAILURE_FLAG_ENGINE = 1024 # Engine failure.
enums['HL_FAILURE_FLAG'][1024] = EnumEntry('HL_FAILURE_FLAG_ENGINE', '''Engine failure.''')
HL_FAILURE_FLAG_GEOFENCE = 2048 # Geofence violation.
enums['HL_FAILURE_FLAG'][2048] = EnumEntry('HL_FAILURE_FLAG_GEOFENCE', '''Geofence violation.''')
HL_FAILURE_FLAG_ESTIMATOR = 4096 # Estimator failure, for example measurement rejection or large
                        # variances.
enums['HL_FAILURE_FLAG'][4096] = EnumEntry('HL_FAILURE_FLAG_ESTIMATOR', '''Estimator failure, for example measurement rejection or large variances.''')
HL_FAILURE_FLAG_MISSION = 8192 # Mission failure.
enums['HL_FAILURE_FLAG'][8192] = EnumEntry('HL_FAILURE_FLAG_MISSION', '''Mission failure.''')
HL_FAILURE_FLAG_ENUM_END = 8193 # 
enums['HL_FAILURE_FLAG'][8193] = EnumEntry('HL_FAILURE_FLAG_ENUM_END', '''''')

# MAV_GOTO
enums['MAV_GOTO'] = {}
MAV_GOTO_DO_HOLD = 0 # Hold at the current position.
enums['MAV_GOTO'][0] = EnumEntry('MAV_GOTO_DO_HOLD', '''Hold at the current position.''')
MAV_GOTO_DO_CONTINUE = 1 # Continue with the next item in mission execution.
enums['MAV_GOTO'][1] = EnumEntry('MAV_GOTO_DO_CONTINUE', '''Continue with the next item in mission execution.''')
MAV_GOTO_HOLD_AT_CURRENT_POSITION = 2 # Hold at the current position of the system
enums['MAV_GOTO'][2] = EnumEntry('MAV_GOTO_HOLD_AT_CURRENT_POSITION', '''Hold at the current position of the system''')
MAV_GOTO_HOLD_AT_SPECIFIED_POSITION = 3 # Hold at the position specified in the parameters of the DO_HOLD action
enums['MAV_GOTO'][3] = EnumEntry('MAV_GOTO_HOLD_AT_SPECIFIED_POSITION', '''Hold at the position specified in the parameters of the DO_HOLD action''')
MAV_GOTO_ENUM_END = 4 # 
enums['MAV_GOTO'][4] = EnumEntry('MAV_GOTO_ENUM_END', '''''')

# MAV_MODE
enums['MAV_MODE'] = {}
MAV_MODE_PREFLIGHT = 0 # System is not ready to fly, booting, calibrating, etc. No flag is set.
enums['MAV_MODE'][0] = EnumEntry('MAV_MODE_PREFLIGHT', '''System is not ready to fly, booting, calibrating, etc. No flag is set.''')
MAV_MODE_MANUAL_DISARMED = 64 # System is allowed to be active, under manual (RC) control, no
                        # stabilization
enums['MAV_MODE'][64] = EnumEntry('MAV_MODE_MANUAL_DISARMED', '''System is allowed to be active, under manual (RC) control, no stabilization''')
MAV_MODE_TEST_DISARMED = 66 # UNDEFINED mode. This solely depends on the autopilot - use with
                        # caution, intended for developers only.
enums['MAV_MODE'][66] = EnumEntry('MAV_MODE_TEST_DISARMED', '''UNDEFINED mode. This solely depends on the autopilot - use with caution, intended for developers only.''')
MAV_MODE_STABILIZE_DISARMED = 80 # System is allowed to be active, under assisted RC control.
enums['MAV_MODE'][80] = EnumEntry('MAV_MODE_STABILIZE_DISARMED', '''System is allowed to be active, under assisted RC control.''')
MAV_MODE_GUIDED_DISARMED = 88 # System is allowed to be active, under autonomous control, manual
                        # setpoint
enums['MAV_MODE'][88] = EnumEntry('MAV_MODE_GUIDED_DISARMED', '''System is allowed to be active, under autonomous control, manual setpoint''')
MAV_MODE_AUTO_DISARMED = 92 # System is allowed to be active, under autonomous control and
                        # navigation (the trajectory is decided
                        # onboard and not pre-programmed by waypoints)
enums['MAV_MODE'][92] = EnumEntry('MAV_MODE_AUTO_DISARMED', '''System is allowed to be active, under autonomous control and navigation (the trajectory is decided onboard and not pre-programmed by waypoints)''')
MAV_MODE_MANUAL_ARMED = 192 # System is allowed to be active, under manual (RC) control, no
                        # stabilization
enums['MAV_MODE'][192] = EnumEntry('MAV_MODE_MANUAL_ARMED', '''System is allowed to be active, under manual (RC) control, no stabilization''')
MAV_MODE_TEST_ARMED = 194 # UNDEFINED mode. This solely depends on the autopilot - use with
                        # caution, intended for developers only.
enums['MAV_MODE'][194] = EnumEntry('MAV_MODE_TEST_ARMED', '''UNDEFINED mode. This solely depends on the autopilot - use with caution, intended for developers only.''')
MAV_MODE_STABILIZE_ARMED = 208 # System is allowed to be active, under assisted RC control.
enums['MAV_MODE'][208] = EnumEntry('MAV_MODE_STABILIZE_ARMED', '''System is allowed to be active, under assisted RC control.''')
MAV_MODE_GUIDED_ARMED = 216 # System is allowed to be active, under autonomous control, manual
                        # setpoint
enums['MAV_MODE'][216] = EnumEntry('MAV_MODE_GUIDED_ARMED', '''System is allowed to be active, under autonomous control, manual setpoint''')
MAV_MODE_AUTO_ARMED = 220 # System is allowed to be active, under autonomous control and
                        # navigation (the trajectory is decided
                        # onboard and not pre-programmed by waypoints)
enums['MAV_MODE'][220] = EnumEntry('MAV_MODE_AUTO_ARMED', '''System is allowed to be active, under autonomous control and navigation (the trajectory is decided onboard and not pre-programmed by waypoints)''')
MAV_MODE_ENUM_END = 221 # 
enums['MAV_MODE'][221] = EnumEntry('MAV_MODE_ENUM_END', '''''')

# MAV_SYS_STATUS_SENSOR
enums['MAV_SYS_STATUS_SENSOR'] = {}
MAV_SYS_STATUS_SENSOR_3D_GYRO = 1 # 0x01 3D gyro
enums['MAV_SYS_STATUS_SENSOR'][1] = EnumEntry('MAV_SYS_STATUS_SENSOR_3D_GYRO', '''0x01 3D gyro''')
MAV_SYS_STATUS_SENSOR_3D_ACCEL = 2 # 0x02 3D accelerometer
enums['MAV_SYS_STATUS_SENSOR'][2] = EnumEntry('MAV_SYS_STATUS_SENSOR_3D_ACCEL', '''0x02 3D accelerometer''')
MAV_SYS_STATUS_SENSOR_3D_MAG = 4 # 0x04 3D magnetometer
enums['MAV_SYS_STATUS_SENSOR'][4] = EnumEntry('MAV_SYS_STATUS_SENSOR_3D_MAG', '''0x04 3D magnetometer''')
MAV_SYS_STATUS_SENSOR_ABSOLUTE_PRESSURE = 8 # 0x08 absolute pressure
enums['MAV_SYS_STATUS_SENSOR'][8] = EnumEntry('MAV_SYS_STATUS_SENSOR_ABSOLUTE_PRESSURE', '''0x08 absolute pressure''')
MAV_SYS_STATUS_SENSOR_DIFFERENTIAL_PRESSURE = 16 # 0x10 differential pressure
enums['MAV_SYS_STATUS_SENSOR'][16] = EnumEntry('MAV_SYS_STATUS_SENSOR_DIFFERENTIAL_PRESSURE', '''0x10 differential pressure''')
MAV_SYS_STATUS_SENSOR_GPS = 32 # 0x20 GPS
enums['MAV_SYS_STATUS_SENSOR'][32] = EnumEntry('MAV_SYS_STATUS_SENSOR_GPS', '''0x20 GPS''')
MAV_SYS_STATUS_SENSOR_OPTICAL_FLOW = 64 # 0x40 optical flow
enums['MAV_SYS_STATUS_SENSOR'][64] = EnumEntry('MAV_SYS_STATUS_SENSOR_OPTICAL_FLOW', '''0x40 optical flow''')
MAV_SYS_STATUS_SENSOR_VISION_POSITION = 128 # 0x80 computer vision position
enums['MAV_SYS_STATUS_SENSOR'][128] = EnumEntry('MAV_SYS_STATUS_SENSOR_VISION_POSITION', '''0x80 computer vision position''')
MAV_SYS_STATUS_SENSOR_LASER_POSITION = 256 # 0x100 laser based position
enums['MAV_SYS_STATUS_SENSOR'][256] = EnumEntry('MAV_SYS_STATUS_SENSOR_LASER_POSITION', '''0x100 laser based position''')
MAV_SYS_STATUS_SENSOR_EXTERNAL_GROUND_TRUTH = 512 # 0x200 external ground truth (Vicon or Leica)
enums['MAV_SYS_STATUS_SENSOR'][512] = EnumEntry('MAV_SYS_STATUS_SENSOR_EXTERNAL_GROUND_TRUTH', '''0x200 external ground truth (Vicon or Leica)''')
MAV_SYS_STATUS_SENSOR_ANGULAR_RATE_CONTROL = 1024 # 0x400 3D angular rate control
enums['MAV_SYS_STATUS_SENSOR'][1024] = EnumEntry('MAV_SYS_STATUS_SENSOR_ANGULAR_RATE_CONTROL', '''0x400 3D angular rate control''')
MAV_SYS_STATUS_SENSOR_ATTITUDE_STABILIZATION = 2048 # 0x800 attitude stabilization
enums['MAV_SYS_STATUS_SENSOR'][2048] = EnumEntry('MAV_SYS_STATUS_SENSOR_ATTITUDE_STABILIZATION', '''0x800 attitude stabilization''')
MAV_SYS_STATUS_SENSOR_YAW_POSITION = 4096 # 0x1000 yaw position
enums['MAV_SYS_STATUS_SENSOR'][4096] = EnumEntry('MAV_SYS_STATUS_SENSOR_YAW_POSITION', '''0x1000 yaw position''')
MAV_SYS_STATUS_SENSOR_Z_ALTITUDE_CONTROL = 8192 # 0x2000 z/altitude control
enums['MAV_SYS_STATUS_SENSOR'][8192] = EnumEntry('MAV_SYS_STATUS_SENSOR_Z_ALTITUDE_CONTROL', '''0x2000 z/altitude control''')
MAV_SYS_STATUS_SENSOR_XY_POSITION_CONTROL = 16384 # 0x4000 x/y position control
enums['MAV_SYS_STATUS_SENSOR'][16384] = EnumEntry('MAV_SYS_STATUS_SENSOR_XY_POSITION_CONTROL', '''0x4000 x/y position control''')
MAV_SYS_STATUS_SENSOR_MOTOR_OUTPUTS = 32768 # 0x8000 motor outputs / control
enums['MAV_SYS_STATUS_SENSOR'][32768] = EnumEntry('MAV_SYS_STATUS_SENSOR_MOTOR_OUTPUTS', '''0x8000 motor outputs / control''')
MAV_SYS_STATUS_SENSOR_RC_RECEIVER = 65536 # 0x10000 rc receiver
enums['MAV_SYS_STATUS_SENSOR'][65536] = EnumEntry('MAV_SYS_STATUS_SENSOR_RC_RECEIVER', '''0x10000 rc receiver''')
MAV_SYS_STATUS_SENSOR_3D_GYRO2 = 131072 # 0x20000 2nd 3D gyro
enums['MAV_SYS_STATUS_SENSOR'][131072] = EnumEntry('MAV_SYS_STATUS_SENSOR_3D_GYRO2', '''0x20000 2nd 3D gyro''')
MAV_SYS_STATUS_SENSOR_3D_ACCEL2 = 262144 # 0x40000 2nd 3D accelerometer
enums['MAV_SYS_STATUS_SENSOR'][262144] = EnumEntry('MAV_SYS_STATUS_SENSOR_3D_ACCEL2', '''0x40000 2nd 3D accelerometer''')
MAV_SYS_STATUS_SENSOR_3D_MAG2 = 524288 # 0x80000 2nd 3D magnetometer
enums['MAV_SYS_STATUS_SENSOR'][524288] = EnumEntry('MAV_SYS_STATUS_SENSOR_3D_MAG2', '''0x80000 2nd 3D magnetometer''')
MAV_SYS_STATUS_GEOFENCE = 1048576 # 0x100000 geofence
enums['MAV_SYS_STATUS_SENSOR'][1048576] = EnumEntry('MAV_SYS_STATUS_GEOFENCE', '''0x100000 geofence''')
MAV_SYS_STATUS_AHRS = 2097152 # 0x200000 AHRS subsystem health
enums['MAV_SYS_STATUS_SENSOR'][2097152] = EnumEntry('MAV_SYS_STATUS_AHRS', '''0x200000 AHRS subsystem health''')
MAV_SYS_STATUS_TERRAIN = 4194304 # 0x400000 Terrain subsystem health
enums['MAV_SYS_STATUS_SENSOR'][4194304] = EnumEntry('MAV_SYS_STATUS_TERRAIN', '''0x400000 Terrain subsystem health''')
MAV_SYS_STATUS_REVERSE_MOTOR = 8388608 # 0x800000 Motors are reversed
enums['MAV_SYS_STATUS_SENSOR'][8388608] = EnumEntry('MAV_SYS_STATUS_REVERSE_MOTOR', '''0x800000 Motors are reversed''')
MAV_SYS_STATUS_LOGGING = 16777216 # 0x1000000 Logging
enums['MAV_SYS_STATUS_SENSOR'][16777216] = EnumEntry('MAV_SYS_STATUS_LOGGING', '''0x1000000 Logging''')
MAV_SYS_STATUS_SENSOR_BATTERY = 33554432 # 0x2000000 Battery
enums['MAV_SYS_STATUS_SENSOR'][33554432] = EnumEntry('MAV_SYS_STATUS_SENSOR_BATTERY', '''0x2000000 Battery''')
MAV_SYS_STATUS_SENSOR_PROXIMITY = 67108864 # 0x4000000 Proximity
enums['MAV_SYS_STATUS_SENSOR'][67108864] = EnumEntry('MAV_SYS_STATUS_SENSOR_PROXIMITY', '''0x4000000 Proximity''')
MAV_SYS_STATUS_SENSOR_SATCOM = 134217728 # 0x8000000 Satellite Communication
enums['MAV_SYS_STATUS_SENSOR'][134217728] = EnumEntry('MAV_SYS_STATUS_SENSOR_SATCOM', '''0x8000000 Satellite Communication ''')
MAV_SYS_STATUS_PREARM_CHECK = 268435456 # 0x10000000 pre-arm check status. Always healthy when armed
enums['MAV_SYS_STATUS_SENSOR'][268435456] = EnumEntry('MAV_SYS_STATUS_PREARM_CHECK', '''0x10000000 pre-arm check status. Always healthy when armed''')
MAV_SYS_STATUS_OBSTACLE_AVOIDANCE = 536870912 # 0x20000000 Avoidance/collision prevention
enums['MAV_SYS_STATUS_SENSOR'][536870912] = EnumEntry('MAV_SYS_STATUS_OBSTACLE_AVOIDANCE', '''0x20000000 Avoidance/collision prevention''')
MAV_SYS_STATUS_SENSOR_PROPULSION = 1073741824 # 0x40000000 propulsion (actuator, esc, motor or propellor)
enums['MAV_SYS_STATUS_SENSOR'][1073741824] = EnumEntry('MAV_SYS_STATUS_SENSOR_PROPULSION', '''0x40000000 propulsion (actuator, esc, motor or propellor)''')
MAV_SYS_STATUS_SENSOR_ENUM_END = 1073741825 # 
enums['MAV_SYS_STATUS_SENSOR'][1073741825] = EnumEntry('MAV_SYS_STATUS_SENSOR_ENUM_END', '''''')

# MAV_FRAME
enums['MAV_FRAME'] = {}
MAV_FRAME_GLOBAL = 0 # Global (WGS84) coordinate frame + MSL altitude. First value / x:
                        # latitude, second value / y: longitude, third
                        # value / z: positive altitude over mean sea
                        # level (MSL).
enums['MAV_FRAME'][0] = EnumEntry('MAV_FRAME_GLOBAL', '''Global (WGS84) coordinate frame + MSL altitude. First value / x: latitude, second value / y: longitude, third value / z: positive altitude over mean sea level (MSL).''')
MAV_FRAME_LOCAL_NED = 1 # Local coordinate frame, Z-down (x: North, y: East, z: Down).
enums['MAV_FRAME'][1] = EnumEntry('MAV_FRAME_LOCAL_NED', '''Local coordinate frame, Z-down (x: North, y: East, z: Down).''')
MAV_FRAME_MISSION = 2 # NOT a coordinate frame, indicates a mission command.
enums['MAV_FRAME'][2] = EnumEntry('MAV_FRAME_MISSION', '''NOT a coordinate frame, indicates a mission command.''')
MAV_FRAME_GLOBAL_RELATIVE_ALT = 3 # Global (WGS84) coordinate frame + altitude relative to the home
                        # position. First value / x: latitude, second
                        # value / y: longitude, third value / z:
                        # positive altitude with 0 being at the
                        # altitude of the home location.
enums['MAV_FRAME'][3] = EnumEntry('MAV_FRAME_GLOBAL_RELATIVE_ALT', '''Global (WGS84) coordinate frame + altitude relative to the home position. First value / x: latitude, second value / y: longitude, third value / z: positive altitude with 0 being at the altitude of the home location.''')
MAV_FRAME_LOCAL_ENU = 4 # Local coordinate frame, Z-up (x: East, y: North, z: Up).
enums['MAV_FRAME'][4] = EnumEntry('MAV_FRAME_LOCAL_ENU', '''Local coordinate frame, Z-up (x: East, y: North, z: Up).''')
MAV_FRAME_GLOBAL_INT = 5 # Global (WGS84) coordinate frame (scaled) + MSL altitude. First value /
                        # x: latitude in degrees*1.0e-7, second value
                        # / y: longitude in degrees*1.0e-7, third
                        # value / z: positive altitude over mean sea
                        # level (MSL).
enums['MAV_FRAME'][5] = EnumEntry('MAV_FRAME_GLOBAL_INT', '''Global (WGS84) coordinate frame (scaled) + MSL altitude. First value / x: latitude in degrees*1.0e-7, second value / y: longitude in degrees*1.0e-7, third value / z: positive altitude over mean sea level (MSL).''')
MAV_FRAME_GLOBAL_RELATIVE_ALT_INT = 6 # Global (WGS84) coordinate frame (scaled) + altitude relative to the
                        # home position. First value / x: latitude in
                        # degrees*10e-7, second value / y: longitude
                        # in degrees*10e-7, third value / z: positive
                        # altitude with 0 being at the altitude of the
                        # home location.
enums['MAV_FRAME'][6] = EnumEntry('MAV_FRAME_GLOBAL_RELATIVE_ALT_INT', '''Global (WGS84) coordinate frame (scaled) + altitude relative to the home position. First value / x: latitude in degrees*10e-7, second value / y: longitude in degrees*10e-7, third value / z: positive altitude with 0 being at the altitude of the home location.''')
MAV_FRAME_LOCAL_OFFSET_NED = 7 # Offset to the current local frame. Anything expressed in this frame
                        # should be added to the current local frame
                        # position.
enums['MAV_FRAME'][7] = EnumEntry('MAV_FRAME_LOCAL_OFFSET_NED', '''Offset to the current local frame. Anything expressed in this frame should be added to the current local frame position.''')
MAV_FRAME_BODY_NED = 8 # Setpoint in body NED frame. This makes sense if all position control
                        # is externalized - e.g. useful to command 2
                        # m/s^2 acceleration to the right.
enums['MAV_FRAME'][8] = EnumEntry('MAV_FRAME_BODY_NED', '''Setpoint in body NED frame. This makes sense if all position control is externalized - e.g. useful to command 2 m/s^2 acceleration to the right.''')
MAV_FRAME_BODY_OFFSET_NED = 9 # Offset in body NED frame. This makes sense if adding setpoints to the
                        # current flight path, to avoid an obstacle -
                        # e.g. useful to command 2 m/s^2 acceleration
                        # to the east.
enums['MAV_FRAME'][9] = EnumEntry('MAV_FRAME_BODY_OFFSET_NED', '''Offset in body NED frame. This makes sense if adding setpoints to the current flight path, to avoid an obstacle - e.g. useful to command 2 m/s^2 acceleration to the east.''')
MAV_FRAME_GLOBAL_TERRAIN_ALT = 10 # Global (WGS84) coordinate frame with AGL altitude (at the waypoint
                        # coordinate). First value / x: latitude in
                        # degrees, second value / y: longitude in
                        # degrees, third value / z: positive altitude
                        # in meters with 0 being at ground level in
                        # terrain model.
enums['MAV_FRAME'][10] = EnumEntry('MAV_FRAME_GLOBAL_TERRAIN_ALT', '''Global (WGS84) coordinate frame with AGL altitude (at the waypoint coordinate). First value / x: latitude in degrees, second value / y: longitude in degrees, third value / z: positive altitude in meters with 0 being at ground level in terrain model.''')
MAV_FRAME_GLOBAL_TERRAIN_ALT_INT = 11 # Global (WGS84) coordinate frame (scaled) with AGL altitude (at the
                        # waypoint coordinate). First value / x:
                        # latitude in degrees*10e-7, second value / y:
                        # longitude in degrees*10e-7, third value / z:
                        # positive altitude in meters with 0 being at
                        # ground level in terrain model.
enums['MAV_FRAME'][11] = EnumEntry('MAV_FRAME_GLOBAL_TERRAIN_ALT_INT', '''Global (WGS84) coordinate frame (scaled) with AGL altitude (at the waypoint coordinate). First value / x: latitude in degrees*10e-7, second value / y: longitude in degrees*10e-7, third value / z: positive altitude in meters with 0 being at ground level in terrain model.''')
MAV_FRAME_BODY_FRD = 12 # Body fixed frame of reference, Z-down (x: Forward, y: Right, z: Down).
enums['MAV_FRAME'][12] = EnumEntry('MAV_FRAME_BODY_FRD', '''Body fixed frame of reference, Z-down (x: Forward, y: Right, z: Down).''')
MAV_FRAME_RESERVED_13 = 13 # MAV_FRAME_BODY_FLU - Body fixed frame of reference, Z-up (x: Forward,
                        # y: Left, z: Up).
enums['MAV_FRAME'][13] = EnumEntry('MAV_FRAME_RESERVED_13', '''MAV_FRAME_BODY_FLU - Body fixed frame of reference, Z-up (x: Forward, y: Left, z: Up).''')
MAV_FRAME_RESERVED_14 = 14 # MAV_FRAME_MOCAP_NED - Odometry local coordinate frame of data given by
                        # a motion capture system, Z-down (x: North,
                        # y: East, z: Down).
enums['MAV_FRAME'][14] = EnumEntry('MAV_FRAME_RESERVED_14', '''MAV_FRAME_MOCAP_NED - Odometry local coordinate frame of data given by a motion capture system, Z-down (x: North, y: East, z: Down).''')
MAV_FRAME_RESERVED_15 = 15 # MAV_FRAME_MOCAP_ENU - Odometry local coordinate frame of data given by
                        # a motion capture system, Z-up (x: East, y:
                        # North, z: Up).
enums['MAV_FRAME'][15] = EnumEntry('MAV_FRAME_RESERVED_15', '''MAV_FRAME_MOCAP_ENU - Odometry local coordinate frame of data given by a motion capture system, Z-up (x: East, y: North, z: Up).''')
MAV_FRAME_RESERVED_16 = 16 # MAV_FRAME_VISION_NED - Odometry local coordinate frame of data given
                        # by a vision estimation system, Z-down (x:
                        # North, y: East, z: Down).
enums['MAV_FRAME'][16] = EnumEntry('MAV_FRAME_RESERVED_16', '''MAV_FRAME_VISION_NED - Odometry local coordinate frame of data given by a vision estimation system, Z-down (x: North, y: East, z: Down).''')
MAV_FRAME_RESERVED_17 = 17 # MAV_FRAME_VISION_ENU - Odometry local coordinate frame of data given
                        # by a vision estimation system, Z-up (x:
                        # East, y: North, z: Up).
enums['MAV_FRAME'][17] = EnumEntry('MAV_FRAME_RESERVED_17', '''MAV_FRAME_VISION_ENU - Odometry local coordinate frame of data given by a vision estimation system, Z-up (x: East, y: North, z: Up).''')
MAV_FRAME_RESERVED_18 = 18 # MAV_FRAME_ESTIM_NED - Odometry local coordinate frame of data given by
                        # an estimator running onboard the vehicle,
                        # Z-down (x: North, y: East, z: Down).
enums['MAV_FRAME'][18] = EnumEntry('MAV_FRAME_RESERVED_18', '''MAV_FRAME_ESTIM_NED - Odometry local coordinate frame of data given by an estimator running onboard the vehicle, Z-down (x: North, y: East, z: Down).''')
MAV_FRAME_RESERVED_19 = 19 # MAV_FRAME_ESTIM_ENU - Odometry local coordinate frame of data given by
                        # an estimator running onboard the vehicle,
                        # Z-up (x: East, y: North, z: Up).
enums['MAV_FRAME'][19] = EnumEntry('MAV_FRAME_RESERVED_19', '''MAV_FRAME_ESTIM_ENU - Odometry local coordinate frame of data given by an estimator running onboard the vehicle, Z-up (x: East, y: North, z: Up).''')
MAV_FRAME_LOCAL_FRD = 20 # Forward, Right, Down coordinate frame. This is a local frame with
                        # Z-down and arbitrary F/R alignment (i.e. not
                        # aligned with NED/earth frame).
enums['MAV_FRAME'][20] = EnumEntry('MAV_FRAME_LOCAL_FRD', '''Forward, Right, Down coordinate frame. This is a local frame with Z-down and arbitrary F/R alignment (i.e. not aligned with NED/earth frame).''')
MAV_FRAME_LOCAL_FLU = 21 # Forward, Left, Up coordinate frame. This is a local frame with Z-up
                        # and arbitrary F/L alignment (i.e. not
                        # aligned with ENU/earth frame).
enums['MAV_FRAME'][21] = EnumEntry('MAV_FRAME_LOCAL_FLU', '''Forward, Left, Up coordinate frame. This is a local frame with Z-up and arbitrary F/L alignment (i.e. not aligned with ENU/earth frame).''')
MAV_FRAME_ENUM_END = 22 # 
enums['MAV_FRAME'][22] = EnumEntry('MAV_FRAME_ENUM_END', '''''')

# MAVLINK_DATA_STREAM_TYPE
enums['MAVLINK_DATA_STREAM_TYPE'] = {}
MAVLINK_DATA_STREAM_IMG_JPEG = 0 # 
enums['MAVLINK_DATA_STREAM_TYPE'][0] = EnumEntry('MAVLINK_DATA_STREAM_IMG_JPEG', '''''')
MAVLINK_DATA_STREAM_IMG_BMP = 1 # 
enums['MAVLINK_DATA_STREAM_TYPE'][1] = EnumEntry('MAVLINK_DATA_STREAM_IMG_BMP', '''''')
MAVLINK_DATA_STREAM_IMG_RAW8U = 2 # 
enums['MAVLINK_DATA_STREAM_TYPE'][2] = EnumEntry('MAVLINK_DATA_STREAM_IMG_RAW8U', '''''')
MAVLINK_DATA_STREAM_IMG_RAW32U = 3 # 
enums['MAVLINK_DATA_STREAM_TYPE'][3] = EnumEntry('MAVLINK_DATA_STREAM_IMG_RAW32U', '''''')
MAVLINK_DATA_STREAM_IMG_PGM = 4 # 
enums['MAVLINK_DATA_STREAM_TYPE'][4] = EnumEntry('MAVLINK_DATA_STREAM_IMG_PGM', '''''')
MAVLINK_DATA_STREAM_IMG_PNG = 5 # 
enums['MAVLINK_DATA_STREAM_TYPE'][5] = EnumEntry('MAVLINK_DATA_STREAM_IMG_PNG', '''''')
MAVLINK_DATA_STREAM_TYPE_ENUM_END = 6 # 
enums['MAVLINK_DATA_STREAM_TYPE'][6] = EnumEntry('MAVLINK_DATA_STREAM_TYPE_ENUM_END', '''''')

# FENCE_ACTION
enums['FENCE_ACTION'] = {}
FENCE_ACTION_NONE = 0 # Disable fenced mode
enums['FENCE_ACTION'][0] = EnumEntry('FENCE_ACTION_NONE', '''Disable fenced mode''')
FENCE_ACTION_GUIDED = 1 # Switched to guided mode to return point (fence point 0)
enums['FENCE_ACTION'][1] = EnumEntry('FENCE_ACTION_GUIDED', '''Switched to guided mode to return point (fence point 0)''')
FENCE_ACTION_REPORT = 2 # Report fence breach, but don't take action
enums['FENCE_ACTION'][2] = EnumEntry('FENCE_ACTION_REPORT', '''Report fence breach, but don't take action''')
FENCE_ACTION_GUIDED_THR_PASS = 3 # Switched to guided mode to return point (fence point 0) with manual
                        # throttle control
enums['FENCE_ACTION'][3] = EnumEntry('FENCE_ACTION_GUIDED_THR_PASS', '''Switched to guided mode to return point (fence point 0) with manual throttle control''')
FENCE_ACTION_RTL = 4 # Switch to RTL (return to launch) mode and head for the return point.
enums['FENCE_ACTION'][4] = EnumEntry('FENCE_ACTION_RTL', '''Switch to RTL (return to launch) mode and head for the return point.''')
FENCE_ACTION_ENUM_END = 5 # 
enums['FENCE_ACTION'][5] = EnumEntry('FENCE_ACTION_ENUM_END', '''''')

# FENCE_BREACH
enums['FENCE_BREACH'] = {}
FENCE_BREACH_NONE = 0 # No last fence breach
enums['FENCE_BREACH'][0] = EnumEntry('FENCE_BREACH_NONE', '''No last fence breach''')
FENCE_BREACH_MINALT = 1 # Breached minimum altitude
enums['FENCE_BREACH'][1] = EnumEntry('FENCE_BREACH_MINALT', '''Breached minimum altitude''')
FENCE_BREACH_MAXALT = 2 # Breached maximum altitude
enums['FENCE_BREACH'][2] = EnumEntry('FENCE_BREACH_MAXALT', '''Breached maximum altitude''')
FENCE_BREACH_BOUNDARY = 3 # Breached fence boundary
enums['FENCE_BREACH'][3] = EnumEntry('FENCE_BREACH_BOUNDARY', '''Breached fence boundary''')
FENCE_BREACH_ENUM_END = 4 # 
enums['FENCE_BREACH'][4] = EnumEntry('FENCE_BREACH_ENUM_END', '''''')

# FENCE_MITIGATE
enums['FENCE_MITIGATE'] = {}
FENCE_MITIGATE_UNKNOWN = 0 # Unknown
enums['FENCE_MITIGATE'][0] = EnumEntry('FENCE_MITIGATE_UNKNOWN', '''Unknown''')
FENCE_MITIGATE_NONE = 1 # No actions being taken
enums['FENCE_MITIGATE'][1] = EnumEntry('FENCE_MITIGATE_NONE', '''No actions being taken''')
FENCE_MITIGATE_VEL_LIMIT = 2 # Velocity limiting active to prevent breach
enums['FENCE_MITIGATE'][2] = EnumEntry('FENCE_MITIGATE_VEL_LIMIT', '''Velocity limiting active to prevent breach''')
FENCE_MITIGATE_ENUM_END = 3 # 
enums['FENCE_MITIGATE'][3] = EnumEntry('FENCE_MITIGATE_ENUM_END', '''''')

# MAV_MOUNT_MODE
enums['MAV_MOUNT_MODE'] = {}
MAV_MOUNT_MODE_RETRACT = 0 # Load and keep safe position (Roll,Pitch,Yaw) from permant memory and
                        # stop stabilization
enums['MAV_MOUNT_MODE'][0] = EnumEntry('MAV_MOUNT_MODE_RETRACT', '''Load and keep safe position (Roll,Pitch,Yaw) from permant memory and stop stabilization''')
MAV_MOUNT_MODE_NEUTRAL = 1 # Load and keep neutral position (Roll,Pitch,Yaw) from permanent memory.
enums['MAV_MOUNT_MODE'][1] = EnumEntry('MAV_MOUNT_MODE_NEUTRAL', '''Load and keep neutral position (Roll,Pitch,Yaw) from permanent memory.''')
MAV_MOUNT_MODE_MAVLINK_TARGETING = 2 # Load neutral position and start MAVLink Roll,Pitch,Yaw control with
                        # stabilization
enums['MAV_MOUNT_MODE'][2] = EnumEntry('MAV_MOUNT_MODE_MAVLINK_TARGETING', '''Load neutral position and start MAVLink Roll,Pitch,Yaw control with stabilization''')
MAV_MOUNT_MODE_RC_TARGETING = 3 # Load neutral position and start RC Roll,Pitch,Yaw control with
                        # stabilization
enums['MAV_MOUNT_MODE'][3] = EnumEntry('MAV_MOUNT_MODE_RC_TARGETING', '''Load neutral position and start RC Roll,Pitch,Yaw control with stabilization''')
MAV_MOUNT_MODE_GPS_POINT = 4 # Load neutral position and start to point to Lat,Lon,Alt
enums['MAV_MOUNT_MODE'][4] = EnumEntry('MAV_MOUNT_MODE_GPS_POINT', '''Load neutral position and start to point to Lat,Lon,Alt''')
MAV_MOUNT_MODE_SYSID_TARGET = 5 # Gimbal tracks system with specified system ID
enums['MAV_MOUNT_MODE'][5] = EnumEntry('MAV_MOUNT_MODE_SYSID_TARGET', '''Gimbal tracks system with specified system ID''')
MAV_MOUNT_MODE_HOME_LOCATION = 6 # Gimbal tracks home location
enums['MAV_MOUNT_MODE'][6] = EnumEntry('MAV_MOUNT_MODE_HOME_LOCATION', '''Gimbal tracks home location''')
MAV_MOUNT_MODE_ENUM_END = 7 # 
enums['MAV_MOUNT_MODE'][7] = EnumEntry('MAV_MOUNT_MODE_ENUM_END', '''''')

# GIMBAL_DEVICE_CAP_FLAGS
enums['GIMBAL_DEVICE_CAP_FLAGS'] = {}
GIMBAL_DEVICE_CAP_FLAGS_HAS_RETRACT = 1 # Gimbal device supports a retracted position
enums['GIMBAL_DEVICE_CAP_FLAGS'][1] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_RETRACT', '''Gimbal device supports a retracted position''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_NEUTRAL = 2 # Gimbal device supports a horizontal, forward looking position,
                        # stabilized
enums['GIMBAL_DEVICE_CAP_FLAGS'][2] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_NEUTRAL', '''Gimbal device supports a horizontal, forward looking position, stabilized''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_AXIS = 4 # Gimbal device supports rotating around roll axis.
enums['GIMBAL_DEVICE_CAP_FLAGS'][4] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_AXIS', '''Gimbal device supports rotating around roll axis.''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_FOLLOW = 8 # Gimbal device supports to follow a roll angle relative to the vehicle
enums['GIMBAL_DEVICE_CAP_FLAGS'][8] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_FOLLOW', '''Gimbal device supports to follow a roll angle relative to the vehicle''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_LOCK = 16 # Gimbal device supports locking to an roll angle (generally that's the
                        # default with roll stabilized)
enums['GIMBAL_DEVICE_CAP_FLAGS'][16] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_LOCK', '''Gimbal device supports locking to an roll angle (generally that's the default with roll stabilized)''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_AXIS = 32 # Gimbal device supports rotating around pitch axis.
enums['GIMBAL_DEVICE_CAP_FLAGS'][32] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_AXIS', '''Gimbal device supports rotating around pitch axis.''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_FOLLOW = 64 # Gimbal device supports to follow a pitch angle relative to the vehicle
enums['GIMBAL_DEVICE_CAP_FLAGS'][64] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_FOLLOW', '''Gimbal device supports to follow a pitch angle relative to the vehicle''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_LOCK = 128 # Gimbal device supports locking to an pitch angle (generally that's the
                        # default with pitch stabilized)
enums['GIMBAL_DEVICE_CAP_FLAGS'][128] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_LOCK', '''Gimbal device supports locking to an pitch angle (generally that's the default with pitch stabilized)''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_AXIS = 256 # Gimbal device supports rotating around yaw axis.
enums['GIMBAL_DEVICE_CAP_FLAGS'][256] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_AXIS', '''Gimbal device supports rotating around yaw axis.''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_FOLLOW = 512 # Gimbal device supports to follow a yaw angle relative to the vehicle
                        # (generally that's the default)
enums['GIMBAL_DEVICE_CAP_FLAGS'][512] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_FOLLOW', '''Gimbal device supports to follow a yaw angle relative to the vehicle (generally that's the default)''')
GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_LOCK = 1024 # Gimbal device supports locking to an absolute heading (often this is
                        # an option available)
enums['GIMBAL_DEVICE_CAP_FLAGS'][1024] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_LOCK', '''Gimbal device supports locking to an absolute heading (often this is an option available)''')
GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_INFINITE_YAW = 2048 # Gimbal device supports yawing/panning infinetely (e.g. using slip
                        # disk).
enums['GIMBAL_DEVICE_CAP_FLAGS'][2048] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_INFINITE_YAW', '''Gimbal device supports yawing/panning infinetely (e.g. using slip disk).''')
GIMBAL_DEVICE_CAP_FLAGS_ENUM_END = 2049 # 
enums['GIMBAL_DEVICE_CAP_FLAGS'][2049] = EnumEntry('GIMBAL_DEVICE_CAP_FLAGS_ENUM_END', '''''')

# GRIPPER_ACTIONS
enums['GRIPPER_ACTIONS'] = {}
GRIPPER_ACTION_RELEASE = 0 # Gripper release cargo.
enums['GRIPPER_ACTIONS'][0] = EnumEntry('GRIPPER_ACTION_RELEASE', '''Gripper release cargo.''')
GRIPPER_ACTION_GRAB = 1 # Gripper grab onto cargo.
enums['GRIPPER_ACTIONS'][1] = EnumEntry('GRIPPER_ACTION_GRAB', '''Gripper grab onto cargo.''')
GRIPPER_ACTIONS_ENUM_END = 2 # 
enums['GRIPPER_ACTIONS'][2] = EnumEntry('GRIPPER_ACTIONS_ENUM_END', '''''')

# WINCH_ACTIONS
enums['WINCH_ACTIONS'] = {}
WINCH_RELAXED = 0 # Relax winch.
enums['WINCH_ACTIONS'][0] = EnumEntry('WINCH_RELAXED', '''Relax winch.''')
WINCH_RELATIVE_LENGTH_CONTROL = 1 # Wind or unwind specified length of cable, optionally using specified
                        # rate.
enums['WINCH_ACTIONS'][1] = EnumEntry('WINCH_RELATIVE_LENGTH_CONTROL', '''Wind or unwind specified length of cable, optionally using specified rate.''')
WINCH_RATE_CONTROL = 2 # Wind or unwind cable at specified rate.
enums['WINCH_ACTIONS'][2] = EnumEntry('WINCH_RATE_CONTROL', '''Wind or unwind cable at specified rate.''')
WINCH_ACTIONS_ENUM_END = 3 # 
enums['WINCH_ACTIONS'][3] = EnumEntry('WINCH_ACTIONS_ENUM_END', '''''')

# UAVCAN_NODE_HEALTH
enums['UAVCAN_NODE_HEALTH'] = {}
UAVCAN_NODE_HEALTH_OK = 0 # The node is functioning properly.
enums['UAVCAN_NODE_HEALTH'][0] = EnumEntry('UAVCAN_NODE_HEALTH_OK', '''The node is functioning properly.''')
UAVCAN_NODE_HEALTH_WARNING = 1 # A critical parameter went out of range or the node has encountered a
                        # minor failure.
enums['UAVCAN_NODE_HEALTH'][1] = EnumEntry('UAVCAN_NODE_HEALTH_WARNING', '''A critical parameter went out of range or the node has encountered a minor failure.''')
UAVCAN_NODE_HEALTH_ERROR = 2 # The node has encountered a major failure.
enums['UAVCAN_NODE_HEALTH'][2] = EnumEntry('UAVCAN_NODE_HEALTH_ERROR', '''The node has encountered a major failure.''')
UAVCAN_NODE_HEALTH_CRITICAL = 3 # The node has suffered a fatal malfunction.
enums['UAVCAN_NODE_HEALTH'][3] = EnumEntry('UAVCAN_NODE_HEALTH_CRITICAL', '''The node has suffered a fatal malfunction.''')
UAVCAN_NODE_HEALTH_ENUM_END = 4 # 
enums['UAVCAN_NODE_HEALTH'][4] = EnumEntry('UAVCAN_NODE_HEALTH_ENUM_END', '''''')

# UAVCAN_NODE_MODE
enums['UAVCAN_NODE_MODE'] = {}
UAVCAN_NODE_MODE_OPERATIONAL = 0 # The node is performing its primary functions.
enums['UAVCAN_NODE_MODE'][0] = EnumEntry('UAVCAN_NODE_MODE_OPERATIONAL', '''The node is performing its primary functions.''')
UAVCAN_NODE_MODE_INITIALIZATION = 1 # The node is initializing; this mode is entered immediately after
                        # startup.
enums['UAVCAN_NODE_MODE'][1] = EnumEntry('UAVCAN_NODE_MODE_INITIALIZATION', '''The node is initializing; this mode is entered immediately after startup.''')
UAVCAN_NODE_MODE_MAINTENANCE = 2 # The node is under maintenance.
enums['UAVCAN_NODE_MODE'][2] = EnumEntry('UAVCAN_NODE_MODE_MAINTENANCE', '''The node is under maintenance.''')
UAVCAN_NODE_MODE_SOFTWARE_UPDATE = 3 # The node is in the process of updating its software.
enums['UAVCAN_NODE_MODE'][3] = EnumEntry('UAVCAN_NODE_MODE_SOFTWARE_UPDATE', '''The node is in the process of updating its software.''')
UAVCAN_NODE_MODE_OFFLINE = 7 # The node is no longer available online.
enums['UAVCAN_NODE_MODE'][7] = EnumEntry('UAVCAN_NODE_MODE_OFFLINE', '''The node is no longer available online.''')
UAVCAN_NODE_MODE_ENUM_END = 8 # 
enums['UAVCAN_NODE_MODE'][8] = EnumEntry('UAVCAN_NODE_MODE_ENUM_END', '''''')

# STORAGE_STATUS
enums['STORAGE_STATUS'] = {}
STORAGE_STATUS_EMPTY = 0 # Storage is missing (no microSD card loaded for example.)
enums['STORAGE_STATUS'][0] = EnumEntry('STORAGE_STATUS_EMPTY', '''Storage is missing (no microSD card loaded for example.)''')
STORAGE_STATUS_UNFORMATTED = 1 # Storage present but unformatted.
enums['STORAGE_STATUS'][1] = EnumEntry('STORAGE_STATUS_UNFORMATTED', '''Storage present but unformatted.''')
STORAGE_STATUS_READY = 2 # Storage present and ready.
enums['STORAGE_STATUS'][2] = EnumEntry('STORAGE_STATUS_READY', '''Storage present and ready.''')
STORAGE_STATUS_NOT_SUPPORTED = 3 # Camera does not supply storage status information. Capacity
                        # information in STORAGE_INFORMATION fields
                        # will be ignored.
enums['STORAGE_STATUS'][3] = EnumEntry('STORAGE_STATUS_NOT_SUPPORTED', '''Camera does not supply storage status information. Capacity information in STORAGE_INFORMATION fields will be ignored.''')
STORAGE_STATUS_ENUM_END = 4 # 
enums['STORAGE_STATUS'][4] = EnumEntry('STORAGE_STATUS_ENUM_END', '''''')

# MAV_DATA_STREAM
enums['MAV_DATA_STREAM'] = {}
MAV_DATA_STREAM_ALL = 0 # Enable all data streams
enums['MAV_DATA_STREAM'][0] = EnumEntry('MAV_DATA_STREAM_ALL', '''Enable all data streams''')
MAV_DATA_STREAM_RAW_SENSORS = 1 # Enable IMU_RAW, GPS_RAW, GPS_STATUS packets.
enums['MAV_DATA_STREAM'][1] = EnumEntry('MAV_DATA_STREAM_RAW_SENSORS', '''Enable IMU_RAW, GPS_RAW, GPS_STATUS packets.''')
MAV_DATA_STREAM_EXTENDED_STATUS = 2 # Enable GPS_STATUS, CONTROL_STATUS, AUX_STATUS
enums['MAV_DATA_STREAM'][2] = EnumEntry('MAV_DATA_STREAM_EXTENDED_STATUS', '''Enable GPS_STATUS, CONTROL_STATUS, AUX_STATUS''')
MAV_DATA_STREAM_RC_CHANNELS = 3 # Enable RC_CHANNELS_SCALED, RC_CHANNELS_RAW, SERVO_OUTPUT_RAW
enums['MAV_DATA_STREAM'][3] = EnumEntry('MAV_DATA_STREAM_RC_CHANNELS', '''Enable RC_CHANNELS_SCALED, RC_CHANNELS_RAW, SERVO_OUTPUT_RAW''')
MAV_DATA_STREAM_RAW_CONTROLLER = 4 # Enable ATTITUDE_CONTROLLER_OUTPUT, POSITION_CONTROLLER_OUTPUT,
                        # NAV_CONTROLLER_OUTPUT.
enums['MAV_DATA_STREAM'][4] = EnumEntry('MAV_DATA_STREAM_RAW_CONTROLLER', '''Enable ATTITUDE_CONTROLLER_OUTPUT, POSITION_CONTROLLER_OUTPUT, NAV_CONTROLLER_OUTPUT.''')
MAV_DATA_STREAM_POSITION = 6 # Enable LOCAL_POSITION, GLOBAL_POSITION/GLOBAL_POSITION_INT messages.
enums['MAV_DATA_STREAM'][6] = EnumEntry('MAV_DATA_STREAM_POSITION', '''Enable LOCAL_POSITION, GLOBAL_POSITION/GLOBAL_POSITION_INT messages.''')
MAV_DATA_STREAM_EXTRA1 = 10 # Dependent on the autopilot
enums['MAV_DATA_STREAM'][10] = EnumEntry('MAV_DATA_STREAM_EXTRA1', '''Dependent on the autopilot''')
MAV_DATA_STREAM_EXTRA2 = 11 # Dependent on the autopilot
enums['MAV_DATA_STREAM'][11] = EnumEntry('MAV_DATA_STREAM_EXTRA2', '''Dependent on the autopilot''')
MAV_DATA_STREAM_EXTRA3 = 12 # Dependent on the autopilot
enums['MAV_DATA_STREAM'][12] = EnumEntry('MAV_DATA_STREAM_EXTRA3', '''Dependent on the autopilot''')
MAV_DATA_STREAM_ENUM_END = 13 # 
enums['MAV_DATA_STREAM'][13] = EnumEntry('MAV_DATA_STREAM_ENUM_END', '''''')

# MAV_ROI
enums['MAV_ROI'] = {}
MAV_ROI_NONE = 0 # No region of interest.
enums['MAV_ROI'][0] = EnumEntry('MAV_ROI_NONE', '''No region of interest.''')
MAV_ROI_WPNEXT = 1 # Point toward next waypoint, with optional pitch/roll/yaw offset.
enums['MAV_ROI'][1] = EnumEntry('MAV_ROI_WPNEXT', '''Point toward next waypoint, with optional pitch/roll/yaw offset.''')
MAV_ROI_WPINDEX = 2 # Point toward given waypoint.
enums['MAV_ROI'][2] = EnumEntry('MAV_ROI_WPINDEX', '''Point toward given waypoint.''')
MAV_ROI_LOCATION = 3 # Point toward fixed location.
enums['MAV_ROI'][3] = EnumEntry('MAV_ROI_LOCATION', '''Point toward fixed location.''')
MAV_ROI_TARGET = 4 # Point toward of given id.
enums['MAV_ROI'][4] = EnumEntry('MAV_ROI_TARGET', '''Point toward of given id.''')
MAV_ROI_ENUM_END = 5 # 
enums['MAV_ROI'][5] = EnumEntry('MAV_ROI_ENUM_END', '''''')

# MAV_CMD_ACK
enums['MAV_CMD_ACK'] = {}
MAV_CMD_ACK_OK = 0 # Command / mission item is ok.
enums['MAV_CMD_ACK'][0] = EnumEntry('MAV_CMD_ACK_OK', '''Command / mission item is ok.''')
enums['MAV_CMD_ACK'][0].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][0].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][0].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][0].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][0].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][0].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][0].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_FAIL = 1 # Generic error message if none of the other reasons fails or if no
                        # detailed error reporting is implemented.
enums['MAV_CMD_ACK'][1] = EnumEntry('MAV_CMD_ACK_ERR_FAIL', '''Generic error message if none of the other reasons fails or if no detailed error reporting is implemented.''')
enums['MAV_CMD_ACK'][1].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][1].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][1].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][1].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][1].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][1].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][1].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_ACCESS_DENIED = 2 # The system is refusing to accept this command from this source /
                        # communication partner.
enums['MAV_CMD_ACK'][2] = EnumEntry('MAV_CMD_ACK_ERR_ACCESS_DENIED', '''The system is refusing to accept this command from this source / communication partner.''')
enums['MAV_CMD_ACK'][2].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][2].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][2].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][2].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][2].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][2].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][2].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_NOT_SUPPORTED = 3 # Command or mission item is not supported, other commands would be
                        # accepted.
enums['MAV_CMD_ACK'][3] = EnumEntry('MAV_CMD_ACK_ERR_NOT_SUPPORTED', '''Command or mission item is not supported, other commands would be accepted.''')
enums['MAV_CMD_ACK'][3].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][3].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][3].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][3].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][3].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][3].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][3].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_COORDINATE_FRAME_NOT_SUPPORTED = 4 # The coordinate frame of this command / mission item is not supported.
enums['MAV_CMD_ACK'][4] = EnumEntry('MAV_CMD_ACK_ERR_COORDINATE_FRAME_NOT_SUPPORTED', '''The coordinate frame of this command / mission item is not supported.''')
enums['MAV_CMD_ACK'][4].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][4].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][4].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][4].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][4].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][4].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][4].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_COORDINATES_OUT_OF_RANGE = 5 # The coordinate frame of this command is ok, but he coordinate values
                        # exceed the safety limits of this system.
                        # This is a generic error, please use the more
                        # specific error messages below if possible.
enums['MAV_CMD_ACK'][5] = EnumEntry('MAV_CMD_ACK_ERR_COORDINATES_OUT_OF_RANGE', '''The coordinate frame of this command is ok, but he coordinate values exceed the safety limits of this system. This is a generic error, please use the more specific error messages below if possible.''')
enums['MAV_CMD_ACK'][5].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][5].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][5].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][5].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][5].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][5].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][5].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_X_LAT_OUT_OF_RANGE = 6 # The X or latitude value is out of range.
enums['MAV_CMD_ACK'][6] = EnumEntry('MAV_CMD_ACK_ERR_X_LAT_OUT_OF_RANGE', '''The X or latitude value is out of range.''')
enums['MAV_CMD_ACK'][6].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][6].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][6].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][6].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][6].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][6].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][6].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_Y_LON_OUT_OF_RANGE = 7 # The Y or longitude value is out of range.
enums['MAV_CMD_ACK'][7] = EnumEntry('MAV_CMD_ACK_ERR_Y_LON_OUT_OF_RANGE', '''The Y or longitude value is out of range.''')
enums['MAV_CMD_ACK'][7].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][7].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][7].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][7].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][7].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][7].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][7].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ERR_Z_ALT_OUT_OF_RANGE = 8 # The Z or altitude value is out of range.
enums['MAV_CMD_ACK'][8] = EnumEntry('MAV_CMD_ACK_ERR_Z_ALT_OUT_OF_RANGE', '''The Z or altitude value is out of range.''')
enums['MAV_CMD_ACK'][8].param[1] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][8].param[2] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][8].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][8].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][8].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][8].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD_ACK'][8].param[7] = '''Reserved (default:0)'''
MAV_CMD_ACK_ENUM_END = 9 # 
enums['MAV_CMD_ACK'][9] = EnumEntry('MAV_CMD_ACK_ENUM_END', '''''')

# MAV_PARAM_TYPE
enums['MAV_PARAM_TYPE'] = {}
MAV_PARAM_TYPE_UINT8 = 1 # 8-bit unsigned integer
enums['MAV_PARAM_TYPE'][1] = EnumEntry('MAV_PARAM_TYPE_UINT8', '''8-bit unsigned integer''')
MAV_PARAM_TYPE_INT8 = 2 # 8-bit signed integer
enums['MAV_PARAM_TYPE'][2] = EnumEntry('MAV_PARAM_TYPE_INT8', '''8-bit signed integer''')
MAV_PARAM_TYPE_UINT16 = 3 # 16-bit unsigned integer
enums['MAV_PARAM_TYPE'][3] = EnumEntry('MAV_PARAM_TYPE_UINT16', '''16-bit unsigned integer''')
MAV_PARAM_TYPE_INT16 = 4 # 16-bit signed integer
enums['MAV_PARAM_TYPE'][4] = EnumEntry('MAV_PARAM_TYPE_INT16', '''16-bit signed integer''')
MAV_PARAM_TYPE_UINT32 = 5 # 32-bit unsigned integer
enums['MAV_PARAM_TYPE'][5] = EnumEntry('MAV_PARAM_TYPE_UINT32', '''32-bit unsigned integer''')
MAV_PARAM_TYPE_INT32 = 6 # 32-bit signed integer
enums['MAV_PARAM_TYPE'][6] = EnumEntry('MAV_PARAM_TYPE_INT32', '''32-bit signed integer''')
MAV_PARAM_TYPE_UINT64 = 7 # 64-bit unsigned integer
enums['MAV_PARAM_TYPE'][7] = EnumEntry('MAV_PARAM_TYPE_UINT64', '''64-bit unsigned integer''')
MAV_PARAM_TYPE_INT64 = 8 # 64-bit signed integer
enums['MAV_PARAM_TYPE'][8] = EnumEntry('MAV_PARAM_TYPE_INT64', '''64-bit signed integer''')
MAV_PARAM_TYPE_REAL32 = 9 # 32-bit floating-point
enums['MAV_PARAM_TYPE'][9] = EnumEntry('MAV_PARAM_TYPE_REAL32', '''32-bit floating-point''')
MAV_PARAM_TYPE_REAL64 = 10 # 64-bit floating-point
enums['MAV_PARAM_TYPE'][10] = EnumEntry('MAV_PARAM_TYPE_REAL64', '''64-bit floating-point''')
MAV_PARAM_TYPE_ENUM_END = 11 # 
enums['MAV_PARAM_TYPE'][11] = EnumEntry('MAV_PARAM_TYPE_ENUM_END', '''''')

# MAV_RESULT
enums['MAV_RESULT'] = {}
MAV_RESULT_ACCEPTED = 0 # Command is valid (is supported and has valid parameters), and was
                        # executed.
enums['MAV_RESULT'][0] = EnumEntry('MAV_RESULT_ACCEPTED', '''Command is valid (is supported and has valid parameters), and was executed.''')
MAV_RESULT_TEMPORARILY_REJECTED = 1 # Command is valid, but cannot be executed at this time. This is used to
                        # indicate a problem that should be fixed just
                        # by waiting (e.g. a state machine is busy,
                        # can't arm because have not got GPS lock,
                        # etc.). Retrying later should work.
enums['MAV_RESULT'][1] = EnumEntry('MAV_RESULT_TEMPORARILY_REJECTED', '''Command is valid, but cannot be executed at this time. This is used to indicate a problem that should be fixed just by waiting (e.g. a state machine is busy, can't arm because have not got GPS lock, etc.). Retrying later should work.''')
MAV_RESULT_DENIED = 2 # Command is invalid (is supported but has invalid parameters). Retrying
                        # same command and parameters will not work.
enums['MAV_RESULT'][2] = EnumEntry('MAV_RESULT_DENIED', '''Command is invalid (is supported but has invalid parameters). Retrying same command and parameters will not work.''')
MAV_RESULT_UNSUPPORTED = 3 # Command is not supported (unknown).
enums['MAV_RESULT'][3] = EnumEntry('MAV_RESULT_UNSUPPORTED', '''Command is not supported (unknown).''')
MAV_RESULT_FAILED = 4 # Command is valid, but execution has failed. This is used to indicate
                        # any non-temporary or unexpected problem,
                        # i.e. any problem that must be fixed before
                        # the command can succeed/be retried. For
                        # example, attempting to write a file when out
                        # of memory, attempting to arm when sensors
                        # are not calibrated, etc.
enums['MAV_RESULT'][4] = EnumEntry('MAV_RESULT_FAILED', '''Command is valid, but execution has failed. This is used to indicate any non-temporary or unexpected problem, i.e. any problem that must be fixed before the command can succeed/be retried. For example, attempting to write a file when out of memory, attempting to arm when sensors are not calibrated, etc.''')
MAV_RESULT_IN_PROGRESS = 5 # Command is valid and is being executed. This will be followed by
                        # further progress updates, i.e. the component
                        # may send further COMMAND_ACK messages with
                        # result MAV_RESULT_IN_PROGRESS (at a rate
                        # decided by the implementation), and must
                        # terminate by sending a COMMAND_ACK message
                        # with final result of the operation. The
                        # COMMAND_ACK.progress field can be used to
                        # indicate the progress of the operation.
                        # There is no need for the sender to retry the
                        # command, but if done during execution, the
                        # component will return MAV_RESULT_IN_PROGRESS
                        # with an updated progress.
enums['MAV_RESULT'][5] = EnumEntry('MAV_RESULT_IN_PROGRESS', '''Command is valid and is being executed. This will be followed by further progress updates, i.e. the component may send further COMMAND_ACK messages with result MAV_RESULT_IN_PROGRESS (at a rate decided by the implementation), and must terminate by sending a COMMAND_ACK message with final result of the operation. The COMMAND_ACK.progress field can be used to indicate the progress of the operation. There is no need for the sender to retry the command, but if done during execution, the component will return MAV_RESULT_IN_PROGRESS with an updated progress.''')
MAV_RESULT_ENUM_END = 6 # 
enums['MAV_RESULT'][6] = EnumEntry('MAV_RESULT_ENUM_END', '''''')

# MAV_MISSION_RESULT
enums['MAV_MISSION_RESULT'] = {}
MAV_MISSION_ACCEPTED = 0 # mission accepted OK
enums['MAV_MISSION_RESULT'][0] = EnumEntry('MAV_MISSION_ACCEPTED', '''mission accepted OK''')
MAV_MISSION_ERROR = 1 # Generic error / not accepting mission commands at all right now.
enums['MAV_MISSION_RESULT'][1] = EnumEntry('MAV_MISSION_ERROR', '''Generic error / not accepting mission commands at all right now.''')
MAV_MISSION_UNSUPPORTED_FRAME = 2 # Coordinate frame is not supported.
enums['MAV_MISSION_RESULT'][2] = EnumEntry('MAV_MISSION_UNSUPPORTED_FRAME', '''Coordinate frame is not supported.''')
MAV_MISSION_UNSUPPORTED = 3 # Command is not supported.
enums['MAV_MISSION_RESULT'][3] = EnumEntry('MAV_MISSION_UNSUPPORTED', '''Command is not supported.''')
MAV_MISSION_NO_SPACE = 4 # Mission items exceed storage space.
enums['MAV_MISSION_RESULT'][4] = EnumEntry('MAV_MISSION_NO_SPACE', '''Mission items exceed storage space.''')
MAV_MISSION_INVALID = 5 # One of the parameters has an invalid value.
enums['MAV_MISSION_RESULT'][5] = EnumEntry('MAV_MISSION_INVALID', '''One of the parameters has an invalid value.''')
MAV_MISSION_INVALID_PARAM1 = 6 # param1 has an invalid value.
enums['MAV_MISSION_RESULT'][6] = EnumEntry('MAV_MISSION_INVALID_PARAM1', '''param1 has an invalid value.''')
MAV_MISSION_INVALID_PARAM2 = 7 # param2 has an invalid value.
enums['MAV_MISSION_RESULT'][7] = EnumEntry('MAV_MISSION_INVALID_PARAM2', '''param2 has an invalid value.''')
MAV_MISSION_INVALID_PARAM3 = 8 # param3 has an invalid value.
enums['MAV_MISSION_RESULT'][8] = EnumEntry('MAV_MISSION_INVALID_PARAM3', '''param3 has an invalid value.''')
MAV_MISSION_INVALID_PARAM4 = 9 # param4 has an invalid value.
enums['MAV_MISSION_RESULT'][9] = EnumEntry('MAV_MISSION_INVALID_PARAM4', '''param4 has an invalid value.''')
MAV_MISSION_INVALID_PARAM5_X = 10 # x / param5 has an invalid value.
enums['MAV_MISSION_RESULT'][10] = EnumEntry('MAV_MISSION_INVALID_PARAM5_X', '''x / param5 has an invalid value.''')
MAV_MISSION_INVALID_PARAM6_Y = 11 # y / param6 has an invalid value.
enums['MAV_MISSION_RESULT'][11] = EnumEntry('MAV_MISSION_INVALID_PARAM6_Y', '''y / param6 has an invalid value.''')
MAV_MISSION_INVALID_PARAM7 = 12 # z / param7 has an invalid value.
enums['MAV_MISSION_RESULT'][12] = EnumEntry('MAV_MISSION_INVALID_PARAM7', '''z / param7 has an invalid value.''')
MAV_MISSION_INVALID_SEQUENCE = 13 # Mission item received out of sequence
enums['MAV_MISSION_RESULT'][13] = EnumEntry('MAV_MISSION_INVALID_SEQUENCE', '''Mission item received out of sequence''')
MAV_MISSION_DENIED = 14 # Not accepting any mission commands from this communication partner.
enums['MAV_MISSION_RESULT'][14] = EnumEntry('MAV_MISSION_DENIED', '''Not accepting any mission commands from this communication partner.''')
MAV_MISSION_OPERATION_CANCELLED = 15 # Current mission operation cancelled (e.g. mission upload, mission
                        # download).
enums['MAV_MISSION_RESULT'][15] = EnumEntry('MAV_MISSION_OPERATION_CANCELLED', '''Current mission operation cancelled (e.g. mission upload, mission download).''')
MAV_MISSION_RESULT_ENUM_END = 16 # 
enums['MAV_MISSION_RESULT'][16] = EnumEntry('MAV_MISSION_RESULT_ENUM_END', '''''')

# MAV_SEVERITY
enums['MAV_SEVERITY'] = {}
MAV_SEVERITY_EMERGENCY = 0 # System is unusable. This is a "panic" condition.
enums['MAV_SEVERITY'][0] = EnumEntry('MAV_SEVERITY_EMERGENCY', '''System is unusable. This is a "panic" condition.''')
MAV_SEVERITY_ALERT = 1 # Action should be taken immediately. Indicates error in non-critical
                        # systems.
enums['MAV_SEVERITY'][1] = EnumEntry('MAV_SEVERITY_ALERT', '''Action should be taken immediately. Indicates error in non-critical systems.''')
MAV_SEVERITY_CRITICAL = 2 # Action must be taken immediately. Indicates failure in a primary
                        # system.
enums['MAV_SEVERITY'][2] = EnumEntry('MAV_SEVERITY_CRITICAL', '''Action must be taken immediately. Indicates failure in a primary system.''')
MAV_SEVERITY_ERROR = 3 # Indicates an error in secondary/redundant systems.
enums['MAV_SEVERITY'][3] = EnumEntry('MAV_SEVERITY_ERROR', '''Indicates an error in secondary/redundant systems.''')
MAV_SEVERITY_WARNING = 4 # Indicates about a possible future error if this is not resolved within
                        # a given timeframe. Example would be a low
                        # battery warning.
enums['MAV_SEVERITY'][4] = EnumEntry('MAV_SEVERITY_WARNING', '''Indicates about a possible future error if this is not resolved within a given timeframe. Example would be a low battery warning.''')
MAV_SEVERITY_NOTICE = 5 # An unusual event has occurred, though not an error condition. This
                        # should be investigated for the root cause.
enums['MAV_SEVERITY'][5] = EnumEntry('MAV_SEVERITY_NOTICE', '''An unusual event has occurred, though not an error condition. This should be investigated for the root cause.''')
MAV_SEVERITY_INFO = 6 # Normal operational messages. Useful for logging. No action is required
                        # for these messages.
enums['MAV_SEVERITY'][6] = EnumEntry('MAV_SEVERITY_INFO', '''Normal operational messages. Useful for logging. No action is required for these messages.''')
MAV_SEVERITY_DEBUG = 7 # Useful non-operational messages that can assist in debugging. These
                        # should not occur during normal operation.
enums['MAV_SEVERITY'][7] = EnumEntry('MAV_SEVERITY_DEBUG', '''Useful non-operational messages that can assist in debugging. These should not occur during normal operation.''')
MAV_SEVERITY_ENUM_END = 8 # 
enums['MAV_SEVERITY'][8] = EnumEntry('MAV_SEVERITY_ENUM_END', '''''')

# MAV_POWER_STATUS
enums['MAV_POWER_STATUS'] = {}
MAV_POWER_STATUS_BRICK_VALID = 1 # main brick power supply valid
enums['MAV_POWER_STATUS'][1] = EnumEntry('MAV_POWER_STATUS_BRICK_VALID', '''main brick power supply valid''')
MAV_POWER_STATUS_SERVO_VALID = 2 # main servo power supply valid for FMU
enums['MAV_POWER_STATUS'][2] = EnumEntry('MAV_POWER_STATUS_SERVO_VALID', '''main servo power supply valid for FMU''')
MAV_POWER_STATUS_USB_CONNECTED = 4 # USB power is connected
enums['MAV_POWER_STATUS'][4] = EnumEntry('MAV_POWER_STATUS_USB_CONNECTED', '''USB power is connected''')
MAV_POWER_STATUS_PERIPH_OVERCURRENT = 8 # peripheral supply is in over-current state
enums['MAV_POWER_STATUS'][8] = EnumEntry('MAV_POWER_STATUS_PERIPH_OVERCURRENT', '''peripheral supply is in over-current state''')
MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT = 16 # hi-power peripheral supply is in over-current state
enums['MAV_POWER_STATUS'][16] = EnumEntry('MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT', '''hi-power peripheral supply is in over-current state''')
MAV_POWER_STATUS_CHANGED = 32 # Power status has changed since boot
enums['MAV_POWER_STATUS'][32] = EnumEntry('MAV_POWER_STATUS_CHANGED', '''Power status has changed since boot''')
MAV_POWER_STATUS_ENUM_END = 33 # 
enums['MAV_POWER_STATUS'][33] = EnumEntry('MAV_POWER_STATUS_ENUM_END', '''''')

# SERIAL_CONTROL_DEV
enums['SERIAL_CONTROL_DEV'] = {}
SERIAL_CONTROL_DEV_TELEM1 = 0 # First telemetry port
enums['SERIAL_CONTROL_DEV'][0] = EnumEntry('SERIAL_CONTROL_DEV_TELEM1', '''First telemetry port''')
SERIAL_CONTROL_DEV_TELEM2 = 1 # Second telemetry port
enums['SERIAL_CONTROL_DEV'][1] = EnumEntry('SERIAL_CONTROL_DEV_TELEM2', '''Second telemetry port''')
SERIAL_CONTROL_DEV_GPS1 = 2 # First GPS port
enums['SERIAL_CONTROL_DEV'][2] = EnumEntry('SERIAL_CONTROL_DEV_GPS1', '''First GPS port''')
SERIAL_CONTROL_DEV_GPS2 = 3 # Second GPS port
enums['SERIAL_CONTROL_DEV'][3] = EnumEntry('SERIAL_CONTROL_DEV_GPS2', '''Second GPS port''')
SERIAL_CONTROL_DEV_SHELL = 10 # system shell
enums['SERIAL_CONTROL_DEV'][10] = EnumEntry('SERIAL_CONTROL_DEV_SHELL', '''system shell''')
SERIAL_CONTROL_SERIAL0 = 100 # SERIAL0
enums['SERIAL_CONTROL_DEV'][100] = EnumEntry('SERIAL_CONTROL_SERIAL0', '''SERIAL0''')
SERIAL_CONTROL_SERIAL1 = 101 # SERIAL1
enums['SERIAL_CONTROL_DEV'][101] = EnumEntry('SERIAL_CONTROL_SERIAL1', '''SERIAL1''')
SERIAL_CONTROL_SERIAL2 = 102 # SERIAL2
enums['SERIAL_CONTROL_DEV'][102] = EnumEntry('SERIAL_CONTROL_SERIAL2', '''SERIAL2''')
SERIAL_CONTROL_SERIAL3 = 103 # SERIAL3
enums['SERIAL_CONTROL_DEV'][103] = EnumEntry('SERIAL_CONTROL_SERIAL3', '''SERIAL3''')
SERIAL_CONTROL_SERIAL4 = 104 # SERIAL4
enums['SERIAL_CONTROL_DEV'][104] = EnumEntry('SERIAL_CONTROL_SERIAL4', '''SERIAL4''')
SERIAL_CONTROL_SERIAL5 = 105 # SERIAL5
enums['SERIAL_CONTROL_DEV'][105] = EnumEntry('SERIAL_CONTROL_SERIAL5', '''SERIAL5''')
SERIAL_CONTROL_SERIAL6 = 106 # SERIAL6
enums['SERIAL_CONTROL_DEV'][106] = EnumEntry('SERIAL_CONTROL_SERIAL6', '''SERIAL6''')
SERIAL_CONTROL_SERIAL7 = 107 # SERIAL7
enums['SERIAL_CONTROL_DEV'][107] = EnumEntry('SERIAL_CONTROL_SERIAL7', '''SERIAL7''')
SERIAL_CONTROL_SERIAL8 = 108 # SERIAL8
enums['SERIAL_CONTROL_DEV'][108] = EnumEntry('SERIAL_CONTROL_SERIAL8', '''SERIAL8''')
SERIAL_CONTROL_SERIAL9 = 109 # SERIAL9
enums['SERIAL_CONTROL_DEV'][109] = EnumEntry('SERIAL_CONTROL_SERIAL9', '''SERIAL9''')
SERIAL_CONTROL_DEV_ENUM_END = 110 # 
enums['SERIAL_CONTROL_DEV'][110] = EnumEntry('SERIAL_CONTROL_DEV_ENUM_END', '''''')

# SERIAL_CONTROL_FLAG
enums['SERIAL_CONTROL_FLAG'] = {}
SERIAL_CONTROL_FLAG_REPLY = 1 # Set if this is a reply
enums['SERIAL_CONTROL_FLAG'][1] = EnumEntry('SERIAL_CONTROL_FLAG_REPLY', '''Set if this is a reply''')
SERIAL_CONTROL_FLAG_RESPOND = 2 # Set if the sender wants the receiver to send a response as another
                        # SERIAL_CONTROL message
enums['SERIAL_CONTROL_FLAG'][2] = EnumEntry('SERIAL_CONTROL_FLAG_RESPOND', '''Set if the sender wants the receiver to send a response as another SERIAL_CONTROL message''')
SERIAL_CONTROL_FLAG_EXCLUSIVE = 4 # Set if access to the serial port should be removed from whatever
                        # driver is currently using it, giving
                        # exclusive access to the SERIAL_CONTROL
                        # protocol. The port can be handed back by
                        # sending a request without this flag set
enums['SERIAL_CONTROL_FLAG'][4] = EnumEntry('SERIAL_CONTROL_FLAG_EXCLUSIVE', '''Set if access to the serial port should be removed from whatever driver is currently using it, giving exclusive access to the SERIAL_CONTROL protocol. The port can be handed back by sending a request without this flag set''')
SERIAL_CONTROL_FLAG_BLOCKING = 8 # Block on writes to the serial port
enums['SERIAL_CONTROL_FLAG'][8] = EnumEntry('SERIAL_CONTROL_FLAG_BLOCKING', '''Block on writes to the serial port''')
SERIAL_CONTROL_FLAG_MULTI = 16 # Send multiple replies until port is drained
enums['SERIAL_CONTROL_FLAG'][16] = EnumEntry('SERIAL_CONTROL_FLAG_MULTI', '''Send multiple replies until port is drained''')
SERIAL_CONTROL_FLAG_ENUM_END = 17 # 
enums['SERIAL_CONTROL_FLAG'][17] = EnumEntry('SERIAL_CONTROL_FLAG_ENUM_END', '''''')

# MAV_DISTANCE_SENSOR
enums['MAV_DISTANCE_SENSOR'] = {}
MAV_DISTANCE_SENSOR_LASER = 0 # Laser rangefinder, e.g. LightWare SF02/F or PulsedLight units
enums['MAV_DISTANCE_SENSOR'][0] = EnumEntry('MAV_DISTANCE_SENSOR_LASER', '''Laser rangefinder, e.g. LightWare SF02/F or PulsedLight units''')
MAV_DISTANCE_SENSOR_ULTRASOUND = 1 # Ultrasound rangefinder, e.g. MaxBotix units
enums['MAV_DISTANCE_SENSOR'][1] = EnumEntry('MAV_DISTANCE_SENSOR_ULTRASOUND', '''Ultrasound rangefinder, e.g. MaxBotix units''')
MAV_DISTANCE_SENSOR_INFRARED = 2 # Infrared rangefinder, e.g. Sharp units
enums['MAV_DISTANCE_SENSOR'][2] = EnumEntry('MAV_DISTANCE_SENSOR_INFRARED', '''Infrared rangefinder, e.g. Sharp units''')
MAV_DISTANCE_SENSOR_RADAR = 3 # Radar type, e.g. uLanding units
enums['MAV_DISTANCE_SENSOR'][3] = EnumEntry('MAV_DISTANCE_SENSOR_RADAR', '''Radar type, e.g. uLanding units''')
MAV_DISTANCE_SENSOR_UNKNOWN = 4 # Broken or unknown type, e.g. analog units
enums['MAV_DISTANCE_SENSOR'][4] = EnumEntry('MAV_DISTANCE_SENSOR_UNKNOWN', '''Broken or unknown type, e.g. analog units''')
MAV_DISTANCE_SENSOR_ENUM_END = 5 # 
enums['MAV_DISTANCE_SENSOR'][5] = EnumEntry('MAV_DISTANCE_SENSOR_ENUM_END', '''''')

# MAV_SENSOR_ORIENTATION
enums['MAV_SENSOR_ORIENTATION'] = {}
MAV_SENSOR_ROTATION_NONE = 0 # Roll: 0, Pitch: 0, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][0] = EnumEntry('MAV_SENSOR_ROTATION_NONE', '''Roll: 0, Pitch: 0, Yaw: 0''')
MAV_SENSOR_ROTATION_YAW_45 = 1 # Roll: 0, Pitch: 0, Yaw: 45
enums['MAV_SENSOR_ORIENTATION'][1] = EnumEntry('MAV_SENSOR_ROTATION_YAW_45', '''Roll: 0, Pitch: 0, Yaw: 45''')
MAV_SENSOR_ROTATION_YAW_90 = 2 # Roll: 0, Pitch: 0, Yaw: 90
enums['MAV_SENSOR_ORIENTATION'][2] = EnumEntry('MAV_SENSOR_ROTATION_YAW_90', '''Roll: 0, Pitch: 0, Yaw: 90''')
MAV_SENSOR_ROTATION_YAW_135 = 3 # Roll: 0, Pitch: 0, Yaw: 135
enums['MAV_SENSOR_ORIENTATION'][3] = EnumEntry('MAV_SENSOR_ROTATION_YAW_135', '''Roll: 0, Pitch: 0, Yaw: 135''')
MAV_SENSOR_ROTATION_YAW_180 = 4 # Roll: 0, Pitch: 0, Yaw: 180
enums['MAV_SENSOR_ORIENTATION'][4] = EnumEntry('MAV_SENSOR_ROTATION_YAW_180', '''Roll: 0, Pitch: 0, Yaw: 180''')
MAV_SENSOR_ROTATION_YAW_225 = 5 # Roll: 0, Pitch: 0, Yaw: 225
enums['MAV_SENSOR_ORIENTATION'][5] = EnumEntry('MAV_SENSOR_ROTATION_YAW_225', '''Roll: 0, Pitch: 0, Yaw: 225''')
MAV_SENSOR_ROTATION_YAW_270 = 6 # Roll: 0, Pitch: 0, Yaw: 270
enums['MAV_SENSOR_ORIENTATION'][6] = EnumEntry('MAV_SENSOR_ROTATION_YAW_270', '''Roll: 0, Pitch: 0, Yaw: 270''')
MAV_SENSOR_ROTATION_YAW_315 = 7 # Roll: 0, Pitch: 0, Yaw: 315
enums['MAV_SENSOR_ORIENTATION'][7] = EnumEntry('MAV_SENSOR_ROTATION_YAW_315', '''Roll: 0, Pitch: 0, Yaw: 315''')
MAV_SENSOR_ROTATION_ROLL_180 = 8 # Roll: 180, Pitch: 0, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][8] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180', '''Roll: 180, Pitch: 0, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_180_YAW_45 = 9 # Roll: 180, Pitch: 0, Yaw: 45
enums['MAV_SENSOR_ORIENTATION'][9] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_YAW_45', '''Roll: 180, Pitch: 0, Yaw: 45''')
MAV_SENSOR_ROTATION_ROLL_180_YAW_90 = 10 # Roll: 180, Pitch: 0, Yaw: 90
enums['MAV_SENSOR_ORIENTATION'][10] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_YAW_90', '''Roll: 180, Pitch: 0, Yaw: 90''')
MAV_SENSOR_ROTATION_ROLL_180_YAW_135 = 11 # Roll: 180, Pitch: 0, Yaw: 135
enums['MAV_SENSOR_ORIENTATION'][11] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_YAW_135', '''Roll: 180, Pitch: 0, Yaw: 135''')
MAV_SENSOR_ROTATION_PITCH_180 = 12 # Roll: 0, Pitch: 180, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][12] = EnumEntry('MAV_SENSOR_ROTATION_PITCH_180', '''Roll: 0, Pitch: 180, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_180_YAW_225 = 13 # Roll: 180, Pitch: 0, Yaw: 225
enums['MAV_SENSOR_ORIENTATION'][13] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_YAW_225', '''Roll: 180, Pitch: 0, Yaw: 225''')
MAV_SENSOR_ROTATION_ROLL_180_YAW_270 = 14 # Roll: 180, Pitch: 0, Yaw: 270
enums['MAV_SENSOR_ORIENTATION'][14] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_YAW_270', '''Roll: 180, Pitch: 0, Yaw: 270''')
MAV_SENSOR_ROTATION_ROLL_180_YAW_315 = 15 # Roll: 180, Pitch: 0, Yaw: 315
enums['MAV_SENSOR_ORIENTATION'][15] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_YAW_315', '''Roll: 180, Pitch: 0, Yaw: 315''')
MAV_SENSOR_ROTATION_ROLL_90 = 16 # Roll: 90, Pitch: 0, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][16] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90', '''Roll: 90, Pitch: 0, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_90_YAW_45 = 17 # Roll: 90, Pitch: 0, Yaw: 45
enums['MAV_SENSOR_ORIENTATION'][17] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_YAW_45', '''Roll: 90, Pitch: 0, Yaw: 45''')
MAV_SENSOR_ROTATION_ROLL_90_YAW_90 = 18 # Roll: 90, Pitch: 0, Yaw: 90
enums['MAV_SENSOR_ORIENTATION'][18] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_YAW_90', '''Roll: 90, Pitch: 0, Yaw: 90''')
MAV_SENSOR_ROTATION_ROLL_90_YAW_135 = 19 # Roll: 90, Pitch: 0, Yaw: 135
enums['MAV_SENSOR_ORIENTATION'][19] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_YAW_135', '''Roll: 90, Pitch: 0, Yaw: 135''')
MAV_SENSOR_ROTATION_ROLL_270 = 20 # Roll: 270, Pitch: 0, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][20] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_270', '''Roll: 270, Pitch: 0, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_270_YAW_45 = 21 # Roll: 270, Pitch: 0, Yaw: 45
enums['MAV_SENSOR_ORIENTATION'][21] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_270_YAW_45', '''Roll: 270, Pitch: 0, Yaw: 45''')
MAV_SENSOR_ROTATION_ROLL_270_YAW_90 = 22 # Roll: 270, Pitch: 0, Yaw: 90
enums['MAV_SENSOR_ORIENTATION'][22] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_270_YAW_90', '''Roll: 270, Pitch: 0, Yaw: 90''')
MAV_SENSOR_ROTATION_ROLL_270_YAW_135 = 23 # Roll: 270, Pitch: 0, Yaw: 135
enums['MAV_SENSOR_ORIENTATION'][23] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_270_YAW_135', '''Roll: 270, Pitch: 0, Yaw: 135''')
MAV_SENSOR_ROTATION_PITCH_90 = 24 # Roll: 0, Pitch: 90, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][24] = EnumEntry('MAV_SENSOR_ROTATION_PITCH_90', '''Roll: 0, Pitch: 90, Yaw: 0''')
MAV_SENSOR_ROTATION_PITCH_270 = 25 # Roll: 0, Pitch: 270, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][25] = EnumEntry('MAV_SENSOR_ROTATION_PITCH_270', '''Roll: 0, Pitch: 270, Yaw: 0''')
MAV_SENSOR_ROTATION_PITCH_180_YAW_90 = 26 # Roll: 0, Pitch: 180, Yaw: 90
enums['MAV_SENSOR_ORIENTATION'][26] = EnumEntry('MAV_SENSOR_ROTATION_PITCH_180_YAW_90', '''Roll: 0, Pitch: 180, Yaw: 90''')
MAV_SENSOR_ROTATION_PITCH_180_YAW_270 = 27 # Roll: 0, Pitch: 180, Yaw: 270
enums['MAV_SENSOR_ORIENTATION'][27] = EnumEntry('MAV_SENSOR_ROTATION_PITCH_180_YAW_270', '''Roll: 0, Pitch: 180, Yaw: 270''')
MAV_SENSOR_ROTATION_ROLL_90_PITCH_90 = 28 # Roll: 90, Pitch: 90, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][28] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_PITCH_90', '''Roll: 90, Pitch: 90, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_180_PITCH_90 = 29 # Roll: 180, Pitch: 90, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][29] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_PITCH_90', '''Roll: 180, Pitch: 90, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_270_PITCH_90 = 30 # Roll: 270, Pitch: 90, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][30] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_270_PITCH_90', '''Roll: 270, Pitch: 90, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_90_PITCH_180 = 31 # Roll: 90, Pitch: 180, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][31] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_PITCH_180', '''Roll: 90, Pitch: 180, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_270_PITCH_180 = 32 # Roll: 270, Pitch: 180, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][32] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_270_PITCH_180', '''Roll: 270, Pitch: 180, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_90_PITCH_270 = 33 # Roll: 90, Pitch: 270, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][33] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_PITCH_270', '''Roll: 90, Pitch: 270, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_180_PITCH_270 = 34 # Roll: 180, Pitch: 270, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][34] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_180_PITCH_270', '''Roll: 180, Pitch: 270, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_270_PITCH_270 = 35 # Roll: 270, Pitch: 270, Yaw: 0
enums['MAV_SENSOR_ORIENTATION'][35] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_270_PITCH_270', '''Roll: 270, Pitch: 270, Yaw: 0''')
MAV_SENSOR_ROTATION_ROLL_90_PITCH_180_YAW_90 = 36 # Roll: 90, Pitch: 180, Yaw: 90
enums['MAV_SENSOR_ORIENTATION'][36] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_PITCH_180_YAW_90', '''Roll: 90, Pitch: 180, Yaw: 90''')
MAV_SENSOR_ROTATION_ROLL_90_YAW_270 = 37 # Roll: 90, Pitch: 0, Yaw: 270
enums['MAV_SENSOR_ORIENTATION'][37] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_YAW_270', '''Roll: 90, Pitch: 0, Yaw: 270''')
MAV_SENSOR_ROTATION_ROLL_90_PITCH_68_YAW_293 = 38 # Roll: 90, Pitch: 68, Yaw: 293
enums['MAV_SENSOR_ORIENTATION'][38] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_PITCH_68_YAW_293', '''Roll: 90, Pitch: 68, Yaw: 293''')
MAV_SENSOR_ROTATION_PITCH_315 = 39 # Pitch: 315
enums['MAV_SENSOR_ORIENTATION'][39] = EnumEntry('MAV_SENSOR_ROTATION_PITCH_315', '''Pitch: 315''')
MAV_SENSOR_ROTATION_ROLL_90_PITCH_315 = 40 # Roll: 90, Pitch: 315
enums['MAV_SENSOR_ORIENTATION'][40] = EnumEntry('MAV_SENSOR_ROTATION_ROLL_90_PITCH_315', '''Roll: 90, Pitch: 315''')
MAV_SENSOR_ROTATION_CUSTOM = 100 # Custom orientation
enums['MAV_SENSOR_ORIENTATION'][100] = EnumEntry('MAV_SENSOR_ROTATION_CUSTOM', '''Custom orientation''')
MAV_SENSOR_ORIENTATION_ENUM_END = 101 # 
enums['MAV_SENSOR_ORIENTATION'][101] = EnumEntry('MAV_SENSOR_ORIENTATION_ENUM_END', '''''')

# MAV_PROTOCOL_CAPABILITY
enums['MAV_PROTOCOL_CAPABILITY'] = {}
MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT = 1 # Autopilot supports MISSION float message type.
enums['MAV_PROTOCOL_CAPABILITY'][1] = EnumEntry('MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT', '''Autopilot supports MISSION float message type.''')
MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT = 2 # Autopilot supports the new param float message type.
enums['MAV_PROTOCOL_CAPABILITY'][2] = EnumEntry('MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT', '''Autopilot supports the new param float message type.''')
MAV_PROTOCOL_CAPABILITY_MISSION_INT = 4 # Autopilot supports MISSION_ITEM_INT scaled integer message type.
enums['MAV_PROTOCOL_CAPABILITY'][4] = EnumEntry('MAV_PROTOCOL_CAPABILITY_MISSION_INT', '''Autopilot supports MISSION_ITEM_INT scaled integer message type.''')
MAV_PROTOCOL_CAPABILITY_COMMAND_INT = 8 # Autopilot supports COMMAND_INT scaled integer message type.
enums['MAV_PROTOCOL_CAPABILITY'][8] = EnumEntry('MAV_PROTOCOL_CAPABILITY_COMMAND_INT', '''Autopilot supports COMMAND_INT scaled integer message type.''')
MAV_PROTOCOL_CAPABILITY_PARAM_UNION = 16 # Autopilot supports the new param union message type.
enums['MAV_PROTOCOL_CAPABILITY'][16] = EnumEntry('MAV_PROTOCOL_CAPABILITY_PARAM_UNION', '''Autopilot supports the new param union message type.''')
MAV_PROTOCOL_CAPABILITY_FTP = 32 # Autopilot supports the new FILE_TRANSFER_PROTOCOL message type.
enums['MAV_PROTOCOL_CAPABILITY'][32] = EnumEntry('MAV_PROTOCOL_CAPABILITY_FTP', '''Autopilot supports the new FILE_TRANSFER_PROTOCOL message type.''')
MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET = 64 # Autopilot supports commanding attitude offboard.
enums['MAV_PROTOCOL_CAPABILITY'][64] = EnumEntry('MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET', '''Autopilot supports commanding attitude offboard.''')
MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED = 128 # Autopilot supports commanding position and velocity targets in local
                        # NED frame.
enums['MAV_PROTOCOL_CAPABILITY'][128] = EnumEntry('MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED', '''Autopilot supports commanding position and velocity targets in local NED frame.''')
MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT = 256 # Autopilot supports commanding position and velocity targets in global
                        # scaled integers.
enums['MAV_PROTOCOL_CAPABILITY'][256] = EnumEntry('MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT', '''Autopilot supports commanding position and velocity targets in global scaled integers.''')
MAV_PROTOCOL_CAPABILITY_TERRAIN = 512 # Autopilot supports terrain protocol / data handling.
enums['MAV_PROTOCOL_CAPABILITY'][512] = EnumEntry('MAV_PROTOCOL_CAPABILITY_TERRAIN', '''Autopilot supports terrain protocol / data handling.''')
MAV_PROTOCOL_CAPABILITY_SET_ACTUATOR_TARGET = 1024 # Autopilot supports direct actuator control.
enums['MAV_PROTOCOL_CAPABILITY'][1024] = EnumEntry('MAV_PROTOCOL_CAPABILITY_SET_ACTUATOR_TARGET', '''Autopilot supports direct actuator control.''')
MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION = 2048 # Autopilot supports the flight termination command.
enums['MAV_PROTOCOL_CAPABILITY'][2048] = EnumEntry('MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION', '''Autopilot supports the flight termination command.''')
MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION = 4096 # Autopilot supports onboard compass calibration.
enums['MAV_PROTOCOL_CAPABILITY'][4096] = EnumEntry('MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION', '''Autopilot supports onboard compass calibration.''')
MAV_PROTOCOL_CAPABILITY_MAVLINK2 = 8192 # Autopilot supports MAVLink version 2.
enums['MAV_PROTOCOL_CAPABILITY'][8192] = EnumEntry('MAV_PROTOCOL_CAPABILITY_MAVLINK2', '''Autopilot supports MAVLink version 2.''')
MAV_PROTOCOL_CAPABILITY_MISSION_FENCE = 16384 # Autopilot supports mission fence protocol.
enums['MAV_PROTOCOL_CAPABILITY'][16384] = EnumEntry('MAV_PROTOCOL_CAPABILITY_MISSION_FENCE', '''Autopilot supports mission fence protocol.''')
MAV_PROTOCOL_CAPABILITY_MISSION_RALLY = 32768 # Autopilot supports mission rally point protocol.
enums['MAV_PROTOCOL_CAPABILITY'][32768] = EnumEntry('MAV_PROTOCOL_CAPABILITY_MISSION_RALLY', '''Autopilot supports mission rally point protocol.''')
MAV_PROTOCOL_CAPABILITY_FLIGHT_INFORMATION = 65536 # Autopilot supports the flight information protocol.
enums['MAV_PROTOCOL_CAPABILITY'][65536] = EnumEntry('MAV_PROTOCOL_CAPABILITY_FLIGHT_INFORMATION', '''Autopilot supports the flight information protocol.''')
MAV_PROTOCOL_CAPABILITY_ENUM_END = 65537 # 
enums['MAV_PROTOCOL_CAPABILITY'][65537] = EnumEntry('MAV_PROTOCOL_CAPABILITY_ENUM_END', '''''')

# MAV_MISSION_TYPE
enums['MAV_MISSION_TYPE'] = {}
MAV_MISSION_TYPE_MISSION = 0 # Items are mission commands for main mission.
enums['MAV_MISSION_TYPE'][0] = EnumEntry('MAV_MISSION_TYPE_MISSION', '''Items are mission commands for main mission.''')
MAV_MISSION_TYPE_FENCE = 1 # Specifies GeoFence area(s). Items are MAV_CMD_NAV_FENCE_ GeoFence
                        # items.
enums['MAV_MISSION_TYPE'][1] = EnumEntry('MAV_MISSION_TYPE_FENCE', '''Specifies GeoFence area(s). Items are MAV_CMD_NAV_FENCE_ GeoFence items.''')
MAV_MISSION_TYPE_RALLY = 2 # Specifies the rally points for the vehicle. Rally points are
                        # alternative RTL points. Items are
                        # MAV_CMD_NAV_RALLY_POINT rally point items.
enums['MAV_MISSION_TYPE'][2] = EnumEntry('MAV_MISSION_TYPE_RALLY', '''Specifies the rally points for the vehicle. Rally points are alternative RTL points. Items are MAV_CMD_NAV_RALLY_POINT rally point items.''')
MAV_MISSION_TYPE_ALL = 255 # Only used in MISSION_CLEAR_ALL to clear all mission types.
enums['MAV_MISSION_TYPE'][255] = EnumEntry('MAV_MISSION_TYPE_ALL', '''Only used in MISSION_CLEAR_ALL to clear all mission types.''')
MAV_MISSION_TYPE_ENUM_END = 256 # 
enums['MAV_MISSION_TYPE'][256] = EnumEntry('MAV_MISSION_TYPE_ENUM_END', '''''')

# MAV_ESTIMATOR_TYPE
enums['MAV_ESTIMATOR_TYPE'] = {}
MAV_ESTIMATOR_TYPE_UNKNOWN = 0 # Unknown type of the estimator.
enums['MAV_ESTIMATOR_TYPE'][0] = EnumEntry('MAV_ESTIMATOR_TYPE_UNKNOWN', '''Unknown type of the estimator.''')
MAV_ESTIMATOR_TYPE_NAIVE = 1 # This is a naive estimator without any real covariance feedback.
enums['MAV_ESTIMATOR_TYPE'][1] = EnumEntry('MAV_ESTIMATOR_TYPE_NAIVE', '''This is a naive estimator without any real covariance feedback.''')
MAV_ESTIMATOR_TYPE_VISION = 2 # Computer vision based estimate. Might be up to scale.
enums['MAV_ESTIMATOR_TYPE'][2] = EnumEntry('MAV_ESTIMATOR_TYPE_VISION', '''Computer vision based estimate. Might be up to scale.''')
MAV_ESTIMATOR_TYPE_VIO = 3 # Visual-inertial estimate.
enums['MAV_ESTIMATOR_TYPE'][3] = EnumEntry('MAV_ESTIMATOR_TYPE_VIO', '''Visual-inertial estimate.''')
MAV_ESTIMATOR_TYPE_GPS = 4 # Plain GPS estimate.
enums['MAV_ESTIMATOR_TYPE'][4] = EnumEntry('MAV_ESTIMATOR_TYPE_GPS', '''Plain GPS estimate.''')
MAV_ESTIMATOR_TYPE_GPS_INS = 5 # Estimator integrating GPS and inertial sensing.
enums['MAV_ESTIMATOR_TYPE'][5] = EnumEntry('MAV_ESTIMATOR_TYPE_GPS_INS', '''Estimator integrating GPS and inertial sensing.''')
MAV_ESTIMATOR_TYPE_MOCAP = 6 # Estimate from external motion capturing system.
enums['MAV_ESTIMATOR_TYPE'][6] = EnumEntry('MAV_ESTIMATOR_TYPE_MOCAP', '''Estimate from external motion capturing system.''')
MAV_ESTIMATOR_TYPE_LIDAR = 7 # Estimator based on lidar sensor input.
enums['MAV_ESTIMATOR_TYPE'][7] = EnumEntry('MAV_ESTIMATOR_TYPE_LIDAR', '''Estimator based on lidar sensor input.''')
MAV_ESTIMATOR_TYPE_AUTOPILOT = 8 # Estimator on autopilot.
enums['MAV_ESTIMATOR_TYPE'][8] = EnumEntry('MAV_ESTIMATOR_TYPE_AUTOPILOT', '''Estimator on autopilot.''')
MAV_ESTIMATOR_TYPE_ENUM_END = 9 # 
enums['MAV_ESTIMATOR_TYPE'][9] = EnumEntry('MAV_ESTIMATOR_TYPE_ENUM_END', '''''')

# MAV_BATTERY_TYPE
enums['MAV_BATTERY_TYPE'] = {}
MAV_BATTERY_TYPE_UNKNOWN = 0 # Not specified.
enums['MAV_BATTERY_TYPE'][0] = EnumEntry('MAV_BATTERY_TYPE_UNKNOWN', '''Not specified.''')
MAV_BATTERY_TYPE_LIPO = 1 # Lithium polymer battery
enums['MAV_BATTERY_TYPE'][1] = EnumEntry('MAV_BATTERY_TYPE_LIPO', '''Lithium polymer battery''')
MAV_BATTERY_TYPE_LIFE = 2 # Lithium-iron-phosphate battery
enums['MAV_BATTERY_TYPE'][2] = EnumEntry('MAV_BATTERY_TYPE_LIFE', '''Lithium-iron-phosphate battery''')
MAV_BATTERY_TYPE_LION = 3 # Lithium-ION battery
enums['MAV_BATTERY_TYPE'][3] = EnumEntry('MAV_BATTERY_TYPE_LION', '''Lithium-ION battery''')
MAV_BATTERY_TYPE_NIMH = 4 # Nickel metal hydride battery
enums['MAV_BATTERY_TYPE'][4] = EnumEntry('MAV_BATTERY_TYPE_NIMH', '''Nickel metal hydride battery''')
MAV_BATTERY_TYPE_ENUM_END = 5 # 
enums['MAV_BATTERY_TYPE'][5] = EnumEntry('MAV_BATTERY_TYPE_ENUM_END', '''''')

# MAV_BATTERY_FUNCTION
enums['MAV_BATTERY_FUNCTION'] = {}
MAV_BATTERY_FUNCTION_UNKNOWN = 0 # Battery function is unknown
enums['MAV_BATTERY_FUNCTION'][0] = EnumEntry('MAV_BATTERY_FUNCTION_UNKNOWN', '''Battery function is unknown''')
MAV_BATTERY_FUNCTION_ALL = 1 # Battery supports all flight systems
enums['MAV_BATTERY_FUNCTION'][1] = EnumEntry('MAV_BATTERY_FUNCTION_ALL', '''Battery supports all flight systems''')
MAV_BATTERY_FUNCTION_PROPULSION = 2 # Battery for the propulsion system
enums['MAV_BATTERY_FUNCTION'][2] = EnumEntry('MAV_BATTERY_FUNCTION_PROPULSION', '''Battery for the propulsion system''')
MAV_BATTERY_FUNCTION_AVIONICS = 3 # Avionics battery
enums['MAV_BATTERY_FUNCTION'][3] = EnumEntry('MAV_BATTERY_FUNCTION_AVIONICS', '''Avionics battery''')
MAV_BATTERY_TYPE_PAYLOAD = 4 # Payload battery
enums['MAV_BATTERY_FUNCTION'][4] = EnumEntry('MAV_BATTERY_TYPE_PAYLOAD', '''Payload battery''')
MAV_BATTERY_FUNCTION_ENUM_END = 5 # 
enums['MAV_BATTERY_FUNCTION'][5] = EnumEntry('MAV_BATTERY_FUNCTION_ENUM_END', '''''')

# MAV_BATTERY_CHARGE_STATE
enums['MAV_BATTERY_CHARGE_STATE'] = {}
MAV_BATTERY_CHARGE_STATE_UNDEFINED = 0 # Low battery state is not provided
enums['MAV_BATTERY_CHARGE_STATE'][0] = EnumEntry('MAV_BATTERY_CHARGE_STATE_UNDEFINED', '''Low battery state is not provided''')
MAV_BATTERY_CHARGE_STATE_OK = 1 # Battery is not in low state. Normal operation.
enums['MAV_BATTERY_CHARGE_STATE'][1] = EnumEntry('MAV_BATTERY_CHARGE_STATE_OK', '''Battery is not in low state. Normal operation.''')
MAV_BATTERY_CHARGE_STATE_LOW = 2 # Battery state is low, warn and monitor close.
enums['MAV_BATTERY_CHARGE_STATE'][2] = EnumEntry('MAV_BATTERY_CHARGE_STATE_LOW', '''Battery state is low, warn and monitor close.''')
MAV_BATTERY_CHARGE_STATE_CRITICAL = 3 # Battery state is critical, return or abort immediately.
enums['MAV_BATTERY_CHARGE_STATE'][3] = EnumEntry('MAV_BATTERY_CHARGE_STATE_CRITICAL', '''Battery state is critical, return or abort immediately.''')
MAV_BATTERY_CHARGE_STATE_EMERGENCY = 4 # Battery state is too low for ordinary abort sequence. Perform fastest
                        # possible emergency stop to prevent damage.
enums['MAV_BATTERY_CHARGE_STATE'][4] = EnumEntry('MAV_BATTERY_CHARGE_STATE_EMERGENCY', '''Battery state is too low for ordinary abort sequence. Perform fastest possible emergency stop to prevent damage.''')
MAV_BATTERY_CHARGE_STATE_FAILED = 5 # Battery failed, damage unavoidable.
enums['MAV_BATTERY_CHARGE_STATE'][5] = EnumEntry('MAV_BATTERY_CHARGE_STATE_FAILED', '''Battery failed, damage unavoidable.''')
MAV_BATTERY_CHARGE_STATE_UNHEALTHY = 6 # Battery is diagnosed to be defective or an error occurred, usage is
                        # discouraged / prohibited.
enums['MAV_BATTERY_CHARGE_STATE'][6] = EnumEntry('MAV_BATTERY_CHARGE_STATE_UNHEALTHY', '''Battery is diagnosed to be defective or an error occurred, usage is discouraged / prohibited.''')
MAV_BATTERY_CHARGE_STATE_CHARGING = 7 # Battery is charging.
enums['MAV_BATTERY_CHARGE_STATE'][7] = EnumEntry('MAV_BATTERY_CHARGE_STATE_CHARGING', '''Battery is charging.''')
MAV_BATTERY_CHARGE_STATE_ENUM_END = 8 # 
enums['MAV_BATTERY_CHARGE_STATE'][8] = EnumEntry('MAV_BATTERY_CHARGE_STATE_ENUM_END', '''''')

# MAV_BATTERY_MODE
enums['MAV_BATTERY_MODE'] = {}
MAV_BATTERY_MODE_UNKNOWN = 0 # Battery mode not supported/unknown battery mode/normal operation.
enums['MAV_BATTERY_MODE'][0] = EnumEntry('MAV_BATTERY_MODE_UNKNOWN', '''Battery mode not supported/unknown battery mode/normal operation.''')
MAV_BATTERY_MODE_AUTO_DISCHARGING = 1 # Battery is auto discharging (towards storage level).
enums['MAV_BATTERY_MODE'][1] = EnumEntry('MAV_BATTERY_MODE_AUTO_DISCHARGING', '''Battery is auto discharging (towards storage level).''')
MAV_BATTERY_MODE_HOT_SWAP = 2 # Battery in hot-swap mode (current limited to prevent spikes that might
                        # damage sensitive electrical circuits).
enums['MAV_BATTERY_MODE'][2] = EnumEntry('MAV_BATTERY_MODE_HOT_SWAP', '''Battery in hot-swap mode (current limited to prevent spikes that might damage sensitive electrical circuits).''')
MAV_BATTERY_MODE_ENUM_END = 3 # 
enums['MAV_BATTERY_MODE'][3] = EnumEntry('MAV_BATTERY_MODE_ENUM_END', '''''')

# MAV_BATTERY_FAULT
enums['MAV_BATTERY_FAULT'] = {}
MAV_BATTERY_FAULT_DEEP_DISCHARGE = 1 # Battery has deep discharged.
enums['MAV_BATTERY_FAULT'][1] = EnumEntry('MAV_BATTERY_FAULT_DEEP_DISCHARGE', '''Battery has deep discharged.''')
MAV_BATTERY_FAULT_SPIKES = 2 # Voltage spikes.
enums['MAV_BATTERY_FAULT'][2] = EnumEntry('MAV_BATTERY_FAULT_SPIKES', '''Voltage spikes.''')
MAV_BATTERY_FAULT_CELL_FAIL = 4 # One or more cells have failed. Battery should also report
                        # MAV_BATTERY_CHARGE_STATE_FAILE (and should
                        # not be used).
enums['MAV_BATTERY_FAULT'][4] = EnumEntry('MAV_BATTERY_FAULT_CELL_FAIL', '''One or more cells have failed. Battery should also report MAV_BATTERY_CHARGE_STATE_FAILE (and should not be used).''')
MAV_BATTERY_FAULT_OVER_CURRENT = 8 # Over-current fault.
enums['MAV_BATTERY_FAULT'][8] = EnumEntry('MAV_BATTERY_FAULT_OVER_CURRENT', '''Over-current fault.''')
MAV_BATTERY_FAULT_OVER_TEMPERATURE = 16 # Over-temperature fault.
enums['MAV_BATTERY_FAULT'][16] = EnumEntry('MAV_BATTERY_FAULT_OVER_TEMPERATURE', '''Over-temperature fault.''')
MAV_BATTERY_FAULT_UNDER_TEMPERATURE = 32 # Under-temperature fault.
enums['MAV_BATTERY_FAULT'][32] = EnumEntry('MAV_BATTERY_FAULT_UNDER_TEMPERATURE', '''Under-temperature fault.''')
MAV_BATTERY_FAULT_INCOMPATIBLE_VOLTAGE = 64 # Vehicle voltage is not compatible with this battery (batteries on same
                        # power rail should have similar voltage).
enums['MAV_BATTERY_FAULT'][64] = EnumEntry('MAV_BATTERY_FAULT_INCOMPATIBLE_VOLTAGE', '''Vehicle voltage is not compatible with this battery (batteries on same power rail should have similar voltage).''')
MAV_BATTERY_FAULT_INCOMPATIBLE_FIRMWARE = 128 # Battery firmware is not compatible with current autopilot firmware.
enums['MAV_BATTERY_FAULT'][128] = EnumEntry('MAV_BATTERY_FAULT_INCOMPATIBLE_FIRMWARE', '''Battery firmware is not compatible with current autopilot firmware.''')
BATTERY_FAULT_INCOMPATIBLE_CELLS_CONFIGURATION = 256 # Battery is not compatible due to cell configuration (e.g. 5s1p when
                        # vehicle requires 6s).
enums['MAV_BATTERY_FAULT'][256] = EnumEntry('BATTERY_FAULT_INCOMPATIBLE_CELLS_CONFIGURATION', '''Battery is not compatible due to cell configuration (e.g. 5s1p when vehicle requires 6s).''')
MAV_BATTERY_FAULT_ENUM_END = 257 # 
enums['MAV_BATTERY_FAULT'][257] = EnumEntry('MAV_BATTERY_FAULT_ENUM_END', '''''')

# MAV_GENERATOR_STATUS_FLAG
enums['MAV_GENERATOR_STATUS_FLAG'] = {}
MAV_GENERATOR_STATUS_FLAG_OFF = 1 # Generator is off.
enums['MAV_GENERATOR_STATUS_FLAG'][1] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_OFF', '''Generator is off.''')
MAV_GENERATOR_STATUS_FLAG_READY = 2 # Generator is ready to start generating power.
enums['MAV_GENERATOR_STATUS_FLAG'][2] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_READY', '''Generator is ready to start generating power.''')
MAV_GENERATOR_STATUS_FLAG_GENERATING = 4 # Generator is generating power.
enums['MAV_GENERATOR_STATUS_FLAG'][4] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_GENERATING', '''Generator is generating power.''')
MAV_GENERATOR_STATUS_FLAG_CHARGING = 8 # Generator is charging the batteries (generating enough power to charge
                        # and provide the load).
enums['MAV_GENERATOR_STATUS_FLAG'][8] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_CHARGING', '''Generator is charging the batteries (generating enough power to charge and provide the load).''')
MAV_GENERATOR_STATUS_FLAG_REDUCED_POWER = 16 # Generator is operating at a reduced maximum power.
enums['MAV_GENERATOR_STATUS_FLAG'][16] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_REDUCED_POWER', '''Generator is operating at a reduced maximum power.''')
MAV_GENERATOR_STATUS_FLAG_MAXPOWER = 32 # Generator is providing the maximum output.
enums['MAV_GENERATOR_STATUS_FLAG'][32] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_MAXPOWER', '''Generator is providing the maximum output.''')
MAV_GENERATOR_STATUS_FLAG_OVERTEMP_WARNING = 64 # Generator is near the maximum operating temperature, cooling is
                        # insufficient.
enums['MAV_GENERATOR_STATUS_FLAG'][64] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_OVERTEMP_WARNING', '''Generator is near the maximum operating temperature, cooling is insufficient.''')
MAV_GENERATOR_STATUS_FLAG_OVERTEMP_FAULT = 128 # Generator hit the maximum operating temperature and shutdown.
enums['MAV_GENERATOR_STATUS_FLAG'][128] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_OVERTEMP_FAULT', '''Generator hit the maximum operating temperature and shutdown.''')
MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_WARNING = 256 # Power electronics are near the maximum operating temperature, cooling
                        # is insufficient.
enums['MAV_GENERATOR_STATUS_FLAG'][256] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_WARNING', '''Power electronics are near the maximum operating temperature, cooling is insufficient.''')
MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_FAULT = 512 # Power electronics hit the maximum operating temperature and shutdown.
enums['MAV_GENERATOR_STATUS_FLAG'][512] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_FAULT', '''Power electronics hit the maximum operating temperature and shutdown.''')
MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_FAULT = 1024 # Power electronics experienced a fault and shutdown.
enums['MAV_GENERATOR_STATUS_FLAG'][1024] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_FAULT', '''Power electronics experienced a fault and shutdown.''')
MAV_GENERATOR_STATUS_FLAG_POWERSOURCE_FAULT = 2048 # The power source supplying the generator failed e.g. mechanical
                        # generator stopped, tether is no longer
                        # providing power, solar cell is in shade,
                        # hydrogen reaction no longer happening.
enums['MAV_GENERATOR_STATUS_FLAG'][2048] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_POWERSOURCE_FAULT', '''The power source supplying the generator failed e.g. mechanical generator stopped, tether is no longer providing power, solar cell is in shade, hydrogen reaction no longer happening.''')
MAV_GENERATOR_STATUS_FLAG_COMMUNICATION_WARNING = 4096 # Generator controller having communication problems.
enums['MAV_GENERATOR_STATUS_FLAG'][4096] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_COMMUNICATION_WARNING', '''Generator controller having communication problems.''')
MAV_GENERATOR_STATUS_FLAG_COOLING_WARNING = 8192 # Power electronic or generator cooling system error.
enums['MAV_GENERATOR_STATUS_FLAG'][8192] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_COOLING_WARNING', '''Power electronic or generator cooling system error.''')
MAV_GENERATOR_STATUS_FLAG_POWER_RAIL_FAULT = 16384 # Generator controller power rail experienced a fault.
enums['MAV_GENERATOR_STATUS_FLAG'][16384] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_POWER_RAIL_FAULT', '''Generator controller power rail experienced a fault.''')
MAV_GENERATOR_STATUS_FLAG_OVERCURRENT_FAULT = 32768 # Generator controller exceeded the overcurrent threshold and shutdown
                        # to prevent damage.
enums['MAV_GENERATOR_STATUS_FLAG'][32768] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_OVERCURRENT_FAULT', '''Generator controller exceeded the overcurrent threshold and shutdown to prevent damage.''')
MAV_GENERATOR_STATUS_FLAG_BATTERY_OVERCHARGE_CURRENT_FAULT = 65536 # Generator controller detected a high current going into the batteries
                        # and shutdown to prevent battery damage.
enums['MAV_GENERATOR_STATUS_FLAG'][65536] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_BATTERY_OVERCHARGE_CURRENT_FAULT', '''Generator controller detected a high current going into the batteries and shutdown to prevent battery damage.''')
MAV_GENERATOR_STATUS_FLAG_OVERVOLTAGE_FAULT = 131072 # Generator controller exceeded it's overvoltage threshold and shutdown
                        # to prevent it exceeding the voltage rating.
enums['MAV_GENERATOR_STATUS_FLAG'][131072] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_OVERVOLTAGE_FAULT', '''Generator controller exceeded it's overvoltage threshold and shutdown to prevent it exceeding the voltage rating.''')
MAV_GENERATOR_STATUS_FLAG_BATTERY_UNDERVOLT_FAULT = 262144 # Batteries are under voltage (generator will not start).
enums['MAV_GENERATOR_STATUS_FLAG'][262144] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_BATTERY_UNDERVOLT_FAULT', '''Batteries are under voltage (generator will not start).''')
MAV_GENERATOR_STATUS_FLAG_START_INHIBITED = 524288 # Generator start is inhibited by e.g. a safety switch.
enums['MAV_GENERATOR_STATUS_FLAG'][524288] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_START_INHIBITED', '''Generator start is inhibited by e.g. a safety switch.''')
MAV_GENERATOR_STATUS_FLAG_MAINTENANCE_REQUIRED = 1048576 # Generator requires maintenance.
enums['MAV_GENERATOR_STATUS_FLAG'][1048576] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_MAINTENANCE_REQUIRED', '''Generator requires maintenance.''')
MAV_GENERATOR_STATUS_FLAG_WARMING_UP = 2097152 # Generator is not ready to generate yet.
enums['MAV_GENERATOR_STATUS_FLAG'][2097152] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_WARMING_UP', '''Generator is not ready to generate yet.''')
MAV_GENERATOR_STATUS_FLAG_IDLE = 4194304 # Generator is idle.
enums['MAV_GENERATOR_STATUS_FLAG'][4194304] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_IDLE', '''Generator is idle.''')
MAV_GENERATOR_STATUS_FLAG_ENUM_END = 4194305 # 
enums['MAV_GENERATOR_STATUS_FLAG'][4194305] = EnumEntry('MAV_GENERATOR_STATUS_FLAG_ENUM_END', '''''')

# MAV_VTOL_STATE
enums['MAV_VTOL_STATE'] = {}
MAV_VTOL_STATE_UNDEFINED = 0 # MAV is not configured as VTOL
enums['MAV_VTOL_STATE'][0] = EnumEntry('MAV_VTOL_STATE_UNDEFINED', '''MAV is not configured as VTOL''')
MAV_VTOL_STATE_TRANSITION_TO_FW = 1 # VTOL is in transition from multicopter to fixed-wing
enums['MAV_VTOL_STATE'][1] = EnumEntry('MAV_VTOL_STATE_TRANSITION_TO_FW', '''VTOL is in transition from multicopter to fixed-wing''')
MAV_VTOL_STATE_TRANSITION_TO_MC = 2 # VTOL is in transition from fixed-wing to multicopter
enums['MAV_VTOL_STATE'][2] = EnumEntry('MAV_VTOL_STATE_TRANSITION_TO_MC', '''VTOL is in transition from fixed-wing to multicopter''')
MAV_VTOL_STATE_MC = 3 # VTOL is in multicopter state
enums['MAV_VTOL_STATE'][3] = EnumEntry('MAV_VTOL_STATE_MC', '''VTOL is in multicopter state''')
MAV_VTOL_STATE_FW = 4 # VTOL is in fixed-wing state
enums['MAV_VTOL_STATE'][4] = EnumEntry('MAV_VTOL_STATE_FW', '''VTOL is in fixed-wing state''')
MAV_VTOL_STATE_ENUM_END = 5 # 
enums['MAV_VTOL_STATE'][5] = EnumEntry('MAV_VTOL_STATE_ENUM_END', '''''')

# MAV_LANDED_STATE
enums['MAV_LANDED_STATE'] = {}
MAV_LANDED_STATE_UNDEFINED = 0 # MAV landed state is unknown
enums['MAV_LANDED_STATE'][0] = EnumEntry('MAV_LANDED_STATE_UNDEFINED', '''MAV landed state is unknown''')
MAV_LANDED_STATE_ON_GROUND = 1 # MAV is landed (on ground)
enums['MAV_LANDED_STATE'][1] = EnumEntry('MAV_LANDED_STATE_ON_GROUND', '''MAV is landed (on ground)''')
MAV_LANDED_STATE_IN_AIR = 2 # MAV is in air
enums['MAV_LANDED_STATE'][2] = EnumEntry('MAV_LANDED_STATE_IN_AIR', '''MAV is in air''')
MAV_LANDED_STATE_TAKEOFF = 3 # MAV currently taking off
enums['MAV_LANDED_STATE'][3] = EnumEntry('MAV_LANDED_STATE_TAKEOFF', '''MAV currently taking off''')
MAV_LANDED_STATE_LANDING = 4 # MAV currently landing
enums['MAV_LANDED_STATE'][4] = EnumEntry('MAV_LANDED_STATE_LANDING', '''MAV currently landing''')
MAV_LANDED_STATE_ENUM_END = 5 # 
enums['MAV_LANDED_STATE'][5] = EnumEntry('MAV_LANDED_STATE_ENUM_END', '''''')

# ADSB_ALTITUDE_TYPE
enums['ADSB_ALTITUDE_TYPE'] = {}
ADSB_ALTITUDE_TYPE_PRESSURE_QNH = 0 # Altitude reported from a Baro source using QNH reference
enums['ADSB_ALTITUDE_TYPE'][0] = EnumEntry('ADSB_ALTITUDE_TYPE_PRESSURE_QNH', '''Altitude reported from a Baro source using QNH reference''')
ADSB_ALTITUDE_TYPE_GEOMETRIC = 1 # Altitude reported from a GNSS source
enums['ADSB_ALTITUDE_TYPE'][1] = EnumEntry('ADSB_ALTITUDE_TYPE_GEOMETRIC', '''Altitude reported from a GNSS source''')
ADSB_ALTITUDE_TYPE_ENUM_END = 2 # 
enums['ADSB_ALTITUDE_TYPE'][2] = EnumEntry('ADSB_ALTITUDE_TYPE_ENUM_END', '''''')

# ADSB_EMITTER_TYPE
enums['ADSB_EMITTER_TYPE'] = {}
ADSB_EMITTER_TYPE_NO_INFO = 0 # 
enums['ADSB_EMITTER_TYPE'][0] = EnumEntry('ADSB_EMITTER_TYPE_NO_INFO', '''''')
ADSB_EMITTER_TYPE_LIGHT = 1 # 
enums['ADSB_EMITTER_TYPE'][1] = EnumEntry('ADSB_EMITTER_TYPE_LIGHT', '''''')
ADSB_EMITTER_TYPE_SMALL = 2 # 
enums['ADSB_EMITTER_TYPE'][2] = EnumEntry('ADSB_EMITTER_TYPE_SMALL', '''''')
ADSB_EMITTER_TYPE_LARGE = 3 # 
enums['ADSB_EMITTER_TYPE'][3] = EnumEntry('ADSB_EMITTER_TYPE_LARGE', '''''')
ADSB_EMITTER_TYPE_HIGH_VORTEX_LARGE = 4 # 
enums['ADSB_EMITTER_TYPE'][4] = EnumEntry('ADSB_EMITTER_TYPE_HIGH_VORTEX_LARGE', '''''')
ADSB_EMITTER_TYPE_HEAVY = 5 # 
enums['ADSB_EMITTER_TYPE'][5] = EnumEntry('ADSB_EMITTER_TYPE_HEAVY', '''''')
ADSB_EMITTER_TYPE_HIGHLY_MANUV = 6 # 
enums['ADSB_EMITTER_TYPE'][6] = EnumEntry('ADSB_EMITTER_TYPE_HIGHLY_MANUV', '''''')
ADSB_EMITTER_TYPE_ROTOCRAFT = 7 # 
enums['ADSB_EMITTER_TYPE'][7] = EnumEntry('ADSB_EMITTER_TYPE_ROTOCRAFT', '''''')
ADSB_EMITTER_TYPE_UNASSIGNED = 8 # 
enums['ADSB_EMITTER_TYPE'][8] = EnumEntry('ADSB_EMITTER_TYPE_UNASSIGNED', '''''')
ADSB_EMITTER_TYPE_GLIDER = 9 # 
enums['ADSB_EMITTER_TYPE'][9] = EnumEntry('ADSB_EMITTER_TYPE_GLIDER', '''''')
ADSB_EMITTER_TYPE_LIGHTER_AIR = 10 # 
enums['ADSB_EMITTER_TYPE'][10] = EnumEntry('ADSB_EMITTER_TYPE_LIGHTER_AIR', '''''')
ADSB_EMITTER_TYPE_PARACHUTE = 11 # 
enums['ADSB_EMITTER_TYPE'][11] = EnumEntry('ADSB_EMITTER_TYPE_PARACHUTE', '''''')
ADSB_EMITTER_TYPE_ULTRA_LIGHT = 12 # 
enums['ADSB_EMITTER_TYPE'][12] = EnumEntry('ADSB_EMITTER_TYPE_ULTRA_LIGHT', '''''')
ADSB_EMITTER_TYPE_UNASSIGNED2 = 13 # 
enums['ADSB_EMITTER_TYPE'][13] = EnumEntry('ADSB_EMITTER_TYPE_UNASSIGNED2', '''''')
ADSB_EMITTER_TYPE_UAV = 14 # 
enums['ADSB_EMITTER_TYPE'][14] = EnumEntry('ADSB_EMITTER_TYPE_UAV', '''''')
ADSB_EMITTER_TYPE_SPACE = 15 # 
enums['ADSB_EMITTER_TYPE'][15] = EnumEntry('ADSB_EMITTER_TYPE_SPACE', '''''')
ADSB_EMITTER_TYPE_UNASSGINED3 = 16 # 
enums['ADSB_EMITTER_TYPE'][16] = EnumEntry('ADSB_EMITTER_TYPE_UNASSGINED3', '''''')
ADSB_EMITTER_TYPE_EMERGENCY_SURFACE = 17 # 
enums['ADSB_EMITTER_TYPE'][17] = EnumEntry('ADSB_EMITTER_TYPE_EMERGENCY_SURFACE', '''''')
ADSB_EMITTER_TYPE_SERVICE_SURFACE = 18 # 
enums['ADSB_EMITTER_TYPE'][18] = EnumEntry('ADSB_EMITTER_TYPE_SERVICE_SURFACE', '''''')
ADSB_EMITTER_TYPE_POINT_OBSTACLE = 19 # 
enums['ADSB_EMITTER_TYPE'][19] = EnumEntry('ADSB_EMITTER_TYPE_POINT_OBSTACLE', '''''')
ADSB_EMITTER_TYPE_ENUM_END = 20 # 
enums['ADSB_EMITTER_TYPE'][20] = EnumEntry('ADSB_EMITTER_TYPE_ENUM_END', '''''')

# ADSB_FLAGS
enums['ADSB_FLAGS'] = {}
ADSB_FLAGS_VALID_COORDS = 1 # 
enums['ADSB_FLAGS'][1] = EnumEntry('ADSB_FLAGS_VALID_COORDS', '''''')
ADSB_FLAGS_VALID_ALTITUDE = 2 # 
enums['ADSB_FLAGS'][2] = EnumEntry('ADSB_FLAGS_VALID_ALTITUDE', '''''')
ADSB_FLAGS_VALID_HEADING = 4 # 
enums['ADSB_FLAGS'][4] = EnumEntry('ADSB_FLAGS_VALID_HEADING', '''''')
ADSB_FLAGS_VALID_VELOCITY = 8 # 
enums['ADSB_FLAGS'][8] = EnumEntry('ADSB_FLAGS_VALID_VELOCITY', '''''')
ADSB_FLAGS_VALID_CALLSIGN = 16 # 
enums['ADSB_FLAGS'][16] = EnumEntry('ADSB_FLAGS_VALID_CALLSIGN', '''''')
ADSB_FLAGS_VALID_SQUAWK = 32 # 
enums['ADSB_FLAGS'][32] = EnumEntry('ADSB_FLAGS_VALID_SQUAWK', '''''')
ADSB_FLAGS_SIMULATED = 64 # 
enums['ADSB_FLAGS'][64] = EnumEntry('ADSB_FLAGS_SIMULATED', '''''')
ADSB_FLAGS_VERTICAL_VELOCITY_VALID = 128 # 
enums['ADSB_FLAGS'][128] = EnumEntry('ADSB_FLAGS_VERTICAL_VELOCITY_VALID', '''''')
ADSB_FLAGS_BARO_VALID = 256 # 
enums['ADSB_FLAGS'][256] = EnumEntry('ADSB_FLAGS_BARO_VALID', '''''')
ADSB_FLAGS_SOURCE_UAT = 32768 # 
enums['ADSB_FLAGS'][32768] = EnumEntry('ADSB_FLAGS_SOURCE_UAT', '''''')
ADSB_FLAGS_ENUM_END = 32769 # 
enums['ADSB_FLAGS'][32769] = EnumEntry('ADSB_FLAGS_ENUM_END', '''''')

# MAV_DO_REPOSITION_FLAGS
enums['MAV_DO_REPOSITION_FLAGS'] = {}
MAV_DO_REPOSITION_FLAGS_CHANGE_MODE = 1 # The aircraft should immediately transition into guided. This should
                        # not be set for follow me applications
enums['MAV_DO_REPOSITION_FLAGS'][1] = EnumEntry('MAV_DO_REPOSITION_FLAGS_CHANGE_MODE', '''The aircraft should immediately transition into guided. This should not be set for follow me applications''')
MAV_DO_REPOSITION_FLAGS_ENUM_END = 2 # 
enums['MAV_DO_REPOSITION_FLAGS'][2] = EnumEntry('MAV_DO_REPOSITION_FLAGS_ENUM_END', '''''')

# ESTIMATOR_STATUS_FLAGS
enums['ESTIMATOR_STATUS_FLAGS'] = {}
ESTIMATOR_ATTITUDE = 1 # True if the attitude estimate is good
enums['ESTIMATOR_STATUS_FLAGS'][1] = EnumEntry('ESTIMATOR_ATTITUDE', '''True if the attitude estimate is good''')
ESTIMATOR_VELOCITY_HORIZ = 2 # True if the horizontal velocity estimate is good
enums['ESTIMATOR_STATUS_FLAGS'][2] = EnumEntry('ESTIMATOR_VELOCITY_HORIZ', '''True if the horizontal velocity estimate is good''')
ESTIMATOR_VELOCITY_VERT = 4 # True if the  vertical velocity estimate is good
enums['ESTIMATOR_STATUS_FLAGS'][4] = EnumEntry('ESTIMATOR_VELOCITY_VERT', '''True if the  vertical velocity estimate is good''')
ESTIMATOR_POS_HORIZ_REL = 8 # True if the horizontal position (relative) estimate is good
enums['ESTIMATOR_STATUS_FLAGS'][8] = EnumEntry('ESTIMATOR_POS_HORIZ_REL', '''True if the horizontal position (relative) estimate is good''')
ESTIMATOR_POS_HORIZ_ABS = 16 # True if the horizontal position (absolute) estimate is good
enums['ESTIMATOR_STATUS_FLAGS'][16] = EnumEntry('ESTIMATOR_POS_HORIZ_ABS', '''True if the horizontal position (absolute) estimate is good''')
ESTIMATOR_POS_VERT_ABS = 32 # True if the vertical position (absolute) estimate is good
enums['ESTIMATOR_STATUS_FLAGS'][32] = EnumEntry('ESTIMATOR_POS_VERT_ABS', '''True if the vertical position (absolute) estimate is good''')
ESTIMATOR_POS_VERT_AGL = 64 # True if the vertical position (above ground) estimate is good
enums['ESTIMATOR_STATUS_FLAGS'][64] = EnumEntry('ESTIMATOR_POS_VERT_AGL', '''True if the vertical position (above ground) estimate is good''')
ESTIMATOR_CONST_POS_MODE = 128 # True if the EKF is in a constant position mode and is not using
                        # external measurements (eg GPS or optical
                        # flow)
enums['ESTIMATOR_STATUS_FLAGS'][128] = EnumEntry('ESTIMATOR_CONST_POS_MODE', '''True if the EKF is in a constant position mode and is not using external measurements (eg GPS or optical flow)''')
ESTIMATOR_PRED_POS_HORIZ_REL = 256 # True if the EKF has sufficient data to enter a mode that will provide
                        # a (relative) position estimate
enums['ESTIMATOR_STATUS_FLAGS'][256] = EnumEntry('ESTIMATOR_PRED_POS_HORIZ_REL', '''True if the EKF has sufficient data to enter a mode that will provide a (relative) position estimate''')
ESTIMATOR_PRED_POS_HORIZ_ABS = 512 # True if the EKF has sufficient data to enter a mode that will provide
                        # a (absolute) position estimate
enums['ESTIMATOR_STATUS_FLAGS'][512] = EnumEntry('ESTIMATOR_PRED_POS_HORIZ_ABS', '''True if the EKF has sufficient data to enter a mode that will provide a (absolute) position estimate''')
ESTIMATOR_GPS_GLITCH = 1024 # True if the EKF has detected a GPS glitch
enums['ESTIMATOR_STATUS_FLAGS'][1024] = EnumEntry('ESTIMATOR_GPS_GLITCH', '''True if the EKF has detected a GPS glitch''')
ESTIMATOR_ACCEL_ERROR = 2048 # True if the EKF has detected bad accelerometer data
enums['ESTIMATOR_STATUS_FLAGS'][2048] = EnumEntry('ESTIMATOR_ACCEL_ERROR', '''True if the EKF has detected bad accelerometer data''')
ESTIMATOR_STATUS_FLAGS_ENUM_END = 2049 # 
enums['ESTIMATOR_STATUS_FLAGS'][2049] = EnumEntry('ESTIMATOR_STATUS_FLAGS_ENUM_END', '''''')

# MOTOR_TEST_ORDER
enums['MOTOR_TEST_ORDER'] = {}
MOTOR_TEST_ORDER_DEFAULT = 0 # default autopilot motor test method
enums['MOTOR_TEST_ORDER'][0] = EnumEntry('MOTOR_TEST_ORDER_DEFAULT', '''default autopilot motor test method''')
MOTOR_TEST_ORDER_SEQUENCE = 1 # motor numbers are specified as their index in a predefined vehicle-
                        # specific sequence
enums['MOTOR_TEST_ORDER'][1] = EnumEntry('MOTOR_TEST_ORDER_SEQUENCE', '''motor numbers are specified as their index in a predefined vehicle-specific sequence''')
MOTOR_TEST_ORDER_BOARD = 2 # motor numbers are specified as the output as labeled on the board
enums['MOTOR_TEST_ORDER'][2] = EnumEntry('MOTOR_TEST_ORDER_BOARD', '''motor numbers are specified as the output as labeled on the board''')
MOTOR_TEST_ORDER_ENUM_END = 3 # 
enums['MOTOR_TEST_ORDER'][3] = EnumEntry('MOTOR_TEST_ORDER_ENUM_END', '''''')

# MOTOR_TEST_THROTTLE_TYPE
enums['MOTOR_TEST_THROTTLE_TYPE'] = {}
MOTOR_TEST_THROTTLE_PERCENT = 0 # throttle as a percentage from 0 ~ 100
enums['MOTOR_TEST_THROTTLE_TYPE'][0] = EnumEntry('MOTOR_TEST_THROTTLE_PERCENT', '''throttle as a percentage from 0 ~ 100''')
MOTOR_TEST_THROTTLE_PWM = 1 # throttle as an absolute PWM value (normally in range of 1000~2000)
enums['MOTOR_TEST_THROTTLE_TYPE'][1] = EnumEntry('MOTOR_TEST_THROTTLE_PWM', '''throttle as an absolute PWM value (normally in range of 1000~2000)''')
MOTOR_TEST_THROTTLE_PILOT = 2 # throttle pass-through from pilot's transmitter
enums['MOTOR_TEST_THROTTLE_TYPE'][2] = EnumEntry('MOTOR_TEST_THROTTLE_PILOT', '''throttle pass-through from pilot's transmitter''')
MOTOR_TEST_COMPASS_CAL = 3 # per-motor compass calibration test
enums['MOTOR_TEST_THROTTLE_TYPE'][3] = EnumEntry('MOTOR_TEST_COMPASS_CAL', '''per-motor compass calibration test''')
MOTOR_TEST_THROTTLE_TYPE_ENUM_END = 4 # 
enums['MOTOR_TEST_THROTTLE_TYPE'][4] = EnumEntry('MOTOR_TEST_THROTTLE_TYPE_ENUM_END', '''''')

# GPS_INPUT_IGNORE_FLAGS
enums['GPS_INPUT_IGNORE_FLAGS'] = {}
GPS_INPUT_IGNORE_FLAG_ALT = 1 # ignore altitude field
enums['GPS_INPUT_IGNORE_FLAGS'][1] = EnumEntry('GPS_INPUT_IGNORE_FLAG_ALT', '''ignore altitude field''')
GPS_INPUT_IGNORE_FLAG_HDOP = 2 # ignore hdop field
enums['GPS_INPUT_IGNORE_FLAGS'][2] = EnumEntry('GPS_INPUT_IGNORE_FLAG_HDOP', '''ignore hdop field''')
GPS_INPUT_IGNORE_FLAG_VDOP = 4 # ignore vdop field
enums['GPS_INPUT_IGNORE_FLAGS'][4] = EnumEntry('GPS_INPUT_IGNORE_FLAG_VDOP', '''ignore vdop field''')
GPS_INPUT_IGNORE_FLAG_VEL_HORIZ = 8 # ignore horizontal velocity field (vn and ve)
enums['GPS_INPUT_IGNORE_FLAGS'][8] = EnumEntry('GPS_INPUT_IGNORE_FLAG_VEL_HORIZ', '''ignore horizontal velocity field (vn and ve)''')
GPS_INPUT_IGNORE_FLAG_VEL_VERT = 16 # ignore vertical velocity field (vd)
enums['GPS_INPUT_IGNORE_FLAGS'][16] = EnumEntry('GPS_INPUT_IGNORE_FLAG_VEL_VERT', '''ignore vertical velocity field (vd)''')
GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY = 32 # ignore speed accuracy field
enums['GPS_INPUT_IGNORE_FLAGS'][32] = EnumEntry('GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY', '''ignore speed accuracy field''')
GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY = 64 # ignore horizontal accuracy field
enums['GPS_INPUT_IGNORE_FLAGS'][64] = EnumEntry('GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY', '''ignore horizontal accuracy field''')
GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY = 128 # ignore vertical accuracy field
enums['GPS_INPUT_IGNORE_FLAGS'][128] = EnumEntry('GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY', '''ignore vertical accuracy field''')
GPS_INPUT_IGNORE_FLAGS_ENUM_END = 129 # 
enums['GPS_INPUT_IGNORE_FLAGS'][129] = EnumEntry('GPS_INPUT_IGNORE_FLAGS_ENUM_END', '''''')

# MAV_COLLISION_ACTION
enums['MAV_COLLISION_ACTION'] = {}
MAV_COLLISION_ACTION_NONE = 0 # Ignore any potential collisions
enums['MAV_COLLISION_ACTION'][0] = EnumEntry('MAV_COLLISION_ACTION_NONE', '''Ignore any potential collisions''')
MAV_COLLISION_ACTION_REPORT = 1 # Report potential collision
enums['MAV_COLLISION_ACTION'][1] = EnumEntry('MAV_COLLISION_ACTION_REPORT', '''Report potential collision''')
MAV_COLLISION_ACTION_ASCEND_OR_DESCEND = 2 # Ascend or Descend to avoid threat
enums['MAV_COLLISION_ACTION'][2] = EnumEntry('MAV_COLLISION_ACTION_ASCEND_OR_DESCEND', '''Ascend or Descend to avoid threat''')
MAV_COLLISION_ACTION_MOVE_HORIZONTALLY = 3 # Move horizontally to avoid threat
enums['MAV_COLLISION_ACTION'][3] = EnumEntry('MAV_COLLISION_ACTION_MOVE_HORIZONTALLY', '''Move horizontally to avoid threat''')
MAV_COLLISION_ACTION_MOVE_PERPENDICULAR = 4 # Aircraft to move perpendicular to the collision's velocity vector
enums['MAV_COLLISION_ACTION'][4] = EnumEntry('MAV_COLLISION_ACTION_MOVE_PERPENDICULAR', '''Aircraft to move perpendicular to the collision's velocity vector''')
MAV_COLLISION_ACTION_RTL = 5 # Aircraft to fly directly back to its launch point
enums['MAV_COLLISION_ACTION'][5] = EnumEntry('MAV_COLLISION_ACTION_RTL', '''Aircraft to fly directly back to its launch point''')
MAV_COLLISION_ACTION_HOVER = 6 # Aircraft to stop in place
enums['MAV_COLLISION_ACTION'][6] = EnumEntry('MAV_COLLISION_ACTION_HOVER', '''Aircraft to stop in place''')
MAV_COLLISION_ACTION_ENUM_END = 7 # 
enums['MAV_COLLISION_ACTION'][7] = EnumEntry('MAV_COLLISION_ACTION_ENUM_END', '''''')

# MAV_COLLISION_THREAT_LEVEL
enums['MAV_COLLISION_THREAT_LEVEL'] = {}
MAV_COLLISION_THREAT_LEVEL_NONE = 0 # Not a threat
enums['MAV_COLLISION_THREAT_LEVEL'][0] = EnumEntry('MAV_COLLISION_THREAT_LEVEL_NONE', '''Not a threat''')
MAV_COLLISION_THREAT_LEVEL_LOW = 1 # Craft is mildly concerned about this threat
enums['MAV_COLLISION_THREAT_LEVEL'][1] = EnumEntry('MAV_COLLISION_THREAT_LEVEL_LOW', '''Craft is mildly concerned about this threat''')
MAV_COLLISION_THREAT_LEVEL_HIGH = 2 # Craft is panicking, and may take actions to avoid threat
enums['MAV_COLLISION_THREAT_LEVEL'][2] = EnumEntry('MAV_COLLISION_THREAT_LEVEL_HIGH', '''Craft is panicking, and may take actions to avoid threat''')
MAV_COLLISION_THREAT_LEVEL_ENUM_END = 3 # 
enums['MAV_COLLISION_THREAT_LEVEL'][3] = EnumEntry('MAV_COLLISION_THREAT_LEVEL_ENUM_END', '''''')

# MAV_COLLISION_SRC
enums['MAV_COLLISION_SRC'] = {}
MAV_COLLISION_SRC_ADSB = 0 # ID field references ADSB_VEHICLE packets
enums['MAV_COLLISION_SRC'][0] = EnumEntry('MAV_COLLISION_SRC_ADSB', '''ID field references ADSB_VEHICLE packets''')
MAV_COLLISION_SRC_MAVLINK_GPS_GLOBAL_INT = 1 # ID field references MAVLink SRC ID
enums['MAV_COLLISION_SRC'][1] = EnumEntry('MAV_COLLISION_SRC_MAVLINK_GPS_GLOBAL_INT', '''ID field references MAVLink SRC ID''')
MAV_COLLISION_SRC_ENUM_END = 2 # 
enums['MAV_COLLISION_SRC'][2] = EnumEntry('MAV_COLLISION_SRC_ENUM_END', '''''')

# GPS_FIX_TYPE
enums['GPS_FIX_TYPE'] = {}
GPS_FIX_TYPE_NO_GPS = 0 # No GPS connected
enums['GPS_FIX_TYPE'][0] = EnumEntry('GPS_FIX_TYPE_NO_GPS', '''No GPS connected''')
GPS_FIX_TYPE_NO_FIX = 1 # No position information, GPS is connected
enums['GPS_FIX_TYPE'][1] = EnumEntry('GPS_FIX_TYPE_NO_FIX', '''No position information, GPS is connected''')
GPS_FIX_TYPE_2D_FIX = 2 # 2D position
enums['GPS_FIX_TYPE'][2] = EnumEntry('GPS_FIX_TYPE_2D_FIX', '''2D position''')
GPS_FIX_TYPE_3D_FIX = 3 # 3D position
enums['GPS_FIX_TYPE'][3] = EnumEntry('GPS_FIX_TYPE_3D_FIX', '''3D position''')
GPS_FIX_TYPE_DGPS = 4 # DGPS/SBAS aided 3D position
enums['GPS_FIX_TYPE'][4] = EnumEntry('GPS_FIX_TYPE_DGPS', '''DGPS/SBAS aided 3D position''')
GPS_FIX_TYPE_RTK_FLOAT = 5 # RTK float, 3D position
enums['GPS_FIX_TYPE'][5] = EnumEntry('GPS_FIX_TYPE_RTK_FLOAT', '''RTK float, 3D position''')
GPS_FIX_TYPE_RTK_FIXED = 6 # RTK Fixed, 3D position
enums['GPS_FIX_TYPE'][6] = EnumEntry('GPS_FIX_TYPE_RTK_FIXED', '''RTK Fixed, 3D position''')
GPS_FIX_TYPE_STATIC = 7 # Static fixed, typically used for base stations
enums['GPS_FIX_TYPE'][7] = EnumEntry('GPS_FIX_TYPE_STATIC', '''Static fixed, typically used for base stations''')
GPS_FIX_TYPE_PPP = 8 # PPP, 3D position.
enums['GPS_FIX_TYPE'][8] = EnumEntry('GPS_FIX_TYPE_PPP', '''PPP, 3D position.''')
GPS_FIX_TYPE_ENUM_END = 9 # 
enums['GPS_FIX_TYPE'][9] = EnumEntry('GPS_FIX_TYPE_ENUM_END', '''''')

# RTK_BASELINE_COORDINATE_SYSTEM
enums['RTK_BASELINE_COORDINATE_SYSTEM'] = {}
RTK_BASELINE_COORDINATE_SYSTEM_ECEF = 0 # Earth-centered, Earth-fixed
enums['RTK_BASELINE_COORDINATE_SYSTEM'][0] = EnumEntry('RTK_BASELINE_COORDINATE_SYSTEM_ECEF', '''Earth-centered, Earth-fixed''')
RTK_BASELINE_COORDINATE_SYSTEM_NED = 1 # RTK basestation centered, north, east, down
enums['RTK_BASELINE_COORDINATE_SYSTEM'][1] = EnumEntry('RTK_BASELINE_COORDINATE_SYSTEM_NED', '''RTK basestation centered, north, east, down''')
RTK_BASELINE_COORDINATE_SYSTEM_ENUM_END = 2 # 
enums['RTK_BASELINE_COORDINATE_SYSTEM'][2] = EnumEntry('RTK_BASELINE_COORDINATE_SYSTEM_ENUM_END', '''''')

# LANDING_TARGET_TYPE
enums['LANDING_TARGET_TYPE'] = {}
LANDING_TARGET_TYPE_LIGHT_BEACON = 0 # Landing target signaled by light beacon (ex: IR-LOCK)
enums['LANDING_TARGET_TYPE'][0] = EnumEntry('LANDING_TARGET_TYPE_LIGHT_BEACON', '''Landing target signaled by light beacon (ex: IR-LOCK)''')
LANDING_TARGET_TYPE_RADIO_BEACON = 1 # Landing target signaled by radio beacon (ex: ILS, NDB)
enums['LANDING_TARGET_TYPE'][1] = EnumEntry('LANDING_TARGET_TYPE_RADIO_BEACON', '''Landing target signaled by radio beacon (ex: ILS, NDB)''')
LANDING_TARGET_TYPE_VISION_FIDUCIAL = 2 # Landing target represented by a fiducial marker (ex: ARTag)
enums['LANDING_TARGET_TYPE'][2] = EnumEntry('LANDING_TARGET_TYPE_VISION_FIDUCIAL', '''Landing target represented by a fiducial marker (ex: ARTag)''')
LANDING_TARGET_TYPE_VISION_OTHER = 3 # Landing target represented by a pre-defined visual shape/feature (ex:
                        # X-marker, H-marker, square)
enums['LANDING_TARGET_TYPE'][3] = EnumEntry('LANDING_TARGET_TYPE_VISION_OTHER', '''Landing target represented by a pre-defined visual shape/feature (ex: X-marker, H-marker, square)''')
LANDING_TARGET_TYPE_ENUM_END = 4 # 
enums['LANDING_TARGET_TYPE'][4] = EnumEntry('LANDING_TARGET_TYPE_ENUM_END', '''''')

# VTOL_TRANSITION_HEADING
enums['VTOL_TRANSITION_HEADING'] = {}
VTOL_TRANSITION_HEADING_VEHICLE_DEFAULT = 0 # Respect the heading configuration of the vehicle.
enums['VTOL_TRANSITION_HEADING'][0] = EnumEntry('VTOL_TRANSITION_HEADING_VEHICLE_DEFAULT', '''Respect the heading configuration of the vehicle.''')
VTOL_TRANSITION_HEADING_NEXT_WAYPOINT = 1 # Use the heading pointing towards the next waypoint.
enums['VTOL_TRANSITION_HEADING'][1] = EnumEntry('VTOL_TRANSITION_HEADING_NEXT_WAYPOINT', '''Use the heading pointing towards the next waypoint.''')
VTOL_TRANSITION_HEADING_TAKEOFF = 2 # Use the heading on takeoff (while sitting on the ground).
enums['VTOL_TRANSITION_HEADING'][2] = EnumEntry('VTOL_TRANSITION_HEADING_TAKEOFF', '''Use the heading on takeoff (while sitting on the ground).''')
VTOL_TRANSITION_HEADING_SPECIFIED = 3 # Use the specified heading in parameter 4.
enums['VTOL_TRANSITION_HEADING'][3] = EnumEntry('VTOL_TRANSITION_HEADING_SPECIFIED', '''Use the specified heading in parameter 4.''')
VTOL_TRANSITION_HEADING_ANY = 4 # Use the current heading when reaching takeoff altitude (potentially
                        # facing the wind when weather-vaning is
                        # active).
enums['VTOL_TRANSITION_HEADING'][4] = EnumEntry('VTOL_TRANSITION_HEADING_ANY', '''Use the current heading when reaching takeoff altitude (potentially facing the wind when weather-vaning is active).''')
VTOL_TRANSITION_HEADING_ENUM_END = 5 # 
enums['VTOL_TRANSITION_HEADING'][5] = EnumEntry('VTOL_TRANSITION_HEADING_ENUM_END', '''''')

# CAMERA_CAP_FLAGS
enums['CAMERA_CAP_FLAGS'] = {}
CAMERA_CAP_FLAGS_CAPTURE_VIDEO = 1 # Camera is able to record video
enums['CAMERA_CAP_FLAGS'][1] = EnumEntry('CAMERA_CAP_FLAGS_CAPTURE_VIDEO', '''Camera is able to record video''')
CAMERA_CAP_FLAGS_CAPTURE_IMAGE = 2 # Camera is able to capture images
enums['CAMERA_CAP_FLAGS'][2] = EnumEntry('CAMERA_CAP_FLAGS_CAPTURE_IMAGE', '''Camera is able to capture images''')
CAMERA_CAP_FLAGS_HAS_MODES = 4 # Camera has separate Video and Image/Photo modes
                        # (MAV_CMD_SET_CAMERA_MODE)
enums['CAMERA_CAP_FLAGS'][4] = EnumEntry('CAMERA_CAP_FLAGS_HAS_MODES', '''Camera has separate Video and Image/Photo modes (MAV_CMD_SET_CAMERA_MODE)''')
CAMERA_CAP_FLAGS_CAN_CAPTURE_IMAGE_IN_VIDEO_MODE = 8 # Camera can capture images while in video mode
enums['CAMERA_CAP_FLAGS'][8] = EnumEntry('CAMERA_CAP_FLAGS_CAN_CAPTURE_IMAGE_IN_VIDEO_MODE', '''Camera can capture images while in video mode''')
CAMERA_CAP_FLAGS_CAN_CAPTURE_VIDEO_IN_IMAGE_MODE = 16 # Camera can capture videos while in Photo/Image mode
enums['CAMERA_CAP_FLAGS'][16] = EnumEntry('CAMERA_CAP_FLAGS_CAN_CAPTURE_VIDEO_IN_IMAGE_MODE', '''Camera can capture videos while in Photo/Image mode''')
CAMERA_CAP_FLAGS_HAS_IMAGE_SURVEY_MODE = 32 # Camera has image survey mode (MAV_CMD_SET_CAMERA_MODE)
enums['CAMERA_CAP_FLAGS'][32] = EnumEntry('CAMERA_CAP_FLAGS_HAS_IMAGE_SURVEY_MODE', '''Camera has image survey mode (MAV_CMD_SET_CAMERA_MODE)''')
CAMERA_CAP_FLAGS_HAS_BASIC_ZOOM = 64 # Camera has basic zoom control (MAV_CMD_SET_CAMERA_ZOOM)
enums['CAMERA_CAP_FLAGS'][64] = EnumEntry('CAMERA_CAP_FLAGS_HAS_BASIC_ZOOM', '''Camera has basic zoom control (MAV_CMD_SET_CAMERA_ZOOM)''')
CAMERA_CAP_FLAGS_HAS_BASIC_FOCUS = 128 # Camera has basic focus control (MAV_CMD_SET_CAMERA_FOCUS)
enums['CAMERA_CAP_FLAGS'][128] = EnumEntry('CAMERA_CAP_FLAGS_HAS_BASIC_FOCUS', '''Camera has basic focus control (MAV_CMD_SET_CAMERA_FOCUS)''')
CAMERA_CAP_FLAGS_HAS_VIDEO_STREAM = 256 # Camera has video streaming capabilities (request
                        # VIDEO_STREAM_INFORMATION with
                        # MAV_CMD_REQUEST_MESSAGE for video streaming
                        # info)
enums['CAMERA_CAP_FLAGS'][256] = EnumEntry('CAMERA_CAP_FLAGS_HAS_VIDEO_STREAM', '''Camera has video streaming capabilities (request VIDEO_STREAM_INFORMATION with MAV_CMD_REQUEST_MESSAGE for video streaming info)''')
CAMERA_CAP_FLAGS_HAS_TRACKING_POINT = 512 # Camera supports tracking of a point on the camera view.
enums['CAMERA_CAP_FLAGS'][512] = EnumEntry('CAMERA_CAP_FLAGS_HAS_TRACKING_POINT', '''Camera supports tracking of a point on the camera view.''')
CAMERA_CAP_FLAGS_HAS_TRACKING_RECTANGLE = 1024 # Camera supports tracking of a selection rectangle on the camera view.
enums['CAMERA_CAP_FLAGS'][1024] = EnumEntry('CAMERA_CAP_FLAGS_HAS_TRACKING_RECTANGLE', '''Camera supports tracking of a selection rectangle on the camera view.''')
CAMERA_CAP_FLAGS_HAS_TRACKING_GEO_STATUS = 2048 # Camera supports tracking geo status (CAMERA_TRACKING_GEO_STATUS).
enums['CAMERA_CAP_FLAGS'][2048] = EnumEntry('CAMERA_CAP_FLAGS_HAS_TRACKING_GEO_STATUS', '''Camera supports tracking geo status (CAMERA_TRACKING_GEO_STATUS).''')
CAMERA_CAP_FLAGS_ENUM_END = 2049 # 
enums['CAMERA_CAP_FLAGS'][2049] = EnumEntry('CAMERA_CAP_FLAGS_ENUM_END', '''''')

# VIDEO_STREAM_STATUS_FLAGS
enums['VIDEO_STREAM_STATUS_FLAGS'] = {}
VIDEO_STREAM_STATUS_FLAGS_RUNNING = 1 # Stream is active (running)
enums['VIDEO_STREAM_STATUS_FLAGS'][1] = EnumEntry('VIDEO_STREAM_STATUS_FLAGS_RUNNING', '''Stream is active (running)''')
VIDEO_STREAM_STATUS_FLAGS_THERMAL = 2 # Stream is thermal imaging
enums['VIDEO_STREAM_STATUS_FLAGS'][2] = EnumEntry('VIDEO_STREAM_STATUS_FLAGS_THERMAL', '''Stream is thermal imaging''')
VIDEO_STREAM_STATUS_FLAGS_ENUM_END = 3 # 
enums['VIDEO_STREAM_STATUS_FLAGS'][3] = EnumEntry('VIDEO_STREAM_STATUS_FLAGS_ENUM_END', '''''')

# VIDEO_STREAM_TYPE
enums['VIDEO_STREAM_TYPE'] = {}
VIDEO_STREAM_TYPE_RTSP = 0 # Stream is RTSP
enums['VIDEO_STREAM_TYPE'][0] = EnumEntry('VIDEO_STREAM_TYPE_RTSP', '''Stream is RTSP''')
VIDEO_STREAM_TYPE_RTPUDP = 1 # Stream is RTP UDP (URI gives the port number)
enums['VIDEO_STREAM_TYPE'][1] = EnumEntry('VIDEO_STREAM_TYPE_RTPUDP', '''Stream is RTP UDP (URI gives the port number)''')
VIDEO_STREAM_TYPE_TCP_MPEG = 2 # Stream is MPEG on TCP
enums['VIDEO_STREAM_TYPE'][2] = EnumEntry('VIDEO_STREAM_TYPE_TCP_MPEG', '''Stream is MPEG on TCP''')
VIDEO_STREAM_TYPE_MPEG_TS_H264 = 3 # Stream is h.264 on MPEG TS (URI gives the port number)
enums['VIDEO_STREAM_TYPE'][3] = EnumEntry('VIDEO_STREAM_TYPE_MPEG_TS_H264', '''Stream is h.264 on MPEG TS (URI gives the port number)''')
VIDEO_STREAM_TYPE_ENUM_END = 4 # 
enums['VIDEO_STREAM_TYPE'][4] = EnumEntry('VIDEO_STREAM_TYPE_ENUM_END', '''''')

# CAMERA_MODE
enums['CAMERA_MODE'] = {}
CAMERA_MODE_IMAGE = 0 # Camera is in image/photo capture mode.
enums['CAMERA_MODE'][0] = EnumEntry('CAMERA_MODE_IMAGE', '''Camera is in image/photo capture mode.''')
CAMERA_MODE_VIDEO = 1 # Camera is in video capture mode.
enums['CAMERA_MODE'][1] = EnumEntry('CAMERA_MODE_VIDEO', '''Camera is in video capture mode.''')
CAMERA_MODE_IMAGE_SURVEY = 2 # Camera is in image survey capture mode. It allows for camera
                        # controller to do specific settings for
                        # surveys.
enums['CAMERA_MODE'][2] = EnumEntry('CAMERA_MODE_IMAGE_SURVEY', '''Camera is in image survey capture mode. It allows for camera controller to do specific settings for surveys.''')
CAMERA_MODE_ENUM_END = 3 # 
enums['CAMERA_MODE'][3] = EnumEntry('CAMERA_MODE_ENUM_END', '''''')

# MAV_ARM_AUTH_DENIED_REASON
enums['MAV_ARM_AUTH_DENIED_REASON'] = {}
MAV_ARM_AUTH_DENIED_REASON_GENERIC = 0 # Not a specific reason
enums['MAV_ARM_AUTH_DENIED_REASON'][0] = EnumEntry('MAV_ARM_AUTH_DENIED_REASON_GENERIC', '''Not a specific reason''')
MAV_ARM_AUTH_DENIED_REASON_NONE = 1 # Authorizer will send the error as string to GCS
enums['MAV_ARM_AUTH_DENIED_REASON'][1] = EnumEntry('MAV_ARM_AUTH_DENIED_REASON_NONE', '''Authorizer will send the error as string to GCS''')
MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT = 2 # At least one waypoint have a invalid value
enums['MAV_ARM_AUTH_DENIED_REASON'][2] = EnumEntry('MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT', '''At least one waypoint have a invalid value''')
MAV_ARM_AUTH_DENIED_REASON_TIMEOUT = 3 # Timeout in the authorizer process(in case it depends on network)
enums['MAV_ARM_AUTH_DENIED_REASON'][3] = EnumEntry('MAV_ARM_AUTH_DENIED_REASON_TIMEOUT', '''Timeout in the authorizer process(in case it depends on network)''')
MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE = 4 # Airspace of the mission in use by another vehicle, second result
                        # parameter can have the waypoint id that
                        # caused it to be denied.
enums['MAV_ARM_AUTH_DENIED_REASON'][4] = EnumEntry('MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE', '''Airspace of the mission in use by another vehicle, second result parameter can have the waypoint id that caused it to be denied.''')
MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER = 5 # Weather is not good to fly
enums['MAV_ARM_AUTH_DENIED_REASON'][5] = EnumEntry('MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER', '''Weather is not good to fly''')
MAV_ARM_AUTH_DENIED_REASON_ENUM_END = 6 # 
enums['MAV_ARM_AUTH_DENIED_REASON'][6] = EnumEntry('MAV_ARM_AUTH_DENIED_REASON_ENUM_END', '''''')

# RC_TYPE
enums['RC_TYPE'] = {}
RC_TYPE_SPEKTRUM_DSM2 = 0 # Spektrum DSM2
enums['RC_TYPE'][0] = EnumEntry('RC_TYPE_SPEKTRUM_DSM2', '''Spektrum DSM2''')
RC_TYPE_SPEKTRUM_DSMX = 1 # Spektrum DSMX
enums['RC_TYPE'][1] = EnumEntry('RC_TYPE_SPEKTRUM_DSMX', '''Spektrum DSMX''')
RC_TYPE_ENUM_END = 2 # 
enums['RC_TYPE'][2] = EnumEntry('RC_TYPE_ENUM_END', '''''')

# POSITION_TARGET_TYPEMASK
enums['POSITION_TARGET_TYPEMASK'] = {}
POSITION_TARGET_TYPEMASK_X_IGNORE = 1 # Ignore position x
enums['POSITION_TARGET_TYPEMASK'][1] = EnumEntry('POSITION_TARGET_TYPEMASK_X_IGNORE', '''Ignore position x''')
POSITION_TARGET_TYPEMASK_Y_IGNORE = 2 # Ignore position y
enums['POSITION_TARGET_TYPEMASK'][2] = EnumEntry('POSITION_TARGET_TYPEMASK_Y_IGNORE', '''Ignore position y''')
POSITION_TARGET_TYPEMASK_Z_IGNORE = 4 # Ignore position z
enums['POSITION_TARGET_TYPEMASK'][4] = EnumEntry('POSITION_TARGET_TYPEMASK_Z_IGNORE', '''Ignore position z''')
POSITION_TARGET_TYPEMASK_VX_IGNORE = 8 # Ignore velocity x
enums['POSITION_TARGET_TYPEMASK'][8] = EnumEntry('POSITION_TARGET_TYPEMASK_VX_IGNORE', '''Ignore velocity x''')
POSITION_TARGET_TYPEMASK_VY_IGNORE = 16 # Ignore velocity y
enums['POSITION_TARGET_TYPEMASK'][16] = EnumEntry('POSITION_TARGET_TYPEMASK_VY_IGNORE', '''Ignore velocity y''')
POSITION_TARGET_TYPEMASK_VZ_IGNORE = 32 # Ignore velocity z
enums['POSITION_TARGET_TYPEMASK'][32] = EnumEntry('POSITION_TARGET_TYPEMASK_VZ_IGNORE', '''Ignore velocity z''')
POSITION_TARGET_TYPEMASK_AX_IGNORE = 64 # Ignore acceleration x
enums['POSITION_TARGET_TYPEMASK'][64] = EnumEntry('POSITION_TARGET_TYPEMASK_AX_IGNORE', '''Ignore acceleration x''')
POSITION_TARGET_TYPEMASK_AY_IGNORE = 128 # Ignore acceleration y
enums['POSITION_TARGET_TYPEMASK'][128] = EnumEntry('POSITION_TARGET_TYPEMASK_AY_IGNORE', '''Ignore acceleration y''')
POSITION_TARGET_TYPEMASK_AZ_IGNORE = 256 # Ignore acceleration z
enums['POSITION_TARGET_TYPEMASK'][256] = EnumEntry('POSITION_TARGET_TYPEMASK_AZ_IGNORE', '''Ignore acceleration z''')
POSITION_TARGET_TYPEMASK_FORCE_SET = 512 # Use force instead of acceleration
enums['POSITION_TARGET_TYPEMASK'][512] = EnumEntry('POSITION_TARGET_TYPEMASK_FORCE_SET', '''Use force instead of acceleration''')
POSITION_TARGET_TYPEMASK_YAW_IGNORE = 1024 # Ignore yaw
enums['POSITION_TARGET_TYPEMASK'][1024] = EnumEntry('POSITION_TARGET_TYPEMASK_YAW_IGNORE', '''Ignore yaw''')
POSITION_TARGET_TYPEMASK_YAW_RATE_IGNORE = 2048 # Ignore yaw rate
enums['POSITION_TARGET_TYPEMASK'][2048] = EnumEntry('POSITION_TARGET_TYPEMASK_YAW_RATE_IGNORE', '''Ignore yaw rate''')
POSITION_TARGET_TYPEMASK_ENUM_END = 2049 # 
enums['POSITION_TARGET_TYPEMASK'][2049] = EnumEntry('POSITION_TARGET_TYPEMASK_ENUM_END', '''''')

# ATTITUDE_TARGET_TYPEMASK
enums['ATTITUDE_TARGET_TYPEMASK'] = {}
ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE = 1 # Ignore body roll rate
enums['ATTITUDE_TARGET_TYPEMASK'][1] = EnumEntry('ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE', '''Ignore body roll rate''')
ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE = 2 # Ignore body pitch rate
enums['ATTITUDE_TARGET_TYPEMASK'][2] = EnumEntry('ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE', '''Ignore body pitch rate''')
ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE = 4 # Ignore body yaw rate
enums['ATTITUDE_TARGET_TYPEMASK'][4] = EnumEntry('ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE', '''Ignore body yaw rate''')
ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE = 64 # Ignore throttle
enums['ATTITUDE_TARGET_TYPEMASK'][64] = EnumEntry('ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE', '''Ignore throttle''')
ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE = 128 # Ignore attitude
enums['ATTITUDE_TARGET_TYPEMASK'][128] = EnumEntry('ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE', '''Ignore attitude''')
ATTITUDE_TARGET_TYPEMASK_ENUM_END = 129 # 
enums['ATTITUDE_TARGET_TYPEMASK'][129] = EnumEntry('ATTITUDE_TARGET_TYPEMASK_ENUM_END', '''''')

# UTM_FLIGHT_STATE
enums['UTM_FLIGHT_STATE'] = {}
UTM_FLIGHT_STATE_UNKNOWN = 1 # The flight state can't be determined.
enums['UTM_FLIGHT_STATE'][1] = EnumEntry('UTM_FLIGHT_STATE_UNKNOWN', '''The flight state can't be determined.''')
UTM_FLIGHT_STATE_GROUND = 2 # UAS on ground.
enums['UTM_FLIGHT_STATE'][2] = EnumEntry('UTM_FLIGHT_STATE_GROUND', '''UAS on ground.''')
UTM_FLIGHT_STATE_AIRBORNE = 3 # UAS airborne.
enums['UTM_FLIGHT_STATE'][3] = EnumEntry('UTM_FLIGHT_STATE_AIRBORNE', '''UAS airborne.''')
UTM_FLIGHT_STATE_EMERGENCY = 16 # UAS is in an emergency flight state.
enums['UTM_FLIGHT_STATE'][16] = EnumEntry('UTM_FLIGHT_STATE_EMERGENCY', '''UAS is in an emergency flight state.''')
UTM_FLIGHT_STATE_NOCTRL = 32 # UAS has no active controls.
enums['UTM_FLIGHT_STATE'][32] = EnumEntry('UTM_FLIGHT_STATE_NOCTRL', '''UAS has no active controls.''')
UTM_FLIGHT_STATE_ENUM_END = 33 # 
enums['UTM_FLIGHT_STATE'][33] = EnumEntry('UTM_FLIGHT_STATE_ENUM_END', '''''')

# UTM_DATA_AVAIL_FLAGS
enums['UTM_DATA_AVAIL_FLAGS'] = {}
UTM_DATA_AVAIL_FLAGS_TIME_VALID = 1 # The field time contains valid data.
enums['UTM_DATA_AVAIL_FLAGS'][1] = EnumEntry('UTM_DATA_AVAIL_FLAGS_TIME_VALID', '''The field time contains valid data.''')
UTM_DATA_AVAIL_FLAGS_UAS_ID_AVAILABLE = 2 # The field uas_id contains valid data.
enums['UTM_DATA_AVAIL_FLAGS'][2] = EnumEntry('UTM_DATA_AVAIL_FLAGS_UAS_ID_AVAILABLE', '''The field uas_id contains valid data.''')
UTM_DATA_AVAIL_FLAGS_POSITION_AVAILABLE = 4 # The fields lat, lon and h_acc contain valid data.
enums['UTM_DATA_AVAIL_FLAGS'][4] = EnumEntry('UTM_DATA_AVAIL_FLAGS_POSITION_AVAILABLE', '''The fields lat, lon and h_acc contain valid data.''')
UTM_DATA_AVAIL_FLAGS_ALTITUDE_AVAILABLE = 8 # The fields alt and v_acc contain valid data.
enums['UTM_DATA_AVAIL_FLAGS'][8] = EnumEntry('UTM_DATA_AVAIL_FLAGS_ALTITUDE_AVAILABLE', '''The fields alt and v_acc contain valid data.''')
UTM_DATA_AVAIL_FLAGS_RELATIVE_ALTITUDE_AVAILABLE = 16 # The field relative_alt contains valid data.
enums['UTM_DATA_AVAIL_FLAGS'][16] = EnumEntry('UTM_DATA_AVAIL_FLAGS_RELATIVE_ALTITUDE_AVAILABLE', '''The field relative_alt contains valid data.''')
UTM_DATA_AVAIL_FLAGS_HORIZONTAL_VELO_AVAILABLE = 32 # The fields vx and vy contain valid data.
enums['UTM_DATA_AVAIL_FLAGS'][32] = EnumEntry('UTM_DATA_AVAIL_FLAGS_HORIZONTAL_VELO_AVAILABLE', '''The fields vx and vy contain valid data.''')
UTM_DATA_AVAIL_FLAGS_VERTICAL_VELO_AVAILABLE = 64 # The field vz contains valid data.
enums['UTM_DATA_AVAIL_FLAGS'][64] = EnumEntry('UTM_DATA_AVAIL_FLAGS_VERTICAL_VELO_AVAILABLE', '''The field vz contains valid data.''')
UTM_DATA_AVAIL_FLAGS_NEXT_WAYPOINT_AVAILABLE = 128 # The fields next_lat, next_lon and next_alt contain valid data.
enums['UTM_DATA_AVAIL_FLAGS'][128] = EnumEntry('UTM_DATA_AVAIL_FLAGS_NEXT_WAYPOINT_AVAILABLE', '''The fields next_lat, next_lon and next_alt contain valid data.''')
UTM_DATA_AVAIL_FLAGS_ENUM_END = 129 # 
enums['UTM_DATA_AVAIL_FLAGS'][129] = EnumEntry('UTM_DATA_AVAIL_FLAGS_ENUM_END', '''''')

# PRECISION_LAND_MODE
enums['PRECISION_LAND_MODE'] = {}
PRECISION_LAND_MODE_DISABLED = 0 # Normal (non-precision) landing.
enums['PRECISION_LAND_MODE'][0] = EnumEntry('PRECISION_LAND_MODE_DISABLED', '''Normal (non-precision) landing.''')
PRECISION_LAND_MODE_OPPORTUNISTIC = 1 # Use precision landing if beacon detected when land command accepted,
                        # otherwise land normally.
enums['PRECISION_LAND_MODE'][1] = EnumEntry('PRECISION_LAND_MODE_OPPORTUNISTIC', '''Use precision landing if beacon detected when land command accepted, otherwise land normally.''')
PRECISION_LAND_MODE_REQUIRED = 2 # Use precision landing, searching for beacon if not found when land
                        # command accepted (land normally if beacon
                        # cannot be found).
enums['PRECISION_LAND_MODE'][2] = EnumEntry('PRECISION_LAND_MODE_REQUIRED', '''Use precision landing, searching for beacon if not found when land command accepted (land normally if beacon cannot be found).''')
PRECISION_LAND_MODE_ENUM_END = 3 # 
enums['PRECISION_LAND_MODE'][3] = EnumEntry('PRECISION_LAND_MODE_ENUM_END', '''''')

# PARACHUTE_ACTION
enums['PARACHUTE_ACTION'] = {}
PARACHUTE_DISABLE = 0 # Disable auto-release of parachute (i.e. release triggered by crash
                        # detectors).
enums['PARACHUTE_ACTION'][0] = EnumEntry('PARACHUTE_DISABLE', '''Disable auto-release of parachute (i.e. release triggered by crash detectors).''')
PARACHUTE_ENABLE = 1 # Enable auto-release of parachute.
enums['PARACHUTE_ACTION'][1] = EnumEntry('PARACHUTE_ENABLE', '''Enable auto-release of parachute.''')
PARACHUTE_RELEASE = 2 # Release parachute and kill motors.
enums['PARACHUTE_ACTION'][2] = EnumEntry('PARACHUTE_RELEASE', '''Release parachute and kill motors.''')
PARACHUTE_ACTION_ENUM_END = 3 # 
enums['PARACHUTE_ACTION'][3] = EnumEntry('PARACHUTE_ACTION_ENUM_END', '''''')

# MAV_TUNNEL_PAYLOAD_TYPE
enums['MAV_TUNNEL_PAYLOAD_TYPE'] = {}
MAV_TUNNEL_PAYLOAD_TYPE_UNKNOWN = 0 # Encoding of payload unknown.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][0] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_UNKNOWN', '''Encoding of payload unknown.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED0 = 200 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][200] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED0', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED1 = 201 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][201] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED1', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED2 = 202 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][202] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED2', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED3 = 203 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][203] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED3', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED4 = 204 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][204] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED4', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED5 = 205 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][205] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED5', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED6 = 206 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][206] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED6', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED7 = 207 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][207] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED7', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED8 = 208 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][208] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED8', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED9 = 209 # Registered for STorM32 gimbal controller.
enums['MAV_TUNNEL_PAYLOAD_TYPE'][209] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED9', '''Registered for STorM32 gimbal controller.''')
MAV_TUNNEL_PAYLOAD_TYPE_ENUM_END = 210 # 
enums['MAV_TUNNEL_PAYLOAD_TYPE'][210] = EnumEntry('MAV_TUNNEL_PAYLOAD_TYPE_ENUM_END', '''''')

# AIS_TYPE
enums['AIS_TYPE'] = {}
AIS_TYPE_UNKNOWN = 0 # Not available (default).
enums['AIS_TYPE'][0] = EnumEntry('AIS_TYPE_UNKNOWN', '''Not available (default).''')
AIS_TYPE_RESERVED_1 = 1 # 
enums['AIS_TYPE'][1] = EnumEntry('AIS_TYPE_RESERVED_1', '''''')
AIS_TYPE_RESERVED_2 = 2 # 
enums['AIS_TYPE'][2] = EnumEntry('AIS_TYPE_RESERVED_2', '''''')
AIS_TYPE_RESERVED_3 = 3 # 
enums['AIS_TYPE'][3] = EnumEntry('AIS_TYPE_RESERVED_3', '''''')
AIS_TYPE_RESERVED_4 = 4 # 
enums['AIS_TYPE'][4] = EnumEntry('AIS_TYPE_RESERVED_4', '''''')
AIS_TYPE_RESERVED_5 = 5 # 
enums['AIS_TYPE'][5] = EnumEntry('AIS_TYPE_RESERVED_5', '''''')
AIS_TYPE_RESERVED_6 = 6 # 
enums['AIS_TYPE'][6] = EnumEntry('AIS_TYPE_RESERVED_6', '''''')
AIS_TYPE_RESERVED_7 = 7 # 
enums['AIS_TYPE'][7] = EnumEntry('AIS_TYPE_RESERVED_7', '''''')
AIS_TYPE_RESERVED_8 = 8 # 
enums['AIS_TYPE'][8] = EnumEntry('AIS_TYPE_RESERVED_8', '''''')
AIS_TYPE_RESERVED_9 = 9 # 
enums['AIS_TYPE'][9] = EnumEntry('AIS_TYPE_RESERVED_9', '''''')
AIS_TYPE_RESERVED_10 = 10 # 
enums['AIS_TYPE'][10] = EnumEntry('AIS_TYPE_RESERVED_10', '''''')
AIS_TYPE_RESERVED_11 = 11 # 
enums['AIS_TYPE'][11] = EnumEntry('AIS_TYPE_RESERVED_11', '''''')
AIS_TYPE_RESERVED_12 = 12 # 
enums['AIS_TYPE'][12] = EnumEntry('AIS_TYPE_RESERVED_12', '''''')
AIS_TYPE_RESERVED_13 = 13 # 
enums['AIS_TYPE'][13] = EnumEntry('AIS_TYPE_RESERVED_13', '''''')
AIS_TYPE_RESERVED_14 = 14 # 
enums['AIS_TYPE'][14] = EnumEntry('AIS_TYPE_RESERVED_14', '''''')
AIS_TYPE_RESERVED_15 = 15 # 
enums['AIS_TYPE'][15] = EnumEntry('AIS_TYPE_RESERVED_15', '''''')
AIS_TYPE_RESERVED_16 = 16 # 
enums['AIS_TYPE'][16] = EnumEntry('AIS_TYPE_RESERVED_16', '''''')
AIS_TYPE_RESERVED_17 = 17 # 
enums['AIS_TYPE'][17] = EnumEntry('AIS_TYPE_RESERVED_17', '''''')
AIS_TYPE_RESERVED_18 = 18 # 
enums['AIS_TYPE'][18] = EnumEntry('AIS_TYPE_RESERVED_18', '''''')
AIS_TYPE_RESERVED_19 = 19 # 
enums['AIS_TYPE'][19] = EnumEntry('AIS_TYPE_RESERVED_19', '''''')
AIS_TYPE_WIG = 20 # Wing In Ground effect.
enums['AIS_TYPE'][20] = EnumEntry('AIS_TYPE_WIG', '''Wing In Ground effect.''')
AIS_TYPE_WIG_HAZARDOUS_A = 21 # 
enums['AIS_TYPE'][21] = EnumEntry('AIS_TYPE_WIG_HAZARDOUS_A', '''''')
AIS_TYPE_WIG_HAZARDOUS_B = 22 # 
enums['AIS_TYPE'][22] = EnumEntry('AIS_TYPE_WIG_HAZARDOUS_B', '''''')
AIS_TYPE_WIG_HAZARDOUS_C = 23 # 
enums['AIS_TYPE'][23] = EnumEntry('AIS_TYPE_WIG_HAZARDOUS_C', '''''')
AIS_TYPE_WIG_HAZARDOUS_D = 24 # 
enums['AIS_TYPE'][24] = EnumEntry('AIS_TYPE_WIG_HAZARDOUS_D', '''''')
AIS_TYPE_WIG_RESERVED_1 = 25 # 
enums['AIS_TYPE'][25] = EnumEntry('AIS_TYPE_WIG_RESERVED_1', '''''')
AIS_TYPE_WIG_RESERVED_2 = 26 # 
enums['AIS_TYPE'][26] = EnumEntry('AIS_TYPE_WIG_RESERVED_2', '''''')
AIS_TYPE_WIG_RESERVED_3 = 27 # 
enums['AIS_TYPE'][27] = EnumEntry('AIS_TYPE_WIG_RESERVED_3', '''''')
AIS_TYPE_WIG_RESERVED_4 = 28 # 
enums['AIS_TYPE'][28] = EnumEntry('AIS_TYPE_WIG_RESERVED_4', '''''')
AIS_TYPE_WIG_RESERVED_5 = 29 # 
enums['AIS_TYPE'][29] = EnumEntry('AIS_TYPE_WIG_RESERVED_5', '''''')
AIS_TYPE_FISHING = 30 # 
enums['AIS_TYPE'][30] = EnumEntry('AIS_TYPE_FISHING', '''''')
AIS_TYPE_TOWING = 31 # 
enums['AIS_TYPE'][31] = EnumEntry('AIS_TYPE_TOWING', '''''')
AIS_TYPE_TOWING_LARGE = 32 # Towing: length exceeds 200m or breadth exceeds 25m.
enums['AIS_TYPE'][32] = EnumEntry('AIS_TYPE_TOWING_LARGE', '''Towing: length exceeds 200m or breadth exceeds 25m.''')
AIS_TYPE_DREDGING = 33 # Dredging or other underwater ops.
enums['AIS_TYPE'][33] = EnumEntry('AIS_TYPE_DREDGING', '''Dredging or other underwater ops.''')
AIS_TYPE_DIVING = 34 # 
enums['AIS_TYPE'][34] = EnumEntry('AIS_TYPE_DIVING', '''''')
AIS_TYPE_MILITARY = 35 # 
enums['AIS_TYPE'][35] = EnumEntry('AIS_TYPE_MILITARY', '''''')
AIS_TYPE_SAILING = 36 # 
enums['AIS_TYPE'][36] = EnumEntry('AIS_TYPE_SAILING', '''''')
AIS_TYPE_PLEASURE = 37 # 
enums['AIS_TYPE'][37] = EnumEntry('AIS_TYPE_PLEASURE', '''''')
AIS_TYPE_RESERVED_20 = 38 # 
enums['AIS_TYPE'][38] = EnumEntry('AIS_TYPE_RESERVED_20', '''''')
AIS_TYPE_RESERVED_21 = 39 # 
enums['AIS_TYPE'][39] = EnumEntry('AIS_TYPE_RESERVED_21', '''''')
AIS_TYPE_HSC = 40 # High Speed Craft.
enums['AIS_TYPE'][40] = EnumEntry('AIS_TYPE_HSC', '''High Speed Craft.''')
AIS_TYPE_HSC_HAZARDOUS_A = 41 # 
enums['AIS_TYPE'][41] = EnumEntry('AIS_TYPE_HSC_HAZARDOUS_A', '''''')
AIS_TYPE_HSC_HAZARDOUS_B = 42 # 
enums['AIS_TYPE'][42] = EnumEntry('AIS_TYPE_HSC_HAZARDOUS_B', '''''')
AIS_TYPE_HSC_HAZARDOUS_C = 43 # 
enums['AIS_TYPE'][43] = EnumEntry('AIS_TYPE_HSC_HAZARDOUS_C', '''''')
AIS_TYPE_HSC_HAZARDOUS_D = 44 # 
enums['AIS_TYPE'][44] = EnumEntry('AIS_TYPE_HSC_HAZARDOUS_D', '''''')
AIS_TYPE_HSC_RESERVED_1 = 45 # 
enums['AIS_TYPE'][45] = EnumEntry('AIS_TYPE_HSC_RESERVED_1', '''''')
AIS_TYPE_HSC_RESERVED_2 = 46 # 
enums['AIS_TYPE'][46] = EnumEntry('AIS_TYPE_HSC_RESERVED_2', '''''')
AIS_TYPE_HSC_RESERVED_3 = 47 # 
enums['AIS_TYPE'][47] = EnumEntry('AIS_TYPE_HSC_RESERVED_3', '''''')
AIS_TYPE_HSC_RESERVED_4 = 48 # 
enums['AIS_TYPE'][48] = EnumEntry('AIS_TYPE_HSC_RESERVED_4', '''''')
AIS_TYPE_HSC_UNKNOWN = 49 # 
enums['AIS_TYPE'][49] = EnumEntry('AIS_TYPE_HSC_UNKNOWN', '''''')
AIS_TYPE_PILOT = 50 # 
enums['AIS_TYPE'][50] = EnumEntry('AIS_TYPE_PILOT', '''''')
AIS_TYPE_SAR = 51 # Search And Rescue vessel.
enums['AIS_TYPE'][51] = EnumEntry('AIS_TYPE_SAR', '''Search And Rescue vessel.''')
AIS_TYPE_TUG = 52 # 
enums['AIS_TYPE'][52] = EnumEntry('AIS_TYPE_TUG', '''''')
AIS_TYPE_PORT_TENDER = 53 # 
enums['AIS_TYPE'][53] = EnumEntry('AIS_TYPE_PORT_TENDER', '''''')
AIS_TYPE_ANTI_POLLUTION = 54 # Anti-pollution equipment.
enums['AIS_TYPE'][54] = EnumEntry('AIS_TYPE_ANTI_POLLUTION', '''Anti-pollution equipment.''')
AIS_TYPE_LAW_ENFORCEMENT = 55 # 
enums['AIS_TYPE'][55] = EnumEntry('AIS_TYPE_LAW_ENFORCEMENT', '''''')
AIS_TYPE_SPARE_LOCAL_1 = 56 # 
enums['AIS_TYPE'][56] = EnumEntry('AIS_TYPE_SPARE_LOCAL_1', '''''')
AIS_TYPE_SPARE_LOCAL_2 = 57 # 
enums['AIS_TYPE'][57] = EnumEntry('AIS_TYPE_SPARE_LOCAL_2', '''''')
AIS_TYPE_MEDICAL_TRANSPORT = 58 # 
enums['AIS_TYPE'][58] = EnumEntry('AIS_TYPE_MEDICAL_TRANSPORT', '''''')
AIS_TYPE_NONECOMBATANT = 59 # Noncombatant ship according to RR Resolution No. 18.
enums['AIS_TYPE'][59] = EnumEntry('AIS_TYPE_NONECOMBATANT', '''Noncombatant ship according to RR Resolution No. 18.''')
AIS_TYPE_PASSENGER = 60 # 
enums['AIS_TYPE'][60] = EnumEntry('AIS_TYPE_PASSENGER', '''''')
AIS_TYPE_PASSENGER_HAZARDOUS_A = 61 # 
enums['AIS_TYPE'][61] = EnumEntry('AIS_TYPE_PASSENGER_HAZARDOUS_A', '''''')
AIS_TYPE_PASSENGER_HAZARDOUS_B = 62 # 
enums['AIS_TYPE'][62] = EnumEntry('AIS_TYPE_PASSENGER_HAZARDOUS_B', '''''')
AIS_TYPE_AIS_TYPE_PASSENGER_HAZARDOUS_C = 63 # 
enums['AIS_TYPE'][63] = EnumEntry('AIS_TYPE_AIS_TYPE_PASSENGER_HAZARDOUS_C', '''''')
AIS_TYPE_PASSENGER_HAZARDOUS_D = 64 # 
enums['AIS_TYPE'][64] = EnumEntry('AIS_TYPE_PASSENGER_HAZARDOUS_D', '''''')
AIS_TYPE_PASSENGER_RESERVED_1 = 65 # 
enums['AIS_TYPE'][65] = EnumEntry('AIS_TYPE_PASSENGER_RESERVED_1', '''''')
AIS_TYPE_PASSENGER_RESERVED_2 = 66 # 
enums['AIS_TYPE'][66] = EnumEntry('AIS_TYPE_PASSENGER_RESERVED_2', '''''')
AIS_TYPE_PASSENGER_RESERVED_3 = 67 # 
enums['AIS_TYPE'][67] = EnumEntry('AIS_TYPE_PASSENGER_RESERVED_3', '''''')
AIS_TYPE_AIS_TYPE_PASSENGER_RESERVED_4 = 68 # 
enums['AIS_TYPE'][68] = EnumEntry('AIS_TYPE_AIS_TYPE_PASSENGER_RESERVED_4', '''''')
AIS_TYPE_PASSENGER_UNKNOWN = 69 # 
enums['AIS_TYPE'][69] = EnumEntry('AIS_TYPE_PASSENGER_UNKNOWN', '''''')
AIS_TYPE_CARGO = 70 # 
enums['AIS_TYPE'][70] = EnumEntry('AIS_TYPE_CARGO', '''''')
AIS_TYPE_CARGO_HAZARDOUS_A = 71 # 
enums['AIS_TYPE'][71] = EnumEntry('AIS_TYPE_CARGO_HAZARDOUS_A', '''''')
AIS_TYPE_CARGO_HAZARDOUS_B = 72 # 
enums['AIS_TYPE'][72] = EnumEntry('AIS_TYPE_CARGO_HAZARDOUS_B', '''''')
AIS_TYPE_CARGO_HAZARDOUS_C = 73 # 
enums['AIS_TYPE'][73] = EnumEntry('AIS_TYPE_CARGO_HAZARDOUS_C', '''''')
AIS_TYPE_CARGO_HAZARDOUS_D = 74 # 
enums['AIS_TYPE'][74] = EnumEntry('AIS_TYPE_CARGO_HAZARDOUS_D', '''''')
AIS_TYPE_CARGO_RESERVED_1 = 75 # 
enums['AIS_TYPE'][75] = EnumEntry('AIS_TYPE_CARGO_RESERVED_1', '''''')
AIS_TYPE_CARGO_RESERVED_2 = 76 # 
enums['AIS_TYPE'][76] = EnumEntry('AIS_TYPE_CARGO_RESERVED_2', '''''')
AIS_TYPE_CARGO_RESERVED_3 = 77 # 
enums['AIS_TYPE'][77] = EnumEntry('AIS_TYPE_CARGO_RESERVED_3', '''''')
AIS_TYPE_CARGO_RESERVED_4 = 78 # 
enums['AIS_TYPE'][78] = EnumEntry('AIS_TYPE_CARGO_RESERVED_4', '''''')
AIS_TYPE_CARGO_UNKNOWN = 79 # 
enums['AIS_TYPE'][79] = EnumEntry('AIS_TYPE_CARGO_UNKNOWN', '''''')
AIS_TYPE_TANKER = 80 # 
enums['AIS_TYPE'][80] = EnumEntry('AIS_TYPE_TANKER', '''''')
AIS_TYPE_TANKER_HAZARDOUS_A = 81 # 
enums['AIS_TYPE'][81] = EnumEntry('AIS_TYPE_TANKER_HAZARDOUS_A', '''''')
AIS_TYPE_TANKER_HAZARDOUS_B = 82 # 
enums['AIS_TYPE'][82] = EnumEntry('AIS_TYPE_TANKER_HAZARDOUS_B', '''''')
AIS_TYPE_TANKER_HAZARDOUS_C = 83 # 
enums['AIS_TYPE'][83] = EnumEntry('AIS_TYPE_TANKER_HAZARDOUS_C', '''''')
AIS_TYPE_TANKER_HAZARDOUS_D = 84 # 
enums['AIS_TYPE'][84] = EnumEntry('AIS_TYPE_TANKER_HAZARDOUS_D', '''''')
AIS_TYPE_TANKER_RESERVED_1 = 85 # 
enums['AIS_TYPE'][85] = EnumEntry('AIS_TYPE_TANKER_RESERVED_1', '''''')
AIS_TYPE_TANKER_RESERVED_2 = 86 # 
enums['AIS_TYPE'][86] = EnumEntry('AIS_TYPE_TANKER_RESERVED_2', '''''')
AIS_TYPE_TANKER_RESERVED_3 = 87 # 
enums['AIS_TYPE'][87] = EnumEntry('AIS_TYPE_TANKER_RESERVED_3', '''''')
AIS_TYPE_TANKER_RESERVED_4 = 88 # 
enums['AIS_TYPE'][88] = EnumEntry('AIS_TYPE_TANKER_RESERVED_4', '''''')
AIS_TYPE_TANKER_UNKNOWN = 89 # 
enums['AIS_TYPE'][89] = EnumEntry('AIS_TYPE_TANKER_UNKNOWN', '''''')
AIS_TYPE_OTHER = 90 # 
enums['AIS_TYPE'][90] = EnumEntry('AIS_TYPE_OTHER', '''''')
AIS_TYPE_OTHER_HAZARDOUS_A = 91 # 
enums['AIS_TYPE'][91] = EnumEntry('AIS_TYPE_OTHER_HAZARDOUS_A', '''''')
AIS_TYPE_OTHER_HAZARDOUS_B = 92 # 
enums['AIS_TYPE'][92] = EnumEntry('AIS_TYPE_OTHER_HAZARDOUS_B', '''''')
AIS_TYPE_OTHER_HAZARDOUS_C = 93 # 
enums['AIS_TYPE'][93] = EnumEntry('AIS_TYPE_OTHER_HAZARDOUS_C', '''''')
AIS_TYPE_OTHER_HAZARDOUS_D = 94 # 
enums['AIS_TYPE'][94] = EnumEntry('AIS_TYPE_OTHER_HAZARDOUS_D', '''''')
AIS_TYPE_OTHER_RESERVED_1 = 95 # 
enums['AIS_TYPE'][95] = EnumEntry('AIS_TYPE_OTHER_RESERVED_1', '''''')
AIS_TYPE_OTHER_RESERVED_2 = 96 # 
enums['AIS_TYPE'][96] = EnumEntry('AIS_TYPE_OTHER_RESERVED_2', '''''')
AIS_TYPE_OTHER_RESERVED_3 = 97 # 
enums['AIS_TYPE'][97] = EnumEntry('AIS_TYPE_OTHER_RESERVED_3', '''''')
AIS_TYPE_OTHER_RESERVED_4 = 98 # 
enums['AIS_TYPE'][98] = EnumEntry('AIS_TYPE_OTHER_RESERVED_4', '''''')
AIS_TYPE_OTHER_UNKNOWN = 99 # 
enums['AIS_TYPE'][99] = EnumEntry('AIS_TYPE_OTHER_UNKNOWN', '''''')
AIS_TYPE_ENUM_END = 100 # 
enums['AIS_TYPE'][100] = EnumEntry('AIS_TYPE_ENUM_END', '''''')

# AIS_NAV_STATUS
enums['AIS_NAV_STATUS'] = {}
UNDER_WAY = 0 # Under way using engine.
enums['AIS_NAV_STATUS'][0] = EnumEntry('UNDER_WAY', '''Under way using engine.''')
AIS_NAV_ANCHORED = 1 # 
enums['AIS_NAV_STATUS'][1] = EnumEntry('AIS_NAV_ANCHORED', '''''')
AIS_NAV_UN_COMMANDED = 2 # 
enums['AIS_NAV_STATUS'][2] = EnumEntry('AIS_NAV_UN_COMMANDED', '''''')
AIS_NAV_RESTRICTED_MANOEUVERABILITY = 3 # 
enums['AIS_NAV_STATUS'][3] = EnumEntry('AIS_NAV_RESTRICTED_MANOEUVERABILITY', '''''')
AIS_NAV_DRAUGHT_CONSTRAINED = 4 # 
enums['AIS_NAV_STATUS'][4] = EnumEntry('AIS_NAV_DRAUGHT_CONSTRAINED', '''''')
AIS_NAV_MOORED = 5 # 
enums['AIS_NAV_STATUS'][5] = EnumEntry('AIS_NAV_MOORED', '''''')
AIS_NAV_AGROUND = 6 # 
enums['AIS_NAV_STATUS'][6] = EnumEntry('AIS_NAV_AGROUND', '''''')
AIS_NAV_FISHING = 7 # 
enums['AIS_NAV_STATUS'][7] = EnumEntry('AIS_NAV_FISHING', '''''')
AIS_NAV_SAILING = 8 # 
enums['AIS_NAV_STATUS'][8] = EnumEntry('AIS_NAV_SAILING', '''''')
AIS_NAV_RESERVED_HSC = 9 # 
enums['AIS_NAV_STATUS'][9] = EnumEntry('AIS_NAV_RESERVED_HSC', '''''')
AIS_NAV_RESERVED_WIG = 10 # 
enums['AIS_NAV_STATUS'][10] = EnumEntry('AIS_NAV_RESERVED_WIG', '''''')
AIS_NAV_RESERVED_1 = 11 # 
enums['AIS_NAV_STATUS'][11] = EnumEntry('AIS_NAV_RESERVED_1', '''''')
AIS_NAV_RESERVED_2 = 12 # 
enums['AIS_NAV_STATUS'][12] = EnumEntry('AIS_NAV_RESERVED_2', '''''')
AIS_NAV_RESERVED_3 = 13 # 
enums['AIS_NAV_STATUS'][13] = EnumEntry('AIS_NAV_RESERVED_3', '''''')
AIS_NAV_AIS_SART = 14 # Search And Rescue Transponder.
enums['AIS_NAV_STATUS'][14] = EnumEntry('AIS_NAV_AIS_SART', '''Search And Rescue Transponder.''')
AIS_NAV_UNKNOWN = 15 # Not available (default).
enums['AIS_NAV_STATUS'][15] = EnumEntry('AIS_NAV_UNKNOWN', '''Not available (default).''')
AIS_NAV_STATUS_ENUM_END = 16 # 
enums['AIS_NAV_STATUS'][16] = EnumEntry('AIS_NAV_STATUS_ENUM_END', '''''')

# AIS_FLAGS
enums['AIS_FLAGS'] = {}
AIS_FLAGS_POSITION_ACCURACY = 1 # 1 = Position accuracy less than 10m, 0 = position accuracy greater
                        # than 10m.
enums['AIS_FLAGS'][1] = EnumEntry('AIS_FLAGS_POSITION_ACCURACY', '''1 = Position accuracy less than 10m, 0 = position accuracy greater than 10m.''')
AIS_FLAGS_VALID_COG = 2 # 
enums['AIS_FLAGS'][2] = EnumEntry('AIS_FLAGS_VALID_COG', '''''')
AIS_FLAGS_VALID_VELOCITY = 4 # 
enums['AIS_FLAGS'][4] = EnumEntry('AIS_FLAGS_VALID_VELOCITY', '''''')
AIS_FLAGS_HIGH_VELOCITY = 8 # 1 = Velocity over 52.5765m/s (102.2 knots)
enums['AIS_FLAGS'][8] = EnumEntry('AIS_FLAGS_HIGH_VELOCITY', '''1 = Velocity over 52.5765m/s (102.2 knots)''')
AIS_FLAGS_VALID_TURN_RATE = 16 # 
enums['AIS_FLAGS'][16] = EnumEntry('AIS_FLAGS_VALID_TURN_RATE', '''''')
AIS_FLAGS_TURN_RATE_SIGN_ONLY = 32 # Only the sign of the returned turn rate value is valid, either greater
                        # than 5deg/30s or less than -5deg/30s
enums['AIS_FLAGS'][32] = EnumEntry('AIS_FLAGS_TURN_RATE_SIGN_ONLY', '''Only the sign of the returned turn rate value is valid, either greater than 5deg/30s or less than -5deg/30s''')
AIS_FLAGS_VALID_DIMENSIONS = 64 # 
enums['AIS_FLAGS'][64] = EnumEntry('AIS_FLAGS_VALID_DIMENSIONS', '''''')
AIS_FLAGS_LARGE_BOW_DIMENSION = 128 # Distance to bow is larger than 511m
enums['AIS_FLAGS'][128] = EnumEntry('AIS_FLAGS_LARGE_BOW_DIMENSION', '''Distance to bow is larger than 511m''')
AIS_FLAGS_LARGE_STERN_DIMENSION = 256 # Distance to stern is larger than 511m
enums['AIS_FLAGS'][256] = EnumEntry('AIS_FLAGS_LARGE_STERN_DIMENSION', '''Distance to stern is larger than 511m''')
AIS_FLAGS_LARGE_PORT_DIMENSION = 512 # Distance to port side is larger than 63m
enums['AIS_FLAGS'][512] = EnumEntry('AIS_FLAGS_LARGE_PORT_DIMENSION', '''Distance to port side is larger than 63m''')
AIS_FLAGS_LARGE_STARBOARD_DIMENSION = 1024 # Distance to starboard side is larger than 63m
enums['AIS_FLAGS'][1024] = EnumEntry('AIS_FLAGS_LARGE_STARBOARD_DIMENSION', '''Distance to starboard side is larger than 63m''')
AIS_FLAGS_VALID_CALLSIGN = 2048 # 
enums['AIS_FLAGS'][2048] = EnumEntry('AIS_FLAGS_VALID_CALLSIGN', '''''')
AIS_FLAGS_VALID_NAME = 4096 # 
enums['AIS_FLAGS'][4096] = EnumEntry('AIS_FLAGS_VALID_NAME', '''''')
AIS_FLAGS_ENUM_END = 4097 # 
enums['AIS_FLAGS'][4097] = EnumEntry('AIS_FLAGS_ENUM_END', '''''')

# MAV_WINCH_STATUS_FLAG
enums['MAV_WINCH_STATUS_FLAG'] = {}
MAV_WINCH_STATUS_HEALTHY = 1 # Winch is healthy
enums['MAV_WINCH_STATUS_FLAG'][1] = EnumEntry('MAV_WINCH_STATUS_HEALTHY', '''Winch is healthy''')
MAV_WINCH_STATUS_FULLY_RETRACTED = 2 # Winch thread is fully retracted
enums['MAV_WINCH_STATUS_FLAG'][2] = EnumEntry('MAV_WINCH_STATUS_FULLY_RETRACTED', '''Winch thread is fully retracted''')
MAV_WINCH_STATUS_MOVING = 4 # Winch motor is moving
enums['MAV_WINCH_STATUS_FLAG'][4] = EnumEntry('MAV_WINCH_STATUS_MOVING', '''Winch motor is moving''')
MAV_WINCH_STATUS_CLUTCH_ENGAGED = 8 # Winch clutch is engaged allowing motor to move freely
enums['MAV_WINCH_STATUS_FLAG'][8] = EnumEntry('MAV_WINCH_STATUS_CLUTCH_ENGAGED', '''Winch clutch is engaged allowing motor to move freely''')
MAV_WINCH_STATUS_FLAG_ENUM_END = 9 # 
enums['MAV_WINCH_STATUS_FLAG'][9] = EnumEntry('MAV_WINCH_STATUS_FLAG_ENUM_END', '''''')

# MAG_CAL_STATUS
enums['MAG_CAL_STATUS'] = {}
MAG_CAL_NOT_STARTED = 0 # 
enums['MAG_CAL_STATUS'][0] = EnumEntry('MAG_CAL_NOT_STARTED', '''''')
MAG_CAL_WAITING_TO_START = 1 # 
enums['MAG_CAL_STATUS'][1] = EnumEntry('MAG_CAL_WAITING_TO_START', '''''')
MAG_CAL_RUNNING_STEP_ONE = 2 # 
enums['MAG_CAL_STATUS'][2] = EnumEntry('MAG_CAL_RUNNING_STEP_ONE', '''''')
MAG_CAL_RUNNING_STEP_TWO = 3 # 
enums['MAG_CAL_STATUS'][3] = EnumEntry('MAG_CAL_RUNNING_STEP_TWO', '''''')
MAG_CAL_SUCCESS = 4 # 
enums['MAG_CAL_STATUS'][4] = EnumEntry('MAG_CAL_SUCCESS', '''''')
MAG_CAL_FAILED = 5 # 
enums['MAG_CAL_STATUS'][5] = EnumEntry('MAG_CAL_FAILED', '''''')
MAG_CAL_BAD_ORIENTATION = 6 # 
enums['MAG_CAL_STATUS'][6] = EnumEntry('MAG_CAL_BAD_ORIENTATION', '''''')
MAG_CAL_BAD_RADIUS = 7 # 
enums['MAG_CAL_STATUS'][7] = EnumEntry('MAG_CAL_BAD_RADIUS', '''''')
MAG_CAL_STATUS_ENUM_END = 8 # 
enums['MAG_CAL_STATUS'][8] = EnumEntry('MAG_CAL_STATUS_ENUM_END', '''''')

# ICAROUS_TRACK_BAND_TYPES
enums['ICAROUS_TRACK_BAND_TYPES'] = {}
ICAROUS_TRACK_BAND_TYPE_NONE = 0 # 
enums['ICAROUS_TRACK_BAND_TYPES'][0] = EnumEntry('ICAROUS_TRACK_BAND_TYPE_NONE', '''''')
ICAROUS_TRACK_BAND_TYPE_NEAR = 1 # 
enums['ICAROUS_TRACK_BAND_TYPES'][1] = EnumEntry('ICAROUS_TRACK_BAND_TYPE_NEAR', '''''')
ICAROUS_TRACK_BAND_TYPE_RECOVERY = 2 # 
enums['ICAROUS_TRACK_BAND_TYPES'][2] = EnumEntry('ICAROUS_TRACK_BAND_TYPE_RECOVERY', '''''')
ICAROUS_TRACK_BAND_TYPES_ENUM_END = 3 # 
enums['ICAROUS_TRACK_BAND_TYPES'][3] = EnumEntry('ICAROUS_TRACK_BAND_TYPES_ENUM_END', '''''')

# ICAROUS_FMS_STATE
enums['ICAROUS_FMS_STATE'] = {}
ICAROUS_FMS_STATE_IDLE = 0 # 
enums['ICAROUS_FMS_STATE'][0] = EnumEntry('ICAROUS_FMS_STATE_IDLE', '''''')
ICAROUS_FMS_STATE_TAKEOFF = 1 # 
enums['ICAROUS_FMS_STATE'][1] = EnumEntry('ICAROUS_FMS_STATE_TAKEOFF', '''''')
ICAROUS_FMS_STATE_CLIMB = 2 # 
enums['ICAROUS_FMS_STATE'][2] = EnumEntry('ICAROUS_FMS_STATE_CLIMB', '''''')
ICAROUS_FMS_STATE_CRUISE = 3 # 
enums['ICAROUS_FMS_STATE'][3] = EnumEntry('ICAROUS_FMS_STATE_CRUISE', '''''')
ICAROUS_FMS_STATE_APPROACH = 4 # 
enums['ICAROUS_FMS_STATE'][4] = EnumEntry('ICAROUS_FMS_STATE_APPROACH', '''''')
ICAROUS_FMS_STATE_LAND = 5 # 
enums['ICAROUS_FMS_STATE'][5] = EnumEntry('ICAROUS_FMS_STATE_LAND', '''''')
ICAROUS_FMS_STATE_ENUM_END = 6 # 
enums['ICAROUS_FMS_STATE'][6] = EnumEntry('ICAROUS_FMS_STATE_ENUM_END', '''''')

# MAV_AUTOPILOT
enums['MAV_AUTOPILOT'] = {}
MAV_AUTOPILOT_GENERIC = 0 # Generic autopilot, full support for everything
enums['MAV_AUTOPILOT'][0] = EnumEntry('MAV_AUTOPILOT_GENERIC', '''Generic autopilot, full support for everything''')
MAV_AUTOPILOT_RESERVED = 1 # Reserved for future use.
enums['MAV_AUTOPILOT'][1] = EnumEntry('MAV_AUTOPILOT_RESERVED', '''Reserved for future use.''')
MAV_AUTOPILOT_SLUGS = 2 # SLUGS autopilot, http://slugsuav.soe.ucsc.edu
enums['MAV_AUTOPILOT'][2] = EnumEntry('MAV_AUTOPILOT_SLUGS', '''SLUGS autopilot, http://slugsuav.soe.ucsc.edu''')
MAV_AUTOPILOT_ARDUPILOTMEGA = 3 # ArduPilot - Plane/Copter/Rover/Sub/Tracker, https://ardupilot.org
enums['MAV_AUTOPILOT'][3] = EnumEntry('MAV_AUTOPILOT_ARDUPILOTMEGA', '''ArduPilot - Plane/Copter/Rover/Sub/Tracker, https://ardupilot.org''')
MAV_AUTOPILOT_OPENPILOT = 4 # OpenPilot, http://openpilot.org
enums['MAV_AUTOPILOT'][4] = EnumEntry('MAV_AUTOPILOT_OPENPILOT', '''OpenPilot, http://openpilot.org''')
MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY = 5 # Generic autopilot only supporting simple waypoints
enums['MAV_AUTOPILOT'][5] = EnumEntry('MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY', '''Generic autopilot only supporting simple waypoints''')
MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY = 6 # Generic autopilot supporting waypoints and other simple navigation
                        # commands
enums['MAV_AUTOPILOT'][6] = EnumEntry('MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY', '''Generic autopilot supporting waypoints and other simple navigation commands''')
MAV_AUTOPILOT_GENERIC_MISSION_FULL = 7 # Generic autopilot supporting the full mission command set
enums['MAV_AUTOPILOT'][7] = EnumEntry('MAV_AUTOPILOT_GENERIC_MISSION_FULL', '''Generic autopilot supporting the full mission command set''')
MAV_AUTOPILOT_INVALID = 8 # No valid autopilot, e.g. a GCS or other MAVLink component
enums['MAV_AUTOPILOT'][8] = EnumEntry('MAV_AUTOPILOT_INVALID', '''No valid autopilot, e.g. a GCS or other MAVLink component''')
MAV_AUTOPILOT_PPZ = 9 # PPZ UAV - http://nongnu.org/paparazzi
enums['MAV_AUTOPILOT'][9] = EnumEntry('MAV_AUTOPILOT_PPZ', '''PPZ UAV - http://nongnu.org/paparazzi''')
MAV_AUTOPILOT_UDB = 10 # UAV Dev Board
enums['MAV_AUTOPILOT'][10] = EnumEntry('MAV_AUTOPILOT_UDB', '''UAV Dev Board''')
MAV_AUTOPILOT_FP = 11 # FlexiPilot
enums['MAV_AUTOPILOT'][11] = EnumEntry('MAV_AUTOPILOT_FP', '''FlexiPilot''')
MAV_AUTOPILOT_PX4 = 12 # PX4 Autopilot - http://px4.io/
enums['MAV_AUTOPILOT'][12] = EnumEntry('MAV_AUTOPILOT_PX4', '''PX4 Autopilot - http://px4.io/''')
MAV_AUTOPILOT_SMACCMPILOT = 13 # SMACCMPilot - http://smaccmpilot.org
enums['MAV_AUTOPILOT'][13] = EnumEntry('MAV_AUTOPILOT_SMACCMPILOT', '''SMACCMPilot - http://smaccmpilot.org''')
MAV_AUTOPILOT_AUTOQUAD = 14 # AutoQuad -- http://autoquad.org
enums['MAV_AUTOPILOT'][14] = EnumEntry('MAV_AUTOPILOT_AUTOQUAD', '''AutoQuad -- http://autoquad.org''')
MAV_AUTOPILOT_ARMAZILA = 15 # Armazila -- http://armazila.com
enums['MAV_AUTOPILOT'][15] = EnumEntry('MAV_AUTOPILOT_ARMAZILA', '''Armazila -- http://armazila.com''')
MAV_AUTOPILOT_AEROB = 16 # Aerob -- http://aerob.ru
enums['MAV_AUTOPILOT'][16] = EnumEntry('MAV_AUTOPILOT_AEROB', '''Aerob -- http://aerob.ru''')
MAV_AUTOPILOT_ASLUAV = 17 # ASLUAV autopilot -- http://www.asl.ethz.ch
enums['MAV_AUTOPILOT'][17] = EnumEntry('MAV_AUTOPILOT_ASLUAV', '''ASLUAV autopilot -- http://www.asl.ethz.ch''')
MAV_AUTOPILOT_SMARTAP = 18 # SmartAP Autopilot - http://sky-drones.com
enums['MAV_AUTOPILOT'][18] = EnumEntry('MAV_AUTOPILOT_SMARTAP', '''SmartAP Autopilot - http://sky-drones.com''')
MAV_AUTOPILOT_AIRRAILS = 19 # AirRails - http://uaventure.com
enums['MAV_AUTOPILOT'][19] = EnumEntry('MAV_AUTOPILOT_AIRRAILS', '''AirRails - http://uaventure.com''')
MAV_AUTOPILOT_ENUM_END = 20 # 
enums['MAV_AUTOPILOT'][20] = EnumEntry('MAV_AUTOPILOT_ENUM_END', '''''')

# MAV_TYPE
enums['MAV_TYPE'] = {}
MAV_TYPE_GENERIC = 0 # Generic micro air vehicle
enums['MAV_TYPE'][0] = EnumEntry('MAV_TYPE_GENERIC', '''Generic micro air vehicle''')
MAV_TYPE_FIXED_WING = 1 # Fixed wing aircraft.
enums['MAV_TYPE'][1] = EnumEntry('MAV_TYPE_FIXED_WING', '''Fixed wing aircraft.''')
MAV_TYPE_QUADROTOR = 2 # Quadrotor
enums['MAV_TYPE'][2] = EnumEntry('MAV_TYPE_QUADROTOR', '''Quadrotor''')
MAV_TYPE_COAXIAL = 3 # Coaxial helicopter
enums['MAV_TYPE'][3] = EnumEntry('MAV_TYPE_COAXIAL', '''Coaxial helicopter''')
MAV_TYPE_HELICOPTER = 4 # Normal helicopter with tail rotor.
enums['MAV_TYPE'][4] = EnumEntry('MAV_TYPE_HELICOPTER', '''Normal helicopter with tail rotor.''')
MAV_TYPE_ANTENNA_TRACKER = 5 # Ground installation
enums['MAV_TYPE'][5] = EnumEntry('MAV_TYPE_ANTENNA_TRACKER', '''Ground installation''')
MAV_TYPE_GCS = 6 # Operator control unit / ground control station
enums['MAV_TYPE'][6] = EnumEntry('MAV_TYPE_GCS', '''Operator control unit / ground control station''')
MAV_TYPE_AIRSHIP = 7 # Airship, controlled
enums['MAV_TYPE'][7] = EnumEntry('MAV_TYPE_AIRSHIP', '''Airship, controlled''')
MAV_TYPE_FREE_BALLOON = 8 # Free balloon, uncontrolled
enums['MAV_TYPE'][8] = EnumEntry('MAV_TYPE_FREE_BALLOON', '''Free balloon, uncontrolled''')
MAV_TYPE_ROCKET = 9 # Rocket
enums['MAV_TYPE'][9] = EnumEntry('MAV_TYPE_ROCKET', '''Rocket''')
MAV_TYPE_GROUND_ROVER = 10 # Ground rover
enums['MAV_TYPE'][10] = EnumEntry('MAV_TYPE_GROUND_ROVER', '''Ground rover''')
MAV_TYPE_SURFACE_BOAT = 11 # Surface vessel, boat, ship
enums['MAV_TYPE'][11] = EnumEntry('MAV_TYPE_SURFACE_BOAT', '''Surface vessel, boat, ship''')
MAV_TYPE_SUBMARINE = 12 # Submarine
enums['MAV_TYPE'][12] = EnumEntry('MAV_TYPE_SUBMARINE', '''Submarine''')
MAV_TYPE_HEXAROTOR = 13 # Hexarotor
enums['MAV_TYPE'][13] = EnumEntry('MAV_TYPE_HEXAROTOR', '''Hexarotor''')
MAV_TYPE_OCTOROTOR = 14 # Octorotor
enums['MAV_TYPE'][14] = EnumEntry('MAV_TYPE_OCTOROTOR', '''Octorotor''')
MAV_TYPE_TRICOPTER = 15 # Tricopter
enums['MAV_TYPE'][15] = EnumEntry('MAV_TYPE_TRICOPTER', '''Tricopter''')
MAV_TYPE_FLAPPING_WING = 16 # Flapping wing
enums['MAV_TYPE'][16] = EnumEntry('MAV_TYPE_FLAPPING_WING', '''Flapping wing''')
MAV_TYPE_KITE = 17 # Kite
enums['MAV_TYPE'][17] = EnumEntry('MAV_TYPE_KITE', '''Kite''')
MAV_TYPE_ONBOARD_CONTROLLER = 18 # Onboard companion controller
enums['MAV_TYPE'][18] = EnumEntry('MAV_TYPE_ONBOARD_CONTROLLER', '''Onboard companion controller''')
MAV_TYPE_VTOL_DUOROTOR = 19 # Two-rotor VTOL using control surfaces in vertical operation in
                        # addition. Tailsitter.
enums['MAV_TYPE'][19] = EnumEntry('MAV_TYPE_VTOL_DUOROTOR', '''Two-rotor VTOL using control surfaces in vertical operation in addition. Tailsitter.''')
MAV_TYPE_VTOL_QUADROTOR = 20 # Quad-rotor VTOL using a V-shaped quad config in vertical operation.
                        # Tailsitter.
enums['MAV_TYPE'][20] = EnumEntry('MAV_TYPE_VTOL_QUADROTOR', '''Quad-rotor VTOL using a V-shaped quad config in vertical operation. Tailsitter.''')
MAV_TYPE_VTOL_TILTROTOR = 21 # Tiltrotor VTOL
enums['MAV_TYPE'][21] = EnumEntry('MAV_TYPE_VTOL_TILTROTOR', '''Tiltrotor VTOL''')
MAV_TYPE_VTOL_RESERVED2 = 22 # VTOL reserved 2
enums['MAV_TYPE'][22] = EnumEntry('MAV_TYPE_VTOL_RESERVED2', '''VTOL reserved 2''')
MAV_TYPE_VTOL_RESERVED3 = 23 # VTOL reserved 3
enums['MAV_TYPE'][23] = EnumEntry('MAV_TYPE_VTOL_RESERVED3', '''VTOL reserved 3''')
MAV_TYPE_VTOL_RESERVED4 = 24 # VTOL reserved 4
enums['MAV_TYPE'][24] = EnumEntry('MAV_TYPE_VTOL_RESERVED4', '''VTOL reserved 4''')
MAV_TYPE_VTOL_RESERVED5 = 25 # VTOL reserved 5
enums['MAV_TYPE'][25] = EnumEntry('MAV_TYPE_VTOL_RESERVED5', '''VTOL reserved 5''')
MAV_TYPE_GIMBAL = 26 # Gimbal
enums['MAV_TYPE'][26] = EnumEntry('MAV_TYPE_GIMBAL', '''Gimbal''')
MAV_TYPE_ADSB = 27 # ADSB system
enums['MAV_TYPE'][27] = EnumEntry('MAV_TYPE_ADSB', '''ADSB system''')
MAV_TYPE_PARAFOIL = 28 # Steerable, nonrigid airfoil
enums['MAV_TYPE'][28] = EnumEntry('MAV_TYPE_PARAFOIL', '''Steerable, nonrigid airfoil''')
MAV_TYPE_DODECAROTOR = 29 # Dodecarotor
enums['MAV_TYPE'][29] = EnumEntry('MAV_TYPE_DODECAROTOR', '''Dodecarotor''')
MAV_TYPE_CAMERA = 30 # Camera
enums['MAV_TYPE'][30] = EnumEntry('MAV_TYPE_CAMERA', '''Camera''')
MAV_TYPE_CHARGING_STATION = 31 # Charging station
enums['MAV_TYPE'][31] = EnumEntry('MAV_TYPE_CHARGING_STATION', '''Charging station''')
MAV_TYPE_FLARM = 32 # FLARM collision avoidance system
enums['MAV_TYPE'][32] = EnumEntry('MAV_TYPE_FLARM', '''FLARM collision avoidance system''')
MAV_TYPE_SERVO = 33 # Servo
enums['MAV_TYPE'][33] = EnumEntry('MAV_TYPE_SERVO', '''Servo''')
MAV_TYPE_ODID = 34 # Open Drone ID. See https://mavlink.io/en/services/opendroneid.html.
enums['MAV_TYPE'][34] = EnumEntry('MAV_TYPE_ODID', '''Open Drone ID. See https://mavlink.io/en/services/opendroneid.html.''')
MAV_TYPE_DECAROTOR = 35 # Decarotor
enums['MAV_TYPE'][35] = EnumEntry('MAV_TYPE_DECAROTOR', '''Decarotor''')
MAV_TYPE_ENUM_END = 36 # 
enums['MAV_TYPE'][36] = EnumEntry('MAV_TYPE_ENUM_END', '''''')

# MAV_MODE_FLAG
enums['MAV_MODE_FLAG'] = {}
MAV_MODE_FLAG_CUSTOM_MODE_ENABLED = 1 # 0b00000001 Reserved for future use.
enums['MAV_MODE_FLAG'][1] = EnumEntry('MAV_MODE_FLAG_CUSTOM_MODE_ENABLED', '''0b00000001 Reserved for future use.''')
MAV_MODE_FLAG_TEST_ENABLED = 2 # 0b00000010 system has a test mode enabled. This flag is intended for
                        # temporary system tests and should not be
                        # used for stable implementations.
enums['MAV_MODE_FLAG'][2] = EnumEntry('MAV_MODE_FLAG_TEST_ENABLED', '''0b00000010 system has a test mode enabled. This flag is intended for temporary system tests and should not be used for stable implementations.''')
MAV_MODE_FLAG_AUTO_ENABLED = 4 # 0b00000100 autonomous mode enabled, system finds its own goal
                        # positions. Guided flag can be set or not,
                        # depends on the actual implementation.
enums['MAV_MODE_FLAG'][4] = EnumEntry('MAV_MODE_FLAG_AUTO_ENABLED', '''0b00000100 autonomous mode enabled, system finds its own goal positions. Guided flag can be set or not, depends on the actual implementation.''')
MAV_MODE_FLAG_GUIDED_ENABLED = 8 # 0b00001000 guided mode enabled, system flies waypoints / mission
                        # items.
enums['MAV_MODE_FLAG'][8] = EnumEntry('MAV_MODE_FLAG_GUIDED_ENABLED', '''0b00001000 guided mode enabled, system flies waypoints / mission items.''')
MAV_MODE_FLAG_STABILIZE_ENABLED = 16 # 0b00010000 system stabilizes electronically its attitude (and
                        # optionally position). It needs however
                        # further control inputs to move around.
enums['MAV_MODE_FLAG'][16] = EnumEntry('MAV_MODE_FLAG_STABILIZE_ENABLED', '''0b00010000 system stabilizes electronically its attitude (and optionally position). It needs however further control inputs to move around.''')
MAV_MODE_FLAG_HIL_ENABLED = 32 # 0b00100000 hardware in the loop simulation. All motors / actuators are
                        # blocked, but internal software is full
                        # operational.
enums['MAV_MODE_FLAG'][32] = EnumEntry('MAV_MODE_FLAG_HIL_ENABLED', '''0b00100000 hardware in the loop simulation. All motors / actuators are blocked, but internal software is full operational.''')
MAV_MODE_FLAG_MANUAL_INPUT_ENABLED = 64 # 0b01000000 remote control input is enabled.
enums['MAV_MODE_FLAG'][64] = EnumEntry('MAV_MODE_FLAG_MANUAL_INPUT_ENABLED', '''0b01000000 remote control input is enabled.''')
MAV_MODE_FLAG_SAFETY_ARMED = 128 # 0b10000000 MAV safety set to armed. Motors are enabled / running / can
                        # start. Ready to fly. Additional note: this
                        # flag is to be ignore when sent in the
                        # command MAV_CMD_DO_SET_MODE and
                        # MAV_CMD_COMPONENT_ARM_DISARM shall be used
                        # instead. The flag can still be used to
                        # report the armed state.
enums['MAV_MODE_FLAG'][128] = EnumEntry('MAV_MODE_FLAG_SAFETY_ARMED', '''0b10000000 MAV safety set to armed. Motors are enabled / running / can start. Ready to fly. Additional note: this flag is to be ignore when sent in the command MAV_CMD_DO_SET_MODE and MAV_CMD_COMPONENT_ARM_DISARM shall be used instead. The flag can still be used to report the armed state.''')
MAV_MODE_FLAG_ENUM_END = 129 # 
enums['MAV_MODE_FLAG'][129] = EnumEntry('MAV_MODE_FLAG_ENUM_END', '''''')

# MAV_MODE_FLAG_DECODE_POSITION
enums['MAV_MODE_FLAG_DECODE_POSITION'] = {}
MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE = 1 # Eighth bit: 00000001
enums['MAV_MODE_FLAG_DECODE_POSITION'][1] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE', '''Eighth bit: 00000001''')
MAV_MODE_FLAG_DECODE_POSITION_TEST = 2 # Seventh bit: 00000010
enums['MAV_MODE_FLAG_DECODE_POSITION'][2] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_TEST', '''Seventh bit: 00000010''')
MAV_MODE_FLAG_DECODE_POSITION_AUTO = 4 # Sixth bit:   00000100
enums['MAV_MODE_FLAG_DECODE_POSITION'][4] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_AUTO', '''Sixth bit:   00000100''')
MAV_MODE_FLAG_DECODE_POSITION_GUIDED = 8 # Fifth bit:  00001000
enums['MAV_MODE_FLAG_DECODE_POSITION'][8] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_GUIDED', '''Fifth bit:  00001000''')
MAV_MODE_FLAG_DECODE_POSITION_STABILIZE = 16 # Fourth bit: 00010000
enums['MAV_MODE_FLAG_DECODE_POSITION'][16] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_STABILIZE', '''Fourth bit: 00010000''')
MAV_MODE_FLAG_DECODE_POSITION_HIL = 32 # Third bit:  00100000
enums['MAV_MODE_FLAG_DECODE_POSITION'][32] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_HIL', '''Third bit:  00100000''')
MAV_MODE_FLAG_DECODE_POSITION_MANUAL = 64 # Second bit: 01000000
enums['MAV_MODE_FLAG_DECODE_POSITION'][64] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_MANUAL', '''Second bit: 01000000''')
MAV_MODE_FLAG_DECODE_POSITION_SAFETY = 128 # First bit:  10000000
enums['MAV_MODE_FLAG_DECODE_POSITION'][128] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_SAFETY', '''First bit:  10000000''')
MAV_MODE_FLAG_DECODE_POSITION_ENUM_END = 129 # 
enums['MAV_MODE_FLAG_DECODE_POSITION'][129] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_ENUM_END', '''''')

# MAV_STATE
enums['MAV_STATE'] = {}
MAV_STATE_UNINIT = 0 # Uninitialized system, state is unknown.
enums['MAV_STATE'][0] = EnumEntry('MAV_STATE_UNINIT', '''Uninitialized system, state is unknown.''')
MAV_STATE_BOOT = 1 # System is booting up.
enums['MAV_STATE'][1] = EnumEntry('MAV_STATE_BOOT', '''System is booting up.''')
MAV_STATE_CALIBRATING = 2 # System is calibrating and not flight-ready.
enums['MAV_STATE'][2] = EnumEntry('MAV_STATE_CALIBRATING', '''System is calibrating and not flight-ready.''')
MAV_STATE_STANDBY = 3 # System is grounded and on standby. It can be launched any time.
enums['MAV_STATE'][3] = EnumEntry('MAV_STATE_STANDBY', '''System is grounded and on standby. It can be launched any time.''')
MAV_STATE_ACTIVE = 4 # System is active and might be already airborne. Motors are engaged.
enums['MAV_STATE'][4] = EnumEntry('MAV_STATE_ACTIVE', '''System is active and might be already airborne. Motors are engaged.''')
MAV_STATE_CRITICAL = 5 # System is in a non-normal flight mode. It can however still navigate.
enums['MAV_STATE'][5] = EnumEntry('MAV_STATE_CRITICAL', '''System is in a non-normal flight mode. It can however still navigate.''')
MAV_STATE_EMERGENCY = 6 # System is in a non-normal flight mode. It lost control over parts or
                        # over the whole airframe. It is in mayday and
                        # going down.
enums['MAV_STATE'][6] = EnumEntry('MAV_STATE_EMERGENCY', '''System is in a non-normal flight mode. It lost control over parts or over the whole airframe. It is in mayday and going down.''')
MAV_STATE_POWEROFF = 7 # System just initialized its power-down sequence, will shut down now.
enums['MAV_STATE'][7] = EnumEntry('MAV_STATE_POWEROFF', '''System just initialized its power-down sequence, will shut down now.''')
MAV_STATE_FLIGHT_TERMINATION = 8 # System is terminating itself.
enums['MAV_STATE'][8] = EnumEntry('MAV_STATE_FLIGHT_TERMINATION', '''System is terminating itself.''')
MAV_STATE_ENUM_END = 9 # 
enums['MAV_STATE'][9] = EnumEntry('MAV_STATE_ENUM_END', '''''')

# MAV_COMPONENT
enums['MAV_COMPONENT'] = {}
MAV_COMP_ID_ALL = 0 # Target id (target_component) used to broadcast messages to all
                        # components of the receiving system.
                        # Components should attempt to process
                        # messages with this component ID and forward
                        # to components on any other interfaces. Note:
                        # This is not a valid *source* component id
                        # for a message.
enums['MAV_COMPONENT'][0] = EnumEntry('MAV_COMP_ID_ALL', '''Target id (target_component) used to broadcast messages to all components of the receiving system. Components should attempt to process messages with this component ID and forward to components on any other interfaces. Note: This is not a valid *source* component id for a message.''')
MAV_COMP_ID_AUTOPILOT1 = 1 # System flight controller component ("autopilot"). Only one autopilot
                        # is expected in a particular system.
enums['MAV_COMPONENT'][1] = EnumEntry('MAV_COMP_ID_AUTOPILOT1', '''System flight controller component ("autopilot"). Only one autopilot is expected in a particular system.''')
MAV_COMP_ID_USER1 = 25 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][25] = EnumEntry('MAV_COMP_ID_USER1', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER2 = 26 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][26] = EnumEntry('MAV_COMP_ID_USER2', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER3 = 27 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][27] = EnumEntry('MAV_COMP_ID_USER3', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER4 = 28 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][28] = EnumEntry('MAV_COMP_ID_USER4', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER5 = 29 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][29] = EnumEntry('MAV_COMP_ID_USER5', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER6 = 30 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][30] = EnumEntry('MAV_COMP_ID_USER6', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER7 = 31 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][31] = EnumEntry('MAV_COMP_ID_USER7', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER8 = 32 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][32] = EnumEntry('MAV_COMP_ID_USER8', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER9 = 33 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][33] = EnumEntry('MAV_COMP_ID_USER9', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER10 = 34 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][34] = EnumEntry('MAV_COMP_ID_USER10', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER11 = 35 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][35] = EnumEntry('MAV_COMP_ID_USER11', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER12 = 36 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][36] = EnumEntry('MAV_COMP_ID_USER12', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER13 = 37 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][37] = EnumEntry('MAV_COMP_ID_USER13', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER14 = 38 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][38] = EnumEntry('MAV_COMP_ID_USER14', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER15 = 39 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][39] = EnumEntry('MAV_COMP_ID_USER15', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER16 = 40 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][40] = EnumEntry('MAV_COMP_ID_USER16', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER17 = 41 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][41] = EnumEntry('MAV_COMP_ID_USER17', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER18 = 42 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][42] = EnumEntry('MAV_COMP_ID_USER18', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER19 = 43 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][43] = EnumEntry('MAV_COMP_ID_USER19', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER20 = 44 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][44] = EnumEntry('MAV_COMP_ID_USER20', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER21 = 45 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][45] = EnumEntry('MAV_COMP_ID_USER21', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER22 = 46 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][46] = EnumEntry('MAV_COMP_ID_USER22', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER23 = 47 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][47] = EnumEntry('MAV_COMP_ID_USER23', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER24 = 48 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][48] = EnumEntry('MAV_COMP_ID_USER24', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER25 = 49 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][49] = EnumEntry('MAV_COMP_ID_USER25', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER26 = 50 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][50] = EnumEntry('MAV_COMP_ID_USER26', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER27 = 51 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][51] = EnumEntry('MAV_COMP_ID_USER27', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER28 = 52 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][52] = EnumEntry('MAV_COMP_ID_USER28', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER29 = 53 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][53] = EnumEntry('MAV_COMP_ID_USER29', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER30 = 54 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][54] = EnumEntry('MAV_COMP_ID_USER30', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER31 = 55 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][55] = EnumEntry('MAV_COMP_ID_USER31', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER32 = 56 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][56] = EnumEntry('MAV_COMP_ID_USER32', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER33 = 57 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][57] = EnumEntry('MAV_COMP_ID_USER33', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER34 = 58 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][58] = EnumEntry('MAV_COMP_ID_USER34', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER35 = 59 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][59] = EnumEntry('MAV_COMP_ID_USER35', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER36 = 60 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][60] = EnumEntry('MAV_COMP_ID_USER36', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER37 = 61 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][61] = EnumEntry('MAV_COMP_ID_USER37', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER38 = 62 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][62] = EnumEntry('MAV_COMP_ID_USER38', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER39 = 63 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][63] = EnumEntry('MAV_COMP_ID_USER39', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER40 = 64 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][64] = EnumEntry('MAV_COMP_ID_USER40', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER41 = 65 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][65] = EnumEntry('MAV_COMP_ID_USER41', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER42 = 66 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][66] = EnumEntry('MAV_COMP_ID_USER42', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER43 = 67 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][67] = EnumEntry('MAV_COMP_ID_USER43', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_TELEMETRY_RADIO = 68 # Telemetry radio (e.g. SiK radio, or other component that emits
                        # RADIO_STATUS messages).
enums['MAV_COMPONENT'][68] = EnumEntry('MAV_COMP_ID_TELEMETRY_RADIO', '''Telemetry radio (e.g. SiK radio, or other component that emits RADIO_STATUS messages).''')
MAV_COMP_ID_USER45 = 69 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][69] = EnumEntry('MAV_COMP_ID_USER45', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER46 = 70 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][70] = EnumEntry('MAV_COMP_ID_USER46', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER47 = 71 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][71] = EnumEntry('MAV_COMP_ID_USER47', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER48 = 72 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][72] = EnumEntry('MAV_COMP_ID_USER48', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER49 = 73 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][73] = EnumEntry('MAV_COMP_ID_USER49', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER50 = 74 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][74] = EnumEntry('MAV_COMP_ID_USER50', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER51 = 75 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][75] = EnumEntry('MAV_COMP_ID_USER51', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER52 = 76 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][76] = EnumEntry('MAV_COMP_ID_USER52', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER53 = 77 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][77] = EnumEntry('MAV_COMP_ID_USER53', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER54 = 78 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][78] = EnumEntry('MAV_COMP_ID_USER54', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER55 = 79 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][79] = EnumEntry('MAV_COMP_ID_USER55', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER56 = 80 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][80] = EnumEntry('MAV_COMP_ID_USER56', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER57 = 81 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][81] = EnumEntry('MAV_COMP_ID_USER57', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER58 = 82 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][82] = EnumEntry('MAV_COMP_ID_USER58', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER59 = 83 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][83] = EnumEntry('MAV_COMP_ID_USER59', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER60 = 84 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][84] = EnumEntry('MAV_COMP_ID_USER60', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER61 = 85 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][85] = EnumEntry('MAV_COMP_ID_USER61', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER62 = 86 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][86] = EnumEntry('MAV_COMP_ID_USER62', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER63 = 87 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][87] = EnumEntry('MAV_COMP_ID_USER63', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER64 = 88 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][88] = EnumEntry('MAV_COMP_ID_USER64', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER65 = 89 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][89] = EnumEntry('MAV_COMP_ID_USER65', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER66 = 90 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][90] = EnumEntry('MAV_COMP_ID_USER66', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER67 = 91 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][91] = EnumEntry('MAV_COMP_ID_USER67', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER68 = 92 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][92] = EnumEntry('MAV_COMP_ID_USER68', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER69 = 93 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][93] = EnumEntry('MAV_COMP_ID_USER69', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER70 = 94 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][94] = EnumEntry('MAV_COMP_ID_USER70', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER71 = 95 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][95] = EnumEntry('MAV_COMP_ID_USER71', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER72 = 96 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][96] = EnumEntry('MAV_COMP_ID_USER72', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER73 = 97 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][97] = EnumEntry('MAV_COMP_ID_USER73', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER74 = 98 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][98] = EnumEntry('MAV_COMP_ID_USER74', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER75 = 99 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][99] = EnumEntry('MAV_COMP_ID_USER75', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_CAMERA = 100 # Camera #1.
enums['MAV_COMPONENT'][100] = EnumEntry('MAV_COMP_ID_CAMERA', '''Camera #1.''')
MAV_COMP_ID_CAMERA2 = 101 # Camera #2.
enums['MAV_COMPONENT'][101] = EnumEntry('MAV_COMP_ID_CAMERA2', '''Camera #2.''')
MAV_COMP_ID_CAMERA3 = 102 # Camera #3.
enums['MAV_COMPONENT'][102] = EnumEntry('MAV_COMP_ID_CAMERA3', '''Camera #3.''')
MAV_COMP_ID_CAMERA4 = 103 # Camera #4.
enums['MAV_COMPONENT'][103] = EnumEntry('MAV_COMP_ID_CAMERA4', '''Camera #4.''')
MAV_COMP_ID_CAMERA5 = 104 # Camera #5.
enums['MAV_COMPONENT'][104] = EnumEntry('MAV_COMP_ID_CAMERA5', '''Camera #5.''')
MAV_COMP_ID_CAMERA6 = 105 # Camera #6.
enums['MAV_COMPONENT'][105] = EnumEntry('MAV_COMP_ID_CAMERA6', '''Camera #6.''')
MAV_COMP_ID_SERVO1 = 140 # Servo #1.
enums['MAV_COMPONENT'][140] = EnumEntry('MAV_COMP_ID_SERVO1', '''Servo #1.''')
MAV_COMP_ID_SERVO2 = 141 # Servo #2.
enums['MAV_COMPONENT'][141] = EnumEntry('MAV_COMP_ID_SERVO2', '''Servo #2.''')
MAV_COMP_ID_SERVO3 = 142 # Servo #3.
enums['MAV_COMPONENT'][142] = EnumEntry('MAV_COMP_ID_SERVO3', '''Servo #3.''')
MAV_COMP_ID_SERVO4 = 143 # Servo #4.
enums['MAV_COMPONENT'][143] = EnumEntry('MAV_COMP_ID_SERVO4', '''Servo #4.''')
MAV_COMP_ID_SERVO5 = 144 # Servo #5.
enums['MAV_COMPONENT'][144] = EnumEntry('MAV_COMP_ID_SERVO5', '''Servo #5.''')
MAV_COMP_ID_SERVO6 = 145 # Servo #6.
enums['MAV_COMPONENT'][145] = EnumEntry('MAV_COMP_ID_SERVO6', '''Servo #6.''')
MAV_COMP_ID_SERVO7 = 146 # Servo #7.
enums['MAV_COMPONENT'][146] = EnumEntry('MAV_COMP_ID_SERVO7', '''Servo #7.''')
MAV_COMP_ID_SERVO8 = 147 # Servo #8.
enums['MAV_COMPONENT'][147] = EnumEntry('MAV_COMP_ID_SERVO8', '''Servo #8.''')
MAV_COMP_ID_SERVO9 = 148 # Servo #9.
enums['MAV_COMPONENT'][148] = EnumEntry('MAV_COMP_ID_SERVO9', '''Servo #9.''')
MAV_COMP_ID_SERVO10 = 149 # Servo #10.
enums['MAV_COMPONENT'][149] = EnumEntry('MAV_COMP_ID_SERVO10', '''Servo #10.''')
MAV_COMP_ID_SERVO11 = 150 # Servo #11.
enums['MAV_COMPONENT'][150] = EnumEntry('MAV_COMP_ID_SERVO11', '''Servo #11.''')
MAV_COMP_ID_SERVO12 = 151 # Servo #12.
enums['MAV_COMPONENT'][151] = EnumEntry('MAV_COMP_ID_SERVO12', '''Servo #12.''')
MAV_COMP_ID_SERVO13 = 152 # Servo #13.
enums['MAV_COMPONENT'][152] = EnumEntry('MAV_COMP_ID_SERVO13', '''Servo #13.''')
MAV_COMP_ID_SERVO14 = 153 # Servo #14.
enums['MAV_COMPONENT'][153] = EnumEntry('MAV_COMP_ID_SERVO14', '''Servo #14.''')
MAV_COMP_ID_GIMBAL = 154 # Gimbal #1.
enums['MAV_COMPONENT'][154] = EnumEntry('MAV_COMP_ID_GIMBAL', '''Gimbal #1.''')
MAV_COMP_ID_LOG = 155 # Logging component.
enums['MAV_COMPONENT'][155] = EnumEntry('MAV_COMP_ID_LOG', '''Logging component.''')
MAV_COMP_ID_ADSB = 156 # Automatic Dependent Surveillance-Broadcast (ADS-B) component.
enums['MAV_COMPONENT'][156] = EnumEntry('MAV_COMP_ID_ADSB', '''Automatic Dependent Surveillance-Broadcast (ADS-B) component.''')
MAV_COMP_ID_OSD = 157 # On Screen Display (OSD) devices for video links.
enums['MAV_COMPONENT'][157] = EnumEntry('MAV_COMP_ID_OSD', '''On Screen Display (OSD) devices for video links.''')
MAV_COMP_ID_PERIPHERAL = 158 # Generic autopilot peripheral component ID. Meant for devices that do
                        # not implement the parameter microservice.
enums['MAV_COMPONENT'][158] = EnumEntry('MAV_COMP_ID_PERIPHERAL', '''Generic autopilot peripheral component ID. Meant for devices that do not implement the parameter microservice.''')
MAV_COMP_ID_QX1_GIMBAL = 159 # Gimbal ID for QX1.
enums['MAV_COMPONENT'][159] = EnumEntry('MAV_COMP_ID_QX1_GIMBAL', '''Gimbal ID for QX1.''')
MAV_COMP_ID_FLARM = 160 # FLARM collision alert component.
enums['MAV_COMPONENT'][160] = EnumEntry('MAV_COMP_ID_FLARM', '''FLARM collision alert component.''')
MAV_COMP_ID_GIMBAL2 = 171 # Gimbal #2.
enums['MAV_COMPONENT'][171] = EnumEntry('MAV_COMP_ID_GIMBAL2', '''Gimbal #2.''')
MAV_COMP_ID_GIMBAL3 = 172 # Gimbal #3.
enums['MAV_COMPONENT'][172] = EnumEntry('MAV_COMP_ID_GIMBAL3', '''Gimbal #3.''')
MAV_COMP_ID_GIMBAL4 = 173 # Gimbal #4
enums['MAV_COMPONENT'][173] = EnumEntry('MAV_COMP_ID_GIMBAL4', '''Gimbal #4''')
MAV_COMP_ID_GIMBAL5 = 174 # Gimbal #5.
enums['MAV_COMPONENT'][174] = EnumEntry('MAV_COMP_ID_GIMBAL5', '''Gimbal #5.''')
MAV_COMP_ID_GIMBAL6 = 175 # Gimbal #6.
enums['MAV_COMPONENT'][175] = EnumEntry('MAV_COMP_ID_GIMBAL6', '''Gimbal #6.''')
MAV_COMP_ID_MISSIONPLANNER = 190 # Component that can generate/supply a mission flight plan (e.g. GCS or
                        # developer API).
enums['MAV_COMPONENT'][190] = EnumEntry('MAV_COMP_ID_MISSIONPLANNER', '''Component that can generate/supply a mission flight plan (e.g. GCS or developer API).''')
MAV_COMP_ID_ONBOARD_COMPUTER = 191 # Component that lives on the onboard computer (companion computer) and
                        # has some generic functionalities, such as
                        # settings system parameters and monitoring
                        # the status of some processes that don't
                        # directly speak mavlink and so on.
enums['MAV_COMPONENT'][191] = EnumEntry('MAV_COMP_ID_ONBOARD_COMPUTER', '''Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.''')
MAV_COMP_ID_PATHPLANNER = 195 # Component that finds an optimal path between points based on a certain
                        # constraint (e.g. minimum snap, shortest
                        # path, cost, etc.).
enums['MAV_COMPONENT'][195] = EnumEntry('MAV_COMP_ID_PATHPLANNER', '''Component that finds an optimal path between points based on a certain constraint (e.g. minimum snap, shortest path, cost, etc.).''')
MAV_COMP_ID_OBSTACLE_AVOIDANCE = 196 # Component that plans a collision free path between two points.
enums['MAV_COMPONENT'][196] = EnumEntry('MAV_COMP_ID_OBSTACLE_AVOIDANCE', '''Component that plans a collision free path between two points.''')
MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY = 197 # Component that provides position estimates using VIO techniques.
enums['MAV_COMPONENT'][197] = EnumEntry('MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY', '''Component that provides position estimates using VIO techniques.''')
MAV_COMP_ID_PAIRING_MANAGER = 198 # Component that manages pairing of vehicle and GCS.
enums['MAV_COMPONENT'][198] = EnumEntry('MAV_COMP_ID_PAIRING_MANAGER', '''Component that manages pairing of vehicle and GCS.''')
MAV_COMP_ID_IMU = 200 # Inertial Measurement Unit (IMU) #1.
enums['MAV_COMPONENT'][200] = EnumEntry('MAV_COMP_ID_IMU', '''Inertial Measurement Unit (IMU) #1.''')
MAV_COMP_ID_IMU_2 = 201 # Inertial Measurement Unit (IMU) #2.
enums['MAV_COMPONENT'][201] = EnumEntry('MAV_COMP_ID_IMU_2', '''Inertial Measurement Unit (IMU) #2.''')
MAV_COMP_ID_IMU_3 = 202 # Inertial Measurement Unit (IMU) #3.
enums['MAV_COMPONENT'][202] = EnumEntry('MAV_COMP_ID_IMU_3', '''Inertial Measurement Unit (IMU) #3.''')
MAV_COMP_ID_GPS = 220 # GPS #1.
enums['MAV_COMPONENT'][220] = EnumEntry('MAV_COMP_ID_GPS', '''GPS #1.''')
MAV_COMP_ID_GPS2 = 221 # GPS #2.
enums['MAV_COMPONENT'][221] = EnumEntry('MAV_COMP_ID_GPS2', '''GPS #2.''')
MAV_COMP_ID_ODID_TXRX_1 = 236 # Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).
enums['MAV_COMPONENT'][236] = EnumEntry('MAV_COMP_ID_ODID_TXRX_1', '''Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).''')
MAV_COMP_ID_ODID_TXRX_2 = 237 # Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).
enums['MAV_COMPONENT'][237] = EnumEntry('MAV_COMP_ID_ODID_TXRX_2', '''Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).''')
MAV_COMP_ID_ODID_TXRX_3 = 238 # Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).
enums['MAV_COMPONENT'][238] = EnumEntry('MAV_COMP_ID_ODID_TXRX_3', '''Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).''')
MAV_COMP_ID_UDP_BRIDGE = 240 # Component to bridge MAVLink to UDP (i.e. from a UART).
enums['MAV_COMPONENT'][240] = EnumEntry('MAV_COMP_ID_UDP_BRIDGE', '''Component to bridge MAVLink to UDP (i.e. from a UART).''')
MAV_COMP_ID_UART_BRIDGE = 241 # Component to bridge to UART (i.e. from UDP).
enums['MAV_COMPONENT'][241] = EnumEntry('MAV_COMP_ID_UART_BRIDGE', '''Component to bridge to UART (i.e. from UDP).''')
MAV_COMP_ID_TUNNEL_NODE = 242 # Component handling TUNNEL messages (e.g. vendor specific GUI of a
                        # component).
enums['MAV_COMPONENT'][242] = EnumEntry('MAV_COMP_ID_TUNNEL_NODE', '''Component handling TUNNEL messages (e.g. vendor specific GUI of a component).''')
MAV_COMP_ID_SYSTEM_CONTROL = 250 # Component for handling system messages (e.g. to ARM, takeoff, etc.).
enums['MAV_COMPONENT'][250] = EnumEntry('MAV_COMP_ID_SYSTEM_CONTROL', '''Component for handling system messages (e.g. to ARM, takeoff, etc.).''')
MAV_COMPONENT_ENUM_END = 251 # 
enums['MAV_COMPONENT'][251] = EnumEntry('MAV_COMPONENT_ENUM_END', '''''')

# UALBERTA_AUTOPILOT_MODE
enums['UALBERTA_AUTOPILOT_MODE'] = {}
MODE_MANUAL_DIRECT = 1 # Raw input pulse widts sent to output
enums['UALBERTA_AUTOPILOT_MODE'][1] = EnumEntry('MODE_MANUAL_DIRECT', '''Raw input pulse widts sent to output''')
MODE_MANUAL_SCALED = 2 # Inputs are normalized using calibration, the converted back to raw
                        # pulse widths for output
enums['UALBERTA_AUTOPILOT_MODE'][2] = EnumEntry('MODE_MANUAL_SCALED', '''Inputs are normalized using calibration, the converted back to raw pulse widths for output''')
MODE_AUTO_PID_ATT = 3 #  dfsdfs
enums['UALBERTA_AUTOPILOT_MODE'][3] = EnumEntry('MODE_AUTO_PID_ATT', ''' dfsdfs''')
MODE_AUTO_PID_VEL = 4 #  dfsfds
enums['UALBERTA_AUTOPILOT_MODE'][4] = EnumEntry('MODE_AUTO_PID_VEL', ''' dfsfds''')
MODE_AUTO_PID_POS = 5 #  dfsdfsdfs
enums['UALBERTA_AUTOPILOT_MODE'][5] = EnumEntry('MODE_AUTO_PID_POS', ''' dfsdfsdfs''')
UALBERTA_AUTOPILOT_MODE_ENUM_END = 6 # 
enums['UALBERTA_AUTOPILOT_MODE'][6] = EnumEntry('UALBERTA_AUTOPILOT_MODE_ENUM_END', '''''')

# UALBERTA_NAV_MODE
enums['UALBERTA_NAV_MODE'] = {}
NAV_AHRS_INIT = 1 # 
enums['UALBERTA_NAV_MODE'][1] = EnumEntry('NAV_AHRS_INIT', '''''')
NAV_AHRS = 2 # AHRS mode
enums['UALBERTA_NAV_MODE'][2] = EnumEntry('NAV_AHRS', '''AHRS mode''')
NAV_INS_GPS_INIT = 3 # INS/GPS initialization mode
enums['UALBERTA_NAV_MODE'][3] = EnumEntry('NAV_INS_GPS_INIT', '''INS/GPS initialization mode''')
NAV_INS_GPS = 4 # INS/GPS mode
enums['UALBERTA_NAV_MODE'][4] = EnumEntry('NAV_INS_GPS', '''INS/GPS mode''')
UALBERTA_NAV_MODE_ENUM_END = 5 # 
enums['UALBERTA_NAV_MODE'][5] = EnumEntry('UALBERTA_NAV_MODE_ENUM_END', '''''')

# UALBERTA_PILOT_MODE
enums['UALBERTA_PILOT_MODE'] = {}
PILOT_MANUAL = 1 #  sdf
enums['UALBERTA_PILOT_MODE'][1] = EnumEntry('PILOT_MANUAL', ''' sdf''')
PILOT_AUTO = 2 #  dfs
enums['UALBERTA_PILOT_MODE'][2] = EnumEntry('PILOT_AUTO', ''' dfs''')
PILOT_ROTO = 3 #  Rotomotion mode
enums['UALBERTA_PILOT_MODE'][3] = EnumEntry('PILOT_ROTO', ''' Rotomotion mode ''')
UALBERTA_PILOT_MODE_ENUM_END = 4 # 
enums['UALBERTA_PILOT_MODE'][4] = EnumEntry('UALBERTA_PILOT_MODE_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_DYNAMIC_STATE
enums['UAVIONIX_ADSB_OUT_DYNAMIC_STATE'] = {}
UAVIONIX_ADSB_OUT_DYNAMIC_STATE_INTENT_CHANGE = 1 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_STATE'][1] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_STATE_INTENT_CHANGE', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_STATE_AUTOPILOT_ENABLED = 2 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_STATE'][2] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_STATE_AUTOPILOT_ENABLED', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_STATE_NICBARO_CROSSCHECKED = 4 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_STATE'][4] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_STATE_NICBARO_CROSSCHECKED', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_STATE_ON_GROUND = 8 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_STATE'][8] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_STATE_ON_GROUND', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_STATE_IDENT = 16 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_STATE'][16] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_STATE_IDENT', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_STATE_ENUM_END = 17 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_STATE'][17] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_STATE_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_RF_SELECT
enums['UAVIONIX_ADSB_OUT_RF_SELECT'] = {}
UAVIONIX_ADSB_OUT_RF_SELECT_STANDBY = 0 # 
enums['UAVIONIX_ADSB_OUT_RF_SELECT'][0] = EnumEntry('UAVIONIX_ADSB_OUT_RF_SELECT_STANDBY', '''''')
UAVIONIX_ADSB_OUT_RF_SELECT_RX_ENABLED = 1 # 
enums['UAVIONIX_ADSB_OUT_RF_SELECT'][1] = EnumEntry('UAVIONIX_ADSB_OUT_RF_SELECT_RX_ENABLED', '''''')
UAVIONIX_ADSB_OUT_RF_SELECT_TX_ENABLED = 2 # 
enums['UAVIONIX_ADSB_OUT_RF_SELECT'][2] = EnumEntry('UAVIONIX_ADSB_OUT_RF_SELECT_TX_ENABLED', '''''')
UAVIONIX_ADSB_OUT_RF_SELECT_ENUM_END = 3 # 
enums['UAVIONIX_ADSB_OUT_RF_SELECT'][3] = EnumEntry('UAVIONIX_ADSB_OUT_RF_SELECT_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'] = {}
UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_NONE_0 = 0 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'][0] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_NONE_0', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_NONE_1 = 1 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'][1] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_NONE_1', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_2D = 2 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'][2] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_2D', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_3D = 3 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'][3] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_3D', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_DGPS = 4 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'][4] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_DGPS', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_RTK = 5 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'][5] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_RTK', '''''')
UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_ENUM_END = 6 # 
enums['UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX'][6] = EnumEntry('UAVIONIX_ADSB_OUT_DYNAMIC_GPS_FIX_ENUM_END', '''''')

# UAVIONIX_ADSB_RF_HEALTH
enums['UAVIONIX_ADSB_RF_HEALTH'] = {}
UAVIONIX_ADSB_RF_HEALTH_INITIALIZING = 0 # 
enums['UAVIONIX_ADSB_RF_HEALTH'][0] = EnumEntry('UAVIONIX_ADSB_RF_HEALTH_INITIALIZING', '''''')
UAVIONIX_ADSB_RF_HEALTH_OK = 1 # 
enums['UAVIONIX_ADSB_RF_HEALTH'][1] = EnumEntry('UAVIONIX_ADSB_RF_HEALTH_OK', '''''')
UAVIONIX_ADSB_RF_HEALTH_FAIL_TX = 2 # 
enums['UAVIONIX_ADSB_RF_HEALTH'][2] = EnumEntry('UAVIONIX_ADSB_RF_HEALTH_FAIL_TX', '''''')
UAVIONIX_ADSB_RF_HEALTH_FAIL_RX = 16 # 
enums['UAVIONIX_ADSB_RF_HEALTH'][16] = EnumEntry('UAVIONIX_ADSB_RF_HEALTH_FAIL_RX', '''''')
UAVIONIX_ADSB_RF_HEALTH_ENUM_END = 17 # 
enums['UAVIONIX_ADSB_RF_HEALTH'][17] = EnumEntry('UAVIONIX_ADSB_RF_HEALTH_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'] = {}
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_NO_DATA = 0 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][0] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_NO_DATA', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L15M_W23M = 1 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][1] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L15M_W23M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L25M_W28P5M = 2 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][2] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L25M_W28P5M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L25_34M = 3 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][3] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L25_34M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L35_33M = 4 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][4] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L35_33M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L35_38M = 5 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][5] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L35_38M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L45_39P5M = 6 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][6] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L45_39P5M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L45_45M = 7 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][7] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L45_45M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L55_45M = 8 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][8] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L55_45M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L55_52M = 9 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][9] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L55_52M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L65_59P5M = 10 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][10] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L65_59P5M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L65_67M = 11 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][11] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L65_67M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L75_W72P5M = 12 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][12] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L75_W72P5M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L75_W80M = 13 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][13] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L75_W80M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L85_W80M = 14 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][14] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L85_W80M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L85_W90M = 15 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][15] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_L85_W90M', '''''')
UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_ENUM_END = 16 # 
enums['UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE'][16] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_AIRCRAFT_SIZE_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'] = {}
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_NO_DATA = 0 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][0] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_NO_DATA', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_LEFT_2M = 1 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][1] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_LEFT_2M', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_LEFT_4M = 2 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][2] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_LEFT_4M', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_LEFT_6M = 3 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][3] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_LEFT_6M', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_0M = 4 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][4] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_0M', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_2M = 5 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][5] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_2M', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_4M = 6 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][6] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_4M', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_6M = 7 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][7] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_RIGHT_6M', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_ENUM_END = 8 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT'][8] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LAT_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON'] = {}
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON_NO_DATA = 0 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON'][0] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON_NO_DATA', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON_APPLIED_BY_SENSOR = 1 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON'][1] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON_APPLIED_BY_SENSOR', '''''')
UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON_ENUM_END = 2 # 
enums['UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON'][2] = EnumEntry('UAVIONIX_ADSB_OUT_CFG_GPS_OFFSET_LON_ENUM_END', '''''')

# UAVIONIX_ADSB_EMERGENCY_STATUS
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'] = {}
UAVIONIX_ADSB_OUT_NO_EMERGENCY = 0 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][0] = EnumEntry('UAVIONIX_ADSB_OUT_NO_EMERGENCY', '''''')
UAVIONIX_ADSB_OUT_GENERAL_EMERGENCY = 1 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][1] = EnumEntry('UAVIONIX_ADSB_OUT_GENERAL_EMERGENCY', '''''')
UAVIONIX_ADSB_OUT_LIFEGUARD_EMERGENCY = 2 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][2] = EnumEntry('UAVIONIX_ADSB_OUT_LIFEGUARD_EMERGENCY', '''''')
UAVIONIX_ADSB_OUT_MINIMUM_FUEL_EMERGENCY = 3 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][3] = EnumEntry('UAVIONIX_ADSB_OUT_MINIMUM_FUEL_EMERGENCY', '''''')
UAVIONIX_ADSB_OUT_NO_COMM_EMERGENCY = 4 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][4] = EnumEntry('UAVIONIX_ADSB_OUT_NO_COMM_EMERGENCY', '''''')
UAVIONIX_ADSB_OUT_UNLAWFUL_INTERFERANCE_EMERGENCY = 5 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][5] = EnumEntry('UAVIONIX_ADSB_OUT_UNLAWFUL_INTERFERANCE_EMERGENCY', '''''')
UAVIONIX_ADSB_OUT_DOWNED_AIRCRAFT_EMERGENCY = 6 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][6] = EnumEntry('UAVIONIX_ADSB_OUT_DOWNED_AIRCRAFT_EMERGENCY', '''''')
UAVIONIX_ADSB_OUT_RESERVED = 7 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][7] = EnumEntry('UAVIONIX_ADSB_OUT_RESERVED', '''''')
UAVIONIX_ADSB_EMERGENCY_STATUS_ENUM_END = 8 # 
enums['UAVIONIX_ADSB_EMERGENCY_STATUS'][8] = EnumEntry('UAVIONIX_ADSB_EMERGENCY_STATUS_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_CONTROL_STATE
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'] = {}
UAVIONIX_ADSB_OUT_CONTROL_STATE_EXTERNAL_BARO_CROSSCHECKED = 1 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][1] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_EXTERNAL_BARO_CROSSCHECKED', '''''')
UAVIONIX_ADSB_OUT_CONTROL_STATE_ON_GROUND = 4 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][4] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_ON_GROUND', '''''')
UAVIONIX_ADSB_OUT_CONTROL_STATE_IDENT_BUTTON_ACTIVE = 8 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][8] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_IDENT_BUTTON_ACTIVE', '''''')
UAVIONIX_ADSB_OUT_CONTROL_STATE_MODE_A_ENABLED = 16 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][16] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_MODE_A_ENABLED', '''''')
UAVIONIX_ADSB_OUT_CONTROL_STATE_MODE_C_ENABLED = 32 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][32] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_MODE_C_ENABLED', '''''')
UAVIONIX_ADSB_OUT_CONTROL_STATE_MODE_S_ENABLED = 64 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][64] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_MODE_S_ENABLED', '''''')
UAVIONIX_ADSB_OUT_CONTROL_STATE_1090ES_TX_ENABLED = 128 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][128] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_1090ES_TX_ENABLED', '''''')
UAVIONIX_ADSB_OUT_CONTROL_STATE_ENUM_END = 129 # 
enums['UAVIONIX_ADSB_OUT_CONTROL_STATE'][129] = EnumEntry('UAVIONIX_ADSB_OUT_CONTROL_STATE_ENUM_END', '''''')

# UAVIONIX_ADSB_XBIT
enums['UAVIONIX_ADSB_XBIT'] = {}
UAVIONIX_ADSB_XBIT_ENABLED = 128 # 
enums['UAVIONIX_ADSB_XBIT'][128] = EnumEntry('UAVIONIX_ADSB_XBIT_ENABLED', '''''')
UAVIONIX_ADSB_XBIT_ENUM_END = 129 # 
enums['UAVIONIX_ADSB_XBIT'][129] = EnumEntry('UAVIONIX_ADSB_XBIT_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_STATUS_STATE
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'] = {}
UAVIONIX_ADSB_OUT_STATUS_STATE_ON_GROUND = 1 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][1] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_ON_GROUND', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_INTERROGATED_SINCE_LAST = 2 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][2] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_INTERROGATED_SINCE_LAST', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_XBIT_ENABLED = 4 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][4] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_XBIT_ENABLED', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_IDENT_ACTIVE = 8 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][8] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_IDENT_ACTIVE', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_MODE_A_ENABLED = 16 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][16] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_MODE_A_ENABLED', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_MODE_C_ENABLED = 32 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][32] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_MODE_C_ENABLED', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_MODE_S_ENABLED = 64 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][64] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_MODE_S_ENABLED', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_1090ES_TX_ENABLED = 128 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][128] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_1090ES_TX_ENABLED', '''''')
UAVIONIX_ADSB_OUT_STATUS_STATE_ENUM_END = 129 # 
enums['UAVIONIX_ADSB_OUT_STATUS_STATE'][129] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_STATE_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_STATUS_NIC_NACP
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'] = {}
UAVIONIX_ADSB_NIC_CR_20_NM = 1 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][1] = EnumEntry('UAVIONIX_ADSB_NIC_CR_20_NM', '''''')
UAVIONIX_ADSB_NIC_CR_8_NM = 2 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][2] = EnumEntry('UAVIONIX_ADSB_NIC_CR_8_NM', '''''')
UAVIONIX_ADSB_NIC_CR_4_NM = 3 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][3] = EnumEntry('UAVIONIX_ADSB_NIC_CR_4_NM', '''''')
UAVIONIX_ADSB_NIC_CR_2_NM = 4 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][4] = EnumEntry('UAVIONIX_ADSB_NIC_CR_2_NM', '''''')
UAVIONIX_ADSB_NIC_CR_1_NM = 5 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][5] = EnumEntry('UAVIONIX_ADSB_NIC_CR_1_NM', '''''')
UAVIONIX_ADSB_NIC_CR_0_3_NM = 6 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][6] = EnumEntry('UAVIONIX_ADSB_NIC_CR_0_3_NM', '''''')
UAVIONIX_ADSB_NIC_CR_0_2_NM = 7 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][7] = EnumEntry('UAVIONIX_ADSB_NIC_CR_0_2_NM', '''''')
UAVIONIX_ADSB_NIC_CR_0_1_NM = 8 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][8] = EnumEntry('UAVIONIX_ADSB_NIC_CR_0_1_NM', '''''')
UAVIONIX_ADSB_NIC_CR_75_M = 9 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][9] = EnumEntry('UAVIONIX_ADSB_NIC_CR_75_M', '''''')
UAVIONIX_ADSB_NIC_CR_25_M = 10 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][10] = EnumEntry('UAVIONIX_ADSB_NIC_CR_25_M', '''''')
UAVIONIX_ADSB_NIC_CR_7_5_M = 11 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][11] = EnumEntry('UAVIONIX_ADSB_NIC_CR_7_5_M', '''''')
UAVIONIX_ADSB_NACP_EPU_10_NM = 16 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][16] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_10_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_4_NM = 32 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][32] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_4_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_2_NM = 48 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][48] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_2_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_1_NM = 64 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][64] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_1_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_0_5_NM = 80 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][80] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_0_5_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_0_3_NM = 96 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][96] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_0_3_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_0_1_NM = 112 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][112] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_0_1_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_0_05_NM = 128 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][128] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_0_05_NM', '''''')
UAVIONIX_ADSB_NACP_EPU_30_M = 144 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][144] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_30_M', '''''')
UAVIONIX_ADSB_NACP_EPU_10_M = 160 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][160] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_10_M', '''''')
UAVIONIX_ADSB_NACP_EPU_3_M = 176 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][176] = EnumEntry('UAVIONIX_ADSB_NACP_EPU_3_M', '''''')
UAVIONIX_ADSB_OUT_STATUS_NIC_NACP_ENUM_END = 177 # 
enums['UAVIONIX_ADSB_OUT_STATUS_NIC_NACP'][177] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_NIC_NACP_ENUM_END', '''''')

# UAVIONIX_ADSB_OUT_STATUS_FAULT
enums['UAVIONIX_ADSB_OUT_STATUS_FAULT'] = {}
UAVIONIX_ADSB_OUT_STATUS_FAULT_STATUS_MESSAGE_UNAVAIL = 8 # 
enums['UAVIONIX_ADSB_OUT_STATUS_FAULT'][8] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_FAULT_STATUS_MESSAGE_UNAVAIL', '''''')
UAVIONIX_ADSB_OUT_STATUS_FAULT_GPS_NO_POS = 16 # 
enums['UAVIONIX_ADSB_OUT_STATUS_FAULT'][16] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_FAULT_GPS_NO_POS', '''''')
UAVIONIX_ADSB_OUT_STATUS_FAULT_GPS_UNAVAIL = 32 # 
enums['UAVIONIX_ADSB_OUT_STATUS_FAULT'][32] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_FAULT_GPS_UNAVAIL', '''''')
UAVIONIX_ADSB_OUT_STATUS_FAULT_TX_SYSTEM_FAIL = 64 # 
enums['UAVIONIX_ADSB_OUT_STATUS_FAULT'][64] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_FAULT_TX_SYSTEM_FAIL', '''''')
UAVIONIX_ADSB_OUT_STATUS_FAULT_MAINT_REQ = 128 # 
enums['UAVIONIX_ADSB_OUT_STATUS_FAULT'][128] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_FAULT_MAINT_REQ', '''''')
UAVIONIX_ADSB_OUT_STATUS_FAULT_ENUM_END = 129 # 
enums['UAVIONIX_ADSB_OUT_STATUS_FAULT'][129] = EnumEntry('UAVIONIX_ADSB_OUT_STATUS_FAULT_ENUM_END', '''''')

# message IDs
MAVLINK_MSG_ID_BAD_DATA = -1
MAVLINK_MSG_ID_SENSOR_OFFSETS = 150
MAVLINK_MSG_ID_SET_MAG_OFFSETS = 151
MAVLINK_MSG_ID_MEMINFO = 152
MAVLINK_MSG_ID_AP_ADC = 153
MAVLINK_MSG_ID_DIGICAM_CONFIGURE = 154
MAVLINK_MSG_ID_DIGICAM_CONTROL = 155
MAVLINK_MSG_ID_MOUNT_CONFIGURE = 156
MAVLINK_MSG_ID_MOUNT_CONTROL = 157
MAVLINK_MSG_ID_MOUNT_STATUS = 158
MAVLINK_MSG_ID_FENCE_POINT = 160
MAVLINK_MSG_ID_FENCE_FETCH_POINT = 161
MAVLINK_MSG_ID_AHRS = 163
MAVLINK_MSG_ID_SIMSTATE = 164
MAVLINK_MSG_ID_HWSTATUS = 165
MAVLINK_MSG_ID_RADIO = 166
MAVLINK_MSG_ID_LIMITS_STATUS = 167
MAVLINK_MSG_ID_WIND = 168
MAVLINK_MSG_ID_DATA16 = 169
MAVLINK_MSG_ID_DATA32 = 170
MAVLINK_MSG_ID_DATA64 = 171
MAVLINK_MSG_ID_DATA96 = 172
MAVLINK_MSG_ID_RANGEFINDER = 173
MAVLINK_MSG_ID_AIRSPEED_AUTOCAL = 174
MAVLINK_MSG_ID_RALLY_POINT = 175
MAVLINK_MSG_ID_RALLY_FETCH_POINT = 176
MAVLINK_MSG_ID_COMPASSMOT_STATUS = 177
MAVLINK_MSG_ID_AHRS2 = 178
MAVLINK_MSG_ID_CAMERA_STATUS = 179
MAVLINK_MSG_ID_CAMERA_FEEDBACK = 180
MAVLINK_MSG_ID_BATTERY2 = 181
MAVLINK_MSG_ID_AHRS3 = 182
MAVLINK_MSG_ID_AUTOPILOT_VERSION_REQUEST = 183
MAVLINK_MSG_ID_REMOTE_LOG_DATA_BLOCK = 184
MAVLINK_MSG_ID_REMOTE_LOG_BLOCK_STATUS = 185
MAVLINK_MSG_ID_LED_CONTROL = 186
MAVLINK_MSG_ID_MAG_CAL_PROGRESS = 191
MAVLINK_MSG_ID_EKF_STATUS_REPORT = 193
MAVLINK_MSG_ID_PID_TUNING = 194
MAVLINK_MSG_ID_DEEPSTALL = 195
MAVLINK_MSG_ID_GIMBAL_REPORT = 200
MAVLINK_MSG_ID_GIMBAL_CONTROL = 201
MAVLINK_MSG_ID_GIMBAL_TORQUE_CMD_REPORT = 214
MAVLINK_MSG_ID_GOPRO_HEARTBEAT = 215
MAVLINK_MSG_ID_GOPRO_GET_REQUEST = 216
MAVLINK_MSG_ID_GOPRO_GET_RESPONSE = 217
MAVLINK_MSG_ID_GOPRO_SET_REQUEST = 218
MAVLINK_MSG_ID_GOPRO_SET_RESPONSE = 219
MAVLINK_MSG_ID_RPM = 226
MAVLINK_MSG_ID_SYS_STATUS = 1
MAVLINK_MSG_ID_SYSTEM_TIME = 2
MAVLINK_MSG_ID_PING = 4
MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL = 5
MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK = 6
MAVLINK_MSG_ID_AUTH_KEY = 7
MAVLINK_MSG_ID_SET_MODE = 11
MAVLINK_MSG_ID_PARAM_REQUEST_READ = 20
MAVLINK_MSG_ID_PARAM_REQUEST_LIST = 21
MAVLINK_MSG_ID_PARAM_VALUE = 22
MAVLINK_MSG_ID_PARAM_SET = 23
MAVLINK_MSG_ID_GPS_RAW_INT = 24
MAVLINK_MSG_ID_GPS_STATUS = 25
MAVLINK_MSG_ID_SCALED_IMU = 26
MAVLINK_MSG_ID_RAW_IMU = 27
MAVLINK_MSG_ID_RAW_PRESSURE = 28
MAVLINK_MSG_ID_SCALED_PRESSURE = 29
MAVLINK_MSG_ID_ATTITUDE = 30
MAVLINK_MSG_ID_ATTITUDE_QUATERNION = 31
MAVLINK_MSG_ID_LOCAL_POSITION_NED = 32
MAVLINK_MSG_ID_GLOBAL_POSITION_INT = 33
MAVLINK_MSG_ID_RC_CHANNELS_SCALED = 34
MAVLINK_MSG_ID_RC_CHANNELS_RAW = 35
MAVLINK_MSG_ID_SERVO_OUTPUT_RAW = 36
MAVLINK_MSG_ID_MISSION_REQUEST_PARTIAL_LIST = 37
MAVLINK_MSG_ID_MISSION_WRITE_PARTIAL_LIST = 38
MAVLINK_MSG_ID_MISSION_ITEM = 39
MAVLINK_MSG_ID_MISSION_REQUEST = 40
MAVLINK_MSG_ID_MISSION_SET_CURRENT = 41
MAVLINK_MSG_ID_MISSION_CURRENT = 42
MAVLINK_MSG_ID_MISSION_REQUEST_LIST = 43
MAVLINK_MSG_ID_MISSION_COUNT = 44
MAVLINK_MSG_ID_MISSION_CLEAR_ALL = 45
MAVLINK_MSG_ID_MISSION_ITEM_REACHED = 46
MAVLINK_MSG_ID_MISSION_ACK = 47
MAVLINK_MSG_ID_SET_GPS_GLOBAL_ORIGIN = 48
MAVLINK_MSG_ID_GPS_GLOBAL_ORIGIN = 49
MAVLINK_MSG_ID_PARAM_MAP_RC = 50
MAVLINK_MSG_ID_MISSION_REQUEST_INT = 51
MAVLINK_MSG_ID_SAFETY_SET_ALLOWED_AREA = 54
MAVLINK_MSG_ID_SAFETY_ALLOWED_AREA = 55
MAVLINK_MSG_ID_ATTITUDE_QUATERNION_COV = 61
MAVLINK_MSG_ID_NAV_CONTROLLER_OUTPUT = 62
MAVLINK_MSG_ID_GLOBAL_POSITION_INT_COV = 63
MAVLINK_MSG_ID_LOCAL_POSITION_NED_COV = 64
MAVLINK_MSG_ID_RC_CHANNELS = 65
MAVLINK_MSG_ID_REQUEST_DATA_STREAM = 66
MAVLINK_MSG_ID_DATA_STREAM = 67
MAVLINK_MSG_ID_MANUAL_CONTROL = 69
MAVLINK_MSG_ID_RC_CHANNELS_OVERRIDE = 70
MAVLINK_MSG_ID_MISSION_ITEM_INT = 73
MAVLINK_MSG_ID_VFR_HUD = 74
MAVLINK_MSG_ID_COMMAND_INT = 75
MAVLINK_MSG_ID_COMMAND_LONG = 76
MAVLINK_MSG_ID_COMMAND_ACK = 77
MAVLINK_MSG_ID_MANUAL_SETPOINT = 81
MAVLINK_MSG_ID_SET_ATTITUDE_TARGET = 82
MAVLINK_MSG_ID_ATTITUDE_TARGET = 83
MAVLINK_MSG_ID_SET_POSITION_TARGET_LOCAL_NED = 84
MAVLINK_MSG_ID_POSITION_TARGET_LOCAL_NED = 85
MAVLINK_MSG_ID_SET_POSITION_TARGET_GLOBAL_INT = 86
MAVLINK_MSG_ID_POSITION_TARGET_GLOBAL_INT = 87
MAVLINK_MSG_ID_LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET = 89
MAVLINK_MSG_ID_HIL_STATE = 90
MAVLINK_MSG_ID_HIL_CONTROLS = 91
MAVLINK_MSG_ID_HIL_RC_INPUTS_RAW = 92
MAVLINK_MSG_ID_HIL_ACTUATOR_CONTROLS = 93
MAVLINK_MSG_ID_OPTICAL_FLOW = 100
MAVLINK_MSG_ID_GLOBAL_VISION_POSITION_ESTIMATE = 101
MAVLINK_MSG_ID_VISION_POSITION_ESTIMATE = 102
MAVLINK_MSG_ID_VISION_SPEED_ESTIMATE = 103
MAVLINK_MSG_ID_VICON_POSITION_ESTIMATE = 104
MAVLINK_MSG_ID_HIGHRES_IMU = 105
MAVLINK_MSG_ID_OPTICAL_FLOW_RAD = 106
MAVLINK_MSG_ID_HIL_SENSOR = 107
MAVLINK_MSG_ID_SIM_STATE = 108
MAVLINK_MSG_ID_RADIO_STATUS = 109
MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL = 110
MAVLINK_MSG_ID_TIMESYNC = 111
MAVLINK_MSG_ID_CAMERA_TRIGGER = 112
MAVLINK_MSG_ID_HIL_GPS = 113
MAVLINK_MSG_ID_HIL_OPTICAL_FLOW = 114
MAVLINK_MSG_ID_HIL_STATE_QUATERNION = 115
MAVLINK_MSG_ID_SCALED_IMU2 = 116
MAVLINK_MSG_ID_LOG_REQUEST_LIST = 117
MAVLINK_MSG_ID_LOG_ENTRY = 118
MAVLINK_MSG_ID_LOG_REQUEST_DATA = 119
MAVLINK_MSG_ID_LOG_DATA = 120
MAVLINK_MSG_ID_LOG_ERASE = 121
MAVLINK_MSG_ID_LOG_REQUEST_END = 122
MAVLINK_MSG_ID_GPS_INJECT_DATA = 123
MAVLINK_MSG_ID_GPS2_RAW = 124
MAVLINK_MSG_ID_POWER_STATUS = 125
MAVLINK_MSG_ID_SERIAL_CONTROL = 126
MAVLINK_MSG_ID_GPS_RTK = 127
MAVLINK_MSG_ID_GPS2_RTK = 128
MAVLINK_MSG_ID_SCALED_IMU3 = 129
MAVLINK_MSG_ID_DATA_TRANSMISSION_HANDSHAKE = 130
MAVLINK_MSG_ID_ENCAPSULATED_DATA = 131
MAVLINK_MSG_ID_DISTANCE_SENSOR = 132
MAVLINK_MSG_ID_TERRAIN_REQUEST = 133
MAVLINK_MSG_ID_TERRAIN_DATA = 134
MAVLINK_MSG_ID_TERRAIN_CHECK = 135
MAVLINK_MSG_ID_TERRAIN_REPORT = 136
MAVLINK_MSG_ID_SCALED_PRESSURE2 = 137
MAVLINK_MSG_ID_ATT_POS_MOCAP = 138
MAVLINK_MSG_ID_SET_ACTUATOR_CONTROL_TARGET = 139
MAVLINK_MSG_ID_ACTUATOR_CONTROL_TARGET = 140
MAVLINK_MSG_ID_ALTITUDE = 141
MAVLINK_MSG_ID_RESOURCE_REQUEST = 142
MAVLINK_MSG_ID_SCALED_PRESSURE3 = 143
MAVLINK_MSG_ID_FOLLOW_TARGET = 144
MAVLINK_MSG_ID_CONTROL_SYSTEM_STATE = 146
MAVLINK_MSG_ID_BATTERY_STATUS = 147
MAVLINK_MSG_ID_AUTOPILOT_VERSION = 148
MAVLINK_MSG_ID_LANDING_TARGET = 149
MAVLINK_MSG_ID_FENCE_STATUS = 162
MAVLINK_MSG_ID_MAG_CAL_REPORT = 192
MAVLINK_MSG_ID_EFI_STATUS = 225
MAVLINK_MSG_ID_ESTIMATOR_STATUS = 230
MAVLINK_MSG_ID_WIND_COV = 231
MAVLINK_MSG_ID_GPS_INPUT = 232
MAVLINK_MSG_ID_GPS_RTCM_DATA = 233
MAVLINK_MSG_ID_HIGH_LATENCY = 234
MAVLINK_MSG_ID_HIGH_LATENCY2 = 235
MAVLINK_MSG_ID_VIBRATION = 241
MAVLINK_MSG_ID_HOME_POSITION = 242
MAVLINK_MSG_ID_SET_HOME_POSITION = 243
MAVLINK_MSG_ID_MESSAGE_INTERVAL = 244
MAVLINK_MSG_ID_EXTENDED_SYS_STATE = 245
MAVLINK_MSG_ID_ADSB_VEHICLE = 246
MAVLINK_MSG_ID_COLLISION = 247
MAVLINK_MSG_ID_V2_EXTENSION = 248
MAVLINK_MSG_ID_MEMORY_VECT = 249
MAVLINK_MSG_ID_DEBUG_VECT = 250
MAVLINK_MSG_ID_NAMED_VALUE_FLOAT = 251
MAVLINK_MSG_ID_NAMED_VALUE_INT = 252
MAVLINK_MSG_ID_STATUSTEXT = 253
MAVLINK_MSG_ID_DEBUG = 254
MAVLINK_MSG_ID_HEARTBEAT = 0
MAVLINK_MSG_ID_NAV_FILTER_BIAS = 220
MAVLINK_MSG_ID_RADIO_CALIBRATION = 221
MAVLINK_MSG_ID_UALBERTA_SYS_STATUS = 222

class MAVLink_sensor_offsets_message(MAVLink_message):
        '''
        Offsets and calibrations values for hardware sensors. This
        makes it easier to debug the calibration process.
        '''
        id = MAVLINK_MSG_ID_SENSOR_OFFSETS
        name = 'SENSOR_OFFSETS'
        fieldnames = ['mag_ofs_x', 'mag_ofs_y', 'mag_ofs_z', 'mag_declination', 'raw_press', 'raw_temp', 'gyro_cal_x', 'gyro_cal_y', 'gyro_cal_z', 'accel_cal_x', 'accel_cal_y', 'accel_cal_z']
        ordered_fieldnames = ['mag_declination', 'raw_press', 'raw_temp', 'gyro_cal_x', 'gyro_cal_y', 'gyro_cal_z', 'accel_cal_x', 'accel_cal_y', 'accel_cal_z', 'mag_ofs_x', 'mag_ofs_y', 'mag_ofs_z']
        fieldtypes = ['int16_t', 'int16_t', 'int16_t', 'float', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"mag_declination": "rad"}
        format = '<fiiffffffhhh'
        native_format = bytearray('<fiiffffffhhh', 'ascii')
        orders = [9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 134
        unpacker = struct.Struct('<fiiffffffhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, mag_ofs_x, mag_ofs_y, mag_ofs_z, mag_declination, raw_press, raw_temp, gyro_cal_x, gyro_cal_y, gyro_cal_z, accel_cal_x, accel_cal_y, accel_cal_z):
                MAVLink_message.__init__(self, MAVLink_sensor_offsets_message.id, MAVLink_sensor_offsets_message.name)
                self._fieldnames = MAVLink_sensor_offsets_message.fieldnames
                self._instance_field = MAVLink_sensor_offsets_message.instance_field
                self._instance_offset = MAVLink_sensor_offsets_message.instance_offset
                self.mag_ofs_x = mag_ofs_x
                self.mag_ofs_y = mag_ofs_y
                self.mag_ofs_z = mag_ofs_z
                self.mag_declination = mag_declination
                self.raw_press = raw_press
                self.raw_temp = raw_temp
                self.gyro_cal_x = gyro_cal_x
                self.gyro_cal_y = gyro_cal_y
                self.gyro_cal_z = gyro_cal_z
                self.accel_cal_x = accel_cal_x
                self.accel_cal_y = accel_cal_y
                self.accel_cal_z = accel_cal_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 134, struct.pack('<fiiffffffhhh', self.mag_declination, self.raw_press, self.raw_temp, self.gyro_cal_x, self.gyro_cal_y, self.gyro_cal_z, self.accel_cal_x, self.accel_cal_y, self.accel_cal_z, self.mag_ofs_x, self.mag_ofs_y, self.mag_ofs_z), force_mavlink1=force_mavlink1)

class MAVLink_set_mag_offsets_message(MAVLink_message):
        '''
        Set the magnetometer offsets
        '''
        id = MAVLINK_MSG_ID_SET_MAG_OFFSETS
        name = 'SET_MAG_OFFSETS'
        fieldnames = ['target_system', 'target_component', 'mag_ofs_x', 'mag_ofs_y', 'mag_ofs_z']
        ordered_fieldnames = ['mag_ofs_x', 'mag_ofs_y', 'mag_ofs_z', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<hhhBB'
        native_format = bytearray('<hhhBB', 'ascii')
        orders = [3, 4, 0, 1, 2]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 219
        unpacker = struct.Struct('<hhhBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, mag_ofs_x, mag_ofs_y, mag_ofs_z):
                MAVLink_message.__init__(self, MAVLink_set_mag_offsets_message.id, MAVLink_set_mag_offsets_message.name)
                self._fieldnames = MAVLink_set_mag_offsets_message.fieldnames
                self._instance_field = MAVLink_set_mag_offsets_message.instance_field
                self._instance_offset = MAVLink_set_mag_offsets_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.mag_ofs_x = mag_ofs_x
                self.mag_ofs_y = mag_ofs_y
                self.mag_ofs_z = mag_ofs_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 219, struct.pack('<hhhBB', self.mag_ofs_x, self.mag_ofs_y, self.mag_ofs_z, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_meminfo_message(MAVLink_message):
        '''
        State of autopilot RAM.
        '''
        id = MAVLINK_MSG_ID_MEMINFO
        name = 'MEMINFO'
        fieldnames = ['brkval', 'freemem']
        ordered_fieldnames = ['brkval', 'freemem']
        fieldtypes = ['uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"freemem": "bytes"}
        format = '<HH'
        native_format = bytearray('<HH', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 208
        unpacker = struct.Struct('<HH')
        instance_field = None
        instance_offset = -1

        def __init__(self, brkval, freemem):
                MAVLink_message.__init__(self, MAVLink_meminfo_message.id, MAVLink_meminfo_message.name)
                self._fieldnames = MAVLink_meminfo_message.fieldnames
                self._instance_field = MAVLink_meminfo_message.instance_field
                self._instance_offset = MAVLink_meminfo_message.instance_offset
                self.brkval = brkval
                self.freemem = freemem

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 208, struct.pack('<HH', self.brkval, self.freemem), force_mavlink1=force_mavlink1)

class MAVLink_ap_adc_message(MAVLink_message):
        '''
        Raw ADC output.
        '''
        id = MAVLINK_MSG_ID_AP_ADC
        name = 'AP_ADC'
        fieldnames = ['adc1', 'adc2', 'adc3', 'adc4', 'adc5', 'adc6']
        ordered_fieldnames = ['adc1', 'adc2', 'adc3', 'adc4', 'adc5', 'adc6']
        fieldtypes = ['uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HHHHHH'
        native_format = bytearray('<HHHHHH', 'ascii')
        orders = [0, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 188
        unpacker = struct.Struct('<HHHHHH')
        instance_field = None
        instance_offset = -1

        def __init__(self, adc1, adc2, adc3, adc4, adc5, adc6):
                MAVLink_message.__init__(self, MAVLink_ap_adc_message.id, MAVLink_ap_adc_message.name)
                self._fieldnames = MAVLink_ap_adc_message.fieldnames
                self._instance_field = MAVLink_ap_adc_message.instance_field
                self._instance_offset = MAVLink_ap_adc_message.instance_offset
                self.adc1 = adc1
                self.adc2 = adc2
                self.adc3 = adc3
                self.adc4 = adc4
                self.adc5 = adc5
                self.adc6 = adc6

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 188, struct.pack('<HHHHHH', self.adc1, self.adc2, self.adc3, self.adc4, self.adc5, self.adc6), force_mavlink1=force_mavlink1)

class MAVLink_digicam_configure_message(MAVLink_message):
        '''
        Configure on-board Camera Control System.
        '''
        id = MAVLINK_MSG_ID_DIGICAM_CONFIGURE
        name = 'DIGICAM_CONFIGURE'
        fieldnames = ['target_system', 'target_component', 'mode', 'shutter_speed', 'aperture', 'iso', 'exposure_type', 'command_id', 'engine_cut_off', 'extra_param', 'extra_value']
        ordered_fieldnames = ['extra_value', 'shutter_speed', 'target_system', 'target_component', 'mode', 'aperture', 'iso', 'exposure_type', 'command_id', 'engine_cut_off', 'extra_param']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"engine_cut_off": "ds"}
        format = '<fHBBBBBBBBB'
        native_format = bytearray('<fHBBBBBBBBB', 'ascii')
        orders = [2, 3, 4, 1, 5, 6, 7, 8, 9, 10, 0]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 84
        unpacker = struct.Struct('<fHBBBBBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, mode, shutter_speed, aperture, iso, exposure_type, command_id, engine_cut_off, extra_param, extra_value):
                MAVLink_message.__init__(self, MAVLink_digicam_configure_message.id, MAVLink_digicam_configure_message.name)
                self._fieldnames = MAVLink_digicam_configure_message.fieldnames
                self._instance_field = MAVLink_digicam_configure_message.instance_field
                self._instance_offset = MAVLink_digicam_configure_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.mode = mode
                self.shutter_speed = shutter_speed
                self.aperture = aperture
                self.iso = iso
                self.exposure_type = exposure_type
                self.command_id = command_id
                self.engine_cut_off = engine_cut_off
                self.extra_param = extra_param
                self.extra_value = extra_value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 84, struct.pack('<fHBBBBBBBBB', self.extra_value, self.shutter_speed, self.target_system, self.target_component, self.mode, self.aperture, self.iso, self.exposure_type, self.command_id, self.engine_cut_off, self.extra_param), force_mavlink1=force_mavlink1)

class MAVLink_digicam_control_message(MAVLink_message):
        '''
        Control on-board Camera Control System to take shots.
        '''
        id = MAVLINK_MSG_ID_DIGICAM_CONTROL
        name = 'DIGICAM_CONTROL'
        fieldnames = ['target_system', 'target_component', 'session', 'zoom_pos', 'zoom_step', 'focus_lock', 'shot', 'command_id', 'extra_param', 'extra_value']
        ordered_fieldnames = ['extra_value', 'target_system', 'target_component', 'session', 'zoom_pos', 'zoom_step', 'focus_lock', 'shot', 'command_id', 'extra_param']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'int8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<fBBBBbBBBB'
        native_format = bytearray('<fBBBBbBBBB', 'ascii')
        orders = [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 22
        unpacker = struct.Struct('<fBBBBbBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, session, zoom_pos, zoom_step, focus_lock, shot, command_id, extra_param, extra_value):
                MAVLink_message.__init__(self, MAVLink_digicam_control_message.id, MAVLink_digicam_control_message.name)
                self._fieldnames = MAVLink_digicam_control_message.fieldnames
                self._instance_field = MAVLink_digicam_control_message.instance_field
                self._instance_offset = MAVLink_digicam_control_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.session = session
                self.zoom_pos = zoom_pos
                self.zoom_step = zoom_step
                self.focus_lock = focus_lock
                self.shot = shot
                self.command_id = command_id
                self.extra_param = extra_param
                self.extra_value = extra_value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 22, struct.pack('<fBBBBbBBBB', self.extra_value, self.target_system, self.target_component, self.session, self.zoom_pos, self.zoom_step, self.focus_lock, self.shot, self.command_id, self.extra_param), force_mavlink1=force_mavlink1)

class MAVLink_mount_configure_message(MAVLink_message):
        '''
        Message to configure a camera mount, directional antenna, etc.
        '''
        id = MAVLINK_MSG_ID_MOUNT_CONFIGURE
        name = 'MOUNT_CONFIGURE'
        fieldnames = ['target_system', 'target_component', 'mount_mode', 'stab_roll', 'stab_pitch', 'stab_yaw']
        ordered_fieldnames = ['target_system', 'target_component', 'mount_mode', 'stab_roll', 'stab_pitch', 'stab_yaw']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"mount_mode": "MAV_MOUNT_MODE"}
        fieldunits_by_name = {}
        format = '<BBBBBB'
        native_format = bytearray('<BBBBBB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 19
        unpacker = struct.Struct('<BBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, mount_mode, stab_roll, stab_pitch, stab_yaw):
                MAVLink_message.__init__(self, MAVLink_mount_configure_message.id, MAVLink_mount_configure_message.name)
                self._fieldnames = MAVLink_mount_configure_message.fieldnames
                self._instance_field = MAVLink_mount_configure_message.instance_field
                self._instance_offset = MAVLink_mount_configure_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.mount_mode = mount_mode
                self.stab_roll = stab_roll
                self.stab_pitch = stab_pitch
                self.stab_yaw = stab_yaw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 19, struct.pack('<BBBBBB', self.target_system, self.target_component, self.mount_mode, self.stab_roll, self.stab_pitch, self.stab_yaw), force_mavlink1=force_mavlink1)

class MAVLink_mount_control_message(MAVLink_message):
        '''
        Message to control a camera mount, directional antenna, etc.
        '''
        id = MAVLINK_MSG_ID_MOUNT_CONTROL
        name = 'MOUNT_CONTROL'
        fieldnames = ['target_system', 'target_component', 'input_a', 'input_b', 'input_c', 'save_position']
        ordered_fieldnames = ['input_a', 'input_b', 'input_c', 'target_system', 'target_component', 'save_position']
        fieldtypes = ['uint8_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<iiiBBB'
        native_format = bytearray('<iiiBBB', 'ascii')
        orders = [3, 4, 0, 1, 2, 5]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 21
        unpacker = struct.Struct('<iiiBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, input_a, input_b, input_c, save_position):
                MAVLink_message.__init__(self, MAVLink_mount_control_message.id, MAVLink_mount_control_message.name)
                self._fieldnames = MAVLink_mount_control_message.fieldnames
                self._instance_field = MAVLink_mount_control_message.instance_field
                self._instance_offset = MAVLink_mount_control_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.input_a = input_a
                self.input_b = input_b
                self.input_c = input_c
                self.save_position = save_position

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 21, struct.pack('<iiiBBB', self.input_a, self.input_b, self.input_c, self.target_system, self.target_component, self.save_position), force_mavlink1=force_mavlink1)

class MAVLink_mount_status_message(MAVLink_message):
        '''
        Message with some status from autopilot to GCS about camera or
        antenna mount.
        '''
        id = MAVLINK_MSG_ID_MOUNT_STATUS
        name = 'MOUNT_STATUS'
        fieldnames = ['target_system', 'target_component', 'pointing_a', 'pointing_b', 'pointing_c']
        ordered_fieldnames = ['pointing_a', 'pointing_b', 'pointing_c', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"pointing_a": "cdeg", "pointing_b": "cdeg", "pointing_c": "cdeg"}
        format = '<iiiBB'
        native_format = bytearray('<iiiBB', 'ascii')
        orders = [3, 4, 0, 1, 2]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 134
        unpacker = struct.Struct('<iiiBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, pointing_a, pointing_b, pointing_c):
                MAVLink_message.__init__(self, MAVLink_mount_status_message.id, MAVLink_mount_status_message.name)
                self._fieldnames = MAVLink_mount_status_message.fieldnames
                self._instance_field = MAVLink_mount_status_message.instance_field
                self._instance_offset = MAVLink_mount_status_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.pointing_a = pointing_a
                self.pointing_b = pointing_b
                self.pointing_c = pointing_c

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 134, struct.pack('<iiiBB', self.pointing_a, self.pointing_b, self.pointing_c, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_fence_point_message(MAVLink_message):
        '''
        A fence point. Used to set a point when from GCS -> MAV. Also
        used to return a point from MAV -> GCS.
        '''
        id = MAVLINK_MSG_ID_FENCE_POINT
        name = 'FENCE_POINT'
        fieldnames = ['target_system', 'target_component', 'idx', 'count', 'lat', 'lng']
        ordered_fieldnames = ['lat', 'lng', 'target_system', 'target_component', 'idx', 'count']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"lat": "deg", "lng": "deg"}
        format = '<ffBBBB'
        native_format = bytearray('<ffBBBB', 'ascii')
        orders = [2, 3, 4, 5, 0, 1]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 78
        unpacker = struct.Struct('<ffBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, idx, count, lat, lng):
                MAVLink_message.__init__(self, MAVLink_fence_point_message.id, MAVLink_fence_point_message.name)
                self._fieldnames = MAVLink_fence_point_message.fieldnames
                self._instance_field = MAVLink_fence_point_message.instance_field
                self._instance_offset = MAVLink_fence_point_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.idx = idx
                self.count = count
                self.lat = lat
                self.lng = lng

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 78, struct.pack('<ffBBBB', self.lat, self.lng, self.target_system, self.target_component, self.idx, self.count), force_mavlink1=force_mavlink1)

class MAVLink_fence_fetch_point_message(MAVLink_message):
        '''
        Request a current fence point from MAV.
        '''
        id = MAVLINK_MSG_ID_FENCE_FETCH_POINT
        name = 'FENCE_FETCH_POINT'
        fieldnames = ['target_system', 'target_component', 'idx']
        ordered_fieldnames = ['target_system', 'target_component', 'idx']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BBB'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 68
        unpacker = struct.Struct('<BBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, idx):
                MAVLink_message.__init__(self, MAVLink_fence_fetch_point_message.id, MAVLink_fence_fetch_point_message.name)
                self._fieldnames = MAVLink_fence_fetch_point_message.fieldnames
                self._instance_field = MAVLink_fence_fetch_point_message.instance_field
                self._instance_offset = MAVLink_fence_fetch_point_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.idx = idx

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 68, struct.pack('<BBB', self.target_system, self.target_component, self.idx), force_mavlink1=force_mavlink1)

class MAVLink_ahrs_message(MAVLink_message):
        '''
        Status of DCM attitude estimator.
        '''
        id = MAVLINK_MSG_ID_AHRS
        name = 'AHRS'
        fieldnames = ['omegaIx', 'omegaIy', 'omegaIz', 'accel_weight', 'renorm_val', 'error_rp', 'error_yaw']
        ordered_fieldnames = ['omegaIx', 'omegaIy', 'omegaIz', 'accel_weight', 'renorm_val', 'error_rp', 'error_yaw']
        fieldtypes = ['float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"omegaIx": "rad/s", "omegaIy": "rad/s", "omegaIz": "rad/s"}
        format = '<fffffff'
        native_format = bytearray('<fffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 127
        unpacker = struct.Struct('<fffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, omegaIx, omegaIy, omegaIz, accel_weight, renorm_val, error_rp, error_yaw):
                MAVLink_message.__init__(self, MAVLink_ahrs_message.id, MAVLink_ahrs_message.name)
                self._fieldnames = MAVLink_ahrs_message.fieldnames
                self._instance_field = MAVLink_ahrs_message.instance_field
                self._instance_offset = MAVLink_ahrs_message.instance_offset
                self.omegaIx = omegaIx
                self.omegaIy = omegaIy
                self.omegaIz = omegaIz
                self.accel_weight = accel_weight
                self.renorm_val = renorm_val
                self.error_rp = error_rp
                self.error_yaw = error_yaw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 127, struct.pack('<fffffff', self.omegaIx, self.omegaIy, self.omegaIz, self.accel_weight, self.renorm_val, self.error_rp, self.error_yaw), force_mavlink1=force_mavlink1)

class MAVLink_simstate_message(MAVLink_message):
        '''
        Status of simulation environment, if used.
        '''
        id = MAVLINK_MSG_ID_SIMSTATE
        name = 'SIMSTATE'
        fieldnames = ['roll', 'pitch', 'yaw', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'lat', 'lng']
        ordered_fieldnames = ['roll', 'pitch', 'yaw', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'lat', 'lng']
        fieldtypes = ['float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'int32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"roll": "rad", "pitch": "rad", "yaw": "rad", "xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s", "lat": "degE7", "lng": "degE7"}
        format = '<fffffffffii'
        native_format = bytearray('<fffffffffii', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 154
        unpacker = struct.Struct('<fffffffffii')
        instance_field = None
        instance_offset = -1

        def __init__(self, roll, pitch, yaw, xacc, yacc, zacc, xgyro, ygyro, zgyro, lat, lng):
                MAVLink_message.__init__(self, MAVLink_simstate_message.id, MAVLink_simstate_message.name)
                self._fieldnames = MAVLink_simstate_message.fieldnames
                self._instance_field = MAVLink_simstate_message.instance_field
                self._instance_offset = MAVLink_simstate_message.instance_offset
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.lat = lat
                self.lng = lng

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 154, struct.pack('<fffffffffii', self.roll, self.pitch, self.yaw, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.lat, self.lng), force_mavlink1=force_mavlink1)

class MAVLink_hwstatus_message(MAVLink_message):
        '''
        Status of key hardware.
        '''
        id = MAVLINK_MSG_ID_HWSTATUS
        name = 'HWSTATUS'
        fieldnames = ['Vcc', 'I2Cerr']
        ordered_fieldnames = ['Vcc', 'I2Cerr']
        fieldtypes = ['uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"Vcc": "mV"}
        format = '<HB'
        native_format = bytearray('<HB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 21
        unpacker = struct.Struct('<HB')
        instance_field = None
        instance_offset = -1

        def __init__(self, Vcc, I2Cerr):
                MAVLink_message.__init__(self, MAVLink_hwstatus_message.id, MAVLink_hwstatus_message.name)
                self._fieldnames = MAVLink_hwstatus_message.fieldnames
                self._instance_field = MAVLink_hwstatus_message.instance_field
                self._instance_offset = MAVLink_hwstatus_message.instance_offset
                self.Vcc = Vcc
                self.I2Cerr = I2Cerr

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 21, struct.pack('<HB', self.Vcc, self.I2Cerr), force_mavlink1=force_mavlink1)

class MAVLink_radio_message(MAVLink_message):
        '''
        Status generated by radio.
        '''
        id = MAVLINK_MSG_ID_RADIO
        name = 'RADIO'
        fieldnames = ['rssi', 'remrssi', 'txbuf', 'noise', 'remnoise', 'rxerrors', 'fixed']
        ordered_fieldnames = ['rxerrors', 'fixed', 'rssi', 'remrssi', 'txbuf', 'noise', 'remnoise']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"txbuf": "%"}
        format = '<HHBBBBB'
        native_format = bytearray('<HHBBBBB', 'ascii')
        orders = [2, 3, 4, 5, 6, 0, 1]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 21
        unpacker = struct.Struct('<HHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, rssi, remrssi, txbuf, noise, remnoise, rxerrors, fixed):
                MAVLink_message.__init__(self, MAVLink_radio_message.id, MAVLink_radio_message.name)
                self._fieldnames = MAVLink_radio_message.fieldnames
                self._instance_field = MAVLink_radio_message.instance_field
                self._instance_offset = MAVLink_radio_message.instance_offset
                self.rssi = rssi
                self.remrssi = remrssi
                self.txbuf = txbuf
                self.noise = noise
                self.remnoise = remnoise
                self.rxerrors = rxerrors
                self.fixed = fixed

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 21, struct.pack('<HHBBBBB', self.rxerrors, self.fixed, self.rssi, self.remrssi, self.txbuf, self.noise, self.remnoise), force_mavlink1=force_mavlink1)

class MAVLink_limits_status_message(MAVLink_message):
        '''
        Status of AP_Limits. Sent in extended status stream when
        AP_Limits is enabled.
        '''
        id = MAVLINK_MSG_ID_LIMITS_STATUS
        name = 'LIMITS_STATUS'
        fieldnames = ['limits_state', 'last_trigger', 'last_action', 'last_recovery', 'last_clear', 'breach_count', 'mods_enabled', 'mods_required', 'mods_triggered']
        ordered_fieldnames = ['last_trigger', 'last_action', 'last_recovery', 'last_clear', 'breach_count', 'limits_state', 'mods_enabled', 'mods_required', 'mods_triggered']
        fieldtypes = ['uint8_t', 'uint32_t', 'uint32_t', 'uint32_t', 'uint32_t', 'uint16_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {"mods_enabled": "bitmask", "mods_required": "bitmask", "mods_triggered": "bitmask"}
        fieldenums_by_name = {"limits_state": "LIMITS_STATE", "mods_enabled": "LIMIT_MODULE", "mods_required": "LIMIT_MODULE", "mods_triggered": "LIMIT_MODULE"}
        fieldunits_by_name = {"last_trigger": "ms", "last_action": "ms", "last_recovery": "ms", "last_clear": "ms"}
        format = '<IIIIHBBBB'
        native_format = bytearray('<IIIIHBBBB', 'ascii')
        orders = [5, 0, 1, 2, 3, 4, 6, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 144
        unpacker = struct.Struct('<IIIIHBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, limits_state, last_trigger, last_action, last_recovery, last_clear, breach_count, mods_enabled, mods_required, mods_triggered):
                MAVLink_message.__init__(self, MAVLink_limits_status_message.id, MAVLink_limits_status_message.name)
                self._fieldnames = MAVLink_limits_status_message.fieldnames
                self._instance_field = MAVLink_limits_status_message.instance_field
                self._instance_offset = MAVLink_limits_status_message.instance_offset
                self.limits_state = limits_state
                self.last_trigger = last_trigger
                self.last_action = last_action
                self.last_recovery = last_recovery
                self.last_clear = last_clear
                self.breach_count = breach_count
                self.mods_enabled = mods_enabled
                self.mods_required = mods_required
                self.mods_triggered = mods_triggered

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 144, struct.pack('<IIIIHBBBB', self.last_trigger, self.last_action, self.last_recovery, self.last_clear, self.breach_count, self.limits_state, self.mods_enabled, self.mods_required, self.mods_triggered), force_mavlink1=force_mavlink1)

class MAVLink_wind_message(MAVLink_message):
        '''
        Wind estimation.
        '''
        id = MAVLINK_MSG_ID_WIND
        name = 'WIND'
        fieldnames = ['direction', 'speed', 'speed_z']
        ordered_fieldnames = ['direction', 'speed', 'speed_z']
        fieldtypes = ['float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"direction": "deg", "speed": "m/s", "speed_z": "m/s"}
        format = '<fff'
        native_format = bytearray('<fff', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 1
        unpacker = struct.Struct('<fff')
        instance_field = None
        instance_offset = -1

        def __init__(self, direction, speed, speed_z):
                MAVLink_message.__init__(self, MAVLink_wind_message.id, MAVLink_wind_message.name)
                self._fieldnames = MAVLink_wind_message.fieldnames
                self._instance_field = MAVLink_wind_message.instance_field
                self._instance_offset = MAVLink_wind_message.instance_offset
                self.direction = direction
                self.speed = speed
                self.speed_z = speed_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 1, struct.pack('<fff', self.direction, self.speed, self.speed_z), force_mavlink1=force_mavlink1)

class MAVLink_data16_message(MAVLink_message):
        '''
        Data packet, size 16.
        '''
        id = MAVLINK_MSG_ID_DATA16
        name = 'DATA16'
        fieldnames = ['type', 'len', 'data']
        ordered_fieldnames = ['type', 'len', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"len": "bytes"}
        format = '<BB16B'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 16]
        array_lengths = [0, 0, 16]
        crc_extra = 234
        unpacker = struct.Struct('<BB16B')
        instance_field = None
        instance_offset = -1

        def __init__(self, type, len, data):
                MAVLink_message.__init__(self, MAVLink_data16_message.id, MAVLink_data16_message.name)
                self._fieldnames = MAVLink_data16_message.fieldnames
                self._instance_field = MAVLink_data16_message.instance_field
                self._instance_offset = MAVLink_data16_message.instance_offset
                self.type = type
                self.len = len
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 234, struct.pack('<BB16B', self.type, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15]), force_mavlink1=force_mavlink1)

class MAVLink_data32_message(MAVLink_message):
        '''
        Data packet, size 32.
        '''
        id = MAVLINK_MSG_ID_DATA32
        name = 'DATA32'
        fieldnames = ['type', 'len', 'data']
        ordered_fieldnames = ['type', 'len', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"len": "bytes"}
        format = '<BB32B'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 32]
        array_lengths = [0, 0, 32]
        crc_extra = 73
        unpacker = struct.Struct('<BB32B')
        instance_field = None
        instance_offset = -1

        def __init__(self, type, len, data):
                MAVLink_message.__init__(self, MAVLink_data32_message.id, MAVLink_data32_message.name)
                self._fieldnames = MAVLink_data32_message.fieldnames
                self._instance_field = MAVLink_data32_message.instance_field
                self._instance_offset = MAVLink_data32_message.instance_offset
                self.type = type
                self.len = len
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 73, struct.pack('<BB32B', self.type, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31]), force_mavlink1=force_mavlink1)

class MAVLink_data64_message(MAVLink_message):
        '''
        Data packet, size 64.
        '''
        id = MAVLINK_MSG_ID_DATA64
        name = 'DATA64'
        fieldnames = ['type', 'len', 'data']
        ordered_fieldnames = ['type', 'len', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"len": "bytes"}
        format = '<BB64B'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 64]
        array_lengths = [0, 0, 64]
        crc_extra = 181
        unpacker = struct.Struct('<BB64B')
        instance_field = None
        instance_offset = -1

        def __init__(self, type, len, data):
                MAVLink_message.__init__(self, MAVLink_data64_message.id, MAVLink_data64_message.name)
                self._fieldnames = MAVLink_data64_message.fieldnames
                self._instance_field = MAVLink_data64_message.instance_field
                self._instance_offset = MAVLink_data64_message.instance_offset
                self.type = type
                self.len = len
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 181, struct.pack('<BB64B', self.type, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63]), force_mavlink1=force_mavlink1)

class MAVLink_data96_message(MAVLink_message):
        '''
        Data packet, size 96.
        '''
        id = MAVLINK_MSG_ID_DATA96
        name = 'DATA96'
        fieldnames = ['type', 'len', 'data']
        ordered_fieldnames = ['type', 'len', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"len": "bytes"}
        format = '<BB96B'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 96]
        array_lengths = [0, 0, 96]
        crc_extra = 22
        unpacker = struct.Struct('<BB96B')
        instance_field = None
        instance_offset = -1

        def __init__(self, type, len, data):
                MAVLink_message.__init__(self, MAVLink_data96_message.id, MAVLink_data96_message.name)
                self._fieldnames = MAVLink_data96_message.fieldnames
                self._instance_field = MAVLink_data96_message.instance_field
                self._instance_offset = MAVLink_data96_message.instance_offset
                self.type = type
                self.len = len
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 22, struct.pack('<BB96B', self.type, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95]), force_mavlink1=force_mavlink1)

class MAVLink_rangefinder_message(MAVLink_message):
        '''
        Rangefinder reporting.
        '''
        id = MAVLINK_MSG_ID_RANGEFINDER
        name = 'RANGEFINDER'
        fieldnames = ['distance', 'voltage']
        ordered_fieldnames = ['distance', 'voltage']
        fieldtypes = ['float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"distance": "m", "voltage": "V"}
        format = '<ff'
        native_format = bytearray('<ff', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 83
        unpacker = struct.Struct('<ff')
        instance_field = None
        instance_offset = -1

        def __init__(self, distance, voltage):
                MAVLink_message.__init__(self, MAVLink_rangefinder_message.id, MAVLink_rangefinder_message.name)
                self._fieldnames = MAVLink_rangefinder_message.fieldnames
                self._instance_field = MAVLink_rangefinder_message.instance_field
                self._instance_offset = MAVLink_rangefinder_message.instance_offset
                self.distance = distance
                self.voltage = voltage

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 83, struct.pack('<ff', self.distance, self.voltage), force_mavlink1=force_mavlink1)

class MAVLink_airspeed_autocal_message(MAVLink_message):
        '''
        Airspeed auto-calibration.
        '''
        id = MAVLINK_MSG_ID_AIRSPEED_AUTOCAL
        name = 'AIRSPEED_AUTOCAL'
        fieldnames = ['vx', 'vy', 'vz', 'diff_pressure', 'EAS2TAS', 'ratio', 'state_x', 'state_y', 'state_z', 'Pax', 'Pby', 'Pcz']
        ordered_fieldnames = ['vx', 'vy', 'vz', 'diff_pressure', 'EAS2TAS', 'ratio', 'state_x', 'state_y', 'state_z', 'Pax', 'Pby', 'Pcz']
        fieldtypes = ['float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"vx": "m/s", "vy": "m/s", "vz": "m/s", "diff_pressure": "Pa"}
        format = '<ffffffffffff'
        native_format = bytearray('<ffffffffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 167
        unpacker = struct.Struct('<ffffffffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, vx, vy, vz, diff_pressure, EAS2TAS, ratio, state_x, state_y, state_z, Pax, Pby, Pcz):
                MAVLink_message.__init__(self, MAVLink_airspeed_autocal_message.id, MAVLink_airspeed_autocal_message.name)
                self._fieldnames = MAVLink_airspeed_autocal_message.fieldnames
                self._instance_field = MAVLink_airspeed_autocal_message.instance_field
                self._instance_offset = MAVLink_airspeed_autocal_message.instance_offset
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.diff_pressure = diff_pressure
                self.EAS2TAS = EAS2TAS
                self.ratio = ratio
                self.state_x = state_x
                self.state_y = state_y
                self.state_z = state_z
                self.Pax = Pax
                self.Pby = Pby
                self.Pcz = Pcz

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 167, struct.pack('<ffffffffffff', self.vx, self.vy, self.vz, self.diff_pressure, self.EAS2TAS, self.ratio, self.state_x, self.state_y, self.state_z, self.Pax, self.Pby, self.Pcz), force_mavlink1=force_mavlink1)

class MAVLink_rally_point_message(MAVLink_message):
        '''
        A rally point. Used to set a point when from GCS -> MAV. Also
        used to return a point from MAV -> GCS.
        '''
        id = MAVLINK_MSG_ID_RALLY_POINT
        name = 'RALLY_POINT'
        fieldnames = ['target_system', 'target_component', 'idx', 'count', 'lat', 'lng', 'alt', 'break_alt', 'land_dir', 'flags']
        ordered_fieldnames = ['lat', 'lng', 'alt', 'break_alt', 'land_dir', 'target_system', 'target_component', 'idx', 'count', 'flags']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'int32_t', 'int32_t', 'int16_t', 'int16_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {"flags": "bitmask"}
        fieldenums_by_name = {"flags": "RALLY_FLAGS"}
        fieldunits_by_name = {"lat": "degE7", "lng": "degE7", "alt": "m", "break_alt": "m", "land_dir": "cdeg"}
        format = '<iihhHBBBBB'
        native_format = bytearray('<iihhHBBBBB', 'ascii')
        orders = [5, 6, 7, 8, 0, 1, 2, 3, 4, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 138
        unpacker = struct.Struct('<iihhHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, idx, count, lat, lng, alt, break_alt, land_dir, flags):
                MAVLink_message.__init__(self, MAVLink_rally_point_message.id, MAVLink_rally_point_message.name)
                self._fieldnames = MAVLink_rally_point_message.fieldnames
                self._instance_field = MAVLink_rally_point_message.instance_field
                self._instance_offset = MAVLink_rally_point_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.idx = idx
                self.count = count
                self.lat = lat
                self.lng = lng
                self.alt = alt
                self.break_alt = break_alt
                self.land_dir = land_dir
                self.flags = flags

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 138, struct.pack('<iihhHBBBBB', self.lat, self.lng, self.alt, self.break_alt, self.land_dir, self.target_system, self.target_component, self.idx, self.count, self.flags), force_mavlink1=force_mavlink1)

class MAVLink_rally_fetch_point_message(MAVLink_message):
        '''
        Request a current rally point from MAV. MAV should respond
        with a RALLY_POINT message. MAV should not respond if the
        request is invalid.
        '''
        id = MAVLINK_MSG_ID_RALLY_FETCH_POINT
        name = 'RALLY_FETCH_POINT'
        fieldnames = ['target_system', 'target_component', 'idx']
        ordered_fieldnames = ['target_system', 'target_component', 'idx']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BBB'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 234
        unpacker = struct.Struct('<BBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, idx):
                MAVLink_message.__init__(self, MAVLink_rally_fetch_point_message.id, MAVLink_rally_fetch_point_message.name)
                self._fieldnames = MAVLink_rally_fetch_point_message.fieldnames
                self._instance_field = MAVLink_rally_fetch_point_message.instance_field
                self._instance_offset = MAVLink_rally_fetch_point_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.idx = idx

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 234, struct.pack('<BBB', self.target_system, self.target_component, self.idx), force_mavlink1=force_mavlink1)

class MAVLink_compassmot_status_message(MAVLink_message):
        '''
        Status of compassmot calibration.
        '''
        id = MAVLINK_MSG_ID_COMPASSMOT_STATUS
        name = 'COMPASSMOT_STATUS'
        fieldnames = ['throttle', 'current', 'interference', 'CompensationX', 'CompensationY', 'CompensationZ']
        ordered_fieldnames = ['current', 'CompensationX', 'CompensationY', 'CompensationZ', 'throttle', 'interference']
        fieldtypes = ['uint16_t', 'float', 'uint16_t', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"throttle": "d%", "current": "A", "interference": "%"}
        format = '<ffffHH'
        native_format = bytearray('<ffffHH', 'ascii')
        orders = [4, 0, 5, 1, 2, 3]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 240
        unpacker = struct.Struct('<ffffHH')
        instance_field = None
        instance_offset = -1

        def __init__(self, throttle, current, interference, CompensationX, CompensationY, CompensationZ):
                MAVLink_message.__init__(self, MAVLink_compassmot_status_message.id, MAVLink_compassmot_status_message.name)
                self._fieldnames = MAVLink_compassmot_status_message.fieldnames
                self._instance_field = MAVLink_compassmot_status_message.instance_field
                self._instance_offset = MAVLink_compassmot_status_message.instance_offset
                self.throttle = throttle
                self.current = current
                self.interference = interference
                self.CompensationX = CompensationX
                self.CompensationY = CompensationY
                self.CompensationZ = CompensationZ

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 240, struct.pack('<ffffHH', self.current, self.CompensationX, self.CompensationY, self.CompensationZ, self.throttle, self.interference), force_mavlink1=force_mavlink1)

class MAVLink_ahrs2_message(MAVLink_message):
        '''
        Status of secondary AHRS filter if available.
        '''
        id = MAVLINK_MSG_ID_AHRS2
        name = 'AHRS2'
        fieldnames = ['roll', 'pitch', 'yaw', 'altitude', 'lat', 'lng']
        ordered_fieldnames = ['roll', 'pitch', 'yaw', 'altitude', 'lat', 'lng']
        fieldtypes = ['float', 'float', 'float', 'float', 'int32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"roll": "rad", "pitch": "rad", "yaw": "rad", "altitude": "m", "lat": "degE7", "lng": "degE7"}
        format = '<ffffii'
        native_format = bytearray('<ffffii', 'ascii')
        orders = [0, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 47
        unpacker = struct.Struct('<ffffii')
        instance_field = None
        instance_offset = -1

        def __init__(self, roll, pitch, yaw, altitude, lat, lng):
                MAVLink_message.__init__(self, MAVLink_ahrs2_message.id, MAVLink_ahrs2_message.name)
                self._fieldnames = MAVLink_ahrs2_message.fieldnames
                self._instance_field = MAVLink_ahrs2_message.instance_field
                self._instance_offset = MAVLink_ahrs2_message.instance_offset
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.altitude = altitude
                self.lat = lat
                self.lng = lng

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 47, struct.pack('<ffffii', self.roll, self.pitch, self.yaw, self.altitude, self.lat, self.lng), force_mavlink1=force_mavlink1)

class MAVLink_camera_status_message(MAVLink_message):
        '''
        Camera Event.
        '''
        id = MAVLINK_MSG_ID_CAMERA_STATUS
        name = 'CAMERA_STATUS'
        fieldnames = ['time_usec', 'target_system', 'cam_idx', 'img_idx', 'event_id', 'p1', 'p2', 'p3', 'p4']
        ordered_fieldnames = ['time_usec', 'p1', 'p2', 'p3', 'p4', 'img_idx', 'target_system', 'cam_idx', 'event_id']
        fieldtypes = ['uint64_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint8_t', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"event_id": "CAMERA_STATUS_TYPES"}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<QffffHBBB'
        native_format = bytearray('<QffffHBBB', 'ascii')
        orders = [0, 6, 7, 5, 8, 1, 2, 3, 4]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 189
        unpacker = struct.Struct('<QffffHBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, target_system, cam_idx, img_idx, event_id, p1, p2, p3, p4):
                MAVLink_message.__init__(self, MAVLink_camera_status_message.id, MAVLink_camera_status_message.name)
                self._fieldnames = MAVLink_camera_status_message.fieldnames
                self._instance_field = MAVLink_camera_status_message.instance_field
                self._instance_offset = MAVLink_camera_status_message.instance_offset
                self.time_usec = time_usec
                self.target_system = target_system
                self.cam_idx = cam_idx
                self.img_idx = img_idx
                self.event_id = event_id
                self.p1 = p1
                self.p2 = p2
                self.p3 = p3
                self.p4 = p4

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 189, struct.pack('<QffffHBBB', self.time_usec, self.p1, self.p2, self.p3, self.p4, self.img_idx, self.target_system, self.cam_idx, self.event_id), force_mavlink1=force_mavlink1)

class MAVLink_camera_feedback_message(MAVLink_message):
        '''
        Camera Capture Feedback.
        '''
        id = MAVLINK_MSG_ID_CAMERA_FEEDBACK
        name = 'CAMERA_FEEDBACK'
        fieldnames = ['time_usec', 'target_system', 'cam_idx', 'img_idx', 'lat', 'lng', 'alt_msl', 'alt_rel', 'roll', 'pitch', 'yaw', 'foc_len', 'flags']
        ordered_fieldnames = ['time_usec', 'lat', 'lng', 'alt_msl', 'alt_rel', 'roll', 'pitch', 'yaw', 'foc_len', 'img_idx', 'target_system', 'cam_idx', 'flags']
        fieldtypes = ['uint64_t', 'uint8_t', 'uint8_t', 'uint16_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"flags": "CAMERA_FEEDBACK_FLAGS"}
        fieldunits_by_name = {"time_usec": "us", "lat": "degE7", "lng": "degE7", "alt_msl": "m", "alt_rel": "m", "roll": "deg", "pitch": "deg", "yaw": "deg", "foc_len": "mm"}
        format = '<QiiffffffHBBB'
        native_format = bytearray('<QiiffffffHBBB', 'ascii')
        orders = [0, 10, 11, 9, 1, 2, 3, 4, 5, 6, 7, 8, 12]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 52
        unpacker = struct.Struct('<QiiffffffHBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, target_system, cam_idx, img_idx, lat, lng, alt_msl, alt_rel, roll, pitch, yaw, foc_len, flags):
                MAVLink_message.__init__(self, MAVLink_camera_feedback_message.id, MAVLink_camera_feedback_message.name)
                self._fieldnames = MAVLink_camera_feedback_message.fieldnames
                self._instance_field = MAVLink_camera_feedback_message.instance_field
                self._instance_offset = MAVLink_camera_feedback_message.instance_offset
                self.time_usec = time_usec
                self.target_system = target_system
                self.cam_idx = cam_idx
                self.img_idx = img_idx
                self.lat = lat
                self.lng = lng
                self.alt_msl = alt_msl
                self.alt_rel = alt_rel
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.foc_len = foc_len
                self.flags = flags

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 52, struct.pack('<QiiffffffHBBB', self.time_usec, self.lat, self.lng, self.alt_msl, self.alt_rel, self.roll, self.pitch, self.yaw, self.foc_len, self.img_idx, self.target_system, self.cam_idx, self.flags), force_mavlink1=force_mavlink1)

class MAVLink_battery2_message(MAVLink_message):
        '''
        2nd Battery status
        '''
        id = MAVLINK_MSG_ID_BATTERY2
        name = 'BATTERY2'
        fieldnames = ['voltage', 'current_battery']
        ordered_fieldnames = ['voltage', 'current_battery']
        fieldtypes = ['uint16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"voltage": "mV", "current_battery": "cA"}
        format = '<Hh'
        native_format = bytearray('<Hh', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 174
        unpacker = struct.Struct('<Hh')
        instance_field = None
        instance_offset = -1

        def __init__(self, voltage, current_battery):
                MAVLink_message.__init__(self, MAVLink_battery2_message.id, MAVLink_battery2_message.name)
                self._fieldnames = MAVLink_battery2_message.fieldnames
                self._instance_field = MAVLink_battery2_message.instance_field
                self._instance_offset = MAVLink_battery2_message.instance_offset
                self.voltage = voltage
                self.current_battery = current_battery

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 174, struct.pack('<Hh', self.voltage, self.current_battery), force_mavlink1=force_mavlink1)

class MAVLink_ahrs3_message(MAVLink_message):
        '''
        Status of third AHRS filter if available. This is for ANU
        research group (Ali and Sean).
        '''
        id = MAVLINK_MSG_ID_AHRS3
        name = 'AHRS3'
        fieldnames = ['roll', 'pitch', 'yaw', 'altitude', 'lat', 'lng', 'v1', 'v2', 'v3', 'v4']
        ordered_fieldnames = ['roll', 'pitch', 'yaw', 'altitude', 'lat', 'lng', 'v1', 'v2', 'v3', 'v4']
        fieldtypes = ['float', 'float', 'float', 'float', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"roll": "rad", "pitch": "rad", "yaw": "rad", "altitude": "m", "lat": "degE7", "lng": "degE7"}
        format = '<ffffiiffff'
        native_format = bytearray('<ffffiiffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 229
        unpacker = struct.Struct('<ffffiiffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, roll, pitch, yaw, altitude, lat, lng, v1, v2, v3, v4):
                MAVLink_message.__init__(self, MAVLink_ahrs3_message.id, MAVLink_ahrs3_message.name)
                self._fieldnames = MAVLink_ahrs3_message.fieldnames
                self._instance_field = MAVLink_ahrs3_message.instance_field
                self._instance_offset = MAVLink_ahrs3_message.instance_offset
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.altitude = altitude
                self.lat = lat
                self.lng = lng
                self.v1 = v1
                self.v2 = v2
                self.v3 = v3
                self.v4 = v4

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 229, struct.pack('<ffffiiffff', self.roll, self.pitch, self.yaw, self.altitude, self.lat, self.lng, self.v1, self.v2, self.v3, self.v4), force_mavlink1=force_mavlink1)

class MAVLink_autopilot_version_request_message(MAVLink_message):
        '''
        Request the autopilot version from the system/component.
        '''
        id = MAVLINK_MSG_ID_AUTOPILOT_VERSION_REQUEST
        name = 'AUTOPILOT_VERSION_REQUEST'
        fieldnames = ['target_system', 'target_component']
        ordered_fieldnames = ['target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 85
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component):
                MAVLink_message.__init__(self, MAVLink_autopilot_version_request_message.id, MAVLink_autopilot_version_request_message.name)
                self._fieldnames = MAVLink_autopilot_version_request_message.fieldnames
                self._instance_field = MAVLink_autopilot_version_request_message.instance_field
                self._instance_offset = MAVLink_autopilot_version_request_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 85, struct.pack('<BB', self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_remote_log_data_block_message(MAVLink_message):
        '''
        Send a block of log data to remote location.
        '''
        id = MAVLINK_MSG_ID_REMOTE_LOG_DATA_BLOCK
        name = 'REMOTE_LOG_DATA_BLOCK'
        fieldnames = ['target_system', 'target_component', 'seqno', 'data']
        ordered_fieldnames = ['seqno', 'target_system', 'target_component', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint32_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"seqno": "MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS"}
        fieldunits_by_name = {}
        format = '<IBB200B'
        native_format = bytearray('<IBBB', 'ascii')
        orders = [1, 2, 0, 3]
        lengths = [1, 1, 1, 200]
        array_lengths = [0, 0, 0, 200]
        crc_extra = 159
        unpacker = struct.Struct('<IBB200B')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, seqno, data):
                MAVLink_message.__init__(self, MAVLink_remote_log_data_block_message.id, MAVLink_remote_log_data_block_message.name)
                self._fieldnames = MAVLink_remote_log_data_block_message.fieldnames
                self._instance_field = MAVLink_remote_log_data_block_message.instance_field
                self._instance_offset = MAVLink_remote_log_data_block_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.seqno = seqno
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 159, struct.pack('<IBB200B', self.seqno, self.target_system, self.target_component, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109], self.data[110], self.data[111], self.data[112], self.data[113], self.data[114], self.data[115], self.data[116], self.data[117], self.data[118], self.data[119], self.data[120], self.data[121], self.data[122], self.data[123], self.data[124], self.data[125], self.data[126], self.data[127], self.data[128], self.data[129], self.data[130], self.data[131], self.data[132], self.data[133], self.data[134], self.data[135], self.data[136], self.data[137], self.data[138], self.data[139], self.data[140], self.data[141], self.data[142], self.data[143], self.data[144], self.data[145], self.data[146], self.data[147], self.data[148], self.data[149], self.data[150], self.data[151], self.data[152], self.data[153], self.data[154], self.data[155], self.data[156], self.data[157], self.data[158], self.data[159], self.data[160], self.data[161], self.data[162], self.data[163], self.data[164], self.data[165], self.data[166], self.data[167], self.data[168], self.data[169], self.data[170], self.data[171], self.data[172], self.data[173], self.data[174], self.data[175], self.data[176], self.data[177], self.data[178], self.data[179], self.data[180], self.data[181], self.data[182], self.data[183], self.data[184], self.data[185], self.data[186], self.data[187], self.data[188], self.data[189], self.data[190], self.data[191], self.data[192], self.data[193], self.data[194], self.data[195], self.data[196], self.data[197], self.data[198], self.data[199]), force_mavlink1=force_mavlink1)

class MAVLink_remote_log_block_status_message(MAVLink_message):
        '''
        Send Status of each log block that autopilot board might have
        sent.
        '''
        id = MAVLINK_MSG_ID_REMOTE_LOG_BLOCK_STATUS
        name = 'REMOTE_LOG_BLOCK_STATUS'
        fieldnames = ['target_system', 'target_component', 'seqno', 'status']
        ordered_fieldnames = ['seqno', 'target_system', 'target_component', 'status']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint32_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"status": "MAV_REMOTE_LOG_DATA_BLOCK_STATUSES"}
        fieldunits_by_name = {}
        format = '<IBBB'
        native_format = bytearray('<IBBB', 'ascii')
        orders = [1, 2, 0, 3]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 186
        unpacker = struct.Struct('<IBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, seqno, status):
                MAVLink_message.__init__(self, MAVLink_remote_log_block_status_message.id, MAVLink_remote_log_block_status_message.name)
                self._fieldnames = MAVLink_remote_log_block_status_message.fieldnames
                self._instance_field = MAVLink_remote_log_block_status_message.instance_field
                self._instance_offset = MAVLink_remote_log_block_status_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.seqno = seqno
                self.status = status

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 186, struct.pack('<IBBB', self.seqno, self.target_system, self.target_component, self.status), force_mavlink1=force_mavlink1)

class MAVLink_led_control_message(MAVLink_message):
        '''
        Control vehicle LEDs.
        '''
        id = MAVLINK_MSG_ID_LED_CONTROL
        name = 'LED_CONTROL'
        fieldnames = ['target_system', 'target_component', 'instance', 'pattern', 'custom_len', 'custom_bytes']
        ordered_fieldnames = ['target_system', 'target_component', 'instance', 'pattern', 'custom_len', 'custom_bytes']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BBBBB24B'
        native_format = bytearray('<BBBBBB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 24]
        array_lengths = [0, 0, 0, 0, 0, 24]
        crc_extra = 72
        unpacker = struct.Struct('<BBBBB24B')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, instance, pattern, custom_len, custom_bytes):
                MAVLink_message.__init__(self, MAVLink_led_control_message.id, MAVLink_led_control_message.name)
                self._fieldnames = MAVLink_led_control_message.fieldnames
                self._instance_field = MAVLink_led_control_message.instance_field
                self._instance_offset = MAVLink_led_control_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.instance = instance
                self.pattern = pattern
                self.custom_len = custom_len
                self.custom_bytes = custom_bytes

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 72, struct.pack('<BBBBB24B', self.target_system, self.target_component, self.instance, self.pattern, self.custom_len, self.custom_bytes[0], self.custom_bytes[1], self.custom_bytes[2], self.custom_bytes[3], self.custom_bytes[4], self.custom_bytes[5], self.custom_bytes[6], self.custom_bytes[7], self.custom_bytes[8], self.custom_bytes[9], self.custom_bytes[10], self.custom_bytes[11], self.custom_bytes[12], self.custom_bytes[13], self.custom_bytes[14], self.custom_bytes[15], self.custom_bytes[16], self.custom_bytes[17], self.custom_bytes[18], self.custom_bytes[19], self.custom_bytes[20], self.custom_bytes[21], self.custom_bytes[22], self.custom_bytes[23]), force_mavlink1=force_mavlink1)

class MAVLink_mag_cal_progress_message(MAVLink_message):
        '''
        Reports progress of compass calibration.
        '''
        id = MAVLINK_MSG_ID_MAG_CAL_PROGRESS
        name = 'MAG_CAL_PROGRESS'
        fieldnames = ['compass_id', 'cal_mask', 'cal_status', 'attempt', 'completion_pct', 'completion_mask', 'direction_x', 'direction_y', 'direction_z']
        ordered_fieldnames = ['direction_x', 'direction_y', 'direction_z', 'compass_id', 'cal_mask', 'cal_status', 'attempt', 'completion_pct', 'completion_mask']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float']
        fielddisplays_by_name = {"cal_mask": "bitmask"}
        fieldenums_by_name = {"cal_status": "MAG_CAL_STATUS"}
        fieldunits_by_name = {"completion_pct": "%"}
        format = '<fffBBBBB10B'
        native_format = bytearray('<fffBBBBBB', 'ascii')
        orders = [3, 4, 5, 6, 7, 8, 0, 1, 2]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 10]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 10]
        crc_extra = 92
        unpacker = struct.Struct('<fffBBBBB10B')
        instance_field = 'compass_id'
        instance_offset = 12

        def __init__(self, compass_id, cal_mask, cal_status, attempt, completion_pct, completion_mask, direction_x, direction_y, direction_z):
                MAVLink_message.__init__(self, MAVLink_mag_cal_progress_message.id, MAVLink_mag_cal_progress_message.name)
                self._fieldnames = MAVLink_mag_cal_progress_message.fieldnames
                self._instance_field = MAVLink_mag_cal_progress_message.instance_field
                self._instance_offset = MAVLink_mag_cal_progress_message.instance_offset
                self.compass_id = compass_id
                self.cal_mask = cal_mask
                self.cal_status = cal_status
                self.attempt = attempt
                self.completion_pct = completion_pct
                self.completion_mask = completion_mask
                self.direction_x = direction_x
                self.direction_y = direction_y
                self.direction_z = direction_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 92, struct.pack('<fffBBBBB10B', self.direction_x, self.direction_y, self.direction_z, self.compass_id, self.cal_mask, self.cal_status, self.attempt, self.completion_pct, self.completion_mask[0], self.completion_mask[1], self.completion_mask[2], self.completion_mask[3], self.completion_mask[4], self.completion_mask[5], self.completion_mask[6], self.completion_mask[7], self.completion_mask[8], self.completion_mask[9]), force_mavlink1=force_mavlink1)

class MAVLink_ekf_status_report_message(MAVLink_message):
        '''
        EKF Status message including flags and variances.
        '''
        id = MAVLINK_MSG_ID_EKF_STATUS_REPORT
        name = 'EKF_STATUS_REPORT'
        fieldnames = ['flags', 'velocity_variance', 'pos_horiz_variance', 'pos_vert_variance', 'compass_variance', 'terrain_alt_variance']
        ordered_fieldnames = ['velocity_variance', 'pos_horiz_variance', 'pos_vert_variance', 'compass_variance', 'terrain_alt_variance', 'flags']
        fieldtypes = ['uint16_t', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"flags": "bitmask"}
        fieldenums_by_name = {"flags": "EKF_STATUS_FLAGS"}
        fieldunits_by_name = {}
        format = '<fffffH'
        native_format = bytearray('<fffffH', 'ascii')
        orders = [5, 0, 1, 2, 3, 4]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 71
        unpacker = struct.Struct('<fffffH')
        instance_field = None
        instance_offset = -1

        def __init__(self, flags, velocity_variance, pos_horiz_variance, pos_vert_variance, compass_variance, terrain_alt_variance):
                MAVLink_message.__init__(self, MAVLink_ekf_status_report_message.id, MAVLink_ekf_status_report_message.name)
                self._fieldnames = MAVLink_ekf_status_report_message.fieldnames
                self._instance_field = MAVLink_ekf_status_report_message.instance_field
                self._instance_offset = MAVLink_ekf_status_report_message.instance_offset
                self.flags = flags
                self.velocity_variance = velocity_variance
                self.pos_horiz_variance = pos_horiz_variance
                self.pos_vert_variance = pos_vert_variance
                self.compass_variance = compass_variance
                self.terrain_alt_variance = terrain_alt_variance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 71, struct.pack('<fffffH', self.velocity_variance, self.pos_horiz_variance, self.pos_vert_variance, self.compass_variance, self.terrain_alt_variance, self.flags), force_mavlink1=force_mavlink1)

class MAVLink_pid_tuning_message(MAVLink_message):
        '''
        PID tuning information.
        '''
        id = MAVLINK_MSG_ID_PID_TUNING
        name = 'PID_TUNING'
        fieldnames = ['axis', 'desired', 'achieved', 'FF', 'P', 'I', 'D']
        ordered_fieldnames = ['desired', 'achieved', 'FF', 'P', 'I', 'D', 'axis']
        fieldtypes = ['uint8_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"axis": "PID_TUNING_AXIS"}
        fieldunits_by_name = {}
        format = '<ffffffB'
        native_format = bytearray('<ffffffB', 'ascii')
        orders = [6, 0, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 98
        unpacker = struct.Struct('<ffffffB')
        instance_field = 'axis'
        instance_offset = 24

        def __init__(self, axis, desired, achieved, FF, P, I, D):
                MAVLink_message.__init__(self, MAVLink_pid_tuning_message.id, MAVLink_pid_tuning_message.name)
                self._fieldnames = MAVLink_pid_tuning_message.fieldnames
                self._instance_field = MAVLink_pid_tuning_message.instance_field
                self._instance_offset = MAVLink_pid_tuning_message.instance_offset
                self.axis = axis
                self.desired = desired
                self.achieved = achieved
                self.FF = FF
                self.P = P
                self.I = I
                self.D = D

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 98, struct.pack('<ffffffB', self.desired, self.achieved, self.FF, self.P, self.I, self.D, self.axis), force_mavlink1=force_mavlink1)

class MAVLink_deepstall_message(MAVLink_message):
        '''
        Deepstall path planning.
        '''
        id = MAVLINK_MSG_ID_DEEPSTALL
        name = 'DEEPSTALL'
        fieldnames = ['landing_lat', 'landing_lon', 'path_lat', 'path_lon', 'arc_entry_lat', 'arc_entry_lon', 'altitude', 'expected_travel_distance', 'cross_track_error', 'stage']
        ordered_fieldnames = ['landing_lat', 'landing_lon', 'path_lat', 'path_lon', 'arc_entry_lat', 'arc_entry_lon', 'altitude', 'expected_travel_distance', 'cross_track_error', 'stage']
        fieldtypes = ['int32_t', 'int32_t', 'int32_t', 'int32_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"stage": "DEEPSTALL_STAGE"}
        fieldunits_by_name = {"landing_lat": "degE7", "landing_lon": "degE7", "path_lat": "degE7", "path_lon": "degE7", "arc_entry_lat": "degE7", "arc_entry_lon": "degE7", "altitude": "m", "expected_travel_distance": "m", "cross_track_error": "m"}
        format = '<iiiiiifffB'
        native_format = bytearray('<iiiiiifffB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 120
        unpacker = struct.Struct('<iiiiiifffB')
        instance_field = None
        instance_offset = -1

        def __init__(self, landing_lat, landing_lon, path_lat, path_lon, arc_entry_lat, arc_entry_lon, altitude, expected_travel_distance, cross_track_error, stage):
                MAVLink_message.__init__(self, MAVLink_deepstall_message.id, MAVLink_deepstall_message.name)
                self._fieldnames = MAVLink_deepstall_message.fieldnames
                self._instance_field = MAVLink_deepstall_message.instance_field
                self._instance_offset = MAVLink_deepstall_message.instance_offset
                self.landing_lat = landing_lat
                self.landing_lon = landing_lon
                self.path_lat = path_lat
                self.path_lon = path_lon
                self.arc_entry_lat = arc_entry_lat
                self.arc_entry_lon = arc_entry_lon
                self.altitude = altitude
                self.expected_travel_distance = expected_travel_distance
                self.cross_track_error = cross_track_error
                self.stage = stage

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 120, struct.pack('<iiiiiifffB', self.landing_lat, self.landing_lon, self.path_lat, self.path_lon, self.arc_entry_lat, self.arc_entry_lon, self.altitude, self.expected_travel_distance, self.cross_track_error, self.stage), force_mavlink1=force_mavlink1)

class MAVLink_gimbal_report_message(MAVLink_message):
        '''
        3 axis gimbal measurements.
        '''
        id = MAVLINK_MSG_ID_GIMBAL_REPORT
        name = 'GIMBAL_REPORT'
        fieldnames = ['target_system', 'target_component', 'delta_time', 'delta_angle_x', 'delta_angle_y', 'delta_angle_z', 'delta_velocity_x', 'delta_velocity_y', 'delta_velocity_z', 'joint_roll', 'joint_el', 'joint_az']
        ordered_fieldnames = ['delta_time', 'delta_angle_x', 'delta_angle_y', 'delta_angle_z', 'delta_velocity_x', 'delta_velocity_y', 'delta_velocity_z', 'joint_roll', 'joint_el', 'joint_az', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"delta_time": "s", "delta_angle_x": "rad", "delta_angle_y": "rad", "delta_angle_z": "rad", "delta_velocity_x": "m/s", "delta_velocity_y": "m/s", "delta_velocity_z": "m/s", "joint_roll": "rad", "joint_el": "rad", "joint_az": "rad"}
        format = '<ffffffffffBB'
        native_format = bytearray('<ffffffffffBB', 'ascii')
        orders = [10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 134
        unpacker = struct.Struct('<ffffffffffBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, delta_time, delta_angle_x, delta_angle_y, delta_angle_z, delta_velocity_x, delta_velocity_y, delta_velocity_z, joint_roll, joint_el, joint_az):
                MAVLink_message.__init__(self, MAVLink_gimbal_report_message.id, MAVLink_gimbal_report_message.name)
                self._fieldnames = MAVLink_gimbal_report_message.fieldnames
                self._instance_field = MAVLink_gimbal_report_message.instance_field
                self._instance_offset = MAVLink_gimbal_report_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.delta_time = delta_time
                self.delta_angle_x = delta_angle_x
                self.delta_angle_y = delta_angle_y
                self.delta_angle_z = delta_angle_z
                self.delta_velocity_x = delta_velocity_x
                self.delta_velocity_y = delta_velocity_y
                self.delta_velocity_z = delta_velocity_z
                self.joint_roll = joint_roll
                self.joint_el = joint_el
                self.joint_az = joint_az

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 134, struct.pack('<ffffffffffBB', self.delta_time, self.delta_angle_x, self.delta_angle_y, self.delta_angle_z, self.delta_velocity_x, self.delta_velocity_y, self.delta_velocity_z, self.joint_roll, self.joint_el, self.joint_az, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_gimbal_control_message(MAVLink_message):
        '''
        Control message for rate gimbal.
        '''
        id = MAVLINK_MSG_ID_GIMBAL_CONTROL
        name = 'GIMBAL_CONTROL'
        fieldnames = ['target_system', 'target_component', 'demanded_rate_x', 'demanded_rate_y', 'demanded_rate_z']
        ordered_fieldnames = ['demanded_rate_x', 'demanded_rate_y', 'demanded_rate_z', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"demanded_rate_x": "rad/s", "demanded_rate_y": "rad/s", "demanded_rate_z": "rad/s"}
        format = '<fffBB'
        native_format = bytearray('<fffBB', 'ascii')
        orders = [3, 4, 0, 1, 2]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 205
        unpacker = struct.Struct('<fffBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, demanded_rate_x, demanded_rate_y, demanded_rate_z):
                MAVLink_message.__init__(self, MAVLink_gimbal_control_message.id, MAVLink_gimbal_control_message.name)
                self._fieldnames = MAVLink_gimbal_control_message.fieldnames
                self._instance_field = MAVLink_gimbal_control_message.instance_field
                self._instance_offset = MAVLink_gimbal_control_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.demanded_rate_x = demanded_rate_x
                self.demanded_rate_y = demanded_rate_y
                self.demanded_rate_z = demanded_rate_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 205, struct.pack('<fffBB', self.demanded_rate_x, self.demanded_rate_y, self.demanded_rate_z, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_gimbal_torque_cmd_report_message(MAVLink_message):
        '''
        100 Hz gimbal torque command telemetry.
        '''
        id = MAVLINK_MSG_ID_GIMBAL_TORQUE_CMD_REPORT
        name = 'GIMBAL_TORQUE_CMD_REPORT'
        fieldnames = ['target_system', 'target_component', 'rl_torque_cmd', 'el_torque_cmd', 'az_torque_cmd']
        ordered_fieldnames = ['rl_torque_cmd', 'el_torque_cmd', 'az_torque_cmd', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<hhhBB'
        native_format = bytearray('<hhhBB', 'ascii')
        orders = [3, 4, 0, 1, 2]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 69
        unpacker = struct.Struct('<hhhBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, rl_torque_cmd, el_torque_cmd, az_torque_cmd):
                MAVLink_message.__init__(self, MAVLink_gimbal_torque_cmd_report_message.id, MAVLink_gimbal_torque_cmd_report_message.name)
                self._fieldnames = MAVLink_gimbal_torque_cmd_report_message.fieldnames
                self._instance_field = MAVLink_gimbal_torque_cmd_report_message.instance_field
                self._instance_offset = MAVLink_gimbal_torque_cmd_report_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.rl_torque_cmd = rl_torque_cmd
                self.el_torque_cmd = el_torque_cmd
                self.az_torque_cmd = az_torque_cmd

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 69, struct.pack('<hhhBB', self.rl_torque_cmd, self.el_torque_cmd, self.az_torque_cmd, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_gopro_heartbeat_message(MAVLink_message):
        '''
        Heartbeat from a HeroBus attached GoPro.
        '''
        id = MAVLINK_MSG_ID_GOPRO_HEARTBEAT
        name = 'GOPRO_HEARTBEAT'
        fieldnames = ['status', 'capture_mode', 'flags']
        ordered_fieldnames = ['status', 'capture_mode', 'flags']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {"flags": "bitmask"}
        fieldenums_by_name = {"status": "GOPRO_HEARTBEAT_STATUS", "capture_mode": "GOPRO_CAPTURE_MODE", "flags": "GOPRO_HEARTBEAT_FLAGS"}
        fieldunits_by_name = {}
        format = '<BBB'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 101
        unpacker = struct.Struct('<BBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, status, capture_mode, flags):
                MAVLink_message.__init__(self, MAVLink_gopro_heartbeat_message.id, MAVLink_gopro_heartbeat_message.name)
                self._fieldnames = MAVLink_gopro_heartbeat_message.fieldnames
                self._instance_field = MAVLink_gopro_heartbeat_message.instance_field
                self._instance_offset = MAVLink_gopro_heartbeat_message.instance_offset
                self.status = status
                self.capture_mode = capture_mode
                self.flags = flags

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 101, struct.pack('<BBB', self.status, self.capture_mode, self.flags), force_mavlink1=force_mavlink1)

class MAVLink_gopro_get_request_message(MAVLink_message):
        '''
        Request a GOPRO_COMMAND response from the GoPro.
        '''
        id = MAVLINK_MSG_ID_GOPRO_GET_REQUEST
        name = 'GOPRO_GET_REQUEST'
        fieldnames = ['target_system', 'target_component', 'cmd_id']
        ordered_fieldnames = ['target_system', 'target_component', 'cmd_id']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"cmd_id": "GOPRO_COMMAND"}
        fieldunits_by_name = {}
        format = '<BBB'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 50
        unpacker = struct.Struct('<BBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, cmd_id):
                MAVLink_message.__init__(self, MAVLink_gopro_get_request_message.id, MAVLink_gopro_get_request_message.name)
                self._fieldnames = MAVLink_gopro_get_request_message.fieldnames
                self._instance_field = MAVLink_gopro_get_request_message.instance_field
                self._instance_offset = MAVLink_gopro_get_request_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.cmd_id = cmd_id

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 50, struct.pack('<BBB', self.target_system, self.target_component, self.cmd_id), force_mavlink1=force_mavlink1)

class MAVLink_gopro_get_response_message(MAVLink_message):
        '''
        Response from a GOPRO_COMMAND get request.
        '''
        id = MAVLINK_MSG_ID_GOPRO_GET_RESPONSE
        name = 'GOPRO_GET_RESPONSE'
        fieldnames = ['cmd_id', 'status', 'value']
        ordered_fieldnames = ['cmd_id', 'status', 'value']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"cmd_id": "GOPRO_COMMAND", "status": "GOPRO_REQUEST_STATUS"}
        fieldunits_by_name = {}
        format = '<BB4B'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 4]
        array_lengths = [0, 0, 4]
        crc_extra = 202
        unpacker = struct.Struct('<BB4B')
        instance_field = None
        instance_offset = -1

        def __init__(self, cmd_id, status, value):
                MAVLink_message.__init__(self, MAVLink_gopro_get_response_message.id, MAVLink_gopro_get_response_message.name)
                self._fieldnames = MAVLink_gopro_get_response_message.fieldnames
                self._instance_field = MAVLink_gopro_get_response_message.instance_field
                self._instance_offset = MAVLink_gopro_get_response_message.instance_offset
                self.cmd_id = cmd_id
                self.status = status
                self.value = value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 202, struct.pack('<BB4B', self.cmd_id, self.status, self.value[0], self.value[1], self.value[2], self.value[3]), force_mavlink1=force_mavlink1)

class MAVLink_gopro_set_request_message(MAVLink_message):
        '''
        Request to set a GOPRO_COMMAND with a desired.
        '''
        id = MAVLINK_MSG_ID_GOPRO_SET_REQUEST
        name = 'GOPRO_SET_REQUEST'
        fieldnames = ['target_system', 'target_component', 'cmd_id', 'value']
        ordered_fieldnames = ['target_system', 'target_component', 'cmd_id', 'value']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"cmd_id": "GOPRO_COMMAND"}
        fieldunits_by_name = {}
        format = '<BBB4B'
        native_format = bytearray('<BBBB', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 4]
        array_lengths = [0, 0, 0, 4]
        crc_extra = 17
        unpacker = struct.Struct('<BBB4B')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, cmd_id, value):
                MAVLink_message.__init__(self, MAVLink_gopro_set_request_message.id, MAVLink_gopro_set_request_message.name)
                self._fieldnames = MAVLink_gopro_set_request_message.fieldnames
                self._instance_field = MAVLink_gopro_set_request_message.instance_field
                self._instance_offset = MAVLink_gopro_set_request_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.cmd_id = cmd_id
                self.value = value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 17, struct.pack('<BBB4B', self.target_system, self.target_component, self.cmd_id, self.value[0], self.value[1], self.value[2], self.value[3]), force_mavlink1=force_mavlink1)

class MAVLink_gopro_set_response_message(MAVLink_message):
        '''
        Response from a GOPRO_COMMAND set request.
        '''
        id = MAVLINK_MSG_ID_GOPRO_SET_RESPONSE
        name = 'GOPRO_SET_RESPONSE'
        fieldnames = ['cmd_id', 'status']
        ordered_fieldnames = ['cmd_id', 'status']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"cmd_id": "GOPRO_COMMAND", "status": "GOPRO_REQUEST_STATUS"}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 162
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, cmd_id, status):
                MAVLink_message.__init__(self, MAVLink_gopro_set_response_message.id, MAVLink_gopro_set_response_message.name)
                self._fieldnames = MAVLink_gopro_set_response_message.fieldnames
                self._instance_field = MAVLink_gopro_set_response_message.instance_field
                self._instance_offset = MAVLink_gopro_set_response_message.instance_offset
                self.cmd_id = cmd_id
                self.status = status

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 162, struct.pack('<BB', self.cmd_id, self.status), force_mavlink1=force_mavlink1)

class MAVLink_rpm_message(MAVLink_message):
        '''
        RPM sensor output.
        '''
        id = MAVLINK_MSG_ID_RPM
        name = 'RPM'
        fieldnames = ['rpm1', 'rpm2']
        ordered_fieldnames = ['rpm1', 'rpm2']
        fieldtypes = ['float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<ff'
        native_format = bytearray('<ff', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 207
        unpacker = struct.Struct('<ff')
        instance_field = None
        instance_offset = -1

        def __init__(self, rpm1, rpm2):
                MAVLink_message.__init__(self, MAVLink_rpm_message.id, MAVLink_rpm_message.name)
                self._fieldnames = MAVLink_rpm_message.fieldnames
                self._instance_field = MAVLink_rpm_message.instance_field
                self._instance_offset = MAVLink_rpm_message.instance_offset
                self.rpm1 = rpm1
                self.rpm2 = rpm2

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 207, struct.pack('<ff', self.rpm1, self.rpm2), force_mavlink1=force_mavlink1)

class MAVLink_sys_status_message(MAVLink_message):
        '''
        The general system state. If the system is following the
        MAVLink standard, the system state is mainly defined by three
        orthogonal states/modes: The system mode, which is either
        LOCKED (motors shut down and locked), MANUAL (system under RC
        control), GUIDED (system with autonomous position control,
        position setpoint controlled manually) or AUTO (system guided
        by path/waypoint planner). The NAV_MODE defined the current
        flight state: LIFTOFF (often an open-loop maneuver), LANDING,
        WAYPOINTS or VECTOR. This represents the internal navigation
        state machine. The system status shows whether the system is
        currently active or not and if an emergency occurred. During
        the CRITICAL and EMERGENCY states the MAV is still considered
        to be active, but should start emergency procedures
        autonomously. After a failure occurred it should first move
        from active to critical to allow manual intervention and then
        move to emergency after a certain timeout.
        '''
        id = MAVLINK_MSG_ID_SYS_STATUS
        name = 'SYS_STATUS'
        fieldnames = ['onboard_control_sensors_present', 'onboard_control_sensors_enabled', 'onboard_control_sensors_health', 'load', 'voltage_battery', 'current_battery', 'battery_remaining', 'drop_rate_comm', 'errors_comm', 'errors_count1', 'errors_count2', 'errors_count3', 'errors_count4']
        ordered_fieldnames = ['onboard_control_sensors_present', 'onboard_control_sensors_enabled', 'onboard_control_sensors_health', 'load', 'voltage_battery', 'current_battery', 'drop_rate_comm', 'errors_comm', 'errors_count1', 'errors_count2', 'errors_count3', 'errors_count4', 'battery_remaining']
        fieldtypes = ['uint32_t', 'uint32_t', 'uint32_t', 'uint16_t', 'uint16_t', 'int16_t', 'int8_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {"onboard_control_sensors_present": "bitmask", "onboard_control_sensors_enabled": "bitmask", "onboard_control_sensors_health": "bitmask"}
        fieldenums_by_name = {"onboard_control_sensors_present": "MAV_SYS_STATUS_SENSOR", "onboard_control_sensors_enabled": "MAV_SYS_STATUS_SENSOR", "onboard_control_sensors_health": "MAV_SYS_STATUS_SENSOR"}
        fieldunits_by_name = {"load": "d%", "voltage_battery": "mV", "current_battery": "cA", "battery_remaining": "%", "drop_rate_comm": "c%"}
        format = '<IIIHHhHHHHHHb'
        native_format = bytearray('<IIIHHhHHHHHHb', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 12, 6, 7, 8, 9, 10, 11]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 124
        unpacker = struct.Struct('<IIIHHhHHHHHHb')
        instance_field = None
        instance_offset = -1

        def __init__(self, onboard_control_sensors_present, onboard_control_sensors_enabled, onboard_control_sensors_health, load, voltage_battery, current_battery, battery_remaining, drop_rate_comm, errors_comm, errors_count1, errors_count2, errors_count3, errors_count4):
                MAVLink_message.__init__(self, MAVLink_sys_status_message.id, MAVLink_sys_status_message.name)
                self._fieldnames = MAVLink_sys_status_message.fieldnames
                self._instance_field = MAVLink_sys_status_message.instance_field
                self._instance_offset = MAVLink_sys_status_message.instance_offset
                self.onboard_control_sensors_present = onboard_control_sensors_present
                self.onboard_control_sensors_enabled = onboard_control_sensors_enabled
                self.onboard_control_sensors_health = onboard_control_sensors_health
                self.load = load
                self.voltage_battery = voltage_battery
                self.current_battery = current_battery
                self.battery_remaining = battery_remaining
                self.drop_rate_comm = drop_rate_comm
                self.errors_comm = errors_comm
                self.errors_count1 = errors_count1
                self.errors_count2 = errors_count2
                self.errors_count3 = errors_count3
                self.errors_count4 = errors_count4

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 124, struct.pack('<IIIHHhHHHHHHb', self.onboard_control_sensors_present, self.onboard_control_sensors_enabled, self.onboard_control_sensors_health, self.load, self.voltage_battery, self.current_battery, self.drop_rate_comm, self.errors_comm, self.errors_count1, self.errors_count2, self.errors_count3, self.errors_count4, self.battery_remaining), force_mavlink1=force_mavlink1)

class MAVLink_system_time_message(MAVLink_message):
        '''
        The system time is the time of the master clock, typically the
        computer clock of the main onboard computer.
        '''
        id = MAVLINK_MSG_ID_SYSTEM_TIME
        name = 'SYSTEM_TIME'
        fieldnames = ['time_unix_usec', 'time_boot_ms']
        ordered_fieldnames = ['time_unix_usec', 'time_boot_ms']
        fieldtypes = ['uint64_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_unix_usec": "us", "time_boot_ms": "ms"}
        format = '<QI'
        native_format = bytearray('<QI', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 137
        unpacker = struct.Struct('<QI')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_unix_usec, time_boot_ms):
                MAVLink_message.__init__(self, MAVLink_system_time_message.id, MAVLink_system_time_message.name)
                self._fieldnames = MAVLink_system_time_message.fieldnames
                self._instance_field = MAVLink_system_time_message.instance_field
                self._instance_offset = MAVLink_system_time_message.instance_offset
                self.time_unix_usec = time_unix_usec
                self.time_boot_ms = time_boot_ms

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 137, struct.pack('<QI', self.time_unix_usec, self.time_boot_ms), force_mavlink1=force_mavlink1)

class MAVLink_ping_message(MAVLink_message):
        '''
        A ping message either requesting or responding to a ping. This
        allows to measure the system latencies, including serial port,
        radio modem and UDP connections. The ping microservice is
        documented at https://mavlink.io/en/services/ping.html
        '''
        id = MAVLINK_MSG_ID_PING
        name = 'PING'
        fieldnames = ['time_usec', 'seq', 'target_system', 'target_component']
        ordered_fieldnames = ['time_usec', 'seq', 'target_system', 'target_component']
        fieldtypes = ['uint64_t', 'uint32_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<QIBB'
        native_format = bytearray('<QIBB', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 237
        unpacker = struct.Struct('<QIBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, seq, target_system, target_component):
                MAVLink_message.__init__(self, MAVLink_ping_message.id, MAVLink_ping_message.name)
                self._fieldnames = MAVLink_ping_message.fieldnames
                self._instance_field = MAVLink_ping_message.instance_field
                self._instance_offset = MAVLink_ping_message.instance_offset
                self.time_usec = time_usec
                self.seq = seq
                self.target_system = target_system
                self.target_component = target_component

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 237, struct.pack('<QIBB', self.time_usec, self.seq, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_change_operator_control_message(MAVLink_message):
        '''
        Request to control this MAV
        '''
        id = MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL
        name = 'CHANGE_OPERATOR_CONTROL'
        fieldnames = ['target_system', 'control_request', 'version', 'passkey']
        ordered_fieldnames = ['target_system', 'control_request', 'version', 'passkey']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'char']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"version": "rad"}
        format = '<BBB25s'
        native_format = bytearray('<BBBc', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 25]
        crc_extra = 217
        unpacker = struct.Struct('<BBB25s')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, control_request, version, passkey):
                MAVLink_message.__init__(self, MAVLink_change_operator_control_message.id, MAVLink_change_operator_control_message.name)
                self._fieldnames = MAVLink_change_operator_control_message.fieldnames
                self._instance_field = MAVLink_change_operator_control_message.instance_field
                self._instance_offset = MAVLink_change_operator_control_message.instance_offset
                self.target_system = target_system
                self.control_request = control_request
                self.version = version
                self.passkey = passkey

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 217, struct.pack('<BBB25s', self.target_system, self.control_request, self.version, self.passkey), force_mavlink1=force_mavlink1)

class MAVLink_change_operator_control_ack_message(MAVLink_message):
        '''
        Accept / deny control of this MAV
        '''
        id = MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK
        name = 'CHANGE_OPERATOR_CONTROL_ACK'
        fieldnames = ['gcs_system_id', 'control_request', 'ack']
        ordered_fieldnames = ['gcs_system_id', 'control_request', 'ack']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BBB'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 104
        unpacker = struct.Struct('<BBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, gcs_system_id, control_request, ack):
                MAVLink_message.__init__(self, MAVLink_change_operator_control_ack_message.id, MAVLink_change_operator_control_ack_message.name)
                self._fieldnames = MAVLink_change_operator_control_ack_message.fieldnames
                self._instance_field = MAVLink_change_operator_control_ack_message.instance_field
                self._instance_offset = MAVLink_change_operator_control_ack_message.instance_offset
                self.gcs_system_id = gcs_system_id
                self.control_request = control_request
                self.ack = ack

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 104, struct.pack('<BBB', self.gcs_system_id, self.control_request, self.ack), force_mavlink1=force_mavlink1)

class MAVLink_auth_key_message(MAVLink_message):
        '''
        Emit an encrypted signature / key identifying this system.
        PLEASE NOTE: This protocol has been kept simple, so
        transmitting the key requires an encrypted channel for true
        safety.
        '''
        id = MAVLINK_MSG_ID_AUTH_KEY
        name = 'AUTH_KEY'
        fieldnames = ['key']
        ordered_fieldnames = ['key']
        fieldtypes = ['char']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<32s'
        native_format = bytearray('<c', 'ascii')
        orders = [0]
        lengths = [1]
        array_lengths = [32]
        crc_extra = 119
        unpacker = struct.Struct('<32s')
        instance_field = None
        instance_offset = -1

        def __init__(self, key):
                MAVLink_message.__init__(self, MAVLink_auth_key_message.id, MAVLink_auth_key_message.name)
                self._fieldnames = MAVLink_auth_key_message.fieldnames
                self._instance_field = MAVLink_auth_key_message.instance_field
                self._instance_offset = MAVLink_auth_key_message.instance_offset
                self.key = key

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 119, struct.pack('<32s', self.key), force_mavlink1=force_mavlink1)

class MAVLink_set_mode_message(MAVLink_message):
        '''
        Set the system mode, as defined by enum MAV_MODE. There is no
        target component id as the mode is by definition for the
        overall aircraft, not only for one component.
        '''
        id = MAVLINK_MSG_ID_SET_MODE
        name = 'SET_MODE'
        fieldnames = ['target_system', 'base_mode', 'custom_mode']
        ordered_fieldnames = ['custom_mode', 'target_system', 'base_mode']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"base_mode": "MAV_MODE"}
        fieldunits_by_name = {}
        format = '<IBB'
        native_format = bytearray('<IBB', 'ascii')
        orders = [1, 2, 0]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 89
        unpacker = struct.Struct('<IBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, base_mode, custom_mode):
                MAVLink_message.__init__(self, MAVLink_set_mode_message.id, MAVLink_set_mode_message.name)
                self._fieldnames = MAVLink_set_mode_message.fieldnames
                self._instance_field = MAVLink_set_mode_message.instance_field
                self._instance_offset = MAVLink_set_mode_message.instance_offset
                self.target_system = target_system
                self.base_mode = base_mode
                self.custom_mode = custom_mode

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 89, struct.pack('<IBB', self.custom_mode, self.target_system, self.base_mode), force_mavlink1=force_mavlink1)

class MAVLink_param_request_read_message(MAVLink_message):
        '''
        Request to read the onboard parameter with the param_id string
        id. Onboard parameters are stored as key[const char*] ->
        value[float]. This allows to send a parameter to any other
        component (such as the GCS) without the need of previous
        knowledge of possible parameter names. Thus the same GCS can
        store different parameters for different autopilots. See also
        https://mavlink.io/en/services/parameter.html for a full
        documentation of QGroundControl and IMU code.
        '''
        id = MAVLINK_MSG_ID_PARAM_REQUEST_READ
        name = 'PARAM_REQUEST_READ'
        fieldnames = ['target_system', 'target_component', 'param_id', 'param_index']
        ordered_fieldnames = ['param_index', 'target_system', 'target_component', 'param_id']
        fieldtypes = ['uint8_t', 'uint8_t', 'char', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<hBB16s'
        native_format = bytearray('<hBBc', 'ascii')
        orders = [1, 2, 3, 0]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 16]
        crc_extra = 214
        unpacker = struct.Struct('<hBB16s')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, param_id, param_index):
                MAVLink_message.__init__(self, MAVLink_param_request_read_message.id, MAVLink_param_request_read_message.name)
                self._fieldnames = MAVLink_param_request_read_message.fieldnames
                self._instance_field = MAVLink_param_request_read_message.instance_field
                self._instance_offset = MAVLink_param_request_read_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.param_id = param_id
                self.param_index = param_index

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 214, struct.pack('<hBB16s', self.param_index, self.target_system, self.target_component, self.param_id), force_mavlink1=force_mavlink1)

class MAVLink_param_request_list_message(MAVLink_message):
        '''
        Request all parameters of this component. After this request,
        all parameters are emitted. The parameter microservice is
        documented at https://mavlink.io/en/services/parameter.html
        '''
        id = MAVLINK_MSG_ID_PARAM_REQUEST_LIST
        name = 'PARAM_REQUEST_LIST'
        fieldnames = ['target_system', 'target_component']
        ordered_fieldnames = ['target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 159
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component):
                MAVLink_message.__init__(self, MAVLink_param_request_list_message.id, MAVLink_param_request_list_message.name)
                self._fieldnames = MAVLink_param_request_list_message.fieldnames
                self._instance_field = MAVLink_param_request_list_message.instance_field
                self._instance_offset = MAVLink_param_request_list_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 159, struct.pack('<BB', self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_param_value_message(MAVLink_message):
        '''
        Emit the value of a onboard parameter. The inclusion of
        param_count and param_index in the message allows the
        recipient to keep track of received parameters and allows him
        to re-request missing parameters after a loss or timeout. The
        parameter microservice is documented at
        https://mavlink.io/en/services/parameter.html
        '''
        id = MAVLINK_MSG_ID_PARAM_VALUE
        name = 'PARAM_VALUE'
        fieldnames = ['param_id', 'param_value', 'param_type', 'param_count', 'param_index']
        ordered_fieldnames = ['param_value', 'param_count', 'param_index', 'param_id', 'param_type']
        fieldtypes = ['char', 'float', 'uint8_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"param_type": "MAV_PARAM_TYPE"}
        fieldunits_by_name = {}
        format = '<fHH16sB'
        native_format = bytearray('<fHHcB', 'ascii')
        orders = [3, 0, 4, 1, 2]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 16, 0]
        crc_extra = 220
        unpacker = struct.Struct('<fHH16sB')
        instance_field = None
        instance_offset = -1

        def __init__(self, param_id, param_value, param_type, param_count, param_index):
                MAVLink_message.__init__(self, MAVLink_param_value_message.id, MAVLink_param_value_message.name)
                self._fieldnames = MAVLink_param_value_message.fieldnames
                self._instance_field = MAVLink_param_value_message.instance_field
                self._instance_offset = MAVLink_param_value_message.instance_offset
                self.param_id = param_id
                self.param_value = param_value
                self.param_type = param_type
                self.param_count = param_count
                self.param_index = param_index

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 220, struct.pack('<fHH16sB', self.param_value, self.param_count, self.param_index, self.param_id, self.param_type), force_mavlink1=force_mavlink1)

class MAVLink_param_set_message(MAVLink_message):
        '''
        Set a parameter value (write new value to permanent storage).
        The receiving component should acknowledge the new parameter
        value by broadcasting a PARAM_VALUE message (broadcasting
        ensures that multiple GCS all have an up-to-date list of all
        parameters). If the sending GCS did not receive a PARAM_VALUE
        within its timeout time, it should re-send the PARAM_SET
        message. The parameter microservice is documented at
        https://mavlink.io/en/services/parameter.html.
        '''
        id = MAVLINK_MSG_ID_PARAM_SET
        name = 'PARAM_SET'
        fieldnames = ['target_system', 'target_component', 'param_id', 'param_value', 'param_type']
        ordered_fieldnames = ['param_value', 'target_system', 'target_component', 'param_id', 'param_type']
        fieldtypes = ['uint8_t', 'uint8_t', 'char', 'float', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"param_type": "MAV_PARAM_TYPE"}
        fieldunits_by_name = {}
        format = '<fBB16sB'
        native_format = bytearray('<fBBcB', 'ascii')
        orders = [1, 2, 3, 0, 4]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 16, 0]
        crc_extra = 168
        unpacker = struct.Struct('<fBB16sB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, param_id, param_value, param_type):
                MAVLink_message.__init__(self, MAVLink_param_set_message.id, MAVLink_param_set_message.name)
                self._fieldnames = MAVLink_param_set_message.fieldnames
                self._instance_field = MAVLink_param_set_message.instance_field
                self._instance_offset = MAVLink_param_set_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.param_id = param_id
                self.param_value = param_value
                self.param_type = param_type

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 168, struct.pack('<fBB16sB', self.param_value, self.target_system, self.target_component, self.param_id, self.param_type), force_mavlink1=force_mavlink1)

class MAVLink_gps_raw_int_message(MAVLink_message):
        '''
        The global position, as returned by the Global Positioning
        System (GPS). This is                 NOT the global position
        estimate of the system, but rather a RAW sensor value. See
        message GLOBAL_POSITION for the global position estimate.
        '''
        id = MAVLINK_MSG_ID_GPS_RAW_INT
        name = 'GPS_RAW_INT'
        fieldnames = ['time_usec', 'fix_type', 'lat', 'lon', 'alt', 'eph', 'epv', 'vel', 'cog', 'satellites_visible']
        ordered_fieldnames = ['time_usec', 'lat', 'lon', 'alt', 'eph', 'epv', 'vel', 'cog', 'fix_type', 'satellites_visible']
        fieldtypes = ['uint64_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"fix_type": "GPS_FIX_TYPE"}
        fieldunits_by_name = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "vel": "cm/s", "cog": "cdeg"}
        format = '<QiiiHHHHBB'
        native_format = bytearray('<QiiiHHHHBB', 'ascii')
        orders = [0, 8, 1, 2, 3, 4, 5, 6, 7, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 24
        unpacker = struct.Struct('<QiiiHHHHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, fix_type, lat, lon, alt, eph, epv, vel, cog, satellites_visible):
                MAVLink_message.__init__(self, MAVLink_gps_raw_int_message.id, MAVLink_gps_raw_int_message.name)
                self._fieldnames = MAVLink_gps_raw_int_message.fieldnames
                self._instance_field = MAVLink_gps_raw_int_message.instance_field
                self._instance_offset = MAVLink_gps_raw_int_message.instance_offset
                self.time_usec = time_usec
                self.fix_type = fix_type
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.eph = eph
                self.epv = epv
                self.vel = vel
                self.cog = cog
                self.satellites_visible = satellites_visible

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 24, struct.pack('<QiiiHHHHBB', self.time_usec, self.lat, self.lon, self.alt, self.eph, self.epv, self.vel, self.cog, self.fix_type, self.satellites_visible), force_mavlink1=force_mavlink1)

class MAVLink_gps_status_message(MAVLink_message):
        '''
        The positioning status, as reported by GPS. This message is
        intended to display status information about each satellite
        visible to the receiver. See message GLOBAL_POSITION for the
        global position estimate. This message can contain information
        for up to 20 satellites.
        '''
        id = MAVLINK_MSG_ID_GPS_STATUS
        name = 'GPS_STATUS'
        fieldnames = ['satellites_visible', 'satellite_prn', 'satellite_used', 'satellite_elevation', 'satellite_azimuth', 'satellite_snr']
        ordered_fieldnames = ['satellites_visible', 'satellite_prn', 'satellite_used', 'satellite_elevation', 'satellite_azimuth', 'satellite_snr']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"satellite_elevation": "deg", "satellite_azimuth": "deg", "satellite_snr": "dB"}
        format = '<B20B20B20B20B20B'
        native_format = bytearray('<BBBBBB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5]
        lengths = [1, 20, 20, 20, 20, 20]
        array_lengths = [0, 20, 20, 20, 20, 20]
        crc_extra = 23
        unpacker = struct.Struct('<B20B20B20B20B20B')
        instance_field = None
        instance_offset = -1

        def __init__(self, satellites_visible, satellite_prn, satellite_used, satellite_elevation, satellite_azimuth, satellite_snr):
                MAVLink_message.__init__(self, MAVLink_gps_status_message.id, MAVLink_gps_status_message.name)
                self._fieldnames = MAVLink_gps_status_message.fieldnames
                self._instance_field = MAVLink_gps_status_message.instance_field
                self._instance_offset = MAVLink_gps_status_message.instance_offset
                self.satellites_visible = satellites_visible
                self.satellite_prn = satellite_prn
                self.satellite_used = satellite_used
                self.satellite_elevation = satellite_elevation
                self.satellite_azimuth = satellite_azimuth
                self.satellite_snr = satellite_snr

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 23, struct.pack('<B20B20B20B20B20B', self.satellites_visible, self.satellite_prn[0], self.satellite_prn[1], self.satellite_prn[2], self.satellite_prn[3], self.satellite_prn[4], self.satellite_prn[5], self.satellite_prn[6], self.satellite_prn[7], self.satellite_prn[8], self.satellite_prn[9], self.satellite_prn[10], self.satellite_prn[11], self.satellite_prn[12], self.satellite_prn[13], self.satellite_prn[14], self.satellite_prn[15], self.satellite_prn[16], self.satellite_prn[17], self.satellite_prn[18], self.satellite_prn[19], self.satellite_used[0], self.satellite_used[1], self.satellite_used[2], self.satellite_used[3], self.satellite_used[4], self.satellite_used[5], self.satellite_used[6], self.satellite_used[7], self.satellite_used[8], self.satellite_used[9], self.satellite_used[10], self.satellite_used[11], self.satellite_used[12], self.satellite_used[13], self.satellite_used[14], self.satellite_used[15], self.satellite_used[16], self.satellite_used[17], self.satellite_used[18], self.satellite_used[19], self.satellite_elevation[0], self.satellite_elevation[1], self.satellite_elevation[2], self.satellite_elevation[3], self.satellite_elevation[4], self.satellite_elevation[5], self.satellite_elevation[6], self.satellite_elevation[7], self.satellite_elevation[8], self.satellite_elevation[9], self.satellite_elevation[10], self.satellite_elevation[11], self.satellite_elevation[12], self.satellite_elevation[13], self.satellite_elevation[14], self.satellite_elevation[15], self.satellite_elevation[16], self.satellite_elevation[17], self.satellite_elevation[18], self.satellite_elevation[19], self.satellite_azimuth[0], self.satellite_azimuth[1], self.satellite_azimuth[2], self.satellite_azimuth[3], self.satellite_azimuth[4], self.satellite_azimuth[5], self.satellite_azimuth[6], self.satellite_azimuth[7], self.satellite_azimuth[8], self.satellite_azimuth[9], self.satellite_azimuth[10], self.satellite_azimuth[11], self.satellite_azimuth[12], self.satellite_azimuth[13], self.satellite_azimuth[14], self.satellite_azimuth[15], self.satellite_azimuth[16], self.satellite_azimuth[17], self.satellite_azimuth[18], self.satellite_azimuth[19], self.satellite_snr[0], self.satellite_snr[1], self.satellite_snr[2], self.satellite_snr[3], self.satellite_snr[4], self.satellite_snr[5], self.satellite_snr[6], self.satellite_snr[7], self.satellite_snr[8], self.satellite_snr[9], self.satellite_snr[10], self.satellite_snr[11], self.satellite_snr[12], self.satellite_snr[13], self.satellite_snr[14], self.satellite_snr[15], self.satellite_snr[16], self.satellite_snr[17], self.satellite_snr[18], self.satellite_snr[19]), force_mavlink1=force_mavlink1)

class MAVLink_scaled_imu_message(MAVLink_message):
        '''
        The RAW IMU readings for the usual 9DOF sensor setup. This
        message should contain the scaled values to the described
        units
        '''
        id = MAVLINK_MSG_ID_SCALED_IMU
        name = 'SCALED_IMU'
        fieldnames = ['time_boot_ms', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        ordered_fieldnames = ['time_boot_ms', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        fieldtypes = ['uint32_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "xacc": "mG", "yacc": "mG", "zacc": "mG", "xgyro": "mrad/s", "ygyro": "mrad/s", "zgyro": "mrad/s", "xmag": "mgauss", "ymag": "mgauss", "zmag": "mgauss"}
        format = '<Ihhhhhhhhh'
        native_format = bytearray('<Ihhhhhhhhh', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 170
        unpacker = struct.Struct('<Ihhhhhhhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, xacc, yacc, zacc, xgyro, ygyro, zgyro, xmag, ymag, zmag):
                MAVLink_message.__init__(self, MAVLink_scaled_imu_message.id, MAVLink_scaled_imu_message.name)
                self._fieldnames = MAVLink_scaled_imu_message.fieldnames
                self._instance_field = MAVLink_scaled_imu_message.instance_field
                self._instance_offset = MAVLink_scaled_imu_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.xmag = xmag
                self.ymag = ymag
                self.zmag = zmag

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 170, struct.pack('<Ihhhhhhhhh', self.time_boot_ms, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag), force_mavlink1=force_mavlink1)

class MAVLink_raw_imu_message(MAVLink_message):
        '''
        The RAW IMU readings for a 9DOF sensor, which is identified by
        the id (default IMU1). This message should always contain the
        true raw values without any scaling to allow data capture and
        system debugging.
        '''
        id = MAVLINK_MSG_ID_RAW_IMU
        name = 'RAW_IMU'
        fieldnames = ['time_usec', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        ordered_fieldnames = ['time_usec', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        fieldtypes = ['uint64_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<Qhhhhhhhhh'
        native_format = bytearray('<Qhhhhhhhhh', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 144
        unpacker = struct.Struct('<Qhhhhhhhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, xacc, yacc, zacc, xgyro, ygyro, zgyro, xmag, ymag, zmag):
                MAVLink_message.__init__(self, MAVLink_raw_imu_message.id, MAVLink_raw_imu_message.name)
                self._fieldnames = MAVLink_raw_imu_message.fieldnames
                self._instance_field = MAVLink_raw_imu_message.instance_field
                self._instance_offset = MAVLink_raw_imu_message.instance_offset
                self.time_usec = time_usec
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.xmag = xmag
                self.ymag = ymag
                self.zmag = zmag

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 144, struct.pack('<Qhhhhhhhhh', self.time_usec, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag), force_mavlink1=force_mavlink1)

class MAVLink_raw_pressure_message(MAVLink_message):
        '''
        The RAW pressure readings for the typical setup of one
        absolute pressure and one differential pressure sensor. The
        sensor values should be the raw, UNSCALED ADC values.
        '''
        id = MAVLINK_MSG_ID_RAW_PRESSURE
        name = 'RAW_PRESSURE'
        fieldnames = ['time_usec', 'press_abs', 'press_diff1', 'press_diff2', 'temperature']
        ordered_fieldnames = ['time_usec', 'press_abs', 'press_diff1', 'press_diff2', 'temperature']
        fieldtypes = ['uint64_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<Qhhhh'
        native_format = bytearray('<Qhhhh', 'ascii')
        orders = [0, 1, 2, 3, 4]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 67
        unpacker = struct.Struct('<Qhhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, press_abs, press_diff1, press_diff2, temperature):
                MAVLink_message.__init__(self, MAVLink_raw_pressure_message.id, MAVLink_raw_pressure_message.name)
                self._fieldnames = MAVLink_raw_pressure_message.fieldnames
                self._instance_field = MAVLink_raw_pressure_message.instance_field
                self._instance_offset = MAVLink_raw_pressure_message.instance_offset
                self.time_usec = time_usec
                self.press_abs = press_abs
                self.press_diff1 = press_diff1
                self.press_diff2 = press_diff2
                self.temperature = temperature

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 67, struct.pack('<Qhhhh', self.time_usec, self.press_abs, self.press_diff1, self.press_diff2, self.temperature), force_mavlink1=force_mavlink1)

class MAVLink_scaled_pressure_message(MAVLink_message):
        '''
        The pressure readings for the typical setup of one absolute
        and differential pressure sensor. The units are as specified
        in each field.
        '''
        id = MAVLINK_MSG_ID_SCALED_PRESSURE
        name = 'SCALED_PRESSURE'
        fieldnames = ['time_boot_ms', 'press_abs', 'press_diff', 'temperature']
        ordered_fieldnames = ['time_boot_ms', 'press_abs', 'press_diff', 'temperature']
        fieldtypes = ['uint32_t', 'float', 'float', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "press_abs": "hPa", "press_diff": "hPa", "temperature": "cdegC"}
        format = '<Iffh'
        native_format = bytearray('<Iffh', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 115
        unpacker = struct.Struct('<Iffh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, press_abs, press_diff, temperature):
                MAVLink_message.__init__(self, MAVLink_scaled_pressure_message.id, MAVLink_scaled_pressure_message.name)
                self._fieldnames = MAVLink_scaled_pressure_message.fieldnames
                self._instance_field = MAVLink_scaled_pressure_message.instance_field
                self._instance_offset = MAVLink_scaled_pressure_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.press_abs = press_abs
                self.press_diff = press_diff
                self.temperature = temperature

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 115, struct.pack('<Iffh', self.time_boot_ms, self.press_abs, self.press_diff, self.temperature), force_mavlink1=force_mavlink1)

class MAVLink_attitude_message(MAVLink_message):
        '''
        The attitude in the aeronautical frame (right-handed, Z-down,
        X-front, Y-right).
        '''
        id = MAVLINK_MSG_ID_ATTITUDE
        name = 'ATTITUDE'
        fieldnames = ['time_boot_ms', 'roll', 'pitch', 'yaw', 'rollspeed', 'pitchspeed', 'yawspeed']
        ordered_fieldnames = ['time_boot_ms', 'roll', 'pitch', 'yaw', 'rollspeed', 'pitchspeed', 'yawspeed']
        fieldtypes = ['uint32_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "roll": "rad", "pitch": "rad", "yaw": "rad", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s"}
        format = '<Iffffff'
        native_format = bytearray('<Iffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 39
        unpacker = struct.Struct('<Iffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, roll, pitch, yaw, rollspeed, pitchspeed, yawspeed):
                MAVLink_message.__init__(self, MAVLink_attitude_message.id, MAVLink_attitude_message.name)
                self._fieldnames = MAVLink_attitude_message.fieldnames
                self._instance_field = MAVLink_attitude_message.instance_field
                self._instance_offset = MAVLink_attitude_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.rollspeed = rollspeed
                self.pitchspeed = pitchspeed
                self.yawspeed = yawspeed

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 39, struct.pack('<Iffffff', self.time_boot_ms, self.roll, self.pitch, self.yaw, self.rollspeed, self.pitchspeed, self.yawspeed), force_mavlink1=force_mavlink1)

class MAVLink_attitude_quaternion_message(MAVLink_message):
        '''
        The attitude in the aeronautical frame (right-handed, Z-down,
        X-front, Y-right), expressed as quaternion. Quaternion order
        is w, x, y, z and a zero rotation would be expressed as (1 0 0
        0).
        '''
        id = MAVLINK_MSG_ID_ATTITUDE_QUATERNION
        name = 'ATTITUDE_QUATERNION'
        fieldnames = ['time_boot_ms', 'q1', 'q2', 'q3', 'q4', 'rollspeed', 'pitchspeed', 'yawspeed']
        ordered_fieldnames = ['time_boot_ms', 'q1', 'q2', 'q3', 'q4', 'rollspeed', 'pitchspeed', 'yawspeed']
        fieldtypes = ['uint32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s"}
        format = '<Ifffffff'
        native_format = bytearray('<Ifffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 246
        unpacker = struct.Struct('<Ifffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, q1, q2, q3, q4, rollspeed, pitchspeed, yawspeed):
                MAVLink_message.__init__(self, MAVLink_attitude_quaternion_message.id, MAVLink_attitude_quaternion_message.name)
                self._fieldnames = MAVLink_attitude_quaternion_message.fieldnames
                self._instance_field = MAVLink_attitude_quaternion_message.instance_field
                self._instance_offset = MAVLink_attitude_quaternion_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.q1 = q1
                self.q2 = q2
                self.q3 = q3
                self.q4 = q4
                self.rollspeed = rollspeed
                self.pitchspeed = pitchspeed
                self.yawspeed = yawspeed

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 246, struct.pack('<Ifffffff', self.time_boot_ms, self.q1, self.q2, self.q3, self.q4, self.rollspeed, self.pitchspeed, self.yawspeed), force_mavlink1=force_mavlink1)

class MAVLink_local_position_ned_message(MAVLink_message):
        '''
        The filtered local position (e.g. fused computer vision and
        accelerometers). Coordinate frame is right-handed, Z-axis down
        (aeronautical frame, NED / north-east-down convention)
        '''
        id = MAVLINK_MSG_ID_LOCAL_POSITION_NED
        name = 'LOCAL_POSITION_NED'
        fieldnames = ['time_boot_ms', 'x', 'y', 'z', 'vx', 'vy', 'vz']
        ordered_fieldnames = ['time_boot_ms', 'x', 'y', 'z', 'vx', 'vy', 'vz']
        fieldtypes = ['uint32_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s"}
        format = '<Iffffff'
        native_format = bytearray('<Iffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 185
        unpacker = struct.Struct('<Iffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, x, y, z, vx, vy, vz):
                MAVLink_message.__init__(self, MAVLink_local_position_ned_message.id, MAVLink_local_position_ned_message.name)
                self._fieldnames = MAVLink_local_position_ned_message.fieldnames
                self._instance_field = MAVLink_local_position_ned_message.instance_field
                self._instance_offset = MAVLink_local_position_ned_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.x = x
                self.y = y
                self.z = z
                self.vx = vx
                self.vy = vy
                self.vz = vz

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 185, struct.pack('<Iffffff', self.time_boot_ms, self.x, self.y, self.z, self.vx, self.vy, self.vz), force_mavlink1=force_mavlink1)

class MAVLink_global_position_int_message(MAVLink_message):
        '''
        The filtered global position (e.g. fused GPS and
        accelerometers). The position is in GPS-frame (right-handed,
        Z-up). It                is designed as scaled integer message
        since the resolution of float is not sufficient.
        '''
        id = MAVLINK_MSG_ID_GLOBAL_POSITION_INT
        name = 'GLOBAL_POSITION_INT'
        fieldnames = ['time_boot_ms', 'lat', 'lon', 'alt', 'relative_alt', 'vx', 'vy', 'vz', 'hdg']
        ordered_fieldnames = ['time_boot_ms', 'lat', 'lon', 'alt', 'relative_alt', 'vx', 'vy', 'vz', 'hdg']
        fieldtypes = ['uint32_t', 'int32_t', 'int32_t', 'int32_t', 'int32_t', 'int16_t', 'int16_t', 'int16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "lat": "degE7", "lon": "degE7", "alt": "mm", "relative_alt": "mm", "vx": "cm/s", "vy": "cm/s", "vz": "cm/s", "hdg": "cdeg"}
        format = '<IiiiihhhH'
        native_format = bytearray('<IiiiihhhH', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 104
        unpacker = struct.Struct('<IiiiihhhH')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, lat, lon, alt, relative_alt, vx, vy, vz, hdg):
                MAVLink_message.__init__(self, MAVLink_global_position_int_message.id, MAVLink_global_position_int_message.name)
                self._fieldnames = MAVLink_global_position_int_message.fieldnames
                self._instance_field = MAVLink_global_position_int_message.instance_field
                self._instance_offset = MAVLink_global_position_int_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.relative_alt = relative_alt
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.hdg = hdg

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 104, struct.pack('<IiiiihhhH', self.time_boot_ms, self.lat, self.lon, self.alt, self.relative_alt, self.vx, self.vy, self.vz, self.hdg), force_mavlink1=force_mavlink1)

class MAVLink_rc_channels_scaled_message(MAVLink_message):
        '''
        The scaled values of the RC channels received: (-100%) -10000,
        (0%) 0, (100%) 10000. Channels that are inactive should be set
        to UINT16_MAX.
        '''
        id = MAVLINK_MSG_ID_RC_CHANNELS_SCALED
        name = 'RC_CHANNELS_SCALED'
        fieldnames = ['time_boot_ms', 'port', 'chan1_scaled', 'chan2_scaled', 'chan3_scaled', 'chan4_scaled', 'chan5_scaled', 'chan6_scaled', 'chan7_scaled', 'chan8_scaled', 'rssi']
        ordered_fieldnames = ['time_boot_ms', 'chan1_scaled', 'chan2_scaled', 'chan3_scaled', 'chan4_scaled', 'chan5_scaled', 'chan6_scaled', 'chan7_scaled', 'chan8_scaled', 'port', 'rssi']
        fieldtypes = ['uint32_t', 'uint8_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms"}
        format = '<IhhhhhhhhBB'
        native_format = bytearray('<IhhhhhhhhBB', 'ascii')
        orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8, 10]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 237
        unpacker = struct.Struct('<IhhhhhhhhBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, port, chan1_scaled, chan2_scaled, chan3_scaled, chan4_scaled, chan5_scaled, chan6_scaled, chan7_scaled, chan8_scaled, rssi):
                MAVLink_message.__init__(self, MAVLink_rc_channels_scaled_message.id, MAVLink_rc_channels_scaled_message.name)
                self._fieldnames = MAVLink_rc_channels_scaled_message.fieldnames
                self._instance_field = MAVLink_rc_channels_scaled_message.instance_field
                self._instance_offset = MAVLink_rc_channels_scaled_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.port = port
                self.chan1_scaled = chan1_scaled
                self.chan2_scaled = chan2_scaled
                self.chan3_scaled = chan3_scaled
                self.chan4_scaled = chan4_scaled
                self.chan5_scaled = chan5_scaled
                self.chan6_scaled = chan6_scaled
                self.chan7_scaled = chan7_scaled
                self.chan8_scaled = chan8_scaled
                self.rssi = rssi

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 237, struct.pack('<IhhhhhhhhBB', self.time_boot_ms, self.chan1_scaled, self.chan2_scaled, self.chan3_scaled, self.chan4_scaled, self.chan5_scaled, self.chan6_scaled, self.chan7_scaled, self.chan8_scaled, self.port, self.rssi), force_mavlink1=force_mavlink1)

class MAVLink_rc_channels_raw_message(MAVLink_message):
        '''
        The RAW values of the RC channels received. The standard PPM
        modulation is as follows: 1000 microseconds: 0%, 2000
        microseconds: 100%. A value of UINT16_MAX implies the channel
        is unused. Individual receivers/transmitters might violate
        this specification.
        '''
        id = MAVLINK_MSG_ID_RC_CHANNELS_RAW
        name = 'RC_CHANNELS_RAW'
        fieldnames = ['time_boot_ms', 'port', 'chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw', 'rssi']
        ordered_fieldnames = ['time_boot_ms', 'chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw', 'port', 'rssi']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us"}
        format = '<IHHHHHHHHBB'
        native_format = bytearray('<IHHHHHHHHBB', 'ascii')
        orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8, 10]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 244
        unpacker = struct.Struct('<IHHHHHHHHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, port, chan1_raw, chan2_raw, chan3_raw, chan4_raw, chan5_raw, chan6_raw, chan7_raw, chan8_raw, rssi):
                MAVLink_message.__init__(self, MAVLink_rc_channels_raw_message.id, MAVLink_rc_channels_raw_message.name)
                self._fieldnames = MAVLink_rc_channels_raw_message.fieldnames
                self._instance_field = MAVLink_rc_channels_raw_message.instance_field
                self._instance_offset = MAVLink_rc_channels_raw_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.port = port
                self.chan1_raw = chan1_raw
                self.chan2_raw = chan2_raw
                self.chan3_raw = chan3_raw
                self.chan4_raw = chan4_raw
                self.chan5_raw = chan5_raw
                self.chan6_raw = chan6_raw
                self.chan7_raw = chan7_raw
                self.chan8_raw = chan8_raw
                self.rssi = rssi

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 244, struct.pack('<IHHHHHHHHBB', self.time_boot_ms, self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.port, self.rssi), force_mavlink1=force_mavlink1)

class MAVLink_servo_output_raw_message(MAVLink_message):
        '''
        Superseded by ACTUATOR_OUTPUT_STATUS. The RAW values of the
        servo outputs (for RC input from the remote, use the
        RC_CHANNELS messages). The standard PPM modulation is as
        follows: 1000 microseconds: 0%, 2000 microseconds: 100%.
        '''
        id = MAVLINK_MSG_ID_SERVO_OUTPUT_RAW
        name = 'SERVO_OUTPUT_RAW'
        fieldnames = ['time_usec', 'port', 'servo1_raw', 'servo2_raw', 'servo3_raw', 'servo4_raw', 'servo5_raw', 'servo6_raw', 'servo7_raw', 'servo8_raw']
        ordered_fieldnames = ['time_usec', 'servo1_raw', 'servo2_raw', 'servo3_raw', 'servo4_raw', 'servo5_raw', 'servo6_raw', 'servo7_raw', 'servo8_raw', 'port']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "servo1_raw": "us", "servo2_raw": "us", "servo3_raw": "us", "servo4_raw": "us", "servo5_raw": "us", "servo6_raw": "us", "servo7_raw": "us", "servo8_raw": "us"}
        format = '<IHHHHHHHHB'
        native_format = bytearray('<IHHHHHHHHB', 'ascii')
        orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 222
        unpacker = struct.Struct('<IHHHHHHHHB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, port, servo1_raw, servo2_raw, servo3_raw, servo4_raw, servo5_raw, servo6_raw, servo7_raw, servo8_raw):
                MAVLink_message.__init__(self, MAVLink_servo_output_raw_message.id, MAVLink_servo_output_raw_message.name)
                self._fieldnames = MAVLink_servo_output_raw_message.fieldnames
                self._instance_field = MAVLink_servo_output_raw_message.instance_field
                self._instance_offset = MAVLink_servo_output_raw_message.instance_offset
                self.time_usec = time_usec
                self.port = port
                self.servo1_raw = servo1_raw
                self.servo2_raw = servo2_raw
                self.servo3_raw = servo3_raw
                self.servo4_raw = servo4_raw
                self.servo5_raw = servo5_raw
                self.servo6_raw = servo6_raw
                self.servo7_raw = servo7_raw
                self.servo8_raw = servo8_raw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 222, struct.pack('<IHHHHHHHHB', self.time_usec, self.servo1_raw, self.servo2_raw, self.servo3_raw, self.servo4_raw, self.servo5_raw, self.servo6_raw, self.servo7_raw, self.servo8_raw, self.port), force_mavlink1=force_mavlink1)

class MAVLink_mission_request_partial_list_message(MAVLink_message):
        '''
        Request a partial list of mission items from the
        system/component. https://mavlink.io/en/services/mission.html.
        If start and end index are the same, just send one waypoint.
        '''
        id = MAVLINK_MSG_ID_MISSION_REQUEST_PARTIAL_LIST
        name = 'MISSION_REQUEST_PARTIAL_LIST'
        fieldnames = ['target_system', 'target_component', 'start_index', 'end_index']
        ordered_fieldnames = ['start_index', 'end_index', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<hhBB'
        native_format = bytearray('<hhBB', 'ascii')
        orders = [2, 3, 0, 1]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 212
        unpacker = struct.Struct('<hhBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, start_index, end_index):
                MAVLink_message.__init__(self, MAVLink_mission_request_partial_list_message.id, MAVLink_mission_request_partial_list_message.name)
                self._fieldnames = MAVLink_mission_request_partial_list_message.fieldnames
                self._instance_field = MAVLink_mission_request_partial_list_message.instance_field
                self._instance_offset = MAVLink_mission_request_partial_list_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.start_index = start_index
                self.end_index = end_index

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 212, struct.pack('<hhBB', self.start_index, self.end_index, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_write_partial_list_message(MAVLink_message):
        '''
        This message is sent to the MAV to write a partial list. If
        start index == end index, only one item will be transmitted /
        updated. If the start index is NOT 0 and above the current
        list size, this request should be REJECTED!
        '''
        id = MAVLINK_MSG_ID_MISSION_WRITE_PARTIAL_LIST
        name = 'MISSION_WRITE_PARTIAL_LIST'
        fieldnames = ['target_system', 'target_component', 'start_index', 'end_index']
        ordered_fieldnames = ['start_index', 'end_index', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<hhBB'
        native_format = bytearray('<hhBB', 'ascii')
        orders = [2, 3, 0, 1]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 9
        unpacker = struct.Struct('<hhBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, start_index, end_index):
                MAVLink_message.__init__(self, MAVLink_mission_write_partial_list_message.id, MAVLink_mission_write_partial_list_message.name)
                self._fieldnames = MAVLink_mission_write_partial_list_message.fieldnames
                self._instance_field = MAVLink_mission_write_partial_list_message.instance_field
                self._instance_offset = MAVLink_mission_write_partial_list_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.start_index = start_index
                self.end_index = end_index

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 9, struct.pack('<hhBB', self.start_index, self.end_index, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_item_message(MAVLink_message):
        '''
        Message encoding a mission item. This message is emitted to
        announce                 the presence of a mission item and to
        set a mission item on the system. The mission item can be
        either in x, y, z meters (type: LOCAL) or x:lat, y:lon,
        z:altitude. Local frame is Z-down, right handed (NED), global
        frame is Z-up, right handed (ENU). NaN may be used to indicate
        an optional/default value (e.g. to use the system's current
        latitude or yaw rather than a specific value). See also
        https://mavlink.io/en/services/mission.html.
        '''
        id = MAVLINK_MSG_ID_MISSION_ITEM
        name = 'MISSION_ITEM'
        fieldnames = ['target_system', 'target_component', 'seq', 'frame', 'command', 'current', 'autocontinue', 'param1', 'param2', 'param3', 'param4', 'x', 'y', 'z']
        ordered_fieldnames = ['param1', 'param2', 'param3', 'param4', 'x', 'y', 'z', 'seq', 'command', 'target_system', 'target_component', 'frame', 'current', 'autocontinue']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t', 'uint8_t', 'uint16_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"frame": "MAV_FRAME", "command": "MAV_CMD"}
        fieldunits_by_name = {}
        format = '<fffffffHHBBBBB'
        native_format = bytearray('<fffffffHHBBBBB', 'ascii')
        orders = [9, 10, 7, 11, 8, 12, 13, 0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 254
        unpacker = struct.Struct('<fffffffHHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, seq, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z):
                MAVLink_message.__init__(self, MAVLink_mission_item_message.id, MAVLink_mission_item_message.name)
                self._fieldnames = MAVLink_mission_item_message.fieldnames
                self._instance_field = MAVLink_mission_item_message.instance_field
                self._instance_offset = MAVLink_mission_item_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.seq = seq
                self.frame = frame
                self.command = command
                self.current = current
                self.autocontinue = autocontinue
                self.param1 = param1
                self.param2 = param2
                self.param3 = param3
                self.param4 = param4
                self.x = x
                self.y = y
                self.z = z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 254, struct.pack('<fffffffHHBBBBB', self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.seq, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue), force_mavlink1=force_mavlink1)

class MAVLink_mission_request_message(MAVLink_message):
        '''
        Request the information of the mission item with the sequence
        number seq. The response of the system to this message should
        be a MISSION_ITEM message.
        https://mavlink.io/en/services/mission.html
        '''
        id = MAVLINK_MSG_ID_MISSION_REQUEST
        name = 'MISSION_REQUEST'
        fieldnames = ['target_system', 'target_component', 'seq']
        ordered_fieldnames = ['seq', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HBB'
        native_format = bytearray('<HBB', 'ascii')
        orders = [1, 2, 0]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 230
        unpacker = struct.Struct('<HBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, seq):
                MAVLink_message.__init__(self, MAVLink_mission_request_message.id, MAVLink_mission_request_message.name)
                self._fieldnames = MAVLink_mission_request_message.fieldnames
                self._instance_field = MAVLink_mission_request_message.instance_field
                self._instance_offset = MAVLink_mission_request_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.seq = seq

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 230, struct.pack('<HBB', self.seq, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_set_current_message(MAVLink_message):
        '''
        Set the mission item with sequence number seq as current item.
        This means that the MAV will continue to this mission item on
        the shortest path (not following the mission items in-
        between).
        '''
        id = MAVLINK_MSG_ID_MISSION_SET_CURRENT
        name = 'MISSION_SET_CURRENT'
        fieldnames = ['target_system', 'target_component', 'seq']
        ordered_fieldnames = ['seq', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HBB'
        native_format = bytearray('<HBB', 'ascii')
        orders = [1, 2, 0]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 28
        unpacker = struct.Struct('<HBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, seq):
                MAVLink_message.__init__(self, MAVLink_mission_set_current_message.id, MAVLink_mission_set_current_message.name)
                self._fieldnames = MAVLink_mission_set_current_message.fieldnames
                self._instance_field = MAVLink_mission_set_current_message.instance_field
                self._instance_offset = MAVLink_mission_set_current_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.seq = seq

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 28, struct.pack('<HBB', self.seq, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_current_message(MAVLink_message):
        '''
        Message that announces the sequence number of the current
        active mission item. The MAV will fly towards this mission
        item.
        '''
        id = MAVLINK_MSG_ID_MISSION_CURRENT
        name = 'MISSION_CURRENT'
        fieldnames = ['seq']
        ordered_fieldnames = ['seq']
        fieldtypes = ['uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<H'
        native_format = bytearray('<H', 'ascii')
        orders = [0]
        lengths = [1]
        array_lengths = [0]
        crc_extra = 28
        unpacker = struct.Struct('<H')
        instance_field = None
        instance_offset = -1

        def __init__(self, seq):
                MAVLink_message.__init__(self, MAVLink_mission_current_message.id, MAVLink_mission_current_message.name)
                self._fieldnames = MAVLink_mission_current_message.fieldnames
                self._instance_field = MAVLink_mission_current_message.instance_field
                self._instance_offset = MAVLink_mission_current_message.instance_offset
                self.seq = seq

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 28, struct.pack('<H', self.seq), force_mavlink1=force_mavlink1)

class MAVLink_mission_request_list_message(MAVLink_message):
        '''
        Request the overall list of mission items from the
        system/component.
        '''
        id = MAVLINK_MSG_ID_MISSION_REQUEST_LIST
        name = 'MISSION_REQUEST_LIST'
        fieldnames = ['target_system', 'target_component']
        ordered_fieldnames = ['target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 132
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component):
                MAVLink_message.__init__(self, MAVLink_mission_request_list_message.id, MAVLink_mission_request_list_message.name)
                self._fieldnames = MAVLink_mission_request_list_message.fieldnames
                self._instance_field = MAVLink_mission_request_list_message.instance_field
                self._instance_offset = MAVLink_mission_request_list_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 132, struct.pack('<BB', self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_count_message(MAVLink_message):
        '''
        This message is emitted as response to MISSION_REQUEST_LIST by
        the MAV and to initiate a write transaction. The GCS can then
        request the individual mission item based on the knowledge of
        the total number of waypoints.
        '''
        id = MAVLINK_MSG_ID_MISSION_COUNT
        name = 'MISSION_COUNT'
        fieldnames = ['target_system', 'target_component', 'count']
        ordered_fieldnames = ['count', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HBB'
        native_format = bytearray('<HBB', 'ascii')
        orders = [1, 2, 0]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 221
        unpacker = struct.Struct('<HBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, count):
                MAVLink_message.__init__(self, MAVLink_mission_count_message.id, MAVLink_mission_count_message.name)
                self._fieldnames = MAVLink_mission_count_message.fieldnames
                self._instance_field = MAVLink_mission_count_message.instance_field
                self._instance_offset = MAVLink_mission_count_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.count = count

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 221, struct.pack('<HBB', self.count, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_clear_all_message(MAVLink_message):
        '''
        Delete all mission items at once.
        '''
        id = MAVLINK_MSG_ID_MISSION_CLEAR_ALL
        name = 'MISSION_CLEAR_ALL'
        fieldnames = ['target_system', 'target_component']
        ordered_fieldnames = ['target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 232
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component):
                MAVLink_message.__init__(self, MAVLink_mission_clear_all_message.id, MAVLink_mission_clear_all_message.name)
                self._fieldnames = MAVLink_mission_clear_all_message.fieldnames
                self._instance_field = MAVLink_mission_clear_all_message.instance_field
                self._instance_offset = MAVLink_mission_clear_all_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 232, struct.pack('<BB', self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_item_reached_message(MAVLink_message):
        '''
        A certain mission item has been reached. The system will
        either hold this position (or circle on the orbit) or (if the
        autocontinue on the WP was set) continue to the next waypoint.
        '''
        id = MAVLINK_MSG_ID_MISSION_ITEM_REACHED
        name = 'MISSION_ITEM_REACHED'
        fieldnames = ['seq']
        ordered_fieldnames = ['seq']
        fieldtypes = ['uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<H'
        native_format = bytearray('<H', 'ascii')
        orders = [0]
        lengths = [1]
        array_lengths = [0]
        crc_extra = 11
        unpacker = struct.Struct('<H')
        instance_field = None
        instance_offset = -1

        def __init__(self, seq):
                MAVLink_message.__init__(self, MAVLink_mission_item_reached_message.id, MAVLink_mission_item_reached_message.name)
                self._fieldnames = MAVLink_mission_item_reached_message.fieldnames
                self._instance_field = MAVLink_mission_item_reached_message.instance_field
                self._instance_offset = MAVLink_mission_item_reached_message.instance_offset
                self.seq = seq

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 11, struct.pack('<H', self.seq), force_mavlink1=force_mavlink1)

class MAVLink_mission_ack_message(MAVLink_message):
        '''
        Acknowledgment message during waypoint handling. The type
        field states if this message is a positive ack (type=0) or if
        an error happened (type=non-zero).
        '''
        id = MAVLINK_MSG_ID_MISSION_ACK
        name = 'MISSION_ACK'
        fieldnames = ['target_system', 'target_component', 'type']
        ordered_fieldnames = ['target_system', 'target_component', 'type']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"type": "MAV_MISSION_RESULT"}
        fieldunits_by_name = {}
        format = '<BBB'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 153
        unpacker = struct.Struct('<BBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, type):
                MAVLink_message.__init__(self, MAVLink_mission_ack_message.id, MAVLink_mission_ack_message.name)
                self._fieldnames = MAVLink_mission_ack_message.fieldnames
                self._instance_field = MAVLink_mission_ack_message.instance_field
                self._instance_offset = MAVLink_mission_ack_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.type = type

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 153, struct.pack('<BBB', self.target_system, self.target_component, self.type), force_mavlink1=force_mavlink1)

class MAVLink_set_gps_global_origin_message(MAVLink_message):
        '''
        Sets the GPS co-ordinates of the vehicle local origin (0,0,0)
        position. Vehicle should emit GPS_GLOBAL_ORIGIN irrespective
        of whether the origin is changed. This enables transform
        between the local coordinate frame and the global (GPS)
        coordinate frame, which may be necessary when (for example)
        indoor and outdoor settings are connected and the MAV should
        move from in- to outdoor.
        '''
        id = MAVLINK_MSG_ID_SET_GPS_GLOBAL_ORIGIN
        name = 'SET_GPS_GLOBAL_ORIGIN'
        fieldnames = ['target_system', 'latitude', 'longitude', 'altitude']
        ordered_fieldnames = ['latitude', 'longitude', 'altitude', 'target_system']
        fieldtypes = ['uint8_t', 'int32_t', 'int32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm"}
        format = '<iiiB'
        native_format = bytearray('<iiiB', 'ascii')
        orders = [3, 0, 1, 2]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 41
        unpacker = struct.Struct('<iiiB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, latitude, longitude, altitude):
                MAVLink_message.__init__(self, MAVLink_set_gps_global_origin_message.id, MAVLink_set_gps_global_origin_message.name)
                self._fieldnames = MAVLink_set_gps_global_origin_message.fieldnames
                self._instance_field = MAVLink_set_gps_global_origin_message.instance_field
                self._instance_offset = MAVLink_set_gps_global_origin_message.instance_offset
                self.target_system = target_system
                self.latitude = latitude
                self.longitude = longitude
                self.altitude = altitude

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 41, struct.pack('<iiiB', self.latitude, self.longitude, self.altitude, self.target_system), force_mavlink1=force_mavlink1)

class MAVLink_gps_global_origin_message(MAVLink_message):
        '''
        Publishes the GPS co-ordinates of the vehicle local origin
        (0,0,0) position. Emitted whenever a new GPS-Local position
        mapping is requested or set - e.g. following
        SET_GPS_GLOBAL_ORIGIN message.
        '''
        id = MAVLINK_MSG_ID_GPS_GLOBAL_ORIGIN
        name = 'GPS_GLOBAL_ORIGIN'
        fieldnames = ['latitude', 'longitude', 'altitude']
        ordered_fieldnames = ['latitude', 'longitude', 'altitude']
        fieldtypes = ['int32_t', 'int32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm"}
        format = '<iii'
        native_format = bytearray('<iii', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 39
        unpacker = struct.Struct('<iii')
        instance_field = None
        instance_offset = -1

        def __init__(self, latitude, longitude, altitude):
                MAVLink_message.__init__(self, MAVLink_gps_global_origin_message.id, MAVLink_gps_global_origin_message.name)
                self._fieldnames = MAVLink_gps_global_origin_message.fieldnames
                self._instance_field = MAVLink_gps_global_origin_message.instance_field
                self._instance_offset = MAVLink_gps_global_origin_message.instance_offset
                self.latitude = latitude
                self.longitude = longitude
                self.altitude = altitude

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 39, struct.pack('<iii', self.latitude, self.longitude, self.altitude), force_mavlink1=force_mavlink1)

class MAVLink_param_map_rc_message(MAVLink_message):
        '''
        Bind a RC channel to a parameter. The parameter should change
        according to the RC channel value.
        '''
        id = MAVLINK_MSG_ID_PARAM_MAP_RC
        name = 'PARAM_MAP_RC'
        fieldnames = ['target_system', 'target_component', 'param_id', 'param_index', 'parameter_rc_channel_index', 'param_value0', 'scale', 'param_value_min', 'param_value_max']
        ordered_fieldnames = ['param_value0', 'scale', 'param_value_min', 'param_value_max', 'param_index', 'target_system', 'target_component', 'param_id', 'parameter_rc_channel_index']
        fieldtypes = ['uint8_t', 'uint8_t', 'char', 'int16_t', 'uint8_t', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<ffffhBB16sB'
        native_format = bytearray('<ffffhBBcB', 'ascii')
        orders = [5, 6, 7, 4, 8, 0, 1, 2, 3]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 16, 0]
        crc_extra = 78
        unpacker = struct.Struct('<ffffhBB16sB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, param_id, param_index, parameter_rc_channel_index, param_value0, scale, param_value_min, param_value_max):
                MAVLink_message.__init__(self, MAVLink_param_map_rc_message.id, MAVLink_param_map_rc_message.name)
                self._fieldnames = MAVLink_param_map_rc_message.fieldnames
                self._instance_field = MAVLink_param_map_rc_message.instance_field
                self._instance_offset = MAVLink_param_map_rc_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.param_id = param_id
                self.param_index = param_index
                self.parameter_rc_channel_index = parameter_rc_channel_index
                self.param_value0 = param_value0
                self.scale = scale
                self.param_value_min = param_value_min
                self.param_value_max = param_value_max

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 78, struct.pack('<ffffhBB16sB', self.param_value0, self.scale, self.param_value_min, self.param_value_max, self.param_index, self.target_system, self.target_component, self.param_id, self.parameter_rc_channel_index), force_mavlink1=force_mavlink1)

class MAVLink_mission_request_int_message(MAVLink_message):
        '''
        Request the information of the mission item with the sequence
        number seq. The response of the system to this message should
        be a MISSION_ITEM_INT message.
        https://mavlink.io/en/services/mission.html
        '''
        id = MAVLINK_MSG_ID_MISSION_REQUEST_INT
        name = 'MISSION_REQUEST_INT'
        fieldnames = ['target_system', 'target_component', 'seq']
        ordered_fieldnames = ['seq', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HBB'
        native_format = bytearray('<HBB', 'ascii')
        orders = [1, 2, 0]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 196
        unpacker = struct.Struct('<HBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, seq):
                MAVLink_message.__init__(self, MAVLink_mission_request_int_message.id, MAVLink_mission_request_int_message.name)
                self._fieldnames = MAVLink_mission_request_int_message.fieldnames
                self._instance_field = MAVLink_mission_request_int_message.instance_field
                self._instance_offset = MAVLink_mission_request_int_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.seq = seq

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 196, struct.pack('<HBB', self.seq, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_safety_set_allowed_area_message(MAVLink_message):
        '''
        Set a safety zone (volume), which is defined by two corners of
        a cube. This message can be used to tell the MAV which
        setpoints/waypoints to accept and which to reject. Safety
        areas are often enforced by national or competition
        regulations.
        '''
        id = MAVLINK_MSG_ID_SAFETY_SET_ALLOWED_AREA
        name = 'SAFETY_SET_ALLOWED_AREA'
        fieldnames = ['target_system', 'target_component', 'frame', 'p1x', 'p1y', 'p1z', 'p2x', 'p2y', 'p2z']
        ordered_fieldnames = ['p1x', 'p1y', 'p1z', 'p2x', 'p2y', 'p2z', 'target_system', 'target_component', 'frame']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"frame": "MAV_FRAME"}
        fieldunits_by_name = {"p1x": "m", "p1y": "m", "p1z": "m", "p2x": "m", "p2y": "m", "p2z": "m"}
        format = '<ffffffBBB'
        native_format = bytearray('<ffffffBBB', 'ascii')
        orders = [6, 7, 8, 0, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 15
        unpacker = struct.Struct('<ffffffBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, frame, p1x, p1y, p1z, p2x, p2y, p2z):
                MAVLink_message.__init__(self, MAVLink_safety_set_allowed_area_message.id, MAVLink_safety_set_allowed_area_message.name)
                self._fieldnames = MAVLink_safety_set_allowed_area_message.fieldnames
                self._instance_field = MAVLink_safety_set_allowed_area_message.instance_field
                self._instance_offset = MAVLink_safety_set_allowed_area_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.frame = frame
                self.p1x = p1x
                self.p1y = p1y
                self.p1z = p1z
                self.p2x = p2x
                self.p2y = p2y
                self.p2z = p2z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 15, struct.pack('<ffffffBBB', self.p1x, self.p1y, self.p1z, self.p2x, self.p2y, self.p2z, self.target_system, self.target_component, self.frame), force_mavlink1=force_mavlink1)

class MAVLink_safety_allowed_area_message(MAVLink_message):
        '''
        Read out the safety zone the MAV currently assumes.
        '''
        id = MAVLINK_MSG_ID_SAFETY_ALLOWED_AREA
        name = 'SAFETY_ALLOWED_AREA'
        fieldnames = ['frame', 'p1x', 'p1y', 'p1z', 'p2x', 'p2y', 'p2z']
        ordered_fieldnames = ['p1x', 'p1y', 'p1z', 'p2x', 'p2y', 'p2z', 'frame']
        fieldtypes = ['uint8_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"frame": "MAV_FRAME"}
        fieldunits_by_name = {"p1x": "m", "p1y": "m", "p1z": "m", "p2x": "m", "p2y": "m", "p2z": "m"}
        format = '<ffffffB'
        native_format = bytearray('<ffffffB', 'ascii')
        orders = [6, 0, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 3
        unpacker = struct.Struct('<ffffffB')
        instance_field = None
        instance_offset = -1

        def __init__(self, frame, p1x, p1y, p1z, p2x, p2y, p2z):
                MAVLink_message.__init__(self, MAVLink_safety_allowed_area_message.id, MAVLink_safety_allowed_area_message.name)
                self._fieldnames = MAVLink_safety_allowed_area_message.fieldnames
                self._instance_field = MAVLink_safety_allowed_area_message.instance_field
                self._instance_offset = MAVLink_safety_allowed_area_message.instance_offset
                self.frame = frame
                self.p1x = p1x
                self.p1y = p1y
                self.p1z = p1z
                self.p2x = p2x
                self.p2y = p2y
                self.p2z = p2z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 3, struct.pack('<ffffffB', self.p1x, self.p1y, self.p1z, self.p2x, self.p2y, self.p2z, self.frame), force_mavlink1=force_mavlink1)

class MAVLink_attitude_quaternion_cov_message(MAVLink_message):
        '''
        The attitude in the aeronautical frame (right-handed, Z-down,
        X-front, Y-right), expressed as quaternion. Quaternion order
        is w, x, y, z and a zero rotation would be expressed as (1 0 0
        0).
        '''
        id = MAVLINK_MSG_ID_ATTITUDE_QUATERNION_COV
        name = 'ATTITUDE_QUATERNION_COV'
        fieldnames = ['time_usec', 'q', 'rollspeed', 'pitchspeed', 'yawspeed', 'covariance']
        ordered_fieldnames = ['time_usec', 'q', 'rollspeed', 'pitchspeed', 'yawspeed', 'covariance']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s"}
        format = '<Q4ffff9f'
        native_format = bytearray('<Qfffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5]
        lengths = [1, 4, 1, 1, 1, 9]
        array_lengths = [0, 4, 0, 0, 0, 9]
        crc_extra = 167
        unpacker = struct.Struct('<Q4ffff9f')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, q, rollspeed, pitchspeed, yawspeed, covariance):
                MAVLink_message.__init__(self, MAVLink_attitude_quaternion_cov_message.id, MAVLink_attitude_quaternion_cov_message.name)
                self._fieldnames = MAVLink_attitude_quaternion_cov_message.fieldnames
                self._instance_field = MAVLink_attitude_quaternion_cov_message.instance_field
                self._instance_offset = MAVLink_attitude_quaternion_cov_message.instance_offset
                self.time_usec = time_usec
                self.q = q
                self.rollspeed = rollspeed
                self.pitchspeed = pitchspeed
                self.yawspeed = yawspeed
                self.covariance = covariance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 167, struct.pack('<Q4ffff9f', self.time_usec, self.q[0], self.q[1], self.q[2], self.q[3], self.rollspeed, self.pitchspeed, self.yawspeed, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8]), force_mavlink1=force_mavlink1)

class MAVLink_nav_controller_output_message(MAVLink_message):
        '''
        The state of the fixed wing navigation and position
        controller.
        '''
        id = MAVLINK_MSG_ID_NAV_CONTROLLER_OUTPUT
        name = 'NAV_CONTROLLER_OUTPUT'
        fieldnames = ['nav_roll', 'nav_pitch', 'nav_bearing', 'target_bearing', 'wp_dist', 'alt_error', 'aspd_error', 'xtrack_error']
        ordered_fieldnames = ['nav_roll', 'nav_pitch', 'alt_error', 'aspd_error', 'xtrack_error', 'nav_bearing', 'target_bearing', 'wp_dist']
        fieldtypes = ['float', 'float', 'int16_t', 'int16_t', 'uint16_t', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"nav_roll": "deg", "nav_pitch": "deg", "nav_bearing": "deg", "target_bearing": "deg", "wp_dist": "m", "alt_error": "m", "aspd_error": "m/s", "xtrack_error": "m"}
        format = '<fffffhhH'
        native_format = bytearray('<fffffhhH', 'ascii')
        orders = [0, 1, 5, 6, 7, 2, 3, 4]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 183
        unpacker = struct.Struct('<fffffhhH')
        instance_field = None
        instance_offset = -1

        def __init__(self, nav_roll, nav_pitch, nav_bearing, target_bearing, wp_dist, alt_error, aspd_error, xtrack_error):
                MAVLink_message.__init__(self, MAVLink_nav_controller_output_message.id, MAVLink_nav_controller_output_message.name)
                self._fieldnames = MAVLink_nav_controller_output_message.fieldnames
                self._instance_field = MAVLink_nav_controller_output_message.instance_field
                self._instance_offset = MAVLink_nav_controller_output_message.instance_offset
                self.nav_roll = nav_roll
                self.nav_pitch = nav_pitch
                self.nav_bearing = nav_bearing
                self.target_bearing = target_bearing
                self.wp_dist = wp_dist
                self.alt_error = alt_error
                self.aspd_error = aspd_error
                self.xtrack_error = xtrack_error

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 183, struct.pack('<fffffhhH', self.nav_roll, self.nav_pitch, self.alt_error, self.aspd_error, self.xtrack_error, self.nav_bearing, self.target_bearing, self.wp_dist), force_mavlink1=force_mavlink1)

class MAVLink_global_position_int_cov_message(MAVLink_message):
        '''
        The filtered global position (e.g. fused GPS and
        accelerometers). The position is in GPS-frame (right-handed,
        Z-up). It  is designed as scaled integer message since the
        resolution of float is not sufficient. NOTE: This message is
        intended for onboard networks / companion computers and
        higher-bandwidth links and optimized for accuracy and
        completeness. Please use the GLOBAL_POSITION_INT message for a
        minimal subset.
        '''
        id = MAVLINK_MSG_ID_GLOBAL_POSITION_INT_COV
        name = 'GLOBAL_POSITION_INT_COV'
        fieldnames = ['time_usec', 'estimator_type', 'lat', 'lon', 'alt', 'relative_alt', 'vx', 'vy', 'vz', 'covariance']
        ordered_fieldnames = ['time_usec', 'lat', 'lon', 'alt', 'relative_alt', 'vx', 'vy', 'vz', 'covariance', 'estimator_type']
        fieldtypes = ['uint64_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"estimator_type": "MAV_ESTIMATOR_TYPE"}
        fieldunits_by_name = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "relative_alt": "mm", "vx": "m/s", "vy": "m/s", "vz": "m/s"}
        format = '<Qiiiifff36fB'
        native_format = bytearray('<QiiiiffffB', 'ascii')
        orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 36, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 36, 0]
        crc_extra = 119
        unpacker = struct.Struct('<Qiiiifff36fB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, estimator_type, lat, lon, alt, relative_alt, vx, vy, vz, covariance):
                MAVLink_message.__init__(self, MAVLink_global_position_int_cov_message.id, MAVLink_global_position_int_cov_message.name)
                self._fieldnames = MAVLink_global_position_int_cov_message.fieldnames
                self._instance_field = MAVLink_global_position_int_cov_message.instance_field
                self._instance_offset = MAVLink_global_position_int_cov_message.instance_offset
                self.time_usec = time_usec
                self.estimator_type = estimator_type
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.relative_alt = relative_alt
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.covariance = covariance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 119, struct.pack('<Qiiiifff36fB', self.time_usec, self.lat, self.lon, self.alt, self.relative_alt, self.vx, self.vy, self.vz, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20], self.covariance[21], self.covariance[22], self.covariance[23], self.covariance[24], self.covariance[25], self.covariance[26], self.covariance[27], self.covariance[28], self.covariance[29], self.covariance[30], self.covariance[31], self.covariance[32], self.covariance[33], self.covariance[34], self.covariance[35], self.estimator_type), force_mavlink1=force_mavlink1)

class MAVLink_local_position_ned_cov_message(MAVLink_message):
        '''
        The filtered local position (e.g. fused computer vision and
        accelerometers). Coordinate frame is right-handed, Z-axis down
        (aeronautical frame, NED / north-east-down convention)
        '''
        id = MAVLINK_MSG_ID_LOCAL_POSITION_NED_COV
        name = 'LOCAL_POSITION_NED_COV'
        fieldnames = ['time_usec', 'estimator_type', 'x', 'y', 'z', 'vx', 'vy', 'vz', 'ax', 'ay', 'az', 'covariance']
        ordered_fieldnames = ['time_usec', 'x', 'y', 'z', 'vx', 'vy', 'vz', 'ax', 'ay', 'az', 'covariance', 'estimator_type']
        fieldtypes = ['uint64_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"estimator_type": "MAV_ESTIMATOR_TYPE"}
        fieldunits_by_name = {"time_usec": "us", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "ax": "m/s/s", "ay": "m/s/s", "az": "m/s/s"}
        format = '<Qfffffffff45fB'
        native_format = bytearray('<QffffffffffB', 'ascii')
        orders = [0, 11, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 45, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0]
        crc_extra = 191
        unpacker = struct.Struct('<Qfffffffff45fB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, estimator_type, x, y, z, vx, vy, vz, ax, ay, az, covariance):
                MAVLink_message.__init__(self, MAVLink_local_position_ned_cov_message.id, MAVLink_local_position_ned_cov_message.name)
                self._fieldnames = MAVLink_local_position_ned_cov_message.fieldnames
                self._instance_field = MAVLink_local_position_ned_cov_message.instance_field
                self._instance_offset = MAVLink_local_position_ned_cov_message.instance_offset
                self.time_usec = time_usec
                self.estimator_type = estimator_type
                self.x = x
                self.y = y
                self.z = z
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.ax = ax
                self.ay = ay
                self.az = az
                self.covariance = covariance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 191, struct.pack('<Qfffffffff45fB', self.time_usec, self.x, self.y, self.z, self.vx, self.vy, self.vz, self.ax, self.ay, self.az, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20], self.covariance[21], self.covariance[22], self.covariance[23], self.covariance[24], self.covariance[25], self.covariance[26], self.covariance[27], self.covariance[28], self.covariance[29], self.covariance[30], self.covariance[31], self.covariance[32], self.covariance[33], self.covariance[34], self.covariance[35], self.covariance[36], self.covariance[37], self.covariance[38], self.covariance[39], self.covariance[40], self.covariance[41], self.covariance[42], self.covariance[43], self.covariance[44], self.estimator_type), force_mavlink1=force_mavlink1)

class MAVLink_rc_channels_message(MAVLink_message):
        '''
        The PPM values of the RC channels received. The standard PPM
        modulation is as follows: 1000 microseconds: 0%, 2000
        microseconds: 100%.  A value of UINT16_MAX implies the channel
        is unused. Individual receivers/transmitters might violate
        this specification.
        '''
        id = MAVLINK_MSG_ID_RC_CHANNELS
        name = 'RC_CHANNELS'
        fieldnames = ['time_boot_ms', 'chancount', 'chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw', 'chan9_raw', 'chan10_raw', 'chan11_raw', 'chan12_raw', 'chan13_raw', 'chan14_raw', 'chan15_raw', 'chan16_raw', 'chan17_raw', 'chan18_raw', 'rssi']
        ordered_fieldnames = ['time_boot_ms', 'chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw', 'chan9_raw', 'chan10_raw', 'chan11_raw', 'chan12_raw', 'chan13_raw', 'chan14_raw', 'chan15_raw', 'chan16_raw', 'chan17_raw', 'chan18_raw', 'chancount', 'rssi']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us", "chan9_raw": "us", "chan10_raw": "us", "chan11_raw": "us", "chan12_raw": "us", "chan13_raw": "us", "chan14_raw": "us", "chan15_raw": "us", "chan16_raw": "us", "chan17_raw": "us", "chan18_raw": "us"}
        format = '<IHHHHHHHHHHHHHHHHHHBB'
        native_format = bytearray('<IHHHHHHHHHHHHHHHHHHBB', 'ascii')
        orders = [0, 19, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 118
        unpacker = struct.Struct('<IHHHHHHHHHHHHHHHHHHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, chancount, chan1_raw, chan2_raw, chan3_raw, chan4_raw, chan5_raw, chan6_raw, chan7_raw, chan8_raw, chan9_raw, chan10_raw, chan11_raw, chan12_raw, chan13_raw, chan14_raw, chan15_raw, chan16_raw, chan17_raw, chan18_raw, rssi):
                MAVLink_message.__init__(self, MAVLink_rc_channels_message.id, MAVLink_rc_channels_message.name)
                self._fieldnames = MAVLink_rc_channels_message.fieldnames
                self._instance_field = MAVLink_rc_channels_message.instance_field
                self._instance_offset = MAVLink_rc_channels_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.chancount = chancount
                self.chan1_raw = chan1_raw
                self.chan2_raw = chan2_raw
                self.chan3_raw = chan3_raw
                self.chan4_raw = chan4_raw
                self.chan5_raw = chan5_raw
                self.chan6_raw = chan6_raw
                self.chan7_raw = chan7_raw
                self.chan8_raw = chan8_raw
                self.chan9_raw = chan9_raw
                self.chan10_raw = chan10_raw
                self.chan11_raw = chan11_raw
                self.chan12_raw = chan12_raw
                self.chan13_raw = chan13_raw
                self.chan14_raw = chan14_raw
                self.chan15_raw = chan15_raw
                self.chan16_raw = chan16_raw
                self.chan17_raw = chan17_raw
                self.chan18_raw = chan18_raw
                self.rssi = rssi

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 118, struct.pack('<IHHHHHHHHHHHHHHHHHHBB', self.time_boot_ms, self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.chan9_raw, self.chan10_raw, self.chan11_raw, self.chan12_raw, self.chan13_raw, self.chan14_raw, self.chan15_raw, self.chan16_raw, self.chan17_raw, self.chan18_raw, self.chancount, self.rssi), force_mavlink1=force_mavlink1)

class MAVLink_request_data_stream_message(MAVLink_message):
        '''
        Request a data stream.
        '''
        id = MAVLINK_MSG_ID_REQUEST_DATA_STREAM
        name = 'REQUEST_DATA_STREAM'
        fieldnames = ['target_system', 'target_component', 'req_stream_id', 'req_message_rate', 'start_stop']
        ordered_fieldnames = ['req_message_rate', 'target_system', 'target_component', 'req_stream_id', 'start_stop']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"req_message_rate": "Hz"}
        format = '<HBBBB'
        native_format = bytearray('<HBBBB', 'ascii')
        orders = [1, 2, 3, 0, 4]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 148
        unpacker = struct.Struct('<HBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, req_stream_id, req_message_rate, start_stop):
                MAVLink_message.__init__(self, MAVLink_request_data_stream_message.id, MAVLink_request_data_stream_message.name)
                self._fieldnames = MAVLink_request_data_stream_message.fieldnames
                self._instance_field = MAVLink_request_data_stream_message.instance_field
                self._instance_offset = MAVLink_request_data_stream_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.req_stream_id = req_stream_id
                self.req_message_rate = req_message_rate
                self.start_stop = start_stop

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 148, struct.pack('<HBBBB', self.req_message_rate, self.target_system, self.target_component, self.req_stream_id, self.start_stop), force_mavlink1=force_mavlink1)

class MAVLink_data_stream_message(MAVLink_message):
        '''
        Data stream status information.
        '''
        id = MAVLINK_MSG_ID_DATA_STREAM
        name = 'DATA_STREAM'
        fieldnames = ['stream_id', 'message_rate', 'on_off']
        ordered_fieldnames = ['message_rate', 'stream_id', 'on_off']
        fieldtypes = ['uint8_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"message_rate": "Hz"}
        format = '<HBB'
        native_format = bytearray('<HBB', 'ascii')
        orders = [1, 0, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 21
        unpacker = struct.Struct('<HBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, stream_id, message_rate, on_off):
                MAVLink_message.__init__(self, MAVLink_data_stream_message.id, MAVLink_data_stream_message.name)
                self._fieldnames = MAVLink_data_stream_message.fieldnames
                self._instance_field = MAVLink_data_stream_message.instance_field
                self._instance_offset = MAVLink_data_stream_message.instance_offset
                self.stream_id = stream_id
                self.message_rate = message_rate
                self.on_off = on_off

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 21, struct.pack('<HBB', self.message_rate, self.stream_id, self.on_off), force_mavlink1=force_mavlink1)

class MAVLink_manual_control_message(MAVLink_message):
        '''
        This message provides an API for manually controlling the
        vehicle using standard joystick axes nomenclature, along with
        a joystick-like input device. Unused axes can be disabled an
        buttons are also transmit as boolean values of their
        '''
        id = MAVLINK_MSG_ID_MANUAL_CONTROL
        name = 'MANUAL_CONTROL'
        fieldnames = ['target', 'x', 'y', 'z', 'r', 'buttons']
        ordered_fieldnames = ['x', 'y', 'z', 'r', 'buttons', 'target']
        fieldtypes = ['uint8_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<hhhhHB'
        native_format = bytearray('<hhhhHB', 'ascii')
        orders = [5, 0, 1, 2, 3, 4]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 243
        unpacker = struct.Struct('<hhhhHB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target, x, y, z, r, buttons):
                MAVLink_message.__init__(self, MAVLink_manual_control_message.id, MAVLink_manual_control_message.name)
                self._fieldnames = MAVLink_manual_control_message.fieldnames
                self._instance_field = MAVLink_manual_control_message.instance_field
                self._instance_offset = MAVLink_manual_control_message.instance_offset
                self.target = target
                self.x = x
                self.y = y
                self.z = z
                self.r = r
                self.buttons = buttons

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 243, struct.pack('<hhhhHB', self.x, self.y, self.z, self.r, self.buttons, self.target), force_mavlink1=force_mavlink1)

class MAVLink_rc_channels_override_message(MAVLink_message):
        '''
        The RAW values of the RC channels sent to the MAV to override
        info received from the RC radio. The standard PPM modulation
        is as follows: 1000 microseconds: 0%, 2000 microseconds: 100%.
        Individual receivers/transmitters might violate this
        specification.  Note carefully the semantic differences
        between the first 8 channels and the subsequent channels
        '''
        id = MAVLINK_MSG_ID_RC_CHANNELS_OVERRIDE
        name = 'RC_CHANNELS_OVERRIDE'
        fieldnames = ['target_system', 'target_component', 'chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw']
        ordered_fieldnames = ['chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us"}
        format = '<HHHHHHHHBB'
        native_format = bytearray('<HHHHHHHHBB', 'ascii')
        orders = [8, 9, 0, 1, 2, 3, 4, 5, 6, 7]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 124
        unpacker = struct.Struct('<HHHHHHHHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, chan1_raw, chan2_raw, chan3_raw, chan4_raw, chan5_raw, chan6_raw, chan7_raw, chan8_raw):
                MAVLink_message.__init__(self, MAVLink_rc_channels_override_message.id, MAVLink_rc_channels_override_message.name)
                self._fieldnames = MAVLink_rc_channels_override_message.fieldnames
                self._instance_field = MAVLink_rc_channels_override_message.instance_field
                self._instance_offset = MAVLink_rc_channels_override_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.chan1_raw = chan1_raw
                self.chan2_raw = chan2_raw
                self.chan3_raw = chan3_raw
                self.chan4_raw = chan4_raw
                self.chan5_raw = chan5_raw
                self.chan6_raw = chan6_raw
                self.chan7_raw = chan7_raw
                self.chan8_raw = chan8_raw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 124, struct.pack('<HHHHHHHHBB', self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_mission_item_int_message(MAVLink_message):
        '''
        Message encoding a mission item. This message is emitted to
        announce                 the presence of a mission item and to
        set a mission item on the system. The mission item can be
        either in x, y, z meters (type: LOCAL) or x:lat, y:lon,
        z:altitude. Local frame is Z-down, right handed (NED), global
        frame is Z-up, right handed (ENU). NaN or INT32_MAX may be
        used in float/integer params (respectively) to indicate
        optional/default values (e.g. to use the component's current
        latitude, yaw rather than a specific value). See also
        https://mavlink.io/en/services/mission.html.
        '''
        id = MAVLINK_MSG_ID_MISSION_ITEM_INT
        name = 'MISSION_ITEM_INT'
        fieldnames = ['target_system', 'target_component', 'seq', 'frame', 'command', 'current', 'autocontinue', 'param1', 'param2', 'param3', 'param4', 'x', 'y', 'z']
        ordered_fieldnames = ['param1', 'param2', 'param3', 'param4', 'x', 'y', 'z', 'seq', 'command', 'target_system', 'target_component', 'frame', 'current', 'autocontinue']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t', 'uint8_t', 'uint16_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'int32_t', 'int32_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"frame": "MAV_FRAME", "command": "MAV_CMD"}
        fieldunits_by_name = {}
        format = '<ffffiifHHBBBBB'
        native_format = bytearray('<ffffiifHHBBBBB', 'ascii')
        orders = [9, 10, 7, 11, 8, 12, 13, 0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 38
        unpacker = struct.Struct('<ffffiifHHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, seq, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z):
                MAVLink_message.__init__(self, MAVLink_mission_item_int_message.id, MAVLink_mission_item_int_message.name)
                self._fieldnames = MAVLink_mission_item_int_message.fieldnames
                self._instance_field = MAVLink_mission_item_int_message.instance_field
                self._instance_offset = MAVLink_mission_item_int_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.seq = seq
                self.frame = frame
                self.command = command
                self.current = current
                self.autocontinue = autocontinue
                self.param1 = param1
                self.param2 = param2
                self.param3 = param3
                self.param4 = param4
                self.x = x
                self.y = y
                self.z = z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 38, struct.pack('<ffffiifHHBBBBB', self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.seq, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue), force_mavlink1=force_mavlink1)

class MAVLink_vfr_hud_message(MAVLink_message):
        '''
        Metrics typically displayed on a HUD for fixed wing aircraft.
        '''
        id = MAVLINK_MSG_ID_VFR_HUD
        name = 'VFR_HUD'
        fieldnames = ['airspeed', 'groundspeed', 'heading', 'throttle', 'alt', 'climb']
        ordered_fieldnames = ['airspeed', 'groundspeed', 'alt', 'climb', 'heading', 'throttle']
        fieldtypes = ['float', 'float', 'int16_t', 'uint16_t', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"airspeed": "m/s", "groundspeed": "m/s", "heading": "deg", "throttle": "%", "alt": "m", "climb": "m/s"}
        format = '<ffffhH'
        native_format = bytearray('<ffffhH', 'ascii')
        orders = [0, 1, 4, 5, 2, 3]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 20
        unpacker = struct.Struct('<ffffhH')
        instance_field = None
        instance_offset = -1

        def __init__(self, airspeed, groundspeed, heading, throttle, alt, climb):
                MAVLink_message.__init__(self, MAVLink_vfr_hud_message.id, MAVLink_vfr_hud_message.name)
                self._fieldnames = MAVLink_vfr_hud_message.fieldnames
                self._instance_field = MAVLink_vfr_hud_message.instance_field
                self._instance_offset = MAVLink_vfr_hud_message.instance_offset
                self.airspeed = airspeed
                self.groundspeed = groundspeed
                self.heading = heading
                self.throttle = throttle
                self.alt = alt
                self.climb = climb

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 20, struct.pack('<ffffhH', self.airspeed, self.groundspeed, self.alt, self.climb, self.heading, self.throttle), force_mavlink1=force_mavlink1)

class MAVLink_command_int_message(MAVLink_message):
        '''
        Message encoding a command with parameters as scaled integers.
        Scaling depends on the actual command value. The command
        microservice is documented at
        https://mavlink.io/en/services/command.html
        '''
        id = MAVLINK_MSG_ID_COMMAND_INT
        name = 'COMMAND_INT'
        fieldnames = ['target_system', 'target_component', 'frame', 'command', 'current', 'autocontinue', 'param1', 'param2', 'param3', 'param4', 'x', 'y', 'z']
        ordered_fieldnames = ['param1', 'param2', 'param3', 'param4', 'x', 'y', 'z', 'command', 'target_system', 'target_component', 'frame', 'current', 'autocontinue']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'int32_t', 'int32_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"frame": "MAV_FRAME", "command": "MAV_CMD"}
        fieldunits_by_name = {}
        format = '<ffffiifHBBBBB'
        native_format = bytearray('<ffffiifHBBBBB', 'ascii')
        orders = [8, 9, 10, 7, 11, 12, 0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 158
        unpacker = struct.Struct('<ffffiifHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z):
                MAVLink_message.__init__(self, MAVLink_command_int_message.id, MAVLink_command_int_message.name)
                self._fieldnames = MAVLink_command_int_message.fieldnames
                self._instance_field = MAVLink_command_int_message.instance_field
                self._instance_offset = MAVLink_command_int_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.frame = frame
                self.command = command
                self.current = current
                self.autocontinue = autocontinue
                self.param1 = param1
                self.param2 = param2
                self.param3 = param3
                self.param4 = param4
                self.x = x
                self.y = y
                self.z = z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 158, struct.pack('<ffffiifHBBBBB', self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue), force_mavlink1=force_mavlink1)

class MAVLink_command_long_message(MAVLink_message):
        '''
        Send a command with up to seven parameters to the MAV. The
        command microservice is documented at
        https://mavlink.io/en/services/command.html
        '''
        id = MAVLINK_MSG_ID_COMMAND_LONG
        name = 'COMMAND_LONG'
        fieldnames = ['target_system', 'target_component', 'command', 'confirmation', 'param1', 'param2', 'param3', 'param4', 'param5', 'param6', 'param7']
        ordered_fieldnames = ['param1', 'param2', 'param3', 'param4', 'param5', 'param6', 'param7', 'command', 'target_system', 'target_component', 'confirmation']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"command": "MAV_CMD"}
        fieldunits_by_name = {}
        format = '<fffffffHBBB'
        native_format = bytearray('<fffffffHBBB', 'ascii')
        orders = [8, 9, 7, 10, 0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 152
        unpacker = struct.Struct('<fffffffHBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, command, confirmation, param1, param2, param3, param4, param5, param6, param7):
                MAVLink_message.__init__(self, MAVLink_command_long_message.id, MAVLink_command_long_message.name)
                self._fieldnames = MAVLink_command_long_message.fieldnames
                self._instance_field = MAVLink_command_long_message.instance_field
                self._instance_offset = MAVLink_command_long_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.command = command
                self.confirmation = confirmation
                self.param1 = param1
                self.param2 = param2
                self.param3 = param3
                self.param4 = param4
                self.param5 = param5
                self.param6 = param6
                self.param7 = param7

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 152, struct.pack('<fffffffHBBB', self.param1, self.param2, self.param3, self.param4, self.param5, self.param6, self.param7, self.command, self.target_system, self.target_component, self.confirmation), force_mavlink1=force_mavlink1)

class MAVLink_command_ack_message(MAVLink_message):
        '''
        Report status of a command. Includes feedback whether the
        command was executed. The command microservice is documented
        at https://mavlink.io/en/services/command.html
        '''
        id = MAVLINK_MSG_ID_COMMAND_ACK
        name = 'COMMAND_ACK'
        fieldnames = ['command', 'result']
        ordered_fieldnames = ['command', 'result']
        fieldtypes = ['uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"command": "MAV_CMD", "result": "MAV_RESULT"}
        fieldunits_by_name = {}
        format = '<HB'
        native_format = bytearray('<HB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 143
        unpacker = struct.Struct('<HB')
        instance_field = None
        instance_offset = -1

        def __init__(self, command, result):
                MAVLink_message.__init__(self, MAVLink_command_ack_message.id, MAVLink_command_ack_message.name)
                self._fieldnames = MAVLink_command_ack_message.fieldnames
                self._instance_field = MAVLink_command_ack_message.instance_field
                self._instance_offset = MAVLink_command_ack_message.instance_offset
                self.command = command
                self.result = result

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 143, struct.pack('<HB', self.command, self.result), force_mavlink1=force_mavlink1)

class MAVLink_manual_setpoint_message(MAVLink_message):
        '''
        Setpoint in roll, pitch, yaw and thrust from the operator
        '''
        id = MAVLINK_MSG_ID_MANUAL_SETPOINT
        name = 'MANUAL_SETPOINT'
        fieldnames = ['time_boot_ms', 'roll', 'pitch', 'yaw', 'thrust', 'mode_switch', 'manual_override_switch']
        ordered_fieldnames = ['time_boot_ms', 'roll', 'pitch', 'yaw', 'thrust', 'mode_switch', 'manual_override_switch']
        fieldtypes = ['uint32_t', 'float', 'float', 'float', 'float', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "roll": "rad/s", "pitch": "rad/s", "yaw": "rad/s"}
        format = '<IffffBB'
        native_format = bytearray('<IffffBB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 106
        unpacker = struct.Struct('<IffffBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, roll, pitch, yaw, thrust, mode_switch, manual_override_switch):
                MAVLink_message.__init__(self, MAVLink_manual_setpoint_message.id, MAVLink_manual_setpoint_message.name)
                self._fieldnames = MAVLink_manual_setpoint_message.fieldnames
                self._instance_field = MAVLink_manual_setpoint_message.instance_field
                self._instance_offset = MAVLink_manual_setpoint_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.thrust = thrust
                self.mode_switch = mode_switch
                self.manual_override_switch = manual_override_switch

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 106, struct.pack('<IffffBB', self.time_boot_ms, self.roll, self.pitch, self.yaw, self.thrust, self.mode_switch, self.manual_override_switch), force_mavlink1=force_mavlink1)

class MAVLink_set_attitude_target_message(MAVLink_message):
        '''
        Sets a desired vehicle attitude. Used by an external
        controller to command the vehicle (manual controller or other
        system).
        '''
        id = MAVLINK_MSG_ID_SET_ATTITUDE_TARGET
        name = 'SET_ATTITUDE_TARGET'
        fieldnames = ['time_boot_ms', 'target_system', 'target_component', 'type_mask', 'q', 'body_roll_rate', 'body_pitch_rate', 'body_yaw_rate', 'thrust']
        ordered_fieldnames = ['time_boot_ms', 'q', 'body_roll_rate', 'body_pitch_rate', 'body_yaw_rate', 'thrust', 'target_system', 'target_component', 'type_mask']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"type_mask": "bitmask"}
        fieldenums_by_name = {"type_mask": "ATTITUDE_TARGET_TYPEMASK"}
        fieldunits_by_name = {"time_boot_ms": "ms", "body_roll_rate": "rad/s", "body_pitch_rate": "rad/s", "body_yaw_rate": "rad/s"}
        format = '<I4fffffBBB'
        native_format = bytearray('<IfffffBBB', 'ascii')
        orders = [0, 6, 7, 8, 1, 2, 3, 4, 5]
        lengths = [1, 4, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 4, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 49
        unpacker = struct.Struct('<I4fffffBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, target_system, target_component, type_mask, q, body_roll_rate, body_pitch_rate, body_yaw_rate, thrust):
                MAVLink_message.__init__(self, MAVLink_set_attitude_target_message.id, MAVLink_set_attitude_target_message.name)
                self._fieldnames = MAVLink_set_attitude_target_message.fieldnames
                self._instance_field = MAVLink_set_attitude_target_message.instance_field
                self._instance_offset = MAVLink_set_attitude_target_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.target_system = target_system
                self.target_component = target_component
                self.type_mask = type_mask
                self.q = q
                self.body_roll_rate = body_roll_rate
                self.body_pitch_rate = body_pitch_rate
                self.body_yaw_rate = body_yaw_rate
                self.thrust = thrust

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 49, struct.pack('<I4fffffBBB', self.time_boot_ms, self.q[0], self.q[1], self.q[2], self.q[3], self.body_roll_rate, self.body_pitch_rate, self.body_yaw_rate, self.thrust, self.target_system, self.target_component, self.type_mask), force_mavlink1=force_mavlink1)

class MAVLink_attitude_target_message(MAVLink_message):
        '''
        Reports the current commanded attitude of the vehicle as
        specified by the autopilot. This should match the commands
        sent in a SET_ATTITUDE_TARGET message if the vehicle is being
        controlled this way.
        '''
        id = MAVLINK_MSG_ID_ATTITUDE_TARGET
        name = 'ATTITUDE_TARGET'
        fieldnames = ['time_boot_ms', 'type_mask', 'q', 'body_roll_rate', 'body_pitch_rate', 'body_yaw_rate', 'thrust']
        ordered_fieldnames = ['time_boot_ms', 'q', 'body_roll_rate', 'body_pitch_rate', 'body_yaw_rate', 'thrust', 'type_mask']
        fieldtypes = ['uint32_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"type_mask": "bitmask"}
        fieldenums_by_name = {"type_mask": "ATTITUDE_TARGET_TYPEMASK"}
        fieldunits_by_name = {"time_boot_ms": "ms", "body_roll_rate": "rad/s", "body_pitch_rate": "rad/s", "body_yaw_rate": "rad/s"}
        format = '<I4fffffB'
        native_format = bytearray('<IfffffB', 'ascii')
        orders = [0, 6, 1, 2, 3, 4, 5]
        lengths = [1, 4, 1, 1, 1, 1, 1]
        array_lengths = [0, 4, 0, 0, 0, 0, 0]
        crc_extra = 22
        unpacker = struct.Struct('<I4fffffB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, type_mask, q, body_roll_rate, body_pitch_rate, body_yaw_rate, thrust):
                MAVLink_message.__init__(self, MAVLink_attitude_target_message.id, MAVLink_attitude_target_message.name)
                self._fieldnames = MAVLink_attitude_target_message.fieldnames
                self._instance_field = MAVLink_attitude_target_message.instance_field
                self._instance_offset = MAVLink_attitude_target_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.type_mask = type_mask
                self.q = q
                self.body_roll_rate = body_roll_rate
                self.body_pitch_rate = body_pitch_rate
                self.body_yaw_rate = body_yaw_rate
                self.thrust = thrust

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 22, struct.pack('<I4fffffB', self.time_boot_ms, self.q[0], self.q[1], self.q[2], self.q[3], self.body_roll_rate, self.body_pitch_rate, self.body_yaw_rate, self.thrust, self.type_mask), force_mavlink1=force_mavlink1)

class MAVLink_set_position_target_local_ned_message(MAVLink_message):
        '''
        Sets a desired vehicle position in a local north-east-down
        coordinate frame. Used by an external controller to command
        the vehicle (manual controller or other system).
        '''
        id = MAVLINK_MSG_ID_SET_POSITION_TARGET_LOCAL_NED
        name = 'SET_POSITION_TARGET_LOCAL_NED'
        fieldnames = ['time_boot_ms', 'target_system', 'target_component', 'coordinate_frame', 'type_mask', 'x', 'y', 'z', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate']
        ordered_fieldnames = ['time_boot_ms', 'x', 'y', 'z', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate', 'type_mask', 'target_system', 'target_component', 'coordinate_frame']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"type_mask": "bitmask"}
        fieldenums_by_name = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
        fieldunits_by_name = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
        format = '<IfffffffffffHBBB'
        native_format = bytearray('<IfffffffffffHBBB', 'ascii')
        orders = [0, 13, 14, 15, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 143
        unpacker = struct.Struct('<IfffffffffffHBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, target_system, target_component, coordinate_frame, type_mask, x, y, z, vx, vy, vz, afx, afy, afz, yaw, yaw_rate):
                MAVLink_message.__init__(self, MAVLink_set_position_target_local_ned_message.id, MAVLink_set_position_target_local_ned_message.name)
                self._fieldnames = MAVLink_set_position_target_local_ned_message.fieldnames
                self._instance_field = MAVLink_set_position_target_local_ned_message.instance_field
                self._instance_offset = MAVLink_set_position_target_local_ned_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.target_system = target_system
                self.target_component = target_component
                self.coordinate_frame = coordinate_frame
                self.type_mask = type_mask
                self.x = x
                self.y = y
                self.z = z
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.afx = afx
                self.afy = afy
                self.afz = afz
                self.yaw = yaw
                self.yaw_rate = yaw_rate

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 143, struct.pack('<IfffffffffffHBBB', self.time_boot_ms, self.x, self.y, self.z, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.target_system, self.target_component, self.coordinate_frame), force_mavlink1=force_mavlink1)

class MAVLink_position_target_local_ned_message(MAVLink_message):
        '''
        Reports the current commanded vehicle position, velocity, and
        acceleration as specified by the autopilot. This should match
        the commands sent in SET_POSITION_TARGET_LOCAL_NED if the
        vehicle is being controlled this way.
        '''
        id = MAVLINK_MSG_ID_POSITION_TARGET_LOCAL_NED
        name = 'POSITION_TARGET_LOCAL_NED'
        fieldnames = ['time_boot_ms', 'coordinate_frame', 'type_mask', 'x', 'y', 'z', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate']
        ordered_fieldnames = ['time_boot_ms', 'x', 'y', 'z', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate', 'type_mask', 'coordinate_frame']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint16_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"type_mask": "bitmask"}
        fieldenums_by_name = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
        fieldunits_by_name = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
        format = '<IfffffffffffHB'
        native_format = bytearray('<IfffffffffffHB', 'ascii')
        orders = [0, 13, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 140
        unpacker = struct.Struct('<IfffffffffffHB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, coordinate_frame, type_mask, x, y, z, vx, vy, vz, afx, afy, afz, yaw, yaw_rate):
                MAVLink_message.__init__(self, MAVLink_position_target_local_ned_message.id, MAVLink_position_target_local_ned_message.name)
                self._fieldnames = MAVLink_position_target_local_ned_message.fieldnames
                self._instance_field = MAVLink_position_target_local_ned_message.instance_field
                self._instance_offset = MAVLink_position_target_local_ned_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.coordinate_frame = coordinate_frame
                self.type_mask = type_mask
                self.x = x
                self.y = y
                self.z = z
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.afx = afx
                self.afy = afy
                self.afz = afz
                self.yaw = yaw
                self.yaw_rate = yaw_rate

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 140, struct.pack('<IfffffffffffHB', self.time_boot_ms, self.x, self.y, self.z, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.coordinate_frame), force_mavlink1=force_mavlink1)

class MAVLink_set_position_target_global_int_message(MAVLink_message):
        '''
        Sets a desired vehicle position, velocity, and/or acceleration
        in a global coordinate system (WGS84). Used by an external
        controller to command the vehicle (manual controller or other
        system).
        '''
        id = MAVLINK_MSG_ID_SET_POSITION_TARGET_GLOBAL_INT
        name = 'SET_POSITION_TARGET_GLOBAL_INT'
        fieldnames = ['time_boot_ms', 'target_system', 'target_component', 'coordinate_frame', 'type_mask', 'lat_int', 'lon_int', 'alt', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate']
        ordered_fieldnames = ['time_boot_ms', 'lat_int', 'lon_int', 'alt', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate', 'type_mask', 'target_system', 'target_component', 'coordinate_frame']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"type_mask": "bitmask"}
        fieldenums_by_name = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
        fieldunits_by_name = {"time_boot_ms": "ms", "lat_int": "degE7", "lon_int": "degE7", "alt": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
        format = '<IiifffffffffHBBB'
        native_format = bytearray('<IiifffffffffHBBB', 'ascii')
        orders = [0, 13, 14, 15, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 5
        unpacker = struct.Struct('<IiifffffffffHBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, target_system, target_component, coordinate_frame, type_mask, lat_int, lon_int, alt, vx, vy, vz, afx, afy, afz, yaw, yaw_rate):
                MAVLink_message.__init__(self, MAVLink_set_position_target_global_int_message.id, MAVLink_set_position_target_global_int_message.name)
                self._fieldnames = MAVLink_set_position_target_global_int_message.fieldnames
                self._instance_field = MAVLink_set_position_target_global_int_message.instance_field
                self._instance_offset = MAVLink_set_position_target_global_int_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.target_system = target_system
                self.target_component = target_component
                self.coordinate_frame = coordinate_frame
                self.type_mask = type_mask
                self.lat_int = lat_int
                self.lon_int = lon_int
                self.alt = alt
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.afx = afx
                self.afy = afy
                self.afz = afz
                self.yaw = yaw
                self.yaw_rate = yaw_rate

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 5, struct.pack('<IiifffffffffHBBB', self.time_boot_ms, self.lat_int, self.lon_int, self.alt, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.target_system, self.target_component, self.coordinate_frame), force_mavlink1=force_mavlink1)

class MAVLink_position_target_global_int_message(MAVLink_message):
        '''
        Reports the current commanded vehicle position, velocity, and
        acceleration as specified by the autopilot. This should match
        the commands sent in SET_POSITION_TARGET_GLOBAL_INT if the
        vehicle is being controlled this way.
        '''
        id = MAVLINK_MSG_ID_POSITION_TARGET_GLOBAL_INT
        name = 'POSITION_TARGET_GLOBAL_INT'
        fieldnames = ['time_boot_ms', 'coordinate_frame', 'type_mask', 'lat_int', 'lon_int', 'alt', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate']
        ordered_fieldnames = ['time_boot_ms', 'lat_int', 'lon_int', 'alt', 'vx', 'vy', 'vz', 'afx', 'afy', 'afz', 'yaw', 'yaw_rate', 'type_mask', 'coordinate_frame']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint16_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"type_mask": "bitmask"}
        fieldenums_by_name = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
        fieldunits_by_name = {"time_boot_ms": "ms", "lat_int": "degE7", "lon_int": "degE7", "alt": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
        format = '<IiifffffffffHB'
        native_format = bytearray('<IiifffffffffHB', 'ascii')
        orders = [0, 13, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 150
        unpacker = struct.Struct('<IiifffffffffHB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, coordinate_frame, type_mask, lat_int, lon_int, alt, vx, vy, vz, afx, afy, afz, yaw, yaw_rate):
                MAVLink_message.__init__(self, MAVLink_position_target_global_int_message.id, MAVLink_position_target_global_int_message.name)
                self._fieldnames = MAVLink_position_target_global_int_message.fieldnames
                self._instance_field = MAVLink_position_target_global_int_message.instance_field
                self._instance_offset = MAVLink_position_target_global_int_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.coordinate_frame = coordinate_frame
                self.type_mask = type_mask
                self.lat_int = lat_int
                self.lon_int = lon_int
                self.alt = alt
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.afx = afx
                self.afy = afy
                self.afz = afz
                self.yaw = yaw
                self.yaw_rate = yaw_rate

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 150, struct.pack('<IiifffffffffHB', self.time_boot_ms, self.lat_int, self.lon_int, self.alt, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.coordinate_frame), force_mavlink1=force_mavlink1)

class MAVLink_local_position_ned_system_global_offset_message(MAVLink_message):
        '''
        The offset in X, Y, Z and yaw between the LOCAL_POSITION_NED
        messages of MAV X and the global coordinate frame in NED
        coordinates. Coordinate frame is right-handed, Z-axis down
        (aeronautical frame, NED / north-east-down convention)
        '''
        id = MAVLINK_MSG_ID_LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET
        name = 'LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET'
        fieldnames = ['time_boot_ms', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        ordered_fieldnames = ['time_boot_ms', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        fieldtypes = ['uint32_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
        format = '<Iffffff'
        native_format = bytearray('<Iffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 231
        unpacker = struct.Struct('<Iffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, x, y, z, roll, pitch, yaw):
                MAVLink_message.__init__(self, MAVLink_local_position_ned_system_global_offset_message.id, MAVLink_local_position_ned_system_global_offset_message.name)
                self._fieldnames = MAVLink_local_position_ned_system_global_offset_message.fieldnames
                self._instance_field = MAVLink_local_position_ned_system_global_offset_message.instance_field
                self._instance_offset = MAVLink_local_position_ned_system_global_offset_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.x = x
                self.y = y
                self.z = z
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 231, struct.pack('<Iffffff', self.time_boot_ms, self.x, self.y, self.z, self.roll, self.pitch, self.yaw), force_mavlink1=force_mavlink1)

class MAVLink_hil_state_message(MAVLink_message):
        '''
        Sent from simulation to autopilot. This packet is useful for
        high throughput applications such as hardware in the loop
        simulations.
        '''
        id = MAVLINK_MSG_ID_HIL_STATE
        name = 'HIL_STATE'
        fieldnames = ['time_usec', 'roll', 'pitch', 'yaw', 'rollspeed', 'pitchspeed', 'yawspeed', 'lat', 'lon', 'alt', 'vx', 'vy', 'vz', 'xacc', 'yacc', 'zacc']
        ordered_fieldnames = ['time_usec', 'roll', 'pitch', 'yaw', 'rollspeed', 'pitchspeed', 'yawspeed', 'lat', 'lon', 'alt', 'vx', 'vy', 'vz', 'xacc', 'yacc', 'zacc']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float', 'int32_t', 'int32_t', 'int32_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "roll": "rad", "pitch": "rad", "yaw": "rad", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s", "lat": "degE7", "lon": "degE7", "alt": "mm", "vx": "cm/s", "vy": "cm/s", "vz": "cm/s", "xacc": "mG", "yacc": "mG", "zacc": "mG"}
        format = '<Qffffffiiihhhhhh'
        native_format = bytearray('<Qffffffiiihhhhhh', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 183
        unpacker = struct.Struct('<Qffffffiiihhhhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, roll, pitch, yaw, rollspeed, pitchspeed, yawspeed, lat, lon, alt, vx, vy, vz, xacc, yacc, zacc):
                MAVLink_message.__init__(self, MAVLink_hil_state_message.id, MAVLink_hil_state_message.name)
                self._fieldnames = MAVLink_hil_state_message.fieldnames
                self._instance_field = MAVLink_hil_state_message.instance_field
                self._instance_offset = MAVLink_hil_state_message.instance_offset
                self.time_usec = time_usec
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.rollspeed = rollspeed
                self.pitchspeed = pitchspeed
                self.yawspeed = yawspeed
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 183, struct.pack('<Qffffffiiihhhhhh', self.time_usec, self.roll, self.pitch, self.yaw, self.rollspeed, self.pitchspeed, self.yawspeed, self.lat, self.lon, self.alt, self.vx, self.vy, self.vz, self.xacc, self.yacc, self.zacc), force_mavlink1=force_mavlink1)

class MAVLink_hil_controls_message(MAVLink_message):
        '''
        Sent from autopilot to simulation. Hardware in the loop
        control outputs
        '''
        id = MAVLINK_MSG_ID_HIL_CONTROLS
        name = 'HIL_CONTROLS'
        fieldnames = ['time_usec', 'roll_ailerons', 'pitch_elevator', 'yaw_rudder', 'throttle', 'aux1', 'aux2', 'aux3', 'aux4', 'mode', 'nav_mode']
        ordered_fieldnames = ['time_usec', 'roll_ailerons', 'pitch_elevator', 'yaw_rudder', 'throttle', 'aux1', 'aux2', 'aux3', 'aux4', 'mode', 'nav_mode']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"mode": "MAV_MODE"}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<QffffffffBB'
        native_format = bytearray('<QffffffffBB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 63
        unpacker = struct.Struct('<QffffffffBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, roll_ailerons, pitch_elevator, yaw_rudder, throttle, aux1, aux2, aux3, aux4, mode, nav_mode):
                MAVLink_message.__init__(self, MAVLink_hil_controls_message.id, MAVLink_hil_controls_message.name)
                self._fieldnames = MAVLink_hil_controls_message.fieldnames
                self._instance_field = MAVLink_hil_controls_message.instance_field
                self._instance_offset = MAVLink_hil_controls_message.instance_offset
                self.time_usec = time_usec
                self.roll_ailerons = roll_ailerons
                self.pitch_elevator = pitch_elevator
                self.yaw_rudder = yaw_rudder
                self.throttle = throttle
                self.aux1 = aux1
                self.aux2 = aux2
                self.aux3 = aux3
                self.aux4 = aux4
                self.mode = mode
                self.nav_mode = nav_mode

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 63, struct.pack('<QffffffffBB', self.time_usec, self.roll_ailerons, self.pitch_elevator, self.yaw_rudder, self.throttle, self.aux1, self.aux2, self.aux3, self.aux4, self.mode, self.nav_mode), force_mavlink1=force_mavlink1)

class MAVLink_hil_rc_inputs_raw_message(MAVLink_message):
        '''
        Sent from simulation to autopilot. The RAW values of the RC
        channels received. The standard PPM modulation is as follows:
        1000 microseconds: 0%, 2000 microseconds: 100%. Individual
        receivers/transmitters might violate this specification.
        '''
        id = MAVLINK_MSG_ID_HIL_RC_INPUTS_RAW
        name = 'HIL_RC_INPUTS_RAW'
        fieldnames = ['time_usec', 'chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw', 'chan9_raw', 'chan10_raw', 'chan11_raw', 'chan12_raw', 'rssi']
        ordered_fieldnames = ['time_usec', 'chan1_raw', 'chan2_raw', 'chan3_raw', 'chan4_raw', 'chan5_raw', 'chan6_raw', 'chan7_raw', 'chan8_raw', 'chan9_raw', 'chan10_raw', 'chan11_raw', 'chan12_raw', 'rssi']
        fieldtypes = ['uint64_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us", "chan9_raw": "us", "chan10_raw": "us", "chan11_raw": "us", "chan12_raw": "us"}
        format = '<QHHHHHHHHHHHHB'
        native_format = bytearray('<QHHHHHHHHHHHHB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 54
        unpacker = struct.Struct('<QHHHHHHHHHHHHB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, chan1_raw, chan2_raw, chan3_raw, chan4_raw, chan5_raw, chan6_raw, chan7_raw, chan8_raw, chan9_raw, chan10_raw, chan11_raw, chan12_raw, rssi):
                MAVLink_message.__init__(self, MAVLink_hil_rc_inputs_raw_message.id, MAVLink_hil_rc_inputs_raw_message.name)
                self._fieldnames = MAVLink_hil_rc_inputs_raw_message.fieldnames
                self._instance_field = MAVLink_hil_rc_inputs_raw_message.instance_field
                self._instance_offset = MAVLink_hil_rc_inputs_raw_message.instance_offset
                self.time_usec = time_usec
                self.chan1_raw = chan1_raw
                self.chan2_raw = chan2_raw
                self.chan3_raw = chan3_raw
                self.chan4_raw = chan4_raw
                self.chan5_raw = chan5_raw
                self.chan6_raw = chan6_raw
                self.chan7_raw = chan7_raw
                self.chan8_raw = chan8_raw
                self.chan9_raw = chan9_raw
                self.chan10_raw = chan10_raw
                self.chan11_raw = chan11_raw
                self.chan12_raw = chan12_raw
                self.rssi = rssi

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 54, struct.pack('<QHHHHHHHHHHHHB', self.time_usec, self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.chan9_raw, self.chan10_raw, self.chan11_raw, self.chan12_raw, self.rssi), force_mavlink1=force_mavlink1)

class MAVLink_hil_actuator_controls_message(MAVLink_message):
        '''
        Sent from autopilot to simulation. Hardware in the loop
        control outputs (replacement for HIL_CONTROLS)
        '''
        id = MAVLINK_MSG_ID_HIL_ACTUATOR_CONTROLS
        name = 'HIL_ACTUATOR_CONTROLS'
        fieldnames = ['time_usec', 'controls', 'mode', 'flags']
        ordered_fieldnames = ['time_usec', 'flags', 'controls', 'mode']
        fieldtypes = ['uint64_t', 'float', 'uint8_t', 'uint64_t']
        fielddisplays_by_name = {"mode": "bitmask", "flags": "bitmask"}
        fieldenums_by_name = {"mode": "MAV_MODE_FLAG"}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<QQ16fB'
        native_format = bytearray('<QQfB', 'ascii')
        orders = [0, 2, 3, 1]
        lengths = [1, 1, 16, 1]
        array_lengths = [0, 0, 16, 0]
        crc_extra = 47
        unpacker = struct.Struct('<QQ16fB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, controls, mode, flags):
                MAVLink_message.__init__(self, MAVLink_hil_actuator_controls_message.id, MAVLink_hil_actuator_controls_message.name)
                self._fieldnames = MAVLink_hil_actuator_controls_message.fieldnames
                self._instance_field = MAVLink_hil_actuator_controls_message.instance_field
                self._instance_offset = MAVLink_hil_actuator_controls_message.instance_offset
                self.time_usec = time_usec
                self.controls = controls
                self.mode = mode
                self.flags = flags

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 47, struct.pack('<QQ16fB', self.time_usec, self.flags, self.controls[0], self.controls[1], self.controls[2], self.controls[3], self.controls[4], self.controls[5], self.controls[6], self.controls[7], self.controls[8], self.controls[9], self.controls[10], self.controls[11], self.controls[12], self.controls[13], self.controls[14], self.controls[15], self.mode), force_mavlink1=force_mavlink1)

class MAVLink_optical_flow_message(MAVLink_message):
        '''
        Optical flow from a flow sensor (e.g. optical mouse sensor)
        '''
        id = MAVLINK_MSG_ID_OPTICAL_FLOW
        name = 'OPTICAL_FLOW'
        fieldnames = ['time_usec', 'sensor_id', 'flow_x', 'flow_y', 'flow_comp_m_x', 'flow_comp_m_y', 'quality', 'ground_distance']
        ordered_fieldnames = ['time_usec', 'flow_comp_m_x', 'flow_comp_m_y', 'ground_distance', 'flow_x', 'flow_y', 'sensor_id', 'quality']
        fieldtypes = ['uint64_t', 'uint8_t', 'int16_t', 'int16_t', 'float', 'float', 'uint8_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "flow_x": "dpix", "flow_y": "dpix", "flow_comp_m_x": "m/s", "flow_comp_m_y": "m/s", "ground_distance": "m"}
        format = '<QfffhhBB'
        native_format = bytearray('<QfffhhBB', 'ascii')
        orders = [0, 6, 4, 5, 1, 2, 7, 3]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 175
        unpacker = struct.Struct('<QfffhhBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, sensor_id, flow_x, flow_y, flow_comp_m_x, flow_comp_m_y, quality, ground_distance):
                MAVLink_message.__init__(self, MAVLink_optical_flow_message.id, MAVLink_optical_flow_message.name)
                self._fieldnames = MAVLink_optical_flow_message.fieldnames
                self._instance_field = MAVLink_optical_flow_message.instance_field
                self._instance_offset = MAVLink_optical_flow_message.instance_offset
                self.time_usec = time_usec
                self.sensor_id = sensor_id
                self.flow_x = flow_x
                self.flow_y = flow_y
                self.flow_comp_m_x = flow_comp_m_x
                self.flow_comp_m_y = flow_comp_m_y
                self.quality = quality
                self.ground_distance = ground_distance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 175, struct.pack('<QfffhhBB', self.time_usec, self.flow_comp_m_x, self.flow_comp_m_y, self.ground_distance, self.flow_x, self.flow_y, self.sensor_id, self.quality), force_mavlink1=force_mavlink1)

class MAVLink_global_vision_position_estimate_message(MAVLink_message):
        '''
        Global position/attitude estimate from a vision source.
        '''
        id = MAVLINK_MSG_ID_GLOBAL_VISION_POSITION_ESTIMATE
        name = 'GLOBAL_VISION_POSITION_ESTIMATE'
        fieldnames = ['usec', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        ordered_fieldnames = ['usec', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"usec": "us", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
        format = '<Qffffff'
        native_format = bytearray('<Qffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 102
        unpacker = struct.Struct('<Qffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, usec, x, y, z, roll, pitch, yaw):
                MAVLink_message.__init__(self, MAVLink_global_vision_position_estimate_message.id, MAVLink_global_vision_position_estimate_message.name)
                self._fieldnames = MAVLink_global_vision_position_estimate_message.fieldnames
                self._instance_field = MAVLink_global_vision_position_estimate_message.instance_field
                self._instance_offset = MAVLink_global_vision_position_estimate_message.instance_offset
                self.usec = usec
                self.x = x
                self.y = y
                self.z = z
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 102, struct.pack('<Qffffff', self.usec, self.x, self.y, self.z, self.roll, self.pitch, self.yaw), force_mavlink1=force_mavlink1)

class MAVLink_vision_position_estimate_message(MAVLink_message):
        '''
        Local position/attitude estimate from a vision source.
        '''
        id = MAVLINK_MSG_ID_VISION_POSITION_ESTIMATE
        name = 'VISION_POSITION_ESTIMATE'
        fieldnames = ['usec', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        ordered_fieldnames = ['usec', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"usec": "us", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
        format = '<Qffffff'
        native_format = bytearray('<Qffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 158
        unpacker = struct.Struct('<Qffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, usec, x, y, z, roll, pitch, yaw):
                MAVLink_message.__init__(self, MAVLink_vision_position_estimate_message.id, MAVLink_vision_position_estimate_message.name)
                self._fieldnames = MAVLink_vision_position_estimate_message.fieldnames
                self._instance_field = MAVLink_vision_position_estimate_message.instance_field
                self._instance_offset = MAVLink_vision_position_estimate_message.instance_offset
                self.usec = usec
                self.x = x
                self.y = y
                self.z = z
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 158, struct.pack('<Qffffff', self.usec, self.x, self.y, self.z, self.roll, self.pitch, self.yaw), force_mavlink1=force_mavlink1)

class MAVLink_vision_speed_estimate_message(MAVLink_message):
        '''
        Speed estimate from a vision source.
        '''
        id = MAVLINK_MSG_ID_VISION_SPEED_ESTIMATE
        name = 'VISION_SPEED_ESTIMATE'
        fieldnames = ['usec', 'x', 'y', 'z']
        ordered_fieldnames = ['usec', 'x', 'y', 'z']
        fieldtypes = ['uint64_t', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"usec": "us", "x": "m/s", "y": "m/s", "z": "m/s"}
        format = '<Qfff'
        native_format = bytearray('<Qfff', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 208
        unpacker = struct.Struct('<Qfff')
        instance_field = None
        instance_offset = -1

        def __init__(self, usec, x, y, z):
                MAVLink_message.__init__(self, MAVLink_vision_speed_estimate_message.id, MAVLink_vision_speed_estimate_message.name)
                self._fieldnames = MAVLink_vision_speed_estimate_message.fieldnames
                self._instance_field = MAVLink_vision_speed_estimate_message.instance_field
                self._instance_offset = MAVLink_vision_speed_estimate_message.instance_offset
                self.usec = usec
                self.x = x
                self.y = y
                self.z = z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 208, struct.pack('<Qfff', self.usec, self.x, self.y, self.z), force_mavlink1=force_mavlink1)

class MAVLink_vicon_position_estimate_message(MAVLink_message):
        '''
        Global position estimate from a Vicon motion system source.
        '''
        id = MAVLINK_MSG_ID_VICON_POSITION_ESTIMATE
        name = 'VICON_POSITION_ESTIMATE'
        fieldnames = ['usec', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        ordered_fieldnames = ['usec', 'x', 'y', 'z', 'roll', 'pitch', 'yaw']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"usec": "us", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
        format = '<Qffffff'
        native_format = bytearray('<Qffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 56
        unpacker = struct.Struct('<Qffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, usec, x, y, z, roll, pitch, yaw):
                MAVLink_message.__init__(self, MAVLink_vicon_position_estimate_message.id, MAVLink_vicon_position_estimate_message.name)
                self._fieldnames = MAVLink_vicon_position_estimate_message.fieldnames
                self._instance_field = MAVLink_vicon_position_estimate_message.instance_field
                self._instance_offset = MAVLink_vicon_position_estimate_message.instance_offset
                self.usec = usec
                self.x = x
                self.y = y
                self.z = z
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 56, struct.pack('<Qffffff', self.usec, self.x, self.y, self.z, self.roll, self.pitch, self.yaw), force_mavlink1=force_mavlink1)

class MAVLink_highres_imu_message(MAVLink_message):
        '''
        The IMU readings in SI units in NED body frame
        '''
        id = MAVLINK_MSG_ID_HIGHRES_IMU
        name = 'HIGHRES_IMU'
        fieldnames = ['time_usec', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag', 'abs_pressure', 'diff_pressure', 'pressure_alt', 'temperature', 'fields_updated']
        ordered_fieldnames = ['time_usec', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag', 'abs_pressure', 'diff_pressure', 'pressure_alt', 'temperature', 'fields_updated']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'uint16_t']
        fielddisplays_by_name = {"fields_updated": "bitmask"}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s", "xmag": "gauss", "ymag": "gauss", "zmag": "gauss", "abs_pressure": "hPa", "diff_pressure": "hPa", "temperature": "degC"}
        format = '<QfffffffffffffH'
        native_format = bytearray('<QfffffffffffffH', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 93
        unpacker = struct.Struct('<QfffffffffffffH')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, xacc, yacc, zacc, xgyro, ygyro, zgyro, xmag, ymag, zmag, abs_pressure, diff_pressure, pressure_alt, temperature, fields_updated):
                MAVLink_message.__init__(self, MAVLink_highres_imu_message.id, MAVLink_highres_imu_message.name)
                self._fieldnames = MAVLink_highres_imu_message.fieldnames
                self._instance_field = MAVLink_highres_imu_message.instance_field
                self._instance_offset = MAVLink_highres_imu_message.instance_offset
                self.time_usec = time_usec
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.xmag = xmag
                self.ymag = ymag
                self.zmag = zmag
                self.abs_pressure = abs_pressure
                self.diff_pressure = diff_pressure
                self.pressure_alt = pressure_alt
                self.temperature = temperature
                self.fields_updated = fields_updated

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 93, struct.pack('<QfffffffffffffH', self.time_usec, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.abs_pressure, self.diff_pressure, self.pressure_alt, self.temperature, self.fields_updated), force_mavlink1=force_mavlink1)

class MAVLink_optical_flow_rad_message(MAVLink_message):
        '''
        Optical flow from an angular rate flow sensor (e.g. PX4FLOW or
        mouse sensor)
        '''
        id = MAVLINK_MSG_ID_OPTICAL_FLOW_RAD
        name = 'OPTICAL_FLOW_RAD'
        fieldnames = ['time_usec', 'sensor_id', 'integration_time_us', 'integrated_x', 'integrated_y', 'integrated_xgyro', 'integrated_ygyro', 'integrated_zgyro', 'temperature', 'quality', 'time_delta_distance_us', 'distance']
        ordered_fieldnames = ['time_usec', 'integration_time_us', 'integrated_x', 'integrated_y', 'integrated_xgyro', 'integrated_ygyro', 'integrated_zgyro', 'time_delta_distance_us', 'distance', 'temperature', 'sensor_id', 'quality']
        fieldtypes = ['uint64_t', 'uint8_t', 'uint32_t', 'float', 'float', 'float', 'float', 'float', 'int16_t', 'uint8_t', 'uint32_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "integration_time_us": "us", "integrated_x": "rad", "integrated_y": "rad", "integrated_xgyro": "rad", "integrated_ygyro": "rad", "integrated_zgyro": "rad", "temperature": "cdegC", "time_delta_distance_us": "us", "distance": "m"}
        format = '<QIfffffIfhBB'
        native_format = bytearray('<QIfffffIfhBB', 'ascii')
        orders = [0, 10, 1, 2, 3, 4, 5, 6, 9, 11, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 138
        unpacker = struct.Struct('<QIfffffIfhBB')
        instance_field = 'sensor_id'
        instance_offset = 42

        def __init__(self, time_usec, sensor_id, integration_time_us, integrated_x, integrated_y, integrated_xgyro, integrated_ygyro, integrated_zgyro, temperature, quality, time_delta_distance_us, distance):
                MAVLink_message.__init__(self, MAVLink_optical_flow_rad_message.id, MAVLink_optical_flow_rad_message.name)
                self._fieldnames = MAVLink_optical_flow_rad_message.fieldnames
                self._instance_field = MAVLink_optical_flow_rad_message.instance_field
                self._instance_offset = MAVLink_optical_flow_rad_message.instance_offset
                self.time_usec = time_usec
                self.sensor_id = sensor_id
                self.integration_time_us = integration_time_us
                self.integrated_x = integrated_x
                self.integrated_y = integrated_y
                self.integrated_xgyro = integrated_xgyro
                self.integrated_ygyro = integrated_ygyro
                self.integrated_zgyro = integrated_zgyro
                self.temperature = temperature
                self.quality = quality
                self.time_delta_distance_us = time_delta_distance_us
                self.distance = distance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 138, struct.pack('<QIfffffIfhBB', self.time_usec, self.integration_time_us, self.integrated_x, self.integrated_y, self.integrated_xgyro, self.integrated_ygyro, self.integrated_zgyro, self.time_delta_distance_us, self.distance, self.temperature, self.sensor_id, self.quality), force_mavlink1=force_mavlink1)

class MAVLink_hil_sensor_message(MAVLink_message):
        '''
        The IMU readings in SI units in NED body frame
        '''
        id = MAVLINK_MSG_ID_HIL_SENSOR
        name = 'HIL_SENSOR'
        fieldnames = ['time_usec', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag', 'abs_pressure', 'diff_pressure', 'pressure_alt', 'temperature', 'fields_updated']
        ordered_fieldnames = ['time_usec', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag', 'abs_pressure', 'diff_pressure', 'pressure_alt', 'temperature', 'fields_updated']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'uint32_t']
        fielddisplays_by_name = {"fields_updated": "bitmask"}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s", "xmag": "gauss", "ymag": "gauss", "zmag": "gauss", "abs_pressure": "hPa", "diff_pressure": "hPa", "temperature": "degC"}
        format = '<QfffffffffffffI'
        native_format = bytearray('<QfffffffffffffI', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 108
        unpacker = struct.Struct('<QfffffffffffffI')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, xacc, yacc, zacc, xgyro, ygyro, zgyro, xmag, ymag, zmag, abs_pressure, diff_pressure, pressure_alt, temperature, fields_updated):
                MAVLink_message.__init__(self, MAVLink_hil_sensor_message.id, MAVLink_hil_sensor_message.name)
                self._fieldnames = MAVLink_hil_sensor_message.fieldnames
                self._instance_field = MAVLink_hil_sensor_message.instance_field
                self._instance_offset = MAVLink_hil_sensor_message.instance_offset
                self.time_usec = time_usec
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.xmag = xmag
                self.ymag = ymag
                self.zmag = zmag
                self.abs_pressure = abs_pressure
                self.diff_pressure = diff_pressure
                self.pressure_alt = pressure_alt
                self.temperature = temperature
                self.fields_updated = fields_updated

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 108, struct.pack('<QfffffffffffffI', self.time_usec, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.abs_pressure, self.diff_pressure, self.pressure_alt, self.temperature, self.fields_updated), force_mavlink1=force_mavlink1)

class MAVLink_sim_state_message(MAVLink_message):
        '''
        Status of simulation environment, if used
        '''
        id = MAVLINK_MSG_ID_SIM_STATE
        name = 'SIM_STATE'
        fieldnames = ['q1', 'q2', 'q3', 'q4', 'roll', 'pitch', 'yaw', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'lat', 'lon', 'alt', 'std_dev_horz', 'std_dev_vert', 'vn', 've', 'vd']
        ordered_fieldnames = ['q1', 'q2', 'q3', 'q4', 'roll', 'pitch', 'yaw', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'lat', 'lon', 'alt', 'std_dev_horz', 'std_dev_vert', 'vn', 've', 'vd']
        fieldtypes = ['float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s", "lat": "deg", "lon": "deg", "alt": "m", "vn": "m/s", "ve": "m/s", "vd": "m/s"}
        format = '<fffffffffffffffffffff'
        native_format = bytearray('<fffffffffffffffffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 32
        unpacker = struct.Struct('<fffffffffffffffffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, q1, q2, q3, q4, roll, pitch, yaw, xacc, yacc, zacc, xgyro, ygyro, zgyro, lat, lon, alt, std_dev_horz, std_dev_vert, vn, ve, vd):
                MAVLink_message.__init__(self, MAVLink_sim_state_message.id, MAVLink_sim_state_message.name)
                self._fieldnames = MAVLink_sim_state_message.fieldnames
                self._instance_field = MAVLink_sim_state_message.instance_field
                self._instance_offset = MAVLink_sim_state_message.instance_offset
                self.q1 = q1
                self.q2 = q2
                self.q3 = q3
                self.q4 = q4
                self.roll = roll
                self.pitch = pitch
                self.yaw = yaw
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.std_dev_horz = std_dev_horz
                self.std_dev_vert = std_dev_vert
                self.vn = vn
                self.ve = ve
                self.vd = vd

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 32, struct.pack('<fffffffffffffffffffff', self.q1, self.q2, self.q3, self.q4, self.roll, self.pitch, self.yaw, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.lat, self.lon, self.alt, self.std_dev_horz, self.std_dev_vert, self.vn, self.ve, self.vd), force_mavlink1=force_mavlink1)

class MAVLink_radio_status_message(MAVLink_message):
        '''
        Status generated by radio and injected into MAVLink stream.
        '''
        id = MAVLINK_MSG_ID_RADIO_STATUS
        name = 'RADIO_STATUS'
        fieldnames = ['rssi', 'remrssi', 'txbuf', 'noise', 'remnoise', 'rxerrors', 'fixed']
        ordered_fieldnames = ['rxerrors', 'fixed', 'rssi', 'remrssi', 'txbuf', 'noise', 'remnoise']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"txbuf": "%"}
        format = '<HHBBBBB'
        native_format = bytearray('<HHBBBBB', 'ascii')
        orders = [2, 3, 4, 5, 6, 0, 1]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 185
        unpacker = struct.Struct('<HHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, rssi, remrssi, txbuf, noise, remnoise, rxerrors, fixed):
                MAVLink_message.__init__(self, MAVLink_radio_status_message.id, MAVLink_radio_status_message.name)
                self._fieldnames = MAVLink_radio_status_message.fieldnames
                self._instance_field = MAVLink_radio_status_message.instance_field
                self._instance_offset = MAVLink_radio_status_message.instance_offset
                self.rssi = rssi
                self.remrssi = remrssi
                self.txbuf = txbuf
                self.noise = noise
                self.remnoise = remnoise
                self.rxerrors = rxerrors
                self.fixed = fixed

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 185, struct.pack('<HHBBBBB', self.rxerrors, self.fixed, self.rssi, self.remrssi, self.txbuf, self.noise, self.remnoise), force_mavlink1=force_mavlink1)

class MAVLink_file_transfer_protocol_message(MAVLink_message):
        '''
        File transfer message
        '''
        id = MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL
        name = 'FILE_TRANSFER_PROTOCOL'
        fieldnames = ['target_network', 'target_system', 'target_component', 'payload']
        ordered_fieldnames = ['target_network', 'target_system', 'target_component', 'payload']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BBB251B'
        native_format = bytearray('<BBBB', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 251]
        array_lengths = [0, 0, 0, 251]
        crc_extra = 84
        unpacker = struct.Struct('<BBB251B')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_network, target_system, target_component, payload):
                MAVLink_message.__init__(self, MAVLink_file_transfer_protocol_message.id, MAVLink_file_transfer_protocol_message.name)
                self._fieldnames = MAVLink_file_transfer_protocol_message.fieldnames
                self._instance_field = MAVLink_file_transfer_protocol_message.instance_field
                self._instance_offset = MAVLink_file_transfer_protocol_message.instance_offset
                self.target_network = target_network
                self.target_system = target_system
                self.target_component = target_component
                self.payload = payload

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 84, struct.pack('<BBB251B', self.target_network, self.target_system, self.target_component, self.payload[0], self.payload[1], self.payload[2], self.payload[3], self.payload[4], self.payload[5], self.payload[6], self.payload[7], self.payload[8], self.payload[9], self.payload[10], self.payload[11], self.payload[12], self.payload[13], self.payload[14], self.payload[15], self.payload[16], self.payload[17], self.payload[18], self.payload[19], self.payload[20], self.payload[21], self.payload[22], self.payload[23], self.payload[24], self.payload[25], self.payload[26], self.payload[27], self.payload[28], self.payload[29], self.payload[30], self.payload[31], self.payload[32], self.payload[33], self.payload[34], self.payload[35], self.payload[36], self.payload[37], self.payload[38], self.payload[39], self.payload[40], self.payload[41], self.payload[42], self.payload[43], self.payload[44], self.payload[45], self.payload[46], self.payload[47], self.payload[48], self.payload[49], self.payload[50], self.payload[51], self.payload[52], self.payload[53], self.payload[54], self.payload[55], self.payload[56], self.payload[57], self.payload[58], self.payload[59], self.payload[60], self.payload[61], self.payload[62], self.payload[63], self.payload[64], self.payload[65], self.payload[66], self.payload[67], self.payload[68], self.payload[69], self.payload[70], self.payload[71], self.payload[72], self.payload[73], self.payload[74], self.payload[75], self.payload[76], self.payload[77], self.payload[78], self.payload[79], self.payload[80], self.payload[81], self.payload[82], self.payload[83], self.payload[84], self.payload[85], self.payload[86], self.payload[87], self.payload[88], self.payload[89], self.payload[90], self.payload[91], self.payload[92], self.payload[93], self.payload[94], self.payload[95], self.payload[96], self.payload[97], self.payload[98], self.payload[99], self.payload[100], self.payload[101], self.payload[102], self.payload[103], self.payload[104], self.payload[105], self.payload[106], self.payload[107], self.payload[108], self.payload[109], self.payload[110], self.payload[111], self.payload[112], self.payload[113], self.payload[114], self.payload[115], self.payload[116], self.payload[117], self.payload[118], self.payload[119], self.payload[120], self.payload[121], self.payload[122], self.payload[123], self.payload[124], self.payload[125], self.payload[126], self.payload[127], self.payload[128], self.payload[129], self.payload[130], self.payload[131], self.payload[132], self.payload[133], self.payload[134], self.payload[135], self.payload[136], self.payload[137], self.payload[138], self.payload[139], self.payload[140], self.payload[141], self.payload[142], self.payload[143], self.payload[144], self.payload[145], self.payload[146], self.payload[147], self.payload[148], self.payload[149], self.payload[150], self.payload[151], self.payload[152], self.payload[153], self.payload[154], self.payload[155], self.payload[156], self.payload[157], self.payload[158], self.payload[159], self.payload[160], self.payload[161], self.payload[162], self.payload[163], self.payload[164], self.payload[165], self.payload[166], self.payload[167], self.payload[168], self.payload[169], self.payload[170], self.payload[171], self.payload[172], self.payload[173], self.payload[174], self.payload[175], self.payload[176], self.payload[177], self.payload[178], self.payload[179], self.payload[180], self.payload[181], self.payload[182], self.payload[183], self.payload[184], self.payload[185], self.payload[186], self.payload[187], self.payload[188], self.payload[189], self.payload[190], self.payload[191], self.payload[192], self.payload[193], self.payload[194], self.payload[195], self.payload[196], self.payload[197], self.payload[198], self.payload[199], self.payload[200], self.payload[201], self.payload[202], self.payload[203], self.payload[204], self.payload[205], self.payload[206], self.payload[207], self.payload[208], self.payload[209], self.payload[210], self.payload[211], self.payload[212], self.payload[213], self.payload[214], self.payload[215], self.payload[216], self.payload[217], self.payload[218], self.payload[219], self.payload[220], self.payload[221], self.payload[222], self.payload[223], self.payload[224], self.payload[225], self.payload[226], self.payload[227], self.payload[228], self.payload[229], self.payload[230], self.payload[231], self.payload[232], self.payload[233], self.payload[234], self.payload[235], self.payload[236], self.payload[237], self.payload[238], self.payload[239], self.payload[240], self.payload[241], self.payload[242], self.payload[243], self.payload[244], self.payload[245], self.payload[246], self.payload[247], self.payload[248], self.payload[249], self.payload[250]), force_mavlink1=force_mavlink1)

class MAVLink_timesync_message(MAVLink_message):
        '''
        Time synchronization message.
        '''
        id = MAVLINK_MSG_ID_TIMESYNC
        name = 'TIMESYNC'
        fieldnames = ['tc1', 'ts1']
        ordered_fieldnames = ['tc1', 'ts1']
        fieldtypes = ['int64_t', 'int64_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<qq'
        native_format = bytearray('<qq', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 34
        unpacker = struct.Struct('<qq')
        instance_field = None
        instance_offset = -1

        def __init__(self, tc1, ts1):
                MAVLink_message.__init__(self, MAVLink_timesync_message.id, MAVLink_timesync_message.name)
                self._fieldnames = MAVLink_timesync_message.fieldnames
                self._instance_field = MAVLink_timesync_message.instance_field
                self._instance_offset = MAVLink_timesync_message.instance_offset
                self.tc1 = tc1
                self.ts1 = ts1

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 34, struct.pack('<qq', self.tc1, self.ts1), force_mavlink1=force_mavlink1)

class MAVLink_camera_trigger_message(MAVLink_message):
        '''
        Camera-IMU triggering and synchronisation message.
        '''
        id = MAVLINK_MSG_ID_CAMERA_TRIGGER
        name = 'CAMERA_TRIGGER'
        fieldnames = ['time_usec', 'seq']
        ordered_fieldnames = ['time_usec', 'seq']
        fieldtypes = ['uint64_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<QI'
        native_format = bytearray('<QI', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 174
        unpacker = struct.Struct('<QI')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, seq):
                MAVLink_message.__init__(self, MAVLink_camera_trigger_message.id, MAVLink_camera_trigger_message.name)
                self._fieldnames = MAVLink_camera_trigger_message.fieldnames
                self._instance_field = MAVLink_camera_trigger_message.instance_field
                self._instance_offset = MAVLink_camera_trigger_message.instance_offset
                self.time_usec = time_usec
                self.seq = seq

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 174, struct.pack('<QI', self.time_usec, self.seq), force_mavlink1=force_mavlink1)

class MAVLink_hil_gps_message(MAVLink_message):
        '''
        The global position, as returned by the Global Positioning
        System (GPS). This is                  NOT the global position
        estimate of the sytem, but rather a RAW sensor value. See
        message GLOBAL_POSITION for the global position estimate.
        '''
        id = MAVLINK_MSG_ID_HIL_GPS
        name = 'HIL_GPS'
        fieldnames = ['time_usec', 'fix_type', 'lat', 'lon', 'alt', 'eph', 'epv', 'vel', 'vn', 've', 'vd', 'cog', 'satellites_visible']
        ordered_fieldnames = ['time_usec', 'lat', 'lon', 'alt', 'eph', 'epv', 'vel', 'vn', 've', 'vd', 'cog', 'fix_type', 'satellites_visible']
        fieldtypes = ['uint64_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t', 'uint16_t', 'uint16_t', 'uint16_t', 'int16_t', 'int16_t', 'int16_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "vel": "cm/s", "vn": "cm/s", "ve": "cm/s", "vd": "cm/s", "cog": "cdeg"}
        format = '<QiiiHHHhhhHBB'
        native_format = bytearray('<QiiiHHHhhhHBB', 'ascii')
        orders = [0, 11, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 124
        unpacker = struct.Struct('<QiiiHHHhhhHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, fix_type, lat, lon, alt, eph, epv, vel, vn, ve, vd, cog, satellites_visible):
                MAVLink_message.__init__(self, MAVLink_hil_gps_message.id, MAVLink_hil_gps_message.name)
                self._fieldnames = MAVLink_hil_gps_message.fieldnames
                self._instance_field = MAVLink_hil_gps_message.instance_field
                self._instance_offset = MAVLink_hil_gps_message.instance_offset
                self.time_usec = time_usec
                self.fix_type = fix_type
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.eph = eph
                self.epv = epv
                self.vel = vel
                self.vn = vn
                self.ve = ve
                self.vd = vd
                self.cog = cog
                self.satellites_visible = satellites_visible

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 124, struct.pack('<QiiiHHHhhhHBB', self.time_usec, self.lat, self.lon, self.alt, self.eph, self.epv, self.vel, self.vn, self.ve, self.vd, self.cog, self.fix_type, self.satellites_visible), force_mavlink1=force_mavlink1)

class MAVLink_hil_optical_flow_message(MAVLink_message):
        '''
        Simulated optical flow from a flow sensor (e.g. PX4FLOW or
        optical mouse sensor)
        '''
        id = MAVLINK_MSG_ID_HIL_OPTICAL_FLOW
        name = 'HIL_OPTICAL_FLOW'
        fieldnames = ['time_usec', 'sensor_id', 'integration_time_us', 'integrated_x', 'integrated_y', 'integrated_xgyro', 'integrated_ygyro', 'integrated_zgyro', 'temperature', 'quality', 'time_delta_distance_us', 'distance']
        ordered_fieldnames = ['time_usec', 'integration_time_us', 'integrated_x', 'integrated_y', 'integrated_xgyro', 'integrated_ygyro', 'integrated_zgyro', 'time_delta_distance_us', 'distance', 'temperature', 'sensor_id', 'quality']
        fieldtypes = ['uint64_t', 'uint8_t', 'uint32_t', 'float', 'float', 'float', 'float', 'float', 'int16_t', 'uint8_t', 'uint32_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "integration_time_us": "us", "integrated_x": "rad", "integrated_y": "rad", "integrated_xgyro": "rad", "integrated_ygyro": "rad", "integrated_zgyro": "rad", "temperature": "cdegC", "time_delta_distance_us": "us", "distance": "m"}
        format = '<QIfffffIfhBB'
        native_format = bytearray('<QIfffffIfhBB', 'ascii')
        orders = [0, 10, 1, 2, 3, 4, 5, 6, 9, 11, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 237
        unpacker = struct.Struct('<QIfffffIfhBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, sensor_id, integration_time_us, integrated_x, integrated_y, integrated_xgyro, integrated_ygyro, integrated_zgyro, temperature, quality, time_delta_distance_us, distance):
                MAVLink_message.__init__(self, MAVLink_hil_optical_flow_message.id, MAVLink_hil_optical_flow_message.name)
                self._fieldnames = MAVLink_hil_optical_flow_message.fieldnames
                self._instance_field = MAVLink_hil_optical_flow_message.instance_field
                self._instance_offset = MAVLink_hil_optical_flow_message.instance_offset
                self.time_usec = time_usec
                self.sensor_id = sensor_id
                self.integration_time_us = integration_time_us
                self.integrated_x = integrated_x
                self.integrated_y = integrated_y
                self.integrated_xgyro = integrated_xgyro
                self.integrated_ygyro = integrated_ygyro
                self.integrated_zgyro = integrated_zgyro
                self.temperature = temperature
                self.quality = quality
                self.time_delta_distance_us = time_delta_distance_us
                self.distance = distance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 237, struct.pack('<QIfffffIfhBB', self.time_usec, self.integration_time_us, self.integrated_x, self.integrated_y, self.integrated_xgyro, self.integrated_ygyro, self.integrated_zgyro, self.time_delta_distance_us, self.distance, self.temperature, self.sensor_id, self.quality), force_mavlink1=force_mavlink1)

class MAVLink_hil_state_quaternion_message(MAVLink_message):
        '''
        Sent from simulation to autopilot, avoids in contrast to
        HIL_STATE singularities. This packet is useful for high
        throughput applications such as hardware in the loop
        simulations.
        '''
        id = MAVLINK_MSG_ID_HIL_STATE_QUATERNION
        name = 'HIL_STATE_QUATERNION'
        fieldnames = ['time_usec', 'attitude_quaternion', 'rollspeed', 'pitchspeed', 'yawspeed', 'lat', 'lon', 'alt', 'vx', 'vy', 'vz', 'ind_airspeed', 'true_airspeed', 'xacc', 'yacc', 'zacc']
        ordered_fieldnames = ['time_usec', 'attitude_quaternion', 'rollspeed', 'pitchspeed', 'yawspeed', 'lat', 'lon', 'alt', 'vx', 'vy', 'vz', 'ind_airspeed', 'true_airspeed', 'xacc', 'yacc', 'zacc']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'int32_t', 'int32_t', 'int32_t', 'int16_t', 'int16_t', 'int16_t', 'uint16_t', 'uint16_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s", "lat": "degE7", "lon": "degE7", "alt": "mm", "vx": "cm/s", "vy": "cm/s", "vz": "cm/s", "ind_airspeed": "cm/s", "true_airspeed": "cm/s", "xacc": "mG", "yacc": "mG", "zacc": "mG"}
        format = '<Q4ffffiiihhhHHhhh'
        native_format = bytearray('<QffffiiihhhHHhhh', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        lengths = [1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 4
        unpacker = struct.Struct('<Q4ffffiiihhhHHhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, attitude_quaternion, rollspeed, pitchspeed, yawspeed, lat, lon, alt, vx, vy, vz, ind_airspeed, true_airspeed, xacc, yacc, zacc):
                MAVLink_message.__init__(self, MAVLink_hil_state_quaternion_message.id, MAVLink_hil_state_quaternion_message.name)
                self._fieldnames = MAVLink_hil_state_quaternion_message.fieldnames
                self._instance_field = MAVLink_hil_state_quaternion_message.instance_field
                self._instance_offset = MAVLink_hil_state_quaternion_message.instance_offset
                self.time_usec = time_usec
                self.attitude_quaternion = attitude_quaternion
                self.rollspeed = rollspeed
                self.pitchspeed = pitchspeed
                self.yawspeed = yawspeed
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.vx = vx
                self.vy = vy
                self.vz = vz
                self.ind_airspeed = ind_airspeed
                self.true_airspeed = true_airspeed
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 4, struct.pack('<Q4ffffiiihhhHHhhh', self.time_usec, self.attitude_quaternion[0], self.attitude_quaternion[1], self.attitude_quaternion[2], self.attitude_quaternion[3], self.rollspeed, self.pitchspeed, self.yawspeed, self.lat, self.lon, self.alt, self.vx, self.vy, self.vz, self.ind_airspeed, self.true_airspeed, self.xacc, self.yacc, self.zacc), force_mavlink1=force_mavlink1)

class MAVLink_scaled_imu2_message(MAVLink_message):
        '''
        The RAW IMU readings for secondary 9DOF sensor setup. This
        message should contain the scaled values to the described
        units
        '''
        id = MAVLINK_MSG_ID_SCALED_IMU2
        name = 'SCALED_IMU2'
        fieldnames = ['time_boot_ms', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        ordered_fieldnames = ['time_boot_ms', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        fieldtypes = ['uint32_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "xacc": "mG", "yacc": "mG", "zacc": "mG", "xgyro": "mrad/s", "ygyro": "mrad/s", "zgyro": "mrad/s", "xmag": "mgauss", "ymag": "mgauss", "zmag": "mgauss"}
        format = '<Ihhhhhhhhh'
        native_format = bytearray('<Ihhhhhhhhh', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 76
        unpacker = struct.Struct('<Ihhhhhhhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, xacc, yacc, zacc, xgyro, ygyro, zgyro, xmag, ymag, zmag):
                MAVLink_message.__init__(self, MAVLink_scaled_imu2_message.id, MAVLink_scaled_imu2_message.name)
                self._fieldnames = MAVLink_scaled_imu2_message.fieldnames
                self._instance_field = MAVLink_scaled_imu2_message.instance_field
                self._instance_offset = MAVLink_scaled_imu2_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.xmag = xmag
                self.ymag = ymag
                self.zmag = zmag

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 76, struct.pack('<Ihhhhhhhhh', self.time_boot_ms, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag), force_mavlink1=force_mavlink1)

class MAVLink_log_request_list_message(MAVLink_message):
        '''
        Request a list of available logs. On some systems calling this
        may stop on-board logging until LOG_REQUEST_END is called. If
        there are no log files available this request shall be
        answered with one LOG_ENTRY message with id = 0 and num_logs =
        0.
        '''
        id = MAVLINK_MSG_ID_LOG_REQUEST_LIST
        name = 'LOG_REQUEST_LIST'
        fieldnames = ['target_system', 'target_component', 'start', 'end']
        ordered_fieldnames = ['start', 'end', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HHBB'
        native_format = bytearray('<HHBB', 'ascii')
        orders = [2, 3, 0, 1]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 128
        unpacker = struct.Struct('<HHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, start, end):
                MAVLink_message.__init__(self, MAVLink_log_request_list_message.id, MAVLink_log_request_list_message.name)
                self._fieldnames = MAVLink_log_request_list_message.fieldnames
                self._instance_field = MAVLink_log_request_list_message.instance_field
                self._instance_offset = MAVLink_log_request_list_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.start = start
                self.end = end

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 128, struct.pack('<HHBB', self.start, self.end, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_log_entry_message(MAVLink_message):
        '''
        Reply to LOG_REQUEST_LIST
        '''
        id = MAVLINK_MSG_ID_LOG_ENTRY
        name = 'LOG_ENTRY'
        fieldnames = ['id', 'num_logs', 'last_log_num', 'time_utc', 'size']
        ordered_fieldnames = ['time_utc', 'size', 'id', 'num_logs', 'last_log_num']
        fieldtypes = ['uint16_t', 'uint16_t', 'uint16_t', 'uint32_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_utc": "s", "size": "bytes"}
        format = '<IIHHH'
        native_format = bytearray('<IIHHH', 'ascii')
        orders = [2, 3, 4, 0, 1]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 56
        unpacker = struct.Struct('<IIHHH')
        instance_field = None
        instance_offset = -1

        def __init__(self, id, num_logs, last_log_num, time_utc, size):
                MAVLink_message.__init__(self, MAVLink_log_entry_message.id, MAVLink_log_entry_message.name)
                self._fieldnames = MAVLink_log_entry_message.fieldnames
                self._instance_field = MAVLink_log_entry_message.instance_field
                self._instance_offset = MAVLink_log_entry_message.instance_offset
                self.id = id
                self.num_logs = num_logs
                self.last_log_num = last_log_num
                self.time_utc = time_utc
                self.size = size

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 56, struct.pack('<IIHHH', self.time_utc, self.size, self.id, self.num_logs, self.last_log_num), force_mavlink1=force_mavlink1)

class MAVLink_log_request_data_message(MAVLink_message):
        '''
        Request a chunk of a log
        '''
        id = MAVLINK_MSG_ID_LOG_REQUEST_DATA
        name = 'LOG_REQUEST_DATA'
        fieldnames = ['target_system', 'target_component', 'id', 'ofs', 'count']
        ordered_fieldnames = ['ofs', 'count', 'id', 'target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t', 'uint32_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"count": "bytes"}
        format = '<IIHBB'
        native_format = bytearray('<IIHBB', 'ascii')
        orders = [3, 4, 2, 0, 1]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0]
        crc_extra = 116
        unpacker = struct.Struct('<IIHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, id, ofs, count):
                MAVLink_message.__init__(self, MAVLink_log_request_data_message.id, MAVLink_log_request_data_message.name)
                self._fieldnames = MAVLink_log_request_data_message.fieldnames
                self._instance_field = MAVLink_log_request_data_message.instance_field
                self._instance_offset = MAVLink_log_request_data_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.id = id
                self.ofs = ofs
                self.count = count

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 116, struct.pack('<IIHBB', self.ofs, self.count, self.id, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_log_data_message(MAVLink_message):
        '''
        Reply to LOG_REQUEST_DATA
        '''
        id = MAVLINK_MSG_ID_LOG_DATA
        name = 'LOG_DATA'
        fieldnames = ['id', 'ofs', 'count', 'data']
        ordered_fieldnames = ['ofs', 'id', 'count', 'data']
        fieldtypes = ['uint16_t', 'uint32_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"count": "bytes"}
        format = '<IHB90B'
        native_format = bytearray('<IHBB', 'ascii')
        orders = [1, 0, 2, 3]
        lengths = [1, 1, 1, 90]
        array_lengths = [0, 0, 0, 90]
        crc_extra = 134
        unpacker = struct.Struct('<IHB90B')
        instance_field = None
        instance_offset = -1

        def __init__(self, id, ofs, count, data):
                MAVLink_message.__init__(self, MAVLink_log_data_message.id, MAVLink_log_data_message.name)
                self._fieldnames = MAVLink_log_data_message.fieldnames
                self._instance_field = MAVLink_log_data_message.instance_field
                self._instance_offset = MAVLink_log_data_message.instance_offset
                self.id = id
                self.ofs = ofs
                self.count = count
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 134, struct.pack('<IHB90B', self.ofs, self.id, self.count, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89]), force_mavlink1=force_mavlink1)

class MAVLink_log_erase_message(MAVLink_message):
        '''
        Erase all logs
        '''
        id = MAVLINK_MSG_ID_LOG_ERASE
        name = 'LOG_ERASE'
        fieldnames = ['target_system', 'target_component']
        ordered_fieldnames = ['target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 237
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component):
                MAVLink_message.__init__(self, MAVLink_log_erase_message.id, MAVLink_log_erase_message.name)
                self._fieldnames = MAVLink_log_erase_message.fieldnames
                self._instance_field = MAVLink_log_erase_message.instance_field
                self._instance_offset = MAVLink_log_erase_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 237, struct.pack('<BB', self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_log_request_end_message(MAVLink_message):
        '''
        Stop log transfer and resume normal logging
        '''
        id = MAVLINK_MSG_ID_LOG_REQUEST_END
        name = 'LOG_REQUEST_END'
        fieldnames = ['target_system', 'target_component']
        ordered_fieldnames = ['target_system', 'target_component']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 203
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component):
                MAVLink_message.__init__(self, MAVLink_log_request_end_message.id, MAVLink_log_request_end_message.name)
                self._fieldnames = MAVLink_log_request_end_message.fieldnames
                self._instance_field = MAVLink_log_request_end_message.instance_field
                self._instance_offset = MAVLink_log_request_end_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 203, struct.pack('<BB', self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_gps_inject_data_message(MAVLink_message):
        '''
        Data for injecting into the onboard GPS (used for DGPS)
        '''
        id = MAVLINK_MSG_ID_GPS_INJECT_DATA
        name = 'GPS_INJECT_DATA'
        fieldnames = ['target_system', 'target_component', 'len', 'data']
        ordered_fieldnames = ['target_system', 'target_component', 'len', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"len": "bytes"}
        format = '<BBB110B'
        native_format = bytearray('<BBBB', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 110]
        array_lengths = [0, 0, 0, 110]
        crc_extra = 250
        unpacker = struct.Struct('<BBB110B')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, target_component, len, data):
                MAVLink_message.__init__(self, MAVLink_gps_inject_data_message.id, MAVLink_gps_inject_data_message.name)
                self._fieldnames = MAVLink_gps_inject_data_message.fieldnames
                self._instance_field = MAVLink_gps_inject_data_message.instance_field
                self._instance_offset = MAVLink_gps_inject_data_message.instance_offset
                self.target_system = target_system
                self.target_component = target_component
                self.len = len
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 250, struct.pack('<BBB110B', self.target_system, self.target_component, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109]), force_mavlink1=force_mavlink1)

class MAVLink_gps2_raw_message(MAVLink_message):
        '''
        Second GPS data.
        '''
        id = MAVLINK_MSG_ID_GPS2_RAW
        name = 'GPS2_RAW'
        fieldnames = ['time_usec', 'fix_type', 'lat', 'lon', 'alt', 'eph', 'epv', 'vel', 'cog', 'satellites_visible', 'dgps_numch', 'dgps_age']
        ordered_fieldnames = ['time_usec', 'lat', 'lon', 'alt', 'dgps_age', 'eph', 'epv', 'vel', 'cog', 'fix_type', 'satellites_visible', 'dgps_numch']
        fieldtypes = ['uint64_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint8_t', 'uint8_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"fix_type": "GPS_FIX_TYPE"}
        fieldunits_by_name = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "vel": "cm/s", "cog": "cdeg", "dgps_age": "ms"}
        format = '<QiiiIHHHHBBB'
        native_format = bytearray('<QiiiIHHHHBBB', 'ascii')
        orders = [0, 9, 1, 2, 3, 5, 6, 7, 8, 10, 11, 4]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 87
        unpacker = struct.Struct('<QiiiIHHHHBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, fix_type, lat, lon, alt, eph, epv, vel, cog, satellites_visible, dgps_numch, dgps_age):
                MAVLink_message.__init__(self, MAVLink_gps2_raw_message.id, MAVLink_gps2_raw_message.name)
                self._fieldnames = MAVLink_gps2_raw_message.fieldnames
                self._instance_field = MAVLink_gps2_raw_message.instance_field
                self._instance_offset = MAVLink_gps2_raw_message.instance_offset
                self.time_usec = time_usec
                self.fix_type = fix_type
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.eph = eph
                self.epv = epv
                self.vel = vel
                self.cog = cog
                self.satellites_visible = satellites_visible
                self.dgps_numch = dgps_numch
                self.dgps_age = dgps_age

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 87, struct.pack('<QiiiIHHHHBBB', self.time_usec, self.lat, self.lon, self.alt, self.dgps_age, self.eph, self.epv, self.vel, self.cog, self.fix_type, self.satellites_visible, self.dgps_numch), force_mavlink1=force_mavlink1)

class MAVLink_power_status_message(MAVLink_message):
        '''
        Power supply status
        '''
        id = MAVLINK_MSG_ID_POWER_STATUS
        name = 'POWER_STATUS'
        fieldnames = ['Vcc', 'Vservo', 'flags']
        ordered_fieldnames = ['Vcc', 'Vservo', 'flags']
        fieldtypes = ['uint16_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {"flags": "bitmask"}
        fieldenums_by_name = {"flags": "MAV_POWER_STATUS"}
        fieldunits_by_name = {"Vcc": "mV", "Vservo": "mV"}
        format = '<HHH'
        native_format = bytearray('<HHH', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 203
        unpacker = struct.Struct('<HHH')
        instance_field = None
        instance_offset = -1

        def __init__(self, Vcc, Vservo, flags):
                MAVLink_message.__init__(self, MAVLink_power_status_message.id, MAVLink_power_status_message.name)
                self._fieldnames = MAVLink_power_status_message.fieldnames
                self._instance_field = MAVLink_power_status_message.instance_field
                self._instance_offset = MAVLink_power_status_message.instance_offset
                self.Vcc = Vcc
                self.Vservo = Vservo
                self.flags = flags

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 203, struct.pack('<HHH', self.Vcc, self.Vservo, self.flags), force_mavlink1=force_mavlink1)

class MAVLink_serial_control_message(MAVLink_message):
        '''
        Control a serial port. This can be used for raw access to an
        onboard serial peripheral such as a GPS or telemetry radio. It
        is designed to make it possible to update the devices firmware
        via MAVLink messages or change the devices settings. A message
        with zero bytes can be used to change just the baudrate.
        '''
        id = MAVLINK_MSG_ID_SERIAL_CONTROL
        name = 'SERIAL_CONTROL'
        fieldnames = ['device', 'flags', 'timeout', 'baudrate', 'count', 'data']
        ordered_fieldnames = ['baudrate', 'timeout', 'device', 'flags', 'count', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint16_t', 'uint32_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {"flags": "bitmask"}
        fieldenums_by_name = {"device": "SERIAL_CONTROL_DEV", "flags": "SERIAL_CONTROL_FLAG"}
        fieldunits_by_name = {"timeout": "ms", "baudrate": "bits/s", "count": "bytes"}
        format = '<IHBBB70B'
        native_format = bytearray('<IHBBBB', 'ascii')
        orders = [2, 3, 1, 0, 4, 5]
        lengths = [1, 1, 1, 1, 1, 70]
        array_lengths = [0, 0, 0, 0, 0, 70]
        crc_extra = 220
        unpacker = struct.Struct('<IHBBB70B')
        instance_field = None
        instance_offset = -1

        def __init__(self, device, flags, timeout, baudrate, count, data):
                MAVLink_message.__init__(self, MAVLink_serial_control_message.id, MAVLink_serial_control_message.name)
                self._fieldnames = MAVLink_serial_control_message.fieldnames
                self._instance_field = MAVLink_serial_control_message.instance_field
                self._instance_offset = MAVLink_serial_control_message.instance_offset
                self.device = device
                self.flags = flags
                self.timeout = timeout
                self.baudrate = baudrate
                self.count = count
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 220, struct.pack('<IHBBB70B', self.baudrate, self.timeout, self.device, self.flags, self.count, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69]), force_mavlink1=force_mavlink1)

class MAVLink_gps_rtk_message(MAVLink_message):
        '''
        RTK GPS data. Gives information on the relative baseline
        calculation the GPS is reporting
        '''
        id = MAVLINK_MSG_ID_GPS_RTK
        name = 'GPS_RTK'
        fieldnames = ['time_last_baseline_ms', 'rtk_receiver_id', 'wn', 'tow', 'rtk_health', 'rtk_rate', 'nsats', 'baseline_coords_type', 'baseline_a_mm', 'baseline_b_mm', 'baseline_c_mm', 'accuracy', 'iar_num_hypotheses']
        ordered_fieldnames = ['time_last_baseline_ms', 'tow', 'baseline_a_mm', 'baseline_b_mm', 'baseline_c_mm', 'accuracy', 'iar_num_hypotheses', 'wn', 'rtk_receiver_id', 'rtk_health', 'rtk_rate', 'nsats', 'baseline_coords_type']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint16_t', 'uint32_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t', 'uint32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"baseline_coords_type": "RTK_BASELINE_COORDINATE_SYSTEM"}
        fieldunits_by_name = {"time_last_baseline_ms": "ms", "tow": "ms", "rtk_rate": "Hz", "baseline_a_mm": "mm", "baseline_b_mm": "mm", "baseline_c_mm": "mm"}
        format = '<IIiiiIiHBBBBB'
        native_format = bytearray('<IIiiiIiHBBBBB', 'ascii')
        orders = [0, 8, 7, 1, 9, 10, 11, 12, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 25
        unpacker = struct.Struct('<IIiiiIiHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_last_baseline_ms, rtk_receiver_id, wn, tow, rtk_health, rtk_rate, nsats, baseline_coords_type, baseline_a_mm, baseline_b_mm, baseline_c_mm, accuracy, iar_num_hypotheses):
                MAVLink_message.__init__(self, MAVLink_gps_rtk_message.id, MAVLink_gps_rtk_message.name)
                self._fieldnames = MAVLink_gps_rtk_message.fieldnames
                self._instance_field = MAVLink_gps_rtk_message.instance_field
                self._instance_offset = MAVLink_gps_rtk_message.instance_offset
                self.time_last_baseline_ms = time_last_baseline_ms
                self.rtk_receiver_id = rtk_receiver_id
                self.wn = wn
                self.tow = tow
                self.rtk_health = rtk_health
                self.rtk_rate = rtk_rate
                self.nsats = nsats
                self.baseline_coords_type = baseline_coords_type
                self.baseline_a_mm = baseline_a_mm
                self.baseline_b_mm = baseline_b_mm
                self.baseline_c_mm = baseline_c_mm
                self.accuracy = accuracy
                self.iar_num_hypotheses = iar_num_hypotheses

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 25, struct.pack('<IIiiiIiHBBBBB', self.time_last_baseline_ms, self.tow, self.baseline_a_mm, self.baseline_b_mm, self.baseline_c_mm, self.accuracy, self.iar_num_hypotheses, self.wn, self.rtk_receiver_id, self.rtk_health, self.rtk_rate, self.nsats, self.baseline_coords_type), force_mavlink1=force_mavlink1)

class MAVLink_gps2_rtk_message(MAVLink_message):
        '''
        RTK GPS data. Gives information on the relative baseline
        calculation the GPS is reporting
        '''
        id = MAVLINK_MSG_ID_GPS2_RTK
        name = 'GPS2_RTK'
        fieldnames = ['time_last_baseline_ms', 'rtk_receiver_id', 'wn', 'tow', 'rtk_health', 'rtk_rate', 'nsats', 'baseline_coords_type', 'baseline_a_mm', 'baseline_b_mm', 'baseline_c_mm', 'accuracy', 'iar_num_hypotheses']
        ordered_fieldnames = ['time_last_baseline_ms', 'tow', 'baseline_a_mm', 'baseline_b_mm', 'baseline_c_mm', 'accuracy', 'iar_num_hypotheses', 'wn', 'rtk_receiver_id', 'rtk_health', 'rtk_rate', 'nsats', 'baseline_coords_type']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint16_t', 'uint32_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'int32_t', 'int32_t', 'int32_t', 'uint32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"baseline_coords_type": "RTK_BASELINE_COORDINATE_SYSTEM"}
        fieldunits_by_name = {"time_last_baseline_ms": "ms", "tow": "ms", "rtk_rate": "Hz", "baseline_a_mm": "mm", "baseline_b_mm": "mm", "baseline_c_mm": "mm"}
        format = '<IIiiiIiHBBBBB'
        native_format = bytearray('<IIiiiIiHBBBBB', 'ascii')
        orders = [0, 8, 7, 1, 9, 10, 11, 12, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 226
        unpacker = struct.Struct('<IIiiiIiHBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_last_baseline_ms, rtk_receiver_id, wn, tow, rtk_health, rtk_rate, nsats, baseline_coords_type, baseline_a_mm, baseline_b_mm, baseline_c_mm, accuracy, iar_num_hypotheses):
                MAVLink_message.__init__(self, MAVLink_gps2_rtk_message.id, MAVLink_gps2_rtk_message.name)
                self._fieldnames = MAVLink_gps2_rtk_message.fieldnames
                self._instance_field = MAVLink_gps2_rtk_message.instance_field
                self._instance_offset = MAVLink_gps2_rtk_message.instance_offset
                self.time_last_baseline_ms = time_last_baseline_ms
                self.rtk_receiver_id = rtk_receiver_id
                self.wn = wn
                self.tow = tow
                self.rtk_health = rtk_health
                self.rtk_rate = rtk_rate
                self.nsats = nsats
                self.baseline_coords_type = baseline_coords_type
                self.baseline_a_mm = baseline_a_mm
                self.baseline_b_mm = baseline_b_mm
                self.baseline_c_mm = baseline_c_mm
                self.accuracy = accuracy
                self.iar_num_hypotheses = iar_num_hypotheses

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 226, struct.pack('<IIiiiIiHBBBBB', self.time_last_baseline_ms, self.tow, self.baseline_a_mm, self.baseline_b_mm, self.baseline_c_mm, self.accuracy, self.iar_num_hypotheses, self.wn, self.rtk_receiver_id, self.rtk_health, self.rtk_rate, self.nsats, self.baseline_coords_type), force_mavlink1=force_mavlink1)

class MAVLink_scaled_imu3_message(MAVLink_message):
        '''
        The RAW IMU readings for 3rd 9DOF sensor setup. This message
        should contain the scaled values to the described units
        '''
        id = MAVLINK_MSG_ID_SCALED_IMU3
        name = 'SCALED_IMU3'
        fieldnames = ['time_boot_ms', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        ordered_fieldnames = ['time_boot_ms', 'xacc', 'yacc', 'zacc', 'xgyro', 'ygyro', 'zgyro', 'xmag', 'ymag', 'zmag']
        fieldtypes = ['uint32_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "xacc": "mG", "yacc": "mG", "zacc": "mG", "xgyro": "mrad/s", "ygyro": "mrad/s", "zgyro": "mrad/s", "xmag": "mgauss", "ymag": "mgauss", "zmag": "mgauss"}
        format = '<Ihhhhhhhhh'
        native_format = bytearray('<Ihhhhhhhhh', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 46
        unpacker = struct.Struct('<Ihhhhhhhhh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, xacc, yacc, zacc, xgyro, ygyro, zgyro, xmag, ymag, zmag):
                MAVLink_message.__init__(self, MAVLink_scaled_imu3_message.id, MAVLink_scaled_imu3_message.name)
                self._fieldnames = MAVLink_scaled_imu3_message.fieldnames
                self._instance_field = MAVLink_scaled_imu3_message.instance_field
                self._instance_offset = MAVLink_scaled_imu3_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.xacc = xacc
                self.yacc = yacc
                self.zacc = zacc
                self.xgyro = xgyro
                self.ygyro = ygyro
                self.zgyro = zgyro
                self.xmag = xmag
                self.ymag = ymag
                self.zmag = zmag

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 46, struct.pack('<Ihhhhhhhhh', self.time_boot_ms, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag), force_mavlink1=force_mavlink1)

class MAVLink_data_transmission_handshake_message(MAVLink_message):
        '''
        Handshake message to initiate, control and stop image
        streaming when using the Image Transmission Protocol:
        https://mavlink.io/en/services/image_transmission.html.
        '''
        id = MAVLINK_MSG_ID_DATA_TRANSMISSION_HANDSHAKE
        name = 'DATA_TRANSMISSION_HANDSHAKE'
        fieldnames = ['type', 'size', 'width', 'height', 'packets', 'payload', 'jpg_quality']
        ordered_fieldnames = ['size', 'width', 'height', 'packets', 'type', 'payload', 'jpg_quality']
        fieldtypes = ['uint8_t', 'uint32_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"type": "MAVLINK_DATA_STREAM_TYPE"}
        fieldunits_by_name = {"size": "bytes", "payload": "bytes", "jpg_quality": "%"}
        format = '<IHHHBBB'
        native_format = bytearray('<IHHHBBB', 'ascii')
        orders = [4, 0, 1, 2, 3, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 29
        unpacker = struct.Struct('<IHHHBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, type, size, width, height, packets, payload, jpg_quality):
                MAVLink_message.__init__(self, MAVLink_data_transmission_handshake_message.id, MAVLink_data_transmission_handshake_message.name)
                self._fieldnames = MAVLink_data_transmission_handshake_message.fieldnames
                self._instance_field = MAVLink_data_transmission_handshake_message.instance_field
                self._instance_offset = MAVLink_data_transmission_handshake_message.instance_offset
                self.type = type
                self.size = size
                self.width = width
                self.height = height
                self.packets = packets
                self.payload = payload
                self.jpg_quality = jpg_quality

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 29, struct.pack('<IHHHBBB', self.size, self.width, self.height, self.packets, self.type, self.payload, self.jpg_quality), force_mavlink1=force_mavlink1)

class MAVLink_encapsulated_data_message(MAVLink_message):
        '''
        Data packet for images sent using the Image Transmission
        Protocol:
        https://mavlink.io/en/services/image_transmission.html.
        '''
        id = MAVLINK_MSG_ID_ENCAPSULATED_DATA
        name = 'ENCAPSULATED_DATA'
        fieldnames = ['seqnr', 'data']
        ordered_fieldnames = ['seqnr', 'data']
        fieldtypes = ['uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<H253B'
        native_format = bytearray('<HB', 'ascii')
        orders = [0, 1]
        lengths = [1, 253]
        array_lengths = [0, 253]
        crc_extra = 223
        unpacker = struct.Struct('<H253B')
        instance_field = None
        instance_offset = -1

        def __init__(self, seqnr, data):
                MAVLink_message.__init__(self, MAVLink_encapsulated_data_message.id, MAVLink_encapsulated_data_message.name)
                self._fieldnames = MAVLink_encapsulated_data_message.fieldnames
                self._instance_field = MAVLink_encapsulated_data_message.instance_field
                self._instance_offset = MAVLink_encapsulated_data_message.instance_offset
                self.seqnr = seqnr
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 223, struct.pack('<H253B', self.seqnr, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109], self.data[110], self.data[111], self.data[112], self.data[113], self.data[114], self.data[115], self.data[116], self.data[117], self.data[118], self.data[119], self.data[120], self.data[121], self.data[122], self.data[123], self.data[124], self.data[125], self.data[126], self.data[127], self.data[128], self.data[129], self.data[130], self.data[131], self.data[132], self.data[133], self.data[134], self.data[135], self.data[136], self.data[137], self.data[138], self.data[139], self.data[140], self.data[141], self.data[142], self.data[143], self.data[144], self.data[145], self.data[146], self.data[147], self.data[148], self.data[149], self.data[150], self.data[151], self.data[152], self.data[153], self.data[154], self.data[155], self.data[156], self.data[157], self.data[158], self.data[159], self.data[160], self.data[161], self.data[162], self.data[163], self.data[164], self.data[165], self.data[166], self.data[167], self.data[168], self.data[169], self.data[170], self.data[171], self.data[172], self.data[173], self.data[174], self.data[175], self.data[176], self.data[177], self.data[178], self.data[179], self.data[180], self.data[181], self.data[182], self.data[183], self.data[184], self.data[185], self.data[186], self.data[187], self.data[188], self.data[189], self.data[190], self.data[191], self.data[192], self.data[193], self.data[194], self.data[195], self.data[196], self.data[197], self.data[198], self.data[199], self.data[200], self.data[201], self.data[202], self.data[203], self.data[204], self.data[205], self.data[206], self.data[207], self.data[208], self.data[209], self.data[210], self.data[211], self.data[212], self.data[213], self.data[214], self.data[215], self.data[216], self.data[217], self.data[218], self.data[219], self.data[220], self.data[221], self.data[222], self.data[223], self.data[224], self.data[225], self.data[226], self.data[227], self.data[228], self.data[229], self.data[230], self.data[231], self.data[232], self.data[233], self.data[234], self.data[235], self.data[236], self.data[237], self.data[238], self.data[239], self.data[240], self.data[241], self.data[242], self.data[243], self.data[244], self.data[245], self.data[246], self.data[247], self.data[248], self.data[249], self.data[250], self.data[251], self.data[252]), force_mavlink1=force_mavlink1)

class MAVLink_distance_sensor_message(MAVLink_message):
        '''
        Distance sensor information for an onboard rangefinder.
        '''
        id = MAVLINK_MSG_ID_DISTANCE_SENSOR
        name = 'DISTANCE_SENSOR'
        fieldnames = ['time_boot_ms', 'min_distance', 'max_distance', 'current_distance', 'type', 'id', 'orientation', 'covariance']
        ordered_fieldnames = ['time_boot_ms', 'min_distance', 'max_distance', 'current_distance', 'type', 'id', 'orientation', 'covariance']
        fieldtypes = ['uint32_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"type": "MAV_DISTANCE_SENSOR", "orientation": "MAV_SENSOR_ORIENTATION"}
        fieldunits_by_name = {"time_boot_ms": "ms", "min_distance": "cm", "max_distance": "cm", "current_distance": "cm", "covariance": "cm^2"}
        format = '<IHHHBBBB'
        native_format = bytearray('<IHHHBBBB', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 85
        unpacker = struct.Struct('<IHHHBBBB')
        instance_field = 'id'
        instance_offset = 11

        def __init__(self, time_boot_ms, min_distance, max_distance, current_distance, type, id, orientation, covariance):
                MAVLink_message.__init__(self, MAVLink_distance_sensor_message.id, MAVLink_distance_sensor_message.name)
                self._fieldnames = MAVLink_distance_sensor_message.fieldnames
                self._instance_field = MAVLink_distance_sensor_message.instance_field
                self._instance_offset = MAVLink_distance_sensor_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.min_distance = min_distance
                self.max_distance = max_distance
                self.current_distance = current_distance
                self.type = type
                self.id = id
                self.orientation = orientation
                self.covariance = covariance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 85, struct.pack('<IHHHBBBB', self.time_boot_ms, self.min_distance, self.max_distance, self.current_distance, self.type, self.id, self.orientation, self.covariance), force_mavlink1=force_mavlink1)

class MAVLink_terrain_request_message(MAVLink_message):
        '''
        Request for terrain data and terrain status. See terrain
        protocol docs: https://mavlink.io/en/services/terrain.html
        '''
        id = MAVLINK_MSG_ID_TERRAIN_REQUEST
        name = 'TERRAIN_REQUEST'
        fieldnames = ['lat', 'lon', 'grid_spacing', 'mask']
        ordered_fieldnames = ['mask', 'lat', 'lon', 'grid_spacing']
        fieldtypes = ['int32_t', 'int32_t', 'uint16_t', 'uint64_t']
        fielddisplays_by_name = {"mask": "bitmask"}
        fieldenums_by_name = {}
        fieldunits_by_name = {"lat": "degE7", "lon": "degE7", "grid_spacing": "m"}
        format = '<QiiH'
        native_format = bytearray('<QiiH', 'ascii')
        orders = [1, 2, 3, 0]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 6
        unpacker = struct.Struct('<QiiH')
        instance_field = None
        instance_offset = -1

        def __init__(self, lat, lon, grid_spacing, mask):
                MAVLink_message.__init__(self, MAVLink_terrain_request_message.id, MAVLink_terrain_request_message.name)
                self._fieldnames = MAVLink_terrain_request_message.fieldnames
                self._instance_field = MAVLink_terrain_request_message.instance_field
                self._instance_offset = MAVLink_terrain_request_message.instance_offset
                self.lat = lat
                self.lon = lon
                self.grid_spacing = grid_spacing
                self.mask = mask

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 6, struct.pack('<QiiH', self.mask, self.lat, self.lon, self.grid_spacing), force_mavlink1=force_mavlink1)

class MAVLink_terrain_data_message(MAVLink_message):
        '''
        Terrain data sent from GCS. The lat/lon and grid_spacing must
        be the same as a lat/lon from a TERRAIN_REQUEST. See terrain
        protocol docs: https://mavlink.io/en/services/terrain.html
        '''
        id = MAVLINK_MSG_ID_TERRAIN_DATA
        name = 'TERRAIN_DATA'
        fieldnames = ['lat', 'lon', 'grid_spacing', 'gridbit', 'data']
        ordered_fieldnames = ['lat', 'lon', 'grid_spacing', 'data', 'gridbit']
        fieldtypes = ['int32_t', 'int32_t', 'uint16_t', 'uint8_t', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"lat": "degE7", "lon": "degE7", "grid_spacing": "m", "data": "m"}
        format = '<iiH16hB'
        native_format = bytearray('<iiHhB', 'ascii')
        orders = [0, 1, 2, 4, 3]
        lengths = [1, 1, 1, 16, 1]
        array_lengths = [0, 0, 0, 16, 0]
        crc_extra = 229
        unpacker = struct.Struct('<iiH16hB')
        instance_field = None
        instance_offset = -1

        def __init__(self, lat, lon, grid_spacing, gridbit, data):
                MAVLink_message.__init__(self, MAVLink_terrain_data_message.id, MAVLink_terrain_data_message.name)
                self._fieldnames = MAVLink_terrain_data_message.fieldnames
                self._instance_field = MAVLink_terrain_data_message.instance_field
                self._instance_offset = MAVLink_terrain_data_message.instance_offset
                self.lat = lat
                self.lon = lon
                self.grid_spacing = grid_spacing
                self.gridbit = gridbit
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 229, struct.pack('<iiH16hB', self.lat, self.lon, self.grid_spacing, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.gridbit), force_mavlink1=force_mavlink1)

class MAVLink_terrain_check_message(MAVLink_message):
        '''
        Request that the vehicle report terrain height at the given
        location (expected response is a TERRAIN_REPORT). Used by GCS
        to check if vehicle has all terrain data needed for a mission.
        '''
        id = MAVLINK_MSG_ID_TERRAIN_CHECK
        name = 'TERRAIN_CHECK'
        fieldnames = ['lat', 'lon']
        ordered_fieldnames = ['lat', 'lon']
        fieldtypes = ['int32_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"lat": "degE7", "lon": "degE7"}
        format = '<ii'
        native_format = bytearray('<ii', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 203
        unpacker = struct.Struct('<ii')
        instance_field = None
        instance_offset = -1

        def __init__(self, lat, lon):
                MAVLink_message.__init__(self, MAVLink_terrain_check_message.id, MAVLink_terrain_check_message.name)
                self._fieldnames = MAVLink_terrain_check_message.fieldnames
                self._instance_field = MAVLink_terrain_check_message.instance_field
                self._instance_offset = MAVLink_terrain_check_message.instance_offset
                self.lat = lat
                self.lon = lon

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 203, struct.pack('<ii', self.lat, self.lon), force_mavlink1=force_mavlink1)

class MAVLink_terrain_report_message(MAVLink_message):
        '''
        Streamed from drone to report progress of terrain map download
        (initiated by TERRAIN_REQUEST), or sent as a response to a
        TERRAIN_CHECK request. See terrain protocol docs:
        https://mavlink.io/en/services/terrain.html
        '''
        id = MAVLINK_MSG_ID_TERRAIN_REPORT
        name = 'TERRAIN_REPORT'
        fieldnames = ['lat', 'lon', 'spacing', 'terrain_height', 'current_height', 'pending', 'loaded']
        ordered_fieldnames = ['lat', 'lon', 'terrain_height', 'current_height', 'spacing', 'pending', 'loaded']
        fieldtypes = ['int32_t', 'int32_t', 'uint16_t', 'float', 'float', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"lat": "degE7", "lon": "degE7", "terrain_height": "m", "current_height": "m"}
        format = '<iiffHHH'
        native_format = bytearray('<iiffHHH', 'ascii')
        orders = [0, 1, 4, 2, 3, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 1
        unpacker = struct.Struct('<iiffHHH')
        instance_field = None
        instance_offset = -1

        def __init__(self, lat, lon, spacing, terrain_height, current_height, pending, loaded):
                MAVLink_message.__init__(self, MAVLink_terrain_report_message.id, MAVLink_terrain_report_message.name)
                self._fieldnames = MAVLink_terrain_report_message.fieldnames
                self._instance_field = MAVLink_terrain_report_message.instance_field
                self._instance_offset = MAVLink_terrain_report_message.instance_offset
                self.lat = lat
                self.lon = lon
                self.spacing = spacing
                self.terrain_height = terrain_height
                self.current_height = current_height
                self.pending = pending
                self.loaded = loaded

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 1, struct.pack('<iiffHHH', self.lat, self.lon, self.terrain_height, self.current_height, self.spacing, self.pending, self.loaded), force_mavlink1=force_mavlink1)

class MAVLink_scaled_pressure2_message(MAVLink_message):
        '''
        Barometer readings for 2nd barometer
        '''
        id = MAVLINK_MSG_ID_SCALED_PRESSURE2
        name = 'SCALED_PRESSURE2'
        fieldnames = ['time_boot_ms', 'press_abs', 'press_diff', 'temperature']
        ordered_fieldnames = ['time_boot_ms', 'press_abs', 'press_diff', 'temperature']
        fieldtypes = ['uint32_t', 'float', 'float', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "press_abs": "hPa", "press_diff": "hPa", "temperature": "cdegC"}
        format = '<Iffh'
        native_format = bytearray('<Iffh', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 195
        unpacker = struct.Struct('<Iffh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, press_abs, press_diff, temperature):
                MAVLink_message.__init__(self, MAVLink_scaled_pressure2_message.id, MAVLink_scaled_pressure2_message.name)
                self._fieldnames = MAVLink_scaled_pressure2_message.fieldnames
                self._instance_field = MAVLink_scaled_pressure2_message.instance_field
                self._instance_offset = MAVLink_scaled_pressure2_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.press_abs = press_abs
                self.press_diff = press_diff
                self.temperature = temperature

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 195, struct.pack('<Iffh', self.time_boot_ms, self.press_abs, self.press_diff, self.temperature), force_mavlink1=force_mavlink1)

class MAVLink_att_pos_mocap_message(MAVLink_message):
        '''
        Motion capture attitude and position
        '''
        id = MAVLINK_MSG_ID_ATT_POS_MOCAP
        name = 'ATT_POS_MOCAP'
        fieldnames = ['time_usec', 'q', 'x', 'y', 'z']
        ordered_fieldnames = ['time_usec', 'q', 'x', 'y', 'z']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "x": "m", "y": "m", "z": "m"}
        format = '<Q4ffff'
        native_format = bytearray('<Qffff', 'ascii')
        orders = [0, 1, 2, 3, 4]
        lengths = [1, 4, 1, 1, 1]
        array_lengths = [0, 4, 0, 0, 0]
        crc_extra = 109
        unpacker = struct.Struct('<Q4ffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, q, x, y, z):
                MAVLink_message.__init__(self, MAVLink_att_pos_mocap_message.id, MAVLink_att_pos_mocap_message.name)
                self._fieldnames = MAVLink_att_pos_mocap_message.fieldnames
                self._instance_field = MAVLink_att_pos_mocap_message.instance_field
                self._instance_offset = MAVLink_att_pos_mocap_message.instance_offset
                self.time_usec = time_usec
                self.q = q
                self.x = x
                self.y = y
                self.z = z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 109, struct.pack('<Q4ffff', self.time_usec, self.q[0], self.q[1], self.q[2], self.q[3], self.x, self.y, self.z), force_mavlink1=force_mavlink1)

class MAVLink_set_actuator_control_target_message(MAVLink_message):
        '''
        Set the vehicle attitude and body angular rates.
        '''
        id = MAVLINK_MSG_ID_SET_ACTUATOR_CONTROL_TARGET
        name = 'SET_ACTUATOR_CONTROL_TARGET'
        fieldnames = ['time_usec', 'group_mlx', 'target_system', 'target_component', 'controls']
        ordered_fieldnames = ['time_usec', 'controls', 'group_mlx', 'target_system', 'target_component']
        fieldtypes = ['uint64_t', 'uint8_t', 'uint8_t', 'uint8_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<Q8fBBB'
        native_format = bytearray('<QfBBB', 'ascii')
        orders = [0, 2, 3, 4, 1]
        lengths = [1, 8, 1, 1, 1]
        array_lengths = [0, 8, 0, 0, 0]
        crc_extra = 168
        unpacker = struct.Struct('<Q8fBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, group_mlx, target_system, target_component, controls):
                MAVLink_message.__init__(self, MAVLink_set_actuator_control_target_message.id, MAVLink_set_actuator_control_target_message.name)
                self._fieldnames = MAVLink_set_actuator_control_target_message.fieldnames
                self._instance_field = MAVLink_set_actuator_control_target_message.instance_field
                self._instance_offset = MAVLink_set_actuator_control_target_message.instance_offset
                self.time_usec = time_usec
                self.group_mlx = group_mlx
                self.target_system = target_system
                self.target_component = target_component
                self.controls = controls

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 168, struct.pack('<Q8fBBB', self.time_usec, self.controls[0], self.controls[1], self.controls[2], self.controls[3], self.controls[4], self.controls[5], self.controls[6], self.controls[7], self.group_mlx, self.target_system, self.target_component), force_mavlink1=force_mavlink1)

class MAVLink_actuator_control_target_message(MAVLink_message):
        '''
        Set the vehicle attitude and body angular rates.
        '''
        id = MAVLINK_MSG_ID_ACTUATOR_CONTROL_TARGET
        name = 'ACTUATOR_CONTROL_TARGET'
        fieldnames = ['time_usec', 'group_mlx', 'controls']
        ordered_fieldnames = ['time_usec', 'controls', 'group_mlx']
        fieldtypes = ['uint64_t', 'uint8_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<Q8fB'
        native_format = bytearray('<QfB', 'ascii')
        orders = [0, 2, 1]
        lengths = [1, 8, 1]
        array_lengths = [0, 8, 0]
        crc_extra = 181
        unpacker = struct.Struct('<Q8fB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, group_mlx, controls):
                MAVLink_message.__init__(self, MAVLink_actuator_control_target_message.id, MAVLink_actuator_control_target_message.name)
                self._fieldnames = MAVLink_actuator_control_target_message.fieldnames
                self._instance_field = MAVLink_actuator_control_target_message.instance_field
                self._instance_offset = MAVLink_actuator_control_target_message.instance_offset
                self.time_usec = time_usec
                self.group_mlx = group_mlx
                self.controls = controls

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 181, struct.pack('<Q8fB', self.time_usec, self.controls[0], self.controls[1], self.controls[2], self.controls[3], self.controls[4], self.controls[5], self.controls[6], self.controls[7], self.group_mlx), force_mavlink1=force_mavlink1)

class MAVLink_altitude_message(MAVLink_message):
        '''
        The current system altitude.
        '''
        id = MAVLINK_MSG_ID_ALTITUDE
        name = 'ALTITUDE'
        fieldnames = ['time_usec', 'altitude_monotonic', 'altitude_amsl', 'altitude_local', 'altitude_relative', 'altitude_terrain', 'bottom_clearance']
        ordered_fieldnames = ['time_usec', 'altitude_monotonic', 'altitude_amsl', 'altitude_local', 'altitude_relative', 'altitude_terrain', 'bottom_clearance']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "altitude_monotonic": "m", "altitude_amsl": "m", "altitude_local": "m", "altitude_relative": "m", "altitude_terrain": "m", "bottom_clearance": "m"}
        format = '<Qffffff'
        native_format = bytearray('<Qffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 47
        unpacker = struct.Struct('<Qffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, altitude_monotonic, altitude_amsl, altitude_local, altitude_relative, altitude_terrain, bottom_clearance):
                MAVLink_message.__init__(self, MAVLink_altitude_message.id, MAVLink_altitude_message.name)
                self._fieldnames = MAVLink_altitude_message.fieldnames
                self._instance_field = MAVLink_altitude_message.instance_field
                self._instance_offset = MAVLink_altitude_message.instance_offset
                self.time_usec = time_usec
                self.altitude_monotonic = altitude_monotonic
                self.altitude_amsl = altitude_amsl
                self.altitude_local = altitude_local
                self.altitude_relative = altitude_relative
                self.altitude_terrain = altitude_terrain
                self.bottom_clearance = bottom_clearance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 47, struct.pack('<Qffffff', self.time_usec, self.altitude_monotonic, self.altitude_amsl, self.altitude_local, self.altitude_relative, self.altitude_terrain, self.bottom_clearance), force_mavlink1=force_mavlink1)

class MAVLink_resource_request_message(MAVLink_message):
        '''
        The autopilot is requesting a resource (file, binary, other
        type of data)
        '''
        id = MAVLINK_MSG_ID_RESOURCE_REQUEST
        name = 'RESOURCE_REQUEST'
        fieldnames = ['request_id', 'uri_type', 'uri', 'transfer_type', 'storage']
        ordered_fieldnames = ['request_id', 'uri_type', 'uri', 'transfer_type', 'storage']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BB120BB120B'
        native_format = bytearray('<BBBBB', 'ascii')
        orders = [0, 1, 2, 3, 4]
        lengths = [1, 1, 120, 1, 120]
        array_lengths = [0, 0, 120, 0, 120]
        crc_extra = 72
        unpacker = struct.Struct('<BB120BB120B')
        instance_field = None
        instance_offset = -1

        def __init__(self, request_id, uri_type, uri, transfer_type, storage):
                MAVLink_message.__init__(self, MAVLink_resource_request_message.id, MAVLink_resource_request_message.name)
                self._fieldnames = MAVLink_resource_request_message.fieldnames
                self._instance_field = MAVLink_resource_request_message.instance_field
                self._instance_offset = MAVLink_resource_request_message.instance_offset
                self.request_id = request_id
                self.uri_type = uri_type
                self.uri = uri
                self.transfer_type = transfer_type
                self.storage = storage

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 72, struct.pack('<BB120BB120B', self.request_id, self.uri_type, self.uri[0], self.uri[1], self.uri[2], self.uri[3], self.uri[4], self.uri[5], self.uri[6], self.uri[7], self.uri[8], self.uri[9], self.uri[10], self.uri[11], self.uri[12], self.uri[13], self.uri[14], self.uri[15], self.uri[16], self.uri[17], self.uri[18], self.uri[19], self.uri[20], self.uri[21], self.uri[22], self.uri[23], self.uri[24], self.uri[25], self.uri[26], self.uri[27], self.uri[28], self.uri[29], self.uri[30], self.uri[31], self.uri[32], self.uri[33], self.uri[34], self.uri[35], self.uri[36], self.uri[37], self.uri[38], self.uri[39], self.uri[40], self.uri[41], self.uri[42], self.uri[43], self.uri[44], self.uri[45], self.uri[46], self.uri[47], self.uri[48], self.uri[49], self.uri[50], self.uri[51], self.uri[52], self.uri[53], self.uri[54], self.uri[55], self.uri[56], self.uri[57], self.uri[58], self.uri[59], self.uri[60], self.uri[61], self.uri[62], self.uri[63], self.uri[64], self.uri[65], self.uri[66], self.uri[67], self.uri[68], self.uri[69], self.uri[70], self.uri[71], self.uri[72], self.uri[73], self.uri[74], self.uri[75], self.uri[76], self.uri[77], self.uri[78], self.uri[79], self.uri[80], self.uri[81], self.uri[82], self.uri[83], self.uri[84], self.uri[85], self.uri[86], self.uri[87], self.uri[88], self.uri[89], self.uri[90], self.uri[91], self.uri[92], self.uri[93], self.uri[94], self.uri[95], self.uri[96], self.uri[97], self.uri[98], self.uri[99], self.uri[100], self.uri[101], self.uri[102], self.uri[103], self.uri[104], self.uri[105], self.uri[106], self.uri[107], self.uri[108], self.uri[109], self.uri[110], self.uri[111], self.uri[112], self.uri[113], self.uri[114], self.uri[115], self.uri[116], self.uri[117], self.uri[118], self.uri[119], self.transfer_type, self.storage[0], self.storage[1], self.storage[2], self.storage[3], self.storage[4], self.storage[5], self.storage[6], self.storage[7], self.storage[8], self.storage[9], self.storage[10], self.storage[11], self.storage[12], self.storage[13], self.storage[14], self.storage[15], self.storage[16], self.storage[17], self.storage[18], self.storage[19], self.storage[20], self.storage[21], self.storage[22], self.storage[23], self.storage[24], self.storage[25], self.storage[26], self.storage[27], self.storage[28], self.storage[29], self.storage[30], self.storage[31], self.storage[32], self.storage[33], self.storage[34], self.storage[35], self.storage[36], self.storage[37], self.storage[38], self.storage[39], self.storage[40], self.storage[41], self.storage[42], self.storage[43], self.storage[44], self.storage[45], self.storage[46], self.storage[47], self.storage[48], self.storage[49], self.storage[50], self.storage[51], self.storage[52], self.storage[53], self.storage[54], self.storage[55], self.storage[56], self.storage[57], self.storage[58], self.storage[59], self.storage[60], self.storage[61], self.storage[62], self.storage[63], self.storage[64], self.storage[65], self.storage[66], self.storage[67], self.storage[68], self.storage[69], self.storage[70], self.storage[71], self.storage[72], self.storage[73], self.storage[74], self.storage[75], self.storage[76], self.storage[77], self.storage[78], self.storage[79], self.storage[80], self.storage[81], self.storage[82], self.storage[83], self.storage[84], self.storage[85], self.storage[86], self.storage[87], self.storage[88], self.storage[89], self.storage[90], self.storage[91], self.storage[92], self.storage[93], self.storage[94], self.storage[95], self.storage[96], self.storage[97], self.storage[98], self.storage[99], self.storage[100], self.storage[101], self.storage[102], self.storage[103], self.storage[104], self.storage[105], self.storage[106], self.storage[107], self.storage[108], self.storage[109], self.storage[110], self.storage[111], self.storage[112], self.storage[113], self.storage[114], self.storage[115], self.storage[116], self.storage[117], self.storage[118], self.storage[119]), force_mavlink1=force_mavlink1)

class MAVLink_scaled_pressure3_message(MAVLink_message):
        '''
        Barometer readings for 3rd barometer
        '''
        id = MAVLINK_MSG_ID_SCALED_PRESSURE3
        name = 'SCALED_PRESSURE3'
        fieldnames = ['time_boot_ms', 'press_abs', 'press_diff', 'temperature']
        ordered_fieldnames = ['time_boot_ms', 'press_abs', 'press_diff', 'temperature']
        fieldtypes = ['uint32_t', 'float', 'float', 'int16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms", "press_abs": "hPa", "press_diff": "hPa", "temperature": "cdegC"}
        format = '<Iffh'
        native_format = bytearray('<Iffh', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 131
        unpacker = struct.Struct('<Iffh')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, press_abs, press_diff, temperature):
                MAVLink_message.__init__(self, MAVLink_scaled_pressure3_message.id, MAVLink_scaled_pressure3_message.name)
                self._fieldnames = MAVLink_scaled_pressure3_message.fieldnames
                self._instance_field = MAVLink_scaled_pressure3_message.instance_field
                self._instance_offset = MAVLink_scaled_pressure3_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.press_abs = press_abs
                self.press_diff = press_diff
                self.temperature = temperature

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 131, struct.pack('<Iffh', self.time_boot_ms, self.press_abs, self.press_diff, self.temperature), force_mavlink1=force_mavlink1)

class MAVLink_follow_target_message(MAVLink_message):
        '''
        Current motion information from a designated system
        '''
        id = MAVLINK_MSG_ID_FOLLOW_TARGET
        name = 'FOLLOW_TARGET'
        fieldnames = ['timestamp', 'est_capabilities', 'lat', 'lon', 'alt', 'vel', 'acc', 'attitude_q', 'rates', 'position_cov', 'custom_state']
        ordered_fieldnames = ['timestamp', 'custom_state', 'lat', 'lon', 'alt', 'vel', 'acc', 'attitude_q', 'rates', 'position_cov', 'est_capabilities']
        fieldtypes = ['uint64_t', 'uint8_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'uint64_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"timestamp": "ms", "lat": "degE7", "lon": "degE7", "alt": "m", "vel": "m/s", "acc": "m/s/s"}
        format = '<QQiif3f3f4f3f3fB'
        native_format = bytearray('<QQiiffffffB', 'ascii')
        orders = [0, 10, 2, 3, 4, 5, 6, 7, 8, 9, 1]
        lengths = [1, 1, 1, 1, 1, 3, 3, 4, 3, 3, 1]
        array_lengths = [0, 0, 0, 0, 0, 3, 3, 4, 3, 3, 0]
        crc_extra = 127
        unpacker = struct.Struct('<QQiif3f3f4f3f3fB')
        instance_field = None
        instance_offset = -1

        def __init__(self, timestamp, est_capabilities, lat, lon, alt, vel, acc, attitude_q, rates, position_cov, custom_state):
                MAVLink_message.__init__(self, MAVLink_follow_target_message.id, MAVLink_follow_target_message.name)
                self._fieldnames = MAVLink_follow_target_message.fieldnames
                self._instance_field = MAVLink_follow_target_message.instance_field
                self._instance_offset = MAVLink_follow_target_message.instance_offset
                self.timestamp = timestamp
                self.est_capabilities = est_capabilities
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.vel = vel
                self.acc = acc
                self.attitude_q = attitude_q
                self.rates = rates
                self.position_cov = position_cov
                self.custom_state = custom_state

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 127, struct.pack('<QQiif3f3f4f3f3fB', self.timestamp, self.custom_state, self.lat, self.lon, self.alt, self.vel[0], self.vel[1], self.vel[2], self.acc[0], self.acc[1], self.acc[2], self.attitude_q[0], self.attitude_q[1], self.attitude_q[2], self.attitude_q[3], self.rates[0], self.rates[1], self.rates[2], self.position_cov[0], self.position_cov[1], self.position_cov[2], self.est_capabilities), force_mavlink1=force_mavlink1)

class MAVLink_control_system_state_message(MAVLink_message):
        '''
        The smoothed, monotonic system state used to feed the control
        loops of the system.
        '''
        id = MAVLINK_MSG_ID_CONTROL_SYSTEM_STATE
        name = 'CONTROL_SYSTEM_STATE'
        fieldnames = ['time_usec', 'x_acc', 'y_acc', 'z_acc', 'x_vel', 'y_vel', 'z_vel', 'x_pos', 'y_pos', 'z_pos', 'airspeed', 'vel_variance', 'pos_variance', 'q', 'roll_rate', 'pitch_rate', 'yaw_rate']
        ordered_fieldnames = ['time_usec', 'x_acc', 'y_acc', 'z_acc', 'x_vel', 'y_vel', 'z_vel', 'x_pos', 'y_pos', 'z_pos', 'airspeed', 'vel_variance', 'pos_variance', 'q', 'roll_rate', 'pitch_rate', 'yaw_rate']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "x_acc": "m/s/s", "y_acc": "m/s/s", "z_acc": "m/s/s", "x_vel": "m/s", "y_vel": "m/s", "z_vel": "m/s", "x_pos": "m", "y_pos": "m", "z_pos": "m", "airspeed": "m/s", "roll_rate": "rad/s", "pitch_rate": "rad/s", "yaw_rate": "rad/s"}
        format = '<Qffffffffff3f3f4ffff'
        native_format = bytearray('<Qffffffffffffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 4, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 4, 0, 0, 0]
        crc_extra = 103
        unpacker = struct.Struct('<Qffffffffff3f3f4ffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, x_acc, y_acc, z_acc, x_vel, y_vel, z_vel, x_pos, y_pos, z_pos, airspeed, vel_variance, pos_variance, q, roll_rate, pitch_rate, yaw_rate):
                MAVLink_message.__init__(self, MAVLink_control_system_state_message.id, MAVLink_control_system_state_message.name)
                self._fieldnames = MAVLink_control_system_state_message.fieldnames
                self._instance_field = MAVLink_control_system_state_message.instance_field
                self._instance_offset = MAVLink_control_system_state_message.instance_offset
                self.time_usec = time_usec
                self.x_acc = x_acc
                self.y_acc = y_acc
                self.z_acc = z_acc
                self.x_vel = x_vel
                self.y_vel = y_vel
                self.z_vel = z_vel
                self.x_pos = x_pos
                self.y_pos = y_pos
                self.z_pos = z_pos
                self.airspeed = airspeed
                self.vel_variance = vel_variance
                self.pos_variance = pos_variance
                self.q = q
                self.roll_rate = roll_rate
                self.pitch_rate = pitch_rate
                self.yaw_rate = yaw_rate

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 103, struct.pack('<Qffffffffff3f3f4ffff', self.time_usec, self.x_acc, self.y_acc, self.z_acc, self.x_vel, self.y_vel, self.z_vel, self.x_pos, self.y_pos, self.z_pos, self.airspeed, self.vel_variance[0], self.vel_variance[1], self.vel_variance[2], self.pos_variance[0], self.pos_variance[1], self.pos_variance[2], self.q[0], self.q[1], self.q[2], self.q[3], self.roll_rate, self.pitch_rate, self.yaw_rate), force_mavlink1=force_mavlink1)

class MAVLink_battery_status_message(MAVLink_message):
        '''
        Battery information
        '''
        id = MAVLINK_MSG_ID_BATTERY_STATUS
        name = 'BATTERY_STATUS'
        fieldnames = ['id', 'battery_function', 'type', 'temperature', 'voltages', 'current_battery', 'current_consumed', 'energy_consumed', 'battery_remaining']
        ordered_fieldnames = ['current_consumed', 'energy_consumed', 'temperature', 'voltages', 'current_battery', 'id', 'battery_function', 'type', 'battery_remaining']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'int16_t', 'uint16_t', 'int16_t', 'int32_t', 'int32_t', 'int8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"battery_function": "MAV_BATTERY_FUNCTION", "type": "MAV_BATTERY_TYPE"}
        fieldunits_by_name = {"temperature": "cdegC", "voltages": "mV", "current_battery": "cA", "current_consumed": "mAh", "energy_consumed": "hJ", "battery_remaining": "%"}
        format = '<iih10HhBBBb'
        native_format = bytearray('<iihHhBBBb', 'ascii')
        orders = [5, 6, 7, 2, 3, 4, 0, 1, 8]
        lengths = [1, 1, 1, 10, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 10, 0, 0, 0, 0, 0]
        crc_extra = 154
        unpacker = struct.Struct('<iih10HhBBBb')
        instance_field = 'id'
        instance_offset = 32

        def __init__(self, id, battery_function, type, temperature, voltages, current_battery, current_consumed, energy_consumed, battery_remaining):
                MAVLink_message.__init__(self, MAVLink_battery_status_message.id, MAVLink_battery_status_message.name)
                self._fieldnames = MAVLink_battery_status_message.fieldnames
                self._instance_field = MAVLink_battery_status_message.instance_field
                self._instance_offset = MAVLink_battery_status_message.instance_offset
                self.id = id
                self.battery_function = battery_function
                self.type = type
                self.temperature = temperature
                self.voltages = voltages
                self.current_battery = current_battery
                self.current_consumed = current_consumed
                self.energy_consumed = energy_consumed
                self.battery_remaining = battery_remaining

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 154, struct.pack('<iih10HhBBBb', self.current_consumed, self.energy_consumed, self.temperature, self.voltages[0], self.voltages[1], self.voltages[2], self.voltages[3], self.voltages[4], self.voltages[5], self.voltages[6], self.voltages[7], self.voltages[8], self.voltages[9], self.current_battery, self.id, self.battery_function, self.type, self.battery_remaining), force_mavlink1=force_mavlink1)

class MAVLink_autopilot_version_message(MAVLink_message):
        '''
        Version and capability of autopilot software. This should be
        emitted in response to a request with MAV_CMD_REQUEST_MESSAGE.
        '''
        id = MAVLINK_MSG_ID_AUTOPILOT_VERSION
        name = 'AUTOPILOT_VERSION'
        fieldnames = ['capabilities', 'flight_sw_version', 'middleware_sw_version', 'os_sw_version', 'board_version', 'flight_custom_version', 'middleware_custom_version', 'os_custom_version', 'vendor_id', 'product_id', 'uid']
        ordered_fieldnames = ['capabilities', 'uid', 'flight_sw_version', 'middleware_sw_version', 'os_sw_version', 'board_version', 'vendor_id', 'product_id', 'flight_custom_version', 'middleware_custom_version', 'os_custom_version']
        fieldtypes = ['uint64_t', 'uint32_t', 'uint32_t', 'uint32_t', 'uint32_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint16_t', 'uint64_t']
        fielddisplays_by_name = {"capabilities": "bitmask"}
        fieldenums_by_name = {"capabilities": "MAV_PROTOCOL_CAPABILITY"}
        fieldunits_by_name = {}
        format = '<QQIIIIHH8B8B8B'
        native_format = bytearray('<QQIIIIHHBBB', 'ascii')
        orders = [0, 2, 3, 4, 5, 8, 9, 10, 6, 7, 1]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 8, 8, 8]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8]
        crc_extra = 178
        unpacker = struct.Struct('<QQIIIIHH8B8B8B')
        instance_field = None
        instance_offset = -1

        def __init__(self, capabilities, flight_sw_version, middleware_sw_version, os_sw_version, board_version, flight_custom_version, middleware_custom_version, os_custom_version, vendor_id, product_id, uid):
                MAVLink_message.__init__(self, MAVLink_autopilot_version_message.id, MAVLink_autopilot_version_message.name)
                self._fieldnames = MAVLink_autopilot_version_message.fieldnames
                self._instance_field = MAVLink_autopilot_version_message.instance_field
                self._instance_offset = MAVLink_autopilot_version_message.instance_offset
                self.capabilities = capabilities
                self.flight_sw_version = flight_sw_version
                self.middleware_sw_version = middleware_sw_version
                self.os_sw_version = os_sw_version
                self.board_version = board_version
                self.flight_custom_version = flight_custom_version
                self.middleware_custom_version = middleware_custom_version
                self.os_custom_version = os_custom_version
                self.vendor_id = vendor_id
                self.product_id = product_id
                self.uid = uid

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 178, struct.pack('<QQIIIIHH8B8B8B', self.capabilities, self.uid, self.flight_sw_version, self.middleware_sw_version, self.os_sw_version, self.board_version, self.vendor_id, self.product_id, self.flight_custom_version[0], self.flight_custom_version[1], self.flight_custom_version[2], self.flight_custom_version[3], self.flight_custom_version[4], self.flight_custom_version[5], self.flight_custom_version[6], self.flight_custom_version[7], self.middleware_custom_version[0], self.middleware_custom_version[1], self.middleware_custom_version[2], self.middleware_custom_version[3], self.middleware_custom_version[4], self.middleware_custom_version[5], self.middleware_custom_version[6], self.middleware_custom_version[7], self.os_custom_version[0], self.os_custom_version[1], self.os_custom_version[2], self.os_custom_version[3], self.os_custom_version[4], self.os_custom_version[5], self.os_custom_version[6], self.os_custom_version[7]), force_mavlink1=force_mavlink1)

class MAVLink_landing_target_message(MAVLink_message):
        '''
        The location of a landing target. See:
        https://mavlink.io/en/services/landing_target.html
        '''
        id = MAVLINK_MSG_ID_LANDING_TARGET
        name = 'LANDING_TARGET'
        fieldnames = ['time_usec', 'target_num', 'frame', 'angle_x', 'angle_y', 'distance', 'size_x', 'size_y']
        ordered_fieldnames = ['time_usec', 'angle_x', 'angle_y', 'distance', 'size_x', 'size_y', 'target_num', 'frame']
        fieldtypes = ['uint64_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"frame": "MAV_FRAME"}
        fieldunits_by_name = {"time_usec": "us", "angle_x": "rad", "angle_y": "rad", "distance": "m", "size_x": "rad", "size_y": "rad"}
        format = '<QfffffBB'
        native_format = bytearray('<QfffffBB', 'ascii')
        orders = [0, 6, 7, 1, 2, 3, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 200
        unpacker = struct.Struct('<QfffffBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, target_num, frame, angle_x, angle_y, distance, size_x, size_y):
                MAVLink_message.__init__(self, MAVLink_landing_target_message.id, MAVLink_landing_target_message.name)
                self._fieldnames = MAVLink_landing_target_message.fieldnames
                self._instance_field = MAVLink_landing_target_message.instance_field
                self._instance_offset = MAVLink_landing_target_message.instance_offset
                self.time_usec = time_usec
                self.target_num = target_num
                self.frame = frame
                self.angle_x = angle_x
                self.angle_y = angle_y
                self.distance = distance
                self.size_x = size_x
                self.size_y = size_y

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 200, struct.pack('<QfffffBB', self.time_usec, self.angle_x, self.angle_y, self.distance, self.size_x, self.size_y, self.target_num, self.frame), force_mavlink1=force_mavlink1)

class MAVLink_fence_status_message(MAVLink_message):
        '''
        Status of geo-fencing. Sent in extended status stream when
        fencing enabled.
        '''
        id = MAVLINK_MSG_ID_FENCE_STATUS
        name = 'FENCE_STATUS'
        fieldnames = ['breach_status', 'breach_count', 'breach_type', 'breach_time']
        ordered_fieldnames = ['breach_time', 'breach_count', 'breach_status', 'breach_type']
        fieldtypes = ['uint8_t', 'uint16_t', 'uint8_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"breach_type": "FENCE_BREACH"}
        fieldunits_by_name = {"breach_time": "ms"}
        format = '<IHBB'
        native_format = bytearray('<IHBB', 'ascii')
        orders = [2, 1, 3, 0]
        lengths = [1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0]
        crc_extra = 189
        unpacker = struct.Struct('<IHBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, breach_status, breach_count, breach_type, breach_time):
                MAVLink_message.__init__(self, MAVLink_fence_status_message.id, MAVLink_fence_status_message.name)
                self._fieldnames = MAVLink_fence_status_message.fieldnames
                self._instance_field = MAVLink_fence_status_message.instance_field
                self._instance_offset = MAVLink_fence_status_message.instance_offset
                self.breach_status = breach_status
                self.breach_count = breach_count
                self.breach_type = breach_type
                self.breach_time = breach_time

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 189, struct.pack('<IHBB', self.breach_time, self.breach_count, self.breach_status, self.breach_type), force_mavlink1=force_mavlink1)

class MAVLink_mag_cal_report_message(MAVLink_message):
        '''
        Reports results of completed compass calibration. Sent until
        MAG_CAL_ACK received.
        '''
        id = MAVLINK_MSG_ID_MAG_CAL_REPORT
        name = 'MAG_CAL_REPORT'
        fieldnames = ['compass_id', 'cal_mask', 'cal_status', 'autosaved', 'fitness', 'ofs_x', 'ofs_y', 'ofs_z', 'diag_x', 'diag_y', 'diag_z', 'offdiag_x', 'offdiag_y', 'offdiag_z']
        ordered_fieldnames = ['fitness', 'ofs_x', 'ofs_y', 'ofs_z', 'diag_x', 'diag_y', 'diag_z', 'offdiag_x', 'offdiag_y', 'offdiag_z', 'compass_id', 'cal_mask', 'cal_status', 'autosaved']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"cal_mask": "bitmask"}
        fieldenums_by_name = {"cal_status": "MAG_CAL_STATUS"}
        fieldunits_by_name = {"fitness": "mgauss"}
        format = '<ffffffffffBBBB'
        native_format = bytearray('<ffffffffffBBBB', 'ascii')
        orders = [10, 11, 12, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 36
        unpacker = struct.Struct('<ffffffffffBBBB')
        instance_field = 'compass_id'
        instance_offset = 40

        def __init__(self, compass_id, cal_mask, cal_status, autosaved, fitness, ofs_x, ofs_y, ofs_z, diag_x, diag_y, diag_z, offdiag_x, offdiag_y, offdiag_z):
                MAVLink_message.__init__(self, MAVLink_mag_cal_report_message.id, MAVLink_mag_cal_report_message.name)
                self._fieldnames = MAVLink_mag_cal_report_message.fieldnames
                self._instance_field = MAVLink_mag_cal_report_message.instance_field
                self._instance_offset = MAVLink_mag_cal_report_message.instance_offset
                self.compass_id = compass_id
                self.cal_mask = cal_mask
                self.cal_status = cal_status
                self.autosaved = autosaved
                self.fitness = fitness
                self.ofs_x = ofs_x
                self.ofs_y = ofs_y
                self.ofs_z = ofs_z
                self.diag_x = diag_x
                self.diag_y = diag_y
                self.diag_z = diag_z
                self.offdiag_x = offdiag_x
                self.offdiag_y = offdiag_y
                self.offdiag_z = offdiag_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 36, struct.pack('<ffffffffffBBBB', self.fitness, self.ofs_x, self.ofs_y, self.ofs_z, self.diag_x, self.diag_y, self.diag_z, self.offdiag_x, self.offdiag_y, self.offdiag_z, self.compass_id, self.cal_mask, self.cal_status, self.autosaved), force_mavlink1=force_mavlink1)

class MAVLink_efi_status_message(MAVLink_message):
        '''
        EFI status output
        '''
        id = MAVLINK_MSG_ID_EFI_STATUS
        name = 'EFI_STATUS'
        fieldnames = ['health', 'ecu_index', 'rpm', 'fuel_consumed', 'fuel_flow', 'engine_load', 'throttle_position', 'spark_dwell_time', 'barometric_pressure', 'intake_manifold_pressure', 'intake_manifold_temperature', 'cylinder_head_temperature', 'ignition_timing', 'injection_time', 'exhaust_gas_temperature', 'throttle_out', 'pt_compensation']
        ordered_fieldnames = ['ecu_index', 'rpm', 'fuel_consumed', 'fuel_flow', 'engine_load', 'throttle_position', 'spark_dwell_time', 'barometric_pressure', 'intake_manifold_pressure', 'intake_manifold_temperature', 'cylinder_head_temperature', 'ignition_timing', 'injection_time', 'exhaust_gas_temperature', 'throttle_out', 'pt_compensation', 'health']
        fieldtypes = ['uint8_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"fuel_consumed": "cm^3", "fuel_flow": "cm^3/min", "engine_load": "%", "throttle_position": "%", "spark_dwell_time": "ms", "barometric_pressure": "kPa", "intake_manifold_pressure": "kPa", "intake_manifold_temperature": "degC", "cylinder_head_temperature": "degC", "ignition_timing": "deg", "injection_time": "ms", "exhaust_gas_temperature": "degC", "throttle_out": "%"}
        format = '<ffffffffffffffffB'
        native_format = bytearray('<ffffffffffffffffB', 'ascii')
        orders = [16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 208
        unpacker = struct.Struct('<ffffffffffffffffB')
        instance_field = None
        instance_offset = -1

        def __init__(self, health, ecu_index, rpm, fuel_consumed, fuel_flow, engine_load, throttle_position, spark_dwell_time, barometric_pressure, intake_manifold_pressure, intake_manifold_temperature, cylinder_head_temperature, ignition_timing, injection_time, exhaust_gas_temperature, throttle_out, pt_compensation):
                MAVLink_message.__init__(self, MAVLink_efi_status_message.id, MAVLink_efi_status_message.name)
                self._fieldnames = MAVLink_efi_status_message.fieldnames
                self._instance_field = MAVLink_efi_status_message.instance_field
                self._instance_offset = MAVLink_efi_status_message.instance_offset
                self.health = health
                self.ecu_index = ecu_index
                self.rpm = rpm
                self.fuel_consumed = fuel_consumed
                self.fuel_flow = fuel_flow
                self.engine_load = engine_load
                self.throttle_position = throttle_position
                self.spark_dwell_time = spark_dwell_time
                self.barometric_pressure = barometric_pressure
                self.intake_manifold_pressure = intake_manifold_pressure
                self.intake_manifold_temperature = intake_manifold_temperature
                self.cylinder_head_temperature = cylinder_head_temperature
                self.ignition_timing = ignition_timing
                self.injection_time = injection_time
                self.exhaust_gas_temperature = exhaust_gas_temperature
                self.throttle_out = throttle_out
                self.pt_compensation = pt_compensation

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 208, struct.pack('<ffffffffffffffffB', self.ecu_index, self.rpm, self.fuel_consumed, self.fuel_flow, self.engine_load, self.throttle_position, self.spark_dwell_time, self.barometric_pressure, self.intake_manifold_pressure, self.intake_manifold_temperature, self.cylinder_head_temperature, self.ignition_timing, self.injection_time, self.exhaust_gas_temperature, self.throttle_out, self.pt_compensation, self.health), force_mavlink1=force_mavlink1)

class MAVLink_estimator_status_message(MAVLink_message):
        '''
        Estimator status message including flags, innovation test
        ratios and estimated accuracies. The flags message is an
        integer bitmask containing information on which EKF outputs
        are valid. See the ESTIMATOR_STATUS_FLAGS enum definition for
        further information. The innovation test ratios show the
        magnitude of the sensor innovation divided by the innovation
        check threshold. Under normal operation the innovation test
        ratios should be below 0.5 with occasional values up to 1.0.
        Values greater than 1.0 should be rare under normal operation
        and indicate that a measurement has been rejected by the
        filter. The user should be notified if an innovation test
        ratio greater than 1.0 is recorded. Notifications for values
        in the range between 0.5 and 1.0 should be optional and
        controllable by the user.
        '''
        id = MAVLINK_MSG_ID_ESTIMATOR_STATUS
        name = 'ESTIMATOR_STATUS'
        fieldnames = ['time_usec', 'flags', 'vel_ratio', 'pos_horiz_ratio', 'pos_vert_ratio', 'mag_ratio', 'hagl_ratio', 'tas_ratio', 'pos_horiz_accuracy', 'pos_vert_accuracy']
        ordered_fieldnames = ['time_usec', 'vel_ratio', 'pos_horiz_ratio', 'pos_vert_ratio', 'mag_ratio', 'hagl_ratio', 'tas_ratio', 'pos_horiz_accuracy', 'pos_vert_accuracy', 'flags']
        fieldtypes = ['uint64_t', 'uint16_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {"flags": "bitmask"}
        fieldenums_by_name = {"flags": "ESTIMATOR_STATUS_FLAGS"}
        fieldunits_by_name = {"time_usec": "us", "pos_horiz_accuracy": "m", "pos_vert_accuracy": "m"}
        format = '<QffffffffH'
        native_format = bytearray('<QffffffffH', 'ascii')
        orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 163
        unpacker = struct.Struct('<QffffffffH')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, flags, vel_ratio, pos_horiz_ratio, pos_vert_ratio, mag_ratio, hagl_ratio, tas_ratio, pos_horiz_accuracy, pos_vert_accuracy):
                MAVLink_message.__init__(self, MAVLink_estimator_status_message.id, MAVLink_estimator_status_message.name)
                self._fieldnames = MAVLink_estimator_status_message.fieldnames
                self._instance_field = MAVLink_estimator_status_message.instance_field
                self._instance_offset = MAVLink_estimator_status_message.instance_offset
                self.time_usec = time_usec
                self.flags = flags
                self.vel_ratio = vel_ratio
                self.pos_horiz_ratio = pos_horiz_ratio
                self.pos_vert_ratio = pos_vert_ratio
                self.mag_ratio = mag_ratio
                self.hagl_ratio = hagl_ratio
                self.tas_ratio = tas_ratio
                self.pos_horiz_accuracy = pos_horiz_accuracy
                self.pos_vert_accuracy = pos_vert_accuracy

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 163, struct.pack('<QffffffffH', self.time_usec, self.vel_ratio, self.pos_horiz_ratio, self.pos_vert_ratio, self.mag_ratio, self.hagl_ratio, self.tas_ratio, self.pos_horiz_accuracy, self.pos_vert_accuracy, self.flags), force_mavlink1=force_mavlink1)

class MAVLink_wind_cov_message(MAVLink_message):
        '''
        Wind covariance estimate from vehicle.
        '''
        id = MAVLINK_MSG_ID_WIND_COV
        name = 'WIND_COV'
        fieldnames = ['time_usec', 'wind_x', 'wind_y', 'wind_z', 'var_horiz', 'var_vert', 'wind_alt', 'horiz_accuracy', 'vert_accuracy']
        ordered_fieldnames = ['time_usec', 'wind_x', 'wind_y', 'wind_z', 'var_horiz', 'var_vert', 'wind_alt', 'horiz_accuracy', 'vert_accuracy']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us", "wind_x": "m/s", "wind_y": "m/s", "wind_z": "m/s", "var_horiz": "m/s", "var_vert": "m/s", "wind_alt": "m", "horiz_accuracy": "m", "vert_accuracy": "m"}
        format = '<Qffffffff'
        native_format = bytearray('<Qffffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 105
        unpacker = struct.Struct('<Qffffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, wind_x, wind_y, wind_z, var_horiz, var_vert, wind_alt, horiz_accuracy, vert_accuracy):
                MAVLink_message.__init__(self, MAVLink_wind_cov_message.id, MAVLink_wind_cov_message.name)
                self._fieldnames = MAVLink_wind_cov_message.fieldnames
                self._instance_field = MAVLink_wind_cov_message.instance_field
                self._instance_offset = MAVLink_wind_cov_message.instance_offset
                self.time_usec = time_usec
                self.wind_x = wind_x
                self.wind_y = wind_y
                self.wind_z = wind_z
                self.var_horiz = var_horiz
                self.var_vert = var_vert
                self.wind_alt = wind_alt
                self.horiz_accuracy = horiz_accuracy
                self.vert_accuracy = vert_accuracy

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 105, struct.pack('<Qffffffff', self.time_usec, self.wind_x, self.wind_y, self.wind_z, self.var_horiz, self.var_vert, self.wind_alt, self.horiz_accuracy, self.vert_accuracy), force_mavlink1=force_mavlink1)

class MAVLink_gps_input_message(MAVLink_message):
        '''
        GPS sensor input message.  This is a raw sensor value sent by
        the GPS. This is NOT the global position estimate of the
        system.
        '''
        id = MAVLINK_MSG_ID_GPS_INPUT
        name = 'GPS_INPUT'
        fieldnames = ['time_usec', 'gps_id', 'ignore_flags', 'time_week_ms', 'time_week', 'fix_type', 'lat', 'lon', 'alt', 'hdop', 'vdop', 'vn', 've', 'vd', 'speed_accuracy', 'horiz_accuracy', 'vert_accuracy', 'satellites_visible']
        ordered_fieldnames = ['time_usec', 'time_week_ms', 'lat', 'lon', 'alt', 'hdop', 'vdop', 'vn', 've', 'vd', 'speed_accuracy', 'horiz_accuracy', 'vert_accuracy', 'ignore_flags', 'time_week', 'gps_id', 'fix_type', 'satellites_visible']
        fieldtypes = ['uint64_t', 'uint8_t', 'uint16_t', 'uint32_t', 'uint16_t', 'uint8_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'uint8_t']
        fielddisplays_by_name = {"ignore_flags": "bitmask"}
        fieldenums_by_name = {"ignore_flags": "GPS_INPUT_IGNORE_FLAGS"}
        fieldunits_by_name = {"time_usec": "us", "time_week_ms": "ms", "lat": "degE7", "lon": "degE7", "alt": "m", "vn": "m/s", "ve": "m/s", "vd": "m/s", "speed_accuracy": "m/s", "horiz_accuracy": "m", "vert_accuracy": "m"}
        format = '<QIiifffffffffHHBBB'
        native_format = bytearray('<QIiifffffffffHHBBB', 'ascii')
        orders = [0, 15, 13, 1, 14, 16, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 17]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 151
        unpacker = struct.Struct('<QIiifffffffffHHBBB')
        instance_field = 'gps_id'
        instance_offset = 60

        def __init__(self, time_usec, gps_id, ignore_flags, time_week_ms, time_week, fix_type, lat, lon, alt, hdop, vdop, vn, ve, vd, speed_accuracy, horiz_accuracy, vert_accuracy, satellites_visible):
                MAVLink_message.__init__(self, MAVLink_gps_input_message.id, MAVLink_gps_input_message.name)
                self._fieldnames = MAVLink_gps_input_message.fieldnames
                self._instance_field = MAVLink_gps_input_message.instance_field
                self._instance_offset = MAVLink_gps_input_message.instance_offset
                self.time_usec = time_usec
                self.gps_id = gps_id
                self.ignore_flags = ignore_flags
                self.time_week_ms = time_week_ms
                self.time_week = time_week
                self.fix_type = fix_type
                self.lat = lat
                self.lon = lon
                self.alt = alt
                self.hdop = hdop
                self.vdop = vdop
                self.vn = vn
                self.ve = ve
                self.vd = vd
                self.speed_accuracy = speed_accuracy
                self.horiz_accuracy = horiz_accuracy
                self.vert_accuracy = vert_accuracy
                self.satellites_visible = satellites_visible

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 151, struct.pack('<QIiifffffffffHHBBB', self.time_usec, self.time_week_ms, self.lat, self.lon, self.alt, self.hdop, self.vdop, self.vn, self.ve, self.vd, self.speed_accuracy, self.horiz_accuracy, self.vert_accuracy, self.ignore_flags, self.time_week, self.gps_id, self.fix_type, self.satellites_visible), force_mavlink1=force_mavlink1)

class MAVLink_gps_rtcm_data_message(MAVLink_message):
        '''
        RTCM message for injecting into the onboard GPS (used for
        DGPS)
        '''
        id = MAVLINK_MSG_ID_GPS_RTCM_DATA
        name = 'GPS_RTCM_DATA'
        fieldnames = ['flags', 'len', 'data']
        ordered_fieldnames = ['flags', 'len', 'data']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"len": "bytes"}
        format = '<BB180B'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 180]
        array_lengths = [0, 0, 180]
        crc_extra = 35
        unpacker = struct.Struct('<BB180B')
        instance_field = None
        instance_offset = -1

        def __init__(self, flags, len, data):
                MAVLink_message.__init__(self, MAVLink_gps_rtcm_data_message.id, MAVLink_gps_rtcm_data_message.name)
                self._fieldnames = MAVLink_gps_rtcm_data_message.fieldnames
                self._instance_field = MAVLink_gps_rtcm_data_message.instance_field
                self._instance_offset = MAVLink_gps_rtcm_data_message.instance_offset
                self.flags = flags
                self.len = len
                self.data = data

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 35, struct.pack('<BB180B', self.flags, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109], self.data[110], self.data[111], self.data[112], self.data[113], self.data[114], self.data[115], self.data[116], self.data[117], self.data[118], self.data[119], self.data[120], self.data[121], self.data[122], self.data[123], self.data[124], self.data[125], self.data[126], self.data[127], self.data[128], self.data[129], self.data[130], self.data[131], self.data[132], self.data[133], self.data[134], self.data[135], self.data[136], self.data[137], self.data[138], self.data[139], self.data[140], self.data[141], self.data[142], self.data[143], self.data[144], self.data[145], self.data[146], self.data[147], self.data[148], self.data[149], self.data[150], self.data[151], self.data[152], self.data[153], self.data[154], self.data[155], self.data[156], self.data[157], self.data[158], self.data[159], self.data[160], self.data[161], self.data[162], self.data[163], self.data[164], self.data[165], self.data[166], self.data[167], self.data[168], self.data[169], self.data[170], self.data[171], self.data[172], self.data[173], self.data[174], self.data[175], self.data[176], self.data[177], self.data[178], self.data[179]), force_mavlink1=force_mavlink1)

class MAVLink_high_latency_message(MAVLink_message):
        '''
        Message appropriate for high latency connections like Iridium
        '''
        id = MAVLINK_MSG_ID_HIGH_LATENCY
        name = 'HIGH_LATENCY'
        fieldnames = ['base_mode', 'custom_mode', 'landed_state', 'roll', 'pitch', 'heading', 'throttle', 'heading_sp', 'latitude', 'longitude', 'altitude_amsl', 'altitude_sp', 'airspeed', 'airspeed_sp', 'groundspeed', 'climb_rate', 'gps_nsat', 'gps_fix_type', 'battery_remaining', 'temperature', 'temperature_air', 'failsafe', 'wp_num', 'wp_distance']
        ordered_fieldnames = ['custom_mode', 'latitude', 'longitude', 'roll', 'pitch', 'heading', 'heading_sp', 'altitude_amsl', 'altitude_sp', 'wp_distance', 'base_mode', 'landed_state', 'throttle', 'airspeed', 'airspeed_sp', 'groundspeed', 'climb_rate', 'gps_nsat', 'gps_fix_type', 'battery_remaining', 'temperature', 'temperature_air', 'failsafe', 'wp_num']
        fieldtypes = ['uint8_t', 'uint32_t', 'uint8_t', 'int16_t', 'int16_t', 'uint16_t', 'int8_t', 'int16_t', 'int32_t', 'int32_t', 'int16_t', 'int16_t', 'uint8_t', 'uint8_t', 'uint8_t', 'int8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'int8_t', 'int8_t', 'uint8_t', 'uint8_t', 'uint16_t']
        fielddisplays_by_name = {"base_mode": "bitmask", "custom_mode": "bitmask"}
        fieldenums_by_name = {"base_mode": "MAV_MODE_FLAG", "landed_state": "MAV_LANDED_STATE", "gps_fix_type": "GPS_FIX_TYPE"}
        fieldunits_by_name = {"roll": "cdeg", "pitch": "cdeg", "heading": "cdeg", "throttle": "%", "heading_sp": "cdeg", "latitude": "degE7", "longitude": "degE7", "altitude_amsl": "m", "altitude_sp": "m", "airspeed": "m/s", "airspeed_sp": "m/s", "groundspeed": "m/s", "climb_rate": "m/s", "battery_remaining": "%", "temperature": "degC", "temperature_air": "degC", "wp_distance": "m"}
        format = '<IiihhHhhhHBBbBBBbBBBbbBB'
        native_format = bytearray('<IiihhHhhhHBBbBBBbBBBbbBB', 'ascii')
        orders = [10, 0, 11, 3, 4, 5, 12, 6, 1, 2, 7, 8, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 9]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 150
        unpacker = struct.Struct('<IiihhHhhhHBBbBBBbBBBbbBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, base_mode, custom_mode, landed_state, roll, pitch, heading, throttle, heading_sp, latitude, longitude, altitude_amsl, altitude_sp, airspeed, airspeed_sp, groundspeed, climb_rate, gps_nsat, gps_fix_type, battery_remaining, temperature, temperature_air, failsafe, wp_num, wp_distance):
                MAVLink_message.__init__(self, MAVLink_high_latency_message.id, MAVLink_high_latency_message.name)
                self._fieldnames = MAVLink_high_latency_message.fieldnames
                self._instance_field = MAVLink_high_latency_message.instance_field
                self._instance_offset = MAVLink_high_latency_message.instance_offset
                self.base_mode = base_mode
                self.custom_mode = custom_mode
                self.landed_state = landed_state
                self.roll = roll
                self.pitch = pitch
                self.heading = heading
                self.throttle = throttle
                self.heading_sp = heading_sp
                self.latitude = latitude
                self.longitude = longitude
                self.altitude_amsl = altitude_amsl
                self.altitude_sp = altitude_sp
                self.airspeed = airspeed
                self.airspeed_sp = airspeed_sp
                self.groundspeed = groundspeed
                self.climb_rate = climb_rate
                self.gps_nsat = gps_nsat
                self.gps_fix_type = gps_fix_type
                self.battery_remaining = battery_remaining
                self.temperature = temperature
                self.temperature_air = temperature_air
                self.failsafe = failsafe
                self.wp_num = wp_num
                self.wp_distance = wp_distance

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 150, struct.pack('<IiihhHhhhHBBbBBBbBBBbbBB', self.custom_mode, self.latitude, self.longitude, self.roll, self.pitch, self.heading, self.heading_sp, self.altitude_amsl, self.altitude_sp, self.wp_distance, self.base_mode, self.landed_state, self.throttle, self.airspeed, self.airspeed_sp, self.groundspeed, self.climb_rate, self.gps_nsat, self.gps_fix_type, self.battery_remaining, self.temperature, self.temperature_air, self.failsafe, self.wp_num), force_mavlink1=force_mavlink1)

class MAVLink_high_latency2_message(MAVLink_message):
        '''
        Message appropriate for high latency connections like Iridium
        (version 2)
        '''
        id = MAVLINK_MSG_ID_HIGH_LATENCY2
        name = 'HIGH_LATENCY2'
        fieldnames = ['timestamp', 'type', 'autopilot', 'custom_mode', 'latitude', 'longitude', 'altitude', 'target_altitude', 'heading', 'target_heading', 'target_distance', 'throttle', 'airspeed', 'airspeed_sp', 'groundspeed', 'windspeed', 'wind_heading', 'eph', 'epv', 'temperature_air', 'climb_rate', 'battery', 'wp_num', 'failure_flags', 'custom0', 'custom1', 'custom2']
        ordered_fieldnames = ['timestamp', 'latitude', 'longitude', 'custom_mode', 'altitude', 'target_altitude', 'target_distance', 'wp_num', 'failure_flags', 'type', 'autopilot', 'heading', 'target_heading', 'throttle', 'airspeed', 'airspeed_sp', 'groundspeed', 'windspeed', 'wind_heading', 'eph', 'epv', 'temperature_air', 'climb_rate', 'battery', 'custom0', 'custom1', 'custom2']
        fieldtypes = ['uint32_t', 'uint8_t', 'uint8_t', 'uint16_t', 'int32_t', 'int32_t', 'int16_t', 'int16_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'uint8_t', 'int8_t', 'int8_t', 'int8_t', 'uint16_t', 'uint16_t', 'int8_t', 'int8_t', 'int8_t']
        fielddisplays_by_name = {"custom_mode": "bitmask", "failure_flags": "bitmask"}
        fieldenums_by_name = {"type": "MAV_TYPE", "autopilot": "MAV_AUTOPILOT", "failure_flags": "HL_FAILURE_FLAG"}
        fieldunits_by_name = {"timestamp": "ms", "latitude": "degE7", "longitude": "degE7", "altitude": "m", "target_altitude": "m", "heading": "deg/2", "target_heading": "deg/2", "target_distance": "dam", "throttle": "%", "airspeed": "m/s*5", "airspeed_sp": "m/s*5", "groundspeed": "m/s*5", "windspeed": "m/s*5", "wind_heading": "deg/2", "eph": "dm", "epv": "dm", "temperature_air": "degC", "climb_rate": "dm/s", "battery": "%"}
        format = '<IiiHhhHHHBBBBBBBBBBBBbbbbbb'
        native_format = bytearray('<IiiHhhHHHBBBBBBBBBBBBbbbbbb', 'ascii')
        orders = [0, 9, 10, 3, 1, 2, 4, 5, 11, 12, 6, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 7, 8, 24, 25, 26]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        crc_extra = 179
        unpacker = struct.Struct('<IiiHhhHHHBBBBBBBBBBBBbbbbbb')
        instance_field = None
        instance_offset = -1

        def __init__(self, timestamp, type, autopilot, custom_mode, latitude, longitude, altitude, target_altitude, heading, target_heading, target_distance, throttle, airspeed, airspeed_sp, groundspeed, windspeed, wind_heading, eph, epv, temperature_air, climb_rate, battery, wp_num, failure_flags, custom0, custom1, custom2):
                MAVLink_message.__init__(self, MAVLink_high_latency2_message.id, MAVLink_high_latency2_message.name)
                self._fieldnames = MAVLink_high_latency2_message.fieldnames
                self._instance_field = MAVLink_high_latency2_message.instance_field
                self._instance_offset = MAVLink_high_latency2_message.instance_offset
                self.timestamp = timestamp
                self.type = type
                self.autopilot = autopilot
                self.custom_mode = custom_mode
                self.latitude = latitude
                self.longitude = longitude
                self.altitude = altitude
                self.target_altitude = target_altitude
                self.heading = heading
                self.target_heading = target_heading
                self.target_distance = target_distance
                self.throttle = throttle
                self.airspeed = airspeed
                self.airspeed_sp = airspeed_sp
                self.groundspeed = groundspeed
                self.windspeed = windspeed
                self.wind_heading = wind_heading
                self.eph = eph
                self.epv = epv
                self.temperature_air = temperature_air
                self.climb_rate = climb_rate
                self.battery = battery
                self.wp_num = wp_num
                self.failure_flags = failure_flags
                self.custom0 = custom0
                self.custom1 = custom1
                self.custom2 = custom2

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 179, struct.pack('<IiiHhhHHHBBBBBBBBBBBBbbbbbb', self.timestamp, self.latitude, self.longitude, self.custom_mode, self.altitude, self.target_altitude, self.target_distance, self.wp_num, self.failure_flags, self.type, self.autopilot, self.heading, self.target_heading, self.throttle, self.airspeed, self.airspeed_sp, self.groundspeed, self.windspeed, self.wind_heading, self.eph, self.epv, self.temperature_air, self.climb_rate, self.battery, self.custom0, self.custom1, self.custom2), force_mavlink1=force_mavlink1)

class MAVLink_vibration_message(MAVLink_message):
        '''
        Vibration levels and accelerometer clipping
        '''
        id = MAVLINK_MSG_ID_VIBRATION
        name = 'VIBRATION'
        fieldnames = ['time_usec', 'vibration_x', 'vibration_y', 'vibration_z', 'clipping_0', 'clipping_1', 'clipping_2']
        ordered_fieldnames = ['time_usec', 'vibration_x', 'vibration_y', 'vibration_z', 'clipping_0', 'clipping_1', 'clipping_2']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'uint32_t', 'uint32_t', 'uint32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<QfffIII'
        native_format = bytearray('<QfffIII', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 90
        unpacker = struct.Struct('<QfffIII')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_usec, vibration_x, vibration_y, vibration_z, clipping_0, clipping_1, clipping_2):
                MAVLink_message.__init__(self, MAVLink_vibration_message.id, MAVLink_vibration_message.name)
                self._fieldnames = MAVLink_vibration_message.fieldnames
                self._instance_field = MAVLink_vibration_message.instance_field
                self._instance_offset = MAVLink_vibration_message.instance_offset
                self.time_usec = time_usec
                self.vibration_x = vibration_x
                self.vibration_y = vibration_y
                self.vibration_z = vibration_z
                self.clipping_0 = clipping_0
                self.clipping_1 = clipping_1
                self.clipping_2 = clipping_2

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 90, struct.pack('<QfffIII', self.time_usec, self.vibration_x, self.vibration_y, self.vibration_z, self.clipping_0, self.clipping_1, self.clipping_2), force_mavlink1=force_mavlink1)

class MAVLink_home_position_message(MAVLink_message):
        '''
        This message can be requested by sending the
        MAV_CMD_GET_HOME_POSITION command. The position the system
        will return to and land on. The position is set automatically
        by the system during the takeoff in case it was not explicitly
        set by the operator before or after. The global and local
        positions encode the position in the respective coordinate
        frames, while the q parameter encodes the orientation of the
        surface. Under normal conditions it describes the heading and
        terrain slope, which can be used by the aircraft to adjust the
        approach. The approach 3D vector describes the point to which
        the system should fly in normal flight mode and then perform a
        landing sequence along the vector.
        '''
        id = MAVLINK_MSG_ID_HOME_POSITION
        name = 'HOME_POSITION'
        fieldnames = ['latitude', 'longitude', 'altitude', 'x', 'y', 'z', 'q', 'approach_x', 'approach_y', 'approach_z']
        ordered_fieldnames = ['latitude', 'longitude', 'altitude', 'x', 'y', 'z', 'q', 'approach_x', 'approach_y', 'approach_z']
        fieldtypes = ['int32_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm", "x": "m", "y": "m", "z": "m", "approach_x": "m", "approach_y": "m", "approach_z": "m"}
        format = '<iiifff4ffff'
        native_format = bytearray('<iiifffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 4, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 4, 0, 0, 0]
        crc_extra = 104
        unpacker = struct.Struct('<iiifff4ffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, latitude, longitude, altitude, x, y, z, q, approach_x, approach_y, approach_z):
                MAVLink_message.__init__(self, MAVLink_home_position_message.id, MAVLink_home_position_message.name)
                self._fieldnames = MAVLink_home_position_message.fieldnames
                self._instance_field = MAVLink_home_position_message.instance_field
                self._instance_offset = MAVLink_home_position_message.instance_offset
                self.latitude = latitude
                self.longitude = longitude
                self.altitude = altitude
                self.x = x
                self.y = y
                self.z = z
                self.q = q
                self.approach_x = approach_x
                self.approach_y = approach_y
                self.approach_z = approach_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 104, struct.pack('<iiifff4ffff', self.latitude, self.longitude, self.altitude, self.x, self.y, self.z, self.q[0], self.q[1], self.q[2], self.q[3], self.approach_x, self.approach_y, self.approach_z), force_mavlink1=force_mavlink1)

class MAVLink_set_home_position_message(MAVLink_message):
        '''
        The position the system will return to and land on. The
        position is set automatically by the system during the takeoff
        in case it was not explicitly set by the operator before or
        after. The global and local positions encode the position in
        the respective coordinate frames, while the q parameter
        encodes the orientation of the surface. Under normal
        conditions it describes the heading and terrain slope, which
        can be used by the aircraft to adjust the approach. The
        approach 3D vector describes the point to which the system
        should fly in normal flight mode and then perform a landing
        sequence along the vector.
        '''
        id = MAVLINK_MSG_ID_SET_HOME_POSITION
        name = 'SET_HOME_POSITION'
        fieldnames = ['target_system', 'latitude', 'longitude', 'altitude', 'x', 'y', 'z', 'q', 'approach_x', 'approach_y', 'approach_z']
        ordered_fieldnames = ['latitude', 'longitude', 'altitude', 'x', 'y', 'z', 'q', 'approach_x', 'approach_y', 'approach_z', 'target_system']
        fieldtypes = ['uint8_t', 'int32_t', 'int32_t', 'int32_t', 'float', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm", "x": "m", "y": "m", "z": "m", "approach_x": "m", "approach_y": "m", "approach_z": "m"}
        format = '<iiifff4ffffB'
        native_format = bytearray('<iiifffffffB', 'ascii')
        orders = [10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        lengths = [1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0]
        crc_extra = 85
        unpacker = struct.Struct('<iiifff4ffffB')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_system, latitude, longitude, altitude, x, y, z, q, approach_x, approach_y, approach_z):
                MAVLink_message.__init__(self, MAVLink_set_home_position_message.id, MAVLink_set_home_position_message.name)
                self._fieldnames = MAVLink_set_home_position_message.fieldnames
                self._instance_field = MAVLink_set_home_position_message.instance_field
                self._instance_offset = MAVLink_set_home_position_message.instance_offset
                self.target_system = target_system
                self.latitude = latitude
                self.longitude = longitude
                self.altitude = altitude
                self.x = x
                self.y = y
                self.z = z
                self.q = q
                self.approach_x = approach_x
                self.approach_y = approach_y
                self.approach_z = approach_z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 85, struct.pack('<iiifff4ffffB', self.latitude, self.longitude, self.altitude, self.x, self.y, self.z, self.q[0], self.q[1], self.q[2], self.q[3], self.approach_x, self.approach_y, self.approach_z, self.target_system), force_mavlink1=force_mavlink1)

class MAVLink_message_interval_message(MAVLink_message):
        '''
        The interval between messages for a particular MAVLink message
        ID. This message is the response to the
        MAV_CMD_GET_MESSAGE_INTERVAL command. This interface replaces
        DATA_STREAM.
        '''
        id = MAVLINK_MSG_ID_MESSAGE_INTERVAL
        name = 'MESSAGE_INTERVAL'
        fieldnames = ['message_id', 'interval_us']
        ordered_fieldnames = ['interval_us', 'message_id']
        fieldtypes = ['uint16_t', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"interval_us": "us"}
        format = '<iH'
        native_format = bytearray('<iH', 'ascii')
        orders = [1, 0]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 95
        unpacker = struct.Struct('<iH')
        instance_field = None
        instance_offset = -1

        def __init__(self, message_id, interval_us):
                MAVLink_message.__init__(self, MAVLink_message_interval_message.id, MAVLink_message_interval_message.name)
                self._fieldnames = MAVLink_message_interval_message.fieldnames
                self._instance_field = MAVLink_message_interval_message.instance_field
                self._instance_offset = MAVLink_message_interval_message.instance_offset
                self.message_id = message_id
                self.interval_us = interval_us

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 95, struct.pack('<iH', self.interval_us, self.message_id), force_mavlink1=force_mavlink1)

class MAVLink_extended_sys_state_message(MAVLink_message):
        '''
        Provides state for additional features
        '''
        id = MAVLINK_MSG_ID_EXTENDED_SYS_STATE
        name = 'EXTENDED_SYS_STATE'
        fieldnames = ['vtol_state', 'landed_state']
        ordered_fieldnames = ['vtol_state', 'landed_state']
        fieldtypes = ['uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"vtol_state": "MAV_VTOL_STATE", "landed_state": "MAV_LANDED_STATE"}
        fieldunits_by_name = {}
        format = '<BB'
        native_format = bytearray('<BB', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 0]
        crc_extra = 130
        unpacker = struct.Struct('<BB')
        instance_field = None
        instance_offset = -1

        def __init__(self, vtol_state, landed_state):
                MAVLink_message.__init__(self, MAVLink_extended_sys_state_message.id, MAVLink_extended_sys_state_message.name)
                self._fieldnames = MAVLink_extended_sys_state_message.fieldnames
                self._instance_field = MAVLink_extended_sys_state_message.instance_field
                self._instance_offset = MAVLink_extended_sys_state_message.instance_offset
                self.vtol_state = vtol_state
                self.landed_state = landed_state

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 130, struct.pack('<BB', self.vtol_state, self.landed_state), force_mavlink1=force_mavlink1)

class MAVLink_adsb_vehicle_message(MAVLink_message):
        '''
        The location and information of an ADSB vehicle
        '''
        id = MAVLINK_MSG_ID_ADSB_VEHICLE
        name = 'ADSB_VEHICLE'
        fieldnames = ['ICAO_address', 'lat', 'lon', 'altitude_type', 'altitude', 'heading', 'hor_velocity', 'ver_velocity', 'callsign', 'emitter_type', 'tslc', 'flags', 'squawk']
        ordered_fieldnames = ['ICAO_address', 'lat', 'lon', 'altitude', 'heading', 'hor_velocity', 'ver_velocity', 'flags', 'squawk', 'altitude_type', 'callsign', 'emitter_type', 'tslc']
        fieldtypes = ['uint32_t', 'int32_t', 'int32_t', 'uint8_t', 'int32_t', 'uint16_t', 'uint16_t', 'int16_t', 'char', 'uint8_t', 'uint8_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {"flags": "bitmask"}
        fieldenums_by_name = {"altitude_type": "ADSB_ALTITUDE_TYPE", "emitter_type": "ADSB_EMITTER_TYPE", "flags": "ADSB_FLAGS"}
        fieldunits_by_name = {"lat": "degE7", "lon": "degE7", "altitude": "mm", "heading": "cdeg", "hor_velocity": "cm/s", "ver_velocity": "cm/s", "tslc": "s"}
        format = '<IiiiHHhHHB9sBB'
        native_format = bytearray('<IiiiHHhHHBcBB', 'ascii')
        orders = [0, 1, 2, 9, 3, 4, 5, 6, 10, 11, 12, 7, 8]
        lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0]
        crc_extra = 184
        unpacker = struct.Struct('<IiiiHHhHHB9sBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, ICAO_address, lat, lon, altitude_type, altitude, heading, hor_velocity, ver_velocity, callsign, emitter_type, tslc, flags, squawk):
                MAVLink_message.__init__(self, MAVLink_adsb_vehicle_message.id, MAVLink_adsb_vehicle_message.name)
                self._fieldnames = MAVLink_adsb_vehicle_message.fieldnames
                self._instance_field = MAVLink_adsb_vehicle_message.instance_field
                self._instance_offset = MAVLink_adsb_vehicle_message.instance_offset
                self.ICAO_address = ICAO_address
                self.lat = lat
                self.lon = lon
                self.altitude_type = altitude_type
                self.altitude = altitude
                self.heading = heading
                self.hor_velocity = hor_velocity
                self.ver_velocity = ver_velocity
                self.callsign = callsign
                self.emitter_type = emitter_type
                self.tslc = tslc
                self.flags = flags
                self.squawk = squawk

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 184, struct.pack('<IiiiHHhHHB9sBB', self.ICAO_address, self.lat, self.lon, self.altitude, self.heading, self.hor_velocity, self.ver_velocity, self.flags, self.squawk, self.altitude_type, self.callsign, self.emitter_type, self.tslc), force_mavlink1=force_mavlink1)

class MAVLink_collision_message(MAVLink_message):
        '''
        Information about a potential collision
        '''
        id = MAVLINK_MSG_ID_COLLISION
        name = 'COLLISION'
        fieldnames = ['src', 'id', 'action', 'threat_level', 'time_to_minimum_delta', 'altitude_minimum_delta', 'horizontal_minimum_delta']
        ordered_fieldnames = ['id', 'time_to_minimum_delta', 'altitude_minimum_delta', 'horizontal_minimum_delta', 'src', 'action', 'threat_level']
        fieldtypes = ['uint8_t', 'uint32_t', 'uint8_t', 'uint8_t', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"src": "MAV_COLLISION_SRC", "action": "MAV_COLLISION_ACTION", "threat_level": "MAV_COLLISION_THREAT_LEVEL"}
        fieldunits_by_name = {"time_to_minimum_delta": "s", "altitude_minimum_delta": "m", "horizontal_minimum_delta": "m"}
        format = '<IfffBBB'
        native_format = bytearray('<IfffBBB', 'ascii')
        orders = [4, 0, 5, 6, 1, 2, 3]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 81
        unpacker = struct.Struct('<IfffBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, src, id, action, threat_level, time_to_minimum_delta, altitude_minimum_delta, horizontal_minimum_delta):
                MAVLink_message.__init__(self, MAVLink_collision_message.id, MAVLink_collision_message.name)
                self._fieldnames = MAVLink_collision_message.fieldnames
                self._instance_field = MAVLink_collision_message.instance_field
                self._instance_offset = MAVLink_collision_message.instance_offset
                self.src = src
                self.id = id
                self.action = action
                self.threat_level = threat_level
                self.time_to_minimum_delta = time_to_minimum_delta
                self.altitude_minimum_delta = altitude_minimum_delta
                self.horizontal_minimum_delta = horizontal_minimum_delta

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 81, struct.pack('<IfffBBB', self.id, self.time_to_minimum_delta, self.altitude_minimum_delta, self.horizontal_minimum_delta, self.src, self.action, self.threat_level), force_mavlink1=force_mavlink1)

class MAVLink_v2_extension_message(MAVLink_message):
        '''
        Message implementing parts of the V2 payload specs in V1
        frames for transitional support.
        '''
        id = MAVLINK_MSG_ID_V2_EXTENSION
        name = 'V2_EXTENSION'
        fieldnames = ['target_network', 'target_system', 'target_component', 'message_type', 'payload']
        ordered_fieldnames = ['message_type', 'target_network', 'target_system', 'target_component', 'payload']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint16_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HBBB249B'
        native_format = bytearray('<HBBBB', 'ascii')
        orders = [1, 2, 3, 0, 4]
        lengths = [1, 1, 1, 1, 249]
        array_lengths = [0, 0, 0, 0, 249]
        crc_extra = 8
        unpacker = struct.Struct('<HBBB249B')
        instance_field = None
        instance_offset = -1

        def __init__(self, target_network, target_system, target_component, message_type, payload):
                MAVLink_message.__init__(self, MAVLink_v2_extension_message.id, MAVLink_v2_extension_message.name)
                self._fieldnames = MAVLink_v2_extension_message.fieldnames
                self._instance_field = MAVLink_v2_extension_message.instance_field
                self._instance_offset = MAVLink_v2_extension_message.instance_offset
                self.target_network = target_network
                self.target_system = target_system
                self.target_component = target_component
                self.message_type = message_type
                self.payload = payload

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 8, struct.pack('<HBBB249B', self.message_type, self.target_network, self.target_system, self.target_component, self.payload[0], self.payload[1], self.payload[2], self.payload[3], self.payload[4], self.payload[5], self.payload[6], self.payload[7], self.payload[8], self.payload[9], self.payload[10], self.payload[11], self.payload[12], self.payload[13], self.payload[14], self.payload[15], self.payload[16], self.payload[17], self.payload[18], self.payload[19], self.payload[20], self.payload[21], self.payload[22], self.payload[23], self.payload[24], self.payload[25], self.payload[26], self.payload[27], self.payload[28], self.payload[29], self.payload[30], self.payload[31], self.payload[32], self.payload[33], self.payload[34], self.payload[35], self.payload[36], self.payload[37], self.payload[38], self.payload[39], self.payload[40], self.payload[41], self.payload[42], self.payload[43], self.payload[44], self.payload[45], self.payload[46], self.payload[47], self.payload[48], self.payload[49], self.payload[50], self.payload[51], self.payload[52], self.payload[53], self.payload[54], self.payload[55], self.payload[56], self.payload[57], self.payload[58], self.payload[59], self.payload[60], self.payload[61], self.payload[62], self.payload[63], self.payload[64], self.payload[65], self.payload[66], self.payload[67], self.payload[68], self.payload[69], self.payload[70], self.payload[71], self.payload[72], self.payload[73], self.payload[74], self.payload[75], self.payload[76], self.payload[77], self.payload[78], self.payload[79], self.payload[80], self.payload[81], self.payload[82], self.payload[83], self.payload[84], self.payload[85], self.payload[86], self.payload[87], self.payload[88], self.payload[89], self.payload[90], self.payload[91], self.payload[92], self.payload[93], self.payload[94], self.payload[95], self.payload[96], self.payload[97], self.payload[98], self.payload[99], self.payload[100], self.payload[101], self.payload[102], self.payload[103], self.payload[104], self.payload[105], self.payload[106], self.payload[107], self.payload[108], self.payload[109], self.payload[110], self.payload[111], self.payload[112], self.payload[113], self.payload[114], self.payload[115], self.payload[116], self.payload[117], self.payload[118], self.payload[119], self.payload[120], self.payload[121], self.payload[122], self.payload[123], self.payload[124], self.payload[125], self.payload[126], self.payload[127], self.payload[128], self.payload[129], self.payload[130], self.payload[131], self.payload[132], self.payload[133], self.payload[134], self.payload[135], self.payload[136], self.payload[137], self.payload[138], self.payload[139], self.payload[140], self.payload[141], self.payload[142], self.payload[143], self.payload[144], self.payload[145], self.payload[146], self.payload[147], self.payload[148], self.payload[149], self.payload[150], self.payload[151], self.payload[152], self.payload[153], self.payload[154], self.payload[155], self.payload[156], self.payload[157], self.payload[158], self.payload[159], self.payload[160], self.payload[161], self.payload[162], self.payload[163], self.payload[164], self.payload[165], self.payload[166], self.payload[167], self.payload[168], self.payload[169], self.payload[170], self.payload[171], self.payload[172], self.payload[173], self.payload[174], self.payload[175], self.payload[176], self.payload[177], self.payload[178], self.payload[179], self.payload[180], self.payload[181], self.payload[182], self.payload[183], self.payload[184], self.payload[185], self.payload[186], self.payload[187], self.payload[188], self.payload[189], self.payload[190], self.payload[191], self.payload[192], self.payload[193], self.payload[194], self.payload[195], self.payload[196], self.payload[197], self.payload[198], self.payload[199], self.payload[200], self.payload[201], self.payload[202], self.payload[203], self.payload[204], self.payload[205], self.payload[206], self.payload[207], self.payload[208], self.payload[209], self.payload[210], self.payload[211], self.payload[212], self.payload[213], self.payload[214], self.payload[215], self.payload[216], self.payload[217], self.payload[218], self.payload[219], self.payload[220], self.payload[221], self.payload[222], self.payload[223], self.payload[224], self.payload[225], self.payload[226], self.payload[227], self.payload[228], self.payload[229], self.payload[230], self.payload[231], self.payload[232], self.payload[233], self.payload[234], self.payload[235], self.payload[236], self.payload[237], self.payload[238], self.payload[239], self.payload[240], self.payload[241], self.payload[242], self.payload[243], self.payload[244], self.payload[245], self.payload[246], self.payload[247], self.payload[248]), force_mavlink1=force_mavlink1)

class MAVLink_memory_vect_message(MAVLink_message):
        '''
        Send raw controller memory. The use of this message is
        discouraged for normal packets, but a quite efficient way for
        testing new messages and getting experimental debug output.
        '''
        id = MAVLINK_MSG_ID_MEMORY_VECT
        name = 'MEMORY_VECT'
        fieldnames = ['address', 'ver', 'type', 'value']
        ordered_fieldnames = ['address', 'ver', 'type', 'value']
        fieldtypes = ['uint16_t', 'uint8_t', 'uint8_t', 'int8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<HBB32b'
        native_format = bytearray('<HBBb', 'ascii')
        orders = [0, 1, 2, 3]
        lengths = [1, 1, 1, 32]
        array_lengths = [0, 0, 0, 32]
        crc_extra = 204
        unpacker = struct.Struct('<HBB32b')
        instance_field = None
        instance_offset = -1

        def __init__(self, address, ver, type, value):
                MAVLink_message.__init__(self, MAVLink_memory_vect_message.id, MAVLink_memory_vect_message.name)
                self._fieldnames = MAVLink_memory_vect_message.fieldnames
                self._instance_field = MAVLink_memory_vect_message.instance_field
                self._instance_offset = MAVLink_memory_vect_message.instance_offset
                self.address = address
                self.ver = ver
                self.type = type
                self.value = value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 204, struct.pack('<HBB32b', self.address, self.ver, self.type, self.value[0], self.value[1], self.value[2], self.value[3], self.value[4], self.value[5], self.value[6], self.value[7], self.value[8], self.value[9], self.value[10], self.value[11], self.value[12], self.value[13], self.value[14], self.value[15], self.value[16], self.value[17], self.value[18], self.value[19], self.value[20], self.value[21], self.value[22], self.value[23], self.value[24], self.value[25], self.value[26], self.value[27], self.value[28], self.value[29], self.value[30], self.value[31]), force_mavlink1=force_mavlink1)

class MAVLink_debug_vect_message(MAVLink_message):
        '''
        To debug something using a named 3D vector.
        '''
        id = MAVLINK_MSG_ID_DEBUG_VECT
        name = 'DEBUG_VECT'
        fieldnames = ['name', 'time_usec', 'x', 'y', 'z']
        ordered_fieldnames = ['time_usec', 'x', 'y', 'z', 'name']
        fieldtypes = ['char', 'uint64_t', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_usec": "us"}
        format = '<Qfff10s'
        native_format = bytearray('<Qfffc', 'ascii')
        orders = [4, 0, 1, 2, 3]
        lengths = [1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 10]
        crc_extra = 49
        unpacker = struct.Struct('<Qfff10s')
        instance_field = 'name'
        instance_offset = 20

        def __init__(self, name, time_usec, x, y, z):
                MAVLink_message.__init__(self, MAVLink_debug_vect_message.id, MAVLink_debug_vect_message.name)
                self._fieldnames = MAVLink_debug_vect_message.fieldnames
                self._instance_field = MAVLink_debug_vect_message.instance_field
                self._instance_offset = MAVLink_debug_vect_message.instance_offset
                self.name = name
                self.time_usec = time_usec
                self.x = x
                self.y = y
                self.z = z

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 49, struct.pack('<Qfff10s', self.time_usec, self.x, self.y, self.z, self.name), force_mavlink1=force_mavlink1)

class MAVLink_named_value_float_message(MAVLink_message):
        '''
        Send a key-value pair as float. The use of this message is
        discouraged for normal packets, but a quite efficient way for
        testing new messages and getting experimental debug output.
        '''
        id = MAVLINK_MSG_ID_NAMED_VALUE_FLOAT
        name = 'NAMED_VALUE_FLOAT'
        fieldnames = ['time_boot_ms', 'name', 'value']
        ordered_fieldnames = ['time_boot_ms', 'value', 'name']
        fieldtypes = ['uint32_t', 'char', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms"}
        format = '<If10s'
        native_format = bytearray('<Ifc', 'ascii')
        orders = [0, 2, 1]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 10]
        crc_extra = 170
        unpacker = struct.Struct('<If10s')
        instance_field = 'name'
        instance_offset = 8

        def __init__(self, time_boot_ms, name, value):
                MAVLink_message.__init__(self, MAVLink_named_value_float_message.id, MAVLink_named_value_float_message.name)
                self._fieldnames = MAVLink_named_value_float_message.fieldnames
                self._instance_field = MAVLink_named_value_float_message.instance_field
                self._instance_offset = MAVLink_named_value_float_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.name = name
                self.value = value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 170, struct.pack('<If10s', self.time_boot_ms, self.value, self.name), force_mavlink1=force_mavlink1)

class MAVLink_named_value_int_message(MAVLink_message):
        '''
        Send a key-value pair as integer. The use of this message is
        discouraged for normal packets, but a quite efficient way for
        testing new messages and getting experimental debug output.
        '''
        id = MAVLINK_MSG_ID_NAMED_VALUE_INT
        name = 'NAMED_VALUE_INT'
        fieldnames = ['time_boot_ms', 'name', 'value']
        ordered_fieldnames = ['time_boot_ms', 'value', 'name']
        fieldtypes = ['uint32_t', 'char', 'int32_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms"}
        format = '<Ii10s'
        native_format = bytearray('<Iic', 'ascii')
        orders = [0, 2, 1]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 10]
        crc_extra = 44
        unpacker = struct.Struct('<Ii10s')
        instance_field = 'name'
        instance_offset = 8

        def __init__(self, time_boot_ms, name, value):
                MAVLink_message.__init__(self, MAVLink_named_value_int_message.id, MAVLink_named_value_int_message.name)
                self._fieldnames = MAVLink_named_value_int_message.fieldnames
                self._instance_field = MAVLink_named_value_int_message.instance_field
                self._instance_offset = MAVLink_named_value_int_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.name = name
                self.value = value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 44, struct.pack('<Ii10s', self.time_boot_ms, self.value, self.name), force_mavlink1=force_mavlink1)

class MAVLink_statustext_message(MAVLink_message):
        '''
        Status text message. These messages are printed in yellow in
        the COMM console of QGroundControl. WARNING: They consume
        quite some bandwidth, so use only for important status and
        error messages. If implemented wisely, these messages are
        buffered on the MCU and sent only at a limited rate (e.g. 10
        Hz).
        '''
        id = MAVLINK_MSG_ID_STATUSTEXT
        name = 'STATUSTEXT'
        fieldnames = ['severity', 'text']
        ordered_fieldnames = ['severity', 'text']
        fieldtypes = ['uint8_t', 'char']
        fielddisplays_by_name = {}
        fieldenums_by_name = {"severity": "MAV_SEVERITY"}
        fieldunits_by_name = {}
        format = '<B50s'
        native_format = bytearray('<Bc', 'ascii')
        orders = [0, 1]
        lengths = [1, 1]
        array_lengths = [0, 50]
        crc_extra = 83
        unpacker = struct.Struct('<B50s')
        instance_field = None
        instance_offset = -1

        def __init__(self, severity, text):
                MAVLink_message.__init__(self, MAVLink_statustext_message.id, MAVLink_statustext_message.name)
                self._fieldnames = MAVLink_statustext_message.fieldnames
                self._instance_field = MAVLink_statustext_message.instance_field
                self._instance_offset = MAVLink_statustext_message.instance_offset
                self.severity = severity
                self.text = text

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 83, struct.pack('<B50s', self.severity, self.text), force_mavlink1=force_mavlink1)

class MAVLink_debug_message(MAVLink_message):
        '''
        Send a debug value. The index is used to discriminate between
        values. These values show up in the plot of QGroundControl as
        DEBUG N.
        '''
        id = MAVLINK_MSG_ID_DEBUG
        name = 'DEBUG'
        fieldnames = ['time_boot_ms', 'ind', 'value']
        ordered_fieldnames = ['time_boot_ms', 'value', 'ind']
        fieldtypes = ['uint32_t', 'uint8_t', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {"time_boot_ms": "ms"}
        format = '<IfB'
        native_format = bytearray('<IfB', 'ascii')
        orders = [0, 2, 1]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 46
        unpacker = struct.Struct('<IfB')
        instance_field = None
        instance_offset = -1

        def __init__(self, time_boot_ms, ind, value):
                MAVLink_message.__init__(self, MAVLink_debug_message.id, MAVLink_debug_message.name)
                self._fieldnames = MAVLink_debug_message.fieldnames
                self._instance_field = MAVLink_debug_message.instance_field
                self._instance_offset = MAVLink_debug_message.instance_offset
                self.time_boot_ms = time_boot_ms
                self.ind = ind
                self.value = value

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 46, struct.pack('<IfB', self.time_boot_ms, self.value, self.ind), force_mavlink1=force_mavlink1)

class MAVLink_heartbeat_message(MAVLink_message):
        '''
        The heartbeat message shows that a system or component is
        present and responding. The type and autopilot fields (along
        with the message component id), allow the receiving system to
        treat further messages from this system appropriately (e.g. by
        laying out the user interface based on the autopilot). This
        microservice is documented at
        https://mavlink.io/en/services/heartbeat.html
        '''
        id = MAVLINK_MSG_ID_HEARTBEAT
        name = 'HEARTBEAT'
        fieldnames = ['type', 'autopilot', 'base_mode', 'custom_mode', 'system_status', 'mavlink_version']
        ordered_fieldnames = ['custom_mode', 'type', 'autopilot', 'base_mode', 'system_status', 'mavlink_version']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint32_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {"base_mode": "bitmask"}
        fieldenums_by_name = {"type": "MAV_TYPE", "autopilot": "MAV_AUTOPILOT", "base_mode": "MAV_MODE_FLAG", "system_status": "MAV_STATE"}
        fieldunits_by_name = {}
        format = '<IBBBBB'
        native_format = bytearray('<IBBBBB', 'ascii')
        orders = [1, 2, 3, 0, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 50
        unpacker = struct.Struct('<IBBBBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version):
                MAVLink_message.__init__(self, MAVLink_heartbeat_message.id, MAVLink_heartbeat_message.name)
                self._fieldnames = MAVLink_heartbeat_message.fieldnames
                self._instance_field = MAVLink_heartbeat_message.instance_field
                self._instance_offset = MAVLink_heartbeat_message.instance_offset
                self.type = type
                self.autopilot = autopilot
                self.base_mode = base_mode
                self.custom_mode = custom_mode
                self.system_status = system_status
                self.mavlink_version = mavlink_version

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 50, struct.pack('<IBBBBB', self.custom_mode, self.type, self.autopilot, self.base_mode, self.system_status, self.mavlink_version), force_mavlink1=force_mavlink1)

class MAVLink_nav_filter_bias_message(MAVLink_message):
        '''
        Accelerometer and Gyro biases from the navigation filter
        '''
        id = MAVLINK_MSG_ID_NAV_FILTER_BIAS
        name = 'NAV_FILTER_BIAS'
        fieldnames = ['usec', 'accel_0', 'accel_1', 'accel_2', 'gyro_0', 'gyro_1', 'gyro_2']
        ordered_fieldnames = ['usec', 'accel_0', 'accel_1', 'accel_2', 'gyro_0', 'gyro_1', 'gyro_2']
        fieldtypes = ['uint64_t', 'float', 'float', 'float', 'float', 'float', 'float']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<Qffffff'
        native_format = bytearray('<Qffffff', 'ascii')
        orders = [0, 1, 2, 3, 4, 5, 6]
        lengths = [1, 1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0, 0]
        crc_extra = 34
        unpacker = struct.Struct('<Qffffff')
        instance_field = None
        instance_offset = -1

        def __init__(self, usec, accel_0, accel_1, accel_2, gyro_0, gyro_1, gyro_2):
                MAVLink_message.__init__(self, MAVLink_nav_filter_bias_message.id, MAVLink_nav_filter_bias_message.name)
                self._fieldnames = MAVLink_nav_filter_bias_message.fieldnames
                self._instance_field = MAVLink_nav_filter_bias_message.instance_field
                self._instance_offset = MAVLink_nav_filter_bias_message.instance_offset
                self.usec = usec
                self.accel_0 = accel_0
                self.accel_1 = accel_1
                self.accel_2 = accel_2
                self.gyro_0 = gyro_0
                self.gyro_1 = gyro_1
                self.gyro_2 = gyro_2

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 34, struct.pack('<Qffffff', self.usec, self.accel_0, self.accel_1, self.accel_2, self.gyro_0, self.gyro_1, self.gyro_2), force_mavlink1=force_mavlink1)

class MAVLink_radio_calibration_message(MAVLink_message):
        '''
        Complete set of calibration parameters for the radio
        '''
        id = MAVLINK_MSG_ID_RADIO_CALIBRATION
        name = 'RADIO_CALIBRATION'
        fieldnames = ['aileron', 'elevator', 'rudder', 'gyro', 'pitch', 'throttle']
        ordered_fieldnames = ['aileron', 'elevator', 'rudder', 'gyro', 'pitch', 'throttle']
        fieldtypes = ['uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t', 'uint16_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<3H3H3H2H5H5H'
        native_format = bytearray('<HHHHHH', 'ascii')
        orders = [0, 1, 2, 3, 4, 5]
        lengths = [3, 3, 3, 2, 5, 5]
        array_lengths = [3, 3, 3, 2, 5, 5]
        crc_extra = 71
        unpacker = struct.Struct('<3H3H3H2H5H5H')
        instance_field = None
        instance_offset = -1

        def __init__(self, aileron, elevator, rudder, gyro, pitch, throttle):
                MAVLink_message.__init__(self, MAVLink_radio_calibration_message.id, MAVLink_radio_calibration_message.name)
                self._fieldnames = MAVLink_radio_calibration_message.fieldnames
                self._instance_field = MAVLink_radio_calibration_message.instance_field
                self._instance_offset = MAVLink_radio_calibration_message.instance_offset
                self.aileron = aileron
                self.elevator = elevator
                self.rudder = rudder
                self.gyro = gyro
                self.pitch = pitch
                self.throttle = throttle

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 71, struct.pack('<3H3H3H2H5H5H', self.aileron[0], self.aileron[1], self.aileron[2], self.elevator[0], self.elevator[1], self.elevator[2], self.rudder[0], self.rudder[1], self.rudder[2], self.gyro[0], self.gyro[1], self.pitch[0], self.pitch[1], self.pitch[2], self.pitch[3], self.pitch[4], self.throttle[0], self.throttle[1], self.throttle[2], self.throttle[3], self.throttle[4]), force_mavlink1=force_mavlink1)

class MAVLink_ualberta_sys_status_message(MAVLink_message):
        '''
        System status specific to ualberta uav
        '''
        id = MAVLINK_MSG_ID_UALBERTA_SYS_STATUS
        name = 'UALBERTA_SYS_STATUS'
        fieldnames = ['mode', 'nav_mode', 'pilot']
        ordered_fieldnames = ['mode', 'nav_mode', 'pilot']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {}
        fieldenums_by_name = {}
        fieldunits_by_name = {}
        format = '<BBB'
        native_format = bytearray('<BBB', 'ascii')
        orders = [0, 1, 2]
        lengths = [1, 1, 1]
        array_lengths = [0, 0, 0]
        crc_extra = 15
        unpacker = struct.Struct('<BBB')
        instance_field = None
        instance_offset = -1

        def __init__(self, mode, nav_mode, pilot):
                MAVLink_message.__init__(self, MAVLink_ualberta_sys_status_message.id, MAVLink_ualberta_sys_status_message.name)
                self._fieldnames = MAVLink_ualberta_sys_status_message.fieldnames
                self._instance_field = MAVLink_ualberta_sys_status_message.instance_field
                self._instance_offset = MAVLink_ualberta_sys_status_message.instance_offset
                self.mode = mode
                self.nav_mode = nav_mode
                self.pilot = pilot

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 15, struct.pack('<BBB', self.mode, self.nav_mode, self.pilot), force_mavlink1=force_mavlink1)


mavlink_map = {
        MAVLINK_MSG_ID_SENSOR_OFFSETS : MAVLink_sensor_offsets_message,
        MAVLINK_MSG_ID_SET_MAG_OFFSETS : MAVLink_set_mag_offsets_message,
        MAVLINK_MSG_ID_MEMINFO : MAVLink_meminfo_message,
        MAVLINK_MSG_ID_AP_ADC : MAVLink_ap_adc_message,
        MAVLINK_MSG_ID_DIGICAM_CONFIGURE : MAVLink_digicam_configure_message,
        MAVLINK_MSG_ID_DIGICAM_CONTROL : MAVLink_digicam_control_message,
        MAVLINK_MSG_ID_MOUNT_CONFIGURE : MAVLink_mount_configure_message,
        MAVLINK_MSG_ID_MOUNT_CONTROL : MAVLink_mount_control_message,
        MAVLINK_MSG_ID_MOUNT_STATUS : MAVLink_mount_status_message,
        MAVLINK_MSG_ID_FENCE_POINT : MAVLink_fence_point_message,
        MAVLINK_MSG_ID_FENCE_FETCH_POINT : MAVLink_fence_fetch_point_message,
        MAVLINK_MSG_ID_AHRS : MAVLink_ahrs_message,
        MAVLINK_MSG_ID_SIMSTATE : MAVLink_simstate_message,
        MAVLINK_MSG_ID_HWSTATUS : MAVLink_hwstatus_message,
        MAVLINK_MSG_ID_RADIO : MAVLink_radio_message,
        MAVLINK_MSG_ID_LIMITS_STATUS : MAVLink_limits_status_message,
        MAVLINK_MSG_ID_WIND : MAVLink_wind_message,
        MAVLINK_MSG_ID_DATA16 : MAVLink_data16_message,
        MAVLINK_MSG_ID_DATA32 : MAVLink_data32_message,
        MAVLINK_MSG_ID_DATA64 : MAVLink_data64_message,
        MAVLINK_MSG_ID_DATA96 : MAVLink_data96_message,
        MAVLINK_MSG_ID_RANGEFINDER : MAVLink_rangefinder_message,
        MAVLINK_MSG_ID_AIRSPEED_AUTOCAL : MAVLink_airspeed_autocal_message,
        MAVLINK_MSG_ID_RALLY_POINT : MAVLink_rally_point_message,
        MAVLINK_MSG_ID_RALLY_FETCH_POINT : MAVLink_rally_fetch_point_message,
        MAVLINK_MSG_ID_COMPASSMOT_STATUS : MAVLink_compassmot_status_message,
        MAVLINK_MSG_ID_AHRS2 : MAVLink_ahrs2_message,
        MAVLINK_MSG_ID_CAMERA_STATUS : MAVLink_camera_status_message,
        MAVLINK_MSG_ID_CAMERA_FEEDBACK : MAVLink_camera_feedback_message,
        MAVLINK_MSG_ID_BATTERY2 : MAVLink_battery2_message,
        MAVLINK_MSG_ID_AHRS3 : MAVLink_ahrs3_message,
        MAVLINK_MSG_ID_AUTOPILOT_VERSION_REQUEST : MAVLink_autopilot_version_request_message,
        MAVLINK_MSG_ID_REMOTE_LOG_DATA_BLOCK : MAVLink_remote_log_data_block_message,
        MAVLINK_MSG_ID_REMOTE_LOG_BLOCK_STATUS : MAVLink_remote_log_block_status_message,
        MAVLINK_MSG_ID_LED_CONTROL : MAVLink_led_control_message,
        MAVLINK_MSG_ID_MAG_CAL_PROGRESS : MAVLink_mag_cal_progress_message,
        MAVLINK_MSG_ID_EKF_STATUS_REPORT : MAVLink_ekf_status_report_message,
        MAVLINK_MSG_ID_PID_TUNING : MAVLink_pid_tuning_message,
        MAVLINK_MSG_ID_DEEPSTALL : MAVLink_deepstall_message,
        MAVLINK_MSG_ID_GIMBAL_REPORT : MAVLink_gimbal_report_message,
        MAVLINK_MSG_ID_GIMBAL_CONTROL : MAVLink_gimbal_control_message,
        MAVLINK_MSG_ID_GIMBAL_TORQUE_CMD_REPORT : MAVLink_gimbal_torque_cmd_report_message,
        MAVLINK_MSG_ID_GOPRO_HEARTBEAT : MAVLink_gopro_heartbeat_message,
        MAVLINK_MSG_ID_GOPRO_GET_REQUEST : MAVLink_gopro_get_request_message,
        MAVLINK_MSG_ID_GOPRO_GET_RESPONSE : MAVLink_gopro_get_response_message,
        MAVLINK_MSG_ID_GOPRO_SET_REQUEST : MAVLink_gopro_set_request_message,
        MAVLINK_MSG_ID_GOPRO_SET_RESPONSE : MAVLink_gopro_set_response_message,
        MAVLINK_MSG_ID_RPM : MAVLink_rpm_message,
        MAVLINK_MSG_ID_SYS_STATUS : MAVLink_sys_status_message,
        MAVLINK_MSG_ID_SYSTEM_TIME : MAVLink_system_time_message,
        MAVLINK_MSG_ID_PING : MAVLink_ping_message,
        MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL : MAVLink_change_operator_control_message,
        MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK : MAVLink_change_operator_control_ack_message,
        MAVLINK_MSG_ID_AUTH_KEY : MAVLink_auth_key_message,
        MAVLINK_MSG_ID_SET_MODE : MAVLink_set_mode_message,
        MAVLINK_MSG_ID_PARAM_REQUEST_READ : MAVLink_param_request_read_message,
        MAVLINK_MSG_ID_PARAM_REQUEST_LIST : MAVLink_param_request_list_message,
        MAVLINK_MSG_ID_PARAM_VALUE : MAVLink_param_value_message,
        MAVLINK_MSG_ID_PARAM_SET : MAVLink_param_set_message,
        MAVLINK_MSG_ID_GPS_RAW_INT : MAVLink_gps_raw_int_message,
        MAVLINK_MSG_ID_GPS_STATUS : MAVLink_gps_status_message,
        MAVLINK_MSG_ID_SCALED_IMU : MAVLink_scaled_imu_message,
        MAVLINK_MSG_ID_RAW_IMU : MAVLink_raw_imu_message,
        MAVLINK_MSG_ID_RAW_PRESSURE : MAVLink_raw_pressure_message,
        MAVLINK_MSG_ID_SCALED_PRESSURE : MAVLink_scaled_pressure_message,
        MAVLINK_MSG_ID_ATTITUDE : MAVLink_attitude_message,
        MAVLINK_MSG_ID_ATTITUDE_QUATERNION : MAVLink_attitude_quaternion_message,
        MAVLINK_MSG_ID_LOCAL_POSITION_NED : MAVLink_local_position_ned_message,
        MAVLINK_MSG_ID_GLOBAL_POSITION_INT : MAVLink_global_position_int_message,
        MAVLINK_MSG_ID_RC_CHANNELS_SCALED : MAVLink_rc_channels_scaled_message,
        MAVLINK_MSG_ID_RC_CHANNELS_RAW : MAVLink_rc_channels_raw_message,
        MAVLINK_MSG_ID_SERVO_OUTPUT_RAW : MAVLink_servo_output_raw_message,
        MAVLINK_MSG_ID_MISSION_REQUEST_PARTIAL_LIST : MAVLink_mission_request_partial_list_message,
        MAVLINK_MSG_ID_MISSION_WRITE_PARTIAL_LIST : MAVLink_mission_write_partial_list_message,
        MAVLINK_MSG_ID_MISSION_ITEM : MAVLink_mission_item_message,
        MAVLINK_MSG_ID_MISSION_REQUEST : MAVLink_mission_request_message,
        MAVLINK_MSG_ID_MISSION_SET_CURRENT : MAVLink_mission_set_current_message,
        MAVLINK_MSG_ID_MISSION_CURRENT : MAVLink_mission_current_message,
        MAVLINK_MSG_ID_MISSION_REQUEST_LIST : MAVLink_mission_request_list_message,
        MAVLINK_MSG_ID_MISSION_COUNT : MAVLink_mission_count_message,
        MAVLINK_MSG_ID_MISSION_CLEAR_ALL : MAVLink_mission_clear_all_message,
        MAVLINK_MSG_ID_MISSION_ITEM_REACHED : MAVLink_mission_item_reached_message,
        MAVLINK_MSG_ID_MISSION_ACK : MAVLink_mission_ack_message,
        MAVLINK_MSG_ID_SET_GPS_GLOBAL_ORIGIN : MAVLink_set_gps_global_origin_message,
        MAVLINK_MSG_ID_GPS_GLOBAL_ORIGIN : MAVLink_gps_global_origin_message,
        MAVLINK_MSG_ID_PARAM_MAP_RC : MAVLink_param_map_rc_message,
        MAVLINK_MSG_ID_MISSION_REQUEST_INT : MAVLink_mission_request_int_message,
        MAVLINK_MSG_ID_SAFETY_SET_ALLOWED_AREA : MAVLink_safety_set_allowed_area_message,
        MAVLINK_MSG_ID_SAFETY_ALLOWED_AREA : MAVLink_safety_allowed_area_message,
        MAVLINK_MSG_ID_ATTITUDE_QUATERNION_COV : MAVLink_attitude_quaternion_cov_message,
        MAVLINK_MSG_ID_NAV_CONTROLLER_OUTPUT : MAVLink_nav_controller_output_message,
        MAVLINK_MSG_ID_GLOBAL_POSITION_INT_COV : MAVLink_global_position_int_cov_message,
        MAVLINK_MSG_ID_LOCAL_POSITION_NED_COV : MAVLink_local_position_ned_cov_message,
        MAVLINK_MSG_ID_RC_CHANNELS : MAVLink_rc_channels_message,
        MAVLINK_MSG_ID_REQUEST_DATA_STREAM : MAVLink_request_data_stream_message,
        MAVLINK_MSG_ID_DATA_STREAM : MAVLink_data_stream_message,
        MAVLINK_MSG_ID_MANUAL_CONTROL : MAVLink_manual_control_message,
        MAVLINK_MSG_ID_RC_CHANNELS_OVERRIDE : MAVLink_rc_channels_override_message,
        MAVLINK_MSG_ID_MISSION_ITEM_INT : MAVLink_mission_item_int_message,
        MAVLINK_MSG_ID_VFR_HUD : MAVLink_vfr_hud_message,
        MAVLINK_MSG_ID_COMMAND_INT : MAVLink_command_int_message,
        MAVLINK_MSG_ID_COMMAND_LONG : MAVLink_command_long_message,
        MAVLINK_MSG_ID_COMMAND_ACK : MAVLink_command_ack_message,
        MAVLINK_MSG_ID_MANUAL_SETPOINT : MAVLink_manual_setpoint_message,
        MAVLINK_MSG_ID_SET_ATTITUDE_TARGET : MAVLink_set_attitude_target_message,
        MAVLINK_MSG_ID_ATTITUDE_TARGET : MAVLink_attitude_target_message,
        MAVLINK_MSG_ID_SET_POSITION_TARGET_LOCAL_NED : MAVLink_set_position_target_local_ned_message,
        MAVLINK_MSG_ID_POSITION_TARGET_LOCAL_NED : MAVLink_position_target_local_ned_message,
        MAVLINK_MSG_ID_SET_POSITION_TARGET_GLOBAL_INT : MAVLink_set_position_target_global_int_message,
        MAVLINK_MSG_ID_POSITION_TARGET_GLOBAL_INT : MAVLink_position_target_global_int_message,
        MAVLINK_MSG_ID_LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET : MAVLink_local_position_ned_system_global_offset_message,
        MAVLINK_MSG_ID_HIL_STATE : MAVLink_hil_state_message,
        MAVLINK_MSG_ID_HIL_CONTROLS : MAVLink_hil_controls_message,
        MAVLINK_MSG_ID_HIL_RC_INPUTS_RAW : MAVLink_hil_rc_inputs_raw_message,
        MAVLINK_MSG_ID_HIL_ACTUATOR_CONTROLS : MAVLink_hil_actuator_controls_message,
        MAVLINK_MSG_ID_OPTICAL_FLOW : MAVLink_optical_flow_message,
        MAVLINK_MSG_ID_GLOBAL_VISION_POSITION_ESTIMATE : MAVLink_global_vision_position_estimate_message,
        MAVLINK_MSG_ID_VISION_POSITION_ESTIMATE : MAVLink_vision_position_estimate_message,
        MAVLINK_MSG_ID_VISION_SPEED_ESTIMATE : MAVLink_vision_speed_estimate_message,
        MAVLINK_MSG_ID_VICON_POSITION_ESTIMATE : MAVLink_vicon_position_estimate_message,
        MAVLINK_MSG_ID_HIGHRES_IMU : MAVLink_highres_imu_message,
        MAVLINK_MSG_ID_OPTICAL_FLOW_RAD : MAVLink_optical_flow_rad_message,
        MAVLINK_MSG_ID_HIL_SENSOR : MAVLink_hil_sensor_message,
        MAVLINK_MSG_ID_SIM_STATE : MAVLink_sim_state_message,
        MAVLINK_MSG_ID_RADIO_STATUS : MAVLink_radio_status_message,
        MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL : MAVLink_file_transfer_protocol_message,
        MAVLINK_MSG_ID_TIMESYNC : MAVLink_timesync_message,
        MAVLINK_MSG_ID_CAMERA_TRIGGER : MAVLink_camera_trigger_message,
        MAVLINK_MSG_ID_HIL_GPS : MAVLink_hil_gps_message,
        MAVLINK_MSG_ID_HIL_OPTICAL_FLOW : MAVLink_hil_optical_flow_message,
        MAVLINK_MSG_ID_HIL_STATE_QUATERNION : MAVLink_hil_state_quaternion_message,
        MAVLINK_MSG_ID_SCALED_IMU2 : MAVLink_scaled_imu2_message,
        MAVLINK_MSG_ID_LOG_REQUEST_LIST : MAVLink_log_request_list_message,
        MAVLINK_MSG_ID_LOG_ENTRY : MAVLink_log_entry_message,
        MAVLINK_MSG_ID_LOG_REQUEST_DATA : MAVLink_log_request_data_message,
        MAVLINK_MSG_ID_LOG_DATA : MAVLink_log_data_message,
        MAVLINK_MSG_ID_LOG_ERASE : MAVLink_log_erase_message,
        MAVLINK_MSG_ID_LOG_REQUEST_END : MAVLink_log_request_end_message,
        MAVLINK_MSG_ID_GPS_INJECT_DATA : MAVLink_gps_inject_data_message,
        MAVLINK_MSG_ID_GPS2_RAW : MAVLink_gps2_raw_message,
        MAVLINK_MSG_ID_POWER_STATUS : MAVLink_power_status_message,
        MAVLINK_MSG_ID_SERIAL_CONTROL : MAVLink_serial_control_message,
        MAVLINK_MSG_ID_GPS_RTK : MAVLink_gps_rtk_message,
        MAVLINK_MSG_ID_GPS2_RTK : MAVLink_gps2_rtk_message,
        MAVLINK_MSG_ID_SCALED_IMU3 : MAVLink_scaled_imu3_message,
        MAVLINK_MSG_ID_DATA_TRANSMISSION_HANDSHAKE : MAVLink_data_transmission_handshake_message,
        MAVLINK_MSG_ID_ENCAPSULATED_DATA : MAVLink_encapsulated_data_message,
        MAVLINK_MSG_ID_DISTANCE_SENSOR : MAVLink_distance_sensor_message,
        MAVLINK_MSG_ID_TERRAIN_REQUEST : MAVLink_terrain_request_message,
        MAVLINK_MSG_ID_TERRAIN_DATA : MAVLink_terrain_data_message,
        MAVLINK_MSG_ID_TERRAIN_CHECK : MAVLink_terrain_check_message,
        MAVLINK_MSG_ID_TERRAIN_REPORT : MAVLink_terrain_report_message,
        MAVLINK_MSG_ID_SCALED_PRESSURE2 : MAVLink_scaled_pressure2_message,
        MAVLINK_MSG_ID_ATT_POS_MOCAP : MAVLink_att_pos_mocap_message,
        MAVLINK_MSG_ID_SET_ACTUATOR_CONTROL_TARGET : MAVLink_set_actuator_control_target_message,
        MAVLINK_MSG_ID_ACTUATOR_CONTROL_TARGET : MAVLink_actuator_control_target_message,
        MAVLINK_MSG_ID_ALTITUDE : MAVLink_altitude_message,
        MAVLINK_MSG_ID_RESOURCE_REQUEST : MAVLink_resource_request_message,
        MAVLINK_MSG_ID_SCALED_PRESSURE3 : MAVLink_scaled_pressure3_message,
        MAVLINK_MSG_ID_FOLLOW_TARGET : MAVLink_follow_target_message,
        MAVLINK_MSG_ID_CONTROL_SYSTEM_STATE : MAVLink_control_system_state_message,
        MAVLINK_MSG_ID_BATTERY_STATUS : MAVLink_battery_status_message,
        MAVLINK_MSG_ID_AUTOPILOT_VERSION : MAVLink_autopilot_version_message,
        MAVLINK_MSG_ID_LANDING_TARGET : MAVLink_landing_target_message,
        MAVLINK_MSG_ID_FENCE_STATUS : MAVLink_fence_status_message,
        MAVLINK_MSG_ID_MAG_CAL_REPORT : MAVLink_mag_cal_report_message,
        MAVLINK_MSG_ID_EFI_STATUS : MAVLink_efi_status_message,
        MAVLINK_MSG_ID_ESTIMATOR_STATUS : MAVLink_estimator_status_message,
        MAVLINK_MSG_ID_WIND_COV : MAVLink_wind_cov_message,
        MAVLINK_MSG_ID_GPS_INPUT : MAVLink_gps_input_message,
        MAVLINK_MSG_ID_GPS_RTCM_DATA : MAVLink_gps_rtcm_data_message,
        MAVLINK_MSG_ID_HIGH_LATENCY : MAVLink_high_latency_message,
        MAVLINK_MSG_ID_HIGH_LATENCY2 : MAVLink_high_latency2_message,
        MAVLINK_MSG_ID_VIBRATION : MAVLink_vibration_message,
        MAVLINK_MSG_ID_HOME_POSITION : MAVLink_home_position_message,
        MAVLINK_MSG_ID_SET_HOME_POSITION : MAVLink_set_home_position_message,
        MAVLINK_MSG_ID_MESSAGE_INTERVAL : MAVLink_message_interval_message,
        MAVLINK_MSG_ID_EXTENDED_SYS_STATE : MAVLink_extended_sys_state_message,
        MAVLINK_MSG_ID_ADSB_VEHICLE : MAVLink_adsb_vehicle_message,
        MAVLINK_MSG_ID_COLLISION : MAVLink_collision_message,
        MAVLINK_MSG_ID_V2_EXTENSION : MAVLink_v2_extension_message,
        MAVLINK_MSG_ID_MEMORY_VECT : MAVLink_memory_vect_message,
        MAVLINK_MSG_ID_DEBUG_VECT : MAVLink_debug_vect_message,
        MAVLINK_MSG_ID_NAMED_VALUE_FLOAT : MAVLink_named_value_float_message,
        MAVLINK_MSG_ID_NAMED_VALUE_INT : MAVLink_named_value_int_message,
        MAVLINK_MSG_ID_STATUSTEXT : MAVLink_statustext_message,
        MAVLINK_MSG_ID_DEBUG : MAVLink_debug_message,
        MAVLINK_MSG_ID_HEARTBEAT : MAVLink_heartbeat_message,
        MAVLINK_MSG_ID_NAV_FILTER_BIAS : MAVLink_nav_filter_bias_message,
        MAVLINK_MSG_ID_RADIO_CALIBRATION : MAVLink_radio_calibration_message,
        MAVLINK_MSG_ID_UALBERTA_SYS_STATUS : MAVLink_ualberta_sys_status_message,
}

class MAVError(Exception):
        '''MAVLink error class'''
        def __init__(self, msg):
            Exception.__init__(self, msg)
            self.message = msg

class MAVString(str):
        '''NUL terminated string'''
        def __init__(self, s):
                str.__init__(self)
        def __str__(self):
            i = self.find(chr(0))
            if i == -1:
                return self[:]
            return self[0:i]

class MAVLink_bad_data(MAVLink_message):
        '''
        a piece of bad data in a mavlink stream
        '''
        def __init__(self, data, reason):
                MAVLink_message.__init__(self, MAVLINK_MSG_ID_BAD_DATA, 'BAD_DATA')
                self._fieldnames = ['data', 'reason']
                self.data = data
                self.reason = reason
                self._msgbuf = data
                self._instance_field = None

        def __str__(self):
            '''Override the __str__ function from MAVLink_messages because non-printable characters are common in to be the reason for this message to exist.'''
            return '%s {%s, data:%s}' % (self._type, self.reason, [('%x' % ord(i) if isinstance(i, str) else '%x' % i) for i in self.data])

class MAVLinkSigning(object):
    '''MAVLink signing state class'''
    def __init__(self):
        self.secret_key = None
        self.timestamp = 0
        self.link_id = 0
        self.sign_outgoing = False
        self.allow_unsigned_callback = None
        self.stream_timestamps = {}
        self.sig_count = 0
        self.badsig_count = 0
        self.goodsig_count = 0
        self.unsigned_count = 0
        self.reject_count = 0

class MAVLink(object):
        '''MAVLink protocol handling class'''
        def __init__(self, file, srcSystem=0, srcComponent=0, use_native=False):
                self.seq = 0
                self.file = file
                self.srcSystem = srcSystem
                self.srcComponent = srcComponent
                self.callback = None
                self.callback_args = None
                self.callback_kwargs = None
                self.send_callback = None
                self.send_callback_args = None
                self.send_callback_kwargs = None
                self.buf = bytearray()
                self.buf_index = 0
                self.expected_length = HEADER_LEN_V1+2
                self.have_prefix_error = False
                self.robust_parsing = False
                self.protocol_marker = 254
                self.little_endian = True
                self.crc_extra = True
                self.sort_fields = True
                self.total_packets_sent = 0
                self.total_bytes_sent = 0
                self.total_packets_received = 0
                self.total_bytes_received = 0
                self.total_receive_errors = 0
                self.startup_time = time.time()
                self.signing = MAVLinkSigning()
                if native_supported and (use_native or native_testing or native_force):
                    print("NOTE: mavnative is currently beta-test code")
                    self.native = mavnative.NativeConnection(MAVLink_message, mavlink_map)
                else:
                    self.native = None
                if native_testing:
                    self.test_buf = bytearray()
                self.mav20_unpacker = struct.Struct('<cBBBBBBHB')
                self.mav10_unpacker = struct.Struct('<cBBBBB')
                self.mav20_h3_unpacker = struct.Struct('BBB')
                self.mav_csum_unpacker = struct.Struct('<H')
                self.mav_sign_unpacker = struct.Struct('<IH')

        def set_callback(self, callback, *args, **kwargs):
            self.callback = callback
            self.callback_args = args
            self.callback_kwargs = kwargs

        def set_send_callback(self, callback, *args, **kwargs):
            self.send_callback = callback
            self.send_callback_args = args
            self.send_callback_kwargs = kwargs

        def send(self, mavmsg, force_mavlink1=False):
                '''send a MAVLink message'''
                buf = mavmsg.pack(self, force_mavlink1=force_mavlink1)
                self.file.write(buf)
                self.seq = (self.seq + 1) % 256
                self.total_packets_sent += 1
                self.total_bytes_sent += len(buf)
                if self.send_callback:
                    self.send_callback(mavmsg, *self.send_callback_args, **self.send_callback_kwargs)

        def buf_len(self):
            return len(self.buf) - self.buf_index

        def bytes_needed(self):
            '''return number of bytes needed for next parsing stage'''
            if self.native:
                ret = self.native.expected_length - self.buf_len()
            else:
                ret = self.expected_length - self.buf_len()

            if ret <= 0:
                return 1
            return ret

        def __parse_char_native(self, c):
            '''this method exists only to see in profiling results'''
            m = self.native.parse_chars(c)
            return m

        def __callbacks(self, msg):
            '''this method exists only to make profiling results easier to read'''
            if self.callback:
                self.callback(msg, *self.callback_args, **self.callback_kwargs)

        def parse_char(self, c):
            '''input some data bytes, possibly returning a new message'''
            self.buf.extend(c)

            self.total_bytes_received += len(c)

            if self.native:
                if native_testing:
                    self.test_buf.extend(c)
                    m = self.__parse_char_native(self.test_buf)
                    m2 = self.__parse_char_legacy()
                    if m2 != m:
                        print("Native: %s\nLegacy: %s\n" % (m, m2))
                        raise Exception('Native vs. Legacy mismatch')
                else:
                    m = self.__parse_char_native(self.buf)
            else:
                m = self.__parse_char_legacy()

            if m is not None:
                self.total_packets_received += 1
                self.__callbacks(m)
            else:
                # XXX The idea here is if we've read something and there's nothing left in
                # the buffer, reset it to 0 which frees the memory
                if self.buf_len() == 0 and self.buf_index != 0:
                    self.buf = bytearray()
                    self.buf_index = 0

            return m

        def __parse_char_legacy(self):
            '''input some data bytes, possibly returning a new message (uses no native code)'''
            header_len = HEADER_LEN_V1
            if self.buf_len() >= 1 and self.buf[self.buf_index] == PROTOCOL_MARKER_V2:
                header_len = HEADER_LEN_V2

            if self.buf_len() >= 1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V2:
                magic = self.buf[self.buf_index]
                self.buf_index += 1
                if self.robust_parsing:
                    m = MAVLink_bad_data(bytearray([magic]), 'Bad prefix')
                    self.expected_length = header_len+2
                    self.total_receive_errors += 1
                    return m
                if self.have_prefix_error:
                    return None
                self.have_prefix_error = True
                self.total_receive_errors += 1
                raise MAVError("invalid MAVLink prefix '%s'" % magic)
            self.have_prefix_error = False
            if self.buf_len() >= 3:
                sbuf = self.buf[self.buf_index:3+self.buf_index]
                if sys.version_info.major < 3:
                    sbuf = str(sbuf)
                (magic, self.expected_length, incompat_flags) = self.mav20_h3_unpacker.unpack(sbuf)
                if magic == PROTOCOL_MARKER_V2 and (incompat_flags & MAVLINK_IFLAG_SIGNED):
                        self.expected_length += MAVLINK_SIGNATURE_BLOCK_LEN
                self.expected_length += header_len + 2
            if self.expected_length >= (header_len+2) and self.buf_len() >= self.expected_length:
                mbuf = array.array('B', self.buf[self.buf_index:self.buf_index+self.expected_length])
                self.buf_index += self.expected_length
                self.expected_length = header_len+2
                if self.robust_parsing:
                    try:
                        if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                            raise MAVError('invalid incompat_flags 0x%x 0x%x %u' % (incompat_flags, magic, self.expected_length))
                        m = self.decode(mbuf)
                    except MAVError as reason:
                        m = MAVLink_bad_data(mbuf, reason.message)
                        self.total_receive_errors += 1
                else:
                    if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                        raise MAVError('invalid incompat_flags 0x%x 0x%x %u' % (incompat_flags, magic, self.expected_length))
                    m = self.decode(mbuf)
                return m
            return None

        def parse_buffer(self, s):
            '''input some data bytes, possibly returning a list of new messages'''
            m = self.parse_char(s)
            if m is None:
                return None
            ret = [m]
            while True:
                m = self.parse_char("")
                if m is None:
                    return ret
                ret.append(m)
            return ret

        def check_signature(self, msgbuf, srcSystem, srcComponent):
            '''check signature on incoming message'''
            if isinstance(msgbuf, array.array):
                try:
                    msgbuf = msgbuf.tostring()
                except:
                    msgbuf = msgbuf.tobytes()
            timestamp_buf = msgbuf[-12:-6]
            link_id = msgbuf[-13]
            (tlow, thigh) = self.mav_sign_unpacker.unpack(timestamp_buf)
            timestamp = tlow + (thigh<<32)

            # see if the timestamp is acceptable
            stream_key = (link_id,srcSystem,srcComponent)
            if stream_key in self.signing.stream_timestamps:
                if timestamp <= self.signing.stream_timestamps[stream_key]:
                    # reject old timestamp
                    # print('old timestamp')
                    return False
            else:
                # a new stream has appeared. Accept the timestamp if it is at most
                # one minute behind our current timestamp
                if timestamp + 6000*1000 < self.signing.timestamp:
                    # print('bad new stream ', timestamp/(100.0*1000*60*60*24*365), self.signing.timestamp/(100.0*1000*60*60*24*365))
                    return False
                self.signing.stream_timestamps[stream_key] = timestamp
                # print('new stream')

            h = hashlib.new('sha256')
            h.update(self.signing.secret_key)
            h.update(msgbuf[:-6])
            if str(type(msgbuf)) == "<class 'bytes'>" or str(type(msgbuf)) == "<class 'bytearray'>":
                # Python 3
                sig1 = h.digest()[:6]
                sig2 = msgbuf[-6:]
            else:
                sig1 = str(h.digest())[:6]
                sig2 = str(msgbuf)[-6:]
            if sig1 != sig2:
                # print('sig mismatch')
                return False

            # the timestamp we next send with is the max of the received timestamp and
            # our current timestamp
            self.signing.timestamp = max(self.signing.timestamp, timestamp)
            return True

        def decode(self, msgbuf):
                '''decode a buffer as a MAVLink message'''
                # decode the header
                if msgbuf[0] != PROTOCOL_MARKER_V1:
                    headerlen = 10
                    try:
                        magic, mlen, incompat_flags, compat_flags, seq, srcSystem, srcComponent, msgIdlow, msgIdhigh = self.mav20_unpacker.unpack(msgbuf[:headerlen])
                    except struct.error as emsg:
                        raise MAVError('Unable to unpack MAVLink header: %s' % emsg)
                    msgId = msgIdlow | (msgIdhigh<<16)
                    mapkey = msgId
                else:
                    headerlen = 6
                    try:
                        magic, mlen, seq, srcSystem, srcComponent, msgId = self.mav10_unpacker.unpack(msgbuf[:headerlen])
                        incompat_flags = 0
                        compat_flags = 0
                    except struct.error as emsg:
                        raise MAVError('Unable to unpack MAVLink header: %s' % emsg)
                    mapkey = msgId
                if (incompat_flags & MAVLINK_IFLAG_SIGNED) != 0:
                    signature_len = MAVLINK_SIGNATURE_BLOCK_LEN
                else:
                    signature_len = 0

                if ord(magic) != PROTOCOL_MARKER_V1 and ord(magic) != PROTOCOL_MARKER_V2:
                    raise MAVError("invalid MAVLink prefix '%s'" % magic)
                if mlen != len(msgbuf)-(headerlen+2+signature_len):
                    raise MAVError('invalid MAVLink message length. Got %u expected %u, msgId=%u headerlen=%u' % (len(msgbuf)-(headerlen+2+signature_len), mlen, msgId, headerlen))

                if not mapkey in mavlink_map:
                    raise MAVError('unknown MAVLink message ID %s' % str(mapkey))

                # decode the payload
                type = mavlink_map[mapkey]
                fmt = type.format
                order_map = type.orders
                len_map = type.lengths
                crc_extra = type.crc_extra

                # decode the checksum
                try:
                    crc, = self.mav_csum_unpacker.unpack(msgbuf[-(2+signature_len):][:2])
                except struct.error as emsg:
                    raise MAVError('Unable to unpack MAVLink CRC: %s' % emsg)
                crcbuf = msgbuf[1:-(2+signature_len)]
                if True: # using CRC extra
                    crcbuf.append(crc_extra)
                crc2 = x25crc(crcbuf)
                if crc != crc2.crc and not MAVLINK_IGNORE_CRC:
                    raise MAVError('invalid MAVLink CRC in msgID %u 0x%04x should be 0x%04x' % (msgId, crc, crc2.crc))

                sig_ok = False
                if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
                    self.signing.sig_count += 1
                if self.signing.secret_key is not None:
                    accept_signature = False
                    if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
                        sig_ok = self.check_signature(msgbuf, srcSystem, srcComponent)
                        accept_signature = sig_ok
                        if sig_ok:
                            self.signing.goodsig_count += 1
                        else:
                            self.signing.badsig_count += 1
                        if not accept_signature and self.signing.allow_unsigned_callback is not None:
                            accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                            if accept_signature:
                                self.signing.unsigned_count += 1
                            else:
                                self.signing.reject_count += 1
                    elif self.signing.allow_unsigned_callback is not None:
                        accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                        if accept_signature:
                            self.signing.unsigned_count += 1
                        else:
                            self.signing.reject_count += 1
                    if not accept_signature:
                        raise MAVError('Invalid signature')

                csize = type.unpacker.size
                mbuf = msgbuf[headerlen:-(2+signature_len)]
                if len(mbuf) < csize:
                    # zero pad to give right size
                    mbuf.extend([0]*(csize - len(mbuf)))
                if len(mbuf) < csize:
                    raise MAVError('Bad message of type %s length %u needs %s' % (
                        type, len(mbuf), csize))
                mbuf = mbuf[:csize]
                try:
                    t = type.unpacker.unpack(mbuf)
                except struct.error as emsg:
                    raise MAVError('Unable to unpack MAVLink payload type=%s fmt=%s payloadLength=%u: %s' % (
                        type, fmt, len(mbuf), emsg))

                tlist = list(t)
                # handle sorted fields
                if True:
                    t = tlist[:]
                    if sum(len_map) == len(len_map):
                        # message has no arrays in it
                        for i in range(0, len(tlist)):
                            tlist[i] = t[order_map[i]]
                    else:
                        # message has some arrays
                        tlist = []
                        for i in range(0, len(order_map)):
                            order = order_map[i]
                            L = len_map[order]
                            tip = sum(len_map[:order])
                            field = t[tip]
                            if L == 1 or isinstance(field, str):
                                tlist.append(field)
                            else:
                                tlist.append(t[tip:(tip + L)])

                # terminate any strings
                for i in range(0, len(tlist)):
                    if type.fieldtypes[i] == 'char':
                        if sys.version_info.major >= 3:
                            tlist[i] = to_string(tlist[i])
                        tlist[i] = str(MAVString(tlist[i]))
                t = tuple(tlist)
                # construct the message object
                try:
                    m = type(*t)
                except Exception as emsg:
                    raise MAVError('Unable to instantiate MAVLink message of type %s : %s' % (type, emsg))
                m._signed = sig_ok
                if m._signed:
                    m._link_id = msgbuf[-13]
                m._msgbuf = msgbuf
                m._payload = msgbuf[6:-(2+signature_len)]
                m._crc = crc
                m._header = MAVLink_header(msgId, incompat_flags, compat_flags, mlen, seq, srcSystem, srcComponent)
                return m
        def sensor_offsets_encode(self, mag_ofs_x, mag_ofs_y, mag_ofs_z, mag_declination, raw_press, raw_temp, gyro_cal_x, gyro_cal_y, gyro_cal_z, accel_cal_x, accel_cal_y, accel_cal_z):
                '''
                Offsets and calibrations values for hardware sensors. This makes it
                easier to debug the calibration process.

                mag_ofs_x                 : Magnetometer X offset. (type:int16_t)
                mag_ofs_y                 : Magnetometer Y offset. (type:int16_t)
                mag_ofs_z                 : Magnetometer Z offset. (type:int16_t)
                mag_declination           : Magnetic declination. [rad] (type:float)
                raw_press                 : Raw pressure from barometer. (type:int32_t)
                raw_temp                  : Raw temperature from barometer. (type:int32_t)
                gyro_cal_x                : Gyro X calibration. (type:float)
                gyro_cal_y                : Gyro Y calibration. (type:float)
                gyro_cal_z                : Gyro Z calibration. (type:float)
                accel_cal_x               : Accel X calibration. (type:float)
                accel_cal_y               : Accel Y calibration. (type:float)
                accel_cal_z               : Accel Z calibration. (type:float)

                '''
                return MAVLink_sensor_offsets_message(mag_ofs_x, mag_ofs_y, mag_ofs_z, mag_declination, raw_press, raw_temp, gyro_cal_x, gyro_cal_y, gyro_cal_z, accel_cal_x, accel_cal_y, accel_cal_z)

        def sensor_offsets_send(self, mag_ofs_x, mag_ofs_y, mag_ofs_z, mag_declination, raw_press, raw_temp, gyro_cal_x, gyro_cal_y, gyro_cal_z, accel_cal_x, accel_cal_y, accel_cal_z, force_mavlink1=False):
                '''
                Offsets and calibrations values for hardware sensors. This makes it
                easier to debug the calibration process.

                mag_ofs_x                 : Magnetometer X offset. (type:int16_t)
                mag_ofs_y                 : Magnetometer Y offset. (type:int16_t)
                mag_ofs_z                 : Magnetometer Z offset. (type:int16_t)
                mag_declination           : Magnetic declination. [rad] (type:float)
                raw_press                 : Raw pressure from barometer. (type:int32_t)
                raw_temp                  : Raw temperature from barometer. (type:int32_t)
                gyro_cal_x                : Gyro X calibration. (type:float)
                gyro_cal_y                : Gyro Y calibration. (type:float)
                gyro_cal_z                : Gyro Z calibration. (type:float)
                accel_cal_x               : Accel X calibration. (type:float)
                accel_cal_y               : Accel Y calibration. (type:float)
                accel_cal_z               : Accel Z calibration. (type:float)

                '''
                return self.send(self.sensor_offsets_encode(mag_ofs_x, mag_ofs_y, mag_ofs_z, mag_declination, raw_press, raw_temp, gyro_cal_x, gyro_cal_y, gyro_cal_z, accel_cal_x, accel_cal_y, accel_cal_z), force_mavlink1=force_mavlink1)

        def set_mag_offsets_encode(self, target_system, target_component, mag_ofs_x, mag_ofs_y, mag_ofs_z):
                '''
                Set the magnetometer offsets

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                mag_ofs_x                 : Magnetometer X offset. (type:int16_t)
                mag_ofs_y                 : Magnetometer Y offset. (type:int16_t)
                mag_ofs_z                 : Magnetometer Z offset. (type:int16_t)

                '''
                return MAVLink_set_mag_offsets_message(target_system, target_component, mag_ofs_x, mag_ofs_y, mag_ofs_z)

        def set_mag_offsets_send(self, target_system, target_component, mag_ofs_x, mag_ofs_y, mag_ofs_z, force_mavlink1=False):
                '''
                Set the magnetometer offsets

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                mag_ofs_x                 : Magnetometer X offset. (type:int16_t)
                mag_ofs_y                 : Magnetometer Y offset. (type:int16_t)
                mag_ofs_z                 : Magnetometer Z offset. (type:int16_t)

                '''
                return self.send(self.set_mag_offsets_encode(target_system, target_component, mag_ofs_x, mag_ofs_y, mag_ofs_z), force_mavlink1=force_mavlink1)

        def meminfo_encode(self, brkval, freemem):
                '''
                State of autopilot RAM.

                brkval                    : Heap top. (type:uint16_t)
                freemem                   : Free memory. [bytes] (type:uint16_t)

                '''
                return MAVLink_meminfo_message(brkval, freemem)

        def meminfo_send(self, brkval, freemem, force_mavlink1=False):
                '''
                State of autopilot RAM.

                brkval                    : Heap top. (type:uint16_t)
                freemem                   : Free memory. [bytes] (type:uint16_t)

                '''
                return self.send(self.meminfo_encode(brkval, freemem), force_mavlink1=force_mavlink1)

        def ap_adc_encode(self, adc1, adc2, adc3, adc4, adc5, adc6):
                '''
                Raw ADC output.

                adc1                      : ADC output 1. (type:uint16_t)
                adc2                      : ADC output 2. (type:uint16_t)
                adc3                      : ADC output 3. (type:uint16_t)
                adc4                      : ADC output 4. (type:uint16_t)
                adc5                      : ADC output 5. (type:uint16_t)
                adc6                      : ADC output 6. (type:uint16_t)

                '''
                return MAVLink_ap_adc_message(adc1, adc2, adc3, adc4, adc5, adc6)

        def ap_adc_send(self, adc1, adc2, adc3, adc4, adc5, adc6, force_mavlink1=False):
                '''
                Raw ADC output.

                adc1                      : ADC output 1. (type:uint16_t)
                adc2                      : ADC output 2. (type:uint16_t)
                adc3                      : ADC output 3. (type:uint16_t)
                adc4                      : ADC output 4. (type:uint16_t)
                adc5                      : ADC output 5. (type:uint16_t)
                adc6                      : ADC output 6. (type:uint16_t)

                '''
                return self.send(self.ap_adc_encode(adc1, adc2, adc3, adc4, adc5, adc6), force_mavlink1=force_mavlink1)

        def digicam_configure_encode(self, target_system, target_component, mode, shutter_speed, aperture, iso, exposure_type, command_id, engine_cut_off, extra_param, extra_value):
                '''
                Configure on-board Camera Control System.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                mode                      : Mode enumeration from 1 to N //P, TV, AV, M, etc. (0 means ignore). (type:uint8_t)
                shutter_speed             : Divisor number //e.g. 1000 means 1/1000 (0 means ignore). (type:uint16_t)
                aperture                  : F stop number x 10 //e.g. 28 means 2.8 (0 means ignore). (type:uint8_t)
                iso                       : ISO enumeration from 1 to N //e.g. 80, 100, 200, Etc (0 means ignore). (type:uint8_t)
                exposure_type             : Exposure type enumeration from 1 to N (0 means ignore). (type:uint8_t)
                command_id                : Command Identity (incremental loop: 0 to 255). //A command sent multiple times will be executed or pooled just once. (type:uint8_t)
                engine_cut_off            : Main engine cut-off time before camera trigger (0 means no cut-off). [ds] (type:uint8_t)
                extra_param               : Extra parameters enumeration (0 means ignore). (type:uint8_t)
                extra_value               : Correspondent value to given extra_param. (type:float)

                '''
                return MAVLink_digicam_configure_message(target_system, target_component, mode, shutter_speed, aperture, iso, exposure_type, command_id, engine_cut_off, extra_param, extra_value)

        def digicam_configure_send(self, target_system, target_component, mode, shutter_speed, aperture, iso, exposure_type, command_id, engine_cut_off, extra_param, extra_value, force_mavlink1=False):
                '''
                Configure on-board Camera Control System.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                mode                      : Mode enumeration from 1 to N //P, TV, AV, M, etc. (0 means ignore). (type:uint8_t)
                shutter_speed             : Divisor number //e.g. 1000 means 1/1000 (0 means ignore). (type:uint16_t)
                aperture                  : F stop number x 10 //e.g. 28 means 2.8 (0 means ignore). (type:uint8_t)
                iso                       : ISO enumeration from 1 to N //e.g. 80, 100, 200, Etc (0 means ignore). (type:uint8_t)
                exposure_type             : Exposure type enumeration from 1 to N (0 means ignore). (type:uint8_t)
                command_id                : Command Identity (incremental loop: 0 to 255). //A command sent multiple times will be executed or pooled just once. (type:uint8_t)
                engine_cut_off            : Main engine cut-off time before camera trigger (0 means no cut-off). [ds] (type:uint8_t)
                extra_param               : Extra parameters enumeration (0 means ignore). (type:uint8_t)
                extra_value               : Correspondent value to given extra_param. (type:float)

                '''
                return self.send(self.digicam_configure_encode(target_system, target_component, mode, shutter_speed, aperture, iso, exposure_type, command_id, engine_cut_off, extra_param, extra_value), force_mavlink1=force_mavlink1)

        def digicam_control_encode(self, target_system, target_component, session, zoom_pos, zoom_step, focus_lock, shot, command_id, extra_param, extra_value):
                '''
                Control on-board Camera Control System to take shots.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                session                   : 0: stop, 1: start or keep it up //Session control e.g. show/hide lens. (type:uint8_t)
                zoom_pos                  : 1 to N //Zoom's absolute position (0 means ignore). (type:uint8_t)
                zoom_step                 : -100 to 100 //Zooming step value to offset zoom from the current position. (type:int8_t)
                focus_lock                : 0: unlock focus or keep unlocked, 1: lock focus or keep locked, 3: re-lock focus. (type:uint8_t)
                shot                      : 0: ignore, 1: shot or start filming. (type:uint8_t)
                command_id                : Command Identity (incremental loop: 0 to 255)//A command sent multiple times will be executed or pooled just once. (type:uint8_t)
                extra_param               : Extra parameters enumeration (0 means ignore). (type:uint8_t)
                extra_value               : Correspondent value to given extra_param. (type:float)

                '''
                return MAVLink_digicam_control_message(target_system, target_component, session, zoom_pos, zoom_step, focus_lock, shot, command_id, extra_param, extra_value)

        def digicam_control_send(self, target_system, target_component, session, zoom_pos, zoom_step, focus_lock, shot, command_id, extra_param, extra_value, force_mavlink1=False):
                '''
                Control on-board Camera Control System to take shots.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                session                   : 0: stop, 1: start or keep it up //Session control e.g. show/hide lens. (type:uint8_t)
                zoom_pos                  : 1 to N //Zoom's absolute position (0 means ignore). (type:uint8_t)
                zoom_step                 : -100 to 100 //Zooming step value to offset zoom from the current position. (type:int8_t)
                focus_lock                : 0: unlock focus or keep unlocked, 1: lock focus or keep locked, 3: re-lock focus. (type:uint8_t)
                shot                      : 0: ignore, 1: shot or start filming. (type:uint8_t)
                command_id                : Command Identity (incremental loop: 0 to 255)//A command sent multiple times will be executed or pooled just once. (type:uint8_t)
                extra_param               : Extra parameters enumeration (0 means ignore). (type:uint8_t)
                extra_value               : Correspondent value to given extra_param. (type:float)

                '''
                return self.send(self.digicam_control_encode(target_system, target_component, session, zoom_pos, zoom_step, focus_lock, shot, command_id, extra_param, extra_value), force_mavlink1=force_mavlink1)

        def mount_configure_encode(self, target_system, target_component, mount_mode, stab_roll, stab_pitch, stab_yaw):
                '''
                Message to configure a camera mount, directional antenna, etc.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                mount_mode                : Mount operating mode. (type:uint8_t, values:MAV_MOUNT_MODE)
                stab_roll                 : (1 = yes, 0 = no). (type:uint8_t)
                stab_pitch                : (1 = yes, 0 = no). (type:uint8_t)
                stab_yaw                  : (1 = yes, 0 = no). (type:uint8_t)

                '''
                return MAVLink_mount_configure_message(target_system, target_component, mount_mode, stab_roll, stab_pitch, stab_yaw)

        def mount_configure_send(self, target_system, target_component, mount_mode, stab_roll, stab_pitch, stab_yaw, force_mavlink1=False):
                '''
                Message to configure a camera mount, directional antenna, etc.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                mount_mode                : Mount operating mode. (type:uint8_t, values:MAV_MOUNT_MODE)
                stab_roll                 : (1 = yes, 0 = no). (type:uint8_t)
                stab_pitch                : (1 = yes, 0 = no). (type:uint8_t)
                stab_yaw                  : (1 = yes, 0 = no). (type:uint8_t)

                '''
                return self.send(self.mount_configure_encode(target_system, target_component, mount_mode, stab_roll, stab_pitch, stab_yaw), force_mavlink1=force_mavlink1)

        def mount_control_encode(self, target_system, target_component, input_a, input_b, input_c, save_position):
                '''
                Message to control a camera mount, directional antenna, etc.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                input_a                   : Pitch (centi-degrees) or lat (degE7), depending on mount mode. (type:int32_t)
                input_b                   : Roll (centi-degrees) or lon (degE7) depending on mount mode. (type:int32_t)
                input_c                   : Yaw (centi-degrees) or alt (cm) depending on mount mode. (type:int32_t)
                save_position             : If "1" it will save current trimmed position on EEPROM (just valid for NEUTRAL and LANDING). (type:uint8_t)

                '''
                return MAVLink_mount_control_message(target_system, target_component, input_a, input_b, input_c, save_position)

        def mount_control_send(self, target_system, target_component, input_a, input_b, input_c, save_position, force_mavlink1=False):
                '''
                Message to control a camera mount, directional antenna, etc.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                input_a                   : Pitch (centi-degrees) or lat (degE7), depending on mount mode. (type:int32_t)
                input_b                   : Roll (centi-degrees) or lon (degE7) depending on mount mode. (type:int32_t)
                input_c                   : Yaw (centi-degrees) or alt (cm) depending on mount mode. (type:int32_t)
                save_position             : If "1" it will save current trimmed position on EEPROM (just valid for NEUTRAL and LANDING). (type:uint8_t)

                '''
                return self.send(self.mount_control_encode(target_system, target_component, input_a, input_b, input_c, save_position), force_mavlink1=force_mavlink1)

        def mount_status_encode(self, target_system, target_component, pointing_a, pointing_b, pointing_c):
                '''
                Message with some status from autopilot to GCS about camera or antenna
                mount.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                pointing_a                : Pitch. [cdeg] (type:int32_t)
                pointing_b                : Roll. [cdeg] (type:int32_t)
                pointing_c                : Yaw. [cdeg] (type:int32_t)

                '''
                return MAVLink_mount_status_message(target_system, target_component, pointing_a, pointing_b, pointing_c)

        def mount_status_send(self, target_system, target_component, pointing_a, pointing_b, pointing_c, force_mavlink1=False):
                '''
                Message with some status from autopilot to GCS about camera or antenna
                mount.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                pointing_a                : Pitch. [cdeg] (type:int32_t)
                pointing_b                : Roll. [cdeg] (type:int32_t)
                pointing_c                : Yaw. [cdeg] (type:int32_t)

                '''
                return self.send(self.mount_status_encode(target_system, target_component, pointing_a, pointing_b, pointing_c), force_mavlink1=force_mavlink1)

        def fence_point_encode(self, target_system, target_component, idx, count, lat, lng):
                '''
                A fence point. Used to set a point when from GCS -> MAV. Also used to
                return a point from MAV -> GCS.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 1, 0 is for return point). (type:uint8_t)
                count                     : Total number of points (for sanity checking). (type:uint8_t)
                lat                       : Latitude of point. [deg] (type:float)
                lng                       : Longitude of point. [deg] (type:float)

                '''
                return MAVLink_fence_point_message(target_system, target_component, idx, count, lat, lng)

        def fence_point_send(self, target_system, target_component, idx, count, lat, lng, force_mavlink1=False):
                '''
                A fence point. Used to set a point when from GCS -> MAV. Also used to
                return a point from MAV -> GCS.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 1, 0 is for return point). (type:uint8_t)
                count                     : Total number of points (for sanity checking). (type:uint8_t)
                lat                       : Latitude of point. [deg] (type:float)
                lng                       : Longitude of point. [deg] (type:float)

                '''
                return self.send(self.fence_point_encode(target_system, target_component, idx, count, lat, lng), force_mavlink1=force_mavlink1)

        def fence_fetch_point_encode(self, target_system, target_component, idx):
                '''
                Request a current fence point from MAV.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 1, 0 is for return point). (type:uint8_t)

                '''
                return MAVLink_fence_fetch_point_message(target_system, target_component, idx)

        def fence_fetch_point_send(self, target_system, target_component, idx, force_mavlink1=False):
                '''
                Request a current fence point from MAV.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 1, 0 is for return point). (type:uint8_t)

                '''
                return self.send(self.fence_fetch_point_encode(target_system, target_component, idx), force_mavlink1=force_mavlink1)

        def ahrs_encode(self, omegaIx, omegaIy, omegaIz, accel_weight, renorm_val, error_rp, error_yaw):
                '''
                Status of DCM attitude estimator.

                omegaIx                   : X gyro drift estimate. [rad/s] (type:float)
                omegaIy                   : Y gyro drift estimate. [rad/s] (type:float)
                omegaIz                   : Z gyro drift estimate. [rad/s] (type:float)
                accel_weight              : Average accel_weight. (type:float)
                renorm_val                : Average renormalisation value. (type:float)
                error_rp                  : Average error_roll_pitch value. (type:float)
                error_yaw                 : Average error_yaw value. (type:float)

                '''
                return MAVLink_ahrs_message(omegaIx, omegaIy, omegaIz, accel_weight, renorm_val, error_rp, error_yaw)

        def ahrs_send(self, omegaIx, omegaIy, omegaIz, accel_weight, renorm_val, error_rp, error_yaw, force_mavlink1=False):
                '''
                Status of DCM attitude estimator.

                omegaIx                   : X gyro drift estimate. [rad/s] (type:float)
                omegaIy                   : Y gyro drift estimate. [rad/s] (type:float)
                omegaIz                   : Z gyro drift estimate. [rad/s] (type:float)
                accel_weight              : Average accel_weight. (type:float)
                renorm_val                : Average renormalisation value. (type:float)
                error_rp                  : Average error_roll_pitch value. (type:float)
                error_yaw                 : Average error_yaw value. (type:float)

                '''
                return self.send(self.ahrs_encode(omegaIx, omegaIy, omegaIz, accel_weight, renorm_val, error_rp, error_yaw), force_mavlink1=force_mavlink1)

        def simstate_encode(self, roll, pitch, yaw, xacc, yacc, zacc, xgyro, ygyro, zgyro, lat, lng):
                '''
                Status of simulation environment, if used.

                roll                      : Roll angle. [rad] (type:float)
                pitch                     : Pitch angle. [rad] (type:float)
                yaw                       : Yaw angle. [rad] (type:float)
                xacc                      : X acceleration. [m/s/s] (type:float)
                yacc                      : Y acceleration. [m/s/s] (type:float)
                zacc                      : Z acceleration. [m/s/s] (type:float)
                xgyro                     : Angular speed around X axis. [rad/s] (type:float)
                ygyro                     : Angular speed around Y axis. [rad/s] (type:float)
                zgyro                     : Angular speed around Z axis. [rad/s] (type:float)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)

                '''
                return MAVLink_simstate_message(roll, pitch, yaw, xacc, yacc, zacc, xgyro, ygyro, zgyro, lat, lng)

        def simstate_send(self, roll, pitch, yaw, xacc, yacc, zacc, xgyro, ygyro, zgyro, lat, lng, force_mavlink1=False):
                '''
                Status of simulation environment, if used.

                roll                      : Roll angle. [rad] (type:float)
                pitch                     : Pitch angle. [rad] (type:float)
                yaw                       : Yaw angle. [rad] (type:float)
                xacc                      : X acceleration. [m/s/s] (type:float)
                yacc                      : Y acceleration. [m/s/s] (type:float)
                zacc                      : Z acceleration. [m/s/s] (type:float)
                xgyro                     : Angular speed around X axis. [rad/s] (type:float)
                ygyro                     : Angular speed around Y axis. [rad/s] (type:float)
                zgyro                     : Angular speed around Z axis. [rad/s] (type:float)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)

                '''
                return self.send(self.simstate_encode(roll, pitch, yaw, xacc, yacc, zacc, xgyro, ygyro, zgyro, lat, lng), force_mavlink1=force_mavlink1)

        def hwstatus_encode(self, Vcc, I2Cerr):
                '''
                Status of key hardware.

                Vcc                       : Board voltage. [mV] (type:uint16_t)
                I2Cerr                    : I2C error count. (type:uint8_t)

                '''
                return MAVLink_hwstatus_message(Vcc, I2Cerr)

        def hwstatus_send(self, Vcc, I2Cerr, force_mavlink1=False):
                '''
                Status of key hardware.

                Vcc                       : Board voltage. [mV] (type:uint16_t)
                I2Cerr                    : I2C error count. (type:uint8_t)

                '''
                return self.send(self.hwstatus_encode(Vcc, I2Cerr), force_mavlink1=force_mavlink1)

        def radio_encode(self, rssi, remrssi, txbuf, noise, remnoise, rxerrors, fixed):
                '''
                Status generated by radio.

                rssi                      : Local signal strength. (type:uint8_t)
                remrssi                   : Remote signal strength. (type:uint8_t)
                txbuf                     : How full the tx buffer is. [%] (type:uint8_t)
                noise                     : Background noise level. (type:uint8_t)
                remnoise                  : Remote background noise level. (type:uint8_t)
                rxerrors                  : Receive errors. (type:uint16_t)
                fixed                     : Count of error corrected packets. (type:uint16_t)

                '''
                return MAVLink_radio_message(rssi, remrssi, txbuf, noise, remnoise, rxerrors, fixed)

        def radio_send(self, rssi, remrssi, txbuf, noise, remnoise, rxerrors, fixed, force_mavlink1=False):
                '''
                Status generated by radio.

                rssi                      : Local signal strength. (type:uint8_t)
                remrssi                   : Remote signal strength. (type:uint8_t)
                txbuf                     : How full the tx buffer is. [%] (type:uint8_t)
                noise                     : Background noise level. (type:uint8_t)
                remnoise                  : Remote background noise level. (type:uint8_t)
                rxerrors                  : Receive errors. (type:uint16_t)
                fixed                     : Count of error corrected packets. (type:uint16_t)

                '''
                return self.send(self.radio_encode(rssi, remrssi, txbuf, noise, remnoise, rxerrors, fixed), force_mavlink1=force_mavlink1)

        def limits_status_encode(self, limits_state, last_trigger, last_action, last_recovery, last_clear, breach_count, mods_enabled, mods_required, mods_triggered):
                '''
                Status of AP_Limits. Sent in extended status stream when AP_Limits is
                enabled.

                limits_state              : State of AP_Limits. (type:uint8_t, values:LIMITS_STATE)
                last_trigger              : Time (since boot) of last breach. [ms] (type:uint32_t)
                last_action               : Time (since boot) of last recovery action. [ms] (type:uint32_t)
                last_recovery             : Time (since boot) of last successful recovery. [ms] (type:uint32_t)
                last_clear                : Time (since boot) of last all-clear. [ms] (type:uint32_t)
                breach_count              : Number of fence breaches. (type:uint16_t)
                mods_enabled              : AP_Limit_Module bitfield of enabled modules. (type:uint8_t, values:LIMIT_MODULE)
                mods_required             : AP_Limit_Module bitfield of required modules. (type:uint8_t, values:LIMIT_MODULE)
                mods_triggered            : AP_Limit_Module bitfield of triggered modules. (type:uint8_t, values:LIMIT_MODULE)

                '''
                return MAVLink_limits_status_message(limits_state, last_trigger, last_action, last_recovery, last_clear, breach_count, mods_enabled, mods_required, mods_triggered)

        def limits_status_send(self, limits_state, last_trigger, last_action, last_recovery, last_clear, breach_count, mods_enabled, mods_required, mods_triggered, force_mavlink1=False):
                '''
                Status of AP_Limits. Sent in extended status stream when AP_Limits is
                enabled.

                limits_state              : State of AP_Limits. (type:uint8_t, values:LIMITS_STATE)
                last_trigger              : Time (since boot) of last breach. [ms] (type:uint32_t)
                last_action               : Time (since boot) of last recovery action. [ms] (type:uint32_t)
                last_recovery             : Time (since boot) of last successful recovery. [ms] (type:uint32_t)
                last_clear                : Time (since boot) of last all-clear. [ms] (type:uint32_t)
                breach_count              : Number of fence breaches. (type:uint16_t)
                mods_enabled              : AP_Limit_Module bitfield of enabled modules. (type:uint8_t, values:LIMIT_MODULE)
                mods_required             : AP_Limit_Module bitfield of required modules. (type:uint8_t, values:LIMIT_MODULE)
                mods_triggered            : AP_Limit_Module bitfield of triggered modules. (type:uint8_t, values:LIMIT_MODULE)

                '''
                return self.send(self.limits_status_encode(limits_state, last_trigger, last_action, last_recovery, last_clear, breach_count, mods_enabled, mods_required, mods_triggered), force_mavlink1=force_mavlink1)

        def wind_encode(self, direction, speed, speed_z):
                '''
                Wind estimation.

                direction                 : Wind direction (that wind is coming from). [deg] (type:float)
                speed                     : Wind speed in ground plane. [m/s] (type:float)
                speed_z                   : Vertical wind speed. [m/s] (type:float)

                '''
                return MAVLink_wind_message(direction, speed, speed_z)

        def wind_send(self, direction, speed, speed_z, force_mavlink1=False):
                '''
                Wind estimation.

                direction                 : Wind direction (that wind is coming from). [deg] (type:float)
                speed                     : Wind speed in ground plane. [m/s] (type:float)
                speed_z                   : Vertical wind speed. [m/s] (type:float)

                '''
                return self.send(self.wind_encode(direction, speed, speed_z), force_mavlink1=force_mavlink1)

        def data16_encode(self, type, len, data):
                '''
                Data packet, size 16.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return MAVLink_data16_message(type, len, data)

        def data16_send(self, type, len, data, force_mavlink1=False):
                '''
                Data packet, size 16.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return self.send(self.data16_encode(type, len, data), force_mavlink1=force_mavlink1)

        def data32_encode(self, type, len, data):
                '''
                Data packet, size 32.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return MAVLink_data32_message(type, len, data)

        def data32_send(self, type, len, data, force_mavlink1=False):
                '''
                Data packet, size 32.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return self.send(self.data32_encode(type, len, data), force_mavlink1=force_mavlink1)

        def data64_encode(self, type, len, data):
                '''
                Data packet, size 64.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return MAVLink_data64_message(type, len, data)

        def data64_send(self, type, len, data, force_mavlink1=False):
                '''
                Data packet, size 64.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return self.send(self.data64_encode(type, len, data), force_mavlink1=force_mavlink1)

        def data96_encode(self, type, len, data):
                '''
                Data packet, size 96.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return MAVLink_data96_message(type, len, data)

        def data96_send(self, type, len, data, force_mavlink1=False):
                '''
                Data packet, size 96.

                type                      : Data type. (type:uint8_t)
                len                       : Data length. [bytes] (type:uint8_t)
                data                      : Raw data. (type:uint8_t)

                '''
                return self.send(self.data96_encode(type, len, data), force_mavlink1=force_mavlink1)

        def rangefinder_encode(self, distance, voltage):
                '''
                Rangefinder reporting.

                distance                  : Distance. [m] (type:float)
                voltage                   : Raw voltage if available, zero otherwise. [V] (type:float)

                '''
                return MAVLink_rangefinder_message(distance, voltage)

        def rangefinder_send(self, distance, voltage, force_mavlink1=False):
                '''
                Rangefinder reporting.

                distance                  : Distance. [m] (type:float)
                voltage                   : Raw voltage if available, zero otherwise. [V] (type:float)

                '''
                return self.send(self.rangefinder_encode(distance, voltage), force_mavlink1=force_mavlink1)

        def airspeed_autocal_encode(self, vx, vy, vz, diff_pressure, EAS2TAS, ratio, state_x, state_y, state_z, Pax, Pby, Pcz):
                '''
                Airspeed auto-calibration.

                vx                        : GPS velocity north. [m/s] (type:float)
                vy                        : GPS velocity east. [m/s] (type:float)
                vz                        : GPS velocity down. [m/s] (type:float)
                diff_pressure             : Differential pressure. [Pa] (type:float)
                EAS2TAS                   : Estimated to true airspeed ratio. (type:float)
                ratio                     : Airspeed ratio. (type:float)
                state_x                   : EKF state x. (type:float)
                state_y                   : EKF state y. (type:float)
                state_z                   : EKF state z. (type:float)
                Pax                       : EKF Pax. (type:float)
                Pby                       : EKF Pby. (type:float)
                Pcz                       : EKF Pcz. (type:float)

                '''
                return MAVLink_airspeed_autocal_message(vx, vy, vz, diff_pressure, EAS2TAS, ratio, state_x, state_y, state_z, Pax, Pby, Pcz)

        def airspeed_autocal_send(self, vx, vy, vz, diff_pressure, EAS2TAS, ratio, state_x, state_y, state_z, Pax, Pby, Pcz, force_mavlink1=False):
                '''
                Airspeed auto-calibration.

                vx                        : GPS velocity north. [m/s] (type:float)
                vy                        : GPS velocity east. [m/s] (type:float)
                vz                        : GPS velocity down. [m/s] (type:float)
                diff_pressure             : Differential pressure. [Pa] (type:float)
                EAS2TAS                   : Estimated to true airspeed ratio. (type:float)
                ratio                     : Airspeed ratio. (type:float)
                state_x                   : EKF state x. (type:float)
                state_y                   : EKF state y. (type:float)
                state_z                   : EKF state z. (type:float)
                Pax                       : EKF Pax. (type:float)
                Pby                       : EKF Pby. (type:float)
                Pcz                       : EKF Pcz. (type:float)

                '''
                return self.send(self.airspeed_autocal_encode(vx, vy, vz, diff_pressure, EAS2TAS, ratio, state_x, state_y, state_z, Pax, Pby, Pcz), force_mavlink1=force_mavlink1)

        def rally_point_encode(self, target_system, target_component, idx, count, lat, lng, alt, break_alt, land_dir, flags):
                '''
                A rally point. Used to set a point when from GCS -> MAV. Also used to
                return a point from MAV -> GCS.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 0). (type:uint8_t)
                count                     : Total number of points (for sanity checking). (type:uint8_t)
                lat                       : Latitude of point. [degE7] (type:int32_t)
                lng                       : Longitude of point. [degE7] (type:int32_t)
                alt                       : Transit / loiter altitude relative to home. [m] (type:int16_t)
                break_alt                 : Break altitude relative to home. [m] (type:int16_t)
                land_dir                  : Heading to aim for when landing. [cdeg] (type:uint16_t)
                flags                     : Configuration flags. (type:uint8_t, values:RALLY_FLAGS)

                '''
                return MAVLink_rally_point_message(target_system, target_component, idx, count, lat, lng, alt, break_alt, land_dir, flags)

        def rally_point_send(self, target_system, target_component, idx, count, lat, lng, alt, break_alt, land_dir, flags, force_mavlink1=False):
                '''
                A rally point. Used to set a point when from GCS -> MAV. Also used to
                return a point from MAV -> GCS.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 0). (type:uint8_t)
                count                     : Total number of points (for sanity checking). (type:uint8_t)
                lat                       : Latitude of point. [degE7] (type:int32_t)
                lng                       : Longitude of point. [degE7] (type:int32_t)
                alt                       : Transit / loiter altitude relative to home. [m] (type:int16_t)
                break_alt                 : Break altitude relative to home. [m] (type:int16_t)
                land_dir                  : Heading to aim for when landing. [cdeg] (type:uint16_t)
                flags                     : Configuration flags. (type:uint8_t, values:RALLY_FLAGS)

                '''
                return self.send(self.rally_point_encode(target_system, target_component, idx, count, lat, lng, alt, break_alt, land_dir, flags), force_mavlink1=force_mavlink1)

        def rally_fetch_point_encode(self, target_system, target_component, idx):
                '''
                Request a current rally point from MAV. MAV should respond with a
                RALLY_POINT message. MAV should not respond if the
                request is invalid.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 0). (type:uint8_t)

                '''
                return MAVLink_rally_fetch_point_message(target_system, target_component, idx)

        def rally_fetch_point_send(self, target_system, target_component, idx, force_mavlink1=False):
                '''
                Request a current rally point from MAV. MAV should respond with a
                RALLY_POINT message. MAV should not respond if the
                request is invalid.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                idx                       : Point index (first point is 0). (type:uint8_t)

                '''
                return self.send(self.rally_fetch_point_encode(target_system, target_component, idx), force_mavlink1=force_mavlink1)

        def compassmot_status_encode(self, throttle, current, interference, CompensationX, CompensationY, CompensationZ):
                '''
                Status of compassmot calibration.

                throttle                  : Throttle. [d%] (type:uint16_t)
                current                   : Current. [A] (type:float)
                interference              : Interference. [%] (type:uint16_t)
                CompensationX             : Motor Compensation X. (type:float)
                CompensationY             : Motor Compensation Y. (type:float)
                CompensationZ             : Motor Compensation Z. (type:float)

                '''
                return MAVLink_compassmot_status_message(throttle, current, interference, CompensationX, CompensationY, CompensationZ)

        def compassmot_status_send(self, throttle, current, interference, CompensationX, CompensationY, CompensationZ, force_mavlink1=False):
                '''
                Status of compassmot calibration.

                throttle                  : Throttle. [d%] (type:uint16_t)
                current                   : Current. [A] (type:float)
                interference              : Interference. [%] (type:uint16_t)
                CompensationX             : Motor Compensation X. (type:float)
                CompensationY             : Motor Compensation Y. (type:float)
                CompensationZ             : Motor Compensation Z. (type:float)

                '''
                return self.send(self.compassmot_status_encode(throttle, current, interference, CompensationX, CompensationY, CompensationZ), force_mavlink1=force_mavlink1)

        def ahrs2_encode(self, roll, pitch, yaw, altitude, lat, lng):
                '''
                Status of secondary AHRS filter if available.

                roll                      : Roll angle. [rad] (type:float)
                pitch                     : Pitch angle. [rad] (type:float)
                yaw                       : Yaw angle. [rad] (type:float)
                altitude                  : Altitude (MSL). [m] (type:float)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)

                '''
                return MAVLink_ahrs2_message(roll, pitch, yaw, altitude, lat, lng)

        def ahrs2_send(self, roll, pitch, yaw, altitude, lat, lng, force_mavlink1=False):
                '''
                Status of secondary AHRS filter if available.

                roll                      : Roll angle. [rad] (type:float)
                pitch                     : Pitch angle. [rad] (type:float)
                yaw                       : Yaw angle. [rad] (type:float)
                altitude                  : Altitude (MSL). [m] (type:float)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)

                '''
                return self.send(self.ahrs2_encode(roll, pitch, yaw, altitude, lat, lng), force_mavlink1=force_mavlink1)

        def camera_status_encode(self, time_usec, target_system, cam_idx, img_idx, event_id, p1, p2, p3, p4):
                '''
                Camera Event.

                time_usec                 : Image timestamp (since UNIX epoch, according to camera clock). [us] (type:uint64_t)
                target_system             : System ID. (type:uint8_t)
                cam_idx                   : Camera ID. (type:uint8_t)
                img_idx                   : Image index. (type:uint16_t)
                event_id                  : Event type. (type:uint8_t, values:CAMERA_STATUS_TYPES)
                p1                        : Parameter 1 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)
                p2                        : Parameter 2 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)
                p3                        : Parameter 3 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)
                p4                        : Parameter 4 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)

                '''
                return MAVLink_camera_status_message(time_usec, target_system, cam_idx, img_idx, event_id, p1, p2, p3, p4)

        def camera_status_send(self, time_usec, target_system, cam_idx, img_idx, event_id, p1, p2, p3, p4, force_mavlink1=False):
                '''
                Camera Event.

                time_usec                 : Image timestamp (since UNIX epoch, according to camera clock). [us] (type:uint64_t)
                target_system             : System ID. (type:uint8_t)
                cam_idx                   : Camera ID. (type:uint8_t)
                img_idx                   : Image index. (type:uint16_t)
                event_id                  : Event type. (type:uint8_t, values:CAMERA_STATUS_TYPES)
                p1                        : Parameter 1 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)
                p2                        : Parameter 2 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)
                p3                        : Parameter 3 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)
                p4                        : Parameter 4 (meaning depends on event_id, see CAMERA_STATUS_TYPES enum). (type:float)

                '''
                return self.send(self.camera_status_encode(time_usec, target_system, cam_idx, img_idx, event_id, p1, p2, p3, p4), force_mavlink1=force_mavlink1)

        def camera_feedback_encode(self, time_usec, target_system, cam_idx, img_idx, lat, lng, alt_msl, alt_rel, roll, pitch, yaw, foc_len, flags):
                '''
                Camera Capture Feedback.

                time_usec                 : Image timestamp (since UNIX epoch), as passed in by CAMERA_STATUS message (or autopilot if no CCB). [us] (type:uint64_t)
                target_system             : System ID. (type:uint8_t)
                cam_idx                   : Camera ID. (type:uint8_t)
                img_idx                   : Image index. (type:uint16_t)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)
                alt_msl                   : Altitude (MSL). [m] (type:float)
                alt_rel                   : Altitude (Relative to HOME location). [m] (type:float)
                roll                      : Camera Roll angle (earth frame, +-180). [deg] (type:float)
                pitch                     : Camera Pitch angle (earth frame, +-180). [deg] (type:float)
                yaw                       : Camera Yaw (earth frame, 0-360, true). [deg] (type:float)
                foc_len                   : Focal Length. [mm] (type:float)
                flags                     : Feedback flags. (type:uint8_t, values:CAMERA_FEEDBACK_FLAGS)

                '''
                return MAVLink_camera_feedback_message(time_usec, target_system, cam_idx, img_idx, lat, lng, alt_msl, alt_rel, roll, pitch, yaw, foc_len, flags)

        def camera_feedback_send(self, time_usec, target_system, cam_idx, img_idx, lat, lng, alt_msl, alt_rel, roll, pitch, yaw, foc_len, flags, force_mavlink1=False):
                '''
                Camera Capture Feedback.

                time_usec                 : Image timestamp (since UNIX epoch), as passed in by CAMERA_STATUS message (or autopilot if no CCB). [us] (type:uint64_t)
                target_system             : System ID. (type:uint8_t)
                cam_idx                   : Camera ID. (type:uint8_t)
                img_idx                   : Image index. (type:uint16_t)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)
                alt_msl                   : Altitude (MSL). [m] (type:float)
                alt_rel                   : Altitude (Relative to HOME location). [m] (type:float)
                roll                      : Camera Roll angle (earth frame, +-180). [deg] (type:float)
                pitch                     : Camera Pitch angle (earth frame, +-180). [deg] (type:float)
                yaw                       : Camera Yaw (earth frame, 0-360, true). [deg] (type:float)
                foc_len                   : Focal Length. [mm] (type:float)
                flags                     : Feedback flags. (type:uint8_t, values:CAMERA_FEEDBACK_FLAGS)

                '''
                return self.send(self.camera_feedback_encode(time_usec, target_system, cam_idx, img_idx, lat, lng, alt_msl, alt_rel, roll, pitch, yaw, foc_len, flags), force_mavlink1=force_mavlink1)

        def battery2_encode(self, voltage, current_battery):
                '''
                2nd Battery status

                voltage                   : Voltage. [mV] (type:uint16_t)
                current_battery           : Battery current, -1: autopilot does not measure the current. [cA] (type:int16_t)

                '''
                return MAVLink_battery2_message(voltage, current_battery)

        def battery2_send(self, voltage, current_battery, force_mavlink1=False):
                '''
                2nd Battery status

                voltage                   : Voltage. [mV] (type:uint16_t)
                current_battery           : Battery current, -1: autopilot does not measure the current. [cA] (type:int16_t)

                '''
                return self.send(self.battery2_encode(voltage, current_battery), force_mavlink1=force_mavlink1)

        def ahrs3_encode(self, roll, pitch, yaw, altitude, lat, lng, v1, v2, v3, v4):
                '''
                Status of third AHRS filter if available. This is for ANU research
                group (Ali and Sean).

                roll                      : Roll angle. [rad] (type:float)
                pitch                     : Pitch angle. [rad] (type:float)
                yaw                       : Yaw angle. [rad] (type:float)
                altitude                  : Altitude (MSL). [m] (type:float)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)
                v1                        : Test variable1. (type:float)
                v2                        : Test variable2. (type:float)
                v3                        : Test variable3. (type:float)
                v4                        : Test variable4. (type:float)

                '''
                return MAVLink_ahrs3_message(roll, pitch, yaw, altitude, lat, lng, v1, v2, v3, v4)

        def ahrs3_send(self, roll, pitch, yaw, altitude, lat, lng, v1, v2, v3, v4, force_mavlink1=False):
                '''
                Status of third AHRS filter if available. This is for ANU research
                group (Ali and Sean).

                roll                      : Roll angle. [rad] (type:float)
                pitch                     : Pitch angle. [rad] (type:float)
                yaw                       : Yaw angle. [rad] (type:float)
                altitude                  : Altitude (MSL). [m] (type:float)
                lat                       : Latitude. [degE7] (type:int32_t)
                lng                       : Longitude. [degE7] (type:int32_t)
                v1                        : Test variable1. (type:float)
                v2                        : Test variable2. (type:float)
                v3                        : Test variable3. (type:float)
                v4                        : Test variable4. (type:float)

                '''
                return self.send(self.ahrs3_encode(roll, pitch, yaw, altitude, lat, lng, v1, v2, v3, v4), force_mavlink1=force_mavlink1)

        def autopilot_version_request_encode(self, target_system, target_component):
                '''
                Request the autopilot version from the system/component.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)

                '''
                return MAVLink_autopilot_version_request_message(target_system, target_component)

        def autopilot_version_request_send(self, target_system, target_component, force_mavlink1=False):
                '''
                Request the autopilot version from the system/component.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)

                '''
                return self.send(self.autopilot_version_request_encode(target_system, target_component), force_mavlink1=force_mavlink1)

        def remote_log_data_block_encode(self, target_system, target_component, seqno, data):
                '''
                Send a block of log data to remote location.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                seqno                     : Log data block sequence number. (type:uint32_t, values:MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS)
                data                      : Log data block. (type:uint8_t)

                '''
                return MAVLink_remote_log_data_block_message(target_system, target_component, seqno, data)

        def remote_log_data_block_send(self, target_system, target_component, seqno, data, force_mavlink1=False):
                '''
                Send a block of log data to remote location.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                seqno                     : Log data block sequence number. (type:uint32_t, values:MAV_REMOTE_LOG_DATA_BLOCK_COMMANDS)
                data                      : Log data block. (type:uint8_t)

                '''
                return self.send(self.remote_log_data_block_encode(target_system, target_component, seqno, data), force_mavlink1=force_mavlink1)

        def remote_log_block_status_encode(self, target_system, target_component, seqno, status):
                '''
                Send Status of each log block that autopilot board might have sent.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                seqno                     : Log data block sequence number. (type:uint32_t)
                status                    : Log data block status. (type:uint8_t, values:MAV_REMOTE_LOG_DATA_BLOCK_STATUSES)

                '''
                return MAVLink_remote_log_block_status_message(target_system, target_component, seqno, status)

        def remote_log_block_status_send(self, target_system, target_component, seqno, status, force_mavlink1=False):
                '''
                Send Status of each log block that autopilot board might have sent.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                seqno                     : Log data block sequence number. (type:uint32_t)
                status                    : Log data block status. (type:uint8_t, values:MAV_REMOTE_LOG_DATA_BLOCK_STATUSES)

                '''
                return self.send(self.remote_log_block_status_encode(target_system, target_component, seqno, status), force_mavlink1=force_mavlink1)

        def led_control_encode(self, target_system, target_component, instance, pattern, custom_len, custom_bytes):
                '''
                Control vehicle LEDs.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                instance                  : Instance (LED instance to control or 255 for all LEDs). (type:uint8_t)
                pattern                   : Pattern (see LED_PATTERN_ENUM). (type:uint8_t)
                custom_len                : Custom Byte Length. (type:uint8_t)
                custom_bytes              : Custom Bytes. (type:uint8_t)

                '''
                return MAVLink_led_control_message(target_system, target_component, instance, pattern, custom_len, custom_bytes)

        def led_control_send(self, target_system, target_component, instance, pattern, custom_len, custom_bytes, force_mavlink1=False):
                '''
                Control vehicle LEDs.

                target_system             : System ID. (type:uint8_t)
                target_component          : Component ID. (type:uint8_t)
                instance                  : Instance (LED instance to control or 255 for all LEDs). (type:uint8_t)
                pattern                   : Pattern (see LED_PATTERN_ENUM). (type:uint8_t)
                custom_len                : Custom Byte Length. (type:uint8_t)
                custom_bytes              : Custom Bytes. (type:uint8_t)

                '''
                return self.send(self.led_control_encode(target_system, target_component, instance, pattern, custom_len, custom_bytes), force_mavlink1=force_mavlink1)

        def mag_cal_progress_encode(self, compass_id, cal_mask, cal_status, attempt, completion_pct, completion_mask, direction_x, direction_y, direction_z):
                '''
                Reports progress of compass calibration.

                compass_id                : Compass being calibrated. (type:uint8_t)
                cal_mask                  : Bitmask of compasses being calibrated. (type:uint8_t)
                cal_status                : Calibration Status. (type:uint8_t, values:MAG_CAL_STATUS)
                attempt                   : Attempt number. (type:uint8_t)
                completion_pct            : Completion percentage. [%] (type:uint8_t)
                completion_mask           : Bitmask of sphere sections (see http://en.wikipedia.org/wiki/Geodesic_grid). (type:uint8_t)
                direction_x               : Body frame direction vector for display. (type:float)
                direction_y               : Body frame direction vector for display. (type:float)
                direction_z               : Body frame direction vector for display. (type:float)

                '''
                return MAVLink_mag_cal_progress_message(compass_id, cal_mask, cal_status, attempt, completion_pct, completion_mask, direction_x, direction_y, direction_z)

        def mag_cal_progress_send(self, compass_id, cal_mask, cal_status, attempt, completion_pct, completion_mask, direction_x, direction_y, direction_z, force_mavlink1=False):
                '''
                Reports progress of compass calibration.

                compass_id                : Compass being calibrated. (type:uint8_t)
                cal_mask                  : Bitmask of compasses being calibrated. (type:uint8_t)
                cal_status                : Calibration Status. (type:uint8_t, values:MAG_CAL_STATUS)
                attempt                   : Attempt number. (type:uint8_t)
                completion_pct            : Completion percentage. [%] (type:uint8_t)
                completion_mask           : Bitmask of sphere sections (see http://en.wikipedia.org/wiki/Geodesic_grid). (type:uint8_t)
                direction_x               : Body frame direction vector for display. (type:float)
                direction_y               : Body frame direction vector for display. (type:float)
                direction_z               : Body frame direction vector for display. (type:float)

                '''
                return self.send(self.mag_cal_progress_encode(compass_id, cal_mask, cal_status, attempt, completion_pct, completion_mask, direction_x, direction_y, direction_z), force_mavlink1=force_mavlink1)

        def ekf_status_report_encode(self, flags, velocity_variance, pos_horiz_variance, pos_vert_variance, compass_variance, terrain_alt_variance):
                '''
                EKF Status message including flags and variances.

                flags                     : Flags. (type:uint16_t, values:EKF_STATUS_FLAGS)
                velocity_variance         : Velocity variance. (type:float)
                pos_horiz_variance        : Horizontal Position variance. (type:float)
                pos_vert_variance         : Vertical Position variance. (type:float)
                compass_variance          : Compass variance. (type:float)
                terrain_alt_variance        : Terrain Altitude variance. (type:float)

                '''
                return MAVLink_ekf_status_report_message(flags, velocity_variance, pos_horiz_variance, pos_vert_variance, compass_variance, terrain_alt_variance)

        def ekf_status_report_send(self, flags, velocity_variance, pos_horiz_variance, pos_vert_variance, compass_variance, terrain_alt_variance, force_mavlink1=False):
                '''
                EKF Status message including flags and variances.

                flags                  