# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Service(pulumi.CustomResource):
    autogenerate_revision_name: pulumi.Output[bool]
    """
    If set to `true`, the revision name (template.metadata.name) will be omitted and 
    autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
    is also set.
    (For legacy support, if `template.metadata.name` is unset in state while
    this field is set to false, the revision name will still autogenerate.)
    """
    location: pulumi.Output[str]
    """
    The location of the cloud run instance. eg us-central1
    """
    metadata: pulumi.Output[dict]
    """
    Metadata associated with this Service, including name, namespace, labels,
    and annotations.  Structure is documented below.

      * `annotations` (`dict`) - Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata. More
        info: http://kubernetes.io/docs/user-guide/annotations
      * `generation` (`float`) - -
        A sequence number representing a specific generation of the desired state.
      * `labels` (`dict`) - Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
      * `namespace` (`str`) - In Cloud Run the namespace must be equal to either the
        project ID or project number.
      * `resourceVersion` (`str`) - -
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
      * `self_link` (`str`) - -
        SelfLink is a URL representing this object.
      * `uid` (`str`) - -
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
    """
    name: pulumi.Output[str]
    """
    Name of the environment variable.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    status: pulumi.Output[dict]
    """
    The current status of the Service.

      * `conditions` (`list`)
        * `message` (`str`)
        * `reason` (`str`)
        * `status` (`str`)
        * `type` (`str`)

      * `latestCreatedRevisionName` (`str`)
      * `latestReadyRevisionName` (`str`)
      * `observedGeneration` (`float`)
      * `url` (`str`)
    """
    template: pulumi.Output[dict]
    """
    template holds the latest specification for the Revision to
    be stamped out. The template references the container image, and may also
    include labels and annotations that should be attached to the Revision.
    To correlate a Revision, and/or to force a Revision to be created when the
    spec doesn't otherwise change, a nonce label may be provided in the
    template metadata. For more details, see:
    https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
    Cloud Run does not currently support referencing a build that is
    responsible for materializing the container image from source.  Structure is documented below.

      * `metadata` (`dict`) - Metadata associated with this Service, including name, namespace, labels,
        and annotations.  Structure is documented below.
        * `annotations` (`dict`) - Annotations is a key value map stored with a resource that
          may be set by external tools to store and retrieve arbitrary metadata. More
          info: http://kubernetes.io/docs/user-guide/annotations
        * `generation` (`float`) - -
          A sequence number representing a specific generation of the desired state.
        * `labels` (`dict`) - Map of string keys and values that can be used to organize and categorize
          (scope and select) objects. May match selectors of replication controllers
          and routes.
          More info: http://kubernetes.io/docs/user-guide/labels
        * `name` (`str`) - Name of the environment variable.
        * `namespace` (`str`) - In Cloud Run the namespace must be equal to either the
          project ID or project number.
        * `resourceVersion` (`str`) - -
          An opaque value that represents the internal version of this object that
          can be used by clients to determine when objects have changed. May be used
          for optimistic concurrency, change detection, and the watch operation on a
          resource or set of resources. They may only be valid for a
          particular resource or set of resources.
          More info:
          https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        * `self_link` (`str`) - -
          SelfLink is a URL representing this object.
        * `uid` (`str`) - -
          UID is a unique id generated by the server on successful creation of a resource and is not
          allowed to change on PUT operations.
          More info: http://kubernetes.io/docs/user-guide/identifiers#uids

      * `spec` (`dict`) - RevisionSpec holds the desired state of the Revision (from the client).  Structure is documented below.
        * `containerConcurrency` (`float`) - ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
          requests per container of the Revision. Values are:
          - `0` thread-safe, the system should manage the max concurrency. This is
          the default value.
          - `1` not-thread-safe. Single concurrency
          - `2-N` thread-safe, max concurrency of N
        * `containers` (`list`) - Container defines the unit of execution for this Revision.
          In the context of a Revision, we disallow a number of the fields of
          this Container, including: name, ports, and volumeMounts.
          The runtime contract is documented here:
          https://github.com/knative/serving/blob/master/docs/runtime-contract.md  Structure is documented below.
          * `args` (`list`) - Arguments to the entrypoint.
            The docker image's CMD is used if this is not provided.
            Variable references $(VAR_NAME) are expanded using the container's
            environment. If a variable cannot be resolved, the reference in the input
            string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
            double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
            regardless of whether the variable exists or not.
            More info:
            https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
          * `commands` (`list`) - Entrypoint array. Not executed within a shell.
            The docker image's ENTRYPOINT is used if this is not provided.
            Variable references $(VAR_NAME) are expanded using the container's
            environment. If a variable cannot be resolved, the reference in the input
            string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
            double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
            regardless of whether the variable exists or not.
            More info:
            https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
          * `envFroms` (`list`) - -
            (Optional, Deprecated)
            List of sources to populate environment variables in the container.
            All invalid keys will be reported as an event when the container is starting.
            When a key exists in multiple sources, the value associated with the last source will
            take precedence. Values defined by an Env with a duplicate key will take
            precedence.  Structure is documented below.
            * `configMapRef` (`dict`) - The ConfigMap to select from.  Structure is documented below.
              * `localObjectReference` (`dict`) - The Secret to select from.  Structure is documented below.
                * `name` (`str`) - Name of the environment variable.

              * `optional` (`bool`) - Specify whether the Secret must be defined

            * `prefix` (`str`) - An optional identifier to prepend to each key in the ConfigMap.
            * `secretRef` (`dict`) - The Secret to select from.  Structure is documented below.
              * `localObjectReference` (`dict`) - The Secret to select from.  Structure is documented below.
                * `name` (`str`) - Name of the environment variable.

              * `optional` (`bool`) - Specify whether the Secret must be defined

          * `envs` (`list`) - List of environment variables to set in the container.  Structure is documented below.
            * `name` (`str`) - Name of the environment variable.
            * `value` (`str`) - Variable references $(VAR_NAME) are expanded
              using the previous defined environment variables in the container and
              any route environment variables. If a variable cannot be resolved,
              the reference in the input string will be unchanged. The $(VAR_NAME)
              syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
              references will never be expanded, regardless of whether the variable
              exists or not.
              Defaults to "".

          * `image` (`str`) - Docker image name. This is most often a reference to a container located
            in the container registry, such as gcr.io/cloudrun/hello
            More info: https://kubernetes.io/docs/concepts/containers/images
          * `resources` (`dict`) - Compute Resources required by this container. Used to set values such as max memory
            More info:
            https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources  Structure is documented below.
            * `limits` (`dict`) - Limits describes the maximum amount of compute resources allowed.
              The values of the map is string form of the 'quantity' k8s type:
              https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
            * `requests` (`dict`) - Requests describes the minimum amount of compute resources required.
              If Requests is omitted for a container, it defaults to Limits if that is
              explicitly specified, otherwise to an implementation-defined value.
              The values of the map is string form of the 'quantity' k8s type:
              https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go

          * `workingDir` (`str`) - -
            (Optional, Deprecated)
            Container's working directory.
            If not specified, the container runtime's default will be used, which
            might be configured in the container image.

        * `service_account_name` (`str`) - Email address of the IAM service account associated with the revision of the
          service. The service account represents the identity of the running revision,
          and determines what permissions the revision has. If not provided, the revision
          will use the project's default service account.
        * `servingState` (`str`) - -
          ServingState holds a value describing the state the resources
          are in for this Revision.
          It is expected
          that the system will manipulate this based on routability and load.
    """
    traffics: pulumi.Output[list]
    """
    Traffic specifies how to distribute traffic over a collection of Knative Revisions
    and Configurations  Structure is documented below.

      * `latestRevision` (`bool`) - LatestRevision may be optionally provided to indicate that the latest ready
        Revision of the Configuration should be used for this traffic target. When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
      * `percent` (`float`) - Percent specifies percent of the traffic to this Revision or Configuration.
      * `revisionName` (`str`) - RevisionName of a specific revision to which to send this portion of traffic.
    """
    def __init__(__self__, resource_name, opts=None, autogenerate_revision_name=None, location=None, metadata=None, name=None, project=None, template=None, traffics=None, __props__=None, __name__=None, __opts__=None):
        """
        Service acts as a top-level container that manages a set of Routes and
        Configurations which implement a network service. Service exists to provide a
        singular abstraction which can be access controlled, reasoned about, and
        which encapsulates software lifecycle decisions such as rollout policy and
        team resource ownership. Service acts only as an orchestrator of the
        underlying Routes and Configurations (much as a kubernetes Deployment
        orchestrates ReplicaSets).

        The Service's controller will track the statuses of its owned Configuration
        and Route, reflecting their statuses and conditions as its own.

        See also:
        https://github.com/knative/serving/blob/master/docs/spec/overview.md#service


        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)


        ## Example Usage

        ### Cloud Run Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            },
            traffics=[{
                "latestRevision": True,
                "percent": 100,
            }])
        ```

        ### Cloud Run Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            region="us-east1",
            settings={
                "tier": "db-f1-micro",
            })
        default = gcp.cloudrun.Service("default",
            autogenerate_revision_name=True,
            location="us-central1",
            template={
                "metadata": {
                    "annotations": {
                        "autoscaling.knative.dev/maxScale": "1000",
                        "run.googleapis.com/client-name": "demo",
                        "run.googleapis.com/cloudsql-instances": instance.name.apply(lambda name: f"my-project-name:us-central1:{name}"),
                    },
                },
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            })
        ```

        ### Cloud Run Service Multiple Environment Variables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            autogenerate_revision_name=True,
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "env": [
                            {
                                "name": "SOURCE",
                                "value": "remote",
                            },
                            {
                                "name": "TARGET",
                                "value": "home",
                            },
                        ],
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            },
            traffics=[{
                "latestRevision": True,
                "percent": 100,
            }])
        ```

        ## Example Usage - Cloud Run Service Traffic Split


        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template={
                "metadata": {
                    "name": "cloudrun-srv-green",
                },
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            },
            traffics=[
                {
                    "percent": 25,
                    "revisionName": "cloudrun-srv-green",
                },
                {
                    "percent": 75,
                    "revisionName": "cloudrun-srv-blue",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and 
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[dict] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.  Structure is documented below.
        :param pulumi.Input[str] name: Name of the environment variable.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[dict] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.  Structure is documented below.
        :param pulumi.Input[list] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations  Structure is documented below.

        The **metadata** object supports the following:

          * `annotations` (`pulumi.Input[dict]`) - Annotations is a key value map stored with a resource that
            may be set by external tools to store and retrieve arbitrary metadata. More
            info: http://kubernetes.io/docs/user-guide/annotations
          * `generation` (`pulumi.Input[float]`) - -
            A sequence number representing a specific generation of the desired state.
          * `labels` (`pulumi.Input[dict]`) - Map of string keys and values that can be used to organize and categorize
            (scope and select) objects. May match selectors of replication controllers
            and routes.
            More info: http://kubernetes.io/docs/user-guide/labels
          * `namespace` (`pulumi.Input[str]`) - In Cloud Run the namespace must be equal to either the
            project ID or project number.
          * `resourceVersion` (`pulumi.Input[str]`) - -
            An opaque value that represents the internal version of this object that
            can be used by clients to determine when objects have changed. May be used
            for optimistic concurrency, change detection, and the watch operation on a
            resource or set of resources. They may only be valid for a
            particular resource or set of resources.
            More info:
            https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
          * `self_link` (`pulumi.Input[str]`) - -
            SelfLink is a URL representing this object.
          * `uid` (`pulumi.Input[str]`) - -
            UID is a unique id generated by the server on successful creation of a resource and is not
            allowed to change on PUT operations.
            More info: http://kubernetes.io/docs/user-guide/identifiers#uids

        The **template** object supports the following:

          * `metadata` (`pulumi.Input[dict]`) - Metadata associated with this Service, including name, namespace, labels,
            and annotations.  Structure is documented below.
            * `annotations` (`pulumi.Input[dict]`) - Annotations is a key value map stored with a resource that
              may be set by external tools to store and retrieve arbitrary metadata. More
              info: http://kubernetes.io/docs/user-guide/annotations
            * `generation` (`pulumi.Input[float]`) - -
              A sequence number representing a specific generation of the desired state.
            * `labels` (`pulumi.Input[dict]`) - Map of string keys and values that can be used to organize and categorize
              (scope and select) objects. May match selectors of replication controllers
              and routes.
              More info: http://kubernetes.io/docs/user-guide/labels
            * `name` (`pulumi.Input[str]`) - Name of the environment variable.
            * `namespace` (`pulumi.Input[str]`) - In Cloud Run the namespace must be equal to either the
              project ID or project number.
            * `resourceVersion` (`pulumi.Input[str]`) - -
              An opaque value that represents the internal version of this object that
              can be used by clients to determine when objects have changed. May be used
              for optimistic concurrency, change detection, and the watch operation on a
              resource or set of resources. They may only be valid for a
              particular resource or set of resources.
              More info:
              https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
            * `self_link` (`pulumi.Input[str]`) - -
              SelfLink is a URL representing this object.
            * `uid` (`pulumi.Input[str]`) - -
              UID is a unique id generated by the server on successful creation of a resource and is not
              allowed to change on PUT operations.
              More info: http://kubernetes.io/docs/user-guide/identifiers#uids

          * `spec` (`pulumi.Input[dict]`) - RevisionSpec holds the desired state of the Revision (from the client).  Structure is documented below.
            * `containerConcurrency` (`pulumi.Input[float]`) - ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
              requests per container of the Revision. Values are:
              - `0` thread-safe, the system should manage the max concurrency. This is
              the default value.
              - `1` not-thread-safe. Single concurrency
              - `2-N` thread-safe, max concurrency of N
            * `containers` (`pulumi.Input[list]`) - Container defines the unit of execution for this Revision.
              In the context of a Revision, we disallow a number of the fields of
              this Container, including: name, ports, and volumeMounts.
              The runtime contract is documented here:
              https://github.com/knative/serving/blob/master/docs/runtime-contract.md  Structure is documented below.
              * `args` (`pulumi.Input[list]`) - Arguments to the entrypoint.
                The docker image's CMD is used if this is not provided.
                Variable references $(VAR_NAME) are expanded using the container's
                environment. If a variable cannot be resolved, the reference in the input
                string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
                double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
                regardless of whether the variable exists or not.
                More info:
                https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
              * `commands` (`pulumi.Input[list]`) - Entrypoint array. Not executed within a shell.
                The docker image's ENTRYPOINT is used if this is not provided.
                Variable references $(VAR_NAME) are expanded using the container's
                environment. If a variable cannot be resolved, the reference in the input
                string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
                double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
                regardless of whether the variable exists or not.
                More info:
                https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
              * `envFroms` (`pulumi.Input[list]`) - -
                (Optional, Deprecated)
                List of sources to populate environment variables in the container.
                All invalid keys will be reported as an event when the container is starting.
                When a key exists in multiple sources, the value associated with the last source will
                take precedence. Values defined by an Env with a duplicate key will take
                precedence.  Structure is documented below.
                * `configMapRef` (`pulumi.Input[dict]`) - The ConfigMap to select from.  Structure is documented below.
                  * `localObjectReference` (`pulumi.Input[dict]`) - The Secret to select from.  Structure is documented below.
                    * `name` (`pulumi.Input[str]`) - Name of the environment variable.

                  * `optional` (`pulumi.Input[bool]`) - Specify whether the Secret must be defined

                * `prefix` (`pulumi.Input[str]`) - An optional identifier to prepend to each key in the ConfigMap.
                * `secretRef` (`pulumi.Input[dict]`) - The Secret to select from.  Structure is documented below.
                  * `localObjectReference` (`pulumi.Input[dict]`) - The Secret to select from.  Structure is documented below.
                    * `name` (`pulumi.Input[str]`) - Name of the environment variable.

                  * `optional` (`pulumi.Input[bool]`) - Specify whether the Secret must be defined

              * `envs` (`pulumi.Input[list]`) - List of environment variables to set in the container.  Structure is documented below.
                * `name` (`pulumi.Input[str]`) - Name of the environment variable.
                * `value` (`pulumi.Input[str]`) - Variable references $(VAR_NAME) are expanded
                  using the previous defined environment variables in the container and
                  any route environment variables. If a variable cannot be resolved,
                  the reference in the input string will be unchanged. The $(VAR_NAME)
                  syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
                  references will never be expanded, regardless of whether the variable
                  exists or not.
                  Defaults to "".

              * `image` (`pulumi.Input[str]`) - Docker image name. This is most often a reference to a container located
                in the container registry, such as gcr.io/cloudrun/hello
                More info: https://kubernetes.io/docs/concepts/containers/images
              * `resources` (`pulumi.Input[dict]`) - Compute Resources required by this container. Used to set values such as max memory
                More info:
                https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources  Structure is documented below.
                * `limits` (`pulumi.Input[dict]`) - Limits describes the maximum amount of compute resources allowed.
                  The values of the map is string form of the 'quantity' k8s type:
                  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
                * `requests` (`pulumi.Input[dict]`) - Requests describes the minimum amount of compute resources required.
                  If Requests is omitted for a container, it defaults to Limits if that is
                  explicitly specified, otherwise to an implementation-defined value.
                  The values of the map is string form of the 'quantity' k8s type:
                  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go

              * `workingDir` (`pulumi.Input[str]`) - -
                (Optional, Deprecated)
                Container's working directory.
                If not specified, the container runtime's default will be used, which
                might be configured in the container image.

            * `service_account_name` (`pulumi.Input[str]`) - Email address of the IAM service account associated with the revision of the
              service. The service account represents the identity of the running revision,
              and determines what permissions the revision has. If not provided, the revision
              will use the project's default service account.
            * `servingState` (`pulumi.Input[str]`) - -
              ServingState holds a value describing the state the resources
              are in for this Revision.
              It is expected
              that the system will manipulate this based on routability and load.

        The **traffics** object supports the following:

          * `latestRevision` (`pulumi.Input[bool]`) - LatestRevision may be optionally provided to indicate that the latest ready
            Revision of the Configuration should be used for this traffic target. When
            provided LatestRevision must be true if RevisionName is empty; it must be
            false when RevisionName is non-empty.
          * `percent` (`pulumi.Input[float]`) - Percent specifies percent of the traffic to this Revision or Configuration.
          * `revisionName` (`pulumi.Input[str]`) - RevisionName of a specific revision to which to send this portion of traffic.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['autogenerate_revision_name'] = autogenerate_revision_name
            if location is None:
                raise TypeError("Missing required property 'location'")
            __props__['location'] = location
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['project'] = project
            __props__['template'] = template
            __props__['traffics'] = traffics
            __props__['status'] = None
        super(Service, __self__).__init__(
            'gcp:cloudrun/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, autogenerate_revision_name=None, location=None, metadata=None, name=None, project=None, status=None, template=None, traffics=None):
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and 
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[dict] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.  Structure is documented below.
        :param pulumi.Input[str] name: Name of the environment variable.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[dict] status: The current status of the Service.
        :param pulumi.Input[dict] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.  Structure is documented below.
        :param pulumi.Input[list] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations  Structure is documented below.

        The **metadata** object supports the following:

          * `annotations` (`pulumi.Input[dict]`) - Annotations is a key value map stored with a resource that
            may be set by external tools to store and retrieve arbitrary metadata. More
            info: http://kubernetes.io/docs/user-guide/annotations
          * `generation` (`pulumi.Input[float]`) - -
            A sequence number representing a specific generation of the desired state.
          * `labels` (`pulumi.Input[dict]`) - Map of string keys and values that can be used to organize and categorize
            (scope and select) objects. May match selectors of replication controllers
            and routes.
            More info: http://kubernetes.io/docs/user-guide/labels
          * `namespace` (`pulumi.Input[str]`) - In Cloud Run the namespace must be equal to either the
            project ID or project number.
          * `resourceVersion` (`pulumi.Input[str]`) - -
            An opaque value that represents the internal version of this object that
            can be used by clients to determine when objects have changed. May be used
            for optimistic concurrency, change detection, and the watch operation on a
            resource or set of resources. They may only be valid for a
            particular resource or set of resources.
            More info:
            https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
          * `self_link` (`pulumi.Input[str]`) - -
            SelfLink is a URL representing this object.
          * `uid` (`pulumi.Input[str]`) - -
            UID is a unique id generated by the server on successful creation of a resource and is not
            allowed to change on PUT operations.
            More info: http://kubernetes.io/docs/user-guide/identifiers#uids

        The **status** object supports the following:

          * `conditions` (`pulumi.Input[list]`)
            * `message` (`pulumi.Input[str]`)
            * `reason` (`pulumi.Input[str]`)
            * `status` (`pulumi.Input[str]`)
            * `type` (`pulumi.Input[str]`)

          * `latestCreatedRevisionName` (`pulumi.Input[str]`)
          * `latestReadyRevisionName` (`pulumi.Input[str]`)
          * `observedGeneration` (`pulumi.Input[float]`)
          * `url` (`pulumi.Input[str]`)

        The **template** object supports the following:

          * `metadata` (`pulumi.Input[dict]`) - Metadata associated with this Service, including name, namespace, labels,
            and annotations.  Structure is documented below.
            * `annotations` (`pulumi.Input[dict]`) - Annotations is a key value map stored with a resource that
              may be set by external tools to store and retrieve arbitrary metadata. More
              info: http://kubernetes.io/docs/user-guide/annotations
            * `generation` (`pulumi.Input[float]`) - -
              A sequence number representing a specific generation of the desired state.
            * `labels` (`pulumi.Input[dict]`) - Map of string keys and values that can be used to organize and categorize
              (scope and select) objects. May match selectors of replication controllers
              and routes.
              More info: http://kubernetes.io/docs/user-guide/labels
            * `name` (`pulumi.Input[str]`) - Name of the environment variable.
            * `namespace` (`pulumi.Input[str]`) - In Cloud Run the namespace must be equal to either the
              project ID or project number.
            * `resourceVersion` (`pulumi.Input[str]`) - -
              An opaque value that represents the internal version of this object that
              can be used by clients to determine when objects have changed. May be used
              for optimistic concurrency, change detection, and the watch operation on a
              resource or set of resources. They may only be valid for a
              particular resource or set of resources.
              More info:
              https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
            * `self_link` (`pulumi.Input[str]`) - -
              SelfLink is a URL representing this object.
            * `uid` (`pulumi.Input[str]`) - -
              UID is a unique id generated by the server on successful creation of a resource and is not
              allowed to change on PUT operations.
              More info: http://kubernetes.io/docs/user-guide/identifiers#uids

          * `spec` (`pulumi.Input[dict]`) - RevisionSpec holds the desired state of the Revision (from the client).  Structure is documented below.
            * `containerConcurrency` (`pulumi.Input[float]`) - ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
              requests per container of the Revision. Values are:
              - `0` thread-safe, the system should manage the max concurrency. This is
              the default value.
              - `1` not-thread-safe. Single concurrency
              - `2-N` thread-safe, max concurrency of N
            * `containers` (`pulumi.Input[list]`) - Container defines the unit of execution for this Revision.
              In the context of a Revision, we disallow a number of the fields of
              this Container, including: name, ports, and volumeMounts.
              The runtime contract is documented here:
              https://github.com/knative/serving/blob/master/docs/runtime-contract.md  Structure is documented below.
              * `args` (`pulumi.Input[list]`) - Arguments to the entrypoint.
                The docker image's CMD is used if this is not provided.
                Variable references $(VAR_NAME) are expanded using the container's
                environment. If a variable cannot be resolved, the reference in the input
                string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
                double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
                regardless of whether the variable exists or not.
                More info:
                https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
              * `commands` (`pulumi.Input[list]`) - Entrypoint array. Not executed within a shell.
                The docker image's ENTRYPOINT is used if this is not provided.
                Variable references $(VAR_NAME) are expanded using the container's
                environment. If a variable cannot be resolved, the reference in the input
                string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
                double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
                regardless of whether the variable exists or not.
                More info:
                https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
              * `envFroms` (`pulumi.Input[list]`) - -
                (Optional, Deprecated)
                List of sources to populate environment variables in the container.
                All invalid keys will be reported as an event when the container is starting.
                When a key exists in multiple sources, the value associated with the last source will
                take precedence. Values defined by an Env with a duplicate key will take
                precedence.  Structure is documented below.
                * `configMapRef` (`pulumi.Input[dict]`) - The ConfigMap to select from.  Structure is documented below.
                  * `localObjectReference` (`pulumi.Input[dict]`) - The Secret to select from.  Structure is documented below.
                    * `name` (`pulumi.Input[str]`) - Name of the environment variable.

                  * `optional` (`pulumi.Input[bool]`) - Specify whether the Secret must be defined

                * `prefix` (`pulumi.Input[str]`) - An optional identifier to prepend to each key in the ConfigMap.
                * `secretRef` (`pulumi.Input[dict]`) - The Secret to select from.  Structure is documented below.
                  * `localObjectReference` (`pulumi.Input[dict]`) - The Secret to select from.  Structure is documented below.
                    * `name` (`pulumi.Input[str]`) - Name of the environment variable.

                  * `optional` (`pulumi.Input[bool]`) - Specify whether the Secret must be defined

              * `envs` (`pulumi.Input[list]`) - List of environment variables to set in the container.  Structure is documented below.
                * `name` (`pulumi.Input[str]`) - Name of the environment variable.
                * `value` (`pulumi.Input[str]`) - Variable references $(VAR_NAME) are expanded
                  using the previous defined environment variables in the container and
                  any route environment variables. If a variable cannot be resolved,
                  the reference in the input string will be unchanged. The $(VAR_NAME)
                  syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
                  references will never be expanded, regardless of whether the variable
                  exists or not.
                  Defaults to "".

              * `image` (`pulumi.Input[str]`) - Docker image name. This is most often a reference to a container located
                in the container registry, such as gcr.io/cloudrun/hello
                More info: https://kubernetes.io/docs/concepts/containers/images
              * `resources` (`pulumi.Input[dict]`) - Compute Resources required by this container. Used to set values such as max memory
                More info:
                https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources  Structure is documented below.
                * `limits` (`pulumi.Input[dict]`) - Limits describes the maximum amount of compute resources allowed.
                  The values of the map is string form of the 'quantity' k8s type:
                  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
                * `requests` (`pulumi.Input[dict]`) - Requests describes the minimum amount of compute resources required.
                  If Requests is omitted for a container, it defaults to Limits if that is
                  explicitly specified, otherwise to an implementation-defined value.
                  The values of the map is string form of the 'quantity' k8s type:
                  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go

              * `workingDir` (`pulumi.Input[str]`) - -
                (Optional, Deprecated)
                Container's working directory.
                If not specified, the container runtime's default will be used, which
                might be configured in the container image.

            * `service_account_name` (`pulumi.Input[str]`) - Email address of the IAM service account associated with the revision of the
              service. The service account represents the identity of the running revision,
              and determines what permissions the revision has. If not provided, the revision
              will use the project's default service account.
            * `servingState` (`pulumi.Input[str]`) - -
              ServingState holds a value describing the state the resources
              are in for this Revision.
              It is expected
              that the system will manipulate this based on routability and load.

        The **traffics** object supports the following:

          * `latestRevision` (`pulumi.Input[bool]`) - LatestRevision may be optionally provided to indicate that the latest ready
            Revision of the Configuration should be used for this traffic target. When
            provided LatestRevision must be true if RevisionName is empty; it must be
            false when RevisionName is non-empty.
          * `percent` (`pulumi.Input[float]`) - Percent specifies percent of the traffic to this Revision or Configuration.
          * `revisionName` (`pulumi.Input[str]`) - RevisionName of a specific revision to which to send this portion of traffic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["autogenerate_revision_name"] = autogenerate_revision_name
        __props__["location"] = location
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["project"] = project
        __props__["status"] = status
        __props__["template"] = template
        __props__["traffics"] = traffics
        return Service(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

