# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class MachineImage(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    A text description of the resource.
    """
    name: pulumi.Output[str]
    """
    Name of the resource.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    source_instance: pulumi.Output[str]
    """
    The source instance used to create the machine image. You can provide this as a partial or full URL to the resource.
    """
    def __init__(__self__, resource_name, opts=None, description=None, name=None, project=None, source_instance=None, __props__=None, __name__=None, __opts__=None):
        """
        Represents a MachineImage resource. Machine images store all the configuration,
        metadata, permissions, and data from one or more disks required to create a
        Virtual machine (VM) instance.

        To get more information about MachineImage, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/machineImages)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/machine-images)

        ## Example Usage - Machine Image Basic


        ```python
        import pulumi
        import pulumi_gcp as gcp

        vm = gcp.compute.Instance("vm",
            machine_type="n1-standard-1",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-9",
                },
            },
            network_interface=[{
                "network": "default",
            }])
        image = gcp.compute.MachineImage("image", source_instance=vm.self_link)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A text description of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] source_instance: The source instance used to create the machine image. You can provide this as a partial or full URL to the resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['name'] = name
            __props__['project'] = project
            if source_instance is None:
                raise TypeError("Missing required property 'source_instance'")
            __props__['source_instance'] = source_instance
            __props__['self_link'] = None
        super(MachineImage, __self__).__init__(
            'gcp:compute/machineImage:MachineImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, name=None, project=None, self_link=None, source_instance=None):
        """
        Get an existing MachineImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A text description of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] source_instance: The source instance used to create the machine image. You can provide this as a partial or full URL to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["name"] = name
        __props__["project"] = project
        __props__["self_link"] = self_link
        __props__["source_instance"] = source_instance
        return MachineImage(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

