# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class RegionHealthCheck(pulumi.CustomResource):
    check_interval_sec: pulumi.Output[float]
    """
    How often (in seconds) to send a health check. The default value is 5
    seconds.
    """
    creation_timestamp: pulumi.Output[str]
    """
    Creation timestamp in RFC3339 text format.
    """
    description: pulumi.Output[str]
    """
    An optional description of this resource. Provide this property when
    you create the resource.
    """
    healthy_threshold: pulumi.Output[float]
    """
    A so-far unhealthy instance will be marked healthy after this many
    consecutive successes. The default value is 2.
    """
    http2_health_check: pulumi.Output[dict]
    """
    A nested object resource  Structure is documented below.

      * `host` (`str`) - The value of the host header in the HTTP2 health check request.
        If left empty (default value), the public IP on behalf of which this health
        check is performed will be used.
      * `port` (`float`) - The TCP port number for the HTTP2 health check request.
        The default value is 443.
      * `port_name` (`str`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
        port_name are defined, port takes precedence.
      * `portSpecification` (`str`) - Specifies how port is selected for health checking, can be one of the
        following values:
        * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
        * `USE_NAMED_PORT`: The `portName` is used for health checking.
        * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
        network endpoint is used for health checking. For other backends, the
        port or named port specified in the Backend Service is used for health
        checking.
        If not specified, HTTP2 health check follows behavior specified in `port` and
        `portName` fields.
      * `proxy_header` (`str`) - Specifies the type of proxy header to append before sending data to the
        backend.
      * `request_path` (`str`) - The request path of the HTTP2 health check request.
        The default value is /.
      * `response` (`str`) - The bytes to match against the beginning of the response data. If left empty
        (the default value), any response will indicate health. The response data
        can only be ASCII.
    """
    http_health_check: pulumi.Output[dict]
    """
    A nested object resource  Structure is documented below.

      * `host` (`str`) - The value of the host header in the HTTP2 health check request.
        If left empty (default value), the public IP on behalf of which this health
        check is performed will be used.
      * `port` (`float`) - The TCP port number for the HTTP2 health check request.
        The default value is 443.
      * `port_name` (`str`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
        port_name are defined, port takes precedence.
      * `portSpecification` (`str`) - Specifies how port is selected for health checking, can be one of the
        following values:
        * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
        * `USE_NAMED_PORT`: The `portName` is used for health checking.
        * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
        network endpoint is used for health checking. For other backends, the
        port or named port specified in the Backend Service is used for health
        checking.
        If not specified, HTTP2 health check follows behavior specified in `port` and
        `portName` fields.
      * `proxy_header` (`str`) - Specifies the type of proxy header to append before sending data to the
        backend.
      * `request_path` (`str`) - The request path of the HTTP2 health check request.
        The default value is /.
      * `response` (`str`) - The bytes to match against the beginning of the response data. If left empty
        (the default value), any response will indicate health. The response data
        can only be ASCII.
    """
    https_health_check: pulumi.Output[dict]
    """
    A nested object resource  Structure is documented below.

      * `host` (`str`) - The value of the host header in the HTTP2 health check request.
        If left empty (default value), the public IP on behalf of which this health
        check is performed will be used.
      * `port` (`float`) - The TCP port number for the HTTP2 health check request.
        The default value is 443.
      * `port_name` (`str`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
        port_name are defined, port takes precedence.
      * `portSpecification` (`str`) - Specifies how port is selected for health checking, can be one of the
        following values:
        * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
        * `USE_NAMED_PORT`: The `portName` is used for health checking.
        * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
        network endpoint is used for health checking. For other backends, the
        port or named port specified in the Backend Service is used for health
        checking.
        If not specified, HTTP2 health check follows behavior specified in `port` and
        `portName` fields.
      * `proxy_header` (`str`) - Specifies the type of proxy header to append before sending data to the
        backend.
      * `request_path` (`str`) - The request path of the HTTP2 health check request.
        The default value is /.
      * `response` (`str`) - The bytes to match against the beginning of the response data. If left empty
        (the default value), any response will indicate health. The response data
        can only be ASCII.
    """
    log_config: pulumi.Output[dict]
    """
    Configure logging on this health check.  Structure is documented below.

      * `enable` (`bool`) - Indicates whether or not to export logs. This is false by default,
        which means no health check logging will be done.
    """
    name: pulumi.Output[str]
    """
    Name of the resource. Provided by the client when the resource is
    created. The name must be 1-63 characters long, and comply with
    RFC1035.  Specifically, the name must be 1-63 characters long and
    match the regular expression `a-z?` which means
    the first character must be a lowercase letter, and all following
    characters must be a dash, lowercase letter, or digit, except the
    last character, which cannot be a dash.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    region: pulumi.Output[str]
    """
    The Region in which the created health check should reside.
    If it is not provided, the provider region is used.
    """
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    ssl_health_check: pulumi.Output[dict]
    """
    A nested object resource  Structure is documented below.

      * `port` (`float`) - The TCP port number for the HTTP2 health check request.
        The default value is 443.
      * `port_name` (`str`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
        port_name are defined, port takes precedence.
      * `portSpecification` (`str`) - Specifies how port is selected for health checking, can be one of the
        following values:
        * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
        * `USE_NAMED_PORT`: The `portName` is used for health checking.
        * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
        network endpoint is used for health checking. For other backends, the
        port or named port specified in the Backend Service is used for health
        checking.
        If not specified, HTTP2 health check follows behavior specified in `port` and
        `portName` fields.
      * `proxy_header` (`str`) - Specifies the type of proxy header to append before sending data to the
        backend.
      * `request` (`str`) - The application data to send once the SSL connection has been
        established (default value is empty). If both request and response are
        empty, the connection establishment alone will indicate health. The request
        data can only be ASCII.
      * `response` (`str`) - The bytes to match against the beginning of the response data. If left empty
        (the default value), any response will indicate health. The response data
        can only be ASCII.
    """
    tcp_health_check: pulumi.Output[dict]
    """
    A nested object resource  Structure is documented below.

      * `port` (`float`) - The TCP port number for the HTTP2 health check request.
        The default value is 443.
      * `port_name` (`str`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
        port_name are defined, port takes precedence.
      * `portSpecification` (`str`) - Specifies how port is selected for health checking, can be one of the
        following values:
        * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
        * `USE_NAMED_PORT`: The `portName` is used for health checking.
        * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
        network endpoint is used for health checking. For other backends, the
        port or named port specified in the Backend Service is used for health
        checking.
        If not specified, HTTP2 health check follows behavior specified in `port` and
        `portName` fields.
      * `proxy_header` (`str`) - Specifies the type of proxy header to append before sending data to the
        backend.
      * `request` (`str`) - The application data to send once the SSL connection has been
        established (default value is empty). If both request and response are
        empty, the connection establishment alone will indicate health. The request
        data can only be ASCII.
      * `response` (`str`) - The bytes to match against the beginning of the response data. If left empty
        (the default value), any response will indicate health. The response data
        can only be ASCII.
    """
    timeout_sec: pulumi.Output[float]
    """
    How long (in seconds) to wait before claiming failure.
    The default value is 5 seconds.  It is invalid for timeoutSec to have
    greater value than checkIntervalSec.
    """
    type: pulumi.Output[str]
    """
    The type of the health check. One of HTTP, HTTP2, HTTPS, TCP, or SSL.
    """
    unhealthy_threshold: pulumi.Output[float]
    """
    A so-far healthy instance will be marked unhealthy after this many
    consecutive failures. The default value is 2.
    """
    def __init__(__self__, resource_name, opts=None, check_interval_sec=None, description=None, healthy_threshold=None, http2_health_check=None, http_health_check=None, https_health_check=None, log_config=None, name=None, project=None, region=None, ssl_health_check=None, tcp_health_check=None, timeout_sec=None, unhealthy_threshold=None, __props__=None, __name__=None, __opts__=None):
        """
        Health Checks determine whether instances are responsive and able to do work.
        They are an important part of a comprehensive load balancing configuration,
        as they enable monitoring instances behind load balancers.

        Health Checks poll instances at a specified interval. Instances that
        do not respond successfully to some number of probes in a row are marked
        as unhealthy. No new connections are sent to unhealthy instances,
        though existing connections will continue. The health check will
        continue to poll unhealthy instances. If an instance later responds
        successfully to some number of consecutive probes, it is marked
        healthy again and can receive new connections.


        To get more information about RegionHealthCheck, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/regionHealthChecks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/load-balancing/docs/health-checks)

        ## Example Usage - Region Health Check Tcp


        ```python
        import pulumi
        import pulumi_gcp as gcp

        tcp_region_health_check = gcp.compute.RegionHealthCheck("tcp-region-health-check",
            check_interval_sec=1,
            tcp_health_check={
                "port": "80",
            },
            timeout_sec=1)
        ```
        ## Example Usage - Region Health Check Tcp Full


        ```python
        import pulumi
        import pulumi_gcp as gcp

        tcp_region_health_check = gcp.compute.RegionHealthCheck("tcp-region-health-check",
            check_interval_sec=1,
            description="Health check via tcp",
            healthy_threshold=4,
            tcp_health_check={
                "port_name": "health-check-port",
                "portSpecification": "USE_NAMED_PORT",
                "proxy_header": "NONE",
                "request": "ARE YOU HEALTHY?",
                "response": "I AM HEALTHY",
            },
            timeout_sec=1,
            unhealthy_threshold=5)
        ```
        ## Example Usage - Region Health Check Ssl


        ```python
        import pulumi
        import pulumi_gcp as gcp

        ssl_region_health_check = gcp.compute.RegionHealthCheck("ssl-region-health-check",
            check_interval_sec=1,
            ssl_health_check={
                "port": "443",
            },
            timeout_sec=1)
        ```
        ## Example Usage - Region Health Check Ssl Full


        ```python
        import pulumi
        import pulumi_gcp as gcp

        ssl_region_health_check = gcp.compute.RegionHealthCheck("ssl-region-health-check",
            check_interval_sec=1,
            description="Health check via ssl",
            healthy_threshold=4,
            ssl_health_check={
                "port_name": "health-check-port",
                "portSpecification": "USE_NAMED_PORT",
                "proxy_header": "NONE",
                "request": "ARE YOU HEALTHY?",
                "response": "I AM HEALTHY",
            },
            timeout_sec=1,
            unhealthy_threshold=5)
        ```
        ## Example Usage - Region Health Check Http


        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            check_interval_sec=1,
            http_health_check={
                "port": "80",
            },
            timeout_sec=1)
        ```
        ## Example Usage - Region Health Check Http Logs


        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            timeout_sec=1,
            check_interval_sec=1,
            http_health_check={
                "port": "80",
            },
            log_config={
                "enable": True,
            })
        ```
        ## Example Usage - Region Health Check Http Full


        ```python
        import pulumi
        import pulumi_gcp as gcp

        http_region_health_check = gcp.compute.RegionHealthCheck("http-region-health-check",
            check_interval_sec=1,
            description="Health check via http",
            healthy_threshold=4,
            http_health_check={
                "host": "1.2.3.4",
                "port_name": "health-check-port",
                "portSpecification": "USE_NAMED_PORT",
                "proxy_header": "NONE",
                "request_path": "/mypath",
                "response": "I AM HEALTHY",
            },
            timeout_sec=1,
            unhealthy_threshold=5)
        ```
        ## Example Usage - Region Health Check Https


        ```python
        import pulumi
        import pulumi_gcp as gcp

        https_region_health_check = gcp.compute.RegionHealthCheck("https-region-health-check",
            check_interval_sec=1,
            https_health_check={
                "port": "443",
            },
            timeout_sec=1)
        ```
        ## Example Usage - Region Health Check Https Full


        ```python
        import pulumi
        import pulumi_gcp as gcp

        https_region_health_check = gcp.compute.RegionHealthCheck("https-region-health-check",
            check_interval_sec=1,
            description="Health check via https",
            healthy_threshold=4,
            https_health_check={
                "host": "1.2.3.4",
                "port_name": "health-check-port",
                "portSpecification": "USE_NAMED_PORT",
                "proxy_header": "NONE",
                "request_path": "/mypath",
                "response": "I AM HEALTHY",
            },
            timeout_sec=1,
            unhealthy_threshold=5)
        ```
        ## Example Usage - Region Health Check Http2


        ```python
        import pulumi
        import pulumi_gcp as gcp

        http2_region_health_check = gcp.compute.RegionHealthCheck("http2-region-health-check",
            check_interval_sec=1,
            http2_health_check={
                "port": "443",
            },
            timeout_sec=1)
        ```
        ## Example Usage - Region Health Check Http2 Full


        ```python
        import pulumi
        import pulumi_gcp as gcp

        http2_region_health_check = gcp.compute.RegionHealthCheck("http2-region-health-check",
            check_interval_sec=1,
            description="Health check via http2",
            healthy_threshold=4,
            http2_health_check={
                "host": "1.2.3.4",
                "port_name": "health-check-port",
                "portSpecification": "USE_NAMED_PORT",
                "proxy_header": "NONE",
                "request_path": "/mypath",
                "response": "I AM HEALTHY",
            },
            timeout_sec=1,
            unhealthy_threshold=5)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] check_interval_sec: How often (in seconds) to send a health check. The default value is 5
               seconds.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[float] healthy_threshold: A so-far unhealthy instance will be marked healthy after this many
               consecutive successes. The default value is 2.
        :param pulumi.Input[dict] http2_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] http_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] https_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] log_config: Configure logging on this health check.  Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The Region in which the created health check should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[dict] ssl_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] tcp_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[float] timeout_sec: How long (in seconds) to wait before claiming failure.
               The default value is 5 seconds.  It is invalid for timeoutSec to have
               greater value than checkIntervalSec.
        :param pulumi.Input[float] unhealthy_threshold: A so-far healthy instance will be marked unhealthy after this many
               consecutive failures. The default value is 2.

        The **http2_health_check** object supports the following:

          * `host` (`pulumi.Input[str]`) - The value of the host header in the HTTP2 health check request.
            If left empty (default value), the public IP on behalf of which this health
            check is performed will be used.
          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request_path` (`pulumi.Input[str]`) - The request path of the HTTP2 health check request.
            The default value is /.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **http_health_check** object supports the following:

          * `host` (`pulumi.Input[str]`) - The value of the host header in the HTTP2 health check request.
            If left empty (default value), the public IP on behalf of which this health
            check is performed will be used.
          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request_path` (`pulumi.Input[str]`) - The request path of the HTTP2 health check request.
            The default value is /.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **https_health_check** object supports the following:

          * `host` (`pulumi.Input[str]`) - The value of the host header in the HTTP2 health check request.
            If left empty (default value), the public IP on behalf of which this health
            check is performed will be used.
          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request_path` (`pulumi.Input[str]`) - The request path of the HTTP2 health check request.
            The default value is /.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **log_config** object supports the following:

          * `enable` (`pulumi.Input[bool]`) - Indicates whether or not to export logs. This is false by default,
            which means no health check logging will be done.

        The **ssl_health_check** object supports the following:

          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request` (`pulumi.Input[str]`) - The application data to send once the SSL connection has been
            established (default value is empty). If both request and response are
            empty, the connection establishment alone will indicate health. The request
            data can only be ASCII.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **tcp_health_check** object supports the following:

          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request` (`pulumi.Input[str]`) - The application data to send once the SSL connection has been
            established (default value is empty). If both request and response are
            empty, the connection establishment alone will indicate health. The request
            data can only be ASCII.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['check_interval_sec'] = check_interval_sec
            __props__['description'] = description
            __props__['healthy_threshold'] = healthy_threshold
            __props__['http2_health_check'] = http2_health_check
            __props__['http_health_check'] = http_health_check
            __props__['https_health_check'] = https_health_check
            __props__['log_config'] = log_config
            __props__['name'] = name
            __props__['project'] = project
            __props__['region'] = region
            __props__['ssl_health_check'] = ssl_health_check
            __props__['tcp_health_check'] = tcp_health_check
            __props__['timeout_sec'] = timeout_sec
            __props__['unhealthy_threshold'] = unhealthy_threshold
            __props__['creation_timestamp'] = None
            __props__['self_link'] = None
            __props__['type'] = None
        super(RegionHealthCheck, __self__).__init__(
            'gcp:compute/regionHealthCheck:RegionHealthCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, check_interval_sec=None, creation_timestamp=None, description=None, healthy_threshold=None, http2_health_check=None, http_health_check=None, https_health_check=None, log_config=None, name=None, project=None, region=None, self_link=None, ssl_health_check=None, tcp_health_check=None, timeout_sec=None, type=None, unhealthy_threshold=None):
        """
        Get an existing RegionHealthCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] check_interval_sec: How often (in seconds) to send a health check. The default value is 5
               seconds.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[float] healthy_threshold: A so-far unhealthy instance will be marked healthy after this many
               consecutive successes. The default value is 2.
        :param pulumi.Input[dict] http2_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] http_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] https_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] log_config: Configure logging on this health check.  Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The Region in which the created health check should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[dict] ssl_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[dict] tcp_health_check: A nested object resource  Structure is documented below.
        :param pulumi.Input[float] timeout_sec: How long (in seconds) to wait before claiming failure.
               The default value is 5 seconds.  It is invalid for timeoutSec to have
               greater value than checkIntervalSec.
        :param pulumi.Input[str] type: The type of the health check. One of HTTP, HTTP2, HTTPS, TCP, or SSL.
        :param pulumi.Input[float] unhealthy_threshold: A so-far healthy instance will be marked unhealthy after this many
               consecutive failures. The default value is 2.

        The **http2_health_check** object supports the following:

          * `host` (`pulumi.Input[str]`) - The value of the host header in the HTTP2 health check request.
            If left empty (default value), the public IP on behalf of which this health
            check is performed will be used.
          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request_path` (`pulumi.Input[str]`) - The request path of the HTTP2 health check request.
            The default value is /.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **http_health_check** object supports the following:

          * `host` (`pulumi.Input[str]`) - The value of the host header in the HTTP2 health check request.
            If left empty (default value), the public IP on behalf of which this health
            check is performed will be used.
          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request_path` (`pulumi.Input[str]`) - The request path of the HTTP2 health check request.
            The default value is /.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **https_health_check** object supports the following:

          * `host` (`pulumi.Input[str]`) - The value of the host header in the HTTP2 health check request.
            If left empty (default value), the public IP on behalf of which this health
            check is performed will be used.
          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request_path` (`pulumi.Input[str]`) - The request path of the HTTP2 health check request.
            The default value is /.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **log_config** object supports the following:

          * `enable` (`pulumi.Input[bool]`) - Indicates whether or not to export logs. This is false by default,
            which means no health check logging will be done.

        The **ssl_health_check** object supports the following:

          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request` (`pulumi.Input[str]`) - The application data to send once the SSL connection has been
            established (default value is empty). If both request and response are
            empty, the connection establishment alone will indicate health. The request
            data can only be ASCII.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.

        The **tcp_health_check** object supports the following:

          * `port` (`pulumi.Input[float]`) - The TCP port number for the HTTP2 health check request.
            The default value is 443.
          * `port_name` (`pulumi.Input[str]`) - Port name as defined in InstanceGroup#NamedPort#name. If both port and
            port_name are defined, port takes precedence.
          * `portSpecification` (`pulumi.Input[str]`) - Specifies how port is selected for health checking, can be one of the
            following values:
            * `USE_FIXED_PORT`: The port number in `port` is used for health checking.
            * `USE_NAMED_PORT`: The `portName` is used for health checking.
            * `USE_SERVING_PORT`: For NetworkEndpointGroup, the port specified for each
            network endpoint is used for health checking. For other backends, the
            port or named port specified in the Backend Service is used for health
            checking.
            If not specified, HTTP2 health check follows behavior specified in `port` and
            `portName` fields.
          * `proxy_header` (`pulumi.Input[str]`) - Specifies the type of proxy header to append before sending data to the
            backend.
          * `request` (`pulumi.Input[str]`) - The application data to send once the SSL connection has been
            established (default value is empty). If both request and response are
            empty, the connection establishment alone will indicate health. The request
            data can only be ASCII.
          * `response` (`pulumi.Input[str]`) - The bytes to match against the beginning of the response data. If left empty
            (the default value), any response will indicate health. The response data
            can only be ASCII.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["check_interval_sec"] = check_interval_sec
        __props__["creation_timestamp"] = creation_timestamp
        __props__["description"] = description
        __props__["healthy_threshold"] = healthy_threshold
        __props__["http2_health_check"] = http2_health_check
        __props__["http_health_check"] = http_health_check
        __props__["https_health_check"] = https_health_check
        __props__["log_config"] = log_config
        __props__["name"] = name
        __props__["project"] = project
        __props__["region"] = region
        __props__["self_link"] = self_link
        __props__["ssl_health_check"] = ssl_health_check
        __props__["tcp_health_check"] = tcp_health_check
        __props__["timeout_sec"] = timeout_sec
        __props__["type"] = type
        __props__["unhealthy_threshold"] = unhealthy_threshold
        return RegionHealthCheck(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

