# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_yunohost_integration',
 'django_yunohost_integration.management',
 'django_yunohost_integration.management.commands',
 'django_yunohost_integration.sso_auth']

package_data = \
{'': ['*']}

install_requires = \
['django', 'django-tools>=0.54.0rc1']

extras_require = \
{'ynh': ['gunicorn', 'psycopg2', 'django-redis', 'django-axes']}

entry_points = \
{'console_scripts': ['devshell = '
                     'django_yunohost_integration.dev_shell:devshell_cmdloop']}

setup_kwargs = {
    'name': 'django-yunohost-integration',
    'version': '0.4.0rc4',
    'description': 'Glue code to package django projects as yunohost apps.',
    'long_description': '# django_yunohost_integration\n\n[![pytest](https://github.com/YunoHost-Apps/django_yunohost_integration/actions/workflows/pytest.yml/badge.svg?branch=main)](https://github.com/YunoHost-Apps/django_yunohost_integration/actions/workflows/pytest.yml) [![Coverage Status on codecov.io](https://codecov.io/gh/YunoHost-Apps/django_yunohost_integration/branch/main/graph/badge.svg)](https://codecov.io/gh/YunoHost-Apps/django_yunohost_integration)\n\n[![django_yunohost_integration @ PyPi](https://img.shields.io/pypi/v/django_yunohost_integration?label=django_yunohost_integration%20%40%20PyPi)](https://pypi.org/project/django_yunohost_integration/)\n[![Python Versions](https://img.shields.io/pypi/pyversions/django_yunohost_integration)](https://gitlab.com/YunoHost-Apps/django_yunohost_integration/-/blob/main/pyproject.toml)\n[![License GPL](https://img.shields.io/pypi/l/django_yunohost_integration)](https://gitlab.com/YunoHost-Apps/django_yunohost_integration/-/blob/main/LICENSE)\n\n\nPython package [django_yunohost_integration](https://pypi.org/project/django_yunohost_integration/) with helpers for integrate a Django project as YunoHost package.\n\nA example usage of this package is here:\n\n* https://github.com/YunoHost-Apps/django_example_ynh\n\nPull requests welcome ;)\n\n\nThese projects used `django_yunohost_integration`:\n\n* https://github.com/YunoHost-Apps/pyinventory_ynh\n* https://github.com/YunoHost-Apps/django-for-runners_ynh\n* https://github.com/YunoHost-Apps/django-fmd_ynh\n\n\n## Features\n\n* SSOwat integration (see below)\n* Helper to create first super user for `scripts/install`\n* Run Django development server with a local generated YunoHost package installation (called `local_test`)\n* Helper to run `pytest` against `local_test` "installation"\n\n\n### SSO authentication\n\n[SSOwat](https://github.com/YunoHost/SSOwat) is fully supported:\n\n* First user (`$YNH_APP_ARG_ADMIN`) will be created as Django\'s super user\n* All new users will be created as normal users\n* Login via SSO is fully supported\n* User Email, First / Last name will be updated from SSO data\n\n\n### usage\n\nTo create/update the first user in `install`/`upgrade`, e.g.:\n\n```bash\n./manage.py create_superuser --username="$admin" --email="$admin_mail"\n```\nThis Create/update Django superuser and set a unusable password.\nA password is not needed, because auth done via SSOwat ;)\n\nMain parts in `settings.py`:\n```python\nfrom pathlib import Path as __Path\n\nfrom django_yunohost_integration.base_settings import *  # noqa\nfrom django_yunohost_integration.secret_key import get_or_create_secret as __get_or_create_secret\n\n\nDEBUG = bool(int(\'__DEBUG_ENABLED__\'))  # Set via config_panel.toml\n\n# -----------------------------------------------------------------------------\n\nFINALPATH = __Path(\'__FINALPATH__\')  # /opt/yunohost/$app\nassert FINALPATH.is_dir(), f\'Directory not exists: {FINALPATH}\'\n\nPUBLIC_PATH = __Path(\'__PUBLIC_PATH__\')  # /var/www/$app\nassert PUBLIC_PATH.is_dir(), f\'Directory not exists: {PUBLIC_PATH}\'\n\nLOG_FILE = __Path(\'__LOG_FILE__\')  # /var/log/$app/$app.log\nassert LOG_FILE.is_file(), f\'File not exists: {LOG_FILE}\'\n\nPATH_URL = \'__PATH_URL__\'  # $YNH_APP_ARG_PATH\nPATH_URL = PATH_URL.strip(\'/\')\n\n# -----------------------------------------------------------------------------\n\n# Function that will be called to finalize a user profile:\nYNH_SETUP_USER = \'setup_user.setup_project_user\'\n\nSECRET_KEY = __get_or_create_secret(FINALPATH / \'secret.txt\')  # /opt/yunohost/$app/secret.txt\n\n# INSTALLED_APPS.append(\'<insert-your-app-here>\')\n\n# -----------------------------------------------------------------------------\n```\n\n\n## local test\n\n### Build prerequisites\n\nWe install `psycopg2` (a PostgreSQL adapter for the Python) that needs some build prerequisites, e.g.:\n\n```bash\n~$ sudo apt install build-essential python3-dev libpq-dev\n```\n\nFor quicker developing of django_yunohost_integration in the context of YunoHost app,\nit\'s possible to run the Django developer server with the settings\nand urls made for YunoHost installation.\n\ne.g.:\n```bash\n~$ git clone https://github.com/YunoHost-Apps/django_yunohost_integration.git\n~$ cd django_yunohost_integration/\n~/django_yunohost_integration$ ./devshell.py\n\n+ .venv/bin/python .venv/bin/devshell\n\n\n\nDeveloper shell - django_yunohost_integration - v0.2.0\n\n\nDocumented commands (use \'help -v\' for verbose/\'help <topic>\' for details):\n\ndev-shell commands\n==================\nfix_code_style  linting  list_venv_packages  publish  pytest  update\n\n\nDjango-YunoHost-Integration commands\n====================================\nlocal_test\n\nUncategorized\n=============\nalias  help     macro  run_pyscript  set    shortcuts\nedit   history  quit   run_script    shell\n\n\n(django_yunohost_integration)\n```\n\nFor quicker developing of django_yunohost_integration in the context of YunoHost app,\nit\'s possible to run the Django developer server with the settings\nand urls made for YunoHost installation.\n\ne.g.:\n```bash\n~/django_yunohost_integration$ ./devshell.py\n(django_yunohost_integration) local_test\n```\n\n* SQlite database will be used\n* A super user with username `test` and password `test` is created\n* The page is available under `http://127.0.0.1:8000/app_path/`\n\n\n## history\n\n* [**dev**](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.4.0rc4...main)\n  * tbc\n* [v0.4.0rc4 - 25.08.2022](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.3.0...v0.4.0rc4)\n  * Add `SyslogHandler` to logging settings\n  * rename replacements (but still support the old ones):\n    * `__FINAL_HOME_PATH__` -> `__FINALPATH__`\n    * `__FINAL_WWW_PATH__` -> `__PUBLIC_PATH__`\n  * Add system checks to verify all "EMAIL" in `settings` and `settings.LOG_LEVEL`\n  * Bugfix dev shell and exit if it\'s called as CLI\n* [v0.3.0 - 14.08.2022](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.2.5...v0.3.0)\n  * Add `extra_replacements:dict` argument to `create_local_test()` to pass own `__YNH_VARIABLE__` replacements\n  * Remove `pytest_helper.run_pytest()` because every project should used a own [conftest.py](https://github.com/YunoHost-Apps/django_yunohost_integration/blob/main/tests/conftest.py) with `create_local_test()` usage.\n* [v0.2.5 - 12.08.2022](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.2.4...v0.2.5)\n  * Support new variable names, for `ynh_add_config` usage in local test helper.\n  * Run tests with Python v3.10, too.\n  * Update project setup.\n* [v0.2.4 - 30.01.2022](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.2.3...v0.2.4)\n  * Rename git "master" branch to "main"\n  * Use darker and pytest-darker as code formatter + update requirements\n* [v0.2.3 - 07.01.2022](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.2.2...v0.2.3)\n  * Bugfix Fix local test by set `"SECURE_SSL_REDIRECT = False"`\n* [v0.2.2 - 10.10.2021](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.2.1...v0.2.2)\n  * Read YunoHost App Id from "manifest.json" and check root directory name\n* [v0.2.1 - 16.09.2021](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.2.0...v0.2.1)\n  * Bugfix endless redirect loop, by adding `SECURE_PROXY_SSL_HEADER` to settings\n* [v0.2.0 - 15.09.2021](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.1.5...v0.2.0)\n  * rename/split `django_ynh` into:\n    * [django_yunohost_integration](https://github.com/YunoHost-Apps/django_yunohost_integration) - Python package with the glue code to integrate a Django project with YunoHost\n    * [django_example_ynh](https://github.com/YunoHost-Apps/django_example_ynh) - Demo YunoHost App to demonstrate the integration of a Django project under YunoHost\n  * Replace `psycopg2-binary` with `psycopg2` (needs some prerequisites packages, see above)\n* [v0.1.5 - 19.01.2021](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.1.4...v0.1.5)\n  * Make some deps `gunicorn`, `psycopg2-binary`, `django-redis`, `django-axes` optional\n* [v0.1.4 - 08.01.2021](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.1.3...v0.1.4)\n  * Bugfix: CSRF verification failed on POST requests\n* [v0.1.3 - 08.01.2021](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.1.2...v0.1.3)\n  * set "DEBUG = True" in local_test (so static files are served and auth works)\n  * Bugfixes and cleanups\n* [v0.1.2 - 29.12.2020](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.1.1...v0.1.2)\n  * Bugfixes\n* [v0.1.1 - 29.12.2020](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/v0.1.0...v0.1.1)\n  * Refactor "create_superuser" to a manage command, useable via "django_yunohost_integration" in `INSTALLED_APPS`\n  * Generate "conf/requirements.txt" and use this file for install\n  * rename own settings and urls (in `/conf/`)\n* [v0.1.0 - 28.12.2020](https://github.com/YunoHost-Apps/django_yunohost_integration/compare/f578f14...v0.1.0)\n  * first working state\n* [23.12.2020](https://github.com/YunoHost-Apps/django_yunohost_integration/commit/f578f144a3a6d11d7044597c37d550d29c247773)\n  * init the project\n\n\n## Links\n\n* Report a bug about this package: https://github.com/YunoHost-Apps/django_yunohost_integration\n* YunoHost website: https://yunohost.org/\n* PyPi package: https://pypi.org/project/django_yunohost_integration/\n',
    'author': 'JensDiemer',
    'author_email': 'git@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/YunoHost-Apps/django_yunohost_integration',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0.0',
}


setup(**setup_kwargs)
