# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_visualization.ipynb.

# %% auto 0
__all__ = ['convert_image', 'show_image_row']

# %% ../nbs/00_visualization.ipynb 2
import matplotlib.pyplot as plt
from torch import Tensor

# %% ../nbs/00_visualization.ipynb 4
def convert_image(image):
    if isinstance(image, Tensor):
        if image.shape[0] in [1,3]:
            image=image.permute(1,2,0)
    return image

def show_image_row(fontsize=10, figsize=(20,8), **images):
    n_images = len(images)
    plt.figure(figsize=figsize)
    for idx, (name, image) in enumerate(images.items()):
        plt.subplot(1, n_images, idx + 1)
        plt.xticks([])
        plt.yticks([])
        plt.title(name.replace('_',' ').title(), fontsize=fontsize)
        plt.imshow(convert_image(image))
    plt.show()
