import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) The policy for the receipt filter.
 *
 * @experimental
 */
export declare enum ReceiptFilterPolicy {
    /**
     * (experimental) Allow the ip address or range.
     *
     * @experimental
     */
    ALLOW = "Allow",
    /**
     * (experimental) Block the ip address or range.
     *
     * @experimental
     */
    BLOCK = "Block"
}
/**
 * (experimental) Construction properties for a ReceiptFilter.
 *
 * @experimental
 */
export interface ReceiptFilterProps {
    /**
     * (experimental) The name for the receipt filter.
     *
     * @default a CloudFormation generated name
     * @experimental
     */
    readonly receiptFilterName?: string;
    /**
     * (experimental) The ip address or range to filter.
     *
     * @default 0.0.0.0/0
     * @experimental
     */
    readonly ip?: string;
    /**
     * (experimental) The policy for the filter.
     *
     * @default Block
     * @experimental
     */
    readonly policy?: ReceiptFilterPolicy;
}
/**
 * (experimental) A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @experimental
 */
export declare class ReceiptFilter extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ReceiptFilterProps);
}
/**
 * (experimental) Construction properties for a WhiteListReceiptFilter.
 *
 * @experimental
 */
export interface WhiteListReceiptFilterProps {
    /**
     * (experimental) A list of ip addresses or ranges to white list.
     *
     * @experimental
     */
    readonly ips: string[];
}
/**
 * (experimental) A white list receipt filter.
 *
 * @experimental
 */
export declare class WhiteListReceiptFilter extends CoreConstruct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: WhiteListReceiptFilterProps);
}
