(self["webpackChunkgosling_widget"] = self["webpackChunkgosling_widget"] || []).push([[589],{

/***/ 8718:
/***/ ((module) => {

"use strict";


var has = Object.prototype.hasOwnProperty
  , prefix = '~';

/**
 * Constructor to create a storage for our `EE` objects.
 * An `Events` instance is a plain object whose properties are event names.
 *
 * @constructor
 * @private
 */
function Events() {}

//
// We try to not inherit from `Object.prototype`. In some engines creating an
// instance in this way is faster than calling `Object.create(null)` directly.
// If `Object.create(null)` is not supported we prefix the event names with a
// character to make sure that the built-in object properties are not
// overridden or used as an attack vector.
//
if (Object.create) {
  Events.prototype = Object.create(null);

  //
  // This hack is needed because the `__proto__` property is still inherited in
  // some old browsers like Android 4, iPhone 5.1, Opera 11 and Safari 5.
  //
  if (!new Events().__proto__) prefix = false;
}

/**
 * Representation of a single event listener.
 *
 * @param {Function} fn The listener function.
 * @param {*} context The context to invoke the listener with.
 * @param {Boolean} [once=false] Specify if the listener is a one-time listener.
 * @constructor
 * @private
 */
function EE(fn, context, once) {
  this.fn = fn;
  this.context = context;
  this.once = once || false;
}

/**
 * Add a listener for a given event.
 *
 * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn The listener function.
 * @param {*} context The context to invoke the listener with.
 * @param {Boolean} once Specify if the listener is a one-time listener.
 * @returns {EventEmitter}
 * @private
 */
function addListener(emitter, event, fn, context, once) {
  if (typeof fn !== 'function') {
    throw new TypeError('The listener must be a function');
  }

  var listener = new EE(fn, context || emitter, once)
    , evt = prefix ? prefix + event : event;

  if (!emitter._events[evt]) emitter._events[evt] = listener, emitter._eventsCount++;
  else if (!emitter._events[evt].fn) emitter._events[evt].push(listener);
  else emitter._events[evt] = [emitter._events[evt], listener];

  return emitter;
}

/**
 * Clear event by name.
 *
 * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.
 * @param {(String|Symbol)} evt The Event name.
 * @private
 */
function clearEvent(emitter, evt) {
  if (--emitter._eventsCount === 0) emitter._events = new Events();
  else delete emitter._events[evt];
}

/**
 * Minimal `EventEmitter` interface that is molded against the Node.js
 * `EventEmitter` interface.
 *
 * @constructor
 * @public
 */
function EventEmitter() {
  this._events = new Events();
  this._eventsCount = 0;
}

/**
 * Return an array listing the events for which the emitter has registered
 * listeners.
 *
 * @returns {Array}
 * @public
 */
EventEmitter.prototype.eventNames = function eventNames() {
  var names = []
    , events
    , name;

  if (this._eventsCount === 0) return names;

  for (name in (events = this._events)) {
    if (has.call(events, name)) names.push(prefix ? name.slice(1) : name);
  }

  if (Object.getOwnPropertySymbols) {
    return names.concat(Object.getOwnPropertySymbols(events));
  }

  return names;
};

/**
 * Return the listeners registered for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @returns {Array} The registered listeners.
 * @public
 */
EventEmitter.prototype.listeners = function listeners(event) {
  var evt = prefix ? prefix + event : event
    , handlers = this._events[evt];

  if (!handlers) return [];
  if (handlers.fn) return [handlers.fn];

  for (var i = 0, l = handlers.length, ee = new Array(l); i < l; i++) {
    ee[i] = handlers[i].fn;
  }

  return ee;
};

/**
 * Return the number of listeners listening to a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @returns {Number} The number of listeners.
 * @public
 */
EventEmitter.prototype.listenerCount = function listenerCount(event) {
  var evt = prefix ? prefix + event : event
    , listeners = this._events[evt];

  if (!listeners) return 0;
  if (listeners.fn) return 1;
  return listeners.length;
};

/**
 * Calls each of the listeners registered for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @returns {Boolean} `true` if the event had listeners, else `false`.
 * @public
 */
EventEmitter.prototype.emit = function emit(event, a1, a2, a3, a4, a5) {
  var evt = prefix ? prefix + event : event;

  if (!this._events[evt]) return false;

  var listeners = this._events[evt]
    , len = arguments.length
    , args
    , i;

  if (listeners.fn) {
    if (listeners.once) this.removeListener(event, listeners.fn, undefined, true);

    switch (len) {
      case 1: return listeners.fn.call(listeners.context), true;
      case 2: return listeners.fn.call(listeners.context, a1), true;
      case 3: return listeners.fn.call(listeners.context, a1, a2), true;
      case 4: return listeners.fn.call(listeners.context, a1, a2, a3), true;
      case 5: return listeners.fn.call(listeners.context, a1, a2, a3, a4), true;
      case 6: return listeners.fn.call(listeners.context, a1, a2, a3, a4, a5), true;
    }

    for (i = 1, args = new Array(len -1); i < len; i++) {
      args[i - 1] = arguments[i];
    }

    listeners.fn.apply(listeners.context, args);
  } else {
    var length = listeners.length
      , j;

    for (i = 0; i < length; i++) {
      if (listeners[i].once) this.removeListener(event, listeners[i].fn, undefined, true);

      switch (len) {
        case 1: listeners[i].fn.call(listeners[i].context); break;
        case 2: listeners[i].fn.call(listeners[i].context, a1); break;
        case 3: listeners[i].fn.call(listeners[i].context, a1, a2); break;
        case 4: listeners[i].fn.call(listeners[i].context, a1, a2, a3); break;
        default:
          if (!args) for (j = 1, args = new Array(len -1); j < len; j++) {
            args[j - 1] = arguments[j];
          }

          listeners[i].fn.apply(listeners[i].context, args);
      }
    }
  }

  return true;
};

/**
 * Add a listener for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn The listener function.
 * @param {*} [context=this] The context to invoke the listener with.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.on = function on(event, fn, context) {
  return addListener(this, event, fn, context, false);
};

/**
 * Add a one-time listener for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn The listener function.
 * @param {*} [context=this] The context to invoke the listener with.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.once = function once(event, fn, context) {
  return addListener(this, event, fn, context, true);
};

/**
 * Remove the listeners of a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn Only remove the listeners that match this function.
 * @param {*} context Only remove the listeners that have this context.
 * @param {Boolean} once Only remove one-time listeners.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.removeListener = function removeListener(event, fn, context, once) {
  var evt = prefix ? prefix + event : event;

  if (!this._events[evt]) return this;
  if (!fn) {
    clearEvent(this, evt);
    return this;
  }

  var listeners = this._events[evt];

  if (listeners.fn) {
    if (
      listeners.fn === fn &&
      (!once || listeners.once) &&
      (!context || listeners.context === context)
    ) {
      clearEvent(this, evt);
    }
  } else {
    for (var i = 0, events = [], length = listeners.length; i < length; i++) {
      if (
        listeners[i].fn !== fn ||
        (once && !listeners[i].once) ||
        (context && listeners[i].context !== context)
      ) {
        events.push(listeners[i]);
      }
    }

    //
    // Reset the array, or remove it completely if we have no more listeners.
    //
    if (events.length) this._events[evt] = events.length === 1 ? events[0] : events;
    else clearEvent(this, evt);
  }

  return this;
};

/**
 * Remove all listeners, or those of the specified event.
 *
 * @param {(String|Symbol)} [event] The event name.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.removeAllListeners = function removeAllListeners(event) {
  var evt;

  if (event) {
    evt = prefix ? prefix + event : event;
    if (this._events[evt]) clearEvent(this, evt);
  } else {
    this._events = new Events();
    this._eventsCount = 0;
  }

  return this;
};

//
// Alias methods names because people roll like that.
//
EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
EventEmitter.prototype.addListener = EventEmitter.prototype.on;

//
// Expose the prefix.
//
EventEmitter.prefixed = prefix;

//
// Allow `EventEmitter` to be imported as module namespace.
//
EventEmitter.EventEmitter = EventEmitter;

//
// Expose the module.
//
if (true) {
  module.exports = EventEmitter;
}


/***/ }),

/***/ 9742:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}


/***/ }),

/***/ 8764:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



const base64 = __webpack_require__(9742)
const ieee754 = __webpack_require__(645)
const customInspectSymbol =
  (typeof Symbol === 'function' && typeof Symbol['for'] === 'function') // eslint-disable-line dot-notation
    ? Symbol['for']('nodejs.util.inspect.custom') // eslint-disable-line dot-notation
    : null

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

const K_MAX_LENGTH = 0x7fffffff
exports.kMaxLength = K_MAX_LENGTH

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport()

if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
    typeof console.error === 'function') {
  console.error(
    'This browser lacks typed array (Uint8Array) support which is required by ' +
    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
  )
}

function typedArraySupport () {
  // Can typed array instances can be augmented?
  try {
    const arr = new Uint8Array(1)
    const proto = { foo: function () { return 42 } }
    Object.setPrototypeOf(proto, Uint8Array.prototype)
    Object.setPrototypeOf(arr, proto)
    return arr.foo() === 42
  } catch (e) {
    return false
  }
}

Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.buffer
  }
})

Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.byteOffset
  }
})

function createBuffer (length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"')
  }
  // Return an augmented `Uint8Array` instance
  const buf = new Uint8Array(length)
  Object.setPrototypeOf(buf, Buffer.prototype)
  return buf
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      )
    }
    return allocUnsafe(arg)
  }
  return from(arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

function from (value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  if (ArrayBuffer.isView(value)) {
    return fromArrayView(value)
  }

  if (value == null) {
    throw new TypeError(
      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
      'or Array-like Object. Received type ' + (typeof value)
    )
  }

  if (isInstance(value, ArrayBuffer) ||
      (value && isInstance(value.buffer, ArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof SharedArrayBuffer !== 'undefined' &&
      (isInstance(value, SharedArrayBuffer) ||
      (value && isInstance(value.buffer, SharedArrayBuffer)))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'number') {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    )
  }

  const valueOf = value.valueOf && value.valueOf()
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length)
  }

  const b = fromObject(value)
  if (b) return b

  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
      typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(value[Symbol.toPrimitive]('string'), encodingOrOffset, length)
  }

  throw new TypeError(
    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
    'or Array-like Object. Received type ' + (typeof value)
  )
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length)
}

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype)
Object.setPrototypeOf(Buffer, Uint8Array)

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number')
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"')
  }
}

function alloc (size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpreted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(size).fill(fill, encoding)
      : createBuffer(size).fill(fill)
  }
  return createBuffer(size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding)
}

function allocUnsafe (size) {
  assertSize(size)
  return createBuffer(size < 0 ? 0 : checked(size) | 0)
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size)
}

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding)
  }

  const length = byteLength(string, encoding) | 0
  let buf = createBuffer(length)

  const actual = buf.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual)
  }

  return buf
}

function fromArrayLike (array) {
  const length = array.length < 0 ? 0 : checked(array.length) | 0
  const buf = createBuffer(length)
  for (let i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255
  }
  return buf
}

function fromArrayView (arrayView) {
  if (isInstance(arrayView, Uint8Array)) {
    const copy = new Uint8Array(arrayView)
    return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength)
  }
  return fromArrayLike(arrayView)
}

function fromArrayBuffer (array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds')
  }

  let buf
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array)
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset)
  } else {
    buf = new Uint8Array(array, byteOffset, length)
  }

  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(buf, Buffer.prototype)

  return buf
}

function fromObject (obj) {
  if (Buffer.isBuffer(obj)) {
    const len = checked(obj.length) | 0
    const buf = createBuffer(len)

    if (buf.length === 0) {
      return buf
    }

    obj.copy(buf, 0, 0, len)
    return buf
  }

  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0)
    }
    return fromArrayLike(obj)
  }

  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data)
  }
}

function checked (length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return b != null && b._isBuffer === true &&
    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
}

Buffer.compare = function compare (a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength)
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength)
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    )
  }

  if (a === b) return 0

  let x = a.length
  let y = b.length

  for (let i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  let i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  const buffer = Buffer.allocUnsafe(length)
  let pos = 0
  for (i = 0; i < list.length; ++i) {
    let buf = list[i]
    if (isInstance(buf, Uint8Array)) {
      if (pos + buf.length > buffer.length) {
        if (!Buffer.isBuffer(buf)) buf = Buffer.from(buf)
        buf.copy(buffer, pos)
      } else {
        Uint8Array.prototype.set.call(
          buffer,
          buf,
          pos
        )
      }
    } else if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    } else {
      buf.copy(buffer, pos)
    }
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
      'Received type ' + typeof string
    )
  }

  const len = string.length
  const mustMatch = (arguments.length > 2 && arguments[2] === true)
  if (!mustMatch && len === 0) return 0

  // Use a for loop to avoid recursion
  let loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
        }
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  let loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coercion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  const i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  const len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (let i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  const len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (let i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  const len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (let i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  const length = this.length
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.toLocaleString = Buffer.prototype.toString

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  let str = ''
  const max = exports.INSPECT_MAX_BYTES
  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim()
  if (this.length > max) str += ' ... '
  return '<Buffer ' + str + '>'
}
if (customInspectSymbol) {
  Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (isInstance(target, Uint8Array)) {
    target = Buffer.from(target, target.offset, target.byteLength)
  }
  if (!Buffer.isBuffer(target)) {
    throw new TypeError(
      'The "target" argument must be one of type Buffer or Uint8Array. ' +
      'Received type ' + (typeof target)
    )
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  let x = thisEnd - thisStart
  let y = end - start
  const len = Math.min(x, y)

  const thisCopy = this.slice(thisStart, thisEnd)
  const targetCopy = target.slice(start, end)

  for (let i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset // Coerce to Number.
  if (numberIsNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  let indexSize = 1
  let arrLength = arr.length
  let valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  let i
  if (dir) {
    let foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      let found = true
      for (let j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  const remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  const strLen = string.length

  if (length > strLen / 2) {
    length = strLen / 2
  }
  let i
  for (i = 0; i < length; ++i) {
    const parsed = parseInt(string.substr(i * 2, 2), 16)
    if (numberIsNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset >>> 0
    if (isFinite(length)) {
      length = length >>> 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  const remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  let loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
      case 'latin1':
      case 'binary':
        return asciiWrite(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  const res = []

  let i = start
  while (i < end) {
    const firstByte = buf[i]
    let codePoint = null
    let bytesPerSequence = (firstByte > 0xEF)
      ? 4
      : (firstByte > 0xDF)
          ? 3
          : (firstByte > 0xBF)
              ? 2
              : 1

    if (i + bytesPerSequence <= end) {
      let secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
const MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  const len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  let res = ''
  let i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  let ret = ''
  end = Math.min(buf.length, end)

  for (let i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  let ret = ''
  end = Math.min(buf.length, end)

  for (let i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  const len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  let out = ''
  for (let i = start; i < end; ++i) {
    out += hexSliceLookupTable[buf[i]]
  }
  return out
}

function utf16leSlice (buf, start, end) {
  const bytes = buf.slice(start, end)
  let res = ''
  // If bytes.length is odd, the last 8 bits must be ignored (same as node.js)
  for (let i = 0; i < bytes.length - 1; i += 2) {
    res += String.fromCharCode(bytes[i] + (bytes[i + 1] * 256))
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  const len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  const newBuf = this.subarray(start, end)
  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(newBuf, Buffer.prototype)

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUintLE =
Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  let val = this[offset]
  let mul = 1
  let i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUintBE =
Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  let val = this[offset + --byteLength]
  let mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUint8 =
Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUint16LE =
Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUint16BE =
Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUint32LE =
Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUint32BE =
Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readBigUInt64LE = defineBigIntMethod(function readBigUInt64LE (offset) {
  offset = offset >>> 0
  validateNumber(offset, 'offset')
  const first = this[offset]
  const last = this[offset + 7]
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8)
  }

  const lo = first +
    this[++offset] * 2 ** 8 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 24

  const hi = this[++offset] +
    this[++offset] * 2 ** 8 +
    this[++offset] * 2 ** 16 +
    last * 2 ** 24

  return BigInt(lo) + (BigInt(hi) << BigInt(32))
})

Buffer.prototype.readBigUInt64BE = defineBigIntMethod(function readBigUInt64BE (offset) {
  offset = offset >>> 0
  validateNumber(offset, 'offset')
  const first = this[offset]
  const last = this[offset + 7]
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8)
  }

  const hi = first * 2 ** 24 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    this[++offset]

  const lo = this[++offset] * 2 ** 24 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    last

  return (BigInt(hi) << BigInt(32)) + BigInt(lo)
})

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  let val = this[offset]
  let mul = 1
  let i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  let i = byteLength
  let mul = 1
  let val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  const val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  const val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readBigInt64LE = defineBigIntMethod(function readBigInt64LE (offset) {
  offset = offset >>> 0
  validateNumber(offset, 'offset')
  const first = this[offset]
  const last = this[offset + 7]
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8)
  }

  const val = this[offset + 4] +
    this[offset + 5] * 2 ** 8 +
    this[offset + 6] * 2 ** 16 +
    (last << 24) // Overflow

  return (BigInt(val) << BigInt(32)) +
    BigInt(first +
    this[++offset] * 2 ** 8 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 24)
})

Buffer.prototype.readBigInt64BE = defineBigIntMethod(function readBigInt64BE (offset) {
  offset = offset >>> 0
  validateNumber(offset, 'offset')
  const first = this[offset]
  const last = this[offset + 7]
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8)
  }

  const val = (first << 24) + // Overflow
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    this[++offset]

  return (BigInt(val) << BigInt(32)) +
    BigInt(this[++offset] * 2 ** 24 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    last)
})

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUintLE =
Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    const maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  let mul = 1
  let i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUintBE =
Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    const maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  let i = byteLength - 1
  let mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUint8 =
Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeUint16LE =
Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeUint16BE =
Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeUint32LE =
Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset + 3] = (value >>> 24)
  this[offset + 2] = (value >>> 16)
  this[offset + 1] = (value >>> 8)
  this[offset] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeUint32BE =
Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

function wrtBigUInt64LE (buf, value, offset, min, max) {
  checkIntBI(value, min, max, buf, offset, 7)

  let lo = Number(value & BigInt(0xffffffff))
  buf[offset++] = lo
  lo = lo >> 8
  buf[offset++] = lo
  lo = lo >> 8
  buf[offset++] = lo
  lo = lo >> 8
  buf[offset++] = lo
  let hi = Number(value >> BigInt(32) & BigInt(0xffffffff))
  buf[offset++] = hi
  hi = hi >> 8
  buf[offset++] = hi
  hi = hi >> 8
  buf[offset++] = hi
  hi = hi >> 8
  buf[offset++] = hi
  return offset
}

function wrtBigUInt64BE (buf, value, offset, min, max) {
  checkIntBI(value, min, max, buf, offset, 7)

  let lo = Number(value & BigInt(0xffffffff))
  buf[offset + 7] = lo
  lo = lo >> 8
  buf[offset + 6] = lo
  lo = lo >> 8
  buf[offset + 5] = lo
  lo = lo >> 8
  buf[offset + 4] = lo
  let hi = Number(value >> BigInt(32) & BigInt(0xffffffff))
  buf[offset + 3] = hi
  hi = hi >> 8
  buf[offset + 2] = hi
  hi = hi >> 8
  buf[offset + 1] = hi
  hi = hi >> 8
  buf[offset] = hi
  return offset + 8
}

Buffer.prototype.writeBigUInt64LE = defineBigIntMethod(function writeBigUInt64LE (value, offset = 0) {
  return wrtBigUInt64LE(this, value, offset, BigInt(0), BigInt('0xffffffffffffffff'))
})

Buffer.prototype.writeBigUInt64BE = defineBigIntMethod(function writeBigUInt64BE (value, offset = 0) {
  return wrtBigUInt64BE(this, value, offset, BigInt(0), BigInt('0xffffffffffffffff'))
})

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    const limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  let i = 0
  let mul = 1
  let sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    const limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  let i = byteLength - 1
  let mul = 1
  let sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  this[offset + 2] = (value >>> 16)
  this[offset + 3] = (value >>> 24)
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeBigInt64LE = defineBigIntMethod(function writeBigInt64LE (value, offset = 0) {
  return wrtBigUInt64LE(this, value, offset, -BigInt('0x8000000000000000'), BigInt('0x7fffffffffffffff'))
})

Buffer.prototype.writeBigInt64BE = defineBigIntMethod(function writeBigInt64BE (value, offset = 0) {
  return wrtBigUInt64BE(this, value, offset, -BigInt('0x8000000000000000'), BigInt('0x7fffffffffffffff'))
})

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer')
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('Index out of range')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  const len = end - start

  if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
    // Use built-in when available, missing from IE11
    this.copyWithin(targetStart, start, end)
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, end),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
    if (val.length === 1) {
      const code = val.charCodeAt(0)
      if ((encoding === 'utf8' && code < 128) ||
          encoding === 'latin1') {
        // Fast path: If `val` fits into a single byte, use that numeric value.
        val = code
      }
    }
  } else if (typeof val === 'number') {
    val = val & 255
  } else if (typeof val === 'boolean') {
    val = Number(val)
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  let i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    const bytes = Buffer.isBuffer(val)
      ? val
      : Buffer.from(val, encoding)
    const len = bytes.length
    if (len === 0) {
      throw new TypeError('The value "' + val +
        '" is invalid for argument "value"')
    }
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// CUSTOM ERRORS
// =============

// Simplified versions from Node, changed for Buffer-only usage
const errors = {}
function E (sym, getMessage, Base) {
  errors[sym] = class NodeError extends Base {
    constructor () {
      super()

      Object.defineProperty(this, 'message', {
        value: getMessage.apply(this, arguments),
        writable: true,
        configurable: true
      })

      // Add the error code to the name to include it in the stack trace.
      this.name = `${this.name} [${sym}]`
      // Access the stack to generate the error message including the error code
      // from the name.
      this.stack // eslint-disable-line no-unused-expressions
      // Reset the name to the actual name.
      delete this.name
    }

    get code () {
      return sym
    }

    set code (value) {
      Object.defineProperty(this, 'code', {
        configurable: true,
        enumerable: true,
        value,
        writable: true
      })
    }

    toString () {
      return `${this.name} [${sym}]: ${this.message}`
    }
  }
}

E('ERR_BUFFER_OUT_OF_BOUNDS',
  function (name) {
    if (name) {
      return `${name} is outside of buffer bounds`
    }

    return 'Attempt to access memory outside buffer bounds'
  }, RangeError)
E('ERR_INVALID_ARG_TYPE',
  function (name, actual) {
    return `The "${name}" argument must be of type number. Received type ${typeof actual}`
  }, TypeError)
E('ERR_OUT_OF_RANGE',
  function (str, range, input) {
    let msg = `The value of "${str}" is out of range.`
    let received = input
    if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
      received = addNumericalSeparator(String(input))
    } else if (typeof input === 'bigint') {
      received = String(input)
      if (input > BigInt(2) ** BigInt(32) || input < -(BigInt(2) ** BigInt(32))) {
        received = addNumericalSeparator(received)
      }
      received += 'n'
    }
    msg += ` It must be ${range}. Received ${received}`
    return msg
  }, RangeError)

function addNumericalSeparator (val) {
  let res = ''
  let i = val.length
  const start = val[0] === '-' ? 1 : 0
  for (; i >= start + 4; i -= 3) {
    res = `_${val.slice(i - 3, i)}${res}`
  }
  return `${val.slice(0, i)}${res}`
}

// CHECK FUNCTIONS
// ===============

function checkBounds (buf, offset, byteLength) {
  validateNumber(offset, 'offset')
  if (buf[offset] === undefined || buf[offset + byteLength] === undefined) {
    boundsError(offset, buf.length - (byteLength + 1))
  }
}

function checkIntBI (value, min, max, buf, offset, byteLength) {
  if (value > max || value < min) {
    const n = typeof min === 'bigint' ? 'n' : ''
    let range
    if (byteLength > 3) {
      if (min === 0 || min === BigInt(0)) {
        range = `>= 0${n} and < 2${n} ** ${(byteLength + 1) * 8}${n}`
      } else {
        range = `>= -(2${n} ** ${(byteLength + 1) * 8 - 1}${n}) and < 2 ** ` +
                `${(byteLength + 1) * 8 - 1}${n}`
      }
    } else {
      range = `>= ${min}${n} and <= ${max}${n}`
    }
    throw new errors.ERR_OUT_OF_RANGE('value', range, value)
  }
  checkBounds(buf, offset, byteLength)
}

function validateNumber (value, name) {
  if (typeof value !== 'number') {
    throw new errors.ERR_INVALID_ARG_TYPE(name, 'number', value)
  }
}

function boundsError (value, length, type) {
  if (Math.floor(value) !== value) {
    validateNumber(value, type)
    throw new errors.ERR_OUT_OF_RANGE(type || 'offset', 'an integer', value)
  }

  if (length < 0) {
    throw new errors.ERR_BUFFER_OUT_OF_BOUNDS()
  }

  throw new errors.ERR_OUT_OF_RANGE(type || 'offset',
                                    `>= ${type ? 1 : 0} and <= ${length}`,
                                    value)
}

// HELPER FUNCTIONS
// ================

const INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node takes equal signs as end of the Base64 encoding
  str = str.split('=')[0]
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = str.trim().replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  let codePoint
  const length = string.length
  let leadSurrogate = null
  const bytes = []

  for (let i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  const byteArray = []
  for (let i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  let c, hi, lo
  const byteArray = []
  for (let i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  let i
  for (i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
// the `instanceof` check but they should be treated as of that type.
// See: https://github.com/feross/buffer/issues/166
function isInstance (obj, type) {
  return obj instanceof type ||
    (obj != null && obj.constructor != null && obj.constructor.name != null &&
      obj.constructor.name === type.name)
}
function numberIsNaN (obj) {
  // For IE11 support
  return obj !== obj // eslint-disable-line no-self-compare
}

// Create lookup table for `toString('hex')`
// See: https://github.com/feross/buffer/issues/219
const hexSliceLookupTable = (function () {
  const alphabet = '0123456789abcdef'
  const table = new Array(256)
  for (let i = 0; i < 16; ++i) {
    const i16 = i * 16
    for (let j = 0; j < 16; ++j) {
      table[i16 + j] = alphabet[i] + alphabet[j]
    }
  }
  return table
})()

// Return not function with Error if BigInt not supported
function defineBigIntMethod (fn) {
  return typeof BigInt === 'undefined' ? BufferBigIntNotDefined : fn
}

function BufferBigIntNotDefined () {
  throw new Error('BigInt not supported')
}


/***/ }),

/***/ 1227:
/***/ ((module, exports, __webpack_require__) => {

/* provided dependency */ var process = __webpack_require__(4155);
/* eslint-env browser */

/**
 * This is the web browser implementation of `debug()`.
 */

exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;
exports.storage = localstorage();
exports.destroy = (() => {
	let warned = false;

	return () => {
		if (!warned) {
			warned = true;
			console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
		}
	};
})();

/**
 * Colors.
 */

exports.colors = [
	'#0000CC',
	'#0000FF',
	'#0033CC',
	'#0033FF',
	'#0066CC',
	'#0066FF',
	'#0099CC',
	'#0099FF',
	'#00CC00',
	'#00CC33',
	'#00CC66',
	'#00CC99',
	'#00CCCC',
	'#00CCFF',
	'#3300CC',
	'#3300FF',
	'#3333CC',
	'#3333FF',
	'#3366CC',
	'#3366FF',
	'#3399CC',
	'#3399FF',
	'#33CC00',
	'#33CC33',
	'#33CC66',
	'#33CC99',
	'#33CCCC',
	'#33CCFF',
	'#6600CC',
	'#6600FF',
	'#6633CC',
	'#6633FF',
	'#66CC00',
	'#66CC33',
	'#9900CC',
	'#9900FF',
	'#9933CC',
	'#9933FF',
	'#99CC00',
	'#99CC33',
	'#CC0000',
	'#CC0033',
	'#CC0066',
	'#CC0099',
	'#CC00CC',
	'#CC00FF',
	'#CC3300',
	'#CC3333',
	'#CC3366',
	'#CC3399',
	'#CC33CC',
	'#CC33FF',
	'#CC6600',
	'#CC6633',
	'#CC9900',
	'#CC9933',
	'#CCCC00',
	'#CCCC33',
	'#FF0000',
	'#FF0033',
	'#FF0066',
	'#FF0099',
	'#FF00CC',
	'#FF00FF',
	'#FF3300',
	'#FF3333',
	'#FF3366',
	'#FF3399',
	'#FF33CC',
	'#FF33FF',
	'#FF6600',
	'#FF6633',
	'#FF9900',
	'#FF9933',
	'#FFCC00',
	'#FFCC33'
];

/**
 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
 * and the Firebug extension (any Firefox version) are known
 * to support "%c" CSS customizations.
 *
 * TODO: add a `localStorage` variable to explicitly enable/disable colors
 */

// eslint-disable-next-line complexity
function useColors() {
	// NB: In an Electron preload script, document will be defined but not fully
	// initialized. Since we know we're in Chrome, we'll just detect this case
	// explicitly
	if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
		return true;
	}

	// Internet Explorer and Edge do not support colors.
	if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
		return false;
	}

	// Is webkit? http://stackoverflow.com/a/16459606/376773
	// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
	return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
		// Is firebug? http://stackoverflow.com/a/398120/376773
		(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
		// Is firefox >= v31?
		// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
		// Double check webkit in userAgent just in case we are in a worker
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
}

/**
 * Colorize log arguments if enabled.
 *
 * @api public
 */

function formatArgs(args) {
	args[0] = (this.useColors ? '%c' : '') +
		this.namespace +
		(this.useColors ? ' %c' : ' ') +
		args[0] +
		(this.useColors ? '%c ' : ' ') +
		'+' + module.exports.humanize(this.diff);

	if (!this.useColors) {
		return;
	}

	const c = 'color: ' + this.color;
	args.splice(1, 0, c, 'color: inherit');

	// The final "%c" is somewhat tricky, because there could be other
	// arguments passed either before or after the %c, so we need to
	// figure out the correct index to insert the CSS into
	let index = 0;
	let lastC = 0;
	args[0].replace(/%[a-zA-Z%]/g, match => {
		if (match === '%%') {
			return;
		}
		index++;
		if (match === '%c') {
			// We only are interested in the *last* %c
			// (the user may have provided their own)
			lastC = index;
		}
	});

	args.splice(lastC, 0, c);
}

/**
 * Invokes `console.debug()` when available.
 * No-op when `console.debug` is not a "function".
 * If `console.debug` is not available, falls back
 * to `console.log`.
 *
 * @api public
 */
exports.log = console.debug || console.log || (() => {});

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */
function save(namespaces) {
	try {
		if (namespaces) {
			exports.storage.setItem('debug', namespaces);
		} else {
			exports.storage.removeItem('debug');
		}
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */
function load() {
	let r;
	try {
		r = exports.storage.getItem('debug');
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}

	// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
	if (!r && typeof process !== 'undefined' && 'env' in process) {
		r = process.env.DEBUG;
	}

	return r;
}

/**
 * Localstorage attempts to return the localstorage.
 *
 * This is necessary because safari throws
 * when a user disables cookies/localstorage
 * and you attempt to access it.
 *
 * @return {LocalStorage}
 * @api private
 */

function localstorage() {
	try {
		// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
		// The Browser also has localStorage in the global context.
		return localStorage;
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

module.exports = __webpack_require__(2447)(exports);

const {formatters} = module.exports;

/**
 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
 */

formatters.j = function (v) {
	try {
		return JSON.stringify(v);
	} catch (error) {
		return '[UnexpectedJSONParseError]: ' + error.message;
	}
};


/***/ }),

/***/ 2447:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/**
 * This is the common logic for both the Node.js and web browser
 * implementations of `debug()`.
 */

function setup(env) {
	createDebug.debug = createDebug;
	createDebug.default = createDebug;
	createDebug.coerce = coerce;
	createDebug.disable = disable;
	createDebug.enable = enable;
	createDebug.enabled = enabled;
	createDebug.humanize = __webpack_require__(7824);
	createDebug.destroy = destroy;

	Object.keys(env).forEach(key => {
		createDebug[key] = env[key];
	});

	/**
	* The currently active debug mode names, and names to skip.
	*/

	createDebug.names = [];
	createDebug.skips = [];

	/**
	* Map of special "%n" handling functions, for the debug "format" argument.
	*
	* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
	*/
	createDebug.formatters = {};

	/**
	* Selects a color for a debug namespace
	* @param {String} namespace The namespace string for the debug instance to be colored
	* @return {Number|String} An ANSI color code for the given namespace
	* @api private
	*/
	function selectColor(namespace) {
		let hash = 0;

		for (let i = 0; i < namespace.length; i++) {
			hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
			hash |= 0; // Convert to 32bit integer
		}

		return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
	}
	createDebug.selectColor = selectColor;

	/**
	* Create a debugger with the given `namespace`.
	*
	* @param {String} namespace
	* @return {Function}
	* @api public
	*/
	function createDebug(namespace) {
		let prevTime;
		let enableOverride = null;
		let namespacesCache;
		let enabledCache;

		function debug(...args) {
			// Disabled?
			if (!debug.enabled) {
				return;
			}

			const self = debug;

			// Set `diff` timestamp
			const curr = Number(new Date());
			const ms = curr - (prevTime || curr);
			self.diff = ms;
			self.prev = prevTime;
			self.curr = curr;
			prevTime = curr;

			args[0] = createDebug.coerce(args[0]);

			if (typeof args[0] !== 'string') {
				// Anything else let's inspect with %O
				args.unshift('%O');
			}

			// Apply any `formatters` transformations
			let index = 0;
			args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
				// If we encounter an escaped % then don't increase the array index
				if (match === '%%') {
					return '%';
				}
				index++;
				const formatter = createDebug.formatters[format];
				if (typeof formatter === 'function') {
					const val = args[index];
					match = formatter.call(self, val);

					// Now we need to remove `args[index]` since it's inlined in the `format`
					args.splice(index, 1);
					index--;
				}
				return match;
			});

			// Apply env-specific formatting (colors, etc.)
			createDebug.formatArgs.call(self, args);

			const logFn = self.log || createDebug.log;
			logFn.apply(self, args);
		}

		debug.namespace = namespace;
		debug.useColors = createDebug.useColors();
		debug.color = createDebug.selectColor(namespace);
		debug.extend = extend;
		debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

		Object.defineProperty(debug, 'enabled', {
			enumerable: true,
			configurable: false,
			get: () => {
				if (enableOverride !== null) {
					return enableOverride;
				}
				if (namespacesCache !== createDebug.namespaces) {
					namespacesCache = createDebug.namespaces;
					enabledCache = createDebug.enabled(namespace);
				}

				return enabledCache;
			},
			set: v => {
				enableOverride = v;
			}
		});

		// Env-specific initialization logic for debug instances
		if (typeof createDebug.init === 'function') {
			createDebug.init(debug);
		}

		return debug;
	}

	function extend(namespace, delimiter) {
		const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
		newDebug.log = this.log;
		return newDebug;
	}

	/**
	* Enables a debug mode by namespaces. This can include modes
	* separated by a colon and wildcards.
	*
	* @param {String} namespaces
	* @api public
	*/
	function enable(namespaces) {
		createDebug.save(namespaces);
		createDebug.namespaces = namespaces;

		createDebug.names = [];
		createDebug.skips = [];

		let i;
		const split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
		const len = split.length;

		for (i = 0; i < len; i++) {
			if (!split[i]) {
				// ignore empty strings
				continue;
			}

			namespaces = split[i].replace(/\*/g, '.*?');

			if (namespaces[0] === '-') {
				createDebug.skips.push(new RegExp('^' + namespaces.slice(1) + '$'));
			} else {
				createDebug.names.push(new RegExp('^' + namespaces + '$'));
			}
		}
	}

	/**
	* Disable debug output.
	*
	* @return {String} namespaces
	* @api public
	*/
	function disable() {
		const namespaces = [
			...createDebug.names.map(toNamespace),
			...createDebug.skips.map(toNamespace).map(namespace => '-' + namespace)
		].join(',');
		createDebug.enable('');
		return namespaces;
	}

	/**
	* Returns true if the given mode name is enabled, false otherwise.
	*
	* @param {String} name
	* @return {Boolean}
	* @api public
	*/
	function enabled(name) {
		if (name[name.length - 1] === '*') {
			return true;
		}

		let i;
		let len;

		for (i = 0, len = createDebug.skips.length; i < len; i++) {
			if (createDebug.skips[i].test(name)) {
				return false;
			}
		}

		for (i = 0, len = createDebug.names.length; i < len; i++) {
			if (createDebug.names[i].test(name)) {
				return true;
			}
		}

		return false;
	}

	/**
	* Convert regexp to namespace
	*
	* @param {RegExp} regxep
	* @return {String} namespace
	* @api private
	*/
	function toNamespace(regexp) {
		return regexp.toString()
			.substring(2, regexp.toString().length - 2)
			.replace(/\.\*\?$/, '*');
	}

	/**
	* Coerce `val`.
	*
	* @param {Mixed} val
	* @return {Mixed}
	* @api private
	*/
	function coerce(val) {
		if (val instanceof Error) {
			return val.stack || val.message;
		}
		return val;
	}

	/**
	* XXX DO NOT USE. This is a temporary stub function.
	* XXX It WILL be removed in the next major release.
	*/
	function destroy() {
		console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
	}

	createDebug.enable(createDebug.load());

	return createDebug;
}

module.exports = setup;


/***/ }),

/***/ 9187:
/***/ ((module) => {

"use strict";


module.exports = earcut;
module.exports["default"] = earcut;

function earcut(data, holeIndices, dim) {

    dim = dim || 2;

    var hasHoles = holeIndices && holeIndices.length,
        outerLen = hasHoles ? holeIndices[0] * dim : data.length,
        outerNode = linkedList(data, 0, outerLen, dim, true),
        triangles = [];

    if (!outerNode || outerNode.next === outerNode.prev) return triangles;

    var minX, minY, maxX, maxY, x, y, invSize;

    if (hasHoles) outerNode = eliminateHoles(data, holeIndices, outerNode, dim);

    // if the shape is not too simple, we'll use z-order curve hash later; calculate polygon bbox
    if (data.length > 80 * dim) {
        minX = maxX = data[0];
        minY = maxY = data[1];

        for (var i = dim; i < outerLen; i += dim) {
            x = data[i];
            y = data[i + 1];
            if (x < minX) minX = x;
            if (y < minY) minY = y;
            if (x > maxX) maxX = x;
            if (y > maxY) maxY = y;
        }

        // minX, minY and invSize are later used to transform coords into integers for z-order calculation
        invSize = Math.max(maxX - minX, maxY - minY);
        invSize = invSize !== 0 ? 1 / invSize : 0;
    }

    earcutLinked(outerNode, triangles, dim, minX, minY, invSize);

    return triangles;
}

// create a circular doubly linked list from polygon points in the specified winding order
function linkedList(data, start, end, dim, clockwise) {
    var i, last;

    if (clockwise === (signedArea(data, start, end, dim) > 0)) {
        for (i = start; i < end; i += dim) last = insertNode(i, data[i], data[i + 1], last);
    } else {
        for (i = end - dim; i >= start; i -= dim) last = insertNode(i, data[i], data[i + 1], last);
    }

    if (last && equals(last, last.next)) {
        removeNode(last);
        last = last.next;
    }

    return last;
}

// eliminate colinear or duplicate points
function filterPoints(start, end) {
    if (!start) return start;
    if (!end) end = start;

    var p = start,
        again;
    do {
        again = false;

        if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {
            removeNode(p);
            p = end = p.prev;
            if (p === p.next) break;
            again = true;

        } else {
            p = p.next;
        }
    } while (again || p !== end);

    return end;
}

// main ear slicing loop which triangulates a polygon (given as a linked list)
function earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {
    if (!ear) return;

    // interlink polygon nodes in z-order
    if (!pass && invSize) indexCurve(ear, minX, minY, invSize);

    var stop = ear,
        prev, next;

    // iterate through ears, slicing them one by one
    while (ear.prev !== ear.next) {
        prev = ear.prev;
        next = ear.next;

        if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {
            // cut off the triangle
            triangles.push(prev.i / dim);
            triangles.push(ear.i / dim);
            triangles.push(next.i / dim);

            removeNode(ear);

            // skipping the next vertex leads to less sliver triangles
            ear = next.next;
            stop = next.next;

            continue;
        }

        ear = next;

        // if we looped through the whole remaining polygon and can't find any more ears
        if (ear === stop) {
            // try filtering points and slicing again
            if (!pass) {
                earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);

            // if this didn't work, try curing all small self-intersections locally
            } else if (pass === 1) {
                ear = cureLocalIntersections(filterPoints(ear), triangles, dim);
                earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);

            // as a last resort, try splitting the remaining polygon into two
            } else if (pass === 2) {
                splitEarcut(ear, triangles, dim, minX, minY, invSize);
            }

            break;
        }
    }
}

// check whether a polygon node forms a valid ear with adjacent nodes
function isEar(ear) {
    var a = ear.prev,
        b = ear,
        c = ear.next;

    if (area(a, b, c) >= 0) return false; // reflex, can't be an ear

    // now make sure we don't have other points inside the potential ear
    var p = ear.next.next;

    while (p !== ear.prev) {
        if (pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) &&
            area(p.prev, p, p.next) >= 0) return false;
        p = p.next;
    }

    return true;
}

function isEarHashed(ear, minX, minY, invSize) {
    var a = ear.prev,
        b = ear,
        c = ear.next;

    if (area(a, b, c) >= 0) return false; // reflex, can't be an ear

    // triangle bbox; min & max are calculated like this for speed
    var minTX = a.x < b.x ? (a.x < c.x ? a.x : c.x) : (b.x < c.x ? b.x : c.x),
        minTY = a.y < b.y ? (a.y < c.y ? a.y : c.y) : (b.y < c.y ? b.y : c.y),
        maxTX = a.x > b.x ? (a.x > c.x ? a.x : c.x) : (b.x > c.x ? b.x : c.x),
        maxTY = a.y > b.y ? (a.y > c.y ? a.y : c.y) : (b.y > c.y ? b.y : c.y);

    // z-order range for the current triangle bbox;
    var minZ = zOrder(minTX, minTY, minX, minY, invSize),
        maxZ = zOrder(maxTX, maxTY, minX, minY, invSize);

    var p = ear.prevZ,
        n = ear.nextZ;

    // look for points inside the triangle in both directions
    while (p && p.z >= minZ && n && n.z <= maxZ) {
        if (p !== ear.prev && p !== ear.next &&
            pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) &&
            area(p.prev, p, p.next) >= 0) return false;
        p = p.prevZ;

        if (n !== ear.prev && n !== ear.next &&
            pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) &&
            area(n.prev, n, n.next) >= 0) return false;
        n = n.nextZ;
    }

    // look for remaining points in decreasing z-order
    while (p && p.z >= minZ) {
        if (p !== ear.prev && p !== ear.next &&
            pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) &&
            area(p.prev, p, p.next) >= 0) return false;
        p = p.prevZ;
    }

    // look for remaining points in increasing z-order
    while (n && n.z <= maxZ) {
        if (n !== ear.prev && n !== ear.next &&
            pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) &&
            area(n.prev, n, n.next) >= 0) return false;
        n = n.nextZ;
    }

    return true;
}

// go through all polygon nodes and cure small local self-intersections
function cureLocalIntersections(start, triangles, dim) {
    var p = start;
    do {
        var a = p.prev,
            b = p.next.next;

        if (!equals(a, b) && intersects(a, p, p.next, b) && locallyInside(a, b) && locallyInside(b, a)) {

            triangles.push(a.i / dim);
            triangles.push(p.i / dim);
            triangles.push(b.i / dim);

            // remove two nodes involved
            removeNode(p);
            removeNode(p.next);

            p = start = b;
        }
        p = p.next;
    } while (p !== start);

    return filterPoints(p);
}

// try splitting polygon into two and triangulate them independently
function splitEarcut(start, triangles, dim, minX, minY, invSize) {
    // look for a valid diagonal that divides the polygon into two
    var a = start;
    do {
        var b = a.next.next;
        while (b !== a.prev) {
            if (a.i !== b.i && isValidDiagonal(a, b)) {
                // split the polygon in two by the diagonal
                var c = splitPolygon(a, b);

                // filter colinear points around the cuts
                a = filterPoints(a, a.next);
                c = filterPoints(c, c.next);

                // run earcut on each half
                earcutLinked(a, triangles, dim, minX, minY, invSize);
                earcutLinked(c, triangles, dim, minX, minY, invSize);
                return;
            }
            b = b.next;
        }
        a = a.next;
    } while (a !== start);
}

// link every hole into the outer loop, producing a single-ring polygon without holes
function eliminateHoles(data, holeIndices, outerNode, dim) {
    var queue = [],
        i, len, start, end, list;

    for (i = 0, len = holeIndices.length; i < len; i++) {
        start = holeIndices[i] * dim;
        end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
        list = linkedList(data, start, end, dim, false);
        if (list === list.next) list.steiner = true;
        queue.push(getLeftmost(list));
    }

    queue.sort(compareX);

    // process holes from left to right
    for (i = 0; i < queue.length; i++) {
        outerNode = eliminateHole(queue[i], outerNode);
        outerNode = filterPoints(outerNode, outerNode.next);
    }

    return outerNode;
}

function compareX(a, b) {
    return a.x - b.x;
}

// find a bridge between vertices that connects hole with an outer ring and and link it
function eliminateHole(hole, outerNode) {
    var bridge = findHoleBridge(hole, outerNode);
    if (!bridge) {
        return outerNode;
    }

    var bridgeReverse = splitPolygon(bridge, hole);

    // filter collinear points around the cuts
    var filteredBridge = filterPoints(bridge, bridge.next);
    filterPoints(bridgeReverse, bridgeReverse.next);

    // Check if input node was removed by the filtering
    return outerNode === bridge ? filteredBridge : outerNode;
}

// David Eberly's algorithm for finding a bridge between hole and outer polygon
function findHoleBridge(hole, outerNode) {
    var p = outerNode,
        hx = hole.x,
        hy = hole.y,
        qx = -Infinity,
        m;

    // find a segment intersected by a ray from the hole's leftmost point to the left;
    // segment's endpoint with lesser x will be potential connection point
    do {
        if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
            var x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
            if (x <= hx && x > qx) {
                qx = x;
                if (x === hx) {
                    if (hy === p.y) return p;
                    if (hy === p.next.y) return p.next;
                }
                m = p.x < p.next.x ? p : p.next;
            }
        }
        p = p.next;
    } while (p !== outerNode);

    if (!m) return null;

    if (hx === qx) return m; // hole touches outer segment; pick leftmost endpoint

    // look for points inside the triangle of hole point, segment intersection and endpoint;
    // if there are no points found, we have a valid connection;
    // otherwise choose the point of the minimum angle with the ray as connection point

    var stop = m,
        mx = m.x,
        my = m.y,
        tanMin = Infinity,
        tan;

    p = m;

    do {
        if (hx >= p.x && p.x >= mx && hx !== p.x &&
                pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {

            tan = Math.abs(hy - p.y) / (hx - p.x); // tangential

            if (locallyInside(p, hole) &&
                (tan < tanMin || (tan === tanMin && (p.x > m.x || (p.x === m.x && sectorContainsSector(m, p)))))) {
                m = p;
                tanMin = tan;
            }
        }

        p = p.next;
    } while (p !== stop);

    return m;
}

// whether sector in vertex m contains sector in vertex p in the same coordinates
function sectorContainsSector(m, p) {
    return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;
}

// interlink polygon nodes in z-order
function indexCurve(start, minX, minY, invSize) {
    var p = start;
    do {
        if (p.z === null) p.z = zOrder(p.x, p.y, minX, minY, invSize);
        p.prevZ = p.prev;
        p.nextZ = p.next;
        p = p.next;
    } while (p !== start);

    p.prevZ.nextZ = null;
    p.prevZ = null;

    sortLinked(p);
}

// Simon Tatham's linked list merge sort algorithm
// http://www.chiark.greenend.org.uk/~sgtatham/algorithms/listsort.html
function sortLinked(list) {
    var i, p, q, e, tail, numMerges, pSize, qSize,
        inSize = 1;

    do {
        p = list;
        list = null;
        tail = null;
        numMerges = 0;

        while (p) {
            numMerges++;
            q = p;
            pSize = 0;
            for (i = 0; i < inSize; i++) {
                pSize++;
                q = q.nextZ;
                if (!q) break;
            }
            qSize = inSize;

            while (pSize > 0 || (qSize > 0 && q)) {

                if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
                    e = p;
                    p = p.nextZ;
                    pSize--;
                } else {
                    e = q;
                    q = q.nextZ;
                    qSize--;
                }

                if (tail) tail.nextZ = e;
                else list = e;

                e.prevZ = tail;
                tail = e;
            }

            p = q;
        }

        tail.nextZ = null;
        inSize *= 2;

    } while (numMerges > 1);

    return list;
}

// z-order of a point given coords and inverse of the longer side of data bbox
function zOrder(x, y, minX, minY, invSize) {
    // coords are transformed into non-negative 15-bit integer range
    x = 32767 * (x - minX) * invSize;
    y = 32767 * (y - minY) * invSize;

    x = (x | (x << 8)) & 0x00FF00FF;
    x = (x | (x << 4)) & 0x0F0F0F0F;
    x = (x | (x << 2)) & 0x33333333;
    x = (x | (x << 1)) & 0x55555555;

    y = (y | (y << 8)) & 0x00FF00FF;
    y = (y | (y << 4)) & 0x0F0F0F0F;
    y = (y | (y << 2)) & 0x33333333;
    y = (y | (y << 1)) & 0x55555555;

    return x | (y << 1);
}

// find the leftmost node of a polygon ring
function getLeftmost(start) {
    var p = start,
        leftmost = start;
    do {
        if (p.x < leftmost.x || (p.x === leftmost.x && p.y < leftmost.y)) leftmost = p;
        p = p.next;
    } while (p !== start);

    return leftmost;
}

// check if a point lies within a convex triangle
function pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {
    return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0 &&
           (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0 &&
           (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0;
}

// check if a diagonal between two polygon nodes is valid (lies in polygon interior)
function isValidDiagonal(a, b) {
    return a.next.i !== b.i && a.prev.i !== b.i && !intersectsPolygon(a, b) && // dones't intersect other edges
           (locallyInside(a, b) && locallyInside(b, a) && middleInside(a, b) && // locally visible
            (area(a.prev, a, b.prev) || area(a, b.prev, b)) || // does not create opposite-facing sectors
            equals(a, b) && area(a.prev, a, a.next) > 0 && area(b.prev, b, b.next) > 0); // special zero-length case
}

// signed area of a triangle
function area(p, q, r) {
    return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
}

// check if two points are equal
function equals(p1, p2) {
    return p1.x === p2.x && p1.y === p2.y;
}

// check if two segments intersect
function intersects(p1, q1, p2, q2) {
    var o1 = sign(area(p1, q1, p2));
    var o2 = sign(area(p1, q1, q2));
    var o3 = sign(area(p2, q2, p1));
    var o4 = sign(area(p2, q2, q1));

    if (o1 !== o2 && o3 !== o4) return true; // general case

    if (o1 === 0 && onSegment(p1, p2, q1)) return true; // p1, q1 and p2 are collinear and p2 lies on p1q1
    if (o2 === 0 && onSegment(p1, q2, q1)) return true; // p1, q1 and q2 are collinear and q2 lies on p1q1
    if (o3 === 0 && onSegment(p2, p1, q2)) return true; // p2, q2 and p1 are collinear and p1 lies on p2q2
    if (o4 === 0 && onSegment(p2, q1, q2)) return true; // p2, q2 and q1 are collinear and q1 lies on p2q2

    return false;
}

// for collinear points p, q, r, check if point q lies on segment pr
function onSegment(p, q, r) {
    return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
}

function sign(num) {
    return num > 0 ? 1 : num < 0 ? -1 : 0;
}

// check if a polygon diagonal intersects any polygon segments
function intersectsPolygon(a, b) {
    var p = a;
    do {
        if (p.i !== a.i && p.next.i !== a.i && p.i !== b.i && p.next.i !== b.i &&
                intersects(p, p.next, a, b)) return true;
        p = p.next;
    } while (p !== a);

    return false;
}

// check if a polygon diagonal is locally inside the polygon
function locallyInside(a, b) {
    return area(a.prev, a, a.next) < 0 ?
        area(a, b, a.next) >= 0 && area(a, a.prev, b) >= 0 :
        area(a, b, a.prev) < 0 || area(a, a.next, b) < 0;
}

// check if the middle point of a polygon diagonal is inside the polygon
function middleInside(a, b) {
    var p = a,
        inside = false,
        px = (a.x + b.x) / 2,
        py = (a.y + b.y) / 2;
    do {
        if (((p.y > py) !== (p.next.y > py)) && p.next.y !== p.y &&
                (px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x))
            inside = !inside;
        p = p.next;
    } while (p !== a);

    return inside;
}

// link two polygon vertices with a bridge; if the vertices belong to the same ring, it splits polygon into two;
// if one belongs to the outer ring and another to a hole, it merges it into a single ring
function splitPolygon(a, b) {
    var a2 = new Node(a.i, a.x, a.y),
        b2 = new Node(b.i, b.x, b.y),
        an = a.next,
        bp = b.prev;

    a.next = b;
    b.prev = a;

    a2.next = an;
    an.prev = a2;

    b2.next = a2;
    a2.prev = b2;

    bp.next = b2;
    b2.prev = bp;

    return b2;
}

// create a node and optionally link it with previous one (in a circular doubly linked list)
function insertNode(i, x, y, last) {
    var p = new Node(i, x, y);

    if (!last) {
        p.prev = p;
        p.next = p;

    } else {
        p.next = last.next;
        p.prev = last;
        last.next.prev = p;
        last.next = p;
    }
    return p;
}

function removeNode(p) {
    p.next.prev = p.prev;
    p.prev.next = p.next;

    if (p.prevZ) p.prevZ.nextZ = p.nextZ;
    if (p.nextZ) p.nextZ.prevZ = p.prevZ;
}

function Node(i, x, y) {
    // vertex index in coordinates array
    this.i = i;

    // vertex coordinates
    this.x = x;
    this.y = y;

    // previous and next vertex nodes in a polygon ring
    this.prev = null;
    this.next = null;

    // z-order curve value
    this.z = null;

    // previous and next nodes in z-order
    this.prevZ = null;
    this.nextZ = null;

    // indicates whether this is a steiner point
    this.steiner = false;
}

// return a percentage difference between the polygon area and its triangulation area;
// used to verify correctness of triangulation
earcut.deviation = function (data, holeIndices, dim, triangles) {
    var hasHoles = holeIndices && holeIndices.length;
    var outerLen = hasHoles ? holeIndices[0] * dim : data.length;

    var polygonArea = Math.abs(signedArea(data, 0, outerLen, dim));
    if (hasHoles) {
        for (var i = 0, len = holeIndices.length; i < len; i++) {
            var start = holeIndices[i] * dim;
            var end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
            polygonArea -= Math.abs(signedArea(data, start, end, dim));
        }
    }

    var trianglesArea = 0;
    for (i = 0; i < triangles.length; i += 3) {
        var a = triangles[i] * dim;
        var b = triangles[i + 1] * dim;
        var c = triangles[i + 2] * dim;
        trianglesArea += Math.abs(
            (data[a] - data[c]) * (data[b + 1] - data[a + 1]) -
            (data[a] - data[b]) * (data[c + 1] - data[a + 1]));
    }

    return polygonArea === 0 && trianglesArea === 0 ? 0 :
        Math.abs((trianglesArea - polygonArea) / polygonArea);
};

function signedArea(data, start, end, dim) {
    var sum = 0;
    for (var i = start, j = end - dim; i < end; i += dim) {
        sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
        j = i;
    }
    return sum;
}

// turn a polygon in a multi-dimensional array form (e.g. as in GeoJSON) into a form Earcut accepts
earcut.flatten = function (data) {
    var dim = data[0][0].length,
        result = {vertices: [], holes: [], dimensions: dim},
        holeIndex = 0;

    for (var i = 0; i < data.length; i++) {
        for (var j = 0; j < data[i].length; j++) {
            for (var d = 0; d < dim; d++) result.vertices.push(data[i][j][d]);
        }
        if (i > 0) {
            holeIndex += data[i - 1].length;
            result.holes.push(holeIndex);
        }
    }
    return result;
};


/***/ }),

/***/ 1589:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "GoslingComponent": () => (/* binding */ GoslingComponent),
  "GoslingSchema": () => (/* binding */ GoslingSchema),
  "GoslingTemplates": () => (/* binding */ GoslingTemplates),
  "ThemeSchema": () => (/* binding */ theme_schema),
  "compile": () => (/* binding */ compile),
  "embed": () => (/* binding */ gosling_es_embed),
  "init": () => (/* binding */ init),
  "name": () => (/* binding */ gosling_es_name),
  "validateGoslingSpec": () => (/* binding */ validateGoslingSpec),
  "version": () => (/* binding */ version)
});

;// CONCATENATED MODULE: ./node_modules/lodash-es/isUndefined.js
/**
 * Checks if `value` is `undefined`.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `undefined`, else `false`.
 * @example
 *
 * _.isUndefined(void 0);
 * // => true
 *
 * _.isUndefined(null);
 * // => false
 */
function isUndefined(value) {
  return value === undefined;
}

/* harmony default export */ const lodash_es_isUndefined = (isUndefined);

// EXTERNAL MODULE: ./node_modules/lodash-es/_root.js
var _root = __webpack_require__(6169);
;// CONCATENATED MODULE: ./node_modules/lodash-es/_Symbol.js


/** Built-in value references. */
var _Symbol_Symbol = _root/* default.Symbol */.Z.Symbol;

/* harmony default export */ const _Symbol = (_Symbol_Symbol);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getRawTag.js


/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _getRawTag_hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = _getRawTag_hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

/* harmony default export */ const _getRawTag = (getRawTag);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_objectToString.js
/** Used for built-in method references. */
var _objectToString_objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var _objectToString_nativeObjectToString = _objectToString_objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return _objectToString_nativeObjectToString.call(value);
}

/* harmony default export */ const _objectToString = (objectToString);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseGetTag.js




/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var _baseGetTag_symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (_baseGetTag_symToStringTag && _baseGetTag_symToStringTag in Object(value))
    ? _getRawTag(value)
    : _objectToString(value);
}

/* harmony default export */ const _baseGetTag = (baseGetTag);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isObject.js
/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

/* harmony default export */ const lodash_es_isObject = (isObject);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isFunction.js



/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!lodash_es_isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = _baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

/* harmony default export */ const lodash_es_isFunction = (isFunction);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_coreJsData.js


/** Used to detect overreaching core-js shims. */
var coreJsData = _root/* default.__core-js_shared__ */.Z["__core-js_shared__"];

/* harmony default export */ const _coreJsData = (coreJsData);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_isMasked.js


/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(_coreJsData && _coreJsData.keys && _coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/* harmony default export */ const _isMasked = (isMasked);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_toSource.js
/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/* harmony default export */ const _toSource = (toSource);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIsNative.js





/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var _baseIsNative_funcProto = Function.prototype,
    _baseIsNative_objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var _baseIsNative_funcToString = _baseIsNative_funcProto.toString;

/** Used to check objects for own properties. */
var _baseIsNative_hasOwnProperty = _baseIsNative_objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  _baseIsNative_funcToString.call(_baseIsNative_hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!lodash_es_isObject(value) || _isMasked(value)) {
    return false;
  }
  var pattern = lodash_es_isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(_toSource(value));
}

/* harmony default export */ const _baseIsNative = (baseIsNative);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getValue.js
/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/* harmony default export */ const _getValue = (getValue);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getNative.js



/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = _getValue(object, key);
  return _baseIsNative(value) ? value : undefined;
}

/* harmony default export */ const _getNative = (getNative);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_defineProperty.js


var defineProperty = (function() {
  try {
    var func = _getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

/* harmony default export */ const _defineProperty = (defineProperty);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseAssignValue.js


/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && _defineProperty) {
    _defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

/* harmony default export */ const _baseAssignValue = (baseAssignValue);

;// CONCATENATED MODULE: ./node_modules/lodash-es/eq.js
/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/* harmony default export */ const lodash_es_eq = (eq);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_assignValue.js



/** Used for built-in method references. */
var _assignValue_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _assignValue_hasOwnProperty = _assignValue_objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(_assignValue_hasOwnProperty.call(object, key) && lodash_es_eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    _baseAssignValue(object, key, value);
  }
}

/* harmony default export */ const _assignValue = (assignValue);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_copyObject.js



/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      _baseAssignValue(object, key, newValue);
    } else {
      _assignValue(object, key, newValue);
    }
  }
  return object;
}

/* harmony default export */ const _copyObject = (copyObject);

;// CONCATENATED MODULE: ./node_modules/lodash-es/identity.js
/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity_identity(value) {
  return value;
}

/* harmony default export */ const lodash_es_identity = (identity_identity);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_apply.js
/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

/* harmony default export */ const _apply = (apply);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_overRest.js


/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        array = Array(length);

    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return _apply(func, this, otherArgs);
  };
}

/* harmony default export */ const _overRest = (overRest);

;// CONCATENATED MODULE: ./node_modules/lodash-es/constant.js
/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

/* harmony default export */ const lodash_es_constant = (constant);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseSetToString.js




/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !_defineProperty ? lodash_es_identity : function(func, string) {
  return _defineProperty(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': lodash_es_constant(string),
    'writable': true
  });
};

/* harmony default export */ const _baseSetToString = (baseSetToString);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_shortOut.js
/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

/* harmony default export */ const _shortOut = (shortOut);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_setToString.js



/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = _shortOut(_baseSetToString);

/* harmony default export */ const _setToString = (setToString);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseRest.js




/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return _setToString(_overRest(func, start, lodash_es_identity), func + '');
}

/* harmony default export */ const _baseRest = (baseRest);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isLength.js
/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/* harmony default export */ const lodash_es_isLength = (isLength);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isArrayLike.js



/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && lodash_es_isLength(value.length) && !lodash_es_isFunction(value);
}

/* harmony default export */ const lodash_es_isArrayLike = (isArrayLike);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_isIndex.js
/** Used as references for various `Number` constants. */
var _isIndex_MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? _isIndex_MAX_SAFE_INTEGER : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

/* harmony default export */ const _isIndex = (isIndex);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_isIterateeCall.js





/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!lodash_es_isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (lodash_es_isArrayLike(object) && _isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return lodash_es_eq(object[index], value);
  }
  return false;
}

/* harmony default export */ const _isIterateeCall = (isIterateeCall);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_createAssigner.js



/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return _baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && _isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

/* harmony default export */ const _createAssigner = (createAssigner);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_isPrototype.js
/** Used for built-in method references. */
var _isPrototype_objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || _isPrototype_objectProto;

  return value === proto;
}

/* harmony default export */ const _isPrototype = (isPrototype);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseTimes.js
/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/* harmony default export */ const _baseTimes = (baseTimes);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isObjectLike.js
/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

/* harmony default export */ const lodash_es_isObjectLike = (isObjectLike);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIsArguments.js



/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return lodash_es_isObjectLike(value) && _baseGetTag(value) == argsTag;
}

/* harmony default export */ const _baseIsArguments = (baseIsArguments);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isArguments.js



/** Used for built-in method references. */
var isArguments_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var isArguments_hasOwnProperty = isArguments_objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = isArguments_objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = _baseIsArguments(function() { return arguments; }()) ? _baseIsArguments : function(value) {
  return lodash_es_isObjectLike(value) && isArguments_hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

/* harmony default export */ const lodash_es_isArguments = (isArguments);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isArray.js
/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/* harmony default export */ const lodash_es_isArray = (isArray);

// EXTERNAL MODULE: ./node_modules/lodash-es/isBuffer.js + 1 modules
var isBuffer = __webpack_require__(4002);
;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIsTypedArray.js




/** `Object#toString` result references. */
var _baseIsTypedArray_argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    _baseIsTypedArray_funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[_baseIsTypedArray_argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[_baseIsTypedArray_funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return lodash_es_isObjectLike(value) &&
    lodash_es_isLength(value.length) && !!typedArrayTags[_baseGetTag(value)];
}

/* harmony default export */ const _baseIsTypedArray = (baseIsTypedArray);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseUnary.js
/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/* harmony default export */ const _baseUnary = (baseUnary);

// EXTERNAL MODULE: ./node_modules/lodash-es/_nodeUtil.js
var _nodeUtil = __webpack_require__(9730);
;// CONCATENATED MODULE: ./node_modules/lodash-es/isTypedArray.js




/* Node.js helper references. */
var nodeIsTypedArray = _nodeUtil/* default */.Z && _nodeUtil/* default.isTypedArray */.Z.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? _baseUnary(nodeIsTypedArray) : _baseIsTypedArray;

/* harmony default export */ const lodash_es_isTypedArray = (isTypedArray);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arrayLikeKeys.js







/** Used for built-in method references. */
var _arrayLikeKeys_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _arrayLikeKeys_hasOwnProperty = _arrayLikeKeys_objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = lodash_es_isArray(value),
      isArg = !isArr && lodash_es_isArguments(value),
      isBuff = !isArr && !isArg && (0,isBuffer/* default */.Z)(value),
      isType = !isArr && !isArg && !isBuff && lodash_es_isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? _baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || _arrayLikeKeys_hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           _isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

/* harmony default export */ const _arrayLikeKeys = (arrayLikeKeys);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_overArg.js
/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/* harmony default export */ const _overArg = (overArg);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_nativeKeys.js


/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = _overArg(Object.keys, Object);

/* harmony default export */ const _nativeKeys = (nativeKeys);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseKeys.js



/** Used for built-in method references. */
var _baseKeys_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _baseKeys_hasOwnProperty = _baseKeys_objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!_isPrototype(object)) {
    return _nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (_baseKeys_hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

/* harmony default export */ const _baseKeys = (baseKeys);

;// CONCATENATED MODULE: ./node_modules/lodash-es/keys.js




/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return lodash_es_isArrayLike(object) ? _arrayLikeKeys(object) : _baseKeys(object);
}

/* harmony default export */ const lodash_es_keys = (keys);

;// CONCATENATED MODULE: ./node_modules/lodash-es/assign.js







/** Used for built-in method references. */
var assign_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var assign_hasOwnProperty = assign_objectProto.hasOwnProperty;

/**
 * Assigns own enumerable string keyed properties of source objects to the
 * destination object. Source objects are applied from left to right.
 * Subsequent sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object` and is loosely based on
 * [`Object.assign`](https://mdn.io/Object/assign).
 *
 * @static
 * @memberOf _
 * @since 0.10.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @see _.assignIn
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * function Bar() {
 *   this.c = 3;
 * }
 *
 * Foo.prototype.b = 2;
 * Bar.prototype.d = 4;
 *
 * _.assign({ 'a': 0 }, new Foo, new Bar);
 * // => { 'a': 1, 'c': 3 }
 */
var assign_assign = _createAssigner(function(object, source) {
  if (_isPrototype(source) || lodash_es_isArrayLike(source)) {
    _copyObject(source, lodash_es_keys(source), object);
    return;
  }
  for (var key in source) {
    if (assign_hasOwnProperty.call(source, key)) {
      _assignValue(object, key, source[key]);
    }
  }
});

/* harmony default export */ const lodash_es_assign = (assign_assign);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseClamp.js
/**
 * The base implementation of `_.clamp` which doesn't coerce arguments.
 *
 * @private
 * @param {number} number The number to clamp.
 * @param {number} [lower] The lower bound.
 * @param {number} upper The upper bound.
 * @returns {number} Returns the clamped number.
 */
function baseClamp(number, lower, upper) {
  if (number === number) {
    if (upper !== undefined) {
      number = number <= upper ? number : upper;
    }
    if (lower !== undefined) {
      number = number >= lower ? number : lower;
    }
  }
  return number;
}

/* harmony default export */ const _baseClamp = (baseClamp);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_copyArray.js
/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

/* harmony default export */ const _copyArray = (copyArray);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseRandom.js
/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeFloor = Math.floor,
    nativeRandom = Math.random;

/**
 * The base implementation of `_.random` without support for returning
 * floating-point numbers.
 *
 * @private
 * @param {number} lower The lower bound.
 * @param {number} upper The upper bound.
 * @returns {number} Returns the random number.
 */
function baseRandom(lower, upper) {
  return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
}

/* harmony default export */ const _baseRandom = (baseRandom);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_shuffleSelf.js


/**
 * A specialized version of `_.shuffle` which mutates and sets the size of `array`.
 *
 * @private
 * @param {Array} array The array to shuffle.
 * @param {number} [size=array.length] The size of `array`.
 * @returns {Array} Returns `array`.
 */
function shuffleSelf(array, size) {
  var index = -1,
      length = array.length,
      lastIndex = length - 1;

  size = size === undefined ? length : size;
  while (++index < size) {
    var rand = _baseRandom(index, lastIndex),
        value = array[rand];

    array[rand] = array[index];
    array[index] = value;
  }
  array.length = size;
  return array;
}

/* harmony default export */ const _shuffleSelf = (shuffleSelf);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arraySampleSize.js




/**
 * A specialized version of `_.sampleSize` for arrays.
 *
 * @private
 * @param {Array} array The array to sample.
 * @param {number} n The number of elements to sample.
 * @returns {Array} Returns the random elements.
 */
function arraySampleSize(array, n) {
  return _shuffleSelf(_copyArray(array), _baseClamp(n, 0, array.length));
}

/* harmony default export */ const _arraySampleSize = (arraySampleSize);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arrayMap.js
/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

/* harmony default export */ const _arrayMap = (arrayMap);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseValues.js


/**
 * The base implementation of `_.values` and `_.valuesIn` which creates an
 * array of `object` property values corresponding to the property names
 * of `props`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array} props The property names to get values for.
 * @returns {Object} Returns the array of property values.
 */
function baseValues(object, props) {
  return _arrayMap(props, function(key) {
    return object[key];
  });
}

/* harmony default export */ const _baseValues = (baseValues);

;// CONCATENATED MODULE: ./node_modules/lodash-es/values.js



/**
 * Creates an array of the own enumerable string keyed property values of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property values.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.values(new Foo);
 * // => [1, 2] (iteration order is not guaranteed)
 *
 * _.values('hi');
 * // => ['h', 'i']
 */
function values(object) {
  return object == null ? [] : _baseValues(object, lodash_es_keys(object));
}

/* harmony default export */ const lodash_es_values = (values);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseSampleSize.js




/**
 * The base implementation of `_.sampleSize` without param guards.
 *
 * @private
 * @param {Array|Object} collection The collection to sample.
 * @param {number} n The number of elements to sample.
 * @returns {Array} Returns the random elements.
 */
function baseSampleSize(collection, n) {
  var array = lodash_es_values(collection);
  return _shuffleSelf(array, _baseClamp(n, 0, array.length));
}

/* harmony default export */ const _baseSampleSize = (baseSampleSize);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_trimmedEndIndex.js
/** Used to match a single whitespace character. */
var reWhitespace = /\s/;

/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
 * character of `string`.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {number} Returns the index of the last non-whitespace character.
 */
function trimmedEndIndex(string) {
  var index = string.length;

  while (index-- && reWhitespace.test(string.charAt(index))) {}
  return index;
}

/* harmony default export */ const _trimmedEndIndex = (trimmedEndIndex);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseTrim.js


/** Used to match leading whitespace. */
var reTrimStart = /^\s+/;

/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */
function baseTrim(string) {
  return string
    ? string.slice(0, _trimmedEndIndex(string) + 1).replace(reTrimStart, '')
    : string;
}

/* harmony default export */ const _baseTrim = (baseTrim);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isSymbol.js



/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (lodash_es_isObjectLike(value) && _baseGetTag(value) == symbolTag);
}

/* harmony default export */ const lodash_es_isSymbol = (isSymbol);

;// CONCATENATED MODULE: ./node_modules/lodash-es/toNumber.js




/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (lodash_es_isSymbol(value)) {
    return NAN;
  }
  if (lodash_es_isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = lodash_es_isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = _baseTrim(value);
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

/* harmony default export */ const lodash_es_toNumber = (toNumber);

;// CONCATENATED MODULE: ./node_modules/lodash-es/toFinite.js


/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0,
    MAX_INTEGER = 1.7976931348623157e+308;

/**
 * Converts `value` to a finite number.
 *
 * @static
 * @memberOf _
 * @since 4.12.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted number.
 * @example
 *
 * _.toFinite(3.2);
 * // => 3.2
 *
 * _.toFinite(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toFinite(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toFinite('3.2');
 * // => 3.2
 */
function toFinite(value) {
  if (!value) {
    return value === 0 ? value : 0;
  }
  value = lodash_es_toNumber(value);
  if (value === INFINITY || value === -INFINITY) {
    var sign = (value < 0 ? -1 : 1);
    return sign * MAX_INTEGER;
  }
  return value === value ? value : 0;
}

/* harmony default export */ const lodash_es_toFinite = (toFinite);

;// CONCATENATED MODULE: ./node_modules/lodash-es/toInteger.js


/**
 * Converts `value` to an integer.
 *
 * **Note:** This method is loosely based on
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted integer.
 * @example
 *
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 */
function toInteger(value) {
  var result = lodash_es_toFinite(value),
      remainder = result % 1;

  return result === result ? (remainder ? result - remainder : result) : 0;
}

/* harmony default export */ const lodash_es_toInteger = (toInteger);

;// CONCATENATED MODULE: ./node_modules/lodash-es/sampleSize.js






/**
 * Gets `n` random elements at unique keys from `collection` up to the
 * size of `collection`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Collection
 * @param {Array|Object} collection The collection to sample.
 * @param {number} [n=1] The number of elements to sample.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {Array} Returns the random elements.
 * @example
 *
 * _.sampleSize([1, 2, 3], 2);
 * // => [3, 1]
 *
 * _.sampleSize([1, 2, 3], 4);
 * // => [2, 3, 1]
 */
function sampleSize(collection, n, guard) {
  if ((guard ? _isIterateeCall(collection, n, guard) : n === undefined)) {
    n = 1;
  } else {
    n = lodash_es_toInteger(n);
  }
  var func = lodash_es_isArray(collection) ? _arraySampleSize : _baseSampleSize;
  return func(collection, n);
}

/* harmony default export */ const lodash_es_sampleSize = (sampleSize);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_listCacheClear.js
/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

/* harmony default export */ const _listCacheClear = (listCacheClear);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_assocIndexOf.js


/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (lodash_es_eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/* harmony default export */ const _assocIndexOf = (assocIndexOf);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_listCacheDelete.js


/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = _assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

/* harmony default export */ const _listCacheDelete = (listCacheDelete);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_listCacheGet.js


/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = _assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/* harmony default export */ const _listCacheGet = (listCacheGet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_listCacheHas.js


/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return _assocIndexOf(this.__data__, key) > -1;
}

/* harmony default export */ const _listCacheHas = (listCacheHas);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_listCacheSet.js


/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = _assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

/* harmony default export */ const _listCacheSet = (listCacheSet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_ListCache.js






/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = _listCacheClear;
ListCache.prototype['delete'] = _listCacheDelete;
ListCache.prototype.get = _listCacheGet;
ListCache.prototype.has = _listCacheHas;
ListCache.prototype.set = _listCacheSet;

/* harmony default export */ const _ListCache = (ListCache);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_stackClear.js


/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new _ListCache;
  this.size = 0;
}

/* harmony default export */ const _stackClear = (stackClear);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_stackDelete.js
/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

/* harmony default export */ const _stackDelete = (stackDelete);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_stackGet.js
/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/* harmony default export */ const _stackGet = (stackGet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_stackHas.js
/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/* harmony default export */ const _stackHas = (stackHas);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_Map.js



/* Built-in method references that are verified to be native. */
var _Map_Map = _getNative(_root/* default */.Z, 'Map');

/* harmony default export */ const _Map = (_Map_Map);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_nativeCreate.js


/* Built-in method references that are verified to be native. */
var nativeCreate = _getNative(Object, 'create');

/* harmony default export */ const _nativeCreate = (nativeCreate);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_hashClear.js


/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = _nativeCreate ? _nativeCreate(null) : {};
  this.size = 0;
}

/* harmony default export */ const _hashClear = (hashClear);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_hashDelete.js
/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

/* harmony default export */ const _hashDelete = (hashDelete);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_hashGet.js


/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var _hashGet_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _hashGet_hasOwnProperty = _hashGet_objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (_nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return _hashGet_hasOwnProperty.call(data, key) ? data[key] : undefined;
}

/* harmony default export */ const _hashGet = (hashGet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_hashHas.js


/** Used for built-in method references. */
var _hashHas_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _hashHas_hasOwnProperty = _hashHas_objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return _nativeCreate ? (data[key] !== undefined) : _hashHas_hasOwnProperty.call(data, key);
}

/* harmony default export */ const _hashHas = (hashHas);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_hashSet.js


/** Used to stand-in for `undefined` hash values. */
var _hashSet_HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (_nativeCreate && value === undefined) ? _hashSet_HASH_UNDEFINED : value;
  return this;
}

/* harmony default export */ const _hashSet = (hashSet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_Hash.js






/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = _hashClear;
Hash.prototype['delete'] = _hashDelete;
Hash.prototype.get = _hashGet;
Hash.prototype.has = _hashHas;
Hash.prototype.set = _hashSet;

/* harmony default export */ const _Hash = (Hash);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_mapCacheClear.js




/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new _Hash,
    'map': new (_Map || _ListCache),
    'string': new _Hash
  };
}

/* harmony default export */ const _mapCacheClear = (mapCacheClear);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_isKeyable.js
/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/* harmony default export */ const _isKeyable = (isKeyable);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getMapData.js


/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return _isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/* harmony default export */ const _getMapData = (getMapData);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_mapCacheDelete.js


/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = _getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

/* harmony default export */ const _mapCacheDelete = (mapCacheDelete);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_mapCacheGet.js


/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return _getMapData(this, key).get(key);
}

/* harmony default export */ const _mapCacheGet = (mapCacheGet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_mapCacheHas.js


/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return _getMapData(this, key).has(key);
}

/* harmony default export */ const _mapCacheHas = (mapCacheHas);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_mapCacheSet.js


/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = _getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

/* harmony default export */ const _mapCacheSet = (mapCacheSet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_MapCache.js






/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = _mapCacheClear;
MapCache.prototype['delete'] = _mapCacheDelete;
MapCache.prototype.get = _mapCacheGet;
MapCache.prototype.has = _mapCacheHas;
MapCache.prototype.set = _mapCacheSet;

/* harmony default export */ const _MapCache = (MapCache);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_stackSet.js




/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof _ListCache) {
    var pairs = data.__data__;
    if (!_Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new _MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

/* harmony default export */ const _stackSet = (stackSet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_Stack.js







/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new _ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = _stackClear;
Stack.prototype['delete'] = _stackDelete;
Stack.prototype.get = _stackGet;
Stack.prototype.has = _stackHas;
Stack.prototype.set = _stackSet;

/* harmony default export */ const _Stack = (Stack);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_setCacheAdd.js
/** Used to stand-in for `undefined` hash values. */
var _setCacheAdd_HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, _setCacheAdd_HASH_UNDEFINED);
  return this;
}

/* harmony default export */ const _setCacheAdd = (setCacheAdd);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_setCacheHas.js
/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

/* harmony default export */ const _setCacheHas = (setCacheHas);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_SetCache.js




/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new _MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = _setCacheAdd;
SetCache.prototype.has = _setCacheHas;

/* harmony default export */ const _SetCache = (SetCache);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arraySome.js
/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

/* harmony default export */ const _arraySome = (arraySome);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_cacheHas.js
/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

/* harmony default export */ const _cacheHas = (cacheHas);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_equalArrays.js




/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new _SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!_arraySome(other, function(othValue, othIndex) {
            if (!_cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

/* harmony default export */ const _equalArrays = (equalArrays);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_Uint8Array.js


/** Built-in value references. */
var _Uint8Array_Uint8Array = _root/* default.Uint8Array */.Z.Uint8Array;

/* harmony default export */ const _Uint8Array = (_Uint8Array_Uint8Array);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_mapToArray.js
/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

/* harmony default export */ const _mapToArray = (mapToArray);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_setToArray.js
/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

/* harmony default export */ const _setToArray = (setToArray);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_equalByTag.js







/** Used to compose bitmasks for value comparisons. */
var _equalByTag_COMPARE_PARTIAL_FLAG = 1,
    _equalByTag_COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var _equalByTag_boolTag = '[object Boolean]',
    _equalByTag_dateTag = '[object Date]',
    _equalByTag_errorTag = '[object Error]',
    _equalByTag_mapTag = '[object Map]',
    _equalByTag_numberTag = '[object Number]',
    _equalByTag_regexpTag = '[object RegExp]',
    _equalByTag_setTag = '[object Set]',
    _equalByTag_stringTag = '[object String]',
    _equalByTag_symbolTag = '[object Symbol]';

var _equalByTag_arrayBufferTag = '[object ArrayBuffer]',
    _equalByTag_dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = _Symbol ? _Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case _equalByTag_dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case _equalByTag_arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new _Uint8Array(object), new _Uint8Array(other))) {
        return false;
      }
      return true;

    case _equalByTag_boolTag:
    case _equalByTag_dateTag:
    case _equalByTag_numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return lodash_es_eq(+object, +other);

    case _equalByTag_errorTag:
      return object.name == other.name && object.message == other.message;

    case _equalByTag_regexpTag:
    case _equalByTag_stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case _equalByTag_mapTag:
      var convert = _mapToArray;

    case _equalByTag_setTag:
      var isPartial = bitmask & _equalByTag_COMPARE_PARTIAL_FLAG;
      convert || (convert = _setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= _equalByTag_COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = _equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case _equalByTag_symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

/* harmony default export */ const _equalByTag = (equalByTag);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arrayPush.js
/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

/* harmony default export */ const _arrayPush = (arrayPush);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseGetAllKeys.js



/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return lodash_es_isArray(object) ? result : _arrayPush(result, symbolsFunc(object));
}

/* harmony default export */ const _baseGetAllKeys = (baseGetAllKeys);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arrayFilter.js
/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

/* harmony default export */ const _arrayFilter = (arrayFilter);

;// CONCATENATED MODULE: ./node_modules/lodash-es/stubArray.js
/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

/* harmony default export */ const lodash_es_stubArray = (stubArray);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getSymbols.js



/** Used for built-in method references. */
var _getSymbols_objectProto = Object.prototype;

/** Built-in value references. */
var _getSymbols_propertyIsEnumerable = _getSymbols_objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? lodash_es_stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return _arrayFilter(nativeGetSymbols(object), function(symbol) {
    return _getSymbols_propertyIsEnumerable.call(object, symbol);
  });
};

/* harmony default export */ const _getSymbols = (getSymbols);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getAllKeys.js




/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return _baseGetAllKeys(object, lodash_es_keys, _getSymbols);
}

/* harmony default export */ const _getAllKeys = (getAllKeys);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_equalObjects.js


/** Used to compose bitmasks for value comparisons. */
var _equalObjects_COMPARE_PARTIAL_FLAG = 1;

/** Used for built-in method references. */
var _equalObjects_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _equalObjects_hasOwnProperty = _equalObjects_objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & _equalObjects_COMPARE_PARTIAL_FLAG,
      objProps = _getAllKeys(object),
      objLength = objProps.length,
      othProps = _getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : _equalObjects_hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

/* harmony default export */ const _equalObjects = (equalObjects);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_DataView.js



/* Built-in method references that are verified to be native. */
var _DataView_DataView = _getNative(_root/* default */.Z, 'DataView');

/* harmony default export */ const _DataView = (_DataView_DataView);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_Promise.js



/* Built-in method references that are verified to be native. */
var _Promise_Promise = _getNative(_root/* default */.Z, 'Promise');

/* harmony default export */ const _Promise = (_Promise_Promise);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_Set.js



/* Built-in method references that are verified to be native. */
var _Set_Set = _getNative(_root/* default */.Z, 'Set');

/* harmony default export */ const _Set = (_Set_Set);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_WeakMap.js



/* Built-in method references that are verified to be native. */
var WeakMap = _getNative(_root/* default */.Z, 'WeakMap');

/* harmony default export */ const _WeakMap = (WeakMap);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getTag.js








/** `Object#toString` result references. */
var _getTag_mapTag = '[object Map]',
    _getTag_objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    _getTag_setTag = '[object Set]',
    _getTag_weakMapTag = '[object WeakMap]';

var _getTag_dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = _toSource(_DataView),
    mapCtorString = _toSource(_Map),
    promiseCtorString = _toSource(_Promise),
    setCtorString = _toSource(_Set),
    weakMapCtorString = _toSource(_WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = _baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((_DataView && getTag(new _DataView(new ArrayBuffer(1))) != _getTag_dataViewTag) ||
    (_Map && getTag(new _Map) != _getTag_mapTag) ||
    (_Promise && getTag(_Promise.resolve()) != promiseTag) ||
    (_Set && getTag(new _Set) != _getTag_setTag) ||
    (_WeakMap && getTag(new _WeakMap) != _getTag_weakMapTag)) {
  getTag = function(value) {
    var result = _baseGetTag(value),
        Ctor = result == _getTag_objectTag ? value.constructor : undefined,
        ctorString = Ctor ? _toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return _getTag_dataViewTag;
        case mapCtorString: return _getTag_mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return _getTag_setTag;
        case weakMapCtorString: return _getTag_weakMapTag;
      }
    }
    return result;
  };
}

/* harmony default export */ const _getTag = (getTag);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIsEqualDeep.js









/** Used to compose bitmasks for value comparisons. */
var _baseIsEqualDeep_COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var _baseIsEqualDeep_argsTag = '[object Arguments]',
    _baseIsEqualDeep_arrayTag = '[object Array]',
    _baseIsEqualDeep_objectTag = '[object Object]';

/** Used for built-in method references. */
var _baseIsEqualDeep_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _baseIsEqualDeep_hasOwnProperty = _baseIsEqualDeep_objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = lodash_es_isArray(object),
      othIsArr = lodash_es_isArray(other),
      objTag = objIsArr ? _baseIsEqualDeep_arrayTag : _getTag(object),
      othTag = othIsArr ? _baseIsEqualDeep_arrayTag : _getTag(other);

  objTag = objTag == _baseIsEqualDeep_argsTag ? _baseIsEqualDeep_objectTag : objTag;
  othTag = othTag == _baseIsEqualDeep_argsTag ? _baseIsEqualDeep_objectTag : othTag;

  var objIsObj = objTag == _baseIsEqualDeep_objectTag,
      othIsObj = othTag == _baseIsEqualDeep_objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && (0,isBuffer/* default */.Z)(object)) {
    if (!(0,isBuffer/* default */.Z)(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new _Stack);
    return (objIsArr || lodash_es_isTypedArray(object))
      ? _equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : _equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & _baseIsEqualDeep_COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && _baseIsEqualDeep_hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && _baseIsEqualDeep_hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new _Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new _Stack);
  return _equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

/* harmony default export */ const _baseIsEqualDeep = (baseIsEqualDeep);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIsEqual.js



/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!lodash_es_isObjectLike(value) && !lodash_es_isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return _baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

/* harmony default export */ const _baseIsEqual = (baseIsEqual);

;// CONCATENATED MODULE: ./node_modules/lodash-es/isEqual.js


/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return _baseIsEqual(value, other);
}

/* harmony default export */ const lodash_es_isEqual = (isEqual);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIsMatch.js



/** Used to compose bitmasks for value comparisons. */
var _baseIsMatch_COMPARE_PARTIAL_FLAG = 1,
    _baseIsMatch_COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new _Stack;
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? _baseIsEqual(srcValue, objValue, _baseIsMatch_COMPARE_PARTIAL_FLAG | _baseIsMatch_COMPARE_UNORDERED_FLAG, customizer, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

/* harmony default export */ const _baseIsMatch = (baseIsMatch);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_isStrictComparable.js


/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !lodash_es_isObject(value);
}

/* harmony default export */ const _isStrictComparable = (isStrictComparable);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_getMatchData.js



/**
 * Gets the property names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = lodash_es_keys(object),
      length = result.length;

  while (length--) {
    var key = result[length],
        value = object[key];

    result[length] = [key, value, _isStrictComparable(value)];
  }
  return result;
}

/* harmony default export */ const _getMatchData = (getMatchData);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_matchesStrictComparable.js
/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

/* harmony default export */ const _matchesStrictComparable = (matchesStrictComparable);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseMatches.js




/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = _getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return _matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || _baseIsMatch(object, source, matchData);
  };
}

/* harmony default export */ const _baseMatches = (baseMatches);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_isKey.js



/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (lodash_es_isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || lodash_es_isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

/* harmony default export */ const _isKey = (isKey);

;// CONCATENATED MODULE: ./node_modules/lodash-es/memoize.js


/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || _MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = _MapCache;

/* harmony default export */ const lodash_es_memoize = (memoize);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_memoizeCapped.js


/** Used as the maximum memoize cache size. */
var MAX_MEMOIZE_SIZE = 500;

/**
 * A specialized version of `_.memoize` which clears the memoized function's
 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
 *
 * @private
 * @param {Function} func The function to have its output memoized.
 * @returns {Function} Returns the new memoized function.
 */
function memoizeCapped(func) {
  var result = lodash_es_memoize(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });

  var cache = result.cache;
  return result;
}

/* harmony default export */ const _memoizeCapped = (memoizeCapped);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_stringToPath.js


/** Used to match property names within property paths. */
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = _memoizeCapped(function(string) {
  var result = [];
  if (string.charCodeAt(0) === 46 /* . */) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, subString) {
    result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

/* harmony default export */ const _stringToPath = (stringToPath);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseToString.js





/** Used as references for various `Number` constants. */
var _baseToString_INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var _baseToString_symbolProto = _Symbol ? _Symbol.prototype : undefined,
    symbolToString = _baseToString_symbolProto ? _baseToString_symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (lodash_es_isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return _arrayMap(value, baseToString) + '';
  }
  if (lodash_es_isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -_baseToString_INFINITY) ? '-0' : result;
}

/* harmony default export */ const _baseToString = (baseToString);

;// CONCATENATED MODULE: ./node_modules/lodash-es/toString.js


/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString_toString(value) {
  return value == null ? '' : _baseToString(value);
}

/* harmony default export */ const lodash_es_toString = (toString_toString);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_castPath.js





/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (lodash_es_isArray(value)) {
    return value;
  }
  return _isKey(value, object) ? [value] : _stringToPath(lodash_es_toString(value));
}

/* harmony default export */ const _castPath = (castPath);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_toKey.js


/** Used as references for various `Number` constants. */
var _toKey_INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || lodash_es_isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -_toKey_INFINITY) ? '-0' : result;
}

/* harmony default export */ const _toKey = (toKey);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseGet.js



/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = _castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[_toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

/* harmony default export */ const _baseGet = (baseGet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/get.js


/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : _baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

/* harmony default export */ const lodash_es_get = (get);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseHasIn.js
/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

/* harmony default export */ const _baseHasIn = (baseHasIn);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_hasPath.js







/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = _castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = _toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && lodash_es_isLength(length) && _isIndex(key, length) &&
    (lodash_es_isArray(object) || lodash_es_isArguments(object));
}

/* harmony default export */ const _hasPath = (hasPath);

;// CONCATENATED MODULE: ./node_modules/lodash-es/hasIn.js



/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && _hasPath(object, path, _baseHasIn);
}

/* harmony default export */ const lodash_es_hasIn = (hasIn);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseMatchesProperty.js








/** Used to compose bitmasks for value comparisons. */
var _baseMatchesProperty_COMPARE_PARTIAL_FLAG = 1,
    _baseMatchesProperty_COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatchesProperty(path, srcValue) {
  if (_isKey(path) && _isStrictComparable(srcValue)) {
    return _matchesStrictComparable(_toKey(path), srcValue);
  }
  return function(object) {
    var objValue = lodash_es_get(object, path);
    return (objValue === undefined && objValue === srcValue)
      ? lodash_es_hasIn(object, path)
      : _baseIsEqual(srcValue, objValue, _baseMatchesProperty_COMPARE_PARTIAL_FLAG | _baseMatchesProperty_COMPARE_UNORDERED_FLAG);
  };
}

/* harmony default export */ const _baseMatchesProperty = (baseMatchesProperty);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseProperty.js
/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

/* harmony default export */ const _baseProperty = (baseProperty);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_basePropertyDeep.js


/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyDeep(path) {
  return function(object) {
    return _baseGet(object, path);
  };
}

/* harmony default export */ const _basePropertyDeep = (basePropertyDeep);

;// CONCATENATED MODULE: ./node_modules/lodash-es/property.js





/**
 * Creates a function that returns the value at `path` of a given object.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 * @example
 *
 * var objects = [
 *   { 'a': { 'b': 2 } },
 *   { 'a': { 'b': 1 } }
 * ];
 *
 * _.map(objects, _.property('a.b'));
 * // => [2, 1]
 *
 * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
 * // => [1, 2]
 */
function property(path) {
  return _isKey(path) ? _baseProperty(_toKey(path)) : _basePropertyDeep(path);
}

/* harmony default export */ const lodash_es_property = (property);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIteratee.js






/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return lodash_es_identity;
  }
  if (typeof value == 'object') {
    return lodash_es_isArray(value)
      ? _baseMatchesProperty(value[0], value[1])
      : _baseMatches(value);
  }
  return lodash_es_property(value);
}

/* harmony default export */ const _baseIteratee = (baseIteratee);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseFindIndex.js
/**
 * The base implementation of `_.findIndex` and `_.findLastIndex` without
 * support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} predicate The function invoked per iteration.
 * @param {number} fromIndex The index to search from.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseFindIndex(array, predicate, fromIndex, fromRight) {
  var length = array.length,
      index = fromIndex + (fromRight ? 1 : -1);

  while ((fromRight ? index-- : ++index < length)) {
    if (predicate(array[index], index, array)) {
      return index;
    }
  }
  return -1;
}

/* harmony default export */ const _baseFindIndex = (baseFindIndex);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIsNaN.js
/**
 * The base implementation of `_.isNaN` without support for number objects.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
 */
function baseIsNaN(value) {
  return value !== value;
}

/* harmony default export */ const _baseIsNaN = (baseIsNaN);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_strictIndexOf.js
/**
 * A specialized version of `_.indexOf` which performs strict equality
 * comparisons of values, i.e. `===`.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function strictIndexOf(array, value, fromIndex) {
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}

/* harmony default export */ const _strictIndexOf = (strictIndexOf);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseIndexOf.js




/**
 * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOf(array, value, fromIndex) {
  return value === value
    ? _strictIndexOf(array, value, fromIndex)
    : _baseFindIndex(array, _baseIsNaN, fromIndex);
}

/* harmony default export */ const _baseIndexOf = (baseIndexOf);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arrayIncludes.js


/**
 * A specialized version of `_.includes` for arrays without support for
 * specifying an index to search from.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludes(array, value) {
  var length = array == null ? 0 : array.length;
  return !!length && _baseIndexOf(array, value, 0) > -1;
}

/* harmony default export */ const _arrayIncludes = (arrayIncludes);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_arrayIncludesWith.js
/**
 * This function is like `arrayIncludes` except that it accepts a comparator.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @param {Function} comparator The comparator invoked per element.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludesWith(array, value, comparator) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (comparator(value, array[index])) {
      return true;
    }
  }
  return false;
}

/* harmony default export */ const _arrayIncludesWith = (arrayIncludesWith);

;// CONCATENATED MODULE: ./node_modules/lodash-es/noop.js
/**
 * This method returns `undefined`.
 *
 * @static
 * @memberOf _
 * @since 2.3.0
 * @category Util
 * @example
 *
 * _.times(2, _.noop);
 * // => [undefined, undefined]
 */
function noop() {
  // No operation performed.
}

/* harmony default export */ const lodash_es_noop = (noop);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_createSet.js




/** Used as references for various `Number` constants. */
var _createSet_INFINITY = 1 / 0;

/**
 * Creates a set object of `values`.
 *
 * @private
 * @param {Array} values The values to add to the set.
 * @returns {Object} Returns the new set.
 */
var createSet = !(_Set && (1 / _setToArray(new _Set([,-0]))[1]) == _createSet_INFINITY) ? lodash_es_noop : function(values) {
  return new _Set(values);
};

/* harmony default export */ const _createSet = (createSet);

;// CONCATENATED MODULE: ./node_modules/lodash-es/_baseUniq.js







/** Used as the size to enable large array optimizations. */
var _baseUniq_LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.uniqBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 */
function baseUniq(array, iteratee, comparator) {
  var index = -1,
      includes = _arrayIncludes,
      length = array.length,
      isCommon = true,
      result = [],
      seen = result;

  if (comparator) {
    isCommon = false;
    includes = _arrayIncludesWith;
  }
  else if (length >= _baseUniq_LARGE_ARRAY_SIZE) {
    var set = iteratee ? null : _createSet(array);
    if (set) {
      return _setToArray(set);
    }
    isCommon = false;
    includes = _cacheHas;
    seen = new _SetCache;
  }
  else {
    seen = iteratee ? [] : result;
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee ? iteratee(value) : value;

    value = (comparator || value !== 0) ? value : 0;
    if (isCommon && computed === computed) {
      var seenIndex = seen.length;
      while (seenIndex--) {
        if (seen[seenIndex] === computed) {
          continue outer;
        }
      }
      if (iteratee) {
        seen.push(computed);
      }
      result.push(value);
    }
    else if (!includes(seen, computed, comparator)) {
      if (seen !== result) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}

/* harmony default export */ const _baseUniq = (baseUniq);

;// CONCATENATED MODULE: ./node_modules/lodash-es/uniqBy.js



/**
 * This method is like `_.uniq` except that it accepts `iteratee` which is
 * invoked for each element in `array` to generate the criterion by which
 * uniqueness is computed. The order of result values is determined by the
 * order they occur in the array. The iteratee is invoked with one argument:
 * (value).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Array
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 * @example
 *
 * _.uniqBy([2.1, 1.2, 2.3], Math.floor);
 * // => [2.1, 1.2]
 *
 * // The `_.property` iteratee shorthand.
 * _.uniqBy([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
 * // => [{ 'x': 1 }, { 'x': 2 }]
 */
function uniqBy(array, iteratee) {
  return (array && array.length) ? _baseUniq(array, _baseIteratee(iteratee, 2)) : [];
}

/* harmony default export */ const lodash_es_uniqBy = (uniqBy);

// EXTERNAL MODULE: ./node_modules/pixi.js/dist/esm/pixi.js + 39 modules
var pixi = __webpack_require__(9618);
;// CONCATENATED MODULE: ./node_modules/d3-color/src/define.js
/* harmony default export */ function src_define(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
}

function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key in definition) prototype[key] = definition[key];
  return prototype;
}

;// CONCATENATED MODULE: ./node_modules/d3-color/src/color.js


function Color() {}

var darker = 0.7;
var brighter = 1 / darker;

var reI = "\\s*([+-]?\\d+)\\s*",
    reN = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",
    reP = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",
    reHex = /^#([0-9a-f]{3,8})$/,
    reRgbInteger = new RegExp("^rgb\\(" + [reI, reI, reI] + "\\)$"),
    reRgbPercent = new RegExp("^rgb\\(" + [reP, reP, reP] + "\\)$"),
    reRgbaInteger = new RegExp("^rgba\\(" + [reI, reI, reI, reN] + "\\)$"),
    reRgbaPercent = new RegExp("^rgba\\(" + [reP, reP, reP, reN] + "\\)$"),
    reHslPercent = new RegExp("^hsl\\(" + [reN, reP, reP] + "\\)$"),
    reHslaPercent = new RegExp("^hsla\\(" + [reN, reP, reP, reN] + "\\)$");

var named = {
  aliceblue: 0xf0f8ff,
  antiquewhite: 0xfaebd7,
  aqua: 0x00ffff,
  aquamarine: 0x7fffd4,
  azure: 0xf0ffff,
  beige: 0xf5f5dc,
  bisque: 0xffe4c4,
  black: 0x000000,
  blanchedalmond: 0xffebcd,
  blue: 0x0000ff,
  blueviolet: 0x8a2be2,
  brown: 0xa52a2a,
  burlywood: 0xdeb887,
  cadetblue: 0x5f9ea0,
  chartreuse: 0x7fff00,
  chocolate: 0xd2691e,
  coral: 0xff7f50,
  cornflowerblue: 0x6495ed,
  cornsilk: 0xfff8dc,
  crimson: 0xdc143c,
  cyan: 0x00ffff,
  darkblue: 0x00008b,
  darkcyan: 0x008b8b,
  darkgoldenrod: 0xb8860b,
  darkgray: 0xa9a9a9,
  darkgreen: 0x006400,
  darkgrey: 0xa9a9a9,
  darkkhaki: 0xbdb76b,
  darkmagenta: 0x8b008b,
  darkolivegreen: 0x556b2f,
  darkorange: 0xff8c00,
  darkorchid: 0x9932cc,
  darkred: 0x8b0000,
  darksalmon: 0xe9967a,
  darkseagreen: 0x8fbc8f,
  darkslateblue: 0x483d8b,
  darkslategray: 0x2f4f4f,
  darkslategrey: 0x2f4f4f,
  darkturquoise: 0x00ced1,
  darkviolet: 0x9400d3,
  deeppink: 0xff1493,
  deepskyblue: 0x00bfff,
  dimgray: 0x696969,
  dimgrey: 0x696969,
  dodgerblue: 0x1e90ff,
  firebrick: 0xb22222,
  floralwhite: 0xfffaf0,
  forestgreen: 0x228b22,
  fuchsia: 0xff00ff,
  gainsboro: 0xdcdcdc,
  ghostwhite: 0xf8f8ff,
  gold: 0xffd700,
  goldenrod: 0xdaa520,
  gray: 0x808080,
  green: 0x008000,
  greenyellow: 0xadff2f,
  grey: 0x808080,
  honeydew: 0xf0fff0,
  hotpink: 0xff69b4,
  indianred: 0xcd5c5c,
  indigo: 0x4b0082,
  ivory: 0xfffff0,
  khaki: 0xf0e68c,
  lavender: 0xe6e6fa,
  lavenderblush: 0xfff0f5,
  lawngreen: 0x7cfc00,
  lemonchiffon: 0xfffacd,
  lightblue: 0xadd8e6,
  lightcoral: 0xf08080,
  lightcyan: 0xe0ffff,
  lightgoldenrodyellow: 0xfafad2,
  lightgray: 0xd3d3d3,
  lightgreen: 0x90ee90,
  lightgrey: 0xd3d3d3,
  lightpink: 0xffb6c1,
  lightsalmon: 0xffa07a,
  lightseagreen: 0x20b2aa,
  lightskyblue: 0x87cefa,
  lightslategray: 0x778899,
  lightslategrey: 0x778899,
  lightsteelblue: 0xb0c4de,
  lightyellow: 0xffffe0,
  lime: 0x00ff00,
  limegreen: 0x32cd32,
  linen: 0xfaf0e6,
  magenta: 0xff00ff,
  maroon: 0x800000,
  mediumaquamarine: 0x66cdaa,
  mediumblue: 0x0000cd,
  mediumorchid: 0xba55d3,
  mediumpurple: 0x9370db,
  mediumseagreen: 0x3cb371,
  mediumslateblue: 0x7b68ee,
  mediumspringgreen: 0x00fa9a,
  mediumturquoise: 0x48d1cc,
  mediumvioletred: 0xc71585,
  midnightblue: 0x191970,
  mintcream: 0xf5fffa,
  mistyrose: 0xffe4e1,
  moccasin: 0xffe4b5,
  navajowhite: 0xffdead,
  navy: 0x000080,
  oldlace: 0xfdf5e6,
  olive: 0x808000,
  olivedrab: 0x6b8e23,
  orange: 0xffa500,
  orangered: 0xff4500,
  orchid: 0xda70d6,
  palegoldenrod: 0xeee8aa,
  palegreen: 0x98fb98,
  paleturquoise: 0xafeeee,
  palevioletred: 0xdb7093,
  papayawhip: 0xffefd5,
  peachpuff: 0xffdab9,
  peru: 0xcd853f,
  pink: 0xffc0cb,
  plum: 0xdda0dd,
  powderblue: 0xb0e0e6,
  purple: 0x800080,
  rebeccapurple: 0x663399,
  red: 0xff0000,
  rosybrown: 0xbc8f8f,
  royalblue: 0x4169e1,
  saddlebrown: 0x8b4513,
  salmon: 0xfa8072,
  sandybrown: 0xf4a460,
  seagreen: 0x2e8b57,
  seashell: 0xfff5ee,
  sienna: 0xa0522d,
  silver: 0xc0c0c0,
  skyblue: 0x87ceeb,
  slateblue: 0x6a5acd,
  slategray: 0x708090,
  slategrey: 0x708090,
  snow: 0xfffafa,
  springgreen: 0x00ff7f,
  steelblue: 0x4682b4,
  tan: 0xd2b48c,
  teal: 0x008080,
  thistle: 0xd8bfd8,
  tomato: 0xff6347,
  turquoise: 0x40e0d0,
  violet: 0xee82ee,
  wheat: 0xf5deb3,
  white: 0xffffff,
  whitesmoke: 0xf5f5f5,
  yellow: 0xffff00,
  yellowgreen: 0x9acd32
};

src_define(Color, color, {
  copy: function(channels) {
    return Object.assign(new this.constructor, this, channels);
  },
  displayable: function() {
    return this.rgb().displayable();
  },
  hex: color_formatHex, // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});

function color_formatHex() {
  return this.rgb().formatHex();
}

function color_formatHsl() {
  return hslConvert(this).formatHsl();
}

function color_formatRgb() {
  return this.rgb().formatRgb();
}

function color(format) {
  var m, l;
  format = (format + "").trim().toLowerCase();
  return (m = reHex.exec(format)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) // #ff0000
      : l === 3 ? new Rgb((m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), ((m & 0xf) << 4) | (m & 0xf), 1) // #f00
      : l === 8 ? rgba(m >> 24 & 0xff, m >> 16 & 0xff, m >> 8 & 0xff, (m & 0xff) / 0xff) // #ff000000
      : l === 4 ? rgba((m >> 12 & 0xf) | (m >> 8 & 0xf0), (m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), (((m & 0xf) << 4) | (m & 0xf)) / 0xff) // #f000
      : null) // invalid hex
      : (m = reRgbInteger.exec(format)) ? new Rgb(m[1], m[2], m[3], 1) // rgb(255, 0, 0)
      : (m = reRgbPercent.exec(format)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) // rgb(100%, 0%, 0%)
      : (m = reRgbaInteger.exec(format)) ? rgba(m[1], m[2], m[3], m[4]) // rgba(255, 0, 0, 1)
      : (m = reRgbaPercent.exec(format)) ? rgba(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) // rgb(100%, 0%, 0%, 1)
      : (m = reHslPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) // hsl(120, 50%, 50%)
      : (m = reHslaPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) // hsla(120, 50%, 50%, 1)
      : named.hasOwnProperty(format) ? rgbn(named[format]) // eslint-disable-line no-prototype-builtins
      : format === "transparent" ? new Rgb(NaN, NaN, NaN, 0)
      : null;
}

function rgbn(n) {
  return new Rgb(n >> 16 & 0xff, n >> 8 & 0xff, n & 0xff, 1);
}

function rgba(r, g, b, a) {
  if (a <= 0) r = g = b = NaN;
  return new Rgb(r, g, b, a);
}

function rgbConvert(o) {
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Rgb;
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}

function color_rgb(r, g, b, opacity) {
  return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
}

function Rgb(r, g, b, opacity) {
  this.r = +r;
  this.g = +g;
  this.b = +b;
  this.opacity = +opacity;
}

src_define(Rgb, color_rgb, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  rgb: function() {
    return this;
  },
  displayable: function() {
    return (-0.5 <= this.r && this.r < 255.5)
        && (-0.5 <= this.g && this.g < 255.5)
        && (-0.5 <= this.b && this.b < 255.5)
        && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex, // Deprecated! Use color.formatHex.
  formatHex: rgb_formatHex,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));

function rgb_formatHex() {
  return "#" + hex(this.r) + hex(this.g) + hex(this.b);
}

function rgb_formatRgb() {
  var a = this.opacity; a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
  return (a === 1 ? "rgb(" : "rgba(")
      + Math.max(0, Math.min(255, Math.round(this.r) || 0)) + ", "
      + Math.max(0, Math.min(255, Math.round(this.g) || 0)) + ", "
      + Math.max(0, Math.min(255, Math.round(this.b) || 0))
      + (a === 1 ? ")" : ", " + a + ")");
}

function hex(value) {
  value = Math.max(0, Math.min(255, Math.round(value) || 0));
  return (value < 16 ? "0" : "") + value.toString(16);
}

function hsla(h, s, l, a) {
  if (a <= 0) h = s = l = NaN;
  else if (l <= 0 || l >= 1) h = s = NaN;
  else if (s <= 0) h = NaN;
  return new Hsl(h, s, l, a);
}

function hslConvert(o) {
  if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Hsl;
  if (o instanceof Hsl) return o;
  o = o.rgb();
  var r = o.r / 255,
      g = o.g / 255,
      b = o.b / 255,
      min = Math.min(r, g, b),
      max = Math.max(r, g, b),
      h = NaN,
      s = max - min,
      l = (max + min) / 2;
  if (s) {
    if (r === max) h = (g - b) / s + (g < b) * 6;
    else if (g === max) h = (b - r) / s + 2;
    else h = (r - g) / s + 4;
    s /= l < 0.5 ? max + min : 2 - max - min;
    h *= 60;
  } else {
    s = l > 0 && l < 1 ? 0 : h;
  }
  return new Hsl(h, s, l, o.opacity);
}

function hsl(h, s, l, opacity) {
  return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
}

function Hsl(h, s, l, opacity) {
  this.h = +h;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}

src_define(Hsl, hsl, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  rgb: function() {
    var h = this.h % 360 + (this.h < 0) * 360,
        s = isNaN(h) || isNaN(this.s) ? 0 : this.s,
        l = this.l,
        m2 = l + (l < 0.5 ? l : 1 - l) * s,
        m1 = 2 * l - m2;
    return new Rgb(
      hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
      hsl2rgb(h, m1, m2),
      hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
      this.opacity
    );
  },
  displayable: function() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s))
        && (0 <= this.l && this.l <= 1)
        && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl: function() {
    var a = this.opacity; a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
    return (a === 1 ? "hsl(" : "hsla(")
        + (this.h || 0) + ", "
        + (this.s || 0) * 100 + "%, "
        + (this.l || 0) * 100 + "%"
        + (a === 1 ? ")" : ", " + a + ")");
  }
}));

/* From FvD 13.37, CSS Color Module Level 3 */
function hsl2rgb(h, m1, m2) {
  return (h < 60 ? m1 + (m2 - m1) * h / 60
      : h < 180 ? m2
      : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60
      : m1) * 255;
}

;// CONCATENATED MODULE: ./node_modules/internmap/src/index.js
class InternMap extends Map {
  constructor(entries, key = keyof) {
    super();
    Object.defineProperties(this, {_intern: {value: new Map()}, _key: {value: key}});
    if (entries != null) for (const [key, value] of entries) this.set(key, value);
  }
  get(key) {
    return super.get(intern_get(this, key));
  }
  has(key) {
    return super.has(intern_get(this, key));
  }
  set(key, value) {
    return super.set(intern_set(this, key), value);
  }
  delete(key) {
    return super.delete(intern_delete(this, key));
  }
}

class InternSet extends Set {
  constructor(values, key = keyof) {
    super();
    Object.defineProperties(this, {_intern: {value: new Map()}, _key: {value: key}});
    if (values != null) for (const value of values) this.add(value);
  }
  has(value) {
    return super.has(intern_get(this, value));
  }
  add(value) {
    return super.add(intern_set(this, value));
  }
  delete(value) {
    return super.delete(intern_delete(this, value));
  }
}

function intern_get({_intern, _key}, value) {
  const key = _key(value);
  return _intern.has(key) ? _intern.get(key) : value;
}

function intern_set({_intern, _key}, value) {
  const key = _key(value);
  if (_intern.has(key)) return _intern.get(key);
  _intern.set(key, value);
  return value;
}

function intern_delete({_intern, _key}, value) {
  const key = _key(value);
  if (_intern.has(key)) {
    value = _intern.get(value);
    _intern.delete(key);
  }
  return value;
}

function keyof(value) {
  return value !== null && typeof value === "object" ? value.valueOf() : value;
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/identity.js
/* harmony default export */ function src_identity(x) {
  return x;
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/group.js



function group(values, ...keys) {
  return nest(values, src_identity, src_identity, keys);
}

function groups(values, ...keys) {
  return nest(values, Array.from, identity, keys);
}

function rollup(values, reduce, ...keys) {
  return nest(values, identity, reduce, keys);
}

function rollups(values, reduce, ...keys) {
  return nest(values, Array.from, reduce, keys);
}

function index(values, ...keys) {
  return nest(values, identity, unique, keys);
}

function indexes(values, ...keys) {
  return nest(values, Array.from, unique, keys);
}

function unique(values) {
  if (values.length !== 1) throw new Error("duplicate key");
  return values[0];
}

function nest(values, map, reduce, keys) {
  return (function regroup(values, i) {
    if (i >= keys.length) return reduce(values);
    const groups = new InternMap();
    const keyof = keys[i++];
    let index = -1;
    for (const value of values) {
      const key = keyof(value, ++index, values);
      const group = groups.get(key);
      if (group) group.push(value);
      else groups.set(key, [value]);
    }
    for (const [key, values] of groups) {
      groups.set(key, regroup(values, i));
    }
    return map(groups);
  })(values, 0);
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/max.js
function max(values, valueof) {
  let max;
  if (valueof === undefined) {
    for (const value of values) {
      if (value != null
          && (max < value || (max === undefined && value >= value))) {
        max = value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null
          && (max < value || (max === undefined && value >= value))) {
        max = value;
      }
    }
  }
  return max;
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/min.js
function min(values, valueof) {
  let min;
  if (valueof === undefined) {
    for (const value of values) {
      if (value != null
          && (min > value || (min === undefined && value >= value))) {
        min = value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null
          && (min > value || (min === undefined && value >= value))) {
        min = value;
      }
    }
  }
  return min;
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/sum.js
function sum(values, valueof) {
  let sum = 0;
  if (valueof === undefined) {
    for (let value of values) {
      if (value = +value) {
        sum += value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if (value = +valueof(value, ++index, values)) {
        sum += value;
      }
    }
  }
  return sum;
}

;// CONCATENATED MODULE: ./node_modules/bezier-js/src/utils.js


// math-inlining.
const { abs, cos, sin, acos, atan2, sqrt, pow } = Math;

// cube root function yielding real roots
function crt(v) {
  return v < 0 ? -pow(-v, 1 / 3) : pow(v, 1 / 3);
}

// trig constants
const pi = Math.PI,
  tau = 2 * pi,
  quart = pi / 2,
  // float precision significant decimal
  epsilon = 0.000001,
  // extremas used in bbox calculation and similar algorithms
  nMax = Number.MAX_SAFE_INTEGER || 9007199254740991,
  nMin = Number.MIN_SAFE_INTEGER || -9007199254740991,
  // a zero coordinate, which is surprisingly useful
  ZERO = { x: 0, y: 0, z: 0 };

// Bezier utility functions
const utils = {
  // Legendre-Gauss abscissae with n=24 (x_i values, defined at i=n as the roots of the nth order Legendre polynomial Pn(x))
  Tvalues: [
    -0.0640568928626056260850430826247450385909,
    0.0640568928626056260850430826247450385909,
    -0.1911188674736163091586398207570696318404,
    0.1911188674736163091586398207570696318404,
    -0.3150426796961633743867932913198102407864,
    0.3150426796961633743867932913198102407864,
    -0.4337935076260451384870842319133497124524,
    0.4337935076260451384870842319133497124524,
    -0.5454214713888395356583756172183723700107,
    0.5454214713888395356583756172183723700107,
    -0.6480936519369755692524957869107476266696,
    0.6480936519369755692524957869107476266696,
    -0.7401241915785543642438281030999784255232,
    0.7401241915785543642438281030999784255232,
    -0.8200019859739029219539498726697452080761,
    0.8200019859739029219539498726697452080761,
    -0.8864155270044010342131543419821967550873,
    0.8864155270044010342131543419821967550873,
    -0.9382745520027327585236490017087214496548,
    0.9382745520027327585236490017087214496548,
    -0.9747285559713094981983919930081690617411,
    0.9747285559713094981983919930081690617411,
    -0.9951872199970213601799974097007368118745,
    0.9951872199970213601799974097007368118745,
  ],

  // Legendre-Gauss weights with n=24 (w_i values, defined by a function linked to in the Bezier primer article)
  Cvalues: [
    0.1279381953467521569740561652246953718517,
    0.1279381953467521569740561652246953718517,
    0.1258374563468282961213753825111836887264,
    0.1258374563468282961213753825111836887264,
    0.121670472927803391204463153476262425607,
    0.121670472927803391204463153476262425607,
    0.1155056680537256013533444839067835598622,
    0.1155056680537256013533444839067835598622,
    0.1074442701159656347825773424466062227946,
    0.1074442701159656347825773424466062227946,
    0.0976186521041138882698806644642471544279,
    0.0976186521041138882698806644642471544279,
    0.086190161531953275917185202983742667185,
    0.086190161531953275917185202983742667185,
    0.0733464814110803057340336152531165181193,
    0.0733464814110803057340336152531165181193,
    0.0592985849154367807463677585001085845412,
    0.0592985849154367807463677585001085845412,
    0.0442774388174198061686027482113382288593,
    0.0442774388174198061686027482113382288593,
    0.0285313886289336631813078159518782864491,
    0.0285313886289336631813078159518782864491,
    0.0123412297999871995468056670700372915759,
    0.0123412297999871995468056670700372915759,
  ],

  arcfn: function (t, derivativeFn) {
    const d = derivativeFn(t);
    let l = d.x * d.x + d.y * d.y;
    if (typeof d.z !== "undefined") {
      l += d.z * d.z;
    }
    return sqrt(l);
  },

  compute: function (t, points, _3d) {
    // shortcuts
    if (t === 0) {
      points[0].t = 0;
      return points[0];
    }

    const order = points.length - 1;

    if (t === 1) {
      points[order].t = 1;
      return points[order];
    }

    const mt = 1 - t;
    let p = points;

    // constant?
    if (order === 0) {
      points[0].t = t;
      return points[0];
    }

    // linear?
    if (order === 1) {
      const ret = {
        x: mt * p[0].x + t * p[1].x,
        y: mt * p[0].y + t * p[1].y,
        t: t,
      };
      if (_3d) {
        ret.z = mt * p[0].z + t * p[1].z;
      }
      return ret;
    }

    // quadratic/cubic curve?
    if (order < 4) {
      let mt2 = mt * mt,
        t2 = t * t,
        a,
        b,
        c,
        d = 0;
      if (order === 2) {
        p = [p[0], p[1], p[2], ZERO];
        a = mt2;
        b = mt * t * 2;
        c = t2;
      } else if (order === 3) {
        a = mt2 * mt;
        b = mt2 * t * 3;
        c = mt * t2 * 3;
        d = t * t2;
      }
      const ret = {
        x: a * p[0].x + b * p[1].x + c * p[2].x + d * p[3].x,
        y: a * p[0].y + b * p[1].y + c * p[2].y + d * p[3].y,
        t: t,
      };
      if (_3d) {
        ret.z = a * p[0].z + b * p[1].z + c * p[2].z + d * p[3].z;
      }
      return ret;
    }

    // higher order curves: use de Casteljau's computation
    const dCpts = JSON.parse(JSON.stringify(points));
    while (dCpts.length > 1) {
      for (let i = 0; i < dCpts.length - 1; i++) {
        dCpts[i] = {
          x: dCpts[i].x + (dCpts[i + 1].x - dCpts[i].x) * t,
          y: dCpts[i].y + (dCpts[i + 1].y - dCpts[i].y) * t,
        };
        if (typeof dCpts[i].z !== "undefined") {
          dCpts[i] = dCpts[i].z + (dCpts[i + 1].z - dCpts[i].z) * t;
        }
      }
      dCpts.splice(dCpts.length - 1, 1);
    }
    dCpts[0].t = t;
    return dCpts[0];
  },

  computeWithRatios: function (t, points, ratios, _3d) {
    const mt = 1 - t,
      r = ratios,
      p = points;

    let f1 = r[0],
      f2 = r[1],
      f3 = r[2],
      f4 = r[3],
      d;

    // spec for linear
    f1 *= mt;
    f2 *= t;

    if (p.length === 2) {
      d = f1 + f2;
      return {
        x: (f1 * p[0].x + f2 * p[1].x) / d,
        y: (f1 * p[0].y + f2 * p[1].y) / d,
        z: !_3d ? false : (f1 * p[0].z + f2 * p[1].z) / d,
        t: t,
      };
    }

    // upgrade to quadratic
    f1 *= mt;
    f2 *= 2 * mt;
    f3 *= t * t;

    if (p.length === 3) {
      d = f1 + f2 + f3;
      return {
        x: (f1 * p[0].x + f2 * p[1].x + f3 * p[2].x) / d,
        y: (f1 * p[0].y + f2 * p[1].y + f3 * p[2].y) / d,
        z: !_3d ? false : (f1 * p[0].z + f2 * p[1].z + f3 * p[2].z) / d,
        t: t,
      };
    }

    // upgrade to cubic
    f1 *= mt;
    f2 *= 1.5 * mt;
    f3 *= 3 * mt;
    f4 *= t * t * t;

    if (p.length === 4) {
      d = f1 + f2 + f3 + f4;
      return {
        x: (f1 * p[0].x + f2 * p[1].x + f3 * p[2].x + f4 * p[3].x) / d,
        y: (f1 * p[0].y + f2 * p[1].y + f3 * p[2].y + f4 * p[3].y) / d,
        z: !_3d
          ? false
          : (f1 * p[0].z + f2 * p[1].z + f3 * p[2].z + f4 * p[3].z) / d,
        t: t,
      };
    }
  },

  derive: function (points, _3d) {
    const dpoints = [];
    for (let p = points, d = p.length, c = d - 1; d > 1; d--, c--) {
      const list = [];
      for (let j = 0, dpt; j < c; j++) {
        dpt = {
          x: c * (p[j + 1].x - p[j].x),
          y: c * (p[j + 1].y - p[j].y),
        };
        if (_3d) {
          dpt.z = c * (p[j + 1].z - p[j].z);
        }
        list.push(dpt);
      }
      dpoints.push(list);
      p = list;
    }
    return dpoints;
  },

  between: function (v, m, M) {
    return (
      (m <= v && v <= M) ||
      utils.approximately(v, m) ||
      utils.approximately(v, M)
    );
  },

  approximately: function (a, b, precision) {
    return abs(a - b) <= (precision || epsilon);
  },

  length: function (derivativeFn) {
    const z = 0.5,
      len = utils.Tvalues.length;

    let sum = 0;

    for (let i = 0, t; i < len; i++) {
      t = z * utils.Tvalues[i] + z;
      sum += utils.Cvalues[i] * utils.arcfn(t, derivativeFn);
    }
    return z * sum;
  },

  map: function (v, ds, de, ts, te) {
    const d1 = de - ds,
      d2 = te - ts,
      v2 = v - ds,
      r = v2 / d1;
    return ts + d2 * r;
  },

  lerp: function (r, v1, v2) {
    const ret = {
      x: v1.x + r * (v2.x - v1.x),
      y: v1.y + r * (v2.y - v1.y),
    };
    if (!!v1.z && !!v2.z) {
      ret.z = v1.z + r * (v2.z - v1.z);
    }
    return ret;
  },

  pointToString: function (p) {
    let s = p.x + "/" + p.y;
    if (typeof p.z !== "undefined") {
      s += "/" + p.z;
    }
    return s;
  },

  pointsToString: function (points) {
    return "[" + points.map(utils.pointToString).join(", ") + "]";
  },

  copy: function (obj) {
    return JSON.parse(JSON.stringify(obj));
  },

  angle: function (o, v1, v2) {
    const dx1 = v1.x - o.x,
      dy1 = v1.y - o.y,
      dx2 = v2.x - o.x,
      dy2 = v2.y - o.y,
      cross = dx1 * dy2 - dy1 * dx2,
      dot = dx1 * dx2 + dy1 * dy2;
    return atan2(cross, dot);
  },

  // round as string, to avoid rounding errors
  round: function (v, d) {
    const s = "" + v;
    const pos = s.indexOf(".");
    return parseFloat(s.substring(0, pos + 1 + d));
  },

  dist: function (p1, p2) {
    const dx = p1.x - p2.x,
      dy = p1.y - p2.y;
    return sqrt(dx * dx + dy * dy);
  },

  closest: function (LUT, point) {
    let mdist = pow(2, 63),
      mpos,
      d;
    LUT.forEach(function (p, idx) {
      d = utils.dist(point, p);
      if (d < mdist) {
        mdist = d;
        mpos = idx;
      }
    });
    return { mdist: mdist, mpos: mpos };
  },

  abcratio: function (t, n) {
    // see ratio(t) note on http://pomax.github.io/bezierinfo/#abc
    if (n !== 2 && n !== 3) {
      return false;
    }
    if (typeof t === "undefined") {
      t = 0.5;
    } else if (t === 0 || t === 1) {
      return t;
    }
    const bottom = pow(t, n) + pow(1 - t, n),
      top = bottom - 1;
    return abs(top / bottom);
  },

  projectionratio: function (t, n) {
    // see u(t) note on http://pomax.github.io/bezierinfo/#abc
    if (n !== 2 && n !== 3) {
      return false;
    }
    if (typeof t === "undefined") {
      t = 0.5;
    } else if (t === 0 || t === 1) {
      return t;
    }
    const top = pow(1 - t, n),
      bottom = pow(t, n) + top;
    return top / bottom;
  },

  lli8: function (x1, y1, x2, y2, x3, y3, x4, y4) {
    const nx =
        (x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4),
      ny = (x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4),
      d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
    if (d == 0) {
      return false;
    }
    return { x: nx / d, y: ny / d };
  },

  lli4: function (p1, p2, p3, p4) {
    const x1 = p1.x,
      y1 = p1.y,
      x2 = p2.x,
      y2 = p2.y,
      x3 = p3.x,
      y3 = p3.y,
      x4 = p4.x,
      y4 = p4.y;
    return utils.lli8(x1, y1, x2, y2, x3, y3, x4, y4);
  },

  lli: function (v1, v2) {
    return utils.lli4(v1, v1.c, v2, v2.c);
  },

  makeline: function (p1, p2) {
    const x1 = p1.x,
      y1 = p1.y,
      x2 = p2.x,
      y2 = p2.y,
      dx = (x2 - x1) / 3,
      dy = (y2 - y1) / 3;
    return new Bezier(
      x1,
      y1,
      x1 + dx,
      y1 + dy,
      x1 + 2 * dx,
      y1 + 2 * dy,
      x2,
      y2
    );
  },

  findbbox: function (sections) {
    let mx = nMax,
      my = nMax,
      MX = nMin,
      MY = nMin;
    sections.forEach(function (s) {
      const bbox = s.bbox();
      if (mx > bbox.x.min) mx = bbox.x.min;
      if (my > bbox.y.min) my = bbox.y.min;
      if (MX < bbox.x.max) MX = bbox.x.max;
      if (MY < bbox.y.max) MY = bbox.y.max;
    });
    return {
      x: { min: mx, mid: (mx + MX) / 2, max: MX, size: MX - mx },
      y: { min: my, mid: (my + MY) / 2, max: MY, size: MY - my },
    };
  },

  shapeintersections: function (
    s1,
    bbox1,
    s2,
    bbox2,
    curveIntersectionThreshold
  ) {
    if (!utils.bboxoverlap(bbox1, bbox2)) return [];
    const intersections = [];
    const a1 = [s1.startcap, s1.forward, s1.back, s1.endcap];
    const a2 = [s2.startcap, s2.forward, s2.back, s2.endcap];
    a1.forEach(function (l1) {
      if (l1.virtual) return;
      a2.forEach(function (l2) {
        if (l2.virtual) return;
        const iss = l1.intersects(l2, curveIntersectionThreshold);
        if (iss.length > 0) {
          iss.c1 = l1;
          iss.c2 = l2;
          iss.s1 = s1;
          iss.s2 = s2;
          intersections.push(iss);
        }
      });
    });
    return intersections;
  },

  makeshape: function (forward, back, curveIntersectionThreshold) {
    const bpl = back.points.length;
    const fpl = forward.points.length;
    const start = utils.makeline(back.points[bpl - 1], forward.points[0]);
    const end = utils.makeline(forward.points[fpl - 1], back.points[0]);
    const shape = {
      startcap: start,
      forward: forward,
      back: back,
      endcap: end,
      bbox: utils.findbbox([start, forward, back, end]),
    };
    shape.intersections = function (s2) {
      return utils.shapeintersections(
        shape,
        shape.bbox,
        s2,
        s2.bbox,
        curveIntersectionThreshold
      );
    };
    return shape;
  },

  getminmax: function (curve, d, list) {
    if (!list) return { min: 0, max: 0 };
    let min = nMax,
      max = nMin,
      t,
      c;
    if (list.indexOf(0) === -1) {
      list = [0].concat(list);
    }
    if (list.indexOf(1) === -1) {
      list.push(1);
    }
    for (let i = 0, len = list.length; i < len; i++) {
      t = list[i];
      c = curve.get(t);
      if (c[d] < min) {
        min = c[d];
      }
      if (c[d] > max) {
        max = c[d];
      }
    }
    return { min: min, mid: (min + max) / 2, max: max, size: max - min };
  },

  align: function (points, line) {
    const tx = line.p1.x,
      ty = line.p1.y,
      a = -atan2(line.p2.y - ty, line.p2.x - tx),
      d = function (v) {
        return {
          x: (v.x - tx) * cos(a) - (v.y - ty) * sin(a),
          y: (v.x - tx) * sin(a) + (v.y - ty) * cos(a),
        };
      };
    return points.map(d);
  },

  roots: function (points, line) {
    line = line || { p1: { x: 0, y: 0 }, p2: { x: 1, y: 0 } };

    const order = points.length - 1;
    const aligned = utils.align(points, line);
    const reduce = function (t) {
      return 0 <= t && t <= 1;
    };

    if (order === 2) {
      const a = aligned[0].y,
        b = aligned[1].y,
        c = aligned[2].y,
        d = a - 2 * b + c;
      if (d !== 0) {
        const m1 = -sqrt(b * b - a * c),
          m2 = -a + b,
          v1 = -(m1 + m2) / d,
          v2 = -(-m1 + m2) / d;
        return [v1, v2].filter(reduce);
      } else if (b !== c && d === 0) {
        return [(2 * b - c) / (2 * b - 2 * c)].filter(reduce);
      }
      return [];
    }

    // see http://www.trans4mind.com/personal_development/mathematics/polynomials/cubicAlgebra.htm
    const pa = aligned[0].y,
      pb = aligned[1].y,
      pc = aligned[2].y,
      pd = aligned[3].y;

    let d = -pa + 3 * pb - 3 * pc + pd,
      a = 3 * pa - 6 * pb + 3 * pc,
      b = -3 * pa + 3 * pb,
      c = pa;

    if (utils.approximately(d, 0)) {
      // this is not a cubic curve.
      if (utils.approximately(a, 0)) {
        // in fact, this is not a quadratic curve either.
        if (utils.approximately(b, 0)) {
          // in fact in fact, there are no solutions.
          return [];
        }
        // linear solution:
        return [-c / b].filter(reduce);
      }
      // quadratic solution:
      const q = sqrt(b * b - 4 * a * c),
        a2 = 2 * a;
      return [(q - b) / a2, (-b - q) / a2].filter(reduce);
    }

    // at this point, we know we need a cubic solution:

    a /= d;
    b /= d;
    c /= d;

    const p = (3 * b - a * a) / 3,
      p3 = p / 3,
      q = (2 * a * a * a - 9 * a * b + 27 * c) / 27,
      q2 = q / 2,
      discriminant = q2 * q2 + p3 * p3 * p3;

    let u1, v1, x1, x2, x3;
    if (discriminant < 0) {
      const mp3 = -p / 3,
        mp33 = mp3 * mp3 * mp3,
        r = sqrt(mp33),
        t = -q / (2 * r),
        cosphi = t < -1 ? -1 : t > 1 ? 1 : t,
        phi = acos(cosphi),
        crtr = crt(r),
        t1 = 2 * crtr;
      x1 = t1 * cos(phi / 3) - a / 3;
      x2 = t1 * cos((phi + tau) / 3) - a / 3;
      x3 = t1 * cos((phi + 2 * tau) / 3) - a / 3;
      return [x1, x2, x3].filter(reduce);
    } else if (discriminant === 0) {
      u1 = q2 < 0 ? crt(-q2) : -crt(q2);
      x1 = 2 * u1 - a / 3;
      x2 = -u1 - a / 3;
      return [x1, x2].filter(reduce);
    } else {
      const sd = sqrt(discriminant);
      u1 = crt(-q2 + sd);
      v1 = crt(q2 + sd);
      return [u1 - v1 - a / 3].filter(reduce);
    }
  },

  droots: function (p) {
    // quadratic roots are easy
    if (p.length === 3) {
      const a = p[0],
        b = p[1],
        c = p[2],
        d = a - 2 * b + c;
      if (d !== 0) {
        const m1 = -sqrt(b * b - a * c),
          m2 = -a + b,
          v1 = -(m1 + m2) / d,
          v2 = -(-m1 + m2) / d;
        return [v1, v2];
      } else if (b !== c && d === 0) {
        return [(2 * b - c) / (2 * (b - c))];
      }
      return [];
    }

    // linear roots are even easier
    if (p.length === 2) {
      const a = p[0],
        b = p[1];
      if (a !== b) {
        return [a / (a - b)];
      }
      return [];
    }

    return [];
  },

  curvature: function (t, d1, d2, _3d, kOnly) {
    let num,
      dnm,
      adk,
      dk,
      k = 0,
      r = 0;

    //
    // We're using the following formula for curvature:
    //
    //              x'y" - y'x"
    //   k(t) = ------------------
    //           (x'² + y'²)^(3/2)
    //
    // from https://en.wikipedia.org/wiki/Radius_of_curvature#Definition
    //
    // With it corresponding 3D counterpart:
    //
    //          sqrt( (y'z" - y"z')² + (z'x" - z"x')² + (x'y" - x"y')²)
    //   k(t) = -------------------------------------------------------
    //                     (x'² + y'² + z'²)^(3/2)
    //

    const d = utils.compute(t, d1);
    const dd = utils.compute(t, d2);
    const qdsum = d.x * d.x + d.y * d.y;

    if (_3d) {
      num = sqrt(
        pow(d.y * dd.z - dd.y * d.z, 2) +
          pow(d.z * dd.x - dd.z * d.x, 2) +
          pow(d.x * dd.y - dd.x * d.y, 2)
      );
      dnm = pow(qdsum + d.z * d.z, 3 / 2);
    } else {
      num = d.x * dd.y - d.y * dd.x;
      dnm = pow(qdsum, 3 / 2);
    }

    if (num === 0 || dnm === 0) {
      return { k: 0, r: 0 };
    }

    k = num / dnm;
    r = dnm / num;

    // We're also computing the derivative of kappa, because
    // there is value in knowing the rate of change for the
    // curvature along the curve. And we're just going to
    // ballpark it based on an epsilon.
    if (!kOnly) {
      // compute k'(t) based on the interval before, and after it,
      // to at least try to not introduce forward/backward pass bias.
      const pk = utils.curvature(t - 0.001, d1, d2, _3d, true).k;
      const nk = utils.curvature(t + 0.001, d1, d2, _3d, true).k;
      dk = (nk - k + (k - pk)) / 2;
      adk = (abs(nk - k) + abs(k - pk)) / 2;
    }

    return { k: k, r: r, dk: dk, adk: adk };
  },

  inflections: function (points) {
    if (points.length < 4) return [];

    // FIXME: TODO: add in inflection abstraction for quartic+ curves?

    const p = utils.align(points, { p1: points[0], p2: points.slice(-1)[0] }),
      a = p[2].x * p[1].y,
      b = p[3].x * p[1].y,
      c = p[1].x * p[2].y,
      d = p[3].x * p[2].y,
      v1 = 18 * (-3 * a + 2 * b + 3 * c - d),
      v2 = 18 * (3 * a - b - 3 * c),
      v3 = 18 * (c - a);

    if (utils.approximately(v1, 0)) {
      if (!utils.approximately(v2, 0)) {
        let t = -v3 / v2;
        if (0 <= t && t <= 1) return [t];
      }
      return [];
    }

    const trm = v2 * v2 - 4 * v1 * v3,
      sq = Math.sqrt(trm),
      d2 = 2 * v1;

    if (utils.approximately(d2, 0)) return [];

    return [(sq - v2) / d2, -(v2 + sq) / d2].filter(function (r) {
      return 0 <= r && r <= 1;
    });
  },

  bboxoverlap: function (b1, b2) {
    const dims = ["x", "y"],
      len = dims.length;

    for (let i = 0, dim, l, t, d; i < len; i++) {
      dim = dims[i];
      l = b1[dim].mid;
      t = b2[dim].mid;
      d = (b1[dim].size + b2[dim].size) / 2;
      if (abs(l - t) >= d) return false;
    }
    return true;
  },

  expandbox: function (bbox, _bbox) {
    if (_bbox.x.min < bbox.x.min) {
      bbox.x.min = _bbox.x.min;
    }
    if (_bbox.y.min < bbox.y.min) {
      bbox.y.min = _bbox.y.min;
    }
    if (_bbox.z && _bbox.z.min < bbox.z.min) {
      bbox.z.min = _bbox.z.min;
    }
    if (_bbox.x.max > bbox.x.max) {
      bbox.x.max = _bbox.x.max;
    }
    if (_bbox.y.max > bbox.y.max) {
      bbox.y.max = _bbox.y.max;
    }
    if (_bbox.z && _bbox.z.max > bbox.z.max) {
      bbox.z.max = _bbox.z.max;
    }
    bbox.x.mid = (bbox.x.min + bbox.x.max) / 2;
    bbox.y.mid = (bbox.y.min + bbox.y.max) / 2;
    if (bbox.z) {
      bbox.z.mid = (bbox.z.min + bbox.z.max) / 2;
    }
    bbox.x.size = bbox.x.max - bbox.x.min;
    bbox.y.size = bbox.y.max - bbox.y.min;
    if (bbox.z) {
      bbox.z.size = bbox.z.max - bbox.z.min;
    }
  },

  pairiteration: function (c1, c2, curveIntersectionThreshold) {
    const c1b = c1.bbox(),
      c2b = c2.bbox(),
      r = 100000,
      threshold = curveIntersectionThreshold || 0.5;

    if (
      c1b.x.size + c1b.y.size < threshold &&
      c2b.x.size + c2b.y.size < threshold
    ) {
      return [
        (((r * (c1._t1 + c1._t2)) / 2) | 0) / r +
          "/" +
          (((r * (c2._t1 + c2._t2)) / 2) | 0) / r,
      ];
    }

    let cc1 = c1.split(0.5),
      cc2 = c2.split(0.5),
      pairs = [
        { left: cc1.left, right: cc2.left },
        { left: cc1.left, right: cc2.right },
        { left: cc1.right, right: cc2.right },
        { left: cc1.right, right: cc2.left },
      ];

    pairs = pairs.filter(function (pair) {
      return utils.bboxoverlap(pair.left.bbox(), pair.right.bbox());
    });

    let results = [];

    if (pairs.length === 0) return results;

    pairs.forEach(function (pair) {
      results = results.concat(
        utils.pairiteration(pair.left, pair.right, threshold)
      );
    });

    results = results.filter(function (v, i) {
      return results.indexOf(v) === i;
    });

    return results;
  },

  getccenter: function (p1, p2, p3) {
    const dx1 = p2.x - p1.x,
      dy1 = p2.y - p1.y,
      dx2 = p3.x - p2.x,
      dy2 = p3.y - p2.y,
      dx1p = dx1 * cos(quart) - dy1 * sin(quart),
      dy1p = dx1 * sin(quart) + dy1 * cos(quart),
      dx2p = dx2 * cos(quart) - dy2 * sin(quart),
      dy2p = dx2 * sin(quart) + dy2 * cos(quart),
      // chord midpoints
      mx1 = (p1.x + p2.x) / 2,
      my1 = (p1.y + p2.y) / 2,
      mx2 = (p2.x + p3.x) / 2,
      my2 = (p2.y + p3.y) / 2,
      // midpoint offsets
      mx1n = mx1 + dx1p,
      my1n = my1 + dy1p,
      mx2n = mx2 + dx2p,
      my2n = my2 + dy2p,
      // intersection of these lines:
      arc = utils.lli8(mx1, my1, mx1n, my1n, mx2, my2, mx2n, my2n),
      r = utils.dist(arc, p1);

    // arc start/end values, over mid point:
    let s = atan2(p1.y - arc.y, p1.x - arc.x),
      m = atan2(p2.y - arc.y, p2.x - arc.x),
      e = atan2(p3.y - arc.y, p3.x - arc.x),
      _;

    // determine arc direction (cw/ccw correction)
    if (s < e) {
      // if s<m<e, arc(s, e)
      // if m<s<e, arc(e, s + tau)
      // if s<e<m, arc(e, s + tau)
      if (s > m || m > e) {
        s += tau;
      }
      if (s > e) {
        _ = e;
        e = s;
        s = _;
      }
    } else {
      // if e<m<s, arc(e, s)
      // if m<e<s, arc(s, e + tau)
      // if e<s<m, arc(s, e + tau)
      if (e < m && m < s) {
        _ = e;
        e = s;
        s = _;
      } else {
        e += tau;
      }
    }
    // assign and done.
    arc.s = s;
    arc.e = e;
    arc.r = r;
    return arc;
  },

  numberSort: function (a, b) {
    return a - b;
  },
};



;// CONCATENATED MODULE: ./node_modules/bezier-js/src/poly-bezier.js


/**
 * Poly Bezier
 * @param {[type]} curves [description]
 */
class PolyBezier {
  constructor(curves) {
    this.curves = [];
    this._3d = false;
    if (!!curves) {
      this.curves = curves;
      this._3d = this.curves[0]._3d;
    }
  }

  valueOf() {
    return this.toString();
  }

  toString() {
    return (
      "[" +
      this.curves
        .map(function (curve) {
          return utils.pointsToString(curve.points);
        })
        .join(", ") +
      "]"
    );
  }

  addCurve(curve) {
    this.curves.push(curve);
    this._3d = this._3d || curve._3d;
  }

  length() {
    return this.curves
      .map(function (v) {
        return v.length();
      })
      .reduce(function (a, b) {
        return a + b;
      });
  }

  curve(idx) {
    return this.curves[idx];
  }

  bbox() {
    const c = this.curves;
    var bbox = c[0].bbox();
    for (var i = 1; i < c.length; i++) {
      utils.expandbox(bbox, c[i].bbox());
    }
    return bbox;
  }

  offset(d) {
    const offset = [];
    this.curves.forEach(function (v) {
      offset.push(...v.offset(d));
    });
    return new PolyBezier(offset);
  }
}



;// CONCATENATED MODULE: ./node_modules/bezier-js/src/bezier.js
/**
  A javascript Bezier curve library by Pomax.

  Based on http://pomax.github.io/bezierinfo

  This code is MIT licensed.
**/




// math-inlining.
const { abs: bezier_abs, min: bezier_min, max: bezier_max, cos: bezier_cos, sin: bezier_sin, acos: bezier_acos, sqrt: bezier_sqrt } = Math;
const bezier_pi = Math.PI;
// a zero coordinate, which is surprisingly useful
const bezier_ZERO = { x: 0, y: 0, z: 0 };

/**
 * Bezier curve constructor.
 *
 * ...docs pending...
 */
class Bezier {
  constructor(coords) {
    let args =
      coords && coords.forEach ? coords : Array.from(arguments).slice();
    let coordlen = false;

    if (typeof args[0] === "object") {
      coordlen = args.length;
      const newargs = [];
      args.forEach(function (point) {
        ["x", "y", "z"].forEach(function (d) {
          if (typeof point[d] !== "undefined") {
            newargs.push(point[d]);
          }
        });
      });
      args = newargs;
    }

    let higher = false;
    const len = args.length;

    if (coordlen) {
      if (coordlen > 4) {
        if (arguments.length !== 1) {
          throw new Error(
            "Only new Bezier(point[]) is accepted for 4th and higher order curves"
          );
        }
        higher = true;
      }
    } else {
      if (len !== 6 && len !== 8 && len !== 9 && len !== 12) {
        if (arguments.length !== 1) {
          throw new Error(
            "Only new Bezier(point[]) is accepted for 4th and higher order curves"
          );
        }
      }
    }

    const _3d = (this._3d =
      (!higher && (len === 9 || len === 12)) ||
      (coords && coords[0] && typeof coords[0].z !== "undefined"));

    const points = (this.points = []);
    for (let idx = 0, step = _3d ? 3 : 2; idx < len; idx += step) {
      var point = {
        x: args[idx],
        y: args[idx + 1],
      };
      if (_3d) {
        point.z = args[idx + 2];
      }
      points.push(point);
    }
    const order = (this.order = points.length - 1);

    const dims = (this.dims = ["x", "y"]);
    if (_3d) dims.push("z");
    this.dimlen = dims.length;

    const aligned = utils.align(points, { p1: points[0], p2: points[order] });
    this._linear = !aligned.some((p) => bezier_abs(p.y) > 0.0001);

    this._lut = [];

    this._t1 = 0;
    this._t2 = 1;
    this.update();
  }

  static quadraticFromPoints(p1, p2, p3, t) {
    if (typeof t === "undefined") {
      t = 0.5;
    }
    // shortcuts, although they're really dumb
    if (t === 0) {
      return new Bezier(p2, p2, p3);
    }
    if (t === 1) {
      return new Bezier(p1, p2, p2);
    }
    // real fitting.
    const abc = Bezier.getABC(2, p1, p2, p3, t);
    return new Bezier(p1, abc.A, p3);
  }

  static cubicFromPoints(S, B, E, t, d1) {
    if (typeof t === "undefined") {
      t = 0.5;
    }
    const abc = Bezier.getABC(3, S, B, E, t);
    if (typeof d1 === "undefined") {
      d1 = utils.dist(B, abc.C);
    }
    const d2 = (d1 * (1 - t)) / t;

    const selen = utils.dist(S, E),
      lx = (E.x - S.x) / selen,
      ly = (E.y - S.y) / selen,
      bx1 = d1 * lx,
      by1 = d1 * ly,
      bx2 = d2 * lx,
      by2 = d2 * ly;
    // derivation of new hull coordinates
    const e1 = { x: B.x - bx1, y: B.y - by1 },
      e2 = { x: B.x + bx2, y: B.y + by2 },
      A = abc.A,
      v1 = { x: A.x + (e1.x - A.x) / (1 - t), y: A.y + (e1.y - A.y) / (1 - t) },
      v2 = { x: A.x + (e2.x - A.x) / t, y: A.y + (e2.y - A.y) / t },
      nc1 = { x: S.x + (v1.x - S.x) / t, y: S.y + (v1.y - S.y) / t },
      nc2 = {
        x: E.x + (v2.x - E.x) / (1 - t),
        y: E.y + (v2.y - E.y) / (1 - t),
      };
    // ...done
    return new Bezier(S, nc1, nc2, E);
  }

  static getUtils() {
    return utils;
  }

  getUtils() {
    return Bezier.getUtils();
  }

  static get PolyBezier() {
    return PolyBezier;
  }

  valueOf() {
    return this.toString();
  }

  toString() {
    return utils.pointsToString(this.points);
  }

  toSVG() {
    if (this._3d) return false;
    const p = this.points,
      x = p[0].x,
      y = p[0].y,
      s = ["M", x, y, this.order === 2 ? "Q" : "C"];
    for (let i = 1, last = p.length; i < last; i++) {
      s.push(p[i].x);
      s.push(p[i].y);
    }
    return s.join(" ");
  }

  setRatios(ratios) {
    if (ratios.length !== this.points.length) {
      throw new Error("incorrect number of ratio values");
    }
    this.ratios = ratios;
    this._lut = []; //  invalidate any precomputed LUT
  }

  verify() {
    const print = this.coordDigest();
    if (print !== this._print) {
      this._print = print;
      this.update();
    }
  }

  coordDigest() {
    return this.points
      .map(function (c, pos) {
        return "" + pos + c.x + c.y + (c.z ? c.z : 0);
      })
      .join("");
  }

  update() {
    // invalidate any precomputed LUT
    this._lut = [];
    this.dpoints = utils.derive(this.points, this._3d);
    this.computedirection();
  }

  computedirection() {
    const points = this.points;
    const angle = utils.angle(points[0], points[this.order], points[1]);
    this.clockwise = angle > 0;
  }

  length() {
    return utils.length(this.derivative.bind(this));
  }

  static getABC(order = 2, S, B, E, t = 0.5) {
    const u = utils.projectionratio(t, order),
      um = 1 - u,
      C = {
        x: u * S.x + um * E.x,
        y: u * S.y + um * E.y,
      },
      s = utils.abcratio(t, order),
      A = {
        x: B.x + (B.x - C.x) / s,
        y: B.y + (B.y - C.y) / s,
      };
    return { A, B, C, S, E };
  }

  getABC(t, B) {
    B = B || this.get(t);
    let S = this.points[0];
    let E = this.points[this.order];
    return Bezier.getABC(this.order, S, B, E, t);
  }

  getLUT(steps) {
    this.verify();
    steps = steps || 100;
    if (this._lut.length === steps) {
      return this._lut;
    }
    this._lut = [];
    // We want a range from 0 to 1 inclusive, so
    // we decrement and then use <= rather than <:
    steps--;
    for (let i = 0, p, t; i < steps; i++) {
      t = i / (steps - 1);
      p = this.compute(t);
      p.t = t;
      this._lut.push(p);
    }
    return this._lut;
  }

  on(point, error) {
    error = error || 5;
    const lut = this.getLUT(),
      hits = [];
    for (let i = 0, c, t = 0; i < lut.length; i++) {
      c = lut[i];
      if (utils.dist(c, point) < error) {
        hits.push(c);
        t += i / lut.length;
      }
    }
    if (!hits.length) return false;
    return (t /= hits.length);
  }

  project(point) {
    // step 1: coarse check
    const LUT = this.getLUT(),
      l = LUT.length - 1,
      closest = utils.closest(LUT, point),
      mpos = closest.mpos,
      t1 = (mpos - 1) / l,
      t2 = (mpos + 1) / l,
      step = 0.1 / l;

    // step 2: fine check
    let mdist = closest.mdist,
      t = t1,
      ft = t,
      p;
    mdist += 1;
    for (let d; t < t2 + step; t += step) {
      p = this.compute(t);
      d = utils.dist(point, p);
      if (d < mdist) {
        mdist = d;
        ft = t;
      }
    }
    ft = ft < 0 ? 0 : ft > 1 ? 1 : ft;
    p = this.compute(ft);
    p.t = ft;
    p.d = mdist;
    return p;
  }

  get(t) {
    return this.compute(t);
  }

  point(idx) {
    return this.points[idx];
  }

  compute(t) {
    if (this.ratios) {
      return utils.computeWithRatios(t, this.points, this.ratios, this._3d);
    }
    return utils.compute(t, this.points, this._3d, this.ratios);
  }

  raise() {
    const p = this.points,
      np = [p[0]],
      k = p.length;
    for (let i = 1, pi, pim; i < k; i++) {
      pi = p[i];
      pim = p[i - 1];
      np[i] = {
        x: ((k - i) / k) * pi.x + (i / k) * pim.x,
        y: ((k - i) / k) * pi.y + (i / k) * pim.y,
      };
    }
    np[k] = p[k - 1];
    return new Bezier(np);
  }

  derivative(t) {
    return utils.compute(t, this.dpoints[0]);
  }

  dderivative(t) {
    return utils.compute(t, this.dpoints[1]);
  }

  align() {
    let p = this.points;
    return new Bezier(utils.align(p, { p1: p[0], p2: p[p.length - 1] }));
  }

  curvature(t) {
    return utils.curvature(t, this.dpoints[0], this.dpoints[1], this._3d);
  }

  inflections() {
    return utils.inflections(this.points);
  }

  normal(t) {
    return this._3d ? this.__normal3(t) : this.__normal2(t);
  }

  __normal2(t) {
    const d = this.derivative(t);
    const q = bezier_sqrt(d.x * d.x + d.y * d.y);
    return { x: -d.y / q, y: d.x / q };
  }

  __normal3(t) {
    // see http://stackoverflow.com/questions/25453159
    const r1 = this.derivative(t),
      r2 = this.derivative(t + 0.01),
      q1 = bezier_sqrt(r1.x * r1.x + r1.y * r1.y + r1.z * r1.z),
      q2 = bezier_sqrt(r2.x * r2.x + r2.y * r2.y + r2.z * r2.z);
    r1.x /= q1;
    r1.y /= q1;
    r1.z /= q1;
    r2.x /= q2;
    r2.y /= q2;
    r2.z /= q2;
    // cross product
    const c = {
      x: r2.y * r1.z - r2.z * r1.y,
      y: r2.z * r1.x - r2.x * r1.z,
      z: r2.x * r1.y - r2.y * r1.x,
    };
    const m = bezier_sqrt(c.x * c.x + c.y * c.y + c.z * c.z);
    c.x /= m;
    c.y /= m;
    c.z /= m;
    // rotation matrix
    const R = [
      c.x * c.x,
      c.x * c.y - c.z,
      c.x * c.z + c.y,
      c.x * c.y + c.z,
      c.y * c.y,
      c.y * c.z - c.x,
      c.x * c.z - c.y,
      c.y * c.z + c.x,
      c.z * c.z,
    ];
    // normal vector:
    const n = {
      x: R[0] * r1.x + R[1] * r1.y + R[2] * r1.z,
      y: R[3] * r1.x + R[4] * r1.y + R[5] * r1.z,
      z: R[6] * r1.x + R[7] * r1.y + R[8] * r1.z,
    };
    return n;
  }

  hull(t) {
    let p = this.points,
      _p = [],
      q = [],
      idx = 0;
    q[idx++] = p[0];
    q[idx++] = p[1];
    q[idx++] = p[2];
    if (this.order === 3) {
      q[idx++] = p[3];
    }
    // we lerp between all points at each iteration, until we have 1 point left.
    while (p.length > 1) {
      _p = [];
      for (let i = 0, pt, l = p.length - 1; i < l; i++) {
        pt = utils.lerp(t, p[i], p[i + 1]);
        q[idx++] = pt;
        _p.push(pt);
      }
      p = _p;
    }
    return q;
  }

  split(t1, t2) {
    // shortcuts
    if (t1 === 0 && !!t2) {
      return this.split(t2).left;
    }
    if (t2 === 1) {
      return this.split(t1).right;
    }

    // no shortcut: use "de Casteljau" iteration.
    const q = this.hull(t1);
    const result = {
      left:
        this.order === 2
          ? new Bezier([q[0], q[3], q[5]])
          : new Bezier([q[0], q[4], q[7], q[9]]),
      right:
        this.order === 2
          ? new Bezier([q[5], q[4], q[2]])
          : new Bezier([q[9], q[8], q[6], q[3]]),
      span: q,
    };

    // make sure we bind _t1/_t2 information!
    result.left._t1 = utils.map(0, 0, 1, this._t1, this._t2);
    result.left._t2 = utils.map(t1, 0, 1, this._t1, this._t2);
    result.right._t1 = utils.map(t1, 0, 1, this._t1, this._t2);
    result.right._t2 = utils.map(1, 0, 1, this._t1, this._t2);

    // if we have no t2, we're done
    if (!t2) {
      return result;
    }

    // if we have a t2, split again:
    t2 = utils.map(t2, t1, 1, 0, 1);
    return result.right.split(t2).left;
  }

  extrema() {
    const result = {};
    let roots = [];

    this.dims.forEach(
      function (dim) {
        let mfn = function (v) {
          return v[dim];
        };
        let p = this.dpoints[0].map(mfn);
        result[dim] = utils.droots(p);
        if (this.order === 3) {
          p = this.dpoints[1].map(mfn);
          result[dim] = result[dim].concat(utils.droots(p));
        }
        result[dim] = result[dim].filter(function (t) {
          return t >= 0 && t <= 1;
        });
        roots = roots.concat(result[dim].sort(utils.numberSort));
      }.bind(this)
    );

    result.values = roots.sort(utils.numberSort).filter(function (v, idx) {
      return roots.indexOf(v) === idx;
    });

    return result;
  }

  bbox() {
    const extrema = this.extrema(),
      result = {};
    this.dims.forEach(
      function (d) {
        result[d] = utils.getminmax(this, d, extrema[d]);
      }.bind(this)
    );
    return result;
  }

  overlaps(curve) {
    const lbbox = this.bbox(),
      tbbox = curve.bbox();
    return utils.bboxoverlap(lbbox, tbbox);
  }

  offset(t, d) {
    if (typeof d !== "undefined") {
      const c = this.get(t),
        n = this.normal(t);
      const ret = {
        c: c,
        n: n,
        x: c.x + n.x * d,
        y: c.y + n.y * d,
      };
      if (this._3d) {
        ret.z = c.z + n.z * d;
      }
      return ret;
    }
    if (this._linear) {
      const nv = this.normal(0),
        coords = this.points.map(function (p) {
          const ret = {
            x: p.x + t * nv.x,
            y: p.y + t * nv.y,
          };
          if (p.z && nv.z) {
            ret.z = p.z + t * nv.z;
          }
          return ret;
        });
      return [new Bezier(coords)];
    }
    return this.reduce().map(function (s) {
      if (s._linear) {
        return s.offset(t)[0];
      }
      return s.scale(t);
    });
  }

  simple() {
    if (this.order === 3) {
      const a1 = utils.angle(this.points[0], this.points[3], this.points[1]);
      const a2 = utils.angle(this.points[0], this.points[3], this.points[2]);
      if ((a1 > 0 && a2 < 0) || (a1 < 0 && a2 > 0)) return false;
    }
    const n1 = this.normal(0);
    const n2 = this.normal(1);
    let s = n1.x * n2.x + n1.y * n2.y;
    if (this._3d) {
      s += n1.z * n2.z;
    }
    return bezier_abs(bezier_acos(s)) < bezier_pi / 3;
  }

  reduce() {
    // TODO: examine these var types in more detail...
    let i,
      t1 = 0,
      t2 = 0,
      step = 0.01,
      segment,
      pass1 = [],
      pass2 = [];
    // first pass: split on extrema
    let extrema = this.extrema().values;
    if (extrema.indexOf(0) === -1) {
      extrema = [0].concat(extrema);
    }
    if (extrema.indexOf(1) === -1) {
      extrema.push(1);
    }

    for (t1 = extrema[0], i = 1; i < extrema.length; i++) {
      t2 = extrema[i];
      segment = this.split(t1, t2);
      segment._t1 = t1;
      segment._t2 = t2;
      pass1.push(segment);
      t1 = t2;
    }

    // second pass: further reduce these segments to simple segments
    pass1.forEach(function (p1) {
      t1 = 0;
      t2 = 0;
      while (t2 <= 1) {
        for (t2 = t1 + step; t2 <= 1 + step; t2 += step) {
          segment = p1.split(t1, t2);
          if (!segment.simple()) {
            t2 -= step;
            if (bezier_abs(t1 - t2) < step) {
              // we can never form a reduction
              return [];
            }
            segment = p1.split(t1, t2);
            segment._t1 = utils.map(t1, 0, 1, p1._t1, p1._t2);
            segment._t2 = utils.map(t2, 0, 1, p1._t1, p1._t2);
            pass2.push(segment);
            t1 = t2;
            break;
          }
        }
      }
      if (t1 < 1) {
        segment = p1.split(t1, 1);
        segment._t1 = utils.map(t1, 0, 1, p1._t1, p1._t2);
        segment._t2 = p1._t2;
        pass2.push(segment);
      }
    });
    return pass2;
  }

  scale(d) {
    const order = this.order;
    let distanceFn = false;
    if (typeof d === "function") {
      distanceFn = d;
    }
    if (distanceFn && order === 2) {
      return this.raise().scale(distanceFn);
    }

    // TODO: add special handling for degenerate (=linear) curves.
    const clockwise = this.clockwise;
    const r1 = distanceFn ? distanceFn(0) : d;
    const r2 = distanceFn ? distanceFn(1) : d;
    const v = [this.offset(0, 10), this.offset(1, 10)];
    const points = this.points;
    const np = [];
    const o = utils.lli4(v[0], v[0].c, v[1], v[1].c);

    if (!o) {
      throw new Error("cannot scale this curve. Try reducing it first.");
    }
    // move all points by distance 'd' wrt the origin 'o'

    // move end points by fixed distance along normal.
    [0, 1].forEach(function (t) {
      const p = (np[t * order] = utils.copy(points[t * order]));
      p.x += (t ? r2 : r1) * v[t].n.x;
      p.y += (t ? r2 : r1) * v[t].n.y;
    });

    if (!distanceFn) {
      // move control points to lie on the intersection of the offset
      // derivative vector, and the origin-through-control vector
      [0, 1].forEach((t) => {
        if (order === 2 && !!t) return;
        const p = np[t * order];
        const d = this.derivative(t);
        const p2 = { x: p.x + d.x, y: p.y + d.y };
        np[t + 1] = utils.lli4(p, p2, o, points[t + 1]);
      });
      return new Bezier(np);
    }

    // move control points by "however much necessary to
    // ensure the correct tangent to endpoint".
    [0, 1].forEach(function (t) {
      if (order === 2 && !!t) return;
      var p = points[t + 1];
      var ov = {
        x: p.x - o.x,
        y: p.y - o.y,
      };
      var rc = distanceFn ? distanceFn((t + 1) / order) : d;
      if (distanceFn && !clockwise) rc = -rc;
      var m = bezier_sqrt(ov.x * ov.x + ov.y * ov.y);
      ov.x /= m;
      ov.y /= m;
      np[t + 1] = {
        x: p.x + rc * ov.x,
        y: p.y + rc * ov.y,
      };
    });
    return new Bezier(np);
  }

  outline(d1, d2, d3, d4) {
    d2 = typeof d2 === "undefined" ? d1 : d2;
    const reduced = this.reduce(),
      len = reduced.length,
      fcurves = [];

    let bcurves = [],
      p,
      alen = 0,
      tlen = this.length();

    const graduated = typeof d3 !== "undefined" && typeof d4 !== "undefined";

    function linearDistanceFunction(s, e, tlen, alen, slen) {
      return function (v) {
        const f1 = alen / tlen,
          f2 = (alen + slen) / tlen,
          d = e - s;
        return utils.map(v, 0, 1, s + f1 * d, s + f2 * d);
      };
    }

    // form curve oulines
    reduced.forEach(function (segment) {
      const slen = segment.length();
      if (graduated) {
        fcurves.push(
          segment.scale(linearDistanceFunction(d1, d3, tlen, alen, slen))
        );
        bcurves.push(
          segment.scale(linearDistanceFunction(-d2, -d4, tlen, alen, slen))
        );
      } else {
        fcurves.push(segment.scale(d1));
        bcurves.push(segment.scale(-d2));
      }
      alen += slen;
    });

    // reverse the "return" outline
    bcurves = bcurves
      .map(function (s) {
        p = s.points;
        if (p[3]) {
          s.points = [p[3], p[2], p[1], p[0]];
        } else {
          s.points = [p[2], p[1], p[0]];
        }
        return s;
      })
      .reverse();

    // form the endcaps as lines
    const fs = fcurves[0].points[0],
      fe = fcurves[len - 1].points[fcurves[len - 1].points.length - 1],
      bs = bcurves[len - 1].points[bcurves[len - 1].points.length - 1],
      be = bcurves[0].points[0],
      ls = utils.makeline(bs, fs),
      le = utils.makeline(fe, be),
      segments = [ls].concat(fcurves).concat([le]).concat(bcurves),
      slen = segments.length;

    return new PolyBezier(segments);
  }

  outlineshapes(d1, d2, curveIntersectionThreshold) {
    d2 = d2 || d1;
    const outline = this.outline(d1, d2).curves;
    const shapes = [];
    for (let i = 1, len = outline.length; i < len / 2; i++) {
      const shape = utils.makeshape(
        outline[i],
        outline[len - i],
        curveIntersectionThreshold
      );
      shape.startcap.virtual = i > 1;
      shape.endcap.virtual = i < len / 2 - 1;
      shapes.push(shape);
    }
    return shapes;
  }

  intersects(curve, curveIntersectionThreshold) {
    if (!curve) return this.selfintersects(curveIntersectionThreshold);
    if (curve.p1 && curve.p2) {
      return this.lineIntersects(curve);
    }
    if (curve instanceof Bezier) {
      curve = curve.reduce();
    }
    return this.curveintersects(
      this.reduce(),
      curve,
      curveIntersectionThreshold
    );
  }

  lineIntersects(line) {
    const mx = bezier_min(line.p1.x, line.p2.x),
      my = bezier_min(line.p1.y, line.p2.y),
      MX = bezier_max(line.p1.x, line.p2.x),
      MY = bezier_max(line.p1.y, line.p2.y);
    return utils.roots(this.points, line).filter((t) => {
      var p = this.get(t);
      return utils.between(p.x, mx, MX) && utils.between(p.y, my, MY);
    });
  }

  selfintersects(curveIntersectionThreshold) {
    // "simple" curves cannot intersect with their direct
    // neighbour, so for each segment X we check whether
    // it intersects [0:x-2][x+2:last].

    const reduced = this.reduce(),
      len = reduced.length - 2,
      results = [];

    for (let i = 0, result, left, right; i < len; i++) {
      left = reduced.slice(i, i + 1);
      right = reduced.slice(i + 2);
      result = this.curveintersects(left, right, curveIntersectionThreshold);
      results.push(...result);
    }
    return results;
  }

  curveintersects(c1, c2, curveIntersectionThreshold) {
    const pairs = [];
    // step 1: pair off any overlapping segments
    c1.forEach(function (l) {
      c2.forEach(function (r) {
        if (l.overlaps(r)) {
          pairs.push({ left: l, right: r });
        }
      });
    });
    // step 2: for each pairing, run through the convergence algorithm.
    let intersections = [];
    pairs.forEach(function (pair) {
      const result = utils.pairiteration(
        pair.left,
        pair.right,
        curveIntersectionThreshold
      );
      if (result.length > 0) {
        intersections = intersections.concat(result);
      }
    });
    return intersections;
  }

  arcs(errorThreshold) {
    errorThreshold = errorThreshold || 0.5;
    return this._iterate(errorThreshold, []);
  }

  _error(pc, np1, s, e) {
    const q = (e - s) / 4,
      c1 = this.get(s + q),
      c2 = this.get(e - q),
      ref = utils.dist(pc, np1),
      d1 = utils.dist(pc, c1),
      d2 = utils.dist(pc, c2);
    return bezier_abs(d1 - ref) + bezier_abs(d2 - ref);
  }

  _iterate(errorThreshold, circles) {
    let t_s = 0,
      t_e = 1,
      safety;
    // we do a binary search to find the "good `t` closest to no-longer-good"
    do {
      safety = 0;

      // step 1: start with the maximum possible arc
      t_e = 1;

      // points:
      let np1 = this.get(t_s),
        np2,
        np3,
        arc,
        prev_arc;

      // booleans:
      let curr_good = false,
        prev_good = false,
        done;

      // numbers:
      let t_m = t_e,
        prev_e = 1,
        step = 0;

      // step 2: find the best possible arc
      do {
        prev_good = curr_good;
        prev_arc = arc;
        t_m = (t_s + t_e) / 2;
        step++;

        np2 = this.get(t_m);
        np3 = this.get(t_e);

        arc = utils.getccenter(np1, np2, np3);

        //also save the t values
        arc.interval = {
          start: t_s,
          end: t_e,
        };

        let error = this._error(arc, np1, t_s, t_e);
        curr_good = error <= errorThreshold;

        done = prev_good && !curr_good;
        if (!done) prev_e = t_e;

        // this arc is fine: we can move 'e' up to see if we can find a wider arc
        if (curr_good) {
          // if e is already at max, then we're done for this arc.
          if (t_e >= 1) {
            // make sure we cap at t=1
            arc.interval.end = prev_e = 1;
            prev_arc = arc;
            // if we capped the arc segment to t=1 we also need to make sure that
            // the arc's end angle is correct with respect to the bezier end point.
            if (t_e > 1) {
              let d = {
                x: arc.x + arc.r * bezier_cos(arc.e),
                y: arc.y + arc.r * bezier_sin(arc.e),
              };
              arc.e += utils.angle({ x: arc.x, y: arc.y }, d, this.get(1));
            }
            break;
          }
          // if not, move it up by half the iteration distance
          t_e = t_e + (t_e - t_s) / 2;
        } else {
          // this is a bad arc: we need to move 'e' down to find a good arc
          t_e = t_m;
        }
      } while (!done && safety++ < 100);

      if (safety >= 100) {
        break;
      }

      // console.log("L835: [F] arc found", t_s, prev_e, prev_arc.x, prev_arc.y, prev_arc.s, prev_arc.e);

      prev_arc = prev_arc ? prev_arc : arc;
      circles.push(prev_arc);
      t_s = prev_e;
    } while (t_e < 1);
    return circles;
  }
}



;// CONCATENATED MODULE: ./node_modules/d3-array/src/ticks.js
var e10 = Math.sqrt(50),
    e5 = Math.sqrt(10),
    e2 = Math.sqrt(2);

/* harmony default export */ function ticks(start, stop, count) {
  var reverse,
      i = -1,
      n,
      ticks,
      step;

  stop = +stop, start = +start, count = +count;
  if (start === stop && count > 0) return [start];
  if (reverse = stop < start) n = start, start = stop, stop = n;
  if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];

  if (step > 0) {
    let r0 = Math.round(start / step), r1 = Math.round(stop / step);
    if (r0 * step < start) ++r0;
    if (r1 * step > stop) --r1;
    ticks = new Array(n = r1 - r0 + 1);
    while (++i < n) ticks[i] = (r0 + i) * step;
  } else {
    step = -step;
    let r0 = Math.round(start * step), r1 = Math.round(stop * step);
    if (r0 / step < start) ++r0;
    if (r1 / step > stop) --r1;
    ticks = new Array(n = r1 - r0 + 1);
    while (++i < n) ticks[i] = (r0 + i) / step;
  }

  if (reverse) ticks.reverse();

  return ticks;
}

function tickIncrement(start, stop, count) {
  var step = (stop - start) / Math.max(0, count),
      power = Math.floor(Math.log(step) / Math.LN10),
      error = step / Math.pow(10, power);
  return power >= 0
      ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power)
      : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);
}

function tickStep(start, stop, count) {
  var step0 = Math.abs(stop - start) / Math.max(0, count),
      step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
      error = step0 / step1;
  if (error >= e10) step1 *= 10;
  else if (error >= e5) step1 *= 5;
  else if (error >= e2) step1 *= 2;
  return stop < start ? -step1 : step1;
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/ascending.js
/* harmony default export */ function ascending(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/bisector.js


/* harmony default export */ function bisector(f) {
  let delta = f;
  let compare = f;

  if (f.length === 1) {
    delta = (d, x) => f(d) - x;
    compare = ascendingComparator(f);
  }

  function left(a, x, lo, hi) {
    if (lo == null) lo = 0;
    if (hi == null) hi = a.length;
    while (lo < hi) {
      const mid = (lo + hi) >>> 1;
      if (compare(a[mid], x) < 0) lo = mid + 1;
      else hi = mid;
    }
    return lo;
  }

  function right(a, x, lo, hi) {
    if (lo == null) lo = 0;
    if (hi == null) hi = a.length;
    while (lo < hi) {
      const mid = (lo + hi) >>> 1;
      if (compare(a[mid], x) > 0) hi = mid;
      else lo = mid + 1;
    }
    return lo;
  }

  function center(a, x, lo, hi) {
    if (lo == null) lo = 0;
    if (hi == null) hi = a.length;
    const i = left(a, x, lo, hi - 1);
    return i > lo && delta(a[i - 1], x) > -delta(a[i], x) ? i - 1 : i;
  }

  return {left, center, right};
}

function ascendingComparator(f) {
  return (d, x) => ascending(f(d), x);
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/number.js
/* harmony default export */ function number(x) {
  return x === null ? NaN : +x;
}

function* numbers(values, valueof) {
  if (valueof === undefined) {
    for (let value of values) {
      if (value != null && (value = +value) >= value) {
        yield value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null && (value = +value) >= value) {
        yield value;
      }
    }
  }
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/bisect.js




const ascendingBisect = bisector(ascending);
const bisectRight = ascendingBisect.right;
const bisectLeft = ascendingBisect.left;
const bisectCenter = bisector(number).center;
/* harmony default export */ const bisect = (bisectRight);

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/basis.js
function basis(t1, v0, v1, v2, v3) {
  var t2 = t1 * t1, t3 = t2 * t1;
  return ((1 - 3 * t1 + 3 * t2 - t3) * v0
      + (4 - 6 * t2 + 3 * t3) * v1
      + (1 + 3 * t1 + 3 * t2 - 3 * t3) * v2
      + t3 * v3) / 6;
}

/* harmony default export */ function src_basis(values) {
  var n = values.length - 1;
  return function(t) {
    var i = t <= 0 ? (t = 0) : t >= 1 ? (t = 1, n - 1) : Math.floor(t * n),
        v1 = values[i],
        v2 = values[i + 1],
        v0 = i > 0 ? values[i - 1] : 2 * v1 - v2,
        v3 = i < n - 1 ? values[i + 2] : 2 * v2 - v1;
    return basis((t - i / n) * n, v0, v1, v2, v3);
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/basisClosed.js


/* harmony default export */ function basisClosed(values) {
  var n = values.length;
  return function(t) {
    var i = Math.floor(((t %= 1) < 0 ? ++t : t) * n),
        v0 = values[(i + n - 1) % n],
        v1 = values[i % n],
        v2 = values[(i + 1) % n],
        v3 = values[(i + 2) % n];
    return basis((t - i / n) * n, v0, v1, v2, v3);
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/constant.js
/* harmony default export */ const src_constant = (x => () => x);

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/color.js


function linear(a, d) {
  return function(t) {
    return a + t * d;
  };
}

function exponential(a, b, y) {
  return a = Math.pow(a, y), b = Math.pow(b, y) - a, y = 1 / y, function(t) {
    return Math.pow(a + t * b, y);
  };
}

function hue(a, b) {
  var d = b - a;
  return d ? linear(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : src_constant(isNaN(a) ? b : a);
}

function gamma(y) {
  return (y = +y) === 1 ? nogamma : function(a, b) {
    return b - a ? exponential(a, b, y) : src_constant(isNaN(a) ? b : a);
  };
}

function nogamma(a, b) {
  var d = b - a;
  return d ? linear(a, d) : src_constant(isNaN(a) ? b : a);
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/rgb.js





/* harmony default export */ const rgb = ((function rgbGamma(y) {
  var color = gamma(y);

  function rgb(start, end) {
    var r = color((start = color_rgb(start)).r, (end = color_rgb(end)).r),
        g = color(start.g, end.g),
        b = color(start.b, end.b),
        opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.r = r(t);
      start.g = g(t);
      start.b = b(t);
      start.opacity = opacity(t);
      return start + "";
    };
  }

  rgb.gamma = rgbGamma;

  return rgb;
})(1));

function rgbSpline(spline) {
  return function(colors) {
    var n = colors.length,
        r = new Array(n),
        g = new Array(n),
        b = new Array(n),
        i, color;
    for (i = 0; i < n; ++i) {
      color = color_rgb(colors[i]);
      r[i] = color.r || 0;
      g[i] = color.g || 0;
      b[i] = color.b || 0;
    }
    r = spline(r);
    g = spline(g);
    b = spline(b);
    color.opacity = 1;
    return function(t) {
      color.r = r(t);
      color.g = g(t);
      color.b = b(t);
      return color + "";
    };
  };
}

var rgbBasis = rgbSpline(src_basis);
var rgbBasisClosed = rgbSpline(basisClosed);

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/array.js



/* harmony default export */ function array(a, b) {
  return (isNumberArray(b) ? numberArray : genericArray)(a, b);
}

function genericArray(a, b) {
  var nb = b ? b.length : 0,
      na = a ? Math.min(nb, a.length) : 0,
      x = new Array(na),
      c = new Array(nb),
      i;

  for (i = 0; i < na; ++i) x[i] = value(a[i], b[i]);
  for (; i < nb; ++i) c[i] = b[i];

  return function(t) {
    for (i = 0; i < na; ++i) c[i] = x[i](t);
    return c;
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/date.js
/* harmony default export */ function date(a, b) {
  var d = new Date;
  return a = +a, b = +b, function(t) {
    return d.setTime(a * (1 - t) + b * t), d;
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/number.js
/* harmony default export */ function src_number(a, b) {
  return a = +a, b = +b, function(t) {
    return a * (1 - t) + b * t;
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/object.js


/* harmony default export */ function object(a, b) {
  var i = {},
      c = {},
      k;

  if (a === null || typeof a !== "object") a = {};
  if (b === null || typeof b !== "object") b = {};

  for (k in b) {
    if (k in a) {
      i[k] = value(a[k], b[k]);
    } else {
      c[k] = b[k];
    }
  }

  return function(t) {
    for (k in i) c[k] = i[k](t);
    return c;
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/string.js


var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,
    reB = new RegExp(reA.source, "g");

function zero(b) {
  return function() {
    return b;
  };
}

function one(b) {
  return function(t) {
    return b(t) + "";
  };
}

/* harmony default export */ function string(a, b) {
  var bi = reA.lastIndex = reB.lastIndex = 0, // scan index for next number in b
      am, // current match in a
      bm, // current match in b
      bs, // string preceding current number in b, if any
      i = -1, // index in s
      s = [], // string constants and placeholders
      q = []; // number interpolators

  // Coerce inputs to strings.
  a = a + "", b = b + "";

  // Interpolate pairs of numbers in a & b.
  while ((am = reA.exec(a))
      && (bm = reB.exec(b))) {
    if ((bs = bm.index) > bi) { // a string precedes the next number in b
      bs = b.slice(bi, bs);
      if (s[i]) s[i] += bs; // coalesce with previous string
      else s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) { // numbers in a & b match
      if (s[i]) s[i] += bm; // coalesce with previous string
      else s[++i] = bm;
    } else { // interpolate non-matching numbers
      s[++i] = null;
      q.push({i: i, x: src_number(am, bm)});
    }
    bi = reB.lastIndex;
  }

  // Add remains of b.
  if (bi < b.length) {
    bs = b.slice(bi);
    if (s[i]) s[i] += bs; // coalesce with previous string
    else s[++i] = bs;
  }

  // Special optimization for only a single match.
  // Otherwise, interpolate each of the numbers and rejoin the string.
  return s.length < 2 ? (q[0]
      ? one(q[0].x)
      : zero(b))
      : (b = q.length, function(t) {
          for (var i = 0, o; i < b; ++i) s[(o = q[i]).i] = o.x(t);
          return s.join("");
        });
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/numberArray.js
/* harmony default export */ function src_numberArray(a, b) {
  if (!b) b = [];
  var n = a ? Math.min(b.length, a.length) : 0,
      c = b.slice(),
      i;
  return function(t) {
    for (i = 0; i < n; ++i) c[i] = a[i] * (1 - t) + b[i] * t;
    return c;
  };
}

function numberArray_isNumberArray(x) {
  return ArrayBuffer.isView(x) && !(x instanceof DataView);
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/value.js










/* harmony default export */ function value(a, b) {
  var t = typeof b, c;
  return b == null || t === "boolean" ? src_constant(b)
      : (t === "number" ? src_number
      : t === "string" ? ((c = color(b)) ? (b = c, rgb) : string)
      : b instanceof color ? rgb
      : b instanceof Date ? date
      : numberArray_isNumberArray(b) ? src_numberArray
      : Array.isArray(b) ? genericArray
      : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? object
      : src_number)(a, b);
}

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/round.js
/* harmony default export */ function round(a, b) {
  return a = +a, b = +b, function(t) {
    return Math.round(a * (1 - t) + b * t);
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/constant.js
function constants(x) {
  return function() {
    return x;
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/number.js
function number_number(x) {
  return +x;
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/continuous.js





var unit = [0, 1];

function continuous_identity(x) {
  return x;
}

function normalize(a, b) {
  return (b -= (a = +a))
      ? function(x) { return (x - a) / b; }
      : constants(isNaN(b) ? NaN : 0.5);
}

function clamper(a, b) {
  var t;
  if (a > b) t = a, a = b, b = t;
  return function(x) { return Math.max(a, Math.min(b, x)); };
}

// normalize(a, b)(x) takes a domain value x in [a,b] and returns the corresponding parameter t in [0,1].
// interpolate(a, b)(t) takes a parameter t in [0,1] and returns the corresponding range value x in [a,b].
function bimap(domain, range, interpolate) {
  var d0 = domain[0], d1 = domain[1], r0 = range[0], r1 = range[1];
  if (d1 < d0) d0 = normalize(d1, d0), r0 = interpolate(r1, r0);
  else d0 = normalize(d0, d1), r0 = interpolate(r0, r1);
  return function(x) { return r0(d0(x)); };
}

function polymap(domain, range, interpolate) {
  var j = Math.min(domain.length, range.length) - 1,
      d = new Array(j),
      r = new Array(j),
      i = -1;

  // Reverse descending domains.
  if (domain[j] < domain[0]) {
    domain = domain.slice().reverse();
    range = range.slice().reverse();
  }

  while (++i < j) {
    d[i] = normalize(domain[i], domain[i + 1]);
    r[i] = interpolate(range[i], range[i + 1]);
  }

  return function(x) {
    var i = bisect(domain, x, 1, j) - 1;
    return r[i](d[i](x));
  };
}

function copy(source, target) {
  return target
      .domain(source.domain())
      .range(source.range())
      .interpolate(source.interpolate())
      .clamp(source.clamp())
      .unknown(source.unknown());
}

function transformer() {
  var domain = unit,
      range = unit,
      interpolate = value,
      transform,
      untransform,
      unknown,
      clamp = continuous_identity,
      piecewise,
      output,
      input;

  function rescale() {
    var n = Math.min(domain.length, range.length);
    if (clamp !== continuous_identity) clamp = clamper(domain[0], domain[n - 1]);
    piecewise = n > 2 ? polymap : bimap;
    output = input = null;
    return scale;
  }

  function scale(x) {
    return x == null || isNaN(x = +x) ? unknown : (output || (output = piecewise(domain.map(transform), range, interpolate)))(transform(clamp(x)));
  }

  scale.invert = function(y) {
    return clamp(untransform((input || (input = piecewise(range, domain.map(transform), src_number)))(y)));
  };

  scale.domain = function(_) {
    return arguments.length ? (domain = Array.from(_, number_number), rescale()) : domain.slice();
  };

  scale.range = function(_) {
    return arguments.length ? (range = Array.from(_), rescale()) : range.slice();
  };

  scale.rangeRound = function(_) {
    return range = Array.from(_), interpolate = round, rescale();
  };

  scale.clamp = function(_) {
    return arguments.length ? (clamp = _ ? true : continuous_identity, rescale()) : clamp !== continuous_identity;
  };

  scale.interpolate = function(_) {
    return arguments.length ? (interpolate = _, rescale()) : interpolate;
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  return function(t, u) {
    transform = t, untransform = u;
    return rescale();
  };
}

function continuous() {
  return transformer()(continuous_identity, continuous_identity);
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/init.js
function initRange(domain, range) {
  switch (arguments.length) {
    case 0: break;
    case 1: this.range(domain); break;
    default: this.range(range).domain(domain); break;
  }
  return this;
}

function init_initInterpolator(domain, interpolator) {
  switch (arguments.length) {
    case 0: break;
    case 1: {
      if (typeof domain === "function") this.interpolator(domain);
      else this.range(domain);
      break;
    }
    default: {
      this.domain(domain);
      if (typeof interpolator === "function") this.interpolator(interpolator);
      else this.range(interpolator);
      break;
    }
  }
  return this;
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatSpecifier.js
// [[fill]align][sign][symbol][0][width][,][.precision][~][type]
var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;

function formatSpecifier(specifier) {
  if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
  var match;
  return new FormatSpecifier({
    fill: match[1],
    align: match[2],
    sign: match[3],
    symbol: match[4],
    zero: match[5],
    width: match[6],
    comma: match[7],
    precision: match[8] && match[8].slice(1),
    trim: match[9],
    type: match[10]
  });
}

formatSpecifier.prototype = FormatSpecifier.prototype; // instanceof

function FormatSpecifier(specifier) {
  this.fill = specifier.fill === undefined ? " " : specifier.fill + "";
  this.align = specifier.align === undefined ? ">" : specifier.align + "";
  this.sign = specifier.sign === undefined ? "-" : specifier.sign + "";
  this.symbol = specifier.symbol === undefined ? "" : specifier.symbol + "";
  this.zero = !!specifier.zero;
  this.width = specifier.width === undefined ? undefined : +specifier.width;
  this.comma = !!specifier.comma;
  this.precision = specifier.precision === undefined ? undefined : +specifier.precision;
  this.trim = !!specifier.trim;
  this.type = specifier.type === undefined ? "" : specifier.type + "";
}

FormatSpecifier.prototype.toString = function() {
  return this.fill
      + this.align
      + this.sign
      + this.symbol
      + (this.zero ? "0" : "")
      + (this.width === undefined ? "" : Math.max(1, this.width | 0))
      + (this.comma ? "," : "")
      + (this.precision === undefined ? "" : "." + Math.max(0, this.precision | 0))
      + (this.trim ? "~" : "")
      + this.type;
};

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatDecimal.js
/* harmony default export */ function formatDecimal(x) {
  return Math.abs(x = Math.round(x)) >= 1e21
      ? x.toLocaleString("en").replace(/,/g, "")
      : x.toString(10);
}

// Computes the decimal coefficient and exponent of the specified number x with
// significant digits p, where x is positive and p is in [1, 21] or undefined.
// For example, formatDecimalParts(1.23) returns ["123", 0].
function formatDecimalParts(x, p) {
  if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0) return null; // NaN, ±Infinity
  var i, coefficient = x.slice(0, i);

  // The string returned by toExponential either has the form \d\.\d+e[-+]\d+
  // (e.g., 1.2e+3) or the form \de[-+]\d+ (e.g., 1e+3).
  return [
    coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
    +x.slice(i + 1)
  ];
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/exponent.js


/* harmony default export */ function exponent(x) {
  return x = formatDecimalParts(Math.abs(x)), x ? x[1] : NaN;
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/precisionPrefix.js


/* harmony default export */ function precisionPrefix(step, value) {
  return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3 - exponent(Math.abs(step)));
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatGroup.js
/* harmony default export */ function formatGroup(grouping, thousands) {
  return function(value, width) {
    var i = value.length,
        t = [],
        j = 0,
        g = grouping[0],
        length = 0;

    while (i > 0 && g > 0) {
      if (length + g + 1 > width) g = Math.max(1, width - length);
      t.push(value.substring(i -= g, i + g));
      if ((length += g + 1) > width) break;
      g = grouping[j = (j + 1) % grouping.length];
    }

    return t.reverse().join(thousands);
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatNumerals.js
/* harmony default export */ function formatNumerals(numerals) {
  return function(value) {
    return value.replace(/[0-9]/g, function(i) {
      return numerals[+i];
    });
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatTrim.js
// Trims insignificant zeros, e.g., replaces 1.2000k with 1.2k.
/* harmony default export */ function formatTrim(s) {
  out: for (var n = s.length, i = 1, i0 = -1, i1; i < n; ++i) {
    switch (s[i]) {
      case ".": i0 = i1 = i; break;
      case "0": if (i0 === 0) i0 = i; i1 = i; break;
      default: if (!+s[i]) break out; if (i0 > 0) i0 = 0; break;
    }
  }
  return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatPrefixAuto.js


var prefixExponent;

/* harmony default export */ function formatPrefixAuto(x, p) {
  var d = formatDecimalParts(x, p);
  if (!d) return x + "";
  var coefficient = d[0],
      exponent = d[1],
      i = exponent - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent / 3))) * 3) + 1,
      n = coefficient.length;
  return i === n ? coefficient
      : i > n ? coefficient + new Array(i - n + 1).join("0")
      : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i)
      : "0." + new Array(1 - i).join("0") + formatDecimalParts(x, Math.max(0, p + i - 1))[0]; // less than 1y!
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatRounded.js


/* harmony default export */ function formatRounded(x, p) {
  var d = formatDecimalParts(x, p);
  if (!d) return x + "";
  var coefficient = d[0],
      exponent = d[1];
  return exponent < 0 ? "0." + new Array(-exponent).join("0") + coefficient
      : coefficient.length > exponent + 1 ? coefficient.slice(0, exponent + 1) + "." + coefficient.slice(exponent + 1)
      : coefficient + new Array(exponent - coefficient.length + 2).join("0");
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/formatTypes.js




/* harmony default export */ const formatTypes = ({
  "%": (x, p) => (x * 100).toFixed(p),
  "b": (x) => Math.round(x).toString(2),
  "c": (x) => x + "",
  "d": formatDecimal,
  "e": (x, p) => x.toExponential(p),
  "f": (x, p) => x.toFixed(p),
  "g": (x, p) => x.toPrecision(p),
  "o": (x) => Math.round(x).toString(8),
  "p": (x, p) => formatRounded(x * 100, p),
  "r": formatRounded,
  "s": formatPrefixAuto,
  "X": (x) => Math.round(x).toString(16).toUpperCase(),
  "x": (x) => Math.round(x).toString(16)
});

;// CONCATENATED MODULE: ./node_modules/d3-format/src/identity.js
/* harmony default export */ function d3_format_src_identity(x) {
  return x;
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/locale.js









var map = Array.prototype.map,
    prefixes = ["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];

/* harmony default export */ function locale(locale) {
  var group = locale.grouping === undefined || locale.thousands === undefined ? d3_format_src_identity : formatGroup(map.call(locale.grouping, Number), locale.thousands + ""),
      currencyPrefix = locale.currency === undefined ? "" : locale.currency[0] + "",
      currencySuffix = locale.currency === undefined ? "" : locale.currency[1] + "",
      decimal = locale.decimal === undefined ? "." : locale.decimal + "",
      numerals = locale.numerals === undefined ? d3_format_src_identity : formatNumerals(map.call(locale.numerals, String)),
      percent = locale.percent === undefined ? "%" : locale.percent + "",
      minus = locale.minus === undefined ? "−" : locale.minus + "",
      nan = locale.nan === undefined ? "NaN" : locale.nan + "";

  function newFormat(specifier) {
    specifier = formatSpecifier(specifier);

    var fill = specifier.fill,
        align = specifier.align,
        sign = specifier.sign,
        symbol = specifier.symbol,
        zero = specifier.zero,
        width = specifier.width,
        comma = specifier.comma,
        precision = specifier.precision,
        trim = specifier.trim,
        type = specifier.type;

    // The "n" type is an alias for ",g".
    if (type === "n") comma = true, type = "g";

    // The "" type, and any invalid type, is an alias for ".12~g".
    else if (!formatTypes[type]) precision === undefined && (precision = 12), trim = true, type = "g";

    // If zero fill is specified, padding goes after sign and before digits.
    if (zero || (fill === "0" && align === "=")) zero = true, fill = "0", align = "=";

    // Compute the prefix and suffix.
    // For SI-prefix, the suffix is lazily computed.
    var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type) ? "0" + type.toLowerCase() : "",
        suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type) ? percent : "";

    // What format function should we use?
    // Is this an integer type?
    // Can this type generate exponential notation?
    var formatType = formatTypes[type],
        maybeSuffix = /[defgprs%]/.test(type);

    // Set the default precision if not specified,
    // or clamp the specified precision to the supported range.
    // For significant precision, it must be in [1, 21].
    // For fixed precision, it must be in [0, 20].
    precision = precision === undefined ? 6
        : /[gprs]/.test(type) ? Math.max(1, Math.min(21, precision))
        : Math.max(0, Math.min(20, precision));

    function format(value) {
      var valuePrefix = prefix,
          valueSuffix = suffix,
          i, n, c;

      if (type === "c") {
        valueSuffix = formatType(value) + valueSuffix;
        value = "";
      } else {
        value = +value;

        // Determine the sign. -0 is not less than 0, but 1 / -0 is!
        var valueNegative = value < 0 || 1 / value < 0;

        // Perform the initial formatting.
        value = isNaN(value) ? nan : formatType(Math.abs(value), precision);

        // Trim insignificant zeros.
        if (trim) value = formatTrim(value);

        // If a negative value rounds to zero after formatting, and no explicit positive sign is requested, hide the sign.
        if (valueNegative && +value === 0 && sign !== "+") valueNegative = false;

        // Compute the prefix and suffix.
        valuePrefix = (valueNegative ? (sign === "(" ? sign : minus) : sign === "-" || sign === "(" ? "" : sign) + valuePrefix;
        valueSuffix = (type === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign === "(" ? ")" : "");

        // Break the formatted value into the integer “value” part that can be
        // grouped, and fractional or exponential “suffix” part that is not.
        if (maybeSuffix) {
          i = -1, n = value.length;
          while (++i < n) {
            if (c = value.charCodeAt(i), 48 > c || c > 57) {
              valueSuffix = (c === 46 ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix;
              value = value.slice(0, i);
              break;
            }
          }
        }
      }

      // If the fill character is not "0", grouping is applied before padding.
      if (comma && !zero) value = group(value, Infinity);

      // Compute the padding.
      var length = valuePrefix.length + value.length + valueSuffix.length,
          padding = length < width ? new Array(width - length + 1).join(fill) : "";

      // If the fill character is "0", grouping is applied after padding.
      if (comma && zero) value = group(padding + value, padding.length ? width - valueSuffix.length : Infinity), padding = "";

      // Reconstruct the final output based on the desired alignment.
      switch (align) {
        case "<": value = valuePrefix + value + valueSuffix + padding; break;
        case "=": value = valuePrefix + padding + value + valueSuffix; break;
        case "^": value = padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length); break;
        default: value = padding + valuePrefix + value + valueSuffix; break;
      }

      return numerals(value);
    }

    format.toString = function() {
      return specifier + "";
    };

    return format;
  }

  function formatPrefix(specifier, value) {
    var f = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)),
        e = Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3,
        k = Math.pow(10, -e),
        prefix = prefixes[8 + e / 3];
    return function(value) {
      return f(k * value) + prefix;
    };
  }

  return {
    format: newFormat,
    formatPrefix: formatPrefix
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/defaultLocale.js


var defaultLocale_locale;
var format;
var formatPrefix;

defaultLocale({
  thousands: ",",
  grouping: [3],
  currency: ["$", ""]
});

function defaultLocale(definition) {
  defaultLocale_locale = locale(definition);
  format = defaultLocale_locale.format;
  formatPrefix = defaultLocale_locale.formatPrefix;
  return defaultLocale_locale;
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/precisionRound.js


/* harmony default export */ function precisionRound(step, max) {
  step = Math.abs(step), max = Math.abs(max) - step;
  return Math.max(0, exponent(max) - exponent(step)) + 1;
}

;// CONCATENATED MODULE: ./node_modules/d3-format/src/precisionFixed.js


/* harmony default export */ function precisionFixed(step) {
  return Math.max(0, -exponent(Math.abs(step)));
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/tickFormat.js



function tickFormat(start, stop, count, specifier) {
  var step = tickStep(start, stop, count),
      precision;
  specifier = formatSpecifier(specifier == null ? ",f" : specifier);
  switch (specifier.type) {
    case "s": {
      var value = Math.max(Math.abs(start), Math.abs(stop));
      if (specifier.precision == null && !isNaN(precision = precisionPrefix(step, value))) specifier.precision = precision;
      return formatPrefix(specifier, value);
    }
    case "":
    case "e":
    case "g":
    case "p":
    case "r": {
      if (specifier.precision == null && !isNaN(precision = precisionRound(step, Math.max(Math.abs(start), Math.abs(stop))))) specifier.precision = precision - (specifier.type === "e");
      break;
    }
    case "f":
    case "%": {
      if (specifier.precision == null && !isNaN(precision = precisionFixed(step))) specifier.precision = precision - (specifier.type === "%") * 2;
      break;
    }
  }
  return format(specifier);
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/linear.js





function linearish(scale) {
  var domain = scale.domain;

  scale.ticks = function(count) {
    var d = domain();
    return ticks(d[0], d[d.length - 1], count == null ? 10 : count);
  };

  scale.tickFormat = function(count, specifier) {
    var d = domain();
    return tickFormat(d[0], d[d.length - 1], count == null ? 10 : count, specifier);
  };

  scale.nice = function(count) {
    if (count == null) count = 10;

    var d = domain();
    var i0 = 0;
    var i1 = d.length - 1;
    var start = d[i0];
    var stop = d[i1];
    var prestep;
    var step;
    var maxIter = 10;

    if (stop < start) {
      step = start, start = stop, stop = step;
      step = i0, i0 = i1, i1 = step;
    }
    
    while (maxIter-- > 0) {
      step = tickIncrement(start, stop, count);
      if (step === prestep) {
        d[i0] = start
        d[i1] = stop
        return domain(d);
      } else if (step > 0) {
        start = Math.floor(start / step) * step;
        stop = Math.ceil(stop / step) * step;
      } else if (step < 0) {
        start = Math.ceil(start * step) / step;
        stop = Math.floor(stop * step) / step;
      } else {
        break;
      }
      prestep = step;
    }

    return scale;
  };

  return scale;
}

function linear_linear() {
  var scale = continuous();

  scale.copy = function() {
    return copy(scale, linear_linear());
  };

  initRange.apply(scale, arguments);

  return linearish(scale);
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/sequential.js








function sequential_transformer() {
  var x0 = 0,
      x1 = 1,
      t0,
      t1,
      k10,
      transform,
      interpolator = continuous_identity,
      clamp = false,
      unknown;

  function scale(x) {
    return x == null || isNaN(x = +x) ? unknown : interpolator(k10 === 0 ? 0.5 : (x = (transform(x) - t0) * k10, clamp ? Math.max(0, Math.min(1, x)) : x));
  }

  scale.domain = function(_) {
    return arguments.length ? ([x0, x1] = _, t0 = transform(x0 = +x0), t1 = transform(x1 = +x1), k10 = t0 === t1 ? 0 : 1 / (t1 - t0), scale) : [x0, x1];
  };

  scale.clamp = function(_) {
    return arguments.length ? (clamp = !!_, scale) : clamp;
  };

  scale.interpolator = function(_) {
    return arguments.length ? (interpolator = _, scale) : interpolator;
  };

  function range(interpolate) {
    return function(_) {
      var r0, r1;
      return arguments.length ? ([r0, r1] = _, interpolator = interpolate(r0, r1), scale) : [interpolator(0), interpolator(1)];
    };
  }

  scale.range = range(value);

  scale.rangeRound = range(round);

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  return function(t) {
    transform = t, t0 = t(x0), t1 = t(x1), k10 = t0 === t1 ? 0 : 1 / (t1 - t0);
    return scale;
  };
}

function sequential_copy(source, target) {
  return target
      .domain(source.domain())
      .interpolator(source.interpolator())
      .clamp(source.clamp())
      .unknown(source.unknown());
}

function sequential() {
  var scale = linearish(sequential_transformer()(continuous_identity));

  scale.copy = function() {
    return sequential_copy(scale, sequential());
  };

  return init_initInterpolator.apply(scale, arguments);
}

function sequentialLog() {
  var scale = loggish(sequential_transformer()).domain([1, 10]);

  scale.copy = function() {
    return sequential_copy(scale, sequentialLog()).base(scale.base());
  };

  return initInterpolator.apply(scale, arguments);
}

function sequentialSymlog() {
  var scale = symlogish(sequential_transformer());

  scale.copy = function() {
    return sequential_copy(scale, sequentialSymlog()).constant(scale.constant());
  };

  return initInterpolator.apply(scale, arguments);
}

function sequentialPow() {
  var scale = powish(sequential_transformer());

  scale.copy = function() {
    return sequential_copy(scale, sequentialPow()).exponent(scale.exponent());
  };

  return initInterpolator.apply(scale, arguments);
}

function sequentialSqrt() {
  return sequentialPow.apply(null, arguments).exponent(0.5);
}

;// CONCATENATED MODULE: ./node_modules/d3-array/src/range.js
/* harmony default export */ function range(start, stop, step) {
  start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;

  var i = -1,
      n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
      range = new Array(n);

  while (++i < n) {
    range[i] = start + i * step;
  }

  return range;
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/ordinal.js


const implicit = Symbol("implicit");

function ordinal() {
  var index = new Map(),
      domain = [],
      range = [],
      unknown = implicit;

  function scale(d) {
    var key = d + "", i = index.get(key);
    if (!i) {
      if (unknown !== implicit) return unknown;
      index.set(key, i = domain.push(d));
    }
    return range[(i - 1) % range.length];
  }

  scale.domain = function(_) {
    if (!arguments.length) return domain.slice();
    domain = [], index = new Map();
    for (const value of _) {
      const key = value + "";
      if (index.has(key)) continue;
      index.set(key, domain.push(value));
    }
    return scale;
  };

  scale.range = function(_) {
    return arguments.length ? (range = Array.from(_), scale) : range.slice();
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  scale.copy = function() {
    return ordinal(domain, range).unknown(unknown);
  };

  initRange.apply(scale, arguments);

  return scale;
}

;// CONCATENATED MODULE: ./node_modules/d3-scale/src/band.js




function band() {
  var scale = ordinal().unknown(undefined),
      domain = scale.domain,
      ordinalRange = scale.range,
      r0 = 0,
      r1 = 1,
      step,
      bandwidth,
      round = false,
      paddingInner = 0,
      paddingOuter = 0,
      align = 0.5;

  delete scale.unknown;

  function rescale() {
    var n = domain().length,
        reverse = r1 < r0,
        start = reverse ? r1 : r0,
        stop = reverse ? r0 : r1;
    step = (stop - start) / Math.max(1, n - paddingInner + paddingOuter * 2);
    if (round) step = Math.floor(step);
    start += (stop - start - step * (n - paddingInner)) * align;
    bandwidth = step * (1 - paddingInner);
    if (round) start = Math.round(start), bandwidth = Math.round(bandwidth);
    var values = range(n).map(function(i) { return start + step * i; });
    return ordinalRange(reverse ? values.reverse() : values);
  }

  scale.domain = function(_) {
    return arguments.length ? (domain(_), rescale()) : domain();
  };

  scale.range = function(_) {
    return arguments.length ? ([r0, r1] = _, r0 = +r0, r1 = +r1, rescale()) : [r0, r1];
  };

  scale.rangeRound = function(_) {
    return [r0, r1] = _, r0 = +r0, r1 = +r1, round = true, rescale();
  };

  scale.bandwidth = function() {
    return bandwidth;
  };

  scale.step = function() {
    return step;
  };

  scale.round = function(_) {
    return arguments.length ? (round = !!_, rescale()) : round;
  };

  scale.padding = function(_) {
    return arguments.length ? (paddingInner = Math.min(1, paddingOuter = +_), rescale()) : paddingInner;
  };

  scale.paddingInner = function(_) {
    return arguments.length ? (paddingInner = Math.min(1, _), rescale()) : paddingInner;
  };

  scale.paddingOuter = function(_) {
    return arguments.length ? (paddingOuter = +_, rescale()) : paddingOuter;
  };

  scale.align = function(_) {
    return arguments.length ? (align = Math.max(0, Math.min(1, _)), rescale()) : align;
  };

  scale.copy = function() {
    return band(domain(), [r0, r1])
        .round(round)
        .paddingInner(paddingInner)
        .paddingOuter(paddingOuter)
        .align(align);
  };

  return initRange.apply(rescale(), arguments);
}

function pointish(scale) {
  var copy = scale.copy;

  scale.padding = scale.paddingOuter;
  delete scale.paddingInner;
  delete scale.paddingOuter;

  scale.copy = function() {
    return pointish(copy());
  };

  return scale;
}

function point() {
  return pointish(band.apply(null, arguments).paddingInner(1));
}

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/colors.js
/* harmony default export */ function colors(specifier) {
  var n = specifier.length / 6 | 0, colors = new Array(n), i = 0;
  while (i < n) colors[i] = "#" + specifier.slice(i * 6, ++i * 6);
  return colors;
}

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/sequential-multi/viridis.js


function ramp(range) {
  var n = range.length;
  return function(t) {
    return range[Math.max(0, Math.min(n - 1, Math.floor(t * n)))];
  };
}

/* harmony default export */ const viridis = (ramp(colors("44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725")));

var magma = ramp(colors("00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"));

var inferno = ramp(colors("00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"));

var plasma = ramp(colors("0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"));

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/ramp.js


/* harmony default export */ const src_ramp = (scheme => rgbBasis(scheme[scheme.length - 1]));

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/sequential-single/Greys.js



var scheme = new Array(3).concat(
  "f0f0f0bdbdbd636363",
  "f7f7f7cccccc969696525252",
  "f7f7f7cccccc969696636363252525",
  "f7f7f7d9d9d9bdbdbd969696636363252525",
  "f7f7f7d9d9d9bdbdbd969696737373525252252525",
  "fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",
  "fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"
).map(colors);

/* harmony default export */ const Greys = (src_ramp(scheme));

;// CONCATENATED MODULE: ./node_modules/d3-color/src/math.js
const radians = Math.PI / 180;
const degrees = 180 / Math.PI;

;// CONCATENATED MODULE: ./node_modules/d3-color/src/cubehelix.js




var A = -0.14861,
    B = +1.78277,
    C = -0.29227,
    D = -0.90649,
    E = +1.97294,
    ED = E * D,
    EB = E * B,
    BC_DA = B * C - D * A;

function cubehelixConvert(o) {
  if (o instanceof Cubehelix) return new Cubehelix(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Rgb)) o = rgbConvert(o);
  var r = o.r / 255,
      g = o.g / 255,
      b = o.b / 255,
      l = (BC_DA * b + ED * r - EB * g) / (BC_DA + ED - EB),
      bl = b - l,
      k = (E * (g - l) - C * bl) / D,
      s = Math.sqrt(k * k + bl * bl) / (E * l * (1 - l)), // NaN if l=0 or l=1
      h = s ? Math.atan2(k, bl) * degrees - 120 : NaN;
  return new Cubehelix(h < 0 ? h + 360 : h, s, l, o.opacity);
}

function cubehelix_cubehelix(h, s, l, opacity) {
  return arguments.length === 1 ? cubehelixConvert(h) : new Cubehelix(h, s, l, opacity == null ? 1 : opacity);
}

function Cubehelix(h, s, l, opacity) {
  this.h = +h;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}

src_define(Cubehelix, cubehelix_cubehelix, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Cubehelix(this.h, this.s, this.l * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Cubehelix(this.h, this.s, this.l * k, this.opacity);
  },
  rgb: function() {
    var h = isNaN(this.h) ? 0 : (this.h + 120) * radians,
        l = +this.l,
        a = isNaN(this.s) ? 0 : this.s * l * (1 - l),
        cosh = Math.cos(h),
        sinh = Math.sin(h);
    return new Rgb(
      255 * (l + a * (A * cosh + B * sinh)),
      255 * (l + a * (C * cosh + D * sinh)),
      255 * (l + a * (E * cosh)),
      this.opacity
    );
  }
}));

;// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/cubehelix.js



function cubehelix(hue) {
  return (function cubehelixGamma(y) {
    y = +y;

    function cubehelix(start, end) {
      var h = hue((start = cubehelix_cubehelix(start)).h, (end = cubehelix_cubehelix(end)).h),
          s = nogamma(start.s, end.s),
          l = nogamma(start.l, end.l),
          opacity = nogamma(start.opacity, end.opacity);
      return function(t) {
        start.h = h(t);
        start.s = s(t);
        start.l = l(Math.pow(t, y));
        start.opacity = opacity(t);
        return start + "";
      };
    }

    cubehelix.gamma = cubehelixGamma;

    return cubehelix;
  })(1);
}

/* harmony default export */ const src_cubehelix = (cubehelix(hue));
var cubehelixLong = cubehelix(nogamma);

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/sequential-multi/rainbow.js



var warm = cubehelixLong(cubehelix_cubehelix(-100, 0.75, 0.35), cubehelix_cubehelix(80, 1.50, 0.8));

var cool = cubehelixLong(cubehelix_cubehelix(260, 0.75, 0.35), cubehelix_cubehelix(80, 1.50, 0.8));

var c = cubehelix_cubehelix();

/* harmony default export */ function rainbow(t) {
  if (t < 0 || t > 1) t -= Math.floor(t);
  var ts = Math.abs(t - 0.5);
  c.h = 360 * t - 100;
  c.s = 1.5 - 1.5 * ts;
  c.l = 0.8 - 0.9 * ts;
  return c + "";
}

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/diverging/Spectral.js



var Spectral_scheme = new Array(3).concat(
  "fc8d59ffffbf99d594",
  "d7191cfdae61abdda42b83ba",
  "d7191cfdae61ffffbfabdda42b83ba",
  "d53e4ffc8d59fee08be6f59899d5943288bd",
  "d53e4ffc8d59fee08bffffbfe6f59899d5943288bd",
  "d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd",
  "d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd",
  "9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2",
  "9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2"
).map(colors);

/* harmony default export */ const Spectral = (src_ramp(Spectral_scheme));

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/sequential-multi/cividis.js
/* harmony default export */ function cividis(t) {
  t = Math.max(0, Math.min(1, t));
  return "rgb("
      + Math.max(0, Math.min(255, Math.round(-4.54 - t * (35.34 - t * (2381.73 - t * (6402.7 - t * (7024.72 - t * 2710.57))))))) + ", "
      + Math.max(0, Math.min(255, Math.round(32.49 + t * (170.73 + t * (52.82 - t * (131.46 - t * (176.58 - t * 67.37))))))) + ", "
      + Math.max(0, Math.min(255, Math.round(81.24 + t * (442.36 - t * (2482.43 - t * (6167.24 - t * (6614.94 - t * 2475.67)))))))
      + ")";
}

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/sequential-multi/BuPu.js



var BuPu_scheme = new Array(3).concat(
  "e0ecf49ebcda8856a7",
  "edf8fbb3cde38c96c688419d",
  "edf8fbb3cde38c96c68856a7810f7c",
  "edf8fbbfd3e69ebcda8c96c68856a7810f7c",
  "edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b",
  "f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b",
  "f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b"
).map(colors);

/* harmony default export */ const BuPu = (src_ramp(BuPu_scheme));

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/diverging/RdBu.js



var RdBu_scheme = new Array(3).concat(
  "ef8a62f7f7f767a9cf",
  "ca0020f4a58292c5de0571b0",
  "ca0020f4a582f7f7f792c5de0571b0",
  "b2182bef8a62fddbc7d1e5f067a9cf2166ac",
  "b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac",
  "b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac",
  "b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac",
  "67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061",
  "67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061"
).map(colors);

/* harmony default export */ const RdBu = (src_ramp(RdBu_scheme));

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/sequential-multi/YlOrBr.js



var YlOrBr_scheme = new Array(3).concat(
  "fff7bcfec44fd95f0e",
  "ffffd4fed98efe9929cc4c02",
  "ffffd4fed98efe9929d95f0e993404",
  "ffffd4fee391fec44ffe9929d95f0e993404",
  "ffffd4fee391fec44ffe9929ec7014cc4c028c2d04",
  "ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04",
  "ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506"
).map(colors);

/* harmony default export */ const YlOrBr = (src_ramp(YlOrBr_scheme));

;// CONCATENATED MODULE: ./node_modules/d3-scale-chromatic/src/sequential-multi/RdPu.js



var RdPu_scheme = new Array(3).concat(
  "fde0ddfa9fb5c51b8a",
  "feebe2fbb4b9f768a1ae017e",
  "feebe2fbb4b9f768a1c51b8a7a0177",
  "feebe2fcc5c0fa9fb5f768a1c51b8a7a0177",
  "feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177",
  "fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177",
  "fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a"
).map(colors);

/* harmony default export */ const RdPu = (src_ramp(RdPu_scheme));

;// CONCATENATED MODULE: ./node_modules/higlass-register/src/index.js
window.higlassTracks = window.higlassTracks || {};
window.higlassTracksByType = window.higlassTracksByType || {};
window.higlassDataFetchersByType = window.higlassDataFetchersByType || {};

const getRandomName = () => Math.random().toString(36).substring(2, 8);

const registerTrack = (trackDef, { force = false } = {}) => {
  // The following is only needed for backward compatibility
  let name = getRandomName();
  while (window.higlassTracks[name]) {
    name = getRandomName();
  }

  trackDef.name = name;
  window.higlassTracks[trackDef.name] = trackDef;
  // backward compatibility: end

  if (window.higlassTracksByType[trackDef.config.type] && !force) {
    // eslint-disable-next-line
    console.warn(
      `A track with the same type (${trackDef.config.type}) was already ` +
      'registered. To override it, set force to true.',
    );
  } else {
    window.higlassTracksByType[trackDef.config.type] = trackDef;
  }
};

const registerDataFetcher = (dataFetcherDef, { force = false } = {}) => {
  if (window.higlassDataFetchersByType[dataFetcherDef.config.type] && !force) {
    // eslint-disable-next-line
    console.warn(
      `A data fetcher with the same type (${dataFetcherDef.config.type}) was already ` +
      'registered. To override it, set force to true.',
    );
  } else {
    window.higlassDataFetchersByType[dataFetcherDef.config.type] = dataFetcherDef;
  }
};

const register = (definition, options = {}) => {
  const { pluginType = 'track' } = options;
  if (pluginType === 'track') {
    registerTrack(definition, options);
  } else if (pluginType === 'dataFetcher') {
    registerDataFetcher(definition, options);
  }
};

/* harmony default export */ const src = (register);

// EXTERNAL MODULE: ./node_modules/higlass-text/node_modules/slugid/index.js
var slugid = __webpack_require__(1722);
;// CONCATENATED MODULE: ./node_modules/higlass-text/es/EmptyDataFetcher.js
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var EmptyDataFetcher = function () {
  function EmptyDataFetcher(dataConfig) {
    _classCallCheck(this, EmptyDataFetcher);

    this.dataConfig = dataConfig;
  }

  _createClass(EmptyDataFetcher, [{
    key: "tilesetInfo",
    value: function tilesetInfo(callback) {
      this.tilesetInfoLoading = false;

      // Dummy values - not actually used
      var TILE_SIZE = 1024;
      var MAX_ZOOM = 22;

      var retVal = {
        tile_size: TILE_SIZE,
        bins_per_dimension: TILE_SIZE,
        max_zoom: MAX_ZOOM,
        max_width: TILE_SIZE * Math.pow(2, MAX_ZOOM),
        min_pos: [0],
        max_pos: [3000000000]
      };

      if (callback) {
        callback(retVal);
      }

      return retVal;
    }
  }, {
    key: "fetchTilesDebounced",
    value: function fetchTilesDebounced(receivedTiles, tileIds) {
      var tiles = {};
      return tiles;
    }
  }, {
    key: "tile",
    value: function tile(z, x) {
      return this.tilesetInfo().then(function (tsInfo) {
        return [];
      });
    }
  }]);

  return EmptyDataFetcher;
}();

/* harmony default export */ const es_EmptyDataFetcher = (EmptyDataFetcher);
;// CONCATENATED MODULE: ./node_modules/higlass-text/es/TextTrack.js
var TextTrack_createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function TextTrack_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var TextTrack = function TextTrack(HGC) {
  for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  if (!new.target) {
    throw new Error('Uncaught TypeError: Class constructor cannot be invoked without "new"');
  }

  // Services
  var tileProxy = HGC.services.tileProxy;

  // Utils

  var colorToHex = HGC.utils.colorToHex;

  var TextTrackClass = function (_HGC$tracks$BedLikeTr) {
    _inherits(TextTrackClass, _HGC$tracks$BedLikeTr);

    function TextTrackClass(context, options) {
      TextTrack_classCallCheck(this, TextTrackClass);

      context.dataFetcher = new es_EmptyDataFetcher(context.dataConfig);

      var _this = _possibleConstructorReturn(this, (TextTrackClass.__proto__ || Object.getPrototypeOf(TextTrackClass)).call(this, context, options));

      var animate = context.animate;

      _this.animate = animate;

      _this.isTrackShownVertically = context.definition.position === "left" || context.definition.position === "right";

      _this.options = options;
      _this.initOptions();
      return _this;
    }

    TextTrack_createClass(TextTrackClass, [{
      key: "initTile",
      value: function initTile(tile) {}
    }, {
      key: "initOptions",
      value: function initOptions() {
        this.fontSize = +this.options.fontSize;

        this.colors = {};
        this.colors["textColor"] = colorToHex(this.options.textColor);
        this.colors["black"] = colorToHex("#000000");
        this.colors["white"] = colorToHex("#ffffff");
        this.colors["lightgrey"] = colorToHex("#ededed");

        this.text = this.options.text;

        this.textOptions = {
          fontSize: this.fontSize + "px",
          fontFamily: this.options.fontFamily,
          fontWeight: this.options.fontWeight,
          fill: this.colors["textColor"]
        };
      }
    }, {
      key: "drawTile",
      value: function drawTile() {}

      /*
       * Redraw the track because the options
       * changed
       */

    }, {
      key: "rerender",
      value: function rerender(options, force) {
        var strOptions = JSON.stringify(options);
        if (!force && strOptions === this.prevOptions) return;

        this.options = options;
        this.initOptions();

        this.prevOptions = strOptions;

        this.renderText();

        requestAnimationFrame(this.animate);
      }
    }, {
      key: "drawTile",
      value: function drawTile(tile) {}
    }, {
      key: "renderTile",
      value: function renderTile(tile) {}
    }, {
      key: "draw",
      value: function draw() {}
    }, {
      key: "renderText",
      value: function renderText() {
        this.pForeground.clear();
        this.pForeground.removeChildren();

        var text = new HGC.libraries.PIXI.Text(this.text, this.textOptions);
        text.interactive = true;
        text.anchor.x = 0;
        text.anchor.y = 0;
        text.visible = true;
        text.y = this.options.offsetY;

        var margin = 5;
        text.x = margin;

        if (!this.isTrackShownVertically) {
          if (this.options.align === "left") {
            text.anchor.x = 0;
            text.x = margin;
            this.svgAnchor = "start";
          } else if (this.options.align === "middle") {
            text.anchor.x = 0.5;
            text.x = this.dimensions[0] / 2;
            this.svgAnchor = "middle";
          } else if (this.options.align === "right") {
            text.anchor.x = 1;
            text.x = this.dimensions[0] - margin;
            this.svgAnchor = "end";
          }
        } else {
          if (this.options.align === "right") {
            text.anchor.x = 1;
            text.scale.x *= -1;
            this.svgAnchor = "end";
          } else if (this.options.align === "middle") {
            text.anchor.x = 0.5;
            text.scale.x *= -1;
            text.x = this.dimensions[0] / 2;
            this.svgAnchor = "middle";
          } else if (this.options.align === "left") {
            text.anchor.x = 0;
            text.scale.x *= -1;
            text.x = this.dimensions[0] - margin;
            this.svgAnchor = "start";
          }
        }

        this.svgX = text.x;

        this.pForeground.addChild(text);
      }
    }, {
      key: "zoomedY",
      value: function zoomedY(yPos, kMultiplier) {}
    }, {
      key: "movedY",
      value: function movedY(dY) {}

      /** cleanup */

    }, {
      key: "destroyTile",
      value: function destroyTile(tile) {
        tile.graphics.destroy();
        tile = null;
      }
    }, {
      key: "setDimensions",
      value: function setDimensions(newDimensions) {
        _get(TextTrackClass.prototype.__proto__ || Object.getPrototypeOf(TextTrackClass.prototype), "setDimensions", this).call(this, newDimensions);
        // We have to rerender here, otherwise it does not fire at all sometimes
        this.rerender(this.options, false);
      }
    }, {
      key: "getMouseOverHtml",
      value: function getMouseOverHtml(trackX, trackY) {}
    }, {
      key: "exportSVG",
      value: function exportSVG() {
        var track = null;
        var base = null;

        base = document.createElement("g");
        track = base;

        var clipPathId = slugid.nice();

        var gClipPath = document.createElement("g");
        gClipPath.setAttribute("style", "clip-path:url(#" + clipPathId + ");");

        track.appendChild(gClipPath);

        // define the clipping area as a polygon defined by the track's
        // dimensions on the canvas
        var clipPath = document.createElementNS("http://www.w3.org/2000/svg", "clipPath");
        clipPath.setAttribute("id", clipPathId);
        track.appendChild(clipPath);

        var clipPolygon = document.createElementNS("http://www.w3.org/2000/svg", "polygon");
        clipPath.appendChild(clipPolygon);

        clipPolygon.setAttribute("points", this.position[0] + "," + this.position[1] + " " + (this.position[0] + this.dimensions[0] + "," + this.position[1] + " ") + (this.position[0] + this.dimensions[0] + "," + (this.position[1] + this.dimensions[1]) + " ") + (this.position[0] + "," + (this.position[1] + this.dimensions[1]) + " "));

        var output = document.createElement("g");

        output.setAttribute("transform", "translate(" + this.position[0] + "," + this.position[1] + ")");

        gClipPath.appendChild(output);

        // Background
        var gBackground = document.createElement("g");
        var rBackground = document.createElement("path");
        var dBackground = "M 0 0 H " + this.dimensions[0] + " V " + this.dimensions[1] + " H 0 Z";
        rBackground.setAttribute("d", dBackground);
        rBackground.setAttribute("fill", this.options.backgroundColor);
        rBackground.setAttribute("opacity", "1");
        gBackground.appendChild(rBackground);
        output.appendChild(gBackground);

        // Text
        var gText = document.createElement("g");
        var t = document.createElement("text");
        t.setAttribute("text-anchor", this.svgAnchor);
        t.setAttribute("font-family", this.options.fontFamily);
        t.setAttribute("font-size", this.fontSize + "px");
        //t.setAttribute("alignment-baseline", "top");
        t.setAttribute("font-weight", this.options.fontWeight);

        gText.setAttribute("transform", "scale(1,1)");

        t.setAttribute("fill", this.options.textColor);
        t.innerHTML = this.options.text;

        var scalefactor = this.isTrackShownVertically ? -1 : 1;

        gText.appendChild(t);
        gText.setAttribute("transform", "translate(" + this.svgX + "," + (this.options.offsetY + this.fontSize) + ")scale(" + scalefactor + ",1)");
        output.appendChild(gText);

        return [base, base];
      }
    }]);

    return TextTrackClass;
  }(HGC.tracks.BedLikeTrack);

  return new (Function.prototype.bind.apply(TextTrackClass, [null].concat(args)))();
};

var icon = '<svg width="20" height="20" xmlns="http://www.w3.org/2000/svg"><path fill="#fff" d="M-1-1h22v22H-1z"/><g><path stroke="#007fff" stroke-width="1.5" fill="#007fff" d="M-.667-.091h5v20.167h-5z"/><path stroke-width="1.5" stroke="#e8e500" fill="#e8e500" d="M5.667.242h5v20.167h-5z"/><path stroke-width="1.5" stroke="#ff0038" fill="#ff0038" d="M15.833.076h5v20.167h-5z"/><path stroke="green" stroke-width="1.5" fill="green" d="M10.833-.258H14.5v20.167h-3.667z"/></g></svg>';

// default
TextTrack.config = {
  type: "text",
  datatype: ["bedlike"],
  local: false,
  orientation: "1d-horizontal",
  thumbnail: new DOMParser().parseFromString(icon, "text/xml").documentElement,
  availableOptions: ["backgroundColor", "textColor", "fontSize", "fontWeight", "offsetY", "align", "text"],
  defaultOptions: {
    backgroundColor: "#ededed",
    textColor: "#333333",
    fontSize: 14,
    fontFamily: "Arial",
    fontWeight: "normal",
    align: "left",
    offsetY: 0,
    text: ""
  }
};

/* harmony default export */ const es_TextTrack = (TextTrack);
;// CONCATENATED MODULE: ./node_modules/higlass-text/es/index.js



// EXTERNAL MODULE: ./node_modules/rbush/rbush.min.js
var rbush_min = __webpack_require__(2582);
var rbush_min_default = /*#__PURE__*/__webpack_require__.n(rbush_min);
;// CONCATENATED MODULE: ./node_modules/d3-path/src/path.js
const path_pi = Math.PI,
    path_tau = 2 * path_pi,
    path_epsilon = 1e-6,
    tauEpsilon = path_tau - path_epsilon;

function Path() {
  this._x0 = this._y0 = // start of current subpath
  this._x1 = this._y1 = null; // end of current subpath
  this._ = "";
}

function path() {
  return new Path;
}

Path.prototype = path.prototype = {
  constructor: Path,
  moveTo: function(x, y) {
    this._ += "M" + (this._x0 = this._x1 = +x) + "," + (this._y0 = this._y1 = +y);
  },
  closePath: function() {
    if (this._x1 !== null) {
      this._x1 = this._x0, this._y1 = this._y0;
      this._ += "Z";
    }
  },
  lineTo: function(x, y) {
    this._ += "L" + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  quadraticCurveTo: function(x1, y1, x, y) {
    this._ += "Q" + (+x1) + "," + (+y1) + "," + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  bezierCurveTo: function(x1, y1, x2, y2, x, y) {
    this._ += "C" + (+x1) + "," + (+y1) + "," + (+x2) + "," + (+y2) + "," + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  arcTo: function(x1, y1, x2, y2, r) {
    x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;
    var x0 = this._x1,
        y0 = this._y1,
        x21 = x2 - x1,
        y21 = y2 - y1,
        x01 = x0 - x1,
        y01 = y0 - y1,
        l01_2 = x01 * x01 + y01 * y01;

    // Is the radius negative? Error.
    if (r < 0) throw new Error("negative radius: " + r);

    // Is this path empty? Move to (x1,y1).
    if (this._x1 === null) {
      this._ += "M" + (this._x1 = x1) + "," + (this._y1 = y1);
    }

    // Or, is (x1,y1) coincident with (x0,y0)? Do nothing.
    else if (!(l01_2 > path_epsilon));

    // Or, are (x0,y0), (x1,y1) and (x2,y2) collinear?
    // Equivalently, is (x1,y1) coincident with (x2,y2)?
    // Or, is the radius zero? Line to (x1,y1).
    else if (!(Math.abs(y01 * x21 - y21 * x01) > path_epsilon) || !r) {
      this._ += "L" + (this._x1 = x1) + "," + (this._y1 = y1);
    }

    // Otherwise, draw an arc!
    else {
      var x20 = x2 - x0,
          y20 = y2 - y0,
          l21_2 = x21 * x21 + y21 * y21,
          l20_2 = x20 * x20 + y20 * y20,
          l21 = Math.sqrt(l21_2),
          l01 = Math.sqrt(l01_2),
          l = r * Math.tan((path_pi - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2),
          t01 = l / l01,
          t21 = l / l21;

      // If the start tangent is not coincident with (x0,y0), line to.
      if (Math.abs(t01 - 1) > path_epsilon) {
        this._ += "L" + (x1 + t01 * x01) + "," + (y1 + t01 * y01);
      }

      this._ += "A" + r + "," + r + ",0,0," + (+(y01 * x20 > x01 * y20)) + "," + (this._x1 = x1 + t21 * x21) + "," + (this._y1 = y1 + t21 * y21);
    }
  },
  arc: function(x, y, r, a0, a1, ccw) {
    x = +x, y = +y, r = +r, ccw = !!ccw;
    var dx = r * Math.cos(a0),
        dy = r * Math.sin(a0),
        x0 = x + dx,
        y0 = y + dy,
        cw = 1 ^ ccw,
        da = ccw ? a0 - a1 : a1 - a0;

    // Is the radius negative? Error.
    if (r < 0) throw new Error("negative radius: " + r);

    // Is this path empty? Move to (x0,y0).
    if (this._x1 === null) {
      this._ += "M" + x0 + "," + y0;
    }

    // Or, is (x0,y0) not coincident with the previous point? Line to (x0,y0).
    else if (Math.abs(this._x1 - x0) > path_epsilon || Math.abs(this._y1 - y0) > path_epsilon) {
      this._ += "L" + x0 + "," + y0;
    }

    // Is this arc empty? We’re done.
    if (!r) return;

    // Does the angle go the wrong way? Flip the direction.
    if (da < 0) da = da % path_tau + path_tau;

    // Is this a complete circle? Draw two arcs to complete the circle.
    if (da > tauEpsilon) {
      this._ += "A" + r + "," + r + ",0,1," + cw + "," + (x - dx) + "," + (y - dy) + "A" + r + "," + r + ",0,1," + cw + "," + (this._x1 = x0) + "," + (this._y1 = y0);
    }

    // Is this arc non-empty? Draw an arc!
    else if (da > path_epsilon) {
      this._ += "A" + r + "," + r + ",0," + (+(da >= path_pi)) + "," + cw + "," + (this._x1 = x + r * Math.cos(a1)) + "," + (this._y1 = y + r * Math.sin(a1));
    }
  },
  rect: function(x, y, w, h) {
    this._ += "M" + (this._x0 = this._x1 = +x) + "," + (this._y0 = this._y1 = +y) + "h" + (+w) + "v" + (+h) + "h" + (-w) + "Z";
  },
  toString: function() {
    return this._;
  }
};

/* harmony default export */ const src_path = (path);

;// CONCATENATED MODULE: ./node_modules/d3-shape/src/constant.js
/* harmony default export */ function d3_shape_src_constant(x) {
  return function constant() {
    return x;
  };
}

;// CONCATENATED MODULE: ./node_modules/d3-shape/src/math.js
var math_abs = Math.abs;
var math_atan2 = Math.atan2;
var math_cos = Math.cos;
var math_max = Math.max;
var math_min = Math.min;
var math_sin = Math.sin;
var math_sqrt = Math.sqrt;

var math_epsilon = 1e-12;
var math_pi = Math.PI;
var halfPi = math_pi / 2;
var math_tau = 2 * math_pi;

function math_acos(x) {
  return x > 1 ? 0 : x < -1 ? math_pi : Math.acos(x);
}

function asin(x) {
  return x >= 1 ? halfPi : x <= -1 ? -halfPi : Math.asin(x);
}

;// CONCATENATED MODULE: ./node_modules/d3-shape/src/arc.js




function arcInnerRadius(d) {
  return d.innerRadius;
}

function arcOuterRadius(d) {
  return d.outerRadius;
}

function arcStartAngle(d) {
  return d.startAngle;
}

function arcEndAngle(d) {
  return d.endAngle;
}

function arcPadAngle(d) {
  return d && d.padAngle; // Note: optional!
}

function intersect(x0, y0, x1, y1, x2, y2, x3, y3) {
  var x10 = x1 - x0, y10 = y1 - y0,
      x32 = x3 - x2, y32 = y3 - y2,
      t = y32 * x10 - x32 * y10;
  if (t * t < math_epsilon) return;
  t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;
  return [x0 + t * x10, y0 + t * y10];
}

// Compute perpendicular offset line of length rc.
// http://mathworld.wolfram.com/Circle-LineIntersection.html
function cornerTangents(x0, y0, x1, y1, r1, rc, cw) {
  var x01 = x0 - x1,
      y01 = y0 - y1,
      lo = (cw ? rc : -rc) / math_sqrt(x01 * x01 + y01 * y01),
      ox = lo * y01,
      oy = -lo * x01,
      x11 = x0 + ox,
      y11 = y0 + oy,
      x10 = x1 + ox,
      y10 = y1 + oy,
      x00 = (x11 + x10) / 2,
      y00 = (y11 + y10) / 2,
      dx = x10 - x11,
      dy = y10 - y11,
      d2 = dx * dx + dy * dy,
      r = r1 - rc,
      D = x11 * y10 - x10 * y11,
      d = (dy < 0 ? -1 : 1) * math_sqrt(math_max(0, r * r * d2 - D * D)),
      cx0 = (D * dy - dx * d) / d2,
      cy0 = (-D * dx - dy * d) / d2,
      cx1 = (D * dy + dx * d) / d2,
      cy1 = (-D * dx + dy * d) / d2,
      dx0 = cx0 - x00,
      dy0 = cy0 - y00,
      dx1 = cx1 - x00,
      dy1 = cy1 - y00;

  // Pick the closer of the two intersection points.
  // TODO Is there a faster way to determine which intersection to use?
  if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;

  return {
    cx: cx0,
    cy: cy0,
    x01: -ox,
    y01: -oy,
    x11: cx0 * (r1 / r - 1),
    y11: cy0 * (r1 / r - 1)
  };
}

/* harmony default export */ function arc() {
  var innerRadius = arcInnerRadius,
      outerRadius = arcOuterRadius,
      cornerRadius = d3_shape_src_constant(0),
      padRadius = null,
      startAngle = arcStartAngle,
      endAngle = arcEndAngle,
      padAngle = arcPadAngle,
      context = null;

  function arc() {
    var buffer,
        r,
        r0 = +innerRadius.apply(this, arguments),
        r1 = +outerRadius.apply(this, arguments),
        a0 = startAngle.apply(this, arguments) - halfPi,
        a1 = endAngle.apply(this, arguments) - halfPi,
        da = math_abs(a1 - a0),
        cw = a1 > a0;

    if (!context) context = buffer = src_path();

    // Ensure that the outer radius is always larger than the inner radius.
    if (r1 < r0) r = r1, r1 = r0, r0 = r;

    // Is it a point?
    if (!(r1 > math_epsilon)) context.moveTo(0, 0);

    // Or is it a circle or annulus?
    else if (da > math_tau - math_epsilon) {
      context.moveTo(r1 * math_cos(a0), r1 * math_sin(a0));
      context.arc(0, 0, r1, a0, a1, !cw);
      if (r0 > math_epsilon) {
        context.moveTo(r0 * math_cos(a1), r0 * math_sin(a1));
        context.arc(0, 0, r0, a1, a0, cw);
      }
    }

    // Or is it a circular or annular sector?
    else {
      var a01 = a0,
          a11 = a1,
          a00 = a0,
          a10 = a1,
          da0 = da,
          da1 = da,
          ap = padAngle.apply(this, arguments) / 2,
          rp = (ap > math_epsilon) && (padRadius ? +padRadius.apply(this, arguments) : math_sqrt(r0 * r0 + r1 * r1)),
          rc = math_min(math_abs(r1 - r0) / 2, +cornerRadius.apply(this, arguments)),
          rc0 = rc,
          rc1 = rc,
          t0,
          t1;

      // Apply padding? Note that since r1 ≥ r0, da1 ≥ da0.
      if (rp > math_epsilon) {
        var p0 = asin(rp / r0 * math_sin(ap)),
            p1 = asin(rp / r1 * math_sin(ap));
        if ((da0 -= p0 * 2) > math_epsilon) p0 *= (cw ? 1 : -1), a00 += p0, a10 -= p0;
        else da0 = 0, a00 = a10 = (a0 + a1) / 2;
        if ((da1 -= p1 * 2) > math_epsilon) p1 *= (cw ? 1 : -1), a01 += p1, a11 -= p1;
        else da1 = 0, a01 = a11 = (a0 + a1) / 2;
      }

      var x01 = r1 * math_cos(a01),
          y01 = r1 * math_sin(a01),
          x10 = r0 * math_cos(a10),
          y10 = r0 * math_sin(a10);

      // Apply rounded corners?
      if (rc > math_epsilon) {
        var x11 = r1 * math_cos(a11),
            y11 = r1 * math_sin(a11),
            x00 = r0 * math_cos(a00),
            y00 = r0 * math_sin(a00),
            oc;

        // Restrict the corner radius according to the sector angle.
        if (da < math_pi && (oc = intersect(x01, y01, x00, y00, x11, y11, x10, y10))) {
          var ax = x01 - oc[0],
              ay = y01 - oc[1],
              bx = x11 - oc[0],
              by = y11 - oc[1],
              kc = 1 / math_sin(math_acos((ax * bx + ay * by) / (math_sqrt(ax * ax + ay * ay) * math_sqrt(bx * bx + by * by))) / 2),
              lc = math_sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
          rc0 = math_min(rc, (r0 - lc) / (kc - 1));
          rc1 = math_min(rc, (r1 - lc) / (kc + 1));
        }
      }

      // Is the sector collapsed to a line?
      if (!(da1 > math_epsilon)) context.moveTo(x01, y01);

      // Does the sector’s outer ring have rounded corners?
      else if (rc1 > math_epsilon) {
        t0 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);
        t1 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);

        context.moveTo(t0.cx + t0.x01, t0.cy + t0.y01);

        // Have the corners merged?
        if (rc1 < rc) context.arc(t0.cx, t0.cy, rc1, math_atan2(t0.y01, t0.x01), math_atan2(t1.y01, t1.x01), !cw);

        // Otherwise, draw the two corners and the ring.
        else {
          context.arc(t0.cx, t0.cy, rc1, math_atan2(t0.y01, t0.x01), math_atan2(t0.y11, t0.x11), !cw);
          context.arc(0, 0, r1, math_atan2(t0.cy + t0.y11, t0.cx + t0.x11), math_atan2(t1.cy + t1.y11, t1.cx + t1.x11), !cw);
          context.arc(t1.cx, t1.cy, rc1, math_atan2(t1.y11, t1.x11), math_atan2(t1.y01, t1.x01), !cw);
        }
      }

      // Or is the outer ring just a circular arc?
      else context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);

      // Is there no inner ring, and it’s a circular sector?
      // Or perhaps it’s an annular sector collapsed due to padding?
      if (!(r0 > math_epsilon) || !(da0 > math_epsilon)) context.lineTo(x10, y10);

      // Does the sector’s inner ring (or point) have rounded corners?
      else if (rc0 > math_epsilon) {
        t0 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
        t1 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);

        context.lineTo(t0.cx + t0.x01, t0.cy + t0.y01);

        // Have the corners merged?
        if (rc0 < rc) context.arc(t0.cx, t0.cy, rc0, math_atan2(t0.y01, t0.x01), math_atan2(t1.y01, t1.x01), !cw);

        // Otherwise, draw the two corners and the ring.
        else {
          context.arc(t0.cx, t0.cy, rc0, math_atan2(t0.y01, t0.x01), math_atan2(t0.y11, t0.x11), !cw);
          context.arc(0, 0, r0, math_atan2(t0.cy + t0.y11, t0.cx + t0.x11), math_atan2(t1.cy + t1.y11, t1.cx + t1.x11), cw);
          context.arc(t1.cx, t1.cy, rc0, math_atan2(t1.y11, t1.x11), math_atan2(t1.y01, t1.x01), !cw);
        }
      }

      // Or is the inner ring just a circular arc?
      else context.arc(0, 0, r0, a10, a00, cw);
    }

    context.closePath();

    if (buffer) return context = null, buffer + "" || null;
  }

  arc.centroid = function() {
    var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2,
        a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - math_pi / 2;
    return [math_cos(a) * r, math_sin(a) * r];
  };

  arc.innerRadius = function(_) {
    return arguments.length ? (innerRadius = typeof _ === "function" ? _ : d3_shape_src_constant(+_), arc) : innerRadius;
  };

  arc.outerRadius = function(_) {
    return arguments.length ? (outerRadius = typeof _ === "function" ? _ : d3_shape_src_constant(+_), arc) : outerRadius;
  };

  arc.cornerRadius = function(_) {
    return arguments.length ? (cornerRadius = typeof _ === "function" ? _ : d3_shape_src_constant(+_), arc) : cornerRadius;
  };

  arc.padRadius = function(_) {
    return arguments.length ? (padRadius = _ == null ? null : typeof _ === "function" ? _ : d3_shape_src_constant(+_), arc) : padRadius;
  };

  arc.startAngle = function(_) {
    return arguments.length ? (startAngle = typeof _ === "function" ? _ : d3_shape_src_constant(+_), arc) : startAngle;
  };

  arc.endAngle = function(_) {
    return arguments.length ? (endAngle = typeof _ === "function" ? _ : d3_shape_src_constant(+_), arc) : endAngle;
  };

  arc.padAngle = function(_) {
    return arguments.length ? (padAngle = typeof _ === "function" ? _ : d3_shape_src_constant(+_), arc) : padAngle;
  };

  arc.context = function(_) {
    return arguments.length ? ((context = _ == null ? null : _), arc) : context;
  };

  return arc;
}

;// CONCATENATED MODULE: ./node_modules/d3-dsv/src/dsv.js
var EOL = {},
    EOF = {},
    QUOTE = 34,
    NEWLINE = 10,
    RETURN = 13;

function objectConverter(columns) {
  return new Function("d", "return {" + columns.map(function(name, i) {
    return JSON.stringify(name) + ": d[" + i + "] || \"\"";
  }).join(",") + "}");
}

function customConverter(columns, f) {
  var object = objectConverter(columns);
  return function(row, i) {
    return f(object(row), i, columns);
  };
}

// Compute unique columns in order of discovery.
function inferColumns(rows) {
  var columnSet = Object.create(null),
      columns = [];

  rows.forEach(function(row) {
    for (var column in row) {
      if (!(column in columnSet)) {
        columns.push(columnSet[column] = column);
      }
    }
  });

  return columns;
}

function pad(value, width) {
  var s = value + "", length = s.length;
  return length < width ? new Array(width - length + 1).join(0) + s : s;
}

function formatYear(year) {
  return year < 0 ? "-" + pad(-year, 6)
    : year > 9999 ? "+" + pad(year, 6)
    : pad(year, 4);
}

function formatDate(date) {
  var hours = date.getUTCHours(),
      minutes = date.getUTCMinutes(),
      seconds = date.getUTCSeconds(),
      milliseconds = date.getUTCMilliseconds();
  return isNaN(date) ? "Invalid Date"
      : formatYear(date.getUTCFullYear(), 4) + "-" + pad(date.getUTCMonth() + 1, 2) + "-" + pad(date.getUTCDate(), 2)
      + (milliseconds ? "T" + pad(hours, 2) + ":" + pad(minutes, 2) + ":" + pad(seconds, 2) + "." + pad(milliseconds, 3) + "Z"
      : seconds ? "T" + pad(hours, 2) + ":" + pad(minutes, 2) + ":" + pad(seconds, 2) + "Z"
      : minutes || hours ? "T" + pad(hours, 2) + ":" + pad(minutes, 2) + "Z"
      : "");
}

/* harmony default export */ function dsv(delimiter) {
  var reFormat = new RegExp("[\"" + delimiter + "\n\r]"),
      DELIMITER = delimiter.charCodeAt(0);

  function parse(text, f) {
    var convert, columns, rows = parseRows(text, function(row, i) {
      if (convert) return convert(row, i - 1);
      columns = row, convert = f ? customConverter(row, f) : objectConverter(row);
    });
    rows.columns = columns || [];
    return rows;
  }

  function parseRows(text, f) {
    var rows = [], // output rows
        N = text.length,
        I = 0, // current character index
        n = 0, // current line number
        t, // current token
        eof = N <= 0, // current token followed by EOF?
        eol = false; // current token followed by EOL?

    // Strip the trailing newline.
    if (text.charCodeAt(N - 1) === NEWLINE) --N;
    if (text.charCodeAt(N - 1) === RETURN) --N;

    function token() {
      if (eof) return EOF;
      if (eol) return eol = false, EOL;

      // Unescape quotes.
      var i, j = I, c;
      if (text.charCodeAt(j) === QUOTE) {
        while (I++ < N && text.charCodeAt(I) !== QUOTE || text.charCodeAt(++I) === QUOTE);
        if ((i = I) >= N) eof = true;
        else if ((c = text.charCodeAt(I++)) === NEWLINE) eol = true;
        else if (c === RETURN) { eol = true; if (text.charCodeAt(I) === NEWLINE) ++I; }
        return text.slice(j + 1, i - 1).replace(/""/g, "\"");
      }

      // Find next delimiter or newline.
      while (I < N) {
        if ((c = text.charCodeAt(i = I++)) === NEWLINE) eol = true;
        else if (c === RETURN) { eol = true; if (text.charCodeAt(I) === NEWLINE) ++I; }
        else if (c !== DELIMITER) continue;
        return text.slice(j, i);
      }

      // Return last token before EOF.
      return eof = true, text.slice(j, N);
    }

    while ((t = token()) !== EOF) {
      var row = [];
      while (t !== EOL && t !== EOF) row.push(t), t = token();
      if (f && (row = f(row, n++)) == null) continue;
      rows.push(row);
    }

    return rows;
  }

  function preformatBody(rows, columns) {
    return rows.map(function(row) {
      return columns.map(function(column) {
        return formatValue(row[column]);
      }).join(delimiter);
    });
  }

  function format(rows, columns) {
    if (columns == null) columns = inferColumns(rows);
    return [columns.map(formatValue).join(delimiter)].concat(preformatBody(rows, columns)).join("\n");
  }

  function formatBody(rows, columns) {
    if (columns == null) columns = inferColumns(rows);
    return preformatBody(rows, columns).join("\n");
  }

  function formatRows(rows) {
    return rows.map(formatRow).join("\n");
  }

  function formatRow(row) {
    return row.map(formatValue).join(delimiter);
  }

  function formatValue(value) {
    return value == null ? ""
        : value instanceof Date ? formatDate(value)
        : reFormat.test(value += "") ? "\"" + value.replace(/"/g, "\"\"") + "\""
        : value;
  }

  return {
    parse: parse,
    parseRows: parseRows,
    format: format,
    formatBody: formatBody,
    formatRows: formatRows,
    formatRow: formatRow,
    formatValue: formatValue
  };
}

// EXTERNAL MODULE: ./node_modules/buffer/index.js
var buffer = __webpack_require__(8764);
;// CONCATENATED MODULE: ./node_modules/fflate/esm/browser.js
// DEFLATE is a complex format; to read this code, you should probably check the RFC first:
// https://tools.ietf.org/html/rfc1951
// You may also wish to take a look at the guide I made about this program:
// https://gist.github.com/101arrowz/253f31eb5abc3d9275ab943003ffecad
// Some of the following code is similar to that of UZIP.js:
// https://github.com/photopea/UZIP.js
// However, the vast majority of the codebase has diverged from UZIP.js to increase performance and reduce bundle size.
// Sometimes 0 will appear where -1 would be more appropriate. This is because using a uint
// is better for memory in most engines (I *think*).
var ch2 = {};
var wk = (function (c, id, msg, transfer, cb) {
    var w = new Worker(ch2[id] || (ch2[id] = URL.createObjectURL(new Blob([
        c + ';addEventListener("error",function(e){e=e.error;postMessage({$e$:[e.message,e.code,e.stack]})})'
    ], { type: 'text/javascript' }))));
    w.onmessage = function (e) {
        var d = e.data, ed = d.$e$;
        if (ed) {
            var err = new Error(ed[0]);
            err['code'] = ed[1];
            err.stack = ed[2];
            cb(err, null);
        }
        else
            cb(null, d);
    };
    w.postMessage(msg, transfer);
    return w;
});

// aliases for shorter compressed code (most minifers don't do this)
var u8 = Uint8Array, u16 = Uint16Array, u32 = Uint32Array;
// fixed length extra bits
var fleb = new u8([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, /* unused */ 0, 0, /* impossible */ 0]);
// fixed distance extra bits
// see fleb note
var fdeb = new u8([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, /* unused */ 0, 0]);
// code length index map
var clim = new u8([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
// get base, reverse index map from extra bits
var freb = function (eb, start) {
    var b = new u16(31);
    for (var i = 0; i < 31; ++i) {
        b[i] = start += 1 << eb[i - 1];
    }
    // numbers here are at max 18 bits
    var r = new u32(b[30]);
    for (var i = 1; i < 30; ++i) {
        for (var j = b[i]; j < b[i + 1]; ++j) {
            r[j] = ((j - b[i]) << 5) | i;
        }
    }
    return [b, r];
};
var _a = freb(fleb, 2), fl = _a[0], revfl = _a[1];
// we can ignore the fact that the other numbers are wrong; they never happen anyway
fl[28] = 258, revfl[258] = 28;
var _b = freb(fdeb, 0), fd = _b[0], revfd = _b[1];
// map of value to reverse (assuming 16 bits)
var rev = new u16(32768);
for (var i = 0; i < 32768; ++i) {
    // reverse table algorithm from SO
    var x = ((i & 0xAAAA) >>> 1) | ((i & 0x5555) << 1);
    x = ((x & 0xCCCC) >>> 2) | ((x & 0x3333) << 2);
    x = ((x & 0xF0F0) >>> 4) | ((x & 0x0F0F) << 4);
    rev[i] = (((x & 0xFF00) >>> 8) | ((x & 0x00FF) << 8)) >>> 1;
}
// create huffman tree from u8 "map": index -> code length for code index
// mb (max bits) must be at most 15
// TODO: optimize/split up?
var hMap = (function (cd, mb, r) {
    var s = cd.length;
    // index
    var i = 0;
    // u16 "map": index -> # of codes with bit length = index
    var l = new u16(mb);
    // length of cd must be 288 (total # of codes)
    for (; i < s; ++i) {
        if (cd[i])
            ++l[cd[i] - 1];
    }
    // u16 "map": index -> minimum code for bit length = index
    var le = new u16(mb);
    for (i = 0; i < mb; ++i) {
        le[i] = (le[i - 1] + l[i - 1]) << 1;
    }
    var co;
    if (r) {
        // u16 "map": index -> number of actual bits, symbol for code
        co = new u16(1 << mb);
        // bits to remove for reverser
        var rvb = 15 - mb;
        for (i = 0; i < s; ++i) {
            // ignore 0 lengths
            if (cd[i]) {
                // num encoding both symbol and bits read
                var sv = (i << 4) | cd[i];
                // free bits
                var r_1 = mb - cd[i];
                // start value
                var v = le[cd[i] - 1]++ << r_1;
                // m is end value
                for (var m = v | ((1 << r_1) - 1); v <= m; ++v) {
                    // every 16 bit value starting with the code yields the same result
                    co[rev[v] >>> rvb] = sv;
                }
            }
        }
    }
    else {
        co = new u16(s);
        for (i = 0; i < s; ++i) {
            if (cd[i]) {
                co[i] = rev[le[cd[i] - 1]++] >>> (15 - cd[i]);
            }
        }
    }
    return co;
});
// fixed length tree
var flt = new u8(288);
for (var i = 0; i < 144; ++i)
    flt[i] = 8;
for (var i = 144; i < 256; ++i)
    flt[i] = 9;
for (var i = 256; i < 280; ++i)
    flt[i] = 7;
for (var i = 280; i < 288; ++i)
    flt[i] = 8;
// fixed distance tree
var fdt = new u8(32);
for (var i = 0; i < 32; ++i)
    fdt[i] = 5;
// fixed length map
var flm = /*#__PURE__*/ (/* unused pure expression or super */ null && (hMap(flt, 9, 0))), flrm = /*#__PURE__*/ hMap(flt, 9, 1);
// fixed distance map
var fdm = /*#__PURE__*/ (/* unused pure expression or super */ null && (hMap(fdt, 5, 0))), fdrm = /*#__PURE__*/ hMap(fdt, 5, 1);
// find max of array
var browser_max = function (a) {
    var m = a[0];
    for (var i = 1; i < a.length; ++i) {
        if (a[i] > m)
            m = a[i];
    }
    return m;
};
// read d, starting at bit p and mask with m
var bits = function (d, p, m) {
    var o = (p / 8) | 0;
    return ((d[o] | (d[o + 1] << 8)) >> (p & 7)) & m;
};
// read d, starting at bit p continuing for at least 16 bits
var bits16 = function (d, p) {
    var o = (p / 8) | 0;
    return ((d[o] | (d[o + 1] << 8) | (d[o + 2] << 16)) >> (p & 7));
};
// get end of byte
var shft = function (p) { return ((p + 7) / 8) | 0; };
// typed array slice - allows garbage collector to free original reference,
// while being more compatible than .slice
var slc = function (v, s, e) {
    if (s == null || s < 0)
        s = 0;
    if (e == null || e > v.length)
        e = v.length;
    // can't use .constructor in case user-supplied
    var n = new (v.BYTES_PER_ELEMENT == 2 ? u16 : v.BYTES_PER_ELEMENT == 4 ? u32 : u8)(e - s);
    n.set(v.subarray(s, e));
    return n;
};
/**
 * Codes for errors generated within this library
 */
var FlateErrorCode = {
    UnexpectedEOF: 0,
    InvalidBlockType: 1,
    InvalidLengthLiteral: 2,
    InvalidDistance: 3,
    StreamFinished: 4,
    NoStreamHandler: 5,
    InvalidHeader: 6,
    NoCallback: 7,
    InvalidUTF8: 8,
    ExtraFieldTooLong: 9,
    InvalidDate: 10,
    FilenameTooLong: 11,
    StreamFinishing: 12,
    InvalidZipData: 13,
    UnknownCompressionMethod: 14
};
// error codes
var ec = [
    'unexpected EOF',
    'invalid block type',
    'invalid length/literal',
    'invalid distance',
    'stream finished',
    'no stream handler',
    ,
    'no callback',
    'invalid UTF-8 data',
    'extra field too long',
    'date not in range 1980-2099',
    'filename too long',
    'stream finishing',
    'invalid zip data'
    // determined by unknown compression method
];
;
var err = function (ind, msg, nt) {
    var e = new Error(msg || ec[ind]);
    e.code = ind;
    if (Error.captureStackTrace)
        Error.captureStackTrace(e, err);
    if (!nt)
        throw e;
    return e;
};
// expands raw DEFLATE data
var inflt = function (dat, buf, st) {
    // source length
    var sl = dat.length;
    if (!sl || (st && st.f && !st.l))
        return buf || new u8(0);
    // have to estimate size
    var noBuf = !buf || st;
    // no state
    var noSt = !st || st.i;
    if (!st)
        st = {};
    // Assumes roughly 33% compression ratio average
    if (!buf)
        buf = new u8(sl * 3);
    // ensure buffer can fit at least l elements
    var cbuf = function (l) {
        var bl = buf.length;
        // need to increase size to fit
        if (l > bl) {
            // Double or set to necessary, whichever is greater
            var nbuf = new u8(Math.max(bl * 2, l));
            nbuf.set(buf);
            buf = nbuf;
        }
    };
    //  last chunk         bitpos           bytes
    var final = st.f || 0, pos = st.p || 0, bt = st.b || 0, lm = st.l, dm = st.d, lbt = st.m, dbt = st.n;
    // total bits
    var tbts = sl * 8;
    do {
        if (!lm) {
            // BFINAL - this is only 1 when last chunk is next
            final = bits(dat, pos, 1);
            // type: 0 = no compression, 1 = fixed huffman, 2 = dynamic huffman
            var type = bits(dat, pos + 1, 3);
            pos += 3;
            if (!type) {
                // go to end of byte boundary
                var s = shft(pos) + 4, l = dat[s - 4] | (dat[s - 3] << 8), t = s + l;
                if (t > sl) {
                    if (noSt)
                        err(0);
                    break;
                }
                // ensure size
                if (noBuf)
                    cbuf(bt + l);
                // Copy over uncompressed data
                buf.set(dat.subarray(s, t), bt);
                // Get new bitpos, update byte count
                st.b = bt += l, st.p = pos = t * 8, st.f = final;
                continue;
            }
            else if (type == 1)
                lm = flrm, dm = fdrm, lbt = 9, dbt = 5;
            else if (type == 2) {
                //  literal                            lengths
                var hLit = bits(dat, pos, 31) + 257, hcLen = bits(dat, pos + 10, 15) + 4;
                var tl = hLit + bits(dat, pos + 5, 31) + 1;
                pos += 14;
                // length+distance tree
                var ldt = new u8(tl);
                // code length tree
                var clt = new u8(19);
                for (var i = 0; i < hcLen; ++i) {
                    // use index map to get real code
                    clt[clim[i]] = bits(dat, pos + i * 3, 7);
                }
                pos += hcLen * 3;
                // code lengths bits
                var clb = browser_max(clt), clbmsk = (1 << clb) - 1;
                // code lengths map
                var clm = hMap(clt, clb, 1);
                for (var i = 0; i < tl;) {
                    var r = clm[bits(dat, pos, clbmsk)];
                    // bits read
                    pos += r & 15;
                    // symbol
                    var s = r >>> 4;
                    // code length to copy
                    if (s < 16) {
                        ldt[i++] = s;
                    }
                    else {
                        //  copy   count
                        var c = 0, n = 0;
                        if (s == 16)
                            n = 3 + bits(dat, pos, 3), pos += 2, c = ldt[i - 1];
                        else if (s == 17)
                            n = 3 + bits(dat, pos, 7), pos += 3;
                        else if (s == 18)
                            n = 11 + bits(dat, pos, 127), pos += 7;
                        while (n--)
                            ldt[i++] = c;
                    }
                }
                //    length tree                 distance tree
                var lt = ldt.subarray(0, hLit), dt = ldt.subarray(hLit);
                // max length bits
                lbt = browser_max(lt);
                // max dist bits
                dbt = browser_max(dt);
                lm = hMap(lt, lbt, 1);
                dm = hMap(dt, dbt, 1);
            }
            else
                err(1);
            if (pos > tbts) {
                if (noSt)
                    err(0);
                break;
            }
        }
        // Make sure the buffer can hold this + the largest possible addition
        // Maximum chunk size (practically, theoretically infinite) is 2^17;
        if (noBuf)
            cbuf(bt + 131072);
        var lms = (1 << lbt) - 1, dms = (1 << dbt) - 1;
        var lpos = pos;
        for (;; lpos = pos) {
            // bits read, code
            var c = lm[bits16(dat, pos) & lms], sym = c >>> 4;
            pos += c & 15;
            if (pos > tbts) {
                if (noSt)
                    err(0);
                break;
            }
            if (!c)
                err(2);
            if (sym < 256)
                buf[bt++] = sym;
            else if (sym == 256) {
                lpos = pos, lm = null;
                break;
            }
            else {
                var add = sym - 254;
                // no extra bits needed if less
                if (sym > 264) {
                    // index
                    var i = sym - 257, b = fleb[i];
                    add = bits(dat, pos, (1 << b) - 1) + fl[i];
                    pos += b;
                }
                // dist
                var d = dm[bits16(dat, pos) & dms], dsym = d >>> 4;
                if (!d)
                    err(3);
                pos += d & 15;
                var dt = fd[dsym];
                if (dsym > 3) {
                    var b = fdeb[dsym];
                    dt += bits16(dat, pos) & ((1 << b) - 1), pos += b;
                }
                if (pos > tbts) {
                    if (noSt)
                        err(0);
                    break;
                }
                if (noBuf)
                    cbuf(bt + 131072);
                var end = bt + add;
                for (; bt < end; bt += 4) {
                    buf[bt] = buf[bt - dt];
                    buf[bt + 1] = buf[bt + 1 - dt];
                    buf[bt + 2] = buf[bt + 2 - dt];
                    buf[bt + 3] = buf[bt + 3 - dt];
                }
                bt = end;
            }
        }
        st.l = lm, st.p = lpos, st.b = bt, st.f = final;
        if (lm)
            final = 1, st.m = lbt, st.d = dm, st.n = dbt;
    } while (!final);
    return bt == buf.length ? buf : slc(buf, 0, bt);
};
// starting at p, write the minimum number of bits that can hold v to d
var wbits = function (d, p, v) {
    v <<= p & 7;
    var o = (p / 8) | 0;
    d[o] |= v;
    d[o + 1] |= v >>> 8;
};
// starting at p, write the minimum number of bits (>8) that can hold v to d
var wbits16 = function (d, p, v) {
    v <<= p & 7;
    var o = (p / 8) | 0;
    d[o] |= v;
    d[o + 1] |= v >>> 8;
    d[o + 2] |= v >>> 16;
};
// creates code lengths from a frequency table
var hTree = function (d, mb) {
    // Need extra info to make a tree
    var t = [];
    for (var i = 0; i < d.length; ++i) {
        if (d[i])
            t.push({ s: i, f: d[i] });
    }
    var s = t.length;
    var t2 = t.slice();
    if (!s)
        return [et, 0];
    if (s == 1) {
        var v = new u8(t[0].s + 1);
        v[t[0].s] = 1;
        return [v, 1];
    }
    t.sort(function (a, b) { return a.f - b.f; });
    // after i2 reaches last ind, will be stopped
    // freq must be greater than largest possible number of symbols
    t.push({ s: -1, f: 25001 });
    var l = t[0], r = t[1], i0 = 0, i1 = 1, i2 = 2;
    t[0] = { s: -1, f: l.f + r.f, l: l, r: r };
    // efficient algorithm from UZIP.js
    // i0 is lookbehind, i2 is lookahead - after processing two low-freq
    // symbols that combined have high freq, will start processing i2 (high-freq,
    // non-composite) symbols instead
    // see https://reddit.com/r/photopea/comments/ikekht/uzipjs_questions/
    while (i1 != s - 1) {
        l = t[t[i0].f < t[i2].f ? i0++ : i2++];
        r = t[i0 != i1 && t[i0].f < t[i2].f ? i0++ : i2++];
        t[i1++] = { s: -1, f: l.f + r.f, l: l, r: r };
    }
    var maxSym = t2[0].s;
    for (var i = 1; i < s; ++i) {
        if (t2[i].s > maxSym)
            maxSym = t2[i].s;
    }
    // code lengths
    var tr = new u16(maxSym + 1);
    // max bits in tree
    var mbt = ln(t[i1 - 1], tr, 0);
    if (mbt > mb) {
        // more algorithms from UZIP.js
        // TODO: find out how this code works (debt)
        //  ind    debt
        var i = 0, dt = 0;
        //    left            cost
        var lft = mbt - mb, cst = 1 << lft;
        t2.sort(function (a, b) { return tr[b.s] - tr[a.s] || a.f - b.f; });
        for (; i < s; ++i) {
            var i2_1 = t2[i].s;
            if (tr[i2_1] > mb) {
                dt += cst - (1 << (mbt - tr[i2_1]));
                tr[i2_1] = mb;
            }
            else
                break;
        }
        dt >>>= lft;
        while (dt > 0) {
            var i2_2 = t2[i].s;
            if (tr[i2_2] < mb)
                dt -= 1 << (mb - tr[i2_2]++ - 1);
            else
                ++i;
        }
        for (; i >= 0 && dt; --i) {
            var i2_3 = t2[i].s;
            if (tr[i2_3] == mb) {
                --tr[i2_3];
                ++dt;
            }
        }
        mbt = mb;
    }
    return [new u8(tr), mbt];
};
// get the max length and assign length codes
var ln = function (n, l, d) {
    return n.s == -1
        ? Math.max(ln(n.l, l, d + 1), ln(n.r, l, d + 1))
        : (l[n.s] = d);
};
// length codes generation
var lc = function (c) {
    var s = c.length;
    // Note that the semicolon was intentional
    while (s && !c[--s])
        ;
    var cl = new u16(++s);
    //  ind      num         streak
    var cli = 0, cln = c[0], cls = 1;
    var w = function (v) { cl[cli++] = v; };
    for (var i = 1; i <= s; ++i) {
        if (c[i] == cln && i != s)
            ++cls;
        else {
            if (!cln && cls > 2) {
                for (; cls > 138; cls -= 138)
                    w(32754);
                if (cls > 2) {
                    w(cls > 10 ? ((cls - 11) << 5) | 28690 : ((cls - 3) << 5) | 12305);
                    cls = 0;
                }
            }
            else if (cls > 3) {
                w(cln), --cls;
                for (; cls > 6; cls -= 6)
                    w(8304);
                if (cls > 2)
                    w(((cls - 3) << 5) | 8208), cls = 0;
            }
            while (cls--)
                w(cln);
            cls = 1;
            cln = c[i];
        }
    }
    return [cl.subarray(0, cli), s];
};
// calculate the length of output from tree, code lengths
var clen = function (cf, cl) {
    var l = 0;
    for (var i = 0; i < cl.length; ++i)
        l += cf[i] * cl[i];
    return l;
};
// writes a fixed block
// returns the new bit pos
var wfblk = function (out, pos, dat) {
    // no need to write 00 as type: TypedArray defaults to 0
    var s = dat.length;
    var o = shft(pos + 2);
    out[o] = s & 255;
    out[o + 1] = s >>> 8;
    out[o + 2] = out[o] ^ 255;
    out[o + 3] = out[o + 1] ^ 255;
    for (var i = 0; i < s; ++i)
        out[o + i + 4] = dat[i];
    return (o + 4 + s) * 8;
};
// writes a block
var wblk = function (dat, out, final, syms, lf, df, eb, li, bs, bl, p) {
    wbits(out, p++, final);
    ++lf[256];
    var _a = hTree(lf, 15), dlt = _a[0], mlb = _a[1];
    var _b = hTree(df, 15), ddt = _b[0], mdb = _b[1];
    var _c = lc(dlt), lclt = _c[0], nlc = _c[1];
    var _d = lc(ddt), lcdt = _d[0], ndc = _d[1];
    var lcfreq = new u16(19);
    for (var i = 0; i < lclt.length; ++i)
        lcfreq[lclt[i] & 31]++;
    for (var i = 0; i < lcdt.length; ++i)
        lcfreq[lcdt[i] & 31]++;
    var _e = hTree(lcfreq, 7), lct = _e[0], mlcb = _e[1];
    var nlcc = 19;
    for (; nlcc > 4 && !lct[clim[nlcc - 1]]; --nlcc)
        ;
    var flen = (bl + 5) << 3;
    var ftlen = clen(lf, flt) + clen(df, fdt) + eb;
    var dtlen = clen(lf, dlt) + clen(df, ddt) + eb + 14 + 3 * nlcc + clen(lcfreq, lct) + (2 * lcfreq[16] + 3 * lcfreq[17] + 7 * lcfreq[18]);
    if (flen <= ftlen && flen <= dtlen)
        return wfblk(out, p, dat.subarray(bs, bs + bl));
    var lm, ll, dm, dl;
    wbits(out, p, 1 + (dtlen < ftlen)), p += 2;
    if (dtlen < ftlen) {
        lm = hMap(dlt, mlb, 0), ll = dlt, dm = hMap(ddt, mdb, 0), dl = ddt;
        var llm = hMap(lct, mlcb, 0);
        wbits(out, p, nlc - 257);
        wbits(out, p + 5, ndc - 1);
        wbits(out, p + 10, nlcc - 4);
        p += 14;
        for (var i = 0; i < nlcc; ++i)
            wbits(out, p + 3 * i, lct[clim[i]]);
        p += 3 * nlcc;
        var lcts = [lclt, lcdt];
        for (var it = 0; it < 2; ++it) {
            var clct = lcts[it];
            for (var i = 0; i < clct.length; ++i) {
                var len = clct[i] & 31;
                wbits(out, p, llm[len]), p += lct[len];
                if (len > 15)
                    wbits(out, p, (clct[i] >>> 5) & 127), p += clct[i] >>> 12;
            }
        }
    }
    else {
        lm = flm, ll = flt, dm = fdm, dl = fdt;
    }
    for (var i = 0; i < li; ++i) {
        if (syms[i] > 255) {
            var len = (syms[i] >>> 18) & 31;
            wbits16(out, p, lm[len + 257]), p += ll[len + 257];
            if (len > 7)
                wbits(out, p, (syms[i] >>> 23) & 31), p += fleb[len];
            var dst = syms[i] & 31;
            wbits16(out, p, dm[dst]), p += dl[dst];
            if (dst > 3)
                wbits16(out, p, (syms[i] >>> 5) & 8191), p += fdeb[dst];
        }
        else {
            wbits16(out, p, lm[syms[i]]), p += ll[syms[i]];
        }
    }
    wbits16(out, p, lm[256]);
    return p + ll[256];
};
// deflate options (nice << 13) | chain
var deo = /*#__PURE__*/ new u32([65540, 131080, 131088, 131104, 262176, 1048704, 1048832, 2114560, 2117632]);
// empty
var et = /*#__PURE__*/ new u8(0);
// compresses data into a raw DEFLATE buffer
var dflt = function (dat, lvl, plvl, pre, post, lst) {
    var s = dat.length;
    var o = new u8(pre + s + 5 * (1 + Math.ceil(s / 7000)) + post);
    // writing to this writes to the output buffer
    var w = o.subarray(pre, o.length - post);
    var pos = 0;
    if (!lvl || s < 8) {
        for (var i = 0; i <= s; i += 65535) {
            // end
            var e = i + 65535;
            if (e >= s) {
                // write final block
                w[pos >> 3] = lst;
            }
            pos = wfblk(w, pos + 1, dat.subarray(i, e));
        }
    }
    else {
        var opt = deo[lvl - 1];
        var n = opt >>> 13, c = opt & 8191;
        var msk_1 = (1 << plvl) - 1;
        //    prev 2-byte val map    curr 2-byte val map
        var prev = new u16(32768), head = new u16(msk_1 + 1);
        var bs1_1 = Math.ceil(plvl / 3), bs2_1 = 2 * bs1_1;
        var hsh = function (i) { return (dat[i] ^ (dat[i + 1] << bs1_1) ^ (dat[i + 2] << bs2_1)) & msk_1; };
        // 24576 is an arbitrary number of maximum symbols per block
        // 424 buffer for last block
        var syms = new u32(25000);
        // length/literal freq   distance freq
        var lf = new u16(288), df = new u16(32);
        //  l/lcnt  exbits  index  l/lind  waitdx  bitpos
        var lc_1 = 0, eb = 0, i = 0, li = 0, wi = 0, bs = 0;
        for (; i < s; ++i) {
            // hash value
            // deopt when i > s - 3 - at end, deopt acceptable
            var hv = hsh(i);
            // index mod 32768    previous index mod
            var imod = i & 32767, pimod = head[hv];
            prev[imod] = pimod;
            head[hv] = imod;
            // We always should modify head and prev, but only add symbols if
            // this data is not yet processed ("wait" for wait index)
            if (wi <= i) {
                // bytes remaining
                var rem = s - i;
                if ((lc_1 > 7000 || li > 24576) && rem > 423) {
                    pos = wblk(dat, w, 0, syms, lf, df, eb, li, bs, i - bs, pos);
                    li = lc_1 = eb = 0, bs = i;
                    for (var j = 0; j < 286; ++j)
                        lf[j] = 0;
                    for (var j = 0; j < 30; ++j)
                        df[j] = 0;
                }
                //  len    dist   chain
                var l = 2, d = 0, ch_1 = c, dif = (imod - pimod) & 32767;
                if (rem > 2 && hv == hsh(i - dif)) {
                    var maxn = Math.min(n, rem) - 1;
                    var maxd = Math.min(32767, i);
                    // max possible length
                    // not capped at dif because decompressors implement "rolling" index population
                    var ml = Math.min(258, rem);
                    while (dif <= maxd && --ch_1 && imod != pimod) {
                        if (dat[i + l] == dat[i + l - dif]) {
                            var nl = 0;
                            for (; nl < ml && dat[i + nl] == dat[i + nl - dif]; ++nl)
                                ;
                            if (nl > l) {
                                l = nl, d = dif;
                                // break out early when we reach "nice" (we are satisfied enough)
                                if (nl > maxn)
                                    break;
                                // now, find the rarest 2-byte sequence within this
                                // length of literals and search for that instead.
                                // Much faster than just using the start
                                var mmd = Math.min(dif, nl - 2);
                                var md = 0;
                                for (var j = 0; j < mmd; ++j) {
                                    var ti = (i - dif + j + 32768) & 32767;
                                    var pti = prev[ti];
                                    var cd = (ti - pti + 32768) & 32767;
                                    if (cd > md)
                                        md = cd, pimod = ti;
                                }
                            }
                        }
                        // check the previous match
                        imod = pimod, pimod = prev[imod];
                        dif += (imod - pimod + 32768) & 32767;
                    }
                }
                // d will be nonzero only when a match was found
                if (d) {
                    // store both dist and len data in one Uint32
                    // Make sure this is recognized as a len/dist with 28th bit (2^28)
                    syms[li++] = 268435456 | (revfl[l] << 18) | revfd[d];
                    var lin = revfl[l] & 31, din = revfd[d] & 31;
                    eb += fleb[lin] + fdeb[din];
                    ++lf[257 + lin];
                    ++df[din];
                    wi = i + l;
                    ++lc_1;
                }
                else {
                    syms[li++] = dat[i];
                    ++lf[dat[i]];
                }
            }
        }
        pos = wblk(dat, w, lst, syms, lf, df, eb, li, bs, i - bs, pos);
        // this is the easiest way to avoid needing to maintain state
        if (!lst && pos & 7)
            pos = wfblk(w, pos + 1, et);
    }
    return slc(o, 0, pre + shft(pos) + post);
};
// CRC32 table
var crct = /*#__PURE__*/ (/* unused pure expression or super */ null && ((function () {
    var t = new Int32Array(256);
    for (var i = 0; i < 256; ++i) {
        var c = i, k = 9;
        while (--k)
            c = ((c & 1) && -306674912) ^ (c >>> 1);
        t[i] = c;
    }
    return t;
})()));
// CRC32
var crc = function () {
    var c = -1;
    return {
        p: function (d) {
            // closures have awful performance
            var cr = c;
            for (var i = 0; i < d.length; ++i)
                cr = crct[(cr & 255) ^ d[i]] ^ (cr >>> 8);
            c = cr;
        },
        d: function () { return ~c; }
    };
};
// Alder32
var adler = function () {
    var a = 1, b = 0;
    return {
        p: function (d) {
            // closures have awful performance
            var n = a, m = b;
            var l = d.length | 0;
            for (var i = 0; i != l;) {
                var e = Math.min(i + 2655, l);
                for (; i < e; ++i)
                    m += n += d[i];
                n = (n & 65535) + 15 * (n >> 16), m = (m & 65535) + 15 * (m >> 16);
            }
            a = n, b = m;
        },
        d: function () {
            a %= 65521, b %= 65521;
            return (a & 255) << 24 | (a >>> 8) << 16 | (b & 255) << 8 | (b >>> 8);
        }
    };
};
;
// deflate with opts
var dopt = function (dat, opt, pre, post, st) {
    return dflt(dat, opt.level == null ? 6 : opt.level, opt.mem == null ? Math.ceil(Math.max(8, Math.min(13, Math.log(dat.length))) * 1.5) : (12 + opt.mem), pre, post, !st);
};
// Walmart object spread
var mrg = function (a, b) {
    var o = {};
    for (var k in a)
        o[k] = a[k];
    for (var k in b)
        o[k] = b[k];
    return o;
};
// worker clone
// This is possibly the craziest part of the entire codebase, despite how simple it may seem.
// The only parameter to this function is a closure that returns an array of variables outside of the function scope.
// We're going to try to figure out the variable names used in the closure as strings because that is crucial for workerization.
// We will return an object mapping of true variable name to value (basically, the current scope as a JS object).
// The reason we can't just use the original variable names is minifiers mangling the toplevel scope.
// This took me three weeks to figure out how to do.
var wcln = function (fn, fnStr, td) {
    var dt = fn();
    var st = fn.toString();
    var ks = st.slice(st.indexOf('[') + 1, st.lastIndexOf(']')).replace(/\s+/g, '').split(',');
    for (var i = 0; i < dt.length; ++i) {
        var v = dt[i], k = ks[i];
        if (typeof v == 'function') {
            fnStr += ';' + k + '=';
            var st_1 = v.toString();
            if (v.prototype) {
                // for global objects
                if (st_1.indexOf('[native code]') != -1) {
                    var spInd = st_1.indexOf(' ', 8) + 1;
                    fnStr += st_1.slice(spInd, st_1.indexOf('(', spInd));
                }
                else {
                    fnStr += st_1;
                    for (var t in v.prototype)
                        fnStr += ';' + k + '.prototype.' + t + '=' + v.prototype[t].toString();
                }
            }
            else
                fnStr += st_1;
        }
        else
            td[k] = v;
    }
    return [fnStr, td];
};
var ch = (/* unused pure expression or super */ null && ([]));
// clone bufs
var cbfs = function (v) {
    var tl = [];
    for (var k in v) {
        if (v[k].buffer) {
            tl.push((v[k] = new v[k].constructor(v[k])).buffer);
        }
    }
    return tl;
};
// use a worker to execute code
var wrkr = function (fns, init, id, cb) {
    var _a;
    if (!ch[id]) {
        var fnStr = '', td_1 = {}, m = fns.length - 1;
        for (var i = 0; i < m; ++i)
            _a = wcln(fns[i], fnStr, td_1), fnStr = _a[0], td_1 = _a[1];
        ch[id] = wcln(fns[m], fnStr, td_1);
    }
    var td = mrg({}, ch[id][1]);
    return wk(ch[id][0] + ';onmessage=function(e){for(var k in e.data)self[k]=e.data[k];onmessage=' + init.toString() + '}', id, td, cbfs(td), cb);
};
// base async inflate fn
var bInflt = function () { return [u8, u16, u32, fleb, fdeb, clim, fl, fd, flrm, fdrm, rev, ec, hMap, browser_max, bits, bits16, shft, slc, err, inflt, inflateSync, pbf, gu8]; };
var bDflt = function () { return [u8, u16, u32, fleb, fdeb, clim, revfl, revfd, flm, flt, fdm, fdt, rev, deo, et, hMap, wbits, wbits16, hTree, ln, lc, clen, wfblk, wblk, shft, slc, dflt, dopt, deflateSync, pbf]; };
// gzip extra
var gze = function () { return [gzh, gzhl, wbytes, crc, crct]; };
// gunzip extra
var guze = function () { return [gzs, gzl]; };
// zlib extra
var zle = function () { return [zlh, wbytes, adler]; };
// unzlib extra
var zule = function () { return [zlv]; };
// post buf
var pbf = function (msg) { return postMessage(msg, [msg.buffer]); };
// get u8
var gu8 = function (o) { return o && o.size && new u8(o.size); };
// async helper
var cbify = function (dat, opts, fns, init, id, cb) {
    var w = wrkr(fns, init, id, function (err, dat) {
        w.terminate();
        cb(err, dat);
    });
    w.postMessage([dat, opts], opts.consume ? [dat.buffer] : []);
    return function () { w.terminate(); };
};
// auto stream
var astrm = function (strm) {
    strm.ondata = function (dat, final) { return postMessage([dat, final], [dat.buffer]); };
    return function (ev) { return strm.push(ev.data[0], ev.data[1]); };
};
// async stream attach
var astrmify = function (fns, strm, opts, init, id) {
    var t;
    var w = wrkr(fns, init, id, function (err, dat) {
        if (err)
            w.terminate(), strm.ondata.call(strm, err);
        else {
            if (dat[1])
                w.terminate();
            strm.ondata.call(strm, err, dat[0], dat[1]);
        }
    });
    w.postMessage(opts);
    strm.push = function (d, f) {
        if (!strm.ondata)
            err(5);
        if (t)
            strm.ondata(err(4, 0, 1), null, !!f);
        w.postMessage([d, t = f], [d.buffer]);
    };
    strm.terminate = function () { w.terminate(); };
};
// read 2 bytes
var b2 = function (d, b) { return d[b] | (d[b + 1] << 8); };
// read 4 bytes
var b4 = function (d, b) { return (d[b] | (d[b + 1] << 8) | (d[b + 2] << 16) | (d[b + 3] << 24)) >>> 0; };
var b8 = function (d, b) { return b4(d, b) + (b4(d, b + 4) * 4294967296); };
// write bytes
var wbytes = function (d, b, v) {
    for (; v; ++b)
        d[b] = v, v >>>= 8;
};
// gzip header
var gzh = function (c, o) {
    var fn = o.filename;
    c[0] = 31, c[1] = 139, c[2] = 8, c[8] = o.level < 2 ? 4 : o.level == 9 ? 2 : 0, c[9] = 3; // assume Unix
    if (o.mtime != 0)
        wbytes(c, 4, Math.floor(new Date(o.mtime || Date.now()) / 1000));
    if (fn) {
        c[3] = 8;
        for (var i = 0; i <= fn.length; ++i)
            c[i + 10] = fn.charCodeAt(i);
    }
};
// gzip footer: -8 to -4 = CRC, -4 to -0 is length
// gzip start
var gzs = function (d) {
    if (d[0] != 31 || d[1] != 139 || d[2] != 8)
        err(6, 'invalid gzip data');
    var flg = d[3];
    var st = 10;
    if (flg & 4)
        st += d[10] | (d[11] << 8) + 2;
    for (var zs = (flg >> 3 & 1) + (flg >> 4 & 1); zs > 0; zs -= !d[st++])
        ;
    return st + (flg & 2);
};
// gzip length
var gzl = function (d) {
    var l = d.length;
    return ((d[l - 4] | d[l - 3] << 8 | d[l - 2] << 16) | (d[l - 1] << 24)) >>> 0;
};
// gzip header length
var gzhl = function (o) { return 10 + ((o.filename && (o.filename.length + 1)) || 0); };
// zlib header
var zlh = function (c, o) {
    var lv = o.level, fl = lv == 0 ? 0 : lv < 6 ? 1 : lv == 9 ? 3 : 2;
    c[0] = 120, c[1] = (fl << 6) | (fl ? (32 - 2 * fl) : 1);
};
// zlib valid
var zlv = function (d) {
    if ((d[0] & 15) != 8 || (d[0] >>> 4) > 7 || ((d[0] << 8 | d[1]) % 31))
        err(6, 'invalid zlib data');
    if (d[1] & 32)
        err(6, 'invalid zlib data: preset dictionaries not supported');
};
function AsyncCmpStrm(opts, cb) {
    if (!cb && typeof opts == 'function')
        cb = opts, opts = {};
    this.ondata = cb;
    return opts;
}
// zlib footer: -4 to -0 is Adler32
/**
 * Streaming DEFLATE compression
 */
var Deflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    function Deflate(opts, cb) {
        if (!cb && typeof opts == 'function')
            cb = opts, opts = {};
        this.ondata = cb;
        this.o = opts || {};
    }
    Deflate.prototype.p = function (c, f) {
        this.ondata(dopt(c, this.o, 0, 0, !f), f);
    };
    /**
     * Pushes a chunk to be deflated
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Deflate.prototype.push = function (chunk, final) {
        if (!this.ondata)
            err(5);
        if (this.d)
            err(4);
        this.d = final;
        this.p(chunk, final || false);
    };
    return Deflate;
}())));

/**
 * Asynchronous streaming DEFLATE compression
 */
var AsyncDeflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    function AsyncDeflate(opts, cb) {
        astrmify([
            bDflt,
            function () { return [astrm, Deflate]; }
        ], this, AsyncCmpStrm.call(this, opts, cb), function (ev) {
            var strm = new Deflate(ev.data);
            onmessage = astrm(strm);
        }, 6);
    }
    return AsyncDeflate;
}())));

function deflate(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    return cbify(data, opts, [
        bDflt,
    ], function (ev) { return pbf(deflateSync(ev.data[0], ev.data[1])); }, 0, cb);
}
/**
 * Compresses data with DEFLATE without any wrapper
 * @param data The data to compress
 * @param opts The compression options
 * @returns The deflated version of the data
 */
function deflateSync(data, opts) {
    return dopt(data, opts || {}, 0, 0);
}
/**
 * Streaming DEFLATE decompression
 */
var Inflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates an inflation stream
     * @param cb The callback to call whenever data is inflated
     */
    function Inflate(cb) {
        this.s = {};
        this.p = new u8(0);
        this.ondata = cb;
    }
    Inflate.prototype.e = function (c) {
        if (!this.ondata)
            err(5);
        if (this.d)
            err(4);
        var l = this.p.length;
        var n = new u8(l + c.length);
        n.set(this.p), n.set(c, l), this.p = n;
    };
    Inflate.prototype.c = function (final) {
        this.d = this.s.i = final || false;
        var bts = this.s.b;
        var dt = inflt(this.p, this.o, this.s);
        this.ondata(slc(dt, bts, this.s.b), this.d);
        this.o = slc(dt, this.s.b - 32768), this.s.b = this.o.length;
        this.p = slc(this.p, (this.s.p / 8) | 0), this.s.p &= 7;
    };
    /**
     * Pushes a chunk to be inflated
     * @param chunk The chunk to push
     * @param final Whether this is the final chunk
     */
    Inflate.prototype.push = function (chunk, final) {
        this.e(chunk), this.c(final);
    };
    return Inflate;
}())));

/**
 * Asynchronous streaming DEFLATE decompression
 */
var AsyncInflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates an asynchronous inflation stream
     * @param cb The callback to call whenever data is deflated
     */
    function AsyncInflate(cb) {
        this.ondata = cb;
        astrmify([
            bInflt,
            function () { return [astrm, Inflate]; }
        ], this, 0, function () {
            var strm = new Inflate();
            onmessage = astrm(strm);
        }, 7);
    }
    return AsyncInflate;
}())));

function inflate(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    return cbify(data, opts, [
        bInflt
    ], function (ev) { return pbf(inflateSync(ev.data[0], gu8(ev.data[1]))); }, 1, cb);
}
/**
 * Expands DEFLATE data with no wrapper
 * @param data The data to decompress
 * @param out Where to write the data. Saves memory if you know the decompressed size and provide an output buffer of that length.
 * @returns The decompressed version of the data
 */
function inflateSync(data, out) {
    return inflt(data, out);
}
// before you yell at me for not just using extends, my reason is that TS inheritance is hard to workerize.
/**
 * Streaming GZIP compression
 */
var Gzip = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    function Gzip(opts, cb) {
        this.c = crc();
        this.l = 0;
        this.v = 1;
        Deflate.call(this, opts, cb);
    }
    /**
     * Pushes a chunk to be GZIPped
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Gzip.prototype.push = function (chunk, final) {
        Deflate.prototype.push.call(this, chunk, final);
    };
    Gzip.prototype.p = function (c, f) {
        this.c.p(c);
        this.l += c.length;
        var raw = dopt(c, this.o, this.v && gzhl(this.o), f && 8, !f);
        if (this.v)
            gzh(raw, this.o), this.v = 0;
        if (f)
            wbytes(raw, raw.length - 8, this.c.d()), wbytes(raw, raw.length - 4, this.l);
        this.ondata(raw, f);
    };
    return Gzip;
}())));

/**
 * Asynchronous streaming GZIP compression
 */
var AsyncGzip = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    function AsyncGzip(opts, cb) {
        astrmify([
            bDflt,
            gze,
            function () { return [astrm, Deflate, Gzip]; }
        ], this, AsyncCmpStrm.call(this, opts, cb), function (ev) {
            var strm = new Gzip(ev.data);
            onmessage = astrm(strm);
        }, 8);
    }
    return AsyncGzip;
}())));

function gzip(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    return cbify(data, opts, [
        bDflt,
        gze,
        function () { return [gzipSync]; }
    ], function (ev) { return pbf(gzipSync(ev.data[0], ev.data[1])); }, 2, cb);
}
/**
 * Compresses data with GZIP
 * @param data The data to compress
 * @param opts The compression options
 * @returns The gzipped version of the data
 */
function gzipSync(data, opts) {
    if (!opts)
        opts = {};
    var c = crc(), l = data.length;
    c.p(data);
    var d = dopt(data, opts, gzhl(opts), 8), s = d.length;
    return gzh(d, opts), wbytes(d, s - 8, c.d()), wbytes(d, s - 4, l), d;
}
/**
 * Streaming GZIP decompression
 */
var Gunzip = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a GUNZIP stream
     * @param cb The callback to call whenever data is inflated
     */
    function Gunzip(cb) {
        this.v = 1;
        Inflate.call(this, cb);
    }
    /**
     * Pushes a chunk to be GUNZIPped
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Gunzip.prototype.push = function (chunk, final) {
        Inflate.prototype.e.call(this, chunk);
        if (this.v) {
            var s = this.p.length > 3 ? gzs(this.p) : 4;
            if (s >= this.p.length && !final)
                return;
            this.p = this.p.subarray(s), this.v = 0;
        }
        if (final) {
            if (this.p.length < 8)
                err(6, 'invalid gzip data');
            this.p = this.p.subarray(0, -8);
        }
        // necessary to prevent TS from using the closure value
        // This allows for workerization to function correctly
        Inflate.prototype.c.call(this, final);
    };
    return Gunzip;
}())));

/**
 * Asynchronous streaming GZIP decompression
 */
var AsyncGunzip = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates an asynchronous GUNZIP stream
     * @param cb The callback to call whenever data is deflated
     */
    function AsyncGunzip(cb) {
        this.ondata = cb;
        astrmify([
            bInflt,
            guze,
            function () { return [astrm, Inflate, Gunzip]; }
        ], this, 0, function () {
            var strm = new Gunzip();
            onmessage = astrm(strm);
        }, 9);
    }
    return AsyncGunzip;
}())));

function gunzip(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    return cbify(data, opts, [
        bInflt,
        guze,
        function () { return [gunzipSync]; }
    ], function (ev) { return pbf(gunzipSync(ev.data[0])); }, 3, cb);
}
/**
 * Expands GZIP data
 * @param data The data to decompress
 * @param out Where to write the data. GZIP already encodes the output size, so providing this doesn't save memory.
 * @returns The decompressed version of the data
 */
function gunzipSync(data, out) {
    return inflt(data.subarray(gzs(data), -8), out || new u8(gzl(data)));
}
/**
 * Streaming Zlib compression
 */
var Zlib = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    function Zlib(opts, cb) {
        this.c = adler();
        this.v = 1;
        Deflate.call(this, opts, cb);
    }
    /**
     * Pushes a chunk to be zlibbed
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Zlib.prototype.push = function (chunk, final) {
        Deflate.prototype.push.call(this, chunk, final);
    };
    Zlib.prototype.p = function (c, f) {
        this.c.p(c);
        var raw = dopt(c, this.o, this.v && 2, f && 4, !f);
        if (this.v)
            zlh(raw, this.o), this.v = 0;
        if (f)
            wbytes(raw, raw.length - 4, this.c.d());
        this.ondata(raw, f);
    };
    return Zlib;
}())));

/**
 * Asynchronous streaming Zlib compression
 */
var AsyncZlib = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    function AsyncZlib(opts, cb) {
        astrmify([
            bDflt,
            zle,
            function () { return [astrm, Deflate, Zlib]; }
        ], this, AsyncCmpStrm.call(this, opts, cb), function (ev) {
            var strm = new Zlib(ev.data);
            onmessage = astrm(strm);
        }, 10);
    }
    return AsyncZlib;
}())));

function zlib(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    return cbify(data, opts, [
        bDflt,
        zle,
        function () { return [zlibSync]; }
    ], function (ev) { return pbf(zlibSync(ev.data[0], ev.data[1])); }, 4, cb);
}
/**
 * Compress data with Zlib
 * @param data The data to compress
 * @param opts The compression options
 * @returns The zlib-compressed version of the data
 */
function zlibSync(data, opts) {
    if (!opts)
        opts = {};
    var a = adler();
    a.p(data);
    var d = dopt(data, opts, 2, 4);
    return zlh(d, opts), wbytes(d, d.length - 4, a.d()), d;
}
/**
 * Streaming Zlib decompression
 */
var Unzlib = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a Zlib decompression stream
     * @param cb The callback to call whenever data is inflated
     */
    function Unzlib(cb) {
        this.v = 1;
        Inflate.call(this, cb);
    }
    /**
     * Pushes a chunk to be unzlibbed
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Unzlib.prototype.push = function (chunk, final) {
        Inflate.prototype.e.call(this, chunk);
        if (this.v) {
            if (this.p.length < 2 && !final)
                return;
            this.p = this.p.subarray(2), this.v = 0;
        }
        if (final) {
            if (this.p.length < 4)
                err(6, 'invalid zlib data');
            this.p = this.p.subarray(0, -4);
        }
        // necessary to prevent TS from using the closure value
        // This allows for workerization to function correctly
        Inflate.prototype.c.call(this, final);
    };
    return Unzlib;
}())));

/**
 * Asynchronous streaming Zlib decompression
 */
var AsyncUnzlib = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates an asynchronous Zlib decompression stream
     * @param cb The callback to call whenever data is deflated
     */
    function AsyncUnzlib(cb) {
        this.ondata = cb;
        astrmify([
            bInflt,
            zule,
            function () { return [astrm, Inflate, Unzlib]; }
        ], this, 0, function () {
            var strm = new Unzlib();
            onmessage = astrm(strm);
        }, 11);
    }
    return AsyncUnzlib;
}())));

function unzlib(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    return cbify(data, opts, [
        bInflt,
        zule,
        function () { return [unzlibSync]; }
    ], function (ev) { return pbf(unzlibSync(ev.data[0], gu8(ev.data[1]))); }, 5, cb);
}
/**
 * Expands Zlib data
 * @param data The data to decompress
 * @param out Where to write the data. Saves memory if you know the decompressed size and provide an output buffer of that length.
 * @returns The decompressed version of the data
 */
function unzlibSync(data, out) {
    return inflt((zlv(data), data.subarray(2, -4)), out);
}
// Default algorithm for compression (used because having a known output size allows faster decompression)

// Default algorithm for compression (used because having a known output size allows faster decompression)

/**
 * Streaming GZIP, Zlib, or raw DEFLATE decompression
 */
var Decompress = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a decompression stream
     * @param cb The callback to call whenever data is decompressed
     */
    function Decompress(cb) {
        this.G = Gunzip;
        this.I = Inflate;
        this.Z = Unzlib;
        this.ondata = cb;
    }
    /**
     * Pushes a chunk to be decompressed
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Decompress.prototype.push = function (chunk, final) {
        if (!this.ondata)
            err(5);
        if (!this.s) {
            if (this.p && this.p.length) {
                var n = new u8(this.p.length + chunk.length);
                n.set(this.p), n.set(chunk, this.p.length);
            }
            else
                this.p = chunk;
            if (this.p.length > 2) {
                var _this_1 = this;
                var cb = function () { _this_1.ondata.apply(_this_1, arguments); };
                this.s = (this.p[0] == 31 && this.p[1] == 139 && this.p[2] == 8)
                    ? new this.G(cb)
                    : ((this.p[0] & 15) != 8 || (this.p[0] >> 4) > 7 || ((this.p[0] << 8 | this.p[1]) % 31))
                        ? new this.I(cb)
                        : new this.Z(cb);
                this.s.push(this.p, final);
                this.p = null;
            }
        }
        else
            this.s.push(chunk, final);
    };
    return Decompress;
}())));

/**
 * Asynchronous streaming GZIP, Zlib, or raw DEFLATE decompression
 */
var AsyncDecompress = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
   * Creates an asynchronous decompression stream
   * @param cb The callback to call whenever data is decompressed
   */
    function AsyncDecompress(cb) {
        this.G = AsyncGunzip;
        this.I = AsyncInflate;
        this.Z = AsyncUnzlib;
        this.ondata = cb;
    }
    /**
     * Pushes a chunk to be decompressed
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    AsyncDecompress.prototype.push = function (chunk, final) {
        Decompress.prototype.push.call(this, chunk, final);
    };
    return AsyncDecompress;
}())));

function decompress(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    return (data[0] == 31 && data[1] == 139 && data[2] == 8)
        ? gunzip(data, opts, cb)
        : ((data[0] & 15) != 8 || (data[0] >> 4) > 7 || ((data[0] << 8 | data[1]) % 31))
            ? inflate(data, opts, cb)
            : unzlib(data, opts, cb);
}
/**
 * Expands compressed GZIP, Zlib, or raw DEFLATE data, automatically detecting the format
 * @param data The data to decompress
 * @param out Where to write the data. Saves memory if you know the decompressed size and provide an output buffer of that length.
 * @returns The decompressed version of the data
 */
function decompressSync(data, out) {
    return (data[0] == 31 && data[1] == 139 && data[2] == 8)
        ? gunzipSync(data, out)
        : ((data[0] & 15) != 8 || (data[0] >> 4) > 7 || ((data[0] << 8 | data[1]) % 31))
            ? inflateSync(data, out)
            : unzlibSync(data, out);
}
// flatten a directory structure
var fltn = function (d, p, t, o) {
    for (var k in d) {
        var val = d[k], n = p + k, op = o;
        if (Array.isArray(val))
            op = mrg(o, val[1]), val = val[0];
        if (val instanceof u8)
            t[n] = [val, op];
        else {
            t[n += '/'] = [new u8(0), op];
            fltn(val, n, t, o);
        }
    }
};
// text encoder
var te = typeof TextEncoder != 'undefined' && /*#__PURE__*/ new TextEncoder();
// text decoder
var td = typeof TextDecoder != 'undefined' && /*#__PURE__*/ new TextDecoder();
// text decoder stream
var tds = 0;
try {
    td.decode(et, { stream: true });
    tds = 1;
}
catch (e) { }
// decode UTF8
var dutf8 = function (d) {
    for (var r = '', i = 0;;) {
        var c = d[i++];
        var eb = (c > 127) + (c > 223) + (c > 239);
        if (i + eb > d.length)
            return [r, slc(d, i - 1)];
        if (!eb)
            r += String.fromCharCode(c);
        else if (eb == 3) {
            c = ((c & 15) << 18 | (d[i++] & 63) << 12 | (d[i++] & 63) << 6 | (d[i++] & 63)) - 65536,
                r += String.fromCharCode(55296 | (c >> 10), 56320 | (c & 1023));
        }
        else if (eb & 1)
            r += String.fromCharCode((c & 31) << 6 | (d[i++] & 63));
        else
            r += String.fromCharCode((c & 15) << 12 | (d[i++] & 63) << 6 | (d[i++] & 63));
    }
};
/**
 * Streaming UTF-8 decoding
 */
var DecodeUTF8 = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a UTF-8 decoding stream
     * @param cb The callback to call whenever data is decoded
     */
    function DecodeUTF8(cb) {
        this.ondata = cb;
        if (tds)
            this.t = new TextDecoder();
        else
            this.p = et;
    }
    /**
     * Pushes a chunk to be decoded from UTF-8 binary
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    DecodeUTF8.prototype.push = function (chunk, final) {
        if (!this.ondata)
            err(5);
        final = !!final;
        if (this.t) {
            this.ondata(this.t.decode(chunk, { stream: true }), final);
            if (final) {
                if (this.t.decode().length)
                    err(8);
                this.t = null;
            }
            return;
        }
        if (!this.p)
            err(4);
        var dat = new u8(this.p.length + chunk.length);
        dat.set(this.p);
        dat.set(chunk, this.p.length);
        var _a = dutf8(dat), ch = _a[0], np = _a[1];
        if (final) {
            if (np.length)
                err(8);
            this.p = null;
        }
        else
            this.p = np;
        this.ondata(ch, final);
    };
    return DecodeUTF8;
}())));

/**
 * Streaming UTF-8 encoding
 */
var EncodeUTF8 = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a UTF-8 decoding stream
     * @param cb The callback to call whenever data is encoded
     */
    function EncodeUTF8(cb) {
        this.ondata = cb;
    }
    /**
     * Pushes a chunk to be encoded to UTF-8
     * @param chunk The string data to push
     * @param final Whether this is the last chunk
     */
    EncodeUTF8.prototype.push = function (chunk, final) {
        if (!this.ondata)
            err(5);
        if (this.d)
            err(4);
        this.ondata(strToU8(chunk), this.d = final || false);
    };
    return EncodeUTF8;
}())));

/**
 * Converts a string into a Uint8Array for use with compression/decompression methods
 * @param str The string to encode
 * @param latin1 Whether or not to interpret the data as Latin-1. This should
 *               not need to be true unless decoding a binary string.
 * @returns The string encoded in UTF-8/Latin-1 binary
 */
function strToU8(str, latin1) {
    if (latin1) {
        var ar_1 = new u8(str.length);
        for (var i = 0; i < str.length; ++i)
            ar_1[i] = str.charCodeAt(i);
        return ar_1;
    }
    if (te)
        return te.encode(str);
    var l = str.length;
    var ar = new u8(str.length + (str.length >> 1));
    var ai = 0;
    var w = function (v) { ar[ai++] = v; };
    for (var i = 0; i < l; ++i) {
        if (ai + 5 > ar.length) {
            var n = new u8(ai + 8 + ((l - i) << 1));
            n.set(ar);
            ar = n;
        }
        var c = str.charCodeAt(i);
        if (c < 128 || latin1)
            w(c);
        else if (c < 2048)
            w(192 | (c >> 6)), w(128 | (c & 63));
        else if (c > 55295 && c < 57344)
            c = 65536 + (c & 1023 << 10) | (str.charCodeAt(++i) & 1023),
                w(240 | (c >> 18)), w(128 | ((c >> 12) & 63)), w(128 | ((c >> 6) & 63)), w(128 | (c & 63));
        else
            w(224 | (c >> 12)), w(128 | ((c >> 6) & 63)), w(128 | (c & 63));
    }
    return slc(ar, 0, ai);
}
/**
 * Converts a Uint8Array to a string
 * @param dat The data to decode to string
 * @param latin1 Whether or not to interpret the data as Latin-1. This should
 *               not need to be true unless encoding to binary string.
 * @returns The original UTF-8/Latin-1 string
 */
function strFromU8(dat, latin1) {
    if (latin1) {
        var r = '';
        for (var i = 0; i < dat.length; i += 16384)
            r += String.fromCharCode.apply(null, dat.subarray(i, i + 16384));
        return r;
    }
    else if (td)
        return td.decode(dat);
    else {
        var _a = dutf8(dat), out = _a[0], ext = _a[1];
        if (ext.length)
            err(8);
        return out;
    }
}
;
// deflate bit flag
var dbf = function (l) { return l == 1 ? 3 : l < 6 ? 2 : l == 9 ? 1 : 0; };
// skip local zip header
var slzh = function (d, b) { return b + 30 + b2(d, b + 26) + b2(d, b + 28); };
// read zip header
var zh = function (d, b, z) {
    var fnl = b2(d, b + 28), fn = strFromU8(d.subarray(b + 46, b + 46 + fnl), !(b2(d, b + 8) & 2048)), es = b + 46 + fnl, bs = b4(d, b + 20);
    var _a = z && bs == 4294967295 ? z64e(d, es) : [bs, b4(d, b + 24), b4(d, b + 42)], sc = _a[0], su = _a[1], off = _a[2];
    return [b2(d, b + 10), sc, su, fn, es + b2(d, b + 30) + b2(d, b + 32), off];
};
// read zip64 extra field
var z64e = function (d, b) {
    for (; b2(d, b) != 1; b += 4 + b2(d, b + 2))
        ;
    return [b8(d, b + 12), b8(d, b + 4), b8(d, b + 20)];
};
// extra field length
var exfl = function (ex) {
    var le = 0;
    if (ex) {
        for (var k in ex) {
            var l = ex[k].length;
            if (l > 65535)
                err(9);
            le += l + 4;
        }
    }
    return le;
};
// write zip header
var wzh = function (d, b, f, fn, u, c, ce, co) {
    var fl = fn.length, ex = f.extra, col = co && co.length;
    var exl = exfl(ex);
    wbytes(d, b, ce != null ? 0x2014B50 : 0x4034B50), b += 4;
    if (ce != null)
        d[b++] = 20, d[b++] = f.os;
    d[b] = 20, b += 2; // spec compliance? what's that?
    d[b++] = (f.flag << 1) | (c == null && 8), d[b++] = u && 8;
    d[b++] = f.compression & 255, d[b++] = f.compression >> 8;
    var dt = new Date(f.mtime == null ? Date.now() : f.mtime), y = dt.getFullYear() - 1980;
    if (y < 0 || y > 119)
        err(10);
    wbytes(d, b, (y << 25) | ((dt.getMonth() + 1) << 21) | (dt.getDate() << 16) | (dt.getHours() << 11) | (dt.getMinutes() << 5) | (dt.getSeconds() >>> 1)), b += 4;
    if (c != null) {
        wbytes(d, b, f.crc);
        wbytes(d, b + 4, c);
        wbytes(d, b + 8, f.size);
    }
    wbytes(d, b + 12, fl);
    wbytes(d, b + 14, exl), b += 16;
    if (ce != null) {
        wbytes(d, b, col);
        wbytes(d, b + 6, f.attrs);
        wbytes(d, b + 10, ce), b += 14;
    }
    d.set(fn, b);
    b += fl;
    if (exl) {
        for (var k in ex) {
            var exf = ex[k], l = exf.length;
            wbytes(d, b, +k);
            wbytes(d, b + 2, l);
            d.set(exf, b + 4), b += 4 + l;
        }
    }
    if (col)
        d.set(co, b), b += col;
    return b;
};
// write zip footer (end of central directory)
var wzf = function (o, b, c, d, e) {
    wbytes(o, b, 0x6054B50); // skip disk
    wbytes(o, b + 8, c);
    wbytes(o, b + 10, c);
    wbytes(o, b + 12, d);
    wbytes(o, b + 16, e);
};
/**
 * A pass-through stream to keep data uncompressed in a ZIP archive.
 */
var ZipPassThrough = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a pass-through stream that can be added to ZIP archives
     * @param filename The filename to associate with this data stream
     */
    function ZipPassThrough(filename) {
        this.filename = filename;
        this.c = crc();
        this.size = 0;
        this.compression = 0;
    }
    /**
     * Processes a chunk and pushes to the output stream. You can override this
     * method in a subclass for custom behavior, but by default this passes
     * the data through. You must call this.ondata(err, chunk, final) at some
     * point in this method.
     * @param chunk The chunk to process
     * @param final Whether this is the last chunk
     */
    ZipPassThrough.prototype.process = function (chunk, final) {
        this.ondata(null, chunk, final);
    };
    /**
     * Pushes a chunk to be added. If you are subclassing this with a custom
     * compression algorithm, note that you must push data from the source
     * file only, pre-compression.
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    ZipPassThrough.prototype.push = function (chunk, final) {
        if (!this.ondata)
            err(5);
        this.c.p(chunk);
        this.size += chunk.length;
        if (final)
            this.crc = this.c.d();
        this.process(chunk, final || false);
    };
    return ZipPassThrough;
}())));

// I don't extend because TypeScript extension adds 1kB of runtime bloat
/**
 * Streaming DEFLATE compression for ZIP archives. Prefer using AsyncZipDeflate
 * for better performance
 */
var ZipDeflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a DEFLATE stream that can be added to ZIP archives
     * @param filename The filename to associate with this data stream
     * @param opts The compression options
     */
    function ZipDeflate(filename, opts) {
        var _this_1 = this;
        if (!opts)
            opts = {};
        ZipPassThrough.call(this, filename);
        this.d = new Deflate(opts, function (dat, final) {
            _this_1.ondata(null, dat, final);
        });
        this.compression = 8;
        this.flag = dbf(opts.level);
    }
    ZipDeflate.prototype.process = function (chunk, final) {
        try {
            this.d.push(chunk, final);
        }
        catch (e) {
            this.ondata(e, null, final);
        }
    };
    /**
     * Pushes a chunk to be deflated
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    ZipDeflate.prototype.push = function (chunk, final) {
        ZipPassThrough.prototype.push.call(this, chunk, final);
    };
    return ZipDeflate;
}())));

/**
 * Asynchronous streaming DEFLATE compression for ZIP archives
 */
var AsyncZipDeflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a DEFLATE stream that can be added to ZIP archives
     * @param filename The filename to associate with this data stream
     * @param opts The compression options
     */
    function AsyncZipDeflate(filename, opts) {
        var _this_1 = this;
        if (!opts)
            opts = {};
        ZipPassThrough.call(this, filename);
        this.d = new AsyncDeflate(opts, function (err, dat, final) {
            _this_1.ondata(err, dat, final);
        });
        this.compression = 8;
        this.flag = dbf(opts.level);
        this.terminate = this.d.terminate;
    }
    AsyncZipDeflate.prototype.process = function (chunk, final) {
        this.d.push(chunk, final);
    };
    /**
     * Pushes a chunk to be deflated
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    AsyncZipDeflate.prototype.push = function (chunk, final) {
        ZipPassThrough.prototype.push.call(this, chunk, final);
    };
    return AsyncZipDeflate;
}())));

// TODO: Better tree shaking
/**
 * A zippable archive to which files can incrementally be added
 */
var Zip = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates an empty ZIP archive to which files can be added
     * @param cb The callback to call whenever data for the generated ZIP archive
     *           is available
     */
    function Zip(cb) {
        this.ondata = cb;
        this.u = [];
        this.d = 1;
    }
    /**
     * Adds a file to the ZIP archive
     * @param file The file stream to add
     */
    Zip.prototype.add = function (file) {
        var _this_1 = this;
        if (!this.ondata)
            err(5);
        // finishing or finished
        if (this.d & 2)
            this.ondata(err(4 + (this.d & 1) * 8, 0, 1), null, false);
        else {
            var f = strToU8(file.filename), fl_1 = f.length;
            var com = file.comment, o = com && strToU8(com);
            var u = fl_1 != file.filename.length || (o && (com.length != o.length));
            var hl_1 = fl_1 + exfl(file.extra) + 30;
            if (fl_1 > 65535)
                this.ondata(err(11, 0, 1), null, false);
            var header = new u8(hl_1);
            wzh(header, 0, file, f, u);
            var chks_1 = [header];
            var pAll_1 = function () {
                for (var _i = 0, chks_2 = chks_1; _i < chks_2.length; _i++) {
                    var chk = chks_2[_i];
                    _this_1.ondata(null, chk, false);
                }
                chks_1 = [];
            };
            var tr_1 = this.d;
            this.d = 0;
            var ind_1 = this.u.length;
            var uf_1 = mrg(file, {
                f: f,
                u: u,
                o: o,
                t: function () {
                    if (file.terminate)
                        file.terminate();
                },
                r: function () {
                    pAll_1();
                    if (tr_1) {
                        var nxt = _this_1.u[ind_1 + 1];
                        if (nxt)
                            nxt.r();
                        else
                            _this_1.d = 1;
                    }
                    tr_1 = 1;
                }
            });
            var cl_1 = 0;
            file.ondata = function (err, dat, final) {
                if (err) {
                    _this_1.ondata(err, dat, final);
                    _this_1.terminate();
                }
                else {
                    cl_1 += dat.length;
                    chks_1.push(dat);
                    if (final) {
                        var dd = new u8(16);
                        wbytes(dd, 0, 0x8074B50);
                        wbytes(dd, 4, file.crc);
                        wbytes(dd, 8, cl_1);
                        wbytes(dd, 12, file.size);
                        chks_1.push(dd);
                        uf_1.c = cl_1, uf_1.b = hl_1 + cl_1 + 16, uf_1.crc = file.crc, uf_1.size = file.size;
                        if (tr_1)
                            uf_1.r();
                        tr_1 = 1;
                    }
                    else if (tr_1)
                        pAll_1();
                }
            };
            this.u.push(uf_1);
        }
    };
    /**
     * Ends the process of adding files and prepares to emit the final chunks.
     * This *must* be called after adding all desired files for the resulting
     * ZIP file to work properly.
     */
    Zip.prototype.end = function () {
        var _this_1 = this;
        if (this.d & 2) {
            this.ondata(err(4 + (this.d & 1) * 8, 0, 1), null, true);
            return;
        }
        if (this.d)
            this.e();
        else
            this.u.push({
                r: function () {
                    if (!(_this_1.d & 1))
                        return;
                    _this_1.u.splice(-1, 1);
                    _this_1.e();
                },
                t: function () { }
            });
        this.d = 3;
    };
    Zip.prototype.e = function () {
        var bt = 0, l = 0, tl = 0;
        for (var _i = 0, _a = this.u; _i < _a.length; _i++) {
            var f = _a[_i];
            tl += 46 + f.f.length + exfl(f.extra) + (f.o ? f.o.length : 0);
        }
        var out = new u8(tl + 22);
        for (var _b = 0, _c = this.u; _b < _c.length; _b++) {
            var f = _c[_b];
            wzh(out, bt, f, f.f, f.u, f.c, l, f.o);
            bt += 46 + f.f.length + exfl(f.extra) + (f.o ? f.o.length : 0), l += f.b;
        }
        wzf(out, bt, this.u.length, tl, l);
        this.ondata(null, out, true);
        this.d = 2;
    };
    /**
     * A method to terminate any internal workers used by the stream. Subsequent
     * calls to add() will fail.
     */
    Zip.prototype.terminate = function () {
        for (var _i = 0, _a = this.u; _i < _a.length; _i++) {
            var f = _a[_i];
            f.t();
        }
        this.d = 2;
    };
    return Zip;
}())));

function zip(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    var r = {};
    fltn(data, '', r, opts);
    var k = Object.keys(r);
    var lft = k.length, o = 0, tot = 0;
    var slft = lft, files = new Array(lft);
    var term = [];
    var tAll = function () {
        for (var i = 0; i < term.length; ++i)
            term[i]();
    };
    var cbd = function (a, b) {
        mt(function () { cb(a, b); });
    };
    mt(function () { cbd = cb; });
    var cbf = function () {
        var out = new u8(tot + 22), oe = o, cdl = tot - o;
        tot = 0;
        for (var i = 0; i < slft; ++i) {
            var f = files[i];
            try {
                var l = f.c.length;
                wzh(out, tot, f, f.f, f.u, l);
                var badd = 30 + f.f.length + exfl(f.extra);
                var loc = tot + badd;
                out.set(f.c, loc);
                wzh(out, o, f, f.f, f.u, l, tot, f.m), o += 16 + badd + (f.m ? f.m.length : 0), tot = loc + l;
            }
            catch (e) {
                return cbd(e, null);
            }
        }
        wzf(out, o, files.length, cdl, oe);
        cbd(null, out);
    };
    if (!lft)
        cbf();
    var _loop_1 = function (i) {
        var fn = k[i];
        var _a = r[fn], file = _a[0], p = _a[1];
        var c = crc(), size = file.length;
        c.p(file);
        var f = strToU8(fn), s = f.length;
        var com = p.comment, m = com && strToU8(com), ms = m && m.length;
        var exl = exfl(p.extra);
        var compression = p.level == 0 ? 0 : 8;
        var cbl = function (e, d) {
            if (e) {
                tAll();
                cbd(e, null);
            }
            else {
                var l = d.length;
                files[i] = mrg(p, {
                    size: size,
                    crc: c.d(),
                    c: d,
                    f: f,
                    m: m,
                    u: s != fn.length || (m && (com.length != ms)),
                    compression: compression
                });
                o += 30 + s + exl + l;
                tot += 76 + 2 * (s + exl) + (ms || 0) + l;
                if (!--lft)
                    cbf();
            }
        };
        if (s > 65535)
            cbl(err(11, 0, 1), null);
        if (!compression)
            cbl(null, file);
        else if (size < 160000) {
            try {
                cbl(null, deflateSync(file, p));
            }
            catch (e) {
                cbl(e, null);
            }
        }
        else
            term.push(deflate(file, p, cbl));
    };
    // Cannot use lft because it can decrease
    for (var i = 0; i < slft; ++i) {
        _loop_1(i);
    }
    return tAll;
}
/**
 * Synchronously creates a ZIP file. Prefer using `zip` for better performance
 * with more than one file.
 * @param data The directory structure for the ZIP archive
 * @param opts The main options, merged with per-file options
 * @returns The generated ZIP archive
 */
function zipSync(data, opts) {
    if (!opts)
        opts = {};
    var r = {};
    var files = [];
    fltn(data, '', r, opts);
    var o = 0;
    var tot = 0;
    for (var fn in r) {
        var _a = r[fn], file = _a[0], p = _a[1];
        var compression = p.level == 0 ? 0 : 8;
        var f = strToU8(fn), s = f.length;
        var com = p.comment, m = com && strToU8(com), ms = m && m.length;
        var exl = exfl(p.extra);
        if (s > 65535)
            err(11);
        var d = compression ? deflateSync(file, p) : file, l = d.length;
        var c = crc();
        c.p(file);
        files.push(mrg(p, {
            size: file.length,
            crc: c.d(),
            c: d,
            f: f,
            m: m,
            u: s != fn.length || (m && (com.length != ms)),
            o: o,
            compression: compression
        }));
        o += 30 + s + exl + l;
        tot += 76 + 2 * (s + exl) + (ms || 0) + l;
    }
    var out = new u8(tot + 22), oe = o, cdl = tot - o;
    for (var i = 0; i < files.length; ++i) {
        var f = files[i];
        wzh(out, f.o, f, f.f, f.u, f.c.length);
        var badd = 30 + f.f.length + exfl(f.extra);
        out.set(f.c, f.o + badd);
        wzh(out, o, f, f.f, f.u, f.c.length, f.o, f.m), o += 16 + badd + (f.m ? f.m.length : 0);
    }
    wzf(out, o, files.length, cdl, oe);
    return out;
}
/**
 * Streaming pass-through decompression for ZIP archives
 */
var UnzipPassThrough = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    function UnzipPassThrough() {
    }
    UnzipPassThrough.prototype.push = function (data, final) {
        this.ondata(null, data, final);
    };
    UnzipPassThrough.compression = 0;
    return UnzipPassThrough;
}())));

/**
 * Streaming DEFLATE decompression for ZIP archives. Prefer AsyncZipInflate for
 * better performance.
 */
var UnzipInflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a DEFLATE decompression that can be used in ZIP archives
     */
    function UnzipInflate() {
        var _this_1 = this;
        this.i = new Inflate(function (dat, final) {
            _this_1.ondata(null, dat, final);
        });
    }
    UnzipInflate.prototype.push = function (data, final) {
        try {
            this.i.push(data, final);
        }
        catch (e) {
            this.ondata(e, null, final);
        }
    };
    UnzipInflate.compression = 8;
    return UnzipInflate;
}())));

/**
 * Asynchronous streaming DEFLATE decompression for ZIP archives
 */
var AsyncUnzipInflate = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a DEFLATE decompression that can be used in ZIP archives
     */
    function AsyncUnzipInflate(_, sz) {
        var _this_1 = this;
        if (sz < 320000) {
            this.i = new Inflate(function (dat, final) {
                _this_1.ondata(null, dat, final);
            });
        }
        else {
            this.i = new AsyncInflate(function (err, dat, final) {
                _this_1.ondata(err, dat, final);
            });
            this.terminate = this.i.terminate;
        }
    }
    AsyncUnzipInflate.prototype.push = function (data, final) {
        if (this.i.terminate)
            data = slc(data, 0);
        this.i.push(data, final);
    };
    AsyncUnzipInflate.compression = 8;
    return AsyncUnzipInflate;
}())));

/**
 * A ZIP archive decompression stream that emits files as they are discovered
 */
var Unzip = /*#__PURE__*/ ((/* unused pure expression or super */ null && (function () {
    /**
     * Creates a ZIP decompression stream
     * @param cb The callback to call whenever a file in the ZIP archive is found
     */
    function Unzip(cb) {
        this.onfile = cb;
        this.k = [];
        this.o = {
            0: UnzipPassThrough
        };
        this.p = et;
    }
    /**
     * Pushes a chunk to be unzipped
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Unzip.prototype.push = function (chunk, final) {
        var _this_1 = this;
        if (!this.onfile)
            err(5);
        if (!this.p)
            err(4);
        if (this.c > 0) {
            var len = Math.min(this.c, chunk.length);
            var toAdd = chunk.subarray(0, len);
            this.c -= len;
            if (this.d)
                this.d.push(toAdd, !this.c);
            else
                this.k[0].push(toAdd);
            chunk = chunk.subarray(len);
            if (chunk.length)
                return this.push(chunk, final);
        }
        else {
            var f = 0, i = 0, is = void 0, buf = void 0;
            if (!this.p.length)
                buf = chunk;
            else if (!chunk.length)
                buf = this.p;
            else {
                buf = new u8(this.p.length + chunk.length);
                buf.set(this.p), buf.set(chunk, this.p.length);
            }
            var l = buf.length, oc = this.c, add = oc && this.d;
            var _loop_2 = function () {
                var _a;
                var sig = b4(buf, i);
                if (sig == 0x4034B50) {
                    f = 1, is = i;
                    this_1.d = null;
                    this_1.c = 0;
                    var bf = b2(buf, i + 6), cmp_1 = b2(buf, i + 8), u = bf & 2048, dd = bf & 8, fnl = b2(buf, i + 26), es = b2(buf, i + 28);
                    if (l > i + 30 + fnl + es) {
                        var chks_3 = [];
                        this_1.k.unshift(chks_3);
                        f = 2;
                        var sc_1 = b4(buf, i + 18), su_1 = b4(buf, i + 22);
                        var fn_1 = strFromU8(buf.subarray(i + 30, i += 30 + fnl), !u);
                        if (sc_1 == 4294967295) {
                            _a = dd ? [-2] : z64e(buf, i), sc_1 = _a[0], su_1 = _a[1];
                        }
                        else if (dd)
                            sc_1 = -1;
                        i += es;
                        this_1.c = sc_1;
                        var d_1;
                        var file_1 = {
                            name: fn_1,
                            compression: cmp_1,
                            start: function () {
                                if (!file_1.ondata)
                                    err(5);
                                if (!sc_1)
                                    file_1.ondata(null, et, true);
                                else {
                                    var ctr = _this_1.o[cmp_1];
                                    if (!ctr)
                                        file_1.ondata(err(14, 'unknown compression type ' + cmp_1, 1), null, false);
                                    d_1 = sc_1 < 0 ? new ctr(fn_1) : new ctr(fn_1, sc_1, su_1);
                                    d_1.ondata = function (err, dat, final) { file_1.ondata(err, dat, final); };
                                    for (var _i = 0, chks_4 = chks_3; _i < chks_4.length; _i++) {
                                        var dat = chks_4[_i];
                                        d_1.push(dat, false);
                                    }
                                    if (_this_1.k[0] == chks_3 && _this_1.c)
                                        _this_1.d = d_1;
                                    else
                                        d_1.push(et, true);
                                }
                            },
                            terminate: function () {
                                if (d_1 && d_1.terminate)
                                    d_1.terminate();
                            }
                        };
                        if (sc_1 >= 0)
                            file_1.size = sc_1, file_1.originalSize = su_1;
                        this_1.onfile(file_1);
                    }
                    return "break";
                }
                else if (oc) {
                    if (sig == 0x8074B50) {
                        is = i += 12 + (oc == -2 && 8), f = 3, this_1.c = 0;
                        return "break";
                    }
                    else if (sig == 0x2014B50) {
                        is = i -= 4, f = 3, this_1.c = 0;
                        return "break";
                    }
                }
            };
            var this_1 = this;
            for (; i < l - 4; ++i) {
                var state_1 = _loop_2();
                if (state_1 === "break")
                    break;
            }
            this.p = et;
            if (oc < 0) {
                var dat = f ? buf.subarray(0, is - 12 - (oc == -2 && 8) - (b4(buf, is - 16) == 0x8074B50 && 4)) : buf.subarray(0, i);
                if (add)
                    add.push(dat, !!f);
                else
                    this.k[+(f == 2)].push(dat);
            }
            if (f & 2)
                return this.push(buf.subarray(i), final);
            this.p = buf.subarray(i);
        }
        if (final) {
            if (this.c)
                err(13);
            this.p = null;
        }
    };
    /**
     * Registers a decoder with the stream, allowing for files compressed with
     * the compression type provided to be expanded correctly
     * @param decoder The decoder constructor
     */
    Unzip.prototype.register = function (decoder) {
        this.o[decoder.compression] = decoder;
    };
    return Unzip;
}())));

var mt = typeof queueMicrotask == 'function' ? queueMicrotask : typeof setTimeout == 'function' ? setTimeout : function (fn) { fn(); };
function unzip(data, opts, cb) {
    if (!cb)
        cb = opts, opts = {};
    if (typeof cb != 'function')
        err(7);
    var term = [];
    var tAll = function () {
        for (var i = 0; i < term.length; ++i)
            term[i]();
    };
    var files = {};
    var cbd = function (a, b) {
        mt(function () { cb(a, b); });
    };
    mt(function () { cbd = cb; });
    var e = data.length - 22;
    for (; b4(data, e) != 0x6054B50; --e) {
        if (!e || data.length - e > 65558) {
            cbd(err(13, 0, 1), null);
            return tAll;
        }
    }
    ;
    var lft = b2(data, e + 8);
    if (lft) {
        var c = lft;
        var o = b4(data, e + 16);
        var z = o == 4294967295;
        if (z) {
            e = b4(data, e - 12);
            if (b4(data, e) != 0x6064B50) {
                cbd(err(13, 0, 1), null);
                return tAll;
            }
            c = lft = b4(data, e + 32);
            o = b4(data, e + 48);
        }
        var fltr = opts && opts.filter;
        var _loop_3 = function (i) {
            var _a = zh(data, o, z), c_1 = _a[0], sc = _a[1], su = _a[2], fn = _a[3], no = _a[4], off = _a[5], b = slzh(data, off);
            o = no;
            var cbl = function (e, d) {
                if (e) {
                    tAll();
                    cbd(e, null);
                }
                else {
                    if (d)
                        files[fn] = d;
                    if (!--lft)
                        cbd(null, files);
                }
            };
            if (!fltr || fltr({
                name: fn,
                size: sc,
                originalSize: su,
                compression: c_1
            })) {
                if (!c_1)
                    cbl(null, slc(data, b, b + sc));
                else if (c_1 == 8) {
                    var infl = data.subarray(b, b + sc);
                    if (sc < 320000) {
                        try {
                            cbl(null, inflateSync(infl, new u8(su)));
                        }
                        catch (e) {
                            cbl(e, null);
                        }
                    }
                    else
                        term.push(inflate(infl, { size: su }, cbl));
                }
                else
                    cbl(err(14, 'unknown compression type ' + c_1, 1), null);
            }
            else
                cbl(null, null);
        };
        for (var i = 0; i < c; ++i) {
            _loop_3(i);
        }
    }
    else
        cbd(null, {});
    return tAll;
}
/**
 * Synchronously decompresses a ZIP archive. Prefer using `unzip` for better
 * performance with more than one file.
 * @param data The raw compressed ZIP file
 * @param opts The ZIP extraction options
 * @returns The decompressed files
 */
function unzipSync(data, opts) {
    var files = {};
    var e = data.length - 22;
    for (; b4(data, e) != 0x6054B50; --e) {
        if (!e || data.length - e > 65558)
            err(13);
    }
    ;
    var c = b2(data, e + 8);
    if (!c)
        return {};
    var o = b4(data, e + 16);
    var z = o == 4294967295;
    if (z) {
        e = b4(data, e - 12);
        if (b4(data, e) != 0x6064B50)
            err(13);
        c = b4(data, e + 32);
        o = b4(data, e + 48);
    }
    var fltr = opts && opts.filter;
    for (var i = 0; i < c; ++i) {
        var _a = zh(data, o, z), c_2 = _a[0], sc = _a[1], su = _a[2], fn = _a[3], no = _a[4], off = _a[5], b = slzh(data, off);
        o = no;
        if (!fltr || fltr({
            name: fn,
            size: sc,
            originalSize: su,
            compression: c_2
        })) {
            if (!c_2)
                files[fn] = slc(data, b, b + sc);
            else if (c_2 == 8)
                files[fn] = inflateSync(data.subarray(b, b + sc), new u8(su));
            else
                err(14, 'unknown compression type ' + c_2);
        }
    }
    return files;
}

// EXTERNAL MODULE: consume shared module (default) generic-filehandle@^2.2.1 (strict) (fallback: ./node_modules/generic-filehandle/dist/index.js)
var index_js_ = __webpack_require__(2493);
var index_js_default = /*#__PURE__*/__webpack_require__.n(index_js_);
// EXTERNAL MODULE: ./node_modules/pubsub-js/src/pubsub.js
var pubsub = __webpack_require__(1798);
var pubsub_default = /*#__PURE__*/__webpack_require__.n(pubsub);
;// CONCATENATED MODULE: ./node_modules/gosling-theme/dist/gosling-theme.es.js
const gosling_theme_es_t=["#E79F00","#029F73","#0072B2","#CB7AA7","#D45E00","#57B4E9","#EFE441"],o={color:gosling_theme_es_t[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:gosling_theme_es_t,quantitativeSizeRange:[2,6]},e={base:"light",root:{background:"white",titleColor:"black",titleBackgroundColor:"transparent",titleFontSize:18,titleFontFamily:"Arial",titleAlign:"left",titleFontWeight:"bold",subtitleColor:"gray",subtitleBackgroundColor:"transparent",subtitleFontSize:16,subtitleFontFamily:"Arial",subtitleFontWeight:"normal",subtitleAlign:"left",showMousePosition:!0,mousePositionColor:"#000000"},track:{background:"transparent",alternatingBackground:"transparent",titleColor:"black",titleBackground:"white",titleFontSize:12,titleAlign:"left",outline:"black",outlineWidth:1},legend:{position:"top",background:"white",backgroundOpacity:.7,labelColor:"black",labelFontSize:12,labelFontWeight:"normal",labelFontFamily:"Arial",backgroundStroke:"#DBDBDB",tickColor:"black"},axis:{tickColor:"black",labelColor:"black",labelFontSize:12,labelFontWeight:"normal",labelFontFamily:"Arial",baselineColor:"black",gridColor:"#E3E3E3",gridStrokeWidth:1,gridStrokeType:"solid",gridStrokeDash:[4,4]},markCommon:{...o},point:{...o,size:3},rect:{...o},triangle:{...o},area:{...o},line:{...o},bar:{...o},rule:{...o,strokeWidth:1},link:{...o,strokeWidth:1},text:{...o,textAnchor:"middle",textFontWeight:"normal"},brush:{...o,color:"gray",opacity:.3,stroke:"black",strokeWidth:1}},gosling_theme_es_i=["#E79F00","#029F73","#0072B2","#CB7AA7","#D45E00","#57B4E9","#EFE441"],l={...{color:gosling_theme_es_i[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:gosling_theme_es_i,quantitativeSizeRange:[2,6]},stroke:"white"},r={base:"dark",root:{background:"black",titleColor:"white",subtitleColor:"lightgray",mousePositionColor:"#FFFFFF",showMousePosition:!0},track:{titleColor:"white",titleBackground:"black",outline:"white",outlineWidth:1},legend:{background:"black",backgroundOpacity:.7,labelColor:"white",backgroundStroke:"#DBDBDB",tickColor:"white"},axis:{tickColor:"white",labelColor:"white",baselineColor:"white",gridColor:"gray",gridStrokeWidth:1},markCommon:{...l},point:{...l,size:3},rect:{...l},triangle:{...l},area:{...l},line:{...l},bar:{...l},rule:{...l,strokeWidth:1},link:{...l,strokeWidth:1},text:{...l,textAnchor:"middle",textFontWeight:"normal"},brush:{...l,color:"lightgray",opacity:.3,stroke:"white",strokeWidth:1}},a=["#D19000","#008F67","#005F96","#B86E97","#B55100","#4793BF","#C9C03"],n={color:a[0],size:1,stroke:"#3C3C3C",strokeWidth:0,opacity:1,nominalColorRange:a,quantitativeSizeRange:[2,6]},k={base:"warm",root:{background:"#FFF8E8",titleColor:"#3C3C3C",subtitleColor:"gray",showMousePosition:!0,mousePositionColor:"#3C3C3C"},track:{titleColor:"#3C3C3C",titleBackground:"#FFF8E8",outline:"#3C3C3C",outlineWidth:1},legend:{background:"#FFF8E8",backgroundOpacity:.7,labelColor:"#3C3C3C",backgroundStroke:"#3C3C3C",tickColor:"3C3C3C"},axis:{tickColor:"#3C3C3C",labelColor:"#3C3C3C",baselineColor:"#3C3C3C",gridColor:"#E3E3E3",gridStrokeWidth:1},markCommon:{...n},point:{...n,size:3},rect:{...n},triangle:{...n},area:{...n},line:{...n},bar:{...n},rule:{...n,strokeWidth:1},link:{...n,strokeWidth:1},text:{...n,textAnchor:"middle",textFontWeight:"normal"},brush:{...n,color:"lightgray",opacity:.3,stroke:"#3C3C3C",strokeWidth:1}},b=["#F66A62","#05B230","#5692FF","#D764D6","#86E9D4","#6E6AD7","#FFFB00"],gosling_theme_es_c={color:b[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:b,quantitativeSizeRange:[2,6]},g={base:"ggplot",root:{background:"white",titleColor:"black",titleFontSize:18,titleFontFamily:"Helvetica",titleAlign:"middle",titleFontWeight:"bold",titleBackgroundColor:"white",subtitleColor:"gray",subtitleFontSize:14,subtitleFontFamily:"Helvetica",subtitleAlign:"middle",subtitleFontWeight:"light",subtitleBackgroundColor:"white",showMousePosition:!0,mousePositionColor:"black"},track:{background:"#e8e8e8",alternatingBackground:"#d1d1d1",titleColor:"black",titleBackground:"white",outline:"black",outlineWidth:2},legend:{position:"right",background:"#e8e8e8",backgroundOpacity:1,labelColor:"black",backgroundStroke:"#e8e8e8",tickColor:"white"},axis:{tickColor:"white",labelColor:"black",baselineColor:"#e8e8e8",gridColor:"white",gridStrokeWidth:2},markCommon:{...gosling_theme_es_c},point:{...gosling_theme_es_c,size:3},rect:{...gosling_theme_es_c},triangle:{...gosling_theme_es_c},area:{...gosling_theme_es_c},line:{...gosling_theme_es_c},bar:{...gosling_theme_es_c},rule:{...gosling_theme_es_c,strokeWidth:1},link:{...gosling_theme_es_c,strokeWidth:1},text:{...gosling_theme_es_c,textAnchor:"middle",textFontWeight:"bold"},brush:{...gosling_theme_es_c,color:"black",opacity:.3,stroke:"black",strokeWidth:1}},s=["#37E649","#ED2D44","#AEAFEA","#EBAEAE","#CE7B3D","#8743E0","#5233F0"],d={color:s[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:s,quantitativeSizeRange:[2,6]},gosling_theme_es_C={base:"igv",root:{background:"white",titleColor:"white",titleAlign:"left",titleFontWeight:"bold",titleBackgroundColor:"#5f5f5f",subtitleColor:"#3b3b3b",subtitleAlign:"left",subtitleFontWeight:"bold",subtitleBackgroundColor:"#c4c4c4",showMousePosition:!0,mousePositionColor:"black"},track:{background:"white",alternatingBackground:"#e8e8e8",titleColor:"white",titleBackground:"#5F5F5F",outline:"#5F5F5F",outlineWidth:1},legend:{position:"top",background:"white",backgroundOpacity:1,labelColor:"black",backgroundStroke:"black",tickColor:"black"},axis:{tickColor:"black",labelColor:"black",baselineColor:"white",gridColor:"transparent",gridStrokeWidth:0},markCommon:{...d},point:{...d,size:3},rect:{...d},triangle:{...d},area:{...d},line:{...d},bar:{...d},rule:{...d,strokeWidth:1},link:{...d,strokeWidth:1},text:{...d,textAnchor:"middle",textFontWeight:"bold"},brush:{...d,color:"white",opacity:.3,stroke:"black",strokeWidth:1}},u=["#CD9B1D","#8A668B","#40E0D0","#FF6969","#666666","#FAC902","#FE0000","#CC96CD","#D9D9D9"],h={color:u[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:u,quantitativeSizeRange:[2,6]},F={base:"ensembl",root:{background:"white",titleColor:"#494949",titleFontSize:24,titleFontFamily:"GGX88",titleAlign:"left",titleFontWeight:"bold",titleBackgroundColor:"white",subtitleColor:"white",subtitleFontSize:19,subtitleFontFamily:"GGX88",subtitleAlign:"left",subtitleFontWeight:"normal",subtitleBackgroundColor:"#7B8BAF",mousePositionColor:"#FE0000",showMousePosition:!0},track:{background:"white",alternatingBackground:"#fffdf7",titleColor:"black",titleBackground:"white",titleFontSize:"normal",titleAlign:"left",outline:"#7B8BAF",outlineWidth:2},legend:{position:"middle",tickColor:"black",labelColor:"black",labelFontWeight:"normal",labelFontFamily:"GGX88",background:"white",backgroundOpacity:2,backgroundStroke:"lightgray"},axis:{tickColor:"black",labelColor:"black",labelFontFamily:"GGX88",baselineColor:"black",gridColor:"#7B8BAF",gridStrokeWidth:2},markCommon:{...h},point:{...h,size:3},rect:{...h},triangle:{...h},area:{...h},line:{...h},bar:{...h},rule:{...h,strokeWidth:1},link:{...h,strokeWidth:1},text:{...h,textAnchor:"middle",textFontWeight:"normal"},brush:{...h,color:"gray",opacity:.3,stroke:"black",strokeWidth:1}},gosling_theme_es_A=["#3A62FE","#F85353","#3A62FE","#F85353","#DCA326","#03BF06","#BABABA"],m={color:gosling_theme_es_A[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:gosling_theme_es_A,quantitativeSizeRange:[2,6]},W={base:"jbrowse",root:{background:"white",titleColor:"white",titleFontSize:20,titleFontFamily:"Roboto",titleAlign:"middle",titleFontWeight:"normal",titleBackgroundColor:"#0b243f",subtitleColor:"white",subtitleFontSize:18,subtitleFontFamily:"Roboto",subtitleAlign:"middle",subtitleFontWeight:"normal",subtitleBackgroundColor:"#732162",showMousePosition:!0,mousePositionColor:"#000000"},track:{background:"white",alternatingBackground:"white",titleAlign:"middle",titleColor:"white",titleBackground:"#0B243F",outline:"black",outlineWidth:1},legend:{position:"top",background:"white",backgroundOpacity:.7,labelColor:"#DCA326",labelFontWeight:"bold",labelFontFamily:"Roboto",backgroundStroke:"#black",tickColor:"black"},axis:{tickColor:"black",labelColor:"#DCA326",labelFontWeight:"bold",labelFontFamily:"Roboto",baselineColor:"black",gridColor:"#c5d5d9",gridStrokeWidth:1},markCommon:{...m},point:{...m,size:3},rect:{...m},triangle:{...m},area:{...m},line:{...m},bar:{...m},rule:{...m,strokeWidth:1},link:{...m,strokeWidth:1},text:{...m,textAnchor:"middle",textFontWeight:"normal"},brush:{...m,color:"#c5d5d9",opacity:.3,stroke:"black",strokeWidth:1}},gosling_theme_es_B=["#3A5FCD","#FFA54E","#8FBC8F","#B6709B","#EE6A50","#CCB79E","#DADA8F","#00CDCC","#EED5D2","#CD8EDD","#9ACD31","#D1BEA8","#FFB6C0"],w={color:gosling_theme_es_B[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:gosling_theme_es_B,quantitativeSizeRange:[2,6]},y={base:"ucsc",root:{background:"white",titleColor:"white",titleFontSize:22,titleAlign:"middle",titleFontWeight:"bold",titleBackgroundColor:"#00457c",subtitleColor:"black",subtitleAlign:"middle",subtitleFontWeight:"bold",subtitleBackgroundColor:"white",showMousePosition:!0,mousePositionColor:"#FE0000"},track:{background:"white",alternatingBackground:"#e3f7fc",titleColor:"#3A5FCD",titleBackground:"white",outline:"black",outlineWidth:1},legend:{position:"top",background:"white",backgroundOpacity:.7,labelColor:"black",labelFontWeight:"bold",backgroundStroke:"#DBDBDB",tickColor:"black"},axis:{tickColor:"black",labelColor:"#3A5FCD",labelFontWeight:"bold",baselineColor:"black",gridColor:"#E3E3E3",gridStrokeWidth:1},markCommon:{...w},point:{...w,size:3},rect:{...w},triangle:{...w},area:{...w},line:{...w},bar:{...w},rule:{...w,strokeWidth:1},link:{...w,strokeWidth:1},text:{...w,textAnchor:"middle",textFontWeight:"normal"},brush:{...w,color:"gray",opacity:.3,stroke:"black",strokeWidth:1}},p=["#6E12AC","#15C250","#E70FB1","#FF8E55","#A3B8F3","#DE5E59","#77AAAA","#F5CCCA"],gosling_theme_es_E={color:p[0],size:1,stroke:"black",strokeWidth:0,opacity:1,nominalColorRange:p,quantitativeSizeRange:[2,6]},S={base:"washu",root:{background:"white",titleColor:"gray",titleAlign:"left",titleFontWeight:"normal",titleBackgroundColor:"white",subtitleColor:"lightgray",subtitleAlign:"left",subtitleFontWeight:"light",subtitleBackgroundColor:"white",showMousePosition:!0,mousePositionColor:"#000000"},track:{background:"white",titleColor:"gray",titleBackground:"white",titleAlign:"left",outline:"gray",outlineWidth:1},legend:{position:"left",background:"white",backgroundOpacity:.5,labelColor:"gray",labelFontWeight:"light",backgroundStroke:"#DBDBDB",tickColor:"gray"},axis:{tickColor:"lightgray",labelColor:"gray",labelFontWeight:"light",baselineColor:"gray",gridColor:"transparent",gridStrokeWidth:0},markCommon:{...gosling_theme_es_E},point:{...gosling_theme_es_E,size:3},rect:{...gosling_theme_es_E},triangle:{...gosling_theme_es_E},area:{...gosling_theme_es_E},line:{...gosling_theme_es_E},bar:{...gosling_theme_es_E},rule:{...gosling_theme_es_E,strokeWidth:1},link:{...gosling_theme_es_E,strokeWidth:1},text:{...gosling_theme_es_E,textAnchor:"middle",textFontWeight:"normal"},brush:{...gosling_theme_es_E,color:"gray",opacity:.3,stroke:"gray",strokeWidth:1}},z=["#ED7D31","#4472C4","#FFC207","#76AE4F","#9E480E","#A5A5A5","#4472C4","#264378","#76AE4F","#5B9CD5"],gosling_theme_es_D={color:z[0],size:1,stroke:"#5A5A5A",strokeWidth:0,opacity:1,nominalColorRange:z,quantitativeSizeRange:[2,6]},gosling_theme_es_x={base:"excel",root:{background:"white",titleColor:"#5A5A5A",titleFontSize:30,titleFontFamily:"Calibri",titleAlign:"middle",titleFontWeight:"bold",titleBackgroundColor:"white",subtitleColor:"#5A5A5A",subtitleFontSize:22,subtitleFontFamily:"Calibri",subtitleAlign:"middle",subtitleFontWeight:"bold",subtitleBackgroundColor:"white",showMousePosition:!0,mousePositionColor:"#000000"},track:{background:"white",alternatingBackground:"#f5f5f5",titleColor:"#5A5A5A",titleBackground:"white",outline:"#5A5A5A",outlineWidth:1},legend:{position:"right",tickColor:"#5A5A5A",labelColor:"#5A5A5A",labelFontSize:12,labelFontWeight:"bold",labelFontFamily:"Calibri",background:"white",backgroundOpacity:.7,backgroundStroke:"#5A5A5A"},axis:{tickColor:"#5A5A5A",labelColor:"#5A5A5A",labelFontFamily:"Calibri",baselineColor:"#5A5A5A",gridColor:"#5A5A5A",gridStrokeWidth:1},markCommon:{...gosling_theme_es_D},point:{...gosling_theme_es_D,size:3},rect:{...gosling_theme_es_D},triangle:{...gosling_theme_es_D},area:{...gosling_theme_es_D},line:{...gosling_theme_es_D},bar:{...gosling_theme_es_D},rule:{...gosling_theme_es_D,strokeWidth:1},link:{...gosling_theme_es_D,strokeWidth:1},text:{...gosling_theme_es_D,textAnchor:"middle",textFontWeight:"normal"},brush:{...gosling_theme_es_D,color:"#5A5A5A",opacity:.3,stroke:"#5A5A5A",strokeWidth:1}},f=["#4185f4","#DB4437","#F4B400","#0D9D58","#AA30C3","#FF6E02","#CBC74C"],R={color:f[0],size:2,stroke:"black",strokeWidth:.3,opacity:1,nominalColorRange:f,quantitativeSizeRange:[2,6]},P={light:e,dark:r,warm:k,ggplot:g,igv:gosling_theme_es_C,ensembl:F,jbrowse:W,ucsc:y,washu:S,excel:gosling_theme_es_x,google:{base:"google",root:{background:"white",titleColor:"#454545",titleFontSize:20,titleFontFamily:"Arial",titleAlign:"left",titleFontWeight:"normal",titleBackgroundColor:"white",subtitleColor:"#7d7d7d",subtitleFontSize:16,subtitleFontFamily:"Arial",subtitleAlign:"left",subtitleFontWeight:"light",subtitleBackgroundColor:"white",showMousePosition:!0,mousePositionColor:"#000000"},track:{background:"white",alternatingBackground:"#f5f5f5",titleColor:"#e8e8e8",titleBackground:"white",titleFontSize:12,titleAlign:"left",outline:"black",outlineWidth:1},legend:{position:"right",background:"white",backgroundOpacity:1,labelColor:"black",labelFontSize:12,labelFontWeight:"normal",labelFontFamily:"Arial",backgroundStroke:"black",tickColor:"black"},axis:{labelFontSize:12,labelFontWeight:"normal",labelFontFamily:"Arial",tickColor:"black",labelColor:"black",baselineColor:"black",gridColor:"black",gridStrokeWidth:1},markCommon:{...R},point:{...R,size:3},rect:{...R},triangle:{...R},area:{...R},line:{...R},bar:{...R},rule:{...R,strokeWidth:1},link:{...R,strokeWidth:1},text:{...R,textAnchor:"middle",textFontWeight:"normal"},brush:{...R,color:"#999999",opacity:.3,stroke:"black",strokeWidth:.7}}};function v(t){return-1!==Object.keys(P).indexOf(t)}function O(t){return v(t)?P[t]:P.light}
//# sourceMappingURL=gosling-theme.es.js.map

// EXTERNAL MODULE: ./node_modules/threads/dist/index.js
var dist = __webpack_require__(3734);
var dist_default = /*#__PURE__*/__webpack_require__.n(dist);
;// CONCATENATED MODULE: ./node_modules/threads/index.mjs


const registerSerializer = (dist_default()).registerSerializer
const spawn = (dist_default()).spawn
const BlobWorker = (dist_default()).BlobWorker
const DefaultSerializer = (dist_default()).DefaultSerializer
const Pool = (dist_default()).Pool
const Thread = (dist_default()).Thread
const Transfer = (dist_default()).Transfer
const threads_Worker = (dist_default()).Worker

// EXTERNAL MODULE: consume shared module (default) react@^17.0.1 (singleton)
var consume_shared_module_default_react_17_0_singleton_ = __webpack_require__(6271);
var consume_shared_module_default_react_17_0_singleton_default = /*#__PURE__*/__webpack_require__.n(consume_shared_module_default_react_17_0_singleton_);
// EXTERNAL MODULE: consume shared module (default) react-dom@^17.0.1 (singleton)
var consume_shared_module_default_react_dom_17_0_singleton_ = __webpack_require__(4456);
var consume_shared_module_default_react_dom_17_0_singleton_default = /*#__PURE__*/__webpack_require__.n(consume_shared_module_default_react_dom_17_0_singleton_);
// EXTERNAL MODULE: ./node_modules/higlass/dist/hglib.js
var hglib = __webpack_require__(7949);
;// CONCATENATED MODULE: ./node_modules/gosling.js/dist/gosling.es.js





















const name$1 = "gosling.js";
const author = "Sehi L'Yi";
const version$1 = "0.9.16";
const license = "MIT";
const repository = {
  type: "git",
  url: "https://github.com/gosling-lang/gosling.js"
};
const homepage = "https://gosling-lang.github.io/gosling.js/";
const main = "dist/gosling.js";
const gosling_es_module = "dist/gosling.es.js";
const types = "dist/src/index.d.ts";
const files = [
  "dist"
];
const gosling_es_exports = {
  ".": "./dist/gosling.es.js",
  "./embed": "./dist/embed/index.js"
};
const scripts = {
  start: "vite --mode editor",
  "start-embed": "vite",
  build: "run-p build-types build-lib",
  "build-lib": "vite build --mode lib && node scripts/build-umd && node scripts/build-embed",
  "build-types": "tsc --emitDeclarationOnly",
  "build-editor": "vite build",
  preview: "vite preview",
  test: "jest editor/ src/",
  changelog: "conventional-changelog -p angular -i CHANGELOG.md -s -r 0",
  format: "eslint src/ editor/ --fix && prettier 'editor/**/*.css' --write",
  schema: "ts-json-schema-generator -p src/index.ts -f tsconfig.json -t GoslingSpec --no-type-check --no-ref-encode > schema/gosling.schema.json",
  "schema-higlass": "ts-json-schema-generator -p src/index.ts -f tsconfig.json -t HiGlassSpec --no-type-check --no-ref-encode > schema/higlass.schema.json",
  "schema-theme": "ts-json-schema-generator -p src/index.ts -f tsconfig.json -t Theme --no-type-check --no-ref-encode > schema/theme.schema.json",
  "schema-template": "ts-json-schema-generator -p src/index.ts -f tsconfig.json -t TemplateTrackDef --no-type-check --no-ref-encode > schema/template.schema.json",
  "schema-versioning": "mkdir -p schema/history/$npm_package_version && cp schema/gosling.schema.json schema/history/$npm_package_version/gosling$npm_package_version.schema.json && cp src/core/gosling.schema.ts schema/history/$npm_package_version/gosling$npm_package_version.schema.ts",
  predeploy: 'yarn build-editor; echo "gosling.js.org" >> build/CNAME',
  deploy: "gh-pages -d build"
};
const peerDependencies = {
  "pixi.js": "^6.0.4",
  react: "16.13.1",
  "react-dom": "16.13.1"
};
const sideEffect = false;
const dependencies$1 = {
  "@gmod/bam": "^1.1.8",
  "@gmod/bbi": "^1.0.30",
  "@types/bezier-js": "^4.1.0",
  "@types/d3": "^7.0.0",
  "@types/lodash": "^4.14.151",
  "@types/node": "^12.0.0",
  "@types/rbush": "^3.0.0",
  "@types/uuid": "^8.3.1",
  "bezier-js": "4.0.3",
  buffer: "^6.0.3",
  "d3-array": "^2.5.1",
  "d3-color": "^2.0.0",
  "d3-dsv": "^2.0.0",
  "d3-scale": "^3.2.1",
  "d3-scale-chromatic": "^2.0.0",
  "d3-shape": "^2.0.0",
  fflate: "^0.7.1",
  "generic-filehandle": "^2.2.1",
  "gosling-theme": "^0.0.10",
  higlass: "^1.11.8",
  "higlass-register": "^0.3.0",
  "higlass-text": "^0.1.1",
  "json-stringify-pretty-compact": "^2.0.0",
  jspdf: "^2.3.1",
  "lodash-es": "^4.17.21",
  mixwith: "^0.1.1",
  "pubsub-js": "^1.9.3",
  rbush: "^3.0.1",
  "react-grid-layout": "^1.2.5",
  threads: "^1.6.4",
  uuid: "^8.3.2"
};
const devDependencies = {
  "@babel/core": "^7.11.1",
  "@commitlint/cli": "^11.0.0",
  "@commitlint/config-conventional": "^11.0.0",
  "@testing-library/jest-dom": "^5.11.3",
  "@testing-library/react": "^10.4.8",
  "@testing-library/user-event": "^12.1.1",
  "@types/d3-drag": "1",
  "@types/d3-selection": "1",
  "@types/jest": "^26.0.10",
  "@types/lodash-es": "^4.17.5",
  "@types/pubsub-js": "^1.8.2",
  "@types/qs": "^6.9.5",
  "@types/react": "^16.9.46",
  "@types/react-dom": "^16.9.8",
  "@types/react-resize-detector": "^4.2.0",
  "@types/react-router-dom": "^5.1.6",
  "@typescript-eslint/eslint-plugin": "^4.8.1",
  "@typescript-eslint/parser": "^4.8.1",
  "@vitejs/plugin-react-refresh": "^1.3.6",
  ajv: "^6.12.2",
  "babel-jest": "^26.3.0",
  canvas: "^2.6.1",
  "conventional-changelog-cli": "^2.1.1",
  "cross-fetch": "^3.0.6",
  "d3-drag": "^1",
  "d3-selection": "^1",
  documentation: "^13.0.2",
  esbuild: "^0.12.25",
  eslint: "^7.6.0",
  "eslint-config-prettier": "^6.11.0",
  "eslint-plugin-jest": "^23.20.0",
  "eslint-plugin-prettier": "^3.1.4",
  "eslint-plugin-react": "^7.20.6",
  "fetch-jsonp": "^1.1.3",
  "gh-pages": "^3.1.0",
  "git-branch-is": "^4.0.0",
  husky: "^4.2.5",
  jest: "^26.4.0",
  "jest-canvas-mock": "^2.3.0",
  "jest-raw-loader": "^1.0.1",
  jsoncrush: "^1.1.6",
  "npm-run-all": "^4.1.5",
  "pixi.js": "^6.0.4",
  prettier: "^2.0.5",
  qs: "^6.9.4",
  react: "16.13.1",
  "react-dom": "16.13.1",
  "react-markdown": "^5.0.3",
  "react-monaco-editor": "^0.45.0",
  "react-resize-detector": "^4.2.3",
  "react-router-dom": "^5.2.0",
  "react-split-pane": "^0.1.91",
  "remark-gfm": "^1.0.0",
  "strip-json-comments": "^3.1.1",
  "ts-jest": "^26.2.0",
  "ts-json-schema-generator": "^0.75.0",
  typescript: "~4.1.2",
  vite: "^2.5.10"
};
const resolutions = {
  slugid: "^3.0.0"
};
const browserslist = {
  production: [
    ">0.2%",
    "not dead",
    "not op_mini all"
  ],
  development: [
    "last 1 chrome version",
    "last 1 firefox version",
    "last 1 safari version"
  ]
};
const jest = {
  moduleNameMapper: {
    inline$: "jest-raw-loader",
    "^lodash-es$": "lodash"
  },
  setupFiles: [
    "jest-canvas-mock"
  ],
  preset: "ts-jest",
  verbose: true,
  moduleFileExtensions: [
    "js",
    "ts"
  ],
  coverageDirectory: "./coverage/",
  collectCoverage: true,
  collectCoverageFrom: [
    "**/src/**/*.{js,ts}",
    "!**/node_modules/**",
    "!**/coverage/**",
    "!**/public/**",
    "!**/dist/**",
    "!**/editor/**",
    "!**/deprecated/**"
  ],
  coverageReporters: [
    "lcov",
    "text"
  ]
};
const husky = {
  hooks: {
    "pre-commit": "yarn changelog && yarn schema && yarn schema-higlass && yarn schema-theme && yarn schema-template && yarn format && git add .",
    "commit-msg": "commitlint -E HUSKY_GIT_PARAMS"
  }
};
var pkg = {
  name: name$1,
  author,
  version: version$1,
  license,
  repository,
  homepage,
  main,
  module: gosling_es_module,
  types,
  files,
  exports: gosling_es_exports,
  scripts,
  peerDependencies,
  sideEffect,
  dependencies: dependencies$1,
  devDependencies,
  resolutions,
  browserslist,
  jest,
  husky
};
const $ref$2 = "#/definitions/GoslingSpec";
const $schema$4 = "http://json-schema.org/draft-07/schema#";
const definitions$3 = {
  Aggregate: {
    "enum": [
      "max",
      "min",
      "mean",
      "bin",
      "count"
    ],
    type: "string"
  },
  Assembly: {
    "enum": [
      "hg38",
      "hg19",
      "hg18",
      "hg17",
      "hg16",
      "mm10",
      "mm9",
      "unknown"
    ],
    type: "string"
  },
  AxisPosition: {
    "enum": [
      "none",
      "top",
      "bottom",
      "left",
      "right"
    ],
    type: "string"
  },
  BAMData: {
    additionalProperties: false,
    description: "Binary Alignment Map (BAM) is the comprehensive raw data of genome sequencing; it consists of the lossless, compressed binary representation of the Sequence Alignment Map-files.",
    properties: {
      extractJunction: {
        description: "Determine whether to extract exon-to-exon junctions. __Default__: `false`",
        type: "boolean"
      },
      indexUrl: {
        description: "URL link to the index file of the BAM file",
        type: "string"
      },
      junctionMinCoverage: {
        description: "Determine the threshold of coverage when extracting exon-to-exon junctions. __Default__: `1`",
        type: "number"
      },
      loadMates: {
        description: "Load mates that are located in the same chromosome. __Default__: `false`",
        type: "boolean"
      },
      maxInsertSize: {
        description: "Determines the threshold of insert sizes for determining the structural variants. __Default__: `5000`",
        type: "number"
      },
      type: {
        "const": "bam",
        type: "string"
      },
      url: {
        description: "URL link to the BAM data file",
        type: "string"
      }
    },
    required: [
      "type",
      "url",
      "indexUrl"
    ],
    type: "object"
  },
  BEDDBData: {
    additionalProperties: false,
    description: "Regular BED or similar files can be pre-aggregated for the scalable data exploration. Find our more about this format at [HiGlass Docs](https://docs.higlass.io/data_preparation.html#bed-files).",
    properties: {
      exonIntervalFields: {
        description: "experimental",
        items: [
          {
            additionalProperties: false,
            properties: {
              index: {
                type: "number"
              },
              name: {
                type: "string"
              }
            },
            required: [
              "index",
              "name"
            ],
            type: "object"
          },
          {
            additionalProperties: false,
            properties: {
              index: {
                type: "number"
              },
              name: {
                type: "string"
              }
            },
            required: [
              "index",
              "name"
            ],
            type: "object"
          }
        ],
        maxItems: 2,
        minItems: 2,
        type: "array"
      },
      genomicFields: {
        description: "Specify the name of genomic data fields.",
        items: {
          additionalProperties: false,
          properties: {
            index: {
              type: "number"
            },
            name: {
              type: "string"
            }
          },
          required: [
            "index",
            "name"
          ],
          type: "object"
        },
        type: "array"
      },
      type: {
        "const": "beddb",
        type: "string"
      },
      url: {
        description: "Specify the URL address of the data file.",
        type: "string"
      },
      valueFields: {
        description: "Specify the column indexes, field names, and field types.",
        items: {
          additionalProperties: false,
          properties: {
            index: {
              type: "number"
            },
            name: {
              type: "string"
            },
            type: {
              "enum": [
                "nominal",
                "quantitative"
              ],
              type: "string"
            }
          },
          required: [
            "index",
            "name",
            "type"
          ],
          type: "object"
        },
        type: "array"
      }
    },
    required: [
      "type",
      "url",
      "genomicFields"
    ],
    type: "object"
  },
  BIGWIGData: {
    additionalProperties: false,
    properties: {
      aggregation: {
        $ref: "#/definitions/BinAggregate",
        description: 'Determine aggregation function to apply within bins. __Default__: `"mean"`'
      },
      binSize: {
        description: "Binning the genomic interval in tiles (unit size: 256).",
        type: "number"
      },
      column: {
        description: "Assign a field name of the middle position of genomic intervals.",
        type: "string"
      },
      end: {
        description: "Assign a field name of the end position of genomic intervals.",
        type: "string"
      },
      start: {
        description: "Assign a field name of the start position of genomic intervals.",
        type: "string"
      },
      type: {
        "const": "bigwig",
        type: "string"
      },
      url: {
        description: "Specify the URL address of the data file.",
        type: "string"
      },
      value: {
        description: "Assign a field name of quantitative values.",
        type: "string"
      }
    },
    required: [
      "type",
      "url",
      "column",
      "value"
    ],
    type: "object"
  },
  BinAggregate: {
    "enum": [
      "mean",
      "sum"
    ],
    type: "string"
  },
  CSVData: {
    additionalProperties: false,
    description: 'Any small enough tabular data files, such as tsv, csv, BED, BEDPE, and GFF, can be loaded using "csv" data specification.',
    properties: {
      chromosomeField: {
        description: "Specify the name of chromosome data fields.",
        type: "string"
      },
      chromosomePrefix: {
        description: "experimental",
        type: "string"
      },
      genomicFields: {
        description: "Specify the name of genomic data fields.",
        items: {
          type: "string"
        },
        type: "array"
      },
      genomicFieldsToConvert: {
        description: "experimental",
        items: {
          additionalProperties: false,
          properties: {
            chromosomeField: {
              type: "string"
            },
            genomicFields: {
              items: {
                type: "string"
              },
              type: "array"
            }
          },
          required: [
            "chromosomeField",
            "genomicFields"
          ],
          type: "object"
        },
        type: "array"
      },
      headerNames: {
        description: "Specify the names of data fields if a CSV file is headerless.",
        items: {
          type: "string"
        },
        type: "array"
      },
      longToWideId: {
        description: "experimental",
        type: "string"
      },
      sampleLength: {
        description: "Specify the number of rows loaded from the URL.\n\n__Default:__ `1000`",
        type: "number"
      },
      separator: {
        description: "Specify file separator, __Default:__ ','",
        type: "string"
      },
      type: {
        "const": "csv",
        type: "string"
      },
      url: {
        description: "Specify the URL address of the data file.",
        type: "string"
      }
    },
    required: [
      "type",
      "url"
    ],
    type: "object"
  },
  Channel: {
    anyOf: [
      {
        $ref: "#/definitions/ChannelDeep"
      },
      {
        $ref: "#/definitions/ChannelValue"
      }
    ]
  },
  ChannelDeep: {
    anyOf: [
      {
        $ref: "#/definitions/X"
      },
      {
        $ref: "#/definitions/Y"
      },
      {
        $ref: "#/definitions/Row"
      },
      {
        $ref: "#/definitions/Color"
      },
      {
        $ref: "#/definitions/Size"
      },
      {
        $ref: "#/definitions/Stroke"
      },
      {
        $ref: "#/definitions/StrokeWidth"
      },
      {
        $ref: "#/definitions/Opacity"
      },
      {
        $ref: "#/definitions/Text"
      }
    ]
  },
  ChannelValue: {
    additionalProperties: false,
    properties: {
      value: {
        description: "Assign a constant value for a visual channel.",
        type: [
          "number",
          "string"
        ]
      }
    },
    required: [
      "value"
    ],
    type: "object"
  },
  Chromosome: {
    "enum": [
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "10",
      "11",
      "12",
      "13",
      "14",
      "15",
      "16",
      "17",
      "18",
      "19",
      "20",
      "21",
      "22",
      "X",
      "Y",
      "M",
      "chr1",
      "chr2",
      "chr3",
      "chr4",
      "chr5",
      "chr6",
      "chr7",
      "chr8",
      "chr9",
      "chr10",
      "chr11",
      "chr12",
      "chr13",
      "chr14",
      "chr15",
      "chr16",
      "chr17",
      "chr18",
      "chr19",
      "chr20",
      "chr21",
      "chr22",
      "chrX",
      "chrY",
      "chrM"
    ],
    type: "string"
  },
  Color: {
    additionalProperties: false,
    properties: {
      domain: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field",
        type: "string"
      },
      legend: {
        description: "Whether to display legend. __Default__: `false`",
        type: "boolean"
      },
      range: {
        $ref: "#/definitions/Range",
        description: "Determine the colors that should be bound to data value. Default properties are determined considering the field type."
      },
      scale: {
        "enum": [
          "linear",
          "log"
        ],
        type: "string"
      },
      type: {
        description: "Specify the data type",
        "enum": [
          "quantitative",
          "nominal"
        ],
        type: "string"
      }
    },
    type: "object"
  },
  CoverageTransform: {
    additionalProperties: false,
    description: "Aggregate rows and calculate coverage",
    properties: {
      endField: {
        type: "string"
      },
      groupField: {
        description: "The name of a nominal field to group rows by in prior to piling-up",
        type: "string"
      },
      newField: {
        type: "string"
      },
      startField: {
        type: "string"
      },
      type: {
        "const": "coverage",
        type: "string"
      }
    },
    required: [
      "type",
      "startField",
      "endField"
    ],
    type: "object"
  },
  DataDeep: {
    anyOf: [
      {
        $ref: "#/definitions/JSONData"
      },
      {
        $ref: "#/definitions/CSVData"
      },
      {
        $ref: "#/definitions/BIGWIGData"
      },
      {
        $ref: "#/definitions/MultivecData"
      },
      {
        $ref: "#/definitions/BEDDBData"
      },
      {
        $ref: "#/definitions/VectorData"
      },
      {
        $ref: "#/definitions/MatrixData"
      },
      {
        $ref: "#/definitions/BAMData"
      }
    ]
  },
  DataTrack: {
    additionalProperties: false,
    description: "Partial specification of `BasicSingleTrack` to use default visual encoding predefined by data type.",
    properties: {
      _invalidTrack: {
        description: "internal",
        type: "boolean"
      },
      _renderingId: {
        description: "internal",
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      data: {
        $ref: "#/definitions/DataDeep"
      },
      endAngle: {
        description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      height: {
        description: "Specify the track height in pixels.",
        type: "number"
      },
      id: {
        type: "string"
      },
      innerRadius: {
        description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      outerRadius: {
        description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
        type: "number"
      },
      overlayOnPreviousTrack: {
        type: "boolean"
      },
      prerelease: {
        additionalProperties: false,
        description: "internal",
        type: "object"
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      startAngle: {
        description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      title: {
        description: "If defined, will show the textual label on the left-top corner of a track.",
        type: "string"
      },
      width: {
        description: "Specify the track width in pixels.",
        type: "number"
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "data",
      "height",
      "width"
    ],
    type: "object"
  },
  DataTransform: {
    anyOf: [
      {
        $ref: "#/definitions/FilterTransform"
      },
      {
        $ref: "#/definitions/StrConcatTransform"
      },
      {
        $ref: "#/definitions/StrReplaceTransform"
      },
      {
        $ref: "#/definitions/LogTransform"
      },
      {
        $ref: "#/definitions/DisplaceTransform"
      },
      {
        $ref: "#/definitions/ExonSplitTransform"
      },
      {
        $ref: "#/definitions/GenomicLengthTransform"
      },
      {
        $ref: "#/definitions/CoverageTransform"
      },
      {
        $ref: "#/definitions/JSONParseTransform"
      }
    ]
  },
  Datum: {
    additionalProperties: {
      type: [
        "number",
        "string"
      ]
    },
    description: "Values in the form of JSON.",
    type: "object"
  },
  DisplaceTransform: {
    additionalProperties: false,
    properties: {
      boundingBox: {
        additionalProperties: false,
        properties: {
          endField: {
            description: "The name of a quantitative field that represents the end position.",
            type: "string"
          },
          groupField: {
            description: "The name of a nominal field to group rows by in prior to piling-up.",
            type: "string"
          },
          isPaddingBP: {
            description: "Whether to consider `padding` as the bp length.",
            type: "boolean"
          },
          padding: {
            description: "The padding around visual lements. Either px or bp",
            type: "number"
          },
          startField: {
            description: "The name of a quantitative field that represents the start position.",
            type: "string"
          }
        },
        required: [
          "startField",
          "endField"
        ],
        type: "object"
      },
      maxRows: {
        description: "Specify maximum rows to be generated (default has no limit).",
        type: "number"
      },
      method: {
        $ref: "#/definitions/DisplacementType",
        description: "A string that specifies the type of diseplancement."
      },
      newField: {
        type: "string"
      },
      type: {
        "const": "displace",
        type: "string"
      }
    },
    required: [
      "type",
      "boundingBox",
      "method",
      "newField"
    ],
    type: "object"
  },
  Displacement: {
    additionalProperties: false,
    properties: {
      padding: {
        type: "number"
      },
      type: {
        $ref: "#/definitions/DisplacementType"
      }
    },
    required: [
      "type"
    ],
    type: "object"
  },
  DisplacementType: {
    "enum": [
      "pile",
      "spread"
    ],
    type: "string"
  },
  DomainChr: {
    additionalProperties: false,
    properties: {
      chromosome: {
        $ref: "#/definitions/Chromosome"
      }
    },
    required: [
      "chromosome"
    ],
    type: "object"
  },
  DomainChrInterval: {
    additionalProperties: false,
    properties: {
      chromosome: {
        $ref: "#/definitions/Chromosome",
        description: "If specified, only showing a certain interval in a chromosome."
      },
      interval: {
        items: [
          {
            type: "number"
          },
          {
            type: "number"
          }
        ],
        maxItems: 2,
        minItems: 2,
        type: "array"
      }
    },
    required: [
      "chromosome",
      "interval"
    ],
    type: "object"
  },
  DomainGene: {
    additionalProperties: false,
    properties: {
      gene: {
        anyOf: [
          {
            type: "string"
          },
          {
            items: [
              {
                type: "string"
              },
              {
                type: "string"
              }
            ],
            maxItems: 2,
            minItems: 2,
            type: "array"
          }
        ]
      }
    },
    required: [
      "gene"
    ],
    type: "object"
  },
  DomainInterval: {
    additionalProperties: false,
    properties: {
      interval: {
        items: [
          {
            type: "number"
          },
          {
            type: "number"
          }
        ],
        maxItems: 2,
        minItems: 2,
        type: "array"
      }
    },
    required: [
      "interval"
    ],
    type: "object"
  },
  ExonSplitTransform: {
    additionalProperties: false,
    properties: {
      fields: {
        items: {
          additionalProperties: false,
          properties: {
            chrField: {
              type: "string"
            },
            field: {
              type: "string"
            },
            newField: {
              type: "string"
            },
            type: {
              $ref: "#/definitions/FieldType"
            }
          },
          required: [
            "field",
            "type",
            "newField",
            "chrField"
          ],
          type: "object"
        },
        type: "array"
      },
      flag: {
        additionalProperties: false,
        properties: {
          field: {
            type: "string"
          },
          value: {
            type: [
              "number",
              "string"
            ]
          }
        },
        required: [
          "field",
          "value"
        ],
        type: "object"
      },
      separator: {
        type: "string"
      },
      type: {
        "const": "exonSplit",
        type: "string"
      }
    },
    required: [
      "type",
      "separator",
      "flag",
      "fields"
    ],
    type: "object"
  },
  FieldType: {
    "enum": [
      "genomic",
      "nominal",
      "quantitative"
    ],
    type: "string"
  },
  FilterTransform: {
    anyOf: [
      {
        $ref: "#/definitions/OneOfFilter"
      },
      {
        $ref: "#/definitions/RangeFilter"
      },
      {
        $ref: "#/definitions/IncludeFilter"
      }
    ]
  },
  FlatTracks: {
    additionalProperties: false,
    properties: {
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      tracks: {
        items: {
          $ref: "#/definitions/Track"
        },
        type: "array"
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "tracks"
    ],
    type: "object"
  },
  GenomicDomain: {
    anyOf: [
      {
        $ref: "#/definitions/DomainInterval"
      },
      {
        $ref: "#/definitions/DomainChrInterval"
      },
      {
        $ref: "#/definitions/DomainChr"
      },
      {
        $ref: "#/definitions/DomainGene"
      }
    ]
  },
  GenomicLengthTransform: {
    additionalProperties: false,
    description: "Calculate genomic length using two genomic fields",
    properties: {
      endField: {
        type: "string"
      },
      newField: {
        type: "string"
      },
      startField: {
        type: "string"
      },
      type: {
        "const": "genomicLength",
        type: "string"
      }
    },
    required: [
      "type",
      "startField",
      "endField",
      "newField"
    ],
    type: "object"
  },
  GoslingSpec: {
    anyOf: [
      {
        $ref: "#/definitions/RootSpecWithSingleView"
      },
      {
        $ref: "#/definitions/RootSpecWithMultipleViews"
      }
    ]
  },
  IncludeFilter: {
    additionalProperties: false,
    properties: {
      field: {
        description: "A filter is applied based on the values of the specified data field",
        type: "string"
      },
      include: {
        description: "Check whether the value includes a substring.",
        type: "string"
      },
      not: {
        description: 'when `{"not": true}`, apply a NOT logical operation to the filter.\n\n__Default:__ `false`',
        type: "boolean"
      },
      type: {
        "const": "filter",
        type: "string"
      }
    },
    required: [
      "field",
      "include",
      "type"
    ],
    type: "object"
  },
  JSONData: {
    additionalProperties: false,
    description: "The JSON data format allows users to include data directly in the Gosling's JSON specification.",
    properties: {
      chromosomeField: {
        description: "Specify the name of chromosome data fields.",
        type: "string"
      },
      genomicFields: {
        description: "Specify the name of genomic data fields.",
        items: {
          type: "string"
        },
        type: "array"
      },
      genomicFieldsToConvert: {
        description: "experimental",
        items: {
          additionalProperties: false,
          properties: {
            chromosomeField: {
              type: "string"
            },
            genomicFields: {
              items: {
                type: "string"
              },
              type: "array"
            }
          },
          required: [
            "chromosomeField",
            "genomicFields"
          ],
          type: "object"
        },
        type: "array"
      },
      sampleLength: {
        description: "Specify the number of rows loaded from the URL.\n\n__Default:__ `1000`",
        type: "number"
      },
      type: {
        "const": "json",
        description: "Define data type.",
        type: "string"
      },
      values: {
        description: "Values in the form of JSON.",
        items: {
          $ref: "#/definitions/Datum"
        },
        type: "array"
      }
    },
    required: [
      "type",
      "values"
    ],
    type: "object"
  },
  JSONParseTransform: {
    additionalProperties: false,
    description: "Parse JSON Object Array and append vertically",
    properties: {
      baseGenomicField: {
        description: "Base genomic position when parsing relative position.",
        type: "string"
      },
      field: {
        description: "The field that contains the JSON object array.",
        type: "string"
      },
      genomicField: {
        description: "Relative genomic position to parse.",
        type: "string"
      },
      genomicLengthField: {
        description: "Length of genomic interval.",
        type: "string"
      },
      type: {
        "const": "subjson",
        type: "string"
      }
    },
    required: [
      "type",
      "field",
      "baseGenomicField",
      "genomicField",
      "genomicLengthField"
    ],
    type: "object"
  },
  Layout: {
    "enum": [
      "linear",
      "circular"
    ],
    type: "string"
  },
  LogBase: {
    anyOf: [
      {
        type: "number"
      },
      {
        "const": "e",
        type: "string"
      }
    ]
  },
  LogTransform: {
    additionalProperties: false,
    properties: {
      base: {
        $ref: "#/definitions/LogBase",
        description: "If not specified, 10 is used."
      },
      field: {
        type: "string"
      },
      newField: {
        description: "If specified, store transformed values in a new field.",
        type: "string"
      },
      type: {
        "const": "log",
        type: "string"
      }
    },
    required: [
      "type",
      "field"
    ],
    type: "object"
  },
  LogicalOperation: {
    "enum": [
      "less-than",
      "lt",
      "LT",
      "greater-than",
      "gt",
      "GT",
      "less-than-or-equal-to",
      "ltet",
      "LTET",
      "greater-than-or-equal-to",
      "gtet",
      "GTET"
    ],
    type: "string"
  },
  Mark: {
    "enum": [
      "point",
      "line",
      "area",
      "bar",
      "rect",
      "text",
      "withinLink",
      "betweenLink",
      "rule",
      "triangleLeft",
      "triangleRight",
      "triangleBottom",
      "brush",
      "header"
    ],
    type: "string"
  },
  MatrixData: {
    additionalProperties: false,
    properties: {
      binSize: {
        description: "Determine the number of nearby cells to aggregate. __Default__: `1`",
        type: "number"
      },
      column: {
        description: "The name of the first genomic field. __Default__: `x`",
        type: "string"
      },
      row: {
        description: "The name of the first genomic field. __Default__: `y`",
        type: "string"
      },
      type: {
        "const": "matrix",
        type: "string"
      },
      url: {
        description: "URL link to the matrix data file",
        type: "string"
      },
      value: {
        description: "The name of the value field. __Default__: `value`",
        type: "string"
      }
    },
    required: [
      "type",
      "url"
    ],
    type: "object"
  },
  MultipleViews: {
    additionalProperties: false,
    properties: {
      arrangement: {
        description: "Specify how multiple views are arranged.",
        "enum": [
          "parallel",
          "serial",
          "horizontal",
          "vertical"
        ],
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      views: {
        description: "An array of view specifications",
        items: {
          anyOf: [
            {
              $ref: "#/definitions/SingleView"
            },
            {
              $ref: "#/definitions/MultipleViews"
            }
          ]
        },
        type: "array"
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "views"
    ],
    type: "object"
  },
  MultivecData: {
    additionalProperties: false,
    description: 'Two-dimensional quantitative values, one axis for genomic coordinate and the other for different samples, can be converted into HiGlass\' `"multivec"` data. For example, multiple BigWig files can be converted into a single multivec file. You can also convert sequence data (FASTA) into this format where rows will be different nucleotide bases (e.g., A, T, G, C) and quantitative values represent the frequency. Find out more about this format at [HiGlass Docs](https://docs.higlass.io/data_preparation.html#multivec-files).',
    properties: {
      aggregation: {
        $ref: "#/definitions/BinAggregate",
        description: 'Determine aggregation function to apply within bins. __Default__: `"mean"`'
      },
      binSize: {
        description: "Binning the genomic interval in tiles (unit size: 256).",
        type: "number"
      },
      categories: {
        description: "assign names of individual samples.",
        items: {
          type: "string"
        },
        type: "array"
      },
      column: {
        description: "Assign a field name of the middle position of genomic intervals.",
        type: "string"
      },
      end: {
        description: "Assign a field name of the end position of genomic intervals.",
        type: "string"
      },
      row: {
        description: "Assign a field name of samples.",
        type: "string"
      },
      start: {
        description: "Assign a field name of the start position of genomic intervals.",
        type: "string"
      },
      type: {
        "const": "multivec",
        type: "string"
      },
      url: {
        description: "Specify the URL address of the data file.",
        type: "string"
      },
      value: {
        description: "Assign a field name of quantitative values.",
        type: "string"
      }
    },
    required: [
      "type",
      "url",
      "column",
      "row",
      "value"
    ],
    type: "object"
  },
  OneOfFilter: {
    additionalProperties: false,
    properties: {
      field: {
        description: "A filter is applied based on the values of the specified data field",
        type: "string"
      },
      not: {
        description: 'when `{"not": true}`, apply a NOT logical operation to the filter.\n\n__Default:__ `false`',
        type: "boolean"
      },
      oneOf: {
        anyOf: [
          {
            items: {
              type: "string"
            },
            type: "array"
          },
          {
            items: {
              type: "number"
            },
            type: "array"
          }
        ],
        description: "Check whether the value is an element in the provided list."
      },
      type: {
        "const": "filter",
        type: "string"
      }
    },
    required: [
      "field",
      "oneOf",
      "type"
    ],
    type: "object"
  },
  Opacity: {
    additionalProperties: false,
    properties: {
      domain: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field",
        type: "string"
      },
      range: {
        $ref: "#/definitions/ValueExtent",
        description: "Ranges of visual channel values"
      },
      type: {
        description: "Specify the data type",
        "enum": [
          "quantitative",
          "nominal"
        ],
        type: "string"
      }
    },
    type: "object"
  },
  Orientation: {
    "enum": [
      "horizontal",
      "vertical"
    ],
    type: "string"
  },
  OverlaidTrack: {
    additionalProperties: false,
    description: "Superposing multiple tracks.",
    properties: {
      _invalidTrack: {
        description: "internal",
        type: "boolean"
      },
      _renderingId: {
        description: "internal",
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      color: {
        anyOf: [
          {
            $ref: "#/definitions/Color"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      data: {
        $ref: "#/definitions/DataDeep"
      },
      dataTransform: {
        items: {
          $ref: "#/definitions/DataTransform"
        },
        type: "array"
      },
      displacement: {
        $ref: "#/definitions/Displacement"
      },
      endAngle: {
        description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      flipY: {
        type: "boolean"
      },
      height: {
        description: "Specify the track height in pixels.",
        type: "number"
      },
      id: {
        type: "string"
      },
      innerRadius: {
        description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      mark: {
        $ref: "#/definitions/Mark"
      },
      opacity: {
        anyOf: [
          {
            $ref: "#/definitions/Opacity"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      outerRadius: {
        description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
        type: "number"
      },
      overlay: {
        items: {
          additionalProperties: false,
          properties: {
            _invalidTrack: {
              description: "internal",
              type: "boolean"
            },
            _renderingId: {
              description: "internal",
              type: "string"
            },
            assembly: {
              $ref: "#/definitions/Assembly",
              description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
            },
            centerRadius: {
              description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
              type: "number"
            },
            color: {
              anyOf: [
                {
                  $ref: "#/definitions/Color"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            data: {
              $ref: "#/definitions/DataDeep"
            },
            dataTransform: {
              items: {
                $ref: "#/definitions/DataTransform"
              },
              type: "array"
            },
            displacement: {
              $ref: "#/definitions/Displacement"
            },
            endAngle: {
              description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
              type: "number"
            },
            flipY: {
              type: "boolean"
            },
            id: {
              type: "string"
            },
            innerRadius: {
              description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
              type: "number"
            },
            linkingId: {
              description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
              type: "string"
            },
            mark: {
              $ref: "#/definitions/Mark"
            },
            opacity: {
              anyOf: [
                {
                  $ref: "#/definitions/Opacity"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            orientation: {
              $ref: "#/definitions/Orientation",
              description: "Specify the orientation."
            },
            outerRadius: {
              description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
              type: "number"
            },
            overlayOnPreviousTrack: {
              type: "boolean"
            },
            overrideTemplate: {
              type: "boolean"
            },
            prerelease: {
              additionalProperties: false,
              description: "internal",
              type: "object"
            },
            row: {
              anyOf: [
                {
                  $ref: "#/definitions/Row"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            size: {
              anyOf: [
                {
                  $ref: "#/definitions/Size"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            spacing: {
              description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
              type: "number"
            },
            startAngle: {
              description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
              type: "number"
            },
            "static": {
              description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
              type: "boolean"
            },
            stretch: {
              type: "boolean"
            },
            stroke: {
              anyOf: [
                {
                  $ref: "#/definitions/Stroke"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            strokeWidth: {
              anyOf: [
                {
                  $ref: "#/definitions/StrokeWidth"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            style: {
              $ref: "#/definitions/Style",
              description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
            },
            text: {
              anyOf: [
                {
                  $ref: "#/definitions/Text"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            tooltip: {
              items: {
                $ref: "#/definitions/Tooltip"
              },
              type: "array"
            },
            visibility: {
              items: {
                $ref: "#/definitions/VisibilityCondition"
              },
              type: "array"
            },
            x: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            x1: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            x1e: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            xAxis: {
              $ref: "#/definitions/AxisPosition",
              description: "not supported"
            },
            xDomain: {
              anyOf: [
                {
                  $ref: "#/definitions/DomainInterval"
                },
                {
                  $ref: "#/definitions/DomainChrInterval"
                },
                {
                  $ref: "#/definitions/DomainChr"
                }
              ],
              description: "Specify the visible region of genomic x-axis"
            },
            xOffset: {
              description: "Specify the x offset of views in the unit of pixels",
              type: "number"
            },
            xe: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            y: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            y1: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            y1e: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            yDomain: {
              anyOf: [
                {
                  $ref: "#/definitions/DomainInterval"
                },
                {
                  $ref: "#/definitions/DomainChrInterval"
                },
                {
                  $ref: "#/definitions/DomainChr"
                }
              ],
              description: "Specify the visible region of genomic y-axis"
            },
            yOffset: {
              description: "Specify the y offset of views in the unit of pixels",
              type: "number"
            },
            ye: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            zoomLimits: {
              $ref: "#/definitions/ZoomLimits"
            }
          },
          type: "object"
        },
        type: "array"
      },
      overlayOnPreviousTrack: {
        type: "boolean"
      },
      overrideTemplate: {
        type: "boolean"
      },
      prerelease: {
        additionalProperties: false,
        description: "internal",
        type: "object"
      },
      row: {
        anyOf: [
          {
            $ref: "#/definitions/Row"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      size: {
        anyOf: [
          {
            $ref: "#/definitions/Size"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      startAngle: {
        description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      stretch: {
        type: "boolean"
      },
      stroke: {
        anyOf: [
          {
            $ref: "#/definitions/Stroke"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      strokeWidth: {
        anyOf: [
          {
            $ref: "#/definitions/StrokeWidth"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      text: {
        anyOf: [
          {
            $ref: "#/definitions/Text"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      title: {
        description: "If defined, will show the textual label on the left-top corner of a track.",
        type: "string"
      },
      tooltip: {
        items: {
          $ref: "#/definitions/Tooltip"
        },
        type: "array"
      },
      visibility: {
        items: {
          $ref: "#/definitions/VisibilityCondition"
        },
        type: "array"
      },
      width: {
        description: "Specify the track width in pixels.",
        type: "number"
      },
      x: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1e: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      xe: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1e: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      ye: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "height",
      "overlay",
      "width"
    ],
    type: "object"
  },
  OverlaidTracks: {
    additionalProperties: false,
    properties: {
      _invalidTrack: {
        description: "internal",
        type: "boolean"
      },
      _renderingId: {
        description: "internal",
        type: "string"
      },
      alignment: {
        "const": "overlay",
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      color: {
        anyOf: [
          {
            $ref: "#/definitions/Color"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      data: {
        $ref: "#/definitions/DataDeep"
      },
      dataTransform: {
        items: {
          $ref: "#/definitions/DataTransform"
        },
        type: "array"
      },
      displacement: {
        $ref: "#/definitions/Displacement"
      },
      endAngle: {
        description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      flipY: {
        type: "boolean"
      },
      height: {
        description: "Specify the track height in pixels.",
        type: "number"
      },
      id: {
        type: "string"
      },
      innerRadius: {
        description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      mark: {
        $ref: "#/definitions/Mark"
      },
      opacity: {
        anyOf: [
          {
            $ref: "#/definitions/Opacity"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      outerRadius: {
        description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
        type: "number"
      },
      overlayOnPreviousTrack: {
        type: "boolean"
      },
      overrideTemplate: {
        type: "boolean"
      },
      prerelease: {
        additionalProperties: false,
        description: "internal",
        type: "object"
      },
      row: {
        anyOf: [
          {
            $ref: "#/definitions/Row"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      size: {
        anyOf: [
          {
            $ref: "#/definitions/Size"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      startAngle: {
        description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      stretch: {
        type: "boolean"
      },
      stroke: {
        anyOf: [
          {
            $ref: "#/definitions/Stroke"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      strokeWidth: {
        anyOf: [
          {
            $ref: "#/definitions/StrokeWidth"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      text: {
        anyOf: [
          {
            $ref: "#/definitions/Text"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      title: {
        description: "If defined, will show the textual label on the left-top corner of a track.",
        type: "string"
      },
      tooltip: {
        items: {
          $ref: "#/definitions/Tooltip"
        },
        type: "array"
      },
      tracks: {
        items: {
          $ref: "#/definitions/PartialTrack"
        },
        type: "array"
      },
      visibility: {
        items: {
          $ref: "#/definitions/VisibilityCondition"
        },
        type: "array"
      },
      width: {
        description: "Specify the track width in pixels.",
        type: "number"
      },
      x: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1e: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      xe: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1e: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      ye: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "alignment",
      "tracks",
      "width",
      "height"
    ],
    type: "object"
  },
  PREDEFINED_COLORS: {
    "enum": [
      "viridis",
      "grey",
      "spectral",
      "warm",
      "cividis",
      "bupu",
      "rdbu",
      "hot",
      "pink"
    ],
    type: "string"
  },
  PartialTrack: {
    additionalProperties: false,
    properties: {
      _invalidTrack: {
        description: "internal",
        type: "boolean"
      },
      _renderingId: {
        description: "internal",
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      color: {
        anyOf: [
          {
            $ref: "#/definitions/Color"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      data: {
        $ref: "#/definitions/DataDeep"
      },
      dataTransform: {
        items: {
          $ref: "#/definitions/DataTransform"
        },
        type: "array"
      },
      displacement: {
        $ref: "#/definitions/Displacement"
      },
      encoding: {
        additionalProperties: {
          $ref: "#/definitions/Channel"
        },
        type: "object"
      },
      endAngle: {
        description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      flipY: {
        type: "boolean"
      },
      height: {
        description: "Specify the track height in pixels.",
        type: "number"
      },
      id: {
        type: "string"
      },
      innerRadius: {
        description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      mark: {
        $ref: "#/definitions/Mark"
      },
      opacity: {
        anyOf: [
          {
            $ref: "#/definitions/Opacity"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      outerRadius: {
        description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
        type: "number"
      },
      overlay: {
        items: {
          additionalProperties: false,
          properties: {
            _invalidTrack: {
              description: "internal",
              type: "boolean"
            },
            _renderingId: {
              description: "internal",
              type: "string"
            },
            assembly: {
              $ref: "#/definitions/Assembly",
              description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
            },
            centerRadius: {
              description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
              type: "number"
            },
            color: {
              anyOf: [
                {
                  $ref: "#/definitions/Color"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            data: {
              $ref: "#/definitions/DataDeep"
            },
            dataTransform: {
              items: {
                $ref: "#/definitions/DataTransform"
              },
              type: "array"
            },
            displacement: {
              $ref: "#/definitions/Displacement"
            },
            endAngle: {
              description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
              type: "number"
            },
            flipY: {
              type: "boolean"
            },
            id: {
              type: "string"
            },
            innerRadius: {
              description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
              type: "number"
            },
            linkingId: {
              description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
              type: "string"
            },
            mark: {
              $ref: "#/definitions/Mark"
            },
            opacity: {
              anyOf: [
                {
                  $ref: "#/definitions/Opacity"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            orientation: {
              $ref: "#/definitions/Orientation",
              description: "Specify the orientation."
            },
            outerRadius: {
              description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
              type: "number"
            },
            overlayOnPreviousTrack: {
              type: "boolean"
            },
            overrideTemplate: {
              type: "boolean"
            },
            prerelease: {
              additionalProperties: false,
              description: "internal",
              type: "object"
            },
            row: {
              anyOf: [
                {
                  $ref: "#/definitions/Row"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            size: {
              anyOf: [
                {
                  $ref: "#/definitions/Size"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            spacing: {
              description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
              type: "number"
            },
            startAngle: {
              description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
              type: "number"
            },
            "static": {
              description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
              type: "boolean"
            },
            stretch: {
              type: "boolean"
            },
            stroke: {
              anyOf: [
                {
                  $ref: "#/definitions/Stroke"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            strokeWidth: {
              anyOf: [
                {
                  $ref: "#/definitions/StrokeWidth"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            style: {
              $ref: "#/definitions/Style",
              description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
            },
            text: {
              anyOf: [
                {
                  $ref: "#/definitions/Text"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            tooltip: {
              items: {
                $ref: "#/definitions/Tooltip"
              },
              type: "array"
            },
            visibility: {
              items: {
                $ref: "#/definitions/VisibilityCondition"
              },
              type: "array"
            },
            x: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            x1: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            x1e: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            xAxis: {
              $ref: "#/definitions/AxisPosition",
              description: "not supported"
            },
            xDomain: {
              anyOf: [
                {
                  $ref: "#/definitions/DomainInterval"
                },
                {
                  $ref: "#/definitions/DomainChrInterval"
                },
                {
                  $ref: "#/definitions/DomainChr"
                }
              ],
              description: "Specify the visible region of genomic x-axis"
            },
            xOffset: {
              description: "Specify the x offset of views in the unit of pixels",
              type: "number"
            },
            xe: {
              anyOf: [
                {
                  $ref: "#/definitions/X"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            y: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            y1: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            y1e: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            yDomain: {
              anyOf: [
                {
                  $ref: "#/definitions/DomainInterval"
                },
                {
                  $ref: "#/definitions/DomainChrInterval"
                },
                {
                  $ref: "#/definitions/DomainChr"
                }
              ],
              description: "Specify the visible region of genomic y-axis"
            },
            yOffset: {
              description: "Specify the y offset of views in the unit of pixels",
              type: "number"
            },
            ye: {
              anyOf: [
                {
                  $ref: "#/definitions/Y"
                },
                {
                  $ref: "#/definitions/ChannelValue"
                }
              ]
            },
            zoomLimits: {
              $ref: "#/definitions/ZoomLimits"
            }
          },
          type: "object"
        },
        type: "array"
      },
      overlayOnPreviousTrack: {
        type: "boolean"
      },
      overrideTemplate: {
        type: "boolean"
      },
      prerelease: {
        additionalProperties: false,
        description: "internal",
        type: "object"
      },
      row: {
        anyOf: [
          {
            $ref: "#/definitions/Row"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      size: {
        anyOf: [
          {
            $ref: "#/definitions/Size"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      startAngle: {
        description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      stretch: {
        type: "boolean"
      },
      stroke: {
        anyOf: [
          {
            $ref: "#/definitions/Stroke"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      strokeWidth: {
        anyOf: [
          {
            $ref: "#/definitions/StrokeWidth"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      template: {
        type: "string"
      },
      text: {
        anyOf: [
          {
            $ref: "#/definitions/Text"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      title: {
        description: "If defined, will show the textual label on the left-top corner of a track.",
        type: "string"
      },
      tooltip: {
        items: {
          $ref: "#/definitions/Tooltip"
        },
        type: "array"
      },
      visibility: {
        items: {
          $ref: "#/definitions/VisibilityCondition"
        },
        type: "array"
      },
      width: {
        description: "Specify the track width in pixels.",
        type: "number"
      },
      x: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1e: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      xe: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1e: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      ye: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    type: "object"
  },
  Range: {
    anyOf: [
      {
        $ref: "#/definitions/ValueExtent"
      },
      {
        $ref: "#/definitions/PREDEFINED_COLORS"
      }
    ]
  },
  RangeFilter: {
    additionalProperties: false,
    properties: {
      field: {
        description: "A filter is applied based on the values of the specified data field",
        type: "string"
      },
      inRange: {
        description: "Check whether the value is in a number range.",
        items: {
          type: "number"
        },
        type: "array"
      },
      not: {
        description: 'when `{"not": true}`, apply a NOT logical operation to the filter.\n\n__Default:__ `false`',
        type: "boolean"
      },
      type: {
        "const": "filter",
        type: "string"
      }
    },
    required: [
      "field",
      "inRange",
      "type"
    ],
    type: "object"
  },
  ResponsiveSize: {
    anyOf: [
      {
        type: "boolean"
      },
      {
        additionalProperties: false,
        properties: {
          height: {
            type: "boolean"
          },
          width: {
            type: "boolean"
          }
        },
        type: "object"
      }
    ]
  },
  RootSpecWithMultipleViews: {
    additionalProperties: false,
    properties: {
      arrangement: {
        description: "Specify how multiple views are arranged.",
        "enum": [
          "parallel",
          "serial",
          "horizontal",
          "vertical"
        ],
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      description: {
        type: "string"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      responsiveSize: {
        $ref: "#/definitions/ResponsiveSize",
        description: "Determine whether to make the size of `GoslingComponent` bound to its parent element. __Default__: `false`"
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      title: {
        type: "string"
      },
      views: {
        description: "An array of view specifications",
        items: {
          anyOf: [
            {
              $ref: "#/definitions/SingleView"
            },
            {
              $ref: "#/definitions/MultipleViews"
            }
          ]
        },
        type: "array"
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "views"
    ],
    type: "object"
  },
  RootSpecWithSingleView: {
    anyOf: [
      {
        additionalProperties: false,
        properties: {
          _invalidTrack: {
            description: "internal",
            type: "boolean"
          },
          _renderingId: {
            description: "internal",
            type: "string"
          },
          alignment: {
            "const": "overlay",
            type: "string"
          },
          assembly: {
            $ref: "#/definitions/Assembly",
            description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
          },
          centerRadius: {
            description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
            type: "number"
          },
          color: {
            anyOf: [
              {
                $ref: "#/definitions/Color"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          data: {
            $ref: "#/definitions/DataDeep"
          },
          dataTransform: {
            items: {
              $ref: "#/definitions/DataTransform"
            },
            type: "array"
          },
          description: {
            type: "string"
          },
          displacement: {
            $ref: "#/definitions/Displacement"
          },
          endAngle: {
            description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
            type: "number"
          },
          flipY: {
            type: "boolean"
          },
          height: {
            description: "Specify the track height in pixels.",
            type: "number"
          },
          id: {
            type: "string"
          },
          innerRadius: {
            description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
            type: "number"
          },
          layout: {
            $ref: "#/definitions/Layout",
            description: "Specify the layout type of all tracks."
          },
          linkingId: {
            description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
            type: "string"
          },
          mark: {
            $ref: "#/definitions/Mark"
          },
          opacity: {
            anyOf: [
              {
                $ref: "#/definitions/Opacity"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          orientation: {
            $ref: "#/definitions/Orientation",
            description: "Specify the orientation."
          },
          outerRadius: {
            description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
            type: "number"
          },
          overlayOnPreviousTrack: {
            type: "boolean"
          },
          overrideTemplate: {
            type: "boolean"
          },
          prerelease: {
            additionalProperties: false,
            description: "internal",
            type: "object"
          },
          responsiveSize: {
            $ref: "#/definitions/ResponsiveSize",
            description: "Determine whether to make the size of `GoslingComponent` bound to its parent element. __Default__: `false`"
          },
          row: {
            anyOf: [
              {
                $ref: "#/definitions/Row"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          size: {
            anyOf: [
              {
                $ref: "#/definitions/Size"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          spacing: {
            description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
            type: "number"
          },
          startAngle: {
            description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
            type: "number"
          },
          "static": {
            description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
            type: "boolean"
          },
          stretch: {
            type: "boolean"
          },
          stroke: {
            anyOf: [
              {
                $ref: "#/definitions/Stroke"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          strokeWidth: {
            anyOf: [
              {
                $ref: "#/definitions/StrokeWidth"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          style: {
            $ref: "#/definitions/Style",
            description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
          },
          subtitle: {
            type: "string"
          },
          text: {
            anyOf: [
              {
                $ref: "#/definitions/Text"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          title: {
            description: "If defined, will show the textual label on the left-top corner of a track.",
            type: "string"
          },
          tooltip: {
            items: {
              $ref: "#/definitions/Tooltip"
            },
            type: "array"
          },
          tracks: {
            items: {
              $ref: "#/definitions/PartialTrack"
            },
            type: "array"
          },
          visibility: {
            items: {
              $ref: "#/definitions/VisibilityCondition"
            },
            type: "array"
          },
          width: {
            description: "Specify the track width in pixels.",
            type: "number"
          },
          x: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          x1: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          x1e: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          xAxis: {
            $ref: "#/definitions/AxisPosition",
            description: "not supported"
          },
          xDomain: {
            anyOf: [
              {
                $ref: "#/definitions/DomainInterval"
              },
              {
                $ref: "#/definitions/DomainChrInterval"
              },
              {
                $ref: "#/definitions/DomainChr"
              }
            ],
            description: "Specify the visible region of genomic x-axis"
          },
          xOffset: {
            description: "Specify the x offset of views in the unit of pixels",
            type: "number"
          },
          xe: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          y: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          y1: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          y1e: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          yDomain: {
            anyOf: [
              {
                $ref: "#/definitions/DomainInterval"
              },
              {
                $ref: "#/definitions/DomainChrInterval"
              },
              {
                $ref: "#/definitions/DomainChr"
              }
            ],
            description: "Specify the visible region of genomic y-axis"
          },
          yOffset: {
            description: "Specify the y offset of views in the unit of pixels",
            type: "number"
          },
          ye: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          zoomLimits: {
            $ref: "#/definitions/ZoomLimits"
          }
        },
        required: [
          "alignment",
          "height",
          "tracks",
          "width"
        ],
        type: "object"
      },
      {
        additionalProperties: false,
        properties: {
          _invalidTrack: {
            description: "internal",
            type: "boolean"
          },
          _renderingId: {
            description: "internal",
            type: "string"
          },
          alignment: {
            "const": "stack",
            type: "string"
          },
          assembly: {
            $ref: "#/definitions/Assembly",
            description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
          },
          centerRadius: {
            description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
            type: "number"
          },
          color: {
            anyOf: [
              {
                $ref: "#/definitions/Color"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          data: {
            $ref: "#/definitions/DataDeep"
          },
          dataTransform: {
            items: {
              $ref: "#/definitions/DataTransform"
            },
            type: "array"
          },
          description: {
            type: "string"
          },
          displacement: {
            $ref: "#/definitions/Displacement"
          },
          endAngle: {
            description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
            type: "number"
          },
          flipY: {
            type: "boolean"
          },
          height: {
            description: "Specify the track height in pixels.",
            type: "number"
          },
          id: {
            type: "string"
          },
          innerRadius: {
            description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
            type: "number"
          },
          layout: {
            $ref: "#/definitions/Layout",
            description: "Specify the layout type of all tracks."
          },
          linkingId: {
            description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
            type: "string"
          },
          mark: {
            $ref: "#/definitions/Mark"
          },
          opacity: {
            anyOf: [
              {
                $ref: "#/definitions/Opacity"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          orientation: {
            $ref: "#/definitions/Orientation",
            description: "Specify the orientation."
          },
          outerRadius: {
            description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
            type: "number"
          },
          overlayOnPreviousTrack: {
            type: "boolean"
          },
          overrideTemplate: {
            type: "boolean"
          },
          prerelease: {
            additionalProperties: false,
            description: "internal",
            type: "object"
          },
          responsiveSize: {
            $ref: "#/definitions/ResponsiveSize",
            description: "Determine whether to make the size of `GoslingComponent` bound to its parent element. __Default__: `false`"
          },
          row: {
            anyOf: [
              {
                $ref: "#/definitions/Row"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          size: {
            anyOf: [
              {
                $ref: "#/definitions/Size"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          spacing: {
            description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
            type: "number"
          },
          startAngle: {
            description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
            type: "number"
          },
          "static": {
            description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
            type: "boolean"
          },
          stretch: {
            type: "boolean"
          },
          stroke: {
            anyOf: [
              {
                $ref: "#/definitions/Stroke"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          strokeWidth: {
            anyOf: [
              {
                $ref: "#/definitions/StrokeWidth"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          style: {
            $ref: "#/definitions/Style",
            description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
          },
          subtitle: {
            type: "string"
          },
          text: {
            anyOf: [
              {
                $ref: "#/definitions/Text"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          title: {
            description: "If defined, will show the textual label on the left-top corner of a track.",
            type: "string"
          },
          tooltip: {
            items: {
              $ref: "#/definitions/Tooltip"
            },
            type: "array"
          },
          tracks: {
            items: {
              anyOf: [
                {
                  $ref: "#/definitions/PartialTrack"
                },
                {
                  $ref: "#/definitions/OverlaidTracks"
                }
              ]
            },
            type: "array"
          },
          visibility: {
            items: {
              $ref: "#/definitions/VisibilityCondition"
            },
            type: "array"
          },
          width: {
            description: "Specify the track width in pixels.",
            type: "number"
          },
          x: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          x1: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          x1e: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          xAxis: {
            $ref: "#/definitions/AxisPosition",
            description: "not supported"
          },
          xDomain: {
            anyOf: [
              {
                $ref: "#/definitions/DomainInterval"
              },
              {
                $ref: "#/definitions/DomainChrInterval"
              },
              {
                $ref: "#/definitions/DomainChr"
              }
            ],
            description: "Specify the visible region of genomic x-axis"
          },
          xOffset: {
            description: "Specify the x offset of views in the unit of pixels",
            type: "number"
          },
          xe: {
            anyOf: [
              {
                $ref: "#/definitions/X"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          y: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          y1: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          y1e: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          yDomain: {
            anyOf: [
              {
                $ref: "#/definitions/DomainInterval"
              },
              {
                $ref: "#/definitions/DomainChrInterval"
              },
              {
                $ref: "#/definitions/DomainChr"
              }
            ],
            description: "Specify the visible region of genomic y-axis"
          },
          yOffset: {
            description: "Specify the y offset of views in the unit of pixels",
            type: "number"
          },
          ye: {
            anyOf: [
              {
                $ref: "#/definitions/Y"
              },
              {
                $ref: "#/definitions/ChannelValue"
              }
            ]
          },
          zoomLimits: {
            $ref: "#/definitions/ZoomLimits"
          }
        },
        required: [
          "tracks"
        ],
        type: "object"
      },
      {
        additionalProperties: false,
        properties: {
          assembly: {
            $ref: "#/definitions/Assembly",
            description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
          },
          centerRadius: {
            description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
            type: "number"
          },
          description: {
            type: "string"
          },
          layout: {
            $ref: "#/definitions/Layout",
            description: "Specify the layout type of all tracks."
          },
          linkingId: {
            description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
            type: "string"
          },
          orientation: {
            $ref: "#/definitions/Orientation",
            description: "Specify the orientation."
          },
          responsiveSize: {
            $ref: "#/definitions/ResponsiveSize",
            description: "Determine whether to make the size of `GoslingComponent` bound to its parent element. __Default__: `false`"
          },
          spacing: {
            description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
            type: "number"
          },
          "static": {
            description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
            type: "boolean"
          },
          style: {
            $ref: "#/definitions/Style",
            description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
          },
          subtitle: {
            type: "string"
          },
          title: {
            type: "string"
          },
          tracks: {
            items: {
              $ref: "#/definitions/Track"
            },
            type: "array"
          },
          xAxis: {
            $ref: "#/definitions/AxisPosition",
            description: "not supported"
          },
          xDomain: {
            anyOf: [
              {
                $ref: "#/definitions/DomainInterval"
              },
              {
                $ref: "#/definitions/DomainChrInterval"
              },
              {
                $ref: "#/definitions/DomainChr"
              }
            ],
            description: "Specify the visible region of genomic x-axis"
          },
          xOffset: {
            description: "Specify the x offset of views in the unit of pixels",
            type: "number"
          },
          yDomain: {
            anyOf: [
              {
                $ref: "#/definitions/DomainInterval"
              },
              {
                $ref: "#/definitions/DomainChrInterval"
              },
              {
                $ref: "#/definitions/DomainChr"
              }
            ],
            description: "Specify the visible region of genomic y-axis"
          },
          yOffset: {
            description: "Specify the y offset of views in the unit of pixels",
            type: "number"
          },
          zoomLimits: {
            $ref: "#/definitions/ZoomLimits"
          }
        },
        required: [
          "tracks"
        ],
        type: "object"
      }
    ]
  },
  Row: {
    additionalProperties: false,
    properties: {
      domain: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field",
        type: "string"
      },
      grid: {
        description: "Whether to display grid. __Default__: `false`",
        type: "boolean"
      },
      legend: {
        description: "Whether to display legend. __Default__: `false`",
        type: "boolean"
      },
      padding: {
        description: "Determines the size of inner white spaces on the top and bottom of individiual rows. __Default__: `0`",
        type: "number"
      },
      range: {
        $ref: "#/definitions/ValueExtent",
        description: "Determine the start and end position of rendering area of this track along vertical axis. __Default__: `[0, height]`"
      },
      type: {
        "const": "nominal",
        description: "Specify the data type",
        type: "string"
      }
    },
    type: "object"
  },
  SingleTrack: {
    additionalProperties: false,
    properties: {
      _invalidTrack: {
        description: "internal",
        type: "boolean"
      },
      _renderingId: {
        description: "internal",
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      color: {
        anyOf: [
          {
            $ref: "#/definitions/Color"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      data: {
        $ref: "#/definitions/DataDeep"
      },
      dataTransform: {
        items: {
          $ref: "#/definitions/DataTransform"
        },
        type: "array"
      },
      displacement: {
        $ref: "#/definitions/Displacement"
      },
      endAngle: {
        description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      flipY: {
        type: "boolean"
      },
      height: {
        description: "Specify the track height in pixels.",
        type: "number"
      },
      id: {
        type: "string"
      },
      innerRadius: {
        description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      mark: {
        $ref: "#/definitions/Mark"
      },
      opacity: {
        anyOf: [
          {
            $ref: "#/definitions/Opacity"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      outerRadius: {
        description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
        type: "number"
      },
      overlayOnPreviousTrack: {
        type: "boolean"
      },
      overrideTemplate: {
        type: "boolean"
      },
      prerelease: {
        additionalProperties: false,
        description: "internal",
        type: "object"
      },
      row: {
        anyOf: [
          {
            $ref: "#/definitions/Row"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      size: {
        anyOf: [
          {
            $ref: "#/definitions/Size"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      startAngle: {
        description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      stretch: {
        type: "boolean"
      },
      stroke: {
        anyOf: [
          {
            $ref: "#/definitions/Stroke"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      strokeWidth: {
        anyOf: [
          {
            $ref: "#/definitions/StrokeWidth"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      text: {
        anyOf: [
          {
            $ref: "#/definitions/Text"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      title: {
        description: "If defined, will show the textual label on the left-top corner of a track.",
        type: "string"
      },
      tooltip: {
        items: {
          $ref: "#/definitions/Tooltip"
        },
        type: "array"
      },
      visibility: {
        items: {
          $ref: "#/definitions/VisibilityCondition"
        },
        type: "array"
      },
      width: {
        description: "Specify the track width in pixels.",
        type: "number"
      },
      x: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1e: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      xe: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1e: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      ye: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "data",
      "height",
      "mark",
      "width"
    ],
    type: "object"
  },
  SingleView: {
    anyOf: [
      {
        $ref: "#/definitions/OverlaidTracks"
      },
      {
        $ref: "#/definitions/StackedTracks"
      },
      {
        $ref: "#/definitions/FlatTracks"
      }
    ]
  },
  Size: {
    additionalProperties: false,
    properties: {
      domain: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field",
        type: "string"
      },
      legend: {
        description: "not supported: Whether to display legend. __Default__: `false`",
        type: "boolean"
      },
      range: {
        $ref: "#/definitions/ValueExtent",
        description: "Ranges of visual channel values"
      },
      type: {
        description: "Specify the data type",
        "enum": [
          "quantitative",
          "nominal"
        ],
        type: "string"
      }
    },
    type: "object"
  },
  SizeVisibilityCondition: {
    additionalProperties: false,
    properties: {
      conditionPadding: {
        description: "Specify the buffer size (in pixel) of width or height when calculating the visibility.\n\n__Default__: `0`",
        type: "number"
      },
      measure: {
        description: "Specify which aspect of the `target` will be compared to the `threshold`.",
        "enum": [
          "width",
          "height"
        ],
        type: "string"
      },
      operation: {
        $ref: "#/definitions/LogicalOperation",
        description: 'A string that pecifies the logical operation to conduct between `threshold` and the `measure` of `target`. Support\n\n- greater than : "greater-than", "gt", "GT"\n\n- less than : "less-than", "lt", "LT"\n\n- greater than or equal to : "greater-than-or-equal-to", "gtet", "GTET"\n\n- less than or equal to : "less-than-or-equal-to", "ltet", "LTET"'
      },
      target: {
        description: "Target specifies the object that you want to compare with the threshold.",
        "enum": [
          "track",
          "mark"
        ],
        type: "string"
      },
      threshold: {
        anyOf: [
          {
            type: "number"
          },
          {
            "const": "|xe-x|",
            type: "string"
          }
        ],
        description: 'Specify the threshold as one of:\n\n- A number representing a fixed threshold in the unit of pixels;\n\n- `"|xe-x|"`, using the distance between `xe` and `x` as threshold'
      },
      transitionPadding: {
        description: "Specify the buffer size (in pixel) of width or height for smooth transition.\n\n__Default__: `0`",
        type: "number"
      }
    },
    required: [
      "measure",
      "operation",
      "target",
      "threshold"
    ],
    type: "object"
  },
  StackedTracks: {
    additionalProperties: false,
    properties: {
      _invalidTrack: {
        description: "internal",
        type: "boolean"
      },
      _renderingId: {
        description: "internal",
        type: "string"
      },
      alignment: {
        "const": "stack",
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      color: {
        anyOf: [
          {
            $ref: "#/definitions/Color"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      data: {
        $ref: "#/definitions/DataDeep"
      },
      dataTransform: {
        items: {
          $ref: "#/definitions/DataTransform"
        },
        type: "array"
      },
      displacement: {
        $ref: "#/definitions/Displacement"
      },
      endAngle: {
        description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      flipY: {
        type: "boolean"
      },
      height: {
        description: "Specify the track height in pixels.",
        type: "number"
      },
      id: {
        type: "string"
      },
      innerRadius: {
        description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      mark: {
        $ref: "#/definitions/Mark"
      },
      opacity: {
        anyOf: [
          {
            $ref: "#/definitions/Opacity"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      outerRadius: {
        description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
        type: "number"
      },
      overlayOnPreviousTrack: {
        type: "boolean"
      },
      overrideTemplate: {
        type: "boolean"
      },
      prerelease: {
        additionalProperties: false,
        description: "internal",
        type: "object"
      },
      row: {
        anyOf: [
          {
            $ref: "#/definitions/Row"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      size: {
        anyOf: [
          {
            $ref: "#/definitions/Size"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      startAngle: {
        description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      stretch: {
        type: "boolean"
      },
      stroke: {
        anyOf: [
          {
            $ref: "#/definitions/Stroke"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      strokeWidth: {
        anyOf: [
          {
            $ref: "#/definitions/StrokeWidth"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      text: {
        anyOf: [
          {
            $ref: "#/definitions/Text"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      title: {
        description: "If defined, will show the textual label on the left-top corner of a track.",
        type: "string"
      },
      tooltip: {
        items: {
          $ref: "#/definitions/Tooltip"
        },
        type: "array"
      },
      tracks: {
        items: {
          anyOf: [
            {
              $ref: "#/definitions/PartialTrack"
            },
            {
              $ref: "#/definitions/OverlaidTracks"
            }
          ]
        },
        type: "array"
      },
      visibility: {
        items: {
          $ref: "#/definitions/VisibilityCondition"
        },
        type: "array"
      },
      width: {
        description: "Specify the track width in pixels.",
        type: "number"
      },
      x: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      x1e: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      xe: {
        anyOf: [
          {
            $ref: "#/definitions/X"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      y1e: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      ye: {
        anyOf: [
          {
            $ref: "#/definitions/Y"
          },
          {
            $ref: "#/definitions/ChannelValue"
          }
        ]
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "tracks"
    ],
    type: "object"
  },
  StrConcatTransform: {
    additionalProperties: false,
    properties: {
      fields: {
        items: {
          type: "string"
        },
        type: "array"
      },
      newField: {
        type: "string"
      },
      separator: {
        type: "string"
      },
      type: {
        "const": "concat",
        type: "string"
      }
    },
    required: [
      "type",
      "fields",
      "newField",
      "separator"
    ],
    type: "object"
  },
  StrReplaceTransform: {
    additionalProperties: false,
    properties: {
      field: {
        type: "string"
      },
      newField: {
        type: "string"
      },
      replace: {
        items: {
          additionalProperties: false,
          properties: {
            from: {
              type: "string"
            },
            to: {
              type: "string"
            }
          },
          required: [
            "from",
            "to"
          ],
          type: "object"
        },
        type: "array"
      },
      type: {
        "const": "replace",
        type: "string"
      }
    },
    required: [
      "type",
      "field",
      "newField",
      "replace"
    ],
    type: "object"
  },
  Stroke: {
    additionalProperties: false,
    properties: {
      domain: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field",
        type: "string"
      },
      range: {
        $ref: "#/definitions/Range",
        description: "Ranges of visual channel values"
      },
      type: {
        description: "Specify the data type",
        "enum": [
          "quantitative",
          "nominal"
        ],
        type: "string"
      }
    },
    type: "object"
  },
  StrokeWidth: {
    additionalProperties: false,
    properties: {
      domain: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field",
        type: "string"
      },
      range: {
        $ref: "#/definitions/ValueExtent",
        description: "Ranges of visual channel values"
      },
      type: {
        description: "Specify the data type",
        "enum": [
          "quantitative",
          "nominal"
        ],
        type: "string"
      }
    },
    type: "object"
  },
  Style: {
    additionalProperties: false,
    properties: {
      align: {
        description: "Specify the alignment of marks. This property is currently only supported for `triangle` marks.",
        "enum": [
          "left",
          "right"
        ],
        type: "string"
      },
      background: {
        type: "string"
      },
      backgroundOpacity: {
        type: "number"
      },
      bezierLink: {
        description: "Specify whether to use bezier curves for the `link` marks.",
        type: "boolean"
      },
      curve: {
        description: "Specify the curve of `rule` marks.",
        "enum": [
          "top",
          "bottom",
          "left",
          "right"
        ],
        type: "string"
      },
      dashed: {
        description: "Specify the pattern of dashes and gaps for `rule` marks.",
        items: [
          {
            type: "number"
          },
          {
            type: "number"
          }
        ],
        maxItems: 2,
        minItems: 2,
        type: "array"
      },
      dx: {
        description: "Offset the position of marks in x direction. This property is currently only supported for `text` marks",
        type: "number"
      },
      dy: {
        description: "Offset the position of marks in y direction. This property is currently only supported for `text` marks.",
        type: "number"
      },
      enableSmoothPath: {
        description: "Whether to enable smooth paths when drawing curves.\n\n__Default__: `false`",
        type: "boolean"
      },
      flatWithinLink: {
        description: "Specify whether to use a flat within-links, such as the one in Sashimi plots. __Default__: `false`",
        type: "boolean"
      },
      inlineLegend: {
        description: "Specify whether to show legend in a single horizontal line?",
        type: "boolean"
      },
      legendTitle: {
        description: "If defined, show legend title on the top or left",
        type: "string"
      },
      linePattern: {
        additionalProperties: false,
        description: "Specify the pattern of dashes and gaps for `rule` marks.",
        properties: {
          size: {
            type: "number"
          },
          type: {
            "enum": [
              "triangleLeft",
              "triangleRight"
            ],
            type: "string"
          }
        },
        required: [
          "type",
          "size"
        ],
        type: "object"
      },
      linkConnectionType: {
        description: 'Specify the connetion type of `betweenLink` marks.\n\n__Default__: `"corner"`',
        "enum": [
          "straight",
          "curve",
          "corner"
        ],
        type: "string"
      },
      outline: {
        type: "string"
      },
      outlineWidth: {
        type: "number"
      },
      textAnchor: {
        description: "Specify the alignment of `text` marks to a given point.",
        "enum": [
          "start",
          "middle",
          "end"
        ],
        type: "string"
      },
      textFontSize: {
        description: "Specify the font size of `text` marks. Can also be specified using the `size` channel option of `text` marks.",
        type: "number"
      },
      textFontWeight: {
        description: "Specify the font weight of `text` marks.",
        "enum": [
          "bold",
          "normal"
        ],
        type: "string"
      },
      textStroke: {
        description: "Specify the stroke of `text` marks. Can also be specified using the `stroke` channel option of `text` marks.",
        type: "string"
      },
      textStrokeWidth: {
        description: "Specify the stroke width of `text` marks. Can also be specified using the `strokeWidth` channel option of `text` marks.",
        type: "number"
      }
    },
    type: "object"
  },
  TemplateTrack: {
    additionalProperties: false,
    description: "Template specification that will be internally converted into `SingleTrack` for rendering.",
    properties: {
      _invalidTrack: {
        description: "internal",
        type: "boolean"
      },
      _renderingId: {
        description: "internal",
        type: "string"
      },
      assembly: {
        $ref: "#/definitions/Assembly",
        description: 'A string that specifies the genome builds to use. Currently support `"hg38"`, `"hg19"`, `"hg18"`, `"hg17"`, `"hg16"`, `"mm10"`, `"mm9"`, and `"unknown"`.\n\n__Note:__: with `"unknown"` assembly, genomic axes do not show chrN: in labels.'
      },
      centerRadius: {
        description: "Proportion of the radius of the center white space.\n\n__Default:__ `0.3`",
        type: "number"
      },
      data: {
        $ref: "#/definitions/DataDeep"
      },
      encoding: {
        additionalProperties: {
          $ref: "#/definitions/Channel"
        },
        type: "object"
      },
      endAngle: {
        description: 'Specify the end angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      height: {
        description: "Specify the track height in pixels.",
        type: "number"
      },
      id: {
        type: "string"
      },
      innerRadius: {
        description: 'Specify the inner radius of tracks when (`{"layout": "circular"}`).',
        type: "number"
      },
      layout: {
        $ref: "#/definitions/Layout",
        description: "Specify the layout type of all tracks."
      },
      linkingId: {
        description: "Specify an ID for [linking multiple views](http://gosling-lang.org/docs/user-interaction#linking-views)",
        type: "string"
      },
      orientation: {
        $ref: "#/definitions/Orientation",
        description: "Specify the orientation."
      },
      outerRadius: {
        description: 'Specify the outer radius of tracks when `{"layout": "circular"}`.',
        type: "number"
      },
      overlayOnPreviousTrack: {
        type: "boolean"
      },
      prerelease: {
        additionalProperties: false,
        description: "internal",
        type: "object"
      },
      spacing: {
        description: '- If `{"layout": "linear"}`, specify the space between tracks in pixels;\n\n- If `{"layout": "circular"}`, specify the space between tracks in percentage ranging from 0 to 100.',
        type: "number"
      },
      startAngle: {
        description: 'Specify the start angle (in the range of [0, 360]) of circular tracks (`{"layout": "circular"}`).',
        type: "number"
      },
      "static": {
        description: "Whether to disable [Zooming and Panning](http://gosling-lang.org/docs/user-interaction#zooming-and-panning), __Default:__ `false`.",
        type: "boolean"
      },
      style: {
        $ref: "#/definitions/Style",
        description: "Define the [style](http://gosling-lang.org/docs/visual-channel#style-related-properties) of multive views. Will be overriden by the style of children elements (e.g., view, track)."
      },
      subtitle: {
        type: "string"
      },
      template: {
        type: "string"
      },
      title: {
        description: "If defined, will show the textual label on the left-top corner of a track.",
        type: "string"
      },
      width: {
        description: "Specify the track width in pixels.",
        type: "number"
      },
      xAxis: {
        $ref: "#/definitions/AxisPosition",
        description: "not supported"
      },
      xDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic x-axis"
      },
      xOffset: {
        description: "Specify the x offset of views in the unit of pixels",
        type: "number"
      },
      yDomain: {
        anyOf: [
          {
            $ref: "#/definitions/DomainInterval"
          },
          {
            $ref: "#/definitions/DomainChrInterval"
          },
          {
            $ref: "#/definitions/DomainChr"
          }
        ],
        description: "Specify the visible region of genomic y-axis"
      },
      yOffset: {
        description: "Specify the y offset of views in the unit of pixels",
        type: "number"
      },
      zoomLimits: {
        $ref: "#/definitions/ZoomLimits"
      }
    },
    required: [
      "data",
      "height",
      "template",
      "width"
    ],
    type: "object"
  },
  Text: {
    additionalProperties: false,
    properties: {
      domain: {
        description: "Values of the data",
        items: {
          type: "string"
        },
        type: "array"
      },
      field: {
        description: "Name of the data field",
        type: "string"
      },
      range: {
        description: "Ranges of visual channel values",
        items: {
          type: "string"
        },
        type: "array"
      },
      type: {
        description: "Specify the data type",
        "enum": [
          "quantitative",
          "nominal"
        ],
        type: "string"
      }
    },
    type: "object"
  },
  Tooltip: {
    additionalProperties: false,
    properties: {
      alt: {
        type: "string"
      },
      field: {
        type: "string"
      },
      format: {
        type: "string"
      },
      type: {
        $ref: "#/definitions/FieldType"
      }
    },
    required: [
      "field",
      "type"
    ],
    type: "object"
  },
  Track: {
    anyOf: [
      {
        $ref: "#/definitions/SingleTrack"
      },
      {
        $ref: "#/definitions/OverlaidTrack"
      },
      {
        $ref: "#/definitions/DataTrack"
      },
      {
        $ref: "#/definitions/TemplateTrack"
      }
    ]
  },
  ValueExtent: {
    anyOf: [
      {
        items: {
          type: "string"
        },
        type: "array"
      },
      {
        items: {
          type: "number"
        },
        type: "array"
      }
    ]
  },
  VectorData: {
    additionalProperties: false,
    description: 'One-dimensional quantitative values along genomic position (e.g., bigwig) can be converted into HiGlass\' `"vector"` format data. Find out more about this format at [HiGlass Docs](https://docs.higlass.io/data_preparation.html#bigwig-files).',
    properties: {
      aggregation: {
        $ref: "#/definitions/BinAggregate",
        description: 'Determine aggregation function to apply within bins. __Default__: `"mean"`'
      },
      binSize: {
        description: "Binning the genomic interval in tiles (unit size: 256).",
        type: "number"
      },
      column: {
        description: "Assign a field name of the middle position of genomic intervals.",
        type: "string"
      },
      end: {
        description: "Assign a field name of the end position of genomic intervals.",
        type: "string"
      },
      start: {
        description: "Assign a field name of the start position of genomic intervals.",
        type: "string"
      },
      type: {
        "const": "vector",
        type: "string"
      },
      url: {
        description: "Specify the URL address of the data file.",
        type: "string"
      },
      value: {
        description: "Assign a field name of quantitative values.",
        type: "string"
      }
    },
    required: [
      "type",
      "url",
      "column",
      "value"
    ],
    type: "object"
  },
  VisibilityCondition: {
    anyOf: [
      {
        $ref: "#/definitions/SizeVisibilityCondition"
      },
      {
        $ref: "#/definitions/ZoomLevelVisibilityCondition"
      }
    ]
  },
  X: {
    additionalProperties: false,
    properties: {
      aggregate: {
        $ref: "#/definitions/Aggregate",
        description: "Specify how to aggregate data. __Default__: `undefined`"
      },
      axis: {
        $ref: "#/definitions/AxisPosition",
        description: "Specify where should the axis be put"
      },
      domain: {
        $ref: "#/definitions/GenomicDomain",
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field.",
        type: "string"
      },
      grid: {
        description: "Whether to display grid. __Default__: `false`",
        type: "boolean"
      },
      legend: {
        description: "Whether to display legend. __Default__: `false`",
        type: "boolean"
      },
      linkingId: {
        description: "Users need to assign a unique linkingId for [linking views](/docs/user-interaction#linking-views) and [Brushing and Linking](/docs/user-interaction#brushing-and-linking)",
        type: "string"
      },
      range: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the visual channel."
      },
      type: {
        "const": "genomic",
        description: "Specify the data type.",
        type: "string"
      }
    },
    type: "object"
  },
  Y: {
    additionalProperties: false,
    properties: {
      aggregate: {
        $ref: "#/definitions/Aggregate",
        description: "Specify how to aggregate data. __Default__: `undefined`"
      },
      axis: {
        $ref: "#/definitions/AxisPosition",
        description: "Specify where should the axis be put"
      },
      baseline: {
        description: "Custom baseline of the y-axis. __Default__: `0`",
        type: [
          "string",
          "number"
        ]
      },
      domain: {
        anyOf: [
          {
            $ref: "#/definitions/ValueExtent"
          },
          {
            $ref: "#/definitions/GenomicDomain"
          }
        ],
        description: "Values of the data"
      },
      field: {
        description: "Name of the data field.",
        type: "string"
      },
      flip: {
        description: "Whether to flip the y-axis. This is done by inverting the `range` property. __Default__: `false`",
        type: "boolean"
      },
      grid: {
        description: "Whether to display grid. __Default__: `false`",
        type: "boolean"
      },
      legend: {
        description: "Whether to display legend. __Default__: `false`",
        type: "boolean"
      },
      linkingId: {
        description: "Users need to assign a unique linkingId for [linking views](/docs/user-interaction#linking-views) and [Brushing and Linking](/docs/user-interaction#brushing-and-linking)",
        type: "string"
      },
      range: {
        $ref: "#/definitions/ValueExtent",
        description: "Values of the visual channel."
      },
      type: {
        description: "Specify the data type.",
        "enum": [
          "quantitative",
          "nominal",
          "genomic"
        ],
        type: "string"
      },
      zeroBaseline: {
        description: "Specify whether to use zero baseline. __Default__: `true`",
        type: "boolean"
      }
    },
    type: "object"
  },
  ZoomLevelVisibilityCondition: {
    additionalProperties: false,
    properties: {
      conditionPadding: {
        description: "Specify the buffer size (in pixel) of width or height when calculating the visibility.\n\n__Default__: `0`",
        type: "number"
      },
      measure: {
        "const": "zoomLevel",
        description: "Specify which aspect of the `target` will be compared to the `threshold`.",
        type: "string"
      },
      operation: {
        $ref: "#/definitions/LogicalOperation",
        description: 'A string that pecifies the logical operation to conduct between `threshold` and the `measure` of `target`. Support\n\n- greater than : "greater-than", "gt", "GT"\n\n- less than : "less-than", "lt", "LT"\n\n- greater than or equal to : "greater-than-or-equal-to", "gtet", "GTET"\n\n- less than or equal to : "less-than-or-equal-to", "ltet", "LTET"'
      },
      target: {
        description: "Target specifies the object that you want to compare with the threshold.",
        "enum": [
          "track",
          "mark"
        ],
        type: "string"
      },
      threshold: {
        description: "Set a threshold in the unit of base pairs (bp)",
        type: "number"
      },
      transitionPadding: {
        description: "Specify the buffer size (in pixel) of width or height for smooth transition.\n\n__Default__: `0`",
        type: "number"
      }
    },
    required: [
      "measure",
      "operation",
      "target",
      "threshold"
    ],
    type: "object"
  },
  ZoomLimits: {
    items: [
      {
        type: [
          "number",
          "null"
        ]
      },
      {
        type: [
          "number",
          "null"
        ]
      }
    ],
    maxItems: 2,
    minItems: 2,
    type: "array"
  }
};
var GoslingSchema = {
  $ref: $ref$2,
  $schema: $schema$4,
  definitions: definitions$3
};
const $ref$1 = "#/definitions/Theme";
const $schema$3 = "http://json-schema.org/draft-07/schema#";
const definitions$2 = {
  AxisStyle: {
    additionalProperties: false,
    properties: {
      baselineColor: {
        type: "string"
      },
      gridColor: {
        type: "string"
      },
      gridStrokeDash: {
        items: [
          {
            type: "number"
          },
          {
            type: "number"
          }
        ],
        maxItems: 2,
        minItems: 2,
        type: "array"
      },
      gridStrokeType: {
        "enum": [
          "solid",
          "dashed"
        ],
        type: "string"
      },
      gridStrokeWidth: {
        type: "number"
      },
      labelColor: {
        type: "string"
      },
      labelFontFamily: {
        type: "string"
      },
      labelFontSize: {
        type: "number"
      },
      labelFontWeight: {
        "enum": [
          "bold",
          "normal",
          "light"
        ],
        type: "string"
      },
      tickColor: {
        type: "string"
      }
    },
    type: "object"
  },
  LegendStyle: {
    additionalProperties: false,
    properties: {
      background: {
        type: "string"
      },
      backgroundOpacity: {
        type: "number"
      },
      backgroundStroke: {
        type: "string"
      },
      labelColor: {
        type: "string"
      },
      labelFontFamily: {
        type: "string"
      },
      labelFontSize: {
        type: "number"
      },
      labelFontWeight: {
        "enum": [
          "bold",
          "normal",
          "light"
        ],
        type: "string"
      },
      position: {
        "enum": [
          "top",
          "right"
        ],
        type: "string"
      },
      tickColor: {
        type: "string"
      }
    },
    type: "object"
  },
  MarkStyle: {
    additionalProperties: false,
    properties: {
      color: {
        type: "string"
      },
      nominalColorRange: {
        items: {
          type: "string"
        },
        type: "array"
      },
      opacity: {
        type: "number"
      },
      quantitativeSizeRange: {
        items: [
          {
            type: "number"
          },
          {
            type: "number"
          }
        ],
        maxItems: 2,
        minItems: 2,
        type: "array"
      },
      size: {
        type: "number"
      },
      stroke: {
        type: "string"
      },
      strokeWidth: {
        type: "number"
      }
    },
    type: "object"
  },
  RootStyle: {
    additionalProperties: false,
    properties: {
      background: {
        type: "string"
      },
      mousePositionColor: {
        type: "string"
      },
      showMousePosition: {
        type: "boolean"
      },
      subtitleAlign: {
        "enum": [
          "left",
          "middle",
          "right"
        ],
        type: "string"
      },
      subtitleBackgroundColor: {
        type: "string"
      },
      subtitleColor: {
        type: "string"
      },
      subtitleFontFamily: {
        type: "string"
      },
      subtitleFontSize: {
        type: "number"
      },
      subtitleFontWeight: {
        "enum": [
          "bold",
          "normal",
          "light"
        ],
        type: "string"
      },
      titleAlign: {
        "enum": [
          "left",
          "middle",
          "right"
        ],
        type: "string"
      },
      titleBackgroundColor: {
        type: "string"
      },
      titleColor: {
        type: "string"
      },
      titleFontFamily: {
        type: "string"
      },
      titleFontSize: {
        type: "number"
      },
      titleFontWeight: {
        "enum": [
          "bold",
          "normal",
          "light"
        ],
        type: "string"
      }
    },
    type: "object"
  },
  Theme: {
    anyOf: [
      {
        $ref: "#/definitions/ThemeType"
      },
      {
        $ref: "#/definitions/ThemeDeep"
      }
    ]
  },
  ThemeDeep: {
    additionalProperties: false,
    properties: {
      area: {
        $ref: "#/definitions/MarkStyle"
      },
      axis: {
        $ref: "#/definitions/AxisStyle"
      },
      bar: {
        $ref: "#/definitions/MarkStyle"
      },
      base: {
        $ref: "#/definitions/ThemeType"
      },
      brush: {
        $ref: "#/definitions/MarkStyle"
      },
      legend: {
        $ref: "#/definitions/LegendStyle"
      },
      line: {
        $ref: "#/definitions/MarkStyle"
      },
      link: {
        $ref: "#/definitions/MarkStyle"
      },
      markCommon: {
        $ref: "#/definitions/MarkStyle"
      },
      point: {
        $ref: "#/definitions/MarkStyle"
      },
      rect: {
        $ref: "#/definitions/MarkStyle"
      },
      root: {
        $ref: "#/definitions/RootStyle"
      },
      rule: {
        $ref: "#/definitions/MarkStyle"
      },
      text: {
        additionalProperties: false,
        properties: {
          color: {
            type: "string"
          },
          nominalColorRange: {
            items: {
              type: "string"
            },
            type: "array"
          },
          opacity: {
            type: "number"
          },
          quantitativeSizeRange: {
            items: [
              {
                type: "number"
              },
              {
                type: "number"
              }
            ],
            maxItems: 2,
            minItems: 2,
            type: "array"
          },
          size: {
            type: "number"
          },
          stroke: {
            type: "string"
          },
          strokeWidth: {
            type: "number"
          },
          textAnchor: {
            "enum": [
              "start",
              "middle",
              "end"
            ],
            type: "string"
          },
          textFontWeight: {
            "enum": [
              "bold",
              "normal"
            ],
            type: "string"
          }
        },
        type: "object"
      },
      track: {
        $ref: "#/definitions/TrackStyle"
      },
      triangle: {
        $ref: "#/definitions/MarkStyle"
      }
    },
    required: [
      "base"
    ],
    type: "object"
  },
  ThemeType: {
    "enum": [
      "light",
      "dark",
      "warm",
      "ggplot",
      "igv",
      "ensembl",
      "jbrowse",
      "ucsc",
      "washu",
      "excel",
      "google"
    ],
    type: "string"
  },
  TrackStyle: {
    additionalProperties: false,
    properties: {
      alternatingBackground: {
        type: "string"
      },
      background: {
        type: "string"
      },
      outline: {
        type: "string"
      },
      outlineWidth: {
        type: "number"
      },
      titleAlign: {
        "enum": [
          "left",
          "middle",
          "right"
        ],
        type: "string"
      },
      titleBackground: {
        type: "string"
      },
      titleColor: {
        type: "string"
      },
      titleFontSize: {
        type: "number"
      }
    },
    type: "object"
  }
};
var theme_schema = {
  $ref: $ref$1,
  $schema: $schema$3,
  definitions: definitions$2
};
const DEWFAULT_TITLE_PADDING_ON_TOP_AND_BOTTOM = 6;
const DEFAULT_TRACK_HEIGHT_LINEAR = 180;
const DEFAULT_TRACK_WIDTH_LINEAR = 360;
const DEFAULT_VIEW_SPACING = 10;
const DEFAULT_INNER_RADIUS_PROP = 0.3;
const DEFAULT_CIRCULAR_VIEW_PADDING = 0;
const DEFAULT_BACKUP_COLOR = "gray";
const colorToHex = (colorStr) => {
  let c = color(colorStr);
  if (!c) {
    c = color(DEFAULT_BACKUP_COLOR);
  }
  const hex = pixi.utils.rgb2hex([c.rgb().r / 255, c.rgb().g / 255, c.rgb().b / 255]);
  return hex;
};
const RADIAN_GAP = 0;
function valueToRadian(v, max2, sa, ea, g) {
  const safeVal = Math.max(Math.min(max2, v), 0);
  const gap = g != null ? g : RADIAN_GAP;
  const radExtent = (ea - sa) / 360 * Math.PI * 2 - gap * 2;
  const radStart = sa / 360 * Math.PI * 2;
  return -(radStart + safeVal / max2 * radExtent) - Math.PI / 2 - gap;
}
function cartesianToPolar(x, max2, r, cx, cy, sa, ea) {
  return {
    x: cx + r * Math.cos(valueToRadian(x, max2, sa, ea)),
    y: cy + r * Math.sin(valueToRadian(x, max2, sa, ea))
  };
}
function positionToRadian(x, y, cx, cy) {
  if (cx <= x) {
    return Math.atan((y - cy) / (x - cx));
  } else {
    return Math.atan((y - cy) / (x - cx)) - Math.PI;
  }
}
const TOOLTIP_MOUSEOVER_MARGIN = 1;
function drawPoint(trackInfo, g, model) {
  var _a, _b, _c, _d, _e;
  const spec = model.spec();
  if (!spec.width || !spec.height) {
    console.warn("Size of a track is not properly determined, so visual mark cannot be rendered");
    return;
  }
  const data2 = model.data();
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const zoomLevel = model.getChannelScale("x").invert(trackWidth) - model.getChannelScale("x").invert(0);
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const tcx = trackWidth / 2;
  const tcy = trackHeight / 2;
  const rowCategories = (_e = model.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  rowCategories.forEach((rowCategory) => {
    const rowPosition = model.encodedValue("row", rowCategory);
    data2.filter((d) => !getValueUsingChannel(d, spec.row) || getValueUsingChannel(d, spec.row) === rowCategory).forEach((d) => {
      const cx = model.encodedPIXIProperty("x-center", d);
      const cy = model.encodedPIXIProperty("y-center", d);
      const color2 = model.encodedPIXIProperty("color", d);
      const size = model.encodedPIXIProperty("p-size", d);
      const strokeWidth = model.encodedPIXIProperty("strokeWidth", d);
      const stroke = model.encodedPIXIProperty("stroke", d);
      const opacity = model.encodedPIXIProperty("opacity", d);
      const alphaTransition = model.markVisibility(d, { width: size, zoomLevel });
      const actualOpacity = Math.min(alphaTransition, opacity);
      if (size <= 0.1 || actualOpacity === 0 || cx + size < 0 || cx - size > trackWidth) {
        return;
      }
      g.lineStyle(strokeWidth, colorToHex(stroke), actualOpacity, 1);
      if (circular) {
        const r = trackOuterRadius - (rowPosition + rowHeight - cy) / trackHeight * trackRingSize;
        const pos = cartesianToPolar(cx, trackWidth, r, tcx, tcy, startAngle, endAngle);
        g.beginFill(colorToHex(color2), actualOpacity);
        g.drawCircle(pos.x, pos.y, size);
      } else {
        g.beginFill(colorToHex(color2), actualOpacity);
        g.drawCircle(cx, rowPosition + rowHeight - cy, size);
        if (trackInfo == null ? void 0 : trackInfo.tooltips) {
          const gcy = rowPosition + rowHeight - cy;
          trackInfo.tooltips.push({
            datum: d,
            isMouseOver: (x, y) => Math.sqrt(Math.abs(x - cx) * Math.abs(x - cx) + Math.abs(y - gcy) * Math.abs(y - gcy)) < size + TOOLTIP_MOUSEOVER_MARGIN,
            markInfo: { x: cx, y: rowPosition + rowHeight - cy, width: size, height: size, type: "point" }
          });
        }
      }
    });
  });
}
function pointProperty(model, propertyKey, datum) {
  const xe = model.visualPropertyByChannel("xe", datum);
  const x = model.visualPropertyByChannel("x", datum);
  const size = model.visualPropertyByChannel("size", datum);
  switch (propertyKey) {
    case "x-center":
      return xe ? (xe + x) / 2 : x;
    case "y-center":
      const ye = model.visualPropertyByChannel("ye", datum);
      const y = model.visualPropertyByChannel("y", datum);
      return ye ? (ye + y) / 2 : y;
    case "p-size":
      return xe && model.spec().stretch ? (xe - x) / 2 : size;
    default:
      return void 0;
  }
}
function drawLine(g, tm, tooltips, trackWidth, trackHeight) {
  var _a, _b, _c, _d, _e, _f;
  const spec = tm.spec();
  if (!spec.width || !spec.height) {
    console.warn("Size of a track is not properly determined, so visual mark cannot be rendered");
    return;
  }
  const data2 = tm.data();
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const trackCenterX = trackWidth / 2;
  const trackCenterY = trackHeight / 2;
  const rowCategories = (_e = tm.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const colorCategories = (_f = tm.getChannelDomainArray("color")) != null ? _f : ["___SINGLE_COLOR___"];
  rowCategories.forEach((rowCategory) => {
    const rowPosition = tm.encodedValue("row", rowCategory);
    colorCategories.forEach((colorCategory) => {
      data2.filter((d) => (!getValueUsingChannel(d, spec.row) || getValueUsingChannel(d, spec.row) === rowCategory) && (!getValueUsingChannel(d, spec.color) || getValueUsingChannel(d, spec.color) === colorCategory)).sort((d1, d2) => getValueUsingChannel(d1, spec.x) - getValueUsingChannel(d2, spec.x)).forEach((d, i) => {
        const cx = tm.encodedPIXIProperty("x", d);
        const y = tm.encodedPIXIProperty("y", d);
        const size = tm.encodedPIXIProperty("size", d);
        const color2 = tm.encodedPIXIProperty("color", d);
        const opacity = tm.encodedPIXIProperty("opacity", d);
        g.lineStyle(size, colorToHex(color2), opacity, 0.5);
        if (circular) {
          const r = trackOuterRadius - (rowPosition + rowHeight - y) / trackHeight * trackRingSize;
          const pos = cartesianToPolar(cx, trackWidth, r, trackCenterX, trackCenterY, startAngle, endAngle);
          if (i === 0) {
            g.moveTo(pos.x, pos.y);
          } else {
            g.lineTo(pos.x, pos.y);
          }
        } else {
          if (i === 0) {
            g.moveTo(cx, rowPosition + rowHeight - y);
          } else {
            g.lineTo(cx, rowPosition + rowHeight - y);
          }
          if (spec.tooltip) {
            tooltips.push({
              datum: d,
              isMouseOver: (x, y2) => cx - TOOLTIP_MOUSEOVER_MARGIN < x && x < cx + TOOLTIP_MOUSEOVER_MARGIN && rowPosition - TOOLTIP_MOUSEOVER_MARGIN < y2 && y2 < rowPosition + rowHeight + TOOLTIP_MOUSEOVER_MARGIN,
              markInfo: { x: cx, y, width: TOOLTIP_MOUSEOVER_MARGIN, height: y, type: "line" }
            });
          }
        }
      });
    });
  });
}
function drawBar(trackInfo, tile, model) {
  var _a, _b, _c, _d, _e, _f, _g;
  const spec = model.spec();
  if (!spec.width || !spec.height) {
    console.warn("Size of a track is not properly determined, so visual mark cannot be rendered");
    return;
  }
  const data2 = model.data();
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const tileSize = trackInfo.tilesetInfo.tile_size;
  const { tileX, tileWidth } = trackInfo.getTilePosAndDimensions(tile.gos.zoomLevel, tile.gos.tilePos, tileSize);
  const zoomLevel = model.getChannelScale("x").invert(trackWidth) - model.getChannelScale("x").invert(0);
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const cx = trackWidth / 2;
  const cy = trackHeight / 2;
  const xScale = model.getChannelScale("x");
  const tileUnitWidth = xScale(tileX + tileWidth / tileSize) - xScale(tileX);
  const rowCategories = (_e = model.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const baselineValue = IsChannelDeep(spec.y) ? (_f = spec.y) == null ? void 0 : _f.baseline : void 0;
  const staticBaseY = (_g = model.encodedValue("y", baselineValue)) != null ? _g : 0;
  const g = tile.graphics;
  if (IsStackedMark(spec)) {
    const genomicChannel = model.getGenomicChannel();
    if (!genomicChannel || !genomicChannel.field) {
      console.warn("Genomic field is not provided in the specification");
      return;
    }
    const pivotedData = group(data2, (d) => d[genomicChannel.field]);
    const xKeys = [...pivotedData.keys()];
    xKeys.forEach((k) => {
      var _a2;
      let prevYEnd = 0;
      (_a2 = pivotedData.get(k)) == null ? void 0 : _a2.forEach((d) => {
        const color2 = model.encodedPIXIProperty("color", d);
        const stroke = model.encodedPIXIProperty("stroke", d);
        const strokeWidth = model.encodedPIXIProperty("strokeWidth", d);
        const opacity = model.encodedPIXIProperty("opacity", d);
        const y = model.encodedPIXIProperty("y", d);
        const barWidth = model.encodedPIXIProperty("width", d, { tileUnitWidth });
        const xs = model.encodedPIXIProperty("x-start", d, { markWidth: barWidth });
        const xe = xs + barWidth;
        const alphaTransition = model.markVisibility(d, { width: barWidth, zoomLevel });
        const actualOpacity = Math.min(alphaTransition, opacity);
        if (actualOpacity === 0 || barWidth <= 0 || y <= 0) {
          return;
        }
        g.lineStyle(strokeWidth, colorToHex(stroke), actualOpacity, 0);
        if (circular) {
          const farR = trackOuterRadius - (rowHeight - prevYEnd) / trackHeight * trackRingSize;
          const nearR = trackOuterRadius - (rowHeight - y - prevYEnd) / trackHeight * trackRingSize;
          const sPos = cartesianToPolar(xs, trackWidth, nearR, cx, cy, startAngle, endAngle);
          const startRad = valueToRadian(xs, trackWidth, startAngle, endAngle);
          const endRad = valueToRadian(xs + barWidth, trackWidth, startAngle, endAngle);
          g.beginFill(colorToHex(color2), actualOpacity);
          g.moveTo(sPos.x, sPos.y);
          g.arc(cx, cy, nearR, startRad, endRad, true);
          g.arc(cx, cy, farR, endRad, startRad, false);
          g.closePath();
        } else {
          const ys = rowHeight - y - prevYEnd;
          const barHeight = y;
          g.beginFill(colorToHex(color2), actualOpacity);
          g.drawRect(xs, rowHeight - y - prevYEnd, barWidth, y);
          if (spec.tooltip) {
            trackInfo.tooltips.push({
              datum: d,
              isMouseOver: (x, y2) => xs - TOOLTIP_MOUSEOVER_MARGIN < x && x < xe + TOOLTIP_MOUSEOVER_MARGIN && ys - TOOLTIP_MOUSEOVER_MARGIN < y2 && y2 < ys + barHeight + TOOLTIP_MOUSEOVER_MARGIN,
              markInfo: { x: xs, y: ys, width: barWidth, height: barHeight, type: "bar" }
            });
          }
        }
        prevYEnd += y;
      });
    });
  } else {
    rowCategories.forEach((rowCategory) => {
      const rowPosition = model.encodedValue("row", rowCategory);
      data2.filter((d) => {
        const rowValue = getValueUsingChannel(d, spec.row);
        return !rowValue || rowValue === rowCategory;
      }).forEach((d) => {
        const color2 = model.encodedPIXIProperty("color", d);
        const stroke = model.encodedPIXIProperty("stroke", d);
        const strokeWidth = model.encodedPIXIProperty("strokeWidth", d);
        const opacity = model.encodedPIXIProperty("opacity");
        let y = model.encodedPIXIProperty("y", d);
        let ye = model.encodedPIXIProperty("ye", d);
        if (typeof ye !== "undefined") {
          [y, ye] = [y, ye].sort();
        }
        const barWidth = model.encodedPIXIProperty("width", d, { tileUnitWidth });
        const xLeft = model.encodedPIXIProperty("x-start", d, { markWidth: barWidth });
        const xRight = xLeft + barWidth;
        let yTop, yBottom;
        if (typeof ye === "undefined") {
          yTop = rowPosition + rowHeight - staticBaseY - y;
          yBottom = rowPosition + rowHeight - staticBaseY;
        } else {
          yTop = rowPosition + rowHeight - ye;
          yBottom = rowPosition + rowHeight - y;
        }
        const alphaTransition = model.markVisibility(d, { width: barWidth, zoomLevel });
        const actualOpacity = Math.min(alphaTransition, opacity);
        if (actualOpacity === 0 || barWidth === 0 || y === 0) {
          return;
        }
        g.lineStyle(strokeWidth, colorToHex(stroke), actualOpacity, 0);
        if (circular) {
          const farR = trackOuterRadius - yTop / trackHeight * trackRingSize;
          const nearR = trackOuterRadius - yBottom / trackHeight * trackRingSize;
          const sPos = cartesianToPolar(xLeft, trackWidth, nearR, cx, cy, startAngle, endAngle);
          const startRad = valueToRadian(xLeft, trackWidth, startAngle, endAngle);
          const endRad = valueToRadian(xLeft + barWidth, trackWidth, startAngle, endAngle);
          g.beginFill(colorToHex(color2), actualOpacity);
          g.moveTo(sPos.x, sPos.y);
          g.arc(cx, cy, nearR, startRad, endRad, true);
          g.arc(cx, cy, farR, endRad, startRad, false);
          g.closePath();
        } else {
          g.beginFill(colorToHex(color2), actualOpacity);
          g.drawRect(xLeft, yTop, barWidth, yBottom - yTop);
          if (spec.tooltip) {
            const barHeight = yBottom - yTop;
            trackInfo.tooltips.push({
              datum: d,
              isMouseOver: (x, y2) => xLeft - TOOLTIP_MOUSEOVER_MARGIN < x && x < xRight + TOOLTIP_MOUSEOVER_MARGIN && yTop - TOOLTIP_MOUSEOVER_MARGIN < y2 && y2 < yBottom + TOOLTIP_MOUSEOVER_MARGIN,
              markInfo: { x: xLeft, y: yTop, width: barWidth, height: barHeight, type: "bar" }
            });
          }
        }
      });
    });
  }
}
function barProperty(gm, propertyKey, datum, additionalInfo) {
  const x = gm.visualPropertyByChannel("x", datum);
  const xe = gm.visualPropertyByChannel("xe", datum);
  const size = gm.visualPropertyByChannel("size", datum);
  switch (propertyKey) {
    case "width":
      return size != null ? size : xe ? xe - x : additionalInfo == null ? void 0 : additionalInfo.tileUnitWidth;
    case "x-start":
      if (!(additionalInfo == null ? void 0 : additionalInfo.markWidth)) {
        return void 0;
      }
      return xe ? (x + xe - (additionalInfo == null ? void 0 : additionalInfo.markWidth)) / 2 : x - (additionalInfo == null ? void 0 : additionalInfo.markWidth) / 2;
    default:
      return void 0;
  }
}
function drawArea(HGC, trackInfo, tile, tm) {
  var _a, _b, _c, _d, _e, _f;
  const spec = tm.spec();
  const data2 = tm.data();
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const tileSize = trackInfo.tilesetInfo.tile_size;
  const { tileX } = trackInfo.getTilePosAndDimensions(tile.gos.zoomLevel, tile.gos.tilePos, tileSize);
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const trackCenterX = trackWidth / 2;
  const trackCenterY = trackHeight / 2;
  const xScale = tm.getChannelScale("x");
  const rowCategories = (_e = tm.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const colorCategories = (_f = tm.getChannelDomainArray("color")) != null ? _f : ["___SINGLE_COLOR___"];
  const constantOpacity = tm.encodedPIXIProperty("opacity");
  const constantStrokeWidth = tm.encodedPIXIProperty("strokeWidth");
  const constantStroke = tm.encodedPIXIProperty("stroke");
  const graphics = tile.graphics;
  if (IsStackedMark(spec)) {
    const genomicChannel = tm.getGenomicChannel();
    if (!genomicChannel || !genomicChannel.field) {
      console.warn("Genomic field is not provided in the specification");
      return;
    }
    const pivotedData = group(data2, (d) => d[genomicChannel.field]);
    const genomicPosCategories = [...pivotedData.keys()];
    graphics.lineStyle(constantStrokeWidth, colorToHex(constantStroke), constantOpacity, 1);
    const prevYEndByGPos = {};
    colorCategories.forEach((colorCategory) => {
      const areaPointsTop = [];
      const areaPointsBottom = [];
      genomicPosCategories.forEach((genomicPosCategory, i, array) => {
        var _a2, _b2;
        (_b2 = (_a2 = pivotedData.get(genomicPosCategory)) == null ? void 0 : _a2.filter((d) => getValueUsingChannel(d, spec.color) === colorCategory)) == null ? void 0 : _b2.forEach((d) => {
          const xValue = +genomicPosCategory;
          const cx = xScale(xValue);
          const cy = max([tm.encodedPIXIProperty("y", d), 0]);
          if (circular) {
            if (i === 0) {
              const r = trackOuterRadius - rowHeight / trackHeight * trackRingSize;
              const pos = cartesianToPolar(cx, trackWidth, r, trackCenterX, trackCenterY, startAngle, endAngle);
              areaPointsTop.push([pos.x, pos.y]);
              areaPointsBottom.push([pos.x, pos.y]);
            }
            if (typeof prevYEndByGPos[genomicPosCategory] === "undefined") {
              prevYEndByGPos[genomicPosCategory] = 0;
            }
            const rTop = trackOuterRadius - (rowHeight - cy - prevYEndByGPos[genomicPosCategory]) / trackHeight * trackRingSize;
            const posTop = cartesianToPolar(cx, trackWidth, rTop, trackCenterX, trackCenterY, startAngle, endAngle);
            areaPointsTop.push([posTop.x, posTop.y]);
            const rBot = trackOuterRadius - (rowHeight - prevYEndByGPos[genomicPosCategory]) / trackHeight * trackRingSize;
            const posBot = cartesianToPolar(cx, trackWidth, rBot, trackCenterX, trackCenterY, startAngle, endAngle);
            areaPointsBottom.push([posBot.x, posBot.y]);
            if (i === array.length - 1) {
              const r = trackOuterRadius - rowHeight / trackHeight * trackRingSize;
              const pos = cartesianToPolar(cx, trackWidth, r, trackCenterX, trackCenterY, startAngle, endAngle);
              areaPointsTop.push([pos.x, pos.y]);
              areaPointsBottom.push([pos.x, pos.y]);
            }
          } else {
            if (i === 0) {
              areaPointsTop.push([cx, rowHeight]);
              areaPointsBottom.push([cx, rowHeight]);
            }
            if (typeof prevYEndByGPos[genomicPosCategory] === "undefined") {
              prevYEndByGPos[genomicPosCategory] = 0;
            }
            areaPointsTop.push([cx, rowHeight - cy - prevYEndByGPos[genomicPosCategory]]);
            areaPointsBottom.push([cx, rowHeight - prevYEndByGPos[genomicPosCategory]]);
            if (i === array.length - 1) {
              areaPointsTop.push([cx, rowHeight]);
              areaPointsBottom.push([cx, rowHeight]);
            }
            if (spec.tooltip) {
              const ys = rowHeight - cy - prevYEndByGPos[genomicPosCategory];
              const ye = rowHeight - prevYEndByGPos[genomicPosCategory];
              trackInfo.tooltips.push({
                datum: d,
                isMouseOver: (x, y) => cx - TOOLTIP_MOUSEOVER_MARGIN < x && x < cx + TOOLTIP_MOUSEOVER_MARGIN && ys - TOOLTIP_MOUSEOVER_MARGIN < y && y < ye + TOOLTIP_MOUSEOVER_MARGIN,
                markInfo: { x: cx, y: ys, width: TOOLTIP_MOUSEOVER_MARGIN, height: cy, type: "area" }
              });
            }
          }
          prevYEndByGPos[genomicPosCategory] += cy;
        });
      });
      const color2 = tm.encodedValue("color", colorCategory);
      graphics.beginFill(colorToHex(color2), constantOpacity);
      graphics.drawPolygon([
        ...areaPointsTop.reduce((a, b) => a.concat(b)),
        ...areaPointsBottom.reverse().reduce((a, b) => a.concat(b))
      ]);
      graphics.endFill();
    });
  } else {
    rowCategories.forEach((rowCategory) => {
      const rowPosition = tm.encodedValue("row", rowCategory);
      graphics.lineStyle(constantStrokeWidth, colorToHex(constantStroke), constantOpacity, 0);
      colorCategories.forEach((colorCategory) => {
        const baselinePoints = [];
        const areaPoints = [];
        const baselineR = trackOuterRadius - (rowPosition + rowHeight) / trackHeight * trackRingSize;
        data2.filter((d) => (typeof getValueUsingChannel(d, spec.row) === "undefined" || getValueUsingChannel(d, spec.row) === rowCategory) && (typeof getValueUsingChannel(d, spec.color) === "undefined" || getValueUsingChannel(d, spec.color) === colorCategory)).sort((a, b) => tm.encodedPIXIProperty("x", a) - tm.encodedPIXIProperty("x", b)).forEach((d, i, array) => {
          const cy = min([max([tm.encodedPIXIProperty("y", d), 0]), rowHeight]);
          const cx = tm.encodedPIXIProperty("x", d);
          if (circular) {
            const baselinePos = cartesianToPolar(cx, trackWidth, baselineR, trackCenterX, trackCenterY, startAngle, endAngle);
            baselinePoints.push([baselinePos.x, baselinePos.y]);
            if (i === 0) {
              areaPoints.push(baselinePos.x, baselinePos.y);
            }
            const r = trackOuterRadius - (rowPosition + rowHeight - cy) / trackHeight * trackRingSize;
            const pos = cartesianToPolar(cx, trackWidth, r, trackCenterX, trackCenterY, startAngle, endAngle);
            areaPoints.push(pos.x, pos.y);
            if (i === array.length - 1) {
              const startR = trackOuterRadius - (rowPosition + rowHeight) / trackHeight * trackRingSize;
              const curPos = cartesianToPolar(cx, trackWidth, startR, trackCenterX, trackCenterY, startAngle, endAngle);
              areaPoints.push(curPos.x, curPos.y);
            }
          } else {
            if (i === 0) {
              areaPoints.push(cx, rowPosition + rowHeight);
            }
            areaPoints.push(cx, rowPosition + rowHeight - cy);
            if (i === array.length - 1) {
              const startX = xScale(tileX);
              areaPoints.push(cx, rowPosition + rowHeight);
              areaPoints.push(startX, rowPosition + rowHeight);
            }
            if (spec.tooltip) {
              trackInfo.tooltips.push({
                datum: d,
                isMouseOver: (x, y) => cx - TOOLTIP_MOUSEOVER_MARGIN < x && x < cx + TOOLTIP_MOUSEOVER_MARGIN && rowPosition - TOOLTIP_MOUSEOVER_MARGIN < y && y < rowPosition + rowHeight + TOOLTIP_MOUSEOVER_MARGIN,
                markInfo: { x: cx, y: cy, width: TOOLTIP_MOUSEOVER_MARGIN, height: cy, type: "area" }
              });
            }
          }
        });
        if (circular && baselinePoints.length !== 0) {
          areaPoints.push(...baselinePoints.reverse().reduce((a, b) => a.concat(b)));
        }
        const color2 = tm.encodedValue("color", colorCategory);
        graphics.beginFill(colorToHex(color2), constantOpacity);
        graphics.drawPolygon(areaPoints);
        graphics.endFill();
      });
    });
  }
}
function drawRect(HGC, trackInfo, tile, model) {
  var _a, _b, _c, _d, _e, _f;
  const spec = model.spec();
  const data2 = model.data();
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const tileSize = trackInfo.tilesetInfo.tile_size;
  const { tileX, tileWidth } = trackInfo.getTilePosAndDimensions(tile.gos.zoomLevel, tile.gos.tilePos, tileSize);
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const cx = trackWidth / 2;
  const cy = trackHeight / 2;
  const xScale = trackInfo._xScale;
  const tileUnitWidth = xScale(tileX + tileWidth / tileSize) - xScale(tileX);
  const rowCategories = (_e = model.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const RPAD = IsChannelDeep(spec.row) && spec.row.padding ? spec.row.padding : 0;
  const yCategories = (_f = model.getChannelDomainArray("y")) != null ? _f : ["___SINGLE_Y_POSITION___"];
  const cellHeight = rowHeight / yCategories.length - RPAD * 2;
  const g = tile.graphics;
  data2.forEach((d) => {
    var _a2;
    const rowPosition = model.encodedPIXIProperty("row", d) + RPAD;
    const x = model.encodedPIXIProperty("x", d);
    const color2 = model.encodedPIXIProperty("color", d);
    const stroke = model.encodedPIXIProperty("stroke", d);
    const strokeWidth = model.encodedPIXIProperty("strokeWidth", d);
    const opacity = model.encodedPIXIProperty("opacity", d);
    const rectWidth = model.encodedPIXIProperty("width", d, { markWidth: tileUnitWidth });
    const rectHeight = model.encodedPIXIProperty("height", d, { markHeight: cellHeight });
    const y = model.encodedPIXIProperty("y", d);
    const alphaTransition = model.markVisibility(d, {
      width: rectWidth,
      zoomLevel: trackInfo._xScale.invert(trackWidth) - trackInfo._xScale.invert(0)
    });
    const actualOpacity = Math.min(alphaTransition, opacity);
    if (actualOpacity === 0 || rectHeight === 0 || rectWidth <= 1e-4) {
      return;
    }
    const xs = x;
    const xe = x + rectWidth;
    const absoluteHeight = (_a2 = model.visualPropertyByChannel("size", d)) != null ? _a2 : void 0;
    g.lineStyle(strokeWidth, colorToHex(stroke), actualOpacity, 0.5);
    if (circular) {
      if (xe < 0 || trackWidth < xs) {
        return;
      }
      let farR = trackOuterRadius - (rowPosition + rowHeight - y - rectHeight / 2) / trackHeight * trackRingSize;
      let nearR = trackOuterRadius - (rowPosition + rowHeight - y + rectHeight / 2) / trackHeight * trackRingSize;
      if (absoluteHeight) {
        const midR = trackOuterRadius - (rowPosition + y) / trackHeight * trackRingSize;
        farR = midR - absoluteHeight / 2;
        nearR = midR + absoluteHeight / 2;
      }
      const sPos = cartesianToPolar(xs, trackWidth, nearR, cx, cy, startAngle, endAngle);
      const startRad = valueToRadian(xs, trackWidth, startAngle, endAngle);
      const endRad = valueToRadian(xe, trackWidth, startAngle, endAngle);
      g.beginFill(colorToHex(color2 === "none" ? "white" : color2), color2 === "none" ? 0 : actualOpacity);
      g.moveTo(sPos.x, sPos.y);
      g.arc(cx, cy, nearR, startRad, endRad, true);
      g.arc(cx, cy, farR, endRad, startRad, false);
      g.closePath();
    } else {
      g.beginFill(colorToHex(color2 === "none" ? "white" : color2), color2 === "none" ? 0 : actualOpacity);
      g.drawRect(xs, rowPosition + rowHeight - y - rectHeight / 2, xe - xs, rectHeight);
      if (spec.tooltip) {
        trackInfo.tooltips.push({
          datum: d,
          isMouseOver: (mouseX, mouseY) => xs - TOOLTIP_MOUSEOVER_MARGIN < mouseX && mouseX < xe + TOOLTIP_MOUSEOVER_MARGIN && rowPosition + rowHeight - y - rectHeight / 2 - TOOLTIP_MOUSEOVER_MARGIN < mouseY && mouseY < rowPosition + rowHeight - y + rectHeight / 2 + TOOLTIP_MOUSEOVER_MARGIN,
          markInfo: {
            x: xs,
            y: rowPosition + rowHeight - y - rectHeight / 2,
            width: xe - xs,
            height: rectHeight,
            type: "rect"
          }
        });
      }
    }
  });
}
function rectProperty(gm, propertyKey, datum, additionalInfo) {
  var _a;
  switch (propertyKey) {
    case "width":
      const width = gm.visualPropertyByChannel("xe", datum) ? gm.visualPropertyByChannel("xe", datum) - gm.visualPropertyByChannel("x", datum) : additionalInfo == null ? void 0 : additionalInfo.markWidth;
      return width === 0 ? 0.1 : width;
    case "height":
      return (_a = gm.visualPropertyByChannel("size", datum)) != null ? _a : additionalInfo == null ? void 0 : additionalInfo.markHeight;
    default:
      return void 0;
  }
}
function drawTriangle(g, model, trackWidth, trackHeight) {
  var _a, _b, _c, _d, _e, _f, _g;
  const spec = model.spec();
  if (!spec.width || !spec.height) {
    console.warn("Size of a track is not properly determined, so visual mark cannot be rendered");
    return;
  }
  const data2 = model.data();
  const zoomLevel = model.getChannelScale("x").invert(trackWidth) - model.getChannelScale("x").invert(0);
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const cx = trackWidth / 2;
  const cy = trackHeight / 2;
  const rowCategories = (_e = model.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const yCategories = (_f = model.getChannelDomainArray("y")) != null ? _f : ["___SINGLE_Y___"];
  const triHeight = (_g = model.encodedValue("size")) != null ? _g : circular ? trackRingSize / rowCategories.length / yCategories.length : rowHeight / yCategories.length;
  rowCategories.forEach((rowCategory) => {
    const rowPosition = model.encodedValue("row", rowCategory);
    data2.filter((d) => !getValueUsingChannel(d, spec.row) || getValueUsingChannel(d, spec.row) === rowCategory).forEach((d) => {
      var _a2, _b2, _c2;
      const x = model.encodedPIXIProperty("x", d);
      const xe = model.encodedPIXIProperty("xe", d);
      const markWidth = (_a2 = model.encodedPIXIProperty("size", d)) != null ? _a2 : xe === void 0 ? triHeight : xe - x;
      const y = model.encodedPIXIProperty("y", d);
      const strokeWidth = model.encodedPIXIProperty("strokeWidth", d);
      const stroke = model.encodedPIXIProperty("stroke", d);
      const color2 = model.encodedPIXIProperty("color", d);
      const opacity = model.encodedPIXIProperty("opacity", d);
      if (circular) {
        let x0 = x ? x : xe - markWidth;
        let x1 = xe ? xe : x + markWidth;
        let xm = (x0 + x1) / 2;
        const rm = trackOuterRadius - (rowPosition + rowHeight - y) / trackHeight * trackRingSize;
        const r0 = rm - triHeight / 2;
        const r1 = rm + triHeight / 2;
        if (((_b2 = spec.style) == null ? void 0 : _b2.align) === "right" && !xe) {
          x0 -= markWidth;
          x1 -= markWidth;
          xm -= markWidth;
        }
        let markToPoints = [];
        if (spec.mark === "triangleLeft") {
          const p0 = cartesianToPolar(x1, trackWidth, r0, cx, cy, startAngle, endAngle);
          const p1 = cartesianToPolar(x0, trackWidth, rm, cx, cy, startAngle, endAngle);
          const p2 = cartesianToPolar(x1, trackWidth, r1, cx, cy, startAngle, endAngle);
          const p3 = cartesianToPolar(x1, trackWidth, r0, cx, cy, startAngle, endAngle);
          markToPoints = [p0.x, p0.y, p1.x, p1.y, p2.x, p2.y, p3.x, p3.y];
        } else if (spec.mark === "triangleRight") {
          const p0 = cartesianToPolar(x0, trackWidth, r0, cx, cy, startAngle, endAngle);
          const p1 = cartesianToPolar(x1, trackWidth, rm, cx, cy, startAngle, endAngle);
          const p2 = cartesianToPolar(x0, trackWidth, r1, cx, cy, startAngle, endAngle);
          const p3 = cartesianToPolar(x0, trackWidth, r0, cx, cy, startAngle, endAngle);
          markToPoints = [p0.x, p0.y, p1.x, p1.y, p2.x, p2.y, p3.x, p3.y];
        } else if (spec.mark === "triangleBottom") {
          x0 = xm - markWidth / 2;
          x1 = xm + markWidth / 2;
          const p0 = cartesianToPolar(x0, trackWidth, r1, cx, cy, startAngle, endAngle);
          const p1 = cartesianToPolar(x1, trackWidth, r1, cx, cy, startAngle, endAngle);
          const p2 = cartesianToPolar(xm, trackWidth, r0, cx, cy, startAngle, endAngle);
          const p3 = cartesianToPolar(x0, trackWidth, r1, cx, cy, startAngle, endAngle);
          markToPoints = [p0.x, p0.y, p1.x, p1.y, p2.x, p2.y, p3.x, p3.y];
        }
        const alphaTransition = model.markVisibility(d, { width: x1 - x0, zoomLevel });
        const actualOpacity = Math.min(alphaTransition, opacity);
        g.lineStyle(strokeWidth, colorToHex(stroke), x1 - x0 > 2 ? actualOpacity : 0, 0);
        g.beginFill(colorToHex(color2), actualOpacity);
        g.drawPolygon(markToPoints);
        g.endFill();
      } else {
        let x0 = x ? x : xe - markWidth;
        let x1 = xe ? xe : x + markWidth;
        let xm = x0 + (x1 - x0) / 2;
        const ym = rowPosition + rowHeight - y;
        const y0 = rowPosition + rowHeight - y - triHeight / 2;
        const y1 = rowPosition + rowHeight - y + triHeight / 2;
        if (((_c2 = spec.style) == null ? void 0 : _c2.align) === "right" && !xe) {
          x0 -= markWidth;
          x1 -= markWidth;
          xm -= markWidth;
        }
        const markToPoints = {
          triangleLeft: [x1, y0, x0, ym, x1, y1, x1, y0],
          triangleRight: [x0, y0, x1, ym, x0, y1, x0, y0],
          triangleBottom: [x0, y0, x1, y0, xm, y1, x0, y0]
        }[spec.mark];
        const alphaTransition = model.markVisibility(d, { width: x1 - x0, zoomLevel });
        const actualOpacity = Math.min(alphaTransition, opacity);
        g.lineStyle(strokeWidth, colorToHex(stroke), x1 - x0 > 2 ? actualOpacity : 0, 0.5);
        g.beginFill(colorToHex(color2), actualOpacity);
        g.drawPolygon(markToPoints);
        g.endFill();
      }
    });
  });
}
const TEXT_STYLE_GLOBAL = {
  fontSize: "12px",
  fontFamily: "sans-serif",
  fontWeight: "normal",
  fill: "black",
  background: "white",
  lineJoin: "round",
  stroke: "#ffffff",
  strokeThickness: 0
};
function drawText(HGC, trackInfo, tile, tm) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  const spec = tm.spec();
  const data2 = tm.data();
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const tcx = trackWidth / 2;
  const tcy = trackHeight / 2;
  const rowCategories = (_e = tm.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const dx = (_g = (_f = spec.style) == null ? void 0 : _f.dx) != null ? _g : 0;
  const dy = (_i = (_h = spec.style) == null ? void 0 : _h.dy) != null ? _i : 0;
  if (IsStackedMark(spec)) {
    if (circular) {
      return;
    }
    const rowGraphics = tile.graphics;
    const genomicChannel = tm.getGenomicChannel();
    if (!genomicChannel || !genomicChannel.field) {
      console.warn("Genomic field is not provided in the specification");
      return;
    }
    const pivotedData = group(data2, (d) => d[genomicChannel.field]);
    const xKeys = [...pivotedData.keys()];
    xKeys.forEach((k) => {
      var _a2;
      let prevYEnd = 0;
      (_a2 = pivotedData.get(k)) == null ? void 0 : _a2.forEach((d) => {
        var _a3, _b2, _c2, _d2, _e2, _f2, _g2, _h2;
        const text = tm.encodedPIXIProperty("text", d);
        const color2 = tm.encodedPIXIProperty("color", d);
        const x = tm.encodedPIXIProperty("x", d) + dx;
        const xe = tm.encodedPIXIProperty("xe", d) + dx;
        const cx = tm.encodedPIXIProperty("x-center", d) + dx;
        const y = tm.encodedPIXIProperty("y", d) + dy;
        const size = tm.encodedPIXIProperty("size", d);
        const stroke = tm.encodedPIXIProperty("stroke", d);
        const strokeWidth = tm.encodedPIXIProperty("strokeWidth", d);
        const opacity = tm.encodedPIXIProperty("opacity", d);
        if (cx < 0 || cx > trackWidth) {
          return;
        }
        if (trackInfo.textsBeingUsed > 1e3) {
          return;
        }
        const localTextStyle = {
          ...TEXT_STYLE_GLOBAL,
          fontSize: size != null ? size : ((_a3 = spec.style) == null ? void 0 : _a3.textFontSize) ? `${(_b2 = spec.style) == null ? void 0 : _b2.textFontSize}px` : TEXT_STYLE_GLOBAL.fontSize,
          stroke: (_d2 = stroke != null ? stroke : (_c2 = spec.style) == null ? void 0 : _c2.textStroke) != null ? _d2 : TEXT_STYLE_GLOBAL.stroke,
          strokeThickness: (_f2 = strokeWidth != null ? strokeWidth : (_e2 = spec.style) == null ? void 0 : _e2.textStrokeWidth) != null ? _f2 : TEXT_STYLE_GLOBAL.strokeThickness,
          fontWeight: (_h2 = (_g2 = spec.style) == null ? void 0 : _g2.textFontWeight) != null ? _h2 : TEXT_STYLE_GLOBAL.fontWeight
        };
        const textStyleObj = new HGC.libraries.PIXI.TextStyle(localTextStyle);
        let textGraphic;
        if (trackInfo.textGraphics.length > trackInfo.textsBeingUsed) {
          textGraphic = trackInfo.textGraphics[trackInfo.textsBeingUsed];
          textGraphic.style.fill = color2;
          textGraphic.visible = true;
          textGraphic.text = text;
          textGraphic.alpha = 1;
        } else {
          textGraphic = new HGC.libraries.PIXI.Text(text, {
            ...localTextStyle,
            fill: color2
          });
          trackInfo.textGraphics.push(textGraphic);
        }
        const metric = HGC.libraries.PIXI.TextMetrics.measureText(text, textStyleObj);
        trackInfo.textsBeingUsed++;
        const alphaTransition = tm.markVisibility(d, {
          ...metric,
          zoomLevel: trackInfo._xScale.invert(trackWidth) - trackInfo._xScale.invert(0)
        });
        const actualOpacity = Math.min(alphaTransition, opacity);
        if (!text || actualOpacity === 0) {
          trackInfo.textsBeingUsed--;
          textGraphic.visible = false;
          return;
        }
        textGraphic.alpha = actualOpacity;
        textGraphic.resolution = 8;
        textGraphic.updateText();
        textGraphic.texture.baseTexture.scaleMode = HGC.libraries.PIXI.SCALE_MODES.LINEAR;
        const sprite = new HGC.libraries.PIXI.Sprite(textGraphic.texture);
        sprite.x = x;
        sprite.y = rowHeight - y - prevYEnd;
        sprite.width = xe - x;
        sprite.height = y;
        rowGraphics.addChild(sprite);
        prevYEnd += y;
      });
    });
  } else {
    rowCategories.forEach((rowCategory) => {
      const rowGraphics = tile.graphics;
      const rowPosition = tm.encodedValue("row", rowCategory);
      data2.filter((d) => !getValueUsingChannel(d, spec.row) || getValueUsingChannel(d, spec.row) === rowCategory).forEach((d) => {
        var _a2, _b2, _c2, _d2, _e2, _f2, _g2, _h2, _i2, _j;
        const text = tm.encodedPIXIProperty("text", d);
        const color2 = tm.encodedPIXIProperty("color", d);
        const cx = tm.encodedPIXIProperty("x-center", d) + dx;
        const y = tm.encodedPIXIProperty("y", d) + dy;
        const size = tm.encodedPIXIProperty("size", d);
        const stroke = tm.encodedPIXIProperty("stroke", d);
        const strokeWidth = tm.encodedPIXIProperty("strokeWidth", d);
        const opacity = tm.encodedPIXIProperty("opacity", d);
        if (cx < 0 || cx > trackWidth) {
          return;
        }
        if (trackInfo.textsBeingUsed > 1e3) {
          return;
        }
        const localTextStyle = {
          ...TEXT_STYLE_GLOBAL,
          fontSize: size != null ? size : ((_a2 = spec.style) == null ? void 0 : _a2.textFontSize) ? `${(_b2 = spec.style) == null ? void 0 : _b2.textFontSize}px` : TEXT_STYLE_GLOBAL.fontSize,
          stroke: (_d2 = stroke != null ? stroke : (_c2 = spec.style) == null ? void 0 : _c2.textStroke) != null ? _d2 : TEXT_STYLE_GLOBAL.stroke,
          strokeThickness: (_f2 = strokeWidth != null ? strokeWidth : (_e2 = spec.style) == null ? void 0 : _e2.textStrokeWidth) != null ? _f2 : TEXT_STYLE_GLOBAL.strokeThickness,
          fontWeight: (_h2 = (_g2 = spec.style) == null ? void 0 : _g2.textFontWeight) != null ? _h2 : TEXT_STYLE_GLOBAL.fontWeight
        };
        const textStyleObj = new HGC.libraries.PIXI.TextStyle(localTextStyle);
        let textGraphic;
        if (trackInfo.textGraphics.length > trackInfo.textsBeingUsed) {
          textGraphic = trackInfo.textGraphics[trackInfo.textsBeingUsed];
          textGraphic.style.fill = color2;
          textGraphic.visible = true;
          textGraphic.text = text;
          textGraphic.alpha = 1;
        } else {
          textGraphic = new HGC.libraries.PIXI.Text(text, {
            ...localTextStyle,
            fill: color2
          });
          trackInfo.textGraphics.push(textGraphic);
        }
        const metric = HGC.libraries.PIXI.TextMetrics.measureText(text, textStyleObj);
        trackInfo.textsBeingUsed++;
        const alphaTransition = tm.markVisibility(d, {
          ...metric,
          zoomLevel: trackInfo._xScale.invert(trackWidth) - trackInfo._xScale.invert(0)
        });
        const actualOpacity = Math.min(alphaTransition, opacity);
        if (!text || actualOpacity === 0) {
          trackInfo.textsBeingUsed--;
          textGraphic.visible = false;
          return;
        }
        textGraphic.alpha = actualOpacity;
        textGraphic.anchor.x = !((_i2 = spec.style) == null ? void 0 : _i2.textAnchor) || ((_j = spec.style) == null ? void 0 : _j.textAnchor) === "middle" ? 0.5 : spec.style.textAnchor === "start" ? 0 : 1;
        textGraphic.anchor.y = 0.5;
        if (circular) {
          const r = trackOuterRadius - (rowPosition + rowHeight - y) / trackHeight * trackRingSize;
          const centerPos = cartesianToPolar(cx, trackWidth, r, tcx, tcy, startAngle, endAngle);
          textGraphic.x = centerPos.x;
          textGraphic.y = centerPos.y;
          textGraphic.resolution = 4;
          const txtStyle = new HGC.libraries.PIXI.TextStyle(textStyleObj);
          const metric2 = HGC.libraries.PIXI.TextMetrics.measureText(textGraphic.text, txtStyle);
          const tw = metric2.width / (2 * r * Math.PI) * trackWidth;
          let [minX, maxX] = [cx - tw / 2, cx + tw / 2];
          if (minX < 0) {
            const gap = -minX;
            minX = 0;
            maxX += gap;
          } else if (maxX > trackWidth) {
            const gap = maxX - trackWidth;
            maxX = trackWidth;
            minX -= gap;
          }
          const ropePoints = [];
          for (let i = maxX; i >= minX; i -= tw / 10) {
            const p = cartesianToPolar(i, trackWidth, r, tcx, tcy, startAngle, endAngle);
            ropePoints.push(new HGC.libraries.PIXI.Point(p.x, p.y));
          }
          textGraphic.updateText();
          const rope = new HGC.libraries.PIXI.SimpleRope(textGraphic.texture, ropePoints);
          rope.alpha = actualOpacity;
          rowGraphics.addChild(rope);
        } else {
          textGraphic.position.x = cx;
          textGraphic.position.y = rowPosition + rowHeight - y;
          rowGraphics.addChild(textGraphic);
        }
      });
    });
  }
}
function drawRule(HGC, trackInfo, tile, tm) {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  const spec = tm.spec();
  const data2 = tm.data();
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const cx = trackWidth / 2;
  const cy = trackHeight / 2;
  const rowCategories = (_e = tm.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const dashed = (_f = spec.style) == null ? void 0 : _f.dashed;
  const linePattern = (_g = spec.style) == null ? void 0 : _g.linePattern;
  const curved = (_h = spec.style) == null ? void 0 : _h.curve;
  const g = tile.graphics;
  rowCategories.forEach((rowCategory) => {
    const rowPosition = tm.encodedValue("row", rowCategory);
    data2.filter((d) => !getValueUsingChannel(d, spec.row) || getValueUsingChannel(d, spec.row) === rowCategory).forEach((d) => {
      const x = tm.encodedPIXIProperty("x", d);
      const xe = tm.encodedPIXIProperty("xe", d);
      const y = tm.encodedPIXIProperty("y", d);
      const color2 = tm.encodedPIXIProperty("color", d);
      const strokeWidth = tm.encodedPIXIProperty("strokeWidth", d);
      const opacity = tm.encodedPIXIProperty("opacity", d);
      const alphaTransition = tm.markVisibility(d, {
        width: xe - x,
        zoomLevel: trackInfo._xScale.invert(trackWidth) - trackInfo._xScale.invert(0)
      });
      const actualOpacity = Math.min(alphaTransition, opacity);
      g.lineStyle(strokeWidth, colorToHex(color2), actualOpacity, 0.5);
      if (!xe && (!spec.y || !("field" in spec.y))) {
        if (circular) {
          return;
        } else {
          if (dashed) {
            const [dashSize, gapSize] = dashed;
            let curPos = 0;
            do {
              g.moveTo(x, curPos);
              g.lineTo(x, curPos + dashSize);
              curPos += dashSize + gapSize;
            } while (curPos < trackHeight);
          } else {
            g.moveTo(x, 0);
            g.lineTo(x, trackHeight);
          }
        }
      } else if (!xe && y) {
        if (circular) {
          g.lineStyle(strokeWidth, colorToHex(color2), 0, 0.5);
          const midR = trackOuterRadius - (rowPosition + y) / trackHeight * trackRingSize;
          const farR = midR + strokeWidth / 2;
          const nearR = midR - strokeWidth / 2;
          const sPos = cartesianToPolar(0, trackWidth, nearR, cx, cy, startAngle, endAngle);
          const startRad = valueToRadian(0, trackWidth, startAngle, endAngle);
          const endRad = valueToRadian(trackWidth, trackWidth, startAngle, endAngle);
          g.beginFill(colorToHex(color2), actualOpacity);
          g.moveTo(sPos.x, sPos.y);
          g.arc(cx, cy, nearR, startRad, endRad, true);
          g.arc(cx, cy, farR, endRad, startRad, false);
          g.closePath();
        } else {
          if (dashed) {
            const [dashSize, gapSize] = dashed;
            let curPos = 0;
            do {
              g.moveTo(curPos, rowPosition + rowHeight - y);
              g.lineTo(curPos + dashSize, rowPosition + rowHeight - y);
              curPos += dashSize + gapSize;
            } while (curPos < trackWidth);
          } else {
            g.moveTo(0, rowPosition + rowHeight - y);
            g.lineTo(trackWidth, rowPosition + rowHeight - y);
          }
        }
      } else {
        if (circular) {
          if (strokeWidth === 0) {
            return;
          }
          g.lineStyle(strokeWidth, colorToHex(color2), 0, 0.5);
          const midR = trackOuterRadius - (rowPosition + y) / trackHeight * trackRingSize;
          const farR = midR + strokeWidth / 2;
          const nearR = midR - strokeWidth / 2;
          const sPos = cartesianToPolar(x, trackWidth, nearR, cx, cy, startAngle, endAngle);
          const startRad = valueToRadian(x, trackWidth, startAngle, endAngle);
          const endRad = valueToRadian(xe, trackWidth, startAngle, endAngle);
          g.beginFill(colorToHex(color2), actualOpacity);
          g.moveTo(sPos.x, sPos.y);
          g.arc(cx, cy, nearR, startRad, endRad, true);
          g.arc(cx, cy, farR, endRad, startRad, false);
          g.closePath();
        } else if (dashed) {
          const [dashSize, gapSize] = dashed;
          let curPos = x;
          do {
            g.moveTo(curPos, rowPosition + rowHeight - y);
            g.lineTo(curPos + dashSize, rowPosition + rowHeight - y);
            curPos += dashSize + gapSize;
          } while (curPos < xe);
        } else {
          if (curved === void 0) {
            g.moveTo(x, rowPosition + rowHeight - y);
            g.lineTo(xe, rowPosition + rowHeight - y);
          } else if (curved === "top") {
            const CURVE_HEIGHT = 2;
            const xm = x + (xe - x) / 2;
            g.moveTo(x, rowPosition + rowHeight - y + CURVE_HEIGHT / 2);
            g.lineTo(xm, rowPosition + rowHeight - y - CURVE_HEIGHT / 2);
            g.moveTo(xm, rowPosition + rowHeight - y - CURVE_HEIGHT / 2);
            g.lineTo(xe, rowPosition + rowHeight - y + CURVE_HEIGHT / 2);
          }
        }
        if (linePattern && curved === void 0 && !circular) {
          const { type: pType, size: pSize } = linePattern;
          let curPos = Math.max(x, 0);
          g.lineStyle(0);
          const PATTERN_GAP_SIZE = pSize * 2;
          let count2 = 0;
          while (curPos < Math.min(xe, trackWidth) && count2 < 100) {
            const x0 = curPos;
            const x1 = curPos + pSize;
            const ym = rowPosition + rowHeight - y;
            const y0 = ym - pSize / 2;
            const y1 = ym + pSize / 2;
            g.beginFill(colorToHex(color2), actualOpacity);
            g.drawPolygon(pType === "triangleLeft" ? [x1, y0, x0, ym, x1, y1, x1, y0] : [x0, y0, x1, ym, x0, y1, x0, y0]);
            g.endFill();
            curPos += pSize + PATTERN_GAP_SIZE;
            count2++;
          }
        }
      }
    });
  });
}
function drawLink(g, trackInfo, model) {
  var _a, _b, _c, _d, _e;
  const spec = model.spec();
  if (!spec.width || !spec.height) {
    console.warn("Size of a track is not properly determined, so visual mark cannot be rendered");
    return;
  }
  const data2 = model.data();
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const circular = spec.layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const tcx = trackWidth / 2;
  const tcy = trackHeight / 2;
  const rowCategories = (_e = model.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  rowCategories.forEach((rowCategory) => {
    const rowPosition = model.encodedValue("row", rowCategory);
    data2.filter((d) => !getValueUsingChannel(d, spec.row) || getValueUsingChannel(d, spec.row) === rowCategory).forEach((d) => {
      var _a2, _b2, _c2, _d2, _e2;
      let x = model.encodedPIXIProperty("x", d);
      let xe = model.encodedPIXIProperty("xe", d);
      let x1 = model.encodedPIXIProperty("x1", d);
      let x1e = model.encodedPIXIProperty("x1e", d);
      const y = model.encodedPIXIProperty("y", d);
      const stroke = model.encodedPIXIProperty("stroke", d);
      const strokeWidth = model.encodedPIXIProperty("strokeWidth", d);
      const color2 = model.encodedPIXIProperty("color", d);
      const opacity = model.encodedPIXIProperty("opacity", d);
      if (typeof xe !== "undefined") {
        [x, xe] = [x, xe].sort((a, b) => a - b);
      }
      if (typeof x1 !== "undefined" && typeof x1e !== "undefined") {
        [x1, x1e] = [x1, x1e].sort((a, b) => a - b);
      }
      const isBand = typeof xe !== "undefined" && typeof x1 !== "undefined" && typeof x1e !== "undefined" && Math.abs(x - xe) > 0.1 && Math.abs(x1 - x1e) > 0.1;
      if (!isBand && xe === void 0 && !Is2DTrack(spec)) {
        if (x1 === void 0 && x1e === void 0) {
          return;
        }
        xe = x1 !== void 0 ? x1 : x1e;
      }
      if (!isBand && Math.abs(x - xe) <= 0.1 && Math.abs(x1 - x1e) <= 0.1) {
        x = (x + xe) / 2;
        xe = (x1 + x1e) / 2;
      }
      g.lineStyle(strokeWidth, colorToHex(stroke), opacity, 0.5);
      const flipY = IsChannelDeep(spec.y) && spec.y.flip || spec.flipY;
      const baseY = rowPosition + (flipY ? 0 : rowHeight);
      if (isBand) {
        g.beginFill(color2 === "none" ? colorToHex("white") : colorToHex(color2), color2 === "none" ? 0 : opacity);
        let [_x1, _x2, _x3, _x4] = [x, xe, x1, x1e];
        if (spec.mark === "betweenLink") {
          [_x1, _x2] = [_x1, _x2].sort((a, b) => a - b);
          [_x3, _x4] = [_x3, _x4].sort((a, b) => a - b);
        } else {
          [_x1, _x2, _x3, _x4] = [_x1, _x2, _x3, _x4].sort((a, b) => a - b);
        }
        if (_x1 > trackWidth || _x4 < 0 || Math.abs(_x4 - _x1) < 0.5) {
          return;
        }
        if (circular) {
          if (_x1 < 0 || _x4 > trackWidth) {
            return;
          }
          const r = trackOuterRadius - rowPosition / trackHeight * trackRingSize;
          const posX = cartesianToPolar(_x1, trackWidth, r, tcx, tcy, startAngle, endAngle);
          const posXE = cartesianToPolar(_x2, trackWidth, r, tcx, tcy, startAngle, endAngle);
          const posX1 = cartesianToPolar(_x3, trackWidth, r, tcx, tcy, startAngle, endAngle);
          const posX1E = cartesianToPolar(_x4, trackWidth, r, tcx, tcy, startAngle, endAngle);
          g.moveTo(posX.x, posX.y);
          g.bezierCurveTo(tcx, tcy, tcx, tcy, posX1E.x, posX1E.y);
          g.arc(tcx, tcy, trackOuterRadius, positionToRadian(posX1E.x, posX1E.y, tcx, tcy), positionToRadian(posX1.x, posX1.y, tcx, tcy), false);
          g.bezierCurveTo(tcx, tcy, tcx, tcy, posXE.x, posXE.y);
          g.arc(tcx, tcy, trackOuterRadius, positionToRadian(posXE.x, posXE.y, tcx, tcy), positionToRadian(posX.x, posX.y, tcx, tcy), false);
          g.endFill();
        } else {
          if (spec.mark === "betweenLink") {
            g.moveTo(_x1, rowPosition);
            g.lineTo(_x2, rowPosition);
            g.lineTo(_x4, rowPosition + rowHeight);
            g.lineTo(_x3, rowPosition + rowHeight);
            g.lineTo(_x1, rowPosition);
            g.closePath();
            return;
          }
          g.moveTo(_x1, baseY);
          if (!((_a2 = spec.style) == null ? void 0 : _a2.bezierLink)) {
            g.arc((_x1 + _x4) / 2, baseY, (_x4 - _x1) / 2, -Math.PI, Math.PI, false);
            g.arc((_x2 + _x3) / 2, baseY, (_x3 - _x2) / 2, Math.PI, -Math.PI, true);
            g.closePath();
          } else {
            g.lineTo(_x3, rowPosition + rowHeight);
            g.bezierCurveTo(_x3 + (_x2 - _x3) / 3, rowPosition + rowHeight - (_x2 - _x3) / 2, _x3 + (_x2 - _x3) / 3 * 2, rowPosition + rowHeight - (_x2 - _x3) / 2, _x2, rowPosition + rowHeight);
            g.lineTo(_x4, rowPosition + rowHeight);
            g.bezierCurveTo(_x1 + (_x4 - _x1) / 3 * 2, rowPosition + rowHeight - (_x4 - _x1) / 2, _x1 + (_x4 - _x1) / 3, rowPosition + rowHeight - (_x4 - _x1) / 2, _x1, rowPosition + rowHeight);
            g.endFill();
          }
        }
      } else {
        if (Is2DTrack(spec) && spec.mark === "betweenLink") {
          if (((_b2 = spec.style) == null ? void 0 : _b2.linkConnectionType) === "curve") {
            g.moveTo(x, 0);
            g.bezierCurveTo(x / 5 * 4, (rowPosition + rowHeight - y) / 2, x / 2, (rowPosition + rowHeight - y) / 5 * 4, 0, rowPosition + rowHeight - y);
          } else if (((_c2 = spec.style) == null ? void 0 : _c2.linkConnectionType) === "straight") {
            g.moveTo(x, 0);
            g.lineTo(0, rowPosition + rowHeight - y);
          } else {
            g.moveTo(x, 0);
            g.lineTo(x, rowPosition + rowHeight - y);
            g.lineTo(0, rowPosition + rowHeight - y);
          }
          return;
        }
        if (spec.mark === "betweenLink" && circular) {
          let prevX, prevY;
          for (let t = 0; t <= 1; t += 0.02) {
            const logodds = (t2) => Math.log(t2 / (1 - t2));
            const movingRadius = (t2) => trackOuterRadius - 1 / (1 + Math.exp(logodds(t2))) * trackRingSize + 3;
            const getRadian = (t2, s, e) => ((e - s) * t2 + s) / trackWidth;
            const _x = tcx + movingRadius(t) * Math.cos(-getRadian(t, x, xe) * 2 * Math.PI - Math.PI / 2);
            const _y = tcy + movingRadius(t) * Math.sin(-getRadian(t, x, xe) * 2 * Math.PI - Math.PI / 2);
            if (prevX && prevY) {
              g.lineStyle(strokeWidth, colorToHex(stroke), opacity, 0.5);
              g.moveTo(prevX, prevY);
              g.lineTo(_x, _y);
            }
            prevX = _x;
            prevY = _y;
          }
          return;
        }
        if (spec.mark === "betweenLink") {
          g.moveTo(xe, rowPosition + rowHeight);
          g.lineTo(x, rowPosition);
          return;
        }
        const midX = (x + xe) / 2;
        g.beginFill(colorToHex("white"), 0);
        if (circular) {
          if (x < 0 || xe > trackWidth) {
            return;
          }
          const r = trackOuterRadius - rowPosition / trackHeight * trackRingSize;
          const posS = cartesianToPolar(x, trackWidth, r, tcx, tcy, startAngle, endAngle);
          const posE = cartesianToPolar(xe, trackWidth, r, tcx, tcy, startAngle, endAngle);
          const x12 = posS.x;
          const y1 = posS.y;
          const x2 = posS.x;
          const y2 = posS.y;
          const x3 = trackWidth / 2;
          const y3 = trackHeight / 2;
          const x4 = posE.x;
          const y4 = posE.y;
          g.moveTo(x12, y1);
          const bezier = new Bezier(x12, y1, x2, y2, x3, y3, x4, y4);
          const points = bezier.getLUT(14);
          points.forEach((d2) => g.lineTo(d2.x, d2.y));
          const morePoints = bezier.getLUT(1e3);
          if (spec.tooltip) {
            trackInfo.tooltips.push({
              datum: d,
              isMouseOver: (mouseX, mouseY) => morePoints.findIndex((d2) => Math.sqrt((d2.x - mouseX) ** 2 + (d2.y - mouseY) ** 2) < 5) !== -1,
              markInfo: {}
            });
          }
        } else {
          g.moveTo(x, baseY);
          if ((_d2 = spec.style) == null ? void 0 : _d2.bezierLink) {
            const x12 = x;
            const y1 = baseY;
            const x2 = x + (xe - x) / 3;
            const y2 = baseY + Math.max(rowHeight / 2, Math.min(rowHeight, (xe - x) / 2)) * (flipY ? 1 : -1);
            const x3 = x + (xe - x) / 3 * 2;
            const y3 = baseY + Math.max(rowHeight / 2, Math.min(rowHeight, (xe - x) / 2)) * (flipY ? 1 : -1);
            const x4 = xe;
            const y4 = baseY;
            const bezier = new Bezier(x12, y1, x2, y2, x3, y3, x4, y4);
            const points = bezier.getLUT(14);
            points.forEach((d2) => g.lineTo(d2.x, d2.y));
            const morePoints = bezier.getLUT(1e3);
            if (spec.tooltip) {
              trackInfo.tooltips.push({
                datum: d,
                isMouseOver: (mouseX, mouseY) => morePoints.findIndex((d2) => Math.sqrt((d2.x - mouseX) ** 2 + (d2.y - mouseY) ** 2) < 5) !== -1,
                markInfo: {}
              });
            }
          } else if ((_e2 = spec.style) == null ? void 0 : _e2.flatWithinLink) {
            const arcWidth = xe - x;
            const radius = Math.min(10, arcWidth / 2);
            const topY = rowPosition + rowHeight - y;
            if (flipY) {
              g.moveTo(x, baseY);
              g.lineTo(x, topY - radius);
              g.arc(x + radius, topY - radius, radius, -Math.PI, Math.PI / 2, true);
              g.lineTo(xe - radius, topY);
              g.arc(xe - radius, topY - radius, radius, Math.PI / 2, 0, true);
              g.lineTo(xe, baseY);
            } else {
              g.moveTo(x, baseY);
              g.lineTo(x, topY + radius);
              g.arc(x + radius, topY + radius, radius, -Math.PI, -Math.PI / 2);
              g.lineTo(xe - radius, topY);
              g.arc(xe - radius, topY + radius, radius, -Math.PI / 2, 0);
              g.lineTo(xe, baseY);
            }
          } else {
            if (xe < 0 || x > trackWidth) {
              return;
            }
            g.arc(midX, baseY, (xe - x) / 2, -Math.PI, Math.PI);
            g.closePath();
          }
        }
      }
    });
  });
}
function drawGrid(trackInfo, tm, theme) {
  drawYGridQuantitative(trackInfo, tm, theme);
  drawRowGrid(trackInfo, tm, theme);
}
function drawRowGrid(trackInfo, tm, theme) {
  var _a, _b, _c, _d;
  const spec = tm.spec();
  if (!IsChannelDeep(spec.row) || spec.row.grid !== true) {
    return;
  }
  const [trackX, trackY] = trackInfo.position;
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const circular = tm.spec().layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const cx = trackWidth / 2;
  const cy = trackHeight / 2;
  const rowCategories = tm.getChannelDomainArray("row");
  if (!rowCategories) {
    return;
  }
  const rowHeight = trackHeight / rowCategories.length;
  if (circular && trackRingSize <= 20 || !circular && rowHeight <= 20) {
    return;
  }
  const graphics = trackInfo.pBackground;
  const strokeWidth = theme.axis.gridStrokeWidth;
  rowCategories.forEach((rowCategory) => {
    const rowPosition = tm.encodedValue("row", rowCategory);
    if (!circular) {
      graphics.lineStyle(strokeWidth, colorToHex(theme.axis.gridColor), 1, 0.5);
      const y = trackY + rowPosition + rowHeight / 2;
      graphics.moveTo(trackX, y);
      graphics.lineTo(trackX + trackWidth, y);
    } else {
      const y = rowPosition + rowHeight / 2;
      const midR = trackOuterRadius - y / trackHeight * trackRingSize;
      const farR = midR + strokeWidth / 2;
      const nearR = midR - strokeWidth / 2;
      const sPos = cartesianToPolar(0, trackWidth, nearR, cx, cy, startAngle, endAngle);
      const startRad = valueToRadian(0, trackWidth, startAngle, endAngle);
      const endRad = valueToRadian(trackWidth, trackWidth, startAngle, endAngle);
      graphics.lineStyle(strokeWidth, colorToHex("black"), 0, 0.5);
      graphics.beginFill(colorToHex(theme.axis.gridColor), 1);
      graphics.moveTo(trackX + sPos.x, trackY + sPos.y);
      graphics.arc(trackX + cx, trackY + cy, nearR, startRad, endRad, true);
      graphics.arc(trackX + cx, trackY + cy, farR, endRad, startRad, false);
      graphics.closePath();
    }
  });
}
function drawYGridQuantitative(trackInfo, tm, theme) {
  var _a, _b, _c, _d, _e;
  const spec = tm.spec();
  if (!IsChannelDeep(spec.y) || spec.y.grid !== true) {
    return;
  }
  const [trackX, trackY] = trackInfo.position;
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const startX = trackX;
  const endX = trackX + trackWidth;
  const circular = tm.spec().layout === "circular";
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const cx = trackWidth / 2;
  const cy = trackHeight / 2;
  const rowCategories = (_e = tm.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = trackHeight / rowCategories.length;
  const scale = tm.getChannelScale("y");
  const domain = tm.getChannelDomainArray("y");
  if (!scale || !domain) {
    return;
  }
  if (circular && rowHeight / trackHeight * trackRingSize <= 20 || !circular && rowHeight <= 20) {
    return;
  }
  const graphics = trackInfo.pBackground;
  const strokeWidth = theme.axis.gridStrokeWidth;
  rowCategories.forEach((rowCategory) => {
    const rowPosition = tm.encodedValue("row", rowCategory);
    const assignedHeight = circular ? rowHeight / trackHeight * trackRingSize : rowHeight;
    const tickCount = Math.max(Math.ceil(assignedHeight / 40), 1);
    let ticks = scale.ticks(tickCount).filter((v) => domain[0] <= v && v <= domain[1]);
    if (ticks.length === 1) {
      ticks = scale.ticks(tickCount + 1).filter((v) => domain[0] <= v && v <= domain[1]);
    }
    if (!circular) {
      graphics.lineStyle(strokeWidth, colorToHex(theme.axis.gridColor), 1, 0.5);
      ticks.forEach((value) => {
        var _a2;
        const y = trackY + rowPosition + rowHeight - scale(value);
        if (theme.axis.gridStrokeType === "solid") {
          graphics.moveTo(startX, y);
          graphics.lineTo(endX, y);
        } else if (theme.axis.gridStrokeType === "dashed") {
          const [line, gap] = (_a2 = theme.axis.gridStrokeDash) != null ? _a2 : [1, 1];
          for (let i = startX; i < endX; i += line + gap) {
            graphics.moveTo(i, y);
            graphics.lineTo(i + line, y);
          }
        }
      });
    } else {
      ticks.forEach((value) => {
        const y = scale(value);
        const midR = trackOuterRadius - (rowPosition + rowHeight - y) / trackHeight * trackRingSize;
        const farR = midR + strokeWidth / 2;
        const nearR = midR - strokeWidth / 2;
        const sPos = cartesianToPolar(0, trackWidth, nearR, cx, cy, startAngle, endAngle);
        const startRad = valueToRadian(0, trackWidth, startAngle, endAngle);
        const endRad = valueToRadian(trackWidth, trackWidth, startAngle, endAngle);
        graphics.lineStyle(strokeWidth, colorToHex("black"), 0, 0.5);
        graphics.beginFill(colorToHex(theme.axis.gridColor), 1);
        graphics.moveTo(trackX + sPos.x, trackY + sPos.y);
        graphics.arc(trackX + cx, trackY + cy, nearR, startRad, endRad, true);
        graphics.arc(trackX + cx, trackY + cy, farR, endRad, startRad, false);
        graphics.closePath();
      });
    }
  });
}
const DEFAULT_TEXT_STYLE = {
  color: "black",
  size: 10,
  fontFamily: "Arial",
  fontWeight: "normal",
  stroke: "#ffffff",
  strokeThickness: 0
};
function getTextStyle(style = DEFAULT_TEXT_STYLE) {
  var _a, _b, _c, _d, _e, _f;
  return {
    fontSize: `${(_a = style.size) != null ? _a : DEFAULT_TEXT_STYLE.size}px`,
    fontFamily: (_b = style.fontFamily) != null ? _b : DEFAULT_TEXT_STYLE.fontFamily,
    fontWeight: (_c = style.fontWeight) != null ? _c : DEFAULT_TEXT_STYLE.fontWeight,
    fill: (_d = style.color) != null ? _d : DEFAULT_TEXT_STYLE.color,
    background: "white",
    lineJoin: "round",
    stroke: (_e = style.stroke) != null ? _e : DEFAULT_TEXT_STYLE.stroke,
    strokeThickness: (_f = style.strokeThickness) != null ? _f : DEFAULT_TEXT_STYLE.strokeThickness
  };
}
function drawCircularTitle(HGC, trackInfo, tile, gos, theme) {
  var _a, _b, _c;
  const spec = gos.spec();
  const { title: title2 } = spec;
  if (spec.layout !== "circular") {
    return;
  }
  if (!title2) {
    return;
  }
  const [tw, th] = trackInfo.dimensions;
  const trackOuterRadius = (_a = spec.outerRadius) != null ? _a : 300;
  const startAngle = (_b = spec.startAngle) != null ? _b : 0;
  const endAngle = (_c = spec.endAngle) != null ? _c : 360;
  const cx = tw / 2;
  const cy = th / 2;
  const g = tile.graphics;
  const titleR = trackOuterRadius - 1;
  const padding = 1;
  const pos = cartesianToPolar(padding, tw, titleR, cx, cy, startAngle, endAngle);
  const styleConfig = getTextStyle({
    color: theme.track.titleColor,
    size: 12,
    fontFamily: theme.axis.labelFontFamily,
    fontWeight: theme.axis.labelFontWeight
  });
  const textGraphic = new HGC.libraries.PIXI.Text(title2, styleConfig);
  textGraphic.anchor.x = 1;
  textGraphic.anchor.y = 0.5;
  textGraphic.position.x = pos.x;
  textGraphic.position.y = pos.y;
  textGraphic.resolution = 4;
  const txtStyle = new HGC.libraries.PIXI.TextStyle(styleConfig);
  const metric = HGC.libraries.PIXI.TextMetrics.measureText(textGraphic.text, txtStyle);
  const txtWidth = metric.width / (2 * titleR * Math.PI) * tw * 360 / (endAngle - startAngle);
  const scaledStartX = padding;
  const scaledEndX = padding + txtWidth;
  const ropePoints = [];
  for (let i = scaledEndX; i >= scaledStartX; i -= txtWidth / 10) {
    const p = cartesianToPolar(i, tw, titleR - metric.height / 2, cx, cy, startAngle, endAngle);
    ropePoints.push(new HGC.libraries.PIXI.Point(p.x, p.y));
  }
  const startRad = valueToRadian(scaledStartX, tw, startAngle, endAngle);
  const endRad = valueToRadian(scaledEndX + padding, tw, startAngle, endAngle);
  g.lineStyle(1, colorToHex("red"), 0, 0.5);
  g.beginFill(colorToHex(theme.track.titleBackground), 0.5);
  g.moveTo(pos.x, pos.y);
  g.arc(cx, cy, titleR - metric.height, startRad, endRad, true);
  g.arc(cx, cy, titleR, endRad, startRad, false);
  g.closePath();
  textGraphic.updateText();
  const rope = new HGC.libraries.PIXI.SimpleRope(textGraphic.texture, ropePoints);
  g.addChild(rope);
}
function drawChartOutlines(HGC, trackInfo, tm, theme) {
  var _a, _b, _c, _d;
  const g = trackInfo.pBorder;
  const [l, t] = trackInfo.position;
  const [w, h] = trackInfo.dimensions;
  g.lineStyle((_b = (_a = tm.spec().style) == null ? void 0 : _a.outlineWidth) != null ? _b : 1, colorToHex((_d = (_c = tm.spec().style) == null ? void 0 : _c.outline) != null ? _d : theme.track.outline), 1, 0.5);
  g.beginFill(colorToHex("white"), 0);
  g.drawRect(l, t, w, h);
  const x = tm.spec().x;
  g.lineStyle(1, colorToHex(theme.axis.baselineColor), 1, 0.5);
  if (IsChannelDeep(x) && x.axis === "top") {
    g.moveTo(l, t);
    g.lineTo(l + w, t);
  } else if (IsChannelDeep(x) && x.axis === "bottom") {
    g.moveTo(l, t + h);
    g.lineTo(l + w, t + h);
  }
}
function drawColorLegend(HGC, trackInfo, tile, tm, theme) {
  const spec = tm.spec();
  if (!IsChannelDeep(spec.color) || !spec.color.legend) {
    return;
  }
  switch (spec.color.type) {
    case "nominal":
      drawColorLegendCategories(HGC, trackInfo, tile, tm, theme);
      break;
    case "quantitative":
      drawColorLegendQuantitative(HGC, trackInfo, tile, tm, theme);
      break;
  }
}
function drawColorLegendQuantitative(HGC, trackInfo, tile, tm, theme) {
  const spec = tm.spec();
  if (!IsChannelDeep(spec.color) || spec.color.type !== "quantitative" || !spec.color.legend) {
    return;
  }
  const [trackX, trackY] = trackInfo.position;
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const legendWidth = 80;
  const legendHeight = trackHeight - 2 > 110 ? 110 : Math.max(trackHeight - 2, 40 - 2);
  const colorBarDim = {
    top: 10,
    left: 55,
    width: 20,
    height: legendHeight - 20
  };
  const legendX = trackX + trackWidth - legendWidth - 1;
  const legendY = trackY + 1;
  const colorScale = tm.getChannelScale("color");
  const colorDomain = tm.getChannelDomainArray("color");
  if (!colorScale || !colorDomain) {
    return;
  }
  const graphics = trackInfo.pBorder;
  graphics.beginFill(colorToHex(theme.legend.background), theme.legend.backgroundOpacity);
  graphics.lineStyle(1, colorToHex(theme.legend.backgroundStroke), theme.legend.backgroundOpacity, 0);
  graphics.drawRect(legendX, legendY, legendWidth, legendHeight);
  const [startValue, endValue] = colorDomain;
  const extent = endValue - startValue;
  [...Array(colorBarDim.height).keys()].forEach((y) => {
    const value = (colorBarDim.height - y) / colorBarDim.height * extent + startValue;
    graphics.beginFill(colorToHex(colorScale(value)), 1);
    graphics.lineStyle(1, colorToHex(theme.legend.backgroundStroke), 0, 0.5);
    graphics.drawRect(legendX + colorBarDim.left, legendY + colorBarDim.top + y, colorBarDim.width, 1);
  });
  const tickCount = Math.max(Math.ceil(colorBarDim.height / 30), 2);
  let ticks = colorScale.ticks(tickCount).filter((v) => colorDomain[0] <= v && v <= colorDomain[1]);
  if (ticks.length === 1) {
    ticks = colorScale.ticks(tickCount + 1).filter((v) => colorDomain[0] <= v && v <= colorDomain[1]);
  }
  const TICK_STROKE_SIZE = 1;
  graphics.lineStyle(TICK_STROKE_SIZE, colorToHex(theme.legend.tickColor), 1, 0.5);
  const labelTextStyle = getTextStyle({
    color: theme.legend.labelColor,
    size: theme.legend.labelFontSize,
    fontWeight: theme.legend.labelFontWeight,
    fontFamily: theme.legend.labelFontFamily
  });
  const tickEnd = legendX + colorBarDim.left;
  ticks.forEach((value) => {
    let y = legendY + colorBarDim.top + colorBarDim.height - (value - startValue) / extent * colorBarDim.height;
    if (y === legendY + colorBarDim.top) {
      y += TICK_STROKE_SIZE / 2;
    } else if (y === legendY + colorBarDim.top + colorBarDim.height) {
      y -= TICK_STROKE_SIZE / 2;
    }
    graphics.moveTo(tickEnd - 3, y);
    graphics.lineTo(tickEnd, y);
    const textGraphic = new HGC.libraries.PIXI.Text(value, labelTextStyle);
    textGraphic.anchor.x = 1;
    textGraphic.anchor.y = 0.5;
    textGraphic.position.x = tickEnd - 6;
    textGraphic.position.y = y;
    graphics.addChild(textGraphic);
  });
}
function drawColorLegendCategories(HGC, trackInfo, tile, tm, theme) {
  var _a, _b, _c, _d, _e;
  const spec = tm.spec();
  if (!IsChannelDeep(spec.color) || spec.color.type !== "nominal" || !spec.color.legend) {
    return;
  }
  const colorCategories = (_a = tm.getChannelDomainArray("color")) != null ? _a : ["___SINGLE_COLOR___"];
  if (colorCategories.length === 0) {
    return;
  }
  const graphics = trackInfo.pBorder;
  const paddingX = 10;
  const paddingY = 4;
  let cumY = paddingY;
  let maxWidth = 0;
  const recipe = [];
  const labelTextStyle = getTextStyle({
    color: theme.legend.labelColor,
    size: theme.legend.labelFontSize,
    fontWeight: theme.legend.labelFontWeight,
    fontFamily: theme.legend.labelFontFamily
  });
  if ((_b = spec.style) == null ? void 0 : _b.inlineLegend) {
    colorCategories.map((d) => d).reverse().forEach((category) => {
      if (maxWidth > trackInfo.dimensions[0]) {
        return;
      }
      const color2 = tm.encodedValue("color", category);
      const textGraphic = new HGC.libraries.PIXI.Text(category, labelTextStyle);
      textGraphic.anchor.x = 1;
      textGraphic.anchor.y = 0;
      textGraphic.position.x = trackInfo.position[0] + trackInfo.dimensions[0] - maxWidth - paddingX;
      textGraphic.position.y = trackInfo.position[1] + paddingY;
      graphics.addChild(textGraphic);
      const textStyleObj = new HGC.libraries.PIXI.TextStyle(labelTextStyle);
      const textMetrics = HGC.libraries.PIXI.TextMetrics.measureText(category, textStyleObj);
      if (cumY < textMetrics.height + paddingY * 3) {
        cumY = textMetrics.height + paddingY * 3;
      }
      recipe.push({
        x: trackInfo.position[0] + trackInfo.dimensions[0] - textMetrics.width - maxWidth - paddingX * 2,
        y: trackInfo.position[1] + paddingY + textMetrics.height / 2,
        color: color2
      });
      maxWidth += textMetrics.width + paddingX * 3;
    });
  } else {
    if ((_c = spec.style) == null ? void 0 : _c.legendTitle) {
      const textGraphic = new HGC.libraries.PIXI.Text((_d = spec.style) == null ? void 0 : _d.legendTitle, {
        ...labelTextStyle,
        fontWeight: "bold"
      });
      textGraphic.anchor.x = 1;
      textGraphic.anchor.y = 0;
      textGraphic.position.x = trackInfo.position[0] + trackInfo.dimensions[0] - paddingX;
      textGraphic.position.y = trackInfo.position[1] + cumY;
      const textStyleObj = new HGC.libraries.PIXI.TextStyle({ ...labelTextStyle, fontWeight: "bold" });
      const textMetrics = HGC.libraries.PIXI.TextMetrics.measureText((_e = spec.style) == null ? void 0 : _e.legendTitle, textStyleObj);
      graphics.addChild(textGraphic);
      cumY += textMetrics.height + paddingY * 2;
    }
    colorCategories.forEach((category) => {
      if (cumY > trackInfo.dimensions[1]) {
        return;
      }
      const color2 = tm.encodedValue("color", category);
      const textGraphic = new HGC.libraries.PIXI.Text(category, labelTextStyle);
      textGraphic.anchor.x = 1;
      textGraphic.anchor.y = 0;
      textGraphic.position.x = trackInfo.position[0] + trackInfo.dimensions[0] - paddingX;
      textGraphic.position.y = trackInfo.position[1] + cumY;
      graphics.addChild(textGraphic);
      const textStyleObj = new HGC.libraries.PIXI.TextStyle(labelTextStyle);
      const textMetrics = HGC.libraries.PIXI.TextMetrics.measureText(category, textStyleObj);
      if (maxWidth < textMetrics.width + paddingX * 3) {
        maxWidth = textMetrics.width + paddingX * 3;
      }
      recipe.push({
        x: trackInfo.position[0] + trackInfo.dimensions[0] - textMetrics.width - paddingX * 2,
        y: trackInfo.position[1] + cumY + textMetrics.height / 2,
        color: color2
      });
      cumY += textMetrics.height + paddingY * 2;
    });
  }
  graphics.beginFill(colorToHex(theme.legend.background), theme.legend.backgroundOpacity);
  graphics.lineStyle(1, colorToHex(theme.legend.backgroundStroke), theme.legend.backgroundOpacity, 0);
  graphics.drawRect(trackInfo.position[0] + trackInfo.dimensions[0] - maxWidth - 1, trackInfo.position[1] + 1, maxWidth, cumY - paddingY);
  recipe.forEach((r) => {
    graphics.lineStyle(1, colorToHex("black"), 0, 0);
    graphics.beginFill(colorToHex(r.color), 1);
    graphics.drawCircle(r.x, r.y, 4);
  });
}
function drawRowLegend(HGC, trackInfo, tile, tm, theme) {
  var _a;
  const spec = tm.spec();
  if (!IsChannelDeep(spec.row) || spec.row.type !== "nominal" || !spec.row.legend) {
    return;
  }
  const rowCategories = (_a = tm.getChannelDomainArray("row")) != null ? _a : ["___SINGLE_ROW___"];
  if (rowCategories.length === 0) {
    return;
  }
  const graphics = trackInfo.pBorder;
  const paddingX = 4;
  const paddingY = 2;
  const labelTextStyle = getTextStyle({
    color: theme.legend.labelColor,
    size: theme.legend.labelFontSize,
    fontWeight: theme.legend.labelFontWeight,
    fontFamily: theme.legend.labelFontFamily
  });
  rowCategories.forEach((category) => {
    const rowPosition = tm.encodedValue("row", category);
    const textGraphic = new HGC.libraries.PIXI.Text(category, labelTextStyle);
    textGraphic.anchor.x = 0;
    textGraphic.anchor.y = 0;
    textGraphic.position.x = trackInfo.position[0] + paddingX;
    textGraphic.position.y = trackInfo.position[1] + rowPosition + paddingY;
    graphics.addChild(textGraphic);
    const textStyleObj = new HGC.libraries.PIXI.TextStyle(labelTextStyle);
    const textMetrics = HGC.libraries.PIXI.TextMetrics.measureText(category, textStyleObj);
    graphics.beginFill(colorToHex(theme.legend.background), theme.legend.backgroundOpacity);
    graphics.lineStyle(1, colorToHex(theme.legend.backgroundStroke), 0, 0);
    graphics.drawRect(trackInfo.position[0] + 1, trackInfo.position[1] + rowPosition + 1, textMetrics.width + paddingX * 2, textMetrics.height + paddingY * 2);
  });
}
const EXTENT_TICK_SIZE = 8;
const TICK_SIZE = 6;
function drawLinearYAxis(HGC, trackInfo, tile, gos, theme) {
  var _a;
  const spec = gos.spec();
  const CIRCULAR = spec.layout === "circular";
  const yDomain = gos.getChannelDomainArray("y");
  const yRange = gos.getChannelRangeArray("y");
  if (CIRCULAR) {
    return;
  }
  if (!gos.isShowYAxis() || !yDomain || !yRange) {
    return;
  }
  const [tw, th] = trackInfo.dimensions;
  const [tx, ty] = trackInfo.position;
  const rowCategories = (_a = gos.getChannelDomainArray("row")) != null ? _a : ["___SINGLE_ROW___"];
  const rowHeight = th / rowCategories.length;
  if (rowHeight <= 20) {
    return;
  }
  const yChannel = gos.spec().y;
  const isLeft = IsChannelDeep(yChannel) && "axis" in yChannel && yChannel.axis === "right" ? false : true;
  const yScale = linear_linear().domain(yDomain).range(yRange);
  const graphics = trackInfo.pBorder;
  rowCategories.forEach((category) => {
    const rowPosition = gos.encodedValue("row", category);
    const dx = isLeft ? tx : tx + tw;
    const dy = ty + rowPosition;
    graphics.lineStyle(1, colorToHex(theme.axis.baselineColor), 1, 0.5);
    graphics.moveTo(dx, dy);
    graphics.lineTo(dx, dy + rowHeight);
    const tickCount = Math.max(Math.ceil(rowHeight / 40), 1);
    let ticks = yScale.ticks(tickCount).filter((v) => yDomain[0] <= v && v <= yDomain[1]);
    if (ticks.length === 1) {
      ticks = yScale.ticks(tickCount + 1).filter((v) => yDomain[0] <= v && v <= yDomain[1]);
    }
    graphics.lineStyle(1, colorToHex(theme.axis.tickColor), 1, 0.5);
    let tickEnd = isLeft ? dx + TICK_SIZE : dx - TICK_SIZE;
    ticks.forEach((t) => {
      const y = yScale(t);
      graphics.moveTo(dx, dy + rowHeight - y);
      graphics.lineTo(tickEnd, dy + rowHeight - y);
    });
    tickEnd = isLeft ? dx + EXTENT_TICK_SIZE : dx - EXTENT_TICK_SIZE;
    graphics.moveTo(dx, dy);
    graphics.lineTo(tickEnd, dy);
    graphics.moveTo(dx, dy + rowHeight);
    graphics.lineTo(tickEnd, dy + rowHeight);
    const styleConfig = getTextStyle({
      color: theme.axis.labelColor,
      size: theme.axis.labelFontSize,
      fontFamily: theme.axis.labelFontFamily,
      fontWeight: theme.axis.labelFontWeight
    });
    ticks.forEach((t) => {
      const y = yScale(t);
      tickEnd = isLeft ? dx + TICK_SIZE * 2 : dx - TICK_SIZE * 2;
      const textGraphic = new HGC.libraries.PIXI.Text(t, styleConfig);
      textGraphic.anchor.x = isLeft ? 0 : 1;
      textGraphic.anchor.y = y === 0 ? 0.9 : 0.5;
      textGraphic.position.x = tickEnd;
      textGraphic.position.y = dy + rowHeight - y;
      graphics.addChild(textGraphic);
    });
  });
}
function drawCircularYAxis(HGC, trackInfo, tile, gos, theme) {
  var _a, _b, _c, _d, _e;
  const spec = gos.spec();
  const CIRCULAR = spec.layout === "circular";
  const yDomain = gos.getChannelDomainArray("y");
  const yRange = gos.getChannelRangeArray("y");
  if (!CIRCULAR) {
    return;
  }
  if (!gos.isShowYAxis() || !yDomain || !yRange) {
    return;
  }
  const [tw, th] = trackInfo.dimensions;
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const trackRingSize = trackOuterRadius - trackInnerRadius;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const cx = tw / 2;
  const cy = th / 2;
  const rowCategories = (_e = gos.getChannelDomainArray("row")) != null ? _e : ["___SINGLE_ROW___"];
  const rowHeight = th / rowCategories.length;
  if (rowHeight / th * trackRingSize <= 20) {
    return;
  }
  const yChannel = gos.spec().y;
  const isLeft = IsChannelDeep(yChannel) && "axis" in yChannel && yChannel.axis === "right" ? false : true;
  const yScale = linear_linear().domain(yDomain).range(yRange);
  const graphics = tile.graphics;
  rowCategories.forEach((category) => {
    const rowPosition = gos.encodedValue("row", category);
    const innerR = trackOuterRadius - (rowPosition + rowHeight) / th * trackRingSize;
    const outerR = trackOuterRadius - rowPosition / th * trackRingSize;
    const innerPos = cartesianToPolar(isLeft ? 0 : tw, tw, innerR, cx, cy, startAngle, endAngle);
    const outerPos = cartesianToPolar(isLeft ? 0 : tw, tw, outerR, cx, cy, startAngle, endAngle);
    graphics.lineStyle(1, colorToHex(theme.axis.baselineColor), 1, 0.5);
    graphics.moveTo(innerPos.x, innerPos.y);
    graphics.lineTo(outerPos.x, outerPos.y);
    const SCALED_TICK_SIZE = (r) => TICK_SIZE * tw / 2 / Math.PI / r;
    const SCALED_EXTENT_TICK_SIZE = (r) => EXTENT_TICK_SIZE * tw / 2 / Math.PI / r;
    const axisHeight = rowHeight / th * trackRingSize;
    const tickCount = Math.max(Math.ceil(axisHeight / 40), 1);
    let ticks = yScale.ticks(tickCount).filter((v) => yDomain[0] <= v && v <= yDomain[1]);
    if (ticks.length === 1) {
      ticks = yScale.ticks(tickCount + 1).filter((v) => yDomain[0] <= v && v <= yDomain[1]);
    }
    graphics.lineStyle(1, colorToHex(theme.axis.tickColor), 1, 0.5);
    ticks.forEach((t) => {
      const y = yScale(t);
      const currentR = trackOuterRadius - (rowPosition + rowHeight - y) / th * trackRingSize;
      const scaledStartX = isLeft ? 0 : tw - SCALED_TICK_SIZE(currentR);
      const scaledEndX = isLeft ? SCALED_TICK_SIZE(currentR) : tw;
      const pos = cartesianToPolar(scaledStartX, tw, currentR, cx, cy, startAngle, endAngle);
      const startRad = valueToRadian(scaledStartX, tw, startAngle, endAngle);
      const endRad = valueToRadian(scaledEndX, tw, startAngle, endAngle);
      graphics.moveTo(pos.x, pos.y);
      graphics.arc(cx, cy, currentR, startRad, endRad, true);
      graphics.arc(cx, cy, currentR, endRad, startRad, false);
      graphics.closePath();
    });
    {
      const scaledStartX = isLeft ? 0 : tw - SCALED_EXTENT_TICK_SIZE(trackInnerRadius);
      const scaledEndX = isLeft ? SCALED_EXTENT_TICK_SIZE(trackInnerRadius) : tw;
      const startRad = valueToRadian(scaledStartX, tw, startAngle, endAngle);
      const endRad = valueToRadian(scaledEndX, tw, startAngle, endAngle);
      graphics.moveTo(innerPos.x, innerPos.y);
      graphics.arc(cx, cy, trackInnerRadius, startRad, endRad, true);
      graphics.arc(cx, cy, trackInnerRadius, endRad, startRad, false);
      graphics.closePath();
    }
    {
      const scaledStartX = isLeft ? 0 : tw - SCALED_EXTENT_TICK_SIZE(trackOuterRadius);
      const scaledEndX = isLeft ? SCALED_EXTENT_TICK_SIZE(trackOuterRadius) : tw;
      const startRad = valueToRadian(scaledStartX, tw, startAngle, endAngle);
      const endRad = valueToRadian(scaledEndX, tw, startAngle, endAngle);
      graphics.moveTo(outerPos.x, outerPos.y);
      graphics.arc(cx, cy, trackOuterRadius, startRad, endRad, true);
      graphics.arc(cx, cy, trackOuterRadius, endRad, startRad, false);
      graphics.closePath();
    }
    ticks.forEach((t) => {
      const y = yScale(t);
      const currentR = trackOuterRadius - (rowPosition + rowHeight - y) / th * trackRingSize;
      const pos = cartesianToPolar(SCALED_TICK_SIZE(currentR) * 2, tw, currentR, cx, cy, startAngle, endAngle);
      const styleConfig = getTextStyle({
        color: theme.axis.labelColor,
        size: theme.axis.labelFontSize,
        fontFamily: theme.axis.labelFontFamily,
        fontWeight: theme.axis.labelFontWeight
      });
      const textGraphic = new HGC.libraries.PIXI.Text(t, styleConfig);
      textGraphic.anchor.x = isLeft ? 1 : 0;
      textGraphic.anchor.y = 0.5;
      textGraphic.position.x = pos.x;
      textGraphic.position.y = pos.y;
      textGraphic.resolution = 4;
      const txtStyle = new HGC.libraries.PIXI.TextStyle(styleConfig);
      const metric = HGC.libraries.PIXI.TextMetrics.measureText(textGraphic.text, txtStyle);
      const txtWidth = metric.width / (2 * currentR * Math.PI) * tw * 360 / (endAngle - startAngle);
      const scaledStartX = isLeft ? SCALED_TICK_SIZE(currentR) * 2 : tw - SCALED_TICK_SIZE(currentR) * 2 - txtWidth;
      const scaledEndX = isLeft ? SCALED_TICK_SIZE(currentR) * 2 + txtWidth : tw - SCALED_TICK_SIZE(currentR) * 2;
      const ropePoints = [];
      for (let i = scaledEndX; i >= scaledStartX; i -= txtWidth / 10) {
        const p = cartesianToPolar(i, tw, currentR, cx, cy, startAngle, endAngle);
        ropePoints.push(new HGC.libraries.PIXI.Point(p.x, p.y));
      }
      textGraphic.updateText();
      const rope = new HGC.libraries.PIXI.SimpleRope(textGraphic.texture, ropePoints);
      graphics.addChild(rope);
    });
  });
}
function drawCircularOutlines(HGC, trackInfo, tile, tm, theme) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l;
  const spec = tm.spec();
  const [l, t] = trackInfo.position;
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  const trackInnerRadius = (_a = spec.innerRadius) != null ? _a : 220;
  const trackOuterRadius = (_b = spec.outerRadius) != null ? _b : 300;
  const startAngle = (_c = spec.startAngle) != null ? _c : 0;
  const endAngle = (_d = spec.endAngle) != null ? _d : 360;
  const cx = l + trackWidth / 2;
  const cy = t + trackHeight / 2;
  const posStartInner = cartesianToPolar(0, trackWidth, trackInnerRadius, cx, cy, startAngle, endAngle);
  const startRad = valueToRadian(0, trackWidth, startAngle, endAngle);
  const endRad = valueToRadian(trackWidth, trackWidth, startAngle, endAngle);
  const g = trackInfo.pBackground;
  if (!(spec.layout === "circular" && spec.mark === "withinLink")) {
    g.lineStyle(((_e = spec.style) == null ? void 0 : _e.outlineWidth) ? ((_f = spec.style) == null ? void 0 : _f.outlineWidth) / 2.5 : 0, colorToHex((_h = (_g = spec.style) == null ? void 0 : _g.outline) != null ? _h : "#DBDBDB"), 1, 1);
    g.beginFill(colorToHex((_j = (_i = tm.spec().style) == null ? void 0 : _i.background) != null ? _j : theme.track.background), (_l = (_k = tm.spec().style) == null ? void 0 : _k.backgroundOpacity) != null ? _l : !theme.track.background || theme.track.background === "transparent" ? 0 : 1);
    g.moveTo(posStartInner.x, posStartInner.y);
    g.arc(cx, cy, trackInnerRadius, startRad, endRad, true);
    g.arc(cx, cy, trackOuterRadius, endRad, startRad, false);
    g.closePath();
  }
  if (IsChannelDeep(spec.x) && spec.x.axis === "top") {
    g.lineStyle(0.5, colorToHex("black"), 0, 0.5);
    g.beginFill(colorToHex("white"), 0);
    g.moveTo(posStartInner.x, posStartInner.y);
    g.arc(cx, cy, trackOuterRadius - 0.5, startRad, endRad, true);
    g.arc(cx, cy, trackOuterRadius, endRad, startRad, false);
    g.closePath();
  }
  g.lineStyle(0.5, colorToHex("black"), 0, 0.5);
  g.beginFill(colorToHex("white"), 0);
  g.moveTo(cx, cy);
  g.arc(cx, cy, trackOuterRadius + 3, startRad, endRad, false);
  g.closePath();
  g.lineStyle(1, colorToHex("#DBDBDB"), 0, 0);
  g.beginFill(colorToHex("white"), 0);
  g.drawCircle(cx, cy, trackInnerRadius - 1);
}
function drawBackground(HGC, trackInfo, tile, tm, theme) {
  var _a, _b, _c, _d, _e, _f;
  const [l, t] = trackInfo.position;
  const [w, h] = trackInfo.dimensions;
  const g = trackInfo.pBackground;
  if (((_a = tm.spec().style) == null ? void 0 : _a.background) || theme.track.background && theme.track.background !== "transparent") {
    g.clear();
    const bg = (_c = (_b = tm.spec().style) == null ? void 0 : _b.background) != null ? _c : theme.track.background;
    const alpha = lodash_es_isUndefined((_d = tm.spec().style) == null ? void 0 : _d.backgroundOpacity) ? 1 : (_e = tm.spec().style) == null ? void 0 : _e.backgroundOpacity;
    g.lineStyle(1, colorToHex("white"), 0, 0);
    g.beginFill(colorToHex(bg), alpha);
    g.drawRect(l, t, w, h);
  }
  if (theme.track.alternatingBackground && theme.track.alternatingBackground !== "transparent") {
    const spec = tm.spec();
    if (!IsChannelDeep(spec.row) || spec.row.type !== "nominal") {
      return;
    }
    const rowCategories = (_f = tm.getChannelDomainArray("row")) != null ? _f : ["___SINGLE_ROW___"];
    if (rowCategories.length === 0) {
      return;
    }
    rowCategories.forEach((category, i) => {
      var _a2, _b2, _c2, _d2;
      if (i % 2 === 0) {
        return;
      }
      const rowPosition = tm.encodedValue("row", category);
      const bg = (_b2 = (_a2 = tm.spec().style) == null ? void 0 : _a2.background) != null ? _b2 : theme.track.alternatingBackground;
      const alpha = lodash_es_isUndefined((_c2 = tm.spec().style) == null ? void 0 : _c2.backgroundOpacity) ? 1 : (_d2 = tm.spec().style) == null ? void 0 : _d2.backgroundOpacity;
      g.lineStyle(1, colorToHex("white"), 0, 0);
      g.beginFill(colorToHex(bg), alpha);
      g.drawRect(trackInfo.position[0], trackInfo.position[1] + rowPosition, w, h / rowCategories.length);
    });
  }
}
const SUPPORTED_CHANNELS = [
  "x",
  "xe",
  "x1",
  "x1e",
  "y",
  "ye",
  "y1",
  "y1e",
  "color",
  "size",
  "row",
  "stroke",
  "strokeWidth",
  "opacity",
  "text"
];
function drawMark(HGC, trackInfo, tile, model) {
  if (!HGC || !trackInfo || !tile) {
    return;
  }
  if (model.spec().mark === "brush") {
    return;
  }
  ["x", "x1", "x1e", "xe"].forEach((d) => {
    model.setChannelScale(d, trackInfo._xScale);
  });
  if (Is2DTrack(model.spec()) || IsVerticalRule(model.spec())) {
    const yScale = trackInfo._yScale.copy();
    yScale.range([yScale.range()[1], yScale.range()[0]]);
    ["y", "y1", "y1e", "ye"].forEach((d) => {
      model.setChannelScale(d, yScale);
    });
  }
  const [trackWidth, trackHeight] = trackInfo.dimensions;
  switch (model.spec().mark) {
    case "point":
      drawPoint(trackInfo, tile.graphics, model);
      break;
    case "bar":
      drawBar(trackInfo, tile, model);
      break;
    case "line":
      drawLine(tile.graphics, model, trackInfo.tooltips, trackWidth, trackHeight);
      break;
    case "area":
      drawArea(HGC, trackInfo, tile, model);
      break;
    case "rect":
      drawRect(HGC, trackInfo, tile, model);
      break;
    case "triangleLeft":
    case "triangleRight":
    case "triangleBottom":
      drawTriangle(tile.graphics, model, trackWidth, trackHeight);
      break;
    case "text":
      drawText(HGC, trackInfo, tile, model);
      break;
    case "rule":
      drawRule(HGC, trackInfo, tile, model);
      break;
    case "betweenLink":
    case "withinLink":
      drawLink(tile.graphics, trackInfo, model);
      break;
    default:
      console.warn("Unsupported mark type");
      break;
  }
}
function drawPreEmbellishment(HGC, trackInfo, tile, model, theme) {
  if (!HGC || !trackInfo || !tile) {
    return;
  }
  if (model.spec().mark === "brush") {
    return;
  }
  trackInfo.pBackground.clear();
  trackInfo.pBackground.removeChildren();
  trackInfo.pBorder.clear();
  trackInfo.pBorder.removeChildren();
  const CIRCULAR = model.spec().layout === "circular";
  ["x", "x1", "x1e", "xe"].forEach((d) => {
    model.setChannelScale(d, trackInfo._xScale);
  });
  if (CIRCULAR) {
    drawCircularOutlines(HGC, trackInfo, tile, model, theme);
  } else {
    drawBackground(HGC, trackInfo, tile, model, theme);
    drawChartOutlines(HGC, trackInfo, model, theme);
  }
  drawGrid(trackInfo, model, theme);
}
function drawPostEmbellishment(HGC, trackInfo, tile, model, theme) {
  if (!HGC || !trackInfo || !tile) {
    return;
  }
  if (model.spec().mark === "brush") {
    return;
  }
  const CIRCULAR = model.spec().layout === "circular";
  ["x", "x1", "x1e", "xe"].forEach((d) => {
    model.setChannelScale(d, trackInfo._xScale);
  });
  if (CIRCULAR) {
    drawCircularYAxis(HGC, trackInfo, tile, model, theme);
    drawCircularTitle(HGC, trackInfo, tile, model, theme);
  } else {
    drawLinearYAxis(HGC, trackInfo, tile, model, theme);
    drawRowLegend(HGC, trackInfo, tile, model, theme);
  }
  drawColorLegend(HGC, trackInfo, tile, model, theme);
}
function resolveSuperposedTracks(track) {
  if (IsDataTrack(track)) {
    return [];
  }
  if (!IsOverlaidTrack(track)) {
    return [track];
  }
  if (track.overlay.length === 0) {
    return [{ ...track, superpose: void 0 }];
  }
  const base = JSON.parse(JSON.stringify(track));
  delete base.overlay;
  const resolved = [];
  track.overlay.forEach((subSpec, i) => {
    const spec = lodash_es_assign(JSON.parse(JSON.stringify(base)), subSpec);
    if (spec.title && i !== 0) {
      delete spec.title;
    }
    resolved.push(spec);
  });
  let xAxisPosition = void 0;
  resolved.forEach((d) => {
    if (IsChannelDeep(d.x) && d.x.axis && !xAxisPosition) {
      xAxisPosition = d.x.axis;
    }
  });
  const corrected = resolved.map((d) => {
    return {
      ...d,
      x: { ...d.x, axis: xAxisPosition }
    };
  });
  return corrected;
}
function spreadTracksByData(tracks) {
  return [].concat(...tracks.map((t) => {
    if (IsDataTrack(t) || !IsOverlaidTrack(t) || t.overlay.length <= 1) {
      return [t];
    }
    if (t.overlay.filter((s) => s.data).length === 0) {
      return [t];
    }
    if (isIdenticalDataSpec([t.data, ...t.overlay.map((s) => s.data)])) {
      return [t];
    }
    const base = JSON.parse(JSON.stringify(t));
    delete base.overlay;
    const spread = [];
    const original = JSON.parse(JSON.stringify(base));
    original.overlay = [];
    t.overlay.forEach((subSpec) => {
      if (!original.data) {
        original.data = subSpec.data;
      }
      if (!subSpec.data || isIdenticalDataSpec([original.data, subSpec.data])) {
        original.overlay.push(subSpec);
        return;
      }
      const spec = lodash_es_assign(JSON.parse(JSON.stringify(base)), subSpec);
      spread.push(spec);
    });
    const output = original.overlay.length > 0 ? [original, ...spread] : spread;
    return output.map((track, i, arr) => {
      const overlayOnPreviousTrack = i !== 0;
      const y = IsSingleTrack(track) && IsChannelDeep(track.y) && !track.y.axis && overlayOnPreviousTrack ? { ...track.y, axis: i === 1 ? "right" : "none" } : IsSingleTrack(track) ? track.y : void 0;
      if (track.title && i !== arr.length - 1 && arr.length !== 1) {
        delete track.title;
      }
      return { ...track, overlayOnPreviousTrack, y };
    });
  }));
}
function isIdenticalDataSpec(specs) {
  if (specs.length === 0) {
    return false;
  }
  const definedSpecs = specs.filter((d) => d);
  if (definedSpecs.length !== specs.length) {
    return false;
  }
  const keys = Object.keys(definedSpecs[0]).sort();
  let isIdentical = true;
  keys.forEach((k) => {
    const uniqueProperties = Array.from(new Set(definedSpecs.map((d) => JSON.stringify(d[k]))));
    if (uniqueProperties.length !== 1) {
      isIdentical = false;
      return;
    }
  });
  return isIdentical;
}
const PREDEFINED_COLOR_STR_MAP = {
  viridis: viridis,
  grey: Greys,
  warm: warm,
  spectral: Spectral,
  cividis: cividis,
  bupu: BuPu,
  rdbu: RdBu,
  hot: YlOrBr,
  pink: RdPu
};
function getHiGlassColorRange(colorStr = "viridis", step = 100) {
  var _a;
  const interpolate = (_a = PREDEFINED_COLOR_STR_MAP[colorStr]) != null ? _a : PREDEFINED_COLOR_STR_MAP["viridis"];
  return [...Array(step)].map((v, i) => interpolate(1 / step * i));
}
function IsFlatTracks(_) {
  return !("alignment" in _) && !_.tracks.find((d) => d.alignment === "overlay" || "tracks" in d);
}
function IsOverlaidTracks(_) {
  return "alignment" in _ && _.alignment === "overlay";
}
function IsStackedTracks(_) {
  return !IsFlatTracks(_) && !IsOverlaidTracks(_);
}
function IsDataTrack(_) {
  return !IsOverlaidTrack(_) && "data" in _ && !("mark" in _);
}
function IsDataTemplate(_) {
  return !!("data" in _ && "overrideTemplate" in _ && _.overrideTemplate);
}
function IsDataDeep(data2) {
  return typeof data2 === "object";
}
function IsDomainChr(domain) {
  return "chromosome" in domain && !("interval" in domain);
}
function IsDomainInterval(domain) {
  return !("chromosome" in domain) && "interval" in domain;
}
function IsDomainChrInterval(domain) {
  return "chromosome" in domain && "interval" in domain;
}
function IsSingleTrack(track) {
  return !("overlay" in track);
}
function IsOverlaidTrack(track) {
  return "overlay" in track;
}
function IsTemplateTrack(track) {
  return "template" in track;
}
function IsVerticalRule(track) {
  return IsSingleTrack(track) && !IsChannelDeep(track.x) && IsChannelDeep(track.y) && track.y.type === "genomic";
}
function Is2DTrack(track) {
  const t = IsSingleTrack(track) ? track : resolveSuperposedTracks(track)[0];
  return IsChannelDeep(t.x) && t.x.type === "genomic" && IsChannelDeep(t.y) && t.y.type === "genomic";
}
function IsHiGlassMatrix(track) {
  return Is2DTrack(track) && track.data.type === "matrix" && (track.mark === "bar" || track.mark === "rect") && track.xe && track.ye;
}
function IsChannelValue(channel) {
  return channel !== null && typeof channel === "object" && "value" in channel;
}
function IsDataDeepTileset(_) {
  return _ !== void 0 && (_.type === "vector" || _.type === "beddb" || _.type === "multivec" || _.type === "bigwig" || _.type === "matrix" || _.type === "bam");
}
function IsChannelDeep(channel) {
  return typeof channel === "object" && !("value" in channel);
}
function IsOneOfFilter(_) {
  return "oneOf" in _;
}
function IsRangeFilter(_) {
  return "inRange" in _;
}
function IsIncludeFilter(_) {
  return "include" in _;
}
function IsDomainArray(domain) {
  return lodash_es_isArray(domain);
}
function IsRangeArray(range2) {
  return lodash_es_isArray(range2);
}
function IsStackedMark(track) {
  return (track.mark === "bar" || track.mark === "area" || track.mark === "text") && IsChannelDeep(track.color) && track.color.type === "nominal" && (!track.row || IsChannelValue(track.row)) && IsChannelDeep(track.y) && track.y.type === "quantitative" && !IsChannelDeep(track.ye);
}
function IsStackedChannel(track, channelKey) {
  const channel = track[channelKey];
  return IsStackedMark(track) && (channelKey === "x" || channelKey === "y") && IsChannelDeep(channel) && channel.type === "quantitative";
}
function getValueUsingChannel(datum, channel) {
  if (IsChannelDeep(channel) && channel.field) {
    return datum[channel == null ? void 0 : channel.field];
  }
  return void 0;
}
function getChannelKeysByAggregateFnc(spec) {
  const keys = [];
  SUPPORTED_CHANNELS.forEach((k) => {
    const c = spec[k];
    if (IsChannelDeep(c) && "aggregate" in c) {
      keys.push(k);
    }
  });
  return keys;
}
function getChannelKeysByType(spec, t) {
  const keys = [];
  SUPPORTED_CHANNELS.forEach((k) => {
    const c = spec[k];
    if (IsChannelDeep(c) && c.type === t) {
      keys.push(k);
    }
  });
  return keys;
}
function IsXAxis(_) {
  if ((IsSingleTrack(_) || IsOverlaidTrack(_)) && IsChannelDeep(_.x) && _.x.axis && _.x.axis !== "none") {
    return true;
  } else if (IsOverlaidTrack(_)) {
    let isFound = false;
    _.overlay.forEach((t) => {
      if (isFound)
        return;
      if (IsChannelDeep(t.x) && t.x.axis && t.x.axis !== "none") {
        isFound = true;
      }
    });
    return isFound;
  }
  return false;
}
function IsYAxis(_) {
  if ((IsSingleTrack(_) || IsOverlaidTrack(_)) && IsChannelDeep(_.y) && _.y.axis && _.y.axis !== "none") {
    return true;
  } else if (IsOverlaidTrack(_)) {
    let isFound = false;
    _.overlay.forEach((t) => {
      if (isFound)
        return;
      if (IsChannelDeep(t.y) && t.y.axis && t.y.axis !== "none") {
        isFound = true;
      }
    });
    return isFound;
  }
  return false;
}
var getRandomValues;
var rnds8 = new Uint8Array(16);
function rng() {
  if (!getRandomValues) {
    getRandomValues = typeof crypto !== "undefined" && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== "undefined" && typeof msCrypto.getRandomValues === "function" && msCrypto.getRandomValues.bind(msCrypto);
    if (!getRandomValues) {
      throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");
    }
  }
  return getRandomValues(rnds8);
}
var REGEX = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;
function validate$2(uuid) {
  return typeof uuid === "string" && REGEX.test(uuid);
}
var byteToHex = [];
for (var gosling_es_i = 0; gosling_es_i < 256; ++gosling_es_i) {
  byteToHex.push((gosling_es_i + 256).toString(16).substr(1));
}
function stringify(arr) {
  var offset = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0;
  var uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + "-" + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + "-" + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + "-" + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + "-" + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase();
  if (!validate$2(uuid)) {
    throw TypeError("Stringified UUID is invalid");
  }
  return uuid;
}
var _nodeId;
var _clockseq;
var _lastMSecs = 0;
var _lastNSecs = 0;
function v1(options, buf, offset) {
  var i = buf && offset || 0;
  var b = buf || new Array(16);
  options = options || {};
  var node = options.node || _nodeId;
  var clockseq = options.clockseq !== void 0 ? options.clockseq : _clockseq;
  if (node == null || clockseq == null) {
    var seedBytes = options.random || (options.rng || rng)();
    if (node == null) {
      node = _nodeId = [seedBytes[0] | 1, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }
    if (clockseq == null) {
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 16383;
    }
  }
  var msecs = options.msecs !== void 0 ? options.msecs : Date.now();
  var nsecs = options.nsecs !== void 0 ? options.nsecs : _lastNSecs + 1;
  var dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 1e4;
  if (dt < 0 && options.clockseq === void 0) {
    clockseq = clockseq + 1 & 16383;
  }
  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === void 0) {
    nsecs = 0;
  }
  if (nsecs >= 1e4) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }
  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq;
  msecs += 122192928e5;
  var tl = ((msecs & 268435455) * 1e4 + nsecs) % 4294967296;
  b[i++] = tl >>> 24 & 255;
  b[i++] = tl >>> 16 & 255;
  b[i++] = tl >>> 8 & 255;
  b[i++] = tl & 255;
  var tmh = msecs / 4294967296 * 1e4 & 268435455;
  b[i++] = tmh >>> 8 & 255;
  b[i++] = tmh & 255;
  b[i++] = tmh >>> 24 & 15 | 16;
  b[i++] = tmh >>> 16 & 255;
  b[i++] = clockseq >>> 8 | 128;
  b[i++] = clockseq & 255;
  for (var n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }
  return buf || stringify(b);
}
function parse(uuid) {
  if (!validate$2(uuid)) {
    throw TypeError("Invalid UUID");
  }
  var v;
  var arr = new Uint8Array(16);
  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 255;
  arr[2] = v >>> 8 & 255;
  arr[3] = v & 255;
  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 255;
  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 255;
  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 255;
  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 1099511627776 & 255;
  arr[11] = v / 4294967296 & 255;
  arr[12] = v >>> 24 & 255;
  arr[13] = v >>> 16 & 255;
  arr[14] = v >>> 8 & 255;
  arr[15] = v & 255;
  return arr;
}
function stringToBytes(str) {
  str = unescape(encodeURIComponent(str));
  var bytes = [];
  for (var i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }
  return bytes;
}
var DNS = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
var URL$2 = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
function v35(name2, version2, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    if (typeof value === "string") {
      value = stringToBytes(value);
    }
    if (typeof namespace === "string") {
      namespace = parse(namespace);
    }
    if (namespace.length !== 16) {
      throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");
    }
    var bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 15 | version2;
    bytes[8] = bytes[8] & 63 | 128;
    if (buf) {
      offset = offset || 0;
      for (var i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }
      return buf;
    }
    return stringify(bytes);
  }
  try {
    generateUUID.name = name2;
  } catch (err) {
  }
  generateUUID.DNS = DNS;
  generateUUID.URL = URL$2;
  return generateUUID;
}
function md5(bytes) {
  if (typeof bytes === "string") {
    var msg = unescape(encodeURIComponent(bytes));
    bytes = new Uint8Array(msg.length);
    for (var i = 0; i < msg.length; ++i) {
      bytes[i] = msg.charCodeAt(i);
    }
  }
  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
}
function md5ToHexEncodedArray(input) {
  var output = [];
  var length32 = input.length * 32;
  var hexTab = "0123456789abcdef";
  for (var i = 0; i < length32; i += 8) {
    var x = input[i >> 5] >>> i % 32 & 255;
    var hex = parseInt(hexTab.charAt(x >>> 4 & 15) + hexTab.charAt(x & 15), 16);
    output.push(hex);
  }
  return output;
}
function getOutputLength(inputLength8) {
  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;
}
function wordsToMd5(x, len) {
  x[len >> 5] |= 128 << len % 32;
  x[getOutputLength(len) - 1] = len;
  var a = 1732584193;
  var b = -271733879;
  var c = -1732584194;
  var d = 271733878;
  for (var i = 0; i < x.length; i += 16) {
    var olda = a;
    var oldb = b;
    var oldc = c;
    var oldd = d;
    a = md5ff(a, b, c, d, x[i], 7, -680876936);
    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
    b = md5gg(b, c, d, a, x[i], 20, -373897302);
    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
    d = md5hh(d, a, b, c, x[i], 11, -358537222);
    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
    a = md5ii(a, b, c, d, x[i], 6, -198630844);
    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
    a = safeAdd(a, olda);
    b = safeAdd(b, oldb);
    c = safeAdd(c, oldc);
    d = safeAdd(d, oldd);
  }
  return [a, b, c, d];
}
function bytesToWords(input) {
  if (input.length === 0) {
    return [];
  }
  var length8 = input.length * 8;
  var output = new Uint32Array(getOutputLength(length8));
  for (var i = 0; i < length8; i += 8) {
    output[i >> 5] |= (input[i / 8] & 255) << i % 32;
  }
  return output;
}
function safeAdd(x, y) {
  var lsw = (x & 65535) + (y & 65535);
  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return msw << 16 | lsw & 65535;
}
function bitRotateLeft(num, cnt) {
  return num << cnt | num >>> 32 - cnt;
}
function md5cmn(q, a, b, x, s, t) {
  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
}
function md5ff(a, b, c, d, x, s, t) {
  return md5cmn(b & c | ~b & d, a, b, x, s, t);
}
function md5gg(a, b, c, d, x, s, t) {
  return md5cmn(b & d | c & ~d, a, b, x, s, t);
}
function md5hh(a, b, c, d, x, s, t) {
  return md5cmn(b ^ c ^ d, a, b, x, s, t);
}
function md5ii(a, b, c, d, x, s, t) {
  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
}
v35("v3", 48, md5);
function v4(options, buf, offset) {
  options = options || {};
  var rnds = options.random || (options.rng || rng)();
  rnds[6] = rnds[6] & 15 | 64;
  rnds[8] = rnds[8] & 63 | 128;
  if (buf) {
    offset = offset || 0;
    for (var i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }
    return buf;
  }
  return stringify(rnds);
}
function gosling_es_f(s, x, y, z) {
  switch (s) {
    case 0:
      return x & y ^ ~x & z;
    case 1:
      return x ^ y ^ z;
    case 2:
      return x & y ^ x & z ^ y & z;
    case 3:
      return x ^ y ^ z;
  }
}
function ROTL(x, n) {
  return x << n | x >>> 32 - n;
}
function sha1(bytes) {
  var K = [1518500249, 1859775393, 2400959708, 3395469782];
  var H = [1732584193, 4023233417, 2562383102, 271733878, 3285377520];
  if (typeof bytes === "string") {
    var msg = unescape(encodeURIComponent(bytes));
    bytes = [];
    for (var i = 0; i < msg.length; ++i) {
      bytes.push(msg.charCodeAt(i));
    }
  } else if (!Array.isArray(bytes)) {
    bytes = Array.prototype.slice.call(bytes);
  }
  bytes.push(128);
  var l = bytes.length / 4 + 2;
  var N = Math.ceil(l / 16);
  var M = new Array(N);
  for (var _i = 0; _i < N; ++_i) {
    var arr = new Uint32Array(16);
    for (var j = 0; j < 16; ++j) {
      arr[j] = bytes[_i * 64 + j * 4] << 24 | bytes[_i * 64 + j * 4 + 1] << 16 | bytes[_i * 64 + j * 4 + 2] << 8 | bytes[_i * 64 + j * 4 + 3];
    }
    M[_i] = arr;
  }
  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (bytes.length - 1) * 8 & 4294967295;
  for (var _i2 = 0; _i2 < N; ++_i2) {
    var W = new Uint32Array(80);
    for (var t = 0; t < 16; ++t) {
      W[t] = M[_i2][t];
    }
    for (var _t = 16; _t < 80; ++_t) {
      W[_t] = ROTL(W[_t - 3] ^ W[_t - 8] ^ W[_t - 14] ^ W[_t - 16], 1);
    }
    var a = H[0];
    var b = H[1];
    var c = H[2];
    var d = H[3];
    var e = H[4];
    for (var _t2 = 0; _t2 < 80; ++_t2) {
      var s = Math.floor(_t2 / 20);
      var T = ROTL(a, 5) + gosling_es_f(s, b, c, d) + e + K[s] + W[_t2] >>> 0;
      e = d;
      d = c;
      c = ROTL(b, 30) >>> 0;
      b = a;
      a = T;
    }
    H[0] = H[0] + a >>> 0;
    H[1] = H[1] + b >>> 0;
    H[2] = H[2] + c >>> 0;
    H[3] = H[3] + d >>> 0;
    H[4] = H[4] + e >>> 0;
  }
  return [H[0] >> 24 & 255, H[0] >> 16 & 255, H[0] >> 8 & 255, H[0] & 255, H[1] >> 24 & 255, H[1] >> 16 & 255, H[1] >> 8 & 255, H[1] & 255, H[2] >> 24 & 255, H[2] >> 16 & 255, H[2] >> 8 & 255, H[2] & 255, H[3] >> 24 & 255, H[3] >> 16 & 255, H[3] >> 8 & 255, H[3] & 255, H[4] >> 24 & 255, H[4] >> 16 & 255, H[4] >> 8 & 255, H[4] & 255];
}
v35("v5", 80, sha1);
function getStyleOverridden(parent, child) {
  const base = parent ? JSON.parse(JSON.stringify(parent)) : {};
  return child ? lodash_es_assign(base, child) : base;
}
function traverseTracks(spec, callback) {
  if ("tracks" in spec) {
    spec.tracks.forEach((t, i, ts) => {
      callback(t, i, ts);
      traverseTracks(t, callback);
    });
  } else if ("views" in spec) {
    spec.views.forEach((view) => traverseTracks(view, callback));
  }
}
function traverseTracksAndViews(spec, callback) {
  if ("tracks" in spec) {
    spec.tracks.forEach((t) => {
      callback(t);
      traverseTracksAndViews(t, callback);
    });
  } else if ("views" in spec) {
    spec.views.forEach((v) => {
      callback(v);
      traverseTracksAndViews(v, callback);
    });
  }
}
function traverseViewArrangements(spec, callback) {
  if ("tracks" in spec)
    ;
  else {
    callback(spec);
    spec.views.forEach((v) => {
      traverseViewArrangements(v, callback);
    });
  }
}
function convertToFlatTracks(spec) {
  if (IsFlatTracks(spec)) {
    const base = JSON.parse(JSON.stringify(spec));
    delete base.tracks;
    return spec.tracks.filter((track) => !track._invalidTrack).map((track) => lodash_es_assign(JSON.parse(JSON.stringify(base)), track));
  }
  const newTracks = [];
  if (IsStackedTracks(spec)) {
    spec.tracks.filter((track) => !track._invalidTrack).map((track) => {
      if ("alignment" in track) {
        newTracks.push({
          ...track,
          overlay: [...track.tracks],
          tracks: void 0,
          alignment: void 0
        });
      } else {
        const base = JSON.parse(JSON.stringify(spec));
        delete base.tracks;
        const newSpec = lodash_es_assign(JSON.parse(JSON.stringify(base)), track);
        newTracks.push(newSpec);
      }
    });
  } else {
    newTracks.push({
      ...spec,
      overlay: [...spec.tracks.filter((track) => !track._invalidTrack)],
      tracks: void 0,
      alignment: void 0
    });
  }
  return JSON.parse(JSON.stringify(newTracks));
}
function traverseToFixSpecDownstream(spec, parentDef) {
  if (parentDef) {
    if (spec.assembly === void 0)
      spec.assembly = parentDef.assembly;
    if (spec.layout === void 0)
      spec.layout = parentDef.layout;
    if (spec.orientation === void 0)
      spec.orientation = parentDef.orientation;
    if (spec.static === void 0)
      spec.static = parentDef.static !== void 0 ? parentDef.static : false;
    if (spec.zoomLimits === void 0)
      spec.zoomLimits = parentDef.zoomLimits;
    if (spec.xDomain === void 0)
      spec.xDomain = parentDef.xDomain;
    if (spec.yDomain === void 0)
      spec.yDomain = parentDef.yDomain;
    if (spec.linkingId === void 0)
      spec.linkingId = parentDef.linkingId;
    if (spec.centerRadius === void 0)
      spec.centerRadius = parentDef.centerRadius;
    if (spec.spacing === void 0 && !("tracks" in spec))
      spec.spacing = parentDef.spacing;
    if (spec.xOffset === void 0)
      spec.xOffset = parentDef.xOffset;
    if (spec.yOffset === void 0)
      spec.yOffset = parentDef.yOffset;
    if ("views" in spec && "arrangement" in parentDef && spec.arrangement === void 0)
      spec.arrangement = parentDef.arrangement;
    spec.style = getStyleOverridden(parentDef.style, spec.style);
  } else {
    if (spec.assembly === void 0)
      spec.assembly = "hg38";
    if (spec.layout === void 0)
      spec.layout = "linear";
    if (spec.orientation === void 0)
      spec.orientation = "horizontal";
    if (spec.static === void 0)
      spec.static = false;
    if (spec.zoomLimits === void 0)
      spec.zoomLimits = [1, null];
    if (spec.centerRadius === void 0)
      spec.centerRadius = DEFAULT_INNER_RADIUS_PROP;
    if (spec.spacing === void 0)
      spec.spacing = DEFAULT_VIEW_SPACING;
    if ("views" in spec && spec.arrangement === void 0)
      spec.arrangement = "vertical";
    if (spec.xOffset === void 0)
      spec.xOffset = 0;
    if (spec.yOffset === void 0)
      spec.yOffset = 0;
  }
  if ("tracks" in spec) {
    let tracks = convertToFlatTracks(spec);
    tracks = spreadTracksByData(tracks);
    const linkID = v4();
    tracks.forEach((track, i, array) => {
      var _a, _b, _c;
      if (!track.width)
        track.width = DEFAULT_TRACK_WIDTH_LINEAR;
      if (!track.height)
        track.height = DEFAULT_TRACK_HEIGHT_LINEAR;
      if ("displacement" in track) {
        if (((_a = track.displacement) == null ? void 0 : _a.type) === "pile" && track.row === void 0 && IsChannelDeep(track.x) && track.x.field && IsChannelDeep(track.xe) && track.xe.field) {
          const newField = v4();
          const startField = track.x.field;
          const endField = track.xe.field;
          const padding = track.displacement.padding;
          const displaceTransform = {
            type: "displace",
            newField,
            boundingBox: { startField, endField, padding },
            method: "pile"
          };
          if (!track.dataTransform) {
            track.dataTransform = [];
          }
          track.dataTransform = [...track.dataTransform, displaceTransform];
          track.row = { field: newField, type: "nominal" };
        } else if (((_b = track.displacement) == null ? void 0 : _b.type) === "spread")
          ;
      }
      if (track.layout)
        track.layout = void 0;
      if (track.zoomLimits)
        track.zoomLimits = void 0;
      if (!track.assembly)
        track.assembly = spec.assembly;
      if (!track.layout)
        track.layout = spec.layout;
      if (!track.orientation)
        track.orientation = spec.orientation;
      if (track.static === void 0)
        track.static = spec.static !== void 0 ? spec.static : false;
      if (!track.zoomLimits)
        track.zoomLimits = spec.zoomLimits;
      track.style = getStyleOverridden(spec.style, track.style);
      if (IsOverlaidTrack(track)) {
        track.overlay.forEach((o) => {
          o.style = getStyleOverridden(track.style, o.style);
        });
      }
      if ((track.layout === "circular" || Is2DTrack(track)) && track.orientation === "vertical") {
        track.orientation = "horizontal";
      }
      if (Is2DTrack(track)) {
        track.layout = "linear";
        if ((IsSingleTrack(track) || IsOverlaidTrack(track)) && IsChannelDeep(track.y) && !track.y.domain) {
          track.y.domain = spec.yDomain;
        } else if (IsOverlaidTrack(track)) {
          track.overlay.forEach((o) => {
            if (IsChannelDeep(o.y) && !o.y.domain) {
              o.y.domain = spec.yDomain;
            }
          });
        }
      }
      if ((IsSingleTrack(track) || IsOverlaidTrack(track)) && IsChannelDeep(track.x) && !track.x.domain) {
        track.x.domain = spec.xDomain;
      } else if (IsOverlaidTrack(track)) {
        track.overlay.forEach((o) => {
          if (IsChannelDeep(o.x) && !o.x.domain) {
            o.x.domain = spec.xDomain;
          }
        });
      }
      if ((IsSingleTrack(track) || IsOverlaidTrack(track)) && IsChannelDeep(track.x) && !track.x.linkingId) {
        track.x.linkingId = (_c = spec.linkingId) != null ? _c : linkID;
      } else if (IsOverlaidTrack(track)) {
        let isAdded = false;
        track.overlay.forEach((o) => {
          var _a2;
          if (isAdded)
            return;
          if (IsChannelDeep(o.x) && !o.x.linkingId) {
            o.x.linkingId = (_a2 = spec.linkingId) != null ? _a2 : linkID;
            isAdded = true;
          }
        });
      }
      if (i === 0) {
        track.overlayOnPreviousTrack = false;
      }
      if (i === 0 || i !== 0 && tracks.slice(0, i).filter((d) => !d.overlayOnPreviousTrack).length === 1 && track.overlayOnPreviousTrack === true) {
        if ((IsSingleTrack(track) || IsOverlaidTrack(track)) && IsChannelDeep(track.x) && !track.x.axis) {
          if (track.orientation === "vertical") {
            track.x.axis = "left";
          } else {
            track.x.axis = "top";
          }
        } else if (IsOverlaidTrack(track)) {
          track.overlay.forEach((o) => {
            if (IsChannelDeep(o.x) && !o.x.axis) {
              if (track.orientation === "vertical") {
                o.x.axis = "left";
              } else {
                o.x.axis = "top";
              }
            }
          });
        }
      }
      if ((IsSingleTrack(track) || IsOverlaidTrack(track)) && IsChannelDeep(track.x) && track.x.axis && track.x.axis !== "none") {
        if (track.orientation === "vertical") {
          if (track.x.axis === "top") {
            track.x.axis = "left";
          } else if (track.x.axis === "bottom") {
            track.x.axis = "right";
          }
        } else {
          if (track.x.axis === "left") {
            track.x.axis = "top";
          } else if (track.x.axis === "right") {
            track.x.axis = "bottom";
          }
        }
      } else if (IsOverlaidTrack(track)) {
        track.overlay.forEach((o) => {
          if (IsChannelDeep(o.x) && o.x.axis && o.x.axis !== "none") {
            if (track.orientation === "vertical") {
              if (o.x.axis === "top") {
                o.x.axis = "left";
              } else if (o.x.axis === "bottom") {
                o.x.axis = "right";
              }
            } else {
              if (o.x.axis === "left") {
                o.x.axis = "top";
              } else if (o.x.axis === "right") {
                o.x.axis = "bottom";
              }
            }
          }
        });
      }
      if (i !== 0 && (i === array.length - 1 && array.slice(0, i + 1).filter((d) => d.overlayOnPreviousTrack).length < i || i !== array.length - 1 && array.slice(i + 1).filter((d) => d.overlayOnPreviousTrack).length === array.length - i - 1 && array.slice(0, i + 1).filter((d) => d.overlayOnPreviousTrack).length < i)) {
        if (IsSingleTrack(track) && track.mark === "withinLink" && track.flipY === void 0) {
          track.flipY = true;
        } else if (IsOverlaidTrack(track)) {
          if (track.mark === "withinLink" && track.flipY === void 0) {
            track.flipY = true;
          }
          track.overlay.forEach((o) => {
            if (o.mark === "withinLink" && o.flipY === void 0) {
              o.flipY = true;
            }
          });
        }
      }
      if (track.overlayOnPreviousTrack && array[i - 1]) {
        track.width = array[i - 1].width;
        track.height = array[i - 1].height;
        track.layout = array[i - 1].layout;
        track.assembly = array[i - 1].assembly;
      }
    });
    spec.tracks = tracks;
  } else {
    spec.views.forEach((v) => {
      traverseToFixSpecDownstream(v, spec);
    });
  }
}
function getVectorTemplate(column, value) {
  return {
    data: {
      type: "vector",
      url: "",
      column,
      value
    },
    mark: "bar",
    x: { field: column, type: "genomic", axis: "top" },
    y: { field: value, type: "quantitative" },
    width: 400,
    height: 100
  };
}
function getMultivecTemplate(row, column, value, categories) {
  return categories && categories.length < 10 ? {
    data: {
      type: "multivec",
      url: "",
      row,
      column,
      value,
      categories
    },
    mark: "bar",
    x: { field: column, type: "genomic", axis: "top" },
    y: { field: value, type: "quantitative" },
    row: { field: row, type: "nominal", legend: true },
    color: { field: row, type: "nominal" },
    width: 400,
    height: 100
  } : {
    data: {
      type: "multivec",
      url: "",
      row,
      column,
      value,
      categories
    },
    mark: "rect",
    x: { field: column, type: "genomic", axis: "top" },
    row: { field: row, type: "nominal", legend: true },
    color: { field: value, type: "quantitative" },
    width: 400,
    height: 100
  };
}
function overrideDataTemplates(spec) {
  traverseTracks(spec, (t, i, ts) => {
    if (!t.data || !IsDataDeepTileset(t.data)) {
      return;
    }
    if ("alignment" in t) {
      return;
    }
    if (!IsDataTemplate(t)) {
      return;
    }
    switch (t.data.type) {
      case "vector":
      case "bigwig":
        ts[i] = lodash_es_assign(getVectorTemplate(t.data.column, t.data.value), t);
        break;
      case "multivec":
        ts[i] = lodash_es_assign(getMultivecTemplate(t.data.row, t.data.column, t.data.value, t.data.categories), t);
        break;
    }
  });
}
const GoslingTemplates = [
  {
    name: "gene",
    channels: [
      { name: "startPosition", type: "genomic", required: true },
      { name: "endPosition", type: "genomic", required: true },
      { name: "strandColor", type: "nominal", required: true },
      { name: "strandRow", type: "nominal", required: true },
      { name: "opacity", type: "value", required: false },
      { name: "geneHeight", type: "value", required: false },
      { name: "geneLabel", type: "nominal", required: true },
      { name: "geneLabelColor", type: "nominal", required: true },
      { name: "geneLabelFontSize", type: "value", required: false },
      { name: "geneLabelStroke", type: "value", required: false },
      { name: "geneLabelStrokeThickness", type: "value", required: false },
      { name: "geneLabelOpacity", type: "value", required: false },
      { name: "type", type: "nominal", required: true }
    ],
    mapping: [
      {
        dataTransform: [
          { type: "filter", base: "type", oneOf: ["gene"] },
          { type: "filter", base: "strandColor", oneOf: ["-"] }
        ],
        mark: "triangleLeft",
        x: { base: "startPosition", type: "genomic" },
        size: { base: "geneHeight", value: 12 },
        row: { base: "strandRow", type: "nominal", domain: ["+", "-"] },
        color: { base: "strandColor", type: "nominal", domain: ["+", "-"], range: ["blue", "red"] },
        opacity: { base: "opacity", value: 0.4 },
        style: { align: "right" }
      },
      {
        dataTransform: [
          { type: "filter", base: "type", oneOf: ["gene"] },
          { type: "filter", base: "strandColor", oneOf: ["+"] }
        ],
        mark: "triangleRight",
        x: { base: "endPosition", type: "genomic" },
        size: { base: "geneHeight", value: 12 },
        row: { base: "strandRow", type: "nominal", domain: ["+", "-"] },
        color: { base: "strandColor", type: "nominal", domain: ["+", "-"], range: ["blue", "red"] },
        opacity: { base: "opacity", value: 0.4 },
        style: { align: "left" }
      },
      {
        dataTransform: [{ type: "filter", base: "type", oneOf: ["exon"] }],
        mark: "rect",
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        size: { base: "geneHeight", value: 12 },
        row: { base: "strandRow", type: "nominal", domain: ["+", "-"] },
        color: { base: "strandColor", type: "nominal", domain: ["+", "-"], range: ["blue", "red"] },
        opacity: { base: "opacity", value: 0.4 }
      },
      {
        dataTransform: [
          { type: "filter", base: "type", oneOf: ["gene"] },
          { type: "filter", base: "strandColor", oneOf: ["+"] }
        ],
        mark: "rect",
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        row: { base: "strandRow", type: "nominal", domain: ["+", "-"] },
        color: { base: "strandColor", type: "nominal", domain: ["+", "-"], range: ["blue", "red"] },
        opacity: { base: "opacity", value: 0.4 },
        size: { value: 3 }
      },
      {
        dataTransform: [
          { type: "filter", base: "type", oneOf: ["gene"] },
          { type: "filter", base: "strandColor", oneOf: ["-"] }
        ],
        mark: "rect",
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        row: { base: "strandRow", type: "nominal", domain: ["+", "-"] },
        color: { base: "strandColor", type: "nominal", domain: ["+", "-"], range: ["blue", "red"] },
        opacity: { base: "opacity", value: 0.4 },
        size: { value: 3 }
      },
      {
        dataTransform: [{ type: "filter", base: "type", oneOf: ["gene"] }],
        mark: "text",
        text: { base: "geneLabel", type: "nominal" },
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        row: { base: "strandRow", type: "nominal", domain: ["+", "-"] },
        color: { base: "geneLabelColor", type: "nominal", domain: ["+", "-"], range: ["blue", "red"] },
        opacity: { base: "opacity", value: 1 },
        size: { base: "geneLabelFontSize", value: 18 },
        stroke: { base: "geneLabelStroke", value: "white" },
        strokeWidth: { base: "geneLabelStrokeThickness", value: 2 },
        visibility: [
          {
            operation: "less-than",
            measure: "width",
            threshold: "|xe-x|",
            transitionPadding: 10,
            target: "mark"
          }
        ]
      }
    ]
  },
  {
    name: "ideogram",
    channels: [
      { name: "startPosition", type: "genomic", required: true },
      { name: "endPosition", type: "genomic", required: true },
      { name: "chrHeight", type: "value", required: false },
      { name: "name", type: "nominal", required: true },
      { name: "stainBackgroundColor", type: "nominal", required: true },
      { name: "stainLabelColor", type: "nominal", required: true },
      { name: "stainStroke", type: "value", required: false },
      { name: "stainStrokeWidth", type: "value", required: false }
    ],
    mapping: [
      {
        mark: "rect",
        dataTransform: [{ type: "filter", base: "stainBackgroundColor", oneOf: ["acen"], not: true }],
        color: {
          base: "stainBackgroundColor",
          type: "nominal",
          domain: ["gneg", "gpos25", "gpos50", "gpos75", "gpos100", "gvar", "acen"],
          range: ["white", "lightgray", "gray", "gray", "black", "#7B9CC8", "#DC4542"]
        },
        size: { base: "chrHeight", value: 18 },
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        stroke: { base: "stainStroke", value: "gray" },
        strokeWidth: { base: "stainStrokeWidth", value: 0.3 }
      },
      {
        mark: "triangleRight",
        dataTransform: [
          { type: "filter", base: "stainBackgroundColor", oneOf: ["acen"] },
          { type: "filter", base: "name", include: "q" }
        ],
        color: {
          base: "stainBackgroundColor",
          type: "nominal",
          domain: ["gneg", "gpos25", "gpos50", "gpos75", "gpos100", "gvar", "acen"],
          range: ["white", "lightgray", "gray", "gray", "black", "#7B9CC8", "#DC4542"]
        },
        size: { base: "chrHeight", value: 18 },
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        stroke: { base: "stainStroke", value: "gray" },
        strokeWidth: { base: "stainStrokeWidth", value: 0.3 }
      },
      {
        mark: "triangleLeft",
        dataTransform: [
          { type: "filter", base: "stainBackgroundColor", oneOf: ["acen"] },
          { type: "filter", base: "name", include: "p" }
        ],
        color: {
          base: "stainBackgroundColor",
          type: "nominal",
          domain: ["gneg", "gpos25", "gpos50", "gpos75", "gpos100", "gvar", "acen"],
          range: ["white", "lightgray", "gray", "gray", "black", "#7B9CC8", "#DC4542"]
        },
        size: { base: "chrHeight", value: 18 },
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        stroke: { base: "stainStroke", value: "gray" },
        strokeWidth: { base: "stainStrokeWidth", value: 0.3 }
      },
      {
        mark: "text",
        dataTransform: [{ type: "filter", base: "stainLabelColor", oneOf: ["acen"], not: true }],
        color: {
          base: "stainLabelColor",
          type: "nominal",
          domain: ["gneg", "gpos25", "gpos50", "gpos75", "gpos100", "gvar"],
          range: ["black", "black", "black", "black", "white", "black"]
        },
        text: { base: "name", type: "nominal" },
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        visibility: [
          {
            operation: "less-than",
            measure: "width",
            threshold: "|xe-x|",
            transitionPadding: 10,
            target: "mark"
          }
        ]
      }
    ]
  },
  {
    name: "sequence",
    channels: [
      { name: "startPosition", type: "genomic", required: true },
      { name: "endPosition", type: "genomic", required: true },
      { name: "barLength", type: "quantitative", required: true },
      { name: "baseBackground", type: "nominal", required: true },
      { name: "baseLabelColor", type: "nominal", required: true },
      { name: "baseLabelFontSize", type: "value", required: false }
    ],
    mapping: [
      {
        mark: "bar",
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        y: { base: "barLength", type: "quantitative", axis: "none" },
        color: { base: "baseBackground", type: "nominal", domain: ["A", "T", "G", "C"] }
      },
      {
        dataTransform: [{ type: "filter", base: "barLength", oneOf: [0], not: true }],
        mark: "text",
        x: { base: "startPosition", type: "genomic" },
        xe: { base: "endPosition", type: "genomic" },
        color: { base: "baseLabelColor", type: "nominal", domain: ["A", "T", "G", "C"], range: ["white"] },
        text: { base: "baseBackground", type: "nominal" },
        size: { base: "baseLabelFontSize", value: 18 },
        visibility: [
          {
            operation: "less-than",
            measure: "width",
            threshold: "|xe-x|",
            transitionPadding: 30,
            target: "mark"
          },
          {
            operation: "LT",
            measure: "zoomLevel",
            threshold: 10,
            target: "track"
          }
        ]
      }
    ]
  }
];
function replaceTrackTemplates(spec, templates) {
  traverseTracks(spec, (t, i, ts) => {
    var _a, _b;
    if (!IsTemplateTrack(t)) {
      return;
    }
    const { template: name2 } = t;
    const templateDef = templates.find((d) => d.name === name2);
    if (!templateDef) {
      t._invalidTrack = true;
      console.warn(`There is no track template named '${name2}'`);
      return;
    }
    let isValid = true;
    templateDef.channels.forEach((d) => {
      if (d.required && (!t.encoding || !(d.name in t.encoding))) {
        isValid = false;
        console.warn(`A template spec ('${name2}') does not contain a required channel, ${d.name}`);
      }
    });
    if (!isValid) {
      t._invalidTrack = true;
      return;
    }
    const viewBase = JSON.parse(JSON.stringify(t));
    if ("encoding" in viewBase) {
      delete viewBase.encoding;
    }
    const convertedView = {
      ...viewBase,
      alignment: "overlay",
      tracks: [],
      width: (_a = t.width) != null ? _a : 100,
      height: (_b = t.height) != null ? _b : 100
    };
    templateDef.mapping.forEach((singleTrackMappingDef) => {
      const convertedTrack = {
        data: t.data,
        mark: singleTrackMappingDef.mark
      };
      const { dataTransform } = singleTrackMappingDef;
      if (dataTransform) {
        dataTransform.map((dataTramsformMap) => {
          const baseChannelName = dataTramsformMap.base;
          if (baseChannelName && t.encoding && baseChannelName in t.encoding && "field" in t.encoding[baseChannelName]) {
            delete dataTramsformMap.base;
            dataTramsformMap.field = t.encoding[baseChannelName].field;
          }
        });
      }
      const encodingSpec = t.encoding;
      if (!encodingSpec) {
        Object.keys(singleTrackMappingDef).filter((k) => k !== "mark").forEach((channelKey) => {
          const channelMap = JSON.parse(JSON.stringify(singleTrackMappingDef[channelKey]));
          if ("base" in channelMap) {
            delete channelMap.base;
          }
          convertedTrack[channelKey] = channelMap;
        });
      } else {
        Object.keys(singleTrackMappingDef).filter((k) => k !== "mark").forEach((channelKey) => {
          const channelMap = JSON.parse(JSON.stringify(singleTrackMappingDef[channelKey]));
          if ("base" in channelMap) {
            const baseChannelName = channelMap.base;
            if (baseChannelName in encodingSpec) {
              const base = JSON.parse(JSON.stringify(encodingSpec[baseChannelName]));
              delete channelMap.base;
              const newChannelSpec = lodash_es_assign(channelMap, JSON.parse(JSON.stringify(base)));
              convertedTrack[channelKey] = newChannelSpec;
            } else {
              delete channelMap.base;
              convertedTrack[channelKey] = channelMap;
            }
          } else {
            convertedTrack[channelKey] = channelMap;
          }
        });
      }
      convertedView.tracks.push(convertedTrack);
    });
    ts[i] = convertedView;
  });
}
function gosling_es_formatDecimal(x) {
  return Math.abs(x = Math.round(x)) >= 1e21 ? x.toLocaleString("en").replace(/,/g, "") : x.toString(10);
}
function gosling_es_formatDecimalParts(x, p) {
  if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0)
    return null;
  var i, coefficient = x.slice(0, i);
  return [
    coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
    +x.slice(i + 1)
  ];
}
function gosling_es_exponent(x) {
  return x = gosling_es_formatDecimalParts(Math.abs(x)), x ? x[1] : NaN;
}
function gosling_es_formatGroup(grouping, thousands) {
  return function(value, width) {
    var i = value.length, t = [], j = 0, g = grouping[0], length = 0;
    while (i > 0 && g > 0) {
      if (length + g + 1 > width)
        g = Math.max(1, width - length);
      t.push(value.substring(i -= g, i + g));
      if ((length += g + 1) > width)
        break;
      g = grouping[j = (j + 1) % grouping.length];
    }
    return t.reverse().join(thousands);
  };
}
function gosling_es_formatNumerals(numerals) {
  return function(value) {
    return value.replace(/[0-9]/g, function(i) {
      return numerals[+i];
    });
  };
}
var gosling_es_re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
function gosling_es_formatSpecifier(specifier) {
  if (!(match = gosling_es_re.exec(specifier)))
    throw new Error("invalid format: " + specifier);
  var match;
  return new gosling_es_FormatSpecifier({
    fill: match[1],
    align: match[2],
    sign: match[3],
    symbol: match[4],
    zero: match[5],
    width: match[6],
    comma: match[7],
    precision: match[8] && match[8].slice(1),
    trim: match[9],
    type: match[10]
  });
}
gosling_es_formatSpecifier.prototype = gosling_es_FormatSpecifier.prototype;
function gosling_es_FormatSpecifier(specifier) {
  this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
  this.align = specifier.align === void 0 ? ">" : specifier.align + "";
  this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
  this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
  this.zero = !!specifier.zero;
  this.width = specifier.width === void 0 ? void 0 : +specifier.width;
  this.comma = !!specifier.comma;
  this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
  this.trim = !!specifier.trim;
  this.type = specifier.type === void 0 ? "" : specifier.type + "";
}
gosling_es_FormatSpecifier.prototype.toString = function() {
  return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
};
function gosling_es_formatTrim(s) {
  out:
    for (var n = s.length, i = 1, i0 = -1, i1; i < n; ++i) {
      switch (s[i]) {
        case ".":
          i0 = i1 = i;
          break;
        case "0":
          if (i0 === 0)
            i0 = i;
          i1 = i;
          break;
        default:
          if (!+s[i])
            break out;
          if (i0 > 0)
            i0 = 0;
          break;
      }
    }
  return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
}
var gosling_es_prefixExponent;
function gosling_es_formatPrefixAuto(x, p) {
  var d = gosling_es_formatDecimalParts(x, p);
  if (!d)
    return x + "";
  var coefficient = d[0], exponent2 = d[1], i = exponent2 - (gosling_es_prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
  return i === n ? coefficient : i > n ? coefficient + new Array(i - n + 1).join("0") : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i) : "0." + new Array(1 - i).join("0") + gosling_es_formatDecimalParts(x, Math.max(0, p + i - 1))[0];
}
function gosling_es_formatRounded(x, p) {
  var d = gosling_es_formatDecimalParts(x, p);
  if (!d)
    return x + "";
  var coefficient = d[0], exponent2 = d[1];
  return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
}
var gosling_es_formatTypes = {
  "%": function(x, p) {
    return (x * 100).toFixed(p);
  },
  "b": function(x) {
    return Math.round(x).toString(2);
  },
  "c": function(x) {
    return x + "";
  },
  "d": gosling_es_formatDecimal,
  "e": function(x, p) {
    return x.toExponential(p);
  },
  "f": function(x, p) {
    return x.toFixed(p);
  },
  "g": function(x, p) {
    return x.toPrecision(p);
  },
  "o": function(x) {
    return Math.round(x).toString(8);
  },
  "p": function(x, p) {
    return gosling_es_formatRounded(x * 100, p);
  },
  "r": gosling_es_formatRounded,
  "s": gosling_es_formatPrefixAuto,
  "X": function(x) {
    return Math.round(x).toString(16).toUpperCase();
  },
  "x": function(x) {
    return Math.round(x).toString(16);
  }
};
function identity$1(x) {
  return x;
}
var map$1 = Array.prototype.map, gosling_es_prefixes = ["y", "z", "a", "f", "p", "n", "\xB5", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
function formatLocale(locale2) {
  var group2 = locale2.grouping === void 0 || locale2.thousands === void 0 ? identity$1 : gosling_es_formatGroup(map$1.call(locale2.grouping, Number), locale2.thousands + ""), currencyPrefix = locale2.currency === void 0 ? "" : locale2.currency[0] + "", currencySuffix = locale2.currency === void 0 ? "" : locale2.currency[1] + "", decimal = locale2.decimal === void 0 ? "." : locale2.decimal + "", numerals = locale2.numerals === void 0 ? identity$1 : gosling_es_formatNumerals(map$1.call(locale2.numerals, String)), percent = locale2.percent === void 0 ? "%" : locale2.percent + "", minus = locale2.minus === void 0 ? "-" : locale2.minus + "", nan = locale2.nan === void 0 ? "NaN" : locale2.nan + "";
  function newFormat(specifier) {
    specifier = gosling_es_formatSpecifier(specifier);
    var fill = specifier.fill, align = specifier.align, sign = specifier.sign, symbol = specifier.symbol, zero = specifier.zero, width = specifier.width, comma = specifier.comma, precision = specifier.precision, trim = specifier.trim, type2 = specifier.type;
    if (type2 === "n")
      comma = true, type2 = "g";
    else if (!gosling_es_formatTypes[type2])
      precision === void 0 && (precision = 12), trim = true, type2 = "g";
    if (zero || fill === "0" && align === "=")
      zero = true, fill = "0", align = "=";
    var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type2) ? "0" + type2.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type2) ? percent : "";
    var formatType = gosling_es_formatTypes[type2], maybeSuffix = /[defgprs%]/.test(type2);
    precision = precision === void 0 ? 6 : /[gprs]/.test(type2) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
    function format2(value) {
      var valuePrefix = prefix, valueSuffix = suffix, i, n, c;
      if (type2 === "c") {
        valueSuffix = formatType(value) + valueSuffix;
        value = "";
      } else {
        value = +value;
        var valueNegative = value < 0 || 1 / value < 0;
        value = isNaN(value) ? nan : formatType(Math.abs(value), precision);
        if (trim)
          value = gosling_es_formatTrim(value);
        if (valueNegative && +value === 0 && sign !== "+")
          valueNegative = false;
        valuePrefix = (valueNegative ? sign === "(" ? sign : minus : sign === "-" || sign === "(" ? "" : sign) + valuePrefix;
        valueSuffix = (type2 === "s" ? gosling_es_prefixes[8 + gosling_es_prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign === "(" ? ")" : "");
        if (maybeSuffix) {
          i = -1, n = value.length;
          while (++i < n) {
            if (c = value.charCodeAt(i), 48 > c || c > 57) {
              valueSuffix = (c === 46 ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix;
              value = value.slice(0, i);
              break;
            }
          }
        }
      }
      if (comma && !zero)
        value = group2(value, Infinity);
      var length = valuePrefix.length + value.length + valueSuffix.length, padding = length < width ? new Array(width - length + 1).join(fill) : "";
      if (comma && zero)
        value = group2(padding + value, padding.length ? width - valueSuffix.length : Infinity), padding = "";
      switch (align) {
        case "<":
          value = valuePrefix + value + valueSuffix + padding;
          break;
        case "=":
          value = valuePrefix + padding + value + valueSuffix;
          break;
        case "^":
          value = padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length);
          break;
        default:
          value = padding + valuePrefix + value + valueSuffix;
          break;
      }
      return numerals(value);
    }
    format2.toString = function() {
      return specifier + "";
    };
    return format2;
  }
  function formatPrefix2(specifier, value) {
    var f2 = newFormat((specifier = gosling_es_formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(gosling_es_exponent(value) / 3))) * 3, k = Math.pow(10, -e), prefix = gosling_es_prefixes[8 + e / 3];
    return function(value2) {
      return f2(k * value2) + prefix;
    };
  }
  return {
    format: newFormat,
    formatPrefix: formatPrefix2
  };
}
var gosling_es_locale;
var format$1;
var gosling_es_formatPrefix;
gosling_es_defaultLocale({
  decimal: ".",
  thousands: ",",
  grouping: [3],
  currency: ["$", ""],
  minus: "-"
});
function gosling_es_defaultLocale(definition) {
  gosling_es_locale = formatLocale(definition);
  format$1 = gosling_es_locale.format;
  gosling_es_formatPrefix = gosling_es_locale.formatPrefix;
  return gosling_es_locale;
}
function gosling_es_precisionPrefix(step, value) {
  return Math.max(0, Math.max(-8, Math.min(8, Math.floor(gosling_es_exponent(value) / 3))) * 3 - gosling_es_exponent(Math.abs(step)));
}
const CHROM_SIZE_HG38 = {
  chr1: 248956422,
  chr2: 242193529,
  chr3: 198295559,
  chr4: 190214555,
  chr5: 181538259,
  chr6: 170805979,
  chr7: 159345973,
  chr8: 145138636,
  chr9: 138394717,
  chr10: 133797422,
  chr11: 135086622,
  chr12: 133275309,
  chr13: 114364328,
  chr14: 107043718,
  chr15: 101991189,
  chr16: 90338345,
  chr17: 83257441,
  chr18: 80373285,
  chr19: 58617616,
  chr20: 64444167,
  chr21: 46709983,
  chr22: 50818468,
  chrX: 156040895,
  chrY: 57227415
};
const CHROM_SIZE_HG19 = {
  chr1: 249250621,
  chr2: 243199373,
  chr3: 198022430,
  chr4: 191154276,
  chr5: 180915260,
  chr6: 171115067,
  chr7: 159138663,
  chr8: 146364022,
  chr9: 141213431,
  chr10: 135534747,
  chr11: 135006516,
  chr12: 133851895,
  chr13: 115169878,
  chr14: 107349540,
  chr15: 102531392,
  chr16: 90354753,
  chr17: 81195210,
  chr18: 78077248,
  chr19: 59128983,
  chr20: 63025520,
  chr21: 48129895,
  chr22: 51304566,
  chrX: 155270560,
  chrY: 59373566,
  chrM: 16571
};
const CHROM_SIZE_HG18 = {
  chr1: 247249719,
  chr2: 242951149,
  chr3: 199501827,
  chr4: 191273063,
  chr5: 180857866,
  chr6: 170899992,
  chr7: 158821424,
  chr8: 146274826,
  chr9: 140273252,
  chr10: 135374737,
  chr11: 134452384,
  chr12: 132349534,
  chr13: 114142980,
  chr14: 106368585,
  chr15: 100338915,
  chr16: 88827254,
  chr17: 78774742,
  chr18: 76117153,
  chr19: 63811651,
  chr20: 62435964,
  chr21: 46944323,
  chr22: 49691432,
  chrX: 154913754,
  chrY: 57772954,
  chrM: 16571
};
const CHROM_SIZE_HG17 = {
  chr1: 245522847,
  chr2: 243018229,
  chr3: 199505740,
  chr4: 191411218,
  chr5: 180857866,
  chr6: 170975699,
  chr7: 158628139,
  chr8: 146274826,
  chr9: 138429268,
  chr10: 135413628,
  chr11: 134452384,
  chr12: 132449811,
  chr13: 114142980,
  chr14: 106368585,
  chr15: 100338915,
  chr16: 88827254,
  chr17: 78774742,
  chr18: 76117153,
  chr19: 63811651,
  chr20: 62435964,
  chr21: 46944323,
  chr22: 49554710,
  chrX: 154824264,
  chrY: 57701691,
  chrM: 16571
};
const CHROM_SIZE_HG16 = {
  chr1: 246127941,
  chr2: 243615958,
  chr3: 199344050,
  chr4: 191731959,
  chr5: 181034922,
  chr6: 170914576,
  chr7: 158545518,
  chr8: 146308819,
  chr9: 136372045,
  chr10: 135037215,
  chr11: 134482954,
  chr12: 132078379,
  chr13: 113042980,
  chr14: 105311216,
  chr15: 100256656,
  chr16: 90041932,
  chr17: 81860266,
  chr18: 76115139,
  chr19: 63811651,
  chr20: 63741868,
  chr21: 46976097,
  chr22: 49396972,
  chrX: 153692391,
  chrY: 50286555,
  chrM: 16571
};
const CHROM_SIZE_MM10 = {
  chr1: 195471971,
  chr2: 182113224,
  chr3: 160039680,
  chr4: 156508116,
  chr5: 151834684,
  chr6: 149736546,
  chr7: 145441459,
  chr8: 129401213,
  chr9: 124595110,
  chr10: 130694993,
  chr11: 122082543,
  chr12: 120129022,
  chr13: 120421639,
  chr14: 124902244,
  chr15: 104043685,
  chr16: 98207768,
  chr17: 94987271,
  chr18: 90702639,
  chr19: 61431566,
  chrX: 171031299,
  chrY: 91744698,
  chrM: 16299
};
const CHROM_SIZE_MM9 = {
  chr1: 197195432,
  chr2: 181748087,
  chr3: 159599783,
  chr4: 155630120,
  chr5: 152537259,
  chr6: 149517037,
  chr7: 152524553,
  chr8: 131738871,
  chr9: 124076172,
  chr10: 129993255,
  chr11: 121843856,
  chr12: 121257530,
  chr13: 120284312,
  chr14: 125194864,
  chr15: 103494974,
  chr16: 98319150,
  chr17: 95272651,
  chr18: 90772031,
  chr19: 61342430,
  chrX: 166650296,
  chrY: 15902555,
  chrM: 16299
};
function getRelativeGenomicPosition(absPos, assembly) {
  const chrAndRange = Object.entries(GET_CHROM_SIZES(assembly).interval).find((d) => {
    const [, [start, end]] = d;
    return start <= absPos && absPos < end;
  });
  if (!chrAndRange) {
    return `${absPos}`;
  }
  const pos = format$1(",")(absPos - chrAndRange[1][0]);
  return `${chrAndRange[0]}:${pos}`;
}
function GET_CHROM_SIZES(assembly) {
  if (assembly && assembly in CRHOM_SIZES) {
    return CRHOM_SIZES[assembly];
  } else {
    return CRHOM_SIZES.hg38;
  }
}
const basePath = (assembly) => `https://s3.amazonaws.com/gosling-lang.org/data/${assembly}.chrom.sizes`;
const CRHOM_SIZES = Object.freeze({
  hg38: {
    size: CHROM_SIZE_HG38,
    interval: getChromInterval(CHROM_SIZE_HG38),
    total: getChromTotalSize(CHROM_SIZE_HG38),
    path: basePath("hg38")
  },
  hg19: {
    size: CHROM_SIZE_HG19,
    interval: getChromInterval(CHROM_SIZE_HG19),
    total: getChromTotalSize(CHROM_SIZE_HG19),
    path: basePath("hg19")
  },
  hg18: {
    size: CHROM_SIZE_HG18,
    interval: getChromInterval(CHROM_SIZE_HG18),
    total: getChromTotalSize(CHROM_SIZE_HG18),
    path: basePath("hg18")
  },
  hg17: {
    size: CHROM_SIZE_HG17,
    interval: getChromInterval(CHROM_SIZE_HG17),
    total: getChromTotalSize(CHROM_SIZE_HG17),
    path: basePath("hg17")
  },
  hg16: {
    size: CHROM_SIZE_HG16,
    interval: getChromInterval(CHROM_SIZE_HG16),
    total: getChromTotalSize(CHROM_SIZE_HG16),
    path: basePath("hg16")
  },
  mm10: {
    size: CHROM_SIZE_MM10,
    interval: getChromInterval(CHROM_SIZE_MM10),
    total: getChromTotalSize(CHROM_SIZE_MM10),
    path: basePath("mm10")
  },
  mm9: {
    size: CHROM_SIZE_MM9,
    interval: getChromInterval(CHROM_SIZE_MM9),
    total: getChromTotalSize(CHROM_SIZE_MM9),
    path: basePath("mm9")
  },
  unknown: {
    size: { chr: Number.MAX_VALUE },
    interval: { chr: [0, Number.MAX_VALUE] },
    total: Number.MAX_VALUE,
    path: basePath("hg38")
  }
});
function getChromInterval(chromSize) {
  const interval2 = {};
  Object.keys(chromSize).reduce((sum2, k) => {
    interval2[k] = [sum2, sum2 + chromSize[k]];
    return sum2 + chromSize[k];
  }, 0);
  return interval2;
}
function getChromTotalSize(chromSize) {
  return Object.values(chromSize).reduce((sum2, current) => sum2 + current, 0);
}
const TICK_WIDTH = 200;
const TICK_HEIGHT = 6;
const TICK_TEXT_SEPARATION = 2;
const TICK_COLOR = 7829367;
function AxisTrack(HGC, ...args) {
  if (!new.target) {
    throw new Error('Uncaught TypeError: Class constructor cannot be invoked without "new"');
  }
  const { absToChr, colorToHex: colorToHex2, pixiTextToSvg, showMousePosition, svgLine } = HGC.utils;
  class AxisTrackClass extends HGC.tracks.PixiTrack {
    constructor(params) {
      super(...params);
      const [context2, options] = params;
      const { dataConfig, animate, chromInfoPath, isShowGlobalMousePosition } = context2;
      this.searchField = null;
      this.chromInfo = null;
      this.dataConfig = dataConfig;
      this.allTexts = [];
      this.pTicksCircular = new HGC.libraries.PIXI.Graphics();
      this.pTicks = new HGC.libraries.PIXI.Graphics();
      this.pMain.addChild(this.pTicks);
      this.pMain.addChild(this.pTicksCircular);
      this.gTicks = {};
      this.tickTexts = {};
      this.options = options;
      this.isShowGlobalMousePosition = isShowGlobalMousePosition;
      this.textFontSize = 12;
      this.textFontFamily = "sans-serif";
      this.textFontWeight = "normal";
      this.textFontColor = "#808080";
      this.textStrokeColor = "#ffffff";
      this.pixiTextConfig = getTextStyle({
        size: +this.options.fontSize || this.textFontSize,
        fontFamily: this.options.fontFamily || this.textFontFamily,
        fontWeight: this.options.fontWeight || this.textFontWeight,
        color: this.options.color || this.textFontColor,
        stroke: this.options.stroke || this.textStrokeColor,
        strokeThickness: 2
      });
      this.stroke = colorToHex2(this.pixiTextConfig.stroke);
      this.tickWidth = TICK_WIDTH;
      this.tickHeight = TICK_HEIGHT;
      this.tickTextSeparation = TICK_TEXT_SEPARATION;
      this.tickColor = this.options.tickColor ? colorToHex2(this.options.tickColor) : TICK_COLOR;
      this.animate = animate;
      this.pubSubs = [];
      if (this.options.showMousePosition && !this.hideMousePosition) {
        this.hideMousePosition = showMousePosition(this, this.is2d, this.isShowGlobalMousePosition());
      }
      let chromSizesPath = chromInfoPath;
      if (!chromSizesPath) {
        chromSizesPath = `${dataConfig.server}/chrom-sizes/?id=${dataConfig.tilesetUid}`;
      }
      const assembly = this.options.assembly;
      const chrPositions = {};
      const chromLengths = { ...GET_CHROM_SIZES(assembly).size };
      const cumPositions = [];
      Object.keys(GET_CHROM_SIZES(assembly).size).forEach((k) => {
        chrPositions[k] = { chr: k, pos: GET_CHROM_SIZES(assembly).size[k] };
      });
      Object.keys(GET_CHROM_SIZES(assembly).interval).forEach((k) => {
        cumPositions.push({ chr: k, pos: GET_CHROM_SIZES(assembly).interval[k][0] });
      });
      this.chromInfo = { chrPositions, chromLengths, cumPositions };
      this.rerender(this.options, true);
      this.draw();
      this.animate();
    }
    initBoundsTicks() {
      if (this.pTicks) {
        this.pMain.removeChild(this.pTicks);
        this.pTicks = null;
      }
      if (!this.gBoundTicks) {
        this.gBoundTicks = new HGC.libraries.PIXI.Graphics();
        this.leftBoundTick = new HGC.libraries.PIXI.Text("", this.pixiTextConfig);
        this.rightBoundTick = new HGC.libraries.PIXI.Text("", this.pixiTextConfig);
        this.gBoundTicks.addChild(this.leftBoundTick);
        this.gBoundTicks.addChild(this.rightBoundTick);
        this.pMain.addChild(this.gBoundTicks);
      }
      this.texts = [];
    }
    initChromLabels() {
      if (!this.chromInfo)
        return;
      if (this.gBoundTicks) {
        this.pMain.removeChild(this.gBoundTicks);
        this.gBoundTicks = null;
      }
      if (!this.pTicks) {
        this.pTicks = new HGC.libraries.PIXI.Graphics();
        this.pMain.addChild(this.pTicks);
      }
      this.texts = [];
      this.pTicks.removeChildren();
      this.chromInfo.cumPositions.forEach((info) => {
        const chromName = info.chr;
        this.gTicks[chromName] = new HGC.libraries.PIXI.Graphics();
        if (!this.tickTexts[chromName])
          this.tickTexts[chromName] = [];
        const text = new HGC.libraries.PIXI.Text(chromName, this.pixiTextConfig);
        text.hashValue = Math.random();
        this.pTicks.addChild(text);
        this.pTicks.addChild(this.gTicks[chromName]);
        this.texts.push(text);
      });
    }
    rerender(options, force) {
      const strOptions = JSON.stringify(options);
      if (!force && strOptions === this.prevOptions)
        return;
      this.prevOptions = strOptions;
      this.options = options;
      this.pixiTextConfig.fontSize = +this.options.fontSize ? `${+this.options.fontSize}px` : this.pixiTextConfig.fontSize;
      this.pixiTextConfig.fill = this.options.color || this.pixiTextConfig.fill;
      this.pixiTextConfig.stroke = this.options.stroke || this.pixiTextConfig.stroke;
      this.stroke = colorToHex2(this.pixiTextConfig.stroke);
      this.tickColor = this.options.tickColor ? colorToHex2(this.options.tickColor) : TICK_COLOR;
      if (this.options.tickPositions === "ends" && this.options.layout !== "circular") {
        this.initBoundsTicks();
      } else {
        this.initChromLabels();
      }
      super.rerender(options, force);
      if (this.options.showMousePosition && !this.hideMousePosition) {
        this.hideMousePosition = showMousePosition(this, this.is2d, this.isShowGlobalMousePosition());
      }
      if (!this.options.showMousePosition && this.hideMousePosition) {
        this.hideMousePosition();
        this.hideMousePosition = void 0;
      }
    }
    formatTick(pos) {
      if (isNaN(pos)) {
        return "null";
      }
      const domain = this._xScale.domain();
      const viewWidth = domain[1] - domain[0];
      const p = gosling_es_precisionPrefix(pos, viewWidth);
      const fPlain = format$1(",");
      const fPrecision = gosling_es_formatPrefix(`,.${p}`, viewWidth);
      let f2 = fPlain;
      if (this.options.tickFormat === "si") {
        f2 = fPrecision;
      } else if (this.options.tickFormat === "plain") {
        f2 = fPlain;
      } else if (this.options.tickPositions === "ends") {
        f2 = fPrecision;
      }
      return f2(pos);
    }
    drawBoundsTicks(x1, x2) {
      const graphics = this.gBoundTicks;
      graphics.clear();
      graphics.lineStyle(1, 0);
      const lineYStart = this.options.reverseOrientation ? 0 : this.dimensions[1];
      const lineYEnd = this.options.reverseOrientation ? this.tickHeight : this.dimensions[1] - this.tickHeight;
      graphics.moveTo(1, lineYStart);
      graphics.lineTo(1, lineYEnd);
      graphics.moveTo(this.dimensions[0] - 1, lineYStart);
      graphics.lineTo(this.dimensions[0] - 1, lineYEnd);
      this.leftBoundTick.x = 0;
      this.leftBoundTick.y = this.options.reverseOrientation ? lineYEnd + this.tickTextSeparation : lineYEnd - this.tickTextSeparation;
      this.leftBoundTick.text = this.options.assembly === "unknown" ? `${this.formatTick(x1[1])}` : `${x1[0]}: ${this.formatTick(x1[1])}`;
      this.leftBoundTick.anchor.y = this.options.reverseOrientation ? 0 : 1;
      this.rightBoundTick.x = this.dimensions[0];
      this.rightBoundTick.text = this.options.assembly === "unknown" ? `${this.formatTick(x2[1])}` : `${x2[0]}: ${this.formatTick(x2[1])}`;
      this.rightBoundTick.y = this.options.reverseOrientation ? lineYEnd + this.tickTextSeparation : lineYEnd - this.tickTextSeparation;
      this.rightBoundTick.anchor.y = this.options.reverseOrientation ? 0 : 1;
      this.rightBoundTick.anchor.x = 1;
      if (this.flipText) {
        this.leftBoundTick.scale.x = -1;
        this.leftBoundTick.anchor.x = 1;
        this.rightBoundTick.scale.x = -1;
        this.rightBoundTick.anchor.x = 0;
      }
      this.leftBoundTick.tickLine = [1, this.dimensions[1], 1, this.dimensions[1] - this.tickHeight];
      this.rightBoundTick.tickLine = [
        this.dimensions[0] - 1,
        this.dimensions[1],
        this.dimensions[0] - 1,
        this.dimensions[1] - this.tickHeight
      ];
      this.tickTexts = {};
      this.tickTexts.all = [this.leftBoundTick, this.rightBoundTick];
    }
    drawTicks(cumPos) {
      const graphics = this.gTicks[cumPos.chr];
      graphics.visible = true;
      graphics.clear();
      const chromLen = +this.chromInfo.chromLengths[cumPos.chr];
      const vpLeft = Math.max(this._xScale(cumPos.pos), 0);
      const vpRight = Math.min(this._xScale(cumPos.pos + chromLen), this.dimensions[0]);
      const numTicks = (vpRight - vpLeft) / this.tickWidth;
      const xScale = linear_linear().domain([
        Math.max(1, this._xScale.invert(0) - cumPos.pos),
        Math.min(chromLen, this._xScale.invert(this.dimensions[0]) - cumPos.pos)
      ]).range([vpLeft, vpRight]);
      const ticks = xScale.ticks(numTicks).filter((tick) => Number.isInteger(tick));
      const tickTexts = this.tickTexts[cumPos.chr];
      const tickHeight = this.tickHeight;
      const xPadding = 0;
      let yPadding = tickHeight + this.tickTextSeparation;
      if (this.options.reverseOrientation) {
        yPadding = this.dimensions[1] - yPadding;
      }
      while (tickTexts.length < ticks.length) {
        const newText = new HGC.libraries.PIXI.Text("", this.pixiTextConfig);
        tickTexts.push(newText);
        this.gTicks[cumPos.chr].addChild(newText);
      }
      while (tickTexts.length > ticks.length) {
        const text = tickTexts.pop();
        this.gTicks[cumPos.chr].removeChild(text);
      }
      let i = 0;
      while (i < ticks.length) {
        tickTexts[i].visible = true;
        tickTexts[i].anchor.x = 0.5;
        tickTexts[i].anchor.y = this.options.layout === "circular" ? 0 : this.options.reverseOrientation ? 0 : 1;
        if (this.flipText)
          tickTexts[i].scale.x = -1;
        const chrText = this.options.assembly === "unknown" ? "" : `${cumPos.chr}: `;
        tickTexts[i].text = ticks[i] === 0 ? `${chrText}1` : `${chrText}${this.formatTick(ticks[i])}`;
        const x = this._xScale(cumPos.pos + ticks[i]);
        if (this.options.layout === "circular") {
          const rope = this.addCurvedText(tickTexts[i], x + xPadding);
          this.pTicksCircular.addChild(rope);
        } else {
          tickTexts[i].x = x + xPadding;
          tickTexts[i].y = this.dimensions[1] - yPadding;
          tickTexts[i].tickLine = [x - 1, this.dimensions[1], x - 1, this.dimensions[1] - tickHeight - 1];
          const lineYStart = this.options.reverseOrientation ? 0 : this.dimensions[1];
          const lineYEnd = this.options.reverseOrientation ? tickHeight : this.dimensions[1] - tickHeight;
          graphics.lineStyle(1, this.tickColor);
          graphics.moveTo(x, lineYStart);
          graphics.lineTo(x, lineYEnd);
        }
        i += 1;
      }
      if (this.options.layout === "circular")
        i = 0;
      while (i < tickTexts.length) {
        tickTexts[i].visible = false;
        i += 1;
      }
      return ticks.length;
    }
    addCurvedText(textObj, cx) {
      const [width, height] = this.dimensions;
      const { startAngle, endAngle } = this.options;
      const factor = Math.min(width, height) / Math.min(this.options.width, this.options.height);
      const innerRadius = this.options.innerRadius * factor;
      const outerRadius = this.options.outerRadius * factor;
      const r = (outerRadius + innerRadius) / 2;
      const centerPos = cartesianToPolar(cx, width, r, width / 2, height / 2, startAngle, endAngle);
      textObj.x = centerPos.x;
      textObj.y = centerPos.y;
      textObj.resolution = 4;
      const txtStyle = new HGC.libraries.PIXI.TextStyle(this.pixiTextConfig);
      const metric = HGC.libraries.PIXI.TextMetrics.measureText(textObj.text, txtStyle);
      const tw = metric.width / (2 * r * Math.PI) * width * 360 / (endAngle - startAngle);
      let [minX, maxX] = [cx - tw / 2, cx + tw / 2];
      if (minX < 0) {
        const gap = -minX;
        minX = 0;
        maxX += gap;
      } else if (maxX > width) {
        const gap = maxX - width;
        maxX = width;
        minX -= gap;
      }
      const ropePoints = [];
      const baseR = innerRadius + metric.height / 2 + 3;
      for (let i = maxX; i >= minX; i -= tw / 10) {
        const p = cartesianToPolar(i, width, baseR, width / 2, height / 2, startAngle, endAngle);
        ropePoints.push(new HGC.libraries.PIXI.Point(p.x, p.y));
      }
      textObj.updateText();
      const rope = new HGC.libraries.PIXI.SimpleRope(textObj.texture, ropePoints);
      return rope;
    }
    draw() {
      this.allTexts = [];
      if (!this.texts)
        return;
      const x1 = absToChr(this._xScale.domain()[0], this.chromInfo);
      const x2 = absToChr(this._xScale.domain()[1], this.chromInfo);
      if (!x1 || !x2) {
        console.warn("Empty chromInfo:", this.dataConfig, this.chromInfo);
        return;
      }
      if (this.options.tickPositions === "ends" && this.options.layout !== "circular") {
        if (!this.gBoundTicks)
          return;
        this.gBoundTicks.visible = true;
        this.drawBoundsTicks(x1, x2);
        return;
      }
      if (!this.pTicks) {
        return;
      }
      const circular = this.options.layout === "circular";
      for (let i = 0; i < this.texts.length; i++) {
        this.texts[i].visible = false;
        this.gTicks[this.chromInfo.cumPositions[i].chr].visible = false;
      }
      let yPadding = this.tickHeight + this.tickTextSeparation;
      if (this.options.reverseOrientation) {
        yPadding = this.dimensions[1] - yPadding;
      }
      Object.keys(this.chromInfo.chrPositions).forEach((chrom) => {
        if (this.tickTexts[chrom]) {
          this.tickTexts[chrom].forEach((tick) => {
            tick.visible = false;
          });
        }
      });
      this.pTicksCircular.removeChildren();
      for (let i = x1[3]; i <= x2[3]; i++) {
        const xCumPos = this.chromInfo.cumPositions[i];
        const midX = xCumPos.pos + this.chromInfo.chromLengths[xCumPos.chr] / 2;
        const viewportMidX = this._xScale(midX);
        const chrText = this.texts[i];
        chrText.anchor.x = 0.5;
        chrText.anchor.y = circular ? 0.5 : this.options.reverseOrientation ? 0 : 1;
        let rope;
        if (circular) {
          rope = this.addCurvedText(chrText, viewportMidX);
          this.pTicksCircular.addChild(rope);
        } else {
          chrText.x = viewportMidX;
          chrText.y = this.dimensions[1] - yPadding;
        }
        chrText.updateTransform();
        if (this.flipText)
          chrText.scale.x = -1;
        const numTicksDrawn = this.drawTicks(xCumPos);
        if (!circular) {
          chrText.visible = numTicksDrawn <= 0;
        } else {
          if (numTicksDrawn > 0) {
            this.pTicksCircular.removeChild(rope);
          }
        }
        this.allTexts.push({
          importance: chrText.hashValue,
          text: chrText,
          rope
        });
      }
      this.hideOverlaps(this.allTexts);
    }
    hideOverlaps(allTexts) {
      const tree = new (rbush_min_default())();
      allTexts.sort((a, b) => b.importance - a.importance).forEach(({ text, rope }) => {
        text.updateTransform();
        const b = text.getBounds();
        const m = 5;
        const boxWithMargin = {
          minX: b.x - m,
          minY: b.y - m,
          maxX: b.x + b.width + m * 2,
          maxY: b.y + b.height + m * 2
        };
        if (!tree.collides(boxWithMargin)) {
          tree.insert(boxWithMargin);
        } else {
          text.visible = false;
          if (this.options.layout === "circular" && rope) {
            this.pTicksCircular.removeChild(rope);
          }
        }
      });
    }
    setPosition(newPosition) {
      super.setPosition(newPosition);
      [this.pMain.position.x, this.pMain.position.y] = this.position;
    }
    zoomed(newXScale, newYScale) {
      const domainValues = [...newXScale.domain(), ...newYScale.domain()];
      if (domainValues.filter((d) => isNaN(d)).length !== 0) {
        return;
      }
      this.xScale(newXScale);
      this.yScale(newYScale);
      this.draw();
    }
    exportSVG() {
      let track = null;
      let base = null;
      if (super.exportSVG) {
        [base, track] = super.exportSVG();
      } else {
        base = document.createElement("g");
        track = base;
      }
      base.setAttribute("class", "chromosome-labels");
      const output = document.createElement("g");
      track.appendChild(output);
      output.setAttribute("transform", `translate(${this.position[0]},${this.position[1]})`);
      this.allTexts.filter((text) => text.text.visible).forEach((text) => {
        const g = pixiTextToSvg(text.text);
        output.appendChild(g);
      });
      Object.values(this.tickTexts).forEach((texts) => {
        texts.filter((x) => x.visible).forEach((text) => {
          let g = pixiTextToSvg(text);
          output.appendChild(g);
          g = svgLine(text.x, this.options.reverseOrientation ? 0 : this.dimensions[1], text.x, this.options.reverseOrientation ? this.tickHeight : this.dimensions[1] - this.tickHeight, 1, this.tickColor);
          const line = document.createElement("line");
          line.setAttribute("x1", text.tickLine[0]);
          line.setAttribute("y1", text.tickLine[1]);
          line.setAttribute("x2", text.tickLine[2]);
          line.setAttribute("y2", text.tickLine[3]);
          line.setAttribute("style", "stroke: grey");
          output.appendChild(g);
          output.appendChild(line);
        });
      });
      return [base, track];
    }
  }
  return new AxisTrackClass(args);
}
const icon$1 = '<svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 5640 5420" preserveAspectRatio="xMidYMid meet"> <g id="layer101" fill="#000000" stroke="none"> <path d="M0 2710 l0 -2710 2820 0 2820 0 0 2710 0 2710 -2820 0 -2820 0 0 -2710z"/> </g> <g id="layer102" fill="#750075" stroke="none"> <path d="M200 4480 l0 -740 630 0 630 0 0 740 0 740 -630 0 -630 0 0 -740z"/> <path d="M1660 4420 l0 -800 570 0 570 0 0 800 0 800 -570 0 -570 0 0 -800z"/> <path d="M3000 3450 l0 -1770 570 0 570 0 0 1770 0 1770 -570 0 -570 0 0 -1770z"/> <path d="M4340 2710 l0 -2510 560 0 560 0 0 2510 0 2510 -560 0 -560 0 0 -2510z"/> <path d="M200 1870 l0 -1670 630 0 630 0 0 1670 0 1670 -630 0 -630 0 0 -1670z"/> <path d="M1660 1810 l0 -1610 570 0 570 0 0 1610 0 1610 -570 0 -570 0 0 -1610z"/> <path d="M3000 840 l0 -640 570 0 570 0 0 640 0 640 -570 0 -570 0 0 -640z"/> </g> <g id="layer103" fill="#ffff04" stroke="none"> <path d="M200 4480 l0 -740 630 0 630 0 0 740 0 740 -630 0 -630 0 0 -740z"/> <path d="M1660 4420 l0 -800 570 0 570 0 0 800 0 800 -570 0 -570 0 0 -800z"/> <path d="M3000 3450 l0 -1770 570 0 570 0 0 1770 0 1770 -570 0 -570 0 0 -1770z"/> </g> </svg>';
AxisTrack.config = {
  type: "axis-track",
  datatype: ["multivec", "epilogos"],
  local: false,
  orientation: "1d-horizontal",
  thumbnail: new DOMParser().parseFromString(icon$1, "text/xml").documentElement,
  availableOptions: [
    "innerRadius",
    "outerRadius",
    "startAngle",
    "endAngle",
    "width",
    "height",
    "layout",
    "labelPosition",
    "labelColor",
    "labelTextOpacity",
    "labelBackgroundOpacity",
    "trackBorderWidth",
    "trackBorderColor",
    "trackType",
    "tickPositions",
    "scaledHeight",
    "backgroundColor"
  ],
  defaultOptions: {
    innerRadius: 340,
    outerRadius: 310,
    startAngle: 0,
    endAngle: 360,
    width: 700,
    height: 700,
    layout: "linear",
    labelPosition: "none",
    labelColor: "black",
    labelTextOpacity: 0.4,
    trackBorderWidth: 0,
    trackBorderColor: "black",
    tickPositions: ["even", "ends"][0],
    backgroundColor: "transparent"
  }
};
function BrushTrack(HGC, ...args) {
  if (!new.target) {
    throw new Error('Uncaught TypeError: Class constructor cannot be invoked without "new"');
  }
  class BrushTrackClass extends HGC.tracks.SVGTrack {
    constructor(params) {
      super(...params);
      var _a, _b;
      const [context2, options] = params;
      const { registerViewportChanged, removeViewportChanged, setDomainsCallback } = context2;
      this.uid = v1();
      this.options = options;
      this.hasFromView = !context2.projectionXDomain;
      this.removeViewportChanged = removeViewportChanged;
      this.setDomainsCallback = setDomainsCallback;
      this.viewportXDomain = this.hasFromView ? null : context2.projectionXDomain;
      this.viewportYDomain = this.hasFromView ? null : [0, 0];
      this.prevExtent = [0, 0];
      this.RR = 0.02;
      const extent = [0, Math.PI * 1.7];
      this.circularBrushData = this.getBrushData(extent);
      this.brush = arc().innerRadius((_a = this.options.innerRadius) != null ? _a : 100).outerRadius((_b = this.options.outerRadius) != null ? _b : 200);
      this.gBrush = this.gMain.append("g").attr("id", `brush-${this.uid}`).selectAll(".brush").data(this.circularBrushData).enter().append("path").attr("class", "brush").attr("d", this.brush).attr("fill", this.options.projectionFillColor).attr("stroke", this.options.projectionStrokeColor).attr("fill-opacity", (d) => d.type === "brush" ? this.options.projectionFillOpacity : 0).attr("stroke-opacity", (d) => d.type === "brush" ? this.options.projectionStrokeOpacity : 0).attr("stroke-width", this.options.strokeWidth).style("pointer-events", "all").style("cursor", (d) => d.cursor).call(this.dragged());
      registerViewportChanged(this.uid, this.viewportChanged.bind(this));
      this.draw();
    }
    getBrushData(extent) {
      return [
        {
          type: "brush",
          startAngle: extent[0],
          endAngle: extent[1],
          cursor: "grab"
        },
        {
          type: "start",
          startAngle: extent[0],
          endAngle: extent[0] + this.RR,
          cursor: "move"
        },
        {
          type: "end",
          startAngle: extent[1] - this.RR,
          endAngle: extent[1],
          cursor: "move"
        }
      ];
    }
    cropExtent(extent) {
      let [s, e] = extent;
      let round = 0;
      while (s > Math.PI * 2 || e > Math.PI * 2 || s < 0 || e < 0) {
        if (round++ > 10) {
          break;
        }
        if (s > Math.PI * 2 || e > Math.PI * 2) {
          s -= Math.PI * 2;
          e -= Math.PI * 2;
        } else if (s < 0 || e < 0) {
          s += Math.PI * 2;
          e += Math.PI * 2;
        }
      }
      return [s, e].sort((a, b) => a - b);
    }
    updateBrush(extent) {
      let [s, e] = extent;
      if (s <= RADIAN_GAP && e <= RADIAN_GAP || s >= Math.PI * 2 - RADIAN_GAP && e >= Math.PI * 2 - RADIAN_GAP) {
        this.gBrush.attr("visibility", "hidden");
        return;
      }
      if (s < RADIAN_GAP) {
        s = RADIAN_GAP;
      }
      if (s > Math.PI * 2 - RADIAN_GAP) {
        s = Math.PI * 2 - RADIAN_GAP;
      }
      if (e < RADIAN_GAP) {
        e = RADIAN_GAP;
      }
      if (e > Math.PI * 2 - RADIAN_GAP) {
        e = Math.PI * 2 - RADIAN_GAP;
      }
      this.circularBrushData = this.getBrushData(extent);
      this.gBrush.data(this.circularBrushData).attr("d", this.brush).attr("visibility", "visible");
    }
    dragged() {
      const start = () => {
        this.startEvent = HGC.libraries.d3Selection.event.sourceEvent;
        this.prevExtent = [this.circularBrushData[0].startAngle, this.circularBrushData[0].endAngle];
      };
      const drag = (d) => {
        const [x, y] = this.position;
        const [w, h] = this.dimensions;
        const endEvent = HGC.libraries.d3Selection.event.sourceEvent;
        const startX = this.startEvent.layerX - x;
        const startY = this.startEvent.layerY - y;
        const endX = endEvent.layerX - x;
        const endY = endEvent.layerY - y;
        const radDiff = Math.atan2(startX - w / 2, startY - h / 2) - Math.atan2(endX - w / 2, endY - h / 2);
        let [s, e] = this.prevExtent;
        if (d.type === "brush") {
          s = s + radDiff;
          e = e + radDiff;
          if (s < RADIAN_GAP || Math.PI * 2 - RADIAN_GAP < e) {
            const sto = RADIAN_GAP - s;
            const eto = e - (Math.PI * 2 - RADIAN_GAP);
            if (sto > eto) {
              e += sto;
              s += sto;
            } else {
              s -= eto;
              e -= eto;
            }
          }
        } else if (d.type === "start") {
          s = s + radDiff;
        } else if (d.type === "end") {
          e = e + radDiff;
        }
        [s, e] = this.cropExtent([s, e]);
        if (!this._xScale || !this._yScale) {
          return;
        }
        const scale = (this.options.endAngle - this.options.startAngle) / 360;
        const offsetedS = s - this.options.startAngle / 360 * Math.PI * 2;
        const offsetedE = e - this.options.startAngle / 360 * Math.PI * 2;
        const xDomain = [
          this._xScale.invert(w - w * offsetedE / (Math.PI * 2 * scale)),
          this._xScale.invert(w - w * offsetedS / (Math.PI * 2 * scale))
        ];
        const yDomain = this.viewportYDomain;
        if (!this.hasFromView) {
          this.viewportXDomain = xDomain;
        }
        this.setDomainsCallback(xDomain, yDomain);
        this.updateBrush([s, e]);
      };
      return HGC.libraries.d3Drag.drag().on("start", start).on("drag", drag);
    }
    draw() {
      if (!this._xScale || !this.yScale) {
        return;
      }
      if (!this.viewportXDomain || !this.viewportYDomain) {
        return;
      }
      const x0 = this._xScale(this.viewportXDomain[0]);
      const x1 = this._xScale(this.viewportXDomain[1]);
      const [w] = this.dimensions;
      let e = valueToRadian(x0, w, this.options.startAngle, this.options.endAngle) + Math.PI / 2;
      let s = valueToRadian(x1, w, this.options.startAngle, this.options.endAngle) + Math.PI / 2;
      [s, e] = this.cropExtent([s, e]);
      this.updateBrush([s, e]);
    }
    viewportChanged(viewportXScale, viewportYScale) {
      const viewportXDomain = viewportXScale.domain();
      const viewportYDomain = viewportYScale.domain();
      this.viewportXDomain = viewportXDomain;
      this.viewportYDomain = viewportYDomain;
      this.draw();
    }
    remove() {
      this.removeViewportChanged(this.uid);
      super.remove();
    }
    rerender() {
    }
    zoomed(newXScale, newYScale) {
      this.xScale(newXScale);
      this.yScale(newYScale);
      this.draw();
    }
    setPosition(newPosition) {
      super.setPosition(newPosition);
      this.draw();
    }
    setDimensions(newDimensions) {
      super.setDimensions(newDimensions);
      this.gBrush.attr("transform", `translate(${newDimensions[0] / 2},${newDimensions[1] / 2})`);
      this.draw();
    }
  }
  return new BrushTrackClass(args);
}
const gosling_es_icon = '<svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 5640 5420" preserveAspectRatio="xMidYMid meet"> <g id="layer101" fill="#000000" stroke="none"> <path d="M0 2710 l0 -2710 2820 0 2820 0 0 2710 0 2710 -2820 0 -2820 0 0 -2710z"/> </g> <g id="layer102" fill="#750075" stroke="none"> <path d="M200 4480 l0 -740 630 0 630 0 0 740 0 740 -630 0 -630 0 0 -740z"/> <path d="M1660 4420 l0 -800 570 0 570 0 0 800 0 800 -570 0 -570 0 0 -800z"/> <path d="M3000 3450 l0 -1770 570 0 570 0 0 1770 0 1770 -570 0 -570 0 0 -1770z"/> <path d="M4340 2710 l0 -2510 560 0 560 0 0 2510 0 2510 -560 0 -560 0 0 -2510z"/> <path d="M200 1870 l0 -1670 630 0 630 0 0 1670 0 1670 -630 0 -630 0 0 -1670z"/> <path d="M1660 1810 l0 -1610 570 0 570 0 0 1610 0 1610 -570 0 -570 0 0 -1610z"/> <path d="M3000 840 l0 -640 570 0 570 0 0 640 0 640 -570 0 -570 0 0 -640z"/> </g> <g id="layer103" fill="#ffff04" stroke="none"> <path d="M200 4480 l0 -740 630 0 630 0 0 740 0 740 -630 0 -630 0 0 -740z"/> <path d="M1660 4420 l0 -800 570 0 570 0 0 800 0 800 -570 0 -570 0 0 -800z"/> <path d="M3000 3450 l0 -1770 570 0 570 0 0 1770 0 1770 -570 0 -570 0 0 -1770z"/> </g> </svg>';
BrushTrack.config = {
  type: "brush-track",
  datatype: ["projection"],
  local: false,
  projection: true,
  orientation: "2d",
  thumbnail: new DOMParser().parseFromString(gosling_es_icon, "text/xml").documentElement,
  availableOptions: [
    "innerRadius",
    "outerRadius",
    "startAngle",
    "endAngle",
    "axisPositionHorizontal",
    "projectionFillColor",
    "projectionStrokeColor",
    "projectionFillOpacity",
    "projectionStrokeOpacity",
    "strokeWidth"
  ],
  defaultOptions: {
    innerRadius: 100,
    outerRadius: 200,
    startAngle: 0,
    endAngle: 360,
    axisPositionHorizontal: "left",
    projectionFillColor: "#777",
    projectionStrokeColor: "#777",
    projectionFillOpacity: 0.3,
    projectionStrokeOpacity: 0.7,
    strokeWidth: 1
  }
};
function filterData(filter2, data2) {
  const { field, not: not3 } = filter2;
  let output = Array.from(data2);
  if (IsOneOfFilter(filter2)) {
    const { oneOf: oneOf2 } = filter2;
    output = output.filter((d) => {
      return not3 ? oneOf2.indexOf(d[field]) === -1 : oneOf2.indexOf(d[field]) !== -1;
    });
  } else if (IsRangeFilter(filter2)) {
    const { inRange } = filter2;
    output = output.filter((d) => {
      return not3 ? !(inRange[0] <= d[field] && d[field] <= inRange[1]) : inRange[0] <= d[field] && d[field] <= inRange[1];
    });
  } else if (IsIncludeFilter(filter2)) {
    const { include } = filter2;
    output = output.filter((d) => {
      return not3 ? `${d[field]}`.includes(include) : !`${d[field]}`.includes(include);
    });
  }
  return output;
}
function concatString(concat2, data2) {
  const { fields, separator, newField } = concat2;
  let output = Array.from(data2);
  output = output.map((d) => {
    const strs = fields.map((f2) => d[f2]);
    d[newField] = strs.join(separator);
    return d;
  });
  return output;
}
function replaceString(_, data2) {
  const { field, replace, newField } = _;
  let output = Array.from(data2);
  output = output.map((d) => {
    d[newField] = d[field];
    replace.forEach((r) => {
      const { from: from2, to } = r;
      d[newField] = d[newField].toString().replaceAll(from2, to);
    });
    return d;
  });
  return output;
}
function calculateData(log, data2) {
  const { field, base, newField } = log;
  let output = Array.from(data2);
  output = output.map((d) => {
    if (+d[field]) {
      if (base === "e") {
        d[newField != null ? newField : field] = Math.log(+d[field]);
      } else {
        d[newField != null ? newField : field] = Math.log(+d[field]) / Math.log(base != null ? base : 10);
      }
    }
    return d;
  });
  return output;
}
function calculateGenomicLength(_, data2) {
  const { startField, endField, newField } = _;
  const output = Array.from(data2);
  output.forEach((d) => {
    const s = d[startField];
    const e = d[endField];
    if (!s || !e) {
      return;
    }
    d[newField] = Math.abs(+e - +s);
  });
  return output;
}
function aggregateCoverage(_, data2, scale) {
  const { startField, endField, newField, groupField } = _;
  const coverage = {};
  const binSize = 1;
  data2.forEach((d) => {
    const curStart = scale(d[startField]);
    const curEnd = scale(d[endField]);
    const group2 = groupField ? d[groupField] : "__NO_GROUP__";
    const adjustedStart = Math.floor(curStart);
    for (let i = adjustedStart; i < curEnd; i += binSize) {
      if (!coverage[group2]) {
        coverage[group2] = {};
      }
      if (!coverage[group2][i]) {
        coverage[group2][i] = 0;
      }
      coverage[group2][i]++;
    }
  });
  const output = Object.entries(coverage).flatMap((group2) => {
    const [groupName, coverageRecords] = group2;
    return Object.entries(coverageRecords).map((entry) => {
      const [key, value] = entry;
      return {
        [startField]: scale.invert(+key),
        [endField]: scale.invert(+key + binSize),
        [newField != null ? newField : "coverage"]: value,
        [groupField != null ? groupField : "group"]: groupName
      };
    });
  });
  return output;
}
function displace(t, data2, scale) {
  const { boundingBox, method, newField } = t;
  const { startField, endField, groupField } = boundingBox;
  let padding = 0;
  if (boundingBox.padding && scale && !boundingBox.isPaddingBP) {
    padding = Math.abs(scale.invert(boundingBox.padding) - scale.invert(0));
  } else if (boundingBox.padding && boundingBox.isPaddingBP) {
    padding = boundingBox.padding;
  }
  const base = Array.from(data2);
  if (base && base.length > 0) {
    if (!Object.keys(base[0]).find((d) => d === startField) || !Object.keys(base[0]).find((d) => d === endField)) {
      return base;
    }
  }
  if (method === "pile") {
    {
      const { maxRows } = t;
      const occupiedSpaceInRows = {};
      const sorted = base.sort((a, b) => a[startField] - b[startField]);
      sorted.forEach((d) => {
        const start = d[startField] - padding;
        const end = d[endField] + padding;
        const group2 = groupField ? d[groupField] : "__NO_GROUP__";
        if (!occupiedSpaceInRows[group2]) {
          occupiedSpaceInRows[group2] = [];
        }
        let rowIndex = occupiedSpaceInRows[group2].findIndex((d2) => {
          if (end < d2.start) {
            d2.start = start;
            return true;
          } else if (d2.end < start) {
            d2.end = end;
            return true;
          }
          return false;
        });
        if (rowIndex === -1) {
          occupiedSpaceInRows[group2].push({ start, end });
          rowIndex = occupiedSpaceInRows[group2].length - 1;
        }
        d[newField] = `${maxRows && maxRows <= rowIndex ? maxRows - 1 : rowIndex}`;
      });
    }
  } else if (method === "spread") {
    const boundingBoxes = [];
    base.sort((a, b) => a[startField] - b[startField]).forEach((d) => {
      let start = d[startField] - padding;
      let end = d[endField] + padding;
      let overlapped = boundingBoxes.filter((box) => box.start === start && end === box.end || box.start < start && start < box.end || box.start < end && end < box.end || start < box.start && box.end < end);
      if (overlapped.length > 0) {
        let trial = 0;
        do {
          overlapped = boundingBoxes.filter((box) => box.start === start && end === box.end || box.start < start && start < box.end || box.start < end && end < box.end || start < box.start && box.end < end);
          if (overlapped.length > 0) {
            if (trial % 2 === 0) {
              start += padding * trial;
              end += padding * trial;
            } else {
              start -= padding * trial;
              end -= padding * trial;
            }
          }
          trial++;
        } while (overlapped.length > 0 && trial < 1e3);
      }
      d[`${newField}Start`] = `${start + padding}`;
      d[`${newField}Etart`] = `${end - padding}`;
      boundingBoxes.push({ start, end });
    });
  }
  return base;
}
function splitExon(split, data2, assembly = "hg38") {
  const { separator, fields, flag } = split;
  let output = Array.from(data2);
  output = output.map((d) => {
    const newRows = [];
    fields.forEach((f2) => {
      const { field, type: type2, newField, chrField } = f2;
      const splitted = d[field].toString().split(separator);
      splitted.forEach((s, i) => {
        let newValue = s;
        if (type2 === "genomic") {
          newValue = GET_CHROM_SIZES(assembly).interval[d[chrField]][0] + +s;
        }
        if (!newRows[i]) {
          newRows[i] = lodash_es_assign(JSON.parse(JSON.stringify(d)), {
            [newField]: newValue,
            [flag.field]: flag.value
          });
        } else {
          newRows[i][newField] = newValue;
        }
      });
    });
    return [d, ...newRows];
  }).reduce((a, b) => a.concat(b), []);
  return output;
}
function parseSubJSON(_, data2) {
  const { field, genomicField, baseGenomicField, genomicLengthField } = _;
  let output = Array.from(data2);
  output = output.map((d) => {
    let newRows = JSON.parse(d[field]);
    newRows = newRows.map((row) => {
      var _a, _b;
      if (row[genomicField] && d[baseGenomicField]) {
        row[`${genomicField}_start`] = +row[genomicField] + +d[baseGenomicField];
        row[`${genomicField}_end`] = +row[genomicField] + +d[baseGenomicField] + +row[genomicLengthField];
      }
      return lodash_es_assign(JSON.parse(JSON.stringify(d)), {
        ...row,
        [`${genomicField}_start`]: row[`${genomicField}_start`],
        [`${genomicField}_end`]: row[`${genomicField}_end`],
        type: (_b = (_a = row.type) != null ? _a : row.variant) != null ? _b : null,
        isParsedRow: "yes"
      });
    });
    return [d, ...newRows];
  }).reduce((a, b) => a.concat(b), []);
  return output;
}
function aggregateData(spec, data2) {
  if (getChannelKeysByAggregateFnc(spec).length === 0) {
    return data2;
  }
  const nChannelKeys = getChannelKeysByType(spec, "nominal");
  if (nChannelKeys.length !== 1) {
    console.warn("Currently, we only support aggregating datasets with single nominal field.");
    return data2;
  }
  const nFieldSpec = spec[nChannelKeys[0]];
  if (!IsChannelDeep(nFieldSpec)) {
    return data2;
  }
  const nField = nFieldSpec.field;
  if (!nField) {
    return data2;
  }
  const qChannelKeys = [...getChannelKeysByType(spec, "quantitative"), ...getChannelKeysByType(spec, "genomic")];
  const aggregated = [];
  const uniqueCategories = Array.from(new Set(data2.map((d) => d[nField])));
  let failed = false;
  uniqueCategories.forEach((c) => {
    const datum = {};
    datum[nField] = c;
    qChannelKeys.forEach((q) => {
      const qFieldSpec = spec[q];
      if (!IsChannelDeep(qFieldSpec)) {
        failed = true;
        return;
      }
      const { field: qField } = qFieldSpec;
      if (!qField || !("aggregate" in qFieldSpec)) {
        failed = true;
        return;
      }
      datum[qField] = qFieldSpec.aggregate === "max" ? Math.max(...data2.filter((d) => d[nField] === c).map((d) => +d[qField])) : Math.min(...data2.filter((d) => d[nField] === c).map((d) => +d[qField]));
    });
    aggregated.push(datum);
  });
  return !failed ? aggregated : data2;
}
function CSVDataFetcher(HGC, ...args) {
  if (!new.target) {
    throw new Error('Uncaught TypeError: Class constructor cannot be invoked without "new"');
  }
  class CSVDataFetcherClass {
    constructor(params) {
      const [dataConfig] = params;
      this.dataConfig = dataConfig;
      this.tilesetInfoLoading = false;
      this.assembly = this.dataConfig.assembly;
      this.filter = this.dataConfig.filter;
      if (!dataConfig.url) {
        console.error("Please provide the `url` of the data");
        return;
      }
      const chromosomeSizes = GET_CHROM_SIZES(this.assembly).size;
      const chromosomeCumPositions = [];
      const chromosomePositions = {};
      let prevEndPosition = 0;
      Object.keys(GET_CHROM_SIZES(this.assembly).size).forEach((chrStr, i) => {
        const positionInfo = {
          id: i,
          chr: chrStr,
          pos: prevEndPosition
        };
        chromosomeCumPositions.push(positionInfo);
        chromosomePositions[chrStr] = positionInfo;
        prevEndPosition += GET_CHROM_SIZES(this.assembly).size[chrStr];
      });
      this.chromSizes = {
        chrToAbs: (chrom, chromPos) => this.chromSizes.chrPositions[chrom].pos + chromPos,
        cumPositions: chromosomeCumPositions,
        chrPositions: chromosomePositions,
        totalLength: prevEndPosition,
        chromLengths: chromosomeSizes
      };
      if (dataConfig.data) {
        this.values = dataConfig.data;
      } else {
        this.dataPromise = this.fetchCSV();
      }
    }
    fetchCSV() {
      var _a;
      const {
        url,
        chromosomeField,
        genomicFields,
        headerNames,
        chromosomePrefix,
        longToWideId,
        genomicFieldsToConvert
      } = this.dataConfig;
      const separator = (_a = this.dataConfig.separator) != null ? _a : ",";
      return fetch(url).then((response) => {
        return response.ok ? response.text() : Promise.reject(response.status);
      }).then((text) => {
        const textWithHeader = headerNames ? `${headerNames.join(separator)}
${text}` : text;
        return dsv(separator).parse(textWithHeader, (row) => {
          let successfullyGotChrInfo = true;
          if (genomicFieldsToConvert) {
            genomicFieldsToConvert.forEach((d) => {
              const cField = d.chromosomeField;
              d.genomicFields.forEach((g) => {
                try {
                  if (this.assembly !== "unknown") {
                    const chr = chromosomePrefix ? row[cField].replace(chromosomePrefix, "chr") : row[cField].includes("chr") ? row[cField] : `chr${row[cField]}`;
                    row[g] = GET_CHROM_SIZES(this.assembly).interval[chr][0] + +row[g];
                  } else {
                  }
                } catch (e) {
                  successfullyGotChrInfo = false;
                }
              });
            });
          } else {
            genomicFields.forEach((g) => {
              if (!row[chromosomeField]) {
                return;
              }
              try {
                const chr = chromosomePrefix ? row[chromosomeField].replace(chromosomePrefix, "chr") : row[chromosomeField].includes("chr") ? row[chromosomeField] : `chr${row[chromosomeField]}`;
                row[g] = GET_CHROM_SIZES(this.assembly).interval[chr][0] + +row[g];
              } catch (e) {
                successfullyGotChrInfo = false;
              }
            });
          }
          if (!successfullyGotChrInfo) {
            return void 0;
          }
          return row;
        });
      }).then((json) => {
        var _a2;
        if (longToWideId && ((_a2 = json[0]) == null ? void 0 : _a2[longToWideId])) {
          const keys = Object.keys(json[0]);
          const newJson = {};
          json.forEach((d) => {
            if (!newJson[d[longToWideId]]) {
              newJson[d[longToWideId]] = JSON.parse(JSON.stringify(d));
            } else {
              keys.forEach((k) => {
                newJson[d[longToWideId]][`${k}_2`] = d[k];
              });
            }
          });
          this.values = Object.keys(newJson).map((k) => newJson[k]);
        } else {
          this.values = json;
        }
      }).catch((error) => {
        console.error("[Gosling Data Fetcher] Error fetching data", error);
      });
    }
    generateTilesetInfo(callback) {
      this.tilesetInfoLoading = false;
      const TILE_SIZE = 1024;
      const totalLength = this.chromSizes.totalLength;
      const retVal = {
        tile_size: TILE_SIZE,
        max_zoom: Math.ceil(Math.log(totalLength / TILE_SIZE) / Math.log(2)),
        max_width: totalLength,
        min_pos: [0, 0],
        max_pos: [totalLength, totalLength]
      };
      if (callback) {
        callback(retVal);
      }
      return retVal;
    }
    tilesetInfo(callback) {
      if (!this.dataPromise) {
        return;
      }
      this.tilesetInfoLoading = true;
      return this.dataPromise.then(() => this.generateTilesetInfo(callback)).catch((err) => {
        this.tilesetInfoLoading = false;
        console.error("[Gosling Data Fetcher] Error parsing data:", err);
      });
    }
    fetchTilesDebounced(receivedTiles, tileIds) {
      const tiles = {};
      const validTileIds = [];
      const tilePromises = [];
      for (const tileId of tileIds) {
        const parts = tileId.split(".");
        const z = parseInt(parts[0], 10);
        const x = parseInt(parts[1], 10);
        const y = parseInt(parts[2], 10);
        if (Number.isNaN(x) || Number.isNaN(z)) {
          console.warn("[Gosling Data Fetcher] Invalid tile zoom or position:", z, x, y);
          continue;
        }
        validTileIds.push(tileId);
        tilePromises.push(this.tile(z, x, y));
      }
      Promise.all(tilePromises).then((values) => {
        values.forEach((value, i) => {
          const validTileId = validTileIds[i];
          tiles[validTileId] = value;
          tiles[validTileId].tilePositionId = validTileId;
        });
        receivedTiles(tiles);
      });
      return tiles;
    }
    tile(z, x, y) {
      var _a;
      return (_a = this.tilesetInfo()) == null ? void 0 : _a.then((tsInfo) => {
        var _a2, _b;
        const tileWidth = +tsInfo.max_width / 2 ** +z;
        const minX = tsInfo.min_pos[0] + x * tileWidth;
        const maxX = tsInfo.min_pos[0] + (x + 1) * tileWidth;
        let tabularData = this.values.filter((d) => {
          if (this.dataConfig.genomicFields) {
            return this.dataConfig.genomicFields.find((g) => minX < d[g] && d[g] <= maxX);
          } else {
            const allGenomicFields = [];
            this.dataConfig.genomicFieldsToConvert.forEach((d2) => allGenomicFields.push(...d2.genomicFields));
            return allGenomicFields.find((g) => minX < d[g] && d[g] <= maxX);
          }
        });
        (_a2 = this.filter) == null ? void 0 : _a2.forEach((f2) => {
          tabularData = filterData(f2, tabularData);
        });
        const sizeLimit = (_b = this.dataConfig.sampleLength) != null ? _b : 1e3;
        return {
          tabularData: tabularData.length > sizeLimit ? lodash_es_sampleSize(tabularData, sizeLimit) : tabularData,
          server: null,
          tilePos: [x, y],
          zoomLevel: z
        };
      });
    }
  }
  return new CSVDataFetcherClass(args);
}
CSVDataFetcher.config = {
  type: "csv"
};
function RawDataFetcher(HGC, ...args) {
  if (!new.target) {
    throw new Error('Uncaught TypeError: Class constructor cannot be invoked without "new"');
  }
  class RawDataFetcherClass {
    constructor(params) {
      const [dataConfig] = params;
      this.dataConfig = dataConfig;
      this.tilesetInfoLoading = false;
      this.assembly = this.dataConfig.assembly;
      if (!dataConfig.values) {
        console.error("Please provide `values` of the raw data");
        return;
      }
      const chromosomeSizes = GET_CHROM_SIZES(this.assembly).size;
      const chromosomeCumPositions = [];
      const chromosomePositions = {};
      let prevEndPosition = 0;
      Object.keys(GET_CHROM_SIZES(this.assembly).size).forEach((chrStr, i) => {
        const positionInfo = {
          id: i,
          chr: chrStr,
          pos: prevEndPosition
        };
        chromosomeCumPositions.push(positionInfo);
        chromosomePositions[chrStr] = positionInfo;
        prevEndPosition += GET_CHROM_SIZES(this.assembly).size[chrStr];
      });
      this.chromSizes = {
        chrToAbs: (chrom, chromPos) => this.chromSizes.chrPositions[chrom].pos + chromPos,
        cumPositions: chromosomeCumPositions,
        chrPositions: chromosomePositions,
        totalLength: prevEndPosition,
        chromLengths: chromosomeSizes
      };
      this.values = dataConfig.values.map((row) => {
        let successfullyGotChrInfo = true;
        this.dataConfig.genomicFields.forEach((g) => {
          if (!row[this.dataConfig.chromosomeField]) {
            return;
          }
          try {
            const chr = row[this.dataConfig.chromosomeField].includes("chr") ? row[this.dataConfig.chromosomeField] : `chr${row[this.dataConfig.chromosomeField]}`;
            row[g] = GET_CHROM_SIZES(this.assembly).interval[chr][0] + +row[g];
          } catch (e) {
            successfullyGotChrInfo = false;
          }
        });
        if (!successfullyGotChrInfo) {
          return void 0;
        }
        return row;
      });
    }
    tilesetInfo(callback) {
      this.tilesetInfoLoading = false;
      const TILE_SIZE = 1024;
      const totalLength = this.chromSizes.totalLength;
      const retVal = {
        tile_size: TILE_SIZE,
        max_zoom: Math.ceil(Math.log(totalLength / TILE_SIZE) / Math.log(2)),
        max_width: totalLength,
        min_pos: [0],
        max_pos: [totalLength]
      };
      if (callback) {
        callback(retVal);
      }
      return retVal;
    }
    fetchTilesDebounced(receivedTiles, tileIds) {
      const tiles = {};
      const validTileIds = [];
      const tilePromises = [];
      for (const tileId of tileIds) {
        const parts = tileId.split(".");
        const z = parseInt(parts[0], 10);
        const x = parseInt(parts[1], 10);
        if (Number.isNaN(x) || Number.isNaN(z)) {
          console.warn("[Gosling Data Fetcher] Invalid tile zoom or position:", z, x);
          continue;
        }
        validTileIds.push(tileId);
        tilePromises.push(this.tile(z, x));
      }
      Promise.all(tilePromises).then((values) => {
        values.forEach((value, i) => {
          const validTileId = validTileIds[i];
          tiles[validTileId] = value;
          tiles[validTileId].tilePositionId = validTileId;
        });
        receivedTiles(tiles);
      });
      return tiles;
    }
    tile(z, x) {
      var _a;
      const tsInfo = this.tilesetInfo();
      const tileWidth = +tsInfo.max_width / 2 ** +z;
      const minX = tsInfo.min_pos[0] + x * tileWidth;
      const maxX = tsInfo.min_pos[0] + (x + 1) * tileWidth;
      let tabularData = this.values;
      const sizeLimit = (_a = this.dataConfig.sampleLength) != null ? _a : 1e3;
      if (sizeLimit < tabularData.length) {
        tabularData = tabularData.filter((d) => {
          return this.dataConfig.genomicFields.find((g) => minX < d[g] && d[g] <= maxX);
        });
      }
      if (sizeLimit < tabularData.length) {
        tabularData = lodash_es_sampleSize(tabularData, sizeLimit);
      }
      return {
        tabularData,
        server: null,
        tilePos: [x],
        zoomLevel: z
      };
    }
  }
  return new RawDataFetcherClass(args);
}
RawDataFetcher.config = {
  type: "json"
};
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : typeof self !== "undefined" ? self : {};
function getAugmentedNamespace(n) {
  if (n.__esModule)
    return n;
  var a = Object.defineProperty({}, "__esModule", { value: true });
  Object.keys(n).forEach(function(k) {
    var d = Object.getOwnPropertyDescriptor(n, k);
    Object.defineProperty(a, k, d.get ? d : {
      enumerable: true,
      get: function() {
        return n[k];
      }
    });
  });
  return a;
}
var dist$1 = {};
var bigwig = {};
var interopRequireDefault = { exports: {} };
(function(module2) {
  function _interopRequireDefault2(obj) {
    return obj && obj.__esModule ? obj : {
      "default": obj
    };
  }
  module2.exports = _interopRequireDefault2;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(interopRequireDefault);
var runtime = { exports: {} };
(function(module2) {
  var runtime2 = function(exports2) {
    var Op = Object.prototype;
    var hasOwn = Op.hasOwnProperty;
    var undefined$1;
    var $Symbol = typeof Symbol === "function" ? Symbol : {};
    var iteratorSymbol = $Symbol.iterator || "@@iterator";
    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
    function define(obj, key, value) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
      return obj[key];
    }
    try {
      define({}, "");
    } catch (err) {
      define = function(obj, key, value) {
        return obj[key] = value;
      };
    }
    function wrap(innerFn, outerFn, self2, tryLocsList) {
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
      var generator = Object.create(protoGenerator.prototype);
      var context2 = new Context3(tryLocsList || []);
      generator._invoke = makeInvokeMethod(innerFn, self2, context2);
      return generator;
    }
    exports2.wrap = wrap;
    function tryCatch(fn, obj, arg) {
      try {
        return { type: "normal", arg: fn.call(obj, arg) };
      } catch (err) {
        return { type: "throw", arg: err };
      }
    }
    var GenStateSuspendedStart = "suspendedStart";
    var GenStateSuspendedYield = "suspendedYield";
    var GenStateExecuting = "executing";
    var GenStateCompleted = "completed";
    var ContinueSentinel = {};
    function Generator() {
    }
    function GeneratorFunction() {
    }
    function GeneratorFunctionPrototype() {
    }
    var IteratorPrototype = {};
    define(IteratorPrototype, iteratorSymbol, function() {
      return this;
    });
    var getProto = Object.getPrototypeOf;
    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
      IteratorPrototype = NativeIteratorPrototype;
    }
    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
    GeneratorFunction.prototype = GeneratorFunctionPrototype;
    define(Gp, "constructor", GeneratorFunctionPrototype);
    define(GeneratorFunctionPrototype, "constructor", GeneratorFunction);
    GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction");
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function(method) {
        define(prototype, method, function(arg) {
          return this._invoke(method, arg);
        });
      });
    }
    exports2.isGeneratorFunction = function(genFun) {
      var ctor = typeof genFun === "function" && genFun.constructor;
      return ctor ? ctor === GeneratorFunction || (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
    };
    exports2.mark = function(genFun) {
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
      } else {
        genFun.__proto__ = GeneratorFunctionPrototype;
        define(genFun, toStringTagSymbol, "GeneratorFunction");
      }
      genFun.prototype = Object.create(Gp);
      return genFun;
    };
    exports2.awrap = function(arg) {
      return { __await: arg };
    };
    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve2, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if (record.type === "throw") {
          reject(record.arg);
        } else {
          var result = record.arg;
          var value = result.value;
          if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
            return PromiseImpl.resolve(value.__await).then(function(value2) {
              invoke("next", value2, resolve2, reject);
            }, function(err) {
              invoke("throw", err, resolve2, reject);
            });
          }
          return PromiseImpl.resolve(value).then(function(unwrapped) {
            result.value = unwrapped;
            resolve2(result);
          }, function(error) {
            return invoke("throw", error, resolve2, reject);
          });
        }
      }
      var previousPromise;
      function enqueue(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function(resolve2, reject) {
            invoke(method, arg, resolve2, reject);
          });
        }
        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
      }
      this._invoke = enqueue;
    }
    defineIteratorMethods(AsyncIterator.prototype);
    define(AsyncIterator.prototype, asyncIteratorSymbol, function() {
      return this;
    });
    exports2.AsyncIterator = AsyncIterator;
    exports2.async = function(innerFn, outerFn, self2, tryLocsList, PromiseImpl) {
      if (PromiseImpl === void 0)
        PromiseImpl = Promise;
      var iter = new AsyncIterator(wrap(innerFn, outerFn, self2, tryLocsList), PromiseImpl);
      return exports2.isGeneratorFunction(outerFn) ? iter : iter.next().then(function(result) {
        return result.done ? result.value : iter.next();
      });
    };
    function makeInvokeMethod(innerFn, self2, context2) {
      var state = GenStateSuspendedStart;
      return function invoke(method, arg) {
        if (state === GenStateExecuting) {
          throw new Error("Generator is already running");
        }
        if (state === GenStateCompleted) {
          if (method === "throw") {
            throw arg;
          }
          return doneResult();
        }
        context2.method = method;
        context2.arg = arg;
        while (true) {
          var delegate = context2.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context2);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel)
                continue;
              return delegateResult;
            }
          }
          if (context2.method === "next") {
            context2.sent = context2._sent = context2.arg;
          } else if (context2.method === "throw") {
            if (state === GenStateSuspendedStart) {
              state = GenStateCompleted;
              throw context2.arg;
            }
            context2.dispatchException(context2.arg);
          } else if (context2.method === "return") {
            context2.abrupt("return", context2.arg);
          }
          state = GenStateExecuting;
          var record = tryCatch(innerFn, self2, context2);
          if (record.type === "normal") {
            state = context2.done ? GenStateCompleted : GenStateSuspendedYield;
            if (record.arg === ContinueSentinel) {
              continue;
            }
            return {
              value: record.arg,
              done: context2.done
            };
          } else if (record.type === "throw") {
            state = GenStateCompleted;
            context2.method = "throw";
            context2.arg = record.arg;
          }
        }
      };
    }
    function maybeInvokeDelegate(delegate, context2) {
      var method = delegate.iterator[context2.method];
      if (method === undefined$1) {
        context2.delegate = null;
        if (context2.method === "throw") {
          if (delegate.iterator["return"]) {
            context2.method = "return";
            context2.arg = undefined$1;
            maybeInvokeDelegate(delegate, context2);
            if (context2.method === "throw") {
              return ContinueSentinel;
            }
          }
          context2.method = "throw";
          context2.arg = new TypeError("The iterator does not provide a 'throw' method");
        }
        return ContinueSentinel;
      }
      var record = tryCatch(method, delegate.iterator, context2.arg);
      if (record.type === "throw") {
        context2.method = "throw";
        context2.arg = record.arg;
        context2.delegate = null;
        return ContinueSentinel;
      }
      var info = record.arg;
      if (!info) {
        context2.method = "throw";
        context2.arg = new TypeError("iterator result is not an object");
        context2.delegate = null;
        return ContinueSentinel;
      }
      if (info.done) {
        context2[delegate.resultName] = info.value;
        context2.next = delegate.nextLoc;
        if (context2.method !== "return") {
          context2.method = "next";
          context2.arg = undefined$1;
        }
      } else {
        return info;
      }
      context2.delegate = null;
      return ContinueSentinel;
    }
    defineIteratorMethods(Gp);
    define(Gp, toStringTagSymbol, "Generator");
    define(Gp, iteratorSymbol, function() {
      return this;
    });
    define(Gp, "toString", function() {
      return "[object Generator]";
    });
    function pushTryEntry(locs) {
      var entry = { tryLoc: locs[0] };
      if (1 in locs) {
        entry.catchLoc = locs[1];
      }
      if (2 in locs) {
        entry.finallyLoc = locs[2];
        entry.afterLoc = locs[3];
      }
      this.tryEntries.push(entry);
    }
    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal";
      delete record.arg;
      entry.completion = record;
    }
    function Context3(tryLocsList) {
      this.tryEntries = [{ tryLoc: "root" }];
      tryLocsList.forEach(pushTryEntry, this);
      this.reset(true);
    }
    exports2.keys = function(object) {
      var keys = [];
      for (var key in object) {
        keys.push(key);
      }
      keys.reverse();
      return function next() {
        while (keys.length) {
          var key2 = keys.pop();
          if (key2 in object) {
            next.value = key2;
            next.done = false;
            return next;
          }
        }
        next.done = true;
        return next;
      };
    };
    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) {
          return iteratorMethod.call(iterable);
        }
        if (typeof iterable.next === "function") {
          return iterable;
        }
        if (!isNaN(iterable.length)) {
          var i = -1, next = function next2() {
            while (++i < iterable.length) {
              if (hasOwn.call(iterable, i)) {
                next2.value = iterable[i];
                next2.done = false;
                return next2;
              }
            }
            next2.value = undefined$1;
            next2.done = true;
            return next2;
          };
          return next.next = next;
        }
      }
      return { next: doneResult };
    }
    exports2.values = values;
    function doneResult() {
      return { value: undefined$1, done: true };
    }
    Context3.prototype = {
      constructor: Context3,
      reset: function(skipTempReset) {
        this.prev = 0;
        this.next = 0;
        this.sent = this._sent = undefined$1;
        this.done = false;
        this.delegate = null;
        this.method = "next";
        this.arg = undefined$1;
        this.tryEntries.forEach(resetTryEntry);
        if (!skipTempReset) {
          for (var name2 in this) {
            if (name2.charAt(0) === "t" && hasOwn.call(this, name2) && !isNaN(+name2.slice(1))) {
              this[name2] = undefined$1;
            }
          }
        }
      },
      stop: function() {
        this.done = true;
        var rootEntry = this.tryEntries[0];
        var rootRecord = rootEntry.completion;
        if (rootRecord.type === "throw") {
          throw rootRecord.arg;
        }
        return this.rval;
      },
      dispatchException: function(exception) {
        if (this.done) {
          throw exception;
        }
        var context2 = this;
        function handle(loc, caught) {
          record.type = "throw";
          record.arg = exception;
          context2.next = loc;
          if (caught) {
            context2.method = "next";
            context2.arg = undefined$1;
          }
          return !!caught;
        }
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          var record = entry.completion;
          if (entry.tryLoc === "root") {
            return handle("end");
          }
          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc");
            var hasFinally = hasOwn.call(entry, "finallyLoc");
            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              } else if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }
            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              }
            } else if (hasFinally) {
              if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }
            } else {
              throw new Error("try statement without catch or finally");
            }
          }
        }
      },
      abrupt: function(type2, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }
        if (finallyEntry && (type2 === "break" || type2 === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
          finallyEntry = null;
        }
        var record = finallyEntry ? finallyEntry.completion : {};
        record.type = type2;
        record.arg = arg;
        if (finallyEntry) {
          this.method = "next";
          this.next = finallyEntry.finallyLoc;
          return ContinueSentinel;
        }
        return this.complete(record);
      },
      complete: function(record, afterLoc) {
        if (record.type === "throw") {
          throw record.arg;
        }
        if (record.type === "break" || record.type === "continue") {
          this.next = record.arg;
        } else if (record.type === "return") {
          this.rval = this.arg = record.arg;
          this.method = "return";
          this.next = "end";
        } else if (record.type === "normal" && afterLoc) {
          this.next = afterLoc;
        }
        return ContinueSentinel;
      },
      finish: function(finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) {
            this.complete(entry.completion, entry.afterLoc);
            resetTryEntry(entry);
            return ContinueSentinel;
          }
        }
      },
      "catch": function(tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if (record.type === "throw") {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }
        throw new Error("illegal catch attempt");
      },
      delegateYield: function(iterable, resultName, nextLoc) {
        this.delegate = {
          iterator: values(iterable),
          resultName,
          nextLoc
        };
        if (this.method === "next") {
          this.arg = undefined$1;
        }
        return ContinueSentinel;
      }
    };
    return exports2;
  }(module2.exports);
  try {
    regeneratorRuntime = runtime2;
  } catch (accidentalStrictMode) {
    if (typeof globalThis === "object") {
      globalThis.regeneratorRuntime = runtime2;
    } else {
      Function("r", "regeneratorRuntime = r")(runtime2);
    }
  }
})(runtime);
var regenerator = runtime.exports;
var asyncToGenerator = { exports: {} };
(function(module2) {
  function asyncGeneratorStep(gen, resolve2, reject, _next, _throw, key, arg) {
    try {
      var info = gen[key](arg);
      var value = info.value;
    } catch (error) {
      reject(error);
      return;
    }
    if (info.done) {
      resolve2(value);
    } else {
      Promise.resolve(value).then(_next, _throw);
    }
  }
  function _asyncToGenerator(fn) {
    return function() {
      var self2 = this, args = arguments;
      return new Promise(function(resolve2, reject) {
        var gen = fn.apply(self2, args);
        function _next(value) {
          asyncGeneratorStep(gen, resolve2, reject, _next, _throw, "next", value);
        }
        function _throw(err) {
          asyncGeneratorStep(gen, resolve2, reject, _next, _throw, "throw", err);
        }
        _next(void 0);
      });
    };
  }
  module2.exports = _asyncToGenerator;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(asyncToGenerator);
var classCallCheck = { exports: {} };
(function(module2) {
  function _classCallCheck3(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  module2.exports = _classCallCheck3;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(classCallCheck);
var createClass = { exports: {} };
(function(module2) {
  function _defineProperties2(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass3(Constructor, protoProps, staticProps) {
    if (protoProps)
      _defineProperties2(Constructor.prototype, protoProps);
    if (staticProps)
      _defineProperties2(Constructor, staticProps);
    return Constructor;
  }
  module2.exports = _createClass3;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(createClass);
var inherits = { exports: {} };
var setPrototypeOf = { exports: {} };
(function(module2) {
  function _setPrototypeOf2(o, p) {
    module2.exports = _setPrototypeOf2 = Object.setPrototypeOf || function _setPrototypeOf3(o2, p2) {
      o2.__proto__ = p2;
      return o2;
    };
    module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
    return _setPrototypeOf2(o, p);
  }
  module2.exports = _setPrototypeOf2;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(setPrototypeOf);
(function(module2) {
  var setPrototypeOf$1 = setPrototypeOf.exports;
  function _inherits3(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass)
      setPrototypeOf$1(subClass, superClass);
  }
  module2.exports = _inherits3;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(inherits);
var possibleConstructorReturn = { exports: {} };
var _typeof$2 = { exports: {} };
(function(module2) {
  function _typeof3(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      module2.exports = _typeof3 = function _typeof4(obj2) {
        return typeof obj2;
      };
      module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
    } else {
      module2.exports = _typeof3 = function _typeof4(obj2) {
        return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
      };
      module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
    }
    return _typeof3(obj);
  }
  module2.exports = _typeof3;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(_typeof$2);
var assertThisInitialized = { exports: {} };
(function(module2) {
  function _assertThisInitialized3(self2) {
    if (self2 === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self2;
  }
  module2.exports = _assertThisInitialized3;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(assertThisInitialized);
(function(module2) {
  var _typeof3 = _typeof$2.exports["default"];
  var assertThisInitialized$1 = assertThisInitialized.exports;
  function _possibleConstructorReturn3(self2, call) {
    if (call && (_typeof3(call) === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }
    return assertThisInitialized$1(self2);
  }
  module2.exports = _possibleConstructorReturn3;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(possibleConstructorReturn);
var getPrototypeOf = { exports: {} };
(function(module2) {
  function _getPrototypeOf3(o) {
    module2.exports = _getPrototypeOf3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf4(o2) {
      return o2.__proto__ || Object.getPrototypeOf(o2);
    };
    module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
    return _getPrototypeOf3(o);
  }
  module2.exports = _getPrototypeOf3;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(getPrototypeOf);
var blockView = {};
var gosling_es_defineProperty = { exports: {} };
(function(module2) {
  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  module2.exports = _defineProperty;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(gosling_es_defineProperty);
var binary_parser = {};
var vmBrowser = {};
function runInThisContext(code) {
  const fn = new Function("code", "return eval(code);");
  return fn.call(globalThis, code);
}
vmBrowser.runInThisContext = runInThisContext;
var context = {};
function _typeof$1(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$1 = function _typeof3(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof$1 = function _typeof3(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof$1(obj);
}
var Context$2 = function Context() {
  this.code = "";
  this.scopes = [["vars"]];
  this.isAsync = false;
  this.bitFields = [];
  this.tmpVariableCount = 0;
  this.references = {};
};
Context$2.prototype.generateVariable = function(name2) {
  var arr = [];
  Array.prototype.push.apply(arr, this.scopes[this.scopes.length - 1]);
  while (/^\$parent\./.test(name2)) {
    arr.pop();
    name2 = name2.replace(/^\$parent\./, "");
  }
  if (name2) {
    arr.push(name2);
  }
  return arr.join(".");
};
Context$2.prototype.generateOption = function(val) {
  switch (_typeof$1(val)) {
    case "number":
      return val.toString();
    case "string":
      return this.generateVariable(val);
    case "function":
      return "(".concat(val, ").call(").concat(this.generateVariable(), ", vars)");
    default:
      return void 0;
  }
};
Context$2.prototype.generateError = function() {
  var args = Array.prototype.slice.call(arguments);
  var err = Context$2.interpolate.apply(this, args);
  if (this.isAsync) {
    this.pushCode("return process.nextTick(function() { callback(new Error(".concat(err, "), vars); });"));
  } else {
    this.pushCode("throw new Error(".concat(err, ");"));
  }
};
Context$2.prototype.generateTmpVariable = function() {
  return "$tmp".concat(this.tmpVariableCount++);
};
Context$2.prototype.pushCode = function() {
  var args = Array.prototype.slice.call(arguments);
  this.code += "".concat(Context$2.interpolate.apply(this, args), "\n");
};
Context$2.prototype.pushPath = function(name2) {
  if (name2) {
    this.scopes[this.scopes.length - 1].push(name2);
  }
};
Context$2.prototype.popPath = function(name2) {
  if (name2) {
    this.scopes[this.scopes.length - 1].pop();
  }
};
Context$2.prototype.pushScope = function(name2) {
  this.scopes.push([name2]);
};
Context$2.prototype.popScope = function() {
  this.scopes.pop();
};
Context$2.prototype.addReference = function(alias) {
  if (this.references[alias])
    return;
  this.references[alias] = { resolved: false, requested: false };
};
Context$2.prototype.markResolved = function(alias) {
  this.references[alias].resolved = true;
};
Context$2.prototype.markRequested = function(aliasList) {
  aliasList.forEach(function(alias) {
    this.references[alias].requested = true;
  }.bind(this));
};
Context$2.prototype.getUnresolvedReferences = function() {
  var references = this.references;
  return Object.keys(this.references).filter(function(alias) {
    return !references[alias].resolved && !references[alias].requested;
  });
};
Context$2.interpolate = function(s) {
  var re2 = /{\d+}/g;
  var matches = s.match(re2);
  var params = Array.prototype.slice.call(arguments, 1);
  if (matches) {
    matches.forEach(function(match) {
      var index = parseInt(match.substr(1, match.length - 2), 10);
      s = s.replace(match, params[index].toString());
    });
  }
  return s;
};
context.Context = Context$2;
var gosling_es_long = Long$1;
var wasm = null;
try {
  wasm = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([
    0,
    97,
    115,
    109,
    1,
    0,
    0,
    0,
    1,
    13,
    2,
    96,
    0,
    1,
    127,
    96,
    4,
    127,
    127,
    127,
    127,
    1,
    127,
    3,
    7,
    6,
    0,
    1,
    1,
    1,
    1,
    1,
    6,
    6,
    1,
    127,
    1,
    65,
    0,
    11,
    7,
    50,
    6,
    3,
    109,
    117,
    108,
    0,
    1,
    5,
    100,
    105,
    118,
    95,
    115,
    0,
    2,
    5,
    100,
    105,
    118,
    95,
    117,
    0,
    3,
    5,
    114,
    101,
    109,
    95,
    115,
    0,
    4,
    5,
    114,
    101,
    109,
    95,
    117,
    0,
    5,
    8,
    103,
    101,
    116,
    95,
    104,
    105,
    103,
    104,
    0,
    0,
    10,
    191,
    1,
    6,
    4,
    0,
    35,
    0,
    11,
    36,
    1,
    1,
    126,
    32,
    0,
    173,
    32,
    1,
    173,
    66,
    32,
    134,
    132,
    32,
    2,
    173,
    32,
    3,
    173,
    66,
    32,
    134,
    132,
    126,
    34,
    4,
    66,
    32,
    135,
    167,
    36,
    0,
    32,
    4,
    167,
    11,
    36,
    1,
    1,
    126,
    32,
    0,
    173,
    32,
    1,
    173,
    66,
    32,
    134,
    132,
    32,
    2,
    173,
    32,
    3,
    173,
    66,
    32,
    134,
    132,
    127,
    34,
    4,
    66,
    32,
    135,
    167,
    36,
    0,
    32,
    4,
    167,
    11,
    36,
    1,
    1,
    126,
    32,
    0,
    173,
    32,
    1,
    173,
    66,
    32,
    134,
    132,
    32,
    2,
    173,
    32,
    3,
    173,
    66,
    32,
    134,
    132,
    128,
    34,
    4,
    66,
    32,
    135,
    167,
    36,
    0,
    32,
    4,
    167,
    11,
    36,
    1,
    1,
    126,
    32,
    0,
    173,
    32,
    1,
    173,
    66,
    32,
    134,
    132,
    32,
    2,
    173,
    32,
    3,
    173,
    66,
    32,
    134,
    132,
    129,
    34,
    4,
    66,
    32,
    135,
    167,
    36,
    0,
    32,
    4,
    167,
    11,
    36,
    1,
    1,
    126,
    32,
    0,
    173,
    32,
    1,
    173,
    66,
    32,
    134,
    132,
    32,
    2,
    173,
    32,
    3,
    173,
    66,
    32,
    134,
    132,
    130,
    34,
    4,
    66,
    32,
    135,
    167,
    36,
    0,
    32,
    4,
    167,
    11
  ])), {}).exports;
} catch (e) {
}
function Long$1(low, high, unsigned) {
  this.low = low | 0;
  this.high = high | 0;
  this.unsigned = !!unsigned;
}
Long$1.prototype.__isLong__;
Object.defineProperty(Long$1.prototype, "__isLong__", { value: true });
function isLong(obj) {
  return (obj && obj["__isLong__"]) === true;
}
Long$1.isLong = isLong;
var INT_CACHE = {};
var UINT_CACHE = {};
function fromInt(value, unsigned) {
  var obj, cachedObj, cache2;
  if (unsigned) {
    value >>>= 0;
    if (cache2 = 0 <= value && value < 256) {
      cachedObj = UINT_CACHE[value];
      if (cachedObj)
        return cachedObj;
    }
    obj = fromBits(value, (value | 0) < 0 ? -1 : 0, true);
    if (cache2)
      UINT_CACHE[value] = obj;
    return obj;
  } else {
    value |= 0;
    if (cache2 = -128 <= value && value < 128) {
      cachedObj = INT_CACHE[value];
      if (cachedObj)
        return cachedObj;
    }
    obj = fromBits(value, value < 0 ? -1 : 0, false);
    if (cache2)
      INT_CACHE[value] = obj;
    return obj;
  }
}
Long$1.fromInt = fromInt;
function fromNumber(value, unsigned) {
  if (isNaN(value))
    return unsigned ? UZERO : gosling_es_ZERO;
  if (unsigned) {
    if (value < 0)
      return UZERO;
    if (value >= TWO_PWR_64_DBL)
      return MAX_UNSIGNED_VALUE;
  } else {
    if (value <= -TWO_PWR_63_DBL)
      return MIN_VALUE;
    if (value + 1 >= TWO_PWR_63_DBL)
      return MAX_VALUE;
  }
  if (value < 0)
    return fromNumber(-value, unsigned).neg();
  return fromBits(value % TWO_PWR_32_DBL | 0, value / TWO_PWR_32_DBL | 0, unsigned);
}
Long$1.fromNumber = fromNumber;
function fromBits(lowBits, highBits, unsigned) {
  return new Long$1(lowBits, highBits, unsigned);
}
Long$1.fromBits = fromBits;
var pow_dbl = Math.pow;
function fromString(str, unsigned, radix) {
  if (str.length === 0)
    throw Error("empty string");
  if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity")
    return gosling_es_ZERO;
  if (typeof unsigned === "number") {
    radix = unsigned, unsigned = false;
  } else {
    unsigned = !!unsigned;
  }
  radix = radix || 10;
  if (radix < 2 || 36 < radix)
    throw RangeError("radix");
  var p;
  if ((p = str.indexOf("-")) > 0)
    throw Error("interior hyphen");
  else if (p === 0) {
    return fromString(str.substring(1), unsigned, radix).neg();
  }
  var radixToPower = fromNumber(pow_dbl(radix, 8));
  var result = gosling_es_ZERO;
  for (var i = 0; i < str.length; i += 8) {
    var size = Math.min(8, str.length - i), value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = fromNumber(pow_dbl(radix, size));
      result = result.mul(power).add(fromNumber(value));
    } else {
      result = result.mul(radixToPower);
      result = result.add(fromNumber(value));
    }
  }
  result.unsigned = unsigned;
  return result;
}
Long$1.fromString = fromString;
function fromValue(val, unsigned) {
  if (typeof val === "number")
    return fromNumber(val, unsigned);
  if (typeof val === "string")
    return fromString(val, unsigned);
  return fromBits(val.low, val.high, typeof unsigned === "boolean" ? unsigned : val.unsigned);
}
Long$1.fromValue = fromValue;
var TWO_PWR_16_DBL = 1 << 16;
var TWO_PWR_24_DBL = 1 << 24;
var TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;
var TWO_PWR_64_DBL = TWO_PWR_32_DBL * TWO_PWR_32_DBL;
var TWO_PWR_63_DBL = TWO_PWR_64_DBL / 2;
var TWO_PWR_24 = fromInt(TWO_PWR_24_DBL);
var gosling_es_ZERO = fromInt(0);
Long$1.ZERO = gosling_es_ZERO;
var UZERO = fromInt(0, true);
Long$1.UZERO = UZERO;
var ONE = fromInt(1);
Long$1.ONE = ONE;
var UONE = fromInt(1, true);
Long$1.UONE = UONE;
var NEG_ONE = fromInt(-1);
Long$1.NEG_ONE = NEG_ONE;
var MAX_VALUE = fromBits(4294967295 | 0, 2147483647 | 0, false);
Long$1.MAX_VALUE = MAX_VALUE;
var MAX_UNSIGNED_VALUE = fromBits(4294967295 | 0, 4294967295 | 0, true);
Long$1.MAX_UNSIGNED_VALUE = MAX_UNSIGNED_VALUE;
var MIN_VALUE = fromBits(0, 2147483648 | 0, false);
Long$1.MIN_VALUE = MIN_VALUE;
var LongPrototype = Long$1.prototype;
LongPrototype.toInt = function toInt() {
  return this.unsigned ? this.low >>> 0 : this.low;
};
LongPrototype.toNumber = function toNumber() {
  if (this.unsigned)
    return (this.high >>> 0) * TWO_PWR_32_DBL + (this.low >>> 0);
  return this.high * TWO_PWR_32_DBL + (this.low >>> 0);
};
LongPrototype.toString = function toString(radix) {
  radix = radix || 10;
  if (radix < 2 || 36 < radix)
    throw RangeError("radix");
  if (this.isZero())
    return "0";
  if (this.isNegative()) {
    if (this.eq(MIN_VALUE)) {
      var radixLong = fromNumber(radix), div = this.div(radixLong), rem1 = div.mul(radixLong).sub(this);
      return div.toString(radix) + rem1.toInt().toString(radix);
    } else
      return "-" + this.neg().toString(radix);
  }
  var radixToPower = fromNumber(pow_dbl(radix, 6), this.unsigned), rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.div(radixToPower), intval = rem.sub(remDiv.mul(radixToPower)).toInt() >>> 0, digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero())
      return digits + result;
    else {
      while (digits.length < 6)
        digits = "0" + digits;
      result = "" + digits + result;
    }
  }
};
LongPrototype.getHighBits = function getHighBits() {
  return this.high;
};
LongPrototype.getHighBitsUnsigned = function getHighBitsUnsigned() {
  return this.high >>> 0;
};
LongPrototype.getLowBits = function getLowBits() {
  return this.low;
};
LongPrototype.getLowBitsUnsigned = function getLowBitsUnsigned() {
  return this.low >>> 0;
};
LongPrototype.getNumBitsAbs = function getNumBitsAbs() {
  if (this.isNegative())
    return this.eq(MIN_VALUE) ? 64 : this.neg().getNumBitsAbs();
  var val = this.high != 0 ? this.high : this.low;
  for (var bit = 31; bit > 0; bit--)
    if ((val & 1 << bit) != 0)
      break;
  return this.high != 0 ? bit + 33 : bit + 1;
};
LongPrototype.isZero = function isZero() {
  return this.high === 0 && this.low === 0;
};
LongPrototype.eqz = LongPrototype.isZero;
LongPrototype.isNegative = function isNegative() {
  return !this.unsigned && this.high < 0;
};
LongPrototype.isPositive = function isPositive() {
  return this.unsigned || this.high >= 0;
};
LongPrototype.isOdd = function isOdd() {
  return (this.low & 1) === 1;
};
LongPrototype.isEven = function isEven() {
  return (this.low & 1) === 0;
};
LongPrototype.equals = function equals(other) {
  if (!isLong(other))
    other = fromValue(other);
  if (this.unsigned !== other.unsigned && this.high >>> 31 === 1 && other.high >>> 31 === 1)
    return false;
  return this.high === other.high && this.low === other.low;
};
LongPrototype.eq = LongPrototype.equals;
LongPrototype.notEquals = function notEquals(other) {
  return !this.eq(other);
};
LongPrototype.neq = LongPrototype.notEquals;
LongPrototype.ne = LongPrototype.notEquals;
LongPrototype.lessThan = function lessThan(other) {
  return this.comp(other) < 0;
};
LongPrototype.lt = LongPrototype.lessThan;
LongPrototype.lessThanOrEqual = function lessThanOrEqual(other) {
  return this.comp(other) <= 0;
};
LongPrototype.lte = LongPrototype.lessThanOrEqual;
LongPrototype.le = LongPrototype.lessThanOrEqual;
LongPrototype.greaterThan = function greaterThan(other) {
  return this.comp(other) > 0;
};
LongPrototype.gt = LongPrototype.greaterThan;
LongPrototype.greaterThanOrEqual = function greaterThanOrEqual(other) {
  return this.comp(other) >= 0;
};
LongPrototype.gte = LongPrototype.greaterThanOrEqual;
LongPrototype.ge = LongPrototype.greaterThanOrEqual;
LongPrototype.compare = function compare(other) {
  if (!isLong(other))
    other = fromValue(other);
  if (this.eq(other))
    return 0;
  var thisNeg = this.isNegative(), otherNeg = other.isNegative();
  if (thisNeg && !otherNeg)
    return -1;
  if (!thisNeg && otherNeg)
    return 1;
  if (!this.unsigned)
    return this.sub(other).isNegative() ? -1 : 1;
  return other.high >>> 0 > this.high >>> 0 || other.high === this.high && other.low >>> 0 > this.low >>> 0 ? -1 : 1;
};
LongPrototype.comp = LongPrototype.compare;
LongPrototype.negate = function negate() {
  if (!this.unsigned && this.eq(MIN_VALUE))
    return MIN_VALUE;
  return this.not().add(ONE);
};
LongPrototype.neg = LongPrototype.negate;
LongPrototype.add = function add(addend) {
  if (!isLong(addend))
    addend = fromValue(addend);
  var a48 = this.high >>> 16;
  var a32 = this.high & 65535;
  var a16 = this.low >>> 16;
  var a00 = this.low & 65535;
  var b48 = addend.high >>> 16;
  var b32 = addend.high & 65535;
  var b16 = addend.low >>> 16;
  var b00 = addend.low & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 + b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 + b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 + b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 + b48;
  c48 &= 65535;
  return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
};
LongPrototype.subtract = function subtract(subtrahend) {
  if (!isLong(subtrahend))
    subtrahend = fromValue(subtrahend);
  return this.add(subtrahend.neg());
};
LongPrototype.sub = LongPrototype.subtract;
LongPrototype.multiply = function multiply(multiplier) {
  if (this.isZero())
    return gosling_es_ZERO;
  if (!isLong(multiplier))
    multiplier = fromValue(multiplier);
  if (wasm) {
    var low = wasm.mul(this.low, this.high, multiplier.low, multiplier.high);
    return fromBits(low, wasm.get_high(), this.unsigned);
  }
  if (multiplier.isZero())
    return gosling_es_ZERO;
  if (this.eq(MIN_VALUE))
    return multiplier.isOdd() ? MIN_VALUE : gosling_es_ZERO;
  if (multiplier.eq(MIN_VALUE))
    return this.isOdd() ? MIN_VALUE : gosling_es_ZERO;
  if (this.isNegative()) {
    if (multiplier.isNegative())
      return this.neg().mul(multiplier.neg());
    else
      return this.neg().mul(multiplier).neg();
  } else if (multiplier.isNegative())
    return this.mul(multiplier.neg()).neg();
  if (this.lt(TWO_PWR_24) && multiplier.lt(TWO_PWR_24))
    return fromNumber(this.toNumber() * multiplier.toNumber(), this.unsigned);
  var a48 = this.high >>> 16;
  var a32 = this.high & 65535;
  var a16 = this.low >>> 16;
  var a00 = this.low & 65535;
  var b48 = multiplier.high >>> 16;
  var b32 = multiplier.high & 65535;
  var b16 = multiplier.low >>> 16;
  var b00 = multiplier.low & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 * b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 * b00;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c16 += a00 * b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 * b00;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a16 * b16;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a00 * b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
  c48 &= 65535;
  return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
};
LongPrototype.mul = LongPrototype.multiply;
LongPrototype.divide = function divide(divisor) {
  if (!isLong(divisor))
    divisor = fromValue(divisor);
  if (divisor.isZero())
    throw Error("division by zero");
  if (wasm) {
    if (!this.unsigned && this.high === -2147483648 && divisor.low === -1 && divisor.high === -1) {
      return this;
    }
    var low = (this.unsigned ? wasm.div_u : wasm.div_s)(this.low, this.high, divisor.low, divisor.high);
    return fromBits(low, wasm.get_high(), this.unsigned);
  }
  if (this.isZero())
    return this.unsigned ? UZERO : gosling_es_ZERO;
  var approx, rem, res;
  if (!this.unsigned) {
    if (this.eq(MIN_VALUE)) {
      if (divisor.eq(ONE) || divisor.eq(NEG_ONE))
        return MIN_VALUE;
      else if (divisor.eq(MIN_VALUE))
        return ONE;
      else {
        var halfThis = this.shr(1);
        approx = halfThis.div(divisor).shl(1);
        if (approx.eq(gosling_es_ZERO)) {
          return divisor.isNegative() ? ONE : NEG_ONE;
        } else {
          rem = this.sub(divisor.mul(approx));
          res = approx.add(rem.div(divisor));
          return res;
        }
      }
    } else if (divisor.eq(MIN_VALUE))
      return this.unsigned ? UZERO : gosling_es_ZERO;
    if (this.isNegative()) {
      if (divisor.isNegative())
        return this.neg().div(divisor.neg());
      return this.neg().div(divisor).neg();
    } else if (divisor.isNegative())
      return this.div(divisor.neg()).neg();
    res = gosling_es_ZERO;
  } else {
    if (!divisor.unsigned)
      divisor = divisor.toUnsigned();
    if (divisor.gt(this))
      return UZERO;
    if (divisor.gt(this.shru(1)))
      return UONE;
    res = UZERO;
  }
  rem = this;
  while (rem.gte(divisor)) {
    approx = Math.max(1, Math.floor(rem.toNumber() / divisor.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2), delta = log2 <= 48 ? 1 : pow_dbl(2, log2 - 48), approxRes = fromNumber(approx), approxRem = approxRes.mul(divisor);
    while (approxRem.isNegative() || approxRem.gt(rem)) {
      approx -= delta;
      approxRes = fromNumber(approx, this.unsigned);
      approxRem = approxRes.mul(divisor);
    }
    if (approxRes.isZero())
      approxRes = ONE;
    res = res.add(approxRes);
    rem = rem.sub(approxRem);
  }
  return res;
};
LongPrototype.div = LongPrototype.divide;
LongPrototype.modulo = function modulo(divisor) {
  if (!isLong(divisor))
    divisor = fromValue(divisor);
  if (wasm) {
    var low = (this.unsigned ? wasm.rem_u : wasm.rem_s)(this.low, this.high, divisor.low, divisor.high);
    return fromBits(low, wasm.get_high(), this.unsigned);
  }
  return this.sub(this.div(divisor).mul(divisor));
};
LongPrototype.mod = LongPrototype.modulo;
LongPrototype.rem = LongPrototype.modulo;
LongPrototype.not = function not() {
  return fromBits(~this.low, ~this.high, this.unsigned);
};
LongPrototype.and = function and(other) {
  if (!isLong(other))
    other = fromValue(other);
  return fromBits(this.low & other.low, this.high & other.high, this.unsigned);
};
LongPrototype.or = function or(other) {
  if (!isLong(other))
    other = fromValue(other);
  return fromBits(this.low | other.low, this.high | other.high, this.unsigned);
};
LongPrototype.xor = function xor(other) {
  if (!isLong(other))
    other = fromValue(other);
  return fromBits(this.low ^ other.low, this.high ^ other.high, this.unsigned);
};
LongPrototype.shiftLeft = function shiftLeft(numBits) {
  if (isLong(numBits))
    numBits = numBits.toInt();
  if ((numBits &= 63) === 0)
    return this;
  else if (numBits < 32)
    return fromBits(this.low << numBits, this.high << numBits | this.low >>> 32 - numBits, this.unsigned);
  else
    return fromBits(0, this.low << numBits - 32, this.unsigned);
};
LongPrototype.shl = LongPrototype.shiftLeft;
LongPrototype.shiftRight = function shiftRight(numBits) {
  if (isLong(numBits))
    numBits = numBits.toInt();
  if ((numBits &= 63) === 0)
    return this;
  else if (numBits < 32)
    return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >> numBits, this.unsigned);
  else
    return fromBits(this.high >> numBits - 32, this.high >= 0 ? 0 : -1, this.unsigned);
};
LongPrototype.shr = LongPrototype.shiftRight;
LongPrototype.shiftRightUnsigned = function shiftRightUnsigned(numBits) {
  if (isLong(numBits))
    numBits = numBits.toInt();
  numBits &= 63;
  if (numBits === 0)
    return this;
  else {
    var high = this.high;
    if (numBits < 32) {
      var low = this.low;
      return fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits, this.unsigned);
    } else if (numBits === 32)
      return fromBits(high, 0, this.unsigned);
    else
      return fromBits(high >>> numBits - 32, 0, this.unsigned);
  }
};
LongPrototype.shru = LongPrototype.shiftRightUnsigned;
LongPrototype.shr_u = LongPrototype.shiftRightUnsigned;
LongPrototype.toSigned = function toSigned() {
  if (!this.unsigned)
    return this;
  return fromBits(this.low, this.high, false);
};
LongPrototype.toUnsigned = function toUnsigned() {
  if (this.unsigned)
    return this;
  return fromBits(this.low, this.high, true);
};
LongPrototype.toBytes = function toBytes(le) {
  return le ? this.toBytesLE() : this.toBytesBE();
};
LongPrototype.toBytesLE = function toBytesLE() {
  var hi = this.high, lo = this.low;
  return [
    lo & 255,
    lo >>> 8 & 255,
    lo >>> 16 & 255,
    lo >>> 24,
    hi & 255,
    hi >>> 8 & 255,
    hi >>> 16 & 255,
    hi >>> 24
  ];
};
LongPrototype.toBytesBE = function toBytesBE() {
  var hi = this.high, lo = this.low;
  return [
    hi >>> 24,
    hi >>> 16 & 255,
    hi >>> 8 & 255,
    hi & 255,
    lo >>> 24,
    lo >>> 16 & 255,
    lo >>> 8 & 255,
    lo & 255
  ];
};
Long$1.fromBytes = function fromBytes(bytes, unsigned, le) {
  return le ? Long$1.fromBytesLE(bytes, unsigned) : Long$1.fromBytesBE(bytes, unsigned);
};
Long$1.fromBytesLE = function fromBytesLE(bytes, unsigned) {
  return new Long$1(bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[3] << 24, bytes[4] | bytes[5] << 8 | bytes[6] << 16 | bytes[7] << 24, unsigned);
};
Long$1.fromBytesBE = function fromBytesBE(bytes, unsigned) {
  return new Long$1(bytes[4] << 24 | bytes[5] << 16 | bytes[6] << 8 | bytes[7], bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], unsigned);
};
function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof3(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function _typeof3(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
var _require = buffer, Buffer$1 = _require.Buffer;
var vm = vmBrowser;
var Context$1 = context.Context;
var Long = gosling_es_long;
if (typeof window !== "undefined")
  window.Buffer = Buffer$1;
if (typeof self !== "undefined")
  self.Buffer = Buffer$1;
var PRIMITIVE_TYPES = {
  UInt8: 1,
  UInt16LE: 2,
  UInt16BE: 2,
  UInt32LE: 4,
  UInt32BE: 4,
  Int8: 1,
  Int16LE: 2,
  Int16BE: 2,
  Int32LE: 4,
  Int32BE: 4,
  FloatLE: 4,
  FloatBE: 4,
  DoubleLE: 8,
  DoubleBE: 8,
  UInt64: 8,
  Int64: 8
};
var SPECIAL_TYPES = {
  String: null,
  Buffer: null,
  Array: null,
  Skip: null,
  Choice: null,
  Nest: null,
  Bit: null,
  Itf8: null,
  Ltf8: null
};
var aliasRegistry = {};
var FUNCTION_PREFIX = "___parser_";
var BIT_RANGE = [];
(function() {
  var i;
  for (i = 1; i <= 32; i++) {
    BIT_RANGE.push(i);
  }
})();
var NAME_MAP = {};
Object.keys(PRIMITIVE_TYPES).concat(Object.keys(SPECIAL_TYPES)).forEach(function(type2) {
  NAME_MAP[type2.toLowerCase()] = type2;
});
var Parser = function Parser2() {
  this.varName = "";
  this.type = "";
  this.options = {};
  this.next = null;
  this.head = null;
  this.compiled = null;
  this.endian = "le";
  this.constructorFn = null;
  this.alias = null;
};
Parser.start = function() {
  return new Parser();
};
Object.keys(PRIMITIVE_TYPES).forEach(function(type2) {
  Parser.prototype[type2.toLowerCase()] = function(varName, options) {
    return this.setNextParser(type2.toLowerCase(), varName, options);
  };
  var typeWithoutEndian = type2.replace(/BE|LE/, "").toLowerCase();
  if (!(typeWithoutEndian in Parser.prototype)) {
    Parser.prototype[typeWithoutEndian] = function(varName, options) {
      return this[typeWithoutEndian + this.endian](varName, options);
    };
  }
});
BIT_RANGE.forEach(function(i) {
  Parser.prototype["bit".concat(i.toString())] = function(varName, options) {
    if (!options) {
      options = {};
    }
    options.length = i;
    return this.setNextParser("bit", varName, options);
  };
});
Parser.prototype.namely = function(alias) {
  aliasRegistry[alias] = this;
  this.alias = alias;
  return this;
};
Parser.prototype.skip = function(length, options) {
  if (options && options.assert) {
    throw new Error("assert option on skip is not allowed.");
  }
  return this.setNextParser("skip", "", { length });
};
Parser.prototype.string = function(varName, options) {
  if (!options.zeroTerminated && !options.length && !options.greedy) {
    throw new Error("Neither length, zeroTerminated, nor greedy is defined for string.");
  }
  if ((options.zeroTerminated || options.length) && options.greedy) {
    throw new Error("greedy is mutually exclusive with length and zeroTerminated for string.");
  }
  if (options.stripNull && !(options.length || options.greedy)) {
    throw new Error("Length or greedy must be defined if stripNull is defined.");
  }
  options.encoding = options.encoding || "utf8";
  return this.setNextParser("string", varName, options);
};
Parser.prototype.buffer = function(varName, options) {
  if (!options.length && !options.readUntil) {
    throw new Error("Length nor readUntil is defined in buffer parser");
  }
  return this.setNextParser("buffer", varName, options);
};
Parser.prototype.array = function(varName, options) {
  if (!options.readUntil && !options.length && !options.lengthInBytes) {
    throw new Error("Length option of array is not defined.");
  }
  if (!options.type) {
    throw new Error("Type option of array is not defined.");
  }
  if (typeof options.type === "string" && !aliasRegistry[options.type] && Object.keys(PRIMITIVE_TYPES).indexOf(NAME_MAP[options.type]) < 0) {
    throw new Error('Specified primitive type "'.concat(options.type, '" is not supported.'));
  }
  return this.setNextParser("array", varName, options);
};
Parser.prototype.choice = function(varName, options) {
  if (arguments.length === 1 && _typeof(varName) === "object") {
    options = varName;
    varName = null;
  }
  if (!options.tag) {
    throw new Error("Tag option of array is not defined.");
  }
  if (!options.choices) {
    throw new Error("Choices option of array is not defined.");
  }
  Object.keys(options.choices).forEach(function(key) {
    if (!options.choices[key]) {
      throw new Error("Choice Case ".concat(key, " of ").concat(varName, " is not valid."));
    }
    if (typeof options.choices[key] === "string" && !aliasRegistry[options.choices[key]] && Object.keys(PRIMITIVE_TYPES).indexOf(NAME_MAP[options.choices[key]]) < 0) {
      throw new Error('Specified primitive type "'.concat(options.choices[key], '" is not supported.'));
    }
  }, this);
  return this.setNextParser("choice", varName, options);
};
Parser.prototype.nest = function(varName, options) {
  if (arguments.length === 1 && _typeof(varName) === "object") {
    options = varName;
    varName = null;
  }
  if (!options.type) {
    throw new Error("Type option of nest is not defined.");
  }
  if (!(options.type instanceof Parser) && !aliasRegistry[options.type]) {
    throw new Error("Type option of nest must be a Parser object.");
  }
  if (!(options.type instanceof Parser) && !varName) {
    throw new Error("options.type must be a object if variable name is omitted.");
  }
  return this.setNextParser("nest", varName, options);
};
Parser.prototype.endianess = function(endianess) {
  switch (endianess.toLowerCase()) {
    case "little":
      this.endian = "le";
      break;
    case "big":
      this.endian = "be";
      break;
    default:
      throw new Error("Invalid endianess: ".concat(endianess));
  }
  return this;
};
Parser.prototype.create = function(constructorFn) {
  if (!(constructorFn instanceof Function)) {
    throw new Error("Constructor must be a Function object.");
  }
  this.constructorFn = constructorFn;
  return this;
};
Parser.prototype.getCode = function() {
  var ctx = new Context$1();
  ctx.pushCode("if (!Buffer.isBuffer(buffer)) {");
  ctx.generateError('"argument buffer is not a Buffer object"');
  ctx.pushCode("}");
  if (!this.alias) {
    this.addRawCode(ctx);
  } else {
    this.addAliasedCode(ctx);
  }
  if (this.alias) {
    ctx.pushCode("return {0}(0)", FUNCTION_PREFIX + this.alias);
  } else {
    ctx.pushCode("return { offset: offset, result: vars };");
  }
  return ctx.code;
};
Parser.prototype.addRawCode = function(ctx) {
  ctx.pushCode("var offset = 0;");
  if (this.constructorFn) {
    ctx.pushCode("var vars = new constructorFn();");
  } else {
    ctx.pushCode("var vars = {};");
  }
  this.generate(ctx);
  this.resolveReferences(ctx);
  ctx.pushCode("return { offset: offset, result: vars };");
};
Parser.prototype.addAliasedCode = function(ctx) {
  ctx.pushCode("function {0}(offset) {", FUNCTION_PREFIX + this.alias);
  if (this.constructorFn) {
    ctx.pushCode("var vars = new constructorFn();");
  } else {
    ctx.pushCode("var vars = {};");
  }
  this.generate(ctx);
  ctx.markResolved(this.alias);
  this.resolveReferences(ctx);
  ctx.pushCode("return { offset: offset, result: vars };");
  ctx.pushCode("}");
  return ctx;
};
Parser.prototype.resolveReferences = function(ctx) {
  var references = ctx.getUnresolvedReferences();
  ctx.markRequested(references);
  references.forEach(function(alias) {
    var parser = aliasRegistry[alias];
    parser.addAliasedCode(ctx);
  });
};
Parser.prototype.compile = function() {
  var src = "(function(buffer, constructorFn, Long) { ".concat(this.getCode(), " })");
  this.compiled = vm.runInThisContext(src);
};
Parser.prototype.sizeOf = function() {
  var size = NaN;
  if (Object.keys(PRIMITIVE_TYPES).indexOf(this.type) >= 0) {
    size = PRIMITIVE_TYPES[this.type];
  } else if (this.type === "String" && typeof this.options.length === "number") {
    size = this.options.length;
  } else if (this.type === "Buffer" && typeof this.options.length === "number") {
    size = this.options.length;
  } else if (this.type === "Array" && typeof this.options.length === "number") {
    var elementSize = NaN;
    if (typeof this.options.type === "string") {
      elementSize = PRIMITIVE_TYPES[NAME_MAP[this.options.type]];
    } else if (this.options.type instanceof Parser) {
      elementSize = this.options.type.sizeOf();
    }
    size = this.options.length * elementSize;
  } else if (this.type === "Skip") {
    size = this.options.length;
  } else if (this.type === "Nest") {
    size = this.options.type.sizeOf();
  } else if (!this.type) {
    size = 0;
  }
  if (this.next) {
    size += this.next.sizeOf();
  }
  return size;
};
Parser.prototype.parse = function(buffer2) {
  if (!this.compiled) {
    this.compile();
  }
  return this.compiled(buffer2, this.constructorFn, Long);
};
Parser.prototype.setNextParser = function(type2, varName, options) {
  var parser = new Parser();
  parser.type = NAME_MAP[type2];
  parser.varName = varName;
  parser.options = options || parser.options;
  parser.endian = this.endian;
  if (this.head) {
    this.head.next = parser;
  } else {
    this.next = parser;
  }
  this.head = parser;
  return this;
};
Parser.prototype.generate = function(ctx) {
  if (this.type) {
    this["generate".concat(this.type)](ctx);
    this.generateAssert(ctx);
  }
  var varName = ctx.generateVariable(this.varName);
  if (this.options.formatter) {
    this.generateFormatter(ctx, varName, this.options.formatter);
  }
  return this.generateNext(ctx);
};
Parser.prototype.generateAssert = function(ctx) {
  if (!this.options.assert) {
    return;
  }
  var varName = ctx.generateVariable(this.varName);
  switch (_typeof(this.options.assert)) {
    case "function":
      ctx.pushCode("if (!({0}).call(vars, {1})) {", this.options.assert, varName);
      break;
    case "number":
      ctx.pushCode("if ({0} !== {1}) {", this.options.assert, varName);
      break;
    case "string":
      ctx.pushCode('if ("{0}" !== {1}) {', this.options.assert, varName);
      break;
    default:
      throw new Error("Assert option supports only strings, numbers and assert functions.");
  }
  ctx.generateError('"Assert error: {0} is " + {0}', varName);
  ctx.pushCode("}");
};
Parser.prototype.generateNext = function(ctx) {
  if (this.next) {
    ctx = this.next.generate(ctx);
  }
  return ctx;
};
Object.keys(PRIMITIVE_TYPES).forEach(function(type2) {
  Parser.prototype["generate".concat(type2)] = function(ctx) {
    if (type2 === "UInt64") {
      ctx.pushCode("{0} = Long.fromBytes(buffer.slice(offset,offset+8), true, this.endian === 'le').toNumber();", ctx.generateVariable(this.varName), type2);
    } else if (type2 === "Int64") {
      ctx.pushCode("{0} = Long.fromBytes(buffer.slice(offset,offset+8), false, this.endian === 'le').toNumber();", ctx.generateVariable(this.varName), type2);
    } else {
      ctx.pushCode("{0} = buffer.read{1}(offset);", ctx.generateVariable(this.varName), type2);
    }
    ctx.pushCode("offset += {0};", PRIMITIVE_TYPES[type2]);
  };
});
Parser.prototype.generateBit = function(ctx) {
  var parser = JSON.parse(JSON.stringify(this));
  parser.varName = ctx.generateVariable(parser.varName);
  ctx.bitFields.push(parser);
  if (!this.next || this.next && ["Bit", "Nest"].indexOf(this.next.type) < 0) {
    var sum2 = 0;
    ctx.bitFields.forEach(function(p) {
      sum2 += p.options.length;
    });
    var val = ctx.generateTmpVariable();
    if (sum2 <= 8) {
      ctx.pushCode("var {0} = buffer.readUInt8(offset);", val);
      sum2 = 8;
    } else if (sum2 <= 16) {
      ctx.pushCode("var {0} = buffer.readUInt16BE(offset);", val);
      sum2 = 16;
    } else if (sum2 <= 24) {
      var val1 = ctx.generateTmpVariable();
      var val2 = ctx.generateTmpVariable();
      ctx.pushCode("var {0} = buffer.readUInt16BE(offset);", val1);
      ctx.pushCode("var {0} = buffer.readUInt8(offset + 2);", val2);
      ctx.pushCode("var {2} = ({0} << 8) | {1};", val1, val2, val);
      sum2 = 24;
    } else if (sum2 <= 32) {
      ctx.pushCode("var {0} = buffer.readUInt32BE(offset);", val);
      sum2 = 32;
    } else {
      throw new Error("Currently, bit field sequence longer than 4-bytes is not supported.");
    }
    ctx.pushCode("offset += {0};", sum2 / 8);
    var bitOffset = 0;
    var isBigEndian = this.endian === "be";
    ctx.bitFields.forEach(function(p) {
      ctx.pushCode("{0} = {1} >> {2} & {3};", p.varName, val, isBigEndian ? sum2 - bitOffset - p.options.length : bitOffset, (1 << p.options.length) - 1);
      bitOffset += p.options.length;
    });
    ctx.bitFields = [];
  }
};
Parser.prototype.generateSkip = function(ctx) {
  var length = ctx.generateOption(this.options.length);
  ctx.pushCode("offset += {0};", length);
};
Parser.prototype.generateString = function(ctx) {
  var name2 = ctx.generateVariable(this.varName);
  var start = ctx.generateTmpVariable();
  if (this.options.length && this.options.zeroTerminated) {
    ctx.pushCode("var {0} = offset;", start);
    ctx.pushCode("while(buffer.readUInt8(offset++) !== 0 && offset - {0}  < {1});", start, this.options.length);
    ctx.pushCode("{0} = buffer.toString('{1}', {2}, offset - {2} < {3} ? offset - 1 : offset);", name2, this.options.encoding, start, this.options.length);
  } else if (this.options.length) {
    ctx.pushCode("{0} = buffer.toString('{1}', offset, offset + {2});", name2, this.options.encoding, ctx.generateOption(this.options.length));
    ctx.pushCode("offset += {0};", ctx.generateOption(this.options.length));
  } else if (this.options.zeroTerminated) {
    ctx.pushCode("var {0} = offset;", start);
    ctx.pushCode("while(buffer.readUInt8(offset++) !== 0);");
    ctx.pushCode("{0} = buffer.toString('{1}', {2}, offset - 1);", name2, this.options.encoding, start);
  } else if (this.options.greedy) {
    ctx.pushCode("var {0} = offset;", start);
    ctx.pushCode("while(buffer.length > offset++);");
    ctx.pushCode("{0} = buffer.toString('{1}', {2}, offset);", name2, this.options.encoding, start);
  }
  if (this.options.stripNull) {
    ctx.pushCode("{0} = {0}.replace(/\\x00+$/g, '')", name2);
  }
};
Parser.prototype.generateBuffer = function(ctx) {
  if (this.options.readUntil === "eof") {
    ctx.pushCode("{0} = buffer.slice(offset);", ctx.generateVariable(this.varName));
  } else {
    ctx.pushCode("{0} = buffer.slice(offset, offset + {1});", ctx.generateVariable(this.varName), ctx.generateOption(this.options.length));
    ctx.pushCode("offset += {0};", ctx.generateOption(this.options.length));
  }
  if (this.options.clone) {
    ctx.pushCode("{0} = Buffer.from({0});", ctx.generateVariable(this.varName));
  }
};
Parser.prototype.generateArray = function(ctx) {
  var length = ctx.generateOption(this.options.length);
  var lengthInBytes = ctx.generateOption(this.options.lengthInBytes);
  var type2 = this.options.type;
  var counter = ctx.generateTmpVariable();
  var lhs = ctx.generateVariable(this.varName);
  var item = ctx.generateTmpVariable();
  var key = this.options.key;
  var isHash = typeof key === "string";
  if (isHash) {
    ctx.pushCode("{0} = {};", lhs);
  } else {
    ctx.pushCode("{0} = [];", lhs);
  }
  if (typeof this.options.readUntil === "function") {
    ctx.pushCode("do {");
  } else if (this.options.readUntil === "eof") {
    ctx.pushCode("for (var {0} = 0; offset < buffer.length; {0}++) {", counter);
  } else if (lengthInBytes !== void 0) {
    ctx.pushCode("for (var {0} = offset; offset - {0} < {1}; ) {", counter, lengthInBytes);
  } else {
    ctx.pushCode("for (var {0} = 0; {0} < {1}; {0}++) {", counter, length);
  }
  if (typeof type2 === "string") {
    if (!aliasRegistry[type2]) {
      ctx.pushCode("var {0} = buffer.read{1}(offset);", item, NAME_MAP[type2]);
      ctx.pushCode("offset += {0};", PRIMITIVE_TYPES[NAME_MAP[type2]]);
    } else {
      var tempVar = ctx.generateTmpVariable();
      ctx.pushCode("var {0} = {1}(offset);", tempVar, FUNCTION_PREFIX + type2);
      ctx.pushCode("var {0} = {1}.result; offset = {1}.offset;", item, tempVar);
      if (type2 !== this.alias)
        ctx.addReference(type2);
    }
  } else if (type2 instanceof Parser) {
    ctx.pushCode("var {0} = {};", item);
    ctx.pushScope(item);
    type2.generate(ctx);
    ctx.popScope();
  }
  if (isHash) {
    ctx.pushCode("{0}[{2}.{1}] = {2};", lhs, key, item);
  } else {
    ctx.pushCode("{0}.push({1});", lhs, item);
  }
  ctx.pushCode("}");
  if (typeof this.options.readUntil === "function") {
    ctx.pushCode(" while (!({0}).call(this, {1}, buffer.slice(offset)));", this.options.readUntil, item);
  }
};
Parser.prototype.generateChoiceCase = function(ctx, varName, type2) {
  if (typeof type2 === "string") {
    if (!aliasRegistry[type2]) {
      ctx.pushCode("{0} = buffer.read{1}(offset);", ctx.generateVariable(this.varName), NAME_MAP[type2]);
      ctx.pushCode("offset += {0};", PRIMITIVE_TYPES[NAME_MAP[type2]]);
    } else {
      var tempVar = ctx.generateTmpVariable();
      ctx.pushCode("var {0} = {1}(offset);", tempVar, FUNCTION_PREFIX + type2);
      ctx.pushCode("{0} = {1}.result; offset = {1}.offset;", ctx.generateVariable(this.varName), tempVar);
      if (type2 !== this.alias)
        ctx.addReference(type2);
    }
  } else if (type2 instanceof Parser) {
    ctx.pushPath(varName);
    type2.generate(ctx);
    ctx.popPath(varName);
  }
};
Parser.prototype.generateChoice = function(ctx) {
  var tag = ctx.generateOption(this.options.tag);
  if (this.varName) {
    ctx.pushCode("{0} = {};", ctx.generateVariable(this.varName));
  }
  ctx.pushCode("switch({0}) {", tag);
  Object.keys(this.options.choices).forEach(function(t) {
    var type2 = this.options.choices[t];
    if (Number.isNaN(parseInt(t, 10))) {
      ctx.pushCode("case '{0}':", t);
    } else {
      ctx.pushCode("case {0}:", t);
    }
    this.generateChoiceCase(ctx, this.varName, type2);
    ctx.pushCode("break;");
  }, this);
  ctx.pushCode("default:");
  if (this.options.defaultChoice) {
    this.generateChoiceCase(ctx, this.varName, this.options.defaultChoice);
  } else {
    ctx.generateError('"Met undefined tag value " + {0} + " at choice"', tag);
  }
  ctx.pushCode("}");
};
Parser.prototype.generateNest = function(ctx) {
  var nestVar = ctx.generateVariable(this.varName);
  if (this.options.type instanceof Parser) {
    if (this.varName) {
      ctx.pushCode("{0} = {};", nestVar);
    }
    ctx.pushPath(this.varName);
    this.options.type.generate(ctx);
    ctx.popPath(this.varName);
  } else if (aliasRegistry[this.options.type]) {
    var tempVar = ctx.generateTmpVariable();
    ctx.pushCode("var {0} = {1}(offset);", tempVar, FUNCTION_PREFIX + this.options.type);
    ctx.pushCode("{0} = {1}.result; offset = {1}.offset;", nestVar, tempVar);
    if (this.options.type !== this.alias)
      ctx.addReference(this.options.type);
  }
};
Parser.prototype.generateFormatter = function(ctx, varName, formatter) {
  if (typeof formatter === "function") {
    ctx.pushCode("{0} = ({1}).call(this, {0});", varName, formatter);
  }
};
Parser.prototype.isInteger = function() {
  return !!this.type.match(/U?Int[8|16|32][BE|LE]?|Bit\d+/);
};
Parser.prototype.itf8 = function(varName, options) {
  return this.setNextParser("itf8", varName, options);
};
Parser.prototype.itf8 = function(varName, options) {
  return this.setNextParser("itf8", varName, options);
};
Parser.prototype.generateItf8 = function(ctx) {
  var name2 = ctx.generateVariable(this.varName);
  var countFlags = ctx.generateTmpVariable();
  ctx.pushCode("\n    var ".concat(countFlags, " = buffer[offset];\n    if (").concat(countFlags, " < 0x80) {\n      ").concat(name2, " = ").concat(countFlags, ";\n      offset += 1;\n    } else if (").concat(countFlags, " < 0xc0) {\n      ").concat(name2, " = ((").concat(countFlags, "<<8) | buffer[offset+1]) & 0x3fff;\n      offset += 2;\n    } else if (").concat(countFlags, " < 0xe0) {\n      ").concat(name2, " = ((").concat(countFlags, "<<16) | (buffer[offset+1]<< 8) |  buffer[offset+2]) & 0x1fffff;\n      offset += 3;\n    } else if (").concat(countFlags, " < 0xf0) {\n      ").concat(name2, " = ((").concat(countFlags, "<<24) | (buffer[offset+1]<<16) | (buffer[offset+2]<<8) | buffer[offset+3]) & 0x0fffffff;\n      offset += 4\n    } else {\n      ").concat(name2, " = ((").concat(countFlags, " & 0x0f)<<28) | (buffer[offset+1]<<20) | (buffer[offset+2]<<12) | (buffer[offset+3]<<4) | (buffer[offset+4] & 0x0f);\n      // x=((0xff & 0x0f)<<28) | (0xff<<20) | (0xff<<12) | (0xff<<4) | (0x0f & 0x0f);\n      // TODO *val_p = uv < 0x80000000UL ? uv : -((int32_t) (0xffffffffUL - uv)) - 1;\n      offset += 5\n    }\n  "));
};
Parser.prototype.ltf8 = function(varName, options) {
  return this.setNextParser("ltf8", varName, options);
};
Parser.prototype.generateLtf8 = function(ctx) {
  var name2 = ctx.generateVariable(this.varName);
  var countFlags = ctx.generateTmpVariable();
  ctx.pushCode("\n  var ".concat(countFlags, " = buffer[offset];\n  if (").concat(countFlags, " < 0x80) {\n    ").concat(name2, " = ").concat(countFlags, ";\n    offset += 1;\n  } else if (").concat(countFlags, " < 0xc0) {\n    ").concat(name2, " = ((buffer[offset]<<8) | buffer[offset+1]) & 0x3fff;\n    offset += 2;\n  } else if (").concat(countFlags, " < 0xe0) {\n    ").concat(name2, " = ((buffer[offset]<<16) | (buffer[offset+1]<<8) | buffer[offset+2]) & 0x1fffff;\n    ").concat(name2, " = (((").concat(countFlags, " & 63) << 16) | buffer.readUInt16LE(offset + 1));\n    offset += 3;\n  } else if (").concat(countFlags, " < 0xf0) {\n    ").concat(name2, " = ((buffer[offset]<<24) | (buffer[offset+1]<<16) | (buffer[offset+2]<<8) | buffer[offset+3]) & 0x0fffffff;\n    offset += 4;\n  } else if (").concat(countFlags, " < 0xf8) {\n    ").concat(name2, " = (((buffer[offset] & 15) * Math.pow(2,32))) +\n      (buffer[offset+1]<<24) | (buffer[offset+2]<<16 | buffer[offset+3]<<8 | buffer[offset+4])\n    // TODO *val_p = uv < 0x80000000UL ? uv : -((int32_t) (0xffffffffUL - uv)) - 1;\n    offset += 5;\n  } else if (").concat(countFlags, " < 0xfc) {\n    ").concat(name2, " = ((((buffer[offset] & 7) << 8) | buffer[offset+1] )) * Math.pow(2,32) +\n      (buffer[offset+2]<<24) | (buffer[offset+3]<<16 | buffer[offset+4]<<8 | buffer[offset+5])\n    offset += 6;\n  } else if (").concat(countFlags, " < 0xfe) {\n    ").concat(name2, " = ((((buffer[offset] & 3) << 16) | buffer[offset+1]<<8 | buffer[offset+2])) * Math.pow(2,32) +\n      (buffer[offset+3]<<24) | (buffer[offset+4]<<16 | buffer[offset+5]<<8 | buffer[offset+6])\n    offset += 7;\n  } else if (").concat(countFlags, " < 0xff) {\n    ").concat(name2, " = Long.fromBytesBE(buffer.slice(offset+1,offset+8));\n    if (").concat(name2, ".greaterThan(Number.MAX_SAFE_INTEGER) || ").concat(name2, ".lessThan(Number.MIN_SAFE_INTEGER))\n      throw new Error('integer overflow')\n    ").concat(name2, " = ").concat(name2, ".toNumber()\n    offset += 8;\n  } else {\n    ").concat(name2, " = Long.fromBytesBE(buffer.slice(offset+1,offset+9));\n    if (").concat(name2, ".greaterThan(Number.MAX_SAFE_INTEGER) || ").concat(name2, ".lessThan(Number.MIN_SAFE_INTEGER))\n      throw new Error('integer overflow')\n    ").concat(name2, " = ").concat(name2, ".toNumber()\n    offset += 9;\n  }\n  "));
};
binary_parser.Parser = Parser;
var gosling_es_dist = {};
var AbortablePromiseCache$1 = {};
var abortcontrollerPonyfill = {};
var cjsPonyfill = {};
Object.defineProperty(cjsPonyfill, "__esModule", { value: true });
function gosling_es_classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function gosling_es_createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  return Constructor;
}
function gosling_es_inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf3(o2) {
    return o2.__proto__ || Object.getPrototypeOf(o2);
  };
  return _getPrototypeOf(o);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p2) {
    o2.__proto__ = p2;
    return o2;
  };
  return _setPrototypeOf(o, p);
}
function _isNativeReflectConstruct$3() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e) {
    return false;
  }
}
function _assertThisInitialized(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function gosling_es_possibleConstructorReturn(self2, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized(self2);
}
function _createSuper$3(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct$3();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return gosling_es_possibleConstructorReturn(this, result);
  };
}
function _superPropBase(object, property) {
  while (!Object.prototype.hasOwnProperty.call(object, property)) {
    object = _getPrototypeOf(object);
    if (object === null)
      break;
  }
  return object;
}
function gosling_es_get(target, property, receiver) {
  if (typeof Reflect !== "undefined" && Reflect.get) {
    gosling_es_get = Reflect.get;
  } else {
    gosling_es_get = function _get2(target2, property2, receiver2) {
      var base = _superPropBase(target2, property2);
      if (!base)
        return;
      var desc = Object.getOwnPropertyDescriptor(base, property2);
      if (desc.get) {
        return desc.get.call(receiver2);
      }
      return desc.value;
    };
  }
  return gosling_es_get(target, property, receiver || target);
}
var Emitter = /* @__PURE__ */ function() {
  function Emitter2() {
    gosling_es_classCallCheck(this, Emitter2);
    Object.defineProperty(this, "listeners", {
      value: {},
      writable: true,
      configurable: true
    });
  }
  gosling_es_createClass(Emitter2, [{
    key: "addEventListener",
    value: function addEventListener(type2, callback, options) {
      if (!(type2 in this.listeners)) {
        this.listeners[type2] = [];
      }
      this.listeners[type2].push({
        callback,
        options
      });
    }
  }, {
    key: "removeEventListener",
    value: function removeEventListener(type2, callback) {
      if (!(type2 in this.listeners)) {
        return;
      }
      var stack = this.listeners[type2];
      for (var i = 0, l = stack.length; i < l; i++) {
        if (stack[i].callback === callback) {
          stack.splice(i, 1);
          return;
        }
      }
    }
  }, {
    key: "dispatchEvent",
    value: function dispatchEvent(event) {
      if (!(event.type in this.listeners)) {
        return;
      }
      var stack = this.listeners[event.type];
      var stackToCall = stack.slice();
      for (var i = 0, l = stackToCall.length; i < l; i++) {
        var listener = stackToCall[i];
        try {
          listener.callback.call(this, event);
        } catch (e) {
          Promise.resolve().then(function() {
            throw e;
          });
        }
        if (listener.options && listener.options.once) {
          this.removeEventListener(event.type, listener.callback);
        }
      }
      return !event.defaultPrevented;
    }
  }]);
  return Emitter2;
}();
var AbortSignal$1 = /* @__PURE__ */ function(_Emitter) {
  gosling_es_inherits(AbortSignal2, _Emitter);
  var _super = _createSuper$3(AbortSignal2);
  function AbortSignal2() {
    var _this;
    gosling_es_classCallCheck(this, AbortSignal2);
    _this = _super.call(this);
    if (!_this.listeners) {
      Emitter.call(_assertThisInitialized(_this));
    }
    Object.defineProperty(_assertThisInitialized(_this), "aborted", {
      value: false,
      writable: true,
      configurable: true
    });
    Object.defineProperty(_assertThisInitialized(_this), "onabort", {
      value: null,
      writable: true,
      configurable: true
    });
    return _this;
  }
  gosling_es_createClass(AbortSignal2, [{
    key: "toString",
    value: function toString2() {
      return "[object AbortSignal]";
    }
  }, {
    key: "dispatchEvent",
    value: function dispatchEvent(event) {
      if (event.type === "abort") {
        this.aborted = true;
        if (typeof this.onabort === "function") {
          this.onabort.call(this, event);
        }
      }
      gosling_es_get(_getPrototypeOf(AbortSignal2.prototype), "dispatchEvent", this).call(this, event);
    }
  }]);
  return AbortSignal2;
}(Emitter);
var AbortController$1 = /* @__PURE__ */ function() {
  function AbortController2() {
    gosling_es_classCallCheck(this, AbortController2);
    Object.defineProperty(this, "signal", {
      value: new AbortSignal$1(),
      writable: true,
      configurable: true
    });
  }
  gosling_es_createClass(AbortController2, [{
    key: "abort",
    value: function abort() {
      var event;
      try {
        event = new Event("abort");
      } catch (e) {
        if (typeof document !== "undefined") {
          if (!document.createEvent) {
            event = document.createEventObject();
            event.type = "abort";
          } else {
            event = document.createEvent("Event");
            event.initEvent("abort", false, false);
          }
        } else {
          event = {
            type: "abort",
            bubbles: false,
            cancelable: false
          };
        }
      }
      this.signal.dispatchEvent(event);
    }
  }, {
    key: "toString",
    value: function toString2() {
      return "[object AbortController]";
    }
  }]);
  return AbortController2;
}();
if (typeof Symbol !== "undefined" && Symbol.toStringTag) {
  AbortController$1.prototype[Symbol.toStringTag] = "AbortController";
  AbortSignal$1.prototype[Symbol.toStringTag] = "AbortSignal";
}
function polyfillNeeded(self2) {
  if (self2.__FORCE_INSTALL_ABORTCONTROLLER_POLYFILL) {
    console.log("__FORCE_INSTALL_ABORTCONTROLLER_POLYFILL=true is set, will force install polyfill");
    return true;
  }
  return typeof self2.Request === "function" && !self2.Request.prototype.hasOwnProperty("signal") || !self2.AbortController;
}
function abortableFetchDecorator(patchTargets) {
  if (typeof patchTargets === "function") {
    patchTargets = {
      fetch: patchTargets
    };
  }
  var _patchTargets = patchTargets, fetch2 = _patchTargets.fetch, _patchTargets$Request = _patchTargets.Request, NativeRequest = _patchTargets$Request === void 0 ? fetch2.Request : _patchTargets$Request, NativeAbortController = _patchTargets.AbortController, _patchTargets$__FORCE = _patchTargets.__FORCE_INSTALL_ABORTCONTROLLER_POLYFILL, __FORCE_INSTALL_ABORTCONTROLLER_POLYFILL = _patchTargets$__FORCE === void 0 ? false : _patchTargets$__FORCE;
  if (!polyfillNeeded({
    fetch: fetch2,
    Request: NativeRequest,
    AbortController: NativeAbortController,
    __FORCE_INSTALL_ABORTCONTROLLER_POLYFILL
  })) {
    return {
      fetch: fetch2,
      Request
    };
  }
  var Request = NativeRequest;
  if (Request && !Request.prototype.hasOwnProperty("signal") || __FORCE_INSTALL_ABORTCONTROLLER_POLYFILL) {
    Request = function Request2(input, init2) {
      var signal;
      if (init2 && init2.signal) {
        signal = init2.signal;
        delete init2.signal;
      }
      var request = new NativeRequest(input, init2);
      if (signal) {
        Object.defineProperty(request, "signal", {
          writable: false,
          enumerable: false,
          configurable: true,
          value: signal
        });
      }
      return request;
    };
    Request.prototype = NativeRequest.prototype;
  }
  var realFetch = fetch2;
  var abortableFetch = function abortableFetch2(input, init2) {
    var signal = Request && Request.prototype.isPrototypeOf(input) ? input.signal : init2 ? init2.signal : void 0;
    if (signal) {
      var abortError;
      try {
        abortError = new DOMException("Aborted", "AbortError");
      } catch (err) {
        abortError = new Error("Aborted");
        abortError.name = "AbortError";
      }
      if (signal.aborted) {
        return Promise.reject(abortError);
      }
      var cancellation = new Promise(function(_, reject) {
        signal.addEventListener("abort", function() {
          return reject(abortError);
        }, {
          once: true
        });
      });
      if (init2 && init2.signal) {
        delete init2.signal;
      }
      return Promise.race([cancellation, realFetch(input, init2)]);
    }
    return realFetch(input, init2);
  };
  return {
    fetch: abortableFetch,
    Request
  };
}
cjsPonyfill.AbortController = AbortController$1;
cjsPonyfill.AbortSignal = AbortSignal$1;
cjsPonyfill.abortableFetch = abortableFetchDecorator;
Object.defineProperty(abortcontrollerPonyfill, "__esModule", { value: true });
abortcontrollerPonyfill.AbortSignal = abortcontrollerPonyfill.AbortController = void 0;
var _cjsPonyfill = cjsPonyfill;
var getGlobal = function getGlobal2() {
  if (typeof self !== "undefined") {
    return self;
  }
  if (typeof window !== "undefined") {
    return window;
  }
  if (typeof commonjsGlobal !== "undefined") {
    return commonjsGlobal;
  }
  throw new Error("unable to locate global object");
};
var AbortController = typeof getGlobal().AbortController === "undefined" ? _cjsPonyfill.AbortController : getGlobal().AbortController;
abortcontrollerPonyfill.AbortController = AbortController;
var AbortSignal = typeof getGlobal().AbortController === "undefined" ? _cjsPonyfill.AbortSignal : getGlobal().AbortSignal;
abortcontrollerPonyfill.AbortSignal = AbortSignal;
var AggregateAbortController$1 = {};
var _interopRequireDefault$9 = interopRequireDefault.exports;
Object.defineProperty(AggregateAbortController$1, "__esModule", { value: true });
AggregateAbortController$1.default = void 0;
var _createClass2$7 = _interopRequireDefault$9(createClass.exports);
var _defineProperty2$7 = _interopRequireDefault$9(gosling_es_defineProperty.exports);
var _classCallCheck2$8 = _interopRequireDefault$9(classCallCheck.exports);
var _abortcontrollerPonyfill$1 = abortcontrollerPonyfill;
var NullSignal = function NullSignal2() {
  (0, _classCallCheck2$8.default)(this, NullSignal2);
};
var AggregateAbortController = /* @__PURE__ */ function() {
  function AggregateAbortController2() {
    (0, _classCallCheck2$8.default)(this, AggregateAbortController2);
    (0, _defineProperty2$7.default)(this, "signals", new Set());
    (0, _defineProperty2$7.default)(this, "abortController", new _abortcontrollerPonyfill$1.AbortController());
  }
  (0, _createClass2$7.default)(AggregateAbortController2, [{
    key: "addSignal",
    value: function addSignal() {
      var _this = this;
      var signal = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : new NullSignal();
      if (this.signal.aborted) {
        throw new Error("cannot add a signal, already aborted!");
      }
      this.signals.add(signal);
      if (signal.aborted) {
        this.handleAborted(signal);
      } else if (typeof signal.addEventListener === "function") {
        signal.addEventListener("abort", function() {
          _this.handleAborted(signal);
        });
      }
    }
  }, { key: "handleAborted", value: function handleAborted(signal) {
    this.signals.delete(signal);
    if (this.signals.size === 0) {
      this.abortController.abort();
    }
  } }, { key: "abort", value: function abort() {
    this.abortController.abort();
  } }, { key: "signal", get: function get() {
    return this.abortController.signal;
  } }]);
  return AggregateAbortController2;
}();
AggregateAbortController$1.default = AggregateAbortController;
var AggregateStatusReporter$1 = {};
var _interopRequireDefault$8 = interopRequireDefault.exports;
Object.defineProperty(AggregateStatusReporter$1, "__esModule", { value: true });
AggregateStatusReporter$1.default = void 0;
var _classCallCheck2$7 = _interopRequireDefault$8(classCallCheck.exports);
var _createClass2$6 = _interopRequireDefault$8(createClass.exports);
var _defineProperty2$6 = _interopRequireDefault$8(gosling_es_defineProperty.exports);
var AggregateStatusReporter = /* @__PURE__ */ function() {
  function AggregateStatusReporter2() {
    (0, _classCallCheck2$7.default)(this, AggregateStatusReporter2);
    (0, _defineProperty2$6.default)(this, "callbacks", new Set());
    (0, _defineProperty2$6.default)(this, "currentMessage", void 0);
  }
  (0, _createClass2$6.default)(AggregateStatusReporter2, [{ key: "addCallback", value: function addCallback() {
    var callback = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : function() {
    };
    this.callbacks.add(callback);
    callback(this.currentMessage);
  } }, { key: "callback", value: function callback(message) {
    this.currentMessage = message;
    this.callbacks.forEach(function(elt) {
      elt(message);
    });
  } }]);
  return AggregateStatusReporter2;
}();
AggregateStatusReporter$1.default = AggregateStatusReporter;
var _interopRequireDefault$7 = interopRequireDefault.exports;
Object.defineProperty(AbortablePromiseCache$1, "__esModule", { value: true });
AbortablePromiseCache$1.default = void 0;
var _typeof2 = _interopRequireDefault$7(_typeof$2.exports);
var _classCallCheck2$6 = _interopRequireDefault$7(classCallCheck.exports);
var _createClass2$5 = _interopRequireDefault$7(createClass.exports);
var _defineProperty2$5 = _interopRequireDefault$7(gosling_es_defineProperty.exports);
var _abortcontrollerPonyfill = abortcontrollerPonyfill;
var _AggregateAbortController = _interopRequireDefault$7(AggregateAbortController$1);
var _AggregateStatusReporter = _interopRequireDefault$7(AggregateStatusReporter$1);
var AbortablePromiseCache = /* @__PURE__ */ function() {
  function AbortablePromiseCache2(_ref) {
    var fill = _ref.fill, cache2 = _ref.cache;
    (0, _classCallCheck2$6.default)(this, AbortablePromiseCache2);
    (0, _defineProperty2$5.default)(this, "cache", void 0);
    (0, _defineProperty2$5.default)(this, "fillCallback", void 0);
    if (typeof fill !== "function")
      throw new TypeError("must pass a fill function");
    if ((0, _typeof2.default)(cache2) !== "object")
      throw new TypeError("must pass a cache object");
    if (typeof cache2.get !== "function" || typeof cache2.set !== "function" || typeof cache2.delete !== "function")
      throw new TypeError("cache must implement get(key), set(key, val), and and delete(key)");
    this.cache = cache2;
    this.fillCallback = fill;
  }
  (0, _createClass2$5.default)(AbortablePromiseCache2, [{ key: "evict", value: function evict(key, entry) {
    if (this.cache.get(key) === entry)
      this.cache.delete(key);
  } }, { key: "fill", value: function fill(key, data2, signal, statusCallback) {
    var _this = this;
    var aborter = new _AggregateAbortController.default();
    var statusReporter = new _AggregateStatusReporter.default();
    statusReporter.addCallback(statusCallback);
    var newEntry = {
      aborter,
      promise: this.fillCallback(data2, aborter.signal, function(message) {
        statusReporter.callback(message);
      }),
      settled: false,
      statusReporter,
      get aborted() {
        return this.aborter.signal.aborted;
      }
    };
    newEntry.aborter.addSignal(signal);
    newEntry.aborter.signal.addEventListener("abort", function() {
      if (!newEntry.settled) {
        _this.evict(key, newEntry);
      }
    });
    newEntry.promise.then(function() {
      newEntry.settled = true;
    }, function(exception) {
      newEntry.settled = true;
      _this.evict(key, newEntry);
    }).catch(function(e) {
      console.error(e);
      throw e;
    });
    this.cache.set(key, newEntry);
  } }, {
    key: "has",
    value: function has(key) {
      return this.cache.has(key);
    }
  }, {
    key: "get",
    value: function get(key, data2, signal, statusCallback) {
      if (!signal && data2 instanceof _abortcontrollerPonyfill.AbortSignal)
        throw new TypeError("second get argument appears to be an AbortSignal, perhaps you meant to pass `null` for the fill data?");
      var cacheEntry = this.cache.get(key);
      if (cacheEntry) {
        if (cacheEntry.aborted && !cacheEntry.settled) {
          this.evict(key, cacheEntry);
          return this.get(key, data2, signal, statusCallback);
        }
        if (cacheEntry.settled) {
          return cacheEntry.promise;
        }
        cacheEntry.aborter.addSignal(signal);
        cacheEntry.statusReporter.addCallback(statusCallback);
        return AbortablePromiseCache2.checkSinglePromise(cacheEntry.promise, signal);
      }
      this.fill(key, data2, signal, statusCallback);
      return AbortablePromiseCache2.checkSinglePromise(this.cache.get(key).promise, signal);
    }
  }, {
    key: "delete",
    value: function _delete(key) {
      var cachedEntry = this.cache.get(key);
      if (cachedEntry) {
        if (!cachedEntry.settled)
          cachedEntry.aborter.abort();
        this.cache.delete(key);
      }
    }
  }, { key: "clear", value: function clear() {
    var keyIter = this.cache.keys();
    var deleteCount = 0;
    for (var result = keyIter.next(); !result.done; result = keyIter.next()) {
      this.delete(result.value);
      deleteCount += 1;
    }
    return deleteCount;
  } }], [{ key: "isAbortException", value: function isAbortException(exception) {
    return exception.name === "AbortError" || exception.code === "ERR_ABORTED" || exception.message === "AbortError: aborted" || exception.message === "Error: aborted";
  } }, { key: "checkSinglePromise", value: function checkSinglePromise(promise, signal) {
    function checkForSingleAbort() {
      if (signal && signal.aborted)
        throw Object.assign(new Error("aborted"), { code: "ERR_ABORTED" });
    }
    return promise.then(function(result) {
      checkForSingleAbort();
      return result;
    }, function(error) {
      checkForSingleAbort();
      throw error;
    });
  } }]);
  return AbortablePromiseCache2;
}();
AbortablePromiseCache$1.default = AbortablePromiseCache;
var _interopRequireDefault$6 = interopRequireDefault.exports;
Object.defineProperty(gosling_es_dist, "__esModule", { value: true });
gosling_es_dist.default = void 0;
var _AbortablePromiseCache = _interopRequireDefault$6(AbortablePromiseCache$1);
var _default = _AbortablePromiseCache.default;
gosling_es_dist.default = _default;
function gosling_es_inflateSync(src) {
  return buffer.Buffer.from(unzlibSync(src));
}
var gosling_es_zlib = { inflateSync: gosling_es_inflateSync };
var zlib$1 = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  [Symbol.toStringTag]: "Module",
  inflateSync: gosling_es_inflateSync,
  "default": gosling_es_zlib
});
var require$$8 = /* @__PURE__ */ getAugmentedNamespace(zlib$1);
class QuickLRU {
  constructor(options = {}) {
    if (!(options.maxSize && options.maxSize > 0)) {
      throw new TypeError("`maxSize` must be a number greater than 0");
    }
    this.maxSize = options.maxSize;
    this.cache = new Map();
    this.oldCache = new Map();
    this._size = 0;
  }
  _set(key, value) {
    this.cache.set(key, value);
    this._size++;
    if (this._size >= this.maxSize) {
      this._size = 0;
      this.oldCache = this.cache;
      this.cache = new Map();
    }
  }
  get(key) {
    if (this.cache.has(key)) {
      return this.cache.get(key);
    }
    if (this.oldCache.has(key)) {
      const value = this.oldCache.get(key);
      this.oldCache.delete(key);
      this._set(key, value);
      return value;
    }
  }
  set(key, value) {
    if (this.cache.has(key)) {
      this.cache.set(key, value);
    } else {
      this._set(key, value);
    }
    return this;
  }
  has(key) {
    return this.cache.has(key) || this.oldCache.has(key);
  }
  peek(key) {
    if (this.cache.has(key)) {
      return this.cache.get(key);
    }
    if (this.oldCache.has(key)) {
      return this.oldCache.get(key);
    }
  }
  delete(key) {
    const deleted = this.cache.delete(key);
    if (deleted) {
      this._size--;
    }
    return this.oldCache.delete(key) || deleted;
  }
  clear() {
    this.cache.clear();
    this.oldCache.clear();
    this._size = 0;
  }
  *keys() {
    for (const [key] of this) {
      yield key;
    }
  }
  *values() {
    for (const [, value] of this) {
      yield value;
    }
  }
  *[Symbol.iterator]() {
    for (const item of this.cache) {
      yield item;
    }
    for (const item of this.oldCache) {
      const [key] = item;
      if (!this.cache.has(key)) {
        yield item;
      }
    }
  }
  get size() {
    let oldCacheSize = 0;
    for (const key of this.oldCache.keys()) {
      if (!this.cache.has(key)) {
        oldCacheSize++;
      }
    }
    return this._size + oldCacheSize;
  }
}
var quickLru = QuickLRU;
var range$1 = {};
var _interopRequireDefault$5 = interopRequireDefault.exports;
Object.defineProperty(range$1, "__esModule", {
  value: true
});
range$1.default = void 0;
var _classCallCheck2$5 = _interopRequireDefault$5(classCallCheck.exports);
var _createClass2$4 = _interopRequireDefault$5(createClass.exports);
var _defineProperty2$4 = _interopRequireDefault$5(gosling_es_defineProperty.exports);
var Range = /* @__PURE__ */ function() {
  function Range2(arg1, arg2) {
    (0, _classCallCheck2$5.default)(this, Range2);
    (0, _defineProperty2$4.default)(this, "ranges", void 0);
    this.ranges = arguments.length === 2 ? [{
      min: arg1,
      max: arg2
    }] : 0 in arg1 ? Object.assign({}, arg1) : [arg1];
  }
  (0, _createClass2$4.default)(Range2, [{
    key: "min",
    value: function min2() {
      return this.ranges[0].min;
    }
  }, {
    key: "max",
    value: function max2() {
      return this.ranges[this.ranges.length - 1].max;
    }
  }, {
    key: "contains",
    value: function contains2(pos) {
      for (var s = 0; s < this.ranges.length; s += 1) {
        var r = this.ranges[s];
        if (r.min <= pos && r.max >= pos) {
          return true;
        }
      }
      return false;
    }
  }, {
    key: "isContiguous",
    value: function isContiguous() {
      return this.ranges.length > 1;
    }
  }, {
    key: "getRanges",
    value: function getRanges() {
      return this.ranges.map(function(r) {
        return new Range2(r.min, r.max);
      });
    }
  }, {
    key: "toString",
    value: function toString2() {
      return this.ranges.map(function(r) {
        return "[".concat(r.min, "-").concat(r.max, "]");
      }).join(",");
    }
  }, {
    key: "union",
    value: function union(s1) {
      var ranges = this.getRanges().concat(s1.getRanges()).sort(this.rangeOrder);
      var oranges = [];
      var current = ranges[0];
      for (var i = 1; i < ranges.length; i += 1) {
        var nxt = ranges[i];
        if (nxt.min() > current.max() + 1) {
          oranges.push(current);
          current = nxt;
        } else if (nxt.max() > current.max()) {
          current = new Range2(current.min(), nxt.max());
        }
      }
      oranges.push(current);
      if (oranges.length === 1) {
        return oranges[0];
      }
      return new Range2(oranges);
    }
  }, {
    key: "intersection",
    value: function intersection(arg) {
      var s0 = this;
      var s1 = arg;
      var r0 = this.ranges();
      var r1 = s1.ranges();
      var l0 = r0.length;
      var l1 = r1.length;
      var i0 = 0;
      var i1 = 0;
      var or2 = [];
      while (i0 < l0 && i1 < l1) {
        s0 = r0[i0];
        s1 = r1[i1];
        var lapMin = Math.max(s0.min(), s1.min());
        var lapMax = Math.min(s0.max(), s1.max());
        if (lapMax >= lapMin) {
          or2.push(new Range2(lapMin, lapMax));
        }
        if (s0.max() > s1.max()) {
          i1 += 1;
        } else {
          i0 += 1;
        }
      }
      if (or2.length === 0) {
        throw new Error("found range of length 0");
      }
      if (or2.length === 1) {
        return or2[0];
      }
      return new Range2(or2);
    }
  }, {
    key: "coverage",
    value: function coverage() {
      var tot = 0;
      var rl = this.ranges();
      for (var ri = 0; ri < rl.length; ri += 1) {
        var r = rl[ri];
        tot += r.max() - r.min() + 1;
      }
      return tot;
    }
  }, {
    key: "rangeOrder",
    value: function rangeOrder(tmpa, tmpb) {
      var a = tmpa;
      var b = tmpb;
      if (arguments.length < 2) {
        b = a;
        a = this;
      }
      if (a.min() < b.min()) {
        return -1;
      }
      if (a.min() > b.min()) {
        return 1;
      }
      if (a.max() < b.max()) {
        return -1;
      }
      if (b.max() > a.max()) {
        return 1;
      }
      return 0;
    }
  }]);
  return Range2;
}();
range$1.default = Range;
var util$6 = {};
var wrapNativeSuper = { exports: {} };
var isNativeFunction = { exports: {} };
(function(module2) {
  function _isNativeFunction(fn) {
    return Function.toString.call(fn).indexOf("[native code]") !== -1;
  }
  module2.exports = _isNativeFunction;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(isNativeFunction);
var construct = { exports: {} };
var isNativeReflectConstruct = { exports: {} };
(function(module2) {
  function _isNativeReflectConstruct2() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e) {
      return false;
    }
  }
  module2.exports = _isNativeReflectConstruct2;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(isNativeReflectConstruct);
(function(module2) {
  var setPrototypeOf$1 = setPrototypeOf.exports;
  var isNativeReflectConstruct$1 = isNativeReflectConstruct.exports;
  function _construct(Parent, args, Class) {
    if (isNativeReflectConstruct$1()) {
      module2.exports = _construct = Reflect.construct;
      module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
    } else {
      module2.exports = _construct = function _construct2(Parent2, args2, Class2) {
        var a = [null];
        a.push.apply(a, args2);
        var Constructor = Function.bind.apply(Parent2, a);
        var instance = new Constructor();
        if (Class2)
          setPrototypeOf$1(instance, Class2.prototype);
        return instance;
      };
      module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
    }
    return _construct.apply(null, arguments);
  }
  module2.exports = _construct;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(construct);
(function(module2) {
  var getPrototypeOf$1 = getPrototypeOf.exports;
  var setPrototypeOf$1 = setPrototypeOf.exports;
  var isNativeFunction$1 = isNativeFunction.exports;
  var construct$1 = construct.exports;
  function _wrapNativeSuper(Class) {
    var _cache = typeof Map === "function" ? new Map() : void 0;
    module2.exports = _wrapNativeSuper = function _wrapNativeSuper3(Class2) {
      if (Class2 === null || !isNativeFunction$1(Class2))
        return Class2;
      if (typeof Class2 !== "function") {
        throw new TypeError("Super expression must either be null or a function");
      }
      if (typeof _cache !== "undefined") {
        if (_cache.has(Class2))
          return _cache.get(Class2);
        _cache.set(Class2, Wrapper);
      }
      function Wrapper() {
        return construct$1(Class2, arguments, getPrototypeOf$1(this).constructor);
      }
      Wrapper.prototype = Object.create(Class2.prototype, {
        constructor: {
          value: Wrapper,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      return setPrototypeOf$1(Wrapper, Class2);
    };
    module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
    return _wrapNativeSuper(Class);
  }
  module2.exports = _wrapNativeSuper;
  module2.exports["default"] = module2.exports, module2.exports.__esModule = true;
})(wrapNativeSuper);
var _interopRequireDefault$4 = interopRequireDefault.exports;
Object.defineProperty(util$6, "__esModule", {
  value: true
});
util$6.groupBlocks = groupBlocks;
util$6.checkAbortSignal = checkAbortSignal;
util$6.abortBreakPoint = abortBreakPoint;
util$6.AbortError = void 0;
var _regenerator$4 = _interopRequireDefault$4(regenerator);
var _asyncToGenerator2$4 = _interopRequireDefault$4(asyncToGenerator.exports);
var _classCallCheck2$4 = _interopRequireDefault$4(classCallCheck.exports);
var _assertThisInitialized2$1 = _interopRequireDefault$4(assertThisInitialized.exports);
var _inherits2$2 = _interopRequireDefault$4(inherits.exports);
var _possibleConstructorReturn2$2 = _interopRequireDefault$4(possibleConstructorReturn.exports);
var _getPrototypeOf2$2 = _interopRequireDefault$4(getPrototypeOf.exports);
var _wrapNativeSuper2 = _interopRequireDefault$4(wrapNativeSuper.exports);
var _defineProperty2$3 = _interopRequireDefault$4(gosling_es_defineProperty.exports);
function _createSuper$2(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct$2();
  return function _createSuperInternal() {
    var Super = (0, _getPrototypeOf2$2.default)(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = (0, _getPrototypeOf2$2.default)(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return (0, _possibleConstructorReturn2$2.default)(this, result);
  };
}
function _isNativeReflectConstruct$2() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function() {
    }));
    return true;
  } catch (e) {
    return false;
  }
}
var AbortError = /* @__PURE__ */ function(_Error) {
  (0, _inherits2$2.default)(AbortError2, _Error);
  var _super = _createSuper$2(AbortError2);
  function AbortError2(message) {
    var _this;
    (0, _classCallCheck2$4.default)(this, AbortError2);
    _this = _super.call(this, message);
    (0, _defineProperty2$3.default)((0, _assertThisInitialized2$1.default)(_this), "code", void 0);
    _this.code = "ERR_ABORTED";
    return _this;
  }
  return AbortError2;
}(/* @__PURE__ */ (0, _wrapNativeSuper2.default)(Error));
util$6.AbortError = AbortError;
function groupBlocks(blocks) {
  blocks.sort(function(b0, b1) {
    return (b0.offset | 0) - (b1.offset | 0);
  });
  var blockGroups = [];
  var lastBlock;
  var lastBlockEnd;
  for (var i = 0; i < blocks.length; i += 1) {
    if (lastBlock && blocks[i].offset - lastBlockEnd <= 2e3) {
      lastBlock.length += blocks[i].length - lastBlockEnd + blocks[i].offset;
      lastBlock.blocks.push(blocks[i]);
    } else {
      blockGroups.push(lastBlock = {
        blocks: [blocks[i]],
        length: blocks[i].length,
        offset: blocks[i].offset
      });
    }
    lastBlockEnd = lastBlock.offset + lastBlock.length;
  }
  return blockGroups;
}
function checkAbortSignal(signal) {
  if (!signal)
    return;
  if (signal.aborted) {
    if (typeof DOMException !== "undefined") {
      throw new DOMException("aborted", "AbortError");
    } else {
      var e = new AbortError("aborted");
      e.code = "ERR_ABORTED";
      throw e;
    }
  }
}
function abortBreakPoint(_x) {
  return _abortBreakPoint.apply(this, arguments);
}
function _abortBreakPoint() {
  _abortBreakPoint = (0, _asyncToGenerator2$4.default)(/* @__PURE__ */ _regenerator$4.default.mark(function _callee(signal) {
    return _regenerator$4.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return Promise.resolve();
          case 2:
            checkAbortSignal(signal);
          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _abortBreakPoint.apply(this, arguments);
}
var _interopRequireDefault$3 = interopRequireDefault.exports;
Object.defineProperty(blockView, "__esModule", {
  value: true
});
blockView.BlockView = void 0;
var _regenerator$3 = _interopRequireDefault$3(regenerator);
var _asyncToGenerator2$3 = _interopRequireDefault$3(asyncToGenerator.exports);
var _classCallCheck2$3 = _interopRequireDefault$3(classCallCheck.exports);
var _createClass2$3 = _interopRequireDefault$3(createClass.exports);
var _defineProperty2$2 = _interopRequireDefault$3(gosling_es_defineProperty.exports);
var _binaryParser$2 = binary_parser;
var _abortablePromiseCache$2 = _interopRequireDefault$3(gosling_es_dist);
var _zlib = _interopRequireDefault$3(require$$8);
var _quickLru$2 = _interopRequireDefault$3(quickLru);
var _range = _interopRequireDefault$3(range$1);
var _util = util$6;
function ownKeys$2(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly)
      symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
    keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread$2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    if (i % 2) {
      ownKeys$2(Object(source), true).forEach(function(key) {
        (0, _defineProperty2$2.default)(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys$2(Object(source)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }
  return target;
}
var BIG_WIG_TYPE_GRAPH = 1;
var BIG_WIG_TYPE_VSTEP = 2;
var BIG_WIG_TYPE_FSTEP = 3;
function getParsers$1(isBigEndian) {
  var _choices;
  var le = isBigEndian ? "big" : "little";
  var summaryParser = new _binaryParser$2.Parser().endianess(le).uint32("chromId").uint32("start").uint32("end").uint32("validCnt").float("minScore").float("maxScore").float("sumData").float("sumSqData");
  var leafParser = new _binaryParser$2.Parser().endianess(le).uint8("isLeaf").skip(1).uint16("cnt").choice({
    tag: "isLeaf",
    choices: {
      1: new _binaryParser$2.Parser().array("blocksToFetch", {
        length: "cnt",
        type: new _binaryParser$2.Parser().uint32("startChrom").uint32("startBase").uint32("endChrom").uint32("endBase").uint64("blockOffset").uint64("blockSize")
      }),
      0: new _binaryParser$2.Parser().array("recurOffsets", {
        length: "cnt",
        type: new _binaryParser$2.Parser().uint32("startChrom").uint32("startBase").uint32("endChrom").uint32("endBase").uint64("blockOffset")
      })
    }
  });
  var bigBedParser = new _binaryParser$2.Parser().endianess(le).uint32("chromId").int32("start").int32("end").string("rest", {
    zeroTerminated: true
  });
  var bigWigParser = new _binaryParser$2.Parser().endianess(le).skip(4).int32("blockStart").skip(4).uint32("itemStep").uint32("itemSpan").uint8("blockType").skip(1).uint16("itemCount").choice({
    tag: "blockType",
    choices: (_choices = {}, (0, _defineProperty2$2.default)(_choices, BIG_WIG_TYPE_FSTEP, new _binaryParser$2.Parser().array("items", {
      length: "itemCount",
      type: new _binaryParser$2.Parser().float("score")
    })), (0, _defineProperty2$2.default)(_choices, BIG_WIG_TYPE_VSTEP, new _binaryParser$2.Parser().array("items", {
      length: "itemCount",
      type: new _binaryParser$2.Parser().int32("start").float("score")
    })), (0, _defineProperty2$2.default)(_choices, BIG_WIG_TYPE_GRAPH, new _binaryParser$2.Parser().array("items", {
      length: "itemCount",
      type: new _binaryParser$2.Parser().int32("start").int32("end").float("score")
    })), _choices)
  });
  return {
    bigWigParser,
    bigBedParser,
    summaryParser,
    leafParser
  };
}
var BlockView = /* @__PURE__ */ function() {
  function BlockView2(bbi2, refsByName, cirTreeOffset, cirTreeLength, isBigEndian, isCompressed, blockType) {
    var _this = this;
    (0, _classCallCheck2$3.default)(this, BlockView2);
    (0, _defineProperty2$2.default)(this, "cirTreeOffset", void 0);
    (0, _defineProperty2$2.default)(this, "cirTreeLength", void 0);
    (0, _defineProperty2$2.default)(this, "bbi", void 0);
    (0, _defineProperty2$2.default)(this, "isCompressed", void 0);
    (0, _defineProperty2$2.default)(this, "isBigEndian", void 0);
    (0, _defineProperty2$2.default)(this, "refsByName", void 0);
    (0, _defineProperty2$2.default)(this, "blockType", void 0);
    (0, _defineProperty2$2.default)(this, "cirTreePromise", void 0);
    (0, _defineProperty2$2.default)(this, "featureCache", new _abortablePromiseCache$2.default({
      cache: new _quickLru$2.default({
        maxSize: 1e3
      }),
      fill: function() {
        var _fill = (0, _asyncToGenerator2$3.default)(/* @__PURE__ */ _regenerator$3.default.mark(function _callee(requestData, signal) {
          var length, offset, _yield$_this$bbi$read, buffer2;
          return _regenerator$3.default.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  length = requestData.length, offset = requestData.offset;
                  _context.next = 3;
                  return _this.bbi.read(Buffer.alloc(length), 0, length, offset, {
                    signal
                  });
                case 3:
                  _yield$_this$bbi$read = _context.sent;
                  buffer2 = _yield$_this$bbi$read.buffer;
                  return _context.abrupt("return", buffer2);
                case 6:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));
        function fill(_x, _x2) {
          return _fill.apply(this, arguments);
        }
        return fill;
      }()
    }));
    (0, _defineProperty2$2.default)(this, "leafParser", void 0);
    (0, _defineProperty2$2.default)(this, "bigWigParser", void 0);
    (0, _defineProperty2$2.default)(this, "bigBedParser", void 0);
    (0, _defineProperty2$2.default)(this, "summaryParser", void 0);
    if (!(cirTreeOffset >= 0))
      throw new Error("invalid cirTreeOffset!");
    if (!(cirTreeLength > 0))
      throw new Error("invalid cirTreeLength!");
    this.cirTreeOffset = cirTreeOffset;
    this.cirTreeLength = cirTreeLength;
    this.isCompressed = isCompressed;
    this.refsByName = refsByName;
    this.isBigEndian = isBigEndian;
    this.bbi = bbi2;
    this.blockType = blockType;
    Object.assign(this, getParsers$1(isBigEndian));
  }
  (0, _createClass2$3.default)(BlockView2, [{
    key: "readWigData",
    value: function() {
      var _readWigData = (0, _asyncToGenerator2$3.default)(/* @__PURE__ */ _regenerator$3.default.mark(function _callee3(chrName, start, end, observer, opts) {
        var _this2 = this;
        var refsByName, bbi2, cirTreeOffset, isBigEndian, signal, chrId, request, _yield$this$cirTreePr, buffer2, cirBlockSize, blocksToFetch, outstanding, cirFobRecur2, filterFeats, cirFobStartFetch, cirFobRecur;
        return _regenerator$3.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.prev = 0;
                refsByName = this.refsByName, bbi2 = this.bbi, cirTreeOffset = this.cirTreeOffset, isBigEndian = this.isBigEndian;
                signal = opts.signal;
                chrId = refsByName[chrName];
                if (chrId === void 0) {
                  observer.complete();
                }
                request = {
                  chrId,
                  start,
                  end
                };
                if (!this.cirTreePromise) {
                  this.cirTreePromise = bbi2.read(Buffer.alloc(48), 0, 48, cirTreeOffset, {
                    signal
                  });
                }
                _context3.next = 9;
                return this.cirTreePromise;
              case 9:
                _yield$this$cirTreePr = _context3.sent;
                buffer2 = _yield$this$cirTreePr.buffer;
                cirBlockSize = isBigEndian ? buffer2.readUInt32BE(4) : buffer2.readUInt32LE(4);
                blocksToFetch = [];
                outstanding = 0;
                filterFeats = function filterFeats2(b) {
                  return (b.startChrom < chrId || b.startChrom === chrId && b.startBase <= end) && (b.endChrom > chrId || b.endChrom === chrId && b.endBase >= start);
                };
                cirFobStartFetch = /* @__PURE__ */ function() {
                  var _ref = (0, _asyncToGenerator2$3.default)(/* @__PURE__ */ _regenerator$3.default.mark(function _callee2(off, fr, level) {
                    var length, offset, resultBuffer, i;
                    return _regenerator$3.default.wrap(function _callee2$(_context2) {
                      while (1) {
                        switch (_context2.prev = _context2.next) {
                          case 0:
                            _context2.prev = 0;
                            length = fr.max() - fr.min();
                            offset = fr.min();
                            _context2.next = 5;
                            return _this2.featureCache.get("".concat(length, "_").concat(offset), {
                              length,
                              offset
                            }, signal);
                          case 5:
                            resultBuffer = _context2.sent;
                            for (i = 0; i < off.length; i += 1) {
                              if (fr.contains(off[i])) {
                                cirFobRecur2(resultBuffer, off[i] - offset, level, observer, opts);
                                outstanding -= 1;
                                if (outstanding === 0) {
                                  _this2.readFeatures(observer, blocksToFetch, _objectSpread$2(_objectSpread$2({}, opts), {}, {
                                    request
                                  }));
                                }
                              }
                            }
                            _context2.next = 12;
                            break;
                          case 9:
                            _context2.prev = 9;
                            _context2.t0 = _context2["catch"](0);
                            observer.error(_context2.t0);
                          case 12:
                          case "end":
                            return _context2.stop();
                        }
                      }
                    }, _callee2, null, [[0, 9]]);
                  }));
                  return function cirFobStartFetch2(_x8, _x9, _x10) {
                    return _ref.apply(this, arguments);
                  };
                }();
                cirFobRecur = function cirFobRecur3(offset, level) {
                  try {
                    outstanding += offset.length;
                    var maxCirBlockSpan = 4 + cirBlockSize * 32;
                    var spans = new _range.default(offset[0], offset[0] + maxCirBlockSpan);
                    for (var i = 1; i < offset.length; i += 1) {
                      var blockSpan = new _range.default(offset[i], offset[i] + maxCirBlockSpan);
                      spans = spans.union(blockSpan);
                    }
                    spans.getRanges().map(function(fr) {
                      return cirFobStartFetch(offset, fr, level);
                    });
                  } catch (e) {
                    observer.error(e);
                  }
                };
                cirFobRecur2 = function cirFobRecur22(cirBlockData, offset, level) {
                  try {
                    var data2 = cirBlockData.slice(offset);
                    var p = _this2.leafParser.parse(data2).result;
                    if (p.blocksToFetch) {
                      blocksToFetch = blocksToFetch.concat(p.blocksToFetch.filter(filterFeats).map(function(l) {
                        return {
                          offset: l.blockOffset,
                          length: l.blockSize
                        };
                      }));
                    }
                    if (p.recurOffsets) {
                      var recurOffsets = p.recurOffsets.filter(filterFeats).map(function(l) {
                        return l.blockOffset;
                      });
                      if (recurOffsets.length > 0) {
                        cirFobRecur(recurOffsets, level + 1);
                      }
                    }
                  } catch (e) {
                    observer.error(e);
                  }
                };
                return _context3.abrupt("return", cirFobRecur([cirTreeOffset + 48], 1));
              case 21:
                _context3.prev = 21;
                _context3.t0 = _context3["catch"](0);
                observer.error(_context3.t0);
              case 24:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[0, 21]]);
      }));
      function readWigData(_x3, _x4, _x5, _x6, _x7) {
        return _readWigData.apply(this, arguments);
      }
      return readWigData;
    }()
  }, {
    key: "parseSummaryBlock",
    value: function parseSummaryBlock(data2, startOffset, request) {
      var features = [];
      var currOffset = startOffset;
      while (currOffset < data2.byteLength) {
        var res = this.summaryParser.parse(data2.slice(currOffset));
        features.push(res.result);
        currOffset += res.offset;
      }
      var items2 = features;
      if (request)
        items2 = items2.filter(function(elt) {
          return elt.chromId === request.chrId;
        });
      items2 = items2.map(function(elt) {
        return {
          start: elt.start,
          end: elt.end,
          maxScore: elt.maxScore,
          minScore: elt.minScore,
          score: elt.sumData / (elt.validCnt || 1),
          summary: true
        };
      });
      return request ? items2.filter(function(f2) {
        return BlockView2.coordFilter(f2, request);
      }) : items2;
    }
  }, {
    key: "parseBigBedBlock",
    value: function parseBigBedBlock(data2, startOffset, offset, request) {
      var items2 = [];
      var currOffset = startOffset;
      while (currOffset < data2.byteLength) {
        var res = this.bigBedParser.parse(data2.slice(currOffset));
        res.result.uniqueId = "bb-".concat(offset + currOffset);
        items2.push(res.result);
        currOffset += res.offset;
      }
      return request ? items2.filter(function(f2) {
        return BlockView2.coordFilter(f2, request);
      }) : items2;
    }
  }, {
    key: "parseBigWigBlock",
    value: function parseBigWigBlock(bytes, startOffset, request) {
      var data2 = bytes.slice(startOffset);
      var results = this.bigWigParser.parse(data2).result;
      var items2 = results.items, itemSpan = results.itemSpan, itemStep = results.itemStep, blockStart = results.blockStart, blockType = results.blockType;
      if (blockType === BIG_WIG_TYPE_FSTEP) {
        for (var i = 0; i < items2.length; i++) {
          items2[i].start = blockStart + i * itemStep;
          items2[i].end = blockStart + i * itemStep + itemSpan;
        }
      } else if (blockType === BIG_WIG_TYPE_VSTEP) {
        for (var _i = 0; _i < items2.length; _i++) {
          items2[_i].end = items2[_i].start + itemSpan;
        }
      }
      return request ? items2.filter(function(f2) {
        return BlockView2.coordFilter(f2, request);
      }) : items2;
    }
  }, {
    key: "readFeatures",
    value: function() {
      var _readFeatures = (0, _asyncToGenerator2$3.default)(/* @__PURE__ */ _regenerator$3.default.mark(function _callee5(observer, blocks) {
        var _this3 = this;
        var opts, blockType, isCompressed, signal, request, blockGroupsToFetch, _args5 = arguments;
        return _regenerator$3.default.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                opts = _args5.length > 2 && _args5[2] !== void 0 ? _args5[2] : {};
                _context5.prev = 1;
                blockType = this.blockType, isCompressed = this.isCompressed;
                signal = opts.signal, request = opts.request;
                blockGroupsToFetch = (0, _util.groupBlocks)(blocks);
                (0, _util.checkAbortSignal)(signal);
                _context5.next = 8;
                return Promise.all(blockGroupsToFetch.map(/* @__PURE__ */ function() {
                  var _ref2 = (0, _asyncToGenerator2$3.default)(/* @__PURE__ */ _regenerator$3.default.mark(function _callee4(blockGroup) {
                    var length, offset, data2;
                    return _regenerator$3.default.wrap(function _callee4$(_context4) {
                      while (1) {
                        switch (_context4.prev = _context4.next) {
                          case 0:
                            (0, _util.checkAbortSignal)(signal);
                            length = blockGroup.length, offset = blockGroup.offset;
                            _context4.next = 4;
                            return _this3.featureCache.get("".concat(length, "_").concat(offset), blockGroup, signal);
                          case 4:
                            data2 = _context4.sent;
                            blockGroup.blocks.forEach(function(block) {
                              (0, _util.checkAbortSignal)(signal);
                              var blockOffset = block.offset - blockGroup.offset;
                              var resultData = data2;
                              if (isCompressed) {
                                resultData = _zlib.default.inflateSync(data2.slice(blockOffset));
                                blockOffset = 0;
                              }
                              (0, _util.checkAbortSignal)(signal);
                              switch (blockType) {
                                case "summary":
                                  observer.next(_this3.parseSummaryBlock(resultData, blockOffset, request));
                                  break;
                                case "bigwig":
                                  observer.next(_this3.parseBigWigBlock(resultData, blockOffset, request));
                                  break;
                                case "bigbed":
                                  observer.next(_this3.parseBigBedBlock(resultData, blockOffset, block.offset * (1 << 8), request));
                                  break;
                                default:
                                  console.warn("Don't know what to do with ".concat(blockType));
                              }
                            });
                          case 6:
                          case "end":
                            return _context4.stop();
                        }
                      }
                    }, _callee4);
                  }));
                  return function(_x13) {
                    return _ref2.apply(this, arguments);
                  };
                }()));
              case 8:
                observer.complete();
                _context5.next = 14;
                break;
              case 11:
                _context5.prev = 11;
                _context5.t0 = _context5["catch"](1);
                observer.error(_context5.t0);
              case 14:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this, [[1, 11]]);
      }));
      function readFeatures(_x11, _x12) {
        return _readFeatures.apply(this, arguments);
      }
      return readFeatures;
    }()
  }], [{
    key: "coordFilter",
    value: function coordFilter(f2, range2) {
      return f2.start < range2.end && f2.end >= range2.start;
    }
  }]);
  return BlockView2;
}();
blockView.BlockView = BlockView;
var bbi = {};
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
    d2.__proto__ = b2;
  } || function(d2, b2) {
    for (var p in b2)
      if (b2.hasOwnProperty(p))
        d2[p] = b2[p];
  };
  return extendStatics(d, b);
};
function __extends(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
function gosling_es_isFunction(x) {
  return typeof x === "function";
}
var _enable_super_gross_mode_that_will_cause_bad_things = false;
var config = {
  Promise: void 0,
  set useDeprecatedSynchronousErrorHandling(value) {
    if (value) {
      var error = /* @__PURE__ */ new Error();
      /* @__PURE__ */ console.warn("DEPRECATED! RxJS was set to use deprecated synchronous error handling behavior by code at: \n" + error.stack);
    }
    _enable_super_gross_mode_that_will_cause_bad_things = value;
  },
  get useDeprecatedSynchronousErrorHandling() {
    return _enable_super_gross_mode_that_will_cause_bad_things;
  }
};
function hostReportError(err) {
  setTimeout(function() {
    throw err;
  }, 0);
}
var empty$1 = {
  closed: true,
  next: function(value) {
  },
  error: function(err) {
    if (config.useDeprecatedSynchronousErrorHandling) {
      throw err;
    } else {
      hostReportError(err);
    }
  },
  complete: function() {
  }
};
var gosling_es_isArray = /* @__PURE__ */ function() {
  return Array.isArray || function(x) {
    return x && typeof x.length === "number";
  };
}();
function gosling_es_isObject(x) {
  return x !== null && typeof x === "object";
}
var UnsubscriptionErrorImpl = /* @__PURE__ */ function() {
  function UnsubscriptionErrorImpl2(errors) {
    Error.call(this);
    this.message = errors ? errors.length + " errors occurred during unsubscription:\n" + errors.map(function(err, i) {
      return i + 1 + ") " + err.toString();
    }).join("\n  ") : "";
    this.name = "UnsubscriptionError";
    this.errors = errors;
    return this;
  }
  UnsubscriptionErrorImpl2.prototype = /* @__PURE__ */ Object.create(Error.prototype);
  return UnsubscriptionErrorImpl2;
}();
var UnsubscriptionError = UnsubscriptionErrorImpl;
var Subscription = /* @__PURE__ */ function() {
  function Subscription2(unsubscribe) {
    this.closed = false;
    this._parentOrParents = null;
    this._subscriptions = null;
    if (unsubscribe) {
      this._ctorUnsubscribe = true;
      this._unsubscribe = unsubscribe;
    }
  }
  Subscription2.prototype.unsubscribe = function() {
    var errors;
    if (this.closed) {
      return;
    }
    var _a = this, _parentOrParents = _a._parentOrParents, _ctorUnsubscribe = _a._ctorUnsubscribe, _unsubscribe = _a._unsubscribe, _subscriptions = _a._subscriptions;
    this.closed = true;
    this._parentOrParents = null;
    this._subscriptions = null;
    if (_parentOrParents instanceof Subscription2) {
      _parentOrParents.remove(this);
    } else if (_parentOrParents !== null) {
      for (var index = 0; index < _parentOrParents.length; ++index) {
        var parent_1 = _parentOrParents[index];
        parent_1.remove(this);
      }
    }
    if (gosling_es_isFunction(_unsubscribe)) {
      if (_ctorUnsubscribe) {
        this._unsubscribe = void 0;
      }
      try {
        _unsubscribe.call(this);
      } catch (e) {
        errors = e instanceof UnsubscriptionError ? flattenUnsubscriptionErrors(e.errors) : [e];
      }
    }
    if (gosling_es_isArray(_subscriptions)) {
      var index = -1;
      var len = _subscriptions.length;
      while (++index < len) {
        var sub = _subscriptions[index];
        if (gosling_es_isObject(sub)) {
          try {
            sub.unsubscribe();
          } catch (e) {
            errors = errors || [];
            if (e instanceof UnsubscriptionError) {
              errors = errors.concat(flattenUnsubscriptionErrors(e.errors));
            } else {
              errors.push(e);
            }
          }
        }
      }
    }
    if (errors) {
      throw new UnsubscriptionError(errors);
    }
  };
  Subscription2.prototype.add = function(teardown) {
    var subscription = teardown;
    if (!teardown) {
      return Subscription2.EMPTY;
    }
    switch (typeof teardown) {
      case "function":
        subscription = new Subscription2(teardown);
      case "object":
        if (subscription === this || subscription.closed || typeof subscription.unsubscribe !== "function") {
          return subscription;
        } else if (this.closed) {
          subscription.unsubscribe();
          return subscription;
        } else if (!(subscription instanceof Subscription2)) {
          var tmp = subscription;
          subscription = new Subscription2();
          subscription._subscriptions = [tmp];
        }
        break;
      default: {
        throw new Error("unrecognized teardown " + teardown + " added to Subscription.");
      }
    }
    var _parentOrParents = subscription._parentOrParents;
    if (_parentOrParents === null) {
      subscription._parentOrParents = this;
    } else if (_parentOrParents instanceof Subscription2) {
      if (_parentOrParents === this) {
        return subscription;
      }
      subscription._parentOrParents = [_parentOrParents, this];
    } else if (_parentOrParents.indexOf(this) === -1) {
      _parentOrParents.push(this);
    } else {
      return subscription;
    }
    var subscriptions = this._subscriptions;
    if (subscriptions === null) {
      this._subscriptions = [subscription];
    } else {
      subscriptions.push(subscription);
    }
    return subscription;
  };
  Subscription2.prototype.remove = function(subscription) {
    var subscriptions = this._subscriptions;
    if (subscriptions) {
      var subscriptionIndex = subscriptions.indexOf(subscription);
      if (subscriptionIndex !== -1) {
        subscriptions.splice(subscriptionIndex, 1);
      }
    }
  };
  Subscription2.EMPTY = function(empty2) {
    empty2.closed = true;
    return empty2;
  }(new Subscription2());
  return Subscription2;
}();
function flattenUnsubscriptionErrors(errors) {
  return errors.reduce(function(errs, err) {
    return errs.concat(err instanceof UnsubscriptionError ? err.errors : err);
  }, []);
}
var rxSubscriber = /* @__PURE__ */ function() {
  return typeof Symbol === "function" ? /* @__PURE__ */ Symbol("rxSubscriber") : "@@rxSubscriber_" + /* @__PURE__ */ Math.random();
}();
var Subscriber = /* @__PURE__ */ function(_super) {
  __extends(Subscriber2, _super);
  function Subscriber2(destinationOrNext, error, complete) {
    var _this = _super.call(this) || this;
    _this.syncErrorValue = null;
    _this.syncErrorThrown = false;
    _this.syncErrorThrowable = false;
    _this.isStopped = false;
    switch (arguments.length) {
      case 0:
        _this.destination = empty$1;
        break;
      case 1:
        if (!destinationOrNext) {
          _this.destination = empty$1;
          break;
        }
        if (typeof destinationOrNext === "object") {
          if (destinationOrNext instanceof Subscriber2) {
            _this.syncErrorThrowable = destinationOrNext.syncErrorThrowable;
            _this.destination = destinationOrNext;
            destinationOrNext.add(_this);
          } else {
            _this.syncErrorThrowable = true;
            _this.destination = new SafeSubscriber(_this, destinationOrNext);
          }
          break;
        }
      default:
        _this.syncErrorThrowable = true;
        _this.destination = new SafeSubscriber(_this, destinationOrNext, error, complete);
        break;
    }
    return _this;
  }
  Subscriber2.prototype[rxSubscriber] = function() {
    return this;
  };
  Subscriber2.create = function(next, error, complete) {
    var subscriber = new Subscriber2(next, error, complete);
    subscriber.syncErrorThrowable = false;
    return subscriber;
  };
  Subscriber2.prototype.next = function(value) {
    if (!this.isStopped) {
      this._next(value);
    }
  };
  Subscriber2.prototype.error = function(err) {
    if (!this.isStopped) {
      this.isStopped = true;
      this._error(err);
    }
  };
  Subscriber2.prototype.complete = function() {
    if (!this.isStopped) {
      this.isStopped = true;
      this._complete();
    }
  };
  Subscriber2.prototype.unsubscribe = function() {
    if (this.closed) {
      return;
    }
    this.isStopped = true;
    _super.prototype.unsubscribe.call(this);
  };
  Subscriber2.prototype._next = function(value) {
    this.destination.next(value);
  };
  Subscriber2.prototype._error = function(err) {
    this.destination.error(err);
    this.unsubscribe();
  };
  Subscriber2.prototype._complete = function() {
    this.destination.complete();
    this.unsubscribe();
  };
  Subscriber2.prototype._unsubscribeAndRecycle = function() {
    var _parentOrParents = this._parentOrParents;
    this._parentOrParents = null;
    this.unsubscribe();
    this.closed = false;
    this.isStopped = false;
    this._parentOrParents = _parentOrParents;
    return this;
  };
  return Subscriber2;
}(Subscription);
var SafeSubscriber = /* @__PURE__ */ function(_super) {
  __extends(SafeSubscriber2, _super);
  function SafeSubscriber2(_parentSubscriber, observerOrNext, error, complete) {
    var _this = _super.call(this) || this;
    _this._parentSubscriber = _parentSubscriber;
    var next;
    var context2 = _this;
    if (gosling_es_isFunction(observerOrNext)) {
      next = observerOrNext;
    } else if (observerOrNext) {
      next = observerOrNext.next;
      error = observerOrNext.error;
      complete = observerOrNext.complete;
      if (observerOrNext !== empty$1) {
        context2 = Object.create(observerOrNext);
        if (gosling_es_isFunction(context2.unsubscribe)) {
          _this.add(context2.unsubscribe.bind(context2));
        }
        context2.unsubscribe = _this.unsubscribe.bind(_this);
      }
    }
    _this._context = context2;
    _this._next = next;
    _this._error = error;
    _this._complete = complete;
    return _this;
  }
  SafeSubscriber2.prototype.next = function(value) {
    if (!this.isStopped && this._next) {
      var _parentSubscriber = this._parentSubscriber;
      if (!config.useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
        this.__tryOrUnsub(this._next, value);
      } else if (this.__tryOrSetError(_parentSubscriber, this._next, value)) {
        this.unsubscribe();
      }
    }
  };
  SafeSubscriber2.prototype.error = function(err) {
    if (!this.isStopped) {
      var _parentSubscriber = this._parentSubscriber;
      var useDeprecatedSynchronousErrorHandling = config.useDeprecatedSynchronousErrorHandling;
      if (this._error) {
        if (!useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
          this.__tryOrUnsub(this._error, err);
          this.unsubscribe();
        } else {
          this.__tryOrSetError(_parentSubscriber, this._error, err);
          this.unsubscribe();
        }
      } else if (!_parentSubscriber.syncErrorThrowable) {
        this.unsubscribe();
        if (useDeprecatedSynchronousErrorHandling) {
          throw err;
        }
        hostReportError(err);
      } else {
        if (useDeprecatedSynchronousErrorHandling) {
          _parentSubscriber.syncErrorValue = err;
          _parentSubscriber.syncErrorThrown = true;
        } else {
          hostReportError(err);
        }
        this.unsubscribe();
      }
    }
  };
  SafeSubscriber2.prototype.complete = function() {
    var _this = this;
    if (!this.isStopped) {
      var _parentSubscriber = this._parentSubscriber;
      if (this._complete) {
        var wrappedComplete = function() {
          return _this._complete.call(_this._context);
        };
        if (!config.useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
          this.__tryOrUnsub(wrappedComplete);
          this.unsubscribe();
        } else {
          this.__tryOrSetError(_parentSubscriber, wrappedComplete);
          this.unsubscribe();
        }
      } else {
        this.unsubscribe();
      }
    }
  };
  SafeSubscriber2.prototype.__tryOrUnsub = function(fn, value) {
    try {
      fn.call(this._context, value);
    } catch (err) {
      this.unsubscribe();
      if (config.useDeprecatedSynchronousErrorHandling) {
        throw err;
      } else {
        hostReportError(err);
      }
    }
  };
  SafeSubscriber2.prototype.__tryOrSetError = function(parent, fn, value) {
    if (!config.useDeprecatedSynchronousErrorHandling) {
      throw new Error("bad call");
    }
    try {
      fn.call(this._context, value);
    } catch (err) {
      if (config.useDeprecatedSynchronousErrorHandling) {
        parent.syncErrorValue = err;
        parent.syncErrorThrown = true;
        return true;
      } else {
        hostReportError(err);
        return true;
      }
    }
    return false;
  };
  SafeSubscriber2.prototype._unsubscribe = function() {
    var _parentSubscriber = this._parentSubscriber;
    this._context = null;
    this._parentSubscriber = null;
    _parentSubscriber.unsubscribe();
  };
  return SafeSubscriber2;
}(Subscriber);
function canReportError(observer) {
  while (observer) {
    var _a = observer, closed_1 = _a.closed, destination = _a.destination, isStopped = _a.isStopped;
    if (closed_1 || isStopped) {
      return false;
    } else if (destination && destination instanceof Subscriber) {
      observer = destination;
    } else {
      observer = null;
    }
  }
  return true;
}
function toSubscriber(nextOrObserver, error, complete) {
  if (nextOrObserver) {
    if (nextOrObserver instanceof Subscriber) {
      return nextOrObserver;
    }
    if (nextOrObserver[rxSubscriber]) {
      return nextOrObserver[rxSubscriber]();
    }
  }
  if (!nextOrObserver && !error && !complete) {
    return new Subscriber(empty$1);
  }
  return new Subscriber(nextOrObserver, error, complete);
}
var observable = /* @__PURE__ */ function() {
  return typeof Symbol === "function" && Symbol.observable || "@@observable";
}();
function gosling_es_identity(x) {
  return x;
}
function pipe() {
  var fns = [];
  for (var _i = 0; _i < arguments.length; _i++) {
    fns[_i] = arguments[_i];
  }
  return pipeFromArray(fns);
}
function pipeFromArray(fns) {
  if (fns.length === 0) {
    return gosling_es_identity;
  }
  if (fns.length === 1) {
    return fns[0];
  }
  return function piped(input) {
    return fns.reduce(function(prev, fn) {
      return fn(prev);
    }, input);
  };
}
var Observable = /* @__PURE__ */ function() {
  function Observable2(subscribe) {
    this._isScalar = false;
    if (subscribe) {
      this._subscribe = subscribe;
    }
  }
  Observable2.prototype.lift = function(operator) {
    var observable2 = new Observable2();
    observable2.source = this;
    observable2.operator = operator;
    return observable2;
  };
  Observable2.prototype.subscribe = function(observerOrNext, error, complete) {
    var operator = this.operator;
    var sink = toSubscriber(observerOrNext, error, complete);
    if (operator) {
      sink.add(operator.call(sink, this.source));
    } else {
      sink.add(this.source || config.useDeprecatedSynchronousErrorHandling && !sink.syncErrorThrowable ? this._subscribe(sink) : this._trySubscribe(sink));
    }
    if (config.useDeprecatedSynchronousErrorHandling) {
      if (sink.syncErrorThrowable) {
        sink.syncErrorThrowable = false;
        if (sink.syncErrorThrown) {
          throw sink.syncErrorValue;
        }
      }
    }
    return sink;
  };
  Observable2.prototype._trySubscribe = function(sink) {
    try {
      return this._subscribe(sink);
    } catch (err) {
      if (config.useDeprecatedSynchronousErrorHandling) {
        sink.syncErrorThrown = true;
        sink.syncErrorValue = err;
      }
      if (canReportError(sink)) {
        sink.error(err);
      } else {
        console.warn(err);
      }
    }
  };
  Observable2.prototype.forEach = function(next, promiseCtor) {
    var _this = this;
    promiseCtor = getPromiseCtor(promiseCtor);
    return new promiseCtor(function(resolve2, reject) {
      var subscription;
      subscription = _this.subscribe(function(value) {
        try {
          next(value);
        } catch (err) {
          reject(err);
          if (subscription) {
            subscription.unsubscribe();
          }
        }
      }, reject, resolve2);
    });
  };
  Observable2.prototype._subscribe = function(subscriber) {
    var source = this.source;
    return source && source.subscribe(subscriber);
  };
  Observable2.prototype[observable] = function() {
    return this;
  };
  Observable2.prototype.pipe = function() {
    var operations = [];
    for (var _i = 0; _i < arguments.length; _i++) {
      operations[_i] = arguments[_i];
    }
    if (operations.length === 0) {
      return this;
    }
    return pipeFromArray(operations)(this);
  };
  Observable2.prototype.toPromise = function(promiseCtor) {
    var _this = this;
    promiseCtor = getPromiseCtor(promiseCtor);
    return new promiseCtor(function(resolve2, reject) {
      var value;
      _this.subscribe(function(x) {
        return value = x;
      }, function(err) {
        return reject(err);
      }, function() {
        return resolve2(value);
      });
    });
  };
  Observable2.create = function(subscribe) {
    return new Observable2(subscribe);
  };
  return Observable2;
}();
function getPromiseCtor(promiseCtor) {
  if (!promiseCtor) {
    promiseCtor = config.Promise || Promise;
  }
  if (!promiseCtor) {
    throw new Error("no Promise impl found");
  }
  return promiseCtor;
}
var ObjectUnsubscribedErrorImpl = /* @__PURE__ */ function() {
  function ObjectUnsubscribedErrorImpl2() {
    Error.call(this);
    this.message = "object unsubscribed";
    this.name = "ObjectUnsubscribedError";
    return this;
  }
  ObjectUnsubscribedErrorImpl2.prototype = /* @__PURE__ */ Object.create(Error.prototype);
  return ObjectUnsubscribedErrorImpl2;
}();
var ObjectUnsubscribedError = ObjectUnsubscribedErrorImpl;
var SubjectSubscription = /* @__PURE__ */ function(_super) {
  __extends(SubjectSubscription2, _super);
  function SubjectSubscription2(subject, subscriber) {
    var _this = _super.call(this) || this;
    _this.subject = subject;
    _this.subscriber = subscriber;
    _this.closed = false;
    return _this;
  }
  SubjectSubscription2.prototype.unsubscribe = function() {
    if (this.closed) {
      return;
    }
    this.closed = true;
    var subject = this.subject;
    var observers = subject.observers;
    this.subject = null;
    if (!observers || observers.length === 0 || subject.isStopped || subject.closed) {
      return;
    }
    var subscriberIndex = observers.indexOf(this.subscriber);
    if (subscriberIndex !== -1) {
      observers.splice(subscriberIndex, 1);
    }
  };
  return SubjectSubscription2;
}(Subscription);
var SubjectSubscriber = /* @__PURE__ */ function(_super) {
  __extends(SubjectSubscriber2, _super);
  function SubjectSubscriber2(destination) {
    var _this = _super.call(this, destination) || this;
    _this.destination = destination;
    return _this;
  }
  return SubjectSubscriber2;
}(Subscriber);
var Subject = /* @__PURE__ */ function(_super) {
  __extends(Subject2, _super);
  function Subject2() {
    var _this = _super.call(this) || this;
    _this.observers = [];
    _this.closed = false;
    _this.isStopped = false;
    _this.hasError = false;
    _this.thrownError = null;
    return _this;
  }
  Subject2.prototype[rxSubscriber] = function() {
    return new SubjectSubscriber(this);
  };
  Subject2.prototype.lift = function(operator) {
    var subject = new AnonymousSubject(this, this);
    subject.operator = operator;
    return subject;
  };
  Subject2.prototype.next = function(value) {
    if (this.closed) {
      throw new ObjectUnsubscribedError();
    }
    if (!this.isStopped) {
      var observers = this.observers;
      var len = observers.length;
      var copy2 = observers.slice();
      for (var i = 0; i < len; i++) {
        copy2[i].next(value);
      }
    }
  };
  Subject2.prototype.error = function(err) {
    if (this.closed) {
      throw new ObjectUnsubscribedError();
    }
    this.hasError = true;
    this.thrownError = err;
    this.isStopped = true;
    var observers = this.observers;
    var len = observers.length;
    var copy2 = observers.slice();
    for (var i = 0; i < len; i++) {
      copy2[i].error(err);
    }
    this.observers.length = 0;
  };
  Subject2.prototype.complete = function() {
    if (this.closed) {
      throw new ObjectUnsubscribedError();
    }
    this.isStopped = true;
    var observers = this.observers;
    var len = observers.length;
    var copy2 = observers.slice();
    for (var i = 0; i < len; i++) {
      copy2[i].complete();
    }
    this.observers.length = 0;
  };
  Subject2.prototype.unsubscribe = function() {
    this.isStopped = true;
    this.closed = true;
    this.observers = null;
  };
  Subject2.prototype._trySubscribe = function(subscriber) {
    if (this.closed) {
      throw new ObjectUnsubscribedError();
    } else {
      return _super.prototype._trySubscribe.call(this, subscriber);
    }
  };
  Subject2.prototype._subscribe = function(subscriber) {
    if (this.closed) {
      throw new ObjectUnsubscribedError();
    } else if (this.hasError) {
      subscriber.error(this.thrownError);
      return Subscription.EMPTY;
    } else if (this.isStopped) {
      subscriber.complete();
      return Subscription.EMPTY;
    } else {
      this.observers.push(subscriber);
      return new SubjectSubscription(this, subscriber);
    }
  };
  Subject2.prototype.asObservable = function() {
    var observable2 = new Observable();
    observable2.source = this;
    return observable2;
  };
  Subject2.create = function(destination, source) {
    return new AnonymousSubject(destination, source);
  };
  return Subject2;
}(Observable);
var AnonymousSubject = /* @__PURE__ */ function(_super) {
  __extends(AnonymousSubject2, _super);
  function AnonymousSubject2(destination, source) {
    var _this = _super.call(this) || this;
    _this.destination = destination;
    _this.source = source;
    return _this;
  }
  AnonymousSubject2.prototype.next = function(value) {
    var destination = this.destination;
    if (destination && destination.next) {
      destination.next(value);
    }
  };
  AnonymousSubject2.prototype.error = function(err) {
    var destination = this.destination;
    if (destination && destination.error) {
      this.destination.error(err);
    }
  };
  AnonymousSubject2.prototype.complete = function() {
    var destination = this.destination;
    if (destination && destination.complete) {
      this.destination.complete();
    }
  };
  AnonymousSubject2.prototype._subscribe = function(subscriber) {
    var source = this.source;
    if (source) {
      return this.source.subscribe(subscriber);
    } else {
      return Subscription.EMPTY;
    }
  };
  return AnonymousSubject2;
}(Subject);
function refCount() {
  return function refCountOperatorFunction(source) {
    return source.lift(new RefCountOperator(source));
  };
}
var RefCountOperator = /* @__PURE__ */ function() {
  function RefCountOperator2(connectable) {
    this.connectable = connectable;
  }
  RefCountOperator2.prototype.call = function(subscriber, source) {
    var connectable = this.connectable;
    connectable._refCount++;
    var refCounter = new RefCountSubscriber(subscriber, connectable);
    var subscription = source.subscribe(refCounter);
    if (!refCounter.closed) {
      refCounter.connection = connectable.connect();
    }
    return subscription;
  };
  return RefCountOperator2;
}();
var RefCountSubscriber = /* @__PURE__ */ function(_super) {
  __extends(RefCountSubscriber2, _super);
  function RefCountSubscriber2(destination, connectable) {
    var _this = _super.call(this, destination) || this;
    _this.connectable = connectable;
    return _this;
  }
  RefCountSubscriber2.prototype._unsubscribe = function() {
    var connectable = this.connectable;
    if (!connectable) {
      this.connection = null;
      return;
    }
    this.connectable = null;
    var refCount2 = connectable._refCount;
    if (refCount2 <= 0) {
      this.connection = null;
      return;
    }
    connectable._refCount = refCount2 - 1;
    if (refCount2 > 1) {
      this.connection = null;
      return;
    }
    var connection = this.connection;
    var sharedConnection = connectable._connection;
    this.connection = null;
    if (sharedConnection && (!connection || sharedConnection === connection)) {
      sharedConnection.unsubscribe();
    }
  };
  return RefCountSubscriber2;
}(Subscriber);
var ConnectableObservable = /* @__PURE__ */ function(_super) {
  __extends(ConnectableObservable2, _super);
  function ConnectableObservable2(source, subjectFactory) {
    var _this = _super.call(this) || this;
    _this.source = source;
    _this.subjectFactory = subjectFactory;
    _this._refCount = 0;
    _this._isComplete = false;
    return _this;
  }
  ConnectableObservable2.prototype._subscribe = function(subscriber) {
    return this.getSubject().subscribe(subscriber);
  };
  ConnectableObservable2.prototype.getSubject = function() {
    var subject = this._subject;
    if (!subject || subject.isStopped) {
      this._subject = this.subjectFactory();
    }
    return this._subject;
  };
  ConnectableObservable2.prototype.connect = function() {
    var connection = this._connection;
    if (!connection) {
      this._isComplete = false;
      connection = this._connection = new Subscription();
      connection.add(this.source.subscribe(new ConnectableSubscriber(this.getSubject(), this)));
      if (connection.closed) {
        this._connection = null;
        connection = Subscription.EMPTY;
      }
    }
    return connection;
  };
  ConnectableObservable2.prototype.refCount = function() {
    return refCount()(this);
  };
  return ConnectableObservable2;
}(Observable);
var connectableObservableDescriptor = /* @__PURE__ */ function() {
  var connectableProto = ConnectableObservable.prototype;
  return {
    operator: { value: null },
    _refCount: { value: 0, writable: true },
    _subject: { value: null, writable: true },
    _connection: { value: null, writable: true },
    _subscribe: { value: connectableProto._subscribe },
    _isComplete: { value: connectableProto._isComplete, writable: true },
    getSubject: { value: connectableProto.getSubject },
    connect: { value: connectableProto.connect },
    refCount: { value: connectableProto.refCount }
  };
}();
var ConnectableSubscriber = /* @__PURE__ */ function(_super) {
  __extends(ConnectableSubscriber2, _super);
  function ConnectableSubscriber2(destination, connectable) {
    var _this = _super.call(this, destination) || this;
    _this.connectable = connectable;
    return _this;
  }
  ConnectableSubscriber2.prototype._error = function(err) {
    this._unsubscribe();
    _super.prototype._error.call(this, err);
  };
  ConnectableSubscriber2.prototype._complete = function() {
    this.connectable._isComplete = true;
    this._unsubscribe();
    _super.prototype._complete.call(this);
  };
  ConnectableSubscriber2.prototype._unsubscribe = function() {
    var connectable = this.connectable;
    if (connectable) {
      this.connectable = null;
      var connection = connectable._connection;
      connectable._refCount = 0;
      connectable._subject = null;
      connectable._connection = null;
      if (connection) {
        connection.unsubscribe();
      }
    }
  };
  return ConnectableSubscriber2;
}(SubjectSubscriber);
function groupBy(keySelector, elementSelector, durationSelector, subjectSelector) {
  return function(source) {
    return source.lift(new GroupByOperator(keySelector, elementSelector, durationSelector, subjectSelector));
  };
}
var GroupByOperator = /* @__PURE__ */ function() {
  function GroupByOperator2(keySelector, elementSelector, durationSelector, subjectSelector) {
    this.keySelector = keySelector;
    this.elementSelector = elementSelector;
    this.durationSelector = durationSelector;
    this.subjectSelector = subjectSelector;
  }
  GroupByOperator2.prototype.call = function(subscriber, source) {
    return source.subscribe(new GroupBySubscriber(subscriber, this.keySelector, this.elementSelector, this.durationSelector, this.subjectSelector));
  };
  return GroupByOperator2;
}();
var GroupBySubscriber = /* @__PURE__ */ function(_super) {
  __extends(GroupBySubscriber2, _super);
  function GroupBySubscriber2(destination, keySelector, elementSelector, durationSelector, subjectSelector) {
    var _this = _super.call(this, destination) || this;
    _this.keySelector = keySelector;
    _this.elementSelector = elementSelector;
    _this.durationSelector = durationSelector;
    _this.subjectSelector = subjectSelector;
    _this.groups = null;
    _this.attemptedToUnsubscribe = false;
    _this.count = 0;
    return _this;
  }
  GroupBySubscriber2.prototype._next = function(value) {
    var key;
    try {
      key = this.keySelector(value);
    } catch (err) {
      this.error(err);
      return;
    }
    this._group(value, key);
  };
  GroupBySubscriber2.prototype._group = function(value, key) {
    var groups = this.groups;
    if (!groups) {
      groups = this.groups = new Map();
    }
    var group2 = groups.get(key);
    var element;
    if (this.elementSelector) {
      try {
        element = this.elementSelector(value);
      } catch (err) {
        this.error(err);
      }
    } else {
      element = value;
    }
    if (!group2) {
      group2 = this.subjectSelector ? this.subjectSelector() : new Subject();
      groups.set(key, group2);
      var groupedObservable = new GroupedObservable(key, group2, this);
      this.destination.next(groupedObservable);
      if (this.durationSelector) {
        var duration = void 0;
        try {
          duration = this.durationSelector(new GroupedObservable(key, group2));
        } catch (err) {
          this.error(err);
          return;
        }
        this.add(duration.subscribe(new GroupDurationSubscriber(key, group2, this)));
      }
    }
    if (!group2.closed) {
  