# coding: utf-8

"""
    Blog Post endpoints

    \"Use these endpoints for interacting with Blog Posts, Blog Authors, and Blog Tags\"  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.cms.blogs.blog_posts.configuration import Configuration


class BlogPost(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "slug": "str",
        "content_group_id": "str",
        "campaign": "str",
        "category_id": "int",
        "state": "str",
        "template_path": "str",
        "name": "str",
        "mab_experiment_id": "str",
        "archived": "bool",
        "author_name": "str",
        "ab_test_id": "str",
        "created_by_id": "str",
        "updated_by_id": "str",
        "domain": "str",
        "subcategory": "str",
        "ab_status": "str",
        "folder_id": "str",
        "widget_containers": "object",
        "widgets": "object",
        "language": "str",
        "translated_from_id": "str",
        "dynamic_page_hub_db_table_id": "str",
        "blog_author_id": "str",
        "html_title": "str",
        "page_redirected": "bool",
        "page_expiry_enabled": "bool",
        "page_expiry_date": "int",
        "page_expiry_redirect_id": "int",
        "page_expiry_redirect_url": "str",
        "use_featured_image": "bool",
        "tag_ids": "list[int]",
        "enable_google_amp_output_override": "bool",
        "post_body": "str",
        "post_summary": "str",
        "rss_body": "str",
        "rss_summary": "str",
        "password": "str",
        "attached_stylesheets": "list[object]",
        "include_default_custom_css": "bool",
        "enable_domain_stylesheets": "bool",
        "enable_layout_stylesheets": "bool",
        "meta_description": "str",
        "publish_immediately": "bool",
        "head_html": "str",
        "footer_html": "str",
        "content_type_category": "str",
        "current_state": "str",
        "link_rel_canonical_url": "str",
        "featured_image": "str",
        "featured_image_alt_text": "str",
        "public_access_rules_enabled": "bool",
        "public_access_rules": "list[object]",
        "layout_sections": "dict(str, LayoutSection)",
        "theme_settings_values": "object",
        "url": "str",
        "publish_date": "datetime",
        "deleted_at": "datetime",
        "created_at": "datetime",
        "published": "bool",
        "updated_at": "datetime",
    }

    attribute_map = {
        "id": "id",
        "slug": "slug",
        "content_group_id": "contentGroupId",
        "campaign": "campaign",
        "category_id": "categoryId",
        "state": "state",
        "template_path": "templatePath",
        "name": "name",
        "mab_experiment_id": "mabExperimentId",
        "archived": "archived",
        "author_name": "authorName",
        "ab_test_id": "abTestId",
        "created_by_id": "createdById",
        "updated_by_id": "updatedById",
        "domain": "domain",
        "subcategory": "subcategory",
        "ab_status": "abStatus",
        "folder_id": "folderId",
        "widget_containers": "widgetContainers",
        "widgets": "widgets",
        "language": "language",
        "translated_from_id": "translatedFromId",
        "dynamic_page_hub_db_table_id": "dynamicPageHubDbTableId",
        "blog_author_id": "blogAuthorId",
        "html_title": "htmlTitle",
        "page_redirected": "pageRedirected",
        "page_expiry_enabled": "pageExpiryEnabled",
        "page_expiry_date": "pageExpiryDate",
        "page_expiry_redirect_id": "pageExpiryRedirectId",
        "page_expiry_redirect_url": "pageExpiryRedirectUrl",
        "use_featured_image": "useFeaturedImage",
        "tag_ids": "tagIds",
        "enable_google_amp_output_override": "enableGoogleAmpOutputOverride",
        "post_body": "postBody",
        "post_summary": "postSummary",
        "rss_body": "rssBody",
        "rss_summary": "rssSummary",
        "password": "password",
        "attached_stylesheets": "attachedStylesheets",
        "include_default_custom_css": "includeDefaultCustomCss",
        "enable_domain_stylesheets": "enableDomainStylesheets",
        "enable_layout_stylesheets": "enableLayoutStylesheets",
        "meta_description": "metaDescription",
        "publish_immediately": "publishImmediately",
        "head_html": "headHtml",
        "footer_html": "footerHtml",
        "content_type_category": "contentTypeCategory",
        "current_state": "currentState",
        "link_rel_canonical_url": "linkRelCanonicalUrl",
        "featured_image": "featuredImage",
        "featured_image_alt_text": "featuredImageAltText",
        "public_access_rules_enabled": "publicAccessRulesEnabled",
        "public_access_rules": "publicAccessRules",
        "layout_sections": "layoutSections",
        "theme_settings_values": "themeSettingsValues",
        "url": "url",
        "publish_date": "publishDate",
        "deleted_at": "deletedAt",
        "created_at": "createdAt",
        "published": "published",
        "updated_at": "updatedAt",
    }

    def __init__(
        self,
        id=None,
        slug=None,
        content_group_id=None,
        campaign=None,
        category_id=None,
        state=None,
        template_path=None,
        name=None,
        mab_experiment_id=None,
        archived=None,
        author_name=None,
        ab_test_id=None,
        created_by_id=None,
        updated_by_id=None,
        domain=None,
        subcategory=None,
        ab_status=None,
        folder_id=None,
        widget_containers=None,
        widgets=None,
        language=None,
        translated_from_id=None,
        dynamic_page_hub_db_table_id=None,
        blog_author_id=None,
        html_title=None,
        page_redirected=None,
        page_expiry_enabled=None,
        page_expiry_date=None,
        page_expiry_redirect_id=None,
        page_expiry_redirect_url=None,
        use_featured_image=None,
        tag_ids=None,
        enable_google_amp_output_override=None,
        post_body=None,
        post_summary=None,
        rss_body=None,
        rss_summary=None,
        password=None,
        attached_stylesheets=None,
        include_default_custom_css=None,
        enable_domain_stylesheets=None,
        enable_layout_stylesheets=None,
        meta_description=None,
        publish_immediately=None,
        head_html=None,
        footer_html=None,
        content_type_category=None,
        current_state=None,
        link_rel_canonical_url=None,
        featured_image=None,
        featured_image_alt_text=None,
        public_access_rules_enabled=None,
        public_access_rules=None,
        layout_sections=None,
        theme_settings_values=None,
        url=None,
        publish_date=None,
        deleted_at=None,
        created_at=None,
        published=None,
        updated_at=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """BlogPost - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._slug = None
        self._content_group_id = None
        self._campaign = None
        self._category_id = None
        self._state = None
        self._template_path = None
        self._name = None
        self._mab_experiment_id = None
        self._archived = None
        self._author_name = None
        self._ab_test_id = None
        self._created_by_id = None
        self._updated_by_id = None
        self._domain = None
        self._subcategory = None
        self._ab_status = None
        self._folder_id = None
        self._widget_containers = None
        self._widgets = None
        self._language = None
        self._translated_from_id = None
        self._dynamic_page_hub_db_table_id = None
        self._blog_author_id = None
        self._html_title = None
        self._page_redirected = None
        self._page_expiry_enabled = None
        self._page_expiry_date = None
        self._page_expiry_redirect_id = None
        self._page_expiry_redirect_url = None
        self._use_featured_image = None
        self._tag_ids = None
        self._enable_google_amp_output_override = None
        self._post_body = None
        self._post_summary = None
        self._rss_body = None
        self._rss_summary = None
        self._password = None
        self._attached_stylesheets = None
        self._include_default_custom_css = None
        self._enable_domain_stylesheets = None
        self._enable_layout_stylesheets = None
        self._meta_description = None
        self._publish_immediately = None
        self._head_html = None
        self._footer_html = None
        self._content_type_category = None
        self._current_state = None
        self._link_rel_canonical_url = None
        self._featured_image = None
        self._featured_image_alt_text = None
        self._public_access_rules_enabled = None
        self._public_access_rules = None
        self._layout_sections = None
        self._theme_settings_values = None
        self._url = None
        self._publish_date = None
        self._deleted_at = None
        self._created_at = None
        self._published = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        self.slug = slug
        self.content_group_id = content_group_id
        self.campaign = campaign
        self.category_id = category_id
        self.state = state
        self.template_path = template_path
        self.name = name
        self.mab_experiment_id = mab_experiment_id
        self.archived = archived
        self.author_name = author_name
        self.ab_test_id = ab_test_id
        self.created_by_id = created_by_id
        self.updated_by_id = updated_by_id
        self.domain = domain
        self.subcategory = subcategory
        self.ab_status = ab_status
        self.folder_id = folder_id
        self.widget_containers = widget_containers
        self.widgets = widgets
        self.language = language
        self.translated_from_id = translated_from_id
        self.dynamic_page_hub_db_table_id = dynamic_page_hub_db_table_id
        self.blog_author_id = blog_author_id
        self.html_title = html_title
        self.page_redirected = page_redirected
        self.page_expiry_enabled = page_expiry_enabled
        self.page_expiry_date = page_expiry_date
        self.page_expiry_redirect_id = page_expiry_redirect_id
        self.page_expiry_redirect_url = page_expiry_redirect_url
        self.use_featured_image = use_featured_image
        self.tag_ids = tag_ids
        self.enable_google_amp_output_override = enable_google_amp_output_override
        self.post_body = post_body
        self.post_summary = post_summary
        self.rss_body = rss_body
        self.rss_summary = rss_summary
        self.password = password
        self.attached_stylesheets = attached_stylesheets
        self.include_default_custom_css = include_default_custom_css
        self.enable_domain_stylesheets = enable_domain_stylesheets
        self.enable_layout_stylesheets = enable_layout_stylesheets
        self.meta_description = meta_description
        self.publish_immediately = publish_immediately
        self.head_html = head_html
        self.footer_html = footer_html
        self.content_type_category = content_type_category
        self.current_state = current_state
        self.link_rel_canonical_url = link_rel_canonical_url
        self.featured_image = featured_image
        self.featured_image_alt_text = featured_image_alt_text
        self.public_access_rules_enabled = public_access_rules_enabled
        self.public_access_rules = public_access_rules
        self.layout_sections = layout_sections
        self.theme_settings_values = theme_settings_values
        self.url = url
        self.publish_date = publish_date
        self.deleted_at = deleted_at
        self.created_at = created_at
        self.published = published
        self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this BlogPost.  # noqa: E501

        The unique ID of the Blog Post.  # noqa: E501

        :return: The id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BlogPost.

        The unique ID of the Blog Post.  # noqa: E501

        :param id: The id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def slug(self):
        """Gets the slug of this BlogPost.  # noqa: E501

        The path of the this blog post. This field is appended to the domain to construct the url of this post.  # noqa: E501

        :return: The slug of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this BlogPost.

        The path of the this blog post. This field is appended to the domain to construct the url of this post.  # noqa: E501

        :param slug: The slug of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and slug is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `slug`, must not be `None`"
            )  # noqa: E501

        self._slug = slug

    @property
    def content_group_id(self):
        """Gets the content_group_id of this BlogPost.  # noqa: E501

        The ID of the parent Blog this Blog Post is associated with.  # noqa: E501

        :return: The content_group_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._content_group_id

    @content_group_id.setter
    def content_group_id(self, content_group_id):
        """Sets the content_group_id of this BlogPost.

        The ID of the parent Blog this Blog Post is associated with.  # noqa: E501

        :param content_group_id: The content_group_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and content_group_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `content_group_id`, must not be `None`"
            )  # noqa: E501

        self._content_group_id = content_group_id

    @property
    def campaign(self):
        """Gets the campaign of this BlogPost.  # noqa: E501

        The GUID of the marketing campaign this Blog Post is a part of.  # noqa: E501

        :return: The campaign of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._campaign

    @campaign.setter
    def campaign(self, campaign):
        """Sets the campaign of this BlogPost.

        The GUID of the marketing campaign this Blog Post is a part of.  # noqa: E501

        :param campaign: The campaign of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and campaign is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `campaign`, must not be `None`"
            )  # noqa: E501

        self._campaign = campaign

    @property
    def category_id(self):
        """Gets the category_id of this BlogPost.  # noqa: E501

        ID of the type of object this is. Should always .  # noqa: E501

        :return: The category_id of this BlogPost.  # noqa: E501
        :rtype: int
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this BlogPost.

        ID of the type of object this is. Should always .  # noqa: E501

        :param category_id: The category_id of this BlogPost.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation and category_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `category_id`, must not be `None`"
            )  # noqa: E501

        self._category_id = category_id

    @property
    def state(self):
        """Gets the state of this BlogPost.  # noqa: E501

        An ENUM descibing the current state of this Blog Post.  # noqa: E501

        :return: The state of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this BlogPost.

        An ENUM descibing the current state of this Blog Post.  # noqa: E501

        :param state: The state of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and state is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `state`, must not be `None`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and state is not None
            and len(state) > 25
        ):
            raise ValueError(
                "Invalid value for `state`, length must be less than or equal to `25`"
            )  # noqa: E501

        self._state = state

    @property
    def template_path(self):
        """Gets the template_path of this BlogPost.  # noqa: E501


        :return: The template_path of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._template_path

    @template_path.setter
    def template_path(self, template_path):
        """Sets the template_path of this BlogPost.


        :param template_path: The template_path of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and template_path is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `template_path`, must not be `None`"
            )  # noqa: E501

        self._template_path = template_path

    @property
    def name(self):
        """Gets the name of this BlogPost.  # noqa: E501

        The internal name of the blog post.  # noqa: E501

        :return: The name of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BlogPost.

        The internal name of the blog post.  # noqa: E501

        :param name: The name of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `name`, must not be `None`"
            )  # noqa: E501

        self._name = name

    @property
    def mab_experiment_id(self):
        """Gets the mab_experiment_id of this BlogPost.  # noqa: E501


        :return: The mab_experiment_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._mab_experiment_id

    @mab_experiment_id.setter
    def mab_experiment_id(self, mab_experiment_id):
        """Sets the mab_experiment_id of this BlogPost.


        :param mab_experiment_id: The mab_experiment_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and mab_experiment_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `mab_experiment_id`, must not be `None`"
            )  # noqa: E501

        self._mab_experiment_id = mab_experiment_id

    @property
    def archived(self):
        """Gets the archived of this BlogPost.  # noqa: E501

        If True, the post will not show up in your dashboard, although the post could still be live.  # noqa: E501

        :return: The archived of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._archived

    @archived.setter
    def archived(self, archived):
        """Sets the archived of this BlogPost.

        If True, the post will not show up in your dashboard, although the post could still be live.  # noqa: E501

        :param archived: The archived of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation and archived is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `archived`, must not be `None`"
            )  # noqa: E501

        self._archived = archived

    @property
    def author_name(self):
        """Gets the author_name of this BlogPost.  # noqa: E501

        The name of the user that updated this blog post.  # noqa: E501

        :return: The author_name of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._author_name

    @author_name.setter
    def author_name(self, author_name):
        """Sets the author_name of this BlogPost.

        The name of the user that updated this blog post.  # noqa: E501

        :param author_name: The author_name of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and author_name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `author_name`, must not be `None`"
            )  # noqa: E501

        self._author_name = author_name

    @property
    def ab_test_id(self):
        """Gets the ab_test_id of this BlogPost.  # noqa: E501


        :return: The ab_test_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._ab_test_id

    @ab_test_id.setter
    def ab_test_id(self, ab_test_id):
        """Sets the ab_test_id of this BlogPost.


        :param ab_test_id: The ab_test_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and ab_test_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `ab_test_id`, must not be `None`"
            )  # noqa: E501

        self._ab_test_id = ab_test_id

    @property
    def created_by_id(self):
        """Gets the created_by_id of this BlogPost.  # noqa: E501

        The ID of the user that created this blog post.  # noqa: E501

        :return: The created_by_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._created_by_id

    @created_by_id.setter
    def created_by_id(self, created_by_id):
        """Sets the created_by_id of this BlogPost.

        The ID of the user that created this blog post.  # noqa: E501

        :param created_by_id: The created_by_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and created_by_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_by_id`, must not be `None`"
            )  # noqa: E501

        self._created_by_id = created_by_id

    @property
    def updated_by_id(self):
        """Gets the updated_by_id of this BlogPost.  # noqa: E501

        The ID of the user that updated this blog post.  # noqa: E501

        :return: The updated_by_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._updated_by_id

    @updated_by_id.setter
    def updated_by_id(self, updated_by_id):
        """Sets the updated_by_id of this BlogPost.

        The ID of the user that updated this blog post.  # noqa: E501

        :param updated_by_id: The updated_by_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and updated_by_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `updated_by_id`, must not be `None`"
            )  # noqa: E501

        self._updated_by_id = updated_by_id

    @property
    def domain(self):
        """Gets the domain of this BlogPost.  # noqa: E501

        The domain this Blog Post will resolve to. If null, the Blog Post will default to the domain of the ParentBlog.  # noqa: E501

        :return: The domain of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this BlogPost.

        The domain this Blog Post will resolve to. If null, the Blog Post will default to the domain of the ParentBlog.  # noqa: E501

        :param domain: The domain of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and domain is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `domain`, must not be `None`"
            )  # noqa: E501

        self._domain = domain

    @property
    def subcategory(self):
        """Gets the subcategory of this BlogPost.  # noqa: E501


        :return: The subcategory of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._subcategory

    @subcategory.setter
    def subcategory(self, subcategory):
        """Sets the subcategory of this BlogPost.


        :param subcategory: The subcategory of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and subcategory is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `subcategory`, must not be `None`"
            )  # noqa: E501

        self._subcategory = subcategory

    @property
    def ab_status(self):
        """Gets the ab_status of this BlogPost.  # noqa: E501


        :return: The ab_status of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._ab_status

    @ab_status.setter
    def ab_status(self, ab_status):
        """Sets the ab_status of this BlogPost.


        :param ab_status: The ab_status of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and ab_status is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `ab_status`, must not be `None`"
            )  # noqa: E501
        allowed_values = [
            "master",
            "variant",
            "loser_variant",
            "mab_master",
            "mab_variant",
            "automated_master",
            "automated_variant",
            "automated_loser_variant",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and ab_status not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `ab_status` ({0}), must be one of {1}".format(  # noqa: E501
                    ab_status, allowed_values
                )
            )

        self._ab_status = ab_status

    @property
    def folder_id(self):
        """Gets the folder_id of this BlogPost.  # noqa: E501


        :return: The folder_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._folder_id

    @folder_id.setter
    def folder_id(self, folder_id):
        """Sets the folder_id of this BlogPost.


        :param folder_id: The folder_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and folder_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `folder_id`, must not be `None`"
            )  # noqa: E501

        self._folder_id = folder_id

    @property
    def widget_containers(self):
        """Gets the widget_containers of this BlogPost.  # noqa: E501

        A data structure containing the data for all the modules inside the containers for this post. This will only be populated if the page has widget containers.  # noqa: E501

        :return: The widget_containers of this BlogPost.  # noqa: E501
        :rtype: object
        """
        return self._widget_containers

    @widget_containers.setter
    def widget_containers(self, widget_containers):
        """Sets the widget_containers of this BlogPost.

        A data structure containing the data for all the modules inside the containers for this post. This will only be populated if the page has widget containers.  # noqa: E501

        :param widget_containers: The widget_containers of this BlogPost.  # noqa: E501
        :type: object
        """
        if (
            self.local_vars_configuration.client_side_validation
            and widget_containers is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `widget_containers`, must not be `None`"
            )  # noqa: E501

        self._widget_containers = widget_containers

    @property
    def widgets(self):
        """Gets the widgets of this BlogPost.  # noqa: E501

        A data structure containing the data for all the modules for this page.  # noqa: E501

        :return: The widgets of this BlogPost.  # noqa: E501
        :rtype: object
        """
        return self._widgets

    @widgets.setter
    def widgets(self, widgets):
        """Sets the widgets of this BlogPost.

        A data structure containing the data for all the modules for this page.  # noqa: E501

        :param widgets: The widgets of this BlogPost.  # noqa: E501
        :type: object
        """
        if (
            self.local_vars_configuration.client_side_validation and widgets is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `widgets`, must not be `None`"
            )  # noqa: E501

        self._widgets = widgets

    @property
    def language(self):
        """Gets the language of this BlogPost.  # noqa: E501

        The explicitly defined language of the Blog Post. If null, the Blog Post will default to the language of the ParentBlog.  # noqa: E501

        :return: The language of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this BlogPost.

        The explicitly defined language of the Blog Post. If null, the Blog Post will default to the language of the ParentBlog.  # noqa: E501

        :param language: The language of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and language is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `language`, must not be `None`"
            )  # noqa: E501
        allowed_values = [
            "af",
            "af-na",
            "af-za",
            "agq",
            "agq-cm",
            "ak",
            "ak-gh",
            "am",
            "am-et",
            "ar",
            "ar-001",
            "ar-ae",
            "ar-bh",
            "ar-dj",
            "ar-dz",
            "ar-eg",
            "ar-eh",
            "ar-er",
            "ar-il",
            "ar-iq",
            "ar-jo",
            "ar-km",
            "ar-kw",
            "ar-lb",
            "ar-ly",
            "ar-ma",
            "ar-mr",
            "ar-om",
            "ar-ps",
            "ar-qa",
            "ar-sa",
            "ar-sd",
            "ar-so",
            "ar-ss",
            "ar-sy",
            "ar-td",
            "ar-tn",
            "ar-ye",
            "as",
            "as-in",
            "asa",
            "asa-tz",
            "ast",
            "ast-es",
            "az",
            "az-az",
            "bas",
            "bas-cm",
            "be",
            "be-by",
            "bem",
            "bem-zm",
            "bez",
            "bez-tz",
            "bg",
            "bg-bg",
            "bm",
            "bm-ml",
            "bn",
            "bn-bd",
            "bn-in",
            "bo",
            "bo-cn",
            "bo-in",
            "br",
            "br-fr",
            "brx",
            "brx-in",
            "bs",
            "bs-ba",
            "ca",
            "ca-ad",
            "ca-es",
            "ca-fr",
            "ca-it",
            "ccp",
            "ccp-bd",
            "ccp-in",
            "ce",
            "ce-ru",
            "cgg",
            "cgg-ug",
            "chr",
            "chr-us",
            "ckb",
            "ckb-iq",
            "ckb-ir",
            "cs",
            "cs-cz",
            "cu",
            "cu-ru",
            "cy",
            "cy-gb",
            "da",
            "da-dk",
            "da-gl",
            "dav",
            "dav-ke",
            "de",
            "de-at",
            "de-be",
            "de-ch",
            "de-de",
            "de-gr",
            "de-it",
            "de-li",
            "de-lu",
            "dje",
            "dje-ne",
            "dsb",
            "dsb-de",
            "dua",
            "dua-cm",
            "dyo",
            "dyo-sn",
            "dz",
            "dz-bt",
            "ebu",
            "ebu-ke",
            "ee",
            "ee-gh",
            "ee-tg",
            "el",
            "el-cy",
            "el-gr",
            "en",
            "en-001",
            "en-150",
            "en-ag",
            "en-ai",
            "en-as",
            "en-at",
            "en-au",
            "en-bb",
            "en-be",
            "en-bi",
            "en-bm",
            "en-bs",
            "en-bw",
            "en-bz",
            "en-ca",
            "en-cc",
            "en-ch",
            "en-ck",
            "en-cm",
            "en-cx",
            "en-cy",
            "en-de",
            "en-dg",
            "en-dk",
            "en-dm",
            "en-er",
            "en-fi",
            "en-fj",
            "en-fk",
            "en-fm",
            "en-gb",
            "en-gd",
            "en-gg",
            "en-gh",
            "en-gi",
            "en-gm",
            "en-gu",
            "en-gy",
            "en-hk",
            "en-ie",
            "en-il",
            "en-im",
            "en-in",
            "en-io",
            "en-je",
            "en-jm",
            "en-ke",
            "en-ki",
            "en-kn",
            "en-ky",
            "en-lc",
            "en-lr",
            "en-ls",
            "en-mg",
            "en-mh",
            "en-mo",
            "en-mp",
            "en-ms",
            "en-mt",
            "en-mu",
            "en-mw",
            "en-my",
            "en-na",
            "en-nf",
            "en-ng",
            "en-nl",
            "en-nr",
            "en-nu",
            "en-nz",
            "en-pg",
            "en-ph",
            "en-pk",
            "en-pn",
            "en-pr",
            "en-pw",
            "en-rw",
            "en-sb",
            "en-sc",
            "en-sd",
            "en-se",
            "en-sg",
            "en-sh",
            "en-si",
            "en-sl",
            "en-ss",
            "en-sx",
            "en-sz",
            "en-tc",
            "en-tk",
            "en-to",
            "en-tt",
            "en-tv",
            "en-tz",
            "en-ug",
            "en-um",
            "en-us",
            "en-vc",
            "en-vg",
            "en-vi",
            "en-vu",
            "en-ws",
            "en-za",
            "en-zm",
            "en-zw",
            "eo",
            "eo-001",
            "es",
            "es-419",
            "es-ar",
            "es-bo",
            "es-br",
            "es-bz",
            "es-cl",
            "es-co",
            "es-cr",
            "es-cu",
            "es-do",
            "es-ea",
            "es-ec",
            "es-es",
            "es-gq",
            "es-gt",
            "es-hn",
            "es-ic",
            "es-mx",
            "es-ni",
            "es-pa",
            "es-pe",
            "es-ph",
            "es-pr",
            "es-py",
            "es-sv",
            "es-us",
            "es-uy",
            "es-ve",
            "et",
            "et-ee",
            "eu",
            "eu-es",
            "ewo",
            "ewo-cm",
            "fa",
            "fa-af",
            "fa-ir",
            "ff",
            "ff-cm",
            "ff-gn",
            "ff-mr",
            "ff-sn",
            "fi",
            "fi-fi",
            "fil",
            "fil-ph",
            "fo",
            "fo-dk",
            "fo-fo",
            "fr",
            "fr-be",
            "fr-bf",
            "fr-bi",
            "fr-bj",
            "fr-bl",
            "fr-ca",
            "fr-cd",
            "fr-cf",
            "fr-cg",
            "fr-ch",
            "fr-ci",
            "fr-cm",
            "fr-dj",
            "fr-dz",
            "fr-fr",
            "fr-ga",
            "fr-gf",
            "fr-gn",
            "fr-gp",
            "fr-gq",
            "fr-ht",
            "fr-km",
            "fr-lu",
            "fr-ma",
            "fr-mc",
            "fr-mf",
            "fr-mg",
            "fr-ml",
            "fr-mq",
            "fr-mr",
            "fr-mu",
            "fr-nc",
            "fr-ne",
            "fr-pf",
            "fr-pm",
            "fr-re",
            "fr-rw",
            "fr-sc",
            "fr-sn",
            "fr-sy",
            "fr-td",
            "fr-tg",
            "fr-tn",
            "fr-vu",
            "fr-wf",
            "fr-yt",
            "fur",
            "fur-it",
            "fy",
            "fy-nl",
            "ga",
            "ga-ie",
            "gd",
            "gd-gb",
            "gl",
            "gl-es",
            "gsw",
            "gsw-ch",
            "gsw-fr",
            "gsw-li",
            "gu",
            "gu-in",
            "guz",
            "guz-ke",
            "gv",
            "gv-im",
            "ha",
            "ha-gh",
            "ha-ne",
            "ha-ng",
            "haw",
            "haw-us",
            "he",
            "hi",
            "hi-in",
            "hr",
            "hr-ba",
            "hr-hr",
            "hsb",
            "hsb-de",
            "hu",
            "hu-hu",
            "hy",
            "hy-am",
            "id",
            "ig",
            "ig-ng",
            "ii",
            "ii-cn",
            "id-id",
            "is",
            "is-is",
            "it",
            "it-ch",
            "it-it",
            "it-sm",
            "it-va",
            "he-il",
            "ja",
            "ja-jp",
            "jgo",
            "jgo-cm",
            "yi",
            "yi-001",
            "jmc",
            "jmc-tz",
            "ka",
            "ka-ge",
            "kab",
            "kab-dz",
            "kam",
            "kam-ke",
            "kde",
            "kde-tz",
            "kea",
            "kea-cv",
            "khq",
            "khq-ml",
            "ki",
            "ki-ke",
            "kk",
            "kk-kz",
            "kkj",
            "kkj-cm",
            "kl",
            "kl-gl",
            "kln",
            "kln-ke",
            "km",
            "km-kh",
            "kn",
            "kn-in",
            "ko",
            "ko-kp",
            "ko-kr",
            "kok",
            "kok-in",
            "ks",
            "ks-in",
            "ksb",
            "ksb-tz",
            "ksf",
            "ksf-cm",
            "ksh",
            "ksh-de",
            "kw",
            "kw-gb",
            "ky",
            "ky-kg",
            "lag",
            "lag-tz",
            "lb",
            "lb-lu",
            "lg",
            "lg-ug",
            "lkt",
            "lkt-us",
            "ln",
            "ln-ao",
            "ln-cd",
            "ln-cf",
            "ln-cg",
            "lo",
            "lo-la",
            "lrc",
            "lrc-iq",
            "lrc-ir",
            "lt",
            "lt-lt",
            "lu",
            "lu-cd",
            "luo",
            "luo-ke",
            "luy",
            "luy-ke",
            "lv",
            "lv-lv",
            "mas",
            "mas-ke",
            "mas-tz",
            "mer",
            "mer-ke",
            "mfe",
            "mfe-mu",
            "mg",
            "mg-mg",
            "mgh",
            "mgh-mz",
            "mgo",
            "mgo-cm",
            "mk",
            "mk-mk",
            "ml",
            "ml-in",
            "mn",
            "mn-mn",
            "mr",
            "mr-in",
            "ms",
            "ms-bn",
            "ms-my",
            "ms-sg",
            "mt",
            "mt-mt",
            "mua",
            "mua-cm",
            "my",
            "my-mm",
            "mzn",
            "mzn-ir",
            "naq",
            "naq-na",
            "nb",
            "nb-no",
            "nb-sj",
            "nd",
            "nd-zw",
            "nds",
            "nds-de",
            "nds-nl",
            "ne",
            "ne-in",
            "ne-np",
            "nl",
            "nl-aw",
            "nl-be",
            "nl-bq",
            "nl-cw",
            "nl-nl",
            "nl-sr",
            "nl-sx",
            "nmg",
            "nmg-cm",
            "nn",
            "nn-no",
            "nnh",
            "nnh-cm",
            "no",
            "no-no",
            "nus",
            "nus-ss",
            "nyn",
            "nyn-ug",
            "om",
            "om-et",
            "om-ke",
            "or",
            "or-in",
            "os",
            "os-ge",
            "os-ru",
            "pa",
            "pa-in",
            "pa-pk",
            "pl",
            "pl-pl",
            "prg",
            "prg-001",
            "ps",
            "ps-af",
            "pt",
            "pt-ao",
            "pt-br",
            "pt-ch",
            "pt-cv",
            "pt-gq",
            "pt-gw",
            "pt-lu",
            "pt-mo",
            "pt-mz",
            "pt-pt",
            "pt-st",
            "pt-tl",
            "qu",
            "qu-bo",
            "qu-ec",
            "qu-pe",
            "rm",
            "rm-ch",
            "rn",
            "rn-bi",
            "ro",
            "ro-md",
            "ro-ro",
            "rof",
            "rof-tz",
            "ru",
            "ru-by",
            "ru-kg",
            "ru-kz",
            "ru-md",
            "ru-ru",
            "ru-ua",
            "rw",
            "rw-rw",
            "rwk",
            "rwk-tz",
            "sa",
            "sah",
            "sah-ru",
            "saq",
            "saq-ke",
            "sbp",
            "sbp-tz",
            "sd",
            "sd-pk",
            "se",
            "se-fi",
            "se-no",
            "se-se",
            "seh",
            "seh-mz",
            "ses",
            "ses-ml",
            "sg",
            "sg-cf",
            "shi",
            "shi-ma",
            "si",
            "si-lk",
            "sk",
            "sk-sk",
            "sl",
            "sl-si",
            "smn",
            "smn-fi",
            "sn",
            "sn-zw",
            "so",
            "so-dj",
            "so-et",
            "so-ke",
            "so-so",
            "sq",
            "sq-al",
            "sq-mk",
            "sq-xk",
            "sr",
            "sr-ba",
            "sr-cs",
            "sr-me",
            "sr-rs",
            "sr-xk",
            "sv",
            "sv-ax",
            "sv-fi",
            "sv-se",
            "sw",
            "sw-cd",
            "sw-ke",
            "sw-tz",
            "sw-ug",
            "sy",
            "ta",
            "ta-in",
            "ta-lk",
            "ta-my",
            "ta-sg",
            "te",
            "te-in",
            "teo",
            "teo-ke",
            "teo-ug",
            "tg",
            "tg-tj",
            "th",
            "th-th",
            "ti",
            "ti-er",
            "ti-et",
            "tk",
            "tk-tm",
            "to",
            "to-to",
            "tr",
            "tr-cy",
            "tr-tr",
            "tt",
            "tt-ru",
            "twq",
            "twq-ne",
            "tzm",
            "tzm-ma",
            "ug",
            "ug-cn",
            "uk",
            "uk-ua",
            "ur",
            "ur-in",
            "ur-pk",
            "uz",
            "uz-af",
            "uz-uz",
            "vai",
            "vai-lr",
            "vi",
            "vi-vn",
            "vo",
            "vo-001",
            "vun",
            "vun-tz",
            "wae",
            "wae-ch",
            "wo",
            "wo-sn",
            "xog",
            "xog-ug",
            "yav",
            "yav-cm",
            "yo",
            "yo-bj",
            "yo-ng",
            "yue",
            "yue-cn",
            "yue-hk",
            "zgh",
            "zgh-ma",
            "zh",
            "zh-cn",
            "zh-hk",
            "zh-mo",
            "zh-sg",
            "zh-tw",
            "zh-hans",
            "zh-hant",
            "zu",
            "zu-za",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and language not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `language` ({0}), must be one of {1}".format(  # noqa: E501
                    language, allowed_values
                )
            )

        self._language = language

    @property
    def translated_from_id(self):
        """Gets the translated_from_id of this BlogPost.  # noqa: E501

        ID of the primary blog post this object was translated from.  # noqa: E501

        :return: The translated_from_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._translated_from_id

    @translated_from_id.setter
    def translated_from_id(self, translated_from_id):
        """Sets the translated_from_id of this BlogPost.

        ID of the primary blog post this object was translated from.  # noqa: E501

        :param translated_from_id: The translated_from_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and translated_from_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `translated_from_id`, must not be `None`"
            )  # noqa: E501

        self._translated_from_id = translated_from_id

    @property
    def dynamic_page_hub_db_table_id(self):
        """Gets the dynamic_page_hub_db_table_id of this BlogPost.  # noqa: E501


        :return: The dynamic_page_hub_db_table_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._dynamic_page_hub_db_table_id

    @dynamic_page_hub_db_table_id.setter
    def dynamic_page_hub_db_table_id(self, dynamic_page_hub_db_table_id):
        """Sets the dynamic_page_hub_db_table_id of this BlogPost.


        :param dynamic_page_hub_db_table_id: The dynamic_page_hub_db_table_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and dynamic_page_hub_db_table_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `dynamic_page_hub_db_table_id`, must not be `None`"
            )  # noqa: E501

        self._dynamic_page_hub_db_table_id = dynamic_page_hub_db_table_id

    @property
    def blog_author_id(self):
        """Gets the blog_author_id of this BlogPost.  # noqa: E501

        The ID of the Blog Author associated with this Blog Post.  # noqa: E501

        :return: The blog_author_id of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._blog_author_id

    @blog_author_id.setter
    def blog_author_id(self, blog_author_id):
        """Sets the blog_author_id of this BlogPost.

        The ID of the Blog Author associated with this Blog Post.  # noqa: E501

        :param blog_author_id: The blog_author_id of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and blog_author_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `blog_author_id`, must not be `None`"
            )  # noqa: E501

        self._blog_author_id = blog_author_id

    @property
    def html_title(self):
        """Gets the html_title of this BlogPost.  # noqa: E501

        The html title of this Blog Post.  # noqa: E501

        :return: The html_title of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._html_title

    @html_title.setter
    def html_title(self, html_title):
        """Sets the html_title of this BlogPost.

        The html title of this Blog Post.  # noqa: E501

        :param html_title: The html_title of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and html_title is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `html_title`, must not be `None`"
            )  # noqa: E501

        self._html_title = html_title

    @property
    def page_redirected(self):
        """Gets the page_redirected of this BlogPost.  # noqa: E501


        :return: The page_redirected of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._page_redirected

    @page_redirected.setter
    def page_redirected(self, page_redirected):
        """Sets the page_redirected of this BlogPost.


        :param page_redirected: The page_redirected of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and page_redirected is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `page_redirected`, must not be `None`"
            )  # noqa: E501

        self._page_redirected = page_redirected

    @property
    def page_expiry_enabled(self):
        """Gets the page_expiry_enabled of this BlogPost.  # noqa: E501


        :return: The page_expiry_enabled of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._page_expiry_enabled

    @page_expiry_enabled.setter
    def page_expiry_enabled(self, page_expiry_enabled):
        """Sets the page_expiry_enabled of this BlogPost.


        :param page_expiry_enabled: The page_expiry_enabled of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and page_expiry_enabled is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `page_expiry_enabled`, must not be `None`"
            )  # noqa: E501

        self._page_expiry_enabled = page_expiry_enabled

    @property
    def page_expiry_date(self):
        """Gets the page_expiry_date of this BlogPost.  # noqa: E501


        :return: The page_expiry_date of this BlogPost.  # noqa: E501
        :rtype: int
        """
        return self._page_expiry_date

    @page_expiry_date.setter
    def page_expiry_date(self, page_expiry_date):
        """Sets the page_expiry_date of this BlogPost.


        :param page_expiry_date: The page_expiry_date of this BlogPost.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and page_expiry_date is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `page_expiry_date`, must not be `None`"
            )  # noqa: E501

        self._page_expiry_date = page_expiry_date

    @property
    def page_expiry_redirect_id(self):
        """Gets the page_expiry_redirect_id of this BlogPost.  # noqa: E501


        :return: The page_expiry_redirect_id of this BlogPost.  # noqa: E501
        :rtype: int
        """
        return self._page_expiry_redirect_id

    @page_expiry_redirect_id.setter
    def page_expiry_redirect_id(self, page_expiry_redirect_id):
        """Sets the page_expiry_redirect_id of this BlogPost.


        :param page_expiry_redirect_id: The page_expiry_redirect_id of this BlogPost.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and page_expiry_redirect_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `page_expiry_redirect_id`, must not be `None`"
            )  # noqa: E501

        self._page_expiry_redirect_id = page_expiry_redirect_id

    @property
    def page_expiry_redirect_url(self):
        """Gets the page_expiry_redirect_url of this BlogPost.  # noqa: E501


        :return: The page_expiry_redirect_url of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._page_expiry_redirect_url

    @page_expiry_redirect_url.setter
    def page_expiry_redirect_url(self, page_expiry_redirect_url):
        """Sets the page_expiry_redirect_url of this BlogPost.


        :param page_expiry_redirect_url: The page_expiry_redirect_url of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and page_expiry_redirect_url is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `page_expiry_redirect_url`, must not be `None`"
            )  # noqa: E501

        self._page_expiry_redirect_url = page_expiry_redirect_url

    @property
    def use_featured_image(self):
        """Gets the use_featured_image of this BlogPost.  # noqa: E501

        Boolean to determine if this post should use a featuredImage.  # noqa: E501

        :return: The use_featured_image of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._use_featured_image

    @use_featured_image.setter
    def use_featured_image(self, use_featured_image):
        """Sets the use_featured_image of this BlogPost.

        Boolean to determine if this post should use a featuredImage.  # noqa: E501

        :param use_featured_image: The use_featured_image of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and use_featured_image is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `use_featured_image`, must not be `None`"
            )  # noqa: E501

        self._use_featured_image = use_featured_image

    @property
    def tag_ids(self):
        """Gets the tag_ids of this BlogPost.  # noqa: E501

        List of IDs for the tags associated with this Blog Post.  # noqa: E501

        :return: The tag_ids of this BlogPost.  # noqa: E501
        :rtype: list[int]
        """
        return self._tag_ids

    @tag_ids.setter
    def tag_ids(self, tag_ids):
        """Sets the tag_ids of this BlogPost.

        List of IDs for the tags associated with this Blog Post.  # noqa: E501

        :param tag_ids: The tag_ids of this BlogPost.  # noqa: E501
        :type: list[int]
        """
        if (
            self.local_vars_configuration.client_side_validation and tag_ids is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `tag_ids`, must not be `None`"
            )  # noqa: E501

        self._tag_ids = tag_ids

    @property
    def enable_google_amp_output_override(self):
        """Gets the enable_google_amp_output_override of this BlogPost.  # noqa: E501

        Boolean to allow overriding the AMP settings for the blog.  # noqa: E501

        :return: The enable_google_amp_output_override of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._enable_google_amp_output_override

    @enable_google_amp_output_override.setter
    def enable_google_amp_output_override(self, enable_google_amp_output_override):
        """Sets the enable_google_amp_output_override of this BlogPost.

        Boolean to allow overriding the AMP settings for the blog.  # noqa: E501

        :param enable_google_amp_output_override: The enable_google_amp_output_override of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and enable_google_amp_output_override is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `enable_google_amp_output_override`, must not be `None`"
            )  # noqa: E501

        self._enable_google_amp_output_override = enable_google_amp_output_override

    @property
    def post_body(self):
        """Gets the post_body of this BlogPost.  # noqa: E501

        The HTML of the main post body.  # noqa: E501

        :return: The post_body of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._post_body

    @post_body.setter
    def post_body(self, post_body):
        """Sets the post_body of this BlogPost.

        The HTML of the main post body.  # noqa: E501

        :param post_body: The post_body of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and post_body is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `post_body`, must not be `None`"
            )  # noqa: E501

        self._post_body = post_body

    @property
    def post_summary(self):
        """Gets the post_summary of this BlogPost.  # noqa: E501

        The summary of the blog post that will appear on the main listing page.  # noqa: E501

        :return: The post_summary of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._post_summary

    @post_summary.setter
    def post_summary(self, post_summary):
        """Sets the post_summary of this BlogPost.

        The summary of the blog post that will appear on the main listing page.  # noqa: E501

        :param post_summary: The post_summary of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and post_summary is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `post_summary`, must not be `None`"
            )  # noqa: E501

        self._post_summary = post_summary

    @property
    def rss_body(self):
        """Gets the rss_body of this BlogPost.  # noqa: E501

        The contents of the RSS body for this Blog Post.  # noqa: E501

        :return: The rss_body of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._rss_body

    @rss_body.setter
    def rss_body(self, rss_body):
        """Sets the rss_body of this BlogPost.

        The contents of the RSS body for this Blog Post.  # noqa: E501

        :param rss_body: The rss_body of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and rss_body is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `rss_body`, must not be `None`"
            )  # noqa: E501

        self._rss_body = rss_body

    @property
    def rss_summary(self):
        """Gets the rss_summary of this BlogPost.  # noqa: E501

        The contents of the RSS summary for this Blog Post.  # noqa: E501

        :return: The rss_summary of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._rss_summary

    @rss_summary.setter
    def rss_summary(self, rss_summary):
        """Sets the rss_summary of this BlogPost.

        The contents of the RSS summary for this Blog Post.  # noqa: E501

        :param rss_summary: The rss_summary of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and rss_summary is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `rss_summary`, must not be `None`"
            )  # noqa: E501

        self._rss_summary = rss_summary

    @property
    def password(self):
        """Gets the password of this BlogPost.  # noqa: E501

        Set this to create a password protected page. Entering the password will be required to view the page.  # noqa: E501

        :return: The password of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this BlogPost.

        Set this to create a password protected page. Entering the password will be required to view the page.  # noqa: E501

        :param password: The password of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and password is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `password`, must not be `None`"
            )  # noqa: E501

        self._password = password

    @property
    def attached_stylesheets(self):
        """Gets the attached_stylesheets of this BlogPost.  # noqa: E501

        List of stylesheets to attach to this blog post. These stylesheets are attached to just this page. Order of precedence is bottom to top, just like in the HTML.  # noqa: E501

        :return: The attached_stylesheets of this BlogPost.  # noqa: E501
        :rtype: list[object]
        """
        return self._attached_stylesheets

    @attached_stylesheets.setter
    def attached_stylesheets(self, attached_stylesheets):
        """Sets the attached_stylesheets of this BlogPost.

        List of stylesheets to attach to this blog post. These stylesheets are attached to just this page. Order of precedence is bottom to top, just like in the HTML.  # noqa: E501

        :param attached_stylesheets: The attached_stylesheets of this BlogPost.  # noqa: E501
        :type: list[object]
        """
        if (
            self.local_vars_configuration.client_side_validation
            and attached_stylesheets is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `attached_stylesheets`, must not be `None`"
            )  # noqa: E501

        self._attached_stylesheets = attached_stylesheets

    @property
    def include_default_custom_css(self):
        """Gets the include_default_custom_css of this BlogPost.  # noqa: E501

        Boolean to determine whether or not the Primary CSS Files should be applied.  # noqa: E501

        :return: The include_default_custom_css of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._include_default_custom_css

    @include_default_custom_css.setter
    def include_default_custom_css(self, include_default_custom_css):
        """Sets the include_default_custom_css of this BlogPost.

        Boolean to determine whether or not the Primary CSS Files should be applied.  # noqa: E501

        :param include_default_custom_css: The include_default_custom_css of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and include_default_custom_css is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `include_default_custom_css`, must not be `None`"
            )  # noqa: E501

        self._include_default_custom_css = include_default_custom_css

    @property
    def enable_domain_stylesheets(self):
        """Gets the enable_domain_stylesheets of this BlogPost.  # noqa: E501

        Boolean to determine whether or not the styles from the template should be applied.  # noqa: E501

        :return: The enable_domain_stylesheets of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._enable_domain_stylesheets

    @enable_domain_stylesheets.setter
    def enable_domain_stylesheets(self, enable_domain_stylesheets):
        """Sets the enable_domain_stylesheets of this BlogPost.

        Boolean to determine whether or not the styles from the template should be applied.  # noqa: E501

        :param enable_domain_stylesheets: The enable_domain_stylesheets of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and enable_domain_stylesheets is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `enable_domain_stylesheets`, must not be `None`"
            )  # noqa: E501

        self._enable_domain_stylesheets = enable_domain_stylesheets

    @property
    def enable_layout_stylesheets(self):
        """Gets the enable_layout_stylesheets of this BlogPost.  # noqa: E501

        Boolean to determine whether or not the styles from the template should be applied.  # noqa: E501

        :return: The enable_layout_stylesheets of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._enable_layout_stylesheets

    @enable_layout_stylesheets.setter
    def enable_layout_stylesheets(self, enable_layout_stylesheets):
        """Sets the enable_layout_stylesheets of this BlogPost.

        Boolean to determine whether or not the styles from the template should be applied.  # noqa: E501

        :param enable_layout_stylesheets: The enable_layout_stylesheets of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and enable_layout_stylesheets is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `enable_layout_stylesheets`, must not be `None`"
            )  # noqa: E501

        self._enable_layout_stylesheets = enable_layout_stylesheets

    @property
    def meta_description(self):
        """Gets the meta_description of this BlogPost.  # noqa: E501

        A description that goes in <meta> tag on the page.  # noqa: E501

        :return: The meta_description of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._meta_description

    @meta_description.setter
    def meta_description(self, meta_description):
        """Sets the meta_description of this BlogPost.

        A description that goes in <meta> tag on the page.  # noqa: E501

        :param meta_description: The meta_description of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and meta_description is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `meta_description`, must not be `None`"
            )  # noqa: E501

        self._meta_description = meta_description

    @property
    def publish_immediately(self):
        """Gets the publish_immediately of this BlogPost.  # noqa: E501

        Set this to true if you want to be published immediately when the schedule publish endpoint is called, and to ignore the publish_date setting.  # noqa: E501

        :return: The publish_immediately of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._publish_immediately

    @publish_immediately.setter
    def publish_immediately(self, publish_immediately):
        """Sets the publish_immediately of this BlogPost.

        Set this to true if you want to be published immediately when the schedule publish endpoint is called, and to ignore the publish_date setting.  # noqa: E501

        :param publish_immediately: The publish_immediately of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and publish_immediately is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `publish_immediately`, must not be `None`"
            )  # noqa: E501

        self._publish_immediately = publish_immediately

    @property
    def head_html(self):
        """Gets the head_html of this BlogPost.  # noqa: E501

        Custom HTML for embed codes, javascript, etc. that goes in the <head> tag of the page.  # noqa: E501

        :return: The head_html of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._head_html

    @head_html.setter
    def head_html(self, head_html):
        """Sets the head_html of this BlogPost.

        Custom HTML for embed codes, javascript, etc. that goes in the <head> tag of the page.  # noqa: E501

        :param head_html: The head_html of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and head_html is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `head_html`, must not be `None`"
            )  # noqa: E501

        self._head_html = head_html

    @property
    def footer_html(self):
        """Gets the footer_html of this BlogPost.  # noqa: E501

        Custom HTML for embed codes, javascript that should be placed before the </body> tag of the page.  # noqa: E501

        :return: The footer_html of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._footer_html

    @footer_html.setter
    def footer_html(self, footer_html):
        """Sets the footer_html of this BlogPost.

        Custom HTML for embed codes, javascript that should be placed before the </body> tag of the page.  # noqa: E501

        :param footer_html: The footer_html of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and footer_html is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `footer_html`, must not be `None`"
            )  # noqa: E501

        self._footer_html = footer_html

    @property
    def content_type_category(self):
        """Gets the content_type_category of this BlogPost.  # noqa: E501

        An ENUM descibing the type of this object. Should always be BLOG_POST.  # noqa: E501

        :return: The content_type_category of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._content_type_category

    @content_type_category.setter
    def content_type_category(self, content_type_category):
        """Sets the content_type_category of this BlogPost.

        An ENUM descibing the type of this object. Should always be BLOG_POST.  # noqa: E501

        :param content_type_category: The content_type_category of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and content_type_category is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `content_type_category`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["0", "1", "2", "3", "4", "5", "6"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and content_type_category not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `content_type_category` ({0}), must be one of {1}".format(  # noqa: E501
                    content_type_category, allowed_values
                )
            )

        self._content_type_category = content_type_category

    @property
    def current_state(self):
        """Gets the current_state of this BlogPost.  # noqa: E501

        A generated ENUM descibing the current state of this Blog Post. Should always match state.  # noqa: E501

        :return: The current_state of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._current_state

    @current_state.setter
    def current_state(self, current_state):
        """Sets the current_state of this BlogPost.

        A generated ENUM descibing the current state of this Blog Post. Should always match state.  # noqa: E501

        :param current_state: The current_state of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and current_state is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `current_state`, must not be `None`"
            )  # noqa: E501
        allowed_values = [
            "AUTOMATED",
            "AUTOMATED_DRAFT",
            "AUTOMATED_SENDING",
            "AUTOMATED_FOR_FORM",
            "AUTOMATED_FOR_FORM_BUFFER",
            "AUTOMATED_FOR_FORM_DRAFT",
            "AUTOMATED_FOR_FORM_LEGACY",
            "BLOG_EMAIL_DRAFT",
            "BLOG_EMAIL_PUBLISHED",
            "DRAFT",
            "DRAFT_AB",
            "DRAFT_AB_VARIANT",
            "ERROR",
            "LOSER_AB_VARIANT",
            "PAGE_STUB",
            "PRE_PROCESSING",
            "PROCESSING",
            "PUBLISHED",
            "PUBLISHED_AB",
            "PUBLISHED_AB_VARIANT",
            "PUBLISHED_OR_SCHEDULED",
            "RSS_TO_EMAIL_DRAFT",
            "RSS_TO_EMAIL_PUBLISHED",
            "SCHEDULED",
            "SCHEDULED_AB",
            "SCHEDULED_OR_PUBLISHED",
            "AUTOMATED_AB",
            "AUTOMATED_AB_VARIANT",
            "AUTOMATED_DRAFT_AB",
            "AUTOMATED_DRAFT_ABVARIANT",
            "AUTOMATED_LOSER_ABVARIANT",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and current_state not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `current_state` ({0}), must be one of {1}".format(  # noqa: E501
                    current_state, allowed_values
                )
            )

        self._current_state = current_state

    @property
    def link_rel_canonical_url(self):
        """Gets the link_rel_canonical_url of this BlogPost.  # noqa: E501

        Optional override to set the URL to be used in the rel=canonical link tag on the page.  # noqa: E501

        :return: The link_rel_canonical_url of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._link_rel_canonical_url

    @link_rel_canonical_url.setter
    def link_rel_canonical_url(self, link_rel_canonical_url):
        """Sets the link_rel_canonical_url of this BlogPost.

        Optional override to set the URL to be used in the rel=canonical link tag on the page.  # noqa: E501

        :param link_rel_canonical_url: The link_rel_canonical_url of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and link_rel_canonical_url is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `link_rel_canonical_url`, must not be `None`"
            )  # noqa: E501

        self._link_rel_canonical_url = link_rel_canonical_url

    @property
    def featured_image(self):
        """Gets the featured_image of this BlogPost.  # noqa: E501

        The featuredImage of this Blog Post.  # noqa: E501

        :return: The featured_image of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._featured_image

    @featured_image.setter
    def featured_image(self, featured_image):
        """Sets the featured_image of this BlogPost.

        The featuredImage of this Blog Post.  # noqa: E501

        :param featured_image: The featured_image of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and featured_image is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `featured_image`, must not be `None`"
            )  # noqa: E501

        self._featured_image = featured_image

    @property
    def featured_image_alt_text(self):
        """Gets the featured_image_alt_text of this BlogPost.  # noqa: E501

        Alt Text of the featuredImage.  # noqa: E501

        :return: The featured_image_alt_text of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._featured_image_alt_text

    @featured_image_alt_text.setter
    def featured_image_alt_text(self, featured_image_alt_text):
        """Sets the featured_image_alt_text of this BlogPost.

        Alt Text of the featuredImage.  # noqa: E501

        :param featured_image_alt_text: The featured_image_alt_text of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and featured_image_alt_text is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `featured_image_alt_text`, must not be `None`"
            )  # noqa: E501

        self._featured_image_alt_text = featured_image_alt_text

    @property
    def public_access_rules_enabled(self):
        """Gets the public_access_rules_enabled of this BlogPost.  # noqa: E501

        Boolean to determine whether or not to respect publicAccessRules.  # noqa: E501

        :return: The public_access_rules_enabled of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._public_access_rules_enabled

    @public_access_rules_enabled.setter
    def public_access_rules_enabled(self, public_access_rules_enabled):
        """Sets the public_access_rules_enabled of this BlogPost.

        Boolean to determine whether or not to respect publicAccessRules.  # noqa: E501

        :param public_access_rules_enabled: The public_access_rules_enabled of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation
            and public_access_rules_enabled is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `public_access_rules_enabled`, must not be `None`"
            )  # noqa: E501

        self._public_access_rules_enabled = public_access_rules_enabled

    @property
    def public_access_rules(self):
        """Gets the public_access_rules of this BlogPost.  # noqa: E501

        Rules for require member registration to access private content.  # noqa: E501

        :return: The public_access_rules of this BlogPost.  # noqa: E501
        :rtype: list[object]
        """
        return self._public_access_rules

    @public_access_rules.setter
    def public_access_rules(self, public_access_rules):
        """Sets the public_access_rules of this BlogPost.

        Rules for require member registration to access private content.  # noqa: E501

        :param public_access_rules: The public_access_rules of this BlogPost.  # noqa: E501
        :type: list[object]
        """
        if (
            self.local_vars_configuration.client_side_validation
            and public_access_rules is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `public_access_rules`, must not be `None`"
            )  # noqa: E501

        self._public_access_rules = public_access_rules

    @property
    def layout_sections(self):
        """Gets the layout_sections of this BlogPost.  # noqa: E501


        :return: The layout_sections of this BlogPost.  # noqa: E501
        :rtype: dict(str, LayoutSection)
        """
        return self._layout_sections

    @layout_sections.setter
    def layout_sections(self, layout_sections):
        """Sets the layout_sections of this BlogPost.


        :param layout_sections: The layout_sections of this BlogPost.  # noqa: E501
        :type: dict(str, LayoutSection)
        """
        if (
            self.local_vars_configuration.client_side_validation
            and layout_sections is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `layout_sections`, must not be `None`"
            )  # noqa: E501

        self._layout_sections = layout_sections

    @property
    def theme_settings_values(self):
        """Gets the theme_settings_values of this BlogPost.  # noqa: E501


        :return: The theme_settings_values of this BlogPost.  # noqa: E501
        :rtype: object
        """
        return self._theme_settings_values

    @theme_settings_values.setter
    def theme_settings_values(self, theme_settings_values):
        """Sets the theme_settings_values of this BlogPost.


        :param theme_settings_values: The theme_settings_values of this BlogPost.  # noqa: E501
        :type: object
        """
        if (
            self.local_vars_configuration.client_side_validation
            and theme_settings_values is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `theme_settings_values`, must not be `None`"
            )  # noqa: E501

        self._theme_settings_values = theme_settings_values

    @property
    def url(self):
        """Gets the url of this BlogPost.  # noqa: E501

        A generated field representing the URL of this blog post.  # noqa: E501

        :return: The url of this BlogPost.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this BlogPost.

        A generated field representing the URL of this blog post.  # noqa: E501

        :param url: The url of this BlogPost.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and url is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `url`, must not be `None`"
            )  # noqa: E501

        self._url = url

    @property
    def publish_date(self):
        """Gets the publish_date of this BlogPost.  # noqa: E501

        The date (ISO8601 format) the blog post is to be published at.  # noqa: E501

        :return: The publish_date of this BlogPost.  # noqa: E501
        :rtype: datetime
        """
        return self._publish_date

    @publish_date.setter
    def publish_date(self, publish_date):
        """Sets the publish_date of this BlogPost.

        The date (ISO8601 format) the blog post is to be published at.  # noqa: E501

        :param publish_date: The publish_date of this BlogPost.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation
            and publish_date is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `publish_date`, must not be `None`"
            )  # noqa: E501

        self._publish_date = publish_date

    @property
    def deleted_at(self):
        """Gets the deleted_at of this BlogPost.  # noqa: E501

        The timestamp (ISO8601 format) when this Blog Post was deleted.  # noqa: E501

        :return: The deleted_at of this BlogPost.  # noqa: E501
        :rtype: datetime
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this BlogPost.

        The timestamp (ISO8601 format) when this Blog Post was deleted.  # noqa: E501

        :param deleted_at: The deleted_at of this BlogPost.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and deleted_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `deleted_at`, must not be `None`"
            )  # noqa: E501

        self._deleted_at = deleted_at

    @property
    def created_at(self):
        """Gets the created_at of this BlogPost.  # noqa: E501

        The timestamp (ISO8601 format) when this blog post was created.  # noqa: E501

        :return: The created_at of this BlogPost.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BlogPost.

        The timestamp (ISO8601 format) when this blog post was created.  # noqa: E501

        :param created_at: The created_at of this BlogPost.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and created_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_at`, must not be `None`"
            )  # noqa: E501

        self._created_at = created_at

    @property
    def published(self):
        """Gets the published of this BlogPost.  # noqa: E501

        Boolean describing if this Blog Post is published.  # noqa: E501

        :return: The published of this BlogPost.  # noqa: E501
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """Sets the published of this BlogPost.

        Boolean describing if this Blog Post is published.  # noqa: E501

        :param published: The published of this BlogPost.  # noqa: E501
        :type: bool
        """
        if (
            self.local_vars_configuration.client_side_validation and published is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `published`, must not be `None`"
            )  # noqa: E501

        self._published = published

    @property
    def updated_at(self):
        """Gets the updated_at of this BlogPost.  # noqa: E501

        The timestamp (ISO8601 format) when this Blog Post was last updated.  # noqa: E501

        :return: The updated_at of this BlogPost.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this BlogPost.

        The timestamp (ISO8601 format) when this Blog Post was last updated.  # noqa: E501

        :param updated_at: The updated_at of this BlogPost.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and updated_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `updated_at`, must not be `None`"
            )  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlogPost):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BlogPost):
            return True

        return self.to_dict() != other.to_dict()
