# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class InvoiceCreatePaymentRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "amount_paid": "float",
        "currency_code": "str",
        "payment_date_time": "datetime",
        "external_payment_id": "str",
    }

    attribute_map = {
        "amount_paid": "amountPaid",
        "currency_code": "currencyCode",
        "payment_date_time": "paymentDateTime",
        "external_payment_id": "externalPaymentId",
    }

    def __init__(
        self,
        amount_paid=None,
        currency_code=None,
        payment_date_time=None,
        external_payment_id=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """InvoiceCreatePaymentRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amount_paid = None
        self._currency_code = None
        self._payment_date_time = None
        self._external_payment_id = None
        self.discriminator = None

        self.amount_paid = amount_paid
        self.currency_code = currency_code
        self.payment_date_time = payment_date_time
        self.external_payment_id = external_payment_id

    @property
    def amount_paid(self):
        """Gets the amount_paid of this InvoiceCreatePaymentRequest.  # noqa: E501

        The amount that this payment is for.  # noqa: E501

        :return: The amount_paid of this InvoiceCreatePaymentRequest.  # noqa: E501
        :rtype: float
        """
        return self._amount_paid

    @amount_paid.setter
    def amount_paid(self, amount_paid):
        """Sets the amount_paid of this InvoiceCreatePaymentRequest.

        The amount that this payment is for.  # noqa: E501

        :param amount_paid: The amount_paid of this InvoiceCreatePaymentRequest.  # noqa: E501
        :type: float
        """
        if (
            self.local_vars_configuration.client_side_validation and amount_paid is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `amount_paid`, must not be `None`"
            )  # noqa: E501

        self._amount_paid = amount_paid

    @property
    def currency_code(self):
        """Gets the currency_code of this InvoiceCreatePaymentRequest.  # noqa: E501

        The ISO 4217 currency code that represents the currency of the payment.  # noqa: E501

        :return: The currency_code of this InvoiceCreatePaymentRequest.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this InvoiceCreatePaymentRequest.

        The ISO 4217 currency code that represents the currency of the payment.  # noqa: E501

        :param currency_code: The currency_code of this InvoiceCreatePaymentRequest.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and currency_code is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `currency_code`, must not be `None`"
            )  # noqa: E501

        self._currency_code = currency_code

    @property
    def payment_date_time(self):
        """Gets the payment_date_time of this InvoiceCreatePaymentRequest.  # noqa: E501

        The datetime that this payment was received.  # noqa: E501

        :return: The payment_date_time of this InvoiceCreatePaymentRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._payment_date_time

    @payment_date_time.setter
    def payment_date_time(self, payment_date_time):
        """Sets the payment_date_time of this InvoiceCreatePaymentRequest.

        The datetime that this payment was received.  # noqa: E501

        :param payment_date_time: The payment_date_time of this InvoiceCreatePaymentRequest.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation
            and payment_date_time is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `payment_date_time`, must not be `None`"
            )  # noqa: E501

        self._payment_date_time = payment_date_time

    @property
    def external_payment_id(self):
        """Gets the external_payment_id of this InvoiceCreatePaymentRequest.  # noqa: E501

        The id of this payment in the external accounting system.  # noqa: E501

        :return: The external_payment_id of this InvoiceCreatePaymentRequest.  # noqa: E501
        :rtype: str
        """
        return self._external_payment_id

    @external_payment_id.setter
    def external_payment_id(self, external_payment_id):
        """Sets the external_payment_id of this InvoiceCreatePaymentRequest.

        The id of this payment in the external accounting system.  # noqa: E501

        :param external_payment_id: The external_payment_id of this InvoiceCreatePaymentRequest.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and external_payment_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `external_payment_id`, must not be `None`"
            )  # noqa: E501

        self._external_payment_id = external_payment_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InvoiceCreatePaymentRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InvoiceCreatePaymentRequest):
            return True

        return self.to_dict() != other.to_dict()
