/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.Utf8;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public final class Internal {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
    public static final CodedInputStream EMPTY_CODED_INPUT_STREAM = CodedInputStream.newInstance(EMPTY_BYTE_ARRAY);

    private Internal() {
    }

    static <T> T checkNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    static <T> T checkNotNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static String stringDefaultValue(String bytes) {
        return new String(bytes.getBytes(ISO_8859_1), UTF_8);
    }

    public static ByteString bytesDefaultValue(String bytes) {
        return ByteString.copyFrom(bytes.getBytes(ISO_8859_1));
    }

    public static byte[] byteArrayDefaultValue(String bytes) {
        return bytes.getBytes(ISO_8859_1);
    }

    public static ByteBuffer byteBufferDefaultValue(String bytes) {
        return ByteBuffer.wrap(Internal.byteArrayDefaultValue(bytes));
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer source) {
        ByteBuffer byteBuffer = source.duplicate();
        byteBuffer.clear();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.clear();
        return byteBuffer2;
    }

    public static boolean isValidUtf8(ByteString byteString) {
        return byteString.isValidUtf8();
    }

    public static boolean isValidUtf8(byte[] byteArray) {
        return Utf8.isValidUtf8(byteArray);
    }

    public static byte[] toByteArray(String value) {
        return value.getBytes(UTF_8);
    }

    public static String toStringUtf8(byte[] bytes) {
        return new String(bytes, UTF_8);
    }

    public static int hashLong(long n2) {
        long l2 = n2;
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int hashBoolean(boolean b2) {
        if (b2) {
            return 1231;
        }
        return 1237;
    }

    public static int hashEnum(EnumLite e2) {
        return e2.getNumber();
    }

    public static int hashEnumList(List<? extends EnumLite> list) {
        int n2 = 1;
        for (EnumLite enumLite : list) {
            n2 = n2 * 31 + Internal.hashEnum(enumLite);
        }
        return n2;
    }

    public static boolean equals(List<byte[]> a2, List<byte[]> b2) {
        if (a2.size() != b2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            if (Arrays.equals(a2.get(i2), b2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(List<byte[]> list) {
        int n2 = 1;
        for (byte[] byArray : list) {
            n2 = n2 * 31 + Internal.hashCode(byArray);
        }
        return n2;
    }

    public static int hashCode(byte[] bytes) {
        return Internal.hashCode(bytes, 0, bytes.length);
    }

    static int hashCode(byte[] bytes, int offset, int length) {
        int n2 = Internal.partialHash(length, bytes, offset, length);
        if (n2 == 0) {
            return 1;
        }
        return n2;
    }

    static int partialHash(int h2, byte[] bytes, int offset, int length) {
        for (int i2 = offset; i2 < offset + length; ++i2) {
            h2 = h2 * 31 + bytes[i2];
        }
        return h2;
    }

    public static boolean equalsByteBuffer(ByteBuffer a2, ByteBuffer b2) {
        if (a2.capacity() != b2.capacity()) {
            return false;
        }
        return a2.duplicate().clear().equals(b2.duplicate().clear());
    }

    public static boolean equalsByteBuffer(List<ByteBuffer> a2, List<ByteBuffer> b2) {
        if (a2.size() != b2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            if (Internal.equalsByteBuffer(a2.get(i2), b2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeByteBuffer(List<ByteBuffer> list) {
        int n2 = 1;
        for (ByteBuffer byteBuffer : list) {
            n2 = n2 * 31 + Internal.hashCodeByteBuffer(byteBuffer);
        }
        return n2;
    }

    public static int hashCodeByteBuffer(ByteBuffer bytes) {
        if (bytes.hasArray()) {
            int n2 = Internal.partialHash(bytes.capacity(), bytes.array(), bytes.arrayOffset(), bytes.capacity());
            if (n2 == 0) {
                return 1;
            }
            return n2;
        }
        int n3 = bytes.capacity() > 4096 ? 4096 : bytes.capacity();
        byte[] byArray = new byte[n3];
        ByteBuffer byteBuffer = bytes.duplicate();
        byteBuffer.clear();
        int n4 = bytes.capacity();
        while (byteBuffer.remaining() > 0) {
            int n5 = byteBuffer.remaining() <= n3 ? byteBuffer.remaining() : n3;
            byteBuffer.get(byArray, 0, n5);
            n4 = Internal.partialHash(n4, byArray, 0, n5);
        }
        if (n4 == 0) {
            return 1;
        }
        return n4;
    }

    public static <T extends MessageLite> T getDefaultInstance(Class<T> clazz) {
        try {
            Method method = clazz.getMethod("getDefaultInstance", new Class[0]);
            return (T)((MessageLite)method.invoke((Object)method, new Object[0]));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get default instance for " + clazz, exception);
        }
    }

    static Object mergeMessage(Object destination, Object source) {
        return ((MessageLite)destination).toBuilder().mergeFrom((MessageLite)source).buildPartial();
    }

    public static interface FloatList
    extends ProtobufList<Float> {
        public float getFloat(int var1);

        public void addFloat(float var1);

        public float setFloat(int var1, float var2);

        public FloatList mutableCopyWithCapacity(int var1);
    }

    public static interface DoubleList
    extends ProtobufList<Double> {
        public double getDouble(int var1);

        public void addDouble(double var1);

        public double setDouble(int var1, double var2);

        public DoubleList mutableCopyWithCapacity(int var1);
    }

    public static interface LongList
    extends ProtobufList<Long> {
        public long getLong(int var1);

        public void addLong(long var1);

        public long setLong(int var1, long var2);

        public LongList mutableCopyWithCapacity(int var1);
    }

    public static interface BooleanList
    extends ProtobufList<Boolean> {
        public boolean getBoolean(int var1);

        public void addBoolean(boolean var1);

        public boolean setBoolean(int var1, boolean var2);

        public BooleanList mutableCopyWithCapacity(int var1);
    }

    public static interface IntList
    extends ProtobufList<Integer> {
        public int getInt(int var1);

        public void addInt(int var1);

        public int setInt(int var1, int var2);

        public IntList mutableCopyWithCapacity(int var1);
    }

    public static interface ProtobufList<E>
    extends List<E>,
    RandomAccess {
        public void makeImmutable();

        public boolean isModifiable();

        public ProtobufList<E> mutableCopyWithCapacity(int var1);
    }

    public static class MapAdapter<K, V, RealValue>
    extends AbstractMap<K, V> {
        private final Map<K, RealValue> realMap;
        private final Converter<RealValue, V> valueConverter;

        public static <T extends EnumLite> Converter<Integer, T> newEnumConverter(final EnumLiteMap<T> enumMap, final T unrecognizedValue) {
            return new Converter<Integer, T>(){

                @Override
                public final T doForward(Integer value) {
                    Object t2 = enumMap.findValueByNumber(value);
                    if (t2 == null) {
                        return unrecognizedValue;
                    }
                    return t2;
                }

                @Override
                public final Integer doBackward(T value) {
                    return value.getNumber();
                }
            };
        }

        public MapAdapter(Map<K, RealValue> realMap, Converter<RealValue, V> valueConverter) {
            this.realMap = realMap;
            this.valueConverter = valueConverter;
        }

        @Override
        public V get(Object key) {
            RealValue RealValue = this.realMap.get(key);
            if (RealValue == null) {
                return null;
            }
            return this.valueConverter.doForward(RealValue);
        }

        @Override
        public V put(K key, V value) {
            RealValue RealValue = this.realMap.put(key, this.valueConverter.doBackward(value));
            if (RealValue == null) {
                return null;
            }
            return this.valueConverter.doForward(RealValue);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            MapAdapter mapAdapter = this;
            return mapAdapter.new SetAdapter(mapAdapter.realMap.entrySet());
        }

        private class EntryAdapter
        implements Map.Entry<K, V> {
            private final Map.Entry<K, RealValue> realEntry;

            public EntryAdapter(Map.Entry<K, RealValue> realEntry) {
                this.realEntry = realEntry;
            }

            @Override
            public K getKey() {
                return this.realEntry.getKey();
            }

            @Override
            public V getValue() {
                return MapAdapter.this.valueConverter.doForward(this.realEntry.getValue());
            }

            @Override
            public V setValue(V value) {
                Object RealValue = this.realEntry.setValue(MapAdapter.this.valueConverter.doBackward(value));
                if (RealValue == null) {
                    return null;
                }
                return MapAdapter.this.valueConverter.doForward(RealValue);
            }
        }

        private class IteratorAdapter
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, RealValue>> realIterator;

            public IteratorAdapter(Iterator<Map.Entry<K, RealValue>> realIterator) {
                this.realIterator = realIterator;
            }

            @Override
            public boolean hasNext() {
                return this.realIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return new EntryAdapter(this.realIterator.next());
            }

            @Override
            public void remove() {
                this.realIterator.remove();
            }
        }

        private class SetAdapter
        extends AbstractSet<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, RealValue>> realSet;

            public SetAdapter(Set<Map.Entry<K, RealValue>> realSet) {
                this.realSet = realSet;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new IteratorAdapter(this.realSet.iterator());
            }

            @Override
            public int size() {
                return this.realSet.size();
            }
        }

        public static interface Converter<A, B> {
            public B doForward(A var1);

            public A doBackward(B var1);
        }
    }

    public static class ListAdapter<F, T>
    extends AbstractList<T> {
        private final List<F> fromList;
        private final Converter<F, T> converter;

        public ListAdapter(List<F> fromList, Converter<F, T> converter) {
            this.fromList = fromList;
            this.converter = converter;
        }

        @Override
        public T get(int index) {
            return this.converter.convert(this.fromList.get(index));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        public static interface Converter<F, T> {
            public T convert(F var1);
        }
    }

    public static interface EnumVerifier {
        public boolean isInRange(int var1);
    }

    public static interface EnumLiteMap<T extends EnumLite> {
        public T findValueByNumber(int var1);
    }

    public static interface EnumLite {
        public int getNumber();
    }
}

