/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.api.BasePipelineListener;

public class PipelineConfig {
    boolean shapEnabled;
    boolean shapOriginal;
    BasePipelineListener listener = BasePipelineListener.NOOP;
    boolean withPredictionInterval;
    String[] exposedColumnNames;
    public static final PipelineConfig DEFAULT = PipelineConfig.builder().build();

    public static Builder builder() {
        return new Builder();
    }

    private PipelineConfig() {
    }

    public boolean isShapEnabled() {
        return this.shapEnabled;
    }

    public boolean isShapOriginal() {
        return this.shapOriginal;
    }

    public BasePipelineListener getListener() {
        return this.listener;
    }

    public boolean isWithPredictionInterval() {
        return this.withPredictionInterval;
    }

    public String[] getExposedColumnNames() {
        return this.exposedColumnNames;
    }

    public static class Builder
    extends PipelineConfig {
        public PipelineConfig build() {
            if (this.shapOriginal) {
                this.shapEnabled = true;
            }
            return this;
        }

        public Builder enableShap(boolean shapEnabled) {
            this.shapEnabled = shapEnabled;
            return this;
        }

        public Builder enableShapOriginal(boolean shapOriginal) {
            if (shapOriginal) {
                this.enableShap(true);
            }
            this.shapOriginal = shapOriginal;
            return this;
        }

        public Builder listener(BasePipelineListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withPredictionInterval(boolean withPredictionInterval) {
            this.withPredictionInterval = withPredictionInterval;
            return this;
        }

        public Builder exposedColumnNames(String ... exposedColumnNames) {
            this.exposedColumnNames = exposedColumnNames;
            return this;
        }
    }
}

