/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.SubParser;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeParserBucket;

class DayOfWeekISOParse
extends SubParser {
    DayOfWeekISOParse() {
    }

    @Override
    public int estimateParsedLength() {
        return 2;
    }

    @Override
    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        if (position > text.length() - 1) {
            return ~position;
        }
        char c2 = text.charAt(position);
        if (c2 < '0' || c2 > '9') {
            return ~position;
        }
        int n2 = c2 - 48;
        int n3 = position + 1;
        if (this.child != null) {
            n3 = this.child.parseInto(bucket, text, n3);
        } else if (this.ignoreSuffix) {
            n3 = text.length();
        }
        if (n3 >= 0) {
            bucket.saveField(DateTimeFieldType.dayOfWeek(), n2);
        }
        return n3;
    }
}

