/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.xgboost;

import biz.k11i.xgboost.util.FVec;
import hex.genmodel.GenModel;
import java.io.Serializable;

class OneHotEncoderFactory
implements Serializable {
    private boolean _compatible10;
    private final boolean _sparse;
    private final int[] _catOffsets;
    private final int _cats;
    private final int _nums;
    private final boolean _useAllFactorLevels;
    private final int[] _catMap;
    private final float _notHot;

    OneHotEncoderFactory(boolean compatible10, boolean sparse, int[] catOffsets, int cats, int nums, boolean useAllFactorLevels) {
        this._compatible10 = compatible10;
        this._sparse = sparse;
        this._catOffsets = catOffsets;
        this._cats = cats;
        this._nums = nums;
        this._useAllFactorLevels = useAllFactorLevels;
        float f2 = this._notHot = this._sparse ? Float.NaN : 0.0f;
        if (this._catOffsets == null) {
            this._catMap = new int[0];
        } else {
            this._catMap = new int[this._catOffsets[this._cats]];
            for (int c2 = 0; c2 < this._cats; ++c2) {
                for (int j2 = this._catOffsets[c2]; j2 < this._catOffsets[c2 + 1]; ++j2) {
                    this._catMap[j2] = c2;
                }
            }
        }
    }

    FVec fromArray(double[] input) {
        float[] numValues = new float[this._nums];
        int[] catValues = new int[this._cats];
        GenModel.setCats(input, catValues, this._cats, this._catOffsets, this._useAllFactorLevels);
        for (int i2 = 0; i2 < numValues.length; ++i2) {
            float val = (float)input[this._cats + i2];
            numValues[i2] = this._sparse && val == 0.0f ? Float.NaN : val;
        }
        if (this._compatible10) {
            return new OneHotEncoderFVecCompatible10(catValues, numValues);
        }
        return new DefaultOneHotEncoderFVec(catValues, numValues);
    }

    private class OneHotEncoderFVecCompatible10
    extends AbstractOneHotEncoderFVec {
        public OneHotEncoderFVecCompatible10(int[] catValues, float[] numValues) {
            super(catValues, numValues);
        }

        @Override
        protected boolean getCategoricalValue(int index) {
            boolean hot;
            boolean bl = hot = this._catValues[OneHotEncoderFactory.this._catMap[index]] == index;
            if (hot) {
                return true;
            }
            for (int catValue : this._catValues) {
                if (catValue != index) continue;
                return true;
            }
            return false;
        }
    }

    private class DefaultOneHotEncoderFVec
    extends AbstractOneHotEncoderFVec {
        public DefaultOneHotEncoderFVec(int[] catValues, float[] numValues) {
            super(catValues, numValues);
        }

        @Override
        protected boolean getCategoricalValue(int index) {
            return this._catValues[OneHotEncoderFactory.this._catMap[index]] == index;
        }
    }

    private abstract class AbstractOneHotEncoderFVec
    implements FVec {
        protected final int[] _catValues;
        protected final float[] _numValues;

        private AbstractOneHotEncoderFVec(int[] catValues, float[] numValues) {
            this._catValues = catValues;
            this._numValues = numValues;
        }

        @Override
        public final float fvalue(int index) {
            if (index >= OneHotEncoderFactory.this._catMap.length) {
                return this._numValues[index - OneHotEncoderFactory.this._catMap.length];
            }
            boolean isHot = this.getCategoricalValue(index);
            return isHot ? 1.0f : OneHotEncoderFactory.this._notHot;
        }

        protected abstract boolean getCategoricalValue(int var1);
    }
}

