/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.capnproto.BufferedInputStream;

public final class BufferedInputStreamWrapper
implements BufferedInputStream {
    private final ReadableByteChannel inner;
    private final ByteBuffer buf;

    public BufferedInputStreamWrapper(ReadableByteChannel readableByteChannel) {
        this.inner = readableByteChannel;
        this.buf = ByteBuffer.allocate(8192);
        this.buf.limit(0);
    }

    @Override
    public final int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 < this.buf.remaining()) {
            ByteBuffer byteBuffer2 = this.buf.slice();
            byteBuffer2.limit(n2);
            byteBuffer.put(byteBuffer2);
            this.buf.position(this.buf.position() + n2);
            return n2;
        }
        int n3 = this.buf.remaining();
        ByteBuffer byteBuffer3 = this.buf.slice();
        byteBuffer3.limit(n3);
        byteBuffer.put(byteBuffer3);
        if ((n2 -= n3) <= this.buf.capacity()) {
            this.buf.clear();
            int n4 = BufferedInputStreamWrapper.readAtLeast(this.inner, this.buf, n2);
            this.buf.rewind();
            ByteBuffer byteBuffer4 = this.buf.slice();
            byteBuffer4.limit(n2);
            byteBuffer.put(byteBuffer4);
            this.buf.limit(n4);
            this.buf.position(n2);
            return n3 + n2;
        }
        this.buf.clear();
        this.buf.limit(0);
        return n3 + BufferedInputStreamWrapper.readAtLeast(this.inner, byteBuffer, n2);
    }

    @Override
    public final ByteBuffer getReadBuffer() throws IOException {
        if (this.buf.remaining() == 0) {
            this.buf.clear();
            int n2 = BufferedInputStreamWrapper.readAtLeast(this.inner, this.buf, 1);
            this.buf.rewind();
            this.buf.limit(n2);
        }
        return this.buf;
    }

    @Override
    public final void close() throws IOException {
        this.inner.close();
    }

    @Override
    public final boolean isOpen() {
        return this.inner.isOpen();
    }

    public static int readAtLeast(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = readableByteChannel.read(byteBuffer);
            if (n4 >= 0) continue;
            throw new Error("premature EOF");
        }
        return n3;
    }
}

