# mypy-boto3-forecast

[![PyPI - mypy-boto3-forecast](https://img.shields.io/pypi/v/mypy-boto3-forecast.svg?color=blue)](https://pypi.org/project/mypy-boto3-forecast)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-forecast.svg?color=blue)](https://pypi.org/project/mypy-boto3-forecast)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ForecastService 1.14.33](https://boto3.amazonaws.com/v1/documentation/api/1.14.33/reference/services/forecast.html#ForecastService) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ForecastService` service.

```bash
python -m pip install boto3-stubs[forecast]
```

## How to use

### Client annotations

`ForecastServiceClient` provides annotations for `boto3.client("forecast")`.

```python
import boto3

from mypy_boto3_forecast import ForecastServiceClient
from mypy_boto3_forecast.paginator import (
    ListDatasetGroupsPaginator,
    ListDatasetImportJobsPaginator,
    ListDatasetsPaginator,
    ListForecastExportJobsPaginator,
    ListForecastsPaginator,
    ListPredictorsPaginator,
)
from mypy_boto3_forecast.type_defs import CategoricalParameterRangeTypeDef, ...

client: ForecastServiceClient = boto3.client("forecast")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ForecastServiceClient = session.client("forecast")
```

### Paginators annotations

`mypy_boto3_forecast.paginator` module contains type annotations for all paginators.

```python

client: ForecastServiceClient = boto3.client("forecast")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_dataset_groups_paginator: ListDatasetGroupsPaginator = client.get_paginator("list_dataset_groups")
list_dataset_import_jobs_paginator: ListDatasetImportJobsPaginator = client.get_paginator("list_dataset_import_jobs")
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_forecast_export_jobs_paginator: ListForecastExportJobsPaginator = client.get_paginator("list_forecast_export_jobs")
list_forecasts_paginator: ListForecastsPaginator = client.get_paginator("list_forecasts")
list_predictors_paginator: ListPredictorsPaginator = client.get_paginator("list_predictors")
```







### Typed dictionations

`mypy_boto3_forecast.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> CategoricalParameterRangeTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_forecast` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("forecast")

session_client = boto3.Session().client("forecast")
```
