/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner;

import at.favre.tools.apksigner.signing.AndroidApkSignerVerify;
import at.favre.tools.apksigner.signing.CertHashChecker;
import at.favre.tools.apksigner.signing.SigningConfig;
import at.favre.tools.apksigner.signing.SigningConfigGen;
import at.favre.tools.apksigner.signing.ZipAlignExecutor;
import at.favre.tools.apksigner.ui.Arg;
import at.favre.tools.apksigner.ui.CLIParser;
import at.favre.tools.apksigner.ui.FileArgParser;
import at.favre.tools.apksigner.util.AndroidApkSignerUtil;
import at.favre.tools.apksigner.util.CmdUtil;
import at.favre.tools.apksigner.util.FileUtil;
import com.android.apksigner.ApkSignerTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class SignTool {
    private static final String ZIPALIGN_ALIGNMENT = "4";
    private static final String APK_FILE_EXTENSION = "apk";

    private SignTool() {
    }

    public static void main(String[] args) {
        Result result = SignTool.mainExecute(args);
        if (result != null && result.error) {
            System.exit(1);
        } else if (result != null && result.unsuccessful > 0) {
            System.exit(2);
        }
    }

    static Result mainExecute(String[] args) {
        Arg arguments = CLIParser.parse(args);
        if (arguments != null) {
            return SignTool.execute(arguments);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result execute(Arg args) {
        ArrayList<CmdUtil.Result> executedCommands = new ArrayList<CmdUtil.Result>();
        ZipAlignExecutor zipAlignExecutor = null;
        SigningConfigGen signingConfigGen = null;
        int successCount = 0;
        int errorCount = 0;
        try {
            File outFolder = null;
            List<File> targetApkFiles = new FileArgParser().parseAndSortUniqueFilesNonRecursive(args.apkFile, APK_FILE_EXTENSION);
            if (targetApkFiles.isEmpty()) {
                throw new IllegalStateException("no apk files found in given paths");
            }
            SignTool.log("source:");
            for (String path : FileArgParser.getDirSummary(targetApkFiles)) {
                SignTool.log("\t" + path);
            }
            if (args.out != null) {
                outFolder = new File(args.out);
                if (!outFolder.exists()) {
                    outFolder.mkdirs();
                }
                if (!outFolder.exists() || !outFolder.isDirectory()) {
                    throw new IllegalArgumentException("if out directory is provided it must exist and be a path: " + args.out);
                }
            }
            if (!args.skipZipAlign) {
                zipAlignExecutor = new ZipAlignExecutor(args);
                SignTool.log(zipAlignExecutor.toString());
            }
            if (!args.onlyVerify) {
                SignTool.log("keystore:");
                signingConfigGen = new SigningConfigGen(args.signArgsList, args.ksIsDebug);
                for (SigningConfig signingConfig : signingConfigGen.signingConfig) {
                    SignTool.log("\t" + signingConfig.description());
                }
            }
            if (args.lineageFilePath != null) {
                SignTool.processLineagePath(args);
            }
            long startTime = System.currentTimeMillis();
            int iterCount = 0;
            ArrayList<File> tempFilesToDelete = new ArrayList<File>();
            for (File targetApkFile : targetApkFiles) {
                boolean sigVerified;
                File rootTargetFile = targetApkFile;
                SignTool.log("\n" + String.format("%02d", ++iterCount) + ". " + targetApkFile.getName());
                if (args.dryRun) {
                    SignTool.log("\t- (skip)");
                    continue;
                }
                if (!args.onlyVerify) {
                    AndroidApkSignerVerify.Result preCheck = SignTool.verifySign(targetApkFile, rootTargetFile, args.checkCertSha256, false, true);
                    if (preCheck != null && args.allowResign) {
                        SignTool.log("\tWARNING: already signed - will be resigned. Old certificate info: " + preCheck.getCertCountString() + preCheck.getSchemaVersionInfoString());
                        for (AndroidApkSignerVerify.CertInfo certInfo : preCheck.certInfoList) {
                            SignTool.log("\t\tSubject: " + certInfo.subjectDn);
                            SignTool.log("\t\tSHA256: " + certInfo.certSha256);
                        }
                    } else if (preCheck != null) {
                        SignTool.logErr("\t- already signed SKIP");
                        ++errorCount;
                        continue;
                    }
                }
                if (!args.onlyVerify) {
                    SignTool.log("\n\tSIGN");
                    SignTool.log("\tfile: " + rootTargetFile.getCanonicalPath() + " (" + FileUtil.getFileSizeMb(targetApkFile) + ")");
                    SignTool.log("\tchecksum: " + FileUtil.createChecksum(rootTargetFile, "SHA-256") + " (sha256)");
                    targetApkFile = SignTool.zipAlign(targetApkFile, rootTargetFile, outFolder, zipAlignExecutor, args, executedCommands);
                    if (targetApkFile == null) {
                        throw new IllegalStateException("could not execute zipalign");
                    }
                    if (!args.overwrite && !args.skipZipAlign) {
                        tempFilesToDelete.add(targetApkFile);
                    }
                    targetApkFile = SignTool.sign(targetApkFile, outFolder, signingConfigGen.signingConfig, args);
                }
                SignTool.log("\n\tVERIFY");
                SignTool.log("\tfile: " + targetApkFile.getCanonicalPath() + " (" + FileUtil.getFileSizeMb(targetApkFile) + ")");
                SignTool.log("\tchecksum: " + FileUtil.createChecksum(targetApkFile, "SHA-256") + " (sha256)");
                boolean zipAlignVerified = args.skipZipAlign || SignTool.verifyZipAlign(targetApkFile, rootTargetFile, zipAlignExecutor, args, executedCommands);
                boolean bl = sigVerified = SignTool.verifySign(targetApkFile, rootTargetFile, args.checkCertSha256, args.verbose, false) != null;
                if (zipAlignVerified && sigVerified) {
                    ++successCount;
                    continue;
                }
                ++errorCount;
            }
            if (iterCount == 0) {
                SignTool.log("No apks found.");
            }
            SignTool.deleteTempFiles(args, tempFilesToDelete);
            SignTool.log(String.format(Locale.US, "\n[%s][v%s]\nSuccessfully processed %d APKs and %d errors in %.2f seconds.", new Date().toString(), CmdUtil.jarVersion(), successCount, errorCount, (double)(System.currentTimeMillis() - startTime) / 1000.0));
            if (args.debug) {
                SignTool.log(SignTool.getCommandHistory(executedCommands));
            }
            SignTool.cleanup(zipAlignExecutor, signingConfigGen);
        }
        catch (Exception e) {
            SignTool.logException(args, executedCommands, e);
            Result result = new Result(true, successCount, errorCount);
            return result;
        }
        finally {
            SignTool.cleanup(zipAlignExecutor, signingConfigGen);
        }
        return new Result(false, successCount, errorCount);
    }

    private static void processLineagePath(Arg args) throws IOException {
        File lineageFile = new File(args.lineageFilePath);
        if (!lineageFile.exists() || !lineageFile.isFile()) {
            throw new IllegalArgumentException("lineage file either does not exist or is not a file: " + args.lineageFilePath);
        }
        SignTool.log("lineage:");
        SignTool.log("\t" + FileUtil.createChecksum(lineageFile, "SHA-256").substring(0, 8) + " " + lineageFile.getCanonicalPath());
    }

    private static void deleteTempFiles(Arg args, List<File> tempFilesToDelete) {
        for (File file : tempFilesToDelete) {
            if (args.verbose) {
                SignTool.log("delete temp file " + file);
            }
            file.delete();
        }
    }

    private static void cleanup(ZipAlignExecutor zipAlignExecutor, SigningConfigGen signingConfigGen) {
        if (zipAlignExecutor != null) {
            zipAlignExecutor.cleanUp();
        }
        if (signingConfigGen != null) {
            signingConfigGen.cleanUp();
        }
    }

    private static void logException(Arg args, List<CmdUtil.Result> executedCommands, Exception e) {
        SignTool.logErr(e.getMessage());
        if (args.debug) {
            e.printStackTrace();
            SignTool.logErr(SignTool.getCommandHistory(executedCommands));
        } else {
            SignTool.logErr("Run with '--debug' parameter to get additional information.");
        }
    }

    private static File zipAlign(File targetApkFile, File rootTargetFile, File outFolder, ZipAlignExecutor executor, Arg arguments, List<CmdUtil.Result> cmdList) {
        if (!arguments.skipZipAlign) {
            String fileName = FileUtil.getFileNameWithoutExtension(targetApkFile);
            fileName = fileName.replace("-unaligned", "");
            File outFile = new File(outFolder != null ? outFolder : targetApkFile.getParentFile(), (fileName = fileName + "-aligned") + "." + FileUtil.getFileExtension(targetApkFile));
            if (outFile.exists()) {
                outFile.delete();
            }
            if (executor.isExecutableFound()) {
                String logMsg = "\t- ";
                CmdUtil.Result zipAlignResult = CmdUtil.runCmd(CmdUtil.concat(executor.getZipAlignExecutable(), new String[]{"-p", "-v", ZIPALIGN_ALIGNMENT, targetApkFile.getAbsolutePath(), outFile.getAbsolutePath()}));
                cmdList.add(zipAlignResult);
                logMsg = zipAlignResult.success() ? logMsg + "zipalign success" : logMsg + "could not align ";
                SignTool.logConditionally(logMsg, outFile, !rootTargetFile.equals(outFile), false);
                if (arguments.overwrite) {
                    targetApkFile.delete();
                    outFile.renameTo(targetApkFile);
                    outFile = targetApkFile;
                }
                return zipAlignResult.success() ? outFile : null;
            }
            throw new IllegalArgumentException("could not find zipalign - either skip it or provide a proper location");
        }
        return targetApkFile;
    }

    private static boolean verifyZipAlign(File targetApkFile, File rootTargetFile, ZipAlignExecutor executor, Arg arguments, List<CmdUtil.Result> cmdList) {
        if (!arguments.skipZipAlign) {
            if (executor.isExecutableFound()) {
                String logMsg = "\t- ";
                CmdUtil.Result zipAlignVerifyResult = CmdUtil.runCmd(CmdUtil.concat(executor.getZipAlignExecutable(), new String[]{"-c", ZIPALIGN_ALIGNMENT, targetApkFile.getAbsolutePath()}));
                cmdList.add(zipAlignVerifyResult);
                boolean success = zipAlignVerifyResult.success();
                logMsg = success ? logMsg + "zipalign verified" : logMsg + "zipalign VERIFY FAILED";
                SignTool.logConditionally(logMsg, targetApkFile, !targetApkFile.equals(rootTargetFile), !success);
                return zipAlignVerifyResult.success();
            }
            throw new IllegalArgumentException("could not find zipalign - either skip it or provide a proper location");
        }
        return true;
    }

    private static File sign(File targetApkFile, File outFolder, List<SigningConfig> signingConfigs, Arg arguments) {
        try {
            File outFile = targetApkFile;
            if (!arguments.overwrite) {
                String fileName = FileUtil.getFileNameWithoutExtension(targetApkFile);
                fileName = fileName.replace("-unsigned", "");
                outFile = new File(outFolder != null ? outFolder : targetApkFile.getParentFile(), (fileName = signingConfigs.size() == 1 && signingConfigs.get((int)0).isDebugType ? fileName + "-debugSigned" : fileName + "-signed") + "." + FileUtil.getFileExtension(targetApkFile));
                if (outFile.exists()) {
                    outFile.delete();
                }
            }
            ByteArrayOutputStream apkSignerToolStream = new ByteArrayOutputStream();
            PrintStream sout = System.out;
            System.setOut(new PrintStream(apkSignerToolStream));
            ApkSignerTool.main(AndroidApkSignerUtil.createApkToolArgs(arguments, signingConfigs, targetApkFile, outFile));
            String output = apkSignerToolStream.toString("UTF-8").trim();
            System.setOut(sout);
            SignTool.log("\t- sign success");
            if (arguments.verbose && !output.isEmpty()) {
                SignTool.log("\t\t" + output);
            }
            return outFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("could not sign " + targetApkFile + ": " + e.getMessage(), e);
        }
    }

    private static AndroidApkSignerVerify.Result verifySign(File targetApkFile, File rootTargetFile, String[] checkHashes, boolean verbose, boolean preCheckVerify) {
        try {
            AndroidApkSignerVerify verifier = new AndroidApkSignerVerify();
            AndroidApkSignerVerify.Result result = verifier.verify(targetApkFile, null, null, false);
            if (!preCheckVerify) {
                CertHashChecker.Result certHashResult;
                String logMsg = result.verified ? "\t- signature verified " + result.getCertCountString() + result.getSchemaVersionInfoString() : "\t- signature VERIFY FAILED (" + targetApkFile.getName() + ")";
                SignTool.logConditionally(logMsg, targetApkFile, !rootTargetFile.equals(targetApkFile), !result.verified);
                if (!result.errors.isEmpty()) {
                    for (String e : result.errors) {
                        SignTool.logErr("\t\t" + e);
                    }
                }
                if (verbose && !result.warnings.isEmpty()) {
                    for (String w : result.warnings) {
                        SignTool.log("\t\t" + w);
                    }
                } else if (!result.warnings.isEmpty()) {
                    SignTool.log("\t\t" + result.warnings.size() + " warnings");
                }
                if (result.verified) {
                    for (int i = 0; i < result.certInfoList.size(); ++i) {
                        AndroidApkSignerVerify.CertInfo certInfo = result.certInfoList.get(i);
                        SignTool.log("\t\t" + certInfo.subjectDn);
                        SignTool.log("\t\tSHA256: " + certInfo.certSha256 + " / " + certInfo.sigAlgo);
                        if (verbose) {
                            SignTool.log("\t\tSHA1: " + certInfo.certSha1);
                            SignTool.log("\t\t" + certInfo.issuerDn);
                            SignTool.log("\t\tPublic Key SHA256: " + certInfo.pubSha256);
                            SignTool.log("\t\tPublic Key SHA1: " + certInfo.pubSha1);
                            SignTool.log("\t\tPublic Key Algo: " + certInfo.pubAlgo + " " + certInfo.pubKeysize);
                            SignTool.log("\t\tIssue Date: " + certInfo.beginValidity);
                        }
                        SignTool.log("\t\tExpires: " + certInfo.expiry.toString());
                        if (i >= result.certInfoList.size() - 1) continue;
                        SignTool.log("");
                    }
                }
                if ((certHashResult = new CertHashChecker().check(result, checkHashes)) != null) {
                    if (!certHashResult.verified) {
                        SignTool.log("\t- verify with provided hash check failed " + certHashResult.hashSummary());
                        SignTool.logErr("\t\tERROR: " + certHashResult.errorString);
                    } else {
                        SignTool.log("\t- verify with provided hash successful " + certHashResult.hashSummary());
                    }
                    return result.verified && certHashResult.verified ? result : null;
                }
            }
            return result.verified ? result : null;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not verify " + targetApkFile + ": " + e.getMessage(), e);
        }
    }

    private static String getCommandHistory(List<CmdUtil.Result> executedCommands) {
        StringBuilder sb = new StringBuilder("\nCmd history for debugging purpose:\n-----------------------\n");
        for (CmdUtil.Result executedCommand : executedCommands) {
            sb.append(executedCommand.toString());
        }
        return sb.toString();
    }

    private static void logErr(String msg) {
        System.err.println(msg);
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static void logConditionally(String logMsg, File file, boolean appendFile, boolean error) {
        if (appendFile && error) {
            logMsg = logMsg + " (" + file.getName() + ")";
        }
        if (error) {
            SignTool.logErr(logMsg);
        } else {
            SignTool.log(logMsg);
        }
    }

    static class Result {
        final boolean error;
        final int success;
        final int unsuccessful;

        Result(boolean error, int success, int unsuccessful) {
            this.error = error;
            this.success = success;
            this.unsuccessful = unsuccessful;
        }
    }
}

