/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.signing;

import at.favre.lib.bytes.Bytes;
import com.android.apksig.ApkVerifier;
import java.io.File;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class AndroidApkSignerVerify {
    public Result verify(File apk, Integer minSdkVersion, Integer maxSdkVersion, boolean warningsTreatedAsErrors) throws Exception {
        String name;
        ApkVerifier.Result apkVerifierResult;
        boolean verified;
        StringBuilder logMsg = new StringBuilder();
        ArrayList<CertInfo> certInfoList = new ArrayList<CertInfo>();
        ArrayList<String> warnings = new ArrayList<String>();
        ApkVerifier.Builder builder = new ApkVerifier.Builder(apk);
        if (minSdkVersion != null) {
            builder.setMinCheckedPlatformVersion(minSdkVersion);
        }
        if (maxSdkVersion != null) {
            builder.setMaxCheckedPlatformVersion(maxSdkVersion);
        }
        if (verified = (apkVerifierResult = builder.build().verify()).isVerified()) {
            List<X509Certificate> signerCertificates = apkVerifierResult.getSignerCertificates();
            logMsg.append("Verifies\n");
            logMsg.append("Verified using v1 scheme (JAR signing): ").append(apkVerifierResult.isVerifiedUsingV1Scheme());
            logMsg.append("Verified using v2 scheme (APK Signature Scheme v2): ").append(apkVerifierResult.isVerifiedUsingV2Scheme());
            logMsg.append("Verified using v3 scheme (APK Signature Scheme v3): ").append(apkVerifierResult.isVerifiedUsingV3Scheme());
            logMsg.append("Number of signers: ").append(signerCertificates.size());
            MessageDigest sha256Digest = MessageDigest.getInstance("SHA-256");
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            Iterator<Object> iter = signerCertificates.iterator();
            while (iter.hasNext()) {
                DSAParams encodedKey;
                CertInfo certInfo = new CertInfo();
                X509Certificate x509Certificate = (X509Certificate)iter.next();
                byte[] encodedCert = x509Certificate.getEncoded();
                certInfo.subjectDn = "Subject: " + x509Certificate.getSubjectDN().toString();
                certInfo.issuerDn = "Issuer: " + x509Certificate.getIssuerDN().toString();
                certInfo.sigAlgo = x509Certificate.getSigAlgName();
                certInfo.certSha1 = Bytes.wrap(sha1Digest.digest(encodedCert)).encodeHex();
                certInfo.certSha256 = Bytes.wrap(sha256Digest.digest(encodedCert)).encodeHex();
                certInfo.expiry = x509Certificate.getNotAfter();
                certInfo.beginValidity = x509Certificate.getNotBefore();
                PublicKey publicKey = x509Certificate.getPublicKey();
                certInfo.pubAlgo = publicKey.getAlgorithm();
                int keySize = -1;
                if (publicKey instanceof RSAKey) {
                    keySize = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
                } else if (publicKey instanceof ECKey) {
                    keySize = ((ECKey)((Object)publicKey)).getParams().getOrder().bitLength();
                } else if (publicKey instanceof DSAKey && (encodedKey = ((DSAKey)((Object)publicKey)).getParams()) != null) {
                    keySize = encodedKey.getP().bitLength();
                }
                certInfo.pubKeysize = keySize;
                byte[] pubKey = publicKey.getEncoded();
                certInfo.pubSha1 = Bytes.wrap(sha1Digest.digest(pubKey)).encodeHex();
                certInfo.pubSha256 = Bytes.wrap(sha256Digest.digest(pubKey)).encodeHex();
                certInfoList.add(certInfo);
            }
        } else {
            logMsg.append("DOES NOT VERIFY\n");
        }
        List<String> errors = apkVerifierResult.getErrors().stream().map(error -> "ERROR: " + error).collect(Collectors.toList());
        for (ApkVerifier.IssueWithParams var29 : apkVerifierResult.getWarnings()) {
            warnings.add("WARNING: " + var29);
        }
        for (ApkVerifier.Result.V1SchemeSignerInfo v1SchemeSignerInfo : apkVerifierResult.getV1SchemeSigners()) {
            name = v1SchemeSignerInfo.getName();
            for (ApkVerifier.IssueWithParams issueWithParams : v1SchemeSignerInfo.getErrors()) {
                errors.add("ERROR: JAR signer " + name + ": " + issueWithParams);
            }
            for (ApkVerifier.IssueWithParams issueWithParams : v1SchemeSignerInfo.getWarnings()) {
                warnings.add("WARNING: JAR signer " + issueWithParams);
            }
        }
        for (ApkVerifier.Result.V2SchemeSignerInfo v2SchemeSignerInfo : apkVerifierResult.getV2SchemeSigners()) {
            name = "signer #" + (v2SchemeSignerInfo.getIndex() + 1);
            for (ApkVerifier.IssueWithParams issueWithParams : v2SchemeSignerInfo.getErrors()) {
                errors.add("ERROR: APK Signature Scheme v2 " + name + ": " + issueWithParams);
            }
            for (ApkVerifier.IssueWithParams issueWithParams : v2SchemeSignerInfo.getWarnings()) {
                warnings.add("WARNING: APK Signature Scheme v2  " + name + ": " + issueWithParams);
            }
        }
        for (ApkVerifier.Result.V3SchemeSignerInfo v3SchemeSignerInfo : apkVerifierResult.getV3SchemeSigners()) {
            name = "signer #" + (v3SchemeSignerInfo.getIndex() + 1);
            for (ApkVerifier.IssueWithParams issueWithParams : v3SchemeSignerInfo.getErrors()) {
                errors.add("ERROR: APK Signature Scheme v3 " + name + ": " + issueWithParams);
            }
            for (ApkVerifier.IssueWithParams issueWithParams : v3SchemeSignerInfo.getWarnings()) {
                warnings.add("WARNING: APK Signature Scheme v3  " + name + ": " + issueWithParams);
            }
        }
        if (!verified || warningsTreatedAsErrors && !warnings.isEmpty()) {
            return new Result(false, warnings, errors, logMsg.toString(), apkVerifierResult.isVerifiedUsingV1Scheme(), apkVerifierResult.isVerifiedUsingV2Scheme(), apkVerifierResult.isVerifiedUsingV3Scheme(), certInfoList);
        }
        return new Result(true, warnings, errors, logMsg.toString(), apkVerifierResult.isVerifiedUsingV1Scheme(), apkVerifierResult.isVerifiedUsingV2Scheme(), apkVerifierResult.isVerifiedUsingV3Scheme(), certInfoList);
    }

    public static class CertInfo {
        public String certSha1;
        public String certSha256;
        public String pubSha1;
        public String pubSha256;
        public String subjectDn;
        public String issuerDn;
        public String sigAlgo;
        public String pubAlgo;
        public int pubKeysize;
        public Date expiry;
        public Date beginValidity;
    }

    public static class Result {
        public final boolean verified;
        public final List<String> warnings;
        public final List<String> errors;
        public final String log;
        public final boolean v1Schema;
        public final boolean v2Schema;
        public final boolean v3Schema;
        public final List<CertInfo> certInfoList;

        public Result(boolean verified, List<String> warnings, List<String> errors, String log, boolean v1Schema, boolean v2Schema, boolean v3Schema, List<CertInfo> certInfoList) {
            this.verified = verified;
            this.warnings = warnings;
            this.errors = errors;
            this.log = log;
            this.v1Schema = v1Schema;
            this.v2Schema = v2Schema;
            this.v3Schema = v3Schema;
            this.certInfoList = certInfoList;
        }

        public String getSchemaVersionInfoString() {
            return "[" + (this.v1Schema ? "v1" : "") + (this.v1Schema && this.v2Schema ? ", " : "") + (this.v2Schema ? "v2" : "") + (this.v2Schema && this.v3Schema ? ", " : "") + (this.v3Schema ? "v3" : "") + "] ";
        }

        public String getCertCountString() {
            if (this.certInfoList.size() > 1) {
                return "(" + this.certInfoList.size() + ") ";
            }
            return "";
        }
    }
}

