/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.signing;

import at.favre.tools.apksigner.signing.AndroidApkSignerVerify;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CertHashChecker {
    public Result check(AndroidApkSignerVerify.Result verifyResult, String[] hashes) {
        if (verifyResult == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (hashes == null || !verifyResult.verified) {
            return null;
        }
        if (verifyResult.certInfoList.isEmpty()) {
            throw new IllegalArgumentException("no certs info found in verify result - strange...");
        }
        if (verifyResult.certInfoList.size() != hashes.length) {
            return new Result(false, "not the same count of signatures and provided check hashes (found " + verifyResult.certInfoList.size() + " signatures)", hashes);
        }
        List apkHashes = verifyResult.certInfoList.stream().map(certInfo -> certInfo.certSha256).distinct().sorted().collect(Collectors.toList());
        List providedHashes = Arrays.stream(hashes).distinct().sorted().collect(Collectors.toList());
        for (int i = 0; i < apkHashes.size(); ++i) {
            if (((String)apkHashes.get(i)).equalsIgnoreCase((String)providedHashes.get(i))) continue;
            return new Result(false, "The following hash does not match with the provided: " + (String)apkHashes.get(i) + " <> " + (String)providedHashes.get(i), hashes);
        }
        return new Result(true, null, hashes);
    }

    public static class Result {
        public final boolean verified;
        public final String errorString;
        public final String[] sha256;

        public Result(boolean verified, String errorString, String[] sha256) {
            this.verified = verified;
            this.errorString = errorString;
            this.sha256 = sha256;
        }

        public String hashSummary() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            if (this.sha256 != null) {
                sb.append("(");
                for (String s : this.sha256) {
                    sb.append(sep);
                    sep = ",";
                    if (s.length() > 8) {
                        sb.append(s.substring(0, 8));
                        continue;
                    }
                    sb.append(s);
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

