/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.signing;

import at.favre.tools.apksigner.ui.Arg;
import at.favre.tools.apksigner.util.CmdUtil;
import at.favre.tools.apksigner.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;

public class ZipAlignExecutor {
    public static final String ZIPALIGN_NAME = "zipalign";
    private String[] zipAlignExecutable;
    private Location location;
    private File tmpFolder;

    public ZipAlignExecutor(Arg arg) {
        this.findLocation(arg);
    }

    private void findLocation(Arg arg) {
        try {
            if (arg.zipAlignPath != null && new File(arg.zipAlignPath).exists()) {
                File passedPath = new File(arg.zipAlignPath);
                if (passedPath.exists() && passedPath.isFile()) {
                    this.zipAlignExecutable = new String[]{new File(arg.zipAlignPath).getAbsolutePath()};
                    this.location = Location.CUSTOM;
                }
            } else {
                File pathFile = CmdUtil.checkAndGetFromPATHEnvVar(ZIPALIGN_NAME);
                if (pathFile != null) {
                    this.zipAlignExecutable = new String[]{pathFile.getAbsolutePath()};
                    this.location = Location.PATH;
                    return;
                }
                if (this.zipAlignExecutable == null) {
                    String fileName;
                    CmdUtil.OS osType = CmdUtil.getOsType();
                    String lib = null;
                    if (osType == CmdUtil.OS.WIN) {
                        fileName = "win-zipalign_29_0_2.exe";
                        lib = "libwinpthread-1-29_0_2.dll";
                    } else if (osType == CmdUtil.OS.MAC) {
                        fileName = "mac-zipalign-29_0_2";
                        lib = "linux64-libc++-29_0_2.so";
                    } else {
                        fileName = "linux-zipalign-29_0_2";
                        lib = "linux64-libc++-29_0_2.so";
                    }
                    this.tmpFolder = Files.createTempDirectory("uapksigner-", new FileAttribute[0]).toFile();
                    File tmpZipAlign = File.createTempFile(fileName, null, this.tmpFolder);
                    Files.copy(this.getClass().getClassLoader().getResourceAsStream(fileName), tmpZipAlign.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    if (osType != CmdUtil.OS.WIN) {
                        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                        perms.add(PosixFilePermission.OWNER_EXECUTE);
                        Files.setPosixFilePermissions(tmpZipAlign.toPath(), perms);
                        File lib64File = new File(new File(this.tmpFolder, "lib64"), "libc++.so");
                        lib64File.mkdirs();
                        Files.setPosixFilePermissions(lib64File.toPath(), perms);
                        Files.copy(this.getClass().getClassLoader().getResourceAsStream(lib), lib64File.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.copy(this.getClass().getClassLoader().getResourceAsStream(lib), new File(this.tmpFolder, "libwinpthread-1.dll").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    this.zipAlignExecutable = new String[]{tmpZipAlign.getAbsolutePath()};
                    this.location = Location.BUILT_IN;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find location for zipalign. Try to set it in PATH or use the --zipAlignPath argument. Optionally you could skip zipalign with --skipZipAlign. " + e.getMessage(), e);
        }
    }

    public boolean isExecutableFound() {
        return this.zipAlignExecutable != null;
    }

    public void cleanUp() {
        if (this.tmpFolder != null) {
            FileUtil.removeRecursive(this.tmpFolder.toPath());
            this.tmpFolder = null;
        }
    }

    public String[] getZipAlignExecutable() {
        return this.zipAlignExecutable;
    }

    public String toString() {
        return "zipalign location: " + (Object)((Object)this.location) + " \n\t" + this.zipAlignExecutable[0];
    }

    private static enum Location {
        CUSTOM,
        PATH,
        BUILT_IN;

    }
}

