/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.ui;

import at.favre.tools.apksigner.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class FileArgParser {
    public List<File> parseAndSortUniqueFilesNonRecursive(String[] files, String extensionFilter) {
        if (files == null) {
            throw new IllegalArgumentException("input files must not be null");
        }
        if (files.length == 0) {
            return Collections.emptyList();
        }
        HashSet<File> fileSet = new HashSet<File>();
        for (String file : files) {
            File apkFile = new File(file);
            if (apkFile.exists() && apkFile.isDirectory()) {
                for (File dirFile : apkFile.listFiles()) {
                    if (!FileArgParser.isCorrectFile(dirFile, extensionFilter)) continue;
                    fileSet.add(dirFile);
                }
                continue;
            }
            if (FileArgParser.isCorrectFile(apkFile, extensionFilter)) {
                fileSet.add(apkFile);
                continue;
            }
            throw new IllegalArgumentException("provided apk path or file '" + file + "' does not exist");
        }
        ArrayList<File> resultList = new ArrayList<File>(fileSet);
        Collections.sort(resultList);
        return resultList;
    }

    public static List<String> getDirSummary(List<File> files) {
        HashSet<File> parents = new HashSet<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                parents.add(file);
                continue;
            }
            try {
                file = new File(file.getCanonicalPath());
                parents.add(file.getParentFile());
            }
            catch (IOException e) {
                throw new IllegalStateException("could not add parent folder", e);
            }
        }
        return parents.stream().map(f -> {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalStateException("could not get dir summary", e);
            }
        }).sorted().collect(Collectors.toList());
    }

    private static boolean isCorrectFile(File f, String extensionFilter) {
        if (f != null && f.exists() && f.isFile()) {
            return FileUtil.getFileExtension(f).equalsIgnoreCase(extensionFilter);
        }
        return false;
    }
}

