/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderDebugItem;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.BuilderOffsetInstruction;
import org.jf.dexlib2.builder.BuilderSwitchPayload;
import org.jf.dexlib2.builder.BuilderTryBlock;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.builder.SwitchLabelElement;
import org.jf.dexlib2.builder.debug.BuilderEndLocal;
import org.jf.dexlib2.builder.debug.BuilderEpilogueBegin;
import org.jf.dexlib2.builder.debug.BuilderLineNumber;
import org.jf.dexlib2.builder.debug.BuilderPrologueEnd;
import org.jf.dexlib2.builder.debug.BuilderRestartLocal;
import org.jf.dexlib2.builder.debug.BuilderSetSourceFile;
import org.jf.dexlib2.builder.debug.BuilderStartLocal;
import org.jf.dexlib2.builder.instruction.BuilderArrayPayload;
import org.jf.dexlib2.builder.instruction.BuilderInstruction10t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction10x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction11n;
import org.jf.dexlib2.builder.instruction.BuilderInstruction11x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction12x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction20bc;
import org.jf.dexlib2.builder.instruction.BuilderInstruction20t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21ih;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21lh;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21s;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22b;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22cs;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22s;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction23x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction30t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction31c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction31i;
import org.jf.dexlib2.builder.instruction.BuilderInstruction31t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction32x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction35c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction35mi;
import org.jf.dexlib2.builder.instruction.BuilderInstruction35ms;
import org.jf.dexlib2.builder.instruction.BuilderInstruction3rc;
import org.jf.dexlib2.builder.instruction.BuilderInstruction3rmi;
import org.jf.dexlib2.builder.instruction.BuilderInstruction3rms;
import org.jf.dexlib2.builder.instruction.BuilderInstruction45cc;
import org.jf.dexlib2.builder.instruction.BuilderInstruction51l;
import org.jf.dexlib2.builder.instruction.BuilderPackedSwitchPayload;
import org.jf.dexlib2.builder.instruction.BuilderSparseSwitchPayload;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.instruction.formats.Instruction22cs;
import org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction35mi;
import org.jf.dexlib2.iface.instruction.formats.Instruction35ms;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rmi;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import org.jf.dexlib2.iface.instruction.formats.Instruction45cc;
import org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.util.ExceptionWithContext;

public class MutableMethodImplementation
implements MethodImplementation {
    private final int registerCount;
    final ArrayList<MethodLocation> instructionList = Lists.newArrayList(new MethodLocation(null, 0, 0));
    private final ArrayList<BuilderTryBlock> tryBlocks = Lists.newArrayList();
    private boolean fixInstructions = true;

    /*
     * WARNING - void declaration
     */
    public MutableMethodImplementation(MethodImplementation methodImplementation) {
        void var5_7;
        this.registerCount = methodImplementation.getRegisterCount();
        int codeAddress = 0;
        int index = 0;
        for (Instruction instruction : methodImplementation.getInstructions()) {
            this.instructionList.add(new MethodLocation(null, codeAddress += instruction.getCodeUnits(), ++index));
        }
        final int[] codeAddressToIndex = new int[codeAddress + 1];
        Arrays.fill(codeAddressToIndex, -1);
        boolean bl = false;
        while (var5_7 < this.instructionList.size()) {
            codeAddressToIndex[this.instructionList.get((int)var5_7).codeAddress] = var5_7;
            ++var5_7;
        }
        ArrayList<1> arrayList = Lists.newArrayList();
        index = 0;
        for (final Instruction instruction : methodImplementation.getInstructions()) {
            final MethodLocation location = this.instructionList.get(index);
            Opcode opcode = instruction.getOpcode();
            if (opcode == Opcode.PACKED_SWITCH_PAYLOAD || opcode == Opcode.SPARSE_SWITCH_PAYLOAD) {
                arrayList.add(new Task(){

                    @Override
                    public void perform() {
                        MutableMethodImplementation.this.convertAndSetInstruction(location, codeAddressToIndex, instruction);
                    }
                });
            } else {
                this.convertAndSetInstruction(location, codeAddressToIndex, instruction);
            }
            ++index;
        }
        for (Task task : arrayList) {
            task.perform();
        }
        for (DebugItem debugItem : methodImplementation.getDebugItems()) {
            int debugCodeAddress = debugItem.getCodeAddress();
            int locationIndex = this.mapCodeAddressToIndex(codeAddressToIndex, debugCodeAddress);
            MethodLocation debugLocation = this.instructionList.get(locationIndex);
            BuilderDebugItem builderDebugItem = this.convertDebugItem(debugItem);
            debugLocation.getDebugItems().add(builderDebugItem);
            builderDebugItem.location = debugLocation;
        }
        for (TryBlock tryBlock : methodImplementation.getTryBlocks()) {
            Label startLabel = this.newLabel(codeAddressToIndex, tryBlock.getStartCodeAddress());
            Label endLabel = this.newLabel(codeAddressToIndex, tryBlock.getStartCodeAddress() + tryBlock.getCodeUnitCount());
            for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                this.tryBlocks.add(new BuilderTryBlock(startLabel, endLabel, exceptionHandler.getExceptionTypeReference(), this.newLabel(codeAddressToIndex, exceptionHandler.getHandlerCodeAddress())));
            }
        }
    }

    public MutableMethodImplementation(int registerCount) {
        this.registerCount = registerCount;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    public List<BuilderInstruction> getInstructions() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        return new AbstractList<BuilderInstruction>(){

            @Override
            public BuilderInstruction get(int i) {
                if (i >= this.size()) {
                    throw new IndexOutOfBoundsException();
                }
                if (MutableMethodImplementation.this.fixInstructions) {
                    MutableMethodImplementation.this.fixInstructions();
                }
                return MutableMethodImplementation.this.instructionList.get((int)i).instruction;
            }

            @Override
            public int size() {
                if (MutableMethodImplementation.this.fixInstructions) {
                    MutableMethodImplementation.this.fixInstructions();
                }
                return MutableMethodImplementation.this.instructionList.size() - 1;
            }
        };
    }

    public List<BuilderTryBlock> getTryBlocks() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        return Collections.unmodifiableList(this.tryBlocks);
    }

    @Override
    public Iterable<? extends DebugItem> getDebugItems() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        return Iterables.concat(Iterables.transform(this.instructionList, new Function<MethodLocation, Iterable<? extends DebugItem>>(){

            @Override
            public Iterable<? extends DebugItem> apply(MethodLocation input) {
                assert (input != null);
                if (MutableMethodImplementation.this.fixInstructions) {
                    throw new IllegalStateException("This iterator was invalidated by a change to this MutableMethodImplementation.");
                }
                return input.getDebugItems();
            }
        }));
    }

    public void addCatch(TypeReference type, Label from, Label to, Label handler) {
        this.tryBlocks.add(new BuilderTryBlock(from, to, type, handler));
    }

    public void addCatch(Label from, Label to, Label handler) {
        this.tryBlocks.add(new BuilderTryBlock(from, to, handler));
    }

    public void addInstruction(int index, BuilderInstruction instruction) {
        if (index >= this.instructionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.instructionList.size() - 1) {
            this.addInstruction(instruction);
            return;
        }
        int codeAddress = this.instructionList.get(index).getCodeAddress();
        MethodLocation newLoc = new MethodLocation(instruction, codeAddress, index);
        this.instructionList.add(index, newLoc);
        instruction.location = newLoc;
        codeAddress += instruction.getCodeUnits();
        for (int i = index + 1; i < this.instructionList.size(); ++i) {
            MethodLocation location = this.instructionList.get(i);
            ++location.index;
            location.codeAddress = codeAddress;
            if (location.instruction != null) {
                codeAddress += location.instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    public void addInstruction(BuilderInstruction instruction) {
        MethodLocation last = this.instructionList.get(this.instructionList.size() - 1);
        last.instruction = instruction;
        instruction.location = last;
        int nextCodeAddress = last.codeAddress + instruction.getCodeUnits();
        this.instructionList.add(new MethodLocation(null, nextCodeAddress, this.instructionList.size()));
        this.fixInstructions = true;
    }

    public void replaceInstruction(int index, BuilderInstruction replacementInstruction) {
        MethodLocation replaceLocation;
        if (index >= this.instructionList.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        replacementInstruction.location = replaceLocation = this.instructionList.get(index);
        BuilderInstruction old = replaceLocation.instruction;
        assert (old != null);
        old.location = null;
        replaceLocation.instruction = replacementInstruction;
        int codeAddress = replaceLocation.codeAddress + replaceLocation.instruction.getCodeUnits();
        for (int i = index + 1; i < this.instructionList.size(); ++i) {
            MethodLocation location = this.instructionList.get(i);
            location.codeAddress = codeAddress;
            Instruction instruction = location.getInstruction();
            if (instruction != null) {
                codeAddress += instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    public void removeInstruction(int index) {
        if (index >= this.instructionList.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        MethodLocation toRemove = this.instructionList.get(index);
        toRemove.instruction = null;
        MethodLocation next = this.instructionList.get(index + 1);
        toRemove.mergeInto(next);
        this.instructionList.remove(index);
        int codeAddress = toRemove.codeAddress;
        for (int i = index; i < this.instructionList.size(); ++i) {
            MethodLocation location = this.instructionList.get(i);
            location.index = i;
            location.codeAddress = codeAddress;
            Instruction instruction = location.getInstruction();
            if (instruction != null) {
                codeAddress += instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    private BuilderInstruction getFirstNonNop(int startIndex) {
        for (int i = startIndex; i < this.instructionList.size() - 1; ++i) {
            BuilderInstruction instruction = this.instructionList.get((int)i).instruction;
            assert (instruction != null);
            if (instruction.getOpcode() == Opcode.NOP) continue;
            return instruction;
        }
        return null;
    }

    private void fixInstructions() {
        boolean madeChanges;
        HashSet<MethodLocation> payloadLocations = Sets.newHashSet();
        for (MethodLocation location : this.instructionList) {
            BuilderInstruction instruction = location.instruction;
            if (instruction == null) continue;
            switch (instruction.getOpcode()) {
                case SPARSE_SWITCH: 
                case PACKED_SWITCH: {
                    MethodLocation targetLocation = ((BuilderOffsetInstruction)instruction).getTarget().getLocation();
                    BuilderInstruction targetInstruction = targetLocation.instruction;
                    if (targetInstruction == null) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d points to the end of the method.", location.codeAddress, location.index));
                    }
                    if (targetInstruction.getOpcode() == Opcode.NOP) {
                        targetInstruction = this.getFirstNonNop(targetLocation.index + 1);
                    }
                    if (targetInstruction == null || !(targetInstruction instanceof BuilderSwitchPayload)) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d does not refer to a payload instruction.", location.codeAddress, location.index));
                    }
                    if (instruction.opcode == Opcode.PACKED_SWITCH && targetInstruction.getOpcode() != Opcode.PACKED_SWITCH_PAYLOAD || instruction.opcode == Opcode.SPARSE_SWITCH && targetInstruction.getOpcode() != Opcode.SPARSE_SWITCH_PAYLOAD) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d refers to the wrong type of payload instruction.", location.codeAddress, location.index));
                    }
                    if (!payloadLocations.add(targetLocation)) {
                        throw new IllegalStateException("Multiple switch instructions refer to the same payload. This is not currently supported. Please file a bug :)");
                    }
                    ((BuilderSwitchPayload)targetInstruction).referrer = location;
                    break;
                }
            }
        }
        do {
            madeChanges = false;
            block11: for (int index = 0; index < this.instructionList.size(); ++index) {
                MethodLocation location = this.instructionList.get(index);
                BuilderInstruction instruction = location.instruction;
                if (instruction == null) continue;
                switch (instruction.getOpcode()) {
                    case GOTO: {
                        int offset = ((BuilderOffsetInstruction)instruction).internalGetCodeOffset();
                        if (offset >= -128 && offset <= 127) continue block11;
                        BuilderOffsetInstruction replacement = offset < Short.MIN_VALUE || offset > Short.MAX_VALUE ? new BuilderInstruction30t(Opcode.GOTO_32, ((BuilderOffsetInstruction)instruction).getTarget()) : new BuilderInstruction20t(Opcode.GOTO_16, ((BuilderOffsetInstruction)instruction).getTarget());
                        this.replaceInstruction(location.index, replacement);
                        madeChanges = true;
                        continue block11;
                    }
                    case GOTO_16: {
                        int offset = ((BuilderOffsetInstruction)instruction).internalGetCodeOffset();
                        if (offset >= Short.MIN_VALUE && offset <= Short.MAX_VALUE) continue block11;
                        BuilderOffsetInstruction replacement = new BuilderInstruction30t(Opcode.GOTO_32, ((BuilderOffsetInstruction)instruction).getTarget());
                        this.replaceInstruction(location.index, replacement);
                        madeChanges = true;
                        continue block11;
                    }
                    case SPARSE_SWITCH_PAYLOAD: 
                    case PACKED_SWITCH_PAYLOAD: {
                        if (((BuilderSwitchPayload)instruction).referrer == null) {
                            this.removeInstruction(index);
                            --index;
                            madeChanges = true;
                            continue block11;
                        }
                    }
                    case ARRAY_PAYLOAD: {
                        if ((location.codeAddress & 1) == 0) continue block11;
                        int previousIndex = location.index - 1;
                        MethodLocation previousLocation = this.instructionList.get(previousIndex);
                        BuilderInstruction previousInstruction = previousLocation.instruction;
                        assert (previousInstruction != null);
                        if (previousInstruction.getOpcode() == Opcode.NOP) {
                            this.removeInstruction(previousIndex);
                            --index;
                        } else {
                            this.addInstruction(location.index, new BuilderInstruction10x(Opcode.NOP));
                            ++index;
                        }
                        madeChanges = true;
                    }
                }
            }
        } while (madeChanges);
        this.fixInstructions = false;
    }

    private int mapCodeAddressToIndex(int[] codeAddressToIndex, int codeAddress) {
        int index;
        while (true) {
            if (codeAddress >= codeAddressToIndex.length) {
                codeAddress = codeAddressToIndex.length - 1;
            }
            if ((index = codeAddressToIndex[codeAddress]) >= 0) break;
            --codeAddress;
        }
        return index;
    }

    private Label newLabel(int[] codeAddressToIndex, int codeAddress) {
        MethodLocation referent = this.instructionList.get(this.mapCodeAddressToIndex(codeAddressToIndex, codeAddress));
        return referent.addNewLabel();
    }

    public Label newSwitchPayloadReferenceLabel(MethodLocation switchLocation, int[] codeAddressToIndex, int codeAddress) {
        MethodLocation referent = this.instructionList.get(this.mapCodeAddressToIndex(codeAddressToIndex, codeAddress));
        SwitchPayloadReferenceLabel label = new SwitchPayloadReferenceLabel();
        label.switchLocation = switchLocation;
        referent.getLabels().add(label);
        return label;
    }

    private void setInstruction(MethodLocation location, BuilderInstruction instruction) {
        location.instruction = instruction;
        instruction.location = location;
    }

    private void convertAndSetInstruction(MethodLocation location, int[] codeAddressToIndex, Instruction instruction) {
        switch (instruction.getOpcode().format) {
            case Format10t: {
                this.setInstruction(location, this.newBuilderInstruction10t(location.codeAddress, codeAddressToIndex, (Instruction10t)instruction));
                return;
            }
            case Format10x: {
                this.setInstruction(location, this.newBuilderInstruction10x((Instruction10x)instruction));
                return;
            }
            case Format11n: {
                this.setInstruction(location, this.newBuilderInstruction11n((Instruction11n)instruction));
                return;
            }
            case Format11x: {
                this.setInstruction(location, this.newBuilderInstruction11x((Instruction11x)instruction));
                return;
            }
            case Format12x: {
                this.setInstruction(location, this.newBuilderInstruction12x((Instruction12x)instruction));
                return;
            }
            case Format20bc: {
                this.setInstruction(location, this.newBuilderInstruction20bc((Instruction20bc)instruction));
                return;
            }
            case Format20t: {
                this.setInstruction(location, this.newBuilderInstruction20t(location.codeAddress, codeAddressToIndex, (Instruction20t)instruction));
                return;
            }
            case Format21c: {
                this.setInstruction(location, this.newBuilderInstruction21c((Instruction21c)instruction));
                return;
            }
            case Format21ih: {
                this.setInstruction(location, this.newBuilderInstruction21ih((Instruction21ih)instruction));
                return;
            }
            case Format21lh: {
                this.setInstruction(location, this.newBuilderInstruction21lh((Instruction21lh)instruction));
                return;
            }
            case Format21s: {
                this.setInstruction(location, this.newBuilderInstruction21s((Instruction21s)instruction));
                return;
            }
            case Format21t: {
                this.setInstruction(location, this.newBuilderInstruction21t(location.codeAddress, codeAddressToIndex, (Instruction21t)instruction));
                return;
            }
            case Format22b: {
                this.setInstruction(location, this.newBuilderInstruction22b((Instruction22b)instruction));
                return;
            }
            case Format22c: {
                this.setInstruction(location, this.newBuilderInstruction22c((Instruction22c)instruction));
                return;
            }
            case Format22cs: {
                this.setInstruction(location, this.newBuilderInstruction22cs((Instruction22cs)instruction));
                return;
            }
            case Format22s: {
                this.setInstruction(location, this.newBuilderInstruction22s((Instruction22s)instruction));
                return;
            }
            case Format22t: {
                this.setInstruction(location, this.newBuilderInstruction22t(location.codeAddress, codeAddressToIndex, (Instruction22t)instruction));
                return;
            }
            case Format22x: {
                this.setInstruction(location, this.newBuilderInstruction22x((Instruction22x)instruction));
                return;
            }
            case Format23x: {
                this.setInstruction(location, this.newBuilderInstruction23x((Instruction23x)instruction));
                return;
            }
            case Format30t: {
                this.setInstruction(location, this.newBuilderInstruction30t(location.codeAddress, codeAddressToIndex, (Instruction30t)instruction));
                return;
            }
            case Format31c: {
                this.setInstruction(location, this.newBuilderInstruction31c((Instruction31c)instruction));
                return;
            }
            case Format31i: {
                this.setInstruction(location, this.newBuilderInstruction31i((Instruction31i)instruction));
                return;
            }
            case Format31t: {
                this.setInstruction(location, this.newBuilderInstruction31t(location, codeAddressToIndex, (Instruction31t)instruction));
                return;
            }
            case Format32x: {
                this.setInstruction(location, this.newBuilderInstruction32x((Instruction32x)instruction));
                return;
            }
            case Format35c: {
                this.setInstruction(location, this.newBuilderInstruction35c((Instruction35c)instruction));
                return;
            }
            case Format35mi: {
                this.setInstruction(location, this.newBuilderInstruction35mi((Instruction35mi)instruction));
                return;
            }
            case Format35ms: {
                this.setInstruction(location, this.newBuilderInstruction35ms((Instruction35ms)instruction));
                return;
            }
            case Format3rc: {
                this.setInstruction(location, this.newBuilderInstruction3rc((Instruction3rc)instruction));
                return;
            }
            case Format3rmi: {
                this.setInstruction(location, this.newBuilderInstruction3rmi((Instruction3rmi)instruction));
                return;
            }
            case Format3rms: {
                this.setInstruction(location, this.newBuilderInstruction3rms((Instruction3rms)instruction));
                return;
            }
            case Format45cc: {
                this.setInstruction(location, this.newBuilderInstruction45cc((Instruction45cc)instruction));
                return;
            }
            case Format51l: {
                this.setInstruction(location, this.newBuilderInstruction51l((Instruction51l)instruction));
                return;
            }
            case PackedSwitchPayload: {
                this.setInstruction(location, this.newBuilderPackedSwitchPayload(location, codeAddressToIndex, (PackedSwitchPayload)instruction));
                return;
            }
            case SparseSwitchPayload: {
                this.setInstruction(location, this.newBuilderSparseSwitchPayload(location, codeAddressToIndex, (SparseSwitchPayload)instruction));
                return;
            }
            case ArrayPayload: {
                this.setInstruction(location, this.newBuilderArrayPayload((ArrayPayload)instruction));
                return;
            }
        }
        throw new ExceptionWithContext("Instruction format %s not supported", new Object[]{instruction.getOpcode().format});
    }

    private BuilderInstruction10t newBuilderInstruction10t(int codeAddress, int[] codeAddressToIndex, Instruction10t instruction) {
        return new BuilderInstruction10t(instruction.getOpcode(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
    }

    private BuilderInstruction10x newBuilderInstruction10x(Instruction10x instruction) {
        return new BuilderInstruction10x(instruction.getOpcode());
    }

    private BuilderInstruction11n newBuilderInstruction11n(Instruction11n instruction) {
        return new BuilderInstruction11n(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
    }

    private BuilderInstruction11x newBuilderInstruction11x(Instruction11x instruction) {
        return new BuilderInstruction11x(instruction.getOpcode(), instruction.getRegisterA());
    }

    private BuilderInstruction12x newBuilderInstruction12x(Instruction12x instruction) {
        return new BuilderInstruction12x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB());
    }

    private BuilderInstruction20bc newBuilderInstruction20bc(Instruction20bc instruction) {
        return new BuilderInstruction20bc(instruction.getOpcode(), instruction.getVerificationError(), instruction.getReference());
    }

    private BuilderInstruction20t newBuilderInstruction20t(int codeAddress, int[] codeAddressToIndex, Instruction20t instruction) {
        return new BuilderInstruction20t(instruction.getOpcode(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
    }

    private BuilderInstruction21c newBuilderInstruction21c(Instruction21c instruction) {
        return new BuilderInstruction21c(instruction.getOpcode(), instruction.getRegisterA(), instruction.getReference());
    }

    private BuilderInstruction21ih newBuilderInstruction21ih(Instruction21ih instruction) {
        return new BuilderInstruction21ih(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
    }

    private BuilderInstruction21lh newBuilderInstruction21lh(Instruction21lh instruction) {
        return new BuilderInstruction21lh(instruction.getOpcode(), instruction.getRegisterA(), instruction.getWideLiteral());
    }

    private BuilderInstruction21s newBuilderInstruction21s(Instruction21s instruction) {
        return new BuilderInstruction21s(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
    }

    private BuilderInstruction21t newBuilderInstruction21t(int codeAddress, int[] codeAddressToIndex, Instruction21t instruction) {
        return new BuilderInstruction21t(instruction.getOpcode(), instruction.getRegisterA(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
    }

    private BuilderInstruction22b newBuilderInstruction22b(Instruction22b instruction) {
        return new BuilderInstruction22b(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getNarrowLiteral());
    }

    private BuilderInstruction22c newBuilderInstruction22c(Instruction22c instruction) {
        return new BuilderInstruction22c(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getReference());
    }

    private BuilderInstruction22cs newBuilderInstruction22cs(Instruction22cs instruction) {
        return new BuilderInstruction22cs(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getFieldOffset());
    }

    private BuilderInstruction22s newBuilderInstruction22s(Instruction22s instruction) {
        return new BuilderInstruction22s(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getNarrowLiteral());
    }

    private BuilderInstruction22t newBuilderInstruction22t(int codeAddress, int[] codeAddressToIndex, Instruction22t instruction) {
        return new BuilderInstruction22t(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
    }

    private BuilderInstruction22x newBuilderInstruction22x(Instruction22x instruction) {
        return new BuilderInstruction22x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB());
    }

    private BuilderInstruction23x newBuilderInstruction23x(Instruction23x instruction) {
        return new BuilderInstruction23x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getRegisterC());
    }

    private BuilderInstruction30t newBuilderInstruction30t(int codeAddress, int[] codeAddressToIndex, Instruction30t instruction) {
        return new BuilderInstruction30t(instruction.getOpcode(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
    }

    private BuilderInstruction31c newBuilderInstruction31c(Instruction31c instruction) {
        return new BuilderInstruction31c(instruction.getOpcode(), instruction.getRegisterA(), instruction.getReference());
    }

    private BuilderInstruction31i newBuilderInstruction31i(Instruction31i instruction) {
        return new BuilderInstruction31i(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
    }

    private BuilderInstruction31t newBuilderInstruction31t(MethodLocation location, int[] codeAddressToIndex, Instruction31t instruction) {
        int codeAddress = location.getCodeAddress();
        Label newLabel = instruction.getOpcode() != Opcode.FILL_ARRAY_DATA ? this.newSwitchPayloadReferenceLabel(location, codeAddressToIndex, codeAddress + instruction.getCodeOffset()) : this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset());
        return new BuilderInstruction31t(instruction.getOpcode(), instruction.getRegisterA(), newLabel);
    }

    private BuilderInstruction32x newBuilderInstruction32x(Instruction32x instruction) {
        return new BuilderInstruction32x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB());
    }

    private BuilderInstruction35c newBuilderInstruction35c(Instruction35c instruction) {
        return new BuilderInstruction35c(instruction.getOpcode(), instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getReference());
    }

    private BuilderInstruction35mi newBuilderInstruction35mi(Instruction35mi instruction) {
        return new BuilderInstruction35mi(instruction.getOpcode(), instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getInlineIndex());
    }

    private BuilderInstruction35ms newBuilderInstruction35ms(Instruction35ms instruction) {
        return new BuilderInstruction35ms(instruction.getOpcode(), instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getVtableIndex());
    }

    private BuilderInstruction3rc newBuilderInstruction3rc(Instruction3rc instruction) {
        return new BuilderInstruction3rc(instruction.getOpcode(), instruction.getStartRegister(), instruction.getRegisterCount(), instruction.getReference());
    }

    private BuilderInstruction3rmi newBuilderInstruction3rmi(Instruction3rmi instruction) {
        return new BuilderInstruction3rmi(instruction.getOpcode(), instruction.getStartRegister(), instruction.getRegisterCount(), instruction.getInlineIndex());
    }

    private BuilderInstruction3rms newBuilderInstruction3rms(Instruction3rms instruction) {
        return new BuilderInstruction3rms(instruction.getOpcode(), instruction.getStartRegister(), instruction.getRegisterCount(), instruction.getVtableIndex());
    }

    private BuilderInstruction45cc newBuilderInstruction45cc(Instruction45cc instruction) {
        return new BuilderInstruction45cc(instruction.getOpcode(), instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getReference(), instruction.getReference2());
    }

    private BuilderInstruction51l newBuilderInstruction51l(Instruction51l instruction) {
        return new BuilderInstruction51l(instruction.getOpcode(), instruction.getRegisterA(), instruction.getWideLiteral());
    }

    private MethodLocation findSwitchForPayload(MethodLocation payloadLocation) {
        MethodLocation location = payloadLocation;
        MethodLocation switchLocation = null;
        do {
            for (Label label : location.getLabels()) {
                if (!(label instanceof SwitchPayloadReferenceLabel)) continue;
                if (switchLocation != null) {
                    throw new IllegalStateException("Multiple switch instructions refer to the same payload. This is not currently supported. Please file a bug :)");
                }
                switchLocation = ((SwitchPayloadReferenceLabel)label).switchLocation;
            }
            if (location.index == 0) {
                return switchLocation;
            }
            location = this.instructionList.get(location.index - 1);
        } while (location.instruction != null && location.instruction.getOpcode() == Opcode.NOP);
        return switchLocation;
    }

    private BuilderPackedSwitchPayload newBuilderPackedSwitchPayload(MethodLocation location, int[] codeAddressToIndex, PackedSwitchPayload instruction) {
        List<? extends SwitchElement> switchElements = instruction.getSwitchElements();
        if (switchElements.size() == 0) {
            return new BuilderPackedSwitchPayload(0, null);
        }
        MethodLocation switchLocation = this.findSwitchForPayload(location);
        int baseAddress = switchLocation == null ? 0 : switchLocation.codeAddress;
        ArrayList<Label> labels = Lists.newArrayList();
        for (SwitchElement switchElement : switchElements) {
            labels.add(this.newLabel(codeAddressToIndex, switchElement.getOffset() + baseAddress));
        }
        return new BuilderPackedSwitchPayload(switchElements.get(0).getKey(), labels);
    }

    private BuilderSparseSwitchPayload newBuilderSparseSwitchPayload(MethodLocation location, int[] codeAddressToIndex, SparseSwitchPayload instruction) {
        List<? extends SwitchElement> switchElements = instruction.getSwitchElements();
        if (switchElements.size() == 0) {
            return new BuilderSparseSwitchPayload(null);
        }
        MethodLocation switchLocation = this.findSwitchForPayload(location);
        int baseAddress = switchLocation == null ? 0 : switchLocation.codeAddress;
        ArrayList<SwitchLabelElement> labelElements = Lists.newArrayList();
        for (SwitchElement switchElement : switchElements) {
            labelElements.add(new SwitchLabelElement(switchElement.getKey(), this.newLabel(codeAddressToIndex, switchElement.getOffset() + baseAddress)));
        }
        return new BuilderSparseSwitchPayload(labelElements);
    }

    private BuilderArrayPayload newBuilderArrayPayload(ArrayPayload instruction) {
        return new BuilderArrayPayload(instruction.getElementWidth(), instruction.getArrayElements());
    }

    private BuilderDebugItem convertDebugItem(DebugItem debugItem) {
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                return new BuilderStartLocal(startLocal.getRegister(), startLocal.getNameReference(), startLocal.getTypeReference(), startLocal.getSignatureReference());
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                return new BuilderEndLocal(endLocal.getRegister());
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                return new BuilderRestartLocal(restartLocal.getRegister());
            }
            case 7: {
                return new BuilderPrologueEnd();
            }
            case 8: {
                return new BuilderEpilogueBegin();
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                return new BuilderLineNumber(lineNumber.getLineNumber());
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                return new BuilderSetSourceFile(setSourceFile.getSourceFileReference());
            }
        }
        throw new ExceptionWithContext("Invalid debug item type: " + debugItem.getDebugItemType(), new Object[0]);
    }

    private static class SwitchPayloadReferenceLabel
    extends Label {
        public MethodLocation switchLocation;

        private SwitchPayloadReferenceLabel() {
        }
    }

    private static interface Task {
        public void perform();
    }
}

