#
# PySNMP MIB module BACS2-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/BACS2-MIB
# Produced by pysmi-0.3.4 at Thu Jun  4 17:32:17 2020
# On host tide platform Linux version 5.6.14-300.fc32.x86_64 by user spider
# Using Python version 3.8.3 (default, May 15 2020, 00:00:00) 
#
OctetString, ObjectIdentifier, Integer = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ConstraintsUnion, ConstraintsIntersection, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ConstraintsIntersection", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
ObjectGroup, NotificationGroup, ModuleCompliance = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
Integer32, MibIdentifier, Counter32, Counter64, iso, IpAddress, MibScalar, MibTable, MibTableRow, MibTableColumn, ModuleIdentity, Bits, TimeTicks, Unsigned32, ObjectIdentity, Gauge32, NotificationType = mibBuilder.importSymbols("SNMPv2-SMI", "Integer32", "MibIdentifier", "Counter32", "Counter64", "iso", "IpAddress", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "ModuleIdentity", "Bits", "TimeTicks", "Unsigned32", "ObjectIdentity", "Gauge32", "NotificationType")
TimeStamp, TextualConvention, AutonomousType, DisplayString = mibBuilder.importSymbols("SNMPv2-TC", "TimeStamp", "TextualConvention", "AutonomousType", "DisplayString")
class PositiveInteger(TextualConvention, Integer32):
    description = 'This data type is a non-zero and non-negative value.'
    status = 'current'
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(1, 2147483647)

class NonNegativeInteger(TextualConvention, Integer32):
    description = 'This data type is a non-negative value.'
    status = 'current'
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(0, 2147483647)

org = MibIdentifier((1, 3))
dod = MibIdentifier((1, 3, 6))
internet = MibIdentifier((1, 3, 6, 1))
mgmt = MibIdentifier((1, 3, 6, 1, 2))
mib_2 = MibIdentifier((1, 3, 6, 1, 2, 1)).setLabel("mib-2")
upsMIB = MibIdentifier((1, 3, 6, 1, 2, 1, 33))
bacs2 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 5))
bacsSettings = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 5, 1))
bacsModuleType = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1, 10, 20))).clone(namedValues=NamedValues(("c20", 0), ("c21", 1), ("c30", 10), ("c40", 20)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleType.setStatus('current')
if mibBuilder.loadTexts: bacsModuleType.setDescription('BACS Module Type. (0=C20, 1=C21, 10=C30, 20=C40)')
bacsNumStrings = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 2), NonNegativeInteger()).setUnits('strings').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsNumStrings.setStatus('current')
if mibBuilder.loadTexts: bacsNumStrings.setDescription('Number of battery strings.')
bacsNumBatteries = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 3), NonNegativeInteger()).setUnits('batteries').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsNumBatteries.setStatus('current')
if mibBuilder.loadTexts: bacsNumBatteries.setDescription('Total number of batteries.')
bacsBattCap = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 4), PositiveInteger()).setUnits('Ah').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsBattCap.setStatus('current')
if mibBuilder.loadTexts: bacsBattCap.setDescription('Capacity of installed batteries.')
bacsLogRate1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 5), PositiveInteger()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsLogRate1.setStatus('current')
if mibBuilder.loadTexts: bacsLogRate1.setDescription('Lograte during normal operation.')
bacsLogRate2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 6), PositiveInteger()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsLogRate2.setStatus('current')
if mibBuilder.loadTexts: bacsLogRate2.setDescription('Lograte during charge or discharge.')
bacsImpcPollRate = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 7), PositiveInteger()).setUnits('minutes').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsImpcPollRate.setStatus('current')
if mibBuilder.loadTexts: bacsImpcPollRate.setDescription('Pollrate internal impedance.')
bacsImpcLowAlarm = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 8), PositiveInteger()).setUnits('0.01 mOhm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsImpcLowAlarm.setStatus('current')
if mibBuilder.loadTexts: bacsImpcLowAlarm.setDescription('Impedance low alarm level.')
bacsImpcHighAlarm = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 9), PositiveInteger()).setUnits('0.01 mOhm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsImpcHighAlarm.setStatus('current')
if mibBuilder.loadTexts: bacsImpcHighAlarm.setDescription('Impedance low alarm level.')
bacsTemperatureLowAlarm = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 10), Integer32()).setUnits('0.1 deg of current temperature unit').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsTemperatureLowAlarm.setStatus('current')
if mibBuilder.loadTexts: bacsTemperatureLowAlarm.setDescription('Temperature alarm below this level.')
bacsTemperatureHighAlarm = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 11), Integer32()).setUnits('0.1 deg of current temperature unit').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsTemperatureHighAlarm.setStatus('current')
if mibBuilder.loadTexts: bacsTemperatureHighAlarm.setDescription('Temperature alarm above this level.')
bacsVoltageLowAlarm = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 12), PositiveInteger()).setUnits('0.01 volt').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsVoltageLowAlarm.setStatus('current')
if mibBuilder.loadTexts: bacsVoltageLowAlarm.setDescription('Voltage alarm below this level.')
bacsVoltageHighAlarm = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 13), PositiveInteger()).setUnits('0.01 volt').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsVoltageHighAlarm.setStatus('current')
if mibBuilder.loadTexts: bacsVoltageHighAlarm.setDescription('Voltage alarm above this level.')
bacsImpcLowWarn = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 14), PositiveInteger()).setUnits('0.01 mOhm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsImpcLowWarn.setStatus('current')
if mibBuilder.loadTexts: bacsImpcLowWarn.setDescription('Impedance low warning level.')
bacsImpcHighWarn = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 15), PositiveInteger()).setUnits('0.01 mOhm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsImpcHighWarn.setStatus('current')
if mibBuilder.loadTexts: bacsImpcHighWarn.setDescription('Impedance high warning level.')
bacsTemperatureLowWarn = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 16), Integer32()).setUnits('0.1 deg of current temperature unit').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsTemperatureLowWarn.setStatus('current')
if mibBuilder.loadTexts: bacsTemperatureLowWarn.setDescription('Temperature warning below this level.')
bacsTemperatureHighWarn = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 17), Integer32()).setUnits('0.1 deg of current temperature unit').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsTemperatureHighWarn.setStatus('current')
if mibBuilder.loadTexts: bacsTemperatureHighWarn.setDescription('Temperature warning above this level.')
bacsVoltageLowWarn = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 18), PositiveInteger()).setUnits('0.01 volt').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsVoltageLowWarn.setStatus('current')
if mibBuilder.loadTexts: bacsVoltageLowWarn.setDescription('Voltage warning below this level.')
bacsVoltageHighWarn = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 19), PositiveInteger()).setUnits('0.01 volt').setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsVoltageHighWarn.setStatus('current')
if mibBuilder.loadTexts: bacsVoltageHighWarn.setDescription('Voltage warning above this level.')
bacsTemperatureUnit = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 1, 20), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("celsius", 0), ("fahrenheit", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bacsTemperatureUnit.setStatus('current')
if mibBuilder.loadTexts: bacsTemperatureUnit.setDescription('Temperature unit currently in use. (0=Celsius, 1=Fahrenheit)')
bacsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 5, 2))
bacsStatus = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 2, 1), PositiveInteger()).setUnits('HEX flags').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsStatus.setStatus('current')
if mibBuilder.loadTexts: bacsStatus.setDescription('BACS System Status Flags.')
bacsAvModuleVolt = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 2, 2), PositiveInteger()).setUnits('0.01 Volt').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsAvModuleVolt.setStatus('current')
if mibBuilder.loadTexts: bacsAvModuleVolt.setDescription('Average module voltage.')
bacsTotalVolt = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 2, 3), PositiveInteger()).setUnits('0.01 Volt').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsTotalVolt.setStatus('current')
if mibBuilder.loadTexts: bacsTotalVolt.setDescription('Total voltage of all modules.')
bacsNumModules = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 2, 4), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsNumModules.setStatus('current')
if mibBuilder.loadTexts: bacsNumModules.setDescription('The number of installed battery modules.')
bacsModuleTable = MibTable((1, 3, 6, 1, 2, 1, 33, 5, 2, 5), )
if mibBuilder.loadTexts: bacsModuleTable.setStatus('current')
if mibBuilder.loadTexts: bacsModuleTable.setDescription('The list of battery table entries.')
bacsModuleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 5, 2, 5, 1), ).setIndexNames((0, "BACS2-MIB", "bacsModuleIndex"))
if mibBuilder.loadTexts: bacsModuleEntry.setStatus('current')
if mibBuilder.loadTexts: bacsModuleEntry.setDescription('An entry containing information applicable to a particular battery.')
bacsModuleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 5, 1, 1), PositiveInteger())
if mibBuilder.loadTexts: bacsModuleIndex.setStatus('current')
if mibBuilder.loadTexts: bacsModuleIndex.setDescription('The module identifier.')
bacsModuleVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 5, 1, 2), PositiveInteger()).setUnits('0.01 volt').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleVoltage.setStatus('current')
if mibBuilder.loadTexts: bacsModuleVoltage.setDescription('The module voltage.')
bacsModuleTemperature = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 5, 1, 3), Integer32()).setUnits('0.1 degrees of current temperature unit').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleTemperature.setStatus('current')
if mibBuilder.loadTexts: bacsModuleTemperature.setDescription('The module temperature.')
bacsModuleBypass = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 5, 1, 4), NonNegativeInteger()).setUnits('0.1 percent').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleBypass.setStatus('current')
if mibBuilder.loadTexts: bacsModuleBypass.setDescription('The module bypass voltage.')
bacsModuleResistance = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 5, 1, 5), NonNegativeInteger()).setUnits('0.01 mOhm').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleResistance.setStatus('current')
if mibBuilder.loadTexts: bacsModuleResistance.setDescription('The module impedance.')
bacsModuleState = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 5, 1, 6), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleState.setStatus('current')
if mibBuilder.loadTexts: bacsModuleState.setDescription('The module alarm flags(0x0=No Alarm, 0x1=General Alarm, 0x2=System Failure, 0x4=Voltage High Alarm, 0x8=Voltage Low Alarm, 0x10=Temperature High Alarm, 0x20=Temperature Low Alarm, 0x40=Resistor High Alarm, 0x80=Resistor Low Alarm, 0x100=Equalizing Error Alarm, 0x200=Voltage High Warning, 0x400=Voltage Low Warning, 0x800=Temperature High Warning, 0x1000=Temperature Low Warning, 0x2000=Resistor High Warning, 0x4000=Resistor Low Warning, 0x8000=Incompatible Module Rev).')
bacsNumBatStrings = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 2, 6), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsNumBatStrings.setStatus('current')
if mibBuilder.loadTexts: bacsNumBatStrings.setDescription('The number of installed battery strings.')
bacsStringTable = MibTable((1, 3, 6, 1, 2, 1, 33, 5, 2, 7), )
if mibBuilder.loadTexts: bacsStringTable.setStatus('current')
if mibBuilder.loadTexts: bacsStringTable.setDescription('The list of stringy table entries.')
bacsStringEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 5, 2, 7, 1), ).setIndexNames((0, "BACS2-MIB", "bacsStringIndex"))
if mibBuilder.loadTexts: bacsStringEntry.setStatus('current')
if mibBuilder.loadTexts: bacsStringEntry.setDescription('An entry containing information applicable to a particular string of batteries.')
bacsStringIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 7, 1, 1), PositiveInteger())
if mibBuilder.loadTexts: bacsStringIndex.setStatus('current')
if mibBuilder.loadTexts: bacsStringIndex.setDescription('The string identifier.')
bacsStringCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 7, 1, 2), PositiveInteger()).setUnits('0.01 ampere').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsStringCurrent.setStatus('current')
if mibBuilder.loadTexts: bacsStringCurrent.setDescription('The string current.')
bacsStringTotalVolt = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 7, 1, 3), PositiveInteger()).setUnits('0.01 volt').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsStringTotalVolt.setStatus('current')
if mibBuilder.loadTexts: bacsStringTotalVolt.setDescription('The string total voltage.')
bacsStringAverageVolt = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 2, 7, 1, 4), PositiveInteger()).setUnits('0.01 volt').setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsStringAverageVolt.setStatus('current')
if mibBuilder.loadTexts: bacsStringAverageVolt.setDescription('The string average voltage per battery.')
bacsAlarms = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 5, 3))
bacsAlarmsPresent = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 3, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsAlarmsPresent.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmsPresent.setDescription('The present number of active alarm conditions.')
bacsAlarmTable = MibTable((1, 3, 6, 1, 2, 1, 33, 5, 3, 2), )
if mibBuilder.loadTexts: bacsAlarmTable.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmTable.setDescription('A list of alarm entries.')
bacsAlarmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 5, 3, 2, 1), ).setIndexNames((0, "BACS2-MIB", "bacsAlarmId"))
if mibBuilder.loadTexts: bacsAlarmEntry.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmEntry.setDescription('An entry containing information applicable to a particular alarm.')
bacsAlarmId = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 3, 2, 1, 1), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsAlarmId.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmId.setDescription('A unique identifier for an alarm condition. This value must remain constant.')
bacsAlarmDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 3, 2, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsAlarmDescr.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmDescr.setDescription('A reference to an alarm description object. The object referenced should not be accessible, but rather be used to provide a unique description of the alarm condition.')
bacsAlarmTime = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 5, 3, 2, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsAlarmTime.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmTime.setDescription('The value of sysUpTime when the alarm condition was detected. If the alarm condition was detected at the time of agent startup and presumably existed before agent startup, the value of dcAlarmTime shall equal 0.')
bacsWellKnownAlarms = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 5, 3, 3))
bacsAlarmSystemError = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 1))
if mibBuilder.loadTexts: bacsAlarmSystemError.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmSystemError.setDescription('This object indicates a communication problem from the agent to one or more of the battery modules.')
bacsAlarmResistWarn = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 2))
if mibBuilder.loadTexts: bacsAlarmResistWarn.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmResistWarn.setDescription('This object indicates that the internal restiance of one or more batteries is above the warning level.')
bacsAlarmResistAlarm = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 3))
if mibBuilder.loadTexts: bacsAlarmResistAlarm.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmResistAlarm.setDescription('This object indicates that the internal restiance of one or more batteries is above the alarm level.')
bacsAlarmVoltage = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 4))
if mibBuilder.loadTexts: bacsAlarmVoltage.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmVoltage.setDescription('This object indicates that the voltage of one or more batteries is outside the defined rage.')
bacsAlarmTemperature = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 5))
if mibBuilder.loadTexts: bacsAlarmTemperature.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmTemperature.setDescription('This object indicates that the temperature of one or more batteries is outside the defined range.')
bacsAlarmVoltageHigh = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 6))
if mibBuilder.loadTexts: bacsAlarmVoltageHigh.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmVoltageHigh.setDescription('This object indicates that the voltage of one or more batteries is higher than the defined range.')
bacsAlarmVoltageLow = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 7))
if mibBuilder.loadTexts: bacsAlarmVoltageLow.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmVoltageLow.setDescription('This object indicates that the voltage of one or more batteries is lower than the defined range.')
bacsAlarmTemperatureHigh = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 8))
if mibBuilder.loadTexts: bacsAlarmTemperatureHigh.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmTemperatureHigh.setDescription('This object indicates that the temperature of one or more batteries is higher than the defined range.')
bacsAlarmTemperatureLow = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 9))
if mibBuilder.loadTexts: bacsAlarmTemperatureLow.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmTemperatureLow.setDescription('This object indicates that the temperature of one or more batteries is lower than the defined range.')
bacsAlarmResistAlarmHigh = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 10))
if mibBuilder.loadTexts: bacsAlarmResistAlarmHigh.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmResistAlarmHigh.setDescription('This object indicates that the internal restiance of one or more batteries is above the alarm level.')
bacsAlarmResistAlarmLow = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 11))
if mibBuilder.loadTexts: bacsAlarmResistAlarmLow.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmResistAlarmLow.setDescription('This object indicates that the internal restiance of one or more batteries is below the alarm level.')
bacsAlarmEqualizing = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 12))
if mibBuilder.loadTexts: bacsAlarmEqualizing.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmEqualizing.setDescription('This object indicates that there is an error with Equalizing.')
bacsAlarmVoltageWarnHigh = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 13))
if mibBuilder.loadTexts: bacsAlarmVoltageWarnHigh.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmVoltageWarnHigh.setDescription('This object indicates that the voltage of one or more batteries is higher than the defined warning range.')
bacsAlarmVoltageWarnLow = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 14))
if mibBuilder.loadTexts: bacsAlarmVoltageWarnLow.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmVoltageWarnLow.setDescription('This object indicates that the voltage of one or more batteries is lower than the defined warning range.')
bacsAlarmTemperatureWarnHigh = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 15))
if mibBuilder.loadTexts: bacsAlarmTemperatureWarnHigh.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmTemperatureWarnHigh.setDescription('This object indicates that the Temperature of one or more batteries is higher than the defined warning range.')
bacsAlarmTemperatureWarnLow = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 16))
if mibBuilder.loadTexts: bacsAlarmTemperatureWarnLow.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmTemperatureWarnLow.setDescription('This object indicates that the Temperature of one or more batteries is lower than the defined warning range.')
bacsAlarmResistWarnHigh = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 17))
if mibBuilder.loadTexts: bacsAlarmResistWarnHigh.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmResistWarnHigh.setDescription('This object indicates that the internal restiance of one or more batteries is higher than the defined warning range.')
bacsAlarmResistWarnLow = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 18))
if mibBuilder.loadTexts: bacsAlarmResistWarnLow.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmResistWarnLow.setDescription('This object indicates that the internal restiance of one or more batteries is lower than the defined warning range.')
bacsAlarmInitializing = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 19))
if mibBuilder.loadTexts: bacsAlarmInitializing.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmInitializing.setDescription('Bacs Alarm Initializing .')
bacsAlarmCommunicationLost = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 20))
if mibBuilder.loadTexts: bacsAlarmCommunicationLost.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmCommunicationLost.setDescription('Bacs Alarm Communication Lost .')
bacsAlarmBatteryBreakerOpen = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 21))
if mibBuilder.loadTexts: bacsAlarmBatteryBreakerOpen.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmBatteryBreakerOpen.setDescription('Bacs Alarm Battery Breaker Open .')
bacsAlarmThermalRunaway = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 22))
if mibBuilder.loadTexts: bacsAlarmThermalRunaway.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmThermalRunaway.setDescription('Bacs Alarm Thermal Runaway.')
bacsAlarmSensorCommunicationLost = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 23))
if mibBuilder.loadTexts: bacsAlarmSensorCommunicationLost.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmSensorCommunicationLost.setDescription('Bacs Alarm Sensor Communication Lost .')
bacsAlarmDischarging = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 24))
if mibBuilder.loadTexts: bacsAlarmDischarging.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmDischarging.setDescription('Bacs Alarm Discharging .')
bacsAlarmDischargingStopped = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 25))
if mibBuilder.loadTexts: bacsAlarmDischargingStopped.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmDischargingStopped.setDescription('Bacs Alarm Discharging Stopped .')
bacsAlarmMaxVoltageDiff = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 5, 3, 3, 26))
if mibBuilder.loadTexts: bacsAlarmMaxVoltageDiff.setStatus('current')
if mibBuilder.loadTexts: bacsAlarmMaxVoltageDiff.setDescription('Bacs Alarm Max Voltage difference.')
bacsModuleAlarmsPresent = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 3, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleAlarmsPresent.setStatus('current')
if mibBuilder.loadTexts: bacsModuleAlarmsPresent.setDescription('The number of BACS modules presently in an alarm state.')
bacsModuleWarningsPresent = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 3, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bacsModuleWarningsPresent.setStatus('current')
if mibBuilder.loadTexts: bacsModuleWarningsPresent.setDescription('The number of BACS modules presently in a warning state.')
bacsTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 5, 4))
bacsTrapAlarmEntryAdded = NotificationType((1, 3, 6, 1, 2, 1, 33, 5, 4, 1)).setObjects(("BACS2-MIB", "bacsAlarmId"), ("BACS2-MIB", "bacsAlarmDescr"))
if mibBuilder.loadTexts: bacsTrapAlarmEntryAdded.setStatus('current')
if mibBuilder.loadTexts: bacsTrapAlarmEntryAdded.setDescription('This trap is sent upon a alarm in the system appears.')
bacsTrapAlarmEntryRemoved = NotificationType((1, 3, 6, 1, 2, 1, 33, 5, 4, 2)).setObjects(("BACS2-MIB", "bacsAlarmId"), ("BACS2-MIB", "bacsAlarmDescr"))
if mibBuilder.loadTexts: bacsTrapAlarmEntryRemoved.setStatus('current')
if mibBuilder.loadTexts: bacsTrapAlarmEntryRemoved.setDescription('This trap is sent upon a alarm in the system disappears.')
gxRAUX = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 5, 5))
gxRAUX1Input1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Input1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Input1.setDescription('The gxRAUX 1 input1.')
gxRAUX1Input2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Input2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Input2.setDescription('The gxRAUX 1 input2.')
gxRAUX1Input3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Input3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Input3.setDescription('The gxRAUX 1 input3.')
gxRAUX1Input4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Input4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Input4.setDescription('The gxRAUX 1 input4.')
gxRAUX1Output1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Output1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Output1.setDescription('The gxRAUX 1 output1.')
gxRAUX1Output2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Output2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Output2.setDescription('The gxRAUX 1 output2.')
gxRAUX1Output3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Output3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Output3.setDescription('The gxRAUX 1 output3.')
gxRAUX1Output4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX1Output4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX1Output4.setDescription('The gxRAUX 1 output4.')
gxRAUX2Input1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Input1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Input1.setDescription('The gxRAUX 2 input1.')
gxRAUX2Input2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Input2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Input2.setDescription('The gxRAUX 2 input2.')
gxRAUX2Input3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Input3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Input3.setDescription('The gxRAUX 2 input3.')
gxRAUX2Input4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Input4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Input4.setDescription('The gxRAUX 2 input4.')
gxRAUX2Output1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 13), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Output1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Output1.setDescription('The gxRAUX 2 output1.')
gxRAUX2Output2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 14), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Output2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Output2.setDescription('The gxRAUX 2 output2.')
gxRAUX2Output3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 15), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Output3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Output3.setDescription('The gxRAUX 2 output3.')
gxRAUX2Output4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 16), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX2Output4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX2Output4.setDescription('The gxRAUX 2 output4.')
gxRAUX3Input1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 17), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Input1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Input1.setDescription('The gxRAUX 3 input1.')
gxRAUX3Input2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 18), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Input2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Input2.setDescription('The gxRAUX 3 input2.')
gxRAUX3Input3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 19), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Input3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Input3.setDescription('The gxRAUX 3 input3.')
gxRAUX3Input4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 20), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Input4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Input4.setDescription('The gxRAUX 3 input4.')
gxRAUX3Output1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Output1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Output1.setDescription('The gxRAUX 3 output1.')
gxRAUX3Output2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 22), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Output2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Output2.setDescription('The gxRAUX 3 output2.')
gxRAUX3Output3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 23), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Output3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Output3.setDescription('The gxRAUX 3 output3.')
gxRAUX3Output4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 24), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX3Output4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX3Output4.setDescription('The gxRAUX 3 output4.')
gxRAUX4Input1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 25), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Input1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Input1.setDescription('The gxRAUX 4 input1.')
gxRAUX4Input2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 26), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Input2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Input2.setDescription('The gxRAUX 4 input2.')
gxRAUX4Input3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 27), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Input3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Input3.setDescription('The gxRAUX 4 input3.')
gxRAUX4Input4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 28), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("alarm", 0), ("normal", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Input4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Input4.setDescription('The gxRAUX 4 input4.')
gxRAUX4Output1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 29), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("on", 1), ("off", 2)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Output1.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Output1.setDescription('The gxRAUX 4 output1.')
gxRAUX4Output2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 30), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("on", 1), ("off", 2)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Output2.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Output2.setDescription('The gxRAUX 4 output2.')
gxRAUX4Output3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 31), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("on", 1), ("off", 2)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Output3.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Output3.setDescription('The gxRAUX 4 output3.')
gxRAUX4Output4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 5, 5, 32), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("on", 1), ("off", 2)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gxRAUX4Output4.setStatus('current')
if mibBuilder.loadTexts: gxRAUX4Output4.setDescription('The gxRAUX 4 output4.')
mibBuilder.exportSymbols("BACS2-MIB", bacsAlarmResistWarnLow=bacsAlarmResistWarnLow, gxRAUX4Output3=gxRAUX4Output3, bacsAlarmSystemError=bacsAlarmSystemError, bacsVoltageLowWarn=bacsVoltageLowWarn, bacsImpcPollRate=bacsImpcPollRate, bacsAlarmInitializing=bacsAlarmInitializing, gxRAUX2Output3=gxRAUX2Output3, bacsAlarmVoltage=bacsAlarmVoltage, mgmt=mgmt, upsMIB=upsMIB, bacsTemperatureUnit=bacsTemperatureUnit, bacsAlarmTemperatureLow=bacsAlarmTemperatureLow, bacsStatus=bacsStatus, bacsLogRate2=bacsLogRate2, bacsAlarmTemperatureWarnLow=bacsAlarmTemperatureWarnLow, gxRAUX3Input3=gxRAUX3Input3, bacsAlarmId=bacsAlarmId, bacsImpcHighWarn=bacsImpcHighWarn, bacsModuleWarningsPresent=bacsModuleWarningsPresent, bacsModuleState=bacsModuleState, internet=internet, mib_2=mib_2, gxRAUX3Output4=gxRAUX3Output4, bacsAlarms=bacsAlarms, bacsAlarmDescr=bacsAlarmDescr, bacsAlarmTable=bacsAlarmTable, bacs2=bacs2, bacsModuleType=bacsModuleType, gxRAUX2Input4=gxRAUX2Input4, bacsAlarmTemperatureHigh=bacsAlarmTemperatureHigh, bacsAlarmResistAlarmLow=bacsAlarmResistAlarmLow, gxRAUX1Input2=gxRAUX1Input2, bacsVoltageLowAlarm=bacsVoltageLowAlarm, gxRAUX1Input1=gxRAUX1Input1, bacsAlarmVoltageWarnLow=bacsAlarmVoltageWarnLow, bacsTrapAlarmEntryRemoved=bacsTrapAlarmEntryRemoved, gxRAUX2Input1=gxRAUX2Input1, gxRAUX2Output4=gxRAUX2Output4, gxRAUX4Output4=gxRAUX4Output4, bacsAlarmTemperature=bacsAlarmTemperature, bacsVoltageHighWarn=bacsVoltageHighWarn, bacsLogRate1=bacsLogRate1, bacsAlarmVoltageWarnHigh=bacsAlarmVoltageWarnHigh, gxRAUX=gxRAUX, bacsAlarmThermalRunaway=bacsAlarmThermalRunaway, bacsStringTotalVolt=bacsStringTotalVolt, bacsAlarmEqualizing=bacsAlarmEqualizing, bacsAlarmTemperatureWarnHigh=bacsAlarmTemperatureWarnHigh, bacsAlarmEntry=bacsAlarmEntry, bacsStringTable=bacsStringTable, gxRAUX2Output1=gxRAUX2Output1, gxRAUX1Output1=gxRAUX1Output1, bacsAlarmTime=bacsAlarmTime, bacsTemperatureLowWarn=bacsTemperatureLowWarn, bacsAlarmDischargingStopped=bacsAlarmDischargingStopped, gxRAUX3Output2=gxRAUX3Output2, dod=dod, gxRAUX2Output2=gxRAUX2Output2, bacsAlarmVoltageLow=bacsAlarmVoltageLow, bacsAlarmResistWarnHigh=bacsAlarmResistWarnHigh, gxRAUX1Output2=gxRAUX1Output2, bacsAlarmVoltageHigh=bacsAlarmVoltageHigh, gxRAUX2Input3=gxRAUX2Input3, bacsAlarmResistAlarm=bacsAlarmResistAlarm, bacsTemperatureHighWarn=bacsTemperatureHighWarn, bacsAvModuleVolt=bacsAvModuleVolt, gxRAUX4Input1=gxRAUX4Input1, bacsBattCap=bacsBattCap, bacsNumModules=bacsNumModules, gxRAUX3Input2=gxRAUX3Input2, bacsTemperatureHighAlarm=bacsTemperatureHighAlarm, gxRAUX4Input3=gxRAUX4Input3, bacsSettings=bacsSettings, bacsModuleBypass=bacsModuleBypass, bacsAlarmSensorCommunicationLost=bacsAlarmSensorCommunicationLost, gxRAUX1Output4=gxRAUX1Output4, bacsModuleVoltage=bacsModuleVoltage, gxRAUX3Input4=gxRAUX3Input4, gxRAUX4Output1=gxRAUX4Output1, bacsObjects=bacsObjects, bacsStringCurrent=bacsStringCurrent, bacsTotalVolt=bacsTotalVolt, bacsAlarmResistWarn=bacsAlarmResistWarn, gxRAUX4Input4=gxRAUX4Input4, bacsNumStrings=bacsNumStrings, bacsWellKnownAlarms=bacsWellKnownAlarms, bacsImpcLowWarn=bacsImpcLowWarn, bacsStringAverageVolt=bacsStringAverageVolt, bacsAlarmBatteryBreakerOpen=bacsAlarmBatteryBreakerOpen, NonNegativeInteger=NonNegativeInteger, gxRAUX4Input2=gxRAUX4Input2, gxRAUX4Output2=gxRAUX4Output2, bacsAlarmsPresent=bacsAlarmsPresent, PositiveInteger=PositiveInteger, bacsModuleEntry=bacsModuleEntry, bacsModuleResistance=bacsModuleResistance, gxRAUX1Input3=gxRAUX1Input3, bacsModuleAlarmsPresent=bacsModuleAlarmsPresent, bacsStringEntry=bacsStringEntry, bacsImpcHighAlarm=bacsImpcHighAlarm, bacsModuleTemperature=bacsModuleTemperature, gxRAUX1Input4=gxRAUX1Input4, gxRAUX3Output3=gxRAUX3Output3, bacsTemperatureLowAlarm=bacsTemperatureLowAlarm, gxRAUX1Output3=gxRAUX1Output3, bacsModuleTable=bacsModuleTable, bacsImpcLowAlarm=bacsImpcLowAlarm, bacsStringIndex=bacsStringIndex, bacsAlarmDischarging=bacsAlarmDischarging, bacsAlarmMaxVoltageDiff=bacsAlarmMaxVoltageDiff, bacsModuleIndex=bacsModuleIndex, bacsNumBatteries=bacsNumBatteries, org=org, bacsAlarmResistAlarmHigh=bacsAlarmResistAlarmHigh, bacsTrapAlarmEntryAdded=bacsTrapAlarmEntryAdded, bacsAlarmCommunicationLost=bacsAlarmCommunicationLost, bacsNumBatStrings=bacsNumBatStrings, gxRAUX3Output1=gxRAUX3Output1, bacsTraps=bacsTraps, gxRAUX2Input2=gxRAUX2Input2, bacsVoltageHighAlarm=bacsVoltageHighAlarm, gxRAUX3Input1=gxRAUX3Input1)
