#
# PySNMP MIB module HOST-RESOURCES-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/HOST-RESOURCES-MIB
# Produced by pysmi-0.3.4 at Wed Jan 29 17:31:16 2020
# On host nerk platform Linux version 5.3.15-300.fc31.x86_64 by user spider
# Using Python version 3.7.5 (default, Oct 17 2019, 12:16:48) 
#
OctetString, Integer, ObjectIdentifier = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ConstraintsUnion, ConstraintsIntersection, ValueSizeConstraint, ValueRangeConstraint, SingleValueConstraint = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ConstraintsIntersection", "ValueSizeConstraint", "ValueRangeConstraint", "SingleValueConstraint")
InterfaceIndexOrZero, = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
ObjectGroup, ModuleCompliance, NotificationGroup = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
mib_2, ObjectIdentity, Counter32, NotificationType, Gauge32, TimeTicks, Unsigned32, Counter64, Integer32, Bits, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, IpAddress, ModuleIdentity, iso = mibBuilder.importSymbols("SNMPv2-SMI", "mib-2", "ObjectIdentity", "Counter32", "NotificationType", "Gauge32", "TimeTicks", "Unsigned32", "Counter64", "Integer32", "Bits", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "IpAddress", "ModuleIdentity", "iso")
TextualConvention, DisplayString, AutonomousType, TruthValue, DateAndTime = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString", "AutonomousType", "TruthValue", "DateAndTime")
hostResourcesMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 25, 7, 1))
hostResourcesMibModule.setRevisions(('2000-03-06 00:00', '1999-10-20 22:00',))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    if mibBuilder.loadTexts: hostResourcesMibModule.setRevisionsDescriptions(('Clarifications and bug fixes based on implementation experience. This revision was also reformatted in the SMIv2 format. The revisions made were: New RFC document standards: Added Copyright notice, updated introduction to SNMP Framework, updated references section, added reference to RFC 2119, and added a meaningful Security Considerations section. New IANA considerations section for registration of new types Conversion to new SMIv2 syntax for the following types and macros: Counter32, Integer32, Gauge32, MODULE-IDENTITY, OBJECT-TYPE, TEXTUAL-CONVENTION, OBJECT-IDENTITY, MODULE-COMPLIANCE, OBJECT-GROUP Used new Textual Conventions: TruthValue, DateAndTime, AutonomousType, InterfaceIndexOrZero Fixed typo in hrPrinterStatus. Added missing error bits to hrPrinterDetectedErrorState and clarified confusion resulting from suggested mappings to hrPrinterStatus. Clarified that size of objects of type InternationalDisplayString is number of octets, not number of encoded symbols. Clarified the use of the following objects based on implementation experience: hrSystemInitialLoadDevice, hrSystemInitialLoadParameters, hrMemorySize, hrStorageSize, hrStorageAllocationFailures, hrDeviceErrors, hrProcessorLoad, hrNetworkIfIndex, hrDiskStorageCapacity, hrSWRunStatus, hrSWRunPerfCPU, and hrSWInstalledDate. Clarified implementation technique for hrSWInstalledTable. Used new AUGMENTS clause for hrSWRunPerfTable. Added Internationalization Considerations section. This revision published as RFC2790.', 'The original version of this MIB, published as RFC1514.',))
if mibBuilder.loadTexts: hostResourcesMibModule.setLastUpdated('200003060000Z')
if mibBuilder.loadTexts: hostResourcesMibModule.setOrganization('IETF Host Resources MIB Working Group')
if mibBuilder.loadTexts: hostResourcesMibModule.setContactInfo('Steve Waldbusser Postal: Lucent Technologies, Inc. 1213 Innsbruck Dr. Sunnyvale, CA 94089 USA Phone: 650-318-1251 Fax: 650-318-1633 Email: waldbusser@lucent.com In addition, the Host Resources MIB mailing list is dedicated to discussion of this MIB. To join the mailing list, send a request message to hostmib-request@andrew.cmu.edu. The mailing list address is hostmib@andrew.cmu.edu.')
if mibBuilder.loadTexts: hostResourcesMibModule.setDescription("This MIB is for use in managing host systems. The term `host' is construed to mean any computer that communicates with other similar computers attached to the internet and that is directly used by one or more human beings. Although this MIB does not necessarily apply to devices whose primary function is communications services (e.g., terminal servers, routers, bridges, monitoring equipment), such relevance is not explicitly precluded. This MIB instruments attributes common to all internet hosts including, for example, both personal computers and systems that run variants of Unix.")
host = MibIdentifier((1, 3, 6, 1, 2, 1, 25))
hrSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 1))
hrStorage = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 2))
hrDevice = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3))
hrSWRun = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 4))
hrSWRunPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 5))
hrSWInstalled = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 6))
hrMIBAdminInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7))
class KBytes(TextualConvention, Integer32):
    description = 'Storage size, expressed in units of 1024 bytes.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(0, 2147483647)

class ProductID(TextualConvention, ObjectIdentifier):
    description = 'This textual convention is intended to identify the manufacturer, model, and version of a specific hardware or software product. It is suggested that these OBJECT IDENTIFIERs are allocated such that all products from a particular manufacturer are registered under a subtree distinct to that manufacturer. In addition, all versions of a product should be registered under a subtree distinct to that product. With this strategy, a management station may uniquely determine the manufacturer and/or model of a product whose productID is unknown to the management station. Objects of this type may be useful for inventory purposes or for automatically detecting incompatibilities or version mismatches between various hardware and software components on a system. For example, the product ID for the ACME 4860 66MHz clock doubled processor might be: enterprises.acme.acmeProcessors.a4860DX2.MHz66 A software product might be registered as: enterprises.acme.acmeOperatingSystems.acmeDOS.six(6).one(1) '
    status = 'current'

class InternationalDisplayString(TextualConvention, OctetString):
    description = 'This data type is used to model textual information in some character set. A network management station should use a local algorithm to determine which character set is in use and how it should be displayed. Note that this character set may be encoded with more than one octet per symbol, but will most often be NVT ASCII. When a size clause is specified for an object of this type, the size refers to the length in octets, not the number of symbols.'
    status = 'current'

hrSystemUptime = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 1), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemUptime.setStatus('current')
if mibBuilder.loadTexts: hrSystemUptime.setDescription('The amount of time since this host was last initialized. Note that this is different from sysUpTime in the SNMPv2-MIB [RFC1907] because sysUpTime is the uptime of the network management portion of the system.')
hrSystemDate = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 2), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemDate.setStatus('current')
if mibBuilder.loadTexts: hrSystemDate.setDescription("The host's notion of the local date and time of day.")
hrSystemInitialLoadDevice = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemInitialLoadDevice.setStatus('current')
if mibBuilder.loadTexts: hrSystemInitialLoadDevice.setDescription('The index of the hrDeviceEntry for the device from which this host is configured to load its initial operating system configuration (i.e., which operating system code and/or boot parameters). Note that writing to this object just changes the configuration that will be used the next time the operating system is loaded and does not actually cause the reload to occur.')
hrSystemInitialLoadParameters = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 4), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemInitialLoadParameters.setStatus('current')
if mibBuilder.loadTexts: hrSystemInitialLoadParameters.setDescription('This object contains the parameters (e.g. a pathname and parameter) supplied to the load device when requesting the initial operating system configuration from that device. Note that writing to this object just changes the configuration that will be used the next time the operating system is loaded and does not actually cause the reload to occur.')
hrSystemNumUsers = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemNumUsers.setStatus('current')
if mibBuilder.loadTexts: hrSystemNumUsers.setDescription('The number of user sessions for which this host is storing state information. A session is a collection of processes requiring a single act of user authentication and possibly subject to collective job control.')
hrSystemProcesses = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemProcesses.setStatus('current')
if mibBuilder.loadTexts: hrSystemProcesses.setDescription('The number of process contexts currently loaded or running on this system.')
hrSystemMaxProcesses = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemMaxProcesses.setStatus('current')
if mibBuilder.loadTexts: hrSystemMaxProcesses.setDescription('The maximum number of process contexts this system can support. If there is no fixed maximum, the value should be zero. On systems that have a fixed maximum, this object can help diagnose failures that occur when this maximum is reached.')
hrStorageTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 2, 1))
hrMemorySize = MibScalar((1, 3, 6, 1, 2, 1, 25, 2, 2), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrMemorySize.setStatus('current')
if mibBuilder.loadTexts: hrMemorySize.setDescription('The amount of physical read-write main memory, typically RAM, contained by the host.')
hrStorageTable = MibTable((1, 3, 6, 1, 2, 1, 25, 2, 3), )
if mibBuilder.loadTexts: hrStorageTable.setStatus('current')
if mibBuilder.loadTexts: hrStorageTable.setDescription("The (conceptual) table of logical storage areas on the host. An entry shall be placed in the storage table for each logical area of storage that is allocated and has fixed resource limits. The amount of storage represented in an entity is the amount actually usable by the requesting entity, and excludes loss due to formatting or file system reference information. These entries are associated with logical storage areas, as might be seen by an application, rather than physical storage entities which are typically seen by an operating system. Storage such as tapes and floppies without file systems on them are typically not allocated in chunks by the operating system to requesting applications, and therefore shouldn't appear in this table. Examples of valid storage for this table include disk partitions, file systems, ram (for some architectures this is further segmented into regular memory, extended memory, and so on), backing store for virtual memory (`swap space'). This table is intended to be a useful diagnostic for `out of memory' and `out of buffers' types of failures. In addition, it can be a useful performance monitoring tool for tracking memory, disk, or buffer usage.")
hrStorageEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 2, 3, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrStorageIndex"))
if mibBuilder.loadTexts: hrStorageEntry.setStatus('current')
if mibBuilder.loadTexts: hrStorageEntry.setDescription('A (conceptual) entry for one logical storage area on the host. As an example, an instance of the hrStorageType object might be named hrStorageType.3')
hrStorageIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageIndex.setStatus('current')
if mibBuilder.loadTexts: hrStorageIndex.setDescription('A unique value for each logical storage area contained by the host.')
hrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageType.setStatus('current')
if mibBuilder.loadTexts: hrStorageType.setDescription('The type of storage represented by this entry.')
hrStorageDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageDescr.setStatus('current')
if mibBuilder.loadTexts: hrStorageDescr.setDescription('A description of the type and instance of the storage described by this entry.')
hrStorageAllocationUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setUnits('Bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageAllocationUnits.setStatus('current')
if mibBuilder.loadTexts: hrStorageAllocationUnits.setDescription('The size, in bytes, of the data objects allocated from this pool. If this entry is monitoring sectors, blocks, buffers, or packets, for example, this number will commonly be greater than one. Otherwise this number will typically be one.')
hrStorageSize = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrStorageSize.setStatus('current')
if mibBuilder.loadTexts: hrStorageSize.setDescription('The size of the storage represented by this entry, in units of hrStorageAllocationUnits. This object is writable to allow remote configuration of the size of the storage area in those cases where such an operation makes sense and is possible on the underlying system. For example, the amount of main memory allocated to a buffer pool might be modified or the amount of disk space allocated to virtual memory might be modified.')
hrStorageUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageUsed.setStatus('current')
if mibBuilder.loadTexts: hrStorageUsed.setDescription('The amount of the storage represented by this entry that is allocated, in units of hrStorageAllocationUnits.')
hrStorageAllocationFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageAllocationFailures.setStatus('current')
if mibBuilder.loadTexts: hrStorageAllocationFailures.setDescription('The number of requests for storage represented by this entry that could not be honored due to not enough storage. It should be noted that as this object has a SYNTAX of Counter32, that it does not have a defined initial value. However, it is recommended that this object be initialized to zero, even though management stations must not depend on such an initialization.')
hrDeviceTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3, 1))
hrDeviceTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 2), )
if mibBuilder.loadTexts: hrDeviceTable.setStatus('current')
if mibBuilder.loadTexts: hrDeviceTable.setDescription('The (conceptual) table of devices contained by the host.')
hrDeviceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrDeviceEntry.setStatus('current')
if mibBuilder.loadTexts: hrDeviceEntry.setDescription('A (conceptual) entry for one device contained by the host. As an example, an instance of the hrDeviceType object might be named hrDeviceType.3')
hrDeviceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceIndex.setStatus('current')
if mibBuilder.loadTexts: hrDeviceIndex.setDescription('A unique value for each device contained by the host. The value for each device must remain constant at least from one re-initialization of the agent to the next re-initialization.')
hrDeviceType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceType.setStatus('current')
if mibBuilder.loadTexts: hrDeviceType.setDescription("An indication of the type of device. If this value is `hrDeviceProcessor { hrDeviceTypes 3 }' then an entry exists in the hrProcessorTable which corresponds to this device. If this value is `hrDeviceNetwork { hrDeviceTypes 4 }', then an entry exists in the hrNetworkTable which corresponds to this device. If this value is `hrDevicePrinter { hrDeviceTypes 5 }', then an entry exists in the hrPrinterTable which corresponds to this device. If this value is `hrDeviceDiskStorage { hrDeviceTypes 6 }', then an entry exists in the hrDiskStorageTable which corresponds to this device.")
hrDeviceDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceDescr.setStatus('current')
if mibBuilder.loadTexts: hrDeviceDescr.setDescription("A textual description of this device, including the device's manufacturer and revision, and optionally, its serial number.")
hrDeviceID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 4), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceID.setStatus('current')
if mibBuilder.loadTexts: hrDeviceID.setDescription('The product ID for this device.')
hrDeviceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))).clone(namedValues=NamedValues(("unknown", 1), ("running", 2), ("warning", 3), ("testing", 4), ("down", 5)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceStatus.setStatus('current')
if mibBuilder.loadTexts: hrDeviceStatus.setDescription("The current operational state of the device described by this row of the table. A value unknown(1) indicates that the current state of the device is unknown. running(2) indicates that the device is up and running and that no unusual error conditions are known. The warning(3) state indicates that agent has been informed of an unusual error condition by the operational software (e.g., a disk device driver) but that the device is still 'operational'. An example would be a high number of soft errors on a disk. A value of testing(4), indicates that the device is not available for use because it is in the testing state. The state of down(5) is used only when the agent has been informed that the device is not available for any use.")
hrDeviceErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceErrors.setStatus('current')
if mibBuilder.loadTexts: hrDeviceErrors.setDescription('The number of errors detected on this device. It should be noted that as this object has a SYNTAX of Counter32, that it does not have a defined initial value. However, it is recommended that this object be initialized to zero, even though management stations must not depend on such an initialization.')
hrProcessorTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 3), )
if mibBuilder.loadTexts: hrProcessorTable.setStatus('current')
if mibBuilder.loadTexts: hrProcessorTable.setDescription("The (conceptual) table of processors contained by the host. Note that this table is potentially sparse: a (conceptual) entry exists only if the correspondent value of the hrDeviceType object is `hrDeviceProcessor'.")
hrProcessorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 3, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrProcessorEntry.setStatus('current')
if mibBuilder.loadTexts: hrProcessorEntry.setDescription('A (conceptual) entry for one processor contained by the host. The hrDeviceIndex in the index represents the entry in the hrDeviceTable that corresponds to the hrProcessorEntry. As an example of how objects in this table are named, an instance of the hrProcessorFrwID object might be named hrProcessorFrwID.3')
hrProcessorFrwID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 3, 1, 1), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrProcessorFrwID.setStatus('current')
if mibBuilder.loadTexts: hrProcessorFrwID.setDescription('The product ID of the firmware associated with the processor.')
hrProcessorLoad = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrProcessorLoad.setStatus('current')
if mibBuilder.loadTexts: hrProcessorLoad.setDescription('The average, over the last minute, of the percentage of time that this processor was not idle. Implementations may approximate this one minute smoothing period if necessary.')
hrNetworkTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 4), )
if mibBuilder.loadTexts: hrNetworkTable.setStatus('current')
if mibBuilder.loadTexts: hrNetworkTable.setDescription("The (conceptual) table of network devices contained by the host. Note that this table is potentially sparse: a (conceptual) entry exists only if the correspondent value of the hrDeviceType object is `hrDeviceNetwork'.")
hrNetworkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 4, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrNetworkEntry.setStatus('current')
if mibBuilder.loadTexts: hrNetworkEntry.setDescription('A (conceptual) entry for one network device contained by the host. The hrDeviceIndex in the index represents the entry in the hrDeviceTable that corresponds to the hrNetworkEntry. As an example of how objects in this table are named, an instance of the hrNetworkIfIndex object might be named hrNetworkIfIndex.3')
hrNetworkIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 4, 1, 1), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrNetworkIfIndex.setStatus('current')
if mibBuilder.loadTexts: hrNetworkIfIndex.setDescription('The value of ifIndex which corresponds to this network device. If this device is not represented in the ifTable, then this value shall be zero.')
hrPrinterTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 5), )
if mibBuilder.loadTexts: hrPrinterTable.setStatus('current')
if mibBuilder.loadTexts: hrPrinterTable.setDescription("The (conceptual) table of printers local to the host. Note that this table is potentially sparse: a (conceptual) entry exists only if the correspondent value of the hrDeviceType object is `hrDevicePrinter'.")
hrPrinterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 5, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrPrinterEntry.setStatus('current')
if mibBuilder.loadTexts: hrPrinterEntry.setDescription('A (conceptual) entry for one printer local to the host. The hrDeviceIndex in the index represents the entry in the hrDeviceTable that corresponds to the hrPrinterEntry. As an example of how objects in this table are named, an instance of the hrPrinterStatus object might be named hrPrinterStatus.3')
hrPrinterStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 5, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))).clone(namedValues=NamedValues(("other", 1), ("unknown", 2), ("idle", 3), ("printing", 4), ("warmup", 5)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPrinterStatus.setStatus('current')
if mibBuilder.loadTexts: hrPrinterStatus.setDescription('The current status of this printer device.')
hrPrinterDetectedErrorState = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 5, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPrinterDetectedErrorState.setStatus('current')
if mibBuilder.loadTexts: hrPrinterDetectedErrorState.setDescription('This object represents any error conditions detected by the printer. The error conditions are encoded as bits in an octet string, with the following definitions: Condition Bit # lowPaper 0 noPaper 1 lowToner 2 noToner 3 doorOpen 4 jammed 5 offline 6 serviceRequested 7 inputTrayMissing 8 outputTrayMissing 9 markerSupplyMissing 10 outputNearFull 11 outputFull 12 inputTrayEmpty 13 overduePreventMaint 14 Bits are numbered starting with the most significant bit of the first byte being bit 0, the least significant bit of the first byte being bit 7, the most significant bit of the second byte being bit 8, and so on. A one bit encodes that the condition was detected, while a zero bit encodes that the condition was not detected. This object is useful for alerting an operator to specific warning or error conditions that may occur, especially those requiring human intervention.')
hrDiskStorageTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 6), )
if mibBuilder.loadTexts: hrDiskStorageTable.setStatus('current')
if mibBuilder.loadTexts: hrDiskStorageTable.setDescription("The (conceptual) table of long-term storage devices contained by the host. In particular, disk devices accessed remotely over a network are not included here. Note that this table is potentially sparse: a (conceptual) entry exists only if the correspondent value of the hrDeviceType object is `hrDeviceDiskStorage'.")
hrDiskStorageEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 6, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrDiskStorageEntry.setStatus('current')
if mibBuilder.loadTexts: hrDiskStorageEntry.setDescription('A (conceptual) entry for one long-term storage device contained by the host. The hrDeviceIndex in the index represents the entry in the hrDeviceTable that corresponds to the hrDiskStorageEntry. As an example, an instance of the hrDiskStorageCapacity object might be named hrDiskStorageCapacity.3')
hrDiskStorageAccess = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("readWrite", 1), ("readOnly", 2)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageAccess.setStatus('current')
if mibBuilder.loadTexts: hrDiskStorageAccess.setDescription('An indication if this long-term storage device is readable and writable or only readable. This should reflect the media type, any write-protect mechanism, and any device configuration that affects the entire device.')
hrDiskStorageMedia = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8))).clone(namedValues=NamedValues(("other", 1), ("unknown", 2), ("hardDisk", 3), ("floppyDisk", 4), ("opticalDiskROM", 5), ("opticalDiskWORM", 6), ("opticalDiskRW", 7), ("ramDisk", 8)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageMedia.setStatus('current')
if mibBuilder.loadTexts: hrDiskStorageMedia.setDescription('An indication of the type of media used in this long- term storage device.')
hrDiskStorageRemoveble = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageRemoveble.setStatus('current')
if mibBuilder.loadTexts: hrDiskStorageRemoveble.setDescription('Denotes whether or not the disk media may be removed from the drive.')
hrDiskStorageCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 4), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageCapacity.setStatus('current')
if mibBuilder.loadTexts: hrDiskStorageCapacity.setDescription('The total size for this long-term storage device. If the media is removable and is currently removed, this value should be zero.')
hrPartitionTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 7), )
if mibBuilder.loadTexts: hrPartitionTable.setStatus('current')
if mibBuilder.loadTexts: hrPartitionTable.setDescription('The (conceptual) table of partitions for long-term storage devices contained by the host. In particular, partitions accessed remotely over a network are not included here.')
hrPartitionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 7, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "HOST-RESOURCES-MIB", "hrPartitionIndex"))
if mibBuilder.loadTexts: hrPartitionEntry.setStatus('current')
if mibBuilder.loadTexts: hrPartitionEntry.setDescription('A (conceptual) entry for one partition. The hrDeviceIndex in the index represents the entry in the hrDeviceTable that corresponds to the hrPartitionEntry. As an example of how objects in this table are named, an instance of the hrPartitionSize object might be named hrPartitionSize.3.1')
hrPartitionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionIndex.setStatus('current')
if mibBuilder.loadTexts: hrPartitionIndex.setDescription('A unique value for each partition on this long-term storage device. The value for each long-term storage device must remain constant at least from one re- initialization of the agent to the next re- initialization.')
hrPartitionLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionLabel.setStatus('current')
if mibBuilder.loadTexts: hrPartitionLabel.setDescription('A textual description of this partition.')
hrPartitionID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionID.setStatus('current')
if mibBuilder.loadTexts: hrPartitionID.setDescription('A descriptor which uniquely represents this partition to the responsible operating system. On some systems, this might take on a binary representation.')
hrPartitionSize = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 4), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionSize.setStatus('current')
if mibBuilder.loadTexts: hrPartitionSize.setDescription('The size of this partition.')
hrPartitionFSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionFSIndex.setStatus('current')
if mibBuilder.loadTexts: hrPartitionFSIndex.setDescription('The index of the file system mounted on this partition. If no file system is mounted on this partition, then this value shall be zero. Note that multiple partitions may point to one file system, denoting that that file system resides on those partitions. Multiple file systems may not reside on one partition.')
hrFSTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3, 9))
hrFSTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 8), )
if mibBuilder.loadTexts: hrFSTable.setStatus('current')
if mibBuilder.loadTexts: hrFSTable.setDescription("The (conceptual) table of file systems local to this host or remotely mounted from a file server. File systems that are in only one user's environment on a multi-user system will not be included in this table.")
hrFSEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 8, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrFSIndex"))
if mibBuilder.loadTexts: hrFSEntry.setStatus('current')
if mibBuilder.loadTexts: hrFSEntry.setDescription("A (conceptual) entry for one file system local to this host or remotely mounted from a file server. File systems that are in only one user's environment on a multi-user system will not be included in this table. As an example of how objects in this table are named, an instance of the hrFSMountPoint object might be named hrFSMountPoint.3")
hrFSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSIndex.setStatus('current')
if mibBuilder.loadTexts: hrFSIndex.setDescription('A unique value for each file system local to this host. The value for each file system must remain constant at least from one re-initialization of the agent to the next re-initialization.')
hrFSMountPoint = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSMountPoint.setStatus('current')
if mibBuilder.loadTexts: hrFSMountPoint.setDescription('The path name of the root of this file system.')
hrFSRemoteMountPoint = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 3), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSRemoteMountPoint.setStatus('current')
if mibBuilder.loadTexts: hrFSRemoteMountPoint.setDescription('A description of the name and/or address of the server that this file system is mounted from. This may also include parameters such as the mount point on the remote file system. If this is not a remote file system, this string should have a length of zero.')
hrFSType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 4), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSType.setStatus('current')
if mibBuilder.loadTexts: hrFSType.setDescription('The value of this object identifies the type of this file system.')
hrFSAccess = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("readWrite", 1), ("readOnly", 2)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSAccess.setStatus('current')
if mibBuilder.loadTexts: hrFSAccess.setDescription('An indication if this file system is logically configured by the operating system to be readable and writable or only readable. This does not represent any local access-control policy, except one that is applied to the file system as a whole.')
hrFSBootable = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSBootable.setStatus('current')
if mibBuilder.loadTexts: hrFSBootable.setDescription('A flag indicating whether this file system is bootable.')
hrFSStorageIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSStorageIndex.setStatus('current')
if mibBuilder.loadTexts: hrFSStorageIndex.setDescription('The index of the hrStorageEntry that represents information about this file system. If there is no such information available, then this value shall be zero. The relevant storage entry will be useful in tracking the percent usage of this file system and diagnosing errors that may occur when it runs out of space.')
hrFSLastFullBackupDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 8), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrFSLastFullBackupDate.setStatus('current')
if mibBuilder.loadTexts: hrFSLastFullBackupDate.setDescription("The last date at which this complete file system was copied to another storage device for backup. This information is useful for ensuring that backups are being performed regularly. If this information is not known, then this variable shall have the value corresponding to January 1, year 0000, 00:00:00.0, which is encoded as (hex)'00 00 01 01 00 00 00 00'.")
hrFSLastPartialBackupDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 9), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrFSLastPartialBackupDate.setStatus('current')
if mibBuilder.loadTexts: hrFSLastPartialBackupDate.setDescription("The last date at which a portion of this file system was copied to another storage device for backup. This information is useful for ensuring that backups are being performed regularly. If this information is not known, then this variable shall have the value corresponding to January 1, year 0000, 00:00:00.0, which is encoded as (hex)'00 00 01 01 00 00 00 00'.")
hrSWOSIndex = MibScalar((1, 3, 6, 1, 2, 1, 25, 4, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWOSIndex.setStatus('current')
if mibBuilder.loadTexts: hrSWOSIndex.setDescription('The value of the hrSWRunIndex for the hrSWRunEntry that represents the primary operating system running on this host. This object is useful for quickly and uniquely identifying that primary operating system.')
hrSWRunTable = MibTable((1, 3, 6, 1, 2, 1, 25, 4, 2), )
if mibBuilder.loadTexts: hrSWRunTable.setStatus('current')
if mibBuilder.loadTexts: hrSWRunTable.setDescription('The (conceptual) table of software running on the host.')
hrSWRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 4, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrSWRunIndex"))
if mibBuilder.loadTexts: hrSWRunEntry.setStatus('current')
if mibBuilder.loadTexts: hrSWRunEntry.setDescription('A (conceptual) entry for one piece of software running on the host Note that because the installed software table only contains information for software stored locally on this host, not every piece of running software will be found in the installed software table. This is true of software that was loaded and run from a non-local source, such as a network-mounted file system. As an example of how objects in this table are named, an instance of the hrSWRunName object might be named hrSWRunName.1287')
hrSWRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunIndex.setStatus('current')
if mibBuilder.loadTexts: hrSWRunIndex.setDescription("A unique value for each piece of software running on the host. Wherever possible, this should be the system's native, unique identification number.")
hrSWRunName = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunName.setStatus('current')
if mibBuilder.loadTexts: hrSWRunName.setDescription('A textual description of this running piece of software, including the manufacturer, revision, and the name by which it is commonly known. If this software was installed locally, this should be the same string as used in the corresponding hrSWInstalledName.')
hrSWRunID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 3), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunID.setStatus('current')
if mibBuilder.loadTexts: hrSWRunID.setDescription('The product ID of this running piece of software.')
hrSWRunPath = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 4), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPath.setStatus('current')
if mibBuilder.loadTexts: hrSWRunPath.setDescription('A description of the location on long-term storage (e.g. a disk drive) from which this software was loaded.')
hrSWRunParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 5), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunParameters.setStatus('current')
if mibBuilder.loadTexts: hrSWRunParameters.setDescription('A description of the parameters supplied to this software when it was initially loaded.')
hrSWRunType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4))).clone(namedValues=NamedValues(("unknown", 1), ("operatingSystem", 2), ("deviceDriver", 3), ("application", 4)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunType.setStatus('current')
if mibBuilder.loadTexts: hrSWRunType.setDescription('The type of this software.')
hrSWRunStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4))).clone(namedValues=NamedValues(("running", 1), ("runnable", 2), ("notRunnable", 3), ("invalid", 4)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSWRunStatus.setStatus('current')
if mibBuilder.loadTexts: hrSWRunStatus.setDescription('The status of this running piece of software. Setting this value to invalid(4) shall cause this software to stop running and to be unloaded. Sets to other values are not valid.')
hrSWRunPerfTable = MibTable((1, 3, 6, 1, 2, 1, 25, 5, 1), )
if mibBuilder.loadTexts: hrSWRunPerfTable.setStatus('current')
if mibBuilder.loadTexts: hrSWRunPerfTable.setDescription('The (conceptual) table of running software performance metrics.')
hrSWRunPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 5, 1, 1), )
hrSWRunEntry.registerAugmentions(("HOST-RESOURCES-MIB", "hrSWRunPerfEntry"))
hrSWRunPerfEntry.setIndexNames(*hrSWRunEntry.getIndexNames())
if mibBuilder.loadTexts: hrSWRunPerfEntry.setStatus('current')
if mibBuilder.loadTexts: hrSWRunPerfEntry.setDescription('A (conceptual) entry containing software performance metrics. As an example, an instance of the hrSWRunPerfCPU object might be named hrSWRunPerfCPU.1287')
hrSWRunPerfCPU = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 5, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPerfCPU.setStatus('current')
if mibBuilder.loadTexts: hrSWRunPerfCPU.setDescription("The number of centi-seconds of the total system's CPU resources consumed by this process. Note that on a multi-processor system, this value may increment by more than one centi-second in one centi-second of real (wall clock) time.")
hrSWRunPerfMem = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 5, 1, 1, 2), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPerfMem.setStatus('current')
if mibBuilder.loadTexts: hrSWRunPerfMem.setDescription('The total amount of real system memory allocated to this process.')
hrSWInstalledLastChange = MibScalar((1, 3, 6, 1, 2, 1, 25, 6, 1), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledLastChange.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledLastChange.setDescription('The value of sysUpTime when an entry in the hrSWInstalledTable was last added, renamed, or deleted. Because this table is likely to contain many entries, polling of this object allows a management station to determine when re-downloading of the table might be useful.')
hrSWInstalledLastUpdateTime = MibScalar((1, 3, 6, 1, 2, 1, 25, 6, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledLastUpdateTime.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledLastUpdateTime.setDescription('The value of sysUpTime when the hrSWInstalledTable was last completely updated. Because caching of this data will be a popular implementation strategy, retrieval of this object allows a management station to obtain a guarantee that no data in this table is older than the indicated time.')
hrSWInstalledTable = MibTable((1, 3, 6, 1, 2, 1, 25, 6, 3), )
if mibBuilder.loadTexts: hrSWInstalledTable.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledTable.setDescription('The (conceptual) table of software installed on this host.')
hrSWInstalledEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 6, 3, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrSWInstalledIndex"))
if mibBuilder.loadTexts: hrSWInstalledEntry.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledEntry.setDescription('A (conceptual) entry for a piece of software installed on this host. As an example of how objects in this table are named, an instance of the hrSWInstalledName object might be named hrSWInstalledName.96')
hrSWInstalledIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledIndex.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledIndex.setDescription('A unique value for each piece of software installed on the host. This value shall be in the range from 1 to the number of pieces of software installed on the host.')
hrSWInstalledName = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledName.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledName.setDescription('A textual description of this installed piece of software, including the manufacturer, revision, the name by which it is commonly known, and optionally, its serial number.')
hrSWInstalledID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 3), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledID.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledID.setDescription('The product ID of this installed piece of software.')
hrSWInstalledType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4))).clone(namedValues=NamedValues(("unknown", 1), ("operatingSystem", 2), ("deviceDriver", 3), ("application", 4)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledType.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledType.setDescription('The type of this software.')
hrSWInstalledDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledDate.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledDate.setDescription("The last-modification date of this application as it would appear in a directory listing. If this information is not known, then this variable shall have the value corresponding to January 1, year 0000, 00:00:00.0, which is encoded as (hex)'00 00 01 01 00 00 00 00'.")
hrMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7, 2))
hrMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7, 3))
hrMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 25, 7, 2, 1)).setObjects(("HOST-RESOURCES-MIB", "hrSystemGroup"), ("HOST-RESOURCES-MIB", "hrStorageGroup"), ("HOST-RESOURCES-MIB", "hrDeviceGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    hrMIBCompliance = hrMIBCompliance.setStatus('current')
if mibBuilder.loadTexts: hrMIBCompliance.setDescription('The requirements for conformance to the Host Resources MIB.')
hrSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 1)).setObjects(("HOST-RESOURCES-MIB", "hrSystemUptime"), ("HOST-RESOURCES-MIB", "hrSystemDate"), ("HOST-RESOURCES-MIB", "hrSystemInitialLoadDevice"), ("HOST-RESOURCES-MIB", "hrSystemInitialLoadParameters"), ("HOST-RESOURCES-MIB", "hrSystemNumUsers"), ("HOST-RESOURCES-MIB", "hrSystemProcesses"), ("HOST-RESOURCES-MIB", "hrSystemMaxProcesses"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    hrSystemGroup = hrSystemGroup.setStatus('current')
if mibBuilder.loadTexts: hrSystemGroup.setDescription('The Host Resources System Group.')
hrStorageGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 2)).setObjects(("HOST-RESOURCES-MIB", "hrMemorySize"), ("HOST-RESOURCES-MIB", "hrStorageIndex"), ("HOST-RESOURCES-MIB", "hrStorageType"), ("HOST-RESOURCES-MIB", "hrStorageDescr"), ("HOST-RESOURCES-MIB", "hrStorageAllocationUnits"), ("HOST-RESOURCES-MIB", "hrStorageSize"), ("HOST-RESOURCES-MIB", "hrStorageUsed"), ("HOST-RESOURCES-MIB", "hrStorageAllocationFailures"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    hrStorageGroup = hrStorageGroup.setStatus('current')
if mibBuilder.loadTexts: hrStorageGroup.setDescription('The Host Resources Storage Group.')
hrDeviceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 3)).setObjects(("HOST-RESOURCES-MIB", "hrDeviceIndex"), ("HOST-RESOURCES-MIB", "hrDeviceType"), ("HOST-RESOURCES-MIB", "hrDeviceDescr"), ("HOST-RESOURCES-MIB", "hrDeviceID"), ("HOST-RESOURCES-MIB", "hrDeviceStatus"), ("HOST-RESOURCES-MIB", "hrDeviceErrors"), ("HOST-RESOURCES-MIB", "hrProcessorFrwID"), ("HOST-RESOURCES-MIB", "hrProcessorLoad"), ("HOST-RESOURCES-MIB", "hrNetworkIfIndex"), ("HOST-RESOURCES-MIB", "hrPrinterStatus"), ("HOST-RESOURCES-MIB", "hrPrinterDetectedErrorState"), ("HOST-RESOURCES-MIB", "hrDiskStorageAccess"), ("HOST-RESOURCES-MIB", "hrDiskStorageMedia"), ("HOST-RESOURCES-MIB", "hrDiskStorageRemoveble"), ("HOST-RESOURCES-MIB", "hrDiskStorageCapacity"), ("HOST-RESOURCES-MIB", "hrPartitionIndex"), ("HOST-RESOURCES-MIB", "hrPartitionLabel"), ("HOST-RESOURCES-MIB", "hrPartitionID"), ("HOST-RESOURCES-MIB", "hrPartitionSize"), ("HOST-RESOURCES-MIB", "hrPartitionFSIndex"), ("HOST-RESOURCES-MIB", "hrFSIndex"), ("HOST-RESOURCES-MIB", "hrFSMountPoint"), ("HOST-RESOURCES-MIB", "hrFSRemoteMountPoint"), ("HOST-RESOURCES-MIB", "hrFSType"), ("HOST-RESOURCES-MIB", "hrFSAccess"), ("HOST-RESOURCES-MIB", "hrFSBootable"), ("HOST-RESOURCES-MIB", "hrFSStorageIndex"), ("HOST-RESOURCES-MIB", "hrFSLastFullBackupDate"), ("HOST-RESOURCES-MIB", "hrFSLastPartialBackupDate"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    hrDeviceGroup = hrDeviceGroup.setStatus('current')
if mibBuilder.loadTexts: hrDeviceGroup.setDescription('The Host Resources Device Group.')
hrSWRunGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 4)).setObjects(("HOST-RESOURCES-MIB", "hrSWOSIndex"), ("HOST-RESOURCES-MIB", "hrSWRunIndex"), ("HOST-RESOURCES-MIB", "hrSWRunName"), ("HOST-RESOURCES-MIB", "hrSWRunID"), ("HOST-RESOURCES-MIB", "hrSWRunPath"), ("HOST-RESOURCES-MIB", "hrSWRunParameters"), ("HOST-RESOURCES-MIB", "hrSWRunType"), ("HOST-RESOURCES-MIB", "hrSWRunStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    hrSWRunGroup = hrSWRunGroup.setStatus('current')
if mibBuilder.loadTexts: hrSWRunGroup.setDescription('The Host Resources Running Software Group.')
hrSWRunPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 5)).setObjects(("HOST-RESOURCES-MIB", "hrSWRunPerfCPU"), ("HOST-RESOURCES-MIB", "hrSWRunPerfMem"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    hrSWRunPerfGroup = hrSWRunPerfGroup.setStatus('current')
if mibBuilder.loadTexts: hrSWRunPerfGroup.setDescription('The Host Resources Running Software Performance Group.')
hrSWInstalledGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 6)).setObjects(("HOST-RESOURCES-MIB", "hrSWInstalledLastChange"), ("HOST-RESOURCES-MIB", "hrSWInstalledLastUpdateTime"), ("HOST-RESOURCES-MIB", "hrSWInstalledIndex"), ("HOST-RESOURCES-MIB", "hrSWInstalledName"), ("HOST-RESOURCES-MIB", "hrSWInstalledID"), ("HOST-RESOURCES-MIB", "hrSWInstalledType"), ("HOST-RESOURCES-MIB", "hrSWInstalledDate"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    hrSWInstalledGroup = hrSWInstalledGroup.setStatus('current')
if mibBuilder.loadTexts: hrSWInstalledGroup.setDescription('The Host Resources Installed Software Group.')
mibBuilder.exportSymbols("HOST-RESOURCES-MIB", hrPrinterDetectedErrorState=hrPrinterDetectedErrorState, hrSWInstalledLastChange=hrSWInstalledLastChange, hrMIBCompliances=hrMIBCompliances, hrFSAccess=hrFSAccess, hrSystemUptime=hrSystemUptime, hrSWInstalled=hrSWInstalled, hrSWRunParameters=hrSWRunParameters, hrSWRunPerfMem=hrSWRunPerfMem, hrMIBCompliance=hrMIBCompliance, hrSWInstalledEntry=hrSWInstalledEntry, hrSWRunEntry=hrSWRunEntry, host=host, hrPrinterEntry=hrPrinterEntry, hrSWInstalledLastUpdateTime=hrSWInstalledLastUpdateTime, hrSystemProcesses=hrSystemProcesses, hrSWRunType=hrSWRunType, hrPartitionLabel=hrPartitionLabel, hrPartitionEntry=hrPartitionEntry, hrPrinterTable=hrPrinterTable, hrProcessorLoad=hrProcessorLoad, hrDeviceType=hrDeviceType, hrSWInstalledIndex=hrSWInstalledIndex, ProductID=ProductID, hrSWRunStatus=hrSWRunStatus, hrSystemNumUsers=hrSystemNumUsers, hrSWRunPerfEntry=hrSWRunPerfEntry, hrDeviceGroup=hrDeviceGroup, hrSWRunID=hrSWRunID, hrStorageTable=hrStorageTable, hrSystemMaxProcesses=hrSystemMaxProcesses, hrStorageDescr=hrStorageDescr, KBytes=KBytes, hrStorageTypes=hrStorageTypes, hrMIBGroups=hrMIBGroups, hrDeviceStatus=hrDeviceStatus, hrProcessorEntry=hrProcessorEntry, hrSystemInitialLoadParameters=hrSystemInitialLoadParameters, hrDiskStorageEntry=hrDiskStorageEntry, hrDeviceErrors=hrDeviceErrors, hrStorageIndex=hrStorageIndex, hrFSTable=hrFSTable, hrDeviceEntry=hrDeviceEntry, hrDeviceTypes=hrDeviceTypes, hrSWRunPath=hrSWRunPath, hrSWInstalledGroup=hrSWInstalledGroup, hrStorageType=hrStorageType, hrSystemDate=hrSystemDate, hrDiskStorageAccess=hrDiskStorageAccess, hrPartitionID=hrPartitionID, hrSWRunTable=hrSWRunTable, hrPartitionTable=hrPartitionTable, hrSWInstalledTable=hrSWInstalledTable, hrFSRemoteMountPoint=hrFSRemoteMountPoint, hrSWRunPerfGroup=hrSWRunPerfGroup, hrStorage=hrStorage, hrSWRunPerf=hrSWRunPerf, hrSWInstalledID=hrSWInstalledID, hrMIBAdminInfo=hrMIBAdminInfo, hrNetworkEntry=hrNetworkEntry, hrDiskStorageCapacity=hrDiskStorageCapacity, hrProcessorTable=hrProcessorTable, hrPrinterStatus=hrPrinterStatus, hrFSIndex=hrFSIndex, hrFSLastFullBackupDate=hrFSLastFullBackupDate, hrStorageGroup=hrStorageGroup, hrSWRunPerfTable=hrSWRunPerfTable, hrStorageAllocationFailures=hrStorageAllocationFailures, hrPartitionFSIndex=hrPartitionFSIndex, hrSWOSIndex=hrSWOSIndex, hrDiskStorageTable=hrDiskStorageTable, hrStorageEntry=hrStorageEntry, hrFSTypes=hrFSTypes, hrFSStorageIndex=hrFSStorageIndex, hrFSLastPartialBackupDate=hrFSLastPartialBackupDate, hrSWRunGroup=hrSWRunGroup, hrStorageAllocationUnits=hrStorageAllocationUnits, hrDeviceTable=hrDeviceTable, hrDiskStorageRemoveble=hrDiskStorageRemoveble, hrSystemInitialLoadDevice=hrSystemInitialLoadDevice, PYSNMP_MODULE_ID=hostResourcesMibModule, hrSWInstalledType=hrSWInstalledType, hrSystemGroup=hrSystemGroup, hrStorageUsed=hrStorageUsed, InternationalDisplayString=InternationalDisplayString, hrPartitionIndex=hrPartitionIndex, hrFSType=hrFSType, hrDeviceID=hrDeviceID, hrDeviceIndex=hrDeviceIndex, hrPartitionSize=hrPartitionSize, hrNetworkIfIndex=hrNetworkIfIndex, hrDiskStorageMedia=hrDiskStorageMedia, hrSWRunName=hrSWRunName, hostResourcesMibModule=hostResourcesMibModule, hrDevice=hrDevice, hrDeviceDescr=hrDeviceDescr, hrSystem=hrSystem, hrProcessorFrwID=hrProcessorFrwID, hrSWRunPerfCPU=hrSWRunPerfCPU, hrSWInstalledDate=hrSWInstalledDate, hrStorageSize=hrStorageSize, hrSWRun=hrSWRun, hrFSMountPoint=hrFSMountPoint, hrSWRunIndex=hrSWRunIndex, hrMemorySize=hrMemorySize, hrSWInstalledName=hrSWInstalledName, hrFSEntry=hrFSEntry, hrFSBootable=hrFSBootable, hrNetworkTable=hrNetworkTable)
