#
# PySNMP MIB module TCP-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/TCP-MIB
# Produced by pysmi-0.3.4 at Fri Feb 28 14:04:53 2020
# On host nerk platform Linux version 5.5.5-200.fc31.x86_64 by user spider
# Using Python version 3.7.6 (default, Jan 30 2020, 09:44:41) 
#
ObjectIdentifier, OctetString, Integer = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ConstraintsIntersection, SingleValueConstraint, ConstraintsUnion, ValueRangeConstraint, ValueSizeConstraint = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "SingleValueConstraint", "ConstraintsUnion", "ValueRangeConstraint", "ValueSizeConstraint")
InetAddress, InetPortNumber, InetAddressType = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetPortNumber", "InetAddressType")
ModuleCompliance, NotificationGroup, ObjectGroup = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
mib_2, Counter64, Bits, iso, MibIdentifier, NotificationType, Counter32, Gauge32, MibScalar, MibTable, MibTableRow, MibTableColumn, ModuleIdentity, IpAddress, Integer32, ObjectIdentity, TimeTicks, Unsigned32 = mibBuilder.importSymbols("SNMPv2-SMI", "mib-2", "Counter64", "Bits", "iso", "MibIdentifier", "NotificationType", "Counter32", "Gauge32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "ModuleIdentity", "IpAddress", "Integer32", "ObjectIdentity", "TimeTicks", "Unsigned32")
TextualConvention, DisplayString = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString")
tcpMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 49))
tcpMIB.setRevisions(('2005-02-18 00:00', '1994-11-01 00:00', '1991-03-31 00:00',))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    if mibBuilder.loadTexts: tcpMIB.setRevisionsDescriptions(('IP version neutral revision, published as RFC 4022.', 'Initial SMIv2 version, published as RFC 2012.', 'The initial revision of this MIB module was part of MIB-II.',))
if mibBuilder.loadTexts: tcpMIB.setLastUpdated('200502180000Z')
if mibBuilder.loadTexts: tcpMIB.setOrganization('IETF IPv6 MIB Revision Team http://www.ietf.org/html.charters/ipv6-charter.html')
if mibBuilder.loadTexts: tcpMIB.setContactInfo('Rajiv Raghunarayan (editor) Cisco Systems Inc. 170 West Tasman Drive San Jose, CA 95134 Phone: +1 408 853 9612 Email: <raraghun@cisco.com> Send comments to <ipv6@ietf.org>')
if mibBuilder.loadTexts: tcpMIB.setDescription('The MIB module for managing TCP implementations. Copyright (C) The Internet Society (2005). This version of this MIB module is a part of RFC 4022; see the RFC itself for full legal notices.')
tcp = MibIdentifier((1, 3, 6, 1, 2, 1, 6))
tcpRtoAlgorithm = MibScalar((1, 3, 6, 1, 2, 1, 6, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))).clone(namedValues=NamedValues(("other", 1), ("constant", 2), ("rsre", 3), ("vanj", 4), ("rfc2988", 5)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRtoAlgorithm.setStatus('current')
if mibBuilder.loadTexts: tcpRtoAlgorithm.setDescription('The algorithm used to determine the timeout value used for retransmitting unacknowledged octets.')
tcpRtoMin = MibScalar((1, 3, 6, 1, 2, 1, 6, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRtoMin.setStatus('current')
if mibBuilder.loadTexts: tcpRtoMin.setDescription('The minimum value permitted by a TCP implementation for the retransmission timeout, measured in milliseconds. More refined semantics for objects of this type depend on the algorithm used to determine the retransmission timeout; in particular, the IETF standard algorithm rfc2988(5) provides a minimum value.')
tcpRtoMax = MibScalar((1, 3, 6, 1, 2, 1, 6, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRtoMax.setStatus('current')
if mibBuilder.loadTexts: tcpRtoMax.setDescription('The maximum value permitted by a TCP implementation for the retransmission timeout, measured in milliseconds. More refined semantics for objects of this type depend on the algorithm used to determine the retransmission timeout; in particular, the IETF standard algorithm rfc2988(5) provides an upper bound (as part of an adaptive backoff algorithm).')
tcpMaxConn = MibScalar((1, 3, 6, 1, 2, 1, 6, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1, -1), ValueRangeConstraint(0, 2147483647), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpMaxConn.setStatus('current')
if mibBuilder.loadTexts: tcpMaxConn.setDescription('The limit on the total number of TCP connections the entity can support. In entities where the maximum number of connections is dynamic, this object should contain the value -1.')
tcpActiveOpens = MibScalar((1, 3, 6, 1, 2, 1, 6, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpActiveOpens.setStatus('current')
if mibBuilder.loadTexts: tcpActiveOpens.setDescription('The number of times that TCP connections have made a direct transition to the SYN-SENT state from the CLOSED state. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpPassiveOpens = MibScalar((1, 3, 6, 1, 2, 1, 6, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpPassiveOpens.setStatus('current')
if mibBuilder.loadTexts: tcpPassiveOpens.setDescription('The number of times TCP connections have made a direct transition to the SYN-RCVD state from the LISTEN state. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpAttemptFails = MibScalar((1, 3, 6, 1, 2, 1, 6, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpAttemptFails.setStatus('current')
if mibBuilder.loadTexts: tcpAttemptFails.setDescription('The number of times that TCP connections have made a direct transition to the CLOSED state from either the SYN-SENT state or the SYN-RCVD state, plus the number of times that TCP connections have made a direct transition to the LISTEN state from the SYN-RCVD state. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpEstabResets = MibScalar((1, 3, 6, 1, 2, 1, 6, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEstabResets.setStatus('current')
if mibBuilder.loadTexts: tcpEstabResets.setDescription('The number of times that TCP connections have made a direct transition to the CLOSED state from either the ESTABLISHED state or the CLOSE-WAIT state. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpCurrEstab = MibScalar((1, 3, 6, 1, 2, 1, 6, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpCurrEstab.setStatus('current')
if mibBuilder.loadTexts: tcpCurrEstab.setDescription('The number of TCP connections for which the current state is either ESTABLISHED or CLOSE-WAIT.')
tcpInSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpInSegs.setStatus('current')
if mibBuilder.loadTexts: tcpInSegs.setDescription('The total number of segments received, including those received in error. This count includes segments received on currently established connections. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpOutSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpOutSegs.setStatus('current')
if mibBuilder.loadTexts: tcpOutSegs.setDescription('The total number of segments sent, including those on current connections but excluding those containing only retransmitted octets. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpRetransSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRetransSegs.setStatus('current')
if mibBuilder.loadTexts: tcpRetransSegs.setDescription('The total number of segments retransmitted; that is, the number of TCP segments transmitted containing one or more previously transmitted octets. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpInErrs = MibScalar((1, 3, 6, 1, 2, 1, 6, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpInErrs.setStatus('current')
if mibBuilder.loadTexts: tcpInErrs.setDescription('The total number of segments received in error (e.g., bad TCP checksums). Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpOutRsts = MibScalar((1, 3, 6, 1, 2, 1, 6, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpOutRsts.setStatus('current')
if mibBuilder.loadTexts: tcpOutRsts.setDescription('The number of TCP segments sent containing the RST flag. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpHCInSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 17), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpHCInSegs.setStatus('current')
if mibBuilder.loadTexts: tcpHCInSegs.setDescription('The total number of segments received, including those received in error. This count includes segments received on currently established connections. This object is the 64-bit equivalent of tcpInSegs. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpHCOutSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 18), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpHCOutSegs.setStatus('current')
if mibBuilder.loadTexts: tcpHCOutSegs.setDescription('The total number of segments sent, including those on current connections but excluding those containing only retransmitted octets. This object is the 64-bit equivalent of tcpOutSegs. Discontinuities in the value of this counter are indicated via discontinuities in the value of sysUpTime.')
tcpConnectionTable = MibTable((1, 3, 6, 1, 2, 1, 6, 19), )
if mibBuilder.loadTexts: tcpConnectionTable.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionTable.setDescription('A table containing information about existing TCP connections. Note that unlike earlier TCP MIBs, there is a separate table for connections in the LISTEN state.')
tcpConnectionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 6, 19, 1), ).setIndexNames((0, "TCP-MIB", "tcpConnectionLocalAddressType"), (0, "TCP-MIB", "tcpConnectionLocalAddress"), (0, "TCP-MIB", "tcpConnectionLocalPort"), (0, "TCP-MIB", "tcpConnectionRemAddressType"), (0, "TCP-MIB", "tcpConnectionRemAddress"), (0, "TCP-MIB", "tcpConnectionRemPort"))
if mibBuilder.loadTexts: tcpConnectionEntry.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionEntry.setDescription('A conceptual row of the tcpConnectionTable containing information about a particular current TCP connection. Each row of this table is transient in that it ceases to exist when (or soon after) the connection makes the transition to the CLOSED state.')
tcpConnectionLocalAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 1), InetAddressType())
if mibBuilder.loadTexts: tcpConnectionLocalAddressType.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionLocalAddressType.setDescription('The address type of tcpConnectionLocalAddress.')
tcpConnectionLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 2), InetAddress())
if mibBuilder.loadTexts: tcpConnectionLocalAddress.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionLocalAddress.setDescription('The local IP address for this TCP connection. The type of this address is determined by the value of tcpConnectionLocalAddressType. As this object is used in the index for the tcpConnectionTable, implementors should be careful not to create entries that would result in OIDs with more than 128 subidentifiers; otherwise the information cannot be accessed by using SNMPv1, SNMPv2c, or SNMPv3.')
tcpConnectionLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 3), InetPortNumber())
if mibBuilder.loadTexts: tcpConnectionLocalPort.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionLocalPort.setDescription('The local port number for this TCP connection.')
tcpConnectionRemAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 4), InetAddressType())
if mibBuilder.loadTexts: tcpConnectionRemAddressType.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionRemAddressType.setDescription('The address type of tcpConnectionRemAddress.')
tcpConnectionRemAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 5), InetAddress())
if mibBuilder.loadTexts: tcpConnectionRemAddress.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionRemAddress.setDescription('The remote IP address for this TCP connection. The type of this address is determined by the value of tcpConnectionRemAddressType. As this object is used in the index for the tcpConnectionTable, implementors should be careful not to create entries that would result in OIDs with more than 128 subidentifiers; otherwise the information cannot be accessed by using SNMPv1, SNMPv2c, or SNMPv3.')
tcpConnectionRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 6), InetPortNumber())
if mibBuilder.loadTexts: tcpConnectionRemPort.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionRemPort.setDescription('The remote port number for this TCP connection.')
tcpConnectionState = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))).clone(namedValues=NamedValues(("closed", 1), ("listen", 2), ("synSent", 3), ("synReceived", 4), ("established", 5), ("finWait1", 6), ("finWait2", 7), ("closeWait", 8), ("lastAck", 9), ("closing", 10), ("timeWait", 11), ("deleteTCB", 12)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpConnectionState.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionState.setDescription("The state of this TCP connection. The value listen(2) is included only for parallelism to the old tcpConnTable and should not be used. A connection in LISTEN state should be present in the tcpListenerTable. The only value that may be set by a management station is deleteTCB(12). Accordingly, it is appropriate for an agent to return a `badValue' response if a management station attempts to set this object to any other value. If a management station sets this object to the value deleteTCB(12), then the TCB (as defined in [RFC793]) of the corresponding connection on the managed node is deleted, resulting in immediate termination of the connection. As an implementation-specific option, a RST segment may be sent from the managed node to the other TCP endpoint (note, however, that RST segments are not sent reliably).")
tcpConnectionProcess = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 19, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnectionProcess.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionProcess.setDescription("The system's process ID for the process associated with this connection, or zero if there is no such process. This value is expected to be the same as HOST-RESOURCES-MIB:: hrSWRunIndex or SYSAPPL-MIB::sysApplElmtRunIndex for some row in the appropriate tables.")
tcpListenerTable = MibTable((1, 3, 6, 1, 2, 1, 6, 20), )
if mibBuilder.loadTexts: tcpListenerTable.setStatus('current')
if mibBuilder.loadTexts: tcpListenerTable.setDescription("A table containing information about TCP listeners. A listening application can be represented in three possible ways: 1. An application that is willing to accept both IPv4 and IPv6 datagrams is represented by a tcpListenerLocalAddressType of unknown (0) and a tcpListenerLocalAddress of ''h (a zero-length octet-string). 2. An application that is willing to accept only IPv4 or IPv6 datagrams is represented by a tcpListenerLocalAddressType of the appropriate address type and a tcpListenerLocalAddress of '0.0.0.0' or '::' respectively. 3. An application that is listening for data destined only to a specific IP address, but from any remote system, is represented by a tcpListenerLocalAddressType of an appropriate address type, with tcpListenerLocalAddress as the specific local address. NOTE: The address type in this table represents the address type used for the communication, irrespective of the higher-layer abstraction. For example, an application using IPv6 'sockets' to communicate via IPv4 between ::ffff:10.0.0.1 and ::ffff:10.0.0.2 would use InetAddressType ipv4(1)).")
tcpListenerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 6, 20, 1), ).setIndexNames((0, "TCP-MIB", "tcpListenerLocalAddressType"), (0, "TCP-MIB", "tcpListenerLocalAddress"), (0, "TCP-MIB", "tcpListenerLocalPort"))
if mibBuilder.loadTexts: tcpListenerEntry.setStatus('current')
if mibBuilder.loadTexts: tcpListenerEntry.setDescription('A conceptual row of the tcpListenerTable containing information about a particular TCP listener.')
tcpListenerLocalAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 20, 1, 1), InetAddressType())
if mibBuilder.loadTexts: tcpListenerLocalAddressType.setStatus('current')
if mibBuilder.loadTexts: tcpListenerLocalAddressType.setDescription('The address type of tcpListenerLocalAddress. The value should be unknown (0) if connection initiations to all local IP addresses are accepted.')
tcpListenerLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 20, 1, 2), InetAddress())
if mibBuilder.loadTexts: tcpListenerLocalAddress.setStatus('current')
if mibBuilder.loadTexts: tcpListenerLocalAddress.setDescription("The local IP address for this TCP connection. The value of this object can be represented in three possible ways, depending on the characteristics of the listening application: 1. For an application willing to accept both IPv4 and IPv6 datagrams, the value of this object must be ''h (a zero-length octet-string), with the value of the corresponding tcpListenerLocalAddressType object being unknown (0). 2. For an application willing to accept only IPv4 or IPv6 datagrams, the value of this object must be '0.0.0.0' or '::' respectively, with tcpListenerLocalAddressType representing the appropriate address type. 3. For an application which is listening for data destined only to a specific IP address, the value of this object is the specific local address, with tcpListenerLocalAddressType representing the appropriate address type. As this object is used in the index for the tcpListenerTable, implementors should be careful not to create entries that would result in OIDs with more than 128 subidentifiers; otherwise the information cannot be accessed, using SNMPv1, SNMPv2c, or SNMPv3.")
tcpListenerLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 20, 1, 3), InetPortNumber())
if mibBuilder.loadTexts: tcpListenerLocalPort.setStatus('current')
if mibBuilder.loadTexts: tcpListenerLocalPort.setDescription('The local port number for this TCP connection.')
tcpListenerProcess = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 20, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpListenerProcess.setStatus('current')
if mibBuilder.loadTexts: tcpListenerProcess.setDescription("The system's process ID for the process associated with this listener, or zero if there is no such process. This value is expected to be the same as HOST-RESOURCES-MIB:: hrSWRunIndex or SYSAPPL-MIB::sysApplElmtRunIndex for some row in the appropriate tables.")
tcpConnTable = MibTable((1, 3, 6, 1, 2, 1, 6, 13), )
if mibBuilder.loadTexts: tcpConnTable.setStatus('deprecated')
if mibBuilder.loadTexts: tcpConnTable.setDescription('A table containing information about existing IPv4-specific TCP connections or listeners. This table has been deprecated in favor of the version neutral tcpConnectionTable.')
tcpConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 6, 13, 1), ).setIndexNames((0, "TCP-MIB", "tcpConnLocalAddress"), (0, "TCP-MIB", "tcpConnLocalPort"), (0, "TCP-MIB", "tcpConnRemAddress"), (0, "TCP-MIB", "tcpConnRemPort"))
if mibBuilder.loadTexts: tcpConnEntry.setStatus('deprecated')
if mibBuilder.loadTexts: tcpConnEntry.setDescription('A conceptual row of the tcpConnTable containing information about a particular current IPv4 TCP connection. Each row of this table is transient in that it ceases to exist when (or soon after) the connection makes the transition to the CLOSED state.')
tcpConnState = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))).clone(namedValues=NamedValues(("closed", 1), ("listen", 2), ("synSent", 3), ("synReceived", 4), ("established", 5), ("finWait1", 6), ("finWait2", 7), ("closeWait", 8), ("lastAck", 9), ("closing", 10), ("timeWait", 11), ("deleteTCB", 12)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpConnState.setStatus('deprecated')
if mibBuilder.loadTexts: tcpConnState.setDescription("The state of this TCP connection. The only value that may be set by a management station is deleteTCB(12). Accordingly, it is appropriate for an agent to return a `badValue' response if a management station attempts to set this object to any other value. If a management station sets this object to the value deleteTCB(12), then the TCB (as defined in [RFC793]) of the corresponding connection on the managed node is deleted, resulting in immediate termination of the connection. As an implementation-specific option, a RST segment may be sent from the managed node to the other TCP endpoint (note, however, that RST segments are not sent reliably).")
tcpConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnLocalAddress.setStatus('deprecated')
if mibBuilder.loadTexts: tcpConnLocalAddress.setDescription('The local IP address for this TCP connection. In the case of a connection in the listen state willing to accept connections for any IP interface associated with the node, the value 0.0.0.0 is used.')
tcpConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnLocalPort.setStatus('deprecated')
if mibBuilder.loadTexts: tcpConnLocalPort.setDescription('The local port number for this TCP connection.')
tcpConnRemAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 4), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnRemAddress.setStatus('deprecated')
if mibBuilder.loadTexts: tcpConnRemAddress.setDescription('The remote IP address for this TCP connection.')
tcpConnRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnRemPort.setStatus('deprecated')
if mibBuilder.loadTexts: tcpConnRemPort.setDescription('The remote port number for this TCP connection.')
tcpMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 49, 2))
tcpMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 49, 2, 1))
tcpMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 49, 2, 2))
tcpMIBCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 49, 2, 1, 2)).setObjects(("TCP-MIB", "tcpBaseGroup"), ("TCP-MIB", "tcpConnectionGroup"), ("TCP-MIB", "tcpListenerGroup"), ("TCP-MIB", "tcpHCGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    tcpMIBCompliance2 = tcpMIBCompliance2.setStatus('current')
if mibBuilder.loadTexts: tcpMIBCompliance2.setDescription('The compliance statement for systems that implement TCP. A number of INDEX objects cannot be represented in the form of OBJECT clauses in SMIv2 but have the following compliance requirements, expressed in OBJECT clause form in this description clause: -- OBJECT tcpConnectionLocalAddressType -- SYNTAX InetAddressType { ipv4(1), ipv6(2) } -- DESCRIPTION -- This MIB requires support for only global IPv4 -- and IPv6 address types. -- -- OBJECT tcpConnectionRemAddressType -- SYNTAX InetAddressType { ipv4(1), ipv6(2) } -- DESCRIPTION -- This MIB requires support for only global IPv4 -- and IPv6 address types. -- -- OBJECT tcpListenerLocalAddressType -- SYNTAX InetAddressType { unknown(0), ipv4(1), -- ipv6(2) } -- DESCRIPTION -- This MIB requires support for only global IPv4 -- and IPv6 address types. The type unknown also -- needs to be supported to identify a special -- case in the listener table: a listen using -- both IPv4 and IPv6 addresses on the device. -- ')
tcpMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 49, 2, 1, 1)).setObjects(("TCP-MIB", "tcpGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    tcpMIBCompliance = tcpMIBCompliance.setStatus('deprecated')
if mibBuilder.loadTexts: tcpMIBCompliance.setDescription('The compliance statement for IPv4-only systems that implement TCP. In order to be IP version independent, this compliance statement is deprecated in favor of tcpMIBCompliance2. However, agents are still encouraged to implement these objects in order to interoperate with the deployed base of managers.')
tcpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 49, 2, 2, 1)).setObjects(("TCP-MIB", "tcpRtoAlgorithm"), ("TCP-MIB", "tcpRtoMin"), ("TCP-MIB", "tcpRtoMax"), ("TCP-MIB", "tcpMaxConn"), ("TCP-MIB", "tcpActiveOpens"), ("TCP-MIB", "tcpPassiveOpens"), ("TCP-MIB", "tcpAttemptFails"), ("TCP-MIB", "tcpEstabResets"), ("TCP-MIB", "tcpCurrEstab"), ("TCP-MIB", "tcpInSegs"), ("TCP-MIB", "tcpOutSegs"), ("TCP-MIB", "tcpRetransSegs"), ("TCP-MIB", "tcpConnState"), ("TCP-MIB", "tcpConnLocalAddress"), ("TCP-MIB", "tcpConnLocalPort"), ("TCP-MIB", "tcpConnRemAddress"), ("TCP-MIB", "tcpConnRemPort"), ("TCP-MIB", "tcpInErrs"), ("TCP-MIB", "tcpOutRsts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    tcpGroup = tcpGroup.setStatus('deprecated')
if mibBuilder.loadTexts: tcpGroup.setDescription('The tcp group of objects providing for management of TCP entities.')
tcpBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 49, 2, 2, 2)).setObjects(("TCP-MIB", "tcpRtoAlgorithm"), ("TCP-MIB", "tcpRtoMin"), ("TCP-MIB", "tcpRtoMax"), ("TCP-MIB", "tcpMaxConn"), ("TCP-MIB", "tcpActiveOpens"), ("TCP-MIB", "tcpPassiveOpens"), ("TCP-MIB", "tcpAttemptFails"), ("TCP-MIB", "tcpEstabResets"), ("TCP-MIB", "tcpCurrEstab"), ("TCP-MIB", "tcpInSegs"), ("TCP-MIB", "tcpOutSegs"), ("TCP-MIB", "tcpRetransSegs"), ("TCP-MIB", "tcpInErrs"), ("TCP-MIB", "tcpOutRsts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    tcpBaseGroup = tcpBaseGroup.setStatus('current')
if mibBuilder.loadTexts: tcpBaseGroup.setDescription('The group of counters common to TCP entities.')
tcpConnectionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 49, 2, 2, 3)).setObjects(("TCP-MIB", "tcpConnectionState"), ("TCP-MIB", "tcpConnectionProcess"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    tcpConnectionGroup = tcpConnectionGroup.setStatus('current')
if mibBuilder.loadTexts: tcpConnectionGroup.setDescription('The group provides general information about TCP connections.')
tcpListenerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 49, 2, 2, 4)).setObjects(("TCP-MIB", "tcpListenerProcess"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    tcpListenerGroup = tcpListenerGroup.setStatus('current')
if mibBuilder.loadTexts: tcpListenerGroup.setDescription('This group has objects providing general information about TCP listeners.')
tcpHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 49, 2, 2, 5)).setObjects(("TCP-MIB", "tcpHCInSegs"), ("TCP-MIB", "tcpHCOutSegs"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    tcpHCGroup = tcpHCGroup.setStatus('current')
if mibBuilder.loadTexts: tcpHCGroup.setDescription('The group of objects providing for counters of high speed TCP implementations.')
mibBuilder.exportSymbols("TCP-MIB", tcpInErrs=tcpInErrs, tcpRtoMax=tcpRtoMax, tcpPassiveOpens=tcpPassiveOpens, tcpListenerLocalAddress=tcpListenerLocalAddress, tcpOutSegs=tcpOutSegs, tcpListenerGroup=tcpListenerGroup, tcpMIBCompliance2=tcpMIBCompliance2, tcpCurrEstab=tcpCurrEstab, tcpConnectionRemPort=tcpConnectionRemPort, tcpRtoAlgorithm=tcpRtoAlgorithm, tcpConnectionGroup=tcpConnectionGroup, tcpConnectionRemAddress=tcpConnectionRemAddress, tcpHCGroup=tcpHCGroup, tcpMIBCompliance=tcpMIBCompliance, tcpGroup=tcpGroup, tcpListenerLocalPort=tcpListenerLocalPort, tcpConnState=tcpConnState, tcpMaxConn=tcpMaxConn, tcpInSegs=tcpInSegs, tcpConnectionRemAddressType=tcpConnectionRemAddressType, tcpOutRsts=tcpOutRsts, tcpConnectionProcess=tcpConnectionProcess, tcpListenerTable=tcpListenerTable, tcpListenerLocalAddressType=tcpListenerLocalAddressType, tcpConnTable=tcpConnTable, tcpRtoMin=tcpRtoMin, PYSNMP_MODULE_ID=tcpMIB, tcpRetransSegs=tcpRetransSegs, tcpConnLocalAddress=tcpConnLocalAddress, tcpBaseGroup=tcpBaseGroup, tcpConnEntry=tcpConnEntry, tcpConnectionEntry=tcpConnectionEntry, tcpHCOutSegs=tcpHCOutSegs, tcpConnectionTable=tcpConnectionTable, tcpConnectionLocalAddress=tcpConnectionLocalAddress, tcpConnRemAddress=tcpConnRemAddress, tcpConnLocalPort=tcpConnLocalPort, tcpMIBCompliances=tcpMIBCompliances, tcp=tcp, tcpConnRemPort=tcpConnRemPort, tcpAttemptFails=tcpAttemptFails, tcpMIBGroups=tcpMIBGroups, tcpListenerEntry=tcpListenerEntry, tcpListenerProcess=tcpListenerProcess, tcpMIBConformance=tcpMIBConformance, tcpHCInSegs=tcpHCInSegs, tcpConnectionState=tcpConnectionState, tcpActiveOpens=tcpActiveOpens, tcpConnectionLocalAddressType=tcpConnectionLocalAddressType, tcpMIB=tcpMIB, tcpEstabResets=tcpEstabResets, tcpConnectionLocalPort=tcpConnectionLocalPort)
