#
# PySNMP MIB module UPS-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/UPS-MIB
# Produced by pysmi-0.3.4 at Thu Jun  4 15:12:01 2020
# On host tide platform Linux version 5.6.14-300.fc32.x86_64 by user spider
# Using Python version 3.8.3 (default, May 15 2020, 00:00:00) 
#
Integer, ObjectIdentifier, OctetString = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ConstraintsUnion, SingleValueConstraint, ConstraintsIntersection, ValueSizeConstraint, ValueRangeConstraint = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "SingleValueConstraint", "ConstraintsIntersection", "ValueSizeConstraint", "ValueRangeConstraint")
ObjectGroup, ModuleCompliance, NotificationGroup = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
Counter64, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, MibIdentifier, IpAddress, ObjectIdentity, Gauge32, ModuleIdentity, iso, Bits, Counter32, Integer32 = mibBuilder.importSymbols("SNMPv2-SMI", "Counter64", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "MibIdentifier", "IpAddress", "ObjectIdentity", "Gauge32", "ModuleIdentity", "iso", "Bits", "Counter32", "Integer32")
AutonomousType, TestAndIncr, DisplayString, TimeStamp, TimeInterval, TextualConvention = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "TestAndIncr", "DisplayString", "TimeStamp", "TimeInterval", "TextualConvention")
org = MibIdentifier((1, 3))
dod = MibIdentifier((1, 3, 6))
internet = MibIdentifier((1, 3, 6, 1))
mgmt = MibIdentifier((1, 3, 6, 1, 2))
mib_2 = MibIdentifier((1, 3, 6, 1, 2, 1)).setLabel("mib-2")
upsMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 33))
if mibBuilder.loadTexts: upsMIB.setLastUpdated('9402230000Z')
if mibBuilder.loadTexts: upsMIB.setOrganization('IETF UPS MIB Working Group')
if mibBuilder.loadTexts: upsMIB.setContactInfo(' Jeffrey D. Case Postal: SNMP Research, Incorporated 3001 Kimberlin Heights Road Knoxville, TN 37920 US Tel: +1 615 573 1434 Fax: +1 615 573 9197 E-mail: case@snmp.com')
if mibBuilder.loadTexts: upsMIB.setDescription('The MIB module to describe Uninterruptible Power Supplies. This version is extended for DIOAD.')
class PositiveInteger(TextualConvention, Integer32):
    description = 'This data type is a non-zero and non-negative value.'
    status = 'current'
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(1, 2147483647)

class NonNegativeInteger(TextualConvention, Integer32):
    description = 'This data type is a non-negative value.'
    status = 'current'
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(0, 2147483647)

upsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1))
upsIdent = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 1))
upsIdentManufacturer = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentManufacturer.setStatus('current')
if mibBuilder.loadTexts: upsIdentManufacturer.setDescription('The name of the UPS manufacturer.')
upsIdentModel = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentModel.setStatus('current')
if mibBuilder.loadTexts: upsIdentModel.setDescription('The UPS Model designation.')
upsIdentUPSSoftwareVersion = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentUPSSoftwareVersion.setStatus('current')
if mibBuilder.loadTexts: upsIdentUPSSoftwareVersion.setDescription('The UPS firmware/software version(s). This variable may or may not have the same value as upsIdentAgentSoftwareVersion in some implementations.')
upsIdentAgentSoftwareVersion = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentAgentSoftwareVersion.setStatus('current')
if mibBuilder.loadTexts: upsIdentAgentSoftwareVersion.setDescription('The UPS agent software version. This variable may or may not have the same value as upsIdentUPSSoftwareVersion in some implementations.')
upsIdentName = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsIdentName.setStatus('current')
if mibBuilder.loadTexts: upsIdentName.setDescription('A string identifying the UPS. This object should be set by the administrator.')
upsIdentAttachedDevices = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 6), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsIdentAttachedDevices.setStatus('current')
if mibBuilder.loadTexts: upsIdentAttachedDevices.setDescription('A string identifying the devices attached to the output(s) of the UPS. This object should be set by the administrator.')
upsSerialNumber = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 7), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsSerialNumber.setStatus('current')
if mibBuilder.loadTexts: upsSerialNumber.setDescription('The UPS Serial Number.')
upsLocation = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 8), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsLocation.setStatus('current')
if mibBuilder.loadTexts: upsLocation.setDescription('The UPS Location.')
upsSystemContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 9), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsSystemContact.setStatus('current')
if mibBuilder.loadTexts: upsSystemContact.setDescription('The UPS System Contact.')
upsBattery = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 2))
upsBatteryStatus = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4))).clone(namedValues=NamedValues(("unknown", 1), ("batteryNormal", 2), ("batteryLow", 3), ("batteryDepleted", 4)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBatteryStatus.setStatus('current')
if mibBuilder.loadTexts: upsBatteryStatus.setDescription("The indication of the capacity remaining in the UPS system's batteries. A value of batteryNormal indicates that the remaining run-time is greater than upsConfigLowBattTime. A value of batteryLow indicates that the remaining battery run-time is less than or equal to upsConfigLowBattTime. A value of batteryDepleted indicates that the UPS will be unable to sustain the present load when and if the utility power is lost (including the possibility that the utility power is currently absent and the UPS is unable to sustain the output).")
upsSecondsOnBattery = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 2), NonNegativeInteger()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsSecondsOnBattery.setStatus('current')
if mibBuilder.loadTexts: upsSecondsOnBattery.setDescription('If the unit is on battery power, the elapsed time since the UPS last switched to battery power, or the time since the network management subsystem was last restarted, whichever is less. Zero shall be returned if the unit is not on battery power.')
upsEstimatedMinutesRemaining = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 3), PositiveInteger()).setUnits('minutes').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsEstimatedMinutesRemaining.setStatus('current')
if mibBuilder.loadTexts: upsEstimatedMinutesRemaining.setDescription('An estimate of the time to battery charge depletion under the present load conditions if the utility power is off and remains off, or if it were to be lost and remain off.')
upsEstimatedChargeRemaining = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 100))).setUnits('percent').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsEstimatedChargeRemaining.setStatus('current')
if mibBuilder.loadTexts: upsEstimatedChargeRemaining.setDescription('An estimate of the battery charge remaining expressed as a percent of full charge.')
upsBatteryVoltage = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 5), NonNegativeInteger()).setUnits('0.1 Volt DC').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBatteryVoltage.setStatus('current')
if mibBuilder.loadTexts: upsBatteryVoltage.setDescription('The magnitude of the present battery voltage.')
upsBatteryCurrent = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 6), Integer32()).setUnits('0.1 Amp DC').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBatteryCurrent.setStatus('current')
if mibBuilder.loadTexts: upsBatteryCurrent.setDescription('The present battery current.')
upsBatteryTemperature = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 7), Integer32()).setUnits('degrees Centigrade').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBatteryTemperature.setStatus('current')
if mibBuilder.loadTexts: upsBatteryTemperature.setDescription('The ambient temperature at or near the UPS Battery casing.')
upsInput = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 3))
upsInputLineBads = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 3, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputLineBads.setStatus('current')
if mibBuilder.loadTexts: upsInputLineBads.setDescription('A count of the number of times the input entered an out-of-tolerance condition as defined by the manufacturer. This count is incremented by one each time the input transitions from zero out-of-tolerance lines to one or more input lines out-of-tolerance.')
upsInputNumLines = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 3, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputNumLines.setStatus('current')
if mibBuilder.loadTexts: upsInputNumLines.setDescription('The number of input lines utilized in this device. This variable indicates the number of rows in the input table.')
upsInputTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 3, 3), )
if mibBuilder.loadTexts: upsInputTable.setStatus('current')
if mibBuilder.loadTexts: upsInputTable.setDescription('A list of input table entries. The number of entries is given by the value of upsInputNumLines.')
upsInputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1), ).setIndexNames((0, "UPS-MIB", "upsInputLineIndex"))
if mibBuilder.loadTexts: upsInputEntry.setStatus('current')
if mibBuilder.loadTexts: upsInputEntry.setDescription('An entry containing information applicable to a particular input line.')
upsInputLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 1), PositiveInteger())
if mibBuilder.loadTexts: upsInputLineIndex.setStatus('current')
if mibBuilder.loadTexts: upsInputLineIndex.setDescription('The input line identifier.')
upsInputFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 2), NonNegativeInteger()).setUnits('0.1 Hertz').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputFrequency.setStatus('current')
if mibBuilder.loadTexts: upsInputFrequency.setDescription('The present input frequency.')
upsInputVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 3), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputVoltage.setStatus('current')
if mibBuilder.loadTexts: upsInputVoltage.setDescription('The magnitude of the present input voltage.')
upsInputCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 4), NonNegativeInteger()).setUnits('0.1 RMS Amp').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputCurrent.setStatus('current')
if mibBuilder.loadTexts: upsInputCurrent.setDescription('The magnitude of the present input current.')
upsInputTruePower = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 5), NonNegativeInteger()).setUnits('Watts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputTruePower.setStatus('current')
if mibBuilder.loadTexts: upsInputTruePower.setDescription('The magnitude of the present input true power.')
upsOutput = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 4))
upsOutputSource = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 4, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7))).clone(namedValues=NamedValues(("other", 1), ("none", 2), ("normal", 3), ("bypass", 4), ("battery", 5), ("booster", 6), ("reducer", 7)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputSource.setStatus('current')
if mibBuilder.loadTexts: upsOutputSource.setDescription('The present source of output power. The enumeration none(2) indicates that there is no source of output power (and therefore no output power), for example, the system has opened the output breaker.')
upsOutputFrequency = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 4, 2), NonNegativeInteger()).setUnits('0.1 Hertz').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputFrequency.setStatus('current')
if mibBuilder.loadTexts: upsOutputFrequency.setDescription('The present output frequency.')
upsOutputNumLines = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 4, 3), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputNumLines.setStatus('current')
if mibBuilder.loadTexts: upsOutputNumLines.setDescription('The number of output lines utilized in this device. This variable indicates the number of rows in the output table.')
upsOutputTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 4, 4), )
if mibBuilder.loadTexts: upsOutputTable.setStatus('current')
if mibBuilder.loadTexts: upsOutputTable.setDescription('A list of output table entries. The number of entries is given by the value of upsOutputNumLines.')
upsOutputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1), ).setIndexNames((0, "UPS-MIB", "upsOutputLineIndex"))
if mibBuilder.loadTexts: upsOutputEntry.setStatus('current')
if mibBuilder.loadTexts: upsOutputEntry.setDescription('An entry containing information applicable to a particular output line.')
upsOutputLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 1), PositiveInteger())
if mibBuilder.loadTexts: upsOutputLineIndex.setStatus('current')
if mibBuilder.loadTexts: upsOutputLineIndex.setDescription('The output line identifier.')
upsOutputVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 2), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputVoltage.setStatus('current')
if mibBuilder.loadTexts: upsOutputVoltage.setDescription('The present output voltage.')
upsOutputCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 3), NonNegativeInteger()).setUnits('0.1 RMS Amp').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputCurrent.setStatus('current')
if mibBuilder.loadTexts: upsOutputCurrent.setDescription('The present output current.')
upsOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 4), NonNegativeInteger()).setUnits('Watts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputPower.setStatus('current')
if mibBuilder.loadTexts: upsOutputPower.setDescription('The present output true power.')
upsOutputPercentLoad = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 200))).setUnits('percent').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputPercentLoad.setStatus('current')
if mibBuilder.loadTexts: upsOutputPercentLoad.setDescription('The percentage of the UPS power capacity presently being used on this output line, i.e., the greater of the percent load of true power capacity and the percent load of VA.')
upsBypass = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 5))
upsBypassFrequency = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 5, 1), NonNegativeInteger()).setUnits('0.1 Hertz').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassFrequency.setStatus('current')
if mibBuilder.loadTexts: upsBypassFrequency.setDescription('The present bypass frequency.')
upsBypassNumLines = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 5, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassNumLines.setStatus('current')
if mibBuilder.loadTexts: upsBypassNumLines.setDescription('The number of bypass lines utilized in this device. This entry indicates the number of rows in the bypass table.')
upsBypassTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 5, 3), )
if mibBuilder.loadTexts: upsBypassTable.setStatus('current')
if mibBuilder.loadTexts: upsBypassTable.setDescription('A list of bypass table entries. The number of entries is given by the value of upsBypassNumLines.')
upsBypassEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1), ).setIndexNames((0, "UPS-MIB", "upsBypassLineIndex"))
if mibBuilder.loadTexts: upsBypassEntry.setStatus('current')
if mibBuilder.loadTexts: upsBypassEntry.setDescription('An entry containing information applicable to a particular bypass input.')
upsBypassLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 1), PositiveInteger())
if mibBuilder.loadTexts: upsBypassLineIndex.setStatus('current')
if mibBuilder.loadTexts: upsBypassLineIndex.setDescription('The bypass line identifier.')
upsBypassVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 2), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassVoltage.setStatus('current')
if mibBuilder.loadTexts: upsBypassVoltage.setDescription('The present bypass voltage.')
upsBypassCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 3), NonNegativeInteger()).setUnits('0.1 RMS Amp').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassCurrent.setStatus('current')
if mibBuilder.loadTexts: upsBypassCurrent.setDescription('The present bypass current.')
upsBypassPower = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 4), NonNegativeInteger()).setUnits('Watts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassPower.setStatus('current')
if mibBuilder.loadTexts: upsBypassPower.setDescription('The present true power conveyed by the bypass.')
upsAlarm = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 6))
upsAlarmsPresent = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 6, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsAlarmsPresent.setStatus('current')
if mibBuilder.loadTexts: upsAlarmsPresent.setDescription('The present number of active alarm conditions.')
upsAlarmTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 6, 2), )
if mibBuilder.loadTexts: upsAlarmTable.setStatus('current')
if mibBuilder.loadTexts: upsAlarmTable.setDescription('A list of alarm table entries. The table contains zero, one, or many rows at any moment, depending upon the number of alarm conditions in effect. The table is initially empty at agent startup. The agent creates a row in the table each time a condition is detected and deletes that row when that condition no longer pertains. The agent creates the first row with upsAlarmId equal to 1, and increments the value of upsAlarmId each time a new row is created, wrapping to the first free value greater than or equal to 1 when the maximum value of upsAlarmId would otherwise be exceeded. Consequently, after multiple operations, the table may become sparse, e.g., containing entries for rows 95, 100, 101, and 203 and the entries should not be assumed to be in chronological order because upsAlarmId might have wrapped. Alarms are named by an AutonomousType (OBJECT IDENTIFIER), upsAlarmDescr, to allow a single table to reflect well known alarms plus alarms defined by a particular implementation, i.e., as documented in the private enterprise MIB definition for the device. No two rows will have the same value of upsAlarmDescr, since alarms define conditions. In order to meet this requirement, care should be taken in the definition of alarm conditions to insure that a system cannot enter the same condition multiple times simultaneously. The number of rows in the table at any given time is reflected by the value of upsAlarmsPresent.')
upsAlarmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1), ).setIndexNames((0, "UPS-MIB", "upsAlarmId"))
if mibBuilder.loadTexts: upsAlarmEntry.setStatus('current')
if mibBuilder.loadTexts: upsAlarmEntry.setDescription('An entry containing information applicable to a particular alarm.')
upsAlarmId = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1, 1), PositiveInteger())
if mibBuilder.loadTexts: upsAlarmId.setStatus('current')
if mibBuilder.loadTexts: upsAlarmId.setDescription('A unique identifier for an alarm condition. This value must remain constant.')
upsAlarmDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsAlarmDescr.setStatus('current')
if mibBuilder.loadTexts: upsAlarmDescr.setDescription('A reference to an alarm description object. The object referenced should not be accessible, but rather be used to provide a unique description of the alarm condition.')
upsAlarmTime = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsAlarmTime.setStatus('current')
if mibBuilder.loadTexts: upsAlarmTime.setDescription('The value of sysUpTime when the alarm condition was detected. If the alarm condition was detected at the time of agent startup and presumably existed before agent startup, the value of upsAlarmTime shall equal 0.')
upsWellKnownAlarms = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 6, 3))
upsAlarmBatteryBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 1))
if mibBuilder.loadTexts: upsAlarmBatteryBad.setStatus('current')
if mibBuilder.loadTexts: upsAlarmBatteryBad.setDescription('One or more batteries have been determined to require replacement.')
upsAlarmOnBattery = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 2))
if mibBuilder.loadTexts: upsAlarmOnBattery.setStatus('current')
if mibBuilder.loadTexts: upsAlarmOnBattery.setDescription('The UPS is drawing power from the batteries.')
upsAlarmLowBattery = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 3))
if mibBuilder.loadTexts: upsAlarmLowBattery.setStatus('current')
if mibBuilder.loadTexts: upsAlarmLowBattery.setDescription('The remaining battery run-time is less than or equal to upsConfigLowBattTime.')
upsAlarmDepletedBattery = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 4))
if mibBuilder.loadTexts: upsAlarmDepletedBattery.setStatus('current')
if mibBuilder.loadTexts: upsAlarmDepletedBattery.setDescription('The UPS will be unable to sustain the present load when and if the utility power is lost.')
upsAlarmTempBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 5))
if mibBuilder.loadTexts: upsAlarmTempBad.setStatus('current')
if mibBuilder.loadTexts: upsAlarmTempBad.setDescription('A temperature is out of tolerance.')
upsAlarmInputBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 6))
if mibBuilder.loadTexts: upsAlarmInputBad.setStatus('current')
if mibBuilder.loadTexts: upsAlarmInputBad.setDescription('An input condition is out of tolerance.')
upsAlarmOutputBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 7))
if mibBuilder.loadTexts: upsAlarmOutputBad.setStatus('current')
if mibBuilder.loadTexts: upsAlarmOutputBad.setDescription('An output condition (other than OutputOverload) is out of tolerance.')
upsAlarmOutputOverload = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 8))
if mibBuilder.loadTexts: upsAlarmOutputOverload.setStatus('current')
if mibBuilder.loadTexts: upsAlarmOutputOverload.setDescription('The output load exceeds the UPS output capacity.')
upsAlarmOnBypass = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 9))
if mibBuilder.loadTexts: upsAlarmOnBypass.setStatus('current')
if mibBuilder.loadTexts: upsAlarmOnBypass.setDescription('The Bypass is presently engaged on the UPS.')
upsAlarmBypassBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 10))
if mibBuilder.loadTexts: upsAlarmBypassBad.setStatus('current')
if mibBuilder.loadTexts: upsAlarmBypassBad.setDescription('The Bypass is out of tolerance.')
upsAlarmOutputOffAsRequested = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 11))
if mibBuilder.loadTexts: upsAlarmOutputOffAsRequested.setStatus('current')
if mibBuilder.loadTexts: upsAlarmOutputOffAsRequested.setDescription('The UPS has shutdown as requested, i.e., the output is off.')
upsAlarmUpsOffAsRequested = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 12))
if mibBuilder.loadTexts: upsAlarmUpsOffAsRequested.setStatus('current')
if mibBuilder.loadTexts: upsAlarmUpsOffAsRequested.setDescription('The entire UPS has shutdown as commanded.')
upsAlarmChargerFailed = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 13))
if mibBuilder.loadTexts: upsAlarmChargerFailed.setStatus('current')
if mibBuilder.loadTexts: upsAlarmChargerFailed.setDescription('An uncorrected problem has been detected within the UPS charger subsystem.')
upsAlarmUpsOutputOff = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 14))
if mibBuilder.loadTexts: upsAlarmUpsOutputOff.setStatus('current')
if mibBuilder.loadTexts: upsAlarmUpsOutputOff.setDescription('The output of the UPS is in the off state.')
upsAlarmUpsSystemOff = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 15))
if mibBuilder.loadTexts: upsAlarmUpsSystemOff.setStatus('current')
if mibBuilder.loadTexts: upsAlarmUpsSystemOff.setDescription('The UPS system is in the off state.')
upsAlarmFanFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 16))
if mibBuilder.loadTexts: upsAlarmFanFailure.setStatus('current')
if mibBuilder.loadTexts: upsAlarmFanFailure.setDescription('The failure of one or more fans in the UPS has been detected.')
upsAlarmFuseFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 17))
if mibBuilder.loadTexts: upsAlarmFuseFailure.setStatus('current')
if mibBuilder.loadTexts: upsAlarmFuseFailure.setDescription('The failure of one or more fuses has been detected.')
upsAlarmGeneralFault = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 18))
if mibBuilder.loadTexts: upsAlarmGeneralFault.setStatus('current')
if mibBuilder.loadTexts: upsAlarmGeneralFault.setDescription('A general fault in the UPS has been detected.')
upsAlarmDiagnosticTestFailed = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 19))
if mibBuilder.loadTexts: upsAlarmDiagnosticTestFailed.setStatus('current')
if mibBuilder.loadTexts: upsAlarmDiagnosticTestFailed.setDescription('The result of the last diagnostic test indicates a failure.')
upsAlarmCommunicationsLost = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 20))
if mibBuilder.loadTexts: upsAlarmCommunicationsLost.setStatus('current')
if mibBuilder.loadTexts: upsAlarmCommunicationsLost.setDescription('A problem has been encountered in the communications between the agent and the UPS.')
upsAlarmAwaitingPower = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 21))
if mibBuilder.loadTexts: upsAlarmAwaitingPower.setStatus('current')
if mibBuilder.loadTexts: upsAlarmAwaitingPower.setDescription('The UPS output is off and the UPS is awaiting the return of input power.')
upsAlarmShutdownPending = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 22))
if mibBuilder.loadTexts: upsAlarmShutdownPending.setStatus('current')
if mibBuilder.loadTexts: upsAlarmShutdownPending.setDescription('A upsShutdownAfterDelay countdown is underway.')
upsAlarmShutdownImminent = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 23))
if mibBuilder.loadTexts: upsAlarmShutdownImminent.setStatus('current')
if mibBuilder.loadTexts: upsAlarmShutdownImminent.setDescription('The UPS will turn off power to the load in less than 5 seconds; this may be either a timed shutdown or a low battery shutdown.')
upsAlarmTestInProgress = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 24))
if mibBuilder.loadTexts: upsAlarmTestInProgress.setStatus('current')
if mibBuilder.loadTexts: upsAlarmTestInProgress.setDescription('A test is in progress, as initiated and indicated by the Test Group. Tests initiated via other implementation-specific mechanisms can indicate the presence of the testing in the alarm table, if desired, via a OBJECT-IDENTITY macro in the MIB document specific to that implementation and are outside the scope of this OBJECT-IDENTITY.')
alarmAUXInput1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 25))
if mibBuilder.loadTexts: alarmAUXInput1.setStatus('current')
if mibBuilder.loadTexts: alarmAUXInput1.setDescription('Alarm AUX Input 1.')
alarmAUXInput2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 26))
if mibBuilder.loadTexts: alarmAUXInput2.setStatus('current')
if mibBuilder.loadTexts: alarmAUXInput2.setDescription('Alarm AUX Input 2.')
alarmAUXInput3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 27))
if mibBuilder.loadTexts: alarmAUXInput3.setStatus('current')
if mibBuilder.loadTexts: alarmAUXInput3.setDescription('Alarm AUX Input 3.')
alarmAUXInput4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 28))
if mibBuilder.loadTexts: alarmAUXInput4.setStatus('current')
if mibBuilder.loadTexts: alarmAUXInput4.setDescription('Alarm AUX Input 4.')
alarmSiteManagerDigitalInput1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 29))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput1.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput1.setDescription('Alarm SiteManager Digital Input 1.')
alarmSiteManagerDigitalInput2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 30))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput2.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput2.setDescription('Alarm SiteManager Digital Input 2.')
alarmSiteManagerDigitalInput3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 31))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput3.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput3.setDescription('Alarm SiteManager Digital Input 3.')
alarmSiteManagerDigitalInput4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 32))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput4.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput4.setDescription('Alarm SiteManager Digital Input 4.')
alarmSiteManagerDigitalInput5 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 33))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput5.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput5.setDescription('Alarm SiteManager Digital Input 5.')
alarmSiteManagerDigitalInput6 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 34))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput6.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput6.setDescription('Alarm SiteManager Digital Input 6.')
alarmSiteManagerDigitalInput7 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 35))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput7.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput7.setDescription('Alarm SiteManager Digital Input 7.')
alarmSiteManagerDigitalInput8 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 36))
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput8.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerDigitalInput8.setDescription('Alarm SiteManager Digital Input 8.')
alarmSiteManagerAnalogInput1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 37))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput1.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput1.setDescription('Alarm SiteManager Analog Input 1.')
alarmSiteManagerAnalogInput2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 38))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput2.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput2.setDescription('Alarm SiteManager Analog Input 2.')
alarmSiteManagerAnalogInput3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 39))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput3.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput3.setDescription('Alarm SiteManager Analog Input 3.')
alarmSiteManagerAnalogInput4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 40))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput4.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput4.setDescription('Alarm SiteManager Analog Input 4.')
alarmSiteManagerAnalogInput5 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 41))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput5.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput5.setDescription('Alarm SiteManager Analog Input 5.')
alarmSiteManagerAnalogInput6 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 42))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput6.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput6.setDescription('Alarm SiteManager Analog Input 6.')
alarmSiteManagerAnalogInput7 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 43))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput7.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput7.setDescription('Alarm SiteManager Analog Input 7.')
alarmSiteManagerAnalogInput8 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 44))
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput8.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerAnalogInput8.setDescription('Alarm SiteManager Analog Input 8.')
alarmSiteManagerMarker1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 45))
if mibBuilder.loadTexts: alarmSiteManagerMarker1.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker1.setDescription('Alarm SiteManager Marker 1.')
alarmSiteManagerMarker2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 46))
if mibBuilder.loadTexts: alarmSiteManagerMarker2.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker2.setDescription('Alarm SiteManager Marker 2.')
alarmSiteManagerMarker3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 47))
if mibBuilder.loadTexts: alarmSiteManagerMarker3.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker3.setDescription('Alarm SiteManager Marker 3.')
alarmSiteManagerMarker4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 48))
if mibBuilder.loadTexts: alarmSiteManagerMarker4.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker4.setDescription('Alarm SiteManager Marker 4.')
alarmSiteManagerMarker5 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 49))
if mibBuilder.loadTexts: alarmSiteManagerMarker5.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker5.setDescription('Alarm SiteManager Marker 5.')
alarmSiteManagerMarker6 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 50))
if mibBuilder.loadTexts: alarmSiteManagerMarker6.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker6.setDescription('Alarm SiteManager Marker 6.')
alarmSiteManagerMarker7 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 51))
if mibBuilder.loadTexts: alarmSiteManagerMarker7.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker7.setDescription('Alarm SiteManager Marker 7.')
alarmSiteManagerMarker8 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 52))
if mibBuilder.loadTexts: alarmSiteManagerMarker8.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerMarker8.setDescription('Alarm SiteManager Marker 8.')
alarmSiteManagerOutput1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 53))
if mibBuilder.loadTexts: alarmSiteManagerOutput1.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput1.setDescription('Alarm SiteManager Output 1.')
alarmSiteManagerOutput2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 54))
if mibBuilder.loadTexts: alarmSiteManagerOutput2.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput2.setDescription('Alarm SiteManager Output 2.')
alarmSiteManagerOutput3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 55))
if mibBuilder.loadTexts: alarmSiteManagerOutput3.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput3.setDescription('Alarm SiteManager Output 3.')
alarmSiteManagerOutput4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 56))
if mibBuilder.loadTexts: alarmSiteManagerOutput4.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput4.setDescription('Alarm SiteManager Output 4.')
alarmSiteManagerOutput5 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 57))
if mibBuilder.loadTexts: alarmSiteManagerOutput5.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput5.setDescription('Alarm SiteManager Output 5.')
alarmSiteManagerOutput6 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 58))
if mibBuilder.loadTexts: alarmSiteManagerOutput6.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput6.setDescription('Alarm SiteManager Output 6.')
alarmSiteManagerOutput7 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 59))
if mibBuilder.loadTexts: alarmSiteManagerOutput7.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput7.setDescription('Alarm SiteManager Output 7.')
alarmSiteManagerOutput8 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 60))
if mibBuilder.loadTexts: alarmSiteManagerOutput8.setStatus('current')
if mibBuilder.loadTexts: alarmSiteManagerOutput8.setDescription('Alarm SiteManager Output 8.')
alarmSiteMonitor1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 61))
if mibBuilder.loadTexts: alarmSiteMonitor1.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor1.setDescription('Alarm SiteMonitor 1.')
alarmSiteMonitor2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 62))
if mibBuilder.loadTexts: alarmSiteMonitor2.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor2.setDescription('Alarm SiteMonitor 2.')
alarmSiteMonitor3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 63))
if mibBuilder.loadTexts: alarmSiteMonitor3.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor3.setDescription('Alarm SiteMonitor 3.')
alarmSiteMonitor4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 64))
if mibBuilder.loadTexts: alarmSiteMonitor4.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor4.setDescription('Alarm SiteMonitor 4.')
alarmSiteMonitor5 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 65))
if mibBuilder.loadTexts: alarmSiteMonitor5.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor5.setDescription('Alarm SiteMonitor 5.')
alarmSiteMonitor6 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 66))
if mibBuilder.loadTexts: alarmSiteMonitor6.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor6.setDescription('Alarm SiteMonitor 6.')
alarmSiteMonitor7 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 67))
if mibBuilder.loadTexts: alarmSiteMonitor7.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor7.setDescription('Alarm SiteMonitor 7.')
alarmSiteMonitor8 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 68))
if mibBuilder.loadTexts: alarmSiteMonitor8.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor8.setDescription('Alarm SiteMonitor 8.')
alarmSiteMonitor9 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 69))
if mibBuilder.loadTexts: alarmSiteMonitor9.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor9.setDescription('Alarm SiteMonitor 9.')
alarmSiteMonitor10 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 70))
if mibBuilder.loadTexts: alarmSiteMonitor10.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor10.setDescription('Alarm SiteMonitor 10.')
alarmSiteMonitor11 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 71))
if mibBuilder.loadTexts: alarmSiteMonitor11.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor11.setDescription('Alarm SiteMonitor 11.')
alarmSiteMonitor12 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 72))
if mibBuilder.loadTexts: alarmSiteMonitor12.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor12.setDescription('Alarm SiteMonitor 12.')
alarmSiteMonitor13 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 73))
if mibBuilder.loadTexts: alarmSiteMonitor13.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor13.setDescription('Alarm SiteMonitor 13.')
alarmSiteMonitor14 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 74))
if mibBuilder.loadTexts: alarmSiteMonitor14.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor14.setDescription('Alarm SiteMonitor 14.')
alarmSiteMonitor15 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 75))
if mibBuilder.loadTexts: alarmSiteMonitor15.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor15.setDescription('Alarm SiteMonitor 15.')
alarmSiteMonitor16 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 76))
if mibBuilder.loadTexts: alarmSiteMonitor16.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor16.setDescription('Alarm SiteMonitor 16.')
alarmSiteMonitor17 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 77))
if mibBuilder.loadTexts: alarmSiteMonitor17.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor17.setDescription('Alarm SiteMonitor 17.')
alarmSiteMonitor18 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 78))
if mibBuilder.loadTexts: alarmSiteMonitor18.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor18.setDescription('Alarm SiteMonitor 18.')
alarmSiteMonitor19 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 79))
if mibBuilder.loadTexts: alarmSiteMonitor19.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor19.setDescription('Alarm SiteMonitor 19.')
alarmSiteMonitor20 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 80))
if mibBuilder.loadTexts: alarmSiteMonitor20.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor20.setDescription('Alarm SiteMonitor 20.')
alarmSiteMonitor21 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 81))
if mibBuilder.loadTexts: alarmSiteMonitor21.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor21.setDescription('Alarm SiteMonitor 21.')
alarmSiteMonitor22 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 82))
if mibBuilder.loadTexts: alarmSiteMonitor22.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor22.setDescription('Alarm SiteMonitor 22.')
alarmSiteMonitor23 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 83))
if mibBuilder.loadTexts: alarmSiteMonitor23.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor23.setDescription('Alarm SiteMonitor 23.')
alarmSiteMonitor24 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 84))
if mibBuilder.loadTexts: alarmSiteMonitor24.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor24.setDescription('Alarm SiteMonitor 24.')
alarmSiteMonitor25 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 85))
if mibBuilder.loadTexts: alarmSiteMonitor25.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor25.setDescription('Alarm SiteMonitor 25.')
alarmSiteMonitor26 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 86))
if mibBuilder.loadTexts: alarmSiteMonitor26.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor26.setDescription('Alarm SiteMonitor 26.')
alarmSiteMonitor27 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 87))
if mibBuilder.loadTexts: alarmSiteMonitor27.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor27.setDescription('Alarm SiteMonitor 27.')
alarmSiteMonitor28 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 88))
if mibBuilder.loadTexts: alarmSiteMonitor28.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor28.setDescription('Alarm SiteMonitor 28.')
alarmSiteMonitor29 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 89))
if mibBuilder.loadTexts: alarmSiteMonitor29.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor29.setDescription('Alarm SiteMonitor 29.')
alarmSiteMonitor30 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 90))
if mibBuilder.loadTexts: alarmSiteMonitor30.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor30.setDescription('Alarm SiteMonitor 30.')
alarmSiteMonitor31 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 91))
if mibBuilder.loadTexts: alarmSiteMonitor31.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor31.setDescription('Alarm SiteMonitor 31.')
alarmSiteMonitor32 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 92))
if mibBuilder.loadTexts: alarmSiteMonitor32.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor32.setDescription('Alarm SiteMonitor 32.')
alarmSiteMonitor33 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 93))
if mibBuilder.loadTexts: alarmSiteMonitor33.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor33.setDescription('Alarm SiteMonitor 33.')
alarmSiteMonitor34 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 94))
if mibBuilder.loadTexts: alarmSiteMonitor34.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor34.setDescription('Alarm SiteMonitor 34.')
alarmSiteMonitor35 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 95))
if mibBuilder.loadTexts: alarmSiteMonitor35.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor35.setDescription('Alarm SiteMonitor 35.')
alarmSiteMonitor36 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 96))
if mibBuilder.loadTexts: alarmSiteMonitor36.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor36.setDescription('Alarm SiteMonitor 36.')
alarmSiteMonitor37 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 97))
if mibBuilder.loadTexts: alarmSiteMonitor37.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor37.setDescription('Alarm SiteMonitor 37.')
alarmSiteMonitor38 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 98))
if mibBuilder.loadTexts: alarmSiteMonitor38.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor38.setDescription('Alarm SiteMonitor 38.')
alarmSiteMonitor39 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 99))
if mibBuilder.loadTexts: alarmSiteMonitor39.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor39.setDescription('Alarm SiteMonitor 39.')
alarmSiteMonitor40 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 100))
if mibBuilder.loadTexts: alarmSiteMonitor40.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor40.setDescription('Alarm SiteMonitor 40.')
alarmSiteMonitor41 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 101))
if mibBuilder.loadTexts: alarmSiteMonitor41.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor41.setDescription('Alarm SiteMonitor 41.')
alarmSiteMonitor42 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 102))
if mibBuilder.loadTexts: alarmSiteMonitor42.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor42.setDescription('Alarm SiteMonitor 42.')
alarmSiteMonitor43 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 103))
if mibBuilder.loadTexts: alarmSiteMonitor43.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor43.setDescription('Alarm SiteMonitor 43.')
alarmSiteMonitor44 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 104))
if mibBuilder.loadTexts: alarmSiteMonitor44.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor44.setDescription('Alarm SiteMonitor 44.')
alarmSiteMonitor45 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 105))
if mibBuilder.loadTexts: alarmSiteMonitor45.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor45.setDescription('Alarm SiteMonitor 45.')
alarmSiteMonitor46 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 106))
if mibBuilder.loadTexts: alarmSiteMonitor46.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor46.setDescription('Alarm SiteMonitor 46.')
alarmSiteMonitor47 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 107))
if mibBuilder.loadTexts: alarmSiteMonitor47.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor47.setDescription('Alarm SiteMonitor 47.')
alarmSiteMonitor48 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 108))
if mibBuilder.loadTexts: alarmSiteMonitor48.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor48.setDescription('Alarm SiteMonitor 48.')
alarmSiteMonitor49 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 109))
if mibBuilder.loadTexts: alarmSiteMonitor49.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor49.setDescription('Alarm SiteMonitor 49.')
alarmSiteMonitor50 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 110))
if mibBuilder.loadTexts: alarmSiteMonitor50.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor50.setDescription('Alarm SiteMonitor 50.')
alarmSiteMonitor51 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 111))
if mibBuilder.loadTexts: alarmSiteMonitor51.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor51.setDescription('Alarm SiteMonitor 51.')
alarmSiteMonitor52 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 112))
if mibBuilder.loadTexts: alarmSiteMonitor52.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor52.setDescription('Alarm SiteMonitor 52.')
alarmSiteMonitor53 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 113))
if mibBuilder.loadTexts: alarmSiteMonitor53.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor53.setDescription('Alarm SiteMonitor 53.')
alarmSiteMonitor54 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 114))
if mibBuilder.loadTexts: alarmSiteMonitor54.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor54.setDescription('Alarm SiteMonitor 54.')
alarmSiteMonitor55 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 115))
if mibBuilder.loadTexts: alarmSiteMonitor55.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor55.setDescription('Alarm SiteMonitor 55.')
alarmSiteMonitor56 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 116))
if mibBuilder.loadTexts: alarmSiteMonitor56.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor56.setDescription('Alarm SiteMonitor 56.')
alarmSiteMonitor57 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 117))
if mibBuilder.loadTexts: alarmSiteMonitor57.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor57.setDescription('Alarm SiteMonitor 57.')
alarmSiteMonitor58 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 118))
if mibBuilder.loadTexts: alarmSiteMonitor58.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor58.setDescription('Alarm SiteMonitor 58.')
alarmSiteMonitor59 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 119))
if mibBuilder.loadTexts: alarmSiteMonitor59.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor59.setDescription('Alarm SiteMonitor 59.')
alarmSiteMonitor60 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 120))
if mibBuilder.loadTexts: alarmSiteMonitor60.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor60.setDescription('Alarm SiteMonitor 60.')
alarmSiteMonitor61 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 121))
if mibBuilder.loadTexts: alarmSiteMonitor61.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor61.setDescription('Alarm SiteMonitor 61.')
alarmSiteMonitor62 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 122))
if mibBuilder.loadTexts: alarmSiteMonitor62.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor62.setDescription('Alarm SiteMonitor 62.')
alarmSiteMonitor63 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 123))
if mibBuilder.loadTexts: alarmSiteMonitor63.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor63.setDescription('Alarm SiteMonitor 63.')
alarmSiteMonitor64 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 124))
if mibBuilder.loadTexts: alarmSiteMonitor64.setStatus('current')
if mibBuilder.loadTexts: alarmSiteMonitor64.setDescription('Alarm SiteMonitor 64.')
alarmSensorManager1Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 125))
if mibBuilder.loadTexts: alarmSensorManager1Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager1Low.setDescription('Alarm SensorManager sensor 1 lower threshold reached.')
alarmSensorManager2Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 126))
if mibBuilder.loadTexts: alarmSensorManager2Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager2Low.setDescription('Alarm SensorManager sensor 2 lower threshold reached.')
alarmSensorManager3Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 127))
if mibBuilder.loadTexts: alarmSensorManager3Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager3Low.setDescription('Alarm SensorManager sensor 3 lower threshold reached.')
alarmSensorManager4Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 128))
if mibBuilder.loadTexts: alarmSensorManager4Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager4Low.setDescription('Alarm SensorManager sensor 4 lower threshold reached.')
alarmSensorManager5Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 129))
if mibBuilder.loadTexts: alarmSensorManager5Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager5Low.setDescription('Alarm SensorManager sensor 5 lower threshold reached.')
alarmSensorManager6Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 130))
if mibBuilder.loadTexts: alarmSensorManager6Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager6Low.setDescription('Alarm SensorManager sensor 6 lower threshold reached.')
alarmSensorManager7Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 131))
if mibBuilder.loadTexts: alarmSensorManager7Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager7Low.setDescription('Alarm SensorManager sensor 7 lower threshold reached.')
alarmSensorManager8Low = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 132))
if mibBuilder.loadTexts: alarmSensorManager8Low.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager8Low.setDescription('Alarm SensorManager sensor 8 lower threshold reached.')
alarmSensorManager1High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 133))
if mibBuilder.loadTexts: alarmSensorManager1High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager1High.setDescription('Alarm SensorManager sensor 1 upper threshold reached.')
alarmSensorManager2High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 134))
if mibBuilder.loadTexts: alarmSensorManager2High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager2High.setDescription('Alarm SensorManager sensor 2 upper threshold reached.')
alarmSensorManager3High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 135))
if mibBuilder.loadTexts: alarmSensorManager3High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager3High.setDescription('Alarm SensorManager sensor 3 upper threshold reached.')
alarmSensorManager4High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 136))
if mibBuilder.loadTexts: alarmSensorManager4High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager4High.setDescription('Alarm SensorManager sensor 4 upper threshold reached.')
alarmSensorManager5High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 137))
if mibBuilder.loadTexts: alarmSensorManager5High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager5High.setDescription('Alarm SensorManager sensor 5 upper threshold reached.')
alarmSensorManager6High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 138))
if mibBuilder.loadTexts: alarmSensorManager6High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager6High.setDescription('Alarm SensorManager sensor 6 upper threshold reached.')
alarmSensorManager7High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 139))
if mibBuilder.loadTexts: alarmSensorManager7High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager7High.setDescription('Alarm SensorManager sensor 7 upper threshold reached.')
alarmSensorManager8High = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 140))
if mibBuilder.loadTexts: alarmSensorManager8High.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManager8High.setDescription('alarm SensorManager sensor 8 upper threshold reached.')
alarmUser1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 141))
if mibBuilder.loadTexts: alarmUser1.setStatus('current')
if mibBuilder.loadTexts: alarmUser1.setDescription('User defined alarm.')
alarmUser2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 142))
if mibBuilder.loadTexts: alarmUser2.setStatus('current')
if mibBuilder.loadTexts: alarmUser2.setDescription('User defined alarm 2.')
alarmUser3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 143))
if mibBuilder.loadTexts: alarmUser3.setStatus('current')
if mibBuilder.loadTexts: alarmUser3.setDescription('User defined alarm 3.')
alarmUser4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 144))
if mibBuilder.loadTexts: alarmUser4.setStatus('current')
if mibBuilder.loadTexts: alarmUser4.setDescription('User defined alarm 4.')
alarmUser5 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 145))
if mibBuilder.loadTexts: alarmUser5.setStatus('current')
if mibBuilder.loadTexts: alarmUser5.setDescription('User defined alarm 5.')
alarmUser6 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 146))
if mibBuilder.loadTexts: alarmUser6.setStatus('current')
if mibBuilder.loadTexts: alarmUser6.setDescription('User defined alarm 6.')
alarmUser7 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 147))
if mibBuilder.loadTexts: alarmUser7.setStatus('current')
if mibBuilder.loadTexts: alarmUser7.setDescription('User defined alarm 7.')
statusDischarging = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 148))
if mibBuilder.loadTexts: statusDischarging.setStatus('current')
if mibBuilder.loadTexts: statusDischarging.setDescription('Discharging')
statusCharging = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 149))
if mibBuilder.loadTexts: statusCharging.setStatus('current')
if mibBuilder.loadTexts: statusCharging.setDescription('Charging')
alarmSensorManagerInput1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 150))
if mibBuilder.loadTexts: alarmSensorManagerInput1.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerInput1.setDescription('Alarm SensorManager input 1 not normal.')
alarmSensorManagerInput2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 151))
if mibBuilder.loadTexts: alarmSensorManagerInput2.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerInput2.setDescription('Alarm SensorManager input 2 not normal.')
alarmSensorManagerInput3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 152))
if mibBuilder.loadTexts: alarmSensorManagerInput3.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerInput3.setDescription('Alarm SensorManager input 3 not normal.')
alarmSensorManagerInput4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 153))
if mibBuilder.loadTexts: alarmSensorManagerInput4.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerInput4.setDescription('Alarm SensorManager input 4 not normal.')
alarmSensorManagerOutput1 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 154))
if mibBuilder.loadTexts: alarmSensorManagerOutput1.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerOutput1.setDescription('Alarm SensorManager output 1 not normal.')
alarmSensorManagerOutput2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 155))
if mibBuilder.loadTexts: alarmSensorManagerOutput2.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerOutput2.setDescription('Alarm SensorManager output 2 not normal.')
alarmSensorManagerOutput3 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 156))
if mibBuilder.loadTexts: alarmSensorManagerOutput3.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerOutput3.setDescription('Alarm SensorManager output 3 not normal.')
alarmSensorManagerOutput4 = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 157))
if mibBuilder.loadTexts: alarmSensorManagerOutput4.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerOutput4.setDescription('Alarm SensorManager output 4 not normal.')
alarmSensorManagerComLost = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 158))
if mibBuilder.loadTexts: alarmSensorManagerComLost.setStatus('current')
if mibBuilder.loadTexts: alarmSensorManagerComLost.setDescription('Alarm SensorManager communication lost.')
alarmVuesWindalarm = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 159))
if mibBuilder.loadTexts: alarmVuesWindalarm.setStatus('current')
if mibBuilder.loadTexts: alarmVuesWindalarm.setDescription('Antennenmast Windalarm.')
alarmTransferswitchSourcesAsynchronous = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 160))
if mibBuilder.loadTexts: alarmTransferswitchSourcesAsynchronous.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchSourcesAsynchronous.setDescription('The Sources are not synchronous.')
alarmTransferswitchStaticSwitchAFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 161))
if mibBuilder.loadTexts: alarmTransferswitchStaticSwitchAFailure.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchStaticSwitchAFailure.setDescription('The failure of static Switch A has been detected.')
alarmTransferswitchStaticSwitchBFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 162))
if mibBuilder.loadTexts: alarmTransferswitchStaticSwitchBFailure.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchStaticSwitchBFailure.setDescription('The failure of static Switch B has been detected.')
alarmTransferswitchOnStaticSwitchA = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 163))
if mibBuilder.loadTexts: alarmTransferswitchOnStaticSwitchA.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchOnStaticSwitchA.setDescription('The static Switch A is presently engaged.')
alarmTransferswitchOnStaticSwitchB = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 164))
if mibBuilder.loadTexts: alarmTransferswitchOnStaticSwitchB.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchOnStaticSwitchB.setDescription('The static Switch B is presently engaged.')
alarmTransferswitchOnManualBypassA = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 165))
if mibBuilder.loadTexts: alarmTransferswitchOnManualBypassA.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchOnManualBypassA.setDescription('The manual Bypass A is presently engaged.')
alarmTransferswitchOnManualBypassB = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 166))
if mibBuilder.loadTexts: alarmTransferswitchOnManualBypassB.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchOnManualBypassB.setDescription('The manual Bypass B is presently engaged.')
alarmTransferswitchSourceAFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 167))
if mibBuilder.loadTexts: alarmTransferswitchSourceAFailure.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchSourceAFailure.setDescription('The failure of static Source A has been detected.')
alarmTransferswitchSourceBFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 168))
if mibBuilder.loadTexts: alarmTransferswitchSourceBFailure.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchSourceBFailure.setDescription('The failure of static Source B has been detected.')
alarmTransferswitchGeneralFault = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 169))
if mibBuilder.loadTexts: alarmTransferswitchGeneralFault.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchGeneralFault.setDescription('A general fault has been detected.')
alarmTransferswitchRedundancyLost = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 170))
if mibBuilder.loadTexts: alarmTransferswitchRedundancyLost.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchRedundancyLost.setDescription('Unable to switch to the alternate power source.')
alarmTransferswitchOutputOverload = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 171))
if mibBuilder.loadTexts: alarmTransferswitchOutputOverload.setStatus('current')
if mibBuilder.loadTexts: alarmTransferswitchOutputOverload.setDescription('The output load exceeds the output capacity.')
alarmBlackBoxReady = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 172))
if mibBuilder.loadTexts: alarmBlackBoxReady.setStatus('current')
if mibBuilder.loadTexts: alarmBlackBoxReady.setDescription('Black Box ready. This signals that history files are ready for download.')
upsAlarmInputAuxBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 173))
if mibBuilder.loadTexts: upsAlarmInputAuxBad.setStatus('current')
if mibBuilder.loadTexts: upsAlarmInputAuxBad.setDescription('An AUX input condition is out of tolerance.')
upsAlarmThresholdAlarm = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 174))
if mibBuilder.loadTexts: upsAlarmThresholdAlarm.setStatus('current')
if mibBuilder.loadTexts: upsAlarmThresholdAlarm.setDescription('A threshold alarm value, e.g. for voltage or current, has been exceeded.')
upsAlarmThresholdWarning = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 175))
if mibBuilder.loadTexts: upsAlarmThresholdWarning.setStatus('current')
if mibBuilder.loadTexts: upsAlarmThresholdWarning.setDescription('A threshold warning value, e.g. for voltage or current, has been exceeded.')
upsTest = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 7))
upsTestId = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 1), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsTestId.setStatus('current')
if mibBuilder.loadTexts: upsTestId.setDescription('The test is named by an OBJECT IDENTIFIER which allows a standard mechanism for the initiation of tests, including the well known tests identified in this document as well as those introduced by a particular implementation, i.e., as documented in the private enterprise MIB definition for the device. Setting this variable initiates the named test. Sets to this variable require the presence of upsTestSpinLock in the same SNMP message. The set request will be rejected with an appropriate error message if the requested test cannot be performed, including attempts to start a test when another test is already in progress. The status of the current or last test is maintained in upsTestResultsSummary. Tests in progress may be aborted by setting the upsTestId variable to upsTestAbortTestInProgress. Read operations return the value of the name of the test in progress if a test is in progress or the name of the last test performed if no test is in progress, unless no test has been run, in which case the well known value upsTestNoTestsInitiated is returned.')
upsTestSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 2), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsTestSpinLock.setStatus('current')
if mibBuilder.loadTexts: upsTestSpinLock.setDescription("A spin lock on the test subsystem. The spinlock is used as follows. Before starting a test, a manager-station should make sure that a test is not in progress as follows: try_again: get (upsTestSpinLock) while (upsTestResultsSummary == inProgress) { /* loop while a test is running for another manager */ short delay get (upsTestSpinLock) } lock_value = upsTestSpinLock /* no test in progress, start the test */ set (upsTestSpinLock = lock_value, upsTestId = requested_test) if (error_index == 1) { /* (upsTestSpinLock failed) */ /* if problem is not access control, then some other manager slipped in ahead of us */ goto try_again } if (error_index == 2) { /* (upsTestId) */ /* cannot perform the test */ give up } /* test started ok */ /* wait for test completion by polling upsTestResultsSummary */ get (upsTestSpinLock, upsTestResultsSummary, upsTestResultsDetail) while (upsTestResultsSummary == inProgress) { short delay get (upsTestSpinLock, upsTestResultsSummary, upsTestResultsDetail) } /* when test completes, retrieve any additional test results */ /* if upsTestSpinLock == lock_value + 1, then these are our test */ /* results (as opposed to another manager's */ The initial value of upsTestSpinLock at agent initialization shall be 1.")
upsTestResultsSummary = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6))).clone(namedValues=NamedValues(("donePass", 1), ("doneWarning", 2), ("doneError", 3), ("aborted", 4), ("inProgress", 5), ("noTestsInitiated", 6)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestResultsSummary.setStatus('current')
if mibBuilder.loadTexts: upsTestResultsSummary.setDescription('The results of the current or last UPS diagnostics test performed. The values for donePass(1), doneWarning(2), and doneError(3) indicate that the test completed either successfully, with a warning, or with an error, respectively. The value aborted(4) is returned for tests which are aborted by setting the value of upsTestId to upsTestAbortTestInProgress. Tests which have not yet concluded are indicated by inProgress(5). The value noTestsInitiated(6) indicates that no previous test results are available, such as is the case when no tests have been run since the last reinitialization of the network management subsystem and the system has no provision for non- volatile storage of test results.')
upsTestResultsDetail = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestResultsDetail.setStatus('current')
if mibBuilder.loadTexts: upsTestResultsDetail.setDescription('Additional information about upsTestResultsSummary. If no additional information available, a zero length string is returned.')
upsTestStartTime = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestStartTime.setStatus('current')
if mibBuilder.loadTexts: upsTestStartTime.setDescription('The value of sysUpTime at the time the test in progress was initiated, or, if no test is in progress, the time the previous test was initiated. If the value of upsTestResultsSummary is noTestsInitiated(6), upsTestStartTime has the value 0.')
upsTestElapsedTime = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 6), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestElapsedTime.setStatus('current')
if mibBuilder.loadTexts: upsTestElapsedTime.setDescription('The amount of time, in TimeTicks, since the test in progress was initiated, or, if no test is in progress, the previous test took to complete. If the value of upsTestResultsSummary is noTestsInitiated(6), upsTestElapsedTime has the value 0.')
upsWellKnownTests = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 7, 7))
upsTestNoTestsInitiated = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 1))
if mibBuilder.loadTexts: upsTestNoTestsInitiated.setStatus('current')
if mibBuilder.loadTexts: upsTestNoTestsInitiated.setDescription('No tests have been initiated and no test is in progress.')
upsTestAbortTestInProgress = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 2))
if mibBuilder.loadTexts: upsTestAbortTestInProgress.setStatus('current')
if mibBuilder.loadTexts: upsTestAbortTestInProgress.setDescription('The test in progress is to be aborted / the test in progress was aborted.')
upsTestGeneralSystemsTest = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 3))
if mibBuilder.loadTexts: upsTestGeneralSystemsTest.setStatus('current')
if mibBuilder.loadTexts: upsTestGeneralSystemsTest.setDescription("The manufacturer's standard test of UPS device systems.")
upsTestQuickBatteryTest = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 4))
if mibBuilder.loadTexts: upsTestQuickBatteryTest.setStatus('current')
if mibBuilder.loadTexts: upsTestQuickBatteryTest.setDescription('A test that is sufficient to determine if the battery needs replacement.')
upsTestDeepBatteryCalibration = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 5))
if mibBuilder.loadTexts: upsTestDeepBatteryCalibration.setStatus('current')
if mibBuilder.loadTexts: upsTestDeepBatteryCalibration.setDescription('The system is placed on battery to a discharge level, set by the manufacturer, sufficient to determine battery replacement and battery run-time with a high degree of confidence. WARNING: this test will leave the battery in a low charge state and will require time for recharging to a level sufficient to provide normal battery duration for the protected load.')
upsControl = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 8))
upsShutdownType = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("output", 1), ("system", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsShutdownType.setStatus('current')
if mibBuilder.loadTexts: upsShutdownType.setDescription('This object determines the nature of the action to be taken at the time when the countdown of the upsShutdownAfterDelay and upsRebootWithDuration objects reaches zero. Setting this object to output(1) indicates that shutdown requests should cause only the output of the UPS to turn off. Setting this object to system(2) indicates that shutdown requests will cause the entire UPS system to turn off.')
upsShutdownAfterDelay = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483648))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsShutdownAfterDelay.setStatus('current')
if mibBuilder.loadTexts: upsShutdownAfterDelay.setDescription('Setting this object will shutdown (i.e., turn off) either the UPS output or the UPS system (as determined by the value of upsShutdownType at the time of shutdown) after the indicated number of seconds, or less if the UPS batteries become depleted. Setting this object to 0 will cause the shutdown to occur immediately. Setting this object to -1 will abort the countdown. If the system is already in the desired state at the time the countdown reaches 0, then nothing will happen. That is, there is no additional action at that time if upsShutdownType = system and the system is already off. Similarly, there is no additional action at that time if upsShutdownType = output and the output is already off. When read, upsShutdownAfterDelay will return the number of seconds remaining until shutdown, or -1 if no shutdown countdown is in effect. On some systems, if the agent is restarted while a shutdown countdown is in effect, the countdown may be aborted. Sets to this object override any upsShutdownAfterDelay already in effect.')
upsStartupAfterDelay = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483648))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsStartupAfterDelay.setStatus('current')
if mibBuilder.loadTexts: upsStartupAfterDelay.setDescription('Setting this object will start the output after the indicated number of seconds, including starting the UPS, if necessary. Setting this object to 0 will cause the startup to occur immediately. Setting this object to -1 will abort the countdown. If the output is already on at the time the countdown reaches 0, then nothing will happen. Sets to this object override the effect of any upsStartupAfterDelay countdown or upsRebootWithDuration countdown in progress. When read, upsStartupAfterDelay will return the number of seconds until startup, or -1 if no startup countdown is in effect. If the countdown expires during a utility failure, the startup shall not occur until the utility power is restored. On some systems, if the agent is restarted while a startup countdown is in effect, the countdown is aborted.')
upsRebootWithDuration = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 300))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsRebootWithDuration.setStatus('current')
if mibBuilder.loadTexts: upsRebootWithDuration.setDescription('Setting this object will immediately shutdown (i.e., turn off) either the UPS output or the UPS system (as determined by the value of upsShutdownType at the time of shutdown) for a period equal to the indicated number of seconds, after which time the output will be started, including starting the UPS, if necessary. If the number of seconds required to perform the request is greater than the requested duration, then the requested shutdown and startup cycle shall be performed in the minimum time possible, but in no case shall this require more than the requested duration plus 60 seconds. When read, upsRebootWithDuration shall return the number of seconds remaining in the countdown, or -1 if no countdown is in progress. If the startup should occur during a utility failure, the startup shall not occur until the utility power is restored.')
upsAutoRestart = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("on", 1), ("off", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsAutoRestart.setStatus('current')
if mibBuilder.loadTexts: upsAutoRestart.setDescription("Setting this object to 'on' will cause the UPS system to restart after a shutdown if the shutdown occurred during a power loss as a result of either a upsShutdownAfterDelay or an internal battery depleted condition. Setting this object to 'off' will prevent the UPS system from restarting after a shutdown until an operator manually or remotely explicitly restarts it. If the UPS is in a startup or reboot countdown, then the UPS will not restart until that delay has been satisfied.")
upsConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 9))
upsConfigInputVoltage = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 1), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigInputVoltage.setStatus('current')
if mibBuilder.loadTexts: upsConfigInputVoltage.setDescription('The magnitude of the nominal input voltage. On those systems which support read-write access to this object, if there is an attempt to set this variable to a value that is not supported, the request must be rejected and the agent shall respond with an appropriate error message, i.e., badValue for SNMPv1, or inconsistentValue for SNMPv2.')
upsConfigInputFreq = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 2), NonNegativeInteger()).setUnits('0.1 Hertz').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigInputFreq.setStatus('current')
if mibBuilder.loadTexts: upsConfigInputFreq.setDescription('The nominal input frequency. On those systems which support read-write access to this object, if there is an attempt to set this variable to a value that is not supported, the request must be rejected and the agent shall respond with an appropriate error message, i.e., badValue for SNMPv1, or inconsistentValue for SNMPv2.')
upsConfigOutputVoltage = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 3), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigOutputVoltage.setStatus('current')
if mibBuilder.loadTexts: upsConfigOutputVoltage.setDescription('The magnitude of the nominal output voltage. On those systems which support read-write access to this object, if there is an attempt to set this variable to a value that is not supported, the request must be rejected and the agent shall respond with an appropriate error message, i.e., badValue for SNMPv1, or inconsistentValue for SNMPv2.')
upsConfigOutputFreq = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 4), NonNegativeInteger()).setUnits('0.1 Hertz').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigOutputFreq.setStatus('current')
if mibBuilder.loadTexts: upsConfigOutputFreq.setDescription('The nominal output frequency. On those systems which support read-write access to this object, if there is an attempt to set this variable to a value that is not supported, the request must be rejected and the agent shall respond with an appropriate error message, i.e., badValue for SNMPv1, or inconsistentValue for SNMPv2.')
upsConfigOutputVA = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 5), NonNegativeInteger()).setUnits('Volt-Amps').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsConfigOutputVA.setStatus('current')
if mibBuilder.loadTexts: upsConfigOutputVA.setDescription('The magnitude of the nominal Volt-Amp rating.')
upsConfigOutputPower = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 6), NonNegativeInteger()).setUnits('Watts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsConfigOutputPower.setStatus('current')
if mibBuilder.loadTexts: upsConfigOutputPower.setDescription('The magnitude of the nominal true power rating.')
upsConfigLowBattTime = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 7), NonNegativeInteger()).setUnits('minutes').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigLowBattTime.setStatus('current')
if mibBuilder.loadTexts: upsConfigLowBattTime.setDescription('The value of upsEstimatedMinutesRemaining at which a lowBattery condition is declared. For agents which support only discrete (discontinuous) values, then the agent shall round up to the next supported value. If the requested value is larger than the largest supported value, then the largest supported value shall be selected.')
upsConfigAudibleStatus = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3))).clone(namedValues=NamedValues(("disabled", 1), ("enabled", 2), ("muted", 3)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigAudibleStatus.setStatus('current')
if mibBuilder.loadTexts: upsConfigAudibleStatus.setDescription('The requested state of the audible alarm. When in the disabled state, the audible alarm should never sound. The enabled state is self-describing. Setting this object to muted(3) when the audible alarm is sounding shall temporarily silence the alarm. It will remain muted until it would normally stop sounding and the value returned for read operations during this period shall equal muted(3). At the end of this period, the value shall revert to enabled(2). Writes of the value muted(3) when the audible alarm is not sounding shall be accepted but otherwise shall have no effect.')
upsConfigLowVoltageTransferPoint = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 9), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigLowVoltageTransferPoint.setStatus('current')
if mibBuilder.loadTexts: upsConfigLowVoltageTransferPoint.setDescription('The minimum input line voltage allowed before the UPS system transfers to battery backup.')
upsConfigHighVoltageTransferPoint = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 10), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigHighVoltageTransferPoint.setStatus('current')
if mibBuilder.loadTexts: upsConfigHighVoltageTransferPoint.setDescription('The maximum line voltage allowed before the UPS system transfers to battery backup.')
sitemanager = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 10))
relais = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 10, 1))
relais1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais1.setStatus('current')
if mibBuilder.loadTexts: relais1.setDescription('Relais 1')
relais2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais2.setStatus('current')
if mibBuilder.loadTexts: relais2.setDescription('Relais 2')
relais3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais3.setStatus('current')
if mibBuilder.loadTexts: relais3.setDescription('Relais 3')
relais4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais4.setStatus('current')
if mibBuilder.loadTexts: relais4.setDescription('Relais 4')
relais5 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais5.setStatus('current')
if mibBuilder.loadTexts: relais5.setDescription('Relais 5')
relais6 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais6.setStatus('current')
if mibBuilder.loadTexts: relais6.setDescription('Relais 6')
relais7 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais7.setStatus('current')
if mibBuilder.loadTexts: relais7.setDescription('Relais 7')
relais8 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: relais8.setStatus('current')
if mibBuilder.loadTexts: relais8.setDescription('Relais 8')
digital = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 10, 2))
digital1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital1.setStatus('current')
if mibBuilder.loadTexts: digital1.setDescription('Digital 1')
digital2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital2.setStatus('current')
if mibBuilder.loadTexts: digital2.setDescription('Digital 2')
digital3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital3.setStatus('current')
if mibBuilder.loadTexts: digital3.setDescription('Digital 3')
digital4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital4.setStatus('current')
if mibBuilder.loadTexts: digital4.setDescription('Digital 4')
digital5 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital5.setStatus('current')
if mibBuilder.loadTexts: digital5.setDescription('Digital 5')
digital6 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital6.setStatus('current')
if mibBuilder.loadTexts: digital6.setDescription('Digital 6')
digital7 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital7.setStatus('current')
if mibBuilder.loadTexts: digital7.setDescription('Digital 7')
digital8 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 2, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: digital8.setStatus('current')
if mibBuilder.loadTexts: digital8.setDescription('Digital 8')
analog = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 10, 3))
analog1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 1), Integer32()).setUnits('degrees centigrade').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog1.setStatus('current')
if mibBuilder.loadTexts: analog1.setDescription('Analog 1')
analog1Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 2), Integer32()).setUnits('degrees centigrade').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog1Min.setStatus('current')
if mibBuilder.loadTexts: analog1Min.setDescription('Analog 1 Minimum')
analog1Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 3), Integer32()).setUnits('degrees centigrade').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog1Max.setStatus('current')
if mibBuilder.loadTexts: analog1Max.setDescription('Analog 1 Maximum')
analog2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 4), Integer32()).setUnits('degrees centigrade').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog2.setStatus('current')
if mibBuilder.loadTexts: analog2.setDescription('Analog 2')
analog2Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 5), Integer32()).setUnits('degrees centigrade').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog2Min.setStatus('current')
if mibBuilder.loadTexts: analog2Min.setDescription('Analog 2 Minimum')
analog2Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 6), Integer32()).setUnits('degrees centigrade').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog2Max.setStatus('current')
if mibBuilder.loadTexts: analog2Max.setDescription('Analog 2 Maximum')
analog3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 7), Integer32()).setUnits('Humidity in per mil').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog3.setStatus('current')
if mibBuilder.loadTexts: analog3.setDescription('Analog 3')
analog3Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 8), Integer32()).setUnits('Humidity in per mil').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog3Min.setStatus('current')
if mibBuilder.loadTexts: analog3Min.setDescription('Analog 3 Minimum')
analog3Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 9), Integer32()).setUnits('Humidity in per mil').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog3Max.setStatus('current')
if mibBuilder.loadTexts: analog3Max.setDescription('Analog 3 Maximum')
analog4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 10), Integer32()).setUnits('Humidity in per mil').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog4.setStatus('current')
if mibBuilder.loadTexts: analog4.setDescription('Analog 4')
analog4Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 11), Integer32()).setUnits('Humidity in per mil').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog4Min.setStatus('current')
if mibBuilder.loadTexts: analog4Min.setDescription('Analog 4 Minimum')
analog4Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 12), Integer32()).setUnits('Humidity in per mil').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog4Max.setStatus('current')
if mibBuilder.loadTexts: analog4Max.setDescription('Analog 4 Maximum')
analog5 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 13), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog5.setStatus('current')
if mibBuilder.loadTexts: analog5.setDescription('Analog 5')
analog5Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 14), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog5Min.setStatus('current')
if mibBuilder.loadTexts: analog5Min.setDescription('Analog 5 Minimum')
analog5Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 15), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog5Max.setStatus('current')
if mibBuilder.loadTexts: analog5Max.setDescription('Analog 5 Maximum')
analog6 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 16), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog6.setStatus('current')
if mibBuilder.loadTexts: analog6.setDescription('Analog 6')
analog6Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 17), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog6Min.setStatus('current')
if mibBuilder.loadTexts: analog6Min.setDescription('Analog 6 Minimum')
analog6Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 18), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog6Max.setStatus('current')
if mibBuilder.loadTexts: analog6Max.setDescription('Analog 6 Maximum')
analog7 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 19), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog7.setStatus('current')
if mibBuilder.loadTexts: analog7.setDescription('Analog 7')
analog7Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 20), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog7Min.setStatus('current')
if mibBuilder.loadTexts: analog7Min.setDescription('Analog 7 Minimum')
analog7Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 21), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog7Max.setStatus('current')
if mibBuilder.loadTexts: analog7Max.setDescription('Analog 7 Maximum')
analog8 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 22), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: analog8.setStatus('current')
if mibBuilder.loadTexts: analog8.setDescription('Analog 8')
analog8Min = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 23), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog8Min.setStatus('current')
if mibBuilder.loadTexts: analog8Min.setDescription('Analog 8 Minimum')
analog8Max = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 3, 24), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: analog8Max.setStatus('current')
if mibBuilder.loadTexts: analog8Max.setDescription('Analog 8 Maximum')
marker = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 10, 4))
marker1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker1.setStatus('current')
if mibBuilder.loadTexts: marker1.setDescription('Marker 1')
marker2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker2.setStatus('current')
if mibBuilder.loadTexts: marker2.setDescription('Marker 2')
marker3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker3.setStatus('current')
if mibBuilder.loadTexts: marker3.setDescription('Marker 3')
marker4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker4.setStatus('current')
if mibBuilder.loadTexts: marker4.setDescription('Marker 4')
marker5 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker5.setStatus('current')
if mibBuilder.loadTexts: marker5.setDescription('Marker 5')
marker6 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker6.setStatus('current')
if mibBuilder.loadTexts: marker6.setDescription('Marker 6')
marker7 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker7.setStatus('current')
if mibBuilder.loadTexts: marker7.setDescription('Marker 7')
marker8 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 4, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: marker8.setStatus('current')
if mibBuilder.loadTexts: marker8.setDescription('Marker 8')
siteMonitor = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 10, 5))
siteMonitor1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor1.setStatus('current')
if mibBuilder.loadTexts: siteMonitor1.setDescription('SiteMonitor 1')
siteMonitor2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor2.setStatus('current')
if mibBuilder.loadTexts: siteMonitor2.setDescription('SiteMonitor 2')
siteMonitor3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor3.setStatus('current')
if mibBuilder.loadTexts: siteMonitor3.setDescription('SiteMonitor 3')
siteMonitor4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor4.setStatus('current')
if mibBuilder.loadTexts: siteMonitor4.setDescription('SiteMonitor 4')
siteMonitor5 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor5.setStatus('current')
if mibBuilder.loadTexts: siteMonitor5.setDescription('SiteMonitor 5')
siteMonitor6 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor6.setStatus('current')
if mibBuilder.loadTexts: siteMonitor6.setDescription('SiteMonitor 6')
siteMonitor7 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor7.setStatus('current')
if mibBuilder.loadTexts: siteMonitor7.setDescription('SiteMonitor 7')
siteMonitor8 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor8.setStatus('current')
if mibBuilder.loadTexts: siteMonitor8.setDescription('SiteMonitor 8')
siteMonitor9 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor9.setStatus('current')
if mibBuilder.loadTexts: siteMonitor9.setDescription('SiteMonitor 9')
siteMonitor10 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor10.setStatus('current')
if mibBuilder.loadTexts: siteMonitor10.setDescription('SiteMonitor 10')
siteMonitor11 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor11.setStatus('current')
if mibBuilder.loadTexts: siteMonitor11.setDescription('SiteMonitor 11')
siteMonitor12 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor12.setStatus('current')
if mibBuilder.loadTexts: siteMonitor12.setDescription('SiteMonitor 12')
siteMonitor13 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 13), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor13.setStatus('current')
if mibBuilder.loadTexts: siteMonitor13.setDescription('SiteMonitor 13')
siteMonitor14 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 14), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor14.setStatus('current')
if mibBuilder.loadTexts: siteMonitor14.setDescription('SiteMonitor 14')
siteMonitor15 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 15), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor15.setStatus('current')
if mibBuilder.loadTexts: siteMonitor15.setDescription('SiteMonitor 15')
siteMonitor16 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 16), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor16.setStatus('current')
if mibBuilder.loadTexts: siteMonitor16.setDescription('SiteMonitor 16')
siteMonitor17 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 17), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor17.setStatus('current')
if mibBuilder.loadTexts: siteMonitor17.setDescription('SiteMonitor 17')
siteMonitor18 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 18), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor18.setStatus('current')
if mibBuilder.loadTexts: siteMonitor18.setDescription('SiteMonitor 18')
siteMonitor19 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 19), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor19.setStatus('current')
if mibBuilder.loadTexts: siteMonitor19.setDescription('SiteMonitor 19')
siteMonitor20 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 20), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor20.setStatus('current')
if mibBuilder.loadTexts: siteMonitor20.setDescription('SiteMonitor 20')
siteMonitor21 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor21.setStatus('current')
if mibBuilder.loadTexts: siteMonitor21.setDescription('SiteMonitor 21')
siteMonitor22 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 22), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor22.setStatus('current')
if mibBuilder.loadTexts: siteMonitor22.setDescription('SiteMonitor 22')
siteMonitor23 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 23), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor23.setStatus('current')
if mibBuilder.loadTexts: siteMonitor23.setDescription('SiteMonitor 23')
siteMonitor24 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 24), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor24.setStatus('current')
if mibBuilder.loadTexts: siteMonitor24.setDescription('SiteMonitor 24')
siteMonitor25 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 25), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor25.setStatus('current')
if mibBuilder.loadTexts: siteMonitor25.setDescription('SiteMonitor 25')
siteMonitor26 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 26), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor26.setStatus('current')
if mibBuilder.loadTexts: siteMonitor26.setDescription('SiteMonitor 26')
siteMonitor27 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 27), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor27.setStatus('current')
if mibBuilder.loadTexts: siteMonitor27.setDescription('SiteMonitor 27')
siteMonitor28 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 28), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor28.setStatus('current')
if mibBuilder.loadTexts: siteMonitor28.setDescription('SiteMonitor 28')
siteMonitor29 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 29), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor29.setStatus('current')
if mibBuilder.loadTexts: siteMonitor29.setDescription('SiteMonitor 29')
siteMonitor30 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 30), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor30.setStatus('current')
if mibBuilder.loadTexts: siteMonitor30.setDescription('SiteMonitor 30')
siteMonitor31 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 31), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor31.setStatus('current')
if mibBuilder.loadTexts: siteMonitor31.setDescription('SiteMonitor 31')
siteMonitor32 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 32), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor32.setStatus('current')
if mibBuilder.loadTexts: siteMonitor32.setDescription('SiteMonitor 32')
siteMonitor33 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 33), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor33.setStatus('current')
if mibBuilder.loadTexts: siteMonitor33.setDescription('SiteMonitor 33')
siteMonitor34 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 34), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor34.setStatus('current')
if mibBuilder.loadTexts: siteMonitor34.setDescription('SiteMonitor 34')
siteMonitor35 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 35), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor35.setStatus('current')
if mibBuilder.loadTexts: siteMonitor35.setDescription('siteMonitor 35')
siteMonitor36 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 36), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor36.setStatus('current')
if mibBuilder.loadTexts: siteMonitor36.setDescription('SiteMonitor 36')
siteMonitor37 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 37), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor37.setStatus('current')
if mibBuilder.loadTexts: siteMonitor37.setDescription('SiteMonitor 37')
siteMonitor38 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 38), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor38.setStatus('current')
if mibBuilder.loadTexts: siteMonitor38.setDescription('SiteMonitor 38')
siteMonitor39 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 39), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor39.setStatus('current')
if mibBuilder.loadTexts: siteMonitor39.setDescription('SiteMonitor 39')
siteMonitor40 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 40), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor40.setStatus('current')
if mibBuilder.loadTexts: siteMonitor40.setDescription('SiteMonitor 40')
siteMonitor41 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 41), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor41.setStatus('current')
if mibBuilder.loadTexts: siteMonitor41.setDescription('SiteMonitor 41')
siteMonitor42 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 42), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor42.setStatus('current')
if mibBuilder.loadTexts: siteMonitor42.setDescription('SiteMonitor 42')
siteMonitor43 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 43), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor43.setStatus('current')
if mibBuilder.loadTexts: siteMonitor43.setDescription('SiteMonitor 43')
siteMonitor44 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 44), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor44.setStatus('current')
if mibBuilder.loadTexts: siteMonitor44.setDescription('SiteMonitor 44')
siteMonitor45 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 45), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor45.setStatus('current')
if mibBuilder.loadTexts: siteMonitor45.setDescription('SiteMonitor 45')
siteMonitor46 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 46), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor46.setStatus('current')
if mibBuilder.loadTexts: siteMonitor46.setDescription('SiteMonitor 46')
siteMonitor47 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 47), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor47.setStatus('current')
if mibBuilder.loadTexts: siteMonitor47.setDescription('SiteMonitor 47')
siteMonitor48 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 48), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor48.setStatus('current')
if mibBuilder.loadTexts: siteMonitor48.setDescription('SiteMonitor 48')
siteMonitor49 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 49), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor49.setStatus('current')
if mibBuilder.loadTexts: siteMonitor49.setDescription('SiteMonitor 49')
siteMonitor50 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 50), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor50.setStatus('current')
if mibBuilder.loadTexts: siteMonitor50.setDescription('SiteMonitor 50')
siteMonitor51 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 51), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor51.setStatus('current')
if mibBuilder.loadTexts: siteMonitor51.setDescription('SiteMonitor 51')
siteMonitor52 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 52), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor52.setStatus('current')
if mibBuilder.loadTexts: siteMonitor52.setDescription('SiteMonitor 52')
siteMonitor53 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 53), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor53.setStatus('current')
if mibBuilder.loadTexts: siteMonitor53.setDescription('SiteMonitor 53')
siteMonitor54 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 54), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor54.setStatus('current')
if mibBuilder.loadTexts: siteMonitor54.setDescription('SiteMonitor 54')
siteMonitor55 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 55), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor55.setStatus('current')
if mibBuilder.loadTexts: siteMonitor55.setDescription('SiteMonitor 55')
siteMonitor56 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 56), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor56.setStatus('current')
if mibBuilder.loadTexts: siteMonitor56.setDescription('SiteMonitor 56')
siteMonitor57 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 57), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor57.setStatus('current')
if mibBuilder.loadTexts: siteMonitor57.setDescription('SiteMonitor 57')
siteMonitor58 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 58), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor58.setStatus('current')
if mibBuilder.loadTexts: siteMonitor58.setDescription('SiteMonitor 58')
siteMonitor59 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 59), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor59.setStatus('current')
if mibBuilder.loadTexts: siteMonitor59.setDescription('SiteMonitor 59')
siteMonitor60 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 60), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor60.setStatus('current')
if mibBuilder.loadTexts: siteMonitor60.setDescription('SiteMonitor 60')
siteMonitor61 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 61), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor61.setStatus('current')
if mibBuilder.loadTexts: siteMonitor61.setDescription('SiteMonitor 61')
siteMonitor62 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 62), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor62.setStatus('current')
if mibBuilder.loadTexts: siteMonitor62.setDescription('SiteMonitor 62')
siteMonitor63 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 63), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor63.setStatus('current')
if mibBuilder.loadTexts: siteMonitor63.setDescription('SiteMonitor 63')
siteMonitor64 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 10, 5, 64), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: siteMonitor64.setStatus('current')
if mibBuilder.loadTexts: siteMonitor64.setDescription('SiteMonitor 64')
aux = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 11))
auxPort1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 11, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: auxPort1.setStatus('current')
if mibBuilder.loadTexts: auxPort1.setDescription('AUX-Port 1')
auxPort2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 11, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: auxPort2.setStatus('current')
if mibBuilder.loadTexts: auxPort2.setDescription('AUX-Port 2')
auxPort3 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 11, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: auxPort3.setStatus('current')
if mibBuilder.loadTexts: auxPort3.setDescription('AUX-Port 3')
auxPort4 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 11, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: auxPort4.setStatus('current')
if mibBuilder.loadTexts: auxPort4.setDescription('AUX-Port 4')
sensorMan = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12))
sensor1 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 1))
sensorMan1Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 1, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan1Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan1Value.setDescription('SensorMan Value 1')
sensorMan1Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan1Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan1Location.setDescription('SensorMan Location 1')
sensorMan1Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan1Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan1Unit.setDescription('SensorMan Unit 1')
sensorMan1ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 1, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan1ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan1ThresholdLow.setDescription('SensorMan Lower Threshold 1')
sensorMan1ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 1, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan1ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan1ThresholdHigh.setDescription('SensorMan Upper Threshold 1')
sensorMan1Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 1, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan1Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan1Scaling.setDescription('SensorMan Scaling Factor 1')
sensorMan1Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 1, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan1Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan1Offset.setDescription('SensorMan Offset 1')
sensor2 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 2))
sensorMan2Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 2, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan2Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan2Value.setDescription('SensorMan Value 2')
sensorMan2Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 2, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan2Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan2Location.setDescription('SensorMan Location 2')
sensorMan2Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 2, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan2Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan2Unit.setDescription('SensorMan Unit 2')
sensorMan2ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 2, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan2ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan2ThresholdLow.setDescription('SensorMan Lower Threshold 2')
sensorMan2ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 2, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan2ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan2ThresholdHigh.setDescription('SensorMan Upper Threshold 2')
sensorMan2Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 2, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan2Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan2Scaling.setDescription('SensorMan Scaling Factor 2')
sensorMan2Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 2, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan2Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan2Offset.setDescription('SensorMan Offset 2')
sensor3 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 3))
sensorMan3Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 3, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan3Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan3Value.setDescription('SensorMan Value 3')
sensorMan3Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 3, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan3Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan3Location.setDescription('SensorMan Location 3')
sensorMan3Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 3, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan3Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan3Unit.setDescription('SensorMan Unit 3')
sensorMan3ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 3, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan3ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan3ThresholdLow.setDescription('SensorMan Lower Threshold 3')
sensorMan3ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 3, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan3ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan3ThresholdHigh.setDescription('SensorMan Upper Threshold 3')
sensorMan3Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 3, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan3Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan3Scaling.setDescription('SensorMan Scaling Factor 3')
sensorMan3Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 3, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan3Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan3Offset.setDescription('SensorMan Offset 3')
sensor4 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 4))
sensorMan4Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 4, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan4Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan4Value.setDescription('SensorMan Value 4')
sensorMan4Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 4, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan4Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan4Location.setDescription('SensorMan Location 4')
sensorMan4Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 4, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan4Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan4Unit.setDescription('SensorMan Unit 4')
sensorMan4ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 4, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan4ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan4ThresholdLow.setDescription('SensorMan Lower Threshold 4')
sensorMan4ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 4, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan4ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan4ThresholdHigh.setDescription('SensorMan Upper Threshold 4')
sensorMan4Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 4, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan4Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan4Scaling.setDescription('SensorMan Scaling Factor 4')
sensorMan4Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 4, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan4Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan4Offset.setDescription('SensorMan Offset 4')
sensor5 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 5))
sensorMan5Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 5, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan5Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan5Value.setDescription('SensorMan Value 5')
sensorMan5Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 5, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan5Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan5Location.setDescription('SensorMan Location 5')
sensorMan5Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 5, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan5Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan5Unit.setDescription('SensorMan Unit 5')
sensorMan5ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 5, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan5ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan5ThresholdLow.setDescription('SensorMan Lower Threshold 5')
sensorMan5ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 5, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan5ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan5ThresholdHigh.setDescription('SensorMan Upper Threshold 5')
sensorMan5Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 5, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan5Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan5Scaling.setDescription('SensorMan Scaling Factor 5')
sensorMan5Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 5, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan5Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan5Offset.setDescription('SensorMan Offset 5')
sensor6 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 6))
sensorMan6Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 6, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan6Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan6Value.setDescription('SensorMan Value 6')
sensorMan6Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 6, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan6Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan6Location.setDescription('SensorMan Location 6')
sensorMan6Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 6, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan6Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan6Unit.setDescription('SensorMan Unit 6')
sensorMan6ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 6, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan6ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan6ThresholdLow.setDescription('SensorMan Lower Threshold 6')
sensorMan6ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 6, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan6ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan6ThresholdHigh.setDescription('SensorMan Upper Threshold 6')
sensorMan6Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 6, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan6Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan6Scaling.setDescription('SensorMan Scaling Factor 6')
sensorMan6Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 6, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan6Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan6Offset.setDescription('SensorMan Offset 6')
sensor7 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 7))
sensorMan7Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 7, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan7Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan7Value.setDescription('SensorMan Value 7')
sensorMan7Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 7, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan7Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan7Location.setDescription('SensorMan Location 7')
sensorMan7Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 7, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan7Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan7Unit.setDescription('SensorMan Unit 7')
sensorMan7ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 7, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan7ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan7ThresholdLow.setDescription('SensorMan Lower Threshold 7')
sensorMan7ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 7, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan7ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan7ThresholdHigh.setDescription('SensorMan Upper Threshold 7')
sensorMan7Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 7, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan7Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan7Scaling.setDescription('SensorMan Scaling Factor 7')
sensorMan7Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 7, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan7Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan7Offset.setDescription('SensorMan Offset 7')
sensor8 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 8))
sensorMan8Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 8, 1), Integer32()).setUnits('0.1 units').setMaxAccess("readonly")
if mibBuilder.loadTexts: sensorMan8Value.setStatus('current')
if mibBuilder.loadTexts: sensorMan8Value.setDescription('SensorMan Value 8')
sensorMan8Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 8, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan8Location.setStatus('current')
if mibBuilder.loadTexts: sensorMan8Location.setDescription('SensorMan Location 8')
sensorMan8Unit = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 8, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan8Unit.setStatus('current')
if mibBuilder.loadTexts: sensorMan8Unit.setDescription('SensorMan Unit 8')
sensorMan8ThresholdLow = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 8, 4), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan8ThresholdLow.setStatus('current')
if mibBuilder.loadTexts: sensorMan8ThresholdLow.setDescription('SensorMan Lower Threshold 8')
sensorMan8ThresholdHigh = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 8, 5), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan8ThresholdHigh.setStatus('current')
if mibBuilder.loadTexts: sensorMan8ThresholdHigh.setDescription('SensorMan Upper Threshold 8')
sensorMan8Scaling = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 8, 6), Integer32()).setUnits('0.01 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan8Scaling.setStatus('current')
if mibBuilder.loadTexts: sensorMan8Scaling.setDescription('SensorMan Scaling Factor 8')
sensorMan8Offset = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 8, 7), Integer32()).setUnits('0.1 units').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sensorMan8Offset.setStatus('current')
if mibBuilder.loadTexts: sensorMan8Offset.setDescription('SensorMan Offset 8')
input1 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 9))
input1Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 9, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: input1Value.setStatus('current')
if mibBuilder.loadTexts: input1Value.setDescription('SensorMan Input 1')
input1Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 9, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input1Location.setStatus('current')
if mibBuilder.loadTexts: input1Location.setDescription('SensorMan Input 1 Location')
input1NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 9, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input1NCContact.setStatus('current')
if mibBuilder.loadTexts: input1NCContact.setDescription('SensorMan Input 1 is used as NC contact')
input2 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 10))
input2Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 10, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: input2Value.setStatus('current')
if mibBuilder.loadTexts: input2Value.setDescription('SensorMan Input 2')
input2Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 10, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input2Location.setStatus('current')
if mibBuilder.loadTexts: input2Location.setDescription('SensorMan Input 2 Location')
input2NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 10, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: input2NCContact.setStatus('current')
if mibBuilder.loadTexts: input2NCContact.setDescription('SensorMan Input 2 is used as NC contact')
input3 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 11))
input3Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 11, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input3Value.setStatus('current')
if mibBuilder.loadTexts: input3Value.setDescription('SensorMan Input 3')
input3Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 11, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input3Location.setStatus('current')
if mibBuilder.loadTexts: input3Location.setDescription('SensorMan Input 3 Location')
input3NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 11, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input3NCContact.setStatus('current')
if mibBuilder.loadTexts: input3NCContact.setDescription('SensorMan Input 3 is used as NC contact')
input4 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 12))
input4Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 12, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: input4Value.setStatus('current')
if mibBuilder.loadTexts: input4Value.setDescription('SensorMan Input 4')
input4Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 12, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input4Location.setStatus('current')
if mibBuilder.loadTexts: input4Location.setDescription('SensorMan Input 4 Location')
input4NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 12, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: input4NCContact.setStatus('current')
if mibBuilder.loadTexts: input4NCContact.setDescription('SensorMan Input 4 is used as NC contact')
output1 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 13))
output1Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 13, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output1Value.setStatus('current')
if mibBuilder.loadTexts: output1Value.setDescription('SensorMan Output 1')
output1Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 13, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output1Location.setStatus('current')
if mibBuilder.loadTexts: output1Location.setDescription('SensorMan Output 1 Location')
output1NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 13, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output1NCContact.setStatus('current')
if mibBuilder.loadTexts: output1NCContact.setDescription('SensorMan Output 1 is used as NC contact')
output2 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 14))
output2Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 14, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output2Value.setStatus('current')
if mibBuilder.loadTexts: output2Value.setDescription('SensorMan Output 2')
output2Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 14, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output2Location.setStatus('current')
if mibBuilder.loadTexts: output2Location.setDescription('SensorMan Output 2 Location')
output2NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 14, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output2NCContact.setStatus('current')
if mibBuilder.loadTexts: output2NCContact.setDescription('SensorMan Output 2 is used as NC contact')
output3 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 15))
output3Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 15, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output3Value.setStatus('current')
if mibBuilder.loadTexts: output3Value.setDescription('SensorMan Output 3')
output3Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 15, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output3Location.setStatus('current')
if mibBuilder.loadTexts: output3Location.setDescription('SensorMan Output 3 Location')
output3NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 15, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output3NCContact.setStatus('current')
if mibBuilder.loadTexts: output3NCContact.setDescription('SensorMan Output 3 is used as NC contact')
output4 = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 12, 16))
output4Value = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 16, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("off", 0), ("on", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output4Value.setStatus('current')
if mibBuilder.loadTexts: output4Value.setDescription('SensorMan Output 4')
output4Location = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 16, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 79))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output4Location.setStatus('current')
if mibBuilder.loadTexts: output4Location.setDescription('SensorMan Output 4 Location')
output4NCContact = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 12, 16, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: output4NCContact.setStatus('current')
if mibBuilder.loadTexts: output4NCContact.setDescription('SensorMan Output 4 is used as NC contact')
sts = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 13))
stsStaticSwitch1On = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsStaticSwitch1On.setStatus('current')
if mibBuilder.loadTexts: stsStaticSwitch1On.setDescription('Static switch 1 on')
stsStaticSwitch2On = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsStaticSwitch2On.setStatus('current')
if mibBuilder.loadTexts: stsStaticSwitch2On.setDescription('Static switch 2 on')
stsManualBypass1On = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsManualBypass1On.setStatus('current')
if mibBuilder.loadTexts: stsManualBypass1On.setDescription('Manual Bypass 1 On')
stsManualBypass2On = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsManualBypass2On.setStatus('current')
if mibBuilder.loadTexts: stsManualBypass2On.setDescription('Manual Bypass 2 On')
stsAutoTransfermode = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsAutoTransfermode.setStatus('current')
if mibBuilder.loadTexts: stsAutoTransfermode.setDescription('Auto Transfermode')
stsSourcesSynchron = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsSourcesSynchron.setStatus('current')
if mibBuilder.loadTexts: stsSourcesSynchron.setDescription('Sources Synchron')
stsPreferedMains1 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsPreferedMains1.setStatus('current')
if mibBuilder.loadTexts: stsPreferedMains1.setDescription('Prefered Mains 1')
stsPreferedMains2 = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsPreferedMains2.setStatus('current')
if mibBuilder.loadTexts: stsPreferedMains2.setDescription('Prefered Mains 2')
stsAutostartEnabled = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 13, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1))).clone(namedValues=NamedValues(("no", 0), ("yes", 1)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: stsAutostartEnabled.setStatus('current')
if mibBuilder.loadTexts: stsAutostartEnabled.setDescription('Autostart Enabled')
upsInputAux = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 14))
upsInputAuxBads = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 14, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputAuxBads.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxBads.setDescription('A count of the number of times the input entered an out-of-tolerance condition as defined by the manufacturer. This count is incremented by one each time the input transitions from zero out-of-tolerance lines to one or more input lines out-of-tolerance.')
upsInputAuxNumLines = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 14, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputAuxNumLines.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxNumLines.setDescription('The number of input lines utilized in this device. This variable indicates the number of rows in the input table.')
upsInputAuxTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 14, 3), )
if mibBuilder.loadTexts: upsInputAuxTable.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxTable.setDescription('A list of input table entries. The number of entries is given by the value of upsInputNumLines.')
upsInputAuxEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 14, 3, 1), ).setIndexNames((0, "UPS-MIB", "upsInputAuxIndex"))
if mibBuilder.loadTexts: upsInputAuxEntry.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxEntry.setDescription('An entry containing information applicable to a particular input line.')
upsInputAuxIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 14, 3, 1, 1), PositiveInteger())
if mibBuilder.loadTexts: upsInputAuxIndex.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxIndex.setDescription('The input line identifier.')
upsInputAuxFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 14, 3, 1, 2), NonNegativeInteger()).setUnits('0.1 Hertz').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputAuxFrequency.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxFrequency.setDescription('The present input frequency.')
upsInputAuxVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 14, 3, 1, 3), NonNegativeInteger()).setUnits('RMS Volts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputAuxVoltage.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxVoltage.setDescription('The magnitude of the present input voltage.')
upsInputAuxCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 14, 3, 1, 4), NonNegativeInteger()).setUnits('0.1 RMS Amp').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputAuxCurrent.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxCurrent.setDescription('The magnitude of the present input current.')
upsInputAuxTruePower = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 14, 3, 1, 5), NonNegativeInteger()).setUnits('Watts').setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputAuxTruePower.setStatus('current')
if mibBuilder.loadTexts: upsInputAuxTruePower.setDescription('The magnitude of the present input true power.')
additionalValues = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 15))
externalSensor = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 15, 1), Integer32()).setUnits('degrees Centigrade').setMaxAccess("readonly")
if mibBuilder.loadTexts: externalSensor.setStatus('current')
if mibBuilder.loadTexts: externalSensor.setDescription('The ambient temperature.')
upsTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 2))
upsTrapOnBattery = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 1)).setObjects(("UPS-MIB", "upsEstimatedMinutesRemaining"), ("UPS-MIB", "upsSecondsOnBattery"), ("UPS-MIB", "upsConfigLowBattTime"))
if mibBuilder.loadTexts: upsTrapOnBattery.setStatus('current')
if mibBuilder.loadTexts: upsTrapOnBattery.setDescription('The UPS is operating on battery power. This trap is persistent and is resent at one minute intervals until the UPS either turns off or is no longer running on battery.')
upsTrapTestCompleted = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 2)).setObjects(("UPS-MIB", "upsTestId"), ("UPS-MIB", "upsTestSpinLock"), ("UPS-MIB", "upsTestResultsSummary"), ("UPS-MIB", "upsTestResultsDetail"), ("UPS-MIB", "upsTestStartTime"), ("UPS-MIB", "upsTestElapsedTime"))
if mibBuilder.loadTexts: upsTrapTestCompleted.setStatus('current')
if mibBuilder.loadTexts: upsTrapTestCompleted.setDescription('This trap is sent upon completion of a UPS diagnostic test.')
upsTrapAlarmEntryAdded = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 3)).setObjects(("UPS-MIB", "upsAlarmId"), ("UPS-MIB", "upsAlarmDescr"))
if mibBuilder.loadTexts: upsTrapAlarmEntryAdded.setStatus('current')
if mibBuilder.loadTexts: upsTrapAlarmEntryAdded.setDescription('This trap is sent each time an alarm is inserted into to the alarm table. It is sent on the insertion of all alarms except for upsAlarmOnBattery and upsAlarmTestInProgress.')
upsTrapAlarmEntryRemoved = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 4)).setObjects(("UPS-MIB", "upsAlarmId"), ("UPS-MIB", "upsAlarmDescr"))
if mibBuilder.loadTexts: upsTrapAlarmEntryRemoved.setStatus('current')
if mibBuilder.loadTexts: upsTrapAlarmEntryRemoved.setDescription('This trap is sent each time an alarm is removed from the alarm table. It is sent on the removal of all alarms except for upsAlarmTestInProgress.')
upsConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3))
upsCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 1))
upsSubsetCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 33, 3, 1, 1)).setObjects(("UPS-MIB", "upsSubsetIdentGroup"), ("UPS-MIB", "upsSubsetBatteryGroup"), ("UPS-MIB", "upsSubsetInputGroup"), ("UPS-MIB", "upsSubsetOutputGroup"), ("UPS-MIB", "upsSubsetAlarmGroup"), ("UPS-MIB", "upsSubsetControlGroup"), ("UPS-MIB", "upsSubsetConfigGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetCompliance = upsSubsetCompliance.setStatus('current')
if mibBuilder.loadTexts: upsSubsetCompliance.setDescription('The compliance statement for UPSs that only support the two-contact communication protocol.')
upsBasicCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 33, 3, 1, 2)).setObjects(("UPS-MIB", "upsBasicIdentGroup"), ("UPS-MIB", "upsBasicBatteryGroup"), ("UPS-MIB", "upsBasicInputGroup"), ("UPS-MIB", "upsBasicOutputGroup"), ("UPS-MIB", "upsBasicAlarmGroup"), ("UPS-MIB", "upsBasicTestGroup"), ("UPS-MIB", "upsBasicControlGroup"), ("UPS-MIB", "upsBasicConfigGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicCompliance = upsBasicCompliance.setStatus('current')
if mibBuilder.loadTexts: upsBasicCompliance.setDescription('The compliance statement for UPSs that support full-featured functions, such as control.')
upsFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 33, 3, 1, 3)).setObjects(("UPS-MIB", "upsFullIdentGroup"), ("UPS-MIB", "upsFullBatteryGroup"), ("UPS-MIB", "upsFullInputGroup"), ("UPS-MIB", "upsFullOutputGroup"), ("UPS-MIB", "upsFullAlarmGroup"), ("UPS-MIB", "upsFullTestGroup"), ("UPS-MIB", "upsFullControlGroup"), ("UPS-MIB", "upsFullConfigGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullCompliance = upsFullCompliance.setStatus('current')
if mibBuilder.loadTexts: upsFullCompliance.setDescription('The compliance statement for UPSs that support advanced full-featured functions.')
upsGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2))
upsSubsetGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2, 1))
upsSubsetIdentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 1)).setObjects(("UPS-MIB", "upsIdentManufacturer"), ("UPS-MIB", "upsIdentModel"), ("UPS-MIB", "upsIdentAgentSoftwareVersion"), ("UPS-MIB", "upsIdentName"), ("UPS-MIB", "upsIdentAttachedDevices"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetIdentGroup = upsSubsetIdentGroup.setStatus('current')
if mibBuilder.loadTexts: upsSubsetIdentGroup.setDescription('The upsSubsetIdentGroup defines objects which are common across all UPSs which meet subset compliance. Most devices which conform to the upsSubsetIdentGroup will provide access to these objects via a proxy agent. If the proxy agent is compatible with multiple UPS types, configuration of the proxy agent will require specifying some of these values, either individually, or as a group (perhaps through a table lookup mechanism based on the UPS model number).')
upsSubsetBatteryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 2)).setObjects(("UPS-MIB", "upsBatteryStatus"), ("UPS-MIB", "upsSecondsOnBattery"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetBatteryGroup = upsSubsetBatteryGroup.setStatus('current')
if mibBuilder.loadTexts: upsSubsetBatteryGroup.setDescription('The upsSubsetBatteryGroup defines the objects that are common to battery groups of two-contact UPSs.')
upsSubsetInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 3)).setObjects(("UPS-MIB", "upsInputLineBads"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetInputGroup = upsSubsetInputGroup.setStatus('current')
if mibBuilder.loadTexts: upsSubsetInputGroup.setDescription('The upsSubsetInputGroup defines the objects that are common to the Input groups of two-contact UPSs.')
upsSubsetOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 4)).setObjects(("UPS-MIB", "upsOutputSource"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetOutputGroup = upsSubsetOutputGroup.setStatus('current')
if mibBuilder.loadTexts: upsSubsetOutputGroup.setDescription('The upsSubsetOutputGroup defines the objects that are common to the Output groups of two-contact UPSs.')
upsSubsetAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 6)).setObjects(("UPS-MIB", "upsAlarmsPresent"), ("UPS-MIB", "upsAlarmDescr"), ("UPS-MIB", "upsAlarmTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetAlarmGroup = upsSubsetAlarmGroup.setStatus('current')
if mibBuilder.loadTexts: upsSubsetAlarmGroup.setDescription('The upsSubsetAlarmGroup defines the objects that are common to the Alarm groups of two-contact UPSs.')
upsSubsetControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 8)).setObjects(("UPS-MIB", "upsShutdownType"), ("UPS-MIB", "upsShutdownAfterDelay"), ("UPS-MIB", "upsAutoRestart"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetControlGroup = upsSubsetControlGroup.setStatus('current')
if mibBuilder.loadTexts: upsSubsetControlGroup.setDescription('The upsSubsetControlGroup defines the objects that are common to the Control groups of two-contact UPSs.')
upsSubsetConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 9)).setObjects(("UPS-MIB", "upsConfigInputVoltage"), ("UPS-MIB", "upsConfigInputFreq"), ("UPS-MIB", "upsConfigOutputVoltage"), ("UPS-MIB", "upsConfigOutputFreq"), ("UPS-MIB", "upsConfigOutputVA"), ("UPS-MIB", "upsConfigOutputPower"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsSubsetConfigGroup = upsSubsetConfigGroup.setStatus('current')
if mibBuilder.loadTexts: upsSubsetConfigGroup.setDescription('The upsSubsetConfigGroup defines the objects that are common to the Config groups of two-contact UPSs.')
upsBasicGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2, 2))
upsBasicIdentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 1)).setObjects(("UPS-MIB", "upsIdentManufacturer"), ("UPS-MIB", "upsIdentModel"), ("UPS-MIB", "upsIdentUPSSoftwareVersion"), ("UPS-MIB", "upsIdentAgentSoftwareVersion"), ("UPS-MIB", "upsIdentName"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicIdentGroup = upsBasicIdentGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicIdentGroup.setDescription('The upsBasicIdentGroup defines objects which are common to the Ident group of compliant UPSs which support basic functions.')
upsBasicBatteryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 2)).setObjects(("UPS-MIB", "upsBatteryStatus"), ("UPS-MIB", "upsSecondsOnBattery"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicBatteryGroup = upsBasicBatteryGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicBatteryGroup.setDescription('The upsBasicBatteryGroup defines the objects that are common to the battery groups of compliant UPSs which support basic functions.')
upsBasicInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 3)).setObjects(("UPS-MIB", "upsInputLineBads"), ("UPS-MIB", "upsInputNumLines"), ("UPS-MIB", "upsInputFrequency"), ("UPS-MIB", "upsInputVoltage"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicInputGroup = upsBasicInputGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicInputGroup.setDescription('The upsBasicInputGroup defines the objects that are common to the Input groups of compliant UPSs which support basic functions.')
upsBasicOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 4)).setObjects(("UPS-MIB", "upsOutputSource"), ("UPS-MIB", "upsOutputFrequency"), ("UPS-MIB", "upsOutputNumLines"), ("UPS-MIB", "upsOutputVoltage"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicOutputGroup = upsBasicOutputGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicOutputGroup.setDescription('The upsBasicOutputGroup defines the objects that are common to the Output groups of compliant UPSs which support basic functions.')
upsBasicBypassGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 5)).setObjects(("UPS-MIB", "upsBypassFrequency"), ("UPS-MIB", "upsBypassNumLines"), ("UPS-MIB", "upsBypassVoltage"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicBypassGroup = upsBasicBypassGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicBypassGroup.setDescription('The upsBasicBypassGroup defines the objects that are common to the Bypass groups of compliant UPSs which support basic functions.')
upsBasicAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 6)).setObjects(("UPS-MIB", "upsAlarmsPresent"), ("UPS-MIB", "upsAlarmDescr"), ("UPS-MIB", "upsAlarmTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicAlarmGroup = upsBasicAlarmGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicAlarmGroup.setDescription('The upsBasicAlarmGroup defines the objects that are common to the Alarm groups of compliant UPSs which support basic functions.')
upsBasicTestGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 7)).setObjects(("UPS-MIB", "upsTestId"), ("UPS-MIB", "upsTestSpinLock"), ("UPS-MIB", "upsTestResultsSummary"), ("UPS-MIB", "upsTestResultsDetail"), ("UPS-MIB", "upsTestStartTime"), ("UPS-MIB", "upsTestElapsedTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicTestGroup = upsBasicTestGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicTestGroup.setDescription('The upsBasicTestGroup defines the objects that are common to the Test groups of compliant UPSs which support basic functions.')
upsBasicControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 8)).setObjects(("UPS-MIB", "upsShutdownType"), ("UPS-MIB", "upsShutdownAfterDelay"), ("UPS-MIB", "upsStartupAfterDelay"), ("UPS-MIB", "upsRebootWithDuration"), ("UPS-MIB", "upsAutoRestart"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicControlGroup = upsBasicControlGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicControlGroup.setDescription('The upsBasicControlGroup defines the objects that are common to the Control groups of compliant UPSs which support basic functions.')
upsBasicConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 9)).setObjects(("UPS-MIB", "upsConfigInputVoltage"), ("UPS-MIB", "upsConfigInputFreq"), ("UPS-MIB", "upsConfigOutputVoltage"), ("UPS-MIB", "upsConfigOutputFreq"), ("UPS-MIB", "upsConfigOutputVA"), ("UPS-MIB", "upsConfigOutputPower"), ("UPS-MIB", "upsConfigLowBattTime"), ("UPS-MIB", "upsConfigAudibleStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsBasicConfigGroup = upsBasicConfigGroup.setStatus('current')
if mibBuilder.loadTexts: upsBasicConfigGroup.setDescription('The upsBasicConfigGroup defines the objects that are common to the Config groups of UPSs which support basic functions.')
upsFullGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2, 3))
upsFullIdentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 1)).setObjects(("UPS-MIB", "upsIdentManufacturer"), ("UPS-MIB", "upsIdentModel"), ("UPS-MIB", "upsIdentUPSSoftwareVersion"), ("UPS-MIB", "upsIdentAgentSoftwareVersion"), ("UPS-MIB", "upsIdentName"), ("UPS-MIB", "upsIdentAttachedDevices"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullIdentGroup = upsFullIdentGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullIdentGroup.setDescription('The upsFullIdentGroup defines objects which are common to the Ident group of fully compliant UPSs.')
upsFullBatteryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 2)).setObjects(("UPS-MIB", "upsBatteryStatus"), ("UPS-MIB", "upsSecondsOnBattery"), ("UPS-MIB", "upsEstimatedMinutesRemaining"), ("UPS-MIB", "upsEstimatedChargeRemaining"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullBatteryGroup = upsFullBatteryGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullBatteryGroup.setDescription('The upsFullBatteryGroup defines the objects that are common to the battery groups of fully compliant UPSs.')
upsFullInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 3)).setObjects(("UPS-MIB", "upsInputLineBads"), ("UPS-MIB", "upsInputNumLines"), ("UPS-MIB", "upsInputFrequency"), ("UPS-MIB", "upsInputVoltage"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullInputGroup = upsFullInputGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullInputGroup.setDescription('The upsFullInputGroup defines the objects that are common to the Input groups of fully compliant UPSs.')
upsFullOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 4)).setObjects(("UPS-MIB", "upsOutputSource"), ("UPS-MIB", "upsOutputFrequency"), ("UPS-MIB", "upsOutputNumLines"), ("UPS-MIB", "upsOutputVoltage"), ("UPS-MIB", "upsOutputCurrent"), ("UPS-MIB", "upsOutputPower"), ("UPS-MIB", "upsOutputPercentLoad"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullOutputGroup = upsFullOutputGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullOutputGroup.setDescription('The upsFullOutputGroup defines the objects that are common to the Output groups of fully compliant UPSs.')
upsFullBypassGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 5)).setObjects(("UPS-MIB", "upsBypassFrequency"), ("UPS-MIB", "upsBypassNumLines"), ("UPS-MIB", "upsBypassVoltage"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullBypassGroup = upsFullBypassGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullBypassGroup.setDescription('The upsFullBypassGroup defines the objects that are common to the Bypass groups of fully compliant UPSs.')
upsFullAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 6)).setObjects(("UPS-MIB", "upsAlarmsPresent"), ("UPS-MIB", "upsAlarmDescr"), ("UPS-MIB", "upsAlarmTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullAlarmGroup = upsFullAlarmGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullAlarmGroup.setDescription('The upsFullAlarmGroup defines the objects that are common to the Alarm groups of fully compliant UPSs.')
upsFullTestGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 7)).setObjects(("UPS-MIB", "upsTestId"), ("UPS-MIB", "upsTestSpinLock"), ("UPS-MIB", "upsTestResultsSummary"), ("UPS-MIB", "upsTestResultsDetail"), ("UPS-MIB", "upsTestStartTime"), ("UPS-MIB", "upsTestElapsedTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullTestGroup = upsFullTestGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullTestGroup.setDescription('The upsFullTestGroup defines the objects that are common to the Test groups of fully compliant UPSs.')
upsFullControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 8)).setObjects(("UPS-MIB", "upsShutdownType"), ("UPS-MIB", "upsShutdownAfterDelay"), ("UPS-MIB", "upsStartupAfterDelay"), ("UPS-MIB", "upsRebootWithDuration"), ("UPS-MIB", "upsAutoRestart"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullControlGroup = upsFullControlGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullControlGroup.setDescription('The upsFullControlGroup defines the objects that are common to the Control groups of fully compliant UPSs.')
upsFullConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 9)).setObjects(("UPS-MIB", "upsConfigInputVoltage"), ("UPS-MIB", "upsConfigInputFreq"), ("UPS-MIB", "upsConfigOutputVoltage"), ("UPS-MIB", "upsConfigOutputFreq"), ("UPS-MIB", "upsConfigOutputVA"), ("UPS-MIB", "upsConfigOutputPower"), ("UPS-MIB", "upsConfigLowBattTime"), ("UPS-MIB", "upsConfigAudibleStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsFullConfigGroup = upsFullConfigGroup.setStatus('current')
if mibBuilder.loadTexts: upsFullConfigGroup.setDescription('The upsFullConfigGroup defines the objects that are common to the Config groups of fully compliant UPSs.')
upsAdditionalValuesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 15)).setObjects(("UPS-MIB", "externalSensor"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    upsAdditionalValuesGroup = upsAdditionalValuesGroup.setStatus('current')
if mibBuilder.loadTexts: upsAdditionalValuesGroup.setDescription('The additional values.')
mibBuilder.exportSymbols("UPS-MIB", alarmSiteManagerDigitalInput5=alarmSiteManagerDigitalInput5, alarmUser5=alarmUser5, sensorMan2ThresholdLow=sensorMan2ThresholdLow, alarmSiteMonitor32=alarmSiteMonitor32, sensorMan7Location=sensorMan7Location, upsInputCurrent=upsInputCurrent, upsConfigLowBattTime=upsConfigLowBattTime, alarmSiteManagerOutput6=alarmSiteManagerOutput6, relais=relais, upsOutputPercentLoad=upsOutputPercentLoad, upsAlarmTable=upsAlarmTable, upsAlarmOutputBad=upsAlarmOutputBad, upsAlarmUpsOutputOff=upsAlarmUpsOutputOff, upsBatteryVoltage=upsBatteryVoltage, marker2=marker2, marker4=marker4, siteMonitor32=siteMonitor32, analog5Min=analog5Min, output3Value=output3Value, sensorMan6Location=sensorMan6Location, upsCompliances=upsCompliances, upsBatteryStatus=upsBatteryStatus, upsAlarmTempBad=upsAlarmTempBad, alarmSensorManagerInput4=alarmSensorManagerInput4, sensorMan6Offset=sensorMan6Offset, upsInputFrequency=upsInputFrequency, siteMonitor29=siteMonitor29, alarmSiteManagerOutput3=alarmSiteManagerOutput3, sensorMan1Offset=sensorMan1Offset, upsAlarmThresholdAlarm=upsAlarmThresholdAlarm, alarmSiteMonitor41=alarmSiteMonitor41, siteMonitor46=siteMonitor46, analog3Max=analog3Max, siteMonitor26=siteMonitor26, siteMonitor8=siteMonitor8, alarmSiteMonitor59=alarmSiteMonitor59, alarmSiteMonitor52=alarmSiteMonitor52, upsConformance=upsConformance, alarmSiteMonitor33=alarmSiteMonitor33, sitemanager=sitemanager, alarmSensorManager7Low=alarmSensorManager7Low, alarmSensorManagerOutput3=alarmSensorManagerOutput3, upsTestElapsedTime=upsTestElapsedTime, upsBasicIdentGroup=upsBasicIdentGroup, upsFullConfigGroup=upsFullConfigGroup, alarmSiteManagerAnalogInput8=alarmSiteManagerAnalogInput8, upsOutputPower=upsOutputPower, siteMonitor25=siteMonitor25, siteMonitor9=siteMonitor9, upsAlarmDescr=upsAlarmDescr, upsBypassTable=upsBypassTable, siteMonitor42=siteMonitor42, PYSNMP_MODULE_ID=upsMIB, alarmSiteMonitor17=alarmSiteMonitor17, digital6=digital6, alarmSensorManager2High=alarmSensorManager2High, relais4=relais4, siteMonitor33=siteMonitor33, upsInputLineBads=upsInputLineBads, alarmSiteManagerAnalogInput6=alarmSiteManagerAnalogInput6, alarmSiteMonitor27=alarmSiteMonitor27, siteMonitor39=siteMonitor39, input4=input4, siteMonitor15=siteMonitor15, upsSubsetInputGroup=upsSubsetInputGroup, upsBasicBatteryGroup=upsBasicBatteryGroup, siteMonitor60=siteMonitor60, output1=output1, siteMonitor34=siteMonitor34, siteMonitor30=siteMonitor30, sensorMan8ThresholdHigh=sensorMan8ThresholdHigh, input1NCContact=input1NCContact, alarmSensorManagerInput1=alarmSensorManagerInput1, alarmSiteMonitor40=alarmSiteMonitor40, sensorMan7Scaling=sensorMan7Scaling, alarmSiteMonitor34=alarmSiteMonitor34, externalSensor=externalSensor, alarmUser6=alarmUser6, alarmSiteManagerDigitalInput4=alarmSiteManagerDigitalInput4, upsConfigHighVoltageTransferPoint=upsConfigHighVoltageTransferPoint, input2=input2, digital1=digital1, sensorMan6ThresholdLow=sensorMan6ThresholdLow, siteMonitor17=siteMonitor17, alarmSiteMonitor12=alarmSiteMonitor12, siteMonitor58=siteMonitor58, analog2=analog2, upsRebootWithDuration=upsRebootWithDuration, analog3=analog3, sensorMan7Offset=sensorMan7Offset, alarmSiteMonitor63=alarmSiteMonitor63, sensorMan8Unit=sensorMan8Unit, stsAutoTransfermode=stsAutoTransfermode, alarmSensorManager4High=alarmSensorManager4High, alarmSiteManagerAnalogInput5=alarmSiteManagerAnalogInput5, upsBasicConfigGroup=upsBasicConfigGroup, sensorMan=sensorMan, sensorMan5Scaling=sensorMan5Scaling, upsBypassCurrent=upsBypassCurrent, analog7Min=analog7Min, analog2Max=analog2Max, alarmAUXInput3=alarmAUXInput3, input3Value=input3Value, upsInputAuxCurrent=upsInputAuxCurrent, sensorMan7Unit=sensorMan7Unit, input4Value=input4Value, siteMonitor=siteMonitor, upsAlarmChargerFailed=upsAlarmChargerFailed, siteMonitor57=siteMonitor57, upsTestResultsDetail=upsTestResultsDetail, output1Location=output1Location, upsSubsetBatteryGroup=upsSubsetBatteryGroup, siteMonitor55=siteMonitor55, analog4Max=analog4Max, upsInputEntry=upsInputEntry, analog1Min=analog1Min, alarmSiteMonitor60=alarmSiteMonitor60, sts=sts, alarmSiteMonitor38=alarmSiteMonitor38, upsSubsetGroups=upsSubsetGroups, upsIdent=upsIdent, sensorMan3Scaling=sensorMan3Scaling, alarmSiteMonitor30=alarmSiteMonitor30, sensor2=sensor2, upsSecondsOnBattery=upsSecondsOnBattery, relais2=relais2, analog6Min=analog6Min, sensorMan6ThresholdHigh=sensorMan6ThresholdHigh, alarmSiteMonitor62=alarmSiteMonitor62, siteMonitor31=siteMonitor31, siteMonitor36=siteMonitor36, sensorMan8Scaling=sensorMan8Scaling, upsOutputEntry=upsOutputEntry, upsIdentUPSSoftwareVersion=upsIdentUPSSoftwareVersion, input1Location=input1Location, sensorMan3Location=sensorMan3Location, alarmSiteMonitor19=alarmSiteMonitor19, siteMonitor52=siteMonitor52, upsSubsetOutputGroup=upsSubsetOutputGroup, upsBasicInputGroup=upsBasicInputGroup, digital7=digital7, sensorMan4Scaling=sensorMan4Scaling, upsFullBypassGroup=upsFullBypassGroup, alarmSiteMonitor28=alarmSiteMonitor28, upsConfigOutputFreq=upsConfigOutputFreq, siteMonitor13=siteMonitor13, upsSubsetCompliance=upsSubsetCompliance, siteMonitor38=siteMonitor38, stsManualBypass2On=stsManualBypass2On, stsStaticSwitch2On=stsStaticSwitch2On, input1=input1, sensorMan8Offset=sensorMan8Offset, upsTestNoTestsInitiated=upsTestNoTestsInitiated, upsBasicControlGroup=upsBasicControlGroup, relais3=relais3, upsSystemContact=upsSystemContact, sensorMan6Scaling=sensorMan6Scaling, alarmSiteMonitor22=alarmSiteMonitor22, sensorMan4ThresholdLow=sensorMan4ThresholdLow, alarmSiteMonitor4=alarmSiteMonitor4, upsSerialNumber=upsSerialNumber, upsInputTable=upsInputTable, alarmSiteManagerAnalogInput3=alarmSiteManagerAnalogInput3, analog6Max=analog6Max, upsOutputSource=upsOutputSource, sensorMan3Offset=sensorMan3Offset, alarmAUXInput1=alarmAUXInput1, alarmSiteMonitor50=alarmSiteMonitor50, upsOutputNumLines=upsOutputNumLines, stsAutostartEnabled=stsAutostartEnabled, upsTrapOnBattery=upsTrapOnBattery, alarmSiteMonitor1=alarmSiteMonitor1, siteMonitor40=siteMonitor40, input2Value=input2Value, input4Location=input4Location, output4=output4, upsBasicGroups=upsBasicGroups, upsInputAuxFrequency=upsInputAuxFrequency, sensorMan2ThresholdHigh=sensorMan2ThresholdHigh, upsConfig=upsConfig, sensorMan1ThresholdHigh=sensorMan1ThresholdHigh, upsAlarmOnBattery=upsAlarmOnBattery, alarmSiteManagerDigitalInput3=alarmSiteManagerDigitalInput3, siteMonitor4=siteMonitor4, upsOutputLineIndex=upsOutputLineIndex, analog7Max=analog7Max, sensorMan7ThresholdHigh=sensorMan7ThresholdHigh, relais8=relais8, upsAlarmInputBad=upsAlarmInputBad, alarmSensorManager6High=alarmSensorManager6High, analog5=analog5, siteMonitor21=siteMonitor21, output1Value=output1Value, upsInput=upsInput, upsBasicOutputGroup=upsBasicOutputGroup, upsTestId=upsTestId, siteMonitor50=siteMonitor50, upsFullGroups=upsFullGroups, upsAlarmOutputOverload=upsAlarmOutputOverload, upsBypassVoltage=upsBypassVoltage, siteMonitor20=siteMonitor20, alarmSiteManagerMarker2=alarmSiteManagerMarker2, sensor1=sensor1, siteMonitor41=siteMonitor41, input3=input3, alarmSiteMonitor23=alarmSiteMonitor23, upsAlarmDiagnosticTestFailed=upsAlarmDiagnosticTestFailed, upsAlarmId=upsAlarmId, upsTrapAlarmEntryRemoved=upsTrapAlarmEntryRemoved, upsInputAuxTable=upsInputAuxTable, upsAlarmFuseFailure=upsAlarmFuseFailure, mib_2=mib_2, siteMonitor61=siteMonitor61, upsAlarmOutputOffAsRequested=upsAlarmOutputOffAsRequested, upsInputAuxVoltage=upsInputAuxVoltage, alarmSiteMonitor16=alarmSiteMonitor16, alarmSiteMonitor6=alarmSiteMonitor6, alarmSensorManager6Low=alarmSensorManager6Low, analog1Max=analog1Max, upsOutput=upsOutput, upsBypassNumLines=upsBypassNumLines, upsTestAbortTestInProgress=upsTestAbortTestInProgress, sensorMan1ThresholdLow=sensorMan1ThresholdLow, upsTestSpinLock=upsTestSpinLock, alarmSiteMonitor42=alarmSiteMonitor42, sensorMan6Unit=sensorMan6Unit, siteMonitor16=siteMonitor16, alarmSiteMonitor39=alarmSiteMonitor39, alarmBlackBoxReady=alarmBlackBoxReady, upsConfigInputFreq=upsConfigInputFreq, alarmSiteMonitor48=alarmSiteMonitor48, alarmSiteMonitor24=alarmSiteMonitor24, marker1=marker1, analog7=analog7, alarmSiteMonitor10=alarmSiteMonitor10, alarmTransferswitchOnManualBypassB=alarmTransferswitchOnManualBypassB, upsWellKnownAlarms=upsWellKnownAlarms, upsAlarmOnBypass=upsAlarmOnBypass, alarmTransferswitchSourceBFailure=alarmTransferswitchSourceBFailure, upsEstimatedMinutesRemaining=upsEstimatedMinutesRemaining, alarmSiteMonitor3=alarmSiteMonitor3, stsStaticSwitch1On=stsStaticSwitch1On, sensorMan1Value=sensorMan1Value, upsInputAuxNumLines=upsInputAuxNumLines, alarmSiteMonitor2=alarmSiteMonitor2, upsSubsetConfigGroup=upsSubsetConfigGroup, upsOutputVoltage=upsOutputVoltage, org=org, upsAlarmLowBattery=upsAlarmLowBattery, analog3Min=analog3Min, alarmTransferswitchGeneralFault=alarmTransferswitchGeneralFault, siteMonitor45=siteMonitor45, siteMonitor56=siteMonitor56, siteMonitor1=siteMonitor1)
mibBuilder.exportSymbols("UPS-MIB", siteMonitor3=siteMonitor3, upsAlarmDepletedBattery=upsAlarmDepletedBattery, alarmAUXInput4=alarmAUXInput4, siteMonitor22=siteMonitor22, upsIdentAgentSoftwareVersion=upsIdentAgentSoftwareVersion, stsPreferedMains1=stsPreferedMains1, input2Location=input2Location, sensor3=sensor3, upsIdentModel=upsIdentModel, upsInputVoltage=upsInputVoltage, analog1=analog1, sensorMan7ThresholdLow=sensorMan7ThresholdLow, upsAlarmEntry=upsAlarmEntry, analog4=analog4, siteMonitor23=siteMonitor23, siteMonitor43=siteMonitor43, analog5Max=analog5Max, dod=dod, alarmSiteManagerOutput4=alarmSiteManagerOutput4, auxPort2=auxPort2, output4NCContact=output4NCContact, alarmSiteMonitor25=alarmSiteMonitor25, internet=internet, upsFullControlGroup=upsFullControlGroup, alarmSiteMonitor56=alarmSiteMonitor56, sensorMan5Value=sensorMan5Value, alarmSensorManager8High=alarmSensorManager8High, upsControl=upsControl, upsTest=upsTest, input1Value=input1Value, analog8=analog8, alarmUser2=alarmUser2, alarmSiteMonitor7=alarmSiteMonitor7, upsAlarmShutdownPending=upsAlarmShutdownPending, output2Location=output2Location, output1NCContact=output1NCContact, alarmSiteMonitor44=alarmSiteMonitor44, alarmUser3=alarmUser3, sensorMan5ThresholdHigh=sensorMan5ThresholdHigh, upsInputTruePower=upsInputTruePower, alarmSiteManagerOutput7=alarmSiteManagerOutput7, upsBasicTestGroup=upsBasicTestGroup, marker5=marker5, upsBasicBypassGroup=upsBasicBypassGroup, alarmSiteMonitor47=alarmSiteMonitor47, alarmSensorManager4Low=alarmSensorManager4Low, upsInputAuxTruePower=upsInputAuxTruePower, alarmUser7=alarmUser7, alarmSiteManagerDigitalInput2=alarmSiteManagerDigitalInput2, alarmSiteMonitor53=alarmSiteMonitor53, alarmSiteMonitor29=alarmSiteMonitor29, sensorMan5Unit=sensorMan5Unit, upsTrapTestCompleted=upsTrapTestCompleted, alarmSensorManagerComLost=alarmSensorManagerComLost, upsAlarmShutdownImminent=upsAlarmShutdownImminent, upsFullTestGroup=upsFullTestGroup, alarmSiteManagerAnalogInput4=alarmSiteManagerAnalogInput4, upsInputAuxBads=upsInputAuxBads, alarmTransferswitchOnManualBypassA=alarmTransferswitchOnManualBypassA, alarmSiteManagerMarker4=alarmSiteManagerMarker4, upsIdentName=upsIdentName, upsLocation=upsLocation, alarmSiteManagerDigitalInput6=alarmSiteManagerDigitalInput6, siteMonitor35=siteMonitor35, alarmSiteMonitor8=alarmSiteMonitor8, upsTestStartTime=upsTestStartTime, sensorMan3Value=sensorMan3Value, upsTrapAlarmEntryAdded=upsTrapAlarmEntryAdded, sensor4=sensor4, alarmSiteMonitor31=alarmSiteMonitor31, alarmSiteMonitor43=alarmSiteMonitor43, alarmSiteManagerDigitalInput1=alarmSiteManagerDigitalInput1, upsAlarmAwaitingPower=upsAlarmAwaitingPower, siteMonitor48=siteMonitor48, upsTestResultsSummary=upsTestResultsSummary, digital3=digital3, siteMonitor51=siteMonitor51, sensorMan2Unit=sensorMan2Unit, auxPort3=auxPort3, alarmSiteManagerOutput8=alarmSiteManagerOutput8, statusCharging=statusCharging, upsTestGeneralSystemsTest=upsTestGeneralSystemsTest, upsAdditionalValuesGroup=upsAdditionalValuesGroup, upsFullAlarmGroup=upsFullAlarmGroup, alarmTransferswitchStaticSwitchBFailure=alarmTransferswitchStaticSwitchBFailure, output3Location=output3Location, upsOutputFrequency=upsOutputFrequency, upsBypassFrequency=upsBypassFrequency, analog2Min=analog2Min, alarmSiteMonitor57=alarmSiteMonitor57, upsBypassLineIndex=upsBypassLineIndex, output3=output3, sensorMan2Offset=sensorMan2Offset, statusDischarging=statusDischarging, sensorMan4Location=sensorMan4Location, siteMonitor37=siteMonitor37, upsTraps=upsTraps, siteMonitor18=siteMonitor18, analog8Max=analog8Max, alarmSiteMonitor26=alarmSiteMonitor26, alarmSensorManagerInput3=alarmSensorManagerInput3, sensorMan4Offset=sensorMan4Offset, alarmSiteMonitor45=alarmSiteMonitor45, sensorMan3ThresholdLow=sensorMan3ThresholdLow, sensorMan8Location=sensorMan8Location, alarmSiteManagerAnalogInput7=alarmSiteManagerAnalogInput7, upsIdentManufacturer=upsIdentManufacturer, upsBypassPower=upsBypassPower, aux=aux, output4Location=output4Location, stsPreferedMains2=stsPreferedMains2, upsAutoRestart=upsAutoRestart, upsAlarmBypassBad=upsAlarmBypassBad, sensor6=sensor6, output2NCContact=output2NCContact, alarmSiteManagerAnalogInput1=alarmSiteManagerAnalogInput1, upsObjects=upsObjects, alarmSiteManagerMarker6=alarmSiteManagerMarker6, analog4Min=analog4Min, upsAlarmThresholdWarning=upsAlarmThresholdWarning, upsAlarmInputAuxBad=upsAlarmInputAuxBad, digital5=digital5, upsSubsetIdentGroup=upsSubsetIdentGroup, digital=digital, analog8Min=analog8Min, sensorMan3ThresholdHigh=sensorMan3ThresholdHigh, relais6=relais6, sensorMan7Value=sensorMan7Value, siteMonitor54=siteMonitor54, upsInputAux=upsInputAux, alarmSiteMonitor46=alarmSiteMonitor46, alarmSiteMonitor36=alarmSiteMonitor36, alarmSiteMonitor51=alarmSiteMonitor51, sensorMan4Unit=sensorMan4Unit, alarmSensorManager8Low=alarmSensorManager8Low, upsMIB=upsMIB, upsAlarm=upsAlarm, alarmSiteMonitor61=alarmSiteMonitor61, alarmSiteMonitor54=alarmSiteMonitor54, upsConfigOutputPower=upsConfigOutputPower, alarmSiteMonitor9=alarmSiteMonitor9, sensorMan4ThresholdHigh=sensorMan4ThresholdHigh, upsBatteryTemperature=upsBatteryTemperature, upsConfigOutputVoltage=upsConfigOutputVoltage, upsConfigLowVoltageTransferPoint=upsConfigLowVoltageTransferPoint, upsAlarmBatteryBad=upsAlarmBatteryBad, marker8=marker8, alarmVuesWindalarm=alarmVuesWindalarm, upsTestDeepBatteryCalibration=upsTestDeepBatteryCalibration, digital8=digital8, upsAlarmGeneralFault=upsAlarmGeneralFault, upsAlarmCommunicationsLost=upsAlarmCommunicationsLost, alarmSiteManagerOutput5=alarmSiteManagerOutput5, upsEstimatedChargeRemaining=upsEstimatedChargeRemaining, siteMonitor63=siteMonitor63, alarmSiteManagerMarker1=alarmSiteManagerMarker1, alarmSensorManagerOutput4=alarmSensorManagerOutput4, alarmSensorManager3Low=alarmSensorManager3Low, siteMonitor19=siteMonitor19, alarmSiteManagerAnalogInput2=alarmSiteManagerAnalogInput2, sensor7=sensor7, upsFullOutputGroup=upsFullOutputGroup, alarmSensorManager7High=alarmSensorManager7High, marker7=marker7, alarmSensorManager2Low=alarmSensorManager2Low, sensorMan5Location=sensorMan5Location, upsShutdownAfterDelay=upsShutdownAfterDelay, alarmUser1=alarmUser1, analog=analog, alarmSensorManager5High=alarmSensorManager5High, sensorMan8ThresholdLow=sensorMan8ThresholdLow, analog6=analog6, output2Value=output2Value, alarmSiteMonitor49=alarmSiteMonitor49, siteMonitor44=siteMonitor44, alarmSiteManagerOutput2=alarmSiteManagerOutput2, alarmUser4=alarmUser4, upsIdentAttachedDevices=upsIdentAttachedDevices, upsFullInputGroup=upsFullInputGroup, alarmSiteMonitor18=alarmSiteMonitor18, sensorMan5Offset=sensorMan5Offset, relais1=relais1, alarmSensorManagerInput2=alarmSensorManagerInput2, marker=marker, alarmSiteMonitor11=alarmSiteMonitor11, siteMonitor7=siteMonitor7, alarmSiteMonitor37=alarmSiteMonitor37, upsAlarmTime=upsAlarmTime, siteMonitor64=siteMonitor64, siteMonitor27=siteMonitor27, siteMonitor59=siteMonitor59, alarmSiteMonitor20=alarmSiteMonitor20, alarmSiteMonitor55=alarmSiteMonitor55, alarmSiteMonitor14=alarmSiteMonitor14, relais5=relais5, upsBasicAlarmGroup=upsBasicAlarmGroup, alarmSensorManager1Low=alarmSensorManager1Low, PositiveInteger=PositiveInteger, alarmSiteMonitor21=alarmSiteMonitor21, upsConfigInputVoltage=upsConfigInputVoltage, auxPort1=auxPort1, siteMonitor2=siteMonitor2, sensorMan1Location=sensorMan1Location, upsBattery=upsBattery, sensorMan2Location=sensorMan2Location, upsFullIdentGroup=upsFullIdentGroup, alarmSiteMonitor5=alarmSiteMonitor5, alarmTransferswitchStaticSwitchAFailure=alarmTransferswitchStaticSwitchAFailure, stsSourcesSynchron=stsSourcesSynchron, siteMonitor47=siteMonitor47, siteMonitor11=siteMonitor11, sensor8=sensor8, mgmt=mgmt, upsShutdownType=upsShutdownType, upsConfigOutputVA=upsConfigOutputVA, marker3=marker3, upsWellKnownTests=upsWellKnownTests, stsManualBypass1On=stsManualBypass1On, sensorMan8Value=sensorMan8Value, output2=output2, upsOutputCurrent=upsOutputCurrent, alarmTransferswitchSourcesAsynchronous=alarmTransferswitchSourcesAsynchronous, alarmSensorManager1High=alarmSensorManager1High, NonNegativeInteger=NonNegativeInteger, alarmTransferswitchOutputOverload=alarmTransferswitchOutputOverload, input4NCContact=input4NCContact, output3NCContact=output3NCContact, upsBatteryCurrent=upsBatteryCurrent, upsFullBatteryGroup=upsFullBatteryGroup, input2NCContact=input2NCContact, upsBasicCompliance=upsBasicCompliance, alarmTransferswitchOnStaticSwitchB=alarmTransferswitchOnStaticSwitchB, upsInputNumLines=upsInputNumLines, alarmSiteManagerMarker5=alarmSiteManagerMarker5, upsStartupAfterDelay=upsStartupAfterDelay, alarmSiteMonitor13=alarmSiteMonitor13, upsAlarmTestInProgress=upsAlarmTestInProgress, sensorMan5ThresholdLow=sensorMan5ThresholdLow, upsAlarmUpsSystemOff=upsAlarmUpsSystemOff, upsAlarmUpsOffAsRequested=upsAlarmUpsOffAsRequested, relais7=relais7, upsGroups=upsGroups, additionalValues=additionalValues, siteMonitor28=siteMonitor28, upsInputLineIndex=upsInputLineIndex, alarmSensorManagerOutput1=alarmSensorManagerOutput1, alarmSiteManagerMarker7=alarmSiteManagerMarker7, alarmSiteMonitor64=alarmSiteMonitor64, sensorMan4Value=sensorMan4Value, upsInputAuxEntry=upsInputAuxEntry, upsTestQuickBatteryTest=upsTestQuickBatteryTest, upsConfigAudibleStatus=upsConfigAudibleStatus, siteMonitor24=siteMonitor24, sensor5=sensor5)
mibBuilder.exportSymbols("UPS-MIB", upsAlarmsPresent=upsAlarmsPresent, output4Value=output4Value, siteMonitor53=siteMonitor53, alarmSiteManagerDigitalInput8=alarmSiteManagerDigitalInput8, sensorMan2Scaling=sensorMan2Scaling, alarmTransferswitchRedundancyLost=alarmTransferswitchRedundancyLost, upsOutputTable=upsOutputTable, upsBypassEntry=upsBypassEntry, sensorMan6Value=sensorMan6Value, alarmSensorManagerOutput2=alarmSensorManagerOutput2, alarmTransferswitchSourceAFailure=alarmTransferswitchSourceAFailure, alarmSiteManagerMarker8=alarmSiteManagerMarker8, digital4=digital4, alarmSiteMonitor35=alarmSiteMonitor35, marker6=marker6, upsAlarmFanFailure=upsAlarmFanFailure, siteMonitor49=siteMonitor49, sensorMan1Scaling=sensorMan1Scaling, input3NCContact=input3NCContact, sensorMan1Unit=sensorMan1Unit, alarmSiteManagerDigitalInput7=alarmSiteManagerDigitalInput7, input3Location=input3Location, siteMonitor62=siteMonitor62, siteMonitor14=siteMonitor14, upsBypass=upsBypass, siteMonitor5=siteMonitor5, upsSubsetControlGroup=upsSubsetControlGroup, alarmSiteManagerOutput1=alarmSiteManagerOutput1, alarmSensorManager3High=alarmSensorManager3High, alarmSensorManager5Low=alarmSensorManager5Low, alarmTransferswitchOnStaticSwitchA=alarmTransferswitchOnStaticSwitchA, upsFullCompliance=upsFullCompliance, alarmSiteManagerMarker3=alarmSiteManagerMarker3, sensorMan2Value=sensorMan2Value, auxPort4=auxPort4, siteMonitor6=siteMonitor6, sensorMan3Unit=sensorMan3Unit, digital2=digital2, alarmSiteMonitor15=alarmSiteMonitor15, siteMonitor12=siteMonitor12, siteMonitor10=siteMonitor10, alarmAUXInput2=alarmAUXInput2, upsInputAuxIndex=upsInputAuxIndex, alarmSiteMonitor58=alarmSiteMonitor58, upsSubsetAlarmGroup=upsSubsetAlarmGroup)
