"""Senml unit list from the IANA SenML registry.

https://www.iana.org/assignments/senml/senml-units.csv

"""
#  ('Symbol', 'Description', 'Type', 'Reference'),
SENML = [
    ("m", "meter", "float", "[RFC8428]"),
    ("kg", "kilogram", "float", "[RFC8428]"),
    ("g", "gram*", "float", "[RFC8428]"),
    ("s", "second", "float", "[RFC8428]"),
    ("A", "ampere", "float", "[RFC8428]"),
    ("K", "kelvin", "float", "[RFC8428]"),
    ("cd", "candela", "float", "[RFC8428]"),
    ("mol", "mole", "float", "[RFC8428]"),
    ("Hz", "hertz", "float", "[RFC8428]"),
    ("rad", "radian", "float", "[RFC8428]"),
    ("sr", "steradian", "float", "[RFC8428]"),
    ("N", "newton", "float", "[RFC8428]"),
    ("Pa", "pascal", "float", "[RFC8428]"),
    ("J", "joule", "float", "[RFC8428]"),
    ("W", "watt", "float", "[RFC8428]"),
    ("C", "coulomb", "float", "[RFC8428]"),
    ("V", "volt", "float", "[RFC8428]"),
    ("F", "farad", "float", "[RFC8428]"),
    ("Ohm", "ohm", "float", "[RFC8428]"),
    ("S", "siemens", "float", "[RFC8428]"),
    ("Wb", "weber", "float", "[RFC8428]"),
    ("T", "tesla", "float", "[RFC8428]"),
    ("H", "henry", "float", "[RFC8428]"),
    ("Cel", "degrees Celsius", "float", "[RFC8428]"),
    ("lm", "lumen", "float", "[RFC8428]"),
    ("lx", "lux", "float", "[RFC8428]"),
    ("Bq", "becquerel", "float", "[RFC8428]"),
    ("Gy", "gray", "float", "[RFC8428]"),
    ("Sv", "sievert", "float", "[RFC8428]"),
    ("kat", "katal", "float", "[RFC8428]"),
    ("m2", "square meter (area)", "float", "[RFC8428]"),
    ("m3", "cubic meter (volume)", "float", "[RFC8428]"),
    ("l", "liter (volume)*", "float", "[RFC8428]"),
    ("m/s", "meter per second (velocity)", "float", "[RFC8428]"),
    ("m/s2", "meter per square second (acceleration)", "float", "[RFC8428]"),
    ("m3/s", "cubic meter per second (flow rate)", "float", "[RFC8428]"),
    ("l/s", "liter per second (flow rate)*", "float", "[RFC8428]"),
    ("W/m2", "watt per square meter (irradiance)", "float", "[RFC8428]"),
    ("cd/m2", "candela per square meter (luminance)", "float", "[RFC8428]"),
    ("bit", "bit (information content)", "float", "[RFC8428]"),
    ("bit/s", "bit per second (data rate)", "float", "[RFC8428]"),
    ("lat", "degrees latitude[1]", "float", "[RFC8428]"),
    ("lon", "degrees longitude[1]", "float", "[RFC8428]"),
    ("pH", "pH value (acidity; logarithmic quantity)", "float", "[RFC8428]"),
    ("dB", "decibel (logarithmic quantity)", "float", "[RFC8428]"),
    ("dBW", "decibel relative to 1 W (power level)", "float", "[RFC8428]"),
    (
        "Bspl",
        "bel (sound pressure level; logarithmic quantity)*",
        "float",
        "[RFC8428]",
    ),
    ("count", "1 (counter value)", "float", "[RFC8428]"),
    ("/", "1 (ratio e.g., value of a switch; [2])", "float", "[RFC8428]"),
    ("%", "1 (ratio e.g., value of a switch; [2])*", "float", "[RFC8428]"),
    ("%RH", "Percentage (Relative Humidity)", "float", "[RFC8428]"),
    (
        "%EL",
        "Percentage (remaining battery energy level)",
        "float",
        "[RFC8428]",
    ),
    ("EL", "seconds (remaining battery energy level)", "float", "[RFC8428]"),
    ("1/s", "1 per second (event rate)", "float", "[RFC8428]"),
    ("1/min", '1 per minute (event rate, "rpm")*', "float", "[RFC8428]"),
    (
        "beat/min",
        "1 per minute (heart rate in beats per minute)*",
        "float",
        "[RFC8428]",
    ),
    ("beats", "1 (Cumulative number of heart beats)*", "float", "[RFC8428]"),
    ("S/m", "Siemens per meter (conductivity)", "float", "[RFC8428]"),
    (
        "B",
        "Byte (information content)",
        "float",
        "[RFC-ietf-core-senml-more-units-06]",
    ),
    (
        "VA",
        "volt-ampere (Apparent Power)",
        "float",
        "[RFC-ietf-core-senml-more-units-06]",
    ),
    (
        "VAs",
        "volt-ampere second (Apparent Energy)",
        "float",
        "[RFC-ietf-core-senml-more-units-06]",
    ),
    (
        "var",
        "volt-ampere reactive (Reactive Power)",
        "float",
        "[RFC-ietf-core-senml-more-units-06]",
    ),
    (
        "vars",
        "volt-ampere reactive second (Reactive Energy)",
        "float",
        "[RFC-ietf-core-senml-more-units-06]",
    ),
    (
        "J/m",
        "joule per meter (Energy per distance)",
        "float",
        "[RFC-ietf-core-senml-more-units-06]",
    ),
    (
        "kg/m3",
        "kilogram per cubic meter (mass density, mass concentration)",
        "float",
        "[RFC-ietf-core-senml-more-units-06]",
    ),
    ("deg", "degree (angle)*", "float", "[RFC-ietf-core-senml-more-units-06]"),
]
SENML_UNITS = [x[0] for x in SENML]
