"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkGroup = exports.EncryptionOption = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const statement = require("cdk-iam-floyd");
const lambda_1 = require("./lambda");
const resourceType = 'Custom::Athena-WorkGroup';
const ID = `CFN::Resource::${resourceType}`;
const createdByTag = 'CreatedByCfnCustomResource';
/**
 * @stability stable
 */
var EncryptionOption;
(function (EncryptionOption) {
    EncryptionOption["SSE_S3"] = "SSE_S3";
    EncryptionOption["SSE_KMS"] = "SSE_KMS";
    EncryptionOption["CSE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
/**
 * An Athena WorkGroup.
 *
 * @stability stable
 */
class WorkGroup extends cdk.Construct {
    /**
     * Defines a new Athena WorkGroup.
     *
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Name of the WorkGroup.
         *
         * @stability stable
         */
        this.name = '';
        /**
         * ARN of the WorkGroup.
         *
         * @stability stable
         */
        this.arn = '';
        if (typeof props.bytesScannedCutoffPerQuery !== 'undefined' &&
            props.bytesScannedCutoffPerQuery < 10000000) {
            cdk.Annotations.of(scope.node).addError(`Parameter bytesScannedCutoffPerQuery must have value greater than or equal to 10000000. Got ${props.bytesScannedCutoffPerQuery}`);
        }
        if (!props.name.match(/^[a-zA-Z0-9._-]{1,128}$/)) {
            cdk.Annotations.of(scope.node).addError(`The WorkGroup name must match /^[a-zA-Z0-9._-]{1,128}$/. Got "${props.name}"`);
        }
        this.tags = new cdk.TagManager(cdk.TagType.MAP, resourceType);
        this.tags.setTag(createdByTag, ID);
        const stack = cdk.Stack.of(this);
        this.lambda = lambda_1.ensureLambda(this);
        this.name = props.name;
        const workGroup = new cdk.CustomResource(this, `Athena-WorkGroup-${this.name}`, {
            serviceToken: this.lambda.functionArn,
            resourceType: resourceType,
            properties: {
                Name: this.name,
                Description: props.desc || '',
                BytesScannedCutoffPerQuery: props.bytesScannedCutoffPerQuery,
                EnforceWorkGroupConfiguration: props.enforceWorkGroupConfiguration || false,
                PublishCloudWatchMetricsEnabled: props.publishCloudWatchMetricsEnabled || false,
                RequesterPaysEnabled: props.requesterPaysEnabled || false,
                //EngineVersion: props.engineVersion,
                ResultConfiguration: props.resultConfiguration,
                StackName: stack.stackName,
                Arn: new statement.Athena()
                    .onWorkgroup(this.name, stack.account, stack.region)
                    .toJSON().Resource,
                Tags: cdk.Lazy.any({
                    produce: () => this.tags.renderTags(),
                }),
            },
        });
        this.arn = workGroup.getAttString('ARN');
    }
}
exports.WorkGroup = WorkGroup;
_a = JSII_RTTI_SYMBOL_1;
WorkGroup[_a] = { fqn: "cdk-athena.WorkGroup", version: "2.0.2" };
//# sourceMappingURL=data:application/json;base64,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