"""
Generated definitions and data structures for abi3info.

This module should not be used directly; it is not a public API.
"""

from __future__ import annotations

from typing import Final

from abi3info.models import (
    Data,
    FeatureMacro,
    FullStruct,
    Function,
    Macro,
    OpaqueStruct,
    PartialStruct,
    PyVersion,
    Struct,
    Symbol,
    Typedef,
)

# this file was generated; do not modify it by hand!
_FEATURE_MACROS: Final[dict[str, FeatureMacro]] = {
    "MS_WINDOWS": FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
    "HAVE_FORK": FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
    "USE_STACKCHECK": FeatureMacro(
        name="USE_STACKCHECK", doc="on platforms with USE_STACKCHECK", windows="maybe"
    ),
    "PY_HAVE_THREAD_NATIVE_ID": FeatureMacro(
        name="PY_HAVE_THREAD_NATIVE_ID", doc="on platforms with native thread IDs", windows=True
    ),
    "Py_REF_DEBUG": FeatureMacro(
        name="Py_REF_DEBUG",
        doc="when Python is compiled in debug mode (with Py_REF_DEBUG)",
        windows="maybe",
    ),
    "Py_TRACE_REFS": FeatureMacro(
        name="Py_TRACE_REFS", doc="when Python is compiled with Py_TRACE_REFS", windows="maybe"
    ),
}
_STRUCTS: Final[dict[str, Struct]] = {
    "PyObject": PartialStruct(
        name="PyObject", added=PyVersion(major=3, minor=2), members=["ob_refcnt", "ob_type"]
    ),
    "PyVarObject": PartialStruct(
        name="PyVarObject", added=PyVersion(major=3, minor=2), members=["ob_base", "ob_size"]
    ),
    "PyMethodDef": FullStruct(name="PyMethodDef", added=PyVersion(major=3, minor=2)),
    "PyMemberDef": FullStruct(name="PyMemberDef", added=PyVersion(major=3, minor=2)),
    "PyGetSetDef": FullStruct(name="PyGetSetDef", added=PyVersion(major=3, minor=2)),
    "PyModuleDef_Base": FullStruct(name="PyModuleDef_Base", added=PyVersion(major=3, minor=2)),
    "PyModuleDef": FullStruct(name="PyModuleDef", added=PyVersion(major=3, minor=2)),
    "PyStructSequence_Field": FullStruct(
        name="PyStructSequence_Field", added=PyVersion(major=3, minor=2)
    ),
    "PyStructSequence_Desc": FullStruct(
        name="PyStructSequence_Desc", added=PyVersion(major=3, minor=2)
    ),
    "PyType_Slot": FullStruct(name="PyType_Slot", added=PyVersion(major=3, minor=2)),
    "PyType_Spec": FullStruct(name="PyType_Spec", added=PyVersion(major=3, minor=2)),
    "PyThreadState": OpaqueStruct(name="PyThreadState", added=PyVersion(major=3, minor=2)),
    "PyInterpreterState": OpaqueStruct(
        name="PyInterpreterState", added=PyVersion(major=3, minor=2)
    ),
    "PyFrameObject": OpaqueStruct(name="PyFrameObject", added=PyVersion(major=3, minor=2)),
    "symtable": OpaqueStruct(name="symtable", added=PyVersion(major=3, minor=2)),
    "PyWeakReference": OpaqueStruct(name="PyWeakReference", added=PyVersion(major=3, minor=2)),
    "PyLongObject": OpaqueStruct(name="PyLongObject", added=PyVersion(major=3, minor=2)),
    "PyTypeObject": OpaqueStruct(name="PyTypeObject", added=PyVersion(major=3, minor=2)),
    "Py_buffer": FullStruct(name="Py_buffer", added=PyVersion(major=3, minor=11)),
    "PyABIInfo": FullStruct(name="PyABIInfo", added=PyVersion(major=3, minor=15)),
}
_FUNCTIONS: Final[dict[Symbol, Function]] = {
    Symbol(name="PyType_FromSpec", visibility=None): Function(
        symbol=Symbol(name="PyType_FromSpec", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_Parse", visibility=None): Function(
        symbol=Symbol(name="PyArg_Parse", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_ParseTuple", visibility=None): Function(
        symbol=Symbol(name="PyArg_ParseTuple", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_ParseTupleAndKeywords", visibility=None): Function(
        symbol=Symbol(name="PyArg_ParseTupleAndKeywords", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_UnpackTuple", visibility=None): Function(
        symbol=Symbol(name="PyArg_UnpackTuple", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_VaParse", visibility=None): Function(
        symbol=Symbol(name="PyArg_VaParse", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_VaParseTupleAndKeywords", visibility=None): Function(
        symbol=Symbol(name="PyArg_VaParseTupleAndKeywords", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_ValidateKeywordArguments", visibility=None): Function(
        symbol=Symbol(name="PyArg_ValidateKeywordArguments", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBool_FromLong", visibility=None): Function(
        symbol=Symbol(name="PyBool_FromLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_AsString", visibility=None): Function(
        symbol=Symbol(name="PyByteArray_AsString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Concat", visibility=None): Function(
        symbol=Symbol(name="PyByteArray_Concat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_FromObject", visibility=None): Function(
        symbol=Symbol(name="PyByteArray_FromObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_FromStringAndSize", visibility=None): Function(
        symbol=Symbol(name="PyByteArray_FromStringAndSize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Resize", visibility=None): Function(
        symbol=Symbol(name="PyByteArray_Resize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Size", visibility=None): Function(
        symbol=Symbol(name="PyByteArray_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_AsString", visibility=None): Function(
        symbol=Symbol(name="PyBytes_AsString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_AsStringAndSize", visibility=None): Function(
        symbol=Symbol(name="PyBytes_AsStringAndSize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Concat", visibility=None): Function(
        symbol=Symbol(name="PyBytes_Concat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_ConcatAndDel", visibility=None): Function(
        symbol=Symbol(name="PyBytes_ConcatAndDel", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_DecodeEscape", visibility=None): Function(
        symbol=Symbol(name="PyBytes_DecodeEscape", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromFormat", visibility=None): Function(
        symbol=Symbol(name="PyBytes_FromFormat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromFormatV", visibility=None): Function(
        symbol=Symbol(name="PyBytes_FromFormatV", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromObject", visibility=None): Function(
        symbol=Symbol(name="PyBytes_FromObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromString", visibility=None): Function(
        symbol=Symbol(name="PyBytes_FromString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromStringAndSize", visibility=None): Function(
        symbol=Symbol(name="PyBytes_FromStringAndSize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Repr", visibility=None): Function(
        symbol=Symbol(name="PyBytes_Repr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Size", visibility=None): Function(
        symbol=Symbol(name="PyBytes_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_Call", visibility=None): Function(
        symbol=Symbol(name="PyCFunction_Call", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyCFunction_GetFlags", visibility=None): Function(
        symbol=Symbol(name="PyCFunction_GetFlags", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_GetFunction", visibility=None): Function(
        symbol=Symbol(name="PyCFunction_GetFunction", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_GetSelf", visibility=None): Function(
        symbol=Symbol(name="PyCFunction_GetSelf", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_NewEx", visibility=None): Function(
        symbol=Symbol(name="PyCFunction_NewEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCallIter_New", visibility=None): Function(
        symbol=Symbol(name="PyCallIter_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCallable_Check", visibility=None): Function(
        symbol=Symbol(name="PyCallable_Check", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetContext", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_GetContext", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetDestructor", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_GetDestructor", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetName", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_GetName", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetPointer", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_GetPointer", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_Import", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_Import", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_IsValid", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_IsValid", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_New", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetContext", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_SetContext", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetDestructor", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_SetDestructor", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetName", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_SetName", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetPointer", visibility=None): Function(
        symbol=Symbol(name="PyCapsule_SetPointer", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_BackslashReplaceErrors", visibility=None): Function(
        symbol=Symbol(name="PyCodec_BackslashReplaceErrors", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Decode", visibility=None): Function(
        symbol=Symbol(name="PyCodec_Decode", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Decoder", visibility=None): Function(
        symbol=Symbol(name="PyCodec_Decoder", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Encode", visibility=None): Function(
        symbol=Symbol(name="PyCodec_Encode", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Encoder", visibility=None): Function(
        symbol=Symbol(name="PyCodec_Encoder", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_IgnoreErrors", visibility=None): Function(
        symbol=Symbol(name="PyCodec_IgnoreErrors", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_IncrementalDecoder", visibility=None): Function(
        symbol=Symbol(name="PyCodec_IncrementalDecoder", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_IncrementalEncoder", visibility=None): Function(
        symbol=Symbol(name="PyCodec_IncrementalEncoder", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_KnownEncoding", visibility=None): Function(
        symbol=Symbol(name="PyCodec_KnownEncoding", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_LookupError", visibility=None): Function(
        symbol=Symbol(name="PyCodec_LookupError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Register", visibility=None): Function(
        symbol=Symbol(name="PyCodec_Register", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_RegisterError", visibility=None): Function(
        symbol=Symbol(name="PyCodec_RegisterError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_ReplaceErrors", visibility=None): Function(
        symbol=Symbol(name="PyCodec_ReplaceErrors", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_StreamReader", visibility=None): Function(
        symbol=Symbol(name="PyCodec_StreamReader", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_StreamWriter", visibility=None): Function(
        symbol=Symbol(name="PyCodec_StreamWriter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_StrictErrors", visibility=None): Function(
        symbol=Symbol(name="PyCodec_StrictErrors", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_XMLCharRefReplaceErrors", visibility=None): Function(
        symbol=Symbol(name="PyCodec_XMLCharRefReplaceErrors", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_FromDoubles", visibility=None): Function(
        symbol=Symbol(name="PyComplex_FromDoubles", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_ImagAsDouble", visibility=None): Function(
        symbol=Symbol(name="PyComplex_ImagAsDouble", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_RealAsDouble", visibility=None): Function(
        symbol=Symbol(name="PyComplex_RealAsDouble", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewClassMethod", visibility=None): Function(
        symbol=Symbol(name="PyDescr_NewClassMethod", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewGetSet", visibility=None): Function(
        symbol=Symbol(name="PyDescr_NewGetSet", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewMember", visibility=None): Function(
        symbol=Symbol(name="PyDescr_NewMember", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewMethod", visibility=None): Function(
        symbol=Symbol(name="PyDescr_NewMethod", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictProxy_New", visibility=None): Function(
        symbol=Symbol(name="PyDictProxy_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Clear", visibility=None): Function(
        symbol=Symbol(name="PyDict_Clear", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Contains", visibility=None): Function(
        symbol=Symbol(name="PyDict_Contains", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Copy", visibility=None): Function(
        symbol=Symbol(name="PyDict_Copy", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_DelItem", visibility=None): Function(
        symbol=Symbol(name="PyDict_DelItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_DelItemString", visibility=None): Function(
        symbol=Symbol(name="PyDict_DelItemString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItem", visibility=None): Function(
        symbol=Symbol(name="PyDict_GetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItemString", visibility=None): Function(
        symbol=Symbol(name="PyDict_GetItemString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItemWithError", visibility=None): Function(
        symbol=Symbol(name="PyDict_GetItemWithError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Items", visibility=None): Function(
        symbol=Symbol(name="PyDict_Items", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Keys", visibility=None): Function(
        symbol=Symbol(name="PyDict_Keys", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Merge", visibility=None): Function(
        symbol=Symbol(name="PyDict_Merge", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_MergeFromSeq2", visibility=None): Function(
        symbol=Symbol(name="PyDict_MergeFromSeq2", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_New", visibility=None): Function(
        symbol=Symbol(name="PyDict_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Next", visibility=None): Function(
        symbol=Symbol(name="PyDict_Next", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_SetItem", visibility=None): Function(
        symbol=Symbol(name="PyDict_SetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_SetItemString", visibility=None): Function(
        symbol=Symbol(name="PyDict_SetItemString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Size", visibility=None): Function(
        symbol=Symbol(name="PyDict_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Update", visibility=None): Function(
        symbol=Symbol(name="PyDict_Update", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Values", visibility=None): Function(
        symbol=Symbol(name="PyDict_Values", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_BadArgument", visibility=None): Function(
        symbol=Symbol(name="PyErr_BadArgument", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_BadInternalCall", visibility=None): Function(
        symbol=Symbol(name="PyErr_BadInternalCall", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_CheckSignals", visibility=None): Function(
        symbol=Symbol(name="PyErr_CheckSignals", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Clear", visibility=None): Function(
        symbol=Symbol(name="PyErr_Clear", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Display", visibility=None): Function(
        symbol=Symbol(name="PyErr_Display", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_DisplayException", visibility=None): Function(
        symbol=Symbol(name="PyErr_DisplayException", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_ExceptionMatches", visibility=None): Function(
        symbol=Symbol(name="PyErr_ExceptionMatches", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Fetch", visibility=None): Function(
        symbol=Symbol(name="PyErr_Fetch", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Format", visibility=None): Function(
        symbol=Symbol(name="PyErr_Format", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_GivenExceptionMatches", visibility=None): Function(
        symbol=Symbol(name="PyErr_GivenExceptionMatches", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NewException", visibility=None): Function(
        symbol=Symbol(name="PyErr_NewException", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NewExceptionWithDoc", visibility=None): Function(
        symbol=Symbol(name="PyErr_NewExceptionWithDoc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NoMemory", visibility=None): Function(
        symbol=Symbol(name="PyErr_NoMemory", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NormalizeException", visibility=None): Function(
        symbol=Symbol(name="PyErr_NormalizeException", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Occurred", visibility=None): Function(
        symbol=Symbol(name="PyErr_Occurred", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Print", visibility=None): Function(
        symbol=Symbol(name="PyErr_Print", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_PrintEx", visibility=None): Function(
        symbol=Symbol(name="PyErr_PrintEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_ProgramText", visibility=None): Function(
        symbol=Symbol(name="PyErr_ProgramText", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Restore", visibility=None): Function(
        symbol=Symbol(name="PyErr_Restore", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrno", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetFromErrno", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrnoWithFilename", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetFromErrnoWithFilename", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrnoWithFilenameObject", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetFromErrnoWithFilenameObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetInterrupt", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetInterrupt", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetNone", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetNone", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetObject", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetString", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SyntaxLocation", visibility=None): Function(
        symbol=Symbol(name="PyErr_SyntaxLocation", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WarnEx", visibility=None): Function(
        symbol=Symbol(name="PyErr_WarnEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WarnExplicit", visibility=None): Function(
        symbol=Symbol(name="PyErr_WarnExplicit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WarnFormat", visibility=None): Function(
        symbol=Symbol(name="PyErr_WarnFormat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WriteUnraisable", visibility=None): Function(
        symbol=Symbol(name="PyErr_WriteUnraisable", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_AcquireLock", visibility=None): Function(
        symbol=Symbol(name="PyEval_AcquireLock", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyEval_AcquireThread", visibility=None): Function(
        symbol=Symbol(name="PyEval_AcquireThread", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_CallFunction", visibility=None): Function(
        symbol=Symbol(name="PyEval_CallFunction", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyEval_CallMethod", visibility=None): Function(
        symbol=Symbol(name="PyEval_CallMethod", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyEval_CallObjectWithKeywords", visibility=None): Function(
        symbol=Symbol(name="PyEval_CallObjectWithKeywords", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyEval_EvalCode", visibility=None): Function(
        symbol=Symbol(name="PyEval_EvalCode", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_EvalCodeEx", visibility=None): Function(
        symbol=Symbol(name="PyEval_EvalCodeEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_EvalFrame", visibility=None): Function(
        symbol=Symbol(name="PyEval_EvalFrame", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_EvalFrameEx", visibility=None): Function(
        symbol=Symbol(name="PyEval_EvalFrameEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetBuiltins", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetBuiltins", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFrame", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetFrame", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFuncDesc", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetFuncDesc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFuncName", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetFuncName", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetGlobals", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetGlobals", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetLocals", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetLocals", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_InitThreads", visibility=None): Function(
        symbol=Symbol(name="PyEval_InitThreads", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_ReleaseLock", visibility=None): Function(
        symbol=Symbol(name="PyEval_ReleaseLock", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyEval_ReleaseThread", visibility=None): Function(
        symbol=Symbol(name="PyEval_ReleaseThread", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_RestoreThread", visibility=None): Function(
        symbol=Symbol(name="PyEval_RestoreThread", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_SaveThread", visibility=None): Function(
        symbol=Symbol(name="PyEval_SaveThread", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_ThreadsInitialized", visibility=None): Function(
        symbol=Symbol(name="PyEval_ThreadsInitialized", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyException_GetCause", visibility=None): Function(
        symbol=Symbol(name="PyException_GetCause", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_GetContext", visibility=None): Function(
        symbol=Symbol(name="PyException_GetContext", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_GetTraceback", visibility=None): Function(
        symbol=Symbol(name="PyException_GetTraceback", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_SetCause", visibility=None): Function(
        symbol=Symbol(name="PyException_SetCause", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_SetContext", visibility=None): Function(
        symbol=Symbol(name="PyException_SetContext", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_SetTraceback", visibility=None): Function(
        symbol=Symbol(name="PyException_SetTraceback", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_FromFd", visibility=None): Function(
        symbol=Symbol(name="PyFile_FromFd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_GetLine", visibility=None): Function(
        symbol=Symbol(name="PyFile_GetLine", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_WriteObject", visibility=None): Function(
        symbol=Symbol(name="PyFile_WriteObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_WriteString", visibility=None): Function(
        symbol=Symbol(name="PyFile_WriteString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_AsDouble", visibility=None): Function(
        symbol=Symbol(name="PyFloat_AsDouble", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_FromDouble", visibility=None): Function(
        symbol=Symbol(name="PyFloat_FromDouble", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_FromString", visibility=None): Function(
        symbol=Symbol(name="PyFloat_FromString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_GetInfo", visibility=None): Function(
        symbol=Symbol(name="PyFloat_GetInfo", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_GetMax", visibility=None): Function(
        symbol=Symbol(name="PyFloat_GetMax", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_GetMin", visibility=None): Function(
        symbol=Symbol(name="PyFloat_GetMin", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrozenSet_New", visibility=None): Function(
        symbol=Symbol(name="PyFrozenSet_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGC_Collect", visibility=None): Function(
        symbol=Symbol(name="PyGC_Collect", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGILState_Ensure", visibility=None): Function(
        symbol=Symbol(name="PyGILState_Ensure", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGILState_GetThisThreadState", visibility=None): Function(
        symbol=Symbol(name="PyGILState_GetThisThreadState", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGILState_Release", visibility=None): Function(
        symbol=Symbol(name="PyGILState_Release", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_AddModule", visibility=None): Function(
        symbol=Symbol(name="PyImport_AddModule", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_AppendInittab", visibility=None): Function(
        symbol=Symbol(name="PyImport_AppendInittab", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModule", visibility=None): Function(
        symbol=Symbol(name="PyImport_ExecCodeModule", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModuleEx", visibility=None): Function(
        symbol=Symbol(name="PyImport_ExecCodeModuleEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModuleWithPathnames", visibility=None): Function(
        symbol=Symbol(name="PyImport_ExecCodeModuleWithPathnames", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetImporter", visibility=None): Function(
        symbol=Symbol(name="PyImport_GetImporter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetMagicNumber", visibility=None): Function(
        symbol=Symbol(name="PyImport_GetMagicNumber", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetMagicTag", visibility=None): Function(
        symbol=Symbol(name="PyImport_GetMagicTag", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetModuleDict", visibility=None): Function(
        symbol=Symbol(name="PyImport_GetModuleDict", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_Import", visibility=None): Function(
        symbol=Symbol(name="PyImport_Import", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportFrozenModule", visibility=None): Function(
        symbol=Symbol(name="PyImport_ImportFrozenModule", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModule", visibility=None): Function(
        symbol=Symbol(name="PyImport_ImportModule", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModuleLevel", visibility=None): Function(
        symbol=Symbol(name="PyImport_ImportModuleLevel", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModuleNoBlock", visibility=None): Function(
        symbol=Symbol(name="PyImport_ImportModuleNoBlock", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyImport_ReloadModule", visibility=None): Function(
        symbol=Symbol(name="PyImport_ReloadModule", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_Clear", visibility=None): Function(
        symbol=Symbol(name="PyInterpreterState_Clear", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_Delete", visibility=None): Function(
        symbol=Symbol(name="PyInterpreterState_Delete", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_New", visibility=None): Function(
        symbol=Symbol(name="PyInterpreterState_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyIter_Next", visibility=None): Function(
        symbol=Symbol(name="PyIter_Next", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Append", visibility=None): Function(
        symbol=Symbol(name="PyList_Append", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_AsTuple", visibility=None): Function(
        symbol=Symbol(name="PyList_AsTuple", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_GetItem", visibility=None): Function(
        symbol=Symbol(name="PyList_GetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_GetSlice", visibility=None): Function(
        symbol=Symbol(name="PyList_GetSlice", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Insert", visibility=None): Function(
        symbol=Symbol(name="PyList_Insert", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_New", visibility=None): Function(
        symbol=Symbol(name="PyList_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Reverse", visibility=None): Function(
        symbol=Symbol(name="PyList_Reverse", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_SetItem", visibility=None): Function(
        symbol=Symbol(name="PyList_SetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_SetSlice", visibility=None): Function(
        symbol=Symbol(name="PyList_SetSlice", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Size", visibility=None): Function(
        symbol=Symbol(name="PyList_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Sort", visibility=None): Function(
        symbol=Symbol(name="PyList_Sort", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsDouble", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsDouble", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLongAndOverflow", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsLongAndOverflow", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLongLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsLongLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLongLongAndOverflow", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsLongLongAndOverflow", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsSize_t", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsSize_t", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsSsize_t", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsSsize_t", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLongLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLongLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLongLongMask", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLongLongMask", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLongMask", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLongMask", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsVoidPtr", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsVoidPtr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromDouble", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromDouble", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromLongLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromLongLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromSize_t", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromSize_t", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromSsize_t", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromSsize_t", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromString", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromUnsignedLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromUnsignedLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromUnsignedLongLong", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromUnsignedLongLong", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromVoidPtr", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromVoidPtr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_GetInfo", visibility=None): Function(
        symbol=Symbol(name="PyLong_GetInfo", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Check", visibility=None): Function(
        symbol=Symbol(name="PyMapping_Check", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_GetItemString", visibility=None): Function(
        symbol=Symbol(name="PyMapping_GetItemString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_HasKey", visibility=None): Function(
        symbol=Symbol(name="PyMapping_HasKey", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_HasKeyString", visibility=None): Function(
        symbol=Symbol(name="PyMapping_HasKeyString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Items", visibility=None): Function(
        symbol=Symbol(name="PyMapping_Items", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Keys", visibility=None): Function(
        symbol=Symbol(name="PyMapping_Keys", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Length", visibility=None): Function(
        symbol=Symbol(name="PyMapping_Length", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_SetItemString", visibility=None): Function(
        symbol=Symbol(name="PyMapping_SetItemString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Size", visibility=None): Function(
        symbol=Symbol(name="PyMapping_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Values", visibility=None): Function(
        symbol=Symbol(name="PyMapping_Values", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Free", visibility=None): Function(
        symbol=Symbol(name="PyMem_Free", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Malloc", visibility=None): Function(
        symbol=Symbol(name="PyMem_Malloc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Realloc", visibility=None): Function(
        symbol=Symbol(name="PyMem_Realloc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_FromObject", visibility=None): Function(
        symbol=Symbol(name="PyMemoryView_FromObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_GetContiguous", visibility=None): Function(
        symbol=Symbol(name="PyMemoryView_GetContiguous", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddIntConstant", visibility=None): Function(
        symbol=Symbol(name="PyModule_AddIntConstant", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddObject", visibility=None): Function(
        symbol=Symbol(name="PyModule_AddObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddStringConstant", visibility=None): Function(
        symbol=Symbol(name="PyModule_AddStringConstant", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_Create2", visibility=None): Function(
        symbol=Symbol(name="PyModule_Create2", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetDef", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetDef", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetDict", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetDict", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetFilename", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetFilename", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetFilenameObject", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetFilenameObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetName", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetName", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetState", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetState", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_New", visibility=None): Function(
        symbol=Symbol(name="PyModule_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Absolute", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Absolute", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Add", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Add", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_And", visibility=None): Function(
        symbol=Symbol(name="PyNumber_And", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_AsSsize_t", visibility=None): Function(
        symbol=Symbol(name="PyNumber_AsSsize_t", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Check", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Check", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Divmod", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Divmod", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Float", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Float", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_FloorDivide", visibility=None): Function(
        symbol=Symbol(name="PyNumber_FloorDivide", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceAdd", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceAdd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceAnd", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceAnd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceFloorDivide", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceFloorDivide", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceLshift", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceLshift", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceMultiply", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceMultiply", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceOr", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceOr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlacePower", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlacePower", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceRemainder", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceRemainder", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceRshift", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceRshift", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceSubtract", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceSubtract", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceTrueDivide", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceTrueDivide", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceXor", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceXor", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Index", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Index", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Invert", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Invert", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Long", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Long", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Lshift", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Lshift", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Multiply", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Multiply", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Negative", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Negative", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Or", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Or", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Positive", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Positive", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Power", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Power", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Remainder", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Remainder", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Rshift", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Rshift", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Subtract", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Subtract", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_ToBase", visibility=None): Function(
        symbol=Symbol(name="PyNumber_ToBase", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_TrueDivide", visibility=None): Function(
        symbol=Symbol(name="PyNumber_TrueDivide", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Xor", visibility=None): Function(
        symbol=Symbol(name="PyNumber_Xor", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_AfterFork", visibility=None): Function(
        symbol=Symbol(name="PyOS_AfterFork", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyOS_InterruptOccurred", visibility=None): Function(
        symbol=Symbol(name="PyOS_InterruptOccurred", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_double_to_string", visibility=None): Function(
        symbol=Symbol(name="PyOS_double_to_string", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_getsig", visibility=None): Function(
        symbol=Symbol(name="PyOS_getsig", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_mystricmp", visibility=None): Function(
        symbol=Symbol(name="PyOS_mystricmp", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_mystrnicmp", visibility=None): Function(
        symbol=Symbol(name="PyOS_mystrnicmp", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_setsig", visibility=None): Function(
        symbol=Symbol(name="PyOS_setsig", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_snprintf", visibility=None): Function(
        symbol=Symbol(name="PyOS_snprintf", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_string_to_double", visibility=None): Function(
        symbol=Symbol(name="PyOS_string_to_double", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_strtol", visibility=None): Function(
        symbol=Symbol(name="PyOS_strtol", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_strtoul", visibility=None): Function(
        symbol=Symbol(name="PyOS_strtoul", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_vsnprintf", visibility=None): Function(
        symbol=Symbol(name="PyOS_vsnprintf", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_ASCII", visibility=None): Function(
        symbol=Symbol(name="PyObject_ASCII", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_AsFileDescriptor", visibility=None): Function(
        symbol=Symbol(name="PyObject_AsFileDescriptor", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Bytes", visibility=None): Function(
        symbol=Symbol(name="PyObject_Bytes", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Call", visibility=None): Function(
        symbol=Symbol(name="PyObject_Call", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallFunction", visibility=None): Function(
        symbol=Symbol(name="PyObject_CallFunction", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallFunctionObjArgs", visibility=None): Function(
        symbol=Symbol(name="PyObject_CallFunctionObjArgs", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallMethod", visibility=None): Function(
        symbol=Symbol(name="PyObject_CallMethod", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallMethodObjArgs", visibility=None): Function(
        symbol=Symbol(name="PyObject_CallMethodObjArgs", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallObject", visibility=None): Function(
        symbol=Symbol(name="PyObject_CallObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_ClearWeakRefs", visibility=None): Function(
        symbol=Symbol(name="PyObject_ClearWeakRefs", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_DelItem", visibility=None): Function(
        symbol=Symbol(name="PyObject_DelItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_DelItemString", visibility=None): Function(
        symbol=Symbol(name="PyObject_DelItemString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Dir", visibility=None): Function(
        symbol=Symbol(name="PyObject_Dir", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Format", visibility=None): Function(
        symbol=Symbol(name="PyObject_Format", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Free", visibility=None): Function(
        symbol=Symbol(name="PyObject_Free", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_Del", visibility=None): Function(
        symbol=Symbol(name="PyObject_GC_Del", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_Track", visibility=None): Function(
        symbol=Symbol(name="PyObject_GC_Track", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_UnTrack", visibility=None): Function(
        symbol=Symbol(name="PyObject_GC_UnTrack", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericGetAttr", visibility=None): Function(
        symbol=Symbol(name="PyObject_GenericGetAttr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericSetAttr", visibility=None): Function(
        symbol=Symbol(name="PyObject_GenericSetAttr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetAttr", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetAttr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetAttrString", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetAttrString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetItem", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetIter", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetIter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HasAttr", visibility=None): Function(
        symbol=Symbol(name="PyObject_HasAttr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HasAttrString", visibility=None): Function(
        symbol=Symbol(name="PyObject_HasAttrString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Hash", visibility=None): Function(
        symbol=Symbol(name="PyObject_Hash", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HashNotImplemented", visibility=None): Function(
        symbol=Symbol(name="PyObject_HashNotImplemented", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Init", visibility=None): Function(
        symbol=Symbol(name="PyObject_Init", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_InitVar", visibility=None): Function(
        symbol=Symbol(name="PyObject_InitVar", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_IsInstance", visibility=None): Function(
        symbol=Symbol(name="PyObject_IsInstance", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_IsSubclass", visibility=None): Function(
        symbol=Symbol(name="PyObject_IsSubclass", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_IsTrue", visibility=None): Function(
        symbol=Symbol(name="PyObject_IsTrue", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Length", visibility=None): Function(
        symbol=Symbol(name="PyObject_Length", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Malloc", visibility=None): Function(
        symbol=Symbol(name="PyObject_Malloc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Not", visibility=None): Function(
        symbol=Symbol(name="PyObject_Not", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Realloc", visibility=None): Function(
        symbol=Symbol(name="PyObject_Realloc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Repr", visibility=None): Function(
        symbol=Symbol(name="PyObject_Repr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_RichCompare", visibility=None): Function(
        symbol=Symbol(name="PyObject_RichCompare", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_RichCompareBool", visibility=None): Function(
        symbol=Symbol(name="PyObject_RichCompareBool", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SelfIter", visibility=None): Function(
        symbol=Symbol(name="PyObject_SelfIter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SetAttr", visibility=None): Function(
        symbol=Symbol(name="PyObject_SetAttr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SetAttrString", visibility=None): Function(
        symbol=Symbol(name="PyObject_SetAttrString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SetItem", visibility=None): Function(
        symbol=Symbol(name="PyObject_SetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Size", visibility=None): Function(
        symbol=Symbol(name="PyObject_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Str", visibility=None): Function(
        symbol=Symbol(name="PyObject_Str", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Type", visibility=None): Function(
        symbol=Symbol(name="PyObject_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySeqIter_New", visibility=None): Function(
        symbol=Symbol(name="PySeqIter_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Check", visibility=None): Function(
        symbol=Symbol(name="PySequence_Check", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Concat", visibility=None): Function(
        symbol=Symbol(name="PySequence_Concat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Contains", visibility=None): Function(
        symbol=Symbol(name="PySequence_Contains", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Count", visibility=None): Function(
        symbol=Symbol(name="PySequence_Count", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_DelItem", visibility=None): Function(
        symbol=Symbol(name="PySequence_DelItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_DelSlice", visibility=None): Function(
        symbol=Symbol(name="PySequence_DelSlice", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Fast", visibility=None): Function(
        symbol=Symbol(name="PySequence_Fast", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_GetItem", visibility=None): Function(
        symbol=Symbol(name="PySequence_GetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_GetSlice", visibility=None): Function(
        symbol=Symbol(name="PySequence_GetSlice", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_In", visibility=None): Function(
        symbol=Symbol(name="PySequence_In", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_InPlaceConcat", visibility=None): Function(
        symbol=Symbol(name="PySequence_InPlaceConcat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_InPlaceRepeat", visibility=None): Function(
        symbol=Symbol(name="PySequence_InPlaceRepeat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Index", visibility=None): Function(
        symbol=Symbol(name="PySequence_Index", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Length", visibility=None): Function(
        symbol=Symbol(name="PySequence_Length", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_List", visibility=None): Function(
        symbol=Symbol(name="PySequence_List", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Repeat", visibility=None): Function(
        symbol=Symbol(name="PySequence_Repeat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_SetItem", visibility=None): Function(
        symbol=Symbol(name="PySequence_SetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_SetSlice", visibility=None): Function(
        symbol=Symbol(name="PySequence_SetSlice", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Size", visibility=None): Function(
        symbol=Symbol(name="PySequence_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Tuple", visibility=None): Function(
        symbol=Symbol(name="PySequence_Tuple", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Add", visibility=None): Function(
        symbol=Symbol(name="PySet_Add", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Clear", visibility=None): Function(
        symbol=Symbol(name="PySet_Clear", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Contains", visibility=None): Function(
        symbol=Symbol(name="PySet_Contains", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Discard", visibility=None): Function(
        symbol=Symbol(name="PySet_Discard", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_New", visibility=None): Function(
        symbol=Symbol(name="PySet_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Pop", visibility=None): Function(
        symbol=Symbol(name="PySet_Pop", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Size", visibility=None): Function(
        symbol=Symbol(name="PySet_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_GetIndices", visibility=None): Function(
        symbol=Symbol(name="PySlice_GetIndices", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_GetIndicesEx", visibility=None): Function(
        symbol=Symbol(name="PySlice_GetIndicesEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_New", visibility=None): Function(
        symbol=Symbol(name="PySlice_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyState_FindModule", visibility=None): Function(
        symbol=Symbol(name="PyState_FindModule", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_GetItem", visibility=None): Function(
        symbol=Symbol(name="PyStructSequence_GetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_New", visibility=None): Function(
        symbol=Symbol(name="PyStructSequence_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_NewType", visibility=None): Function(
        symbol=Symbol(name="PyStructSequence_NewType", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_SetItem", visibility=None): Function(
        symbol=Symbol(name="PyStructSequence_SetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_AddWarnOption", visibility=None): Function(
        symbol=Symbol(name="PySys_AddWarnOption", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PySys_AddWarnOptionUnicode", visibility=None): Function(
        symbol=Symbol(name="PySys_AddWarnOptionUnicode", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PySys_FormatStderr", visibility=None): Function(
        symbol=Symbol(name="PySys_FormatStderr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_FormatStdout", visibility=None): Function(
        symbol=Symbol(name="PySys_FormatStdout", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_GetObject", visibility=None): Function(
        symbol=Symbol(name="PySys_GetObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_HasWarnOptions", visibility=None): Function(
        symbol=Symbol(name="PySys_HasWarnOptions", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PySys_ResetWarnOptions", visibility=None): Function(
        symbol=Symbol(name="PySys_ResetWarnOptions", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PySys_SetArgv", visibility=None): Function(
        symbol=Symbol(name="PySys_SetArgv", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_SetArgvEx", visibility=None): Function(
        symbol=Symbol(name="PySys_SetArgvEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_SetObject", visibility=None): Function(
        symbol=Symbol(name="PySys_SetObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_SetPath", visibility=None): Function(
        symbol=Symbol(name="PySys_SetPath", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PySys_WriteStderr", visibility=None): Function(
        symbol=Symbol(name="PySys_WriteStderr", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_WriteStdout", visibility=None): Function(
        symbol=Symbol(name="PySys_WriteStdout", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_Clear", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_Clear", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_Delete", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_Delete", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_DeleteCurrent", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_DeleteCurrent", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyThreadState_Get", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_Get", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetDict", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_GetDict", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_New", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_SetAsyncExc", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_SetAsyncExc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_Swap", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_Swap", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTraceBack_Here", visibility=None): Function(
        symbol=Symbol(name="PyTraceBack_Here", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTraceBack_Print", visibility=None): Function(
        symbol=Symbol(name="PyTraceBack_Print", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_GetItem", visibility=None): Function(
        symbol=Symbol(name="PyTuple_GetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_GetSlice", visibility=None): Function(
        symbol=Symbol(name="PyTuple_GetSlice", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_New", visibility=None): Function(
        symbol=Symbol(name="PyTuple_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_Pack", visibility=None): Function(
        symbol=Symbol(name="PyTuple_Pack", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_SetItem", visibility=None): Function(
        symbol=Symbol(name="PyTuple_SetItem", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_Size", visibility=None): Function(
        symbol=Symbol(name="PyTuple_Size", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_ClearCache", visibility=None): Function(
        symbol=Symbol(name="PyType_ClearCache", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GenericAlloc", visibility=None): Function(
        symbol=Symbol(name="PyType_GenericAlloc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GenericNew", visibility=None): Function(
        symbol=Symbol(name="PyType_GenericNew", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetFlags", visibility=None): Function(
        symbol=Symbol(name="PyType_GetFlags", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_IsSubtype", visibility=None): Function(
        symbol=Symbol(name="PyType_IsSubtype", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_Modified", visibility=None): Function(
        symbol=Symbol(name="PyType_Modified", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_Ready", visibility=None): Function(
        symbol=Symbol(name="PyType_Ready", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_Create", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_Create", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetEncoding", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetEncoding", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetEnd", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetEnd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetObject", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetReason", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetReason", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetStart", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetStart", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_SetEnd", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_SetEnd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_SetReason", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_SetReason", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_SetStart", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_SetStart", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetEncoding", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetEncoding", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetEnd", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetEnd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetObject", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetReason", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetReason", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetStart", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetStart", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_SetEnd", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_SetEnd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_SetReason", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_SetReason", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_SetStart", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_SetStart", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetEnd", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetEnd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetObject", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetReason", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetReason", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetStart", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetStart", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_SetEnd", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_SetEnd", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_SetReason", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_SetReason", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_SetStart", visibility=None): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_SetStart", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Append", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Append", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AppendAndDel", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AppendAndDel", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsASCIIString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsASCIIString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsCharmapString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsCharmapString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsDecodedObject", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsDecodedObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_AsDecodedUnicode", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsDecodedUnicode", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_AsEncodedObject", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsEncodedObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_AsEncodedString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsEncodedString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsEncodedUnicode", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsEncodedUnicode", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_AsLatin1String", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsLatin1String", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsRawUnicodeEscapeString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsRawUnicodeEscapeString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF16String", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsUTF16String", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF32String", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsUTF32String", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF8String", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsUTF8String", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUnicodeEscapeString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsUnicodeEscapeString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsWideChar", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsWideChar", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Compare", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Compare", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Concat", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Concat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Contains", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Contains", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Count", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Count", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Decode", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Decode", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeASCII", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeASCII", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeCharmap", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeCharmap", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeFSDefault", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeFSDefault", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeFSDefaultAndSize", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeFSDefaultAndSize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeLatin1", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeLatin1", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeRawUnicodeEscape", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeRawUnicodeEscape", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF16", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF16", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF16Stateful", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF16Stateful", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF32", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF32", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF32Stateful", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF32Stateful", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF8", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF8", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF8Stateful", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF8Stateful", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUnicodeEscape", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUnicodeEscape", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FSConverter", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FSConverter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FSDecoder", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FSDecoder", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Find", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Find", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Format", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Format", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromEncodedObject", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromEncodedObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromFormat", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromFormat", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromFormatV", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromFormatV", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromObject", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromOrdinal", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromOrdinal", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromStringAndSize", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromStringAndSize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromWideChar", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FromWideChar", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_GetDefaultEncoding", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_GetDefaultEncoding", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_GetSize", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_GetSize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_IsIdentifier", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_IsIdentifier", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Join", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Join", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Partition", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Partition", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_RPartition", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_RPartition", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_RSplit", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_RSplit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Replace", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Replace", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Resize", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Resize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_RichCompare", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_RichCompare", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Split", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Split", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Splitlines", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Splitlines", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Tailmatch", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Tailmatch", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Translate", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Translate", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_BuildEncodingMap", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_BuildEncodingMap", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_CompareWithASCIIString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_CompareWithASCIIString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF7", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF7", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF7Stateful", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF7Stateful", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EncodeFSDefault", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_EncodeFSDefault", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_InternFromString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_InternFromString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_InternImmortal", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_InternImmortal", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_InternInPlace", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_InternInPlace", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWeakref_GetObject", visibility=None): Function(
        symbol=Symbol(name="PyWeakref_GetObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyWeakref_NewProxy", visibility=None): Function(
        symbol=Symbol(name="PyWeakref_NewProxy", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWeakref_NewRef", visibility=None): Function(
        symbol=Symbol(name="PyWeakref_NewRef", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWrapper_New", visibility=None): Function(
        symbol=Symbol(name="PyWrapper_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_AddPendingCall", visibility=None): Function(
        symbol=Symbol(name="Py_AddPendingCall", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_AtExit", visibility=None): Function(
        symbol=Symbol(name="Py_AtExit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_BuildValue", visibility=None): Function(
        symbol=Symbol(name="Py_BuildValue", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_CompileString", visibility=None): Function(
        symbol=Symbol(name="Py_CompileString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_DecRef", visibility=None): Function(
        symbol=Symbol(name="Py_DecRef", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_EndInterpreter", visibility=None): Function(
        symbol=Symbol(name="Py_EndInterpreter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Exit", visibility=None): Function(
        symbol=Symbol(name="Py_Exit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_FatalError", visibility=None): Function(
        symbol=Symbol(name="Py_FatalError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Finalize", visibility=None): Function(
        symbol=Symbol(name="Py_Finalize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetBuildInfo", visibility=None): Function(
        symbol=Symbol(name="Py_GetBuildInfo", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetCompiler", visibility=None): Function(
        symbol=Symbol(name="Py_GetCompiler", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetCopyright", visibility=None): Function(
        symbol=Symbol(name="Py_GetCopyright", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetExecPrefix", visibility=None): Function(
        symbol=Symbol(name="Py_GetExecPrefix", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="Py_GetPath", visibility=None): Function(
        symbol=Symbol(name="Py_GetPath", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="Py_GetPlatform", visibility=None): Function(
        symbol=Symbol(name="Py_GetPlatform", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetPrefix", visibility=None): Function(
        symbol=Symbol(name="Py_GetPrefix", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="Py_GetProgramFullPath", visibility=None): Function(
        symbol=Symbol(name="Py_GetProgramFullPath", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="Py_GetProgramName", visibility=None): Function(
        symbol=Symbol(name="Py_GetProgramName", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="Py_GetPythonHome", visibility=None): Function(
        symbol=Symbol(name="Py_GetPythonHome", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="Py_GetRecursionLimit", visibility=None): Function(
        symbol=Symbol(name="Py_GetRecursionLimit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetVersion", visibility=None): Function(
        symbol=Symbol(name="Py_GetVersion", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IncRef", visibility=None): Function(
        symbol=Symbol(name="Py_IncRef", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Initialize", visibility=None): Function(
        symbol=Symbol(name="Py_Initialize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_InitializeEx", visibility=None): Function(
        symbol=Symbol(name="Py_InitializeEx", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsInitialized", visibility=None): Function(
        symbol=Symbol(name="Py_IsInitialized", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Main", visibility=None): Function(
        symbol=Symbol(name="Py_Main", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_MakePendingCalls", visibility=None): Function(
        symbol=Symbol(name="Py_MakePendingCalls", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_NewInterpreter", visibility=None): Function(
        symbol=Symbol(name="Py_NewInterpreter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_ReprEnter", visibility=None): Function(
        symbol=Symbol(name="Py_ReprEnter", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_ReprLeave", visibility=None): Function(
        symbol=Symbol(name="Py_ReprLeave", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetProgramName", visibility=None): Function(
        symbol=Symbol(name="Py_SetProgramName", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetPythonHome", visibility=None): Function(
        symbol=Symbol(name="Py_SetPythonHome", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetRecursionLimit", visibility=None): Function(
        symbol=Symbol(name="Py_SetRecursionLimit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_VaBuildValue", visibility=None): Function(
        symbol=Symbol(name="Py_VaBuildValue", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_PyErr_BadInternalCall", visibility=None): Function(
        symbol=Symbol(name="_PyErr_BadInternalCall", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_CallFunction_SizeT", visibility=None): Function(
        symbol=Symbol(name="_PyObject_CallFunction_SizeT", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_CallMethod_SizeT", visibility=None): Function(
        symbol=Symbol(name="_PyObject_CallMethod_SizeT", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_GC_New", visibility=None): Function(
        symbol=Symbol(name="_PyObject_GC_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_GC_NewVar", visibility=None): Function(
        symbol=Symbol(name="_PyObject_GC_NewVar", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_GC_Resize", visibility=None): Function(
        symbol=Symbol(name="_PyObject_GC_Resize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_New", visibility=None): Function(
        symbol=Symbol(name="_PyObject_New", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_NewVar", visibility=None): Function(
        symbol=Symbol(name="_PyObject_NewVar", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyState_AddModule", visibility=None): Function(
        symbol=Symbol(name="_PyState_AddModule", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyThreadState_Init", visibility=None): Function(
        symbol=Symbol(name="_PyThreadState_Init", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyThreadState_Prealloc", visibility=None): Function(
        symbol=Symbol(name="_PyThreadState_Prealloc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_BuildValue_SizeT", visibility=None): Function(
        symbol=Symbol(name="_Py_BuildValue_SizeT", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_CheckRecursiveCall", visibility=None): Function(
        symbol=Symbol(name="_Py_CheckRecursiveCall", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_Dealloc", visibility=None): Function(
        symbol=Symbol(name="_Py_Dealloc", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_VaBuildValue_SizeT", visibility=None): Function(
        symbol=Symbol(name="_Py_VaBuildValue_SizeT", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyObject_AsCharBuffer", visibility=None): Function(
        symbol=Symbol(name="PyObject_AsCharBuffer", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyObject_AsReadBuffer", visibility=None): Function(
        symbol=Symbol(name="PyObject_AsReadBuffer", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyObject_AsWriteBuffer", visibility=None): Function(
        symbol=Symbol(name="PyObject_AsWriteBuffer", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyObject_CheckReadBuffer", visibility=None): Function(
        symbol=Symbol(name="PyObject_CheckReadBuffer", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyMarshal_ReadObjectFromString", visibility=None): Function(
        symbol=Symbol(name="PyMarshal_ReadObjectFromString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyMarshal_WriteObjectToString", visibility=None): Function(
        symbol=Symbol(name="PyMarshal_WriteObjectToString", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyMember_GetOne", visibility=None): Function(
        symbol=Symbol(name="PyMember_GetOne", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMember_SetOne", visibility=None): Function(
        symbol=Symbol(name="PyMember_SetOne", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_ReInitTLS", visibility=None): Function(
        symbol=Symbol(name="PyThread_ReInitTLS", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_create_key", visibility=None): Function(
        symbol=Symbol(name="PyThread_create_key", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_delete_key", visibility=None): Function(
        symbol=Symbol(name="PyThread_delete_key", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_set_key_value", visibility=None): Function(
        symbol=Symbol(name="PyThread_set_key_value", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_key_value", visibility=None): Function(
        symbol=Symbol(name="PyThread_get_key_value", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_delete_key_value", visibility=None): Function(
        symbol=Symbol(name="PyThread_delete_key_value", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_acquire_lock", visibility=None): Function(
        symbol=Symbol(name="PyThread_acquire_lock", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_acquire_lock_timed", visibility=None): Function(
        symbol=Symbol(name="PyThread_acquire_lock_timed", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_allocate_lock", visibility=None): Function(
        symbol=Symbol(name="PyThread_allocate_lock", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_exit_thread", visibility=None): Function(
        symbol=Symbol(name="PyThread_exit_thread", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_free_lock", visibility=None): Function(
        symbol=Symbol(name="PyThread_free_lock", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_stacksize", visibility=None): Function(
        symbol=Symbol(name="PyThread_get_stacksize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_thread_ident", visibility=None): Function(
        symbol=Symbol(name="PyThread_get_thread_ident", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_thread_native_id", visibility=None): Function(
        symbol=Symbol(name="PyThread_get_thread_native_id", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=FeatureMacro(
            name="PY_HAVE_THREAD_NATIVE_ID", doc="on platforms with native thread IDs", windows=True
        ),
        abi_only=False,
    ),
    Symbol(name="PyThread_init_thread", visibility=None): Function(
        symbol=Symbol(name="PyThread_init_thread", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_release_lock", visibility=None): Function(
        symbol=Symbol(name="PyThread_release_lock", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_set_stacksize", visibility=None): Function(
        symbol=Symbol(name="PyThread_set_stacksize", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_start_new_thread", visibility=None): Function(
        symbol=Symbol(name="PyThread_start_new_thread", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyState_AddModule", visibility=None): Function(
        symbol=Symbol(name="PyState_AddModule", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyState_RemoveModule", visibility=None): Function(
        symbol=Symbol(name="PyState_RemoveModule", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_FromSpecWithBases", visibility=None): Function(
        symbol=Symbol(name="PyType_FromSpecWithBases", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_PyArg_Parse_SizeT", visibility=None): Function(
        symbol=Symbol(name="_PyArg_Parse_SizeT", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_ParseTuple_SizeT", visibility=None): Function(
        symbol=Symbol(name="_PyArg_ParseTuple_SizeT", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_ParseTupleAndKeywords_SizeT", visibility=None): Function(
        symbol=Symbol(name="_PyArg_ParseTupleAndKeywords_SizeT", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_VaParse_SizeT", visibility=None): Function(
        symbol=Symbol(name="_PyArg_VaParse_SizeT", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_VaParseTupleAndKeywords_SizeT", visibility=None): Function(
        symbol=Symbol(name="_PyArg_VaParseTupleAndKeywords_SizeT", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyThread_GetInfo", visibility=None): Function(
        symbol=Symbol(name="PyThread_GetInfo", visibility=None),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_New", visibility=None): Function(
        symbol=Symbol(name="PyCFunction_New", visibility=None),
        added=PyVersion(major=3, minor=4),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetSlot", visibility=None): Function(
        symbol=Symbol(name="PyType_GetSlot", visibility=None),
        added=PyVersion(major=3, minor=4),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_FormatV", visibility=None): Function(
        symbol=Symbol(name="PyErr_FormatV", visibility=None),
        added=PyVersion(major=3, minor=5),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModuleDef_Init", visibility=None): Function(
        symbol=Symbol(name="PyModuleDef_Init", visibility=None),
        added=PyVersion(major=3, minor=5),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_FinalizeEx", visibility=None): Function(
        symbol=Symbol(name="Py_FinalizeEx", visibility=None),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_FSPath", visibility=None): Function(
        symbol=Symbol(name="PyOS_FSPath", visibility=None),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_ResourceWarning", visibility=None): Function(
        symbol=Symbol(name="PyErr_ResourceWarning", visibility=None),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetImportErrorSubclass", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetImportErrorSubclass", visibility=None),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_NameReplaceErrors", visibility=None): Function(
        symbol=Symbol(name="PyCodec_NameReplaceErrors", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_GetExcInfo", visibility=None): Function(
        symbol=Symbol(name="PyErr_GetExcInfo", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcInfo", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetExcInfo", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrnoWithFilenameObjects", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetFromErrnoWithFilenameObjects", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetImportError", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetImportError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SyntaxLocationEx", visibility=None): Function(
        symbol=Symbol(name="PyErr_SyntaxLocationEx", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_AddModuleObject", visibility=None): Function(
        symbol=Symbol(name="PyImport_AddModuleObject", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModuleObject", visibility=None): Function(
        symbol=Symbol(name="PyImport_ExecCodeModuleObject", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportFrozenModuleObject", visibility=None): Function(
        symbol=Symbol(name="PyImport_ImportFrozenModuleObject", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModuleLevelObject", visibility=None): Function(
        symbol=Symbol(name="PyImport_ImportModuleLevelObject", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Calloc", visibility=None): Function(
        symbol=Symbol(name="PyMem_Calloc", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_FromMemory", visibility=None): Function(
        symbol=Symbol(name="PyMemoryView_FromMemory", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddFunctions", visibility=None): Function(
        symbol=Symbol(name="PyModule_AddFunctions", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_ExecDef", visibility=None): Function(
        symbol=Symbol(name="PyModule_ExecDef", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_FromDefAndSpec2", visibility=None): Function(
        symbol=Symbol(name="PyModule_FromDefAndSpec2", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetNameObject", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetNameObject", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_NewObject", visibility=None): Function(
        symbol=Symbol(name="PyModule_NewObject", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_SetDocString", visibility=None): Function(
        symbol=Symbol(name="PyModule_SetDocString", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceMatrixMultiply", visibility=None): Function(
        symbol=Symbol(name="PyNumber_InPlaceMatrixMultiply", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_MatrixMultiply", visibility=None): Function(
        symbol=Symbol(name="PyNumber_MatrixMultiply", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Calloc", visibility=None): Function(
        symbol=Symbol(name="PyObject_Calloc", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericSetDict", visibility=None): Function(
        symbol=Symbol(name="PyObject_GenericSetDict", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_AddXOption", visibility=None): Function(
        symbol=Symbol(name="PySys_AddXOption", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PySys_GetXOptions", visibility=None): Function(
        symbol=Symbol(name="PySys_GetXOptions", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUCS4", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsUCS4", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUCS4Copy", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsUCS4Copy", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsWideCharString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsWideCharString", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeLocale", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeLocale", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeLocaleAndSize", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeLocaleAndSize", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EncodeLocale", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_EncodeLocale", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FindChar", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_FindChar", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_GetLength", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_GetLength", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_ReadChar", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_ReadChar", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Substring", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Substring", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_WriteChar", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_WriteChar", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_DecodeLocale", visibility=None): Function(
        symbol=Symbol(name="Py_DecodeLocale", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_EncodeLocale", visibility=None): Function(
        symbol=Symbol(name="Py_EncodeLocale", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetPath", visibility=None): Function(
        symbol=Symbol(name="Py_SetPath", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErr", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErr", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErrWithFilename", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErrWithFilename", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObject", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObject", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObjects", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObjects", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromWindowsErr", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetFromWindowsErr", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromWindowsErrWithFilename", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetFromWindowsErrWithFilename", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyOS_CheckStack", visibility=None): Function(
        symbol=Symbol(name="PyOS_CheckStack", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(
            name="USE_STACKCHECK", doc="on platforms with USE_STACKCHECK", windows="maybe"
        ),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsMBCSString", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsMBCSString", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeCodePageStateful", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeCodePageStateful", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeMBCS", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeMBCS", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeMBCSStateful", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_DecodeMBCSStateful", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EncodeCodePage", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_EncodeCodePage", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PySlice_AdjustIndices", visibility=None): Function(
        symbol=Symbol(name="PySlice_AdjustIndices", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_Unpack", visibility=None): Function(
        symbol=Symbol(name="PySlice_Unpack", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_GetID", visibility=None): Function(
        symbol=Symbol(name="PyInterpreterState_GetID", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_alloc", visibility=None): Function(
        symbol=Symbol(name="PyThread_tss_alloc", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_create", visibility=None): Function(
        symbol=Symbol(name="PyThread_tss_create", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_delete", visibility=None): Function(
        symbol=Symbol(name="PyThread_tss_delete", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_free", visibility=None): Function(
        symbol=Symbol(name="PyThread_tss_free", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_get", visibility=None): Function(
        symbol=Symbol(name="PyThread_tss_get", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_is_created", visibility=None): Function(
        symbol=Symbol(name="PyThread_tss_is_created", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_set", visibility=None): Function(
        symbol=Symbol(name="PyThread_tss_set", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_BeforeFork", visibility=None): Function(
        symbol=Symbol(name="PyOS_BeforeFork", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyOS_AfterFork_Parent", visibility=None): Function(
        symbol=Symbol(name="PyOS_AfterFork_Parent", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyOS_AfterFork_Child", visibility=None): Function(
        symbol=Symbol(name="PyOS_AfterFork_Child", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyImport_GetModule", visibility=None): Function(
        symbol=Symbol(name="PyImport_GetModule", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExceptionClass_Name", visibility=None): Function(
        symbol=Symbol(name="PyExceptionClass_Name", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyIndex_Check", visibility=None): Function(
        symbol=Symbol(name="PyIndex_Check", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyIter_Check", visibility=None): Function(
        symbol=Symbol(name="PyIter_Check", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_GetDict", visibility=None): Function(
        symbol=Symbol(name="PyInterpreterState_GetDict", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_BytesMain", visibility=None): Function(
        symbol=Symbol(name="Py_BytesMain", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_EnterRecursiveCall", visibility=None): Function(
        symbol=Symbol(name="Py_EnterRecursiveCall", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_LeaveRecursiveCall", visibility=None): Function(
        symbol=Symbol(name="Py_LeaveRecursiveCall", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GenericAlias", visibility=None): Function(
        symbol=Symbol(name="Py_GenericAlias", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCMethod_New", visibility=None): Function(
        symbol=Symbol(name="PyCMethod_New", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_Get", visibility=None): Function(
        symbol=Symbol(name="PyInterpreterState_Get", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_IsFinalized", visibility=None): Function(
        symbol=Symbol(name="PyObject_GC_IsFinalized", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_IsTracked", visibility=None): Function(
        symbol=Symbol(name="PyObject_GC_IsTracked", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetArgcArgv", visibility=None): Function(
        symbol=Symbol(name="Py_GetArgcArgv", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyIter_Send", visibility=None): Function(
        symbol=Symbol(name="PyIter_Send", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF8AndSize", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_AsUTF8AndSize", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericGetDict", visibility=None): Function(
        symbol=Symbol(name="PyObject_GenericGetDict", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_NewRef", visibility=None): Function(
        symbol=Symbol(name="Py_NewRef", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_XNewRef", visibility=None): Function(
        symbol=Symbol(name="Py_XNewRef", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddType", visibility=None): Function(
        symbol=Symbol(name="PyModule_AddType", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_FromModuleAndSpec", visibility=None): Function(
        symbol=Symbol(name="PyType_FromModuleAndSpec", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetModule", visibility=None): Function(
        symbol=Symbol(name="PyType_GetModule", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetModuleState", visibility=None): Function(
        symbol=Symbol(name="PyType_GetModuleState", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrame_GetLineNumber", visibility=None): Function(
        symbol=Symbol(name="PyFrame_GetLineNumber", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrame_GetCode", visibility=None): Function(
        symbol=Symbol(name="PyFrame_GetCode", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallNoArgs", visibility=None): Function(
        symbol=Symbol(name="PyObject_CallNoArgs", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetFrame", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_GetFrame", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetID", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_GetID", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetInterpreter", visibility=None): Function(
        symbol=Symbol(name="PyThreadState_GetInterpreter", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddObjectRef", visibility=None): Function(
        symbol=Symbol(name="PyModule_AddObjectRef", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Unregister", visibility=None): Function(
        symbol=Symbol(name="PyCodec_Unregister", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetInterruptEx", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetInterruptEx", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Is", visibility=None): Function(
        symbol=Symbol(name="Py_Is", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsTrue", visibility=None): Function(
        symbol=Symbol(name="Py_IsTrue", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsFalse", visibility=None): Function(
        symbol=Symbol(name="Py_IsFalse", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsNone", visibility=None): Function(
        symbol=Symbol(name="Py_IsNone", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_Py_IncRef", visibility=None): Function(
        symbol=Symbol(name="_Py_IncRef", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_DecRef", visibility=None): Function(
        symbol=Symbol(name="_Py_DecRef", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyAIter_Check", visibility=None): Function(
        symbol=Symbol(name="PyAIter_Check", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetAIter", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetAIter", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_Py_NegativeRefcount", visibility=None): Function(
        symbol=Symbol(name="_Py_NegativeRefcount", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=FeatureMacro(
            name="Py_REF_DEBUG",
            doc="when Python is compiled in debug mode (with Py_REF_DEBUG)",
            windows="maybe",
        ),
        abi_only=True,
    ),
    Symbol(name="PyGC_Disable", visibility=None): Function(
        symbol=Symbol(name="PyGC_Disable", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGC_Enable", visibility=None): Function(
        symbol=Symbol(name="PyGC_Enable", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGC_IsEnabled", visibility=None): Function(
        symbol=Symbol(name="PyGC_IsEnabled", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetName", visibility=None): Function(
        symbol=Symbol(name="PyType_GetName", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetQualName", visibility=None): Function(
        symbol=Symbol(name="PyType_GetQualName", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CheckBuffer", visibility=None): Function(
        symbol=Symbol(name="PyObject_CheckBuffer", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetBuffer", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetBuffer", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_GetPointer", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_GetPointer", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_SizeFromFormat", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_SizeFromFormat", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_ToContiguous", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_ToContiguous", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_FromContiguous", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_FromContiguous", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CopyData", visibility=None): Function(
        symbol=Symbol(name="PyObject_CopyData", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_IsContiguous", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_IsContiguous", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_FillContiguousStrides", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_FillContiguousStrides", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_FillInfo", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_FillInfo", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_Release", visibility=None): Function(
        symbol=Symbol(name="PyBuffer_Release", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_FromBuffer", visibility=None): Function(
        symbol=Symbol(name="PyMemoryView_FromBuffer", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_GetHandledException", visibility=None): Function(
        symbol=Symbol(name="PyErr_GetHandledException", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetHandledException", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetHandledException", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_FromMetaclass", visibility=None): Function(
        symbol=Symbol(name="PyType_FromMetaclass", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyVectorcall_NARGS", visibility=None): Function(
        symbol=Symbol(name="PyVectorcall_NARGS", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyVectorcall_Call", visibility=None): Function(
        symbol=Symbol(name="PyVectorcall_Call", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_GetRaisedException", visibility=None): Function(
        symbol=Symbol(name="PyErr_GetRaisedException", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetRaisedException", visibility=None): Function(
        symbol=Symbol(name="PyErr_SetRaisedException", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_GetArgs", visibility=None): Function(
        symbol=Symbol(name="PyException_GetArgs", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_SetArgs", visibility=None): Function(
        symbol=Symbol(name="PyException_SetArgs", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Vectorcall", visibility=None): Function(
        symbol=Symbol(name="PyObject_Vectorcall", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_VectorcallMethod", visibility=None): Function(
        symbol=Symbol(name="PyObject_VectorcallMethod", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetTypeData", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetTypeData", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetTypeDataSize", visibility=None): Function(
        symbol=Symbol(name="PyType_GetTypeDataSize", visibility=None),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_AddModuleRef", visibility=None): Function(
        symbol=Symbol(name="PyImport_AddModuleRef", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWeakref_GetRef", visibility=None): Function(
        symbol=Symbol(name="PyWeakref_GetRef", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_DelAttr", visibility=None): Function(
        symbol=Symbol(name="PyObject_DelAttr", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_DelAttrString", visibility=None): Function(
        symbol=Symbol(name="PyObject_DelAttrString", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetOptionalAttr", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetOptionalAttr", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetOptionalAttrString", visibility=None): Function(
        symbol=Symbol(name="PyObject_GetOptionalAttrString", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_GetOptionalItem", visibility=None): Function(
        symbol=Symbol(name="PyMapping_GetOptionalItem", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_GetOptionalItemString", visibility=None): Function(
        symbol=Symbol(name="PyMapping_GetOptionalItemString", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_Add", visibility=None): Function(
        symbol=Symbol(name="PyModule_Add", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItemRef", visibility=None): Function(
        symbol=Symbol(name="PyDict_GetItemRef", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItemStringRef", visibility=None): Function(
        symbol=Symbol(name="PyDict_GetItemStringRef", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsInt", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsInt", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HasAttrWithError", visibility=None): Function(
        symbol=Symbol(name="PyObject_HasAttrWithError", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HasAttrStringWithError", visibility=None): Function(
        symbol=Symbol(name="PyObject_HasAttrStringWithError", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_HasKeyWithError", visibility=None): Function(
        symbol=Symbol(name="PyMapping_HasKeyWithError", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_HasKeyStringWithError", visibility=None): Function(
        symbol=Symbol(name="PyMapping_HasKeyStringWithError", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsFinalizing", visibility=None): Function(
        symbol=Symbol(name="Py_IsFinalizing", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EqualToUTF8", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_EqualToUTF8", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EqualToUTF8AndSize", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_EqualToUTF8AndSize", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_RawMalloc", visibility=None): Function(
        symbol=Symbol(name="PyMem_RawMalloc", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_RawCalloc", visibility=None): Function(
        symbol=Symbol(name="PyMem_RawCalloc", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_RawRealloc", visibility=None): Function(
        symbol=Symbol(name="PyMem_RawRealloc", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_RawFree", visibility=None): Function(
        symbol=Symbol(name="PyMem_RawFree", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_Audit", visibility=None): Function(
        symbol=Symbol(name="PySys_Audit", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_AuditTuple", visibility=None): Function(
        symbol=Symbol(name="PySys_AuditTuple", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_Py_SetRefcnt", visibility=None): Function(
        symbol=Symbol(name="_Py_SetRefcnt", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyList_GetItemRef", visibility=None): Function(
        symbol=Symbol(name="PyList_GetItemRef", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetFullyQualifiedName", visibility=None): Function(
        symbol=Symbol(name="PyType_GetFullyQualifiedName", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetModuleName", visibility=None): Function(
        symbol=Symbol(name="PyType_GetModuleName", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetConstant", visibility=None): Function(
        symbol=Symbol(name="Py_GetConstant", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetConstantBorrowed", visibility=None): Function(
        symbol=Symbol(name="Py_GetConstantBorrowed", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetModuleByDef", visibility=None): Function(
        symbol=Symbol(name="PyType_GetModuleByDef", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFrameBuiltins", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetFrameBuiltins", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFrameGlobals", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetFrameGlobals", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFrameLocals", visibility=None): Function(
        symbol=Symbol(name="PyEval_GetFrameLocals", visibility=None),
        added=PyVersion(major=3, minor=13),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_TYPE", visibility=None): Function(
        symbol=Symbol(name="Py_TYPE", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_REFCNT", visibility=None): Function(
        symbol=Symbol(name="Py_REFCNT", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyIter_NextItem", visibility=None): Function(
        symbol=Symbol(name="PyIter_NextItem", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromInt32", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromInt32", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromUInt32", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromUInt32", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsInt32", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsInt32", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUInt32", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsUInt32", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromInt64", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromInt64", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromUInt64", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromUInt64", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsInt64", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsInt64", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUInt64", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsUInt64", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsNativeBytes", visibility=None): Function(
        symbol=Symbol(name="PyLong_AsNativeBytes", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromNativeBytes", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromNativeBytes", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromUnsignedNativeBytes", visibility=None): Function(
        symbol=Symbol(name="PyLong_FromUnsignedNativeBytes", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetBaseByToken", visibility=None): Function(
        symbol=Symbol(name="PyType_GetBaseByToken", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Equal", visibility=None): Function(
        symbol=Symbol(name="PyUnicode_Equal", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_Freeze", visibility=None): Function(
        symbol=Symbol(name="PyType_Freeze", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_PACK_FULL_VERSION", visibility=None): Function(
        symbol=Symbol(name="Py_PACK_FULL_VERSION", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_PACK_VERSION", visibility=None): Function(
        symbol=Symbol(name="Py_PACK_VERSION", visibility=None),
        added=PyVersion(major=3, minor=14),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_GetAttr", visibility=None): Function(
        symbol=Symbol(name="PySys_GetAttr", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_GetAttrString", visibility=None): Function(
        symbol=Symbol(name="PySys_GetAttrString", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_GetOptionalAttr", visibility=None): Function(
        symbol=Symbol(name="PySys_GetOptionalAttr", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_GetOptionalAttrString", visibility=None): Function(
        symbol=Symbol(name="PySys_GetOptionalAttrString", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyABIInfo_Check", visibility=None): Function(
        symbol=Symbol(name="PyABIInfo_Check", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_FromSlotsAndSpec", visibility=None): Function(
        symbol=Symbol(name="PyModule_FromSlotsAndSpec", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_Exec", visibility=None): Function(
        symbol=Symbol(name="PyModule_Exec", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetToken", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetToken", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetModuleByToken", visibility=None): Function(
        symbol=Symbol(name="PyType_GetModuleByToken", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetStateSize", visibility=None): Function(
        symbol=Symbol(name="PyModule_GetStateSize", visibility=None),
        added=PyVersion(major=3, minor=15),
        ifdef=None,
        abi_only=False,
    ),
}
_MACROS: Final[dict[str, Macro]] = {
    "Py_tp_dealloc": Macro(name="Py_tp_dealloc", added=PyVersion(major=3, minor=2)),
    "Py_tp_getattr": Macro(name="Py_tp_getattr", added=PyVersion(major=3, minor=2)),
    "Py_tp_setattr": Macro(name="Py_tp_setattr", added=PyVersion(major=3, minor=2)),
    "Py_tp_repr": Macro(name="Py_tp_repr", added=PyVersion(major=3, minor=2)),
    "Py_tp_hash": Macro(name="Py_tp_hash", added=PyVersion(major=3, minor=2)),
    "Py_tp_call": Macro(name="Py_tp_call", added=PyVersion(major=3, minor=2)),
    "Py_tp_str": Macro(name="Py_tp_str", added=PyVersion(major=3, minor=2)),
    "Py_tp_getattro": Macro(name="Py_tp_getattro", added=PyVersion(major=3, minor=2)),
    "Py_tp_setattro": Macro(name="Py_tp_setattro", added=PyVersion(major=3, minor=2)),
    "Py_tp_doc": Macro(name="Py_tp_doc", added=PyVersion(major=3, minor=2)),
    "Py_tp_traverse": Macro(name="Py_tp_traverse", added=PyVersion(major=3, minor=2)),
    "Py_tp_clear": Macro(name="Py_tp_clear", added=PyVersion(major=3, minor=2)),
    "Py_tp_richcompare": Macro(name="Py_tp_richcompare", added=PyVersion(major=3, minor=2)),
    "Py_tp_iter": Macro(name="Py_tp_iter", added=PyVersion(major=3, minor=2)),
    "Py_tp_iternext": Macro(name="Py_tp_iternext", added=PyVersion(major=3, minor=2)),
    "Py_tp_methods": Macro(name="Py_tp_methods", added=PyVersion(major=3, minor=2)),
    "Py_tp_base": Macro(name="Py_tp_base", added=PyVersion(major=3, minor=2)),
    "Py_tp_descr_get": Macro(name="Py_tp_descr_get", added=PyVersion(major=3, minor=2)),
    "Py_tp_descr_set": Macro(name="Py_tp_descr_set", added=PyVersion(major=3, minor=2)),
    "Py_tp_init": Macro(name="Py_tp_init", added=PyVersion(major=3, minor=2)),
    "Py_tp_alloc": Macro(name="Py_tp_alloc", added=PyVersion(major=3, minor=2)),
    "Py_tp_new": Macro(name="Py_tp_new", added=PyVersion(major=3, minor=2)),
    "Py_tp_members": Macro(name="Py_tp_members", added=PyVersion(major=3, minor=2)),
    "Py_tp_getset": Macro(name="Py_tp_getset", added=PyVersion(major=3, minor=2)),
    "Py_tp_free": Macro(name="Py_tp_free", added=PyVersion(major=3, minor=2)),
    "Py_tp_is_gc": Macro(name="Py_tp_is_gc", added=PyVersion(major=3, minor=2)),
    "Py_tp_bases": Macro(name="Py_tp_bases", added=PyVersion(major=3, minor=2)),
    "Py_tp_del": Macro(name="Py_tp_del", added=PyVersion(major=3, minor=2)),
    "Py_nb_add": Macro(name="Py_nb_add", added=PyVersion(major=3, minor=2)),
    "Py_nb_subtract": Macro(name="Py_nb_subtract", added=PyVersion(major=3, minor=2)),
    "Py_nb_multiply": Macro(name="Py_nb_multiply", added=PyVersion(major=3, minor=2)),
    "Py_nb_remainder": Macro(name="Py_nb_remainder", added=PyVersion(major=3, minor=2)),
    "Py_nb_divmod": Macro(name="Py_nb_divmod", added=PyVersion(major=3, minor=2)),
    "Py_nb_power": Macro(name="Py_nb_power", added=PyVersion(major=3, minor=2)),
    "Py_nb_negative": Macro(name="Py_nb_negative", added=PyVersion(major=3, minor=2)),
    "Py_nb_positive": Macro(name="Py_nb_positive", added=PyVersion(major=3, minor=2)),
    "Py_nb_absolute": Macro(name="Py_nb_absolute", added=PyVersion(major=3, minor=2)),
    "Py_nb_bool": Macro(name="Py_nb_bool", added=PyVersion(major=3, minor=2)),
    "Py_nb_invert": Macro(name="Py_nb_invert", added=PyVersion(major=3, minor=2)),
    "Py_nb_lshift": Macro(name="Py_nb_lshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_rshift": Macro(name="Py_nb_rshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_and": Macro(name="Py_nb_and", added=PyVersion(major=3, minor=2)),
    "Py_nb_xor": Macro(name="Py_nb_xor", added=PyVersion(major=3, minor=2)),
    "Py_nb_or": Macro(name="Py_nb_or", added=PyVersion(major=3, minor=2)),
    "Py_nb_int": Macro(name="Py_nb_int", added=PyVersion(major=3, minor=2)),
    "Py_nb_float": Macro(name="Py_nb_float", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_add": Macro(name="Py_nb_inplace_add", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_subtract": Macro(
        name="Py_nb_inplace_subtract", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_multiply": Macro(
        name="Py_nb_inplace_multiply", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_remainder": Macro(
        name="Py_nb_inplace_remainder", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_power": Macro(name="Py_nb_inplace_power", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_lshift": Macro(name="Py_nb_inplace_lshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_rshift": Macro(name="Py_nb_inplace_rshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_and": Macro(name="Py_nb_inplace_and", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_xor": Macro(name="Py_nb_inplace_xor", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_or": Macro(name="Py_nb_inplace_or", added=PyVersion(major=3, minor=2)),
    "Py_nb_floor_divide": Macro(name="Py_nb_floor_divide", added=PyVersion(major=3, minor=2)),
    "Py_nb_true_divide": Macro(name="Py_nb_true_divide", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_floor_divide": Macro(
        name="Py_nb_inplace_floor_divide", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_true_divide": Macro(
        name="Py_nb_inplace_true_divide", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_index": Macro(name="Py_nb_index", added=PyVersion(major=3, minor=2)),
    "Py_sq_length": Macro(name="Py_sq_length", added=PyVersion(major=3, minor=2)),
    "Py_sq_concat": Macro(name="Py_sq_concat", added=PyVersion(major=3, minor=2)),
    "Py_sq_repeat": Macro(name="Py_sq_repeat", added=PyVersion(major=3, minor=2)),
    "Py_sq_item": Macro(name="Py_sq_item", added=PyVersion(major=3, minor=2)),
    "Py_sq_ass_item": Macro(name="Py_sq_ass_item", added=PyVersion(major=3, minor=2)),
    "Py_sq_contains": Macro(name="Py_sq_contains", added=PyVersion(major=3, minor=2)),
    "Py_sq_inplace_concat": Macro(name="Py_sq_inplace_concat", added=PyVersion(major=3, minor=2)),
    "Py_sq_inplace_repeat": Macro(name="Py_sq_inplace_repeat", added=PyVersion(major=3, minor=2)),
    "Py_mp_length": Macro(name="Py_mp_length", added=PyVersion(major=3, minor=2)),
    "Py_mp_subscript": Macro(name="Py_mp_subscript", added=PyVersion(major=3, minor=2)),
    "Py_mp_ass_subscript": Macro(name="Py_mp_ass_subscript", added=PyVersion(major=3, minor=2)),
    "Py_TPFLAGS_DEFAULT": Macro(name="Py_TPFLAGS_DEFAULT", added=PyVersion(major=3, minor=2)),
    "Py_TPFLAGS_BASETYPE": Macro(name="Py_TPFLAGS_BASETYPE", added=PyVersion(major=3, minor=2)),
    "Py_TPFLAGS_HAVE_GC": Macro(name="Py_TPFLAGS_HAVE_GC", added=PyVersion(major=3, minor=2)),
    "METH_VARARGS": Macro(name="METH_VARARGS", added=PyVersion(major=3, minor=2)),
    "METH_NOARGS": Macro(name="METH_NOARGS", added=PyVersion(major=3, minor=2)),
    "METH_O": Macro(name="METH_O", added=PyVersion(major=3, minor=2)),
    "METH_CLASS": Macro(name="METH_CLASS", added=PyVersion(major=3, minor=2)),
    "METH_STATIC": Macro(name="METH_STATIC", added=PyVersion(major=3, minor=2)),
    "METH_COEXIST": Macro(name="METH_COEXIST", added=PyVersion(major=3, minor=2)),
    "Py_nb_matrix_multiply": Macro(name="Py_nb_matrix_multiply", added=PyVersion(major=3, minor=5)),
    "Py_nb_inplace_matrix_multiply": Macro(
        name="Py_nb_inplace_matrix_multiply", added=PyVersion(major=3, minor=5)
    ),
    "Py_am_await": Macro(name="Py_am_await", added=PyVersion(major=3, minor=5)),
    "Py_am_aiter": Macro(name="Py_am_aiter", added=PyVersion(major=3, minor=5)),
    "Py_am_anext": Macro(name="Py_am_anext", added=PyVersion(major=3, minor=5)),
    "Py_tp_finalize": Macro(name="Py_tp_finalize", added=PyVersion(major=3, minor=5)),
    "METH_FASTCALL": Macro(name="METH_FASTCALL", added=PyVersion(major=3, minor=7)),
    "METH_METHOD": Macro(name="METH_METHOD", added=PyVersion(major=3, minor=7)),
    "Py_TPFLAGS_METHOD_DESCRIPTOR": Macro(
        name="Py_TPFLAGS_METHOD_DESCRIPTOR", added=PyVersion(major=3, minor=8)
    ),
    "Py_am_send": Macro(name="Py_am_send", added=PyVersion(major=3, minor=10)),
    "Py_bf_getbuffer": Macro(name="Py_bf_getbuffer", added=PyVersion(major=3, minor=11)),
    "Py_bf_releasebuffer": Macro(name="Py_bf_releasebuffer", added=PyVersion(major=3, minor=11)),
    "PyBUF_MAX_NDIM": Macro(name="PyBUF_MAX_NDIM", added=PyVersion(major=3, minor=11)),
    "PyBUF_SIMPLE": Macro(name="PyBUF_SIMPLE", added=PyVersion(major=3, minor=11)),
    "PyBUF_WRITABLE": Macro(name="PyBUF_WRITABLE", added=PyVersion(major=3, minor=11)),
    "PyBUF_FORMAT": Macro(name="PyBUF_FORMAT", added=PyVersion(major=3, minor=11)),
    "PyBUF_ND": Macro(name="PyBUF_ND", added=PyVersion(major=3, minor=11)),
    "PyBUF_STRIDES": Macro(name="PyBUF_STRIDES", added=PyVersion(major=3, minor=11)),
    "PyBUF_C_CONTIGUOUS": Macro(name="PyBUF_C_CONTIGUOUS", added=PyVersion(major=3, minor=11)),
    "PyBUF_F_CONTIGUOUS": Macro(name="PyBUF_F_CONTIGUOUS", added=PyVersion(major=3, minor=11)),
    "PyBUF_ANY_CONTIGUOUS": Macro(name="PyBUF_ANY_CONTIGUOUS", added=PyVersion(major=3, minor=11)),
    "PyBUF_INDIRECT": Macro(name="PyBUF_INDIRECT", added=PyVersion(major=3, minor=11)),
    "PyBUF_CONTIG": Macro(name="PyBUF_CONTIG", added=PyVersion(major=3, minor=11)),
    "PyBUF_CONTIG_RO": Macro(name="PyBUF_CONTIG_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_STRIDED": Macro(name="PyBUF_STRIDED", added=PyVersion(major=3, minor=11)),
    "PyBUF_STRIDED_RO": Macro(name="PyBUF_STRIDED_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_RECORDS": Macro(name="PyBUF_RECORDS", added=PyVersion(major=3, minor=11)),
    "PyBUF_RECORDS_RO": Macro(name="PyBUF_RECORDS_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_FULL": Macro(name="PyBUF_FULL", added=PyVersion(major=3, minor=11)),
    "PyBUF_FULL_RO": Macro(name="PyBUF_FULL_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_READ": Macro(name="PyBUF_READ", added=PyVersion(major=3, minor=11)),
    "PyBUF_WRITE": Macro(name="PyBUF_WRITE", added=PyVersion(major=3, minor=11)),
    "Py_TPFLAGS_HAVE_VECTORCALL": Macro(
        name="Py_TPFLAGS_HAVE_VECTORCALL", added=PyVersion(major=3, minor=12)
    ),
    "Py_T_BYTE": Macro(name="Py_T_BYTE", added=PyVersion(major=3, minor=12)),
    "Py_T_SHORT": Macro(name="Py_T_SHORT", added=PyVersion(major=3, minor=12)),
    "Py_T_INT": Macro(name="Py_T_INT", added=PyVersion(major=3, minor=12)),
    "Py_T_LONG": Macro(name="Py_T_LONG", added=PyVersion(major=3, minor=12)),
    "Py_T_LONGLONG": Macro(name="Py_T_LONGLONG", added=PyVersion(major=3, minor=12)),
    "Py_T_UBYTE": Macro(name="Py_T_UBYTE", added=PyVersion(major=3, minor=12)),
    "Py_T_UINT": Macro(name="Py_T_UINT", added=PyVersion(major=3, minor=12)),
    "Py_T_USHORT": Macro(name="Py_T_USHORT", added=PyVersion(major=3, minor=12)),
    "Py_T_ULONG": Macro(name="Py_T_ULONG", added=PyVersion(major=3, minor=12)),
    "Py_T_ULONGLONG": Macro(name="Py_T_ULONGLONG", added=PyVersion(major=3, minor=12)),
    "Py_T_PYSSIZET": Macro(name="Py_T_PYSSIZET", added=PyVersion(major=3, minor=12)),
    "Py_T_FLOAT": Macro(name="Py_T_FLOAT", added=PyVersion(major=3, minor=12)),
    "Py_T_DOUBLE": Macro(name="Py_T_DOUBLE", added=PyVersion(major=3, minor=12)),
    "Py_T_BOOL": Macro(name="Py_T_BOOL", added=PyVersion(major=3, minor=12)),
    "Py_T_STRING": Macro(name="Py_T_STRING", added=PyVersion(major=3, minor=12)),
    "Py_T_STRING_INPLACE": Macro(name="Py_T_STRING_INPLACE", added=PyVersion(major=3, minor=12)),
    "Py_T_CHAR": Macro(name="Py_T_CHAR", added=PyVersion(major=3, minor=12)),
    "Py_T_OBJECT_EX": Macro(name="Py_T_OBJECT_EX", added=PyVersion(major=3, minor=12)),
    "Py_READONLY": Macro(name="Py_READONLY", added=PyVersion(major=3, minor=12)),
    "Py_AUDIT_READ": Macro(name="Py_AUDIT_READ", added=PyVersion(major=3, minor=12)),
    "Py_RELATIVE_OFFSET": Macro(name="Py_RELATIVE_OFFSET", added=PyVersion(major=3, minor=12)),
    "Py_TPFLAGS_ITEMS_AT_END": Macro(
        name="Py_TPFLAGS_ITEMS_AT_END", added=PyVersion(major=3, minor=12)
    ),
    "Py_ASNATIVEBYTES_DEFAULTS": Macro(
        name="Py_ASNATIVEBYTES_DEFAULTS", added=PyVersion(major=3, minor=14)
    ),
    "Py_ASNATIVEBYTES_BIG_ENDIAN": Macro(
        name="Py_ASNATIVEBYTES_BIG_ENDIAN", added=PyVersion(major=3, minor=14)
    ),
    "Py_ASNATIVEBYTES_LITTLE_ENDIAN": Macro(
        name="Py_ASNATIVEBYTES_LITTLE_ENDIAN", added=PyVersion(major=3, minor=14)
    ),
    "Py_ASNATIVEBYTES_NATIVE_ENDIAN": Macro(
        name="Py_ASNATIVEBYTES_NATIVE_ENDIAN", added=PyVersion(major=3, minor=14)
    ),
    "Py_ASNATIVEBYTES_UNSIGNED_BUFFER": Macro(
        name="Py_ASNATIVEBYTES_UNSIGNED_BUFFER", added=PyVersion(major=3, minor=14)
    ),
    "Py_ASNATIVEBYTES_REJECT_NEGATIVE": Macro(
        name="Py_ASNATIVEBYTES_REJECT_NEGATIVE", added=PyVersion(major=3, minor=14)
    ),
    "Py_ASNATIVEBYTES_ALLOW_INDEX": Macro(
        name="Py_ASNATIVEBYTES_ALLOW_INDEX", added=PyVersion(major=3, minor=14)
    ),
    "Py_tp_vectorcall": Macro(name="Py_tp_vectorcall", added=PyVersion(major=3, minor=14)),
    "Py_tp_token": Macro(name="Py_tp_token", added=PyVersion(major=3, minor=14)),
    "Py_TP_USE_SPEC": Macro(name="Py_TP_USE_SPEC", added=PyVersion(major=3, minor=14)),
    "Py_mod_abi": Macro(name="Py_mod_abi", added=PyVersion(major=3, minor=15)),
    "PyABIInfo_DEFAULT_ABI_VERSION": Macro(
        name="PyABIInfo_DEFAULT_ABI_VERSION", added=PyVersion(major=3, minor=15)
    ),
    "PyABIInfo_DEFAULT_FLAGS": Macro(
        name="PyABIInfo_DEFAULT_FLAGS", added=PyVersion(major=3, minor=15)
    ),
    "PyABIInfo_STABLE": Macro(name="PyABIInfo_STABLE", added=PyVersion(major=3, minor=15)),
    "PyABIInfo_FREETHREADED": Macro(
        name="PyABIInfo_FREETHREADED", added=PyVersion(major=3, minor=15)
    ),
    "PyABIInfo_GIL": Macro(name="PyABIInfo_GIL", added=PyVersion(major=3, minor=15)),
    "PyABIInfo_FREETHREADING_AGNOSTIC": Macro(
        name="PyABIInfo_FREETHREADING_AGNOSTIC", added=PyVersion(major=3, minor=15)
    ),
    "Py_mod_name": Macro(name="Py_mod_name", added=PyVersion(major=3, minor=15)),
    "Py_mod_doc": Macro(name="Py_mod_doc", added=PyVersion(major=3, minor=15)),
    "Py_mod_state_size": Macro(name="Py_mod_state_size", added=PyVersion(major=3, minor=15)),
    "Py_mod_methods": Macro(name="Py_mod_methods", added=PyVersion(major=3, minor=15)),
    "Py_mod_state_traverse": Macro(
        name="Py_mod_state_traverse", added=PyVersion(major=3, minor=15)
    ),
    "Py_mod_state_clear": Macro(name="Py_mod_state_clear", added=PyVersion(major=3, minor=15)),
    "Py_mod_state_free": Macro(name="Py_mod_state_free", added=PyVersion(major=3, minor=15)),
    "Py_mod_token": Macro(name="Py_mod_token", added=PyVersion(major=3, minor=15)),
    "Py_BEGIN_ALLOW_THREADS": Macro(
        name="Py_BEGIN_ALLOW_THREADS", added=PyVersion(major=3, minor=2)
    ),
    "Py_BLOCK_THREADS": Macro(name="Py_BLOCK_THREADS", added=PyVersion(major=3, minor=2)),
    "Py_UNBLOCK_THREADS": Macro(name="Py_UNBLOCK_THREADS", added=PyVersion(major=3, minor=2)),
    "Py_END_ALLOW_THREADS": Macro(name="Py_END_ALLOW_THREADS", added=PyVersion(major=3, minor=2)),
    "PY_VECTORCALL_ARGUMENTS_OFFSET": Macro(
        name="PY_VECTORCALL_ARGUMENTS_OFFSET", added=PyVersion(major=3, minor=12)
    ),
    "PyABIInfo_VAR": Macro(name="PyABIInfo_VAR", added=PyVersion(major=3, minor=15)),
    "PyMODEXPORT_FUNC": Macro(name="PyMODEXPORT_FUNC", added=PyVersion(major=3, minor=15)),
}
_DATAS: Final[dict[Symbol, Data]] = {
    Symbol(name="PyBaseObject_Type", visibility=None): Data(
        symbol=Symbol(name="PyBaseObject_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBool_Type", visibility=None): Data(
        symbol=Symbol(name="PyBool_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArrayIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyByteArrayIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Type", visibility=None): Data(
        symbol=Symbol(name="PyByteArray_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytesIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyBytesIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Type", visibility=None): Data(
        symbol=Symbol(name="PyBytes_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_Type", visibility=None): Data(
        symbol=Symbol(name="PyCFunction_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCallIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyCallIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_Type", visibility=None): Data(
        symbol=Symbol(name="PyCapsule_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyClassMethodDescr_Type", visibility=None): Data(
        symbol=Symbol(name="PyClassMethodDescr_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_Type", visibility=None): Data(
        symbol=Symbol(name="PyComplex_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictItems_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictItems_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictIterItem_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictIterItem_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictIterKey_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictIterKey_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictIterValue_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictIterValue_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictKeys_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictKeys_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictProxy_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictProxy_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictValues_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictValues_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Type", visibility=None): Data(
        symbol=Symbol(name="PyDict_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEllipsis_Type", visibility=None): Data(
        symbol=Symbol(name="PyEllipsis_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEnum_Type", visibility=None): Data(
        symbol=Symbol(name="PyEnum_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ArithmeticError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ArithmeticError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_AssertionError", visibility=None): Data(
        symbol=Symbol(name="PyExc_AssertionError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_AttributeError", visibility=None): Data(
        symbol=Symbol(name="PyExc_AttributeError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BaseException", visibility=None): Data(
        symbol=Symbol(name="PyExc_BaseException", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BaseExceptionGroup", visibility=None): Data(
        symbol=Symbol(name="PyExc_BaseExceptionGroup", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BufferError", visibility=None): Data(
        symbol=Symbol(name="PyExc_BufferError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BytesWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_BytesWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_DeprecationWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_DeprecationWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_EOFError", visibility=None): Data(
        symbol=Symbol(name="PyExc_EOFError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_EnvironmentError", visibility=None): Data(
        symbol=Symbol(name="PyExc_EnvironmentError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_Exception", visibility=None): Data(
        symbol=Symbol(name="PyExc_Exception", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FloatingPointError", visibility=None): Data(
        symbol=Symbol(name="PyExc_FloatingPointError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FutureWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_FutureWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_GeneratorExit", visibility=None): Data(
        symbol=Symbol(name="PyExc_GeneratorExit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IOError", visibility=None): Data(
        symbol=Symbol(name="PyExc_IOError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ImportError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ImportError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ImportWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_ImportWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IndentationError", visibility=None): Data(
        symbol=Symbol(name="PyExc_IndentationError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IndexError", visibility=None): Data(
        symbol=Symbol(name="PyExc_IndexError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_KeyError", visibility=None): Data(
        symbol=Symbol(name="PyExc_KeyError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_KeyboardInterrupt", visibility=None): Data(
        symbol=Symbol(name="PyExc_KeyboardInterrupt", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_LookupError", visibility=None): Data(
        symbol=Symbol(name="PyExc_LookupError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_MemoryError", visibility=None): Data(
        symbol=Symbol(name="PyExc_MemoryError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_NameError", visibility=None): Data(
        symbol=Symbol(name="PyExc_NameError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_NotImplementedError", visibility=None): Data(
        symbol=Symbol(name="PyExc_NotImplementedError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_OSError", visibility=None): Data(
        symbol=Symbol(name="PyExc_OSError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_OverflowError", visibility=None): Data(
        symbol=Symbol(name="PyExc_OverflowError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_PendingDeprecationWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_PendingDeprecationWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ReferenceError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ReferenceError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_RuntimeError", visibility=None): Data(
        symbol=Symbol(name="PyExc_RuntimeError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_RuntimeWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_RuntimeWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_StopIteration", visibility=None): Data(
        symbol=Symbol(name="PyExc_StopIteration", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SyntaxError", visibility=None): Data(
        symbol=Symbol(name="PyExc_SyntaxError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SyntaxWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_SyntaxWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SystemError", visibility=None): Data(
        symbol=Symbol(name="PyExc_SystemError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SystemExit", visibility=None): Data(
        symbol=Symbol(name="PyExc_SystemExit", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_TabError", visibility=None): Data(
        symbol=Symbol(name="PyExc_TabError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_TypeError", visibility=None): Data(
        symbol=Symbol(name="PyExc_TypeError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnboundLocalError", visibility=None): Data(
        symbol=Symbol(name="PyExc_UnboundLocalError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeDecodeError", visibility=None): Data(
        symbol=Symbol(name="PyExc_UnicodeDecodeError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeEncodeError", visibility=None): Data(
        symbol=Symbol(name="PyExc_UnicodeEncodeError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeError", visibility=None): Data(
        symbol=Symbol(name="PyExc_UnicodeError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeTranslateError", visibility=None): Data(
        symbol=Symbol(name="PyExc_UnicodeTranslateError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_UnicodeWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UserWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_UserWarning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ValueError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ValueError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_Warning", visibility=None): Data(
        symbol=Symbol(name="PyExc_Warning", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ZeroDivisionError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ZeroDivisionError", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFilter_Type", visibility=None): Data(
        symbol=Symbol(name="PyFilter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_Type", visibility=None): Data(
        symbol=Symbol(name="PyFloat_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrozenSet_Type", visibility=None): Data(
        symbol=Symbol(name="PyFrozenSet_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGetSetDescr_Type", visibility=None): Data(
        symbol=Symbol(name="PyGetSetDescr_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyListIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyListIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyListRevIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyListRevIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Type", visibility=None): Data(
        symbol=Symbol(name="PyList_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLongRangeIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyLongRangeIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_Type", visibility=None): Data(
        symbol=Symbol(name="PyLong_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMap_Type", visibility=None): Data(
        symbol=Symbol(name="PyMap_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemberDescr_Type", visibility=None): Data(
        symbol=Symbol(name="PyMemberDescr_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_Type", visibility=None): Data(
        symbol=Symbol(name="PyMemoryView_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMethodDescr_Type", visibility=None): Data(
        symbol=Symbol(name="PyMethodDescr_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_Type", visibility=None): Data(
        symbol=Symbol(name="PyModule_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_InputHook", visibility=None): Data(
        symbol=Symbol(name="PyOS_InputHook", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyProperty_Type", visibility=None): Data(
        symbol=Symbol(name="PyProperty_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyRangeIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyRangeIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyRange_Type", visibility=None): Data(
        symbol=Symbol(name="PyRange_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyReversed_Type", visibility=None): Data(
        symbol=Symbol(name="PyReversed_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySeqIter_Type", visibility=None): Data(
        symbol=Symbol(name="PySeqIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySetIter_Type", visibility=None): Data(
        symbol=Symbol(name="PySetIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Type", visibility=None): Data(
        symbol=Symbol(name="PySet_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_Type", visibility=None): Data(
        symbol=Symbol(name="PySlice_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySuper_Type", visibility=None): Data(
        symbol=Symbol(name="PySuper_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTraceBack_Type", visibility=None): Data(
        symbol=Symbol(name="PyTraceBack_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTupleIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyTupleIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_Type", visibility=None): Data(
        symbol=Symbol(name="PyTuple_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_Type", visibility=None): Data(
        symbol=Symbol(name="PyType_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeIter_Type", visibility=None): Data(
        symbol=Symbol(name="PyUnicodeIter_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Type", visibility=None): Data(
        symbol=Symbol(name="PyUnicode_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWrapperDescr_Type", visibility=None): Data(
        symbol=Symbol(name="PyWrapperDescr_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyZip_Type", visibility=None): Data(
        symbol=Symbol(name="PyZip_Type", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_FileSystemDefaultEncoding", visibility=None): Data(
        symbol=Symbol(name="Py_FileSystemDefaultEncoding", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_HasFileSystemDefaultEncoding", visibility=None): Data(
        symbol=Symbol(name="Py_HasFileSystemDefaultEncoding", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_PyWeakref_CallableProxyType", visibility=None): Data(
        symbol=Symbol(name="_PyWeakref_CallableProxyType", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyWeakref_ProxyType", visibility=None): Data(
        symbol=Symbol(name="_PyWeakref_ProxyType", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyWeakref_RefType", visibility=None): Data(
        symbol=Symbol(name="_PyWeakref_RefType", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_EllipsisObject", visibility=None): Data(
        symbol=Symbol(name="_Py_EllipsisObject", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_FalseStruct", visibility=None): Data(
        symbol=Symbol(name="_Py_FalseStruct", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_NoneStruct", visibility=None): Data(
        symbol=Symbol(name="_Py_NoneStruct", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_NotImplementedStruct", visibility=None): Data(
        symbol=Symbol(name="_Py_NotImplementedStruct", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_SwappedOp", visibility=None): Data(
        symbol=Symbol(name="_Py_SwappedOp", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_TrueStruct", visibility=None): Data(
        symbol=Symbol(name="_Py_TrueStruct", visibility=None),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyModuleDef_Type", visibility=None): Data(
        symbol=Symbol(name="PyModuleDef_Type", visibility=None),
        added=PyVersion(major=3, minor=5),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ModuleNotFoundError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ModuleNotFoundError", visibility=None),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BlockingIOError", visibility=None): Data(
        symbol=Symbol(name="PyExc_BlockingIOError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BrokenPipeError", visibility=None): Data(
        symbol=Symbol(name="PyExc_BrokenPipeError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ChildProcessError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ChildProcessError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionAbortedError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ConnectionAbortedError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ConnectionError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionRefusedError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ConnectionRefusedError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionResetError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ConnectionResetError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FileExistsError", visibility=None): Data(
        symbol=Symbol(name="PyExc_FileExistsError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FileNotFoundError", visibility=None): Data(
        symbol=Symbol(name="PyExc_FileNotFoundError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_InterruptedError", visibility=None): Data(
        symbol=Symbol(name="PyExc_InterruptedError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IsADirectoryError", visibility=None): Data(
        symbol=Symbol(name="PyExc_IsADirectoryError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_NotADirectoryError", visibility=None): Data(
        symbol=Symbol(name="PyExc_NotADirectoryError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_PermissionError", visibility=None): Data(
        symbol=Symbol(name="PyExc_PermissionError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ProcessLookupError", visibility=None): Data(
        symbol=Symbol(name="PyExc_ProcessLookupError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_RecursionError", visibility=None): Data(
        symbol=Symbol(name="PyExc_RecursionError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ResourceWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_ResourceWarning", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_StopAsyncIteration", visibility=None): Data(
        symbol=Symbol(name="PyExc_StopAsyncIteration", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_TimeoutError", visibility=None): Data(
        symbol=Symbol(name="PyExc_TimeoutError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_WindowsError", visibility=None): Data(
        symbol=Symbol(name="PyExc_WindowsError", visibility=None),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="Py_UTF8Mode", visibility=None): Data(
        symbol=Symbol(name="Py_UTF8Mode", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictRevIterItem_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictRevIterItem_Type", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictRevIterKey_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictRevIterKey_Type", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictRevIterValue_Type", visibility=None): Data(
        symbol=Symbol(name="PyDictRevIterValue_Type", visibility=None),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GenericAliasType", visibility=None): Data(
        symbol=Symbol(name="Py_GenericAliasType", visibility=None),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_FileSystemDefaultEncodeErrors", visibility=None): Data(
        symbol=Symbol(name="Py_FileSystemDefaultEncodeErrors", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_EncodingWarning", visibility=None): Data(
        symbol=Symbol(name="PyExc_EncodingWarning", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_Py_RefTotal", visibility=None): Data(
        symbol=Symbol(name="_Py_RefTotal", visibility=None),
        added=PyVersion(major=3, minor=10),
        ifdef=FeatureMacro(
            name="Py_REF_DEBUG",
            doc="when Python is compiled in debug mode (with Py_REF_DEBUG)",
            windows="maybe",
        ),
        abi_only=True,
    ),
    Symbol(name="PyStructSequence_UnnamedField", visibility=None): Data(
        symbol=Symbol(name="PyStructSequence_UnnamedField", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Version", visibility=None): Data(
        symbol=Symbol(name="Py_Version", visibility=None),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
}
_TYPEDEFS: Final[dict[str, Typedef]] = {
    "Py_uintptr_t": Typedef(name="Py_uintptr_t", added=PyVersion(major=3, minor=2)),
    "Py_intptr_t": Typedef(name="Py_intptr_t", added=PyVersion(major=3, minor=2)),
    "Py_ssize_t": Typedef(name="Py_ssize_t", added=PyVersion(major=3, minor=2)),
    "unaryfunc": Typedef(name="unaryfunc", added=PyVersion(major=3, minor=2)),
    "binaryfunc": Typedef(name="binaryfunc", added=PyVersion(major=3, minor=2)),
    "ternaryfunc": Typedef(name="ternaryfunc", added=PyVersion(major=3, minor=2)),
    "inquiry": Typedef(name="inquiry", added=PyVersion(major=3, minor=2)),
    "lenfunc": Typedef(name="lenfunc", added=PyVersion(major=3, minor=2)),
    "ssizeargfunc": Typedef(name="ssizeargfunc", added=PyVersion(major=3, minor=2)),
    "ssizessizeargfunc": Typedef(name="ssizessizeargfunc", added=PyVersion(major=3, minor=2)),
    "ssizeobjargproc": Typedef(name="ssizeobjargproc", added=PyVersion(major=3, minor=2)),
    "ssizessizeobjargproc": Typedef(name="ssizessizeobjargproc", added=PyVersion(major=3, minor=2)),
    "objobjargproc": Typedef(name="objobjargproc", added=PyVersion(major=3, minor=2)),
    "objobjproc": Typedef(name="objobjproc", added=PyVersion(major=3, minor=2)),
    "visitproc": Typedef(name="visitproc", added=PyVersion(major=3, minor=2)),
    "traverseproc": Typedef(name="traverseproc", added=PyVersion(major=3, minor=2)),
    "destructor": Typedef(name="destructor", added=PyVersion(major=3, minor=2)),
    "getattrfunc": Typedef(name="getattrfunc", added=PyVersion(major=3, minor=2)),
    "getattrofunc": Typedef(name="getattrofunc", added=PyVersion(major=3, minor=2)),
    "setattrfunc": Typedef(name="setattrfunc", added=PyVersion(major=3, minor=2)),
    "setattrofunc": Typedef(name="setattrofunc", added=PyVersion(major=3, minor=2)),
    "reprfunc": Typedef(name="reprfunc", added=PyVersion(major=3, minor=2)),
    "hashfunc": Typedef(name="hashfunc", added=PyVersion(major=3, minor=2)),
    "richcmpfunc": Typedef(name="richcmpfunc", added=PyVersion(major=3, minor=2)),
    "getiterfunc": Typedef(name="getiterfunc", added=PyVersion(major=3, minor=2)),
    "iternextfunc": Typedef(name="iternextfunc", added=PyVersion(major=3, minor=2)),
    "descrgetfunc": Typedef(name="descrgetfunc", added=PyVersion(major=3, minor=2)),
    "descrsetfunc": Typedef(name="descrsetfunc", added=PyVersion(major=3, minor=2)),
    "initproc": Typedef(name="initproc", added=PyVersion(major=3, minor=2)),
    "newfunc": Typedef(name="newfunc", added=PyVersion(major=3, minor=2)),
    "allocfunc": Typedef(name="allocfunc", added=PyVersion(major=3, minor=2)),
    "PyCFunction": Typedef(name="PyCFunction", added=PyVersion(major=3, minor=2)),
    "PyCFunctionWithKeywords": Typedef(
        name="PyCFunctionWithKeywords", added=PyVersion(major=3, minor=2)
    ),
    "PyCapsule_Destructor": Typedef(name="PyCapsule_Destructor", added=PyVersion(major=3, minor=2)),
    "getter": Typedef(name="getter", added=PyVersion(major=3, minor=2)),
    "setter": Typedef(name="setter", added=PyVersion(major=3, minor=2)),
    "PyOS_sighandler_t": Typedef(name="PyOS_sighandler_t", added=PyVersion(major=3, minor=2)),
    "PyGILState_STATE": Typedef(name="PyGILState_STATE", added=PyVersion(major=3, minor=2)),
    "Py_UCS4": Typedef(name="Py_UCS4", added=PyVersion(major=3, minor=2)),
    "vectorcallfunc": Typedef(name="vectorcallfunc", added=PyVersion(major=3, minor=12)),
    "getbufferproc": Typedef(name="getbufferproc", added=PyVersion(major=3, minor=12)),
    "releasebufferproc": Typedef(name="releasebufferproc", added=PyVersion(major=3, minor=12)),
    "PyCFunctionFast": Typedef(name="PyCFunctionFast", added=PyVersion(major=3, minor=13)),
    "PyCFunctionFastWithKeywords": Typedef(
        name="PyCFunctionFastWithKeywords", added=PyVersion(major=3, minor=13)
    ),
}
