# Generated by Django 4.1.5 on 2023-01-27 19:22

import datetime
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import literature.utils
import model_utils.fields
import sortedm2m.fields
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("taggit", "0005_auto_20220424_2025"),
    ]

    operations = [
        migrations.CreateModel(
            name="Author",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "given",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="given name"
                    ),
                ),
                (
                    "family",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="family name"
                    ),
                ),
                (
                    "ORCID",
                    models.CharField(
                        blank=True,
                        max_length=64,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^(?:\\d{4}-){3}\\d{3}[\\d,x]"
                            )
                        ],
                        verbose_name="ORCID",
                    ),
                ),
            ],
            options={
                "verbose_name": "author",
                "verbose_name_plural": "authors",
                "ordering": ["family"],
            },
        ),
        migrations.CreateModel(
            name="Collection",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                ("description", models.TextField(verbose_name="description")),
            ],
            options={
                "verbose_name": "collection",
                "verbose_name_plural": "collections",
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="Literature",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "abstract",
                    models.TextField(blank=True, null=True, verbose_name="abstract"),
                ),
                (
                    "author_str",
                    models.TextField(
                        blank=True,
                        help_text='List of authors in the format "LastName, GivenName" separated by semi-colons. E.g Smith, John; Klose, Sarah;',
                        null=True,
                        verbose_name="authors",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        help_text="General comments regarding the entry.",
                        null=True,
                        verbose_name="comment",
                    ),
                ),
                (
                    "container_title",
                    models.CharField(
                        blank=True,
                        help_text="The journal, book or other container title of the entry.",
                        max_length=512,
                        null=True,
                        verbose_name="container title",
                    ),
                ),
                (
                    "doi",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        unique=True,
                        verbose_name="DOI",
                    ),
                ),
                (
                    "institution",
                    models.CharField(
                        blank=True,
                        help_text="Name of the institution.",
                        max_length=255,
                        null=True,
                        verbose_name="institution",
                    ),
                ),
                (
                    "issn",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="ISSN"
                    ),
                ),
                (
                    "isbn",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="ISBN"
                    ),
                ),
                (
                    "issue",
                    models.IntegerField(
                        blank=True, null=True, verbose_name="issue number"
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        blank=True,
                        help_text="A human readable identifier. Whitespace and hyphens will be converted to underscores.",
                        max_length=255,
                        unique=True,
                        verbose_name="label",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        blank=True, max_length=2, null=True, verbose_name="language"
                    ),
                ),
                (
                    "month",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        choices=[
                            (1, "January"),
                            (2, "February"),
                            (3, "March"),
                            (4, "April"),
                            (5, "May"),
                            (6, "June"),
                            (7, "July"),
                            (8, "August"),
                            (9, "September"),
                            (10, "October"),
                            (11, "November"),
                            (12, "December"),
                        ],
                        help_text="The month of publication.",
                        null=True,
                        verbose_name="month",
                    ),
                ),
                (
                    "pages",
                    models.CharField(
                        blank=True,
                        help_text="Either a single digit indicating the page number or two hyphen-separated digits representing a range.",
                        max_length=32,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator("^(\\d+-{1,2}?\\d+)$")
                        ],
                        verbose_name="pages",
                    ),
                ),
                (
                    "pdf",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=literature.utils.pdf_file_renamer,
                        validators=[
                            django.core.validators.FileExtensionValidator(["pdf"])
                        ],
                        verbose_name="PDF",
                    ),
                ),
                (
                    "published",
                    models.DateField(
                        max_length=255,
                        validators=[
                            django.core.validators.MaxValueValidator(
                                datetime.date.today
                            )
                        ],
                        verbose_name="date published",
                    ),
                ),
                (
                    "publisher",
                    models.CharField(
                        blank=True,
                        help_text="Name of the publisher.",
                        max_length=255,
                        null=True,
                        verbose_name="publisher",
                    ),
                ),
                (
                    "source",
                    models.CharField(
                        blank=True,
                        default="Admin Upload",
                        help_text="The source of metadata for the entry.",
                        max_length=255,
                        verbose_name="source",
                    ),
                ),
                ("title", models.CharField(max_length=512, verbose_name="title")),
                ("type", models.CharField(max_length=255, verbose_name="entry type")),
                (
                    "url",
                    models.URLField(
                        blank=True,
                        help_text="A link to the URL resource.",
                        null=True,
                        verbose_name="URL",
                    ),
                ),
                (
                    "volume",
                    models.IntegerField(blank=True, null=True, verbose_name="volume"),
                ),
                (
                    "year",
                    models.PositiveSmallIntegerField(
                        help_text="The year of publication.",
                        validators=[
                            django.core.validators.MinValueValidator(1900),
                            django.core.validators.MaxValueValidator(
                                literature.utils.get_current_year
                            ),
                        ],
                        verbose_name="year",
                    ),
                ),
                (
                    "last_synced",
                    models.DateTimeField(
                        blank=True,
                        help_text="Last time the entry was synced with an online resource.",
                        null=True,
                        verbose_name="last synced",
                    ),
                ),
            ],
            options={
                "verbose_name": "literature",
                "verbose_name_plural": "literature",
                "ordering": ["label"],
                "default_related_name": "literature",
            },
        ),
        migrations.CreateModel(
            name="SupplementaryMaterial",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("file", models.FileField(upload_to="", verbose_name="file")),
                (
                    "literature",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="supplementary",
                        to="literature.literature",
                        verbose_name="literature",
                    ),
                ),
            ],
            options={
                "verbose_name": "supplementary material",
                "verbose_name_plural": "supplementary material",
            },
        ),
        migrations.CreateModel(
            name="LiteratureAuthor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.IntegerField()),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="position",
                        to="literature.author",
                    ),
                ),
                (
                    "literature",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="literature.literature",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="literature",
            name="authors",
            field=sortedm2m.fields.SortedManyToManyField(
                blank=True,
                help_text=None,
                related_name="works",
                sort_value_field_name="number",
                through="literature.LiteratureAuthor",
                to="literature.author",
                verbose_name="authors",
            ),
        ),
        migrations.AddField(
            model_name="literature",
            name="collections",
            field=models.ManyToManyField(
                blank=True,
                help_text="Add the entry to a collection.",
                to="literature.collection",
                verbose_name="collection",
            ),
        ),
        migrations.AddField(
            model_name="literature",
            name="keywords",
            field=taggit.managers.TaggableManager(
                blank=True,
                help_text="A list of comma-separated keywords.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="key words",
            ),
        ),
    ]
