import * as ecr from 'aws-cdk-lib/aws-ecr';
import * as iam from 'aws-cdk-lib/aws-iam';
import { LoginConfig } from './login';
/**
 * Destination information
 */
export interface DestinationConfig {
    /**
     * The URI of the destination repository to deploy to.
     */
    readonly destinationUri: string;
    /**
     * The login command and region.
     */
    readonly loginConfig: LoginConfig;
    /**
     * The tag of the deployed image.
     *
     * @default - the tag of the source
     */
    readonly destinationTag?: string;
}
/**
 * Properties needed for Source.ecr
 */
export interface EcrSourceOptions {
    /**
     * Tag of deployed image.
     *
     * @default -  tag of source
     */
    readonly tag?: string;
}
/**
 * Specifies docker image deployment destination
 *
 * Usage:
 *
 * ```ts
 * declare const repo: ecr.IRepository;
 * const destinationEcr = dockerDeploy.Destination.ecr(repository, {
 *   tag: 'tag',
 * });
 * ```
 *
 */
export declare abstract class Destination {
    /**
     * Uses an ECR repository in the same account as the stack as the destination for the image.
     */
    static ecr(repository: ecr.IRepository, options?: EcrSourceOptions): Destination;
    /**
     * Bind grants the CodeBuild role permissions to pull and push to a repository if necessary.
     * Bind should be invoked by the caller to get the DestinationConfig.
     */
    abstract bind(role: iam.IGrantable): DestinationConfig;
}
