# -*- coding: utf-8 -*-


class MongoDBObjectTypesForSearch(object):

    """Implementation of the 'MongoDB object Types for search.' model.

    MongoDB object Types for search.

    Attributes:
        mtype (Type23Enum): Specifies the MongoDB object Types for search.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype":'type'
    }

    def __init__(self,
                 mtype=None):
        """Constructor for the MongoDBObjectTypesForSearch class"""

        # Initialize members of the class
        self.mtype = mtype


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get('type')

        # Return an object of this model
        return cls(mtype)


