import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudNetworkloadbalancerForwardingruleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#datacenter_id DataIonoscloudNetworkloadbalancerForwardingrule#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#id DataIonoscloudNetworkloadbalancerForwardingrule#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#name DataIonoscloudNetworkloadbalancerForwardingrule#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#networkloadbalancer_id DataIonoscloudNetworkloadbalancerForwardingrule#networkloadbalancer_id}
    */
    readonly networkloadbalancerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#timeouts DataIonoscloudNetworkloadbalancerForwardingrule#timeouts}
    */
    readonly timeouts?: DataIonoscloudNetworkloadbalancerForwardingruleTimeouts;
}
export interface DataIonoscloudNetworkloadbalancerForwardingruleHealthCheck {
}
export declare function dataIonoscloudNetworkloadbalancerForwardingruleHealthCheckToTerraform(struct?: DataIonoscloudNetworkloadbalancerForwardingruleHealthCheck): any;
export declare class DataIonoscloudNetworkloadbalancerForwardingruleHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudNetworkloadbalancerForwardingruleHealthCheck | undefined;
    set internalValue(value: DataIonoscloudNetworkloadbalancerForwardingruleHealthCheck | undefined);
    get clientTimeout(): number;
    get connectTimeout(): number;
    get retries(): number;
    get targetTimeout(): number;
}
export declare class DataIonoscloudNetworkloadbalancerForwardingruleHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudNetworkloadbalancerForwardingruleHealthCheckOutputReference;
}
export interface DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheck {
}
export declare function dataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheckToTerraform(struct?: DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheck): any;
export declare class DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheck | undefined;
    set internalValue(value: DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheck | undefined);
    get check(): cdktf.IResolvable;
    get checkInterval(): number;
    get maintenance(): cdktf.IResolvable;
}
export declare class DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheckOutputReference;
}
export interface DataIonoscloudNetworkloadbalancerForwardingruleTargets {
}
export declare function dataIonoscloudNetworkloadbalancerForwardingruleTargetsToTerraform(struct?: DataIonoscloudNetworkloadbalancerForwardingruleTargets): any;
export declare class DataIonoscloudNetworkloadbalancerForwardingruleTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudNetworkloadbalancerForwardingruleTargets | undefined;
    set internalValue(value: DataIonoscloudNetworkloadbalancerForwardingruleTargets | undefined);
    private _healthCheck;
    get healthCheck(): DataIonoscloudNetworkloadbalancerForwardingruleTargetsHealthCheckList;
    get ip(): string;
    get port(): number;
    get weight(): number;
}
export declare class DataIonoscloudNetworkloadbalancerForwardingruleTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudNetworkloadbalancerForwardingruleTargetsOutputReference;
}
export interface DataIonoscloudNetworkloadbalancerForwardingruleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#create DataIonoscloudNetworkloadbalancerForwardingrule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#default DataIonoscloudNetworkloadbalancerForwardingrule#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#delete DataIonoscloudNetworkloadbalancerForwardingrule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule#update DataIonoscloudNetworkloadbalancerForwardingrule#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudNetworkloadbalancerForwardingruleTimeoutsToTerraform(struct?: DataIonoscloudNetworkloadbalancerForwardingruleTimeoutsOutputReference | DataIonoscloudNetworkloadbalancerForwardingruleTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudNetworkloadbalancerForwardingruleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudNetworkloadbalancerForwardingruleTimeouts | undefined;
    set internalValue(value: DataIonoscloudNetworkloadbalancerForwardingruleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule ionoscloud_networkloadbalancer_forwardingrule}
*/
export declare class DataIonoscloudNetworkloadbalancerForwardingrule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_networkloadbalancer_forwardingrule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/networkloadbalancer_forwardingrule ionoscloud_networkloadbalancer_forwardingrule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudNetworkloadbalancerForwardingruleConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudNetworkloadbalancerForwardingruleConfig);
    get algorithm(): string;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _healthCheck;
    get healthCheck(): DataIonoscloudNetworkloadbalancerForwardingruleHealthCheckList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get listenerIp(): string;
    get listenerPort(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkloadbalancerId?;
    get networkloadbalancerId(): string;
    set networkloadbalancerId(value: string);
    get networkloadbalancerIdInput(): string | undefined;
    get protocol(): string;
    private _targets;
    get targets(): DataIonoscloudNetworkloadbalancerForwardingruleTargetsList;
    private _timeouts;
    get timeouts(): DataIonoscloudNetworkloadbalancerForwardingruleTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudNetworkloadbalancerForwardingruleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudNetworkloadbalancerForwardingruleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
