""" Hl7.

Do not edit this file by hand.
This is generated by parsing api.html service doc.
"""
from ambra_sdk.exceptions.service import DuplicateOrderBy
from ambra_sdk.exceptions.service import FilterNotFound
from ambra_sdk.exceptions.service import InvalidCondition
from ambra_sdk.exceptions.service import InvalidField
from ambra_sdk.exceptions.service import InvalidHl7
from ambra_sdk.exceptions.service import InvalidMessage
from ambra_sdk.exceptions.service import InvalidReplacement
from ambra_sdk.exceptions.service import InvalidSortField
from ambra_sdk.exceptions.service import InvalidSortOrder
from ambra_sdk.exceptions.service import MissingFields
from ambra_sdk.exceptions.service import NotConfigured
from ambra_sdk.exceptions.service import NotFound
from ambra_sdk.exceptions.service import NotList
from ambra_sdk.exceptions.service import NotPermitted
from ambra_sdk.service.query import QueryO
from ambra_sdk.service.query import QueryOPSF

class Hl7:
    """Hl7."""

    def __init__(self, api):
        self._api = api

    
    def list(
        self,
        account_id,
    ):
        """List.
        :param account_id: uuid of the account
        """
        request_data = {
           'account_id': account_id,
        }
	
        errors_mapping = {}
        errors_mapping[('FILTER_NOT_FOUND', None)] = FilterNotFound('The filter can not be found. The error_subtype will hold the filter UUID')
        errors_mapping[('INVALID_CONDITION', None)] = InvalidCondition('The condition is not support. The error_subtype will hold the filter expression this applies to')
        errors_mapping[('INVALID_FIELD', None)] = InvalidField('The field is not valid for this object. The error_subtype will hold the filter expression this applies to')
        errors_mapping[('INVALID_SORT_FIELD', None)] = InvalidSortField('The field is not valid for this object. The error_subtype will hold the field name this applies to')
        errors_mapping[('INVALID_SORT_ORDER', None)] = InvalidSortOrder('The sort order for the field is invalid. The error_subtype will hold the field name this applies to')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The account_id can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/list',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'messages'
        return QueryOPSF(**query_data)
    
    def add(
        self,
        message,
        serial_no,
        uuid,
        accession_number=None,
    ):
        """Add.
        :param message: The HL7 message
        :param serial_no: The serial number of the node
        :param uuid: The node id
        :param accession_number: Use this accession number instead of the accession number in the HL7 message (optional)
        """
        request_data = {
           'accession_number': accession_number,
           'message': message,
           'serial_no': serial_no,
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('INVALID_MESSAGE', None)] = InvalidMessage('The message could not parsed as a HL7 message')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The node can not be found')
        query_data = {
            'api': self._api,
            'url': '/hl7/add',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': False,
        }
        return QueryO(**query_data)
    
    def get(
        self,
        raw,
        uuid,
        node_id=None,
        phi_namespace=None,
        serial_no=None,
        storage_namespace=None,
        study_id=None,
        study_uid=None,
    ):
        """Get.
        :param raw: Flag to return the raw HL7 message as well
        :param uuid: The hl7 uuid
        :param node_id: node_id
        :param phi_namespace: phi_namespace
        :param serial_no: serial_no
        :param storage_namespace: storage_namespace
        :param study_id: study_id
        :param study_uid: study_uid

        Notes:
        (sid OR node_id AND serial_no) - Either the sid or the node uuid and serial number
        (study_id OR study_uid AND storage_namespace AND phi_namespace) - The study uuid or the storage triplet (optional)
        """
        request_data = {
           'node_id': node_id,
           'phi_namespace': phi_namespace,
           'raw': raw,
           'serial_no': serial_no,
           'storage_namespace': storage_namespace,
           'study_id': study_id,
           'study_uid': study_uid,
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The hl7 can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to access this hl7')
        query_data = {
            'api': self._api,
            'url': '/hl7/get',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def delete(
        self,
        uuid,
    ):
        """Delete.
        :param uuid: The hl7 uuid
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The hl7 can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to delete this hl7')
        query_data = {
            'api': self._api,
            'url': '/hl7/delete',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def study_report(
        self,
        study_id,
    ):
        """Study report.
        :param study_id: The study uuid
        """
        request_data = {
           'study_id': study_id,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The study can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to view this')
        query_data = {
            'api': self._api,
            'url': '/hl7/study/report',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def extract_report(
        self,
        uuid,
    ):
        """Extract report.
        :param uuid: The HL7 uuid
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_CONFIGURED', None)] = NotConfigured('The node setting report_from_hl7 is not configured')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The HL7 can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to access this HL7 message')
        query_data = {
            'api': self._api,
            'url': '/hl7/extract/report',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def template_list(
        self,
        account_id,
    ):
        """Template list.
        :param account_id: The account uuid
        """
        request_data = {
           'account_id': account_id,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The account can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to view this list')
        query_data = {
            'api': self._api,
            'url': '/hl7/template/list',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def template_add(
        self,
        account_id,
        body,
        name,
    ):
        """Template add.
        :param account_id: The account uuid
        :param body: The HL7 message with replacement expressions
        :param name: Name of the template
        """
        request_data = {
           'account_id': account_id,
           'body': body,
           'name': name,
        }
	
        errors_mapping = {}
        errors_mapping[('INVALID_HL7', None)] = InvalidHl7('The body is not a valid HL7 message')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The account can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/template/add',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def template_set(
        self,
        body,
        name,
        uuid,
    ):
        """Template set.
        :param body: The HL7 message with replacement expressions
        :param name: Name of the template
        :param uuid: The template id
        """
        request_data = {
           'body': body,
           'name': name,
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('INVALID_HL7', None)] = InvalidHl7('The body is not a valid HL7 message')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The template can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/template/set',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def template_get(
        self,
        uuid,
    ):
        """Template get.
        :param uuid: The template id
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The template can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/template/get',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def template_render(
        self,
        hex,
        hl7_id,
        study_id,
        text,
        uuid,
    ):
        """Template render.
        :param hex: Flag if you want a hexdump of the text returned rather than the JSON
        :param hl7_id: Optional hl7 message
        :param study_id: The study id
        :param text: Flag if you want the text returned rather than the JSON
        :param uuid: The template id
        """
        request_data = {
           'hex': hex,
           'hl7_id': hl7_id,
           'study_id': study_id,
           'text': text,
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The template or study can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/template/render',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def template_delete(
        self,
        uuid,
    ):
        """Template delete.
        :param uuid: The template id
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The template can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/template/delete',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def transform_list(
        self,
        account_id,
    ):
        """Transform list.
        :param account_id: The account uuid
        """
        request_data = {
           'account_id': account_id,
        }
	
        errors_mapping = {}
        errors_mapping[('FILTER_NOT_FOUND', None)] = FilterNotFound('The filter can not be found. The error_subtype will hold the filter UUID')
        errors_mapping[('INVALID_CONDITION', None)] = InvalidCondition('The condition is not support. The error_subtype will hold the filter expression this applies to')
        errors_mapping[('INVALID_FIELD', None)] = InvalidField('The field is not valid for this object. The error_subtype will hold the filter expression this applies to')
        errors_mapping[('INVALID_SORT_FIELD', None)] = InvalidSortField('The field is not valid for this object. The error_subtype will hold the field name this applies to')
        errors_mapping[('INVALID_SORT_ORDER', None)] = InvalidSortOrder('The sort order for the field is invalid. The error_subtype will hold the field name this applies to')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The account can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to view this list')
        query_data = {
            'api': self._api,
            'url': '/hl7/transform/list',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'transforms'
        return QueryOPSF(**query_data)
    
    def transform_add(
        self,
        account_id,
        conditions,
        name,
        order_by,
        replacements,
    ):
        """Transform add.
        :param account_id: The account uuid
        :param conditions: A JSON array of the transform conditions
        :param name: Name of the transform
        :param order_by: A numeric ordering value. Transformations are run in this order from lowest to highest
        :param replacements: A JSON array of the transform replacements
        """
        request_data = {
           'account_id': account_id,
           'conditions': conditions,
           'name': name,
           'order_by': order_by,
           'replacements': replacements,
        }
	
        errors_mapping = {}
        errors_mapping[('DUPLICATE_ORDER_BY', None)] = DuplicateOrderBy('The order_by value is used by another transform')
        errors_mapping[('INVALID_CONDITION', None)] = InvalidCondition('An invalid condition was passed. The error_subtype holds the details on why it is invalid')
        errors_mapping[('INVALID_REPLACEMENT', None)] = InvalidReplacement('An invalid replacement was passed. The error_subtype holds the details on why it is invalid')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The account can not be found')
        errors_mapping[('NOT_LIST', None)] = NotList('The field is not a JSON array. The error_subtype holds the name of the field')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/transform/add',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def transform_set(
        self,
        conditions,
        name,
        order_by,
        replacements,
        uuid,
    ):
        """Transform set.
        :param conditions: A JSON array of the transform conditions
        :param name: Name of the transform
        :param order_by: A numeric ordering value. Transformations are run in this order from lowest to highest
        :param replacements: A JSON array of the transform replacements
        :param uuid: The transform id
        """
        request_data = {
           'conditions': conditions,
           'name': name,
           'order_by': order_by,
           'replacements': replacements,
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('DUPLICATE_ORDER_BY', None)] = DuplicateOrderBy('The order_by value is used by another transform')
        errors_mapping[('INVALID_CONDITION', None)] = InvalidCondition('An invalid condition was passed. The error_subtype holds the details on why it is invalid')
        errors_mapping[('INVALID_REPLACEMENT', None)] = InvalidReplacement('An invalid replacement was passed. The error_subtype holds the details on why it is invalid')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The account can not be found')
        errors_mapping[('NOT_LIST', None)] = NotList('The field is not a JSON array. The error_subtype holds the name of the field')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/transform/set',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def transform_get(
        self,
        uuid,
    ):
        """Transform get.
        :param uuid: The transform id
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The transform can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/transform/get',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def transform_delete(
        self,
        uuid,
    ):
        """Transform delete.
        :param uuid: The transform id
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_FOUND', None)] = NotFound('The transform can not be found')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/transform/delete',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def transform_test(
        self,
        hl7,
    ):
        """Transform test.
        :param hl7: HL7 message to run the transformations on
        """
        request_data = {
           'hl7': hl7,
        }
	
        errors_mapping = {}
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping[('NOT_PERMITTED', None)] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/hl7/transform/test',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def parse_fields(
        self,
        message,
        fields=None,
    ):
        """Parse fields.
        :param message: HL7 message to parse
        :param fields: Comma delimited list of the field to return. Use the notation specified in /hl7/transform/add (optional)
        """
        request_data = {
           'fields': fields,
           'message': message,
        }
	
        errors_mapping = {}
        errors_mapping[('INVALID_MESSAGE', None)] = InvalidMessage('The message could not parsed as a HL7 message')
        errors_mapping[('MISSING_FIELDS', None)] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        query_data = {
            'api': self._api,
            'url': '/hl7/parse/fields',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': False,
        }
        return QueryO(**query_data)
    