<p align='center'>
<img src='https://github.com/hdmamin/jabberwocky/raw/347e1514769264219393abf8a62b1a808cb70421/data/icons/icon.png' height='100'>
<h1 align='center'>Jabberwocky</h1>
</p>


Video demo: https://user-images.githubusercontent.com/40480855/132139847-0d0014b9-022e-4684-80bf-d46031ca4763.mp4
<p></p>

This was not really designed to be used as a standalone library - it was mostly used as a convenient way to structure and import code in other parts of the [project](https://github.com/hdmamin/jabberwocky). Some components may be reusable for other projects combining GPT-3 with audio, however.

# Project Description

This is the core library powering a GUI that provides an audio interface to GPT-3. My main goal was to provide a convenient way to interact with various experts or public figures: imagine discussing physics with Einstein or hip hop with Kanye (or hip hop with Einstein? 🤔). I often find writing and speaking to be wildly different experiences and I imagined the same would be true when interacting with GPT-3. This turned out to be partially true - the default Mac text-to-speech functionality I'm using here is certainly not as lifelike as I'd like. Perhaps more powerful audio generation methods will pop up in a future release...

We also provide Task Mode containing built-in prompts for a number of sample tasks:

- Summarization
- Explain like I'm 5
- Translation
- How To (step by step instructions for performing everyday tasks)
- Writing Style Analysis
- Explain machine learning concepts in simple language
- Generate ML paper abstracts
- MMA Fight Analysis and Prediction

## Getting Started

1. Clone the repo.

```
git clone https://github.com/hdmamin/jabberwocky.git
```

2. Install the necessary packages. I recommend using a virtual environment of some kind (virtualenv, conda, etc). If you're not using Mac OS, you could try installing portaudio with whatever package manager you're using, but app behavior on other systems is unknown.

```
brew install portaudio
pip install -r requirements.txt
python -m nltk.downloader punkt
```

If you have `make` installed you can simply use the command:

```
make install
```

3. Add your openai API key somewhere the program can access it. There are two ways to do this:

```
echo your_openai_api_key > ~/.openai
```

or

```
export OPENAI_API_KEY=your_openai_api_key
```

(Make sure to use your actual key, not the literal text `your_openai_api_key`.)

4. Run the app.

```
python gui/main.py
```

Or with `make`:

```
make run
```

## Usage

### Conversation Mode

In conversation mode, you can chat with a number of pre-defined personas or add new ones. New personas can be autogenerated or defined manually. 

![](https://github.com/hdmamin/jabberwocky/raw/5f0f7665c73adf48409177992a87aa2107263efb/data/clips/demo/add_persona.gif)

See `data/conversation_personas` for examples of autogenerated prompts. You can likely achieve better results using custom prompts though.

Conversation mode only supports spoken input, though you can edit flawed transcriptions manually. Querying GPT-3 with nonsensical or ungrammatical text will negatively affect response quality.

### Task Mode

In task mode, you can ask GPT-3 to perform a number pre-defined tasks. Written and spoken input are both supported. By default, GPT-3's response is both typed out and read aloud.

![](https://github.com/hdmamin/jabberwocky/raw/c48600f88d8127911c96de138ce09f6ef97377eb/data/clips/demo/punctuation.gif)

Transcripts of responses from a small subset of non-conversation tasks can be found in the `data/completions` directory. You can also save your own completions while using the app.

### Usage Notes

The first time you speak, the speech transcription back end will take a few seconds to calibrate to the level of ambient noise in your environment. You will know it's ready for transcription when you see a "Listening..." message appear below the Record button. Calibration only occurs once to save time.

### Hotkeys

**CTRL + SHIFT**: Start recording audio (same as pressing the "Record" button).  
**CTRL + a**: Get GPT-3's response to whatever input you've recorded (same as pressing the "Get Response" button).

### Project Members
* Harrison Mamin

### Repo Structure

```
jabberwocky/
├── data         # Raw and processed data. Some files are excluded from github but the ones needed to run the app are there.
├── notes        # Miscellaneous notes from the development process stored as raw text files.
├── notebooks    # Jupyter notebooks for experimentation and exploratory analysis.
├── reports      # Markdown reports (performance reports, blog posts, etc.)
├── gui          # GUI scripts. The main script should be run from the project root directory. 
└── lib          # Python package. Code can be imported in analysis notebooks, py scripts, etc.
```

---
Start of auto-generated file data.<br/>Last updated: 2022-07-24 14:12:52

<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th>File</th>
      <th>Summary</th>
      <th>Line Count</th>
      <th>Last Modified</th>
      <th>Size</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>__init__.py</td>
      <td>_</td>
      <td>1</td>
      <td>2022-07-23 20:30:48</td>
      <td>22.00 b</td>
    </tr>
    <tr>
      <td>cli.py</td>
      <td>At the moment, the only useful part of this is the `update_prompt_readme`<br/>command which updates the readme in data/prompts to make it easier to review<br/>what prompts are currently available.<br/><br/>The chat functionality was a brief experiment with an old version of<br/>Jabberwocky and no longer reflects the current API. I'm keeping it around for<br/>future reference since I'm still interested in combining prompt_toolkit with<br/>jabberwocky and it may be useful to see my old thoughts on implementation<br/>(or at the very least, serve as a sort of API reference about the<br/>prompt_toolkit features I care about).</td>
      <td>108</td>
      <td>2022-06-25 11:08:06</td>
      <td>3.71 kb</td>
    </tr>
    <tr>
      <td>config.py</td>
      <td>Define constants used throughout the project.</td>
      <td>72</td>
      <td>2022-07-07 20:05:07</td>
      <td>2.49 kb</td>
    </tr>
    <tr>
      <td>core.py</td>
      <td>Core functionality that ties together multiple APIs.</td>
      <td>612</td>
      <td>2022-04-22 21:46:52</td>
      <td>24.36 kb</td>
    </tr>
    <tr>
      <td>external_data.py</td>
      <td>Functionality to fetch and work with YouTube transcripts and Wikipedia data.</td>
      <td>426</td>
      <td>2022-07-14 20:35:09</td>
      <td>15.56 kb</td>
    </tr>
    <tr>
      <td>openai_utils.py</td>
      <td>Utility functions for interacting with the gpt3 api.<br/><br/>A note on query functions:<br/>There are a number of different services (both paid and free) that provide<br/>access to GPT-like models. GPTBackend.query() provides a convenient interface<br/>to them by calling different query functions under the hood. These query<br/>functions are all defined in this module and have names starting with<br/>'query_gpt'. There are a number of steps to defining a new query function:<br/><br/>1. Use the `mark` decorator to set "batch_support" to either True or False.<br/>True means you can pass in a list of prompts, False means the prompt must be a<br/>single string. GPTBackend will support batching either way, but it needs to<br/>know whether each query function supports this natively in order to determine<br/>how to do this.<br/>2. The first parameter should be 'prompt' with no default. The other parameters<br/>should have defaults, but keep in mind many of these will be ignored when<br/>called by GPTBackend.query - the latter has its own defaults which are passed<br/>in as kwargs. Speaking of which...<br/>3. It must accept kwargs.<br/>4. If it supports multiple completions, include a parameter "n" with a default<br/>value of 1 in the signature. GPTBackend.query will support it either way, but<br/>again it needs to know how to achieve this.<br/>5. If multiple engines are available through this backend, update<br/>jabberwocky.config.C.backend_engines, using the other examples as guidance. In<br/>addition, in this scenario we recommend retrieving the engine name explicitly<br/>as query_gpt_huggingface does:<br/>```engine = GPTBackend.engine(engine, backend='huggingface')```<br/>rather than simply calling ```GPTBackend.engine(engine)```.<br/>6. We recommend popping off kwargs that you actually do want to use and then<br/>providing a warning so the user can see the remaining unused kwargs if there<br/>are any.<br/>7. The fuction should either return a (str, dict-like) tuple or<br/>(list[str], list[dict-like]). Use the latter if batch_support is True and<br/>multiple completions per prompt are supported (i.e. n is in its parameters).<br/>Technically I suppose there could be a backend that supported 1 but not the<br/>other, but I haven't seen it yet so I'll figure that case out if/when needed.<br/>8. When done, update some or all of the following GPTBackend class attributes.<br/>- name2base<br/>- name2func<br/>- skip_trunc<br/>Use the comments and examples in the class as guidance.</td>
      <td>3090</td>
      <td>2022-07-19 19:43:49</td>
      <td>130.72 kb</td>
    </tr>
    <tr>
      <td>speech.py</td>
      <td>Module to help us interact with mac's speech command. This lets the GUI read<br/>responses out loud.</td>
      <td>117</td>
      <td>2021-08-20 21:05:11</td>
      <td>4.16 kb</td>
    </tr>
    <tr>
      <td>streaming.py</td>
      <td>Functionality to support streaming gpt responses, both from backends that<br/>natively support it like openai and those that don't. This handles things like<br/>updating prompt_index in each streamed response dict so we can more easily tell<br/>which prompt a token belongs to, truncating before stop words for backends that<br/>don't (only openai supports this natively), and updating finish_reason when<br/>we find stop words.<br/><br/>Note: if adding a streaming function for a new backend, make sure to register<br/>it so it ends up in BACKEND2STREAMER (see _stream_openai_generator for an<br/>example). Each function must accept a first param which is the result of<br/>calling<br/>GPT.query(prompt, stream=True)<br/>while using the desired backend. It must also accept **kwargs. Be careful when<br/>changing param names - they must match the stream_response() call in<br/>jabberwocky.openai_utils.GPTBackend._query().</td>
      <td>575</td>
      <td>2022-05-09 20:53:51</td>
      <td>23.75 kb</td>
    </tr>
    <tr>
      <td>utils.py</td>
      <td>General purpose utilities.</td>
      <td>699</td>
      <td>2022-07-19 18:57:35</td>
      <td>23.36 kb</td>
    </tr>
  </tbody>
</table>
<br/>End of auto-generated file data. Do not add anything below this.
