import * as lambda from '@aws-cdk/aws-lambda';
import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Properties for InvokeFunction
 */
export interface InvokeFunctionProps {
    /**
     * The JSON that you want to provide to your Lambda function as input.
     *
     * This parameter is named as payload to keep consistent with RunLambdaTask class.
     *
     * @default - The JSON data indicated by the task's InputPath is used as payload
     */
    readonly payload?: {
        [key: string]: any;
    };
}
/**
 * A Step Functions Task to invoke a Lambda function.
 *
 * The Lambda function Arn is defined as Resource in the state machine definition.
 *
 * OUTPUT: the output of this task is the return value of the Lambda Function.
 */
export declare class InvokeFunction implements sfn.IStepFunctionsTask {
    private readonly lambdaFunction;
    private readonly props;
    constructor(lambdaFunction: lambda.IFunction, props?: InvokeFunctionProps);
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
}
